/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.ExceptionList;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.Rescue;
import com.xruby.compiler.codedom.Visitable;
import java.util.ArrayList;

public class BodyStatement
implements Visitable {
    private final CompoundStatement compoundStatement_;
    private ArrayList<Rescue> rescues_ = new ArrayList();
    private CompoundStatement else_ = null;
    private CompoundStatement ensure_ = null;

    public BodyStatement(CompoundStatement compoundStatement) {
        this.compoundStatement_ = compoundStatement;
    }

    public int size() {
        return this.compoundStatement_.size();
    }

    boolean lastStatementHasReturnValue() {
        return this.compoundStatement_.lastStatementHasReturnValue();
    }

    public void addRescue(ExceptionList el, CompoundStatement compoundStatement) {
        if (null == compoundStatement) {
            compoundStatement = new CompoundStatement();
            compoundStatement.addStatement(new ExpressionStatement(new NilExpression()));
        }
        this.rescues_.add(new Rescue(el, compoundStatement));
    }

    public void addElse(CompoundStatement compoundStatement) {
        if (null == compoundStatement) {
            compoundStatement = new CompoundStatement();
            compoundStatement.addStatement(new ExpressionStatement(new NilExpression()));
        }
        this.else_ = compoundStatement;
    }

    public void addEnsure(CompoundStatement compoundStatement) {
        if (null == compoundStatement) {
            compoundStatement = new CompoundStatement();
            compoundStatement.addStatement(new ExpressionStatement(new NilExpression()));
        }
        this.ensure_ = compoundStatement;
    }

    private boolean needCatch() {
        return !this.rescues_.isEmpty() || null != this.ensure_;
    }

    private void acceptNoBody(CodeVisitor visitor) {
        if (null != this.else_) {
            this.else_.accept(visitor);
        }
        if (null != this.ensure_) {
            if (null != this.else_) {
                visitor.visitTerminal();
            }
            this.ensure_.accept(visitor);
        }
        if (null == this.else_ && null == this.ensure_) {
            visitor.visitNilExpression();
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (null == this.compoundStatement_) {
            this.acceptNoBody(visitor);
            return;
        }
        if (!this.needCatch()) {
            this.compoundStatement_.accept(visitor);
            return;
        }
        this.compoundStatement_.ensureVariablesAreInitialized(visitor);
        ArrayList<Block> pulled_blocks = new ArrayList<Block>();
        this.compoundStatement_.pullBlock(pulled_blocks);
        for (Block block : pulled_blocks) {
            block.acceptAsPulled(visitor);
        }
        Object begin_label = visitor.visitBodyBegin(null != this.ensure_);
        this.compoundStatement_.accept(visitor);
        Object after_label = visitor.visitBodyAfter();
        if (null != this.else_) {
            visitor.visitTerminal();
            this.else_.accept(visitor);
        }
        if (null != this.ensure_) {
            visitor.visitEnsure(-1);
        }
        Object end_label = visitor.visitPrepareEnsure();
        int exception_var = visitor.visitRescueBegin(begin_label, after_label);
        for (Rescue rescue : this.rescues_) {
            rescue.accept(visitor, end_label, exception_var, null != this.ensure_);
        }
        if (null != this.ensure_) {
            visitor.visitEnsure(exception_var);
            int var = visitor.visitEnsureBodyBegin();
            this.ensure_.accept(visitor);
            visitor.visitEnsureBodyEnd(var);
        }
        if (!this.rescues_.isEmpty()) {
            visitor.visitRescueEnd(exception_var, null != this.ensure_);
        }
        visitor.visitBodyEnd(end_label);
    }

    public int getLastLine() {
        int lastLine = this.compoundStatement_.getLastLine();
        if (this.else_ != null && this.else_.getLastLine() > lastLine) {
            lastLine = this.else_.getLastLine();
        }
        if (this.ensure_ != null && this.ensure_.getLastLine() > lastLine) {
            lastLine = this.ensure_.getLastLine();
        }
        for (Rescue rescue : this.rescues_) {
            if (rescue.getLastLine() <= lastLine) continue;
            lastLine = rescue.getLastLine();
        }
        return lastLine;
    }

    void pullBlock(ArrayList<Block> result) {
        if (null != this.compoundStatement_) {
            this.compoundStatement_.pullBlock(result);
        }
    }

    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        if (null != this.compoundStatement_) {
            this.compoundStatement_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

