/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.When;
import java.util.ArrayList;

public class CaseExpression
extends Expression {
    private final Expression condition_;
    private ArrayList<When> whens_ = new ArrayList();
    private CompoundStatement else_body_;

    public CaseExpression(Expression condition) {
        this.condition_ = condition;
    }

    public void addWhen(When when) {
        this.whens_.add(when);
    }

    public void addElse(CompoundStatement body) {
        this.else_body_ = body;
    }

    private void ensureElseBodyIsNotEmpty() {
        if (null == this.else_body_) {
            this.else_body_ = new CompoundStatement();
            this.else_body_.addStatement(new ExpressionStatement(new NilExpression()));
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.ensureElseBodyIsNotEmpty();
        for (When when : this.whens_) {
            when.ensureVariablesAreInitialized(visitor);
        }
        this.else_body_.ensureVariablesAreInitialized(visitor);
        ArrayList<Block> pulled_blocks = new ArrayList<Block>();
        for (When when : this.whens_) {
            when.pullBlock(pulled_blocks);
        }
        this.else_body_.pullBlock(pulled_blocks);
        for (Block block : pulled_blocks) {
            block.acceptAsPulled(visitor);
        }
        if (null == this.condition_) {
            visitor.visitTrueExpression();
        } else {
            this.condition_.accept(visitor);
        }
        Object var = visitor.visitAfterCaseCondition();
        Object end_label = null;
        for (When when : this.whens_) {
            end_label = when.accept(visitor, var, end_label, null == this.condition_);
        }
        this.else_body_.accept(visitor);
        visitor.visitAfterWhenBody(null, end_label);
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        if (null != this.condition_) {
            this.condition_.pullBlock(result);
        }
        for (When when : this.whens_) {
            when.pullBlock(result);
        }
        if (null != this.else_body_) {
            this.else_body_.pullBlock(result);
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        if (null != this.condition_) {
            this.condition_.getNewlyAssignedVariables(symboltable, result);
        }
        for (When when : this.whens_) {
            when.getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.else_body_) {
            this.else_body_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

