/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.AssignmentOperatorExpression;
import com.xruby.compiler.codedom.BEGINBlock;
import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.BreakExpression;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.ENDBlock;
import com.xruby.compiler.codedom.ExceptionHandlingExpression;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.MultipleAssignmentStatement;
import com.xruby.compiler.codedom.NextExpression;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.RedoExpression;
import com.xruby.compiler.codedom.ReturnExpression;
import com.xruby.compiler.codedom.Statement;
import com.xruby.compiler.codedom.Visitable;
import java.util.ArrayList;
import java.util.List;

public class CompoundStatement
implements Visitable {
    protected List<Statement> statements_ = new ArrayList<Statement>();
    private List<BEGINBlock> beginblocks_ = null;
    private List<ENDBlock> endblocks_ = null;
    private int lastLine = 0;

    public void addStatement(Statement statement) {
        if (null != statement) {
            if (statement instanceof ExpressionStatement) {
                Expression expression = ((ExpressionStatement)statement).getExpression();
                if (!expression.willNotBeExecuted()) {
                    this.statements_.add(statement);
                }
                if (expression.shouldlabelNewLine() && expression.getPosition() > 0) {
                    this.lastLine = expression.getPosition();
                }
            } else if (statement instanceof BEGINBlock) {
                this.addBeginBlock((BEGINBlock)statement);
            } else if (statement instanceof ENDBlock) {
                this.addEndBlock((ENDBlock)statement);
            } else {
                this.statements_.add(statement);
            }
        }
    }

    private void addBeginBlock(BEGINBlock block) {
        if (this.beginblocks_ == null) {
            this.beginblocks_ = new ArrayList<BEGINBlock>();
        }
        this.beginblocks_.add(block);
    }

    private void addEndBlock(ENDBlock block) {
        if (this.endblocks_ == null) {
            this.endblocks_ = new ArrayList<ENDBlock>();
        }
        this.endblocks_.add(0, block);
    }

    int size() {
        return this.statements_.size();
    }

    boolean isSingleBeginEnd() {
        return this.statements_.size() == 1 && this.statements_.get(0) instanceof ExpressionStatement && ((ExpressionStatement)this.statements_.get(0)).getExpression() instanceof ExceptionHandlingExpression;
    }

    public int getLastLine() {
        return this.lastLine;
    }

    boolean lastStatementHasReturnValue() {
        if (this.statements_.isEmpty()) {
            return false;
        }
        if (this.statements_.get(this.statements_.size() - 1) instanceof ExpressionStatement) {
            ExpressionStatement e = (ExpressionStatement)this.statements_.get(this.statements_.size() - 1);
            return !(e.getExpression() instanceof ReturnExpression) && !(e.getExpression() instanceof BreakExpression) && !(e.getExpression() instanceof NextExpression) && !(e.getExpression() instanceof RedoExpression);
        }
        return this.statements_.get(this.statements_.size() - 1) instanceof MultipleAssignmentStatement;
    }

    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        for (Statement s : this.statements_) {
            s.getNewlyAssignedVariables(symboltable, result);
        }
    }

    void pullBlock(ArrayList<Block> result) {
        for (Statement s : this.statements_) {
            s.pullBlock(result);
        }
    }

    void ensureVariablesAreInitialized(CodeVisitor visitor) {
        ArrayList<String> vars = new ArrayList<String>();
        this.getNewlyAssignedVariables(visitor, vars);
        if (vars.isEmpty()) {
            return;
        }
        CompoundStatement comp = new CompoundStatement();
        for (String var : vars) {
            try {
                comp.addStatement(new ExpressionStatement(new AssignmentOperatorExpression(new LocalVariableExpression(var, false), new NilExpression())));
            }
            catch (RecognitionException e) {
                throw new Error(e);
            }
        }
        comp.accept(visitor);
        visitor.visitTerminal();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.beginblocks_ != null) {
            this.statements_.addAll(0, this.beginblocks_);
        }
        if (this.endblocks_ != null) {
            this.statements_.addAll(this.endblocks_);
        }
        int i = 0;
        for (Statement statement : this.statements_) {
            statement.accept(visitor);
            if (!(statement instanceof ExpressionStatement) && !(statement instanceof MultipleAssignmentStatement) && !(statement instanceof BEGINBlock) && !(statement instanceof ENDBlock) || ++i == this.statements_.size()) continue;
            visitor.visitTerminal();
        }
    }
}

