/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.BinaryOperatorExpression;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Colon2Expression;
import com.xruby.compiler.codedom.CurrentNamespaceConstantExpression;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.FalseExpression;
import com.xruby.compiler.codedom.GlobalVariableExpression;
import com.xruby.compiler.codedom.InstanceVariableExpression;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.MethodCallArguments;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.SuperExpression;
import com.xruby.compiler.codedom.TrueExpression;
import com.xruby.compiler.codedom.YieldExpression;

public class DefinedExpression
extends Expression {
    private Expression expression_;

    public DefinedExpression(MethodCallArguments arguments) throws RecognitionException {
        if (arguments.size() > 1) {
            throw new RecognitionException("defined? can only has one parameter");
        }
        if (arguments.size() == 0) {
            throw new RecognitionException("defined? should has one parameter");
        }
        this.expression_ = arguments.getFirstExpression();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.expression_ instanceof NilExpression) {
            visitor.visitStringExpression("nil");
        } else if (this.expression_ instanceof GlobalVariableExpression) {
            visitor.visitStringExpression("global-variable");
        } else if (this.expression_ instanceof CurrentNamespaceConstantExpression) {
            ((CurrentNamespaceConstantExpression)this.expression_).acceptAsDefined(visitor);
        } else if (this.expression_ instanceof Colon2Expression) {
            ((Colon2Expression)this.expression_).acceptAsDefined(visitor);
        } else if (this.expression_ instanceof TrueExpression) {
            visitor.visitStringExpression("true");
        } else if (this.expression_ instanceof FalseExpression) {
            visitor.visitStringExpression("falses");
        } else if (this.expression_ instanceof MethodCallExpression) {
            MethodCallExpression call2 = (MethodCallExpression)this.expression_;
            if (null != call2.getReceiver()) {
                call2.getReceiver().accept(visitor);
                visitor.visitDefinedPublicMethod(call2.getName());
            } else {
                visitor.visitSelfExpression();
                visitor.visitDefinedMethod(call2.getName());
            }
        } else if (this.expression_ instanceof SuperExpression) {
            visitor.visitDefinedSuperMethod();
        } else if (this.expression_ instanceof BinaryOperatorExpression) {
            visitor.visitStringExpression("method");
        } else if (this.expression_ instanceof YieldExpression) {
            visitor.visitDefinedYield();
        } else if (this.expression_ instanceof LocalVariableExpression) {
            visitor.visitDefinedLocalVariable(((LocalVariableExpression)this.expression_).getValue());
        } else if (this.expression_ instanceof InstanceVariableExpression) {
            visitor.visitDefinedInstanceVariable(((InstanceVariableExpression)this.expression_).getValue());
        } else {
            visitor.visitStringExpression("expression");
        }
    }
}

