/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.FalseExpression;
import com.xruby.compiler.codedom.FloatExpression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.IntegerExpression;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.StringExpression;
import com.xruby.compiler.codedom.TrueExpression;
import com.xruby.compiler.codedom.Visitable;
import java.util.ArrayList;

public abstract class Expression
implements Visitable {
    protected int position;
    protected boolean newLine = false;

    protected boolean conditionIsAlwayTrue(Expression e) {
        if (e instanceof IntegerExpression) {
            return true;
        }
        if (e instanceof FloatExpression) {
            return true;
        }
        if (e instanceof StringExpression) {
            return true;
        }
        return e instanceof TrueExpression;
    }

    boolean willNotBeExecuted() {
        return false;
    }

    protected boolean conditionIsAlwayFalse(Expression e) {
        if (e instanceof FalseExpression) {
            return true;
        }
        return e instanceof NilExpression;
    }

    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
    }

    void pullBlock(ArrayList<Block> result) {
    }

    public void getFrequentlyUsedIntegers(ArrayList<Integer> result) {
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean shouldlabelNewLine() {
        return this.newLine;
    }

    public void setNewLine(boolean newLine) {
        this.newLine = newLine;
    }

    public void addLineno(CodeVisitor visitor) {
        if (this.shouldlabelNewLine()) {
            int lineNumber = this.getPosition();
            visitor.visitLineLabel(lineNumber);
        }
    }
}

