/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.ArrayExpression;
import com.xruby.compiler.codedom.AssignmentOperatorExpression;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.NestedVariableExpression;
import com.xruby.compiler.codedom.ParenthesisExpression;
import com.xruby.compiler.codedom.Statement;
import com.xruby.compiler.codedom.VariableExpression;
import java.util.ArrayList;
import java.util.Collections;

public class MultipleAssignmentStatement
extends Statement {
    private ArrayList<Expression> mlhs_ = new ArrayList();
    private ArrayList<Expression> mrhs_ = new ArrayList();
    private VariableExpression asterisk_lhs_ = null;
    private Expression asterisk_rhs_ = null;
    private boolean handle_special_case_ = false;
    private boolean has_extra_comma_;

    public MultipleAssignmentStatement(boolean has_extra_comma) {
        this.has_extra_comma_ = has_extra_comma;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLhs(Expression e) throws RecognitionException {
        if (this.handle_special_case_) {
            this.mrhs_.add(e);
            return;
        }
        if (e instanceof VariableExpression) {
            this.mlhs_.add(e);
            return;
        } else if (e instanceof AssignmentOperatorExpression) {
            AssignmentOperatorExpression a = (AssignmentOperatorExpression)e;
            this.mlhs_.add(a.getLhs());
            this.mrhs_.add(a.getRhs());
            this.handle_special_case_ = true;
            return;
        } else if (e instanceof MethodCallExpression) {
            MethodCallExpression m = (MethodCallExpression)e;
            if (m.getArguments() == null || m.getArguments().size() == 0) {
                this.mlhs_.add(new LocalVariableExpression(m.getName(), false));
                return;
            } else {
                if (!m.isElementSet()) throw new RecognitionException("Only variable can be parallel assigned");
                this.mlhs_.add(m);
            }
            return;
        } else {
            if (!(e instanceof ParenthesisExpression)) throw new RecognitionException("Only variable can be parallel assigned (" + e.getClass() + ")");
            NestedVariableExpression ne = new NestedVariableExpression();
            ParenthesisExpression p2 = (ParenthesisExpression)e;
            CompoundStatement c = p2.compstmt_;
            if (c.size() != 1) {
                throw new RecognitionException("MultipleAssignment syntax error");
            }
            MultipleAssignmentStatement m = (MultipleAssignmentStatement)c.statements_.get(0);
            for (Expression lhs : m.mlhs_) {
                ne.addLhs(lhs);
            }
            if (null != m.asterisk_lhs_) {
                ne.setAsteriskLhs(m.asterisk_lhs_);
            }
            this.mlhs_.add(ne);
        }
    }

    public void addRhs(Expression e) {
        this.mrhs_.add(e);
    }

    public void setAsteriskRhs(Expression e) {
        assert (null == this.asterisk_rhs_);
        this.asterisk_rhs_ = e;
    }

    public void setAsteriskLhs(Expression e) throws RecognitionException {
        assert (null == this.asterisk_lhs_);
        if (null == e) {
            this.asterisk_lhs_ = new LocalVariableExpression("anonymous_asterisk$", false);
        } else if (e instanceof VariableExpression) {
            this.asterisk_lhs_ = (VariableExpression)e;
        } else {
            throw new RecognitionException("Only variable can be parallel assigned");
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        MultipleAssignmentStatement.acceptMrhs(visitor, this.mrhs_, this.asterisk_rhs_);
        MultipleAssignmentStatement.acceptMLhs(visitor, this.mlhs_, this.asterisk_lhs_, this.has_extra_comma_, true);
    }

    private static void acceptMrhs(CodeVisitor visitor, ArrayList<Expression> mrhs, Expression asterisk_rhs) {
        ArrayExpression to_a2 = new ArrayExpression(mrhs, asterisk_rhs);
        to_a2.accept(visitor);
    }

    static void acceptMLhs(CodeVisitor visitor, ArrayList<Expression> mlhs, VariableExpression asterisk_lhs, boolean has_extra_comma, boolean is_multi_rhs) {
        Collections.reverse(mlhs);
        if (!is_multi_rhs && mlhs.size() == 1) {
            visitor.visitMultipleAssignment(true, true, is_multi_rhs);
            ((VariableExpression)mlhs.get(0)).acceptAsAssignment(visitor, false, true);
        } else if (mlhs.size() == 1 && null == asterisk_lhs && !has_extra_comma) {
            visitor.visitMultipleAssignment(true, true, is_multi_rhs);
            ((VariableExpression)mlhs.get(0)).acceptAsAssignment(visitor, false, true);
        } else {
            int var = visitor.visitMultipleAssignment(false, mlhs.size() > 0, is_multi_rhs);
            for (int i = 0; i < mlhs.size(); ++i) {
                visitor.visitMrhs(var, i, false);
            }
            if (null != asterisk_lhs) {
                visitor.visitMrhs(var, mlhs.size(), true);
                asterisk_lhs.acceptAsAssignment(visitor, false, true);
            }
            for (Expression lhs : mlhs) {
                if (lhs instanceof VariableExpression) {
                    ((VariableExpression)lhs).acceptAsAssignment(visitor, false, true);
                    continue;
                }
                assert (lhs instanceof MethodCallExpression);
                ((MethodCallExpression)lhs).acceptMultipleArrayAssign(visitor);
            }
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        for (Expression lhs : this.mlhs_) {
            if (lhs instanceof LocalVariableExpression) {
                String name = ((LocalVariableExpression)lhs).getValue();
                if (symboltable.isDefinedInCurrentScope(name)) continue;
                result.add(name);
                continue;
            }
            if (!(lhs instanceof NestedVariableExpression)) continue;
            ((NestedVariableExpression)lhs).getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.asterisk_lhs_) {
            this.asterisk_lhs_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

