/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.ParameterVariableExpression;
import java.util.ArrayList;
import java.util.Collections;

public class NestedVariableExpression
extends ParameterVariableExpression {
    private ArrayList<ParameterVariableExpression> mlhs_ = new ArrayList();
    private ParameterVariableExpression asterisk_lhs_ = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLhs(Expression e) throws RecognitionException {
        if (e instanceof ParameterVariableExpression) {
            this.mlhs_.add((ParameterVariableExpression)e);
            return;
        } else {
            if (!(e instanceof MethodCallExpression)) throw new RecognitionException("Only variable can be parallel assigned");
            MethodCallExpression m = (MethodCallExpression)e;
            if (m.getArguments() != null && m.getArguments().size() != 0) throw new RecognitionException("Only variable can be parallel assigned");
            this.mlhs_.add(new LocalVariableExpression(m.getName(), false));
        }
    }

    public void setAsteriskLhs(Expression e) throws RecognitionException {
        assert (null == this.asterisk_lhs_);
        if (!(e instanceof ParameterVariableExpression)) {
            throw new RecognitionException("Only variable can be parallel assigned");
        }
        this.asterisk_lhs_ = (ParameterVariableExpression)e;
    }

    @Override
    public void accept(CodeVisitor visitor) {
        throw new Error("Nested variable should not appear in this context");
    }

    @Override
    public void acceptAsInitializeToNil(CodeVisitor visitor) {
        for (ParameterVariableExpression var : this.mlhs_) {
            var.acceptAsInitializeToNil(visitor);
        }
        if (null != this.asterisk_lhs_) {
            this.asterisk_lhs_.acceptAsInitializeToNil(visitor);
        }
    }

    @Override
    public void acceptAsAssignment(CodeVisitor visitor, boolean rhs_is_method_call, boolean is_multiple_assign) {
        assert (is_multiple_assign);
        Collections.reverse(this.mlhs_);
        int var = visitor.visitNestedVariable(false, this.mlhs_.size() > 0);
        for (int i = 0; i < this.mlhs_.size(); ++i) {
            visitor.visitMrhs(var, i, false);
        }
        if (null != this.asterisk_lhs_) {
            visitor.visitMrhs(var, this.mlhs_.size(), true);
            this.asterisk_lhs_.acceptAsAssignment(visitor, false, true);
        }
        for (ParameterVariableExpression lhs : this.mlhs_) {
            lhs.acceptAsAssignment(visitor, false, true);
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        for (ParameterVariableExpression var : this.mlhs_) {
            var.getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.asterisk_lhs_) {
            this.asterisk_lhs_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

