/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;

public class StringExpression
extends Expression {
    private final StringBuilder value_ = new StringBuilder();

    public StringExpression(String value2, boolean double_quote) {
        this.appendString(value2, double_quote);
    }

    public String getValue() {
        return this.value_.toString();
    }

    static String convertDoubleQuoteString(String value2) {
        StringBuilder result = new StringBuilder();
        block13: for (int i = 0; i < value2.length(); ++i) {
            if (value2.charAt(i) != '\\') {
                result.append(value2.charAt(i));
                continue;
            }
            if (i == value2.length() - 1) {
                result.append('\\');
                break;
            }
            char next_char = value2.charAt(i + 1);
            switch (next_char) {
                case 'n': {
                    result.append('\n');
                    ++i;
                    continue block13;
                }
                case 't': {
                    result.append('\t');
                    ++i;
                    continue block13;
                }
                case 'r': {
                    result.append('\r');
                    ++i;
                    continue block13;
                }
                case '\\': {
                    result.append('\\');
                    ++i;
                    continue block13;
                }
                case 'b': {
                    result.append('\b');
                    ++i;
                    continue block13;
                }
                case 'f': {
                    result.append('\f');
                    ++i;
                    continue block13;
                }
                case '\"': {
                    result.append('\"');
                    ++i;
                    continue block13;
                }
                case '\'': {
                    result.append('\'');
                    ++i;
                    continue block13;
                }
                case '#': {
                    result.append('#');
                    ++i;
                    continue block13;
                }
                case 'u': {
                    int nEnd = value2.indexOf(125, i);
                    String hex2 = value2.substring(i + 3, nEnd);
                    char h = (char)Integer.parseInt(hex2, 16);
                    result.append(h);
                    i = nEnd;
                    continue block13;
                }
                case 'x': {
                    String hex3 = value2.substring(i + 2, i + (value2.length() > 4 ? 4 : 3));
                    char h = (char)Integer.parseInt(hex3, 16);
                    result.append(h);
                    i += 3;
                    continue block13;
                }
                default: {
                    if (next_char >= '0' && next_char < '8') {
                        int number_length;
                        for (number_length = 1; i + 1 + number_length < value2.length() && value2.charAt(i + 1 + number_length) >= '0' && value2.charAt(i + 1 + number_length) < '8' && number_length <= 3; ++number_length) {
                        }
                        String oct = value2.substring(i + 1, i + 1 + number_length);
                        char o = (char)Integer.parseInt(oct, 8);
                        result.append(o);
                        i += number_length;
                        continue block13;
                    }
                    result.append('\\');
                }
            }
        }
        return result.toString();
    }

    static String convertSingleQuoteString(String value2) {
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < value2.length(); ++i) {
            if (value2.charAt(i) != '\\') {
                result.append(value2.charAt(i));
                continue;
            }
            if (i == value2.length() - 1) {
                result.append('\\');
                break;
            }
            char next_char = value2.charAt(i + 1);
            switch (next_char) {
                case '\\': {
                    result.append('\\');
                    ++i;
                    continue block4;
                }
                case '\'': {
                    result.append('\'');
                    ++i;
                    continue block4;
                }
                default: {
                    result.append(value2.charAt(i));
                }
            }
        }
        return result.toString();
    }

    public void appendString(String value2, boolean double_quote) {
        if (double_quote) {
            this.value_.append(StringExpression.convertDoubleQuoteString(value2));
        } else {
            this.value_.append(StringExpression.convertSingleQuoteString(value2));
        }
    }

    public void appendRegExString(String value2) {
        this.value_.append(value2);
    }

    @Override
    public void accept(CodeVisitor visitor) {
        visitor.visitStringExpression(this.value_.toString());
    }
}

