/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.codegen.CgUtil;
import com.xruby.compiler.codegen.CompilationResult;
import com.xruby.compiler.codegen.MethodGenerator;
import com.xruby.compiler.codegen.SymbolTable;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.lang.RubyBinding;
import java.util.Collection;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.CheckClassAdapter;

abstract class ClassGenerator {
    private final ClassWriter cw_ = new ClassWriter(1);
    protected final ClassVisitor cv_ = new CheckClassAdapter(this.cw_);
    protected final String name_;
    protected MethodGenerator mg_for_run_method_ = null;

    public abstract void loadArgOfMethodForBlock();

    protected ClassGenerator(String name) {
        this.name_ = name;
    }

    public CompilationResult getCompilationResult() {
        return new CompilationResult(this.name_, this.cw_.toByteArray());
    }

    SymbolTable getSymbolTable() {
        return this.getMethodGenerator().getSymbolTable();
    }

    static String decorateName(String name) {
        return "$" + name;
    }

    public void addParameter(String name) {
        this.getSymbolTable().addMethodParameter(name);
    }

    public void setAsteriskParameter(String name, int argc) {
        MethodGenerator mg = this.getMethodGenerator();
        mg.RubyAPI_initializeAsteriskParameter(argc);
        int i = mg.newLocal(Types.RUBY_VALUE_TYPE);
        this.getSymbolTable().addAsteriskOrBlockMethodParameter(name, i);
        mg.storeLocal(i);
    }

    public void setBlockParameter(String name) {
        MethodGenerator mg = this.getMethodGenerator();
        mg.RubyAPI_initializeBlockParameter();
        int i = mg.newLocal(Types.RUBY_VALUE_TYPE);
        this.getSymbolTable().addAsteriskOrBlockMethodParameter(name, i);
        mg.storeLocal(i);
    }

    public void visitEnd() {
        this.cv_.visitEnd();
    }

    public int getAnonymousLocalVariable() {
        return this.getMethodGenerator().newLocal(Types.RUBY_VALUE_TYPE);
    }

    void getSharedBlock(String name) {
        this.getMethodGenerator().loadLocal(this.getSymbolTable().getBlock(name));
    }

    public void storeVariable(String name) {
        SymbolTable.VariableAssignedInBlock record = this.getSymbolTable().getVariableAssignedInBlock(name);
        MethodGenerator mg = this.getMethodGenerator();
        if (null != record) {
            mg.loadLocal(record.block_var_);
            mg.swap();
            mg.putField(Type.getType("L" + record.block_name_ + ";"), ClassGenerator.decorateName(name), Types.RUBY_VALUE_TYPE);
            return;
        }
        if (this.getSymbolTable().getLocalVariable(name) >= 0) {
            mg.storeRubyLocalVariable(name);
            return;
        }
        int i = this.getSymbolTable().getAsteriskOrBlockMethodParameter(name);
        if (i >= 0) {
            mg.storeLocal(i);
            return;
        }
        int index2 = this.getSymbolTable().getMethodParameter(name);
        if (index2 >= 0) {
            this.storeMethodParameter(index2);
            return;
        }
        mg.storeNewLocalVariable(name);
    }

    public void loadVariable(String name) {
        SymbolTable.VariableAssignedInBlock record = this.getSymbolTable().getVariableAssignedInBlock(name);
        MethodGenerator mg = this.getMethodGenerator();
        if (null != record) {
            mg.loadLocal(record.block_var_);
            mg.getField(Type.getType("L" + record.block_name_ + ";"), ClassGenerator.decorateName(name), Types.RUBY_VALUE_TYPE);
            return;
        }
        if (this.getSymbolTable().getLocalVariable(name) >= 0) {
            mg.loadRubyLocalVariable(name);
            return;
        }
        int i = this.getSymbolTable().getAsteriskOrBlockMethodParameter(name);
        if (i >= 0) {
            mg.loadLocal(i);
            return;
        }
        int index2 = this.getSymbolTable().getMethodParameter(name);
        if (index2 >= 0) {
            this.loadMethodPrameter(index2);
            return;
        }
        mg.loadNil();
    }

    public void loadMethodPrameter(int index2) {
        MethodGenerator mg = this.getMethodGenerator();
        mg.loadArg(1);
        mg.push(index2);
        mg.invokeVirtual(Types.RUBY_ARRAY_TYPE, CgUtil.getMethod("get", Types.RUBY_VALUE_TYPE, Type.INT_TYPE));
    }

    public void storeMethodParameter(int index2) {
        MethodGenerator mg = this.getMethodGenerator();
        int i = mg.newLocal(Types.RUBY_VALUE_TYPE);
        mg.storeLocal(i);
        mg.loadArg(1);
        mg.push(index2);
        mg.loadLocal(i);
        mg.invokeVirtual(Types.RUBY_ARRAY_TYPE, CgUtil.getMethod("set", Types.RUBY_VALUE_TYPE, Type.INT_TYPE, Types.RUBY_VALUE_TYPE));
        mg.pop();
    }

    public MethodGenerator getMethodGenerator() {
        return this.mg_for_run_method_;
    }

    public void createBinding(boolean isInClassBuilder, boolean isInSingletonMethod, boolean isInGlobalScope, boolean isInBlock) {
        int i = this.getSymbolTable().getInternalBindingVar();
        MethodGenerator mg = this.getMethodGenerator();
        if (i >= 0) {
            mg.loadLocal(i);
            this.updateBinding(isInClassBuilder, isInSingletonMethod, isInGlobalScope, isInBlock);
            return;
        }
        this.newBinding();
        this.updateBinding(isInClassBuilder, isInSingletonMethod, isInGlobalScope, isInBlock);
        mg.dup();
        i = mg.newLocal(Types.RUBY_BINDING_TYPE);
        mg.storeLocal(i);
        this.getSymbolTable().setInternalBindingVar(i);
    }

    private void newBinding() {
        MethodGenerator mg = this.getMethodGenerator();
        mg.newInstance(Types.RUBY_BINDING_TYPE);
        mg.dup();
        mg.invokeConstructor(Types.RUBY_BINDING_TYPE, CgUtil.CONSTRUCTOR);
    }

    private void updateBinding(boolean isInClassBuilder, boolean isInSingletonMethod, boolean isInGlobalScope, boolean isInBlock) {
        MethodGenerator mg = this.getMethodGenerator();
        mg.loadSelf(isInBlock);
        mg.invokeVirtual(Types.RUBY_BINDING_TYPE, CgUtil.getMethod("setSelf", Types.RUBY_BINDING_TYPE, Types.RUBY_VALUE_TYPE));
        if (isInClassBuilder) {
            mg.pushNull();
        } else {
            mg.loadBlock(isInBlock);
        }
        mg.invokeVirtual(Types.RUBY_BINDING_TYPE, CgUtil.getMethod("setBlock", Types.RUBY_BINDING_TYPE, Types.RUBY_BLOCK_TYPE));
        if (!isInBlock) {
            mg.loadCurrentScope(isInClassBuilder, isInSingletonMethod, isInGlobalScope, isInBlock);
        } else {
            mg.pushNull();
        }
        mg.invokeVirtual(Types.RUBY_BINDING_TYPE, CgUtil.getMethod("setScope", Types.RUBY_BINDING_TYPE, Types.RUBY_MODULE_TYPE));
        this.addVariableToBinding();
    }

    public void addVariableToBinding() {
        Collection<String> vars = this.getSymbolTable().getLocalVariables();
        Method addVarMethod = CgUtil.getMethod("addVariable", Types.RUBY_BINDING_TYPE, Type.getType(String.class), Types.RUBY_VALUE_TYPE);
        MethodGenerator mg = this.getMethodGenerator();
        for (String s : vars) {
            mg.push(s);
            this.loadVariable(s);
            mg.invokeVirtual(Types.RUBY_BINDING_TYPE, addVarMethod);
        }
        Collection<String> params = this.getSymbolTable().getParameters();
        for (String s : params) {
            mg.push(s);
            this.loadMethodPrameter(this.getSymbolTable().getMethodParameter(s));
            mg.invokeVirtual(Types.RUBY_BINDING_TYPE, addVarMethod);
        }
    }

    public boolean isDefinedInCurrentScope(String name) {
        return this.getSymbolTable().isDefinedInCurrentScope(name);
    }

    protected void updateBinding(RubyBinding binding2, String name) {
        if (null != binding2 && !binding2.hasName(name)) {
            binding2.addVariableName(name);
            this.mg_for_run_method_.dup();
            this.mg_for_run_method_.loadArg(1);
            this.mg_for_run_method_.swap();
            this.mg_for_run_method_.invokeVirtual(Types.RUBY_ARRAY_TYPE, CgUtil.getMethod("add", Types.RUBY_ARRAY_TYPE, Types.RUBY_VALUE_TYPE));
            this.mg_for_run_method_.pop();
        }
    }
}

