/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.XRubyClassLoader;
import com.xruby.compiler.codedom.BlockFarm;
import com.xruby.compiler.codegen.CompilationResult;
import com.xruby.compiler.codegen.NameFactory;
import com.xruby.runtime.lang.RubyProgram;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class CompilationResults {
    private final List<CompilationResult> results_ = new ArrayList<CompilationResult>();

    public void add(CompilationResult result) {
        this.results_.add(result);
    }

    public void add(CompilationResults results) {
        for (CompilationResult result : results.results_) {
            this.results_.add(result);
        }
    }

    public int size() {
        return this.results_.size();
    }

    public void save(String script_name) throws FileNotFoundException, IOException {
        String targetFileName = NameFactory.createJarFileName(script_name);
        File targetFile = new File(targetFileName);
        FileOutputStream fstream = new FileOutputStream(targetFile);
        JarOutputStream jarstream = new JarOutputStream((OutputStream)fstream, this.createManifest(script_name));
        for (CompilationResult result : this.results_) {
            result.save(jarstream);
        }
        this.writeBlockInfo(script_name, jarstream);
        jarstream.close();
        System.out.println("Generated " + targetFileName);
    }

    private void writeBlockInfo(String script_name, JarOutputStream jarstream) throws IOException {
        String smap = BlockFarm.getMapByName(script_name);
        if (smap == null) {
            smap = "0\n";
        }
        jarstream.putNextEntry(new JarEntry(NameFactory.createClassNameForSmap(script_name)));
        jarstream.write(smap.getBytes());
    }

    private Manifest createManifest(String script_name) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.putValue("Manifest-Version", "1.0");
        attrs.putValue("Created-By", "0.3.3 (XRuby)");
        attrs.putValue("Main-Class", NameFactory.createMainClass(script_name));
        attrs.putValue("Class-Path", "xruby-0.3.3.jar");
        return manifest;
    }

    public RubyProgram getRubyProgram() throws InstantiationException, IllegalAccessException {
        XRubyClassLoader loader = new XRubyClassLoader();
        Class classToRun = null;
        for (CompilationResult result : this.results_) {
            classToRun = result.load(loader);
        }
        return (RubyProgram)classToRun.newInstance();
    }
}

