/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.codegen.CgUtil;
import com.xruby.compiler.codegen.ClassGenerator;
import com.xruby.compiler.codegen.ClassGeneratorForRubyBlock;
import com.xruby.compiler.codegen.EnsureLabelManager;
import com.xruby.compiler.codegen.IntegerTable;
import com.xruby.compiler.codegen.LabelManager;
import com.xruby.compiler.codegen.RubyIDClassGenerator;
import com.xruby.compiler.codegen.SymbolTable;
import com.xruby.compiler.codegen.SymbolTableForBlock;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyBinding;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

class MethodGenerator
extends GeneratorAdapter {
    private SymbolTable symbol_table_;
    private IntegerTable integer_table_ = new IntegerTable();
    private List<Class> current_types_on_stack_ = new ArrayList<Class>();
    private List<Integer> saved_vars_ = new ArrayList<Integer>();
    private final boolean is_singleton_;
    private final LabelManager label_manager_ = new LabelManager();
    private final EnsureLabelManager ensure_label_manager_ = new EnsureLabelManager();
    private static final Method RubyAPICallNoArgMethodMethod = CgUtil.getMethod("callNoArgMethod", Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_BLOCK_TYPE, Types.RUBY_ID_TYPE);
    private static final Method RubyAPICallOneArgMethodMethod = CgUtil.getMethod("callOneArgMethod", Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_BLOCK_TYPE, Types.RUBY_ID_TYPE);
    private static final Method RubyAPICallTwoArgMethodMethod = CgUtil.getMethod("callTwoArgMethod", Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_BLOCK_TYPE, Types.RUBY_ID_TYPE);

    public MethodGenerator(int arg0, Method arg1, ClassVisitor cv, RubyBinding binding2, SymbolTable st, boolean is_singleton) {
        super(arg0, arg1, null, null, cv);
        List<String> bindingVar = null == binding2 ? null : binding2.getVariableNames();
        this.symbol_table_ = null == st ? new SymbolTable(bindingVar) : new SymbolTableForBlock(bindingVar, st);
        this.is_singleton_ = is_singleton;
        this.visitCode();
    }

    public SymbolTable getSymbolTable() {
        return this.symbol_table_;
    }

    public LabelManager getLabelManager() {
        return this.label_manager_;
    }

    public EnsureLabelManager getEnsureLabelManager() {
        return this.ensure_label_manager_;
    }

    public boolean isSingleton() {
        return this.is_singleton_;
    }

    public void saveCurrentVariablesOnStack() {
        Collections.reverse(this.current_types_on_stack_);
        for (Class c : this.current_types_on_stack_) {
            int v = this.newLocal(Type.getType(c));
            this.saved_vars_.add(v);
            this.storeLocal(v);
        }
        Collections.reverse(this.current_types_on_stack_);
    }

    public void restoreCurrentVariablesOnStack() {
        if (this.saved_vars_.isEmpty()) {
            return;
        }
        int i = this.newLocal(Types.RUBY_VALUE_TYPE);
        this.storeLocal(i);
        Collections.reverse(this.saved_vars_);
        for (Integer v : this.saved_vars_) {
            this.loadLocal(v);
        }
        this.saved_vars_.clear();
        this.loadLocal(i);
    }

    public void addCurrentVariablesOnStack(Class c) {
        this.current_types_on_stack_.add(c);
    }

    public void removeCurrentVariablesOnStack() {
        this.current_types_on_stack_.remove(this.current_types_on_stack_.size() - 1);
    }

    public void pushNull() {
        this.visitInsn(1);
    }

    public void loadRubyLocalVariable(String name) {
        this.loadLocal(this.getSymbolTable().getLocalVariable(name));
    }

    public void storeRubyLocalVariable(String name) {
        this.storeLocal(this.getSymbolTable().getLocalVariable(name));
    }

    public void storeNewLocalVariable(String name) {
        int i = this.newLocal(Types.RUBY_VALUE_TYPE);
        this.getSymbolTable().addLocalVariable(name, i);
        this.storeLocal(i);
    }

    public void storeVariablesAssignedInBlock(String block_name, String[] assigned_commons, int i) {
        if (assigned_commons.length == 0) {
            return;
        }
        if (i < 0) {
            i = this.newLocal(Types.RUBY_BLOCK_TYPE);
            this.dup();
            this.storeLocal(i);
        }
        this.symbol_table_.addVariblesAssignedInBlock(block_name, i, assigned_commons);
    }

    public void returnIfBlockReturned() {
        this.dup();
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, Method.getMethod("boolean returnedInBlock()"));
        Label after_return = new Label();
        this.ifZCmp(153, after_return);
        this.returnValue();
        this.mark(after_return);
    }

    public void store_asterisk_parameter_(Class c) {
        this.loadThis();
        this.swap();
        this.putField(Type.getType(c), "asterisk_parameter_", Types.RUBY_VALUE_TYPE);
    }

    public void store_block_parameter_(Class c) {
        this.loadThis();
        this.swap();
        this.putField(Type.getType(c), "block_parameter_", Types.RUBY_VALUE_TYPE);
    }

    public void load_asterisk_parameter_(Class c) {
        this.loadThis();
        this.getField(Type.getType(c), "asterisk_parameter_", Types.RUBY_VALUE_TYPE);
    }

    public void load_block_parameter_(Class c) {
        this.loadThis();
        this.getField(Type.getType(c), "block_parameter_", Types.RUBY_VALUE_TYPE);
    }

    public void loadBlock(boolean is_in_block) {
        if (is_in_block) {
            this.RubyBlock_blockOfCurrentMethod_();
        } else {
            this.loadCurrentBlock();
        }
    }

    public void loadMethodPrameterLength() {
        this.loadArg(1);
        this.invokeVirtual(Types.RUBY_ARRAY_TYPE, Method.getMethod("int size()"));
    }

    public void loadCurrentScope(boolean is_in_class_builder, boolean is_in_singleton_method, boolean is_in_global_scope, boolean is_in_block) {
        if (is_in_class_builder || is_in_global_scope) {
            this.loadArg(3);
        } else {
            this.loadThis();
            this.MethodBlockBase_getScope();
        }
    }

    public void loadCurrentClass(boolean is_in_block) {
        if (is_in_block) {
            this.loadThis();
            this.MethodBlockBase_getScope();
        } else {
            this.loadArg(3);
        }
    }

    public void loadMethodArg() {
        this.loadArg(1);
    }

    public int saveRubyArrayAsLocalVariable() {
        int var = this.newLocal(Types.RUBY_ARRAY_TYPE);
        this.storeLocal(var);
        return var;
    }

    public void catchRubyException(Label start2, Label end) {
        this.catchException(start2, end, Types.RUBY_EXCEPTION_TYPE);
    }

    public void RubyBlock_argOfCurrentMethod_() {
        this.loadThis();
        this.getField(Types.RUBY_BLOCK_TYPE, "argOfCurrentMethod_", Types.RUBY_VALUE_TYPE);
    }

    public void RubyBlock_argsOfCurrentMethod_() {
        this.loadThis();
        this.getField(Types.RUBY_BLOCK_TYPE, "argsOfCurrentMethod_", Types.RUBY_ARRAY_TYPE);
    }

    private void RubyBlock_blockOfCurrentMethod_() {
        this.loadThis();
        this.getField(Types.RUBY_BLOCK_TYPE, "blockOfCurrentMethod_", Types.RUBY_BLOCK_TYPE);
    }

    private void RubyBlock_selfOfCurrentMethod_() {
        this.loadThis();
        this.getField(Types.RUBY_BLOCK_TYPE, "selfOfCurrentMethod_", Types.RUBY_VALUE_TYPE);
    }

    public void RubyBlock__break__() {
        this.loadThis();
        this.push(true);
        this.putField(Types.RUBY_BLOCK_TYPE, "__break__", Type.BOOLEAN_TYPE);
    }

    public void RubyBlock__return__() {
        this.loadThis();
        this.push(true);
        this.putField(Types.RUBY_BLOCK_TYPE, "__return__", Type.BOOLEAN_TYPE);
    }

    public void RubyBlock__retry__() {
        this.loadThis();
        this.push(true);
        this.putField(Types.RUBY_BLOCK_TYPE, "__retry__", Type.BOOLEAN_TYPE);
    }

    public void RubyBlock_getCurrentMethod() {
        this.invokeVirtual(Types.RUBY_BLOCK_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyMethod getCurrentMethod()"));
    }

    public void loadSelf(boolean is_in_block) {
        if (is_in_block) {
            this.RubyBlock_selfOfCurrentMethod_();
        } else {
            this.loadArg(0);
        }
    }

    public void new_MethodClass(String methodName) {
        Type methodNameType = Type.getType("L" + methodName + ";");
        this.newInstance(methodNameType);
        this.dup();
        this.invokeConstructor(methodNameType, Method.getMethod("void <init> ()"));
    }

    void loadCurrentBlock() {
        this.loadArg(2);
    }

    public void new_BlockClass(ClassGenerator cg, String name, boolean is_in_class_builder, boolean is_in_singleton_method, boolean is_in_global_scope, boolean is_in_block) {
        Type methodNameType = Type.getType("L" + name + ";");
        this.newInstance(methodNameType);
        this.dup();
        this.loadSelf(is_in_block);
        cg.loadArgOfMethodForBlock();
        if (is_in_global_scope) {
            this.pushNull();
        } else {
            this.loadBlock(is_in_block);
        }
        this.loadCurrentScope(is_in_class_builder, is_in_singleton_method, is_in_global_scope, is_in_block);
        if (is_in_block) {
            this.loadThis();
            this.RubyBlock_getCurrentMethod();
            this.push(true);
        } else if (is_in_global_scope || is_in_class_builder) {
            this.pushNull();
            this.push(false);
        } else {
            this.loadThis();
            this.push(false);
        }
        this.invokeConstructor(methodNameType, Method.getMethod(ClassGeneratorForRubyBlock.buildContructorSignature()));
    }

    public void RubyArray_add(boolean is_method_call) {
        if (is_method_call) {
            this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue expandArrayIfThereIsZeroOrOneValue(com.xruby.runtime.lang.RubyValue)"));
        }
        this.invokeVirtual(Types.RUBY_ARRAY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyArray add(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyArray_expand(boolean is_method_call) {
        if (is_method_call) {
            this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue expandArrayIfThereIsZeroOrOneValue(com.xruby.runtime.lang.RubyValue)"));
        }
        this.invokeVirtual(Types.RUBY_ARRAY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyArray expand(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyArray_get(int index2) {
        this.push(index2);
        this.invokeVirtual(Types.RUBY_ARRAY_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue get(int)"));
    }

    public void RubyArray_collect(int index2) {
        this.push(index2);
        this.invokeVirtual(Types.RUBY_ARRAY_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue collect(int)"));
    }

    public void RubyString_append(String value2) {
        this.push(value2);
        this.invokeVirtual(Types.RUBY_STRING_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyString appendString(String)"));
    }

    public void RubyString_append() {
        this.invokeVirtual(Types.RUBY_STRING_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyString appendString(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyHash_addValue() {
        this.invokeVirtual(Types.RUBY_HASH_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyHash add(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue)"));
    }

    public boolean RubyRuntime_getBuiltinClass(String className) {
        if (Types.isBuiltinClass(className)) {
            this.getStatic(Types.RUBY_RUNTIME_TYPE, className + "Class", Types.RUBY_CLASS_TYPE);
            return true;
        }
        return false;
    }

    public boolean RubyRuntime_getBuiltinModule(String name) {
        if (Types.isBuiltinModule(name)) {
            this.getStatic(Types.RUBY_RUNTIME_TYPE, name + "Module", Types.RUBY_MODULE_TYPE);
            return true;
        }
        return false;
    }

    public void ObjectFactory_createFixnum(int value2) {
        if (value2 >= 0 && value2 <= 10) {
            this.getStatic(Types.OBJECTFACTORY_TYPE, "FIXNUM" + value2, Types.RUBY_FIXNUM_TYPE);
            return;
        }
        Integer i = this.integer_table_.getInteger(value2);
        if (null != i) {
            this.loadLocal(i);
            return;
        }
        this.push(value2);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyFixnum createFixnum(int)"));
    }

    public void ObjectFactory_createFloat(double value2) {
        this.push(value2);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyFloat createFloat(double)"));
    }

    public void ObjectFactory_createBignum(BigInteger value2) {
        this.push(value2.toString());
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyBignum createBignum(String)"));
    }

    public void ObjectFactory_createString(String value2) {
        this.push(value2);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyString createString(String)"));
    }

    public void ObjectFactory_createString() {
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyString createString()"));
    }

    public void ObjectFactory_createRegexp(String value2, String option) {
        this.push(value2);
        this.push(option);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyRegexp createRegexp(String, String)"));
    }

    public void ObjectFactory_createRegexp(String option) {
        this.invokeVirtual(Types.RUBY_STRING_TYPE, Method.getMethod("String toString()"));
        this.push(option);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyRegexp createRegexp(String, String)"));
    }

    public void ObjectFactory_createSymbol(String value2) {
        if (null != value2) {
            this.push(value2);
        } else {
            this.invokeVirtual(Types.RUBY_STRING_TYPE, Method.getMethod("String toString()"));
        }
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.lang.RubySymbol createSymbol(String)"));
    }

    public void loadNil() {
        this.loadRubyConstant("QNIL");
    }

    public void loadTrue() {
        this.loadRubyConstant("QTRUE");
    }

    public void loadFalse() {
        this.loadRubyConstant("QFALSE");
    }

    private void loadRubyConstant(String constantName) {
        this.getStatic(Types.RUBY_CONSTANT_TYPE, constantName, Types.RUBY_CONSTANT_TYPE);
    }

    public void ObjectFactory_createArray(int size2, int rhs_size, boolean has_single_asterisk) {
        this.push(size2);
        this.push(rhs_size);
        this.push(has_single_asterisk);
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyArray createArray(int, int, boolean)"));
    }

    public void ObjectFactory_createHash() {
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyHash createHash()"));
    }

    public void ObjectFactory_createRange() {
        this.invokeStatic(Types.OBJECTFACTORY_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyRange createRange(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, boolean)"));
    }

    public void GlobalVatiables_set(String var) {
        if (GlobalVariables.isReadOnly(var)) {
            this.push(var);
            this.invokeStatic(Types.GLOBAL_VARIABLES_TYPE, Method.getMethod("void throwNameError(String)"));
            return;
        }
        this.push(var);
        this.invokeStatic(Types.GLOBAL_VARIABLES_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue set(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void GlobalVatiables_get(String var) {
        this.push(var);
        this.invokeStatic(Types.GLOBAL_VARIABLES_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue get(String)"));
    }

    public void GlobalVariables_alias(String newName, String oldName) {
        this.push(newName);
        this.push(oldName);
        this.invokeStatic(Types.GLOBAL_VARIABLES_TYPE, Method.getMethod("void alias(String, String)"));
    }

    public void RubyRuntime_GlobalScope() {
        this.getStatic(Types.RUBY_RUNTIME_TYPE, "ObjectClass", Types.RUBY_CLASS_TYPE);
    }

    public void RubyValue_isTrue() {
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, CgUtil.getMethod("isTrue", Type.BOOLEAN_TYPE));
    }

    private void loadRubyID(String s) {
        RubyIDClassGenerator.getField(this, s);
    }

    public void RubyAPI_callPublicMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callPublicMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.builtin.RubyArray, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyAPI_callPublicNoArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callPublicNoArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyAPI_callPublicOneArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callPublicOneArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyAPI_callPublicTwoArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callPublicTwoArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyAPI_callMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.builtin.RubyArray, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyAPI_callNoArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, RubyAPICallNoArgMethodMethod);
    }

    public void RubyAPI_callOneArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, RubyAPICallOneArgMethodMethod);
    }

    public void RubyAPI_callTwoArgMethod(String methodName) {
        this.loadRubyID(methodName);
        this.invokeStatic(Types.RUBY_API_TYPE, RubyAPICallTwoArgMethodMethod);
    }

    public void RubyAPI_callSuperMethod() {
        this.loadThis();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callSuperMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.builtin.RubyArray, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.MethodBlockBase)"));
    }

    public void RubyAPI_callSuperNoArgMethod() {
        this.loadThis();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callSuperNoArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.MethodBlockBase)"));
    }

    public void RubyAPI_callSuperOneArgMethod() {
        this.loadThis();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callSuperOneArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.MethodBlockBase)"));
    }

    public void RubyAPI_callSuperTwoArgMethod() {
        this.loadThis();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue callSuperTwoArgMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyBlock, com.xruby.runtime.lang.MethodBlockBase)"));
    }

    public void RubyAPI_operatorNot() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue operatorNot(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_runCommandAndCaptureOutput(String command) {
        this.push(command);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue runCommandAndCaptureOutput(String)"));
    }

    public void RubyAPI_runCommandAndCaptureOutput() {
        this.invokeVirtual(Types.RUBY_STRING_TYPE, Method.getMethod("String toString()"));
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue runCommandAndCaptureOutput(String)"));
    }

    public void RubyAPI_testCaseEqual() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("boolean testCaseEqual(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_testCaseEqual2() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("boolean testCaseEqual(com.xruby.runtime.builtin.RubyArray, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_testCaseEqualNotNil() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("boolean testCaseEqualNotNil(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_testExceptionType() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("boolean testExceptionType(com.xruby.runtime.builtin.RubyArray, com.xruby.runtime.lang.RubyException)"));
    }

    public void RubyAPI_getSingleValue() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue getSingleValue(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_expandArrayIfThereIsZeroOrOneValue() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue expandArrayIfThereIsZeroOrOneValue(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_expandArrayIfThereIsZeroOrOneValue2() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue expandArrayIfThereIsZeroOrOneValue(com.xruby.runtime.builtin.RubyArray)"));
    }

    public void RubyAPI_expandArrayIfThereIsOnlyOneRubyArray() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyArray expandArrayIfThereIsOnlyOneRubyArray(com.xruby.runtime.builtin.RubyArray)"));
    }

    public void RubyAPI_convertToArrayIfNotYet() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.builtin.RubyArray convertToArrayIfNotYet(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_convertRubyValue2RubyBlock() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyBlock convertRubyValue2RubyBlock(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_convertRubyException2RubyValue() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue convertRubyException2RubyValue(com.xruby.runtime.lang.RubyException)"));
    }

    public void RubyAPI_isDefinedPublicMethod(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedPublicMethod(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyModule, String)"));
    }

    public void RubyAPI_isDefinedMethod(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedMethod(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_isDefinedInstanceVariable(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedInstanceVariable(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_isDefinedCurrentNamespaceConstant(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedCurrentNamespaceConstant(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_isDefinedSuperMethod(String name) {
        this.push(name);
        this.loadThis();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedSuperMethod(com.xruby.runtime.lang.RubyValue, String, com.xruby.runtime.lang.RubyMethod)"));
    }

    public void RubyAPI_isDefinedYield() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue isDefinedYield(com.xruby.runtime.lang.RubyBlock)"));
    }

    public void RubyAPI_setTopLevelConstant(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue setTopLevelConstant(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_getCurrentNamespaceConstant(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue getCurrentNamespaceConstant(com.xruby.runtime.lang.RubyModule, String)"));
    }

    public void RubyAPI_getConstant(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue getConstant(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_setConstant(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue setConstant(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyAPI_callArraySet() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("void callArraySet(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_defineClass() {
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyClass defineClass(String, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyModule_defineClass() {
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyClass defineClass(String, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyAPI_defineModule(String name) {
        this.push(name);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyModule defineModule(String)"));
    }

    public void RubyAPI_initializeAsteriskParameter(int argc) {
        this.loadArg(1);
        this.push(argc);
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue initializeAsteriskParameter(com.xruby.runtime.builtin.RubyArray, int)"));
    }

    public void RubyAPI_initializeBlockParameter() {
        this.loadCurrentBlock();
        this.invokeStatic(Types.RUBY_API_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue initializeBlockParameter(com.xruby.runtime.lang.RubyBlock)"));
    }

    public void RubyModule_defineModule(String name) {
        this.push(name);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyModule defineModule(String)"));
    }

    public void RubyModule_getClassVariable(String name) {
        this.push(name);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue getClassVariable(String)"));
    }

    public void RubyModule_setClassVariable(String name) {
        this.push(name);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue setClassVariable(com.xruby.runtime.lang.RubyValue, String)"));
    }

    public void RubyModule_aliasMethod(String newName, String oldName) {
        this.push(newName);
        this.push(oldName);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("void aliasMethod(String, String)"));
    }

    public void RubyModule_undefMethod(String name) {
        this.push(name);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("void undefMethod(String)"));
    }

    public void RubyModule_defineMethod(String methodName, String uniqueMethodName) {
        this.push(methodName);
        this.new_MethodClass(uniqueMethodName);
        this.invokeVirtual(Types.RUBY_MODULE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue defineMethod(String, com.xruby.runtime.lang.RubyMethod)"));
    }

    public void RubyBlock_invokeNoArg(boolean is_in_block) {
        this.invokeVirtual(Types.RUBY_BLOCK_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue invoke(com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyBlock_invokeOneArg(boolean is_in_block) {
        this.invokeVirtual(Types.RUBY_BLOCK_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue invoke(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyValue)"));
    }

    public void RubyBlock_invoke(boolean is_in_block) {
        this.invokeVirtual(Types.RUBY_BLOCK_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue invoke(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.builtin.RubyArray)"));
    }

    public void checkBreakedOrReturned(boolean is_in_block) {
        int value2 = this.newLocal(Types.RUBY_VALUE_TYPE);
        this.storeLocal(value2);
        this.invokeVirtual(Types.RUBY_BLOCK_TYPE, CgUtil.getMethod("breakedOrReturned", Type.BOOLEAN_TYPE));
        Label after_return = new Label();
        this.ifZCmp(153, after_return);
        if (is_in_block) {
            this.loadThis();
            this.push(true);
            this.putField(Types.RUBY_BLOCK_TYPE, "__break__", Type.BOOLEAN_TYPE);
        }
        this.loadLocal(value2);
        this.returnValue();
        this.mark(after_return);
        this.loadLocal(value2);
    }

    public void RubyValue_getRubyClass() {
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyClass getRubyClass()"));
    }

    public void RubyValue_getSingletonClass() {
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyClass getSingletonClass(com.xruby.runtime.lang.RubyModule)"));
    }

    public void RubyValue_getInstanceVariable(String name) {
        RubyIDClassGenerator.getField(this, name);
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue getInstanceVariable(com.xruby.runtime.lang.RubyID)"));
    }

    public void RubyValue_setInstanceVariable(String name) {
        RubyIDClassGenerator.getField(this, name);
        this.invokeVirtual(Types.RUBY_VALUE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyValue setInstanceVariable(com.xruby.runtime.lang.RubyValue, com.xruby.runtime.lang.RubyID)"));
    }

    public void MethodBlockBase_getScope() {
        this.invokeVirtual(Types.METHOD_BLOCK_BASE_TYPE, Method.getMethod("com.xruby.runtime.lang.RubyModule getScope()"));
    }

    public void RubyProc_isDefinedInAnotherBlock() {
        this.invokeVirtual(Types.RUBY_PROC_TYPE, Method.getMethod("boolean isDefinedInAnotherBlock()"));
    }

    public void writeLocalVariableInfo() {
        Label endLabel = this.mark();
        SymbolTable table = this.getSymbolTable();
        Map<String, Label> varRanges = table.getLocalVariableRange();
        List<String> sequence = table.getDeclarationSeq();
        for (String var : sequence) {
            Label startLabel = varRanges.get(var);
            if (startLabel == null) continue;
            int index2 = table.getLocalVariable(var);
            this.visitLocalVariable(var, "Lcom/xruby/runtime/lang/RubyValue;", null, startLabel, endLabel, index2);
        }
    }
}

