/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public class NameFactory {
    private static AtomicInteger count_ = new AtomicInteger(0);
    private static final String DefaultName = "main";
    public static String name_classprefix_ = "xruby";
    public static String DEFAULT_RUBY_ID_CLASS_NAME = "RubyIDContainer";

    public static void reset() {
        count_.set(0);
    }

    public static String createClassName(String extra, String script_name, String method_name) {
        if (null == script_name) {
            script_name = "STDIN";
        }
        if (null == method_name) {
            return name_classprefix_ + "/" + NameFactory.getNameWithoutPrefixAndSufix(extra, script_name) + "/" + DefaultName;
        }
        return name_classprefix_ + "/" + NameFactory.getNameWithoutPrefixAndSufix(extra, script_name) + "/" + NameFactory.removeInvalidIdentifierPart(method_name, false) + "$" + count_.getAndIncrement();
    }

    public static String createClassnameForClassModuleBuilder(String extra, String script_name, String class_name) {
        return NameFactory.createClassName(extra, script_name, class_name);
    }

    public static String createClassNameForIDContainer(String extra, String script_name) {
        if (null == script_name) {
            script_name = "STDIN";
        }
        return name_classprefix_ + "/" + NameFactory.getNameWithoutPrefixAndSufix(extra, script_name) + "/" + DEFAULT_RUBY_ID_CLASS_NAME;
    }

    private static String removeInvalidIdentifierPart(String method_name, boolean ignore_back_slash_and_dot) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < method_name.length(); ++i) {
            char current_char = method_name.charAt(i);
            if (Character.isJavaIdentifierPart(current_char)) {
                sb.append(current_char);
                continue;
            }
            sb.append(NameFactory.translateCommonChar(current_char, ignore_back_slash_and_dot));
        }
        return sb.toString();
    }

    private static String translateCommonChar(char v, boolean ignore_back_slash_and_dot) {
        switch (v) {
            case '+': {
                return "plus";
            }
            case '-': {
                return "minus";
            }
            case '*': {
                return "star";
            }
            case '/': {
                if (ignore_back_slash_and_dot) {
                    return "/";
                }
                return "div";
            }
            case '\\': {
                if (ignore_back_slash_and_dot) {
                    return "/";
                }
                return "div";
            }
            case '.': {
                if (ignore_back_slash_and_dot) {
                    return ".";
                }
                return "dot";
            }
            case '=': {
                return "equal";
            }
            case '?': {
                return "question";
            }
            case '!': {
                return "danger";
            }
        }
        return "$";
    }

    public static String createClassNameForBlock(String extra, String script_name, String method_name) {
        if (null == script_name) {
            script_name = "STDIN";
        }
        return name_classprefix_ + "/" + NameFactory.getNameWithoutPrefixAndSufix(extra, script_name) + "/BLOCK" + (null == method_name ? "" : "_" + NameFactory.removeInvalidIdentifierPart(method_name, false)) + "$" + count_.getAndIncrement();
    }

    public static String createClassNameForSmap(String script_name) {
        return name_classprefix_ + "/" + NameFactory.getNameWithoutSufix(script_name) + "/" + script_name + ".smap";
    }

    public static String createMainClass(String script_name) {
        return name_classprefix_ + "." + NameFactory.getNameWithoutSufix(script_name) + "." + DefaultName;
    }

    public static String createClassFileName(String method_name) {
        return method_name + ".class";
    }

    public static String createJarFileName(String script_name) {
        return null == script_name ? "STDIN.jar" : NameFactory.getNameWithoutSufix(script_name) + ".jar";
    }

    public static String createMainClassName(String required_file) {
        if (required_file.endsWith(".rb")) {
            required_file = required_file.substring(0, required_file.length() - 3);
        }
        required_file = required_file.replace('/', '.');
        required_file = required_file.replace('\\', '.');
        required_file = required_file + ".main";
        return name_classprefix_ + "." + required_file;
    }

    private static String getNameWithoutSufix(String script_name) {
        int position_of_last_dot;
        File file = new File(script_name);
        String name = file.getName();
        if (name.endsWith(".rb") && (position_of_last_dot = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, position_of_last_dot);
        }
        return NameFactory.removeInvalidIdentifierPart(name, true);
    }

    private static String getNameWithoutPrefixAndSufix(String omit, String script_name) {
        if (null == omit) {
            return NameFactory.getNameWithoutSufix(script_name);
        }
        assert (script_name.startsWith(omit));
        String extra = script_name.substring(omit.length() + 1);
        int position_of_first_dot = extra.indexOf(46);
        if (position_of_first_dot >= 0) {
            extra = extra.substring(0, position_of_first_dot);
        }
        return NameFactory.removeInvalidIdentifierPart(extra, true);
    }

    public static String filename2classname(String name) {
        return NameFactory.convertSlashToDot(name.replace(".class", ""));
    }

    public static String convertSlashToDot(String name) {
        return name.replace('/', '.');
    }
}

