/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;

class SymbolTable {
    private final Map<String, Integer> local_variables_ = new HashMap<String, Integer>();
    private final Map<String, VariableAssignedInBlock> local_variables_assigned_in_block_ = new HashMap<String, VariableAssignedInBlock>();
    private final Map<String, Label> localVariableRange = new HashMap<String, Label>();
    private final List<String> declarationSeq = new ArrayList<String>();
    private final List<String> method_parameters_;
    private final Map<String, Integer> asterisk_or_block_method_parameter_ = new HashMap<String, Integer>();
    private static final String NAME_FOR_INTERNAL_BINDING_VAR = "binding$";

    public SymbolTable(List<String> binding2) {
        this.method_parameters_ = null == binding2 ? new ArrayList<String>() : binding2;
    }

    public void addVariblesAssignedInBlock(String block_name, int block_var, String[] assigned_commons) {
        for (String s : assigned_commons) {
            if (this.local_variables_assigned_in_block_.containsKey(s)) continue;
            this.local_variables_assigned_in_block_.put(s, new VariableAssignedInBlock(block_name, block_var));
        }
    }

    public VariableAssignedInBlock getVariableAssignedInBlock(String name) {
        return this.local_variables_assigned_in_block_.get(name);
    }

    public void setInternalBindingVar(int i) {
        this.addLocalVariable(NAME_FOR_INTERNAL_BINDING_VAR, i);
    }

    public int getInternalBindingVar() {
        return this.getLocalVariable(NAME_FOR_INTERNAL_BINDING_VAR);
    }

    public Collection<String> getLocalVariables() {
        Set<String> r = this.local_variables_.keySet();
        return r;
    }

    public Collection<String> getParameters() {
        return this.method_parameters_;
    }

    public void addLocalVariable(String name, int i) {
        this.local_variables_.put(name, i);
        this.localVariableRange.put(name, null);
    }

    public void addAsteriskOrBlockMethodParameter(String name, int i) {
        this.asterisk_or_block_method_parameter_.put(name, i);
    }

    public int getLocalVariable(String name) {
        Integer i = this.local_variables_.get(name);
        if (null == i) {
            return -1;
        }
        return i;
    }

    public int getAsteriskOrBlockMethodParameter(String name) {
        Integer i = this.asterisk_or_block_method_parameter_.get(name);
        if (null == i) {
            return -1;
        }
        return i;
    }

    public void addMethodParameter(String name) {
        this.method_parameters_.add(name);
    }

    public int getMethodParameter(String name) {
        return this.method_parameters_.indexOf(name);
    }

    public boolean isDefinedInCurrentScope(String name) {
        if (this.getLocalVariable(name) >= 0) {
            return true;
        }
        if (this.getAsteriskOrBlockMethodParameter(name) >= 0) {
            return true;
        }
        return this.getMethodParameter(name) >= 0;
    }

    public boolean isNewLocalVar(String var) {
        return this.localVariableRange.get(var) == null;
    }

    public void setVarLineNumberInfo(String var, Label label) {
        this.localVariableRange.put(var, label);
        this.declarationSeq.add(var);
    }

    public Map<String, Label> getLocalVariableRange() {
        return this.localVariableRange;
    }

    public List<String> getDeclarationSeq() {
        return this.declarationSeq;
    }

    public int getBlock(String name) {
        for (VariableAssignedInBlock record : this.local_variables_assigned_in_block_.values()) {
            if (!name.equals(record.block_name_)) continue;
            return record.block_var_;
        }
        return -1;
    }

    class VariableAssignedInBlock {
        final String block_name_;
        final int block_var_;

        VariableAssignedInBlock(String block_name, int block_var) {
            this.block_name_ = block_name;
            this.block_var_ = block_var;
        }
    }
}

