/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.parser;

import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import com.xruby.compiler.parser.InputBufferWithHereDocSupport;
import com.xruby.compiler.parser.RubyLexerBase;
import com.xruby.compiler.parser.StringDelimiter;
import com.xruby.compiler.parser.SymbolTableManager;
import java.io.Reader;
import java.util.Stack;

public class RubyLexer
extends RubyLexerBase {
    private SymbolTableManager stm_;
    private Token last_token_ = new Token();
    private boolean allow_asignment_ = true;
    private boolean allow_block_parameter_ = false;
    private boolean allow_for_expression_parameter_ = false;
    private boolean seen_whitespace_ = true;
    private boolean is_in_condition = false;
    private boolean just_finished_parsing_regex_expression_substituation_ = false;
    private boolean just_finished_parsing_string_expression_substituation_ = false;
    private boolean just_finished_parsing_heredoc_expression_substituation_ = false;
    private boolean just_finished_parsing_symbol_ = false;
    private boolean is_in_nested_multiple_assign_ = false;
    private Stack<StringDelimiter> current_special_string_delimiter_ = new Stack();
    private InputBufferWithHereDocSupport input_ = (InputBufferWithHereDocSupport)this.inputState.getInput();
    private String current_heredoc_delimiter_ = null;

    public RubyLexer(Reader in, boolean strip2) {
        this(in, new SymbolTableManager(), strip2);
    }

    public RubyLexer(Reader in, SymbolTableManager stm, boolean strip2) {
        super(new InputBufferWithHereDocSupport(in));
        this.stm_ = stm;
        if (strip2) {
            this.stripOffSomeText();
        }
    }

    private void stripOffSomeText() {
        try {
            while (this.LA(1) != '#' || this.LA(2) != '!') {
                this.mLINE(false);
            }
        }
        catch (CharStreamException e) {
        }
        catch (RecognitionException e) {
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
    }

    @Override
    public Token nextToken() throws TokenStreamException {
        try {
            try {
                return this._nextToken();
            }
            catch (RecognitionException e) {
                throw new TokenStreamRecognitionException(e);
            }
        }
        catch (CharStreamException e) {
            if (e instanceof CharStreamIOException) {
                throw new TokenStreamIOException(((CharStreamIOException)e).io);
            }
            throw new TokenStreamException(e.toString());
        }
    }

    SymbolTableManager getSymbolTableManager() {
        return this.stm_;
    }

    private Token getNextTokenFromStream() throws TokenStreamException, RecognitionException, CharStreamException {
        if (this.just_finished_parsing_string_expression_substituation_ || this.just_finished_parsing_regex_expression_substituation_) {
            if (this.current_special_string_delimiter_.empty()) {
                throw new TokenStreamException("Delimiter mismatch!");
            }
            StringDelimiter delimiter = this.current_special_string_delimiter_.peek();
            this.mSTRING_BETWEEN_EXPRESSION_SUBSTITUTION(true, delimiter.getDelimiter(), delimiter.getCount());
            Token t = this._returnToken;
            if (113 == t.getType()) {
                this.current_special_string_delimiter_.pop();
                if (this.just_finished_parsing_regex_expression_substituation_) {
                    this.text.setLength(0);
                    this.mREGEX_MODIFIER(true);
                    String option = this._returnToken.getText();
                    t.setText(t.getText() + "/" + option);
                }
            }
            this.just_finished_parsing_string_expression_substituation_ = false;
            this.just_finished_parsing_regex_expression_substituation_ = false;
            return t;
        }
        if (this.just_finished_parsing_heredoc_expression_substituation_) {
            this.mHERE_DOC_CONTENT(true, this.current_heredoc_delimiter_, 121, 122);
            this.just_finished_parsing_heredoc_expression_substituation_ = false;
            if (122 == this._returnToken.getType()) {
                this.input_.finishedHereDoc();
            }
            return this._returnToken;
        }
        if (118 == this.last_token_.getType()) {
            this.current_heredoc_delimiter_ = this.last_token_.getText();
            this.mHERE_DOC_CONTENT(true, this.current_heredoc_delimiter_, 120, 119);
            if (119 == this._returnToken.getType()) {
                this.input_.finishedHereDoc();
            }
            return this._returnToken;
        }
        return super.nextToken();
    }

    private Token _nextToken() throws TokenStreamException, RecognitionException, CharStreamException {
        Token token = this.getNextTokenFromStream();
        assert (182 != token.getType());
        assert (184 != token.getType());
        assert (180 != token.getType());
        assert (168 != token.getType());
        assert (4 != token.getType());
        assert (-1 != token.getType());
        if (!this.keywordOrOperatorToMethodName(token)) {
            this.changeLexerStateIfNecessary(token);
        }
        this.last_token_ = token;
        this.seen_whitespace_ = false;
        this.just_finished_parsing_symbol_ = false;
        return token;
    }

    private void changeLexerStateIfNecessary(Token token) throws TokenStreamException, CharStreamException {
        switch (token.getType()) {
            case 118: {
                this.input_.skipToLineBreak();
                break;
            }
            case 19: 
            case 20: {
                this.allow_asignment_ = true;
                this.is_in_condition = false;
                break;
            }
            case 34: {
                this.allow_asignment_ = true;
                break;
            }
            case 35: 
            case 37: {
                if (95 == this.last_token_.getType() || 96 == this.last_token_.getType() || 45 == this.last_token_.getType()) break;
                this.updateSymbolTable(token);
                break;
            }
            case 43: {
                if (this.allow_block_parameter_) {
                    this.allow_block_parameter_ = false;
                    break;
                }
                if (this.last_token_.getType() != 26 && this.last_token_.getType() != 41 && this.last_token_.getType() != 20) break;
                this.allow_block_parameter_ = true;
                break;
            }
            case 139: 
            case 143: 
            case 145: {
                this.convertToModifierIfNeeded(token);
                break;
            }
            case 149: 
            case 150: {
                if (this.convertToModifierIfNeeded(token)) break;
                this.is_in_condition = true;
                break;
            }
            case 147: {
                this.is_in_condition = true;
                this.allow_for_expression_parameter_ = true;
                break;
            }
            case 41: {
                if (!this.is_in_condition) break;
                token.setType(160);
                this.is_in_condition = false;
                break;
            }
            case 42: {
                this.allow_asignment_ = true;
                break;
            }
            case 148: {
                this.allow_for_expression_parameter_ = false;
            }
        }
    }

    @Override
    protected void setCurrentSpecialStringDelimiter(char delimiter, int delimiter_count) {
        this.current_special_string_delimiter_.push(new StringDelimiter(delimiter, delimiter_count));
    }

    @Override
    protected void updateCurrentSpecialStringDelimiterCount(int delimiter_count) {
        StringDelimiter delimiter = this.current_special_string_delimiter_.peek();
        delimiter.setCount(delimiter_count);
    }

    void setIsInNestedMultipleAssign(boolean v) {
        this.is_in_nested_multiple_assign_ = v;
    }

    void setJustFinishedParsingStringExpressionSubstituation() {
        this.just_finished_parsing_string_expression_substituation_ = true;
        this.just_finished_parsing_regex_expression_substituation_ = false;
    }

    void setJustFinishedParsingRegexExpressionSubstituation() {
        this.just_finished_parsing_regex_expression_substituation_ = true;
        this.just_finished_parsing_string_expression_substituation_ = false;
    }

    void setJustFinishedParsingHeredocExpressionSubstituation() {
        this.just_finished_parsing_heredoc_expression_substituation_ = true;
    }

    void setLastTokenToBe_RPAREN_IN_METHOD_DEFINATION() {
        assert (34 == this.last_token_.getType());
        this.last_token_.setType(4);
    }

    void setJustFinishedParsingSymbol() {
        this.just_finished_parsing_symbol_ = true;
    }

    @Override
    protected boolean justSeenWhitespace() {
        return this.seen_whitespace_;
    }

    private boolean followedByAssign() throws CharStreamException {
        int i = 0;
        block9: while (true) {
            char c = this.LA(++i);
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block9;
                }
                case ',': {
                    return this.last_token_.getType() != 30 && this.last_token_.getType() != 102;
                }
                case ')': {
                    return this.is_in_nested_multiple_assign_;
                }
                case '=': {
                    return this.LA(i + 1) != '=';
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '^': {
                    return this.LA(i + 1) == '=';
                }
                case '&': 
                case '|': {
                    if (this.LA(i + 1) == '=') {
                        return true;
                    }
                    if ('&' == c && '&' == this.LA(i + 1) && '=' == this.LA(i + 2)) {
                        return true;
                    }
                    if ('|' == c && '|' == this.LA(i + 1) && '=' == this.LA(i + 2)) {
                        return true;
                    }
                    return this.is_in_nested_multiple_assign_;
                }
                case '<': 
                case '>': {
                    if ('<' == c && '<' == this.LA(i + 1) && '=' == this.LA(i + 2)) {
                        return true;
                    }
                    return '>' == c && '>' == this.LA(i + 1) && '=' == this.LA(i + 2);
                }
            }
            break;
        }
        return false;
    }

    private void updateSymbolTable(Token token) throws TokenStreamException, CharStreamException {
        if (151 == this.last_token_.getType() || 152 == this.last_token_.getType()) {
            this.stm_.addVariable(token.getText());
            return;
        }
        if (this.allow_for_expression_parameter_) {
            this.stm_.addVariable(token.getText());
            return;
        }
        if (this.allow_block_parameter_) {
            this.stm_.addVariable(token.getText());
            return;
        }
        if (!this.stm_.isDefinedInCurrentScope(token.getText())) {
            if (this.allow_asignment_ && this.followedByAssign()) {
                this.stm_.addVariable(token.getText());
            } else {
                token.setType(37);
            }
        }
    }

    private boolean expectModifier() {
        switch (this.last_token_.getType()) {
            case 0: 
            case 4: 
            case 19: 
            case 20: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 41: 
            case 45: 
            case 97: 
            case 102: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 157: {
                return false;
            }
        }
        return !this.isOperator(this.last_token_.getType()) || this.just_finished_parsing_symbol_;
    }

    private boolean convertToModifierIfNeeded(Token token) {
        if (this.expectModifier()) {
            switch (token.getType()) {
                case 143: {
                    token.setType(21);
                    break;
                }
                case 145: {
                    token.setType(22);
                    break;
                }
                case 149: {
                    token.setType(23);
                    break;
                }
                case 150: {
                    token.setType(24);
                    break;
                }
                case 139: {
                    token.setType(25);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean keywordOrOperatorToMethodName(Token token) {
        switch (token.getType()) {
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.doNotExpectKeywordAndOperator(token);
            }
        }
        return false;
    }

    private boolean doNotExpectKeywordAndOperator(Token token) {
        switch (this.last_token_.getType()) {
            case 95: 
            case 96: {
                token.setType(35);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setSeenWhitespace() {
        this.seen_whitespace_ = true;
    }

    @Override
    protected boolean expectArrayAccess() {
        switch (this.last_token_.getType()) {
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 98: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 113: 
            case 123: 
            case 130: 
            case 136: {
                return true;
            }
            case 37: 
            case 134: {
                return !this.seen_whitespace_;
            }
        }
        return false;
    }

    @Override
    protected boolean expectHeredoc() {
        switch (this.last_token_.getType()) {
            case 0: 
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 92: 
            case 97: 
            case 102: 
            case 131: 
            case 134: 
            case 137: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 145: 
            case 149: 
            case 150: 
            case 157: 
            case 158: {
                return true;
            }
        }
        return this.isOperator(this.last_token_.getType());
    }

    @Override
    protected boolean expectHash() {
        switch (this.last_token_.getType()) {
            case 0: 
            case 19: 
            case 20: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 92: 
            case 97: 
            case 102: 
            case 137: 
            case 138: 
            case 148: 
            case 158: {
                return true;
            }
        }
        return this.isOperator(this.last_token_.getType());
    }

    @Override
    protected boolean spaceIsNext() throws CharStreamException {
        switch (this.LA(1)) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean expressionSubstitutionIsNext() throws CharStreamException {
        if (this.LA(1) != '#') {
            return false;
        }
        switch (this.LA(2)) {
            case '$': 
            case '@': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    private boolean isOperator(int type) {
        switch (type) {
            case 30: 
            case 31: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean expectLeadingColon2() {
        switch (this.last_token_.getType()) {
            case 19: 
            case 20: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 97: 
            case 137: 
            case 138: {
                return true;
            }
        }
        return this.seen_whitespace_ || this.isOperator(this.last_token_.getType());
    }

    @Override
    protected boolean expectOperator(int k) throws CharStreamException {
        switch (this.last_token_.getType()) {
            case 37: {
                if (this.seen_whitespace_ && ' ' != this.LA(k) && '\t' != this.LA(k)) {
                    return false;
                }
            }
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 95: 
            case 98: 
            case 99: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 136: 
            case 153: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean expectUnary() throws CharStreamException {
        switch (this.last_token_.getType()) {
            case 0: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 92: 
            case 97: 
            case 102: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 143: 
            case 145: 
            case 149: 
            case 150: 
            case 157: 
            case 158: {
                return true;
            }
            case 37: {
                return this.seen_whitespace_ && ' ' != this.LA(1) && '\t' != this.LA(1);
            }
        }
        return this.isOperator(this.last_token_.getType());
    }

    @Override
    protected boolean lastTokenIsDotOrColon2() {
        return 95 == this.last_token_.getType() || 96 == this.last_token_.getType() || 132 == this.last_token_.getType();
    }

    @Override
    protected boolean lastTokenIsSemi() {
        return 95 == this.last_token_.getType();
    }

    @Override
    protected boolean lastTokenIsKeywordDefOrColonWithNoFollowingSpace() {
        return 153 == this.last_token_.getType() || 45 == this.last_token_.getType();
    }

    @Override
    protected boolean lastTokenIsColonWithNoFollowingSpace() {
        return 45 == this.last_token_.getType();
    }

    @Override
    protected boolean shouldIgnoreLinebreak() {
        switch (this.last_token_.getType()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 95: 
            case 97: 
            case 102: 
            case 137: 
            case 138: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isDelimiter(String next_line, String delimiter) {
        boolean r;
        if ('-' == delimiter.charAt(0)) {
            String trimmed_next_line = "-" + next_line.trim();
            r = delimiter.equals(trimmed_next_line);
        } else {
            r = delimiter.equals(next_line);
        }
        return r;
    }

    @Override
    protected boolean isAsciiValueTerminator(char value2) {
        switch (value2) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case ']': 
            case '\uffff': {
                return true;
            }
        }
        return false;
    }

    @Override
    protected int trackDelimiterCount(char next_char, char delimeter, int delimeter_count) {
        if (delimeter == this.translateDelimiter(delimeter)) {
            if (delimeter == next_char) assert (--delimeter_count >= 0);
        } else if (delimeter == next_char) {
            ++delimeter_count;
        } else if (next_char == this.translateDelimiter(delimeter)) assert (--delimeter_count >= 0);
        return delimeter_count;
    }

    private char translateDelimiter(char in) {
        switch (in) {
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '(': {
                return ')';
            }
            case '<': {
                return '>';
            }
        }
        return in;
    }
}

