/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.math.BigDecimal;
import java.math.BigInteger;

@RubyLevelClass(name="Bignum", superclass="Integer")
public class RubyBignum
extends RubyInteger {
    private static final BigInteger FIXNUM_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger FIXNUM_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private BigInteger value_;
    private RubyClass klass;

    RubyBignum(String value2, int radix) {
        this(new BigInteger(value2, radix));
    }

    RubyBignum(String value2) {
        this(new BigInteger(value2));
    }

    RubyBignum(BigInteger value2) {
        this.value_ = value2;
        this.klass = RubyRuntime.BignumClass;
    }

    @Override
    public RubyClass getRubyClass() {
        return this.klass;
    }

    @Override
    public void setRubyClass(RubyClass klass) {
        this.klass = klass;
    }

    @Override
    public int toInt() {
        return this.value_.intValue();
    }

    @Override
    public double toFloat() {
        return this.value_.doubleValue();
    }

    @Override
    public RubyFloat toRubyFloat() {
        return ObjectFactory.createFloat(this.value_.doubleValue());
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(this.value_.toString(10));
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s(RubyValue radix) {
        return ObjectFactory.createString(this.value_.toString(radix.toInt()));
    }

    @RubyLevelMethod(name="to_f")
    public RubyFloat to_f() {
        return ObjectFactory.createFloat(this.value_.doubleValue());
    }

    public BigInteger getInternal() {
        return this.value_;
    }

    public boolean sign() {
        return this.value_.signum() >= 0;
    }

    public long longValue() {
        return this.value_.longValue();
    }

    public void setValue(BigInteger value2) {
        this.value_ = value2;
    }

    @RubyLevelMethod(name="size")
    public RubyFixnum rubySize() {
        return ObjectFactory.createFixnum(this.size());
    }

    public int size() {
        int alignedBytesCount = ((this.value_.bitLength() - 1 & 0xFFFFFFE0) >> 3) + 4;
        return alignedBytesCount;
    }

    @Override
    @RubyLevelMethod(name="coerce")
    public RubyArray coerce(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return new RubyArray(new RubyBignum(BigInteger.valueOf(v.toInt())), (RubyValue)this);
        }
        if (v instanceof RubyBignum) {
            return new RubyArray(v, (RubyValue)this);
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't coerce " + v.getRubyClass().getName() + " to Bignum");
    }

    @Override
    @RubyLevelMethod(name="-@")
    public RubyBignum uminus() {
        return ObjectFactory.createBignum(this.value_.negate());
    }

    @RubyLevelMethod(name="~")
    public RubyValue op_neg() {
        return RubyBignum.bignorm(this.value_.not());
    }

    @RubyLevelMethod(name="+")
    public RubyValue op_add(RubyValue value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            return RubyBignum.bignorm(this.value_.add(bigValue.value_));
        }
        if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            return RubyBignum.bignorm(this.value_.add(bigValue));
        }
        if (value2 instanceof RubyFloat) {
            double ret = this.value_.doubleValue() + value2.toFloat();
            return ObjectFactory.createFloat(ret);
        }
        return this.coerceBin(RubyID.plusID, value2);
    }

    @RubyLevelMethod(name="-")
    public RubyValue op_sub(RubyValue value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            return RubyBignum.bignorm(this.value_.subtract(bigValue.value_));
        }
        if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            return RubyBignum.bignorm(this.value_.subtract(bigValue));
        }
        if (value2 instanceof RubyFloat) {
            double ret = this.value_.doubleValue() - value2.toFloat();
            return ObjectFactory.createFloat(ret);
        }
        return this.coerceBin(RubyID.subID, value2);
    }

    @RubyLevelMethod(name="*")
    public RubyValue op_mul(RubyValue value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            return RubyBignum.bignorm(this.value_.multiply(bigValue.value_));
        }
        if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            return RubyBignum.bignorm(this.value_.multiply(bigValue));
        }
        if (value2 instanceof RubyFloat) {
            double ret = this.value_.doubleValue() * value2.toFloat();
            return ObjectFactory.createFloat(ret);
        }
        return this.coerceBin(RubyID.mulID, value2);
    }

    @RubyLevelMethod(name="/")
    public RubyValue op_div(RubyValue value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            if (bigValue.equals(BigInteger.ZERO)) {
                this.zeroDiv();
            }
            return RubyBignum.bignorm(this.value_.divide(bigValue.value_));
        }
        if (value2 instanceof RubyFixnum) {
            int intValue = value2.toInt();
            if (intValue == 0) {
                this.zeroDiv();
            }
            BigInteger bigValue = BigInteger.valueOf(intValue);
            return RubyBignum.bignorm(this.value_.divide(bigValue));
        }
        if (value2 instanceof RubyFloat) {
            double ret = this.value_.doubleValue() / value2.toFloat();
            return ObjectFactory.createFloat(ret);
        }
        return this.coerceBin(RubyID.divID, value2);
    }

    @RubyLevelMethod(name="quo")
    public RubyValue quo(RubyValue v) {
        double dy;
        double dx = this.value_.doubleValue();
        if (v instanceof RubyFixnum) {
            dy = v.toInt();
        } else if (v instanceof RubyBignum) {
            dy = v.toFloat();
        } else if (v instanceof RubyFloat) {
            dy = v.toFloat();
        } else {
            return this.coerceBin(RubyID.quoID, v);
        }
        return ObjectFactory.createFloat(dx / dy);
    }

    @RubyLevelMethod(name="**")
    public RubyValue pow(RubyValue v) {
        double d;
        if (v instanceof RubyFixnum && v.toInt() == 0) {
            return ObjectFactory.FIXNUM1;
        }
        if (v instanceof RubyFloat) {
            d = v.toFloat();
        } else if (v instanceof RubyBignum) {
            d = v.toFloat();
        } else if (v instanceof RubyFixnum) {
            int yy = v.toInt();
            if (yy > 0 && this.value_.bitLength() * yy <= 0x100000) {
                return RubyBignum.bignorm(this.value_.pow(yy));
            }
            d = yy;
        } else {
            return this.coerceBin(RubyID.powID, v);
        }
        return ObjectFactory.createFloat(Math.pow(this.value_.doubleValue(), d));
    }

    @RubyLevelMethod(name="%")
    public RubyValue op_mod(RubyValue value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            return RubyBignum.bignorm(RubyBignum.ruby_mod(this.value_, bigValue.value_));
        }
        if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            return RubyBignum.bignorm(RubyBignum.ruby_mod(this.value_, bigValue));
        }
        return this.coerceBin(RubyID.modID, value2);
    }

    private static BigInteger ruby_mod(BigInteger a, BigInteger b) {
        BigInteger modValue = a.abs().mod(b.abs());
        if (modValue.signum() == 0) {
            return modValue;
        }
        BigInteger result = modValue;
        if (a.signum() > 0 && b.signum() < 0) {
            result = b.add(modValue);
        }
        if (a.signum() < 0) {
            if (b.signum() > 0) {
                result = b.add(modValue.negate());
            }
            if (b.signum() < 0) {
                result = modValue.negate();
            }
        }
        return result;
    }

    @RubyLevelMethod(name="&")
    public RubyValue op_band(RubyValue value2) {
        BigInteger result;
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            result = this.value_.and(bigValue.value_);
        } else if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            result = this.value_.and(bigValue);
        } else if (value2 instanceof RubyFloat) {
            double floatValue = ((RubyFloat)value2).doubleValue();
            BigInteger bigValue = BigDecimal.valueOf(floatValue).toBigInteger();
            result = this.value_.and(bigValue);
        } else {
            throw new RubyException(RubyRuntime.TypeErrorClass, value2.getRubyClass().toString() + " not expected");
        }
        return RubyBignum.bignorm(result);
    }

    @RubyLevelMethod(name="|")
    public RubyValue op_bor(RubyValue value2) {
        BigInteger result;
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            result = this.value_.or(bigValue.value_);
        } else if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            result = this.value_.or(bigValue);
        } else if (value2 instanceof RubyFloat) {
            double floatValue = ((RubyFloat)value2).doubleValue();
            BigInteger bigValue = BigDecimal.valueOf(floatValue).toBigInteger();
            result = this.value_.or(bigValue);
        } else {
            throw new RubyException(RubyRuntime.TypeErrorClass, value2.getRubyClass().toString() + " not expected");
        }
        return RubyBignum.bignorm(result);
    }

    @RubyLevelMethod(name="^")
    public RubyValue op_bxor(RubyValue value2) {
        BigInteger result;
        if (value2 instanceof RubyBignum) {
            RubyBignum bigValue = (RubyBignum)value2;
            result = this.value_.xor(bigValue.value_);
        } else if (value2 instanceof RubyFixnum) {
            BigInteger bigValue = BigInteger.valueOf(value2.toInt());
            result = this.value_.xor(bigValue);
        } else if (value2 instanceof RubyFloat) {
            double floatValue = ((RubyFloat)value2).doubleValue();
            BigInteger bigValue = BigDecimal.valueOf(floatValue).toBigInteger();
            result = this.value_.xor(bigValue);
        } else {
            throw new RubyException(RubyRuntime.TypeErrorClass, value2.getRubyClass().toString() + " not expected");
        }
        return RubyBignum.bignorm(result);
    }

    @RubyLevelMethod(name="<<")
    public RubyValue lshift(RubyValue v) {
        int shift2 = v.toInt();
        if (shift2 < 0) {
            return this.rshift(RubyBignum.bignorm(-shift2));
        }
        return RubyBignum.bignorm(this.value_.shiftLeft(shift2));
    }

    @RubyLevelMethod(name=">>")
    public RubyValue rshift(RubyValue v) {
        int shift2 = v.toInt();
        if (shift2 < 0) {
            return this.lshift(ObjectFactory.createFixnum(-shift2));
        }
        return RubyBignum.bignorm(this.value_.shiftRight(shift2));
    }

    @RubyLevelMethod(name="[]")
    public RubyFixnum aref(RubyValue v) {
        int index2 = v.toInt();
        return this.value_.testBit(index2) ? ObjectFactory.FIXNUM1 : ObjectFactory.FIXNUM0;
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue cmp(RubyValue v) {
        BigInteger b;
        if (v instanceof RubyFixnum) {
            b = BigInteger.valueOf(v.toInt());
        } else if (v instanceof RubyBignum) {
            b = ((RubyBignum)v).value_;
        } else {
            if (v instanceof RubyFloat) {
                return this.toRubyFloat().cmp(v);
            }
            return this.coerceCmp(RubyID.unequalID, v);
        }
        int result = this.value_.compareTo(b);
        if (result == 0) {
            return ObjectFactory.FIXNUM0;
        }
        if (result > 0) {
            return ObjectFactory.FIXNUM1;
        }
        return ObjectFactory.FIXNUM_NEGATIVE_ONE;
    }

    public static RubyValue bignorm(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return v;
        }
        if (v instanceof RubyBignum) {
            return RubyBignum.bignorm(((RubyBignum)v).value_);
        }
        return v;
    }

    public static RubyInteger bignorm(BigInteger value2) {
        if (value2.compareTo(FIXNUM_MAX) > 0 || value2.compareTo(FIXNUM_MIN) < 0) {
            return ObjectFactory.createBignum(value2);
        }
        return ObjectFactory.createFixnum(value2.intValue());
    }

    public static RubyInteger bignorm(long value2) {
        if (value2 > Integer.MAX_VALUE || value2 < Integer.MIN_VALUE) {
            return ObjectFactory.createBignum(BigInteger.valueOf(value2));
        }
        return ObjectFactory.createFixnum((int)value2);
    }
}

