/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyIO;
import com.xruby.runtime.builtin.RubyIOExecutor;
import com.xruby.runtime.builtin.RubyIOFileExecutor;
import com.xruby.runtime.builtin.RubyTime;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyKernelModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.io.File;
import java.math.BigInteger;

@RubyLevelClass(name="File", superclass="IO")
public class RubyFile
extends RubyIO {
    public RubyFile(String filename, String mode) {
        super(new RubyIOFileExecutor(filename, mode), RubyRuntime.FileClass);
    }

    public RubyFile(RubyIOExecutor executor, RubyClass klass) {
        super(executor, klass);
    }

    @RubyLevelMethod(name="file?", singleton=true)
    public static RubyValue file_question(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        return ObjectFactory.createBoolean(file.isFile());
    }

    @RubyLevelMethod(name="writable?", singleton=true)
    public static RubyValue writable_question(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        return ObjectFactory.createBoolean(file.canWrite());
    }

    @RubyLevelMethod(name="readable?", singleton=true)
    public static RubyValue readable_question(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        return ObjectFactory.createBoolean(file.canRead());
    }

    @RubyLevelMethod(name="exist?", alias={"exists?"}, singleton=true)
    public static RubyValue exist_question(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        return ObjectFactory.createBoolean(file.exists());
    }

    @RubyLevelMethod(name="directory?", singleton=true)
    public static RubyValue directory_question(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        return ObjectFactory.createBoolean(!file.isFile());
    }

    @RubyLevelMethod(name="executable?", singleton=true)
    public static RubyValue executable_question(RubyValue receiver, RubyValue arg) {
        return RubyConstant.QTRUE;
    }

    @RubyLevelMethod(name="expand_path", singleton=true)
    public static RubyValue expand_path(RubyValue receiver) {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (0 for 1)");
    }

    @RubyLevelMethod(name="expand_path", singleton=true)
    public static RubyValue expand_path(RubyValue receiver, RubyArray args) {
        StringBuilder dir_string;
        String file_name = args.get(0).toStr();
        if (file_name.equals(".")) {
            file_name = "";
        }
        if (args.size() == 1) {
            File file = new File(file_name);
            return ObjectFactory.createString(file.getAbsolutePath().replace('\\', '/'));
        }
        if (file_name.startsWith("/")) {
            file_name = ".." + file_name;
        }
        if ((dir_string = new StringBuilder(args.get(1).toStr())).toString().equals("/")) {
            dir_string = new StringBuilder(new File("/").getAbsolutePath().replace('\\', '/'));
        }
        while (file_name.startsWith("../")) {
            int i = dir_string.lastIndexOf("/");
            if (i >= 0) {
                dir_string.delete(i, dir_string.length());
            }
            file_name = file_name.substring(3, file_name.length());
        }
        if (file_name.length() > 0 || dir_string.toString().endsWith(":")) {
            if (!dir_string.toString().endsWith("/")) {
                dir_string.append("/");
            }
            dir_string.append(file_name);
        }
        return ObjectFactory.createString(dir_string.toString().replace('\\', '/'));
    }

    @RubyLevelMethod(name="dirname", singleton=true)
    public static RubyValue dirname(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        String parent = file.getParent();
        if (parent == null) {
            return ObjectFactory.createString(fileName.matches("\\/+") ? "/" : ".");
        }
        return ObjectFactory.createString(parent.replace('\\', '/'));
    }

    @RubyLevelMethod(name="mtime", singleton=true)
    public static RubyValue mtime(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        if (!file.isFile() && !file.isDirectory()) {
            throw new RubyException(RubyRuntime.RuntimeErrorClass, "No such file or directory - " + fileName);
        }
        return ObjectFactory.createTime(file.lastModified());
    }

    @RubyLevelMethod(name="size", singleton=true)
    public static RubyValue size(RubyValue receiver, RubyValue arg) {
        String fileName = arg.toStr();
        File file = new File(fileName);
        if (!file.isFile() && !file.isDirectory()) {
            throw new RubyException(RubyRuntime.RuntimeErrorClass, "No such file or directory - " + fileName);
        }
        return RubyBignum.bignorm(BigInteger.valueOf(file.length()));
    }

    @RubyLevelMethod(name="rename", singleton=true)
    public static RubyValue rename(RubyValue receiver, RubyValue arg1, RubyValue arg2) {
        String file1 = arg1.toStr();
        String file2 = arg2.toStr();
        File file = new File(file1);
        if (!file.isFile() && !file.isDirectory()) {
            throw new RubyException(RubyRuntime.RuntimeErrorClass, "No such file or directory - " + file1);
        }
        return ObjectFactory.createBoolean(file.renameTo(new File(file2)));
    }

    @RubyLevelMethod(name="utime", singleton=true)
    public static RubyValue utime(RubyValue receiver, RubyArray args) {
        if (args.size() < 3) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (" + args.length() + " for 2)");
        }
        RubyTime mtime2 = (RubyTime)args.get(1);
        for (int i = 2; i < args.size(); ++i) {
            String filename = args.get(i).toStr();
            File f = new File(filename);
            f.setLastModified(mtime2.getTime());
        }
        return ObjectFactory.createFixnum(args.size() - 2);
    }

    @RubyLevelMethod(name="truncate")
    public RubyValue truncate(RubyValue arg) {
        this.truncate(arg.toInt());
        return ObjectFactory.FIXNUM0;
    }

    @RubyLevelMethod(name="separator", singleton=true)
    public static RubyValue separator(RubyValue receiver) {
        return ObjectFactory.createString(File.separator);
    }

    @RubyLevelMethod(name="delete", alias={"unlink"}, singleton=true)
    public static RubyValue delete(RubyValue receiver, RubyArray args) {
        int deleted = 0;
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                String fileName = args.get(i).toStr();
                File file = new File(fileName);
                if (file.isDirectory()) {
                    throw new RubyException(RubyRuntime.RuntimeErrorClass, "Is a directory - " + fileName);
                }
                if (file.isFile()) {
                    file.delete();
                    ++deleted;
                    continue;
                }
                throw new RubyException(RubyRuntime.RuntimeErrorClass, "No such file or directory - " + fileName);
            }
        }
        return ObjectFactory.createFixnum(deleted);
    }

    @RubyLevelMethod(name="basename", singleton=true)
    public static RubyValue basename(RubyValue receiver, RubyArray args) {
        String basename2;
        String fileName = args.get(0).toStr();
        if ("".equals(fileName)) {
            basename2 = "";
        } else {
            basename2 = new File(fileName).getName();
            if (0 == basename2.length()) {
                basename2 = "/";
            }
        }
        if (args.size() == 1) {
            return ObjectFactory.createString(basename2);
        }
        String suffix = args.get(1).toStr();
        if (suffix.equals(".*")) {
            int dot_position = basename2.lastIndexOf(46);
            if (dot_position < 0) {
                return ObjectFactory.createString(basename2);
            }
            return ObjectFactory.createString(basename2.substring(0, dot_position));
        }
        if (basename2.endsWith(suffix)) {
            return ObjectFactory.createString(basename2.substring(0, basename2.length() - suffix.length()));
        }
        return ObjectFactory.createString(basename2);
    }

    @RubyLevelMethod(name="open", singleton=true)
    public static RubyValue open(RubyValue receiver, RubyArray args, RubyBlock block) {
        return RubyKernelModule.open(receiver, args, block);
    }
}

