/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyNumeric;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.math.BigDecimal;

@RubyLevelClass(name="Float", superclass="Numeric")
public class RubyFloat
extends RubyNumeric {
    private RubyClass klass;
    private double value_;

    RubyFloat(double value2) {
        this.value_ = value2;
        this.klass = RubyRuntime.FloatClass;
    }

    @Override
    public RubyClass getRubyClass() {
        return this.klass;
    }

    @Override
    public void setRubyClass(RubyClass klass) {
        this.klass = klass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RubyFloat) {
            return ((RubyFloat)o).value_ == this.value_;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return Double.toString(this.value_);
    }

    public double doubleValue() {
        return this.value_;
    }

    @Override
    public int toInt() {
        return (int)this.value_;
    }

    @Override
    public double toFloat() {
        return this.value_;
    }

    @Override
    public RubyFloat toRubyFloat() {
        return this;
    }

    @Override
    public RubyInteger toRubyInteger() {
        return RubyBignum.bignorm((int)this.value_);
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(Double.toString(this.value_));
    }

    @RubyLevelMethod(name="to_i")
    public RubyFixnum to_i() {
        return ObjectFactory.createFixnum((int)this.value_);
    }

    @Override
    @RubyLevelMethod(name="coerce")
    public RubyArray coerce(RubyValue v) {
        return new RubyArray(v.toRubyFloat(), (RubyValue)this);
    }

    @RubyLevelMethod(name="+")
    public RubyValue opPlus(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createFloat(this.value_ + v.toFloat());
        }
        if (v instanceof RubyBignum) {
            return ObjectFactory.createFloat(this.value_ + v.toFloat());
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat(this.value_ + ((RubyFloat)v).value_);
        }
        return this.coerceBin(RubyID.plusID, v);
    }

    @RubyLevelMethod(name="-")
    public RubyValue opMinus(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createFloat(this.value_ - v.toFloat());
        }
        if (v instanceof RubyBignum) {
            return ObjectFactory.createFloat(this.value_ - v.toFloat());
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat(this.value_ - ((RubyFloat)v).value_);
        }
        return this.coerceBin(RubyID.subID, v);
    }

    @RubyLevelMethod(name="*")
    public RubyValue opMul(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createFloat(this.value_ * v.toFloat());
        }
        if (v instanceof RubyBignum) {
            return ObjectFactory.createFloat(this.value_ * v.toFloat());
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat(this.value_ * ((RubyFloat)v).value_);
        }
        return this.coerceBin(RubyID.mulID, v);
    }

    @RubyLevelMethod(name="/")
    public RubyValue opDiv(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createFloat(this.value_ / v.toFloat());
        }
        if (v instanceof RubyBignum) {
            return ObjectFactory.createFloat(this.value_ / v.toFloat());
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat(this.value_ / ((RubyFloat)v).value_);
        }
        return this.coerceBin(RubyID.divID, v);
    }

    @RubyLevelMethod(name="%")
    public RubyValue opMod(RubyValue v) {
        double fy;
        if (v instanceof RubyFixnum) {
            fy = v.toFloat();
        } else if (v instanceof RubyBignum) {
            fy = v.toFloat();
        } else if (v instanceof RubyFloat) {
            fy = ((RubyFloat)v).value_;
        } else {
            return this.coerceBin(RubyID.modID, v);
        }
        return ObjectFactory.createFloat(this.value_ % fy);
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue cmp(RubyValue v) {
        double b;
        double a = this.value_;
        if (v instanceof RubyFixnum) {
            b = v.toFloat();
        } else if (v instanceof RubyBignum) {
            b = v.toFloat();
        } else if (v instanceof RubyFloat) {
            b = ((RubyFloat)v).value_;
        } else {
            return this.coerceCmp(RubyID.unequalID, v);
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return RubyConstant.QNIL;
        }
        if (a == b) {
            return ObjectFactory.FIXNUM0;
        }
        if (a > b) {
            return ObjectFactory.FIXNUM1;
        }
        return ObjectFactory.FIXNUM_NEGATIVE_ONE;
    }

    @RubyLevelMethod(name="floor")
    public RubyInteger floor() {
        return this.createRubyInteger(Math.floor(this.value_));
    }

    @RubyLevelMethod(name="ceil")
    public RubyInteger ceil() {
        return this.createRubyInteger(Math.ceil(this.value_));
    }

    @RubyLevelMethod(name="truncate")
    public RubyInteger truncate() {
        return this.createRubyInteger(this.value_);
    }

    @RubyLevelMethod(name="round")
    public RubyInteger round() {
        return this.createRubyInteger(Math.round(this.value_));
    }

    @RubyLevelMethod(name="abs")
    public RubyFloat abs() {
        return ObjectFactory.createFloat(Math.abs(this.value_));
    }

    private RubyInteger createRubyInteger(double value2) {
        if (value2 <= 2.147483647E9 && value2 >= -2.147483648E9) {
            return ObjectFactory.createFixnum((int)value2);
        }
        return ObjectFactory.createBignum(BigDecimal.valueOf(value2).toBigInteger());
    }

    @RubyLevelMethod(name="finite?")
    public RubyValue finite_p() {
        return ObjectFactory.createBoolean(!Double.isInfinite(this.value_));
    }

    @RubyLevelMethod(name="infinite?")
    public RubyValue infinite_p() {
        if (this.value_ == Double.NEGATIVE_INFINITY) {
            return ObjectFactory.FIXNUM_NEGATIVE_ONE;
        }
        if (this.value_ == Double.POSITIVE_INFINITY) {
            return ObjectFactory.FIXNUM1;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="nan?")
    public RubyValue nan_p() {
        return ObjectFactory.createBoolean(Double.isNaN(this.value_));
    }
}

