/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.RubyIOExecutor;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class RubyIOFileExecutor
implements RubyIOExecutor {
    private RandomAccessFile file_ = null;

    public RubyIOFileExecutor(String filename, String mode) {
        this.open(filename, mode);
    }

    private String translateMode(String mode) {
        if (mode.equals("w")) {
            return "rw";
        }
        if (mode.equals("a")) {
            return "rw";
        }
        if (mode.equals("rb")) {
            return "r";
        }
        if (mode.equals("r+")) {
            return "r";
        }
        return mode;
    }

    private boolean open(String filename, String mode) {
        assert (null == this.file_);
        File f = new File(filename);
        long length2 = f.length();
        try {
            this.file_ = new RandomAccessFile(f, this.translateMode(mode));
            if (mode.equals("w")) {
                this.file_.setLength(0L);
            } else if (mode.equals("a")) {
                this.file_.seek(length2);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            this.file_ = null;
            return false;
        }
    }

    @Override
    public boolean eof() {
        try {
            return this.file_.length() == this.file_.getFilePointer();
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public void close() {
        if (null != this.file_) {
            try {
                this.file_.close();
                this.file_ = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.file_.getChannel().force(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void print(String s) {
        if (null == this.file_) {
            throw new RubyException(RubyRuntime.IOErrorClass, "file is not opened");
        }
        try {
            this.file_.writeBytes(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String readsTheEntireContents() throws IOException {
        int size2 = (int)this.file_.length();
        byte[] buffer = new byte[size2];
        if (this.file_.read(buffer) < 0) {
            return "";
        }
        return new String(buffer);
    }

    private String readUntilSeperator(String separator2) throws IOException {
        String s = this.file_.readLine();
        if (null == s) {
            return null;
        }
        return s + "\n";
    }

    @Override
    public String gets(RubyValue separator2) {
        if (null == this.file_) {
            throw new RubyException(RubyRuntime.IOErrorClass, "file is not opened");
        }
        try {
            if (RubyConstant.QNIL == separator2) {
                return this.readsTheEntireContents();
            }
            if (!(separator2 instanceof RubyString)) {
                throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + separator2.getRubyClass().getName() + " into String");
            }
            RubyString s = (RubyString)separator2;
            return this.readUntilSeperator(s.toString());
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public String read() {
        if (null == this.file_) {
            throw new RubyException(RubyRuntime.IOErrorClass, "file is not opened");
        }
        try {
            return this.readsTheEntireContents();
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public String read(long length2) {
        if (null == this.file_) {
            throw new RubyException(RubyRuntime.IOErrorClass, "file is not opened");
        }
        try {
            long size2 = this.file_.length();
            size2 = Math.min(length2, size2);
            byte[] buffer = new byte[(int)size2];
            if (this.file_.read(buffer) < 0) {
                return null;
            }
            return new String(buffer);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public String read(int length2, int offset) {
        if (null == this.file_) {
            throw new RubyException(RubyRuntime.IOErrorClass, "file is not opened");
        }
        try {
            this.file_.seek(offset);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
        return this.read(length2);
    }

    @Override
    public int write(String s) {
        this.print(s);
        return s.length();
    }

    @Override
    public void truncate(int length2) {
        try {
            this.file_.setLength(length2);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public void seek(long pos2) {
        try {
            this.file_.seek(pos2);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }
}

