/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;

@RubyLevelClass(name="Method")
public class RubyMethodValue
extends RubyBasic {
    private RubyValue receiver_;
    private String name_;
    private RubyMethod method_;

    RubyMethodValue(RubyValue receiver, String name, RubyMethod method) {
        super(RubyRuntime.MethodClass);
        this.receiver_ = receiver;
        this.name_ = name;
        this.method_ = method;
    }

    @RubyLevelMethod(name="call")
    public RubyValue call(RubyArray args, RubyBlock block) {
        return this.method_.invoke(this.receiver_, args, block);
    }

    @RubyLevelMethod(name="to_proc")
    public RubyProc convertToRubyProc() {
        return ObjectFactory.createProc(this.method_.convertToRubyBolck(this.receiver_));
    }

    @RubyLevelMethod(name="arity")
    public RubyFixnum arity() {
        return ObjectFactory.createFixnum(this.method_.arity());
    }

    @RubyLevelMethod(name="bind")
    public RubyMethodValue bind(RubyValue receiver) {
        if (receiver.getRubyClass() != this.receiver_.getRubyClass()) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "bind argument must be an instance of " + this.receiver_.getRubyClass().getName());
        }
        RubyMethodValue m = new RubyMethodValue(receiver, this.name_, this.method_);
        return m;
    }

    @RubyLevelMethod(name="unbind")
    public RubyMethodValue unbind() {
        RubyMethodValue m = new RubyMethodValue(this.receiver_, this.name_, this.method_);
        m.setRubyClass(RubyRuntime.UnboundMethodClass);
        return m;
    }

    @RubyLevelMethod(name="to_s", alias={"inspect"})
    public RubyString to_s() {
        return ObjectFactory.createString(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("#<Method: ");
        s.append(this.receiver_.getRubyClass().getName());
        s.append("#");
        s.append(this.name_);
        s.append(">");
        return s.toString();
    }
}

