/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;

@RubyLevelClass(name="Range")
public class RubyRange
extends RubyBasic {
    private RubyValue begin_;
    private RubyValue end_;
    private boolean exclude_end_;

    RubyRange() {
        super(RubyRuntime.RangeClass);
    }

    public void setValue(RubyValue left, RubyValue right, boolean isExclusive) {
        if (!(left instanceof RubyFixnum) || !(right instanceof RubyFixnum)) {
            try {
                RubyValue result = RubyAPI.callOneArgMethod(left, right, null, RubyID.unequalID);
                if (result == RubyConstant.QNIL) {
                    throw new RubyException(RubyRuntime.ArgumentErrorClass, "bad value for range");
                }
            }
            catch (RubyException e) {
                RubyValue value2 = RubyAPI.convertRubyException2RubyValue(e);
                if (value2.getRubyClass() == RubyRuntime.ArgumentErrorClass) {
                    throw new RubyException(RubyRuntime.ArgumentErrorClass, "bad value for range");
                }
                throw e;
            }
        }
        this.begin_ = left;
        this.end_ = right;
        this.exclude_end_ = isExclusive;
    }

    @RubyAllocMethod
    public static RubyRange alloc(RubyValue receiver) {
        return ObjectFactory.createRange();
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyValue arg0, RubyValue arg1) {
        this.setValue(arg0, arg1, false);
        return this;
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyArray args) {
        RubyValue exclusive;
        RubyValue left = args.get(0);
        RubyValue right = args.get(1);
        boolean isExclusive = false;
        if (args.size() == 3 && (exclusive = args.get(2)) != RubyConstant.QNIL && exclusive != RubyConstant.QFALSE) {
            isExclusive = true;
        }
        this.setValue(left, right, isExclusive);
        return this;
    }

    @RubyLevelMethod(name="begin")
    public RubyValue getLeft() {
        return this.begin_;
    }

    @RubyLevelMethod(name="end")
    public RubyValue getRight() {
        return this.end_;
    }

    @RubyLevelMethod(name="exclude_end?")
    public RubyValue excludeEndP() {
        return ObjectFactory.createBoolean(this.exclude_end_);
    }

    public boolean isExcludeEnd() {
        return this.exclude_end_;
    }

    @RubyLevelMethod(name="to_a")
    public RubyArray to_a() {
        if (this.begin_ instanceof RubyFixnum && this.end_ instanceof RubyFixnum) {
            return this.fixnumRangeToA();
        }
        return this.defaultToA();
    }

    private RubyArray defaultToA() {
        RubyArray a = new RubyArray();
        RubyValue iter = this.begin_;
        while (this.compare(iter, this.end_)) {
            a.add(iter);
            iter = RubyAPI.callPublicNoArgMethod(iter, null, RubyID.succID);
        }
        if (!this.exclude_end_) {
            a.add(iter);
        }
        return a;
    }

    private RubyArray fixnumRangeToA() {
        int left = this.begin_.toInt();
        int right = this.end_.toInt();
        if (!this.exclude_end_) {
            ++right;
        }
        RubyArray a = new RubyArray();
        for (int i = left; i < right; ++i) {
            a.add(ObjectFactory.createFixnum(i));
        }
        return a;
    }

    @RubyLevelMethod(name="hash")
    public RubyFixnum hash() {
        int baseHash = this.exclude_end_ ? 1 : 0;
        int beginHash = RubyAPI.callPublicNoArgMethod(this.begin_, null, RubyID.hashID).toInt();
        int endHash = RubyAPI.callPublicNoArgMethod(this.end_, null, RubyID.hashID).toInt();
        int hash2 = baseHash;
        hash2 ^= beginHash << 1;
        hash2 ^= endHash << 9;
        return ObjectFactory.createFixnum(hash2 ^= baseHash << 24);
    }

    @RubyLevelMethod(name="each")
    public RubyValue each(RubyBlock block) {
        if (this.begin_ instanceof RubyFixnum && this.end_ instanceof RubyFixnum) {
            return this.eachForFixnum(block);
        }
        return this.rangeEach(block);
    }

    private RubyValue eachForFixnum(RubyBlock block) {
        int begin = this.begin_.toInt();
        int limit = this.end_.toInt();
        if (!this.exclude_end_) {
            ++limit;
        }
        for (int i = begin; i < limit; ++i) {
            RubyValue v = block.invoke((RubyValue)this, ObjectFactory.createFixnum(i));
            if (block.breakedOrReturned()) {
                return v;
            }
            if (!block.shouldRetry()) continue;
            i = begin - 1;
        }
        return this;
    }

    private boolean compare(RubyValue value1, RubyValue value2) {
        RubyValue r = RubyAPI.callPublicOneArgMethod(value1, value2, null, RubyID.unequalID);
        return !RubyAPI.testEqual(r, ObjectFactory.FIXNUM0);
    }

    private RubyValue rangeEach(RubyBlock block) {
        RubyValue ite = this.begin_;
        while (true) {
            RubyValue v;
            if (this.compare(ite, this.end_)) {
                v = block.invoke((RubyValue)this, ite);
                if (block.breakedOrReturned()) {
                    return v;
                }
                if (block.shouldRetry()) {
                    ite = this.begin_;
                    continue;
                }
                ite = RubyAPI.callPublicNoArgMethod(ite, null, RubyID.succID);
                continue;
            }
            if (this.exclude_end_) break;
            v = block.invoke((RubyValue)this, ite);
            if (block.breakedOrReturned()) {
                return v;
            }
            if (!block.shouldRetry()) break;
            ite = this.begin_;
        }
        return this;
    }
}

