/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ArrayPacker;
import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyMatchData;
import com.xruby.runtime.builtin.RubyRange;
import com.xruby.runtime.builtin.RubyRegexp;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyKernelModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.StringTokenizer;

@RubyLevelClass(name="String")
public class RubyString
extends RubyBasic {
    private StringBuilder sb_;
    private static Formatter formatter;

    RubyString(RubyClass c, String s) {
        super(c);
        this.sb_ = new StringBuilder(s);
    }

    RubyString(String s) {
        super(RubyRuntime.StringClass);
        this.sb_ = new StringBuilder(s);
    }

    RubyString(StringBuilder sb) {
        super(RubyRuntime.StringClass);
        this.sb_ = sb;
    }

    @Override
    public RubyString clone() {
        RubyString s = (RubyString)super.clone();
        s.sb_ = new StringBuilder(this.sb_);
        return s;
    }

    @Override
    public String toString() {
        return this.sb_.toString();
    }

    @Override
    public int toInt() {
        return Integer.valueOf(this.sb_.toString());
    }

    @Override
    public RubyInteger toRubyInteger() {
        return RubyBignum.bignorm(this.toInt());
    }

    @Override
    public double toFloat() {
        try {
            return Double.parseDouble(this.sb_.toString());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public RubyString toRubyString() {
        return this;
    }

    @Override
    public String toStr() {
        return this.sb_.toString();
    }

    @Override
    public String asString() {
        return this.sb_.toString();
    }

    @Override
    public RubyID toID() {
        return RubyID.intern(this.sb_.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RubyString) {
            RubyString s = (RubyString)obj;
            return this.sb_.toString().equals(s.sb_.toString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.sb_.toString().hashCode();
    }

    public int length() {
        return this.sb_.length();
    }

    public RubyString appendString(String v) {
        this.sb_.append(v);
        return this;
    }

    private RubyString appendString(RubyString v) {
        this.sb_.append((CharSequence)v.sb_);
        return this;
    }

    public RubyString appendString(RubyValue v) {
        if (v instanceof RubyString) {
            return this.appendString((RubyString)v);
        }
        RubyValue r = RubyAPI.callPublicNoArgMethod(v, null, RubyID.toSID);
        return this.appendString((RubyString)r);
    }

    @RubyAllocMethod
    public static RubyString alloc(RubyValue receiver) {
        return ObjectFactory.createString((RubyClass)receiver, "");
    }

    @RubyLevelMethod(name="initialize", alias={"initialize_copy"})
    public RubyString initialize(RubyValue v) {
        this.setString(v.toStr());
        return this;
    }

    @RubyLevelMethod(name="initialize", alias={"initialize_copy"})
    public RubyString initialize() {
        return this;
    }

    @Override
    @RubyLevelMethod(name="to_f")
    public RubyFloat toRubyFloat() {
        double d;
        try {
            d = this.toFloat();
        }
        catch (NumberFormatException e) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, e.toString());
        }
        return ObjectFactory.createFloat(d);
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(this.sb_.toString());
    }

    @RubyLevelMethod(name="length")
    public RubyFixnum rubyLength() {
        return ObjectFactory.createFixnum(this.sb_.length());
    }

    @RubyLevelMethod(name="intern", alias={"to_sym"})
    public RubySymbol intern() {
        if (this.sb_.length() <= 0) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "interning empty string");
        }
        RubyID id = RubyID.intern(this.sb_.toString());
        return id.toSymbol();
    }

    @RubyLevelMethod(name="+")
    public RubyString plus(RubyValue v) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.sb_);
        sb.append((CharSequence)v.toRubyString().sb_);
        return ObjectFactory.createString(sb);
    }

    @RubyLevelMethod(name="concat", alias={"<<"})
    public RubyString concat(RubyValue v) {
        int i;
        if (v instanceof RubyFixnum && (i = v.toInt()) >= 0 && i <= 255) {
            this.sb_.append((char)i);
            return this;
        }
        this.sb_.append((CharSequence)v.toRubyString().sb_);
        return this;
    }

    public RubyString setString(String s) {
        this.sb_.replace(0, this.sb_.length(), s);
        return this;
    }

    private int cmp(RubyString s) {
        int result = this.sb_.toString().compareTo(s.sb_.toString());
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return 1;
        }
        return -1;
    }

    private String replace(String source2, int start2, int end, String replacement) {
        assert (start2 <= source2.length() - 1);
        if (end < start2) {
            end = start2 + 1;
        }
        StringBuffer result = new StringBuffer(source2.substring(0, start2));
        result.append(replacement);
        result.append(source2.substring(end));
        return result.toString();
    }

    private RubyValue substring(String string2, int begin, int end, boolean isExcludeEnd) {
        if (begin < 0) {
            begin = string2.length() + begin;
        }
        if (end < 0) {
            end = string2.length() + end;
        }
        if (!isExcludeEnd) {
            ++end;
        }
        if (begin < 0 || end < 0 || begin > end || begin > string2.length() || end > string2.length()) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString(string2.substring(begin, end));
    }

    private RubyString gsub(RubyString g, RubyArray args) {
        if (null == args || args.size() != 2) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `gsub': wrong number of arguments (" + actual_argc + " for 2)");
        }
        if (!(args.get(1) instanceof RubyString)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "can't convert " + args.get(1).getRubyClass().getName() + " into String");
        }
        RubyString s = (RubyString)args.get(1);
        if (args.get(0) instanceof RubyRegexp) {
            RubyRegexp r = (RubyRegexp)args.get(0);
            return r.gsub(g, s);
        }
        if (args.get(0) instanceof RubyString) {
            RubyString r = (RubyString)args.get(0);
            String result = g.toString().replaceAll(r.toString(), s.toString());
            return ObjectFactory.createString(result);
        }
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
    }

    private RubyString sub(RubyString g, RubyArray args) {
        if (null == args || args.size() != 2) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `sub': wrong number of arguments (" + actual_argc + " for 2)");
        }
        if (!(args.get(1) instanceof RubyString)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "can't convert " + args.get(1).getRubyClass().getName() + " into String");
        }
        RubyString s = (RubyString)args.get(1);
        if (args.get(0) instanceof RubyRegexp) {
            RubyRegexp r = (RubyRegexp)args.get(0);
            return r.sub(g, s);
        }
        if (args.get(0) instanceof RubyString) {
            RubyString r = (RubyString)args.get(0);
            String result = g.toString().replaceFirst(r.toString(), s.toString());
            return ObjectFactory.createString(result);
        }
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
    }

    private Collection<String> split(RubyString s, String delimiter) {
        StringTokenizer t = new StringTokenizer(s.toString(), delimiter);
        int total = t.countTokens();
        ArrayList<String> r = new ArrayList<String>(total);
        for (int i = 0; i < total; ++i) {
            r.add(t.nextToken());
        }
        return r;
    }

    private Collection<String> split(RubyString g, RubyRegexp r, RubyArray args) {
        if (args.size() <= 1) {
            return r.split(g.toString(), 0);
        }
        RubyFixnum i = (RubyFixnum)args.get(1);
        return r.split(g.toString(), i.toInt());
    }

    @RubyLevelMethod(name="==")
    public RubyValue opEqual(RubyValue v) {
        if (this == v) {
            return RubyConstant.QTRUE;
        }
        if (v instanceof RubyString) {
            RubyString str = (RubyString)v;
            if (this.sb_.length() == str.sb_.length() && this.cmp(str) == 0) {
                return RubyConstant.QTRUE;
            }
            return RubyConstant.QFALSE;
        }
        if (v.respondTo(RubyID.toStrID)) {
            return ObjectFactory.createBoolean(v.equals(this));
        }
        return RubyConstant.QFALSE;
    }

    @RubyLevelMethod(name="strip")
    public RubyString strip() {
        return ObjectFactory.createString(this.sb_.toString().trim());
    }

    @RubyLevelMethod(name="lstrip!")
    public RubyValue lstripBang() {
        int i;
        for (i = 0; i < this.sb_.length() && Character.isWhitespace(this.sb_.charAt(i)); ++i) {
        }
        if (0 == i) {
            return RubyConstant.QNIL;
        }
        this.sb_.delete(0, i);
        return this;
    }

    @RubyLevelMethod(name="strip!")
    public RubyValue stripBang() {
        String str = this.sb_.toString();
        int orgSize = str.length();
        str = str.trim();
        this.sb_ = new StringBuilder(str);
        if (str.length() == orgSize) {
            return RubyConstant.QNIL;
        }
        return this;
    }

    @RubyLevelMethod(name="capitalize")
    public RubyString capitalize() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return ObjectFactory.createString();
        }
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        ca[0] = Character.toUpperCase(ca[0]);
        for (int i = 1; i < length2; ++i) {
            ca[i] = Character.toLowerCase(ca[i]);
        }
        return ObjectFactory.createString(new StringBuilder().append(ca));
    }

    @RubyLevelMethod(name="capitalize!")
    public RubyValue capitalizeBang() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return RubyConstant.QNIL;
        }
        boolean modify = false;
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        if (Character.isLowerCase(ca[0])) {
            ca[0] = Character.toUpperCase(ca[0]);
            modify = true;
        }
        for (int i = 1; i < ca.length; ++i) {
            char c = ca[i];
            if (!Character.isUpperCase(c)) continue;
            ca[i] = Character.toLowerCase(c);
            modify = true;
        }
        this.sb_.delete(0, ca.length).append(ca);
        return modify ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="upcase")
    public RubyString upcase() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return ObjectFactory.createString();
        }
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = Character.toUpperCase(ca[i]);
        }
        return ObjectFactory.createString(new StringBuilder().append(ca));
    }

    @RubyLevelMethod(name="upcase!")
    public RubyValue upcaseBang() {
        boolean modify = false;
        int length2 = this.sb_.length();
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        for (int i = 0; i < length2; ++i) {
            char c = ca[i];
            if (!Character.isLowerCase(c)) continue;
            ca[i] = Character.toUpperCase(c);
            modify = true;
        }
        this.sb_.delete(0, ca.length).append(ca);
        return modify ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="downcase")
    public RubyString downcase() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return ObjectFactory.createString();
        }
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = Character.toLowerCase(ca[i]);
        }
        return ObjectFactory.createString(new StringBuilder().append(ca));
    }

    @RubyLevelMethod(name="downcase!")
    public RubyValue downcaseBang() {
        boolean modify = false;
        int length2 = this.sb_.length();
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (!Character.isUpperCase(c)) continue;
            ca[i] = Character.toLowerCase(c);
            modify = true;
        }
        this.sb_.delete(0, ca.length).append(ca);
        return modify ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="reverse!")
    public RubyString reverse_danger() {
        this.sb_.reverse();
        return this;
    }

    private boolean chomp(String seperator) {
        if (!this.sb_.toString().endsWith(seperator)) {
            return false;
        }
        int start2 = this.sb_.length() - seperator.length();
        int end = this.sb_.length();
        this.sb_.delete(start2, end);
        return true;
    }

    @RubyLevelMethod(name="scan")
    public RubyValue scan(RubyValue arg, RubyBlock block) {
        RubyRegexp regex = (RubyRegexp)arg;
        if (null != block) {
            regex.scan(this.sb_.toString(), block);
            return this;
        }
        return regex.scan(this.sb_.toString());
    }

    private boolean transform(String from, String to, boolean remove_duplicate) {
        String oldString = this.sb_.toString();
        if (from.length() == 3 && to.length() == 3 && from.charAt(1) == '-' && to.charAt(1) == '-') {
            char from_start = from.charAt(0);
            char from_end = from.charAt(2);
            char to_start = to.charAt(0);
            char to_end = to.charAt(2);
            char last_char = '\u0000';
            for (int i = 0; i < this.sb_.length(); ++i) {
                char current_char = this.sb_.charAt(i);
                if (current_char < from_start || current_char > from_end) continue;
                if (remove_duplicate && last_char == current_char) {
                    this.sb_.deleteCharAt(i);
                    --i;
                    continue;
                }
                int replace_char = current_char - from_start + to_start;
                this.sb_.setCharAt(i, replace_char < to_end ? (char)replace_char : to_end);
                last_char = current_char;
            }
        } else {
            char last_char = '\u0000';
            for (int i = 0; i < this.sb_.length(); ++i) {
                char current_char = this.sb_.charAt(i);
                int index2 = from.indexOf(current_char);
                if (index2 < 0) continue;
                if (remove_duplicate && last_char == current_char) {
                    this.sb_.deleteCharAt(i);
                    --i;
                    continue;
                }
                char replace_char = to.charAt(index2 < to.length() ? index2 : to.length());
                this.sb_.setCharAt(i, replace_char);
                last_char = current_char;
            }
        }
        return !oldString.equals(this.sb_.toString());
    }

    private boolean tr(String from, String to) {
        return this.transform(from, to, false);
    }

    private boolean tr_s(String from, String to) {
        return this.transform(from, to, true);
    }

    private boolean squeeze(String from) {
        if (null != from && from.length() == 3 && from.charAt(1) == '-') {
            char from_start = from.charAt(0);
            char from_end = from.charAt(2);
            char last_char = '\u0000';
            for (int i = 0; i < this.sb_.length(); ++i) {
                char current_char = this.sb_.charAt(i);
                if (current_char < from_start || current_char > from_end) continue;
                if (last_char == current_char) {
                    this.sb_.deleteCharAt(i);
                    --i;
                    continue;
                }
                last_char = current_char;
            }
            return true;
        }
        return false;
    }

    private boolean delete(String from) {
        if (null != from && from.length() == 3 && from.charAt(1) == '-') {
            char from_start = from.charAt(0);
            char from_end = from.charAt(2);
            for (int i = 0; i < this.sb_.length(); ++i) {
                char current_char = this.sb_.charAt(i);
                if (current_char < from_start || current_char > from_end) continue;
                this.sb_.deleteCharAt(i);
                --i;
            }
            return true;
        }
        boolean changed = false;
        int index2;
        while ((index2 = this.sb_.indexOf(from)) >= 0) {
            this.sb_.delete(index2, index2 + from.length());
            changed = true;
        }
        return changed;
    }

    private int count(String s) {
        int n = 0;
        for (int i = 0; i < this.sb_.length(); ++i) {
            if (s.indexOf(this.sb_.charAt(i)) < 0) continue;
            ++n;
        }
        return n;
    }

    @RubyLevelMethod(name="swapcase")
    public RubyString swapcase() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return ObjectFactory.createString();
        }
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        for (int i = 0; i < length2; ++i) {
            char c = ca[i];
            if (Character.isUpperCase(c)) {
                ca[i] = Character.toLowerCase(c);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            ca[i] = Character.toUpperCase(c);
        }
        return ObjectFactory.createString(new StringBuilder().append(ca));
    }

    @RubyLevelMethod(name="swapcase!")
    public RubyValue swapcaseBang() {
        int length2 = this.sb_.length();
        if (length2 == 0) {
            return RubyConstant.QNIL;
        }
        char[] ca = new char[length2];
        this.sb_.getChars(0, length2, ca, 0);
        boolean modify = false;
        for (int i = 0; i < length2; ++i) {
            char c = ca[i];
            if (Character.isUpperCase(c)) {
                ca[i] = Character.toLowerCase(c);
                modify = true;
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            ca[i] = Character.toUpperCase(c);
            modify = true;
        }
        this.sb_.delete(0, ca.length).append(ca);
        return modify ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="chop")
    public RubyValue chop() {
        RubyString rs = this.clone();
        rs.chopBang();
        return rs;
    }

    @RubyLevelMethod(name="chop!")
    public RubyValue chopBang() {
        int length2 = this.sb_.length();
        if (length2 > 0) {
            int orgLength = length2--;
            if (this.sb_.charAt(length2) == '\n' && length2 > 0 && this.sb_.charAt(length2 - 1) == '\r') {
                --length2;
            }
            this.sb_.delete(length2, orgLength);
        }
        return RubyConstant.QNIL;
    }

    private boolean isEvstr(char c, int current2, int end) {
        return current2 < end && c == '$' && c == '@' && c == '{';
    }

    private boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private boolean isPrint(char c) {
        return this.isAscii(c) && c > '\u001f';
    }

    private String formatForDump(String format2, char c) {
        if (formatter == null) {
            formatter = new Formatter();
        }
        return formatter.format(format2, Character.valueOf(c)).toString();
    }

    public String dump() {
        int length2 = this.sb_.length();
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        for (int i = 0; i < length2; ++i) {
            char c = this.sb_.charAt(i);
            if (c == '\"' || c == '\\') {
                buf.append('\\');
                buf.append(c);
                continue;
            }
            if (c == '#') {
                if (this.isEvstr(c, i, length2 - 1)) {
                    buf.append('\\');
                }
                buf.append('#');
                continue;
            }
            if (this.isPrint(c)) {
                buf.append(c);
                continue;
            }
            if (c == '\n') {
                buf.append('\\');
                buf.append('n');
                continue;
            }
            if (c == '\r') {
                buf.append('\\');
                buf.append('r');
                continue;
            }
            if (c == '\t') {
                buf.append('\\');
                buf.append('t');
                continue;
            }
            if (c == '\f') {
                buf.append('\\');
                buf.append('f');
                continue;
            }
            if (c == '\u000b') {
                buf.append('\\');
                buf.append('v');
                continue;
            }
            if (c == '\b') {
                buf.append('\\');
                buf.append('b');
                continue;
            }
            if (c == '\u0007') {
                buf.append('\\');
                buf.append('a');
                continue;
            }
            if (c == '\u001b') {
                buf.append('\\');
                buf.append('e');
                continue;
            }
            buf.append('\\');
            buf.append(this.formatForDump("%03o", c));
        }
        buf.append('\"');
        return buf.toString();
    }

    @RubyLevelMethod(name="dump")
    public RubyString rubyDump() {
        return ObjectFactory.createString(this.dump());
    }

    @RubyLevelMethod(name="each", alias={"each_line"})
    public RubyValue each(RubyBlock block) {
        block.invoke((RubyValue)this, this);
        return this;
    }

    @RubyLevelMethod(name="to_i")
    public RubyValue to_i() {
        return this.to_i(10);
    }

    @RubyLevelMethod(name="to_i")
    public RubyValue to_i(RubyValue arg) {
        return this.to_i(arg.toInt());
    }

    private RubyValue to_i(int radix) {
        String value2 = this.toString();
        value2 = value2.replaceAll("[^+\\-a-zA-Z0-9]", "");
        int end = value2.indexOf(43, 1);
        int end1 = value2.indexOf(45, 1);
        if (end < 0) {
            end = end1 < 0 ? value2.length() : end1;
        } else if (end1 >= 0) {
            end = Math.min(end, end1);
        }
        value2 = value2.substring(0, end);
        if (radix >= 2 && radix <= 36) {
            BigInteger bigint;
            try {
                bigint = new BigInteger(value2, radix);
            }
            catch (NumberFormatException e) {
                return ObjectFactory.FIXNUM0;
            }
            return RubyBignum.bignorm(bigint);
        }
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "illegal radix " + radix);
    }

    @RubyLevelMethod(name="hex")
    public RubyValue hex() {
        String s = this.toString();
        if (s.startsWith("0x")) {
            s = s.substring("0x".length());
        }
        try {
            return ObjectFactory.createFixnum(Integer.valueOf(s, 16));
        }
        catch (NumberFormatException e) {
            return ObjectFactory.FIXNUM0;
        }
    }

    @RubyLevelMethod(name="gsub")
    public RubyValue gsub(RubyArray args, RubyBlock block) {
        if (null == block) {
            return this.gsub(this, args);
        }
        if (null == args || args.size() != 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `gsub': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubyRegexp)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
        }
        RubyRegexp r = (RubyRegexp)args.get(0);
        return r.gsub(this, block);
    }

    @RubyLevelMethod(name="gsub!")
    public RubyValue gsub_danger(RubyArray args, RubyBlock block) {
        if (null == block) {
            RubyString result = this.gsub(this, args);
            if (result == this) {
                return RubyConstant.QNIL;
            }
            return this.setString(result.toString());
        }
        if (null == args || args.size() != 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `gsub!': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubyRegexp)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
        }
        RubyRegexp r = (RubyRegexp)args.get(0);
        return this.setString(r.gsub(this, block).toString());
    }

    @RubyLevelMethod(name="sub")
    public RubyValue sub(RubyArray args, RubyBlock block) {
        if (null == block) {
            return this.sub(this, args);
        }
        if (null == args || args.size() != 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `sub': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubyRegexp)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
        }
        RubyRegexp r = (RubyRegexp)args.get(0);
        return r.sub(this, block);
    }

    @RubyLevelMethod(name="sub!")
    public RubyValue sub_danger(RubyArray args, RubyBlock block) {
        if (null == block) {
            RubyString result = this.sub(this, args);
            if (result == this) {
                return RubyConstant.QNIL;
            }
            return this.setString(result.toString());
        }
        if (null == args || args.size() != 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `sub!': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubyRegexp)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + args.get(0).getRubyClass().getName() + " (expected Regexp)");
        }
        RubyRegexp r = (RubyRegexp)args.get(0);
        return this.setString(r.sub(this, block).toString());
    }

    @RubyLevelMethod(name="split")
    public RubyValue split(RubyArray args) {
        Collection<String> splitResult;
        RubyValue r;
        RubyValue rubyValue = r = null == args ? GlobalVariables.get("$;") : args.get(0);
        if (r == RubyConstant.QNIL) {
            splitResult = this.split(this, " ");
        } else if (r instanceof RubyRegexp) {
            splitResult = this.split(this, (RubyRegexp)r, args);
        } else if (r instanceof RubyString) {
            splitResult = this.split(this, ((RubyString)r).toString());
        } else {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong argument type " + r.getRubyClass() + " (expected Regexp)");
        }
        RubyArray a = new RubyArray(splitResult.size());
        int i = 0;
        for (String str : splitResult) {
            if (0 != i || !str.equals("")) {
                a.add(ObjectFactory.createString(str));
            }
            ++i;
        }
        return a;
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue operator_compare(RubyValue arg) {
        if (!(arg instanceof RubyString)) {
            return RubyConstant.QNIL;
        }
        RubyString value2 = (RubyString)arg;
        int compare2 = this.toString().compareTo(value2.toString());
        if (compare2 > 0) {
            compare2 = 1;
        } else if (compare2 < 0) {
            compare2 = -1;
        }
        return ObjectFactory.createFixnum(compare2);
    }

    @RubyLevelMethod(name="casecmp")
    RubyValue run(RubyValue arg) {
        if (!(arg instanceof RubyString)) {
            return RubyConstant.QNIL;
        }
        RubyString value2 = (RubyString)arg;
        int compare2 = this.toString().toUpperCase().compareTo(value2.toString().toUpperCase());
        if (compare2 > 0) {
            compare2 = 1;
        } else if (compare2 < 0) {
            compare2 = -1;
        }
        return ObjectFactory.createFixnum(compare2);
    }

    @RubyLevelMethod(name="=~")
    public RubyValue operator_match(RubyValue arg) {
        if (arg instanceof RubyRegexp) {
            RubyRegexp reg = (RubyRegexp)arg;
            int p2 = reg.matchPosition(this.toString());
            if (p2 >= 0) {
                return ObjectFactory.createFixnum(p2);
            }
            return RubyConstant.QNIL;
        }
        return RubyAPI.callPublicOneArgMethod(arg, this, null, RubyID.matchID);
    }

    @RubyLevelMethod(name="[]")
    public RubyValue array_access(RubyArray args) {
        String string2 = this.toString();
        if (args.size() == 1) {
            RubyValue arg = args.get(0);
            if (arg instanceof RubyString) {
                String str = ((RubyString)arg).toString();
                if (string2.indexOf(str) >= 0) {
                    return ObjectFactory.createString(str);
                }
                return RubyConstant.QNIL;
            }
            if (arg instanceof RubyRange) {
                RubyRange range = (RubyRange)arg;
                int start2 = range.getLeft().toInt();
                int end = range.getRight().toInt();
                return this.substring(string2, start2, end, range.isExcludeEnd());
            }
            if (arg instanceof RubyRegexp) {
                RubyRegexp regexp = (RubyRegexp)arg;
                RubyMatchData match2 = regexp.match(string2);
                if (match2 != null) {
                    return ObjectFactory.createString(match2.toString());
                }
                return RubyConstant.QNIL;
            }
            int index2 = arg.toInt();
            if (index2 < 0) {
                index2 = string2.length() + index2;
            }
            if (index2 < 0 || index2 >= string2.length()) {
                return RubyConstant.QNIL;
            }
            return ObjectFactory.createFixnum(string2.charAt(index2));
        }
        int start3 = args.get(0).toInt();
        int length2 = args.get(1).toInt() - 1;
        return this.substring(string2, start3, start3 + length2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RubyLevelMethod(name="[]=")
    public RubyValue array_set(RubyArray args) {
        int end;
        int start2;
        String replacement;
        String string2 = this.toString();
        if (args.size() == 2) {
            RubyValue arg = args.get(0);
            replacement = ((RubyString)args.get(1)).toString();
            if (arg instanceof RubyString) {
                String str = ((RubyString)arg).toString();
                start2 = string2.indexOf(str);
                if (start2 < 0) throw new RubyException(RubyRuntime.IndexErrorClass, "string not matched");
                end = start2 + str.length();
            } else if (arg instanceof RubyRange) {
                RubyRange range = (RubyRange)arg;
                start2 = range.getLeft().toInt();
                end = range.getRight().toInt();
                if (start2 >= string2.length()) {
                    throw new RubyException(RubyRuntime.RangeClass, range.toString() + " out of range");
                }
            } else if (arg instanceof RubyRegexp) {
                RubyRegexp regexp = (RubyRegexp)arg;
                RubyMatchData match2 = regexp.match(string2);
                if (match2 == null) throw new RubyException(RubyRuntime.IndexErrorClass, "regexp not matched");
                String matched = match2.toString();
                start2 = string2.indexOf(matched);
                end = matched.length() + start2;
            } else {
                start2 = arg.toInt();
                end = start2 + 1;
            }
        } else {
            replacement = ((RubyString)args.get(2)).toString();
            start2 = args.get(0).toInt();
            end = args.get(1).toInt() + start2;
            if (start2 >= string2.length()) {
                throw new RubyException(RubyRuntime.RangeClass, String.format("index %d out of string", start2));
            }
        }
        this.setString(this.replace(string2, start2, end, replacement));
        return ObjectFactory.createString(replacement);
    }

    @RubyLevelMethod(name="%")
    public RubyValue format(RubyValue arg) {
        String format2 = this.toString();
        String s = arg instanceof RubyArray ? String.format(format2, RubyKernelModule.buildFormatArg((RubyArray)arg, 0)) : String.format(format2, RubyKernelModule.buildFormatArg(new RubyArray(arg), 0));
        return ObjectFactory.createString(s);
    }

    @RubyLevelMethod(name="*")
    public RubyValue operator_star(RubyValue arg) {
        String string2 = this.toString();
        int count2 = arg.toInt();
        if (count2 < 0) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "negative argument");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count2; ++i) {
            result.append(string2);
        }
        return ObjectFactory.createString(result);
    }

    @RubyLevelMethod(name="each_byte")
    public RubyValue each_byte(RubyBlock block) {
        String string2 = this.toString();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            block.invoke((RubyValue)this, ObjectFactory.createFixnum(c));
        }
        return this;
    }

    @RubyLevelMethod(name="reverse")
    public RubyValue reverse() {
        RubyString string2 = ObjectFactory.createString(this.toString());
        return string2.reverse_danger();
    }

    @RubyLevelMethod(name="chomp")
    public RubyValue chomp(RubyArray args) {
        RubyString string2 = ObjectFactory.createString(this.toString());
        RubyValue separator2 = null != args ? args.get(0) : GlobalVariables.get("$/");
        string2.chomp(((RubyString)separator2).toString());
        return string2;
    }

    @RubyLevelMethod(name="chomp!")
    public RubyValue chomp_danger(RubyArray args) {
        RubyValue separator2;
        RubyValue rubyValue = separator2 = null == args ? GlobalVariables.get("$/") : args.get(0);
        if (this.chomp(((RubyString)separator2).toString())) {
            return this;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="tr!")
    public RubyValue tr_danger(RubyValue arg1, RubyValue arg2) {
        RubyString from = (RubyString)arg1;
        RubyString to = (RubyString)arg2;
        return this.tr(from.toString(), to.toString()) ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="tr")
    public RubyValue tr(RubyValue arg1, RubyValue arg2) {
        RubyString from = (RubyString)arg1;
        RubyString to = (RubyString)arg2;
        this.tr(from.toString(), to.toString());
        return this;
    }

    @RubyLevelMethod(name="tr_s!")
    public RubyValue trs_danger(RubyValue arg1, RubyValue arg2) {
        RubyString from = (RubyString)arg1;
        RubyString to = (RubyString)arg2;
        return this.tr_s(from.toString(), to.toString()) ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="tr_s")
    public RubyValue tr_s(RubyValue arg1, RubyValue arg2) {
        RubyString string2 = ObjectFactory.createString(this.toString());
        RubyString from = (RubyString)arg1;
        RubyString to = (RubyString)arg2;
        string2.tr_s(from.toString(), to.toString());
        return string2;
    }

    @RubyLevelMethod(name="squeeze!")
    public RubyValue squeeze_danger(RubyArray args) {
        String arg = null == args ? null : ((RubyString)args.get(0)).toString();
        return this.squeeze(arg) ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="squeeze")
    public RubyValue squeeze(RubyArray args) {
        RubyString string2 = ObjectFactory.createString(this.toString());
        String arg = null == args ? null : ((RubyString)args.get(0)).toString();
        string2.squeeze(arg);
        return string2;
    }

    @RubyLevelMethod(name="delete!")
    public RubyValue delete_danger(RubyArray args) {
        if (null == args) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments");
        }
        String arg = ((RubyString)args.get(0)).toString();
        return this.delete(arg) ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="delete")
    public RubyValue delete(RubyArray args) {
        if (null == args) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments");
        }
        RubyString string2 = ObjectFactory.createString(this.toString());
        String arg = ((RubyString)args.get(0)).toString();
        string2.delete(arg);
        return string2;
    }

    @RubyLevelMethod(name="count")
    public RubyValue count(RubyArray args) {
        if (null == args) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments");
        }
        int n = 0;
        for (RubyValue v : args) {
            RubyString other_str = (RubyString)v;
            n += this.count(other_str.toString());
        }
        return ObjectFactory.createFixnum(n);
    }

    @RubyLevelMethod(name="unpack")
    public RubyValue unpack(RubyValue arg) {
        RubyString format2 = (RubyString)arg;
        return ArrayPacker.unpack(this.toString(), format2.toString());
    }
}

