/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

@RubyLevelClass(name="Time")
public class RubyTime
extends RubyBasic {
    private final Calendar date_;

    private RubyTime(Calendar date) {
        super(RubyRuntime.TimeClass);
        this.date_ = date;
    }

    RubyTime(long time) {
        super(RubyRuntime.TimeClass);
        this.date_ = Calendar.getInstance();
        this.date_.setTimeInMillis(time);
    }

    RubyTime() {
        super(RubyRuntime.TimeClass);
        this.date_ = Calendar.getInstance();
    }

    @RubyAllocMethod
    public static RubyTime alloc(RubyValue receiver) {
        return ObjectFactory.createTime();
    }

    public final long getTime() {
        return this.date_.getTimeInMillis();
    }

    private final int getUsec() {
        long t = this.getTime();
        if (t > 0L && t < 1000L) {
            return (int)(t * 1000L);
        }
        float t1 = (float)t / 1000.0f;
        float t2 = (long)t1;
        return (int)((t1 - t2) * 1000000.0f);
    }

    @Override
    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        sdf.setCalendar(this.date_);
        return sdf.format(this.date_.getTime()).replace("GMT", "UTC");
    }

    @RubyLevelMethod(name="year")
    public RubyValue year() {
        return ObjectFactory.createFixnum(this.date_.get(1));
    }

    @RubyLevelMethod(name="month")
    public RubyValue month() {
        return ObjectFactory.createFixnum(this.date_.get(2) + 1);
    }

    @RubyLevelMethod(name="day")
    public RubyValue day() {
        return ObjectFactory.createFixnum(this.date_.get(5));
    }

    @RubyLevelMethod(name="to_f")
    public RubyFloat to_f() {
        return ObjectFactory.createFloat((double)this.getTime() / 1000.0);
    }

    @RubyLevelMethod(name="to_i", alias={"tv_sec"})
    public RubyFixnum to_i() {
        return ObjectFactory.createFixnum((int)(this.getTime() / 1000L));
    }

    @RubyLevelMethod(name="usec", alias={"tv_usec"})
    public RubyFixnum usec() {
        return ObjectFactory.createFixnum(this.getUsec());
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(this.toString());
    }

    @RubyLevelMethod(name="+")
    public RubyTime plus(RubyValue value2) {
        double timeAdd = value2.toFloat();
        return ObjectFactory.createTime(this.getTime() + (long)(timeAdd * 1000.0));
    }

    @RubyLevelMethod(name="-")
    public RubyValue minus(RubyValue value2) {
        if (value2 instanceof RubyTime) {
            RubyTime time2 = (RubyTime)value2;
            long timeInteval = this.getTime() - time2.getTime();
            if (timeInteval % 1000L == 0L) {
                return ObjectFactory.createFixnum((int)(timeInteval / 1000L));
            }
            return ObjectFactory.createFloat((double)timeInteval / 1000.0);
        }
        double time = value2.toFloat();
        return ObjectFactory.createTime(this.getTime() - (long)(time * 1000.0));
    }

    @RubyLevelMethod(name="<=>")
    public RubyFixnum cmp(RubyValue value2) {
        long time2;
        long time1 = this.getTime();
        if (time1 < (time2 = RubyTypesUtil.convertToTime(value2).getTime())) {
            return ObjectFactory.FIXNUM_NEGATIVE_ONE;
        }
        if (time1 > time2) {
            return ObjectFactory.FIXNUM1;
        }
        return ObjectFactory.FIXNUM0;
    }

    @RubyLevelMethod(name="zone")
    public RubyString zone() {
        String name = this.date_.getTimeZone().getDisplayName(false, 0, Locale.US);
        if (name.equals("GMT")) {
            name = "UTC";
        }
        return ObjectFactory.createString(name);
    }

    @RubyLevelMethod(name="utc", alias={"gm"})
    public static RubyTime utc(RubyValue receiver, RubyArray args) {
        return RubyTime.createTime(args, TimeZone.getTimeZone("GMT"));
    }

    @RubyLevelMethod(name="gmt?")
    public RubyValue gmt_question() {
        return ObjectFactory.createBoolean(this.date_.getTimeZone().hasSameRules(TimeZone.getTimeZone("GMT")));
    }

    @RubyLevelMethod(name="localtime")
    public RubyValue localtime() {
        this.date_.setTimeZone(TimeZone.getDefault());
        return this;
    }

    @RubyLevelMethod(name="mktime", alias={"local"})
    public static RubyTime local(RubyValue receiver, RubyArray args) {
        return RubyTime.createTime(args, TimeZone.getDefault());
    }

    private static RubyTime createTime(RubyArray args, TimeZone zone2) {
        if (null == args || args.size() == 0) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (0 for 1)");
        }
        int i = 0;
        int year2 = ((RubyFixnum)args.get(i++)).toInt();
        int month2 = args.size() <= i ? 0 : ((RubyFixnum)args.get(i++)).toInt();
        int day2 = args.size() <= i ? 0 : ((RubyFixnum)args.get(i++)).toInt();
        int hour = args.size() <= i ? 0 : ((RubyFixnum)args.get(i++)).toInt();
        int min = args.size() <= i ? 0 : ((RubyFixnum)args.get(i++)).toInt();
        int sec = args.size() <= i ? 0 : ((RubyFixnum)args.get(i++)).toInt();
        Calendar calendar = Calendar.getInstance(zone2);
        calendar.set(year2, month2 - 1, day2, hour, min, sec);
        return new RubyTime(calendar);
    }

    @RubyLevelMethod(name="at")
    public static RubyTime at(RubyValue receiver, RubyValue value2) {
        double time = 0.0;
        if (value2 instanceof RubyFixnum) {
            time = value2.toInt();
        } else if (value2 instanceof RubyBignum) {
            time = value2.toFloat();
        } else if (value2 instanceof RubyFloat) {
            time = value2.toFloat();
        } else {
            throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + value2.getRubyClass().getName() + " into Time");
        }
        return ObjectFactory.createTime((long)(time * 1000.0));
    }

    @RubyLevelMethod(name="now")
    public static RubyValue now(RubyValue receiver, RubyArray args, RubyBlock block) {
        RubyClass r = (RubyClass)receiver;
        return r.newInstance(args, block);
    }
}

