/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.javasupport;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.javasupport.JavaClass;
import com.xruby.runtime.javasupport.RubyJavaObject;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public class JavaUtil {
    public static RubyValue convertToRubyValue(Object value2) {
        if (null == value2) {
            return RubyConstant.QNIL;
        }
        if (value2.getClass().equals(Integer.class) || value2.getClass().equals(Byte.class) || value2.getClass().equals(Short.class)) {
            int tmpVal = value2 instanceof Integer ? (Integer)value2 : (value2 instanceof Byte ? (int)((Byte)value2).byteValue() : (int)((Short)value2).shortValue());
            return ObjectFactory.createFixnum(tmpVal);
        }
        if (value2.getClass().equals(Double.class)) {
            return ObjectFactory.createFloat((Double)value2);
        }
        if (value2.getClass().equals(Float.class)) {
            return ObjectFactory.createFloat(((Float)value2).floatValue());
        }
        if (value2.getClass().equals(Boolean.class)) {
            return ObjectFactory.createBoolean(value2.equals(true));
        }
        if (value2.getClass().equals(BigInteger.class)) {
            return ObjectFactory.createBignum((BigInteger)value2);
        }
        if (value2.getClass().equals(String.class)) {
            return ObjectFactory.createString((String)value2);
        }
        if (value2.getClass().isArray()) {
            RubyArray array = new RubyArray();
            for (Object o : (Object[])value2) {
                array.add(JavaUtil.convertToRubyValue(o));
            }
            return array;
        }
        return new RubyJavaObject<Object>(JavaClass.createJavaClass(value2.getClass()), value2);
    }

    public static RubyArray convertToRubyValues(Object[] values2) {
        if (null == values2) {
            return new RubyArray(0);
        }
        int size2 = values2.length;
        RubyArray retArray = new RubyArray(size2);
        for (int i = 0; i < size2; ++i) {
            Object obj = values2[i];
            RubyValue value2 = JavaUtil.convertToRubyValue(obj);
            retArray.add(value2);
        }
        return retArray;
    }

    public static Object convertToJavaValue(RubyValue value2) {
        RubyClass klass;
        boolean flag = false;
        if (value2 instanceof JavaClass) {
            klass = (JavaClass)value2;
        } else {
            klass = value2.getRubyClass();
            flag = true;
        }
        String className = klass.getName();
        if (className.equals("String")) {
            return ((RubyString)value2).toString();
        }
        if (className.equals("Fixnum")) {
            int tmpVal = ((RubyFixnum)value2).toInt();
            if (tmpVal <= 127 && tmpVal >= -128) {
                return (byte)tmpVal;
            }
            if (tmpVal <= Short.MAX_VALUE && tmpVal >= Short.MIN_VALUE) {
                return (short)tmpVal;
            }
            return tmpVal;
        }
        if (className.equals("Bignum")) {
            return ((RubyBignum)value2).getInternal();
        }
        if (className.equals("TrueClass")) {
            return true;
        }
        if (className.equals("FalseClass")) {
            return false;
        }
        if (className.equals("NilClass")) {
            return null;
        }
        if (className.equals("Symbol")) {
            return ((RubySymbol)value2).toString();
        }
        if (className.equals("Exception")) {
            return new Exception(value2.toString());
        }
        if (className.equals("Float")) {
            return ((RubyFloat)value2).doubleValue();
        }
        if (className.equals("Array")) {
            RubyArray array = (RubyArray)value2;
            boolean first2 = true;
            Object[] objs = null;
            int i = 0;
            Iterator<RubyValue> iterator = array.iterator();
            while (iterator.hasNext()) {
                Object obj = JavaUtil.convertToJavaValue(iterator.next());
                if (first2) {
                    objs = (Object[])Array.newInstance(obj.getClass(), array.size());
                    first2 = false;
                }
                objs[i++] = obj;
            }
            return objs;
        }
        if (className.equals("Regexp")) {
            // empty if block
        }
        while (!klass.getName().equals("Object")) {
            if (klass instanceof JavaClass) {
                final RubyValue tmp = value2;
                Class clazz = ((JavaClass)klass).getOriginJavaClass();
                if (clazz.isInterface()) {
                    if (flag) {
                        return Proxy.newProxyInstance(JavaUtil.class.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                                return RubyAPI.callPublicMethod(tmp, JavaUtil.convertToRubyValues(nargs), null, RubyID.intern(method.getName()));
                            }
                        });
                    }
                    return clazz;
                }
                return ((JavaClass)klass).getOriginJavaClass();
            }
            klass = klass.getSuperClass();
        }
        if (value2 instanceof RubyJavaObject) {
            return ((RubyJavaObject)value2).getData();
        }
        throw new IllegalArgumentException("Ruby type " + className + " couldn't be passed to java method");
    }

    public static Object[] convertToJavaValues(RubyArray array) {
        if (null == array) {
            return new Object[0];
        }
        int size2 = array.size();
        Object[] retValues = new Object[size2];
        for (int i = 0; i < size2; ++i) {
            Object obj;
            RubyValue value2 = array.get(i);
            retValues[i] = obj = JavaUtil.convertToJavaValue(value2);
        }
        return retValues;
    }

    private static String[] collectTypes(RubyArray args) {
        String[] tmp = new String[50];
        int i = 0;
        for (RubyValue value2 : args) {
            String className;
            if (value2 instanceof JavaClass) {
                className = "java.lang.Class";
            } else {
                RubyClass klass = value2.getRubyClass();
                className = klass.getName();
                while (!klass.getName().equals("Object")) {
                    if (klass instanceof JavaClass) {
                        className = ((JavaClass)klass).getOriginJavaClass().getName();
                        break;
                    }
                    klass = klass.getSuperClass();
                }
            }
            tmp[i] = className;
            ++i;
        }
        String[] types = new String[i];
        System.arraycopy(tmp, 0, types, 0, i);
        return types;
    }

    private static boolean matchNativeTye(String type, Class clazz) {
        if (type.equals("String") && clazz.equals(String.class)) {
            return true;
        }
        if (type.equals("Fixnum")) {
            if (clazz.equals(Integer.class)) {
                return true;
            }
            if (clazz.isPrimitive() && (clazz.equals(Integer.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE))) {
                return true;
            }
        }
        if (type.equals("Bignum") && clazz.equals(BigInteger.class)) {
            return true;
        }
        if (type.equals("TrueClass") && clazz.equals(Boolean.class)) {
            return true;
        }
        if (type.equals("FalseClass") && clazz.equals(Boolean.class)) {
            return true;
        }
        return type.equals(clazz.getName());
    }

    public static Method matchMethod(List<Method> methods, RubyArray args) {
        String[] types = JavaUtil.collectTypes(args);
        for (Method method : methods) {
            Class<?>[] params = method.getParameterTypes();
            boolean match2 = true;
            for (int i = 0; i < types.length && match2; ++i) {
                if (JavaUtil.matchNativeTye(types[i], params[i])) continue;
                match2 = false;
            }
            if (!match2) continue;
            return method;
        }
        throw new RubyException("Couldn't find method ");
    }

    public static Constructor matchInitMethod(List<Constructor> methods, RubyArray args) {
        String[] types = JavaUtil.collectTypes(args);
        for (Constructor method : methods) {
            Class<?>[] params = method.getParameterTypes();
            boolean match2 = true;
            for (int i = 0; i < types.length && match2; ++i) {
                if (JavaUtil.matchNativeTye(types[i], params[i])) continue;
                match2 = false;
            }
            if (!match2) continue;
            return method;
        }
        throw new RubyException("Couldn't find method ");
    }
}

