/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyRuntime;

class MethodCache {
    private static int CACHE_SIZE = 2048;
    private static int CACHE_MASK = 2047;
    private CacheEntry[] cache = this.clearCache();

    MethodCache() {
    }

    public void reset() {
        if (!RubyRuntime.running) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            this.cache[i].klass = null;
            this.cache[i].mid = null;
            this.cache[i].method = null;
        }
    }

    private CacheEntry[] clearCache() {
        CacheEntry[] cache = new CacheEntry[CACHE_SIZE];
        for (int i = 0; i < CACHE_SIZE; ++i) {
            cache[i] = new CacheEntry();
            cache[i].klass = null;
            cache[i].mid = null;
            cache[i].method = null;
        }
        return cache;
    }

    private int cacheIndex(RubyClass c, RubyID id) {
        return (c.objectAddress() >> 3 ^ (int)id.getId()) & CACHE_MASK;
    }

    public CacheEntry getMethod(RubyClass c, RubyID id) {
        int index2 = this.cacheIndex(c, id);
        return this.cache[index2];
    }

    public void putMethod(RubyClass c, RubyID id, RubyMethod m) {
        int index2 = this.cacheIndex(c, id);
        this.cache[index2].klass = c;
        this.cache[index2].mid = id;
        this.cache[index2].method = m;
    }

    public void removeMethod(RubyClass c, RubyID id) {
        if (!RubyRuntime.running) {
            return;
        }
        for (CacheEntry entry : this.cache) {
            if (entry.mid != id || entry.klass != c) continue;
            entry.mid = null;
        }
    }

    public void removeMethod(RubyID id) {
        if (!RubyRuntime.running) {
            return;
        }
        for (CacheEntry entry : this.cache) {
            if (entry.mid != id) continue;
            entry.mid = null;
        }
    }

    public void removeClass(RubyClass c) {
        if (!RubyRuntime.running) {
            return;
        }
        for (CacheEntry entry : this.cache) {
            if (entry.klass != c) continue;
            entry.mid = null;
        }
    }

    static class CacheEntry {
        public RubyClass klass;
        public RubyID mid;
        public RubyMethod method;

        CacheEntry() {
        }
    }
}

