/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyMethodValue;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.javasupport.JavaClass;
import com.xruby.runtime.lang.ClassFactory;
import com.xruby.runtime.lang.MethodBlockBase;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyExceptionValue;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.UndefMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RubyAPI {
    private static final RubyID ASERT = RubyID.intern("[]=");

    public static RubyClass defineClass(String name, RubyClass superclass2) {
        return ClassFactory.defineClass(name, superclass2);
    }

    public static RubyClass defineClass(String name, RubyValue superclass2) {
        if (null != superclass2 && !(superclass2 instanceof RubyClass)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "superclass must be a Class (" + superclass2.getRubyClass().getName() + " given)");
        }
        RubyValue value2 = RubyRuntime.ObjectClass.getConstant(name);
        if (value2 != null) {
            if (!(value2 instanceof RubyClass)) {
                throw new RubyException(RubyRuntime.TypeErrorClass, name + " is not a class");
            }
            RubyClass klass = (RubyClass)value2;
            if (superclass2 != null && superclass2 != klass.getSuperClass().getRealClass()) {
                throw new RubyException(RubyRuntime.TypeErrorClass, "superclass mismatch for class " + name);
            }
            klass.setAccessPublic();
            return klass;
        }
        return RubyAPI.defineClass(name, null == superclass2 ? null : (RubyClass)superclass2);
    }

    public static RubyModule defineModule(String name) {
        return ClassFactory.defineModule(name);
    }

    public static boolean testCaseEqual(RubyValue value1, RubyValue value2) {
        return RubyAPI.callPublicOneArgMethod(value1, value2, null, RubyID.longEqualID).isTrue();
    }

    public static boolean testCaseEqualNotNil(RubyValue value1, RubyValue value2) {
        return value1.isTrue();
    }

    public static boolean testCaseEqual(RubyArray values2, RubyValue value2) {
        for (RubyValue value1 : values2) {
            if (!RubyAPI.callPublicOneArgMethod(value1, value2, null, RubyID.longEqualID).isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean testEqual(RubyValue value1, RubyValue value2) {
        return RubyAPI.callPublicOneArgMethod(value1, value2, null, RubyID.equalID).isTrue();
    }

    public static boolean testExceptionType(RubyArray classes_to_compare, RubyException e) {
        RubyExceptionValue value2 = e.getRubyValue();
        for (RubyValue class_to_compare : classes_to_compare) {
            if (!RubyAPI.isKindOf(class_to_compare, value2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKindOf(RubyValue class_to_compare, RubyValue value2) {
        if (class_to_compare == value2) {
            return true;
        }
        if (!(class_to_compare instanceof RubyModule)) {
            return false;
        }
        return value2.getRubyClass().isKindOf((RubyModule)class_to_compare);
    }

    public static RubyValue isDefinedSuperMethod(RubyValue receiver, String method_name, RubyMethod current_method) {
        RubyID mid;
        RubyClass c = (RubyClass)current_method.getScope();
        RubyMethod m = c.findSuperMethod(mid = RubyID.intern(method_name));
        if (null == m || UndefMethod.isUndef(m)) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("super");
    }

    public static RubyValue isDefinedPublicMethod(RubyValue receiver, RubyModule owner, String method_name) {
        if (receiver.getRubyClass() == owner) {
            return RubyAPI.isDefinedMethod(receiver, method_name);
        }
        RubyID mid = RubyID.intern(method_name);
        RubyMethod m = receiver.findPublicMethod(mid);
        if (null == m || UndefMethod.isUndef(m)) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("method");
    }

    public static RubyValue isDefinedMethod(RubyValue receiver, String method_name) {
        RubyID mid = RubyID.intern(method_name);
        RubyMethod m = receiver.findMethod(mid);
        if (null == m || UndefMethod.isUndef(m)) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("method");
    }

    public static RubyValue isDefinedInstanceVariable(RubyValue receiver, String method_name) {
        RubyID mid = RubyID.intern(method_name);
        RubyValue var = receiver.getInstanceVariable(mid);
        if (null == var || var == RubyConstant.QNIL) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("instance-variable");
    }

    public static RubyValue isDefinedYield(RubyBlock block) {
        if (null == block) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("yield");
    }

    private static RubyValue callMethodMissing(RubyValue receiver, RubyArray args, RubyBlock block, RubyID mid) {
        RubyMethod m = receiver.findMethod(RubyID.methodMissingId);
        if (null != m && !UndefMethod.isUndef(m)) {
            if (null == args) {
                args = new RubyArray(ObjectFactory.createSymbol(mid));
            } else {
                args.insert(0, ObjectFactory.createSymbol(mid));
            }
            return m.invoke(receiver, args, block);
        }
        RubyClass klass = receiver.getRubyClass();
        klass = klass != null ? klass.getRealClass() : null;
        throw new RubyException(RubyRuntime.NoMethodErrorClass, "undefined method '" + mid.toString() + "' for " + klass.getName());
    }

    public static RubyValue callMethod(RubyValue receiver, RubyArray args, RubyBlock block, RubyID mid) {
        assert (null == args || args.size() > 1);
        RubyMethod m = receiver.findMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, args, block);
        }
        return RubyAPI.callMethodMissing(receiver, args, block, mid);
    }

    public static RubyValue callNoArgMethod(RubyValue receiver, RubyBlock block, RubyID mid) {
        RubyMethod m = receiver.findMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, block);
        }
        return RubyAPI.callMethodMissing(receiver, null, block, mid);
    }

    public static RubyValue callOneArgMethod(RubyValue receiver, RubyValue arg, RubyBlock block, RubyID mid) {
        assert (null != arg);
        RubyMethod m = receiver.findMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, arg, block);
        }
        return RubyAPI.callMethodMissing(receiver, new RubyArray(arg), block, mid);
    }

    public static RubyValue callTwoArgMethod(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block, RubyID mid) {
        assert (null != arg0 && null != arg1);
        RubyMethod m = receiver.findMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, arg0, arg1, block);
        }
        return RubyAPI.callMethodMissing(receiver, new RubyArray(arg0, arg1), block, mid);
    }

    public static RubyValue callPublicNoArgMethod(RubyValue receiver, RubyBlock block, RubyID mid) {
        RubyMethod m = receiver.findPublicMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, block);
        }
        return RubyAPI.callMethodMissing(receiver, null, block, mid);
    }

    public static RubyValue callPublicOneArgMethod(RubyValue receiver, RubyValue arg, RubyBlock block, RubyID mid) {
        assert (null != arg);
        RubyMethod m = receiver.findPublicMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, arg, block);
        }
        return RubyAPI.callMethodMissing(receiver, new RubyArray(arg), block, mid);
    }

    public static RubyValue callPublicTwoArgMethod(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block, RubyID mid) {
        assert (null != arg0 && null != arg1);
        RubyMethod m = receiver.findPublicMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, arg0, arg1, block);
        }
        return RubyAPI.callMethodMissing(receiver, new RubyArray(arg0, arg1), block, mid);
    }

    public static RubyValue callPublicMethod(RubyValue receiver, RubyArray args, RubyBlock block, RubyID mid) {
        assert (null == args || args.size() > 1);
        RubyMethod m = receiver.findPublicMethod(mid);
        if (null != m && !UndefMethod.isUndef(m)) {
            return m.invoke(receiver, args, block);
        }
        return RubyAPI.callMethodMissing(receiver, args, block, mid);
    }

    public static RubyValue callSuperNoArgMethod(RubyValue receiver, RubyBlock block, MethodBlockBase mbb) {
        RubyClass c = (RubyClass)mbb.getScope();
        RubyMethod m = c.findSuperMethod(mbb.getID());
        if (null == m || UndefMethod.isUndef(m)) {
            throw new RubyException(RubyRuntime.NoMethodErrorClass, "super method '" + mbb.getID() + "' can not be found in '" + c.getName() + "'");
        }
        return m.invoke(receiver, block);
    }

    public static RubyValue callSuperOneArgMethod(RubyValue receiver, RubyValue arg, RubyBlock block, MethodBlockBase mbb) {
        assert (null != arg);
        RubyClass c = (RubyClass)mbb.getScope();
        RubyMethod m = c.findSuperMethod(mbb.getID());
        if (null == m || UndefMethod.isUndef(m)) {
            throw new RubyException(RubyRuntime.NoMethodErrorClass, "super method '" + mbb.getID() + "' can not be found in '" + c.getName() + "'");
        }
        return m.invoke(receiver, arg, block);
    }

    public static RubyValue callSuperTwoArgMethod(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block, MethodBlockBase mbb) {
        assert (null != arg0 && null != arg1);
        RubyClass c = (RubyClass)mbb.getScope();
        RubyMethod m = c.findSuperMethod(mbb.getID());
        if (null == m || UndefMethod.isUndef(m)) {
            throw new RubyException(RubyRuntime.NoMethodErrorClass, "super method '" + mbb.getID() + "' can not be found in '" + c.getName() + "'");
        }
        return m.invoke(receiver, arg0, arg1, block);
    }

    public static RubyValue callSuperMethod(RubyValue receiver, RubyArray args, RubyBlock block, MethodBlockBase mbb) {
        assert (null == args || args.size() > 1);
        RubyClass c = (RubyClass)mbb.getScope();
        RubyMethod m = c.findSuperMethod(mbb.getID());
        if (null == m || UndefMethod.isUndef(m)) {
            throw new RubyException(RubyRuntime.NoMethodErrorClass, "super method '" + mbb.getID() + "' can not be found in '" + c.getName() + "'");
        }
        return m.invoke(receiver, args, block);
    }

    public static RubyValue operatorNot(RubyValue value2) {
        return value2.isTrue() ? RubyConstant.QFALSE : RubyConstant.QTRUE;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0;
    }

    public static RubyValue runCommandAndCaptureOutput(String value2) {
        String[] cmdarray = new String[3];
        cmdarray[2] = value2;
        if (RubyAPI.isWindows()) {
            cmdarray[0] = "cmd";
            cmdarray[1] = "/c";
        } else {
            cmdarray[0] = "/bin/sh";
            cmdarray[1] = "-c";
        }
        try {
            int c;
            Process p2 = Runtime.getRuntime().exec(cmdarray);
            StringBuilder output = new StringBuilder();
            BufferedReader stderr = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
            while ((c = stderr.read()) != -1) {
                if (c == 13) continue;
                output.append((char)c);
            }
            stderr.close();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            while ((c = stdout.read()) != -1) {
                if (c == 13) continue;
                output.append((char)c);
            }
            stdout.close();
            return ObjectFactory.createString(output);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.ExceptionClass, e.toString());
        }
    }

    public static RubyValue expandArrayIfThereIsZeroOrOneValue(RubyArray a) {
        if (a.size() <= 1) {
            return a.get(0);
        }
        return a;
    }

    public static RubyValue expandArrayIfThereIsZeroOrOneValue(RubyValue v) {
        RubyArray a;
        if (v instanceof RubyArray && (a = (RubyArray)v).isSingleAsterisk()) {
            return RubyAPI.expandArrayIfThereIsZeroOrOneValue(a);
        }
        return v;
    }

    public static RubyArray expandArrayIfThereIsOnlyOneRubyArray(RubyArray a) {
        if (a.size() == 1 && a.isSingleRhs() && a.get(0) instanceof RubyArray) {
            return (RubyArray)a.get(0);
        }
        return a;
    }

    public static RubyArray convertToArrayIfNotYet(RubyValue v) {
        if (v instanceof RubyArray) {
            return (RubyArray)v;
        }
        return new RubyArray(v);
    }

    public static RubyBlock convertRubyValue2RubyBlock(RubyValue v) {
        if (RubyConstant.QNIL == v) {
            return null;
        }
        if (v instanceof RubyMethodValue) {
            return ((RubyMethodValue)v).convertToRubyProc().getBlock();
        }
        if (v instanceof RubyProc) {
            return ((RubyProc)v).getBlock();
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "wrong argument type " + v.getRubyClass().getName() + " (expected Proc) ");
    }

    public static RubyValue convertRubyException2RubyValue(RubyException e) {
        return e.getRubyValue();
    }

    public static RubyValue setTopLevelConstant(RubyValue value2, String name) {
        return RubyRuntime.ObjectClass.setConstant(name, value2);
    }

    public static RubyValue getCurrentNamespaceConstant(RubyModule receiver, String name) {
        RubyValue v = receiver.getConstant(name);
        if (null != v) {
            return v;
        }
        v = RubyRuntime.ObjectClass.getConstant(name);
        if (null == v) {
            if (RubyRuntime.javaIsSupported()) {
                for (String pkgName : JavaClass.getPackeageList()) {
                    try {
                        Class<?> clazz = Class.forName(pkgName + "." + name);
                        return JavaClass.createJavaClass(clazz);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
            }
            RubyAPI.throwUninitializedConstant(receiver, name);
        }
        return v;
    }

    public static RubyValue isDefinedCurrentNamespaceConstant(RubyValue receiver, String name) {
        RubyValue v = ((RubyModule)receiver).getConstant(name);
        if (null == v) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createString("constant");
    }

    public static RubyValue getConstant(RubyValue receiver, String name) {
        RubyAPI.throwTypeErrorIfNotClassModule(receiver);
        RubyModule m = (RubyModule)receiver;
        RubyValue v = m.getConstant(name);
        if (null == v) {
            RubyAPI.throwUninitializedConstant(m, name);
        }
        return v;
    }

    private static void throwUninitializedConstant(RubyModule m, String name) {
        RubyString str = ObjectFactory.createString();
        if (m != RubyRuntime.ObjectClass) {
            m.to_s(str);
            if (str.length() > 0) {
                str.appendString("::");
            }
        }
        str.appendString(name);
        throw new RubyException(RubyRuntime.NameErrorClass, "uninitialized constant " + str.toString());
    }

    public static RubyValue setConstant(RubyValue value2, RubyValue receiver, String name) {
        RubyAPI.throwTypeErrorIfNotClassModule(receiver);
        return ((RubyModule)receiver).setConstant(name, value2);
    }

    private static void throwTypeErrorIfNotClassModule(RubyValue receiver) {
        if (!(receiver instanceof RubyClass) && !(receiver instanceof RubyModule)) {
            RubyValue v = RubyAPI.callPublicNoArgMethod(receiver, null, RubyID.toSID);
            String s = v.toString();
            throw new RubyException(RubyRuntime.TypeErrorClass, s + " is not a class/module");
        }
    }

    public static void callArraySet(RubyValue value2, RubyValue index2, RubyValue receiver) {
        RubyAPI.callPublicTwoArgMethod(receiver, index2, value2, null, ASERT);
    }

    public static RubyValue initializeAsteriskParameter(RubyArray args, int argc) {
        if (null == args) {
            return new RubyArray();
        }
        return args.collect(argc);
    }

    public static RubyValue initializeBlockParameter(RubyBlock block) {
        if (null == block) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createProc(block);
    }
}

