/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import java.util.ArrayList;
import java.util.List;

public class RubyBinding
extends RubyBasic {
    private RubyModule scope_;
    private RubyValue self_;
    private RubyBlock block_;
    private RubyArray variables_ = new RubyArray();
    private List<String> names_ = new ArrayList<String>();

    public RubyBinding(RubyClass c) {
        super(c);
    }

    public RubyBinding() {
        super(RubyRuntime.BindingClass);
    }

    @Override
    public RubyValue clone() {
        RubyBinding cl = new RubyBinding(this.class_);
        cl.doClone((RubyValue)this);
        return cl;
    }

    @Override
    protected void doClone(RubyValue orig) {
        RubyBinding cl = (RubyBinding)orig;
        this.scope_ = (RubyModule)cl.scope_.clone();
        this.self_ = cl.self_.clone();
        this.block_ = cl.block_;
        this.variables_ = cl.variables_.clone();
        this.names_ = new ArrayList<String>(cl.names_);
        super.doClone(orig);
    }

    public boolean hasName(String name) {
        return this.names_.indexOf(name) >= 0;
    }

    public RubyBinding setScope(RubyModule scope) {
        this.scope_ = scope;
        return this;
    }

    public RubyBinding setSelf(RubyValue self) {
        this.self_ = self;
        return this;
    }

    public RubyValue getSelf() {
        return this.self_;
    }

    public RubyBinding setBlock(RubyBlock block) {
        this.block_ = block;
        return this;
    }

    public RubyBlock getBlock() {
        return this.block_;
    }

    public RubyModule getScope() {
        return this.scope_;
    }

    public void addVariableName(String name) {
        if (this.names_.indexOf(name) < 0) {
            this.names_.add(name);
        }
    }

    public RubyBinding addVariable(String name, RubyValue value2) {
        int i = this.names_.indexOf(name);
        if (i < 0) {
            this.names_.add(name);
            this.variables_.add(value2);
        } else {
            this.variables_.set(i, value2);
        }
        return this;
    }

    public RubyArray getVariables() {
        return this.variables_;
    }

    public List<String> getVariableNames() {
        return this.names_;
    }

    protected RubyValue getVariable(String name) {
        int i = this.names_.indexOf(name);
        if (i < 0) {
            return null;
        }
        return this.variables_.get(i);
    }
}

