/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.xruby.compiler.RubyCompiler;
import com.xruby.compiler.codegen.CompilationResults;
import com.xruby.compiler.codegen.NameFactory;
import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyIO;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyThread;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.javasupport.JavaClass;
import com.xruby.runtime.lang.AtExitBlocks;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBinding;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyExceptionValue;
import com.xruby.runtime.lang.RubyExceptionValueForThrow;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyProgram;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import com.xruby.runtime.lang.annotation.RubyLevelModule;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.regex.Pattern;

@RubyLevelModule(name="Kernel")
public class RubyKernelModule {
    private static BufferedReader in_ = new BufferedReader(new InputStreamReader(System.in));
    private static Pattern packagePattern = Pattern.compile("\\.");
    private static int RDWR = 2;
    private static int CREAT = 256;
    private static int EXCL = 1024;

    @RubyLevelMethod(name="==", alias={"equal?", "eql?"})
    public static RubyValue opEqual(RubyValue receiver, RubyValue arg) {
        return ObjectFactory.createBoolean(receiver == arg);
    }

    @RubyLevelMethod(name="===")
    public static RubyValue objEqual(RubyValue receiver, RubyValue arg) {
        if (receiver == arg) {
            return RubyConstant.QTRUE;
        }
        boolean result = RubyAPI.callPublicOneArgMethod(receiver, arg, null, RubyID.equalID).isTrue();
        return ObjectFactory.createBoolean(result);
    }

    @RubyLevelMethod(name="class")
    public static RubyValue objRubyClass(RubyValue receiver) {
        RubyClass klass = receiver.getRubyClass();
        return klass != null ? klass.getRealClass() : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="clone", alias={"dup"})
    public static RubyValue objClone(RubyValue receiver) {
        return receiver.clone();
    }

    @RubyLevelMethod(name="to_s")
    public static RubyValue anyObjToS(RubyValue receiver) {
        String className = receiver.getRubyClass().getName();
        return ObjectFactory.createString("#<" + className + ":0x" + Integer.toHexString(receiver.hashCode()) + "x>");
    }

    @RubyLevelMethod(name="inspect")
    public static RubyValue objInsepct(RubyValue receiver) {
        return ObjectFactory.createString(receiver.inspect());
    }

    @RubyLevelMethod(name="methods")
    public static RubyValue objMethods(RubyValue receiver) {
        RubyArray a = new RubyArray();
        RubyClass klass = receiver.getRubyClass();
        klass.collectClassMethodNames(a, 4);
        return a;
    }

    @RubyLevelMethod(name="singleton_methods")
    public static RubyValue objSingletonMethods(RubyValue receiver) {
        return RubyKernelModule.objSingletonMethod(receiver, true);
    }

    @RubyLevelMethod(name="singleton_methods")
    public static RubyValue objSingletonMethods(RubyValue receiver, RubyValue arg) {
        return RubyKernelModule.objSingletonMethod(receiver, arg.isTrue());
    }

    private static RubyValue objSingletonMethod(RubyValue receiver, boolean all) {
        RubyArray a = new RubyArray();
        if (receiver.getRubyClass().isSingleton()) {
            RubyClass rubyClass = receiver.getRubyClass();
            rubyClass.collectOwnMethodNames(a, 0);
            if (all) {
                for (rubyClass = rubyClass.getSuperClass(); rubyClass != null && rubyClass.isSingleton(); rubyClass = rubyClass.getSuperClass()) {
                    rubyClass.collectOwnMethodNames(a, 0);
                }
            }
        }
        return a;
    }

    @RubyLevelMethod(name="raise", alias={"fail"})
    public static RubyValue raise(RubyValue value2, RubyArray args) {
        RubyExceptionValue e;
        if (null == args) {
            RubyValue v = GlobalVariables.get("$!");
            e = RubyConstant.QNIL == v ? new RubyExceptionValue(RubyRuntime.RuntimeErrorClass, "") : (RubyExceptionValue)v;
        } else if (1 == args.size() && args.get(0) instanceof RubyString) {
            e = new RubyExceptionValue(RubyRuntime.RuntimeErrorClass, ((RubyString)args.get(0)).toString());
        } else if (args.get(0) instanceof RubyExceptionValue) {
            e = (RubyExceptionValue)args.get(0);
            if (args.size() > 1) {
                e.setMessage(((RubyString)args.get(1)).toString());
            }
        } else {
            RubyClass v = (RubyClass)args.get(0);
            e = new RubyExceptionValue(v, 1 == args.size() ? "" : ((RubyString)args.get(1)).toString());
        }
        throw new RubyException(e);
    }

    @RubyLevelMethod(name="exit", module=true)
    public static RubyValue exit(RubyValue receiver) {
        System.exit(0);
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="exit", module=true)
    public static RubyValue exit(RubyValue receiver, RubyValue arg) {
        int status2 = arg == RubyConstant.QTRUE ? 0 : (arg == RubyConstant.QFALSE ? 1 : arg.toInt());
        System.exit(status2);
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="loop", module=true)
    public static RubyValue loop(RubyValue receiver, RubyArray args, RubyBlock block) {
        RubyValue v;
        if (null == block) {
            throw new RubyException(RubyRuntime.LocalJumpErrorClass, "in `loop': no block given");
        }
        do {
            v = block.invoke(receiver, args);
        } while (!block.breakedOrReturned());
        return v;
    }

    @RubyLevelMethod(name="kind_of?", alias={"is_a?"})
    public static RubyValue kindOf(RubyValue receiver, RubyValue arg) {
        return ObjectFactory.createBoolean(RubyAPI.isKindOf(arg, receiver));
    }

    @RubyLevelMethod(name="instance_of?")
    public static RubyValue instanceOf(RubyValue receiver, RubyValue arg) {
        return ObjectFactory.createBoolean(receiver.getRubyClass().getRealClass() == arg);
    }

    @RubyLevelMethod(name="respond_to?")
    public static RubyValue respond_to(RubyValue receiver, RubyArray args) {
        if (null == args || args.size() < 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `respond_to': wrong number of arguments (" + actual_argc + " for 1)");
        }
        boolean include_private = RubyConstant.QTRUE == args.get(1);
        RubyID mid = RubyID.intern(args.get(0).toStr());
        return ObjectFactory.createBoolean(RubyKernelModule.hasMethod(receiver, mid, include_private));
    }

    private static boolean hasMethod(RubyValue receiver, RubyID mid, boolean include_private) {
        if (include_private) {
            return null != receiver.findMethod(mid);
        }
        return null != receiver.findPublicMethod(mid);
    }

    @RubyLevelMethod(name="send", alias={"__send__"})
    public static RubyValue send(RubyValue receiver, RubyBlock block) {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "no method name given");
    }

    @RubyLevelMethod(name="send", alias={"__send__"})
    public static RubyValue send(RubyValue receiver, RubyValue value2, RubyBlock block) {
        RubyID mid = RubyID.intern(value2.toStr());
        return RubyAPI.callNoArgMethod(receiver, block, mid);
    }

    @RubyLevelMethod(name="send", alias={"__send__"})
    public static RubyValue send(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block) {
        RubyID mid = RubyID.intern(arg0.toStr());
        return RubyAPI.callOneArgMethod(receiver, arg1, block, mid);
    }

    @RubyLevelMethod(name="send", alias={"__send__"})
    public static RubyValue send(RubyValue receiver, RubyArray args, RubyBlock block) {
        RubyValue method_name = args.delete_at(0);
        RubyID mid = RubyID.intern(method_name.toStr());
        return RubyAPI.callMethod(receiver, args, block, mid);
    }

    @RubyLevelMethod(name="instance_eval")
    public static RubyValue instanceEval(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (null == args && null == block) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "block not supplied");
        }
        if (null != args) {
            RubyBinding binding2 = new RubyBinding();
            System.out.println(receiver);
            binding2.setScope((RubyModule)receiver);
            binding2.setSelf(receiver);
            return RubyKernelModule.eval(args.get(0).toStr(), binding2);
        }
        block.setSelf(receiver);
        return block.invoke(receiver);
    }

    private static RubyValue eval(String evalText) {
        RubyCompiler compiler = new RubyCompiler();
        try {
            CompilationResults codes = compiler.compileString(evalText);
            RubyProgram p2 = codes.getRubyProgram();
            return p2.invoke();
        }
        catch (RecognitionException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, e.toString());
        }
        catch (TokenStreamException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, e.toString());
        }
        catch (InstantiationException e) {
            throw new RubyException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RubyException(e.toString());
        }
    }

    public static RubyValue eval(String evalText, RubyBinding binding2) {
        RubyCompiler compiler = new RubyCompiler();
        try {
            CompilationResults codes = compiler.compileString(evalText);
            RubyProgram p2 = codes.getRubyProgram();
            return p2.invoke(binding2.getSelf(), binding2.getVariables(), binding2.getBlock(), binding2.getScope());
        }
        catch (RecognitionException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, e.toString());
        }
        catch (TokenStreamException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, e.toString());
        }
        catch (InstantiationException e) {
            throw new RubyException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RubyException(e.toString());
        }
    }

    private static RubyValue eval(String evalText, RubyBinding binding2, String file_name) {
        RubyCompiler compiler = new RubyCompiler(binding2, false);
        try {
            CompilationResults codes = compiler.compileString(file_name, evalText);
            RubyProgram p2 = codes.getRubyProgram();
            if (null != binding2) {
                return p2.invoke(binding2.getSelf(), binding2.getVariables(), binding2.getBlock(), binding2.getScope());
            }
            return p2.invoke();
        }
        catch (RecognitionException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, file_name + " " + e.toString());
        }
        catch (TokenStreamException e) {
            throw new RubyException(RubyRuntime.SyntaxErrorClass, file_name + " " + e.toString());
        }
        catch (InstantiationException e) {
            throw new RubyException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RubyException(e.toString());
        }
    }

    @RubyLevelMethod(name="eval", module=true)
    public static RubyValue eval(RubyValue receiver, RubyValue arg) {
        return RubyKernelModule.eval(arg.toStr());
    }

    @RubyLevelMethod(name="eval", module=true)
    public static RubyValue eval(RubyValue receiver, RubyValue arg0, RubyValue arg1) {
        if (arg1 instanceof RubyBinding) {
            return RubyKernelModule.eval(arg0.toStr(), (RubyBinding)arg1);
        }
        return RubyKernelModule.eval(arg0.toStr());
    }

    @RubyLevelMethod(name="eval", module=true)
    public static RubyValue eval(RubyValue receiver, RubyArray args) {
        RubyBinding binding2 = null;
        if (args.get(1) instanceof RubyBinding) {
            binding2 = (RubyBinding)args.get(1);
        }
        String file_name = null;
        if (args.size() > 2) {
            file_name = args.get(2).toStr();
        }
        return RubyKernelModule.eval(args.get(0).toStr(), binding2, file_name);
    }

    @RubyLevelMethod(name="method")
    public static RubyValue objMethod(RubyValue receiver, RubyValue arg) {
        String method_name = arg.toStr();
        RubyID mid = RubyID.intern(method_name);
        RubyMethod m = receiver.findMethod(mid);
        if (null == m) {
            throw new RubyException(RubyRuntime.NameErrorClass, "public method '" + method_name + "' can not be found in '" + receiver.getRubyClass().getName() + "'");
        }
        return ObjectFactory.createMethod(receiver, method_name, m);
    }

    @RubyLevelMethod(name="public_methods")
    public static RubyValue publicMethods(RubyValue receiver) {
        RubyArray a = new RubyArray();
        RubyClass klass = receiver.getRubyClass();
        klass.collectClassMethodNames(a, 0);
        return a;
    }

    @RubyLevelMethod(name="caller", module=true)
    public static RubyValue call(RubyValue receiver) {
        return new RubyArray();
    }

    @RubyLevelMethod(name="caller", module=true)
    public static RubyValue call(RubyValue receiver, RubyValue arg) {
        return new RubyArray();
    }

    @RubyLevelMethod(name="throw", module=true)
    public static RubyValue throwMethod(RubyValue receiver) {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `throw': wrong number of arguments (0 for 1)");
    }

    @RubyLevelMethod(name="throw", module=true)
    public static RubyValue throwMethod(RubyValue receiver, RubyArray args) {
        RubyExceptionValue e;
        RubyValue tag = args.get(0);
        if (tag instanceof RubySymbol || tag instanceof RubyString) {
            e = new RubyExceptionValueForThrow(tag, args.get(1));
        } else if (tag instanceof RubyExceptionValue) {
            e = (RubyExceptionValue)tag;
        } else if (tag instanceof RubyClass) {
            RubyClass c = (RubyClass)tag;
            e = new RubyExceptionValue(c, c.getName() + " is not a symbol");
        } else {
            e = new RubyExceptionValue(RubyRuntime.ArgumentErrorClass, tag.toString() + " is not a symbol");
        }
        throw new RubyException(e);
    }

    @RubyLevelMethod(name="catch", module=true)
    public static RubyValue catchMethod(RubyValue receiver, RubyValue arg, RubyBlock block) {
        if (!(arg instanceof RubySymbol)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, arg.toString() + " is not a symbol");
        }
        try {
            block.invoke(receiver);
        }
        catch (RubyException e) {
            RubyExceptionValueForThrow v;
            RubyValue ev = RubyAPI.convertRubyException2RubyValue(e);
            if (ev instanceof RubyExceptionValueForThrow && (v = (RubyExceptionValueForThrow)ev).isSameSymbol(arg)) {
                return v.getReturnValue();
            }
            throw e;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="untrace_var", module=true)
    public static RubyValue untrace_var(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (null == args || args.size() < 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `untrace_var': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubySymbol)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, args.get(0).toString() + " is not a symbol");
        }
        String name = ((RubySymbol)args.get(0)).toString();
        RubyValue v = args.get(1);
        if (v == RubyConstant.QNIL) {
            GlobalVariables.removeAllTraceProc(name);
        } else if (v instanceof RubyProc) {
            GlobalVariables.removeTraceProc(name, (RubyProc)v);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="trace_var", module=true)
    public static RubyValue trace_var(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (null == args || args.size() < 1) {
            int actual_argc = null == args ? 0 : args.size();
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `trace_var': wrong number of arguments (" + actual_argc + " for 1)");
        }
        if (!(args.get(0) instanceof RubySymbol)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, args.get(0).toString() + " is not a symbol");
        }
        String name = ((RubySymbol)args.get(0)).toString();
        RubyValue v = args.get(1);
        if (v instanceof RubyProc) {
            GlobalVariables.addTraceProc(name, (RubyProc)v);
        } else if (null != block) {
            GlobalVariables.addTraceProc(name, ObjectFactory.createProc(block));
        } else {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "tried to create Proc object without a block");
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="block_given?", alias={"iterator?"}, module=true)
    public static RubyValue blockGivenP(RubyValue receiver, RubyBlock block) {
        return ObjectFactory.createBoolean(null != block);
    }

    @RubyLevelMethod(name="Float", module=true)
    public static RubyFloat toFloat(RubyValue receiver, RubyValue arg) {
        return arg.toRubyFloat();
    }

    @RubyLevelMethod(name="Integer", module=true)
    public static RubyInteger toInteger(RubyValue receiver, RubyValue arg) {
        return arg.toRubyInteger();
    }

    @RubyLevelMethod(name="puts", module=true)
    public static RubyValue puts(RubyValue receiver) {
        return RubyIO.STDOUT.puts();
    }

    @RubyLevelMethod(name="puts", module=true)
    public static RubyValue puts(RubyValue receiver, RubyArray args) {
        return RubyIO.STDOUT.puts(args);
    }

    @RubyLevelMethod(name="print", module=true)
    public static RubyValue print(RubyValue receiver) {
        return RubyIO.STDOUT.print();
    }

    @RubyLevelMethod(name="print", module=true)
    public static RubyValue print(RubyValue receiver, RubyValue arg) {
        return RubyIO.STDOUT.print(arg);
    }

    @RubyLevelMethod(name="print", module=true)
    public static RubyValue print(RubyValue receiver, RubyArray args) {
        return RubyIO.STDOUT.print(args);
    }

    @RubyLevelMethod(name="printf", module=true)
    public static RubyValue printf(RubyValue receiver, RubyArray args) {
        String fmt = args.get(0).toStr();
        System.out.printf(fmt, RubyKernelModule.buildFormatArg(args, 1));
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="sprintf", module=true)
    public static RubyValue sprintf(RubyValue receiver, RubyArray args) {
        String fmt = args.get(0).toStr();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.printf(fmt, RubyKernelModule.buildFormatArg(args, 1));
        ps.flush();
        ps.close();
        return ObjectFactory.createString(baos.toString());
    }

    @RubyLevelMethod(name="p", module=true)
    public static RubyValue p(RubyValue receiver) {
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="p", module=true)
    public static RubyValue p(RubyValue receiver, RubyValue arg) {
        RubyValue str = RubyAPI.callNoArgMethod(arg, null, RubyID.inspectID);
        RubyString value2 = str.toRubyString();
        value2.appendString("\n");
        System.out.print(value2.toString());
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="p", module=true)
    public static RubyValue p(RubyValue receiver, RubyArray args) {
        for (RubyValue arg : args) {
            RubyValue str = RubyAPI.callNoArgMethod(arg, null, RubyID.inspectID);
            RubyString value2 = (RubyString)str;
            value2.appendString("\n");
            System.out.print(value2.toString());
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="gets", module=true)
    public static RubyValue gets(RubyValue receiver) {
        String s = null;
        try {
            s = in_.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GlobalVariables.set(null == s ? RubyConstant.QNIL : ObjectFactory.createString(s), "$_");
        return GlobalVariables.get("$_");
    }

    @RubyLevelMethod(name="object_id", alias={"__id__", "hash"})
    public static RubyValue objectId(RubyValue receiver) {
        return ObjectFactory.createFixnum(receiver.hashCode());
    }

    @RubyLevelMethod(name="extend")
    public static RubyValue extend(RubyValue receiver) {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (0 for 1)");
    }

    @RubyLevelMethod(name="extend")
    public static RubyValue extend(RubyValue receiver, RubyValue arg) {
        RubyAPI.callPublicOneArgMethod(arg, receiver, null, RubyID.extendObjectID);
        return receiver;
    }

    @RubyLevelMethod(name="extend")
    public static RubyValue extend(RubyValue receiver, RubyArray args) {
        for (RubyValue v : args) {
            RubyAPI.callPublicOneArgMethod(v, receiver, null, RubyID.extendObjectID);
        }
        return receiver;
    }

    @RubyLevelMethod(name="freeze")
    public static RubyValue freeze(RubyValue receiver) {
        receiver.freeze();
        return receiver;
    }

    @RubyLevelMethod(name="frozen?")
    public static RubyValue frozen(RubyValue receiver) {
        return ObjectFactory.createBoolean(receiver.frozen());
    }

    @RubyLevelMethod(name="taint")
    public static RubyValue taint(RubyValue receiver) {
        receiver.taint();
        return receiver;
    }

    @RubyLevelMethod(name="tainted?")
    public static RubyValue tainted(RubyValue receiver) {
        return ObjectFactory.createBoolean(receiver.tainted());
    }

    @RubyLevelMethod(name="method_missing", module=true)
    public static RubyValue methodMissing(RubyValue receiver, RubyArray args) {
        RubySymbol method_name = (RubySymbol)args.get(0);
        RubyClass klass = receiver.getRubyClass();
        klass = klass != null ? klass.getRealClass() : null;
        throw new RubyException(RubyRuntime.NoMethodErrorClass, "undefined method '" + method_name.toString() + "' for " + klass.getName());
    }

    @RubyLevelMethod(name="sleep", module=true)
    public static RubyValue sleep(RubyValue receiver, RubyValue arg) {
        long milliseconds = RubyTypesUtil.convertToJavaLong(arg) * 1000L;
        long startTime = System.currentTimeMillis();
        RubyThread.sleep(milliseconds);
        long endTime = System.currentTimeMillis();
        return ObjectFactory.createFixnum((int)Math.round((double)(endTime - startTime) / 1000.0));
    }

    @RubyLevelMethod(name="require_java", alias={"import"}, module=true)
    public static RubyValue requireJava(RubyValue receiver, RubyValue arg, RubyBlock block) {
        String className = arg.toStr();
        String[] names = packagePattern.split(className);
        String name = names[names.length - 1];
        if (name.equals("*")) {
            JavaClass.addPackage(className.substring(0, className.lastIndexOf(46)));
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                JavaClass.createJavaClass(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RubyException("Couldn't find class " + className);
            }
        }
        RubyRuntime.setJavaSupported(true);
        return RubyConstant.QTRUE;
    }

    @RubyLevelMethod(name="__load_with_reflection__", module=true)
    public static RubyValue loadWithReflection(RubyValue receiver, RubyValue arg, RubyBlock block) {
        String required_file = arg.toStr();
        String name = NameFactory.createMainClassName(required_file);
        try {
            Class<?> c = Class.forName(name);
            Object o = c.newInstance();
            RubyProgram p2 = (RubyProgram)o;
            RubyArray a = (RubyArray)GlobalVariables.get("$\"");
            if (a.include(arg) == RubyConstant.QFALSE) {
                a.push(arg);
            }
            p2.invoke();
            return RubyConstant.QTRUE;
        }
        catch (ClassNotFoundException e) {
            return RubyConstant.QFALSE;
        }
        catch (InstantiationException e) {
            return RubyConstant.QFALSE;
        }
        catch (IllegalAccessException e) {
            return RubyConstant.QFALSE;
        }
    }

    @RubyLevelMethod(name="binding", module=true)
    public static RubyValue binding(RubyValue receiver, RubyArray args) {
        return args.get(0);
    }

    @RubyLevelMethod(name="lambda", alias={"proc"}, module=true)
    public static RubyValue lambda(RubyValue receiver, RubyBlock block) {
        block.setCreatedByLambda();
        return ObjectFactory.createProc(block);
    }

    @RubyLevelMethod(name="at_exit", module=true)
    public static RubyValue atExit(RubyValue receiver, RubyBlock block) {
        if (null == block) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "called without a block");
        }
        AtExitBlocks.registerBlock(block);
        return ObjectFactory.createProc(block);
    }

    @RubyLevelMethod(name="gsub", module=true)
    public static RubyValue gsub(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (!(GlobalVariables.get("$_") instanceof RubyString)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "$_ value need to be String (" + GlobalVariables.get("$LAST_READ_LINE").getRubyClass().getName() + " given)");
        }
        RubyValue r = ((RubyString)GlobalVariables.get("$_")).gsub_danger(args, block);
        return GlobalVariables.set(r, "$_");
    }

    @RubyLevelMethod(name="gsub!", module=true)
    public static RubyValue gsubBang(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (!(GlobalVariables.get("$_") instanceof RubyString)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "$_ value need to be String (" + GlobalVariables.get("$_").getRubyClass().getName() + " given)");
        }
        RubyValue r = ((RubyString)GlobalVariables.get("$_")).gsub_danger(args, block);
        if (r != RubyConstant.QNIL) {
            GlobalVariables.set(r, "$_");
        }
        return r;
    }

    @RubyLevelMethod(name="sub", module=true)
    public static RubyValue sub(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (!(GlobalVariables.get("$_") instanceof RubyString)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "$_ value need to be String (" + GlobalVariables.get("$LAST_READ_LINE").getRubyClass().getName() + " given)");
        }
        RubyValue r = ((RubyString)GlobalVariables.get("$_")).gsub_danger(args, block);
        return GlobalVariables.set(r, "$_");
    }

    @RubyLevelMethod(name="open")
    public static RubyValue open(RubyValue receiver, RubyArray args, RubyBlock block) {
        Object mode;
        RubyIO io;
        String filename = args.get(0).toStr();
        if (args.size() <= 1) {
            io = ObjectFactory.createFile(filename, "r");
        } else if (args.get(1) instanceof RubyFixnum) {
            mode = "r";
            int i = args.get(1).toInt();
            if ((i & RDWR) != 0) {
                mode = (String)mode + "w";
            }
            io = ObjectFactory.createFile(filename, (String)mode);
        } else {
            mode = (RubyString)args.get(1);
            io = ObjectFactory.createFile(filename, ((RubyString)mode).toString());
        }
        if (null == block) {
            return io;
        }
        RubyValue v = block.invoke(receiver, io);
        io.close();
        return v;
    }

    public static Object[] buildFormatArg(RubyArray args, int start2) {
        Object[] raw_args = new Object[args.size() - start2];
        for (int i = 0; i < args.size() - start2; ++i) {
            RubyValue v = args.get(i + start2);
            raw_args[i] = v instanceof RubyFixnum ? Integer.valueOf(((RubyFixnum)v).toInt()) : (v instanceof RubyFloat ? Double.valueOf(((RubyFloat)v).doubleValue()) : v);
        }
        return raw_args;
    }
}

