/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.AttrReader;
import com.xruby.runtime.builtin.AttrWriter;
import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.lang.ClassFactory;
import com.xruby.runtime.lang.ObjectSpace;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBinding;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyIncludeClass;
import com.xruby.runtime.lang.RubyKernelModule;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyObject;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.RubyVarArgMethod;
import com.xruby.runtime.lang.UndefMethod;
import com.xruby.runtime.lang.annotation.DummyMethod;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.util.HashMap;
import java.util.Map;

@RubyLevelClass(name="Module", superclass="Object", dummy={@DummyMethod(name="included", privateMethod=true), @DummyMethod(name="extended", privateMethod=true), @DummyMethod(name="method_added", privateMethod=true), @DummyMethod(name="method_removed", privateMethod=true), @DummyMethod(name="method_undefined", privateMethod=true)})
public class RubyModule
extends RubyBasic {
    protected String name_;
    private RubyModule scope_ = null;
    protected RubyClass superclass_;
    private int current_access_mode_ = 0;
    protected Map<RubyID, RubyValue> instance_varibles_ = null;
    protected Map<RubyID, RubyMethod> methods_ = new HashMap<RubyID, RubyMethod>();
    protected Map<String, RubyValue> constants_ = new HashMap<String, RubyValue>();

    public RubyModule() {
        super(null);
        this.name_ = null;
        this.scope_ = null;
    }

    public RubyModule(String name, RubyModule owner) {
        super(null);
        this.name_ = name;
        this.scope_ = owner;
    }

    @Override
    public RubyValue clone() {
        RubyModule cl = null;
        try {
            cl = (RubyModule)this.getClass().newInstance();
            cl.doClone(this);
        }
        catch (Exception e) {
            throw new RubyException(RubyRuntime.ExceptionClass, e.toString());
        }
        return cl;
    }

    @Override
    protected void doClone(RubyValue orig) {
        RubyModule m = (RubyModule)orig;
        this.name_ = m.name_;
        this.scope_ = m.scope_;
        this.superclass_ = m.superclass_;
        this.current_access_mode_ = m.current_access_mode_;
        this.methods_ = m.methods_;
        this.constants_ = m.constants_;
        super.doClone((RubyObject)orig);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    void setScope(RubyModule owner) {
        this.scope_ = owner;
    }

    public boolean isRealModule() {
        return true;
    }

    public boolean isRealClass() {
        return false;
    }

    public void setAccessPublic() {
        this.current_access_mode_ = 0;
    }

    public void setAccessPrivate() {
        this.current_access_mode_ = 2;
    }

    public void setAccessMode(int access) {
        this.current_access_mode_ = access;
    }

    protected RubyValue getOwnConstant(String name) {
        return this.constants_.get(name);
    }

    public RubyValue setConstant(String name, RubyValue value2) {
        this.constants_.put(name, value2);
        if (value2 instanceof RubyModule) {
            ((RubyModule)value2).setName(name);
        }
        return value2;
    }

    @RubyAllocMethod
    public static RubyModule allocModule(RubyValue receiver) {
        RubyModule module = new RubyModule();
        module.setRubyClass((RubyClass)receiver);
        return module;
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initializeModule(RubyBlock block) {
        if (block != null) {
            this.module_eval(null, block);
        }
        return RubyConstant.QNIL;
    }

    public RubyValue defineMethod(String name, RubyMethod m) {
        return this.addMethod(RubyID.intern(name), m, this.current_access_mode_);
    }

    public RubyValue defineMethod(RubyID mid, RubyMethod m) {
        return this.addMethod(mid, m, this.current_access_mode_);
    }

    public RubyValue definePrivateMethod(String name, RubyMethod m) {
        return this.addMethod(RubyID.intern(name), m, 2);
    }

    public void defineModuleMethod(String name, RubyMethod m) {
        this.definePrivateMethod(name, m);
        this.getSingletonClass().defineMethod(name, m.clone());
    }

    protected RubyMethod findOwnMethod(RubyID mid) {
        RubyModule klass = this;
        do {
            RubyMethod m;
            if ((m = klass.methods_.get(mid)) == null) continue;
            return m;
        } while ((klass = klass.superclass_) != null);
        return null;
    }

    protected RubyMethod findOwnPublicMethod(RubyID mid) {
        RubyModule klass = this;
        do {
            RubyMethod m;
            if ((m = klass.methods_.get(mid)) == null || 0 != m.getAccess()) continue;
            return m;
        } while ((klass = klass.superclass_) != null);
        return null;
    }

    public void undefMethod(String method_name) {
        RubyID mid = RubyID.intern(method_name);
        if (this.findOwnMethod(mid) == null) {
            throw new RubyException(RubyRuntime.NameErrorClass, "undefined method " + mid.toString() + " for class `Object'");
        }
        this.addMethod(mid, UndefMethod.getInstance(), 0);
    }

    public void aliasMethod(String newName, String oldName) {
        RubyID oldId = RubyID.intern(oldName);
        RubyMethod m = this.findOwnMethod(oldId);
        if (null == m) {
            if (this instanceof RubyModule) {
                m = RubyRuntime.ObjectClass.findPublicMethod(oldId);
            }
            if (null == m) {
                throw new RubyException(RubyRuntime.NameErrorClass, "undefined method " + oldName + " for class `Object'");
            }
        }
        RubyID newId = RubyID.intern(newName);
        this.methods_.put(newId, m);
    }

    public void collectOwnMethodNames(RubyArray a, int mode) {
        for (Map.Entry<RubyID, RubyMethod> entry : this.methods_.entrySet()) {
            if (entry.getKey() == RubyID.ID_ALLOCATOR) continue;
            int access_mode = entry.getValue().getAccess();
            if (4 != mode && (3 != mode || 2 == access_mode) && access_mode != mode) continue;
            a.add(ObjectFactory.createString(entry.getKey().toString()));
        }
    }

    protected RubyValue addMethod(RubyID id, RubyMethod m, int attribute) {
        m.setScope(this);
        m.setID(id);
        m.setAccess(attribute);
        this.methods_.put(id, m);
        if (RubyRuntime.running && id != RubyID.ID_ALLOCATOR) {
            RubyAPI.callOneArgMethod(this, id.toSymbol(), null, RubyID.methodAddedID);
        }
        return RubyConstant.QNIL;
    }

    public boolean isMethodBound(RubyID id, boolean check) {
        RubyMethod m = this.findOwnMethod(id);
        return null != m && !UndefMethod.isUndef(m);
    }

    @Override
    public boolean isKindOf(RubyModule klass) {
        RubyModule m = this;
        while (m != null) {
            if (m == klass || m.methods_ == klass.methods_) {
                return true;
            }
            m = m.superclass_;
        }
        return false;
    }

    private boolean isKindOf(RubyValue v) {
        RubyClass cl = v.getRubyClass();
        while (cl != null) {
            if (cl == this || cl.methods_ == this.methods_) {
                return true;
            }
            cl = cl.superclass_;
        }
        return false;
    }

    public RubyClass defineNewClass(String name, RubyClass parent) {
        if (parent == null) {
            parent = RubyRuntime.ObjectClass;
        }
        RubyClass klass = ClassFactory.makeRubyClass(parent);
        if (null != name) {
            klass.setScope(this);
            klass.setName(name);
            this.constants_.put(name, klass);
        }
        ClassFactory.inheritedClass(parent, klass);
        ObjectSpace.add(klass);
        return klass;
    }

    private RubyClass defineClass(String name, RubyClass parent) {
        RubyValue v = null;
        if (null != name) {
            v = this.constants_.get(name);
        }
        if (null == v) {
            return this.defineNewClass(name, parent);
        }
        if (!(v instanceof RubyClass)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, name + " is not a class");
        }
        RubyClass c = (RubyClass)v;
        if (null != parent && !c.isMyParent(parent)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "superclass mismatch for class " + name);
        }
        c.setAccessPublic();
        return c;
    }

    public RubyClass defineClass(String name, RubyValue parent) {
        if (null != parent && !(parent instanceof RubyClass)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "superclass must be a Class (" + parent.getRubyClass().getName() + " given)");
        }
        return this.defineClass(name, null == parent ? null : (RubyClass)parent);
    }

    public RubyModule defineNewModule(String name) {
        RubyModule m = new RubyModule(name, this);
        m.setName(name);
        m.setRubyClass(RubyRuntime.ModuleClass);
        this.constants_.put(name, m);
        return m;
    }

    public RubyModule defineModule(String name) {
        RubyValue v = this.constants_.get(name);
        if (null == v) {
            return this.defineNewModule(name);
        }
        if (!(v instanceof RubyModule) || v instanceof RubyClass) {
            throw new RubyException(RubyRuntime.TypeErrorClass, name + " is not a module");
        }
        return (RubyModule)v;
    }

    public RubyValue getConstant(String name) {
        RubyValue v = this.getOwnConstant(name);
        if (null != v) {
            return v;
        }
        if (null != this.scope_ && null != (v = this.scope_.getConstant(name))) {
            return v;
        }
        if (null != this.superclass_ && null != (v = this.superclass_.getConstant(name))) {
            return v;
        }
        return null;
    }

    public void to_s(RubyString s) {
        String name;
        if (null != this.scope_) {
            this.scope_.to_s(s);
            if (s.length() > 0) {
                s.appendString("::");
            }
        }
        if ((name = this.getName()) != null) {
            s.appendString(this.getName());
        }
    }

    public void includeModule(RubyModule module) {
        if (module == null) {
            return;
        }
        RubyModule c = this;
        boolean changed = false;
        while (module != null) {
            boolean superclassSeen = false;
            if (c.methods_ == module.methods_) {
                throw new RubyException(RubyRuntime.ArgumentErrorClass, "cyclic include detected");
            }
            boolean skip = false;
            RubyClass p2 = this.superclass_;
            while (p2 != null) {
                if (p2 instanceof RubyIncludeClass) {
                    if (p2.methods_ == module.methods_ && !superclassSeen) {
                        c = p2;
                        skip = true;
                        break;
                    }
                } else if (p2.isRealClass()) {
                    superclassSeen = true;
                    break;
                }
                p2 = p2.superclass_;
            }
            if (!skip) {
                c.superclass_ = new RubyIncludeClass(module, c.superclass_);
                c = c.superclass_;
                changed = true;
            }
            module = module.superclass_;
        }
        if (changed) {
            RubyClass.resetCache();
        }
    }

    public final void collectIncludedModuleNames(RubyArray a) {
        RubyModule m = this;
        while (m != null) {
            if (m.isRealModule()) {
                a.add(m);
            } else if (m instanceof RubyIncludeClass) {
                a.add(((RubyIncludeClass)m).getIncludedModule());
            }
            m = m.superclass_;
        }
    }

    @Override
    public RubyValue getInstanceVariable(RubyID id) {
        if (null == this.instance_varibles_) {
            return RubyConstant.QNIL;
        }
        RubyValue v = this.instance_varibles_.get(id);
        return null != v ? v : RubyConstant.QNIL;
    }

    @Override
    public RubyValue setInstanceVariable(RubyValue value2, RubyID id) {
        if (null == this.instance_varibles_) {
            this.instance_varibles_ = new HashMap<RubyID, RubyValue>();
        }
        this.instance_varibles_.put(id, value2);
        return value2;
    }

    public RubyValue getClassVariable(String name) {
        RubyModule klass = this;
        RubyID id = RubyID.intern(name);
        while (klass != null) {
            RubyValue v;
            if (klass.instance_varibles_ != null && (v = klass.instance_varibles_.get(id)) != null) {
                return v;
            }
            klass = klass.superclass_;
        }
        throw new RubyException(RubyRuntime.NameErrorClass, "uninitialized class variable " + name + " in " + (null == this.name_ ? "Object" : this.name_));
    }

    public RubyValue setClassVariable(RubyValue value2, String name) {
        RubyModule klass = this;
        RubyID id = RubyID.intern(name);
        while (klass != null) {
            if (klass.instance_varibles_ != null) {
                klass.instance_varibles_.put(id, value2);
                return value2;
            }
            klass = klass.superclass_;
        }
        this.setInstanceVariable(value2, id);
        return value2;
    }

    @RubyLevelMethod(name="attr_reader", privateMethod=true)
    public RubyValue attrReader(RubyArray args) {
        for (RubyValue v : args) {
            RubyID id = v.toID();
            this.defineMethod(id, (RubyMethod)new AttrReader(id));
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="attr_writer", privateMethod=true)
    public RubyValue attrWriter(RubyArray args) {
        for (RubyValue v : args) {
            RubyID id = v.toID();
            this.defineMethod(id + "=", (RubyMethod)new AttrWriter(id));
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="attr_accessor", privateMethod=true)
    public RubyValue attrAccessor(RubyArray args) {
        for (RubyValue v : args) {
            RubyID id = v.toID();
            this.defineMethod(id, (RubyMethod)new AttrReader(id));
            this.defineMethod(id + "=", (RubyMethod)new AttrWriter(id));
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="attr", privateMethod=true)
    public RubyValue attr(RubyValue arg) {
        RubyID id = arg.toID();
        this.defineMethod(id, (RubyMethod)new AttrReader(id));
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="attr", privateMethod=true)
    public RubyValue attr(RubyValue arg0, RubyValue arg1) {
        RubyID id = arg0.toID();
        this.defineMethod(id, (RubyMethod)new AttrReader(id));
        if (arg1 != RubyConstant.QFALSE && arg1 != RubyConstant.QNIL) {
            this.defineMethod(id + "=", (RubyMethod)new AttrWriter(id));
        }
        return RubyConstant.QNIL;
    }

    private RubyMethod setAccess(RubyID mid, int access) {
        RubyMethod m = this.findOwnMethod(mid);
        if (null == m && this instanceof RubyModule) {
            m = RubyRuntime.ObjectClass.findPublicMethod(mid);
        }
        if (null != m && m.getAccess() != access) {
            this.addMethod(mid, m.clone(), access);
        }
        return m;
    }

    private static void setAccess(int access, RubyModule c, RubyArray args) {
        if (null == args) {
            c.setAccessMode(access);
            return;
        }
        for (RubyValue arg : args) {
            RubyID mid;
            String method_name;
            if (arg instanceof RubyString) {
                method_name = arg.toString();
            } else if (arg instanceof RubySymbol) {
                method_name = arg.toString();
            } else {
                throw new RubyException(RubyRuntime.TypeErrorClass, arg.toString() + " is not a symbol");
            }
            if (c.setAccess(mid = RubyID.intern(method_name), access) != null) continue;
            throw new RubyException(RubyRuntime.NameErrorClass, "undefined method '" + method_name + "' for " + c.getName());
        }
    }

    @RubyLevelMethod(name="public", privateMethod=true)
    public RubyValue modPublic(RubyArray args) {
        RubyModule.setAccess(0, this, args);
        return this;
    }

    @RubyLevelMethod(name="protected", privateMethod=true)
    public RubyValue modProtected(RubyArray args) {
        RubyModule.setAccess(1, this, args);
        return this;
    }

    @RubyLevelMethod(name="private", privateMethod=true)
    public RubyValue modPrivate(RubyArray args) {
        RubyModule.setAccess(2, this, args);
        return this;
    }

    @RubyLevelMethod(name="private_class_method")
    public RubyValue private_class_method(RubyArray args) {
        RubyModule.setAccess(2, this.getSingletonClass(), args);
        return this;
    }

    @RubyLevelMethod(name="public_class_method")
    public RubyValue public_class_method(RubyArray args) {
        RubyModule.setAccess(0, this.getSingletonClass(), args);
        return this;
    }

    @RubyLevelMethod(name="to_s", alias={"name"})
    public RubyValue modName() {
        RubyString s = ObjectFactory.createString();
        this.to_s(s);
        return s;
    }

    @RubyLevelMethod(name="inspect")
    public RubyValue rubyInspect() {
        return RubyAPI.callNoArgMethod(this, null, RubyID.toSID);
    }

    private void checkType(RubyValue arg, RubyClass type) {
        RubyClass c = arg.getRubyClass().getRealClass();
        if (c != type) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "wrong argument type " + c.getName() + " (expected Module)");
        }
    }

    @RubyLevelMethod(name="append_features")
    public RubyValue append_features(RubyValue arg) {
        ((RubyModule)arg).includeModule(this);
        return this;
    }

    @RubyLevelMethod(name="include", privateMethod=true)
    public RubyValue include() {
        return this;
    }

    @RubyLevelMethod(name="include", privateMethod=true)
    public RubyValue include(RubyValue arg) {
        this.checkType(arg, RubyRuntime.ModuleClass);
        RubyAPI.callOneArgMethod(arg, this, null, RubyID.append_featuresID);
        RubyAPI.callOneArgMethod(arg, this, null, RubyID.includedID);
        return this;
    }

    @RubyLevelMethod(name="include", privateMethod=true)
    public RubyValue include(RubyArray args) {
        for (RubyValue arg : args) {
            this.checkType(arg, RubyRuntime.ModuleClass);
            RubyAPI.callOneArgMethod(arg, this, null, RubyID.append_featuresID);
            RubyAPI.callOneArgMethod(arg, this, null, RubyID.includedID);
        }
        return this;
    }

    @RubyLevelMethod(name="extend_object")
    public RubyValue extendObject(RubyValue arg) {
        arg.getSingletonClass().includeModule(this);
        return arg;
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue opSpaceship(RubyValue arg) {
        if (this == arg) {
            return ObjectFactory.FIXNUM0;
        }
        if (!(arg instanceof RubyModule)) {
            return RubyConstant.QNIL;
        }
        RubyModule other_module = (RubyModule)arg;
        if (this instanceof RubyClass && other_module instanceof RubyClass) {
            RubyClass c1 = (RubyClass)this;
            RubyClass c2 = (RubyClass)other_module;
            if (c1.isKindOf(c2)) {
                return ObjectFactory.FIXNUM_NEGATIVE_ONE;
            }
            if (c2.isKindOf(c1)) {
                return ObjectFactory.FIXNUM1;
            }
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="<")
    public RubyValue opLt(RubyValue arg) {
        if (!(arg instanceof RubyModule)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "compared with non class/module");
        }
        return RubyModule.compareModule(this, arg);
    }

    @RubyLevelMethod(name=">")
    public RubyValue opGt(RubyValue arg) {
        if (!(arg instanceof RubyModule)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "compared with non class/module");
        }
        return RubyModule.compareModule(arg, this);
    }

    @RubyLevelMethod(name=">=")
    public RubyValue opGe(RubyValue arg) {
        if (!(arg instanceof RubyModule)) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "compared with non class/module");
        }
        if (arg == this) {
            return RubyConstant.QTRUE;
        }
        return RubyModule.compareModule(arg, this);
    }

    private static RubyValue compareModule(RubyValue module, RubyValue other_module) {
        if (module == other_module) {
            return RubyConstant.QFALSE;
        }
        if (module instanceof RubyClass && other_module instanceof RubyClass) {
            RubyClass c1 = (RubyClass)module;
            RubyClass c2 = (RubyClass)other_module;
            if (c1.isKindOf(c2)) {
                return RubyConstant.QTRUE;
            }
            if (c2.isKindOf(c1)) {
                return RubyConstant.QFALSE;
            }
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="===")
    public RubyValue caseEqual(RubyValue arg) {
        return ObjectFactory.createBoolean(this.isKindOf(arg));
    }

    @RubyLevelMethod(name="ancestors")
    public RubyValue ancestors() {
        RubyArray r = new RubyArray();
        this.collectIncludedModuleNames(r);
        return r;
    }

    @RubyLevelMethod(name="instance_methods")
    public RubyValue instance_methods(RubyArray args) {
        return this.get_instance_methods(this, args, 3);
    }

    @RubyLevelMethod(name="public_instance_methods")
    public RubyValue public_instance_methods(RubyArray args) {
        return this.get_instance_methods(this, args, 0);
    }

    @RubyLevelMethod(name="protected_instance_methods")
    public RubyValue protected_instance_methods(RubyArray args) {
        return this.get_instance_methods(this, args, 1);
    }

    @RubyLevelMethod(name="private_instance_methods")
    public RubyValue private_instance_methods(RubyArray args) {
        return this.get_instance_methods(this, args, 2);
    }

    private RubyValue get_instance_methods(RubyValue receiver, RubyArray args, int mode) {
        boolean include_super = false;
        if (args != null && args.get(0).isTrue()) {
            include_super = true;
        }
        RubyArray a = new RubyArray();
        if (include_super) {
            ((RubyClass)receiver).collectClassMethodNames(a, mode);
        } else {
            ((RubyModule)receiver).collectOwnMethodNames(a, mode);
        }
        return a;
    }

    private void module_function(String method_name) {
        RubyID mid = RubyID.intern(method_name);
        RubyMethod m = this.findOwnMethod(mid);
        if (null == m || UndefMethod.isUndef(m)) {
            throw new RubyException(RubyRuntime.NoMethodErrorClass, "undefined method '" + method_name + "' for " + this.getName());
        }
        this.getSingletonClass().defineMethod(method_name, m);
    }

    @RubyLevelMethod(name="module_function")
    public RubyValue module_function() {
        return this;
    }

    @RubyLevelMethod(name="module_function")
    public RubyValue module_function(RubyArray args) {
        for (RubyValue v : args) {
            RubySymbol s = (RubySymbol)v;
            this.module_function(s.toString());
        }
        return this;
    }

    @RubyLevelMethod(name="module_eval", alias={"class_eval"})
    public RubyValue module_eval(RubyArray args, RubyBlock block) {
        if (null == args && null == block) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "block not supplied");
        }
        if (null != args) {
            RubyBinding binding2 = new RubyBinding();
            binding2.setScope(this);
            binding2.setSelf(this);
            return RubyKernelModule.eval(args.get(0).toStr(), binding2);
        }
        block.setScope(this);
        block.setSelf(this);
        return block.invoke(this);
    }

    @RubyLevelMethod(name="const_get")
    public RubyValue constGet(RubyValue arg) {
        RubySymbol s = RubyTypesUtil.convertToSymbol(arg);
        return RubyAPI.getConstant(this, s.toString());
    }

    @RubyLevelMethod(name="const_set")
    public RubyValue constSet(RubyValue arg1, RubyValue arg2) {
        RubySymbol s = RubyTypesUtil.convertToSymbol(arg1);
        return RubyAPI.setConstant(arg2, this, s.toString());
    }

    @RubyLevelMethod(name="define_method")
    public RubyValue define_method(RubyArray args, RubyBlock block) {
        final RubyBlock b = null != args && args.size() == 1 && null != block ? block : ((RubyProc)args.get(1)).getBlock();
        String name = RubyTypesUtil.convertToJavaString(args.get(0));
        RubyVarArgMethod method = new RubyVarArgMethod(){

            @Override
            protected RubyValue run(RubyValue _receiver, RubyArray _args, RubyBlock _block) {
                b.setSelf(_receiver);
                b.setArgsOfCurrentMethod(_args);
                return b.invoke(_receiver, _args);
            }
        };
        b.setCurrentMethod(method);
        return this.defineMethod(name, (RubyMethod)method);
    }

    @RubyLevelMethod(name="remove_method")
    public RubyValue remove_method(RubyArray args) {
        for (RubyValue arg : args) {
            String method_name = RubyTypesUtil.convertToJavaString(arg);
            this.undefMethod(method_name);
        }
        return this;
    }

    @RubyLevelMethod(name="alias_method")
    public RubyValue alias_method(RubyValue arg1, RubyValue arg2) {
        this.aliasMethod(arg1.toStr(), arg2.toStr());
        return this;
    }

    @RubyLevelMethod(name="undef_method")
    public RubyValue undef_method(RubyValue symbol) {
        this.undefMethod(symbol.toStr());
        return this;
    }
}

