/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySpecialValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;

@RubyLevelClass(name="Symbol")
public class RubySymbol
extends RubySpecialValue {
    private RubyID id;

    public RubySymbol(RubyID id) {
        this.id = id;
    }

    @Override
    public RubyClass getRubyClass() {
        return RubyRuntime.SymbolClass;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    @Override
    public String toStr() {
        return this.id.toString();
    }

    @Override
    public String asString() {
        return this.id.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public RubyID toID() {
        return this.id;
    }

    @RubyLevelMethod(name="to_i", alias={"to_int"})
    public RubyFixnum to_i() {
        return this.id.toFixnum();
    }

    @RubyLevelMethod(name="to_s", alias={"id2name"})
    public RubyString to_s() {
        return ObjectFactory.createString(this.id.toString());
    }

    @RubyLevelMethod(name="to_sym")
    public RubySymbol to_sym() {
        return this;
    }

    @RubyLevelMethod(name="inspect")
    public RubyString rubyInspect() {
        String value2 = this.toString();
        RubyString str = ObjectFactory.createString(":" + value2);
        if (!this.isSymname(value2)) {
            String s = str.dump();
            s = ":\"" + s.substring(2);
            str = ObjectFactory.createString(s);
        }
        return str;
    }

    private boolean isSymname(String name) {
        if (name == null) {
            return false;
        }
        int current2 = 0;
        boolean id = false;
        boolean localid = false;
        switch (this.getChar(name, current2)) {
            case 0: {
                return false;
            }
            case 36: {
                if (this.isSpecialGlobalName(name.substring(++current2))) {
                    return true;
                }
                id = true;
                break;
            }
            case 64: {
                if (this.getChar(name, ++current2) == 64) {
                    ++current2;
                }
                id = true;
            }
            case 60: {
                switch (this.getChar(name, ++current2)) {
                    case 60: {
                        ++current2;
                        break;
                    }
                    case 61: {
                        if (this.getChar(name, ++current2) != 62) break;
                        ++current2;
                    }
                }
                break;
            }
            case 62: {
                switch (this.getChar(name, ++current2)) {
                    case 61: 
                    case 62: {
                        ++current2;
                    }
                }
                break;
            }
            case 61: {
                switch (this.getChar(name, ++current2)) {
                    case 126: {
                        ++current2;
                        break;
                    }
                    case 61: {
                        if (this.getChar(name, ++current2) != 61) break;
                        ++current2;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 42: {
                if (this.getChar(name, ++current2) != 42) break;
                ++current2;
                break;
            }
            case 43: 
            case 45: {
                if (this.getChar(name, ++current2) != 64) break;
                ++current2;
                break;
            }
            case 37: 
            case 38: 
            case 47: 
            case 94: 
            case 96: 
            case 124: 
            case 126: {
                ++current2;
                break;
            }
            case 91: {
                if (this.getChar(name, ++current2) != 93) {
                    return false;
                }
                if (this.getChar(name, ++current2) != 61) break;
                ++current2;
                break;
            }
            default: {
                localid = !this.isUpper(this.getChar(name, current2));
                id = true;
            }
        }
        if (id) {
            int c = this.getChar(name, current2);
            if (c != 95 && !this.isAlpha(c)) {
                return false;
            }
            while (this.isIdentChar(this.getChar(name, current2))) {
                ++current2;
            }
            if (localid) {
                switch (this.getChar(name, current2)) {
                    case 33: 
                    case 61: 
                    case 63: {
                        ++current2;
                    }
                }
            }
        }
        return this.getChar(name, current2) <= 0;
    }

    private int getChar(String name, int index2) {
        if (index2 >= name.length()) {
            return -1;
        }
        return name.charAt(index2);
    }

    private boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    private boolean isAlpha(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isAlnum(int c) {
        return this.isAlpha(c) || this.isDigit(c);
    }

    private boolean isIdentChar(int c) {
        return this.isAlnum(c) || c == 95;
    }

    private boolean isSpecialGlobalName(String name) {
        int current2 = 0;
        switch (this.getChar(name, current2)) {
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 96: 
            case 126: {
                ++current2;
                break;
            }
            case 45: {
                ++current2;
                break;
            }
            default: {
                if (!this.isDigit(this.getChar(name, current2))) {
                    return false;
                }
                while (this.isDigit(this.getChar(name, ++current2))) {
                }
                break block0;
            }
        }
        return this.getChar(name, current2) <= 0;
    }
}

