/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang.util;

import com.xruby.compiler.codegen.CgUtil;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyValue;
import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public abstract class RunMethodHelper {
    protected abstract Method getRunMethod();

    protected abstract void loadBlock(GeneratorAdapter var1);

    protected abstract void loadArgs(GeneratorAdapter var1);

    protected abstract int rubyArgSize();

    public void createRunMethod(ClassVisitor cv, Class hostClass, Class castClass, String name, boolean staticMethod, boolean block) {
        Class<?> returnClass;
        Class[] params = this.getParamType(staticMethod, block);
        try {
            returnClass = hostClass.getMethod(name, params).getReturnType();
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("no such method: " + CgUtil.getMethod(name, RubyValue.class, params).getDescriptor());
        }
        GeneratorAdapter mg = this.startRun(this.getRunMethod(), cv);
        Type type = Type.getType(castClass);
        this.loadReceiver(mg, type, staticMethod);
        this.loadArgs(mg);
        if (block) {
            this.loadBlock(mg);
        }
        Method method = CgUtil.getMethod(name, returnClass, params);
        if (staticMethod) {
            mg.invokeStatic(type, method);
        } else {
            mg.invokeVirtual(type, method);
        }
        this.endRun(mg);
    }

    private Class[] getParamType(boolean staticMethod, boolean block) {
        int size2;
        ArrayList<Class<RubyBlock>> javaArgList = new ArrayList<Class<RubyBlock>>();
        if (staticMethod) {
            javaArgList.add(RubyValue.class);
        }
        if ((size2 = this.rubyArgSize()) >= 0) {
            for (int i = 0; i < size2; ++i) {
                javaArgList.add(RubyValue.class);
            }
        } else {
            javaArgList.add(RubyArray.class);
        }
        if (block) {
            javaArgList.add(RubyBlock.class);
        }
        return javaArgList.toArray(new Class[0]);
    }

    protected GeneratorAdapter startRun(Method runMethod, ClassVisitor cv) {
        GeneratorAdapter mg = new GeneratorAdapter(4, runMethod, null, null, cv);
        mg.visitCode();
        return mg;
    }

    protected void loadReceiver(GeneratorAdapter mg, Type type, boolean module) {
        mg.loadArg(0);
        if (!module && !Types.RUBY_VALUE_TYPE.equals(type)) {
            mg.checkCast(type);
        }
    }

    protected void endRun(GeneratorAdapter mg) {
        mg.returnValue();
        mg.endMethod();
    }
}

