/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes.socket;

import com.rhomobile.rhodes.Logger;
import com.rhomobile.rhodes.RhoConf;
import com.rhomobile.rhodes.socket.RhoSockAddr;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

public class RhoSocketImpl
extends SocketImpl {
    private static final String TAG = "RhoSocketImpl";
    private int sockfd = -1;
    private static final int DEFAULT_TIMEOUT = 30000;
    private int soTimeout = 30000;
    private int ipTos = 0;
    private RhoSockAddr remote;

    private native void initImpl(int var1);

    private native void closeImpl(int var1);

    private native Object getOptionImpl(int var1, int var2);

    private native void setOptionImpl(int var1, int var2, Object var3);

    public RhoSocketImpl(int n, RhoSockAddr rhoSockAddr) {
        Logger.D(TAG, "New socket wrapper. fd: " + n + ", host: " + rhoSockAddr.host + ", port: " + rhoSockAddr.port);
        this.soTimeout = RhoConf.getInt("net_timeout");
        if (0 == this.soTimeout) {
            this.soTimeout = 30000;
        }
        this.sockfd = n;
        this.remote = rhoSockAddr;
        this.initImpl(this.sockfd);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.remote.host;
    }

    @Override
    public int getPort() {
        return this.remote.port;
    }

    @Override
    protected void close() throws IOException {
        Logger.T(TAG, "close");
        this.closeImpl(this.sockfd);
        this.fd = new FileDescriptor();
        this.sockfd = -1;
    }

    @Override
    public Object getOption(int n) throws SocketException {
        Logger.T(TAG, "getOption");
        switch (n) {
            case 4102: {
                return this.soTimeout;
            }
            case 3: {
                return this.ipTos;
            }
        }
        return this.getOptionImpl(this.sockfd, n);
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        Logger.T(TAG, "setOption");
        if (n == 4102) {
            this.soTimeout = (Integer)object;
        } else {
            this.setOptionImpl(this.sockfd, n, object);
            if (n == 3) {
                this.ipTos = (Integer)object;
            }
        }
    }

    @Override
    protected int available() throws IOException {
        Logger.T(TAG, "available");
        return 0;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        Logger.T(TAG, "getInputStream");
        return null;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        Logger.T(TAG, "getOutputStream");
        return null;
    }

    @Override
    protected void create(boolean bl) throws IOException {
        Logger.T(TAG, "create");
    }

    @Override
    protected void connect(String string, int n) throws IOException {
        Logger.T(TAG, "connect1");
    }

    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        Logger.T(TAG, "connect2");
    }

    @Override
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        Logger.T(TAG, "connect3");
    }

    @Override
    protected void listen(int n) throws IOException {
        Logger.T(TAG, "listen");
    }

    @Override
    protected void accept(SocketImpl socketImpl) throws IOException {
        Logger.T(TAG, "accept");
    }

    @Override
    protected void bind(InetAddress inetAddress, int n) throws IOException {
        Logger.T(TAG, "bind");
    }

    @Override
    protected void sendUrgentData(int n) throws IOException {
        Logger.T(TAG, "sendUrgentData");
    }
}

