/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes;

import android.content.SharedPreferences;
import com.rhomobile.rhodes.Base64;
import com.rhomobile.rhodes.Logger;
import com.rhomobile.rhodes.util.ContextFactory;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class RhoCryptImpl {
    private static final String TAG = "RhoCryptJava";
    private static final boolean DEBUG = false;
    byte[] m_dbKeyData;
    String m_strDBPartition;
    final String m_strPrefName = "rho_internal_data";
    Cipher m_encryptCipher;
    Cipher m_decryptCipher;
    final int m_nKeyLenBit = 128;

    private void readKeyFromStorage() {
        SharedPreferences sharedPreferences = ContextFactory.getContext().getSharedPreferences("rho_internal_data", 0);
        String string = sharedPreferences.getString(this.m_strDBPartition, "");
        if (string != null && string.length() > 0) {
            this.m_dbKeyData = Base64.decode(string);
            Logger.I(TAG, "Key is successfully read from Shared Preferences");
        } else {
            Logger.I(TAG, "No key is found in Shared Preferences");
        }
    }

    private static String dumpKey(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(String.format("%x ", by));
        }
        return stringBuffer.toString();
    }

    private void generateNewKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        this.m_dbKeyData = secretKey.getEncoded();
        Logger.I(TAG, "New key is generated");
    }

    private void writeKeyToStorage() {
        SharedPreferences sharedPreferences = ContextFactory.getContext().getSharedPreferences("rho_internal_data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String string = Base64.encodeToString(this.m_dbKeyData, false);
        editor.putString(this.m_strDBPartition, string);
        if (editor.commit()) {
            Logger.I(TAG, "Key is successfully saved to Shared Preferences");
        } else {
            Logger.E(TAG, "Write key to Shared Preferences is failed");
        }
    }

    private void initKey(String string) throws Exception {
        if (this.m_dbKeyData != null) {
            return;
        }
        this.m_strDBPartition = string;
        this.readKeyFromStorage();
        if (this.m_dbKeyData != null) {
            return;
        }
        this.generateNewKey();
        this.writeKeyToStorage();
    }

    private void initContext(String string) throws Exception {
        if (this.m_dbKeyData != null) {
            Logger.T(TAG, "RhoCrypt context already initialized, partition: " + string);
            return;
        }
        this.initKey(string);
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.m_dbKeyData, "AES");
        this.m_encryptCipher = Cipher.getInstance("AES/CBC/NoPadding");
        this.m_encryptCipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        this.m_decryptCipher = Cipher.getInstance("AES/CBC/NoPadding");
        this.m_decryptCipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        Logger.T(TAG, "RhoCrypt context initialized for partition: " + string);
    }

    public boolean db_encrypt(String string, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            this.initContext(string);
            byteBuffer2.rewind();
            if (this.m_encryptCipher == null) {
                throw new NullPointerException("m_encryptCipher == null");
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer.capacity());
            byteBuffer3.put(byteBuffer);
            byteBuffer3.rewind();
            this.m_encryptCipher.doFinal(byteBuffer3, byteBuffer2);
            return true;
        }
        catch (Exception exception) {
            Logger.E(TAG, exception);
            return false;
        }
    }

    public boolean db_decrypt(String string, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            this.initContext(string);
            byteBuffer2.rewind();
            if (this.m_decryptCipher == null) {
                throw new NullPointerException("m_decryptCipher == null");
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer.capacity());
            byteBuffer3.put(byteBuffer);
            byteBuffer3.rewind();
            this.m_decryptCipher.doFinal(byteBuffer3, byteBuffer2);
            return true;
        }
        catch (Exception exception) {
            Logger.E(TAG, exception);
            return false;
        }
    }

    public boolean set_db_CryptKey(String string, String string2, boolean bl) {
        this.m_strDBPartition = string;
        byte[] byArray = Base64.decode(string2);
        if (byArray.length != 16) {
            Logger.E(TAG, "Incorrect key size : " + byArray.length + "; Should be: " + 16);
            return false;
        }
        this.m_dbKeyData = byArray;
        if (bl) {
            this.writeKeyToStorage();
        }
        return true;
    }
}

