/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes.file;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.rhomobile.rhodes.Logger;
import com.rhomobile.rhodes.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;

public class RhoFileApi {
    private static final String TAG = RhoFileApi.class.getSimpleName();
    private static final int MAX_SIZE = 0x200000;
    private static final String STAT_TABLE_FILENAME = "rho.dat";
    private static AssetManager am;
    private static String root;
    private static final String DB_FILES_FOLDER = "db/db-files";
    private static final String TMP_FOLDER = "tmp";

    private static native void nativeInitPath(String var0, String var1, String var2, String var3);

    private static native void nativeInitLogPath(String var0);

    private static native void nativeInit();

    private static native void updateStatTable(String var0, String var1, long var2, long var4);

    public static native String normalizePath(String var0);

    public static native String absolutePath(String var0);

    private static native boolean needEmulate(String var0);

    private static native String makeRelativePath(String var0);

    public static native void setFsModeTransparrent(boolean var0);

    public static native void removeBundleUpgrade();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillStatTable() throws IOException {
        InputStream inputStream = null;
        try {
            String string;
            File file = new File(RhoFileApi.getRootPath(), STAT_TABLE_FILENAME);
            if (file.exists() && file.isFile()) {
                Log.i((String)TAG, (String)("Opening stat table from FS: " + file.getCanonicalPath()));
                inputStream = new FileInputStream(file);
            } else {
                Log.i((String)TAG, (String)"Opening stat table from package assets");
                inputStream = am.open(STAT_TABLE_FILENAME);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(9);
                if (n == -1) continue;
                String string2 = string.substring(0, n);
                if ((n = (string = string.substring(n + 1)).indexOf(9)) == -1) continue;
                String string3 = string.substring(0, n);
                if ((n = (string = string.substring(n + 1)).indexOf(9)) == -1) continue;
                long l = Long.parseLong(string.substring(0, n));
                long l2 = Long.parseLong(string.substring(n + 1));
                RhoFileApi.updateStatTable(string2, string3, l, l2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    static void reloadStatTable() {
        Log.i((String)TAG, (String)"reloadStatTable()");
        try {
            RhoFileApi.fillStatTable();
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"Exception during update Stat Table !!!");
        }
    }

    static void patchStatTable(String string) {
    }

    private static void copyAssets(String[] stringArray) {
        for (String string : stringArray) {
            Log.i((String)TAG, (String)("Forsing file: " + string));
            RhoFileApi.forceFile(string);
        }
    }

    public static String initRootPath(String string, String string2, String string3) {
        root = string + "/rhodata/";
        String string4 = string + "/sqlite_stmt_journals/";
        File file = new File(RhoFileApi.getRootPath());
        file.mkdirs();
        file = new File(RhoFileApi.getDbFilesPath());
        file.mkdirs();
        file = new File(string4);
        file.mkdirs();
        file = new File(RhoFileApi.getTempPath());
        file.mkdirs();
        String string5 = string2;
        if (string3 == null || string3.length() == 0) {
            string3 = root;
        }
        Log.d((String)TAG, (String)("App root path: " + root));
        Log.d((String)TAG, (String)("Sqlite journals path: " + string4));
        Log.d((String)TAG, (String)("Shared path: " + string3));
        RhoFileApi.nativeInitPath(root, string4, string5, string3);
        return root;
    }

    public static void initLogPath(String string) {
        RhoFileApi.nativeInitLogPath(string);
    }

    public static String getRootPath() {
        return root;
    }

    public static String getDbFilesUriPath() {
        return DB_FILES_FOLDER;
    }

    public static String getDbFilesPath() {
        return new File(RhoFileApi.getRootPath(), DB_FILES_FOLDER).getAbsolutePath();
    }

    public static String getTempPath() {
        return new File(RhoFileApi.getRootPath(), TMP_FOLDER).getAbsolutePath();
    }

    public static void init(Context context) throws IOException {
        RhoFileApi.nativeInit();
        am = context.getAssets();
        RhoFileApi.fillStatTable();
    }

    public static void initialCopy(Context context, String[] stringArray) {
        am = context.getAssets();
        for (String string : stringArray) {
            RhoFileApi.forceFile(RhoFileApi.getRootPath() + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(String string) {
        boolean bl;
        Log.d((String)TAG, (String)("Copy " + string + " to FS"));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = am.open(string);
            File file = new File(root, string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                boolean bl2 = false;
                return bl2;
            }
            file2.mkdirs();
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            Log.d((String)TAG, (String)("File " + string + " copied"));
            bl = true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Can not copy " + string + " to FS"));
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static InputStream open(String string) {
        if (RhoFileApi.needEmulate(string)) {
            String string2 = RhoFileApi.makeRelativePath(string);
            return RhoFileApi.openInPackage(string2);
        }
        try {
            return new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private static void forceFile(String string) {
        String string2 = RhoFileApi.makeRelativePath(string);
        if (RhoFileApi.copy(string2)) {
            Logger.D(TAG, "File extracted from package to file system: " + string);
        }
    }

    public static FileDescriptor openFd(String string) {
        RhoFileApi.forceFile(string);
        try {
            Logger.D(TAG, "Opening file from file system: " + RhoFileApi.absolutePath(string));
            FileInputStream fileInputStream = new FileInputStream(RhoFileApi.absolutePath(string));
            return fileInputStream.getFD();
        }
        catch (Exception exception) {
            Logger.E(TAG, "Can not open file descriptor: " + exception.getMessage());
            return null;
        }
    }

    public static ParcelFileDescriptor openParcelFd(String string) {
        RhoFileApi.forceFile(string);
        try {
            Logger.D(TAG, "Opening file from file system: " + RhoFileApi.absolutePath(string));
            File file = new File(string);
            return ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.E(TAG, "Can not open ParcelFileDescriptor" + fileNotFoundException.getMessage());
            return null;
        }
    }

    public static InputStream openInPackage(String string) {
        try {
            InputStream inputStream = am.open(string, 1);
            inputStream.mark(0x200000);
            return inputStream;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.getMessage());
            return null;
        }
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        try {
            int n = inputStream.read(byArray);
            return n == -1 ? 0 : n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void seek(InputStream inputStream, int n) {
        try {
            long l;
            inputStream.reset();
            for (long i = 0L; i < (long)n && (l = inputStream.skip((long)n - i)) != 0L; i += l) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getChildren(String string) {
        try {
            String[] stringArray = am.list(string);
            File file = new File(root, string);
            String[] stringArray2 = file.list();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    arrayList.add(string2);
                }
            }
            if (stringArray2 != null) {
                for (String string2 : stringArray2) {
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
            }
            return arrayList.toArray(new String[0]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int copyRecursively(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            Utils.copyRecursively(new Utils.FileSource(), file, file2, true);
            return 0;
        }
        catch (Throwable throwable) {
            Logger.E(TAG, throwable.getMessage());
            return -1;
        }
    }

    public static int deleteRecursively(String string) {
        try {
            Utils.deleteRecursively(new File(string));
            return 0;
        }
        catch (Throwable throwable) {
            Logger.E(TAG, throwable.getMessage());
            return -1;
        }
    }
}

