/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes.util;

import android.content.res.AssetManager;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    public static String getContent(InputStream inputStream) throws IOException {
        int n;
        String string = "";
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) > 0) {
            string = string + new String(byArray);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContentsEquals(FileSource fileSource, String string, FileSource fileSource2, String string2) throws IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = fileSource.open(string);
            inputStream2 = fileSource2.open(string2);
            String string3 = Utils.getContent(inputStream);
            String string4 = Utils.getContent(inputStream2);
            boolean bl = string3.equals(string4);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
    }

    public static void deleteRecursively(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i != stringArray.length; ++i) {
                Utils.deleteRecursively(new File(file, stringArray[i]));
            }
        }
        if (!file.delete()) {
            throw new IOException("Can not delete " + file.getAbsolutePath());
        }
    }

    public static void deleteChildrenIgnoreFirstLevel(File file, String string) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i != stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    Utils.deleteRecursively(file2);
                    continue;
                }
                if (file2.getName().startsWith(string) || file2.delete()) continue;
                throw new IOException("Can not delete " + file2.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyRecursively(FileSource fileSource, File file, File file2, boolean bl) throws IOException {
        block14: {
            block13: {
                if (bl && file2.exists()) {
                    Utils.deleteRecursively(file2);
                }
                if (!file.isDirectory()) break block13;
                String[] stringArray = fileSource.list(file.getAbsolutePath());
                if (stringArray == null || stringArray.length <= 0) break block14;
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                for (String string : stringArray) {
                    Utils.copyRecursively(fileSource, new File(file, string), new File(file2, string), false);
                }
                break block14;
            }
            if (file.isFile()) {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    int n;
                    inputStream = fileSource.open(file.getAbsolutePath());
                    file2.getParentFile().mkdirs();
                    outputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (inputStream != null) {
                        throw fileNotFoundException;
                    }
                    file2.createNewFile();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static String getDirName(String string) {
        if (string == null) {
            return null;
        }
        return new File(string).getParent();
    }

    public static String getBaseName(String string) {
        if (string == null) {
            return null;
        }
        return new File(string).getName();
    }

    public static void platformLog(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ms[");
        stringBuilder.append(System.currentTimeMillis());
        stringBuilder.append("] ");
        stringBuilder.append(string2);
        Log.v((String)string, (String)stringBuilder.toString());
    }

    public static class AssetsSource
    extends FileSource {
        private AssetManager am;

        public AssetsSource(AssetManager assetManager) {
            this.am = assetManager;
        }

        @Override
        String[] list(String string) throws IOException {
            return this.am.list(string);
        }

        @Override
        InputStream open(String string) throws IOException {
            return this.am.open(string);
        }
    }

    public static class FileSource {
        String[] list(String string) throws IOException {
            return new File(string).list();
        }

        InputStream open(String string) throws FileNotFoundException, IOException {
            return new FileInputStream(string);
        }
    }
}

