Rhodes
===

[Rhodes](http://github.com/rhomobile/rhodes) is a framework for building locally executing, device-optimized mobile applications for smartphone devices. These applications are optimized for interacting with transactional enterprise application backends (with synced local data via [RhoConnect](http://rhomobile.com/products/rhoconnect)). Rhodes is available for iOS, Android, Windows Mobile, Symbian, and Research in Motion (Blackberry) smartphones.  

Rhodes is available as an open source product under the MIT license.  For developers interested a commercial license is still [available](http://rhomobile.com/products/rhodes/license/).

## Introduction  

Rhodes takes much of its inspiration from web-oriented MVC style frameworks such as Ruby on Rails. However it has several simplifications and optimizations for the mobile scenario. Some of these are to make it easier for the developer. Most of them are to keep the framework as lightweight as possible to be able to run on mobile devices with limited memory. As with developing apps on any good app framework (Rails, Merb, Django), building a Rhodes mobile application consists of building a set of files and putting them into the right directories for the respective models.

## Installing Rhodes

Install Rhodes:

	$ gem install rhodes

## Generating an Application

Rhodes features an application generator called 'rhodes' that generates a controller and views for a given model.  The syntax for running Rhodes is:

	$ rhodes app appname

This will generate a new directory called `appname` with several application files.

## Generate a Model and Associated Controller and Templates

	$ cd appname
	$ rhodes model modelname options

This will generate a model file, controller file, and several views (corresponding to the actions below). Each Rhodes model has several actions to perform basic CRUD (create, read, update and delete) on the object generated by default by the scaffold . Specifically the template views generated are:

    * index - to list all objects
    * new - to display the editing form for creating a new object
    * edit - to edit the actual object
    * show - to show the object attributes

## More Resources

There is a [tutorial available](http://docs.rhomobile.com/rhodes/tutorial) on the [Rhomobile site](http://www.rhomobile.com).  This includes thorough and current platform-by-platform build instructions.

The [Rhodes Developer Reference](http://docs.rhomobile.com/rhodes/introduction) for full documentation on the Rhodes framework.

For further questions [email us](mailto:info@rhomobile.com) or join the [Google Group](http://groups.google.com/group/rhomobile).

For questions on commercial support contact [our sales team](mailto:sales@rhomobile.com).