/*------------------------------------------------------------------------
* (The MIT License)
* 
* Copyright (c) 2008-2011 Rhomobile, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
* 
* http://rhomobile.com
*------------------------------------------------------------------------*/

package com.rhomobile.rhodes.extmanager;

import com.rhomobile.rhodes.RhodesActivity;

import android.app.Dialog;
import android.content.Intent;

public interface IRhoListener {

    void onCreate(RhodesActivity activity, Intent intent);
    void onStart(RhodesActivity activity);
    void onResume(RhodesActivity activity);
    void onPause(RhodesActivity activity);
    void onStop(RhodesActivity activity);
    void onDestroy(RhodesActivity activity);
    void onNewIntent(RhodesActivity activity, Intent intent);
    void onActivityResult(RhodesActivity activity, int requestCode, int resultCode, Intent intent);
    Dialog onCreateDialog(RhodesActivity activity, int id/*, Bundle args*/);

    void onCreateApplication(IRhoExtManager extManager);
}