﻿using System;
using rho.common;

namespace rho.sync
{
    public class SyncProtocol_3 : ISyncProtocol
    {
        String m_strContentType;

        public SyncProtocol_3()
        {
            m_strContentType = "application/json";
        }

        public String getContentType() { return m_strContentType; }
        public int getVersion() { return 3; }

        public String getLoginUrl()
        {
            if (RhoConf.getInstance().getPath("syncserver").Equals("http://rhoconnect-spec-wp.heroku.com/application/"))
                return "http://rhoconnect-spec-wp.heroku.com/api/application/clientlogin";
            else if (RhoConf.getInstance().getPath("syncserver").Equals("http://rhodes-samples-server.heroku.com/application/"))
                return "http://rhodes-samples-server.heroku.com/api/application/clientlogin";
            else
                return RhoConf.getInstance().getPath("syncserver") + "clientlogin";
        }

        public String getLoginBody(String name, String password)
        {
            return "{\"login\":\"" + name + "\",\"password\":\"" + password + "\",\"remember_me\":1}";
        }

        public String getClientCreateUrl()
        {
            return RhoConf.getInstance().getPath("syncserver") + "clientcreate";
        }

        public String getClientRegisterUrl()
        {
            return RhoConf.getInstance().getPath("syncserver") + "clientregister";
        }

        public String getClientRegisterBody(String strClientID, String strPin, int nPort, String strType)
        {
            return "{\"client_id\":\"" + strClientID +
                "\",\"device_pin\":\"" + strPin +
                "\",\"device_port\":\"" + nPort +
                "\",\"device_type\":\"" + strType + "\"}";
        }

        public String getClientResetUrl(String strClientID)
        {
            String strUrl = RhoConf.getInstance().getPath("syncserver") + "clientreset?client_id=" + strClientID;
            String strSources = RhoConf.getInstance().getString("reset_models");
            if ( strSources.length() > 0 )
                strUrl += strSources;

            return strUrl;
        }

        public String getClientChangesUrl()
        {
            String strUrl = RhoConf.getInstance().getPath("syncserver");
            return strUrl.substring(0, strUrl.length() - 1);
        }

        public String getServerQueryUrl(String strAction)
        {
            String strUrl = RhoConf.getInstance().getPath("syncserver");
            if (strAction.length() > 0)
                strUrl = CFilePath.join(strUrl, strAction);
            else
                strUrl = strUrl.substring(0, strUrl.length() - 1);

            return strUrl;
        }

        public String getServerQueryBody(String strSrcName, String strClientID, int nPageSize)
        {
            String strQuery = "?client_id=" + strClientID +
                    "&p_size=" + nPageSize + "&version=3";

            if (strSrcName.length() > 0)
                strQuery += "&source_name=" + strSrcName;

            return strQuery;
        }
    }
}
