//
//  UIColor+HIG.swift
//  Naterade
//
//  Created by Nathan Racklyeft on 1/23/16.
//  Copyright © 2016 Nathan Racklyeft. All rights reserved.
//

import UIKit


extension UIColor {
    // MARK: - HIG colors
    // See: https://developer.apple.com/ios/human-interface-guidelines/visual-design/color/

    static func HIGTealBlueColor() -> UIColor {
        return UIColor(red: 90 / 255, green: 200 / 255, blue: 250 / 255, alpha: 1)
    }

    static func HIGYellowColor() -> UIColor {
        return UIColor(red: 1, green: 204 / 255, blue: 0, alpha: 1)
    }

    static func HIGOrangeColor() -> UIColor {
        return UIColor(red: 1, green: 149 / 255, blue: 0 / 255, alpha: 1)
    }

    static func HIGPinkColor() -> UIColor {
        return UIColor(red: 1, green: 45 / 255, blue: 85 / 255, alpha: 1)
    }

    static func HIGBlueColor() -> UIColor {
        return UIColor(red: 0, green: 122 / 255, blue: 1, alpha: 1)
    }

    static func HIGGreenColor() -> UIColor {
        return UIColor(red: 76 / 255, green: 217 / 255, blue: 100 / 255, alpha: 1)
    }

    static func HIGRedColor() -> UIColor {
        return UIColor(red: 1, green: 59 / 255, blue: 48 / 255, alpha: 1)
    }

    static func HIGPurpleColor() -> UIColor {
        return UIColor(red: 88 / 255, green: 86 / 255, blue: 214 / 255, alpha: 1)
    }

    static func HIGGrayColor() -> UIColor {
        return UIColor(red: 142 / 255, green: 143 / 255, blue: 147 / 255, alpha: 1)
    }

}
