// ReSharper disable UnusedMember.Global
// ReSharper disable IdentifierTypo
// ReSharper disable CommentTypo

namespace Dot.Native;

internal static class VkCode
{
    public const int VK_A                   = 0x41; // A 键
    public const int VK_ACCEPT              = 0x1E; // IME 接受
    public const int VK_ADD                 = 0x6B; // 添加密钥
    public const int VK_APPS                = 0x5D; // 应用程序键 (自然键盘)
    public const int VK_ATTN                = 0xF6; // Attn 键
    public const int VK_B                   = 0x42; // B 键
    public const int VK_BACK                = 0x08; // BACKSPACE 密钥
    public const int VK_BROWSER_BACK        = 0xA6; // 浏览器后退键
    public const int VK_BROWSER_FAVORITES   = 0xAB; // 浏览器收藏键
    public const int VK_BROWSER_FORWARD     = 0xA7; // 浏览器前进键
    public const int VK_BROWSER_HOME        = 0xAC; // 浏览器“开始”和“主页”键
    public const int VK_BROWSER_REFRESH     = 0xA8; // 浏览器刷新键
    public const int VK_BROWSER_SEARCH      = 0xAA; // 浏览器搜索键
    public const int VK_BROWSER_STOP        = 0xA9; // 浏览器停止键
    public const int VK_C                   = 0x43; // C 键
    public const int VK_CANCEL              = 0x03; // 控制中断处理
    public const int VK_CAPITAL             = 0x14; // CAPS LOCK 键
    public const int VK_CLEAR               = 0x0C; // CLEAR 键
    public const int VK_CONTROL             = 0x11; // Ctrl 键
    public const int VK_CONVERT             = 0x1C; // IME 转换
    public const int VK_CRSEL               = 0xF7; // CrSel 键
    public const int VK_D                   = 0x44; // D 键
    public const int VK_DECIMAL             = 0x6E; // 十进制键
    public const int VK_DELETE              = 0x2E; // DEL 键
    public const int VK_DIVIDE              = 0x6F; // 除键
    public const int VK_DOWN                = 0x28; // 向下键
    public const int VK_E                   = 0x45; // E 键
    public const int VK_END                 = 0x23; // END 键
    public const int VK_EREOF               = 0xF9; // 擦除 EOF 密钥
    public const int VK_ESCAPE              = 0x1B; // ESC 键
    public const int VK_EXECUTE             = 0x2B; // EXECUTE 键
    public const int VK_EXSEL               = 0xF8; // ExSel 密钥
    public const int VK_F                   = 0x46; // F 键
    public const int VK_F1                  = 0x70; // F1         键
    public const int VK_F10                 = 0x79; // F10        键
    public const int VK_F11                 = 0x7A; // F11        键
    public const int VK_F12                 = 0x7B; // F12        键
    public const int VK_F13                 = 0x7C; // F13        键
    public const int VK_F14                 = 0x7D; // F14        键
    public const int VK_F15                 = 0x7E; // F15        键
    public const int VK_F16                 = 0x7F; // F16        键
    public const int VK_F17                 = 0x80; // F17        键
    public const int VK_F18                 = 0x81; // F18        键
    public const int VK_F19                 = 0x82; // F19        键
    public const int VK_F2                  = 0x71; // F2         键
    public const int VK_F20                 = 0x83; // F20        键
    public const int VK_F21                 = 0x84; // F21        键
    public const int VK_F22                 = 0x85; // F22        键
    public const int VK_F23                 = 0x86; // F23        键
    public const int VK_F24                 = 0x87; // F24        键
    public const int VK_F3                  = 0x72; // F3         键
    public const int VK_F4                  = 0x73; // F4         键
    public const int VK_F5                  = 0x74; // F5         键
    public const int VK_F6                  = 0x75; // F6         键
    public const int VK_F7                  = 0x76; // F7         键
    public const int VK_F8                  = 0x77; // F8         键
    public const int VK_F9                  = 0x78; // F9         键
    public const int VK_FINAL               = 0x18; // IME 最终模式
    public const int VK_G                   = 0x47; // G 键
    public const int VK_H                   = 0x48; // H 键
    public const int VK_HANGUEL             = 0x15; // IME 朝鲜文库埃尔模式 (保持兼容性;使用 VK_HANGUL)
    public const int VK_HANGUL              = 0x15; // IME Hanguel 模式
    public const int VK_HANJA               = 0x19; // IME Hanja 模式
    public const int VK_HELP                = 0x2F; // 帮助密钥
    public const int VK_HOME                = 0x24; // HOME 键
    public const int VK_I                   = 0x49; // I 键
    public const int VK_IME_OFF             = 0x1A; // IME 关闭
    public const int VK_IME_ON              = 0x16; // IME On
    public const int VK_INSERT              = 0x2D; // INS 密钥
    public const int VK_J                   = 0x4A; // J 键
    public const int VK_JUNJA               = 0x17; // IME Junja 模式
    public const int VK_K                   = 0x4B; // K 键
    public const int VK_KANA                = 0x15; // IME Kana 模式
    public const int VK_KANJI               = 0x19; // IME Kanji 模式
    public const int VK_L                   = 0x4C; // L 键
    public const int VK_LAUNCH_APP1         = 0xB6; // 启动应用程序 1 键
    public const int VK_LAUNCH_APP2         = 0xB7; // 启动应用程序 2 键
    public const int VK_LAUNCH_MAIL         = 0xB4; // 启动邮件键
    public const int VK_LAUNCH_MEDIA_SELECT = 0xB5; // 选择媒体键
    public const int VK_LBUTTON             = 0x01; // 鼠标左键
    public const int VK_LCONTROL            = 0xA2; // 左 Ctrl 键
    public const int VK_LEFT                = 0x25; // 向左键
    public const int VK_LMENU               = 0xA4; // 左 Alt 键
    public const int VK_LSHIFT              = 0xA0; // 左 SHIFT 键
    public const int VK_LWIN                = 0x5B; // 左Windows键 (自然键盘)
    public const int VK_M                   = 0x4D; // M 键
    public const int VK_MBUTTON             = 0x04; // 中间鼠标按钮 (三键鼠标)
    public const int VK_MEDIA_NEXT_TRACK    = 0xB0; // 下一曲目键
    public const int VK_MEDIA_PLAY_PAUSE    = 0xB3; // 播放/暂停媒体键
    public const int VK_MEDIA_PREV_TRACK    = 0xB1; // 上一曲目键
    public const int VK_MEDIA_STOP          = 0xB2; // 停止媒体键
    public const int VK_MENU                = 0x12; // Alt 键
    public const int VK_MODECHANGE          = 0x1F; // IME 模式更改请求
    public const int VK_MULTIPLY            = 0x6A; // 乘键
    public const int VK_N                   = 0x4E; // N 键
    public const int VK_NEXT                = 0x22; // PAGE DOWN 键
    public const int VK_NONAME              = 0xFC; // 预留
    public const int VK_NONCONVERT          = 0x1D; // IME 不转换
    public const int VK_NUMLOCK             = 0x90; // NUM    LOCK 密钥
    public const int VK_NUMPAD0             = 0x60; // 数字键盘 0 键
    public const int VK_NUMPAD1             = 0x61; // 数字键盘 1 键
    public const int VK_NUMPAD2             = 0x62; // 数字键盘 2 键
    public const int VK_NUMPAD3             = 0x63; // 数字键盘 3 键
    public const int VK_NUMPAD4             = 0x64; // 数字键盘 4 键
    public const int VK_NUMPAD5             = 0x65; // 数字键盘 5 键
    public const int VK_NUMPAD6             = 0x66; // 数字键盘 6 键
    public const int VK_NUMPAD7             = 0x67; // 数字键盘 7 键
    public const int VK_NUMPAD8             = 0x68; // 数字键盘 8 键
    public const int VK_NUMPAD9             = 0x69; // 数字键盘 9 键
    public const int VK_O                   = 0x4F; // O 键
    public const int VK_OEM_1               = 0xBA; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“;：”键
    public const int VK_OEM_102             = 0xE2; // <>美国标准键盘上的键，或\\|非美国 102 键键盘上的键
    public const int VK_OEM_2               = 0xBF; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“/？” key
    public const int VK_OEM_3               = 0xC0; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“~”键
    public const int VK_OEM_4               = 0xDB; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“[{”键
    public const int VK_OEM_5               = 0xDC; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“\|”键
    public const int VK_OEM_6               = 0xDD; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“]}”键
    public const int VK_OEM_7               = 0xDE; // 用于其他字符;它可能因键盘而异。 对于美国标准键盘，“单引号/双引号”键
    public const int VK_OEM_8               = 0xDF; // 用于其他字符;它可能因键盘而异。
    public const int VK_OEM_CLEAR           = 0xFE; // 清除键
    public const int VK_OEM_COMMA           = 0xBC; // 对于任何国家/地区，“，键
    public const int VK_OEM_MINUS           = 0xBD; // 对于任何国家/地区，“-”键
    public const int VK_OEM_PERIOD          = 0xBE; // 对于任何国家/地区，“.”键
    public const int VK_OEM_PLUS            = 0xBB; // 对于任何国家/地区，“+”键
    public const int VK_P                   = 0x50; // P 键
    public const int VK_PA1                 = 0xFD; // PA1 键
    public const int VK_PACKET              = 0xE7; //   用于将 Unicode 字符当作键击传递。
    public const int VK_PAUSE               = 0x13; // PAUSE 键
    public const int VK_PLAY                = 0xFA; // 播放键
    public const int VK_PRINT               = 0x2A; // PRINT 键
    public const int VK_PRIOR               = 0x21; // PAGE UP 键
    public const int VK_PROCESSKEY          = 0xE5; // IME PROCESS 密钥
    public const int VK_Q                   = 0x51; // Q 键
    public const int VK_R                   = 0x52; // R 键
    public const int VK_RBUTTON             = 0x02; // 鼠标右键
    public const int VK_RCONTROL            = 0xA3; // 右 Ctrl 键
    public const int VK_RETURN              = 0x0D; // Enter 键
    public const int VK_RIGHT               = 0x27; // 向右键
    public const int VK_RMENU               = 0xA5; // 右 ALT 键
    public const int VK_RSHIFT              = 0xA1; // 右 SHIFT 键
    public const int VK_RWIN                = 0x5C; // 右Windows键 (自然键盘)
    public const int VK_S                   = 0x53; // S 键
    public const int VK_SCROLL              = 0x91; // SCROLL LOCK 键
    public const int VK_SELECT              = 0x29; // SELECT 键
    public const int VK_SEPARATOR           = 0x6C; // 分隔符键
    public const int VK_SHIFT               = 0x10; // SHIFT 键
    public const int VK_SLEEP               = 0x5F; // 计算机休眠键
    public const int VK_SNAPSHOT            = 0x2C; // 打印屏幕键
    public const int VK_SPACE               = 0x20; // 空格键
    public const int VK_SUBTRACT            = 0x6D; // 减去键
    public const int VK_T                   = 0x54; // T 键
    public const int VK_TAB                 = 0x09; // Tab       键
    public const int VK_U                   = 0x55; // U 键
    public const int VK_UP                  = 0x26; // 向上键
    public const int VK_V                   = 0x56; // V 键
    public const int VK_VOLUME_DOWN         = 0xAE; // 音量减小键
    public const int VK_VOLUME_MUTE         = 0xAD; // 静音键
    public const int VK_VOLUME_UP           = 0xAF; // 音量增加键
    public const int VK_W                   = 0x57; // W 键
    public const int VK_X                   = 0x58; // X 键
    public const int VK_XBUTTON1            = 0x05; // X1    鼠标按钮
    public const int VK_XBUTTON2            = 0x06; // X2    鼠标按钮
    public const int VK_Y                   = 0x59; // Y 键
    public const int VK_Z                   = 0x5A; // Z 键
    public const int VK_ZOOM                = 0xFB; // 缩放键
}