<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:bom="http://cyclonedx.org/schema/bom/1.6"
    exclude-result-prefixes="bom">

  <xsl:output method="html" encoding="UTF-8" indent="yes"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>Software Bill of Materials</title>
        <style>
          body {
            font-family: sans-serif;
            margin: 20px;
            background-color: #f0f4fb;
            color: #000;
          }
          h1 {
            text-align: left;
            color: #2c3e50;
            font-size: 2em;
            margin-bottom: 0.5em;
          }
          h2 {
            color: #3a4f7a;
            border-bottom: 2px solid #ccc;
            padding-bottom: 5px;
            margin-top: 40px;
            margin-bottom: 15px;
          }
          table {
            border-collapse: collapse;
            background-color: #fff;
            color: #000;
            margin-top: 10px;
            margin-bottom: 40px;
            border-radius: 6px;
            overflow: hidden;
          }
          .metadata-table {
            width: auto;
            margin: 0;
            padding: 0;
          }
          th, td {
            padding: 10px 10px;
            text-align: left;
            border-bottom: 1px solid #ccc;
          }
          tr {
            line-height: 2;
          }
          th {
            background-color: #d0def0;
            font-weight: bold;
            color: #1b2e4b;
          }
          a {
            color: #003366;
            text-decoration: none;
          }
          a:hover {
            text-decoration: underline;
          }
          .footer {
            margin-top: 50px;
            font-size: 0.9em;
            color: #666;
            text-align: center;
          }
          ul {
            list-style: none;
            padding: 0;
            margin: 10px 0 30px 0;
          }
          li {
            margin-bottom: 5px;
          }
          .index a {
            color: #000;
            text-decoration: underline;
          }
          .back-to-top {
            display: inline-block;
            margin-top: 20px;
            font-size: 0.9em;
            color: #003366;
            text-decoration: none;
          }
          .back-to-top::before {
            content: "↑ ";
            font-weight: bold;
            margin-right: 4px;
          }
          .back-to-top:hover {
            text-decoration: underline;
          }
        </style>
      </head>
      <body>
        <h1>Software Bill of Materials - ownCloud Android app</h1>

        <div class="index">
          <h2>Index</h2>
          <ul>
            <li><a href="#metadata">Metadata</a></li>
            <li><a href="#components">Components</a></li>
          </ul>
        </div>

        <!-- Metadata Section -->
        <h2 id="metadata">Metadata</h2>
        <table class="metadata-table">
          <tr><th>Creation Date</th><td><xsl:call-template name="format-date"><xsl:with-param name="timestamp" select="bom:bom/bom:metadata/bom:timestamp"/></xsl:call-template></td></tr>
          <tr><th>Generated by</th>
            <td>
              <xsl:for-each select="bom:bom/bom:metadata/bom:tools/bom:components/bom:component">
                <xsl:value-of select="bom:name"/> <xsl:text> </xsl:text><xsl:value-of select="bom:version"/>
              </xsl:for-each>
            </td>
          </tr>
        </table>

        <!-- Components Section -->
        <h2 id="components">Components</h2>
        <table style="width: 100%;">
          <tr>
            <th style="width: 10%;">Type</th>
            <th style="width: 15%;">Group</th>
            <th style="width: 20%;">Name</th>
            <th style="width: 10%;">Version</th>
            <th style="width: 10%;">License</th>
            <th style="width: 35%;">PURL</th>
          </tr>
          <xsl:for-each select="bom:bom/bom:components/bom:component">
            <tr>
              <td><xsl:value-of select="@type"/></td>
              <td><xsl:value-of select="bom:group"/></td>
              <td><xsl:value-of select="bom:name"/></td>
              <td><xsl:value-of select="bom:version"/></td>
              <td><xsl:value-of select="bom:licenses/bom:license/bom:id"/></td>
              <td><xsl:value-of select="bom:purl"/></td>
            </tr>
          </xsl:for-each>
        </table>

        <div><a class="back-to-top" href="#metadata">Back to top</a></div>

        <div class="footer">
          Document generated from CycloneDX SBOM using XSLT styling.
        </div>
      </body>
    </html>
  </xsl:template>

  <!-- Helper: Convert ISO timestamp to readable date -->
  <xsl:template name="format-date">
    <xsl:param name="timestamp"/>
    <xsl:variable name="year" select="substring($timestamp, 1, 4)"/>
    <xsl:variable name="month" select="substring($timestamp, 6, 2)"/>
    <xsl:variable name="day" select="substring($timestamp, 9, 2)"/>
    <xsl:variable name="hour" select="substring($timestamp, 12, 2)"/>
    <xsl:variable name="minute" select="substring($timestamp, 15, 2)"/>
    <xsl:variable name="monthName">
      <xsl:choose>
        <xsl:when test="$month = '01'">January</xsl:when>
        <xsl:when test="$month = '02'">February</xsl:when>
        <xsl:when test="$month = '03'">March</xsl:when>
        <xsl:when test="$month = '04'">April</xsl:when>
        <xsl:when test="$month = '05'">May</xsl:when>
        <xsl:when test="$month = '06'">June</xsl:when>
        <xsl:when test="$month = '07'">July</xsl:when>
        <xsl:when test="$month = '08'">August</xsl:when>
        <xsl:when test="$month = '09'">September</xsl:when>
        <xsl:when test="$month = '10'">October</xsl:when>
        <xsl:when test="$month = '11'">November</xsl:when>
        <xsl:when test="$month = '12'">December</xsl:when>
        <xsl:otherwise>Unknown</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="concat($day, ' ', $monthName, ' ', $year, ', ', $hour, ':', $minute, ' UTC')"/>
  </xsl:template>

</xsl:stylesheet>

