# Public API

## Namespaces & Types

### Nuke.Common.ChangeLog

- ChangeLog
- ChangelogTasks
- ReleaseNotes

### Nuke.Common.CI.AppVeyor

- AppVeyor
- AppVeyorAttribute
- AppVeyorImage
- AppVeyorMessageCategory
- AppVeyorService

### Nuke.Common.CI.AppVeyor.Configuration

- AppVeyorBranches
- AppVeyorConfiguration
- AppVeyorCustomWriterExtensions

### Nuke.Common.CI

- ArtifactExtensions
- ChainedConfigurationAttributeBase
- CIAttribute
- ConfigurationAttributeBase
- ConfigurationEntity
- NoConvertAttribute
- Partition
- Partition.TypeConverter
- PartitionAttribute

### Nuke.Common.CI.AzurePipelines

- AzurePipelines
- AzurePipelinesAttribute
- AzurePipelinesBuildReason
- AzurePipelinesCodeCoverageToolType
- AzurePipelinesImage
- AzurePipelinesIssueType
- AzurePipelinesJobStatus
- AzurePipelinesRepositoryType
- AzurePipelinesTestResultsType

### Nuke.Common.CI.AzurePipelines.Configuration

- AzurePipelinesConfiguration
- AzurePipelinesCustomWriterExtensions
- AzurePipelinesJob
- AzurePipelinesStage

### Nuke.Common.CI.Bamboo

- Bamboo

### Nuke.Common.CI.Bitrise

- Bitrise

### Nuke.Common.CI.GitHubActions.Configuration

- GitHubActionsArtifactStep
- GitHubActionsConfiguration
- GitHubActionsDetailedTrigger
- GitHubActionsJob
- GitHubActionsRunStep
- GitHubActionsScheduledTrigger
- GitHubActionsStep
- GitHubActionsUsingStep
- GitHubActionsVcsTrigger

### Nuke.Common.CI.GitHubActions

- GitHubActions
- GitHubActionsAttribute
- GitHubActionsImage
- GitHubActionsTrigger

### Nuke.Common.CI.GitLab

- GitLab
- GitLabProjectVisibility

### Nuke.Common.CI.Jenkins

- Jenkins

### Nuke.Common.CI.TeamCity

- Build
- BuildQueue
- DotNetBuildSettingsExtensions
- ITeamCityRestClient
- MSBuildSettingsExtensions
- TeamCity
- TeamCityAgentPlatform
- TeamCityAttribute
- TeamCityImportTool
- TeamCityImportType
- TeamCityNoDataPublishedAction
- TeamCityRestObject
- TeamCityStatus

### Nuke.Common.CI.TeamCity.Configuration

- TeamCityArtifactDependency
- TeamCityBuildType
- TeamCityBuildTypeVcsRoot
- TeamCityConfiguration
- TeamCityConfigurationParameter
- TeamCityCustomWriterExtensions
- TeamCityDependency
- TeamCityDependencyFailureAction
- TeamCityFinishBuildTrigger
- TeamCityKeyValueParameter
- TeamCityParameter
- TeamCityParameterDisplay
- TeamCityParameterType
- TeamCityProject
- TeamCityScheduledTrigger
- TeamCitySnapshotDependency
- TeamCityTrigger
- TeamCityVcsRoot
- TeamCityVcsTrigger

### Nuke.Common.CI.TravisCI

- TravisCI
- TravisCIEventType

### Nuke.Common

- Configuration
- ControlFlow
- DependencyBehavior
- EnvironmentInfo
- ExecutableTargetExtensions
- HostType
- ITargetDefinition
- Logger
- LogLevel
- NukeBuild
- ParameterAttribute
- PlatformFamily
- RequiredAttribute
- SpecialFolders
- Target
- TargetDefinitionExtensions
- Verbosity

### Nuke.Common.Execution

- CheckBuildProjectConfigurationsAttribute
- CheckPathEnvironmentVariableAttribute
- ExecutableTarget
- ExecutionStatus
- HandleVisualStudioDebuggingAttribute
- IBuildExtension
- InjectionAttributeBase
- InjectionUtility
- IOnAfterLogo
- IOnBeforeLogo
- IOnBuildFinished
- ReflectionService
- UnsetVisualStudioEnvironmentVariablesAttribute

### Nuke.Common.Git

- GitHubItemType
- GitRepository
- GitRepositoryAttribute
- GitRepositoryExtensions

### Nuke.Common.Gitter

- GitterTasks

### Nuke.Common.IO

- CompressionTasks
- DirectoryExistsPolicy
- DirectoryGlobbingAttribute
- FileExistsPolicy
- FileGlobbingAttribute
- FileSystemGlobbingAttributeBase
- FileSystemTasks
- FtpTasks
- GlobbingCaseSensitivity
- GlobbingOptionsAttribute
- HttpTasks
- PathConstruction
- PathConstruction.AbsolutePath
- PathConstruction.AbsolutePath.TypeConverter
- PathConstruction.RelativePath
- PathConstruction.UnixRelativePath
- PathConstruction.WinRelativePath
- SerializationTasks
- TextTasks
- XmlTasks

### Nuke.Common.OutputSinks

- FigletTransform
- IOutputSink

### Nuke.Common.ProjectModel

- PrimitiveProject
- Project
- ProjectExtensions
- ProjectModelTasks
- ProjectType
- Solution
- SolutionAttribute
- SolutionFolder

### Nuke.Common.Tooling

- Arguments
- CombinatorialConfigure<T>
- Configure<T>
- ConfigureExtensions
- Enumeration
- Enumeration.TypeConverter<T>
- EnumerationExtensions
- EnumValueAttribute
- ExtensionHelper
- IArguments
- IProcess
- ISettingsEntity
- LocalExecutableAttribute
- LookupTable<TKey, TValue>
- LookupTableExtensions
- NuGetPackageResolver
- NuGetPackageResolver.InstalledPackage
- NuGetPackageResolver.InstalledPackage.Comparer
- Output
- OutputType
- PackageExecutableAttribute
- PaketPackageResolver
- PathExecutableAttribute
- Process2
- ProcessException
- ProcessExtensions
- ProcessTasks
- SettingsEntityExtensions
- Tool
- ToolPathResolver
- ToolResolver
- ToolSettings
- ToolSettingsExtensions
- VerbosityMapping
- VerbosityMappingAttribute

### Nuke.Common.Tools.AzureKeyVault.Attributes

- KeyVaultAttribute
- KeyVaultCertificateAttribute
- KeyVaultKeyAttribute
- KeyVaultSecretAttribute
- KeyVaultSettings
- KeyVaultSettingsAttribute

### Nuke.Common.Tools.AzureKeyVault

- KeyVault
- KeyVaultCertificate
- KeyVaultKey
- KeyVaultTasks
- KeyVaultTaskSettings
- KeyVaultTaskSettingsExtensions

### Nuke.Common.Tools.CloudFoundry

- CloudFoundryApiSettings
- CloudFoundryApiSettingsExtensions
- CloudFoundryAuthSettings
- CloudFoundryAuthSettingsExtensions
- CloudFoundryBindServiceSettings
- CloudFoundryBindServiceSettingsExtensions
- CloudFoundryCreateRouteSettings
- CloudFoundryCreateRouteSettingsExtensions
- CloudFoundryCreateServiceSettings
- CloudFoundryCreateServiceSettingsExtensions
- CloudFoundryCreateSpaceSettings
- CloudFoundryCreateSpaceSettingsExtensions
- CloudFoundryCreateUserProvidedServiceSettings
- CloudFoundryCreateUserProvidedServiceSettingsExtensions
- CloudFoundryCurlSettings
- CloudFoundryCurlSettingsExtensions
- CloudFoundryDeleteApplicationSettings
- CloudFoundryDeleteApplicationSettingsExtensions
- CloudFoundryDeleteServiceSettings
- CloudFoundryDeleteServiceSettingsExtensions
- CloudFoundryDeleteSpaceSettings
- CloudFoundryDeleteSpaceSettingsExtensions
- CloudFoundryGetServiceInfoSettings
- CloudFoundryGetServiceInfoSettingsExtensions
- CloudFoundryLoginSettings
- CloudFoundryLoginSettingsExtensions
- CloudFoundryMapRouteSettings
- CloudFoundryMapRouteSettingsExtensions
- CloudFoundryPushSettings
- CloudFoundryPushSettingsExtensions
- CloudFoundryRestageSettings
- CloudFoundryRestageSettingsExtensions
- CloudFoundryRestartSettings
- CloudFoundryRestartSettingsExtensions
- CloudFoundryScaleSettings
- CloudFoundryScaleSettingsExtensions
- CloudFoundrySetEnvSettings
- CloudFoundrySetEnvSettingsExtensions
- CloudFoundryStartSettings
- CloudFoundryStartSettingsExtensions
- CloudFoundryStopSettings
- CloudFoundryStopSettingsExtensions
- CloudFoundryTargetSettings
- CloudFoundryTargetSettingsExtensions
- CloudFoundryTasks
- CloudFoundryUnbindServiceSettings
- CloudFoundryUnbindServiceSettingsExtensions
- CloudFoundryUnmapRouteSettings
- CloudFoundryUnmapRouteSettingsExtensions
- CloudFoundryUnsetEnvSettings
- CloudFoundryUnsetEnvSettingsExtensions
- HealthCheckType
- Stack

### Nuke.Common.Tools.CoverallsNet

- CoverallsNetSettings
- CoverallsNetSettingsExtensions
- CoverallsNetTasks

### Nuke.Common.Tools.Coverlet

- CoverletOutputFormat
- CoverletSettings
- CoverletSettingsExtensions
- CoverletTasks
- CoverletThresholdType
- DotNetTestSettingsExtensions

### Nuke.Common.Tools.DocFX

- DocFXBuildSettings
- DocFXBuildSettingsExtensions
- DocFXDependencySettings
- DocFXDependencySettingsExtensions
- DocFXDownloadSettings
- DocFXDownloadSettingsExtensions
- DocFXHelpSettings
- DocFXHelpSettingsExtensions
- DocFXInitSettings
- DocFXInitSettingsExtensions
- DocFXLogLevel
- DocFXMergeSettings
- DocFXMergeSettingsExtensions
- DocFXMetadataSettings
- DocFXMetadataSettingsExtensions
- DocFXPdfSettings
- DocFXPdfSettingsExtensions
- DocFXServeSettings
- DocFXServeSettingsExtensions
- DocFXTasks
- DocFXTemplateCommand
- DocFXTemplateSettings
- DocFXTemplateSettingsExtensions

### Nuke.Common.Tools.Docker

- Availability
- CliSettings
- DockerAttachSettings
- DockerAttachSettingsExtensions
- DockerBuilderBuildSettings
- DockerBuilderBuildSettingsExtensions
- DockerBuilderPruneSettings
- DockerBuilderPruneSettingsExtensions
- DockerBuilderSettings
- DockerBuilderSettingsExtensions
- DockerBuildSettings
- DockerBuildSettingsExtensions
- DockerCheckpointCreateSettings
- DockerCheckpointCreateSettingsExtensions
- DockerCheckpointLsSettings
- DockerCheckpointLsSettingsExtensions
- DockerCheckpointRmSettings
- DockerCheckpointRmSettingsExtensions
- DockerCheckpointSettings
- DockerCheckpointSettingsExtensions
- DockerCommitSettings
- DockerCommitSettingsExtensions
- DockerConfigCreateSettings
- DockerConfigCreateSettingsExtensions
- DockerConfigInspectSettings
- DockerConfigInspectSettingsExtensions
- DockerConfigLsSettings
- DockerConfigLsSettingsExtensions
- DockerConfigRmSettings
- DockerConfigRmSettingsExtensions
- DockerConfigSettings
- DockerConfigSettingsExtensions
- DockerContainerAttachSettings
- DockerContainerAttachSettingsExtensions
- DockerContainerCommitSettings
- DockerContainerCommitSettingsExtensions
- DockerContainerCreateSettings
- DockerContainerCreateSettingsExtensions
- DockerContainerDiffSettings
- DockerContainerDiffSettingsExtensions
- DockerContainerExecSettings
- DockerContainerExecSettingsExtensions
- DockerContainerExportSettings
- DockerContainerExportSettingsExtensions
- DockerContainerInspectSettings
- DockerContainerInspectSettingsExtensions
- DockerContainerKillSettings
- DockerContainerKillSettingsExtensions
- DockerContainerLogsSettings
- DockerContainerLogsSettingsExtensions
- DockerContainerLsSettings
- DockerContainerLsSettingsExtensions
- DockerContainerPauseSettings
- DockerContainerPauseSettingsExtensions
- DockerContainerPortSettings
- DockerContainerPortSettingsExtensions
- DockerContainerPruneSettings
- DockerContainerPruneSettingsExtensions
- DockerContainerRenameSettings
- DockerContainerRenameSettingsExtensions
- DockerContainerRestartSettings
- DockerContainerRestartSettingsExtensions
- DockerContainerRmSettings
- DockerContainerRmSettingsExtensions
- DockerContainerRunSettings
- DockerContainerRunSettingsExtensions
- DockerContainerSettings
- DockerContainerSettingsExtensions
- DockerContainerStartSettings
- DockerContainerStartSettingsExtensions
- DockerContainerStatsSettings
- DockerContainerStatsSettingsExtensions
- DockerContainerStopSettings
- DockerContainerStopSettingsExtensions
- DockerContainerTopSettings
- DockerContainerTopSettingsExtensions
- DockerContainerUnpauseSettings
- DockerContainerUnpauseSettingsExtensions
- DockerContainerUpdateSettings
- DockerContainerUpdateSettingsExtensions
- DockerContainerWaitSettings
- DockerContainerWaitSettingsExtensions
- DockerContextCreateSettings
- DockerContextCreateSettingsExtensions
- DockerContextExportSettings
- DockerContextExportSettingsExtensions
- DockerContextImportSettings
- DockerContextImportSettingsExtensions
- DockerContextInspectSettings
- DockerContextInspectSettingsExtensions
- DockerContextLsSettings
- DockerContextLsSettingsExtensions
- DockerContextRmSettings
- DockerContextRmSettingsExtensions
- DockerContextSettings
- DockerContextSettingsExtensions
- DockerContextUpdateSettings
- DockerContextUpdateSettingsExtensions
- DockerContextUseSettings
- DockerContextUseSettingsExtensions
- DockerCreateSettings
- DockerCreateSettingsExtensions
- DockerDeploySettings
- DockerDeploySettingsExtensions
- DockerDiffSettings
- DockerDiffSettingsExtensions
- DockerEngineActivateSettings
- DockerEngineActivateSettingsExtensions
- DockerEngineCheckSettings
- DockerEngineCheckSettingsExtensions
- DockerEngineSettings
- DockerEngineSettingsExtensions
- DockerEngineUpdateSettings
- DockerEngineUpdateSettingsExtensions
- DockerEventsSettings
- DockerEventsSettingsExtensions
- DockerExecSettings
- DockerExecSettingsExtensions
- DockerExportSettings
- DockerExportSettingsExtensions
- DockerHistorySettings
- DockerHistorySettingsExtensions
- DockerImageBuildSettings
- DockerImageBuildSettingsExtensions
- DockerImageHistorySettings
- DockerImageHistorySettingsExtensions
- DockerImageImportSettings
- DockerImageImportSettingsExtensions
- DockerImageInspectSettings
- DockerImageInspectSettingsExtensions
- DockerImageLoadSettings
- DockerImageLoadSettingsExtensions
- DockerImageLsSettings
- DockerImageLsSettingsExtensions
- DockerImagePruneSettings
- DockerImagePruneSettingsExtensions
- DockerImagePullSettings
- DockerImagePullSettingsExtensions
- DockerImagePushSettings
- DockerImagePushSettingsExtensions
- DockerImageRmSettings
- DockerImageRmSettingsExtensions
- DockerImageSaveSettings
- DockerImageSaveSettingsExtensions
- DockerImageSettings
- DockerImageSettingsExtensions
- DockerImagesSettings
- DockerImagesSettingsExtensions
- DockerImageTagSettings
- DockerImageTagSettingsExtensions
- DockerImportSettings
- DockerImportSettingsExtensions
- DockerInfoSettings
- DockerInfoSettingsExtensions
- DockerInspectSettings
- DockerInspectSettingsExtensions
- DockerKillSettings
- DockerKillSettingsExtensions
- DockerLoadSettings
- DockerLoadSettingsExtensions
- DockerLoginSettings
- DockerLoginSettingsExtensions
- DockerLogoutSettings
- DockerLogoutSettingsExtensions
- DockerLogsSettings
- DockerLogsSettingsExtensions
- DockerManifestAnnotateSettings
- DockerManifestAnnotateSettingsExtensions
- DockerManifestCreateSettings
- DockerManifestCreateSettingsExtensions
- DockerManifestInspectSettings
- DockerManifestInspectSettingsExtensions
- DockerManifestPushSettings
- DockerManifestPushSettingsExtensions
- DockerManifestSettings
- DockerManifestSettingsExtensions
- DockerNetworkConnectSettings
- DockerNetworkConnectSettingsExtensions
- DockerNetworkCreateSettings
- DockerNetworkCreateSettingsExtensions
- DockerNetworkDisconnectSettings
- DockerNetworkDisconnectSettingsExtensions
- DockerNetworkInspectSettings
- DockerNetworkInspectSettingsExtensions
- DockerNetworkLsSettings
- DockerNetworkLsSettingsExtensions
- DockerNetworkPruneSettings
- DockerNetworkPruneSettingsExtensions
- DockerNetworkRmSettings
- DockerNetworkRmSettingsExtensions
- DockerNetworkSettings
- DockerNetworkSettingsExtensions
- DockerNodeDemoteSettings
- DockerNodeDemoteSettingsExtensions
- DockerNodeInspectSettings
- DockerNodeInspectSettingsExtensions
- DockerNodeLsSettings
- DockerNodeLsSettingsExtensions
- DockerNodePromoteSettings
- DockerNodePromoteSettingsExtensions
- DockerNodePsSettings
- DockerNodePsSettingsExtensions
- DockerNodeRmSettings
- DockerNodeRmSettingsExtensions
- DockerNodeSettings
- DockerNodeSettingsExtensions
- DockerNodeUpdateSettings
- DockerNodeUpdateSettingsExtensions
- DockerPauseSettings
- DockerPauseSettingsExtensions
- DockerPluginCreateSettings
- DockerPluginCreateSettingsExtensions
- DockerPluginDisableSettings
- DockerPluginDisableSettingsExtensions
- DockerPluginEnableSettings
- DockerPluginEnableSettingsExtensions
- DockerPluginInspectSettings
- DockerPluginInspectSettingsExtensions
- DockerPluginInstallSettings
- DockerPluginInstallSettingsExtensions
- DockerPluginLsSettings
- DockerPluginLsSettingsExtensions
- DockerPluginPushSettings
- DockerPluginPushSettingsExtensions
- DockerPluginRmSettings
- DockerPluginRmSettingsExtensions
- DockerPluginSetSettings
- DockerPluginSetSettingsExtensions
- DockerPluginSettings
- DockerPluginSettingsExtensions
- DockerPluginUpgradeSettings
- DockerPluginUpgradeSettingsExtensions
- DockerPortSettings
- DockerPortSettingsExtensions
- DockerPsSettings
- DockerPsSettingsExtensions
- DockerPullSettings
- DockerPullSettingsExtensions
- DockerPushSettings
- DockerPushSettingsExtensions
- DockerRenameSettings
- DockerRenameSettingsExtensions
- DockerRestartSettings
- DockerRestartSettingsExtensions
- DockerRmiSettings
- DockerRmiSettingsExtensions
- DockerRmSettings
- DockerRmSettingsExtensions
- DockerRunSettings
- DockerRunSettingsExtensions
- DockerSaveSettings
- DockerSaveSettingsExtensions
- DockerSearchSettings
- DockerSearchSettingsExtensions
- DockerSecretCreateSettings
- DockerSecretCreateSettingsExtensions
- DockerSecretInspectSettings
- DockerSecretInspectSettingsExtensions
- DockerSecretLsSettings
- DockerSecretLsSettingsExtensions
- DockerSecretRmSettings
- DockerSecretRmSettingsExtensions
- DockerSecretSettings
- DockerSecretSettingsExtensions
- DockerServiceCreateSettings
- DockerServiceCreateSettingsExtensions
- DockerServiceInspectSettings
- DockerServiceInspectSettingsExtensions
- DockerServiceLogsSettings
- DockerServiceLogsSettingsExtensions
- DockerServiceLsSettings
- DockerServiceLsSettingsExtensions
- DockerServicePsSettings
- DockerServicePsSettingsExtensions
- DockerServiceRmSettings
- DockerServiceRmSettingsExtensions
- DockerServiceRollbackSettings
- DockerServiceRollbackSettingsExtensions
- DockerServiceScaleSettings
- DockerServiceScaleSettingsExtensions
- DockerServiceSettings
- DockerServiceSettingsExtensions
- DockerServiceUpdateSettings
- DockerServiceUpdateSettingsExtensions
- DockerSettings
- DockerSettingsExtensions
- DockerStackDeploySettings
- DockerStackDeploySettingsExtensions
- DockerStackLsSettings
- DockerStackLsSettingsExtensions
- DockerStackPsSettings
- DockerStackPsSettingsExtensions
- DockerStackRmSettings
- DockerStackRmSettingsExtensions
- DockerStackServicesSettings
- DockerStackServicesSettingsExtensions
- DockerStackSettings
- DockerStackSettingsExtensions
- DockerStartSettings
- DockerStartSettingsExtensions
- DockerStatsSettings
- DockerStatsSettingsExtensions
- DockerStopSettings
- DockerStopSettingsExtensions
- DockerSwarmCaSettings
- DockerSwarmCaSettingsExtensions
- DockerSwarmInitSettings
- DockerSwarmInitSettingsExtensions
- DockerSwarmJoinSettings
- DockerSwarmJoinSettingsExtensions
- DockerSwarmJoinTokenSettings
- DockerSwarmJoinTokenSettingsExtensions
- DockerSwarmLeaveSettings
- DockerSwarmLeaveSettingsExtensions
- DockerSwarmSettings
- DockerSwarmSettingsExtensions
- DockerSwarmUnlockKeySettings
- DockerSwarmUnlockKeySettingsExtensions
- DockerSwarmUnlockSettings
- DockerSwarmUnlockSettingsExtensions
- DockerSwarmUpdateSettings
- DockerSwarmUpdateSettingsExtensions
- DockerSystemDfSettings
- DockerSystemDfSettingsExtensions
- DockerSystemEventsSettings
- DockerSystemEventsSettingsExtensions
- DockerSystemInfoSettings
- DockerSystemInfoSettingsExtensions
- DockerSystemPruneSettings
- DockerSystemPruneSettingsExtensions
- DockerSystemSettings
- DockerSystemSettingsExtensions
- DockerTagSettings
- DockerTagSettingsExtensions
- DockerTasks
- DockerTopSettings
- DockerTopSettingsExtensions
- DockerTrustInspectSettings
- DockerTrustInspectSettingsExtensions
- DockerTrustKeyGenerateSettings
- DockerTrustKeyGenerateSettingsExtensions
- DockerTrustKeyLoadSettings
- DockerTrustKeyLoadSettingsExtensions
- DockerTrustKeySettings
- DockerTrustKeySettingsExtensions
- DockerTrustRevokeSettings
- DockerTrustRevokeSettingsExtensions
- DockerTrustSettings
- DockerTrustSettingsExtensions
- DockerTrustSignerAddSettings
- DockerTrustSignerAddSettingsExtensions
- DockerTrustSignerRemoveSettings
- DockerTrustSignerRemoveSettingsExtensions
- DockerTrustSignerSettings
- DockerTrustSignerSettingsExtensions
- DockerTrustSignSettings
- DockerTrustSignSettingsExtensions
- DockerUnpauseSettings
- DockerUnpauseSettingsExtensions
- DockerUpdateSettings
- DockerUpdateSettingsExtensions
- DockerVersionSettings
- DockerVersionSettingsExtensions
- DockerVolumeCreateSettings
- DockerVolumeCreateSettingsExtensions
- DockerVolumeInspectSettings
- DockerVolumeInspectSettingsExtensions
- DockerVolumeLsSettings
- DockerVolumeLsSettingsExtensions
- DockerVolumePruneSettings
- DockerVolumePruneSettingsExtensions
- DockerVolumeRmSettings
- DockerVolumeRmSettingsExtensions
- DockerVolumeSettings
- DockerVolumeSettingsExtensions
- DockerWaitSettings
- DockerWaitSettingsExtensions
- LogLevel
- ResolveImage
- RestartCondition
- Role
- RollbackFailureAction
- RollbackOrder
- UpdateFailureAction
- UpdateOrder

### Nuke.Common.Tools.DotCover

- DotCoverAnalyseSettings
- DotCoverAnalyseSettingsExtensions
- DotCoverCoverSettings
- DotCoverCoverSettingsExtensions
- DotCoverDeleteSettings
- DotCoverDeleteSettingsExtensions
- DotCoverMergeSettings
- DotCoverMergeSettingsExtensions
- DotCoverReportSettings
- DotCoverReportSettingsExtensions
- DotCoverReportType
- DotCoverTasks
- DotCoverZipSettings
- DotCoverZipSettingsExtensions
- TeamCitySetDotCoverHomePathAttribute

### Nuke.Common.Tools.DotMemoryUnit

- DotMemoryUnitTasks

### Nuke.Common.Tools.DotNet

- DotNetBuildSettings
- DotNetBuildSettingsExtensions
- DotNetCleanSettings
- DotNetCleanSettingsExtensions
- DotNetNuGetPushSettings
- DotNetNuGetPushSettingsExtensions
- DotNetPackSettings
- DotNetPackSettingsExtensions
- DotNetPublishSettings
- DotNetPublishSettingsExtensions
- DotNetRestoreSettings
- DotNetRestoreSettingsExtensions
- DotNetRunSettings
- DotNetRunSettingsExtensions
- DotNetSymbolPackageFormat
- DotNetTasks
- DotNetTestSettings
- DotNetTestSettingsExtensions
- DotNetToolInstallSettings
- DotNetToolInstallSettingsExtensions
- DotNetToolUninstallSettings
- DotNetToolUninstallSettingsExtensions
- DotNetToolUpdateSettings
- DotNetToolUpdateSettingsExtensions
- DotNetVerbosity
- DotNetVerbosityMappingAttribute

### Nuke.Common.Tools.DupFinder

- DupFinderSettings
- DupFinderSettingsExtensions
- DupFinderTasks

### Nuke.Common.Tools.EntityFramework

- EntityFrameworkDatabaseDropSettings
- EntityFrameworkDatabaseDropSettingsExtensions
- EntityFrameworkDatabaseUpdateSettings
- EntityFrameworkDatabaseUpdateSettingsExtensions
- EntityFrameworkDbContextInfoSettings
- EntityFrameworkDbContextInfoSettingsExtensions
- EntityFrameworkDbContextListSettings
- EntityFrameworkDbContextListSettingsExtensions
- EntityFrameworkDbContextScaffoldSettings
- EntityFrameworkDbContextScaffoldSettingsExtensions
- EntityFrameworkMigrationsAddSettings
- EntityFrameworkMigrationsAddSettingsExtensions
- EntityFrameworkMigrationsListSettings
- EntityFrameworkMigrationsListSettingsExtensions
- EntityFrameworkMigrationsRemoveSettings
- EntityFrameworkMigrationsRemoveSettingsExtensions
- EntityFrameworkMigrationsScriptSettings
- EntityFrameworkMigrationsScriptSettingsExtensions
- EntityFrameworkTasks

### Nuke.Common.Tools.Git

- GitTasks

### Nuke.Common.Tools.GitHub

- GitHubTasks

### Nuke.Common.Tools.GitLink

- GitLink2Settings
- GitLink2SettingsExtensions
- GitLink3Settings
- GitLink3SettingsExtensions
- GitLinkSourceCodeRetrieval
- GitLinkTasks

### Nuke.Common.Tools.GitReleaseManager

- GitReleaseManagerAddAssetsSettings
- GitReleaseManagerAddAssetsSettingsExtensions
- GitReleaseManagerCloseSettings
- GitReleaseManagerCloseSettingsExtensions
- GitReleaseManagerCreateSettings
- GitReleaseManagerCreateSettingsExtensions
- GitReleaseManagerExportSettings
- GitReleaseManagerExportSettingsExtensions
- GitReleaseManagerPublishSettings
- GitReleaseManagerPublishSettingsExtensions
- GitReleaseManagerTasks

### Nuke.Common.Tools.GitVersion

- GitVersion
- GitVersionAttribute
- GitVersionOutput
- GitVersionSettings
- GitVersionSettingsExtensions
- GitVersionTasks
- GitVersionVerbosity

### Nuke.Common.Tools.Helm

- HelmCommonSettings
- HelmCommonSettingsExtensions
- HelmCompletionSettings
- HelmCompletionSettingsExtensions
- HelmCreateSettings
- HelmCreateSettingsExtensions
- HelmDeleteSettings
- HelmDeleteSettingsExtensions
- HelmDependencyBuildSettings
- HelmDependencyBuildSettingsExtensions
- HelmDependencyListSettings
- HelmDependencyListSettingsExtensions
- HelmDependencyUpdateSettings
- HelmDependencyUpdateSettingsExtensions
- HelmFetchSettings
- HelmFetchSettingsExtensions
- HelmGetHooksSettings
- HelmGetHooksSettingsExtensions
- HelmGetManifestSettings
- HelmGetManifestSettingsExtensions
- HelmGetNotesSettings
- HelmGetNotesSettingsExtensions
- HelmGetSettings
- HelmGetSettingsExtensions
- HelmGetValuesSettings
- HelmGetValuesSettingsExtensions
- HelmHistorySettings
- HelmHistorySettingsExtensions
- HelmHomeSettings
- HelmHomeSettingsExtensions
- HelmInitSettings
- HelmInitSettingsExtensions
- HelmInspectChartSettings
- HelmInspectChartSettingsExtensions
- HelmInspectReadmeSettings
- HelmInspectReadmeSettingsExtensions
- HelmInspectSettings
- HelmInspectSettingsExtensions
- HelmInspectValuesSettings
- HelmInspectValuesSettingsExtensions
- HelmInstallSettings
- HelmInstallSettingsExtensions
- HelmLintSettings
- HelmLintSettingsExtensions
- HelmListSettings
- HelmListSettingsExtensions
- HelmOutputFormat
- HelmPackageSettings
- HelmPackageSettingsExtensions
- HelmPluginInstallSettings
- HelmPluginInstallSettingsExtensions
- HelmPluginListSettings
- HelmPluginListSettingsExtensions
- HelmPluginRemoveSettings
- HelmPluginRemoveSettingsExtensions
- HelmPluginUpdateSettings
- HelmPluginUpdateSettingsExtensions
- HelmRepoAddSettings
- HelmRepoAddSettingsExtensions
- HelmRepoIndexSettings
- HelmRepoIndexSettingsExtensions
- HelmRepoListSettings
- HelmRepoListSettingsExtensions
- HelmRepoRemoveSettings
- HelmRepoRemoveSettingsExtensions
- HelmRepoUpdateSettings
- HelmRepoUpdateSettingsExtensions
- HelmResetSettings
- HelmResetSettingsExtensions
- HelmRollbackSettings
- HelmRollbackSettingsExtensions
- HelmSearchSettings
- HelmSearchSettingsExtensions
- HelmServeSettings
- HelmServeSettingsExtensions
- HelmStatusSettings
- HelmStatusSettingsExtensions
- HelmTasks
- HelmTemplateSettings
- HelmTemplateSettingsExtensions
- HelmTestSettings
- HelmTestSettingsExtensions
- HelmToolSettings
- HelmToolSettingsExtensions
- HelmUpgradeSettings
- HelmUpgradeSettingsExtensions
- HelmVerifySettings
- HelmVerifySettingsExtensions
- HelmVersionSettings
- HelmVersionSettingsExtensions

### Nuke.Common.Tools.InnoSetup

- InnoSetupSettings
- InnoSetupSettingsExtensions
- InnoSetupTasks

### Nuke.Common.Tools.InspectCode

- InspectCodeMSBuildToolset
- InspectCodeSettings
- InspectCodeSettingsExtensions
- InspectCodeSettingsLayers
- InspectCodeTasks

### Nuke.Common.Tools.Kubernetes

- KubernetesAlphaSettings
- KubernetesAlphaSettingsExtensions
- KubernetesAnnotateOutput
- KubernetesAnnotateSettings
- KubernetesAnnotateSettingsExtensions
- KubernetesApiResourcesOutput
- KubernetesApiResourcesSettings
- KubernetesApiResourcesSettingsExtensions
- KubernetesApiVersionsSettings
- KubernetesApiVersionsSettingsExtensions
- KubernetesApplyOutput
- KubernetesApplySettings
- KubernetesApplySettingsExtensions
- KubernetesAttachSettings
- KubernetesAttachSettingsExtensions
- KubernetesAuthSettings
- KubernetesAuthSettingsExtensions
- KubernetesAutoscaleOutput
- KubernetesAutoscaleSettings
- KubernetesAutoscaleSettingsExtensions
- KubernetesCertificateSettings
- KubernetesCertificateSettingsExtensions
- KubernetesClusterInfoSettings
- KubernetesClusterInfoSettingsExtensions
- KubernetesCommonSettings
- KubernetesCommonSettingsExtensions
- KubernetesCompletionSettings
- KubernetesCompletionSettingsExtensions
- KubernetesConfigSettings
- KubernetesConfigSettingsExtensions
- KubernetesConvertOutput
- KubernetesConvertSettings
- KubernetesConvertSettingsExtensions
- KubernetesCordonSettings
- KubernetesCordonSettingsExtensions
- KubernetesCpSettings
- KubernetesCpSettingsExtensions
- KubernetesCreateOutput
- KubernetesCreateSettings
- KubernetesCreateSettingsExtensions
- KubernetesDeleteSettings
- KubernetesDeleteSettingsExtensions
- KubernetesDescribeSettings
- KubernetesDescribeSettingsExtensions
- KubernetesDrainSettings
- KubernetesDrainSettingsExtensions
- KubernetesEditOutput
- KubernetesEditSettings
- KubernetesEditSettingsExtensions
- KubernetesExecBaseSettings
- KubernetesExecBaseSettingsExtensions
- KubernetesExecSettings
- KubernetesExecSettingsExtensions
- KubernetesExplainSettings
- KubernetesExplainSettingsExtensions
- KubernetesExposeOutput
- KubernetesExposeSettings
- KubernetesExposeSettingsExtensions
- KubernetesGetOutput
- KubernetesGetSettings
- KubernetesGetSettingsExtensions
- KubernetesLabelOutput
- KubernetesLabelSettings
- KubernetesLabelSettingsExtensions
- KubernetesLogsSettings
- KubernetesLogsSettingsExtensions
- KubernetesOptionsSettings
- KubernetesOptionsSettingsExtensions
- KubernetesPatchOutput
- KubernetesPatchSettings
- KubernetesPatchSettingsExtensions
- KubernetesPatchType
- KubernetesPluginSettings
- KubernetesPluginSettingsExtensions
- KubernetesPortForwardSettings
- KubernetesPortForwardSettingsExtensions
- KubernetesProxySettings
- KubernetesProxySettingsExtensions
- KubernetesReplaceOutput
- KubernetesReplaceSettings
- KubernetesReplaceSettingsExtensions
- KubernetesRollingUpdateOutput
- KubernetesRollingUpdateSettings
- KubernetesRollingUpdateSettingsExtensions
- KubernetesRolloutSettings
- KubernetesRolloutSettingsExtensions
- KubernetesRunContainerOutput
- KubernetesRunContainerSettings
- KubernetesRunContainerSettingsExtensions
- KubernetesRunOutput
- KubernetesRunSettings
- KubernetesRunSettingsExtensions
- KubernetesScaleOutput
- KubernetesScaleSettings
- KubernetesScaleSettingsExtensions
- KubernetesSetSettings
- KubernetesSetSettingsExtensions
- KubernetesSettings
- KubernetesSettingsExtensions
- KubernetesTaintOutput
- KubernetesTaintSettings
- KubernetesTaintSettingsExtensions
- KubernetesTasks
- KubernetesToolSettings
- KubernetesToolSettingsExtensions
- KubernetesTopSettings
- KubernetesTopSettingsExtensions
- KubernetesUncordonSettings
- KubernetesUncordonSettingsExtensions
- KubernetesVersionSettings
- KubernetesVersionSettingsExtensions
- KubernetesWaitOutput
- KubernetesWaitSettings
- KubernetesWaitSettingsExtensions

### Nuke.Common.Tools.MSBuild

- MSBuildPlatform
- MSBuildProject
- MSBuildSettings
- MSBuildSettingsExtensions
- MSBuildSymbolPackageFormat
- MSBuildTargetPlatform
- MSBuildTasks
- MSBuildToolPathResolver
- MSBuildToolsVersion
- MSBuildVerbosity
- MSBuildVerbosityMappingAttribute
- MSBuildVersion

### Nuke.Common.Tools.MSpec

- MSpecSettings
- MSpecSettingsExtensions
- MSpecTasks

### Nuke.Common.Tools.Npm

- NpmCiSettings
- NpmCiSettingsExtensions
- NpmInstallSettings
- NpmInstallSettingsExtensions
- NpmOnlyMode
- NpmRunSettings
- NpmRunSettingsExtensions
- NpmTasks

### Nuke.Common.Tools.NSwag

- CSharpClassStyle
- CSharpControllerRouteNamingStrategy
- CSharpControllerStyle
- CSharpControllerTarget
- EnumHandling
- HttpClass
- InjectionTokenType
- NSwagAspNetCoreToOpenApiSettings
- NSwagAspNetCoreToOpenApiSettingsExtensions
- NSwagAspNetCoreToSwaggerSettings
- NSwagAspNetCoreToSwaggerSettingsExtensions
- NSwagCreateDocumentSettings
- NSwagCreateDocumentSettingsExtensions
- NSwagExecuteDocumentSettings
- NSwagExecuteDocumentSettingsExtensions
- NSwagJsonSchemaToCSharpSettings
- NSwagJsonSchemaToCSharpSettingsExtensions
- NSwagJsonSchemaToTypeScriptSettings
- NSwagJsonSchemaToTypeScriptSettingsExtensions
- NSwagListTypesSettings
- NSwagListTypesSettingsExtensions
- NSwagListWebApiControllersSettings
- NSwagListWebApiControllersSettingsExtensions
- NSwagOpenApiToCSharpClientSettings
- NSwagOpenApiToCSharpClientSettingsExtensions
- NSwagOpenApiToCSharpControllerSettings
- NSwagOpenApiToCSharpControllerSettingsExtensions
- NSwagOpenApiToTypeScriptClientSettings
- NSwagOpenApiToTypeScriptClientSettingsExtensions
- NSwagSettings
- NSwagSettingsExtensions
- NSwagSwaggerToCSharpClientSettings
- NSwagSwaggerToCSharpClientSettingsExtensions
- NSwagSwaggerToCSharpControllerSettings
- NSwagSwaggerToCSharpControllerSettingsExtensions
- NSwagSwaggerToTypeScriptClientSettings
- NSwagSwaggerToTypeScriptClientSettingsExtensions
- NSwagTasks
- NSwagTasks.Runtime
- NSwagTypesToOpenApiSettings
- NSwagTypesToOpenApiSettingsExtensions
- NSwagTypesToSwaggerSettings
- NSwagTypesToSwaggerSettingsExtensions
- NSwagVersionSettings
- NSwagVersionSettingsExtensions
- NSwagWebApiToOpenApiSettings
- NSwagWebApiToOpenApiSettingsExtensions
- NSwagWebApiToSwaggerSettings
- NSwagWebApiToSwaggerSettingsExtensions
- OperationGenerationMode
- PromiseType
- PropertyNameHandling
- ReferenceTypeNullHandling
- SchemaType
- TypeScriptDateTimeType
- TypeScriptNullValue
- TypeScriptTemplate
- TypeScriptTypeStyle

### Nuke.Common.Tools.NuGet

- NuGetMSBuildVersion
- NuGetPackSettings
- NuGetPackSettingsExtensions
- NuGetPushSettings
- NuGetPushSettingsExtensions
- NuGetRestoreSettings
- NuGetRestoreSettingsExtensions
- NuGetSourcesAddSettings
- NuGetSourcesAddSettingsExtensions
- NuGetSourcesDisableSettings
- NuGetSourcesDisableSettingsExtensions
- NuGetSourcesEnableSettings
- NuGetSourcesEnableSettingsExtensions
- NuGetSourcesListFormat
- NuGetSourcesListSettings
- NuGetSourcesListSettingsExtensions
- NuGetSourcesRemoveSettings
- NuGetSourcesRemoveSettingsExtensions
- NuGetSourcesUpdateSettings
- NuGetSourcesUpdateSettingsExtensions
- NuGetSymbolPackageFormat
- NuGetTasks
- NuGetVerbosity
- PackageSaveMode

### Nuke.Common.Tools.NUnit

- NUnit3Settings
- NUnit3SettingsExtensions
- NUnitLabelType
- NUnitPrincipalPolicy
- NUnitProcessType
- NUnitTasks
- NUnitTraceLevel

### Nuke.Common.Tools.Octopus

- OctopusCreateReleaseSettings
- OctopusCreateReleaseSettingsExtensions
- OctopusDeployReleaseSettings
- OctopusDeployReleaseSettingsExtensions
- OctopusPackFormat
- OctopusPackSettings
- OctopusPackSettingsExtensions
- OctopusPushSettings
- OctopusPushSettingsExtensions
- OctopusTasks

### Nuke.Common.Tools.OpenCover

- OpenCoverSettings
- OpenCoverSettingsExtensions
- OpenCoverSkipping
- OpenCoverTasks
- OpenCoverVerbosity
- RegistrationType

### Nuke.Common.Tools.Paket

- PaketPackSettings
- PaketPackSettingsExtensions
- PaketPushSettings
- PaketPushSettingsExtensions
- PaketRestoreSettings
- PaketRestoreSettingsExtensions
- PaketTasks
- PaketUpdateSettings
- PaketUpdateSettingsExtensions

### Nuke.Common.Tools.ReportGenerator

- ReportGeneratorSettings
- ReportGeneratorSettingsExtensions
- ReportGeneratorTasks
- ReportGeneratorVerbosity
- ReportTypes

### Nuke.Common.Tools.SignTool

- SignToolContentMethod
- SignToolSettings
- SignToolSettingsExtensions
- SignToolTasks

### Nuke.Common.Tools.Slack

- SlackMessage
- SlackMessageAttachment
- SlackMessageAttachmentExtensions
- SlackMessageExtensions
- SlackMessageField
- SlackMessageFieldExtensions
- SlackTasks

### Nuke.Common.Tools.SonarScanner

- SonarScannerBeginSettings
- SonarScannerBeginSettingsExtensions
- SonarScannerEndSettings
- SonarScannerEndSettingsExtensions
- SonarScannerTasks

### Nuke.Common.Tools.SpecFlow

- SpecFlowAboutSettings
- SpecFlowAboutSettingsExtensions
- SpecFlowBuildServerRunSettings
- SpecFlowBuildServerRunSettingsExtensions
- SpecFlowMSTestExecutionReportSettings
- SpecFlowMSTestExecutionReportSettingsExtensions
- SpecFlowNUnitExecutionReportSettings
- SpecFlowNUnitExecutionReportSettingsExtensions
- SpecFlowRegisterSettings
- SpecFlowRegisterSettingsExtensions
- SpecFlowRunSettings
- SpecFlowRunSettingsExtensions
- SpecFlowStepDefinitionReportSettings
- SpecFlowStepDefinitionReportSettingsExtensions
- SpecFlowTasks
- SpecFlowToolIntegration
- SpecFlowUnregisterSettings
- SpecFlowUnregisterSettingsExtensions

### Nuke.Common.Tools.Squirrel

- SquirrelSettings
- SquirrelSettingsExtensions
- SquirrelTasks

### Nuke.Common.Tools.TestCloud

- TestCloudSettings
- TestCloudSettingsExtensions
- TestCloudTasks

### Nuke.Common.Tools.Twitter

- TwitterTasks

### Nuke.Common.Tools.Unity.Logging

- LogLevel

### Nuke.Common.Tools.Unity

- UnityBaseSettings
- UnityBaseSettingsExtensions
- UnityBuildTarget
- UnityCreateManualActivationFileSettings
- UnityCreateManualActivationFileSettingsExtensions
- UnityGLCore
- UnityGLES
- UnityManualLicenseFileSettings
- UnityManualLicenseFileSettingsExtensions
- UnityPlatformTextureFormat
- UnityReturnLicenseSettings
- UnityReturnLicenseSettingsExtensions
- UnitySettings
- UnitySettingsExtensions
- UnityStackTraceLogType
- UnityTasks

### Nuke.Common.Tools.VSTest

- VsTestFramework
- VsTestPlatform
- VSTestSettings
- VSTestSettingsExtensions
- VSTestTasks

### Nuke.Common.Tools.VSWhere

- VSWhereCatalog
- VSWhereFormat
- VSWhereResult
- VSWhereSettings
- VSWhereSettingsExtensions
- VSWhereTasks

### Nuke.Common.Tools.WebConfigTransformRunner

- WebConfigTransformRunnerSettings
- WebConfigTransformRunnerSettingsExtensions
- WebConfigTransformRunnerTasks

### Nuke.Common.Tools.Xunit

- Xunit2AppDomainMode
- Xunit2ParallelOption
- Xunit2ReporterType
- Xunit2ResultFormat
- Xunit2Settings
- Xunit2SettingsExtensions
- XunitTasks

### Nuke.Common.Utilities

- AssemblyExtensions
- CompletionUtility
- ConsoleUtility
- CustomFileWriter
- DelegateDisposable
- DirectoryInfoExtensions
- DisposableExtensions
- ObjectExtensions
- ResourceUtility
- StringExtensions
- TemplateUtility

### Nuke.Common.Utilities.Collections

- ArrayExtensions
- DictionaryExtensions
- EnumerableExtensions

### System.Diagnostics.CodeAnalysis

- ExcludeAssemblyFromCodeCoverageAttribute

## Types & Methods

### Nuke.Common.ChangeLog.ChangeLog

- .ctor(string path, ReleaseNotes unreleased, IReadOnlyList<ReleaseNotes> releaseNotes)
- .ctor(string path, IReadOnlyList<ReleaseNotes> releaseNotes)
- get_LatestVersion() : NuGetVersion
- get_Path() : string
- get_ReleaseNotes() : IReadOnlyList<ReleaseNotes>
- get_Unreleased() : ReleaseNotes

### Nuke.Common.ChangeLog.ChangelogTasks

- ExtractChangelogSectionNotes(string changelogFile, string tag = null) : IEnumerable<string>
- FinalizeChangelog(ChangeLog changelogFile, NuGetVersion tag, GitRepository repository = null) : void
- FinalizeChangelog(string changelogFile, string tag, GitRepository repository = null) : void
- GetNuGetReleaseNotes(string changelogFile, GitRepository repository = null) : string
- ReadChangelog(string changelogFile) : ChangeLog
- ReadReleaseNotes(string changelogFile) : IReadOnlyList<ReleaseNotes>

### Nuke.Common.ChangeLog.ReleaseNotes

- .ctor(NuGetVersion version, IReadOnlyList<string> notes, int startIndex, int endIndex)
- .ctor(IReadOnlyList<string> notes, int startIndex, int endIndex)
- get_EndIndex() : int
- get_IsEmpty() : bool
- get_Notes() : IReadOnlyList<string>
- get_StartIndex() : int
- get_Unreleased() : bool
- get_Version() : NuGetVersion
- ToString() : string

### Nuke.Common.CI.AppVeyor.AppVeyor

- get_AccountName() : string
- get_ApiUrl() : string
- get_BuildFolder() : string
- get_BuildId() : int
- get_BuildNumber() : int
- get_BuildVersion() : string
- get_BuildWorkerImage() : string
- get_Configuration() : string
- get_ForcedBuild() : bool
- get_Instance() : AppVeyor
- get_JobId() : string
- get_JobName() : string
- get_JobNumber() : int
- get_Platform() : string
- get_ProjectId() : int
- get_ProjectName() : string
- get_ProjectSlug() : string
- get_PullRequestNumber() : int
- get_PullRequestTitle() : string
- get_Rebuild() : bool
- get_RepositoryBranch() : string
- get_RepositoryCommitAuthor() : string
- get_RepositoryCommitAuthorEmail() : string
- get_RepositoryCommitMessage() : string
- get_RepositoryCommitMessageExtended() : string
- get_RepositoryCommitSha() : string
- get_RepositoryCommitTimestamp() : DateTime
- get_RepositoryName() : string
- get_RepositoryProvider() : string
- get_RepositoryScm() : string
- get_RepositoryTag() : bool
- get_RepositoryTagName() : string
- get_ScheduledBuild() : bool
- WriteError(string message, string details = null) : void
- WriteInformation(string message, string details = null) : void
- WriteWarning(string message, string details = null) : void

### Nuke.Common.CI.AppVeyor.AppVeyorAttribute

- .ctor(AppVeyorImage image, AppVeyorImage[] images)
- get_BranchesExcept() : string[]
- get_BranchesOnly() : string[]
- get_Cache() : string[]
- get_GeneratedFiles() : IEnumerable<string>
- get_HostType() : HostType
- get_Init() : string[]
- get_InvokedTargets() : string[]
- get_IrrelevantTargetNames() : IEnumerable<string>
- get_OnlyCommitsAuthor() : string
- get_OnlyCommitsMessage() : string
- get_RelevantTargetNames() : IEnumerable<string>
- get_Services() : AppVeyorService[]
- get_SkipBranchesWithPullRequest() : bool
- get_SkipCommitsAuthor() : string
- get_SkipCommitsMessage() : string
- get_SkipTags() : bool
- set_BranchesExcept(string[] value) : void
- set_BranchesOnly(string[] value) : void
- set_Cache(string[] value) : void
- set_Init(string[] value) : void
- set_InvokedTargets(string[] value) : void
- set_OnlyCommitsAuthor(string value) : void
- set_OnlyCommitsMessage(string value) : void
- set_Services(AppVeyorService[] value) : void
- set_SkipBranchesWithPullRequest(bool value) : void
- set_SkipCommitsAuthor(string value) : void
- set_SkipCommitsMessage(string value) : void
- set_SkipTags(bool value) : void
- CreateWriter() : CustomFileWriter
- GetBranches() : AppVeyorBranches
- GetConfiguration(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : ConfigurationEntity

### Nuke.Common.CI.AppVeyor.AppVeyorImage

- Ubuntu1604 : AppVeyorImage
- Ubuntu1804 : AppVeyorImage
- UbuntuLatest : AppVeyorImage
- VisualStudio2013 : AppVeyorImage
- VisualStudio2015 : AppVeyorImage
- VisualStudio2017 : AppVeyorImage
- VisualStudio2019 : AppVeyorImage
- VisualStudioLatest : AppVeyorImage

### Nuke.Common.CI.AppVeyor.AppVeyorMessageCategory

- Error : AppVeyorMessageCategory
- Information : AppVeyorMessageCategory
- Warning : AppVeyorMessageCategory

### Nuke.Common.CI.AppVeyor.AppVeyorService

- IIS : AppVeyorService
- MongoDB : AppVeyorService
- MSMQ : AppVeyorService
- MSSQL2008R2SP2 : AppVeyorService
- MSSQL2008R2SP2RS : AppVeyorService
- MSSQL2012SP1 : AppVeyorService
- MSSQL2012SP1RS : AppVeyorService
- MSSQL2014 : AppVeyorService
- MSSQL2014RS : AppVeyorService
- MSSQL2016 : AppVeyorService
- MSSQL2017 : AppVeyorService
- MYSQL : AppVeyorService
- PostgreSQL : AppVeyorService
- PostgreSQL101 : AppVeyorService
- PostgreSQL93 : AppVeyorService
- PostgreSQL94 : AppVeyorService
- PostgreSQL95 : AppVeyorService

### Nuke.Common.CI.AppVeyor.Configuration.AppVeyorBranches

- .ctor()
- get_Except() : string[]
- get_Only() : string[]
- set_Except(string[] value) : void
- set_Only(string[] value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.AppVeyor.Configuration.AppVeyorConfiguration

- .ctor()
- get_Artifacts() : string[]
- get_Branches() : AppVeyorBranches
- get_BuildScript() : string
- get_Cache() : string[]
- get_Images() : AppVeyorImage[]
- get_Init() : string[]
- get_InvokedTargets() : string[]
- get_OnlyCommitsAuthor() : string
- get_OnlyCommitsMessage() : string
- get_Services() : AppVeyorService[]
- get_SkipBranchesWithPullRequest() : bool
- get_SkipCommitsAuthor() : string
- get_SkipCommitsMessage() : string
- get_SkipTags() : bool
- set_Artifacts(string[] value) : void
- set_Branches(AppVeyorBranches value) : void
- set_BuildScript(string value) : void
- set_Cache(string[] value) : void
- set_Images(AppVeyorImage[] value) : void
- set_Init(string[] value) : void
- set_InvokedTargets(string[] value) : void
- set_OnlyCommitsAuthor(string value) : void
- set_OnlyCommitsMessage(string value) : void
- set_Services(AppVeyorService[] value) : void
- set_SkipBranchesWithPullRequest(bool value) : void
- set_SkipCommitsAuthor(string value) : void
- set_SkipCommitsMessage(string value) : void
- set_SkipTags(bool value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.AppVeyor.Configuration.AppVeyorCustomWriterExtensions

- WriteBlock(this CustomFileWriter writer, string text) : IDisposable

### Nuke.Common.CI.ArtifactExtensions

- Consumes(this ITargetDefinition targetDefinition, Target[] targets) : ITargetDefinition
- Consumes(this ITargetDefinition targetDefinition, Target target, string[] artifacts) : ITargetDefinition
- Partition(this ITargetDefinition targetDefinition, Expression<Func<Partition>> partition) : ITargetDefinition
- Produces(this ITargetDefinition targetDefinition, string[] artifacts) : ITargetDefinition

### Nuke.Common.CI.AzurePipelines.AzurePipelines

- get_AccessToken() : string
- get_AgentBuildDirectory() : string
- get_AgentHomeDirectory() : string
- get_AgentId() : long
- get_AgentJobStatus() : AzurePipelinesJobStatus
- get_AgentMachineName() : string
- get_AgentName() : string
- get_AgentWorkFolder() : string
- get_ArtifactStagingDirectory() : string
- get_BinariesDirectory() : string
- get_BuildId() : long
- get_BuildNumber() : string
- get_BuildReason() : AzurePipelinesBuildReason
- get_BuildUri() : string
- get_CollectionId() : Guid
- get_DefaultWorkingDirectory() : string
- get_DefinitionId() : long
- get_DefinitionName() : string
- get_DefinitionVersion() : long
- get_Instance() : AzurePipelines
- get_PullRequestId() : long?
- get_PullRequestSourceBranch() : string
- get_PullRequestTargetBranch() : string
- get_QueuedBy() : string
- get_QueuedById() : Guid
- get_RepositoryClean() : bool
- get_RepositoryGitSubmoduleCheckout() : bool
- get_RepositoryLocalPath() : string
- get_RepositoryName() : string
- get_RepositoryProvider() : AzurePipelinesRepositoryType
- get_RepositoryTfvcWorkspace() : string
- get_RepositoryUri() : string
- get_RequestedFor() : string
- get_RequestedForEmail() : string
- get_RequestedForId() : Guid
- get_SourceBranch() : string
- get_SourceBranchName() : string
- get_SourceDirectory() : string
- get_SourceTfvcShelveset() : string
- get_SourceVersion() : string
- get_StageDisplayName() : string
- get_StageName() : string
- get_StagingDirectory() : string
- get_TeamFoundationCollectionUri() : string
- get_TeamProject() : string
- get_TeamProjectId() : Guid
- get_TestResultsDirectory() : string
- AddBuildTag(string buildTag) : void
- EndGroup(string group) : void
- Group(string group) : void
- LogError(string message, string sourcePath = null, string lineNumber = null, string columnNumber = null, string code = null) : void
- LogIssue(AzurePipelinesIssueType type, string message, string sourcePath = null, string lineNumber = null, string columnNumber = null, string code = null) : void
- LogWarning(string message, string sourcePath = null, string lineNumber = null, string columnNumber = null, string code = null) : void
- PublishCodeCoverage(AzurePipelinesCodeCoverageToolType coverageTool, string summaryFile, string reportDirectory, string[] additionalCodeCoverageFiles) : void
- PublishTestResults(string title, AzurePipelinesTestResultsType type, IEnumerable<string> files, bool? mergeResults = null, string platform = null, string configuration = null, bool? publishRunAttachments = null) : void
- UpdateBuildNumber(string buildNumber) : void
- UploadArtifacts(string containerDirectory, string artifactName, string packageDirectory) : void
- UploadLog(string path) : void
- WriteCommand(string command, string message = null, Func<IDictionary<string, object>, IDictionary<string, object>> dictionaryConfigurator = null) : void

### Nuke.Common.CI.AzurePipelines.AzurePipelinesAttribute

- .ctor(AzurePipelinesImage image, AzurePipelinesImage[] images)
- get_GeneratedFiles() : IEnumerable<string>
- get_HostType() : HostType
- get_InvokedTargets() : string[]
- get_PullRequestsAutoCancel() : bool
- get_PullRequestsBranchesExclude() : string[]
- get_PullRequestsBranchesInclude() : string[]
- get_PullRequestsPathsExclude() : string[]
- get_PullRequestsPathsInclude() : string[]
- get_RelevantTargetNames() : IEnumerable<string>
- get_TriggerBatch() : bool
- get_TriggerBranchesExclude() : string[]
- get_TriggerBranchesInclude() : string[]
- get_TriggerPathsExclude() : string[]
- get_TriggerPathsInclude() : string[]
- get_TriggerTagsExclude() : string[]
- get_TriggerTagsInclude() : string[]
- set_InvokedTargets(string[] value) : void
- set_PullRequestsAutoCancel(bool value) : void
- set_PullRequestsBranchesExclude(string[] value) : void
- set_PullRequestsBranchesInclude(string[] value) : void
- set_PullRequestsPathsExclude(string[] value) : void
- set_PullRequestsPathsInclude(string[] value) : void
- set_TriggerBatch(bool value) : void
- set_TriggerBranchesExclude(string[] value) : void
- set_TriggerBranchesInclude(string[] value) : void
- set_TriggerPathsExclude(string[] value) : void
- set_TriggerPathsInclude(string[] value) : void
- set_TriggerTagsExclude(string[] value) : void
- set_TriggerTagsInclude(string[] value) : void
- CreateWriter() : CustomFileWriter
- GetArtifact(string artifact) : string
- GetConfiguration(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : ConfigurationEntity
- GetJob(ExecutableTarget executableTarget, LookupTable<ExecutableTarget, AzurePipelinesJob> jobs) : AzurePipelinesJob
- GetStage(AzurePipelinesImage image, IReadOnlyCollection<ExecutableTarget> relevantTargets) : AzurePipelinesStage

### Nuke.Common.CI.AzurePipelines.AzurePipelinesBuildReason

- BatchedCI : AzurePipelinesBuildReason
- CheckInShelveset : AzurePipelinesBuildReason
- IndividualCI : AzurePipelinesBuildReason
- Manual : AzurePipelinesBuildReason
- PullRequest : AzurePipelinesBuildReason
- Schedule : AzurePipelinesBuildReason
- ValidateShelveset : AzurePipelinesBuildReason

### Nuke.Common.CI.AzurePipelines.AzurePipelinesCodeCoverageToolType

- Cobertura : AzurePipelinesCodeCoverageToolType
- JaCoCo : AzurePipelinesCodeCoverageToolType

### Nuke.Common.CI.AzurePipelines.AzurePipelinesImage

- MacOs1013 : AzurePipelinesImage
- MacOs1014 : AzurePipelinesImage
- MacOsLatest : AzurePipelinesImage
- Ubuntu1604 : AzurePipelinesImage
- Ubuntu1804 : AzurePipelinesImage
- UbuntuLatest : AzurePipelinesImage
- Vs2015Win2012R2 : AzurePipelinesImage
- Vs2017Win2016 : AzurePipelinesImage
- Win1803 : AzurePipelinesImage
- Windows2019 : AzurePipelinesImage
- WindowsLatest : AzurePipelinesImage

### Nuke.Common.CI.AzurePipelines.AzurePipelinesIssueType

- Error : AzurePipelinesIssueType
- Warning : AzurePipelinesIssueType

### Nuke.Common.CI.AzurePipelines.AzurePipelinesJobStatus

- Canceled : AzurePipelinesJobStatus
- Failed : AzurePipelinesJobStatus
- Succeeded : AzurePipelinesJobStatus
- SucceededWithIssues : AzurePipelinesJobStatus

### Nuke.Common.CI.AzurePipelines.AzurePipelinesRepositoryType

- AzureRepos : AzurePipelinesRepositoryType
- Git : AzurePipelinesRepositoryType
- GitHub : AzurePipelinesRepositoryType
- Svn : AzurePipelinesRepositoryType
- TfsVersionControl : AzurePipelinesRepositoryType

### Nuke.Common.CI.AzurePipelines.AzurePipelinesTestResultsType

- CTest : AzurePipelinesTestResultsType
- JUnit : AzurePipelinesTestResultsType
- NUnit : AzurePipelinesTestResultsType
- VSTest : AzurePipelinesTestResultsType
- XUnit : AzurePipelinesTestResultsType

### Nuke.Common.CI.AzurePipelines.Configuration.AzurePipelinesConfiguration

- .ctor()
- get_Stages() : AzurePipelinesStage[]
- set_Stages(AzurePipelinesStage[] value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.AzurePipelines.Configuration.AzurePipelinesCustomWriterExtensions

- WriteBlock(this CustomFileWriter writer, string text) : IDisposable

### Nuke.Common.CI.AzurePipelines.Configuration.AzurePipelinesJob

- .ctor()
- get_Dependencies() : AzurePipelinesJob[]
- get_DisplayName() : string
- get_DownloadArtifacts() : string[]
- get_Image() : AzurePipelinesImage?
- get_InvokedTargets() : string[]
- get_Name() : string
- get_Parallel() : int
- get_PartitionName() : string
- get_PublishArtifacts() : string[]
- get_ScriptPath() : string
- set_Dependencies(AzurePipelinesJob[] value) : void
- set_DisplayName(string value) : void
- set_DownloadArtifacts(string[] value) : void
- set_Image(AzurePipelinesImage? value) : void
- set_InvokedTargets(string[] value) : void
- set_Name(string value) : void
- set_Parallel(int value) : void
- set_PartitionName(string value) : void
- set_PublishArtifacts(string[] value) : void
- set_ScriptPath(string value) : void
- Write(CustomFileWriter writer) : void
- WriteSteps(CustomFileWriter writer) : void

### Nuke.Common.CI.AzurePipelines.Configuration.AzurePipelinesStage

- .ctor()
- get_Dependencies() : AzurePipelinesStage[]
- get_DisplayName() : string
- get_Image() : AzurePipelinesImage?
- get_Jobs() : AzurePipelinesJob[]
- get_Name() : string
- set_Dependencies(AzurePipelinesStage[] value) : void
- set_DisplayName(string value) : void
- set_Image(AzurePipelinesImage? value) : void
- set_Jobs(AzurePipelinesJob[] value) : void
- set_Name(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.Bamboo.Bamboo

- get_AgentHome() : string
- get_AgentId() : long
- get_AgentWorkingDirectory() : string
- get_BuildFailed() : bool
- get_BuildKey() : string
- get_BuildNumber() : long
- get_BuildPlanName() : string
- get_BuildResultsKey() : string
- get_BuildResultsUrl() : string
- get_BuildTimeStamp() : DateTime
- get_BuildWorkingDirectory() : string
- get_Instance() : Bamboo
- get_PlanKey() : string
- get_PlanName() : string
- get_PlanResultsUrl() : string
- get_PlanStorageTag() : string
- get_ShortJobKey() : string
- get_ShortJobName() : string
- get_ShortPlanKey() : string
- get_ShortPlanName() : string

### Nuke.Common.CI.Bitrise.Bitrise

- get_AppSlug() : string
- get_AppTitle() : string
- get_AppUrl() : string
- get_BuildNumber() : long
- get_BuildSlug() : string
- get_BuildTriggerTimestamp() : DateTime
- get_BuildUrl() : string
- get_CertificatePassphrase() : string
- get_CertificateUrl() : string
- get_GitBranch() : string
- get_GitCommit() : string
- get_GitMessage() : string
- get_GitTag() : string
- get_Instance() : Bitrise
- get_ProvisionUrl() : string
- get_PullRequest() : long?
- get_RepositoryUrl() : string

### Nuke.Common.CI.ChainedConfigurationAttributeBase

- .ctor()
- get_ExcludedTargets() : string[]
- get_IrrelevantTargetNames() : IEnumerable<string>
- get_NonEntryTargets() : string[]
- set_ExcludedTargets(string[] value) : void
- set_NonEntryTargets(string[] value) : void
- GetInvokedTargets(ExecutableTarget executableTarget) : IEnumerable<string>
- GetTargetDependencies(ExecutableTarget executableTarget) : IEnumerable<ExecutableTarget>

### Nuke.Common.CI.CIAttribute

- .ctor()
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.CI.ConfigurationAttributeBase

- ConfigurationParameterName : string
- .ctor()
- get_AutoGenerate() : bool
- get_BashScript() : string
- get_GeneratedFiles() : IEnumerable<string>
- get_HostType() : HostType
- get_IrrelevantTargetNames() : IEnumerable<string>
- get_PowerShellScript() : string
- get_RelevantTargetNames() : IEnumerable<string>
- get_ShutdownDotNetBuildServer() : bool
- set_AutoGenerate(bool value) : void
- set_ShutdownDotNetBuildServer(bool value) : void
- CreateWriter() : CustomFileWriter
- GetConfiguration(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : ConfigurationEntity
- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void
- OnBeforeLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets) : void
- OnBuildFinished(NukeBuild build) : void
- OnBuildFinishedInternal(NukeBuild build) : void
- WriteAutoGenerationComment(CustomFileWriter writer) : void

### Nuke.Common.CI.ConfigurationEntity

- .ctor()
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsArtifactStep

- .ctor()
- get_Name() : string
- get_Path() : string
- set_Name(string value) : void
- set_Path(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsConfiguration

- .ctor()
- get_DetailedTriggers() : GitHubActionsDetailedTrigger[]
- get_Jobs() : GitHubActionsJob[]
- get_Name() : string
- get_ShortTriggers() : GitHubActionsTrigger[]
- set_DetailedTriggers(GitHubActionsDetailedTrigger[] value) : void
- set_Jobs(GitHubActionsJob[] value) : void
- set_Name(string value) : void
- set_ShortTriggers(GitHubActionsTrigger[] value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsDetailedTrigger

- .ctor()

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsJob

- .ctor()
- get_Image() : GitHubActionsImage
- get_Name() : string
- get_Steps() : GitHubActionsStep[]
- set_Image(GitHubActionsImage value) : void
- set_Name(string value) : void
- set_Steps(GitHubActionsStep[] value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsRunStep

- .ctor()
- get_Command() : string
- get_Imports() : Dictionary<string, string>
- set_Command(string value) : void
- set_Imports(Dictionary<string, string> value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsScheduledTrigger

- .ctor()
- get_Cron() : string
- set_Cron(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsStep

- .ctor()

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsUsingStep

- .ctor()
- get_Using() : string
- set_Using(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.Configuration.GitHubActionsVcsTrigger

- .ctor()
- get_Branches() : string[]
- get_ExcludePaths() : string[]
- get_IncludePaths() : string[]
- get_Kind() : GitHubActionsTrigger
- get_Tags() : string[]
- set_Branches(string[] value) : void
- set_ExcludePaths(string[] value) : void
- set_IncludePaths(string[] value) : void
- set_Kind(GitHubActionsTrigger value) : void
- set_Tags(string[] value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.GitHubActions.GitHubActions

- get_GitHubAction() : string
- get_GitHubActor() : string
- get_GitHubBaseRef() : string
- get_GitHubEventName() : string
- get_GitHubEventPath() : string
- get_GitHubHeadRef() : string
- get_GitHubRef() : string
- get_GitHubRepository() : string
- get_GitHubSha() : string
- get_GitHubToken() : string
- get_GitHubWorkflow() : string
- get_GitHubWorkspace() : string
- get_Home() : string
- get_Instance() : GitHubActions
- EndGroup(string group) : void
- Group(string group) : void
- WriteCommand(string command, string message = null, Func<IDictionary<string, object>, IDictionary<string, object>> dictionaryConfigurator = null) : void
- WriteDebug(string message) : void
- WriteError(string message) : void
- WriteWarning(string message) : void

### Nuke.Common.CI.GitHubActions.GitHubActionsAttribute

- .ctor(string name, GitHubActionsImage image, GitHubActionsImage[] images)
- get_GeneratedFiles() : IEnumerable<string>
- get_HostType() : HostType
- get_ImportGitHubTokenAs() : string
- get_ImportSecrets() : string[]
- get_InvokedTargets() : string[]
- get_IrrelevantTargetNames() : IEnumerable<string>
- get_On() : GitHubActionsTrigger[]
- get_OnCronSchedule() : string
- get_OnPullRequestBranches() : string[]
- get_OnPullRequestExcludePaths() : string[]
- get_OnPullRequestIncludePaths() : string[]
- get_OnPullRequestTags() : string[]
- get_OnPushBranches() : string[]
- get_OnPushExcludePaths() : string[]
- get_OnPushIncludePaths() : string[]
- get_OnPushTags() : string[]
- get_RelevantTargetNames() : IEnumerable<string>
- set_ImportGitHubTokenAs(string value) : void
- set_ImportSecrets(string[] value) : void
- set_InvokedTargets(string[] value) : void
- set_On(GitHubActionsTrigger[] value) : void
- set_OnCronSchedule(string value) : void
- set_OnPullRequestBranches(string[] value) : void
- set_OnPullRequestExcludePaths(string[] value) : void
- set_OnPullRequestIncludePaths(string[] value) : void
- set_OnPullRequestTags(string[] value) : void
- set_OnPushBranches(string[] value) : void
- set_OnPushExcludePaths(string[] value) : void
- set_OnPushIncludePaths(string[] value) : void
- set_OnPushTags(string[] value) : void
- CreateWriter() : CustomFileWriter
- GetConfiguration(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : ConfigurationEntity
- GetImports() : IEnumerable<(key string, value string)>
- GetJobs(GitHubActionsImage image, IReadOnlyCollection<ExecutableTarget> relevantTargets) : GitHubActionsJob
- GetTriggers() : IEnumerable<GitHubActionsDetailedTrigger>

### Nuke.Common.CI.GitHubActions.GitHubActionsImage

- MacOs1014 : GitHubActionsImage
- MacOsLatest : GitHubActionsImage
- Ubuntu1604 : GitHubActionsImage
- Ubuntu1804 : GitHubActionsImage
- UbuntuLatest : GitHubActionsImage
- WindowsLatest : GitHubActionsImage
- WindowsServer2016R2 : GitHubActionsImage
- WindowsServer2019 : GitHubActionsImage

### Nuke.Common.CI.GitHubActions.GitHubActionsTrigger

- PullRequest : GitHubActionsTrigger
- Push : GitHubActionsTrigger

### Nuke.Common.CI.GitLab.GitLab

- get_ArtifactDownloadAttempts() : int
- get_Ci() : bool
- get_CommitRefName() : string
- get_CommitRefSlug() : string
- get_CommitSha() : string
- get_CommitTag() : string
- get_ConfigPath() : string
- get_DebugTrace() : bool
- get_DisposableEnvironment() : bool
- get_EnvironmentName() : string
- get_EnvironmentSlug() : string
- get_EnvironmentUrl() : string
- get_GetSourcesAttempts() : int
- get_GitLabCi() : bool
- get_GitLabUserEmail() : string
- get_GitLabUserId() : string
- get_GitLabUserLogin() : string
- get_GitLabUserName() : string
- get_Instance() : GitLab
- get_JobId() : string
- get_JobManual() : bool
- get_JobName() : string
- get_JobStage() : string
- get_JobToken() : string
- get_PipelineId() : string
- get_PipelineSource() : string
- get_PipelineTriggered() : bool
- get_ProjectDir() : string
- get_ProjectId() : string
- get_ProjectName() : string
- get_ProjectNamespace() : string
- get_ProjectPath() : string
- get_ProjectPathSlug() : string
- get_ProjectUrl() : string
- get_ProjectVisibility() : GitLabProjectVisibility
- get_Registry() : string
- get_RegistryImage() : string
- get_RegistryPassword() : string
- get_RegistryUser() : string
- get_RepositoryUrl() : string
- get_RestoreCacheAttempts() : int
- get_RunnerDescription() : string
- get_RunnerId() : string
- get_RunnerTags() : string
- get_Server() : bool
- get_ServerName() : string
- get_ServerRevision() : string
- get_ServerVersion() : string
- get_SharedEnvironment() : bool

### Nuke.Common.CI.GitLab.GitLabProjectVisibility

- Internal : GitLabProjectVisibility
- Private : GitLabProjectVisibility
- Public : GitLabProjectVisibility

### Nuke.Common.CI.Jenkins.Jenkins

- get_BranchName() : string
- get_BuilDisplayName() : string
- get_BuildNumber() : int
- get_BuildTag() : string
- get_ChangeId() : string
- get_ExecutorNumber() : int
- get_GitBranch() : string
- get_GitCommit() : string
- get_GitPreviousCommit() : string
- get_GitPreviousSuccessfulCommit() : string
- get_GitUrl() : string
- get_Instance() : Jenkins
- get_JenkinsHome() : string
- get_JenkinsServerCookie() : string
- get_JobBaseName() : string
- get_JobDisplayUrl() : string
- get_JobName() : string
- get_NodeLabels() : string
- get_NodeName() : string
- get_RunChangesDisplayUrl() : string
- get_RunDisplayUrl() : string
- get_Workspace() : string

### Nuke.Common.CI.NoConvertAttribute

- .ctor()

### Nuke.Common.CI.Partition

- .ctor()
- get_Single() : Partition
- GetCurrent(IEnumerable<T> enumerable) : IEnumerable<T>
- IsIn(int part) : bool
- ToString() : string

### Nuke.Common.CI.Partition.TypeConverter

- .ctor()
- CanConvertFrom(ITypeDescriptorContext context, Type sourceType) : bool
- ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value) : object

### Nuke.Common.CI.PartitionAttribute

- .ctor(int total)
- get_List() : bool
- get_Total() : int
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.CI.TeamCity.Build

- .ctor()
- get_BranchName() : string
- get_BuildTypeId() : string
- get_Id() : int
- get_IsDefaultBranch() : bool
- get_State() : string
- get_WebUrl() : string
- set_BranchName(string value) : void
- set_BuildTypeId(string value) : void
- set_Id(int value) : void
- set_IsDefaultBranch(bool value) : void
- set_State(string value) : void
- set_WebUrl(string value) : void
- ToString() : string

### Nuke.Common.CI.TeamCity.BuildQueue

- .ctor()
- get_Builds() : Build[]

### Nuke.Common.CI.TeamCity.Configuration.TeamCityArtifactDependency

- .ctor()
- get_ArtifactRules() : string[]
- get_BuildType() : TeamCityBuildType
- set_ArtifactRules(string[] value) : void
- set_BuildType(TeamCityBuildType value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityBuildType

- .ctor()
- get_ArtifactRules() : string[]
- get_BashScript() : string
- get_Dependencies() : TeamCityDependency[]
- get_Description() : string
- get_Id() : string
- get_InvokedTargets() : string[]
- get_IsComposite() : bool
- get_IsDeployment() : bool
- get_Name() : string
- get_Parameters() : TeamCityConfigurationParameter[]
- get_Partition() : Partition
- get_PartitionName() : string
- get_Platform() : TeamCityAgentPlatform
- get_PowerShellScript() : string
- get_Triggers() : TeamCityTrigger[]
- get_VcsRoot() : TeamCityBuildTypeVcsRoot
- set_ArtifactRules(string[] value) : void
- set_BashScript(string value) : void
- set_Dependencies(TeamCityDependency[] value) : void
- set_Description(string value) : void
- set_Id(string value) : void
- set_InvokedTargets(string[] value) : void
- set_IsComposite(bool value) : void
- set_IsDeployment(bool value) : void
- set_Name(string value) : void
- set_Parameters(TeamCityConfigurationParameter[] value) : void
- set_Partition(Partition value) : void
- set_PartitionName(string value) : void
- set_Platform(TeamCityAgentPlatform value) : void
- set_PowerShellScript(string value) : void
- set_Triggers(TeamCityTrigger[] value) : void
- set_VcsRoot(TeamCityBuildTypeVcsRoot value) : void
- Write(CustomFileWriter writer) : void
- WriteArtifacts(CustomFileWriter writer) : void
- WriteDependencies(CustomFileWriter writer) : void
- WriteExecStep(CustomFileWriter writer, string arguments) : void
- WriteParameters(CustomFileWriter writer) : void
- WritePowerShellStep(CustomFileWriter writer, string arguments) : void
- WriteSteps(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityBuildTypeVcsRoot

- .ctor()
- get_CleanCheckoutDirectory() : bool
- get_Root() : TeamCityVcsRoot
- get_ShowDependenciesChanges() : bool
- set_CleanCheckoutDirectory(bool value) : void
- set_Root(TeamCityVcsRoot value) : void
- set_ShowDependenciesChanges(bool value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityConfiguration

- .ctor()
- get_Header() : string[]
- get_Project() : TeamCityProject
- get_Version() : string
- set_Project(TeamCityProject value) : void
- set_Version(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityConfigurationParameter

- .ctor()
- get_AllowMultiple() : bool
- get_DefaultValue() : string
- get_Description() : string
- get_Display() : TeamCityParameterDisplay
- get_Name() : string
- get_Options() : IReadOnlyDictionary<string, object>
- get_Type() : TeamCityParameterType
- get_ValueSeparator() : string
- set_AllowMultiple(bool value) : void
- set_DefaultValue(string value) : void
- set_Description(string value) : void
- set_Display(TeamCityParameterDisplay value) : void
- set_Name(string value) : void
- set_Options(IReadOnlyDictionary<string, object> value) : void
- set_Type(TeamCityParameterType value) : void
- set_ValueSeparator(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityCustomWriterExtensions

- WriteBlock(this CustomFileWriter writer, string text) : IDisposable

### Nuke.Common.CI.TeamCity.Configuration.TeamCityDependency

- .ctor()

### Nuke.Common.CI.TeamCity.Configuration.TeamCityDependencyFailureAction

- AddProblem : TeamCityDependencyFailureAction
- Cancel : TeamCityDependencyFailureAction
- FailToStart : TeamCityDependencyFailureAction
- Ignore : TeamCityDependencyFailureAction

### Nuke.Common.CI.TeamCity.Configuration.TeamCityFinishBuildTrigger

- .ctor()
- get_BuildType() : TeamCityBuildType
- set_BuildType(TeamCityBuildType value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityKeyValueParameter

- .ctor()
- get_Key() : string
- get_Value() : string
- set_Key(string value) : void
- set_Value(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityParameter

- .ctor()

### Nuke.Common.CI.TeamCity.Configuration.TeamCityParameterDisplay

- Hidden : TeamCityParameterDisplay
- Normal : TeamCityParameterDisplay
- Prompt : TeamCityParameterDisplay

### Nuke.Common.CI.TeamCity.Configuration.TeamCityParameterType

- Checkbox : TeamCityParameterType
- Password : TeamCityParameterType
- Select : TeamCityParameterType
- Text : TeamCityParameterType

### Nuke.Common.CI.TeamCity.Configuration.TeamCityProject

- .ctor()
- get_BuildTypes() : TeamCityBuildType[]
- get_Description() : string
- get_Parameters() : TeamCityParameter[]
- get_VcsRoot() : TeamCityVcsRoot
- set_BuildTypes(TeamCityBuildType[] value) : void
- set_Description(string value) : void
- set_Parameters(TeamCityParameter[] value) : void
- set_VcsRoot(TeamCityVcsRoot value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityScheduledTrigger

- .ctor()
- get_BranchFilter() : string
- get_EnableQueueOptimization() : bool
- get_TriggerBuildAlways() : bool
- get_TriggerRules() : string
- get_WithPendingChangesOnly() : bool
- set_BranchFilter(string value) : void
- set_EnableQueueOptimization(bool value) : void
- set_TriggerBuildAlways(bool value) : void
- set_TriggerRules(string value) : void
- set_WithPendingChangesOnly(bool value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCitySnapshotDependency

- .ctor()
- get_BuildType() : TeamCityBuildType
- get_CancelAction() : TeamCityDependencyFailureAction
- get_FailureAction() : TeamCityDependencyFailureAction
- set_BuildType(TeamCityBuildType value) : void
- set_CancelAction(TeamCityDependencyFailureAction value) : void
- set_FailureAction(TeamCityDependencyFailureAction value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityTrigger

- .ctor()

### Nuke.Common.CI.TeamCity.Configuration.TeamCityVcsRoot

- .ctor()
- get_Branch() : string
- get_BranchSpec() : string[]
- get_Id() : string
- get_Name() : string
- get_PollInterval() : int?
- get_Url() : string
- set_Branch(string value) : void
- set_BranchSpec(string[] value) : void
- set_Name(string value) : void
- set_PollInterval(int? value) : void
- set_Url(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.Configuration.TeamCityVcsTrigger

- .ctor()
- get_BranchFilter() : string
- get_TriggerRules() : string
- set_BranchFilter(string value) : void
- set_TriggerRules(string value) : void
- Write(CustomFileWriter writer) : void

### Nuke.Common.CI.TeamCity.DotNetBuildSettingsExtensions

- AddTeamCityLogger(this DotNetBuildSettings toolSettings) : DotNetBuildSettings

### Nuke.Common.CI.TeamCity.ITeamCityRestClient

- GetBuildQueue() : Task<BuildQueue>
- IsPinned(Build build) : Task<bool>

### Nuke.Common.CI.TeamCity.MSBuildSettingsExtensions

- AddTeamCityLogger(this MSBuildSettings toolSettings) : MSBuildSettings

### Nuke.Common.CI.TeamCity.TeamCity

- get_BranchName() : string
- get_BuildConfiguration() : string
- get_BuildNumber() : string
- get_BuildTypeId() : string
- get_ConfigurationProperties() : IReadOnlyDictionary<string, string>
- get_Instance() : TeamCity
- get_ProjectName() : string
- get_RecentlyFailedTests() : IReadOnlyCollection<string>
- get_RestClient() : ITeamCityRestClient
- get_RunnerProperties() : IReadOnlyDictionary<string, string>
- get_ServerUrl() : string
- get_SystemProperties() : IReadOnlyDictionary<string, string>
- get_Version() : string
- AddBuildProblem(string description) : void
- AddStatisticValue(string key, string value) : void
- CloseBlock(string name) : void
- CreateRestClient(string serverUrl, string username, string password) : T
- CreateRestClient() : T
- DisableServiceMessages() : void
- EnableServiceMessages() : void
- FinishCompilation(string compiler) : void
- FinishProgress(string text) : void
- ImportData(TeamCityImportType type, string path, TeamCityImportTool? tool = null, bool? verbose = null, bool? parseOutOfDate = null, TeamCityNoDataPublishedAction? action = null) : void
- OpenBlock(string name, string description = null) : void
- PublishArtifacts(string path) : void
- SetBuildNumber(string number) : void
- SetBuildStatus(string text, bool prepend = False, bool append = False) : void
- SetConfigurationParameter(string name, string value) : void
- SetEnvironmentVariable(string name, string value) : void
- SetProgress(string text) : void
- SetSystemProperty(string name, string value) : void
- StartCompilation(string compiler) : void
- StartProgress(string text) : void
- Write(string command, Func<IDictionary<string, object>, IDictionary<string, object>> dictionaryConfigurator) : void
- Write(string command, string[] escapedArguments) : void
- Write(IEnumerable<string> escapedTokens) : void
- Write(string escapedMessage) : void
- WriteError(string text, string errorDetails = null) : void
- WriteFailure(string text) : void
- WriteMessage(string text) : void
- WriteWarning(string text) : void

### Nuke.Common.CI.TeamCity.TeamCityAgentPlatform

- Unix : TeamCityAgentPlatform
- Windows : TeamCityAgentPlatform

### Nuke.Common.CI.TeamCity.TeamCityAttribute

- .ctor(TeamCityAgentPlatform platform)
- get_CleanCheckoutDirectory() : bool
- get_DefaultBranch() : string
- get_Description() : string
- get_GeneratedFiles() : IEnumerable<string>
- get_HostType() : HostType
- get_ManuallyTriggeredTargets() : string[]
- get_NightlyBuildAlways() : bool
- get_NightlyTriggerBranchFilter() : string
- get_NightlyTriggeredTargets() : string[]
- get_NightlyTriggerRules() : string
- get_Platform() : TeamCityAgentPlatform
- get_RelevantTargetNames() : IEnumerable<string>
- get_VcsTriggerBranchFilter() : string
- get_VcsTriggeredTargets() : string[]
- get_VcsTriggerRules() : string
- get_Version() : string
- set_CleanCheckoutDirectory(bool value) : void
- set_DefaultBranch(string value) : void
- set_Description(string value) : void
- set_ManuallyTriggeredTargets(string[] value) : void
- set_NightlyBuildAlways(bool value) : void
- set_NightlyTriggerBranchFilter(string value) : void
- set_NightlyTriggeredTargets(string[] value) : void
- set_NightlyTriggerRules(string value) : void
- set_VcsTriggerBranchFilter(string value) : void
- set_VcsTriggeredTargets(string[] value) : void
- set_VcsTriggerRules(string value) : void
- set_Version(string value) : void
- CreateWriter() : CustomFileWriter
- GetArtifactRule(string source) : string
- GetBuildTypes(NukeBuild build, ExecutableTarget executableTarget, TeamCityVcsRoot vcsRoot, LookupTable<ExecutableTarget, TeamCityBuildType> buildTypes) : IEnumerable<TeamCityBuildType>
- GetConfiguration(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : ConfigurationEntity
- GetGlobalParameters(NukeBuild build) : IEnumerable<TeamCityParameter>
- GetParameter(MemberInfo member, NukeBuild build, bool required) : TeamCityConfigurationParameter
- GetProject(NukeBuild build, IReadOnlyCollection<ExecutableTarget> relevantTargets) : TeamCityProject
- GetTriggers(ExecutableTarget executableTarget, LookupTable<ExecutableTarget, TeamCityBuildType> buildTypes) : IEnumerable<TeamCityTrigger>
- GetVcsRoot(NukeBuild build) : TeamCityVcsRoot
- OnBuildFinishedInternal(NukeBuild build) : void

### Nuke.Common.CI.TeamCity.TeamCityImportTool

- dotcover : TeamCityImportTool
- ncover : TeamCityImportTool
- ncover3 : TeamCityImportTool
- partcover : TeamCityImportTool

### Nuke.Common.CI.TeamCity.TeamCityImportType

- checkstyle : TeamCityImportType
- dotNetCoverage : TeamCityImportType
- DotNetDupFinder : TeamCityImportType
- findBugs : TeamCityImportType
- FxCop : TeamCityImportType
- gtest : TeamCityImportType
- jslint : TeamCityImportType
- junit : TeamCityImportType
- mstest : TeamCityImportType
- nunit : TeamCityImportType
- pmd : TeamCityImportType
- pmdCpd : TeamCityImportType
- ReSharperInspectCode : TeamCityImportType
- surefire : TeamCityImportType
- vstest : TeamCityImportType

### Nuke.Common.CI.TeamCity.TeamCityNoDataPublishedAction

- error : TeamCityNoDataPublishedAction
- info : TeamCityNoDataPublishedAction
- nothing : TeamCityNoDataPublishedAction
- warning : TeamCityNoDataPublishedAction

### Nuke.Common.CI.TeamCity.TeamCityRestObject

- .ctor()
- get_Href() : string

### Nuke.Common.CI.TeamCity.TeamCityStatus

- ERROR : TeamCityStatus
- FAILURE : TeamCityStatus
- NORMAL : TeamCityStatus
- WARNING : TeamCityStatus

### Nuke.Common.CI.TravisCI.TravisCI

- get_AllowFailure() : bool
- get_Branch() : string
- get_BuildDir() : string
- get_BuildId() : long
- get_BuildNumber() : long
- get_Ci() : bool
- get_Commit() : string
- get_CommitMessage() : string
- get_CommitRange() : string
- get_ContinousIntegration() : bool
- get_DartVersion() : string
- get_EventType() : TravisCIEventType
- get_GoVersion() : string
- get_HaxeVersion() : string
- get_Instance() : TravisCI
- get_JdkVersion() : string
- get_JobId() : long
- get_JobNumber() : string
- get_JuliaVersion() : string
- get_NodeVersion() : string
- get_OsName() : string
- get_OtpRelease() : string
- get_PerlVersion() : string
- get_PhpVersion() : string
- get_PullRequest() : string
- get_PullRequestBranch() : string
- get_PullRequestSha() : string
- get_PullRequestSlug() : string
- get_PythonVersion() : string
- get_RepoSlug() : string
- get_RubyVersion() : string
- get_RustVersion() : string
- get_RVersion() : string
- get_ScalaVersion() : string
- get_SecureEnvVars() : bool
- get_Sudo() : bool
- get_Tag() : string
- get_TestResult() : string
- get_XCodeProject() : string
- get_XCodeScheme() : string
- get_XCodeSdk() : string
- get_XCodeWorkspace() : string

### Nuke.Common.CI.TravisCI.TravisCIEventType

- api : TravisCIEventType
- cron : TravisCIEventType
- pull_request : TravisCIEventType
- push : TravisCIEventType

### Nuke.Common.Configuration

- Debug : Configuration
- Release : Configuration
- .ctor()
- op_Implicit(Configuration configuration) : string

### Nuke.Common.ControlFlow

- Assert(bool condition, string text) : void
- AssertWarn(bool condition, string text) : void
- ExecuteWithRetry(Action action, Action cleanup = null, int retryAttempts = 3, int waitInSeconds = 0) : void
- Fail(string format, object[] args) : void
- Fail(object value) : void
- Fail(string text) : void
- NoNullItems(this IEnumerable<T> enumerable) : IReadOnlyCollection<T>
- NotEmpty(this IEnumerable<T> enumerable, string message = null) : IReadOnlyCollection<T>
- NotNull(this T obj, string text = null) : T
- NotNullWarn(this T obj, string text = null) : T
- SuppressErrors(Action action, bool includeStackTrace = False) : void
- SuppressErrors(Func<T> action, T defaultValue = null, bool includeStackTrace = False) : T
- SuppressErrors(Func<IEnumerable<T>> action, bool includeStackTrace = False) : IEnumerable<T>

### Nuke.Common.DependencyBehavior

- Execute : DependencyBehavior
- Skip : DependencyBehavior

### Nuke.Common.EnvironmentInfo

- get_CommandLineArguments() : string[]
- get_Framework() : FrameworkName
- get_Is32Bit() : bool
- get_Is64Bit() : bool
- get_IsLinux() : bool
- get_IsOsx() : bool
- get_IsUnix() : bool
- get_IsWin() : bool
- get_IsWsl() : bool
- get_MachineName() : string
- get_NewLine() : string
- get_Platform() : PlatformFamily
- get_Variables() : IReadOnlyDictionary<string, string>
- get_WorkingDirectory() : string
- set_WorkingDirectory(string value) : void
- ExpandVariables(string value) : string
- GetAllPositionalArguments(char? separator = null) : T[]
- GetNamedArgument(string parameterName, char? separator = null) : T
- GetNamedArgument(Expression<Func<T>> expression) : T
- GetNamedArgument(Expression<Func<object>> expression) : T
- GetNamedArgument(MemberInfo member, Type destinationType = null) : T
- GetParameter(string name, char? separator = null) : T
- GetParameter(Expression<Func<T>> expression) : T
- GetParameter(Expression<Func<object>> expression) : T
- GetParameter(MemberInfo member, Type destinationType = null) : T
- GetPositionalArgument(int position, char? separator = null) : T
- GetVariable(Expression<Func<T>> expression) : T
- GetVariable(Expression<Func<object>> expression) : T
- GetVariable(MemberInfo member, Type destinationType = null) : T
- GetVariable(string parameterName, char? separator = null) : T
- SetVariable(string name, string value) : void
- SpecialFolder(SpecialFolders folder) : string
- SwitchWorkingDirectory(string workingDirectory, bool allowCreate = True) : IDisposable

### Nuke.Common.ExecutableTargetExtensions

- Contains(this IEnumerable<ExecutableTarget> targets, Target target) : bool

### Nuke.Common.Execution.CheckBuildProjectConfigurationsAttribute

- .ctor()
- get_TimeoutInMilliseconds() : int
- set_TimeoutInMilliseconds(int value) : void
- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void

### Nuke.Common.Execution.CheckPathEnvironmentVariableAttribute

- .ctor()
- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void

### Nuke.Common.Execution.ExecutableTarget

- get_Description() : string
- get_Duration() : TimeSpan
- get_Invoked() : bool
- get_IsDefault() : bool
- get_Listed() : bool
- get_Name() : string
- get_SkipReason() : string
- get_Status() : ExecutionStatus

### Nuke.Common.Execution.ExecutionStatus

- Aborted : ExecutionStatus
- Collective : ExecutionStatus
- Executed : ExecutionStatus
- Executing : ExecutionStatus
- Failed : ExecutionStatus
- NotRun : ExecutionStatus
- Skipped : ExecutionStatus

### Nuke.Common.Execution.HandleVisualStudioDebuggingAttribute

- .ctor()
- get_TimeoutInMilliseconds() : int
- OnBeforeLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets) : void

### Nuke.Common.Execution.IBuildExtension


### Nuke.Common.Execution.InjectionAttributeBase

- .ctor()
- get_IsFast() : bool
- get_Priority() : int
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Execution.InjectionUtility

- GetInjectionMembers(Type type) : IReadOnlyCollection<(Member MemberInfo, Attribute InjectionAttributeBase)>
- GetParameterMembers(Type type, bool includeUnlisted) : IReadOnlyCollection<MemberInfo>
- InjectValues(T instance = null, Func<InjectionAttributeBase, bool> filter = null) : void

### Nuke.Common.Execution.IOnAfterLogo

- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void

### Nuke.Common.Execution.IOnBeforeLogo

- OnBeforeLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets) : void

### Nuke.Common.Execution.IOnBuildFinished

- OnBuildFinished(NukeBuild build) : void

### Nuke.Common.Execution.ReflectionService

- All : BindingFlags
- Instance : BindingFlags
- Static : BindingFlags
- Convert(string value) : T
- Convert(object value, Type destinationType) : object
- GetDisplayName(this Type type) : string
- GetDisplayShortName(this Type type) : string
- GetDisplayText(this ParameterInfo parameter) : string
- GetDisplayText(this MemberInfo member) : string
- GetMemberInfo(this LambdaExpression expression) : MemberInfo
- GetMemberType(this MemberInfo member) : Type
- GetNullableType(this Type type) : Type
- GetValue(this MemberInfo member, object obj = null, object[] args = null) : T
- GetValue(this MemberInfo member, object obj = null, object[] args = null) : object
- HasCustomAttribute(this MemberInfo member) : bool
- HasCustomAttribute(this ParameterInfo parameter) : bool
- IsAssembly(this MemberInfo member) : bool
- IsExtensionParameter(this ParameterInfo parameter) : bool
- IsFamily(this MemberInfo member) : bool
- IsNullableType(this Type type) : bool
- IsPublic(this MemberInfo member) : bool
- SetValue(this MemberInfo member, object instance, object value) : void

### Nuke.Common.Execution.UnsetVisualStudioEnvironmentVariablesAttribute

- .ctor()
- OnBeforeLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets) : void

### Nuke.Common.Git.GitHubItemType

- Automatic : GitHubItemType
- Directory : GitHubItemType
- File : GitHubItemType

### Nuke.Common.Git.GitRepository

- .ctor(string endpoint, string identifier, string localDirectory = null, string head = null, string branch = null)
- get_Branch() : string
- get_Endpoint() : string
- get_Head() : string
- get_HttpsUrl() : string
- get_Identifier() : string
- get_LocalDirectory() : string
- get_SshUrl() : string
- FromLocalDirectory(string directory, string branch = null, string remote = origin) : GitRepository
- FromUrl(string url, string branch = null) : GitRepository
- SetBranch(string branch) : GitRepository
- ToString() : string

### Nuke.Common.Git.GitRepositoryAttribute

- .ctor()
- get_Branch() : string
- get_Remote() : string
- set_Branch(string value) : void
- set_Remote(string value) : void
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Git.GitRepositoryExtensions

- IsOnDevelopBranch(this GitRepository repository) : bool
- IsOnFeatureBranch(this GitRepository repository) : bool
- IsOnHotfixBranch(this GitRepository repository) : bool
- IsOnMasterBranch(this GitRepository repository) : bool
- IsOnReleaseBranch(this GitRepository repository) : bool

### Nuke.Common.Gitter.GitterTasks

- SendGitterMessage(string message, string roomId, string token) : void
- SendGitterMessageAsync(string message, string roomId, string token) : Task

### Nuke.Common.HostType

- AppVeyor : HostType
- AzurePipelines : HostType
- Bamboo : HostType
- Bitrise : HostType
- Console : HostType
- GitHubActions : HostType
- GitLab : HostType
- Jenkins : HostType
- TeamCity : HostType
- Travis : HostType

### Nuke.Common.IO.CompressionTasks

- Compress(string directory, string archiveFile, Predicate<FileInfo> filter = null) : void
- CompressTarBZip2(string directory, string archiveFile, Predicate<FileInfo> filter = null, FileMode fileMode = CreateNew) : void
- CompressTarGZip(string directory, string archiveFile, Predicate<FileInfo> filter = null, FileMode fileMode = CreateNew) : void
- CompressZip(string directory, string archiveFile, Predicate<FileInfo> filter = null, CompressionLevel compressionLevel = Optimal, FileMode fileMode = CreateNew) : void
- Uncompress(string archiveFile, string directory) : void
- UncompressTarBZip2(string archiveFile, string directory) : void
- UncompressTarGZip(string archiveFile, string directory) : void
- UncompressZip(string archiveFile, string directory) : void

### Nuke.Common.IO.DirectoryExistsPolicy

- Fail : DirectoryExistsPolicy
- Merge : DirectoryExistsPolicy

### Nuke.Common.IO.DirectoryGlobbingAttribute

- .ctor(string[] patterns)

### Nuke.Common.IO.FileExistsPolicy

- Fail : FileExistsPolicy
- Overwrite : FileExistsPolicy
- OverwriteIfNewer : FileExistsPolicy
- Skip : FileExistsPolicy

### Nuke.Common.IO.FileGlobbingAttribute

- .ctor(string[] patterns)

### Nuke.Common.IO.FileSystemGlobbingAttributeBase

- .ctor(string[] patterns, Func<AbsolutePath, string[], IEnumerable<AbsolutePath>> globber)
- GetValue(MemberInfo member, object instance) : object
- GetValueSet(MemberInfo member, object instance) : IEnumerable<ValueTuple<string, object>>

### Nuke.Common.IO.FileSystemTasks

- CopyDirectoryRecursively(string source, string target, DirectoryExistsPolicy directoryPolicy = Fail, FileExistsPolicy filePolicy = Fail, Func<DirectoryInfo, bool> excludeDirectory = null, Func<FileInfo, bool> excludeFile = null) : void
- CopyFile(string source, string target, FileExistsPolicy policy = Fail, bool createDirectories = True) : void
- CopyFileToDirectory(string source, string targetDirectory, FileExistsPolicy policy = Fail, bool createDirectories = True) : void
- DeleteDirectory(AbsolutePath directory) : void
- DeleteDirectory(string directory) : void
- DeleteFile(AbsolutePath file) : void
- DeleteFile(string file) : void
- DirectoryExists(AbsolutePath path) : bool
- EnsureCleanDirectory(string directory) : void
- EnsureExistingDirectory(string directory) : void
- EnsureExistingParentDirectory(string file) : void
- FileExists(AbsolutePath path) : bool
- FindParentDirectory(string start, Func<DirectoryInfo, bool> predicate) : string
- FindParentDirectory(DirectoryInfo start, Func<DirectoryInfo, bool> predicate) : DirectoryInfo
- GetDirectoryHash(string directory, string[] fileGlobPatterns) : string
- GetFileHash(string file) : string
- GetLastWriteTimeUtc(string path) : DateTime
- IsDotDirectory(DirectoryInfo directory) : bool
- MoveDirectory(string source, string target, DirectoryExistsPolicy directoryPolicy = Fail, FileExistsPolicy filePolicy = Fail) : void
- MoveDirectoryToDirectory(string source, string targetDirectory, DirectoryExistsPolicy directoryPolicy = Fail, FileExistsPolicy filePolicy = Fail) : void
- MoveFile(string source, string target, FileExistsPolicy policy = Fail, bool createDirectories = True) : void
- MoveFileToDirectory(string source, string targetDirectory, FileExistsPolicy policy = Fail, bool createDirectories = True) : void
- RenameDirectory(string directory, string newName, DirectoryExistsPolicy directoryPolicy = Fail, FileExistsPolicy filePolicy = Fail) : void
- RenameFile(string file, string newName, FileExistsPolicy policy = Fail) : void
- Touch(string path, DateTime? time = null, bool createDirectories = True) : void

### Nuke.Common.IO.FtpTasks

- get_FtpCredentials() : NetworkCredential
- set_FtpCredentials(NetworkCredential value) : void
- FtpMakeDirectory(string path) : void
- FtpUploadDirectoryRecursively(string directory, string hostRoot) : void
- FtpUploadFile(string file, string hostDestination) : void

### Nuke.Common.IO.GlobbingCaseSensitivity

- Auto : GlobbingCaseSensitivity
- CaseInsensitive : GlobbingCaseSensitivity
- CaseSensitive : GlobbingCaseSensitivity

### Nuke.Common.IO.GlobbingOptionsAttribute

- .ctor(GlobbingCaseSensitivity caseSensitivity)
- OnBeforeLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets) : void

### Nuke.Common.IO.HttpTasks

- HttpDownloadFile(string uri, string path, Configure<WebClient> clientConfigurator = null, Action<WebHeaderCollection> headerConfigurator = null, Action<WebRequest> requestConfigurator = null) : void
- HttpDownloadFileAsync(string uri, string path, Configure<WebClient> clientConfigurator = null, Action<WebHeaderCollection> headerConfigurator = null, Action<WebRequest> requestConfigurator = null) : Task
- HttpDownloadString(string uri, Configure<WebClient> clientConfigurator = null, Action<WebHeaderCollection> headerConfigurator = null, Action<WebRequest> requestConfigurator = null) : string
- HttpDownloadStringAsync(string uri, Configure<WebClient> clientConfigurator = null, Action<WebHeaderCollection> headerConfigurator = null, Action<WebRequest> requestConfigurator = null) : Task<string>

### Nuke.Common.IO.PathConstruction

- Combine(string left, string right, char? separator = null) : string
- GetPathRoot(string path) : string
- GetRelativePath(string basePath, string destinationPath, bool normalize = True) : string
- GlobDirectories(string directory, string[] patterns) : IReadOnlyCollection<string>
- GlobDirectories(this AbsolutePath directory, string[] patterns) : IReadOnlyCollection<AbsolutePath>
- GlobFiles(string directory, string[] patterns) : IReadOnlyCollection<string>
- GlobFiles(this AbsolutePath directory, string[] patterns) : IReadOnlyCollection<AbsolutePath>
- HasPathRoot(string path) : bool
- IsDescendantPath(string basePath, string destinationPath) : bool
- NormalizePath(string path, char? separator = null) : string

### Nuke.Common.IO.PathConstruction.AbsolutePath

- get_Parent() : AbsolutePath
- Equals(AbsolutePath other) : bool
- Equals(object obj) : bool
- GetHashCode() : int
- op_Division(AbsolutePath left, string right) : AbsolutePath
- op_Explicit(string path) : AbsolutePath
- op_Implicit(AbsolutePath path) : string
- ToString() : string

### Nuke.Common.IO.PathConstruction.AbsolutePath.TypeConverter

- .ctor()
- CanConvertFrom(ITypeDescriptorContext context, Type sourceType) : bool
- ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value) : object

### Nuke.Common.IO.PathConstruction.RelativePath

- .ctor(string path, char? separator = null)
- op_Division(RelativePath left, string right) : RelativePath
- op_Explicit(string path) : RelativePath
- op_Implicit(RelativePath path) : string
- ToString() : string

### Nuke.Common.IO.PathConstruction.UnixRelativePath

- .ctor(string path, char? separator)
- op_Explicit(string path) : UnixRelativePath

### Nuke.Common.IO.PathConstruction.WinRelativePath

- .ctor(string path, char? separator)
- op_Explicit(string path) : WinRelativePath

### Nuke.Common.IO.SerializationTasks

- JsonDeserialize(string content, Configure<JsonSerializerSettings> configurator = null) : T
- JsonDeserializeFromFile(string path) : T
- JsonSerialize(T obj, Configure<JsonSerializerSettings> configurator = null) : string
- JsonSerializeToFile(object obj, string path) : void
- XmlDeserialize(string content) : T
- XmlDeserializeFromFile(string path) : T
- XmlSerialize(T obj) : string
- XmlSerializeToFile(object obj, string path) : void
- YamlDeserialize(string content, Configure<DeserializerBuilder> configurator = null) : T
- YamlDeserializeFromFile(string path, Configure<DeserializerBuilder> configurator = null) : T
- YamlSerialize(object obj, Configure<SerializerBuilder> configurator = null) : string
- YamlSerializeToFile(object obj, string path, Configure<SerializerBuilder> configurator = null) : void

### Nuke.Common.IO.TextTasks

- get_UTF8NoBom() : UTF8Encoding
- ReadAllBytes(string path) : byte[]
- ReadAllLines(string path, Encoding encoding = null) : string[]
- ReadAllText(string path, Encoding encoding = null) : string
- WriteAllBytes(string path, byte[] bytes) : void
- WriteAllLines(string path, IEnumerable<string> lines, Encoding encoding = null) : void
- WriteAllLines(string path, string[] lines, Encoding encoding = null) : void
- WriteAllText(string path, string content, Encoding encoding = null) : void

### Nuke.Common.IO.XmlTasks

- XmlPeek(string path, string xpath, (prefix string, uri string)[] namespaces) : IEnumerable<string>
- XmlPeekSingle(string path, string xpath, (prefix string, uri string)[] namespaces) : string
- XmlPoke(string path, string xpath, object value, (prefix string, uri string)[] namespaces) : void

### Nuke.Common.ITargetDefinition

- After(Target[] targets) : ITargetDefinition
- AssuredAfterFailure() : ITargetDefinition
- Before(Target[] targets) : ITargetDefinition
- DependentFor(Target[] targets) : ITargetDefinition
- DependsOn(Target[] targets) : ITargetDefinition
- Description(string description) : ITargetDefinition
- Executes(Action[] actions) : ITargetDefinition
- Executes(Func<T> action) : ITargetDefinition
- Executes(Func<Task> action) : ITargetDefinition
- OnlyWhenDynamic(Expression<Func<bool>>[] conditions) : ITargetDefinition
- OnlyWhenStatic(Expression<Func<bool>>[] conditions) : ITargetDefinition
- ProceedAfterFailure() : ITargetDefinition
- Requires(Expression<Func<T>>[] parameterRequirement) : ITargetDefinition
- Requires(Expression<Func<T?>>[] parameterRequirement) : ITargetDefinition
- Requires(Expression<Func<bool>>[] requirement) : ITargetDefinition
- TriggeredBy(Target[] targets) : ITargetDefinition
- Triggers(Target[] targets) : ITargetDefinition
- Unlisted() : ITargetDefinition
- WhenSkipped(DependencyBehavior dependencyBehavior) : ITargetDefinition

### Nuke.Common.Logger

- LogLevel : LogLevel
- OutputSink : IOutputSink
- Block(string text) : IDisposable
- Error(string format, object[] args) : void
- Error(object value) : void
- Error(string text = null) : void
- Error(Exception exception) : void
- Info(string format, object[] args) : void
- Info(object value) : void
- Info(string text = null) : void
- Log(LogLevel level, string format, object[] args) : void
- Log(LogLevel level, object value) : void
- Log(LogLevel level, string text = null) : void
- Normal(string format, object[] args) : void
- Normal(object value) : void
- Normal(string text = null) : void
- Success(string format, object[] args) : void
- Success(object value) : void
- Success(string text = null) : void
- Trace(string format, object[] args) : void
- Trace(object value) : void
- Trace(string text = null) : void
- Warn(string format, object[] args) : void
- Warn(object value) : void
- Warn(string text = null) : void
- Warn(Exception exception) : void

### Nuke.Common.LogLevel

- Error : LogLevel
- Normal : LogLevel
- Trace : LogLevel
- Warning : LogLevel

### Nuke.Common.NukeBuild

- .ctor()
- get_BuildAssemblyDirectory() : AbsolutePath
- get_BuildProjectDirectory() : AbsolutePath
- get_Continue() : bool
- get_ExecutingTargets() : IReadOnlyCollection<ExecutableTarget>
- get_Help() : bool
- get_Host() : HostType
- get_InvokedTargets() : IReadOnlyCollection<ExecutableTarget>
- get_IsLocalBuild() : bool
- get_IsServerBuild() : bool
- get_LogLevel() : LogLevel
- get_NoLogo() : bool
- get_Plan() : bool
- get_RootDirectory() : AbsolutePath
- get_SkippedTargets() : IReadOnlyCollection<ExecutableTarget>
- get_TemporaryDirectory() : AbsolutePath
- get_Verbosity() : Verbosity
- set_Verbosity(Verbosity value) : void
- Execute(Expression<Func<T, Target>>[] defaultTargetExpressions) : int

### Nuke.Common.OutputSinks.FigletTransform

- .ctor()
- GetText(string text, string integratedFontName = null) : string
- GetText(string text, Stream stream) : string

### Nuke.Common.OutputSinks.IOutputSink

- WriteBlock(string text) : IDisposable
- WriteError(string text, string details = null) : void
- WriteInformation(string text) : void
- WriteNormal(string text) : void
- WriteSuccess(string text) : void
- WriteTrace(string text) : void
- WriteWarning(string text, string details = null) : void

### Nuke.Common.ParameterAttribute

- .ctor(string description = null)
- get_Description() : string
- get_IsFast() : bool
- get_List() : bool
- get_Name() : string
- get_Separator() : string
- get_ValueProvider() : string
- set_List(bool value) : void
- set_Name(string value) : void
- set_Separator(string value) : void
- set_ValueProvider(string value) : void
- GetValue(MemberInfo member, object instance) : object
- GetValueSet(MemberInfo member, object instance) : IEnumerable<ValueTuple<string, object>>

### Nuke.Common.PlatformFamily

- Linux : PlatformFamily
- OSX : PlatformFamily
- Unknown : PlatformFamily
- Windows : PlatformFamily

### Nuke.Common.ProjectModel.PrimitiveProject

- .ctor(Solution solution, Guid projectId, string name, Guid typeId)
- get_Name() : string
- get_ProjectId() : Guid
- get_Solution() : Solution
- get_SolutionFolder() : SolutionFolder
- get_TypeId() : Guid
- set_SolutionFolder(SolutionFolder value) : void
- Is(ProjectType projectType) : bool

### Nuke.Common.ProjectModel.Project

- get_Configurations() : IDictionary<string, string>
- get_Directory() : AbsolutePath
- get_Path() : AbsolutePath
- op_Implicit(Project project) : string
- ToString() : string

### Nuke.Common.ProjectModel.ProjectExtensions

- GetItemMetadata(this Project project, string itemGroupName, string metadataName) : IEnumerable<string>
- GetItemMetadata(this Project project, string itemGroupName, string metadataName) : IEnumerable<T>
- GetItems(this Project project, string itemGroupName) : IEnumerable<string>
- GetItems(this Project project, string itemGroupName) : IEnumerable<T>
- GetMSBuildProject(this Project project, string configuration = null, string targetFramework = null) : Project
- GetOutputType(this Project project) : string
- GetProperty(this Project project, string propertyName) : string
- GetProperty(this Project project, string propertyName) : T
- GetTargetFrameworks(this Project project) : IReadOnlyCollection<string>

### Nuke.Common.ProjectModel.ProjectModelTasks

- CreateSolution(string fileName = null) : Solution
- ParseProject(string projectFile, string configuration = null, string targetFramework = null) : Project
- ParseSolution(string solutionFile) : Solution

### Nuke.Common.ProjectModel.ProjectType

- AspNetProject : ProjectType
- CSharpProject : ProjectType
- DockerComposeProject : ProjectType
- FSharpProject : ProjectType
- SharePointProject : ProjectType
- SolutionFolder : ProjectType
- SqlProject : ProjectType
- VBNetProject : ProjectType
- VisualCppProject : ProjectType
- VSTAProject : ProjectType
- VSTOProject : ProjectType
- WcfProject : ProjectType
- WindowsPhoneProject : ProjectType
- WindowsStoreProject : ProjectType
- WpfProject : ProjectType
- WwfProject : ProjectType
- XamarinProject : ProjectType
- XnaProject : ProjectType
- .ctor(string[] guids)
- .ctor(Guid[] guids)
- get_FirstGuid() : Guid
- get_Guids() : IReadOnlyCollection<Guid>

### Nuke.Common.ProjectModel.Solution

- .ctor()
- get_AllProjects() : IReadOnlyCollection<Project>
- get_AllSolutionFolders() : IReadOnlyCollection<SolutionFolder>
- get_Configurations() : IDictionary<string, string>
- get_Directory() : AbsolutePath
- get_ExtensibilityGlobals() : IDictionary<string, string>
- get_FileName() : string
- get_Header() : string[]
- get_Name() : string
- get_Path() : AbsolutePath
- get_Projects() : IReadOnlyCollection<Project>
- get_Properties() : IDictionary<string, string>
- get_SolutionFolders() : IReadOnlyCollection<SolutionFolder>
- set_Configurations(IDictionary<string, string> value) : void
- set_ExtensibilityGlobals(IDictionary<string, string> value) : void
- set_Header(string[] value) : void
- set_Properties(IDictionary<string, string> value) : void
- AddProject(string name, Guid typeId, string path, Guid? projectId = null, IDictionary<string, string> configurationPlatforms = null, SolutionFolder solutionFolder = null) : Project
- AddSolutionFolder(string name, Guid? projectId = null, SolutionFolder solutionFolder = null) : SolutionFolder
- GetProject(Guid projectId) : Project
- GetProject(string nameOrFullPath) : Project
- GetProjects(string wildcardPattern) : IEnumerable<Project>
- GetSolutionFolder(Guid projectId) : SolutionFolder
- GetSolutionFolder(string name) : SolutionFolder
- op_Implicit(Solution solution) : string
- RemoveProject(Project project) : void
- RemoveSolutionFolder(SolutionFolder solutionFolder) : IReadOnlyCollection<PrimitiveProject>
- Save() : void
- SaveAs(string fileName) : void
- ToString() : string

### Nuke.Common.ProjectModel.SolutionAttribute

- .ctor()
- .ctor(string relativePath)
- get_List() : bool
- set_List(bool value) : void
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.ProjectModel.SolutionFolder

- .ctor(Solution solution, Guid projectId, string name, IDictionary<string, string> items)
- get_Items() : IDictionary<string, string>
- set_Items(IDictionary<string, string> value) : void

### Nuke.Common.RequiredAttribute

- .ctor()

### Nuke.Common.SpecialFolders

- ApplicationData : SpecialFolders
- CommonApplicationData : SpecialFolders
- LocalApplicationData : SpecialFolders
- ProgramFiles : SpecialFolders
- ProgramFilesX86 : SpecialFolders
- System : SpecialFolders
- UserProfile : SpecialFolders
- Windows : SpecialFolders

### Nuke.Common.Target

- .ctor(object object, IntPtr method)
- BeginInvoke(ITargetDefinition definition, AsyncCallback callback, object object) : IAsyncResult
- EndInvoke(IAsyncResult result) : ITargetDefinition
- Invoke(ITargetDefinition definition) : ITargetDefinition

### Nuke.Common.TargetDefinitionExtensions

- Executes(this ITargetDefinition definition, Target target) : ITargetDefinition

### Nuke.Common.Tooling.Arguments

- .ctor()
- Add(string argumentFormat, bool? condition = True) : Arguments
- Add(string argumentFormat, T? value, char? disallowed = null, bool secret = False) : Arguments
- Add(string argumentFormat, object value, char? disallowed = null, bool secret = False) : Arguments
- Add(string argumentFormat, string value, char? disallowed = null, bool customValue = False, bool secret = False) : Arguments
- Add(string argumentFormat, IEnumerable<T> values, char? separator = null, char? disallowed = null, bool quoteMultiple = False) : Arguments
- Add(string argumentFormat, IReadOnlyDictionary<TKey, TValue> dictionary, string itemFormat, char? separator = null, char? disallowed = null, bool quoteMultiple = False) : Arguments
- Add(string argumentFormat, ILookup<TKey, TValue> lookup, string itemFormat, char? separator = null, char? disallowed = null, bool quoteMultiple = False) : Arguments
- Concatenate(Arguments arguments) : Arguments
- FilterSecrets(string text) : string
- RenderForExecution() : string
- RenderForOutput() : string
- ToString() : string

### Nuke.Common.Tooling.CombinatorialConfigure<T>

- .ctor(object object, IntPtr method)
- BeginInvoke(T settings, AsyncCallback callback, object object) : IAsyncResult
- EndInvoke(IAsyncResult result) : IEnumerable<T>
- Invoke(T settings) : IEnumerable<T>

### Nuke.Common.Tooling.Configure<T>

- .ctor(object object, IntPtr method)
- BeginInvoke(T settings, AsyncCallback callback, object object) : IAsyncResult
- EndInvoke(IAsyncResult result) : T
- Invoke(T settings) : T

### Nuke.Common.Tooling.ConfigureExtensions

- Invoke(this CombinatorialConfigure<TSettings> configurator, Func<TSettings, IReadOnlyCollection<Output>> executor, Action<OutputType, string> logger, int degreeOfParallelism, bool completeOnFailure) : IReadOnlyCollection<(Settings TSettings, Output IReadOnlyCollection<Output>)>
- Invoke(this CombinatorialConfigure<TSettings> configurator, Func<TSettings, (Result TResult, Output IReadOnlyCollection<Output>)> executor, Action<OutputType, string> logger, int degreeOfParallelism, bool completeOnFailure) : IReadOnlyCollection<(Settings TSettings, Result TResult, Output IReadOnlyCollection<Output>)>
- InvokeSafe(this Configure<T> configurator, T obj) : T

### Nuke.Common.Tooling.Enumeration

- .ctor()
- get_Value() : string
- set_Value(string value) : void
- Equals(Enumeration other) : bool
- Equals(object obj) : bool
- GetHashCode() : int
- ToString() : string

### Nuke.Common.Tooling.Enumeration.TypeConverter<T>

- .ctor()
- CanConvertFrom(ITypeDescriptorContext context, Type sourceType) : bool
- ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value) : object

### Nuke.Common.Tooling.EnumerationExtensions

- GetValue(this T value) : string

### Nuke.Common.Tooling.EnumValueAttribute

- .ctor(string value)
- get_Value() : string

### Nuke.Common.Tooling.ExtensionHelper

- AddItems(IDictionary dictionary, string key, IEnumerable<T> values, char separator) : void
- RemoveItems(IDictionary dictionary, string key, IEnumerable<T> values, char separator) : void
- SetCollection(IDictionary dictionary, string key, IEnumerable<T> values, char separator) : void
- ToggleBoolean(IDictionary dictionary, string key) : void

### Nuke.Common.Tooling.IArguments

- FilterSecrets(string text) : string
- RenderForExecution() : string
- RenderForOutput() : string

### Nuke.Common.Tooling.IProcess

- get_Arguments() : string
- get_ExitCode() : int
- get_FileName() : string
- get_Output() : IReadOnlyCollection<Output>
- get_WorkingDirectory() : string
- Kill() : void
- WaitForExit() : bool

### Nuke.Common.Tooling.ISettingsEntity


### Nuke.Common.Tooling.LocalExecutableAttribute

- .ctor(string absoluteOrRelativePath)
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tooling.LookupTable<TKey, TValue>

- .ctor()
- .ctor(IEqualityComparer<TKey> comparer)
- .ctor(ILookup<TKey, TValue> lookupTable, IEqualityComparer<TKey> comparer = null)
- .ctor(Dictionary<TKey, List<TValue>> dictionary)
- get_Count() : int
- get_Item(TKey key) : IEnumerable<TValue>
- Add(TKey key, TValue value) : void
- AddRange(TKey key, IEnumerable<TValue> values) : void
- Clear() : void
- Contains(TKey key) : bool
- GetEnumerator() : IEnumerator<IGrouping<TKey, TValue>>
- Remove(TKey key) : void
- Remove(TKey key, TValue value) : void

### Nuke.Common.Tooling.LookupTableExtensions

- AsReadOnly(this LookupTable<TKey, TValue> lookupTable) : ILookup<TKey, TValue>
- ToLookupTable(this ILookup<TKey, TValue> lookup, IEqualityComparer<TKey> comparer) : LookupTable<TKey, TValue>
- ToLookupTable(this IEnumerable<TItem> enumerable, Func<TItem, TKey> keySelector, Func<TItem, TValue> valueSelector) : LookupTable<TKey, TValue>

### Nuke.Common.Tooling.NuGetPackageResolver

- GetGlobalInstalledPackage(string packageId, string version, string packagesConfigFile) : InstalledPackage
- GetGlobalInstalledPackage(string packageId, VersionRange versionRange, string packagesConfigFile, bool? includePrereleases = null) : InstalledPackage
- GetLatestPackageVersion(string packageId, bool includePrereleases, int? timeout = null) : Task<string>
- GetLocalInstalledPackage(string packageId, string packagesConfigFile, string version = null, bool resolveDependencies = False) : InstalledPackage
- GetLocalInstalledPackages(string packagesConfigFile, bool resolveDependencies = True) : IEnumerable<InstalledPackage>
- GetPackagesConfigFile(string projectDirectory) : string
- IsLegacyFile(string packagesConfigFile) : bool

### Nuke.Common.Tooling.NuGetPackageResolver.InstalledPackage

- .ctor(string fileName)
- get_Directory() : AbsolutePath
- get_FileName() : string
- get_Id() : string
- get_Metadata() : NuspecReader
- get_Version() : NuGetVersion
- ToString() : string

### Nuke.Common.Tooling.NuGetPackageResolver.InstalledPackage.Comparer

- Instance : Comparer
- .ctor()
- Equals(InstalledPackage x, InstalledPackage y) : bool
- GetHashCode(InstalledPackage obj) : int

### Nuke.Common.Tooling.Output

- Text : string
- Type : OutputType

### Nuke.Common.Tooling.OutputType

- Err : OutputType
- Std : OutputType

### Nuke.Common.Tooling.PackageExecutableAttribute

- .ctor(string packageId, string packageExecutable)
- .ctor(string packageId, string packageExecutable32, string packageExecutable64)
- get_Framework() : string
- get_Version() : string
- set_Framework(string value) : void
- set_Version(string value) : void
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tooling.PaketPackageResolver

- GetLocalInstalledPackageDirectory(string packageId, string packagesConfigFile) : string

### Nuke.Common.Tooling.PathExecutableAttribute

- .ctor(string name = null)
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tooling.Process2

- .ctor(Process process, Func<string, string> outputFilter, int? timeout, IReadOnlyCollection<Output> output)
- get_Arguments() : string
- get_ExitCode() : int
- get_FileName() : string
- get_Output() : IReadOnlyCollection<Output>
- get_WorkingDirectory() : string
- Dispose() : void
- Kill() : void
- WaitForExit() : bool

### Nuke.Common.Tooling.ProcessException

- .ctor(IProcess process)
- .ctor(SerializationInfo info, StreamingContext context)

### Nuke.Common.Tooling.ProcessExtensions

- AssertWaitForExit(this IProcess process) : IProcess
- AssertZeroExitCode(this IProcess process) : IProcess
- EnsureOnlyStd(this IReadOnlyCollection<Output> output) : IReadOnlyCollection<Output>

### Nuke.Common.Tooling.ProcessTasks

- DefaultLogInvocation : bool
- DefaultLogOutput : bool
- LogWorkingDirectory : bool
- CheckPathEnvironmentVariable() : void
- DefaultLogger(OutputType type, string output) : void
- StartProcess(ToolSettings toolSettings) : IProcess
- StartProcess(string toolPath, string arguments = null, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Action<OutputType, string> customLogger = null, Func<string, string> outputFilter = null) : IProcess

### Nuke.Common.Tooling.SettingsEntityExtensions

- NewInstance(this T settingsEntity) : T

### Nuke.Common.Tooling.Tool

- .ctor(object object, IntPtr method)
- BeginInvoke(string arguments, string workingDirectory, IReadOnlyDictionary<string, string> environmentVariables, int? timeout, bool? logOutput, bool? logInvocation, Action<OutputType, string> customLogger, Func<string, string> outputFilter, AsyncCallback callback, object object) : IAsyncResult
- EndInvoke(IAsyncResult result) : IReadOnlyCollection<Output>
- Invoke(string arguments = null, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Action<OutputType, string> customLogger = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>

### Nuke.Common.Tooling.ToolPathResolver

- ExecutingAssemblyDirectory : string
- NuGetAssetsConfigFile : string
- NuGetPackagesConfigFile : string
- PaketPackagesConfigFile : string
- GetPackageExecutable(string packageId, string packageExecutable, string version = null, string framework = null) : string
- GetPathExecutable(string pathExecutable) : string
- TryGetEnvironmentExecutable(string environmentExecutable) : string

### Nuke.Common.Tooling.ToolResolver

- GetLocalTool(string absoluteOrRelativePath) : Tool
- GetPackageTool(string packageId, string packageExecutable, string version = null, string framework = null) : Tool
- GetPathTool(string name) : Tool
- TryGetEnvironmentTool(string name) : Tool

### Nuke.Common.Tooling.ToolSettings

- .ctor()
- get_ArgumentConfigurator() : Func<Arguments, Arguments>
- get_CustomLogger() : Action<OutputType, string>
- get_EnvironmentVariables() : IReadOnlyDictionary<string, string>
- get_ExecutionTimeout() : int?
- get_LogInvocation() : bool?
- get_LogOutput() : bool?
- get_ToolPath() : string
- get_WorkingDirectory() : string
- AssertValid() : void
- ConfigureArguments(Arguments arguments) : Arguments
- GetArguments() : IArguments
- GetArgumentsInternal() : Arguments
- HasValidToolPath() : bool
- ToString() : string

### Nuke.Common.Tooling.ToolSettingsExtensions

- AddEnvironmentVariable(this T toolSettings, string environmentVariableKey, string environmentVariableValue) : T
- ClearEnvironmentVariables(this T toolSettings) : T
- CombineWith(this T toolSettings, Configure<T>[] configurators) : T[]
- CombineWith(this T toolSettings, CombinatorialConfigure<T>[] configurators) : T[]
- CombineWith(this IEnumerable<T> toolSettings, Configure<T>[] configurators) : T[]
- CombineWith(this IEnumerable<T> toolSettings, CombinatorialConfigure<T>[] configurators) : T[]
- CombineWith(this T toolSettings, IEnumerable<TValue> values, Func<T, TValue, T> configurator) : T[]
- CombineWith(this IEnumerable<T> toolSettings, IEnumerable<TValue> values, Func<T, TValue, T> configurator) : T[]
- CombineWith(this T toolSettings, IEnumerable<TValue> values, Func<T, TValue, IEnumerable<T>> configurator) : T[]
- CombineWith(this IEnumerable<T> toolSettings, IEnumerable<TValue> values, Func<T, TValue, IEnumerable<T>> configurator) : T[]
- DisableLogInvocation(this T toolSettings) : T
- DisableLogOutput(this T toolSettings) : T
- EnableLogInvocation(this T toolSettings) : T
- EnableLogOutput(this T toolSettings) : T
- RemoveEnvironmentVariable(this T toolSettings, string environmentVariableKey) : T
- SetArgumentConfigurator(this T toolSettings, Func<Arguments, Arguments> argumentConfigurator) : T
- SetEnvironmentVariable(this T toolSettings, string environmentVariableKey, string environmentVariableValue) : T
- SetExecutionTimeout(this T toolSettings, int? executionTimeout) : T
- SetLogInvocation(this T toolSettings, bool enableInvocation) : T
- SetLogOutput(this T toolSettings, bool enableOutput) : T
- SetToolPath(this T toolSettings, string toolPath) : T
- SetWorkingDirectory(this T toolSettings, string workingDirectory) : T
- When(this T settings, bool condition, Configure<T> configurator) : T
- When(this T[] settings, Func<T, bool> condition, Configure<T> configurator) : T[]

### Nuke.Common.Tooling.VerbosityMapping

- Mappings : LookupTable<Type, (Verbosity Verbosity, MappedVerbosity object)>
- Apply(object obj) : void

### Nuke.Common.Tooling.VerbosityMappingAttribute

- .ctor(Type targetType)
- get_Minimal() : string
- get_Normal() : string
- get_Quiet() : string
- get_Verbose() : string
- set_Minimal(string value) : void
- set_Normal(string value) : void
- set_Quiet(string value) : void
- set_Verbose(string value) : void
- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultAttribute

- .ctor()
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultCertificateAttribute

- .ctor(string certificateName = null, bool includeKey = True)
- get_IncludeKey() : bool
- set_IncludeKey(bool value) : void
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultKeyAttribute

- .ctor(string keyName = null)
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultSecretAttribute

- .ctor()
- .ctor(string secretName)
- get_SecretName() : string
- get_SettingFieldName() : string
- set_SecretName(string value) : void
- set_SettingFieldName(string value) : void
- CreateSettings(string secretName, KeyVaultSettings keyVaultSettings) : KeyVaultTaskSettings
- GetSettings(object instance) : KeyVaultSettings
- GetValue(MemberInfo member, object instance) : object

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultSettings

- .ctor()
- get_BaseUrl() : string
- get_ClientId() : string
- get_Secret() : string
- IsValid(out string error) : bool

### Nuke.Common.Tools.AzureKeyVault.Attributes.KeyVaultSettingsAttribute

- .ctor()
- .ctor(string baseUrlParameterName, string clientIdParameterName, string clientSecretParameterName)
- get_BaseUrl() : string
- get_BaseUrlParameterName() : string
- get_ClientId() : string
- get_ClientIdParameterName() : string
- get_ClientSecretParameterName() : string
- set_BaseUrl(string value) : void
- set_BaseUrlParameterName(string value) : void
- set_ClientId(string value) : void
- set_ClientIdParameterName(string value) : void
- set_ClientSecretParameterName(string value) : void
- GetValue(MemberInfo member, object instance) : object
- GetValue(object instance) : KeyVaultSettings

### Nuke.Common.Tools.AzureKeyVault.KeyVault

- Client : KeyVaultClient
- GetCertificate(string certificateName, bool includeKey = True) : Task<KeyVaultCertificate>
- GetKey(string keyName) : Task<KeyVaultKey>
- GetSecret(string secretName) : Task<string>

### Nuke.Common.Tools.AzureKeyVault.KeyVaultCertificate

- .ctor()
- get_Cer() : byte[]
- get_Key() : KeyVaultKey
- get_X509Thumbprint() : byte[]

### Nuke.Common.Tools.AzureKeyVault.KeyVaultKey

- .ctor()
- get_Key() : JsonWebKey
- get_Secret() : string

### Nuke.Common.Tools.AzureKeyVault.KeyVaultTasks

- GetCertificateBundle(KeyVaultTaskSettings settings, bool includeKey = True) : KeyVaultCertificate
- GetKeyBundle(KeyVaultTaskSettings settings) : KeyVaultKey
- GetSecret(KeyVaultTaskSettings settings) : string
- LoadVault(KeyVaultTaskSettings settings) : KeyVault

### Nuke.Common.Tools.AzureKeyVault.KeyVaultTaskSettings

- .ctor()
- .ctor(KeyVaultSettings keyVaultSettings)
- get_ClientId() : string
- get_ClientSecret() : string
- get_SecretName() : string
- get_VaultBaseUrl() : string

### Nuke.Common.Tools.AzureKeyVault.KeyVaultTaskSettingsExtensions

- Set(this KeyVaultTaskSettings keyVaultTaskSettings, KeyVaultSettings settings) : KeyVaultTaskSettings
- SetClientId(this KeyVaultTaskSettings keyVaultSettings, string clientId) : KeyVaultTaskSettings
- SetClientSecret(this KeyVaultTaskSettings keyVaultSettings, string clientSecret) : KeyVaultTaskSettings
- SetSecretName(this KeyVaultTaskSettings keyVaultSettings, string secretName) : KeyVaultTaskSettings
- SetVaultBaseUrl(this KeyVaultTaskSettings keyVaultSettings, string vaultBaseUrl) : KeyVaultTaskSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryApiSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_SkipSSLValidation() : bool?
- get_ToolPath() : string
- get_Unset() : bool?
- get_Url() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryApiSettingsExtensions

- DisableSkipSSLValidation(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- DisableUnset(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- EnableSkipSSLValidation(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- EnableUnset(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- ResetSkipSSLValidation(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- ResetUnset(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- ResetUrl(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- SetSkipSSLValidation(this CloudFoundryApiSettings toolSettings, bool? skipSSLValidation) : CloudFoundryApiSettings
- SetUnset(this CloudFoundryApiSettings toolSettings, bool? unset) : CloudFoundryApiSettings
- SetUrl(this CloudFoundryApiSettings toolSettings, string url) : CloudFoundryApiSettings
- ToggleSkipSSLValidation(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings
- ToggleUnset(this CloudFoundryApiSettings toolSettings) : CloudFoundryApiSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryAuthSettings

- .ctor()
- get_ClientCredentials() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Origin() : string
- get_Password() : string
- get_ToolPath() : string
- get_Username() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryAuthSettingsExtensions

- DisableClientCredentials(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- EnableClientCredentials(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- ResetClientCredentials(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- ResetOrigin(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- ResetPassword(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- ResetUsername(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings
- SetClientCredentials(this CloudFoundryAuthSettings toolSettings, bool? clientCredentials) : CloudFoundryAuthSettings
- SetOrigin(this CloudFoundryAuthSettings toolSettings, string origin) : CloudFoundryAuthSettings
- SetPassword(this CloudFoundryAuthSettings toolSettings, string password) : CloudFoundryAuthSettings
- SetUsername(this CloudFoundryAuthSettings toolSettings, string username) : CloudFoundryAuthSettings
- ToggleClientCredentials(this CloudFoundryAuthSettings toolSettings) : CloudFoundryAuthSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryBindServiceSettings

- .ctor()
- get_AppName() : string
- get_BindingName() : string
- get_ConfigurationParameters() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ServiceInstance() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryBindServiceSettingsExtensions

- ResetAppName(this CloudFoundryBindServiceSettings toolSettings) : CloudFoundryBindServiceSettings
- ResetBindingName(this CloudFoundryBindServiceSettings toolSettings) : CloudFoundryBindServiceSettings
- ResetConfigurationParameters(this CloudFoundryBindServiceSettings toolSettings) : CloudFoundryBindServiceSettings
- ResetServiceInstance(this CloudFoundryBindServiceSettings toolSettings) : CloudFoundryBindServiceSettings
- SetAppName(this CloudFoundryBindServiceSettings toolSettings, string appName) : CloudFoundryBindServiceSettings
- SetBindingName(this CloudFoundryBindServiceSettings toolSettings, string bindingName) : CloudFoundryBindServiceSettings
- SetConfigurationParameters(this CloudFoundryBindServiceSettings toolSettings, string configurationParameters) : CloudFoundryBindServiceSettings
- SetServiceInstance(this CloudFoundryBindServiceSettings toolSettings, string serviceInstance) : CloudFoundryBindServiceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateRouteSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Domain() : string
- get_Hostname() : string
- get_Path() : string
- get_Port() : int?
- get_RandomPort() : bool?
- get_Space() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateRouteSettingsExtensions

- DisableRandomPort(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- EnableRandomPort(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetDomain(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetHostname(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetPath(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetPort(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetRandomPort(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- ResetSpace(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings
- SetDomain(this CloudFoundryCreateRouteSettings toolSettings, string domain) : CloudFoundryCreateRouteSettings
- SetHostname(this CloudFoundryCreateRouteSettings toolSettings, string hostname) : CloudFoundryCreateRouteSettings
- SetPath(this CloudFoundryCreateRouteSettings toolSettings, string path) : CloudFoundryCreateRouteSettings
- SetPort(this CloudFoundryCreateRouteSettings toolSettings, int? port) : CloudFoundryCreateRouteSettings
- SetRandomPort(this CloudFoundryCreateRouteSettings toolSettings, bool? randomPort) : CloudFoundryCreateRouteSettings
- SetSpace(this CloudFoundryCreateRouteSettings toolSettings, string space) : CloudFoundryCreateRouteSettings
- ToggleRandomPort(this CloudFoundryCreateRouteSettings toolSettings) : CloudFoundryCreateRouteSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateServiceSettings

- .ctor()
- get_ConfigurationParameters() : string
- get_CustomLogger() : Action<OutputType, string>
- get_InstanceName() : string
- get_Plan() : string
- get_Service() : string
- get_Tags() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateServiceSettingsExtensions

- AddTags(this CloudFoundryCreateServiceSettings toolSettings, string[] tags) : CloudFoundryCreateServiceSettings
- AddTags(this CloudFoundryCreateServiceSettings toolSettings, IEnumerable<string> tags) : CloudFoundryCreateServiceSettings
- ClearTags(this CloudFoundryCreateServiceSettings toolSettings) : CloudFoundryCreateServiceSettings
- RemoveTags(this CloudFoundryCreateServiceSettings toolSettings, string[] tags) : CloudFoundryCreateServiceSettings
- RemoveTags(this CloudFoundryCreateServiceSettings toolSettings, IEnumerable<string> tags) : CloudFoundryCreateServiceSettings
- ResetConfigurationParameters(this CloudFoundryCreateServiceSettings toolSettings) : CloudFoundryCreateServiceSettings
- ResetInstanceName(this CloudFoundryCreateServiceSettings toolSettings) : CloudFoundryCreateServiceSettings
- ResetPlan(this CloudFoundryCreateServiceSettings toolSettings) : CloudFoundryCreateServiceSettings
- ResetService(this CloudFoundryCreateServiceSettings toolSettings) : CloudFoundryCreateServiceSettings
- SetConfigurationParameters(this CloudFoundryCreateServiceSettings toolSettings, string configurationParameters) : CloudFoundryCreateServiceSettings
- SetInstanceName(this CloudFoundryCreateServiceSettings toolSettings, string instanceName) : CloudFoundryCreateServiceSettings
- SetPlan(this CloudFoundryCreateServiceSettings toolSettings, string plan) : CloudFoundryCreateServiceSettings
- SetService(this CloudFoundryCreateServiceSettings toolSettings, string service) : CloudFoundryCreateServiceSettings
- SetTags(this CloudFoundryCreateServiceSettings toolSettings, string[] tags) : CloudFoundryCreateServiceSettings
- SetTags(this CloudFoundryCreateServiceSettings toolSettings, IEnumerable<string> tags) : CloudFoundryCreateServiceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateSpaceSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Org() : string
- get_Quota() : string
- get_Space() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateSpaceSettingsExtensions

- ResetOrg(this CloudFoundryCreateSpaceSettings toolSettings) : CloudFoundryCreateSpaceSettings
- ResetQuota(this CloudFoundryCreateSpaceSettings toolSettings) : CloudFoundryCreateSpaceSettings
- ResetSpace(this CloudFoundryCreateSpaceSettings toolSettings) : CloudFoundryCreateSpaceSettings
- SetOrg(this CloudFoundryCreateSpaceSettings toolSettings, string org) : CloudFoundryCreateSpaceSettings
- SetQuota(this CloudFoundryCreateSpaceSettings toolSettings, string quota) : CloudFoundryCreateSpaceSettings
- SetSpace(this CloudFoundryCreateSpaceSettings toolSettings, string space) : CloudFoundryCreateSpaceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateUserProvidedServiceSettings

- .ctor()
- .ctor(SerializationInfo info, StreamingContext context)
- get_Credentials() : JObject
- get_CustomLogger() : Action<OutputType, string>
- get_LogUrl() : string
- get_RouteUrl() : string
- get_ServiceInstanceName() : string
- get_Tags() : string
- get_ToolPath() : string
- set_Credentials(JObject value) : void
- ConfigureArguments(Arguments arguments) : Arguments
- GetObjectData(SerializationInfo info, StreamingContext context) : void

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCreateUserProvidedServiceSettingsExtensions

- ResetLogUrl(this CloudFoundryCreateUserProvidedServiceSettings toolSettings) : CloudFoundryCreateUserProvidedServiceSettings
- ResetRouteUrl(this CloudFoundryCreateUserProvidedServiceSettings toolSettings) : CloudFoundryCreateUserProvidedServiceSettings
- ResetServiceInstanceName(this CloudFoundryCreateUserProvidedServiceSettings toolSettings) : CloudFoundryCreateUserProvidedServiceSettings
- ResetTags(this CloudFoundryCreateUserProvidedServiceSettings toolSettings) : CloudFoundryCreateUserProvidedServiceSettings
- SetCredentials(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, Dictionary<string, string> credentials) : CloudFoundryCreateUserProvidedServiceSettings
- SetCredentials(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string key, string value) : CloudFoundryCreateUserProvidedServiceSettings
- SetCredentials(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string credentialsFile) : CloudFoundryCreateUserProvidedServiceSettings
- SetLogUrl(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string logUrl) : CloudFoundryCreateUserProvidedServiceSettings
- SetRouteUrl(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string routeUrl) : CloudFoundryCreateUserProvidedServiceSettings
- SetServiceInstanceName(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string serviceInstanceName) : CloudFoundryCreateUserProvidedServiceSettings
- SetTags(this CloudFoundryCreateUserProvidedServiceSettings toolSettings, string tags) : CloudFoundryCreateUserProvidedServiceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCurlSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_HttpData() : string
- get_HttpMethod() : string
- get_IncludeResponseHeaders() : bool?
- get_Path() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryCurlSettingsExtensions

- DisableIncludeResponseHeaders(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- EnableIncludeResponseHeaders(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- ResetHttpData(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- ResetHttpMethod(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- ResetIncludeResponseHeaders(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- ResetPath(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings
- SetHttpData(this CloudFoundryCurlSettings toolSettings, string httpData) : CloudFoundryCurlSettings
- SetHttpMethod(this CloudFoundryCurlSettings toolSettings, string httpMethod) : CloudFoundryCurlSettings
- SetIncludeResponseHeaders(this CloudFoundryCurlSettings toolSettings, bool? includeResponseHeaders) : CloudFoundryCurlSettings
- SetPath(this CloudFoundryCurlSettings toolSettings, string path) : CloudFoundryCurlSettings
- ToggleIncludeResponseHeaders(this CloudFoundryCurlSettings toolSettings) : CloudFoundryCurlSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteApplicationSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DeleteRoutes() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteApplicationSettingsExtensions

- DisableDeleteRoutes(this CloudFoundryDeleteApplicationSettings toolSettings) : CloudFoundryDeleteApplicationSettings
- EnableDeleteRoutes(this CloudFoundryDeleteApplicationSettings toolSettings) : CloudFoundryDeleteApplicationSettings
- ResetAppName(this CloudFoundryDeleteApplicationSettings toolSettings) : CloudFoundryDeleteApplicationSettings
- ResetDeleteRoutes(this CloudFoundryDeleteApplicationSettings toolSettings) : CloudFoundryDeleteApplicationSettings
- SetAppName(this CloudFoundryDeleteApplicationSettings toolSettings, string appName) : CloudFoundryDeleteApplicationSettings
- SetDeleteRoutes(this CloudFoundryDeleteApplicationSettings toolSettings, bool? deleteRoutes) : CloudFoundryDeleteApplicationSettings
- ToggleDeleteRoutes(this CloudFoundryDeleteApplicationSettings toolSettings) : CloudFoundryDeleteApplicationSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteServiceSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ServiceInstance() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteServiceSettingsExtensions

- ResetServiceInstance(this CloudFoundryDeleteServiceSettings toolSettings) : CloudFoundryDeleteServiceSettings
- SetServiceInstance(this CloudFoundryDeleteServiceSettings toolSettings, string serviceInstance) : CloudFoundryDeleteServiceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteSpaceSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Org() : string
- get_Space() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryDeleteSpaceSettingsExtensions

- ResetOrg(this CloudFoundryDeleteSpaceSettings toolSettings) : CloudFoundryDeleteSpaceSettings
- ResetSpace(this CloudFoundryDeleteSpaceSettings toolSettings) : CloudFoundryDeleteSpaceSettings
- SetOrg(this CloudFoundryDeleteSpaceSettings toolSettings, string org) : CloudFoundryDeleteSpaceSettings
- SetSpace(this CloudFoundryDeleteSpaceSettings toolSettings, string space) : CloudFoundryDeleteSpaceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryGetServiceInfoSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ServiceInstance() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryGetServiceInfoSettingsExtensions

- ResetServiceInstance(this CloudFoundryGetServiceInfoSettings toolSettings) : CloudFoundryGetServiceInfoSettings
- SetServiceInstance(this CloudFoundryGetServiceInfoSettings toolSettings, string serviceInstance) : CloudFoundryGetServiceInfoSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryLoginSettings

- .ctor()
- get_ApiEndpoint() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Org() : string
- get_Password() : string
- get_SkipSslValidation() : bool?
- get_Space() : string
- get_ToolPath() : string
- get_Username() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryLoginSettingsExtensions

- DisableSkipSslValidation(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- EnableSkipSslValidation(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetApiEndpoint(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetOrg(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetPassword(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetSkipSslValidation(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetSpace(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- ResetUsername(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings
- SetApiEndpoint(this CloudFoundryLoginSettings toolSettings, string apiEndpoint) : CloudFoundryLoginSettings
- SetOrg(this CloudFoundryLoginSettings toolSettings, string org) : CloudFoundryLoginSettings
- SetPassword(this CloudFoundryLoginSettings toolSettings, string password) : CloudFoundryLoginSettings
- SetSkipSslValidation(this CloudFoundryLoginSettings toolSettings, bool? skipSslValidation) : CloudFoundryLoginSettings
- SetSpace(this CloudFoundryLoginSettings toolSettings, string space) : CloudFoundryLoginSettings
- SetUsername(this CloudFoundryLoginSettings toolSettings, string username) : CloudFoundryLoginSettings
- ToggleSkipSslValidation(this CloudFoundryLoginSettings toolSettings) : CloudFoundryLoginSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryMapRouteSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Domain() : string
- get_Hostname() : string
- get_Path() : string
- get_Port() : int?
- get_RandomPort() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryMapRouteSettingsExtensions

- DisableRandomPort(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- EnableRandomPort(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetAppName(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetDomain(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetHostname(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetPath(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetPort(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- ResetRandomPort(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings
- SetAppName(this CloudFoundryMapRouteSettings toolSettings, string appName) : CloudFoundryMapRouteSettings
- SetDomain(this CloudFoundryMapRouteSettings toolSettings, string domain) : CloudFoundryMapRouteSettings
- SetHostname(this CloudFoundryMapRouteSettings toolSettings, string hostname) : CloudFoundryMapRouteSettings
- SetPath(this CloudFoundryMapRouteSettings toolSettings, string path) : CloudFoundryMapRouteSettings
- SetPort(this CloudFoundryMapRouteSettings toolSettings, int? port) : CloudFoundryMapRouteSettings
- SetRandomPort(this CloudFoundryMapRouteSettings toolSettings, bool? randomPort) : CloudFoundryMapRouteSettings
- ToggleRandomPort(this CloudFoundryMapRouteSettings toolSettings) : CloudFoundryMapRouteSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryPushSettings

- .ctor()
- get_AppName() : string
- get_Buildpack() : IReadOnlyList<string>
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DockerImage() : string
- get_DockerUsername() : string
- get_Domain() : string
- get_Droplet() : string
- get_HealthCheckType() : HealthCheckType
- get_Hostname() : string
- get_IgnoreManifest() : bool?
- get_Manifest() : string
- get_NoRoute() : bool?
- get_NoStart() : bool?
- get_Path() : string
- get_RandomRoute() : bool?
- get_RoutePath() : string
- get_Stack() : Stack
- get_StartupTimeout() : int?
- get_ToolPath() : string
- get_Variables() : IReadOnlyDictionary<string, string>
- get_VariablesFile() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryPushSettingsExtensions

- AddBuildpack(this CloudFoundryPushSettings toolSettings, string[] buildpack) : CloudFoundryPushSettings
- AddBuildpack(this CloudFoundryPushSettings toolSettings, IEnumerable<string> buildpack) : CloudFoundryPushSettings
- AddVariable(this CloudFoundryPushSettings toolSettings, string variableKey, string variableValue) : CloudFoundryPushSettings
- ClearBuildpack(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ClearVariables(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- DisableIgnoreManifest(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- DisableNoRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- DisableNoStart(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- DisableRandomRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- EnableIgnoreManifest(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- EnableNoRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- EnableNoStart(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- EnableRandomRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- RemoveBuildpack(this CloudFoundryPushSettings toolSettings, string[] buildpack) : CloudFoundryPushSettings
- RemoveBuildpack(this CloudFoundryPushSettings toolSettings, IEnumerable<string> buildpack) : CloudFoundryPushSettings
- RemoveVariable(this CloudFoundryPushSettings toolSettings, string variableKey) : CloudFoundryPushSettings
- ResetAppName(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetCommand(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetDockerImage(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetDockerUsername(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetDomain(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetDroplet(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetHealthCheckType(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetHostname(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetIgnoreManifest(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetManifest(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetNoRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetNoStart(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetPath(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetRandomRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetRoutePath(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetStack(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetStartupTimeout(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ResetVariablesFile(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- SetAppName(this CloudFoundryPushSettings toolSettings, string appName) : CloudFoundryPushSettings
- SetBuildpack(this CloudFoundryPushSettings toolSettings, string[] buildpack) : CloudFoundryPushSettings
- SetBuildpack(this CloudFoundryPushSettings toolSettings, IEnumerable<string> buildpack) : CloudFoundryPushSettings
- SetCommand(this CloudFoundryPushSettings toolSettings, string command) : CloudFoundryPushSettings
- SetDockerImage(this CloudFoundryPushSettings toolSettings, string dockerImage) : CloudFoundryPushSettings
- SetDockerUsername(this CloudFoundryPushSettings toolSettings, string dockerUsername) : CloudFoundryPushSettings
- SetDomain(this CloudFoundryPushSettings toolSettings, string domain) : CloudFoundryPushSettings
- SetDroplet(this CloudFoundryPushSettings toolSettings, string droplet) : CloudFoundryPushSettings
- SetHealthCheckType(this CloudFoundryPushSettings toolSettings, HealthCheckType healthCheckType) : CloudFoundryPushSettings
- SetHostname(this CloudFoundryPushSettings toolSettings, string hostname) : CloudFoundryPushSettings
- SetIgnoreManifest(this CloudFoundryPushSettings toolSettings, bool? ignoreManifest) : CloudFoundryPushSettings
- SetManifest(this CloudFoundryPushSettings toolSettings, string manifest) : CloudFoundryPushSettings
- SetNoRoute(this CloudFoundryPushSettings toolSettings, bool? noRoute) : CloudFoundryPushSettings
- SetNoStart(this CloudFoundryPushSettings toolSettings, bool? noStart) : CloudFoundryPushSettings
- SetPath(this CloudFoundryPushSettings toolSettings, string path) : CloudFoundryPushSettings
- SetRandomRoute(this CloudFoundryPushSettings toolSettings, bool? randomRoute) : CloudFoundryPushSettings
- SetRoutePath(this CloudFoundryPushSettings toolSettings, string routePath) : CloudFoundryPushSettings
- SetStack(this CloudFoundryPushSettings toolSettings, Stack stack) : CloudFoundryPushSettings
- SetStartupTimeout(this CloudFoundryPushSettings toolSettings, int? startupTimeout) : CloudFoundryPushSettings
- SetVariable(this CloudFoundryPushSettings toolSettings, string variableKey, string variableValue) : CloudFoundryPushSettings
- SetVariables(this CloudFoundryPushSettings toolSettings, IDictionary<string, string> variables) : CloudFoundryPushSettings
- SetVariablesFile(this CloudFoundryPushSettings toolSettings, string variablesFile) : CloudFoundryPushSettings
- ToggleIgnoreManifest(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ToggleNoRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ToggleNoStart(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings
- ToggleRandomRoute(this CloudFoundryPushSettings toolSettings) : CloudFoundryPushSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryRestageSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryRestageSettingsExtensions

- ResetAppName(this CloudFoundryRestageSettings toolSettings) : CloudFoundryRestageSettings
- SetAppName(this CloudFoundryRestageSettings toolSettings, string appName) : CloudFoundryRestageSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryRestartSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryRestartSettingsExtensions

- ResetAppName(this CloudFoundryRestartSettings toolSettings) : CloudFoundryRestartSettings
- SetAppName(this CloudFoundryRestartSettings toolSettings, string appName) : CloudFoundryRestartSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryScaleSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Disk() : string
- get_Instances() : string
- get_Memory() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryScaleSettingsExtensions

- ResetDisk(this CloudFoundryScaleSettings toolSettings) : CloudFoundryScaleSettings
- ResetInstances(this CloudFoundryScaleSettings toolSettings) : CloudFoundryScaleSettings
- ResetMemory(this CloudFoundryScaleSettings toolSettings) : CloudFoundryScaleSettings
- SetDisk(this CloudFoundryScaleSettings toolSettings, string disk) : CloudFoundryScaleSettings
- SetInstances(this CloudFoundryScaleSettings toolSettings, string instances) : CloudFoundryScaleSettings
- SetMemory(this CloudFoundryScaleSettings toolSettings, string memory) : CloudFoundryScaleSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundrySetEnvSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_EnvVarName() : string
- get_EnvVarValue() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundrySetEnvSettingsExtensions

- ResetAppName(this CloudFoundrySetEnvSettings toolSettings) : CloudFoundrySetEnvSettings
- ResetEnvVarName(this CloudFoundrySetEnvSettings toolSettings) : CloudFoundrySetEnvSettings
- ResetEnvVarValue(this CloudFoundrySetEnvSettings toolSettings) : CloudFoundrySetEnvSettings
- SetAppName(this CloudFoundrySetEnvSettings toolSettings, string appName) : CloudFoundrySetEnvSettings
- SetEnvVarName(this CloudFoundrySetEnvSettings toolSettings, string envVarName) : CloudFoundrySetEnvSettings
- SetEnvVarValue(this CloudFoundrySetEnvSettings toolSettings, string envVarValue) : CloudFoundrySetEnvSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryStartSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryStartSettingsExtensions

- ResetAppName(this CloudFoundryStartSettings toolSettings) : CloudFoundryStartSettings
- SetAppName(this CloudFoundryStartSettings toolSettings, string appName) : CloudFoundryStartSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryStopSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryStopSettingsExtensions

- ResetAppName(this CloudFoundryStopSettings toolSettings) : CloudFoundryStopSettings
- SetAppName(this CloudFoundryStopSettings toolSettings, string appName) : CloudFoundryStopSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryTargetSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Org() : string
- get_Space() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryTargetSettingsExtensions

- ResetOrg(this CloudFoundryTargetSettings toolSettings) : CloudFoundryTargetSettings
- ResetSpace(this CloudFoundryTargetSettings toolSettings) : CloudFoundryTargetSettings
- SetOrg(this CloudFoundryTargetSettings toolSettings, string org) : CloudFoundryTargetSettings
- SetSpace(this CloudFoundryTargetSettings toolSettings, string space) : CloudFoundryTargetSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryTasks

- get_CloudFoundryLogger() : Action<OutputType, string>
- get_CloudFoundryPath() : string
- set_CloudFoundryLogger(Action<OutputType, string> value) : void
- CloudFoundry(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- CloudFoundryApi(CloudFoundryApiSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryApi(Configure<CloudFoundryApiSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryApi(CombinatorialConfigure<CloudFoundryApiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryApiSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryAuth(CloudFoundryAuthSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryAuth(Configure<CloudFoundryAuthSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryAuth(CombinatorialConfigure<CloudFoundryAuthSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryAuthSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryBindService(CloudFoundryBindServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryBindService(Configure<CloudFoundryBindServiceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryBindService(CombinatorialConfigure<CloudFoundryBindServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryBindServiceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryCreateRoute(CloudFoundryCreateRouteSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryCreateRoute(Configure<CloudFoundryCreateRouteSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryCreateRoute(CombinatorialConfigure<CloudFoundryCreateRouteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryCreateRouteSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryCreateService(CloudFoundryCreateServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryCreateService(Configure<CloudFoundryCreateServiceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryCreateService(CombinatorialConfigure<CloudFoundryCreateServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryCreateServiceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryCreateSpace(CloudFoundryCreateSpaceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryCreateSpace(Configure<CloudFoundryCreateSpaceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryCreateSpace(CombinatorialConfigure<CloudFoundryCreateSpaceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryCreateSpaceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryCreateUserProvidedService(CloudFoundryCreateUserProvidedServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryCreateUserProvidedService(Configure<CloudFoundryCreateUserProvidedServiceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryCreateUserProvidedService(CombinatorialConfigure<CloudFoundryCreateUserProvidedServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryCreateUserProvidedServiceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryCurl(CloudFoundryCurlSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryCurl(Configure<CloudFoundryCurlSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryCurl(CombinatorialConfigure<CloudFoundryCurlSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryCurlSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryDeleteApplication(CloudFoundryDeleteApplicationSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryDeleteApplication(Configure<CloudFoundryDeleteApplicationSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryDeleteApplication(CombinatorialConfigure<CloudFoundryDeleteApplicationSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryDeleteApplicationSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryDeleteService(CloudFoundryDeleteServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryDeleteService(Configure<CloudFoundryDeleteServiceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryDeleteService(CombinatorialConfigure<CloudFoundryDeleteServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryDeleteServiceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryDeleteSpace(CloudFoundryDeleteSpaceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryDeleteSpace(Configure<CloudFoundryDeleteSpaceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryDeleteSpace(CombinatorialConfigure<CloudFoundryDeleteSpaceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryDeleteSpaceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryEnsureServiceReady(string serviceInstance) : Task
- CloudFoundryGetServiceInfo(CloudFoundryGetServiceInfoSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryGetServiceInfo(Configure<CloudFoundryGetServiceInfoSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryGetServiceInfo(CombinatorialConfigure<CloudFoundryGetServiceInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryGetServiceInfoSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryLogin(CloudFoundryLoginSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryLogin(Configure<CloudFoundryLoginSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryLogin(CombinatorialConfigure<CloudFoundryLoginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryLoginSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryMapRoute(CloudFoundryMapRouteSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryMapRoute(Configure<CloudFoundryMapRouteSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryMapRoute(CombinatorialConfigure<CloudFoundryMapRouteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryMapRouteSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryPush(CloudFoundryPushSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryPush(Configure<CloudFoundryPushSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryPush(CombinatorialConfigure<CloudFoundryPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryPushSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryRestage(CloudFoundryRestageSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryRestage(Configure<CloudFoundryRestageSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryRestage(CombinatorialConfigure<CloudFoundryRestageSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryRestageSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryRestart(CloudFoundryRestartSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryRestart(Configure<CloudFoundryRestartSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryRestart(CombinatorialConfigure<CloudFoundryRestartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryRestartSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryScale(CloudFoundryScaleSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryScale(Configure<CloudFoundryScaleSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryScale(CombinatorialConfigure<CloudFoundryScaleSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryScaleSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundrySetEnv(CloudFoundrySetEnvSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundrySetEnv(Configure<CloudFoundrySetEnvSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundrySetEnv(CombinatorialConfigure<CloudFoundrySetEnvSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundrySetEnvSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryStart(CloudFoundryStartSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryStart(Configure<CloudFoundryStartSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryStart(CombinatorialConfigure<CloudFoundryStartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryStartSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryStop(CloudFoundryStopSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryStop(Configure<CloudFoundryStopSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryStop(CombinatorialConfigure<CloudFoundryStopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryStopSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryTarget(CloudFoundryTargetSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryTarget(Configure<CloudFoundryTargetSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryTarget(CombinatorialConfigure<CloudFoundryTargetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryTargetSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryUnbindService(CloudFoundryUnbindServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryUnbindService(Configure<CloudFoundryUnbindServiceSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryUnbindService(CombinatorialConfigure<CloudFoundryUnbindServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryUnbindServiceSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryUnmapRoute(CloudFoundryUnmapRouteSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryUnmapRoute(Configure<CloudFoundryUnmapRouteSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryUnmapRoute(CombinatorialConfigure<CloudFoundryUnmapRouteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryUnmapRouteSettings, Output IReadOnlyCollection<Output>)>
- CloudFoundryUnsetEnv(CloudFoundryUnsetEnvSettings toolSettings = null) : IReadOnlyCollection<Output>
- CloudFoundryUnsetEnv(Configure<CloudFoundryUnsetEnvSettings> configurator) : IReadOnlyCollection<Output>
- CloudFoundryUnsetEnv(CombinatorialConfigure<CloudFoundryUnsetEnvSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CloudFoundryUnsetEnvSettings, Output IReadOnlyCollection<Output>)>
- GetToolPath() : string

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnbindServiceSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ServiceInstance() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnbindServiceSettingsExtensions

- ResetAppName(this CloudFoundryUnbindServiceSettings toolSettings) : CloudFoundryUnbindServiceSettings
- ResetServiceInstance(this CloudFoundryUnbindServiceSettings toolSettings) : CloudFoundryUnbindServiceSettings
- SetAppName(this CloudFoundryUnbindServiceSettings toolSettings, string appName) : CloudFoundryUnbindServiceSettings
- SetServiceInstance(this CloudFoundryUnbindServiceSettings toolSettings, string serviceInstance) : CloudFoundryUnbindServiceSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnmapRouteSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Domain() : string
- get_Hostname() : string
- get_Path() : string
- get_Port() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnmapRouteSettingsExtensions

- ResetAppName(this CloudFoundryUnmapRouteSettings toolSettings) : CloudFoundryUnmapRouteSettings
- ResetDomain(this CloudFoundryUnmapRouteSettings toolSettings) : CloudFoundryUnmapRouteSettings
- ResetHostname(this CloudFoundryUnmapRouteSettings toolSettings) : CloudFoundryUnmapRouteSettings
- ResetPath(this CloudFoundryUnmapRouteSettings toolSettings) : CloudFoundryUnmapRouteSettings
- ResetPort(this CloudFoundryUnmapRouteSettings toolSettings) : CloudFoundryUnmapRouteSettings
- SetAppName(this CloudFoundryUnmapRouteSettings toolSettings, string appName) : CloudFoundryUnmapRouteSettings
- SetDomain(this CloudFoundryUnmapRouteSettings toolSettings, string domain) : CloudFoundryUnmapRouteSettings
- SetHostname(this CloudFoundryUnmapRouteSettings toolSettings, string hostname) : CloudFoundryUnmapRouteSettings
- SetPath(this CloudFoundryUnmapRouteSettings toolSettings, string path) : CloudFoundryUnmapRouteSettings
- SetPort(this CloudFoundryUnmapRouteSettings toolSettings, int? port) : CloudFoundryUnmapRouteSettings

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnsetEnvSettings

- .ctor()
- get_AppName() : string
- get_CustomLogger() : Action<OutputType, string>
- get_EnvironmentalVariableName() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CloudFoundry.CloudFoundryUnsetEnvSettingsExtensions

- ResetAppName(this CloudFoundryUnsetEnvSettings toolSettings) : CloudFoundryUnsetEnvSettings
- ResetEnvironmentalVariableName(this CloudFoundryUnsetEnvSettings toolSettings) : CloudFoundryUnsetEnvSettings
- SetAppName(this CloudFoundryUnsetEnvSettings toolSettings, string appName) : CloudFoundryUnsetEnvSettings
- SetEnvironmentalVariableName(this CloudFoundryUnsetEnvSettings toolSettings, string environmentalVariableName) : CloudFoundryUnsetEnvSettings

### Nuke.Common.Tools.CloudFoundry.HealthCheckType

- Http : HealthCheckType
- None : HealthCheckType
- Port : HealthCheckType
- Process : HealthCheckType
- .ctor()
- op_Explicit(string value) : HealthCheckType

### Nuke.Common.Tools.CloudFoundry.Stack

- cflinuxfs2 : Stack
- cflinuxfs3 : Stack
- windows : Stack
- windows2012R2 : Stack
- windows2016 : Stack
- .ctor()
- op_Explicit(string value) : Stack

### Nuke.Common.Tools.CoverallsNet.CoverallsNetSettings

- .ctor()
- get_BasePath() : string
- get_CommitAuthor() : string
- get_CommitBranch() : string
- get_CommitEmail() : string
- get_CommitId() : string
- get_CommitMessage() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DryRun() : bool?
- get_DynamicCodeCoverage() : bool?
- get_ExportCodeCoverage() : bool?
- get_Input() : string
- get_JobId() : int?
- get_Monocov() : bool?
- get_OpenCover() : bool?
- get_Output() : string
- get_PullRequest() : int?
- get_RepoToken() : string
- get_RepoTokenVariable() : string
- get_ServiceName() : string
- get_ToolPath() : string
- get_UserRelativePaths() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.CoverallsNet.CoverallsNetSettingsExtensions

- DisableDryRun(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- DisableDynamicCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- DisableExportCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- DisableMonocov(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- DisableOpenCover(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- DisableUserRelativePaths(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableDryRun(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableDynamicCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableExportCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableMonocov(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableOpenCover(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- EnableUserRelativePaths(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetBasePath(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetCommitAuthor(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetCommitBranch(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetCommitEmail(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetCommitId(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetCommitMessage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetDryRun(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetDynamicCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetExportCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetInput(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetJobId(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetMonocov(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetOpenCover(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetOutput(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetPullRequest(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetRepoToken(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetRepoTokenVariable(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetServiceName(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ResetUserRelativePaths(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- SetBasePath(this CoverallsNetSettings toolSettings, string basePath) : CoverallsNetSettings
- SetCommitAuthor(this CoverallsNetSettings toolSettings, string commitAuthor) : CoverallsNetSettings
- SetCommitBranch(this CoverallsNetSettings toolSettings, string commitBranch) : CoverallsNetSettings
- SetCommitEmail(this CoverallsNetSettings toolSettings, string commitEmail) : CoverallsNetSettings
- SetCommitId(this CoverallsNetSettings toolSettings, string commitId) : CoverallsNetSettings
- SetCommitMessage(this CoverallsNetSettings toolSettings, string commitMessage) : CoverallsNetSettings
- SetDryRun(this CoverallsNetSettings toolSettings, bool? dryRun) : CoverallsNetSettings
- SetDynamicCodeCoverage(this CoverallsNetSettings toolSettings, bool? dynamicCodeCoverage) : CoverallsNetSettings
- SetExportCodeCoverage(this CoverallsNetSettings toolSettings, bool? exportCodeCoverage) : CoverallsNetSettings
- SetInput(this CoverallsNetSettings toolSettings, string input) : CoverallsNetSettings
- SetJobId(this CoverallsNetSettings toolSettings, int? jobId) : CoverallsNetSettings
- SetMonocov(this CoverallsNetSettings toolSettings, bool? monocov) : CoverallsNetSettings
- SetOpenCover(this CoverallsNetSettings toolSettings, bool? openCover) : CoverallsNetSettings
- SetOutput(this CoverallsNetSettings toolSettings, string output) : CoverallsNetSettings
- SetPullRequest(this CoverallsNetSettings toolSettings, int? pullRequest) : CoverallsNetSettings
- SetRepoToken(this CoverallsNetSettings toolSettings, string repoToken) : CoverallsNetSettings
- SetRepoTokenVariable(this CoverallsNetSettings toolSettings, string repoTokenVariable) : CoverallsNetSettings
- SetServiceName(this CoverallsNetSettings toolSettings, string serviceName) : CoverallsNetSettings
- SetUserRelativePaths(this CoverallsNetSettings toolSettings, bool? userRelativePaths) : CoverallsNetSettings
- ToggleDryRun(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ToggleDynamicCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ToggleExportCodeCoverage(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ToggleMonocov(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ToggleOpenCover(this CoverallsNetSettings toolSettings) : CoverallsNetSettings
- ToggleUserRelativePaths(this CoverallsNetSettings toolSettings) : CoverallsNetSettings

### Nuke.Common.Tools.CoverallsNet.CoverallsNetTasks

- get_CoverallsNetLogger() : Action<OutputType, string>
- get_CoverallsNetPath() : string
- set_CoverallsNetLogger(Action<OutputType, string> value) : void
- CoverallsNet(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- CoverallsNet(CoverallsNetSettings toolSettings = null) : IReadOnlyCollection<Output>
- CoverallsNet(Configure<CoverallsNetSettings> configurator) : IReadOnlyCollection<Output>
- CoverallsNet(CombinatorialConfigure<CoverallsNetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CoverallsNetSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.Coverlet.CoverletOutputFormat

- cobertura : CoverletOutputFormat
- Icov : CoverletOutputFormat
- json : CoverletOutputFormat
- opencover : CoverletOutputFormat
- teamcity : CoverletOutputFormat
- .ctor()
- op_Explicit(string value) : CoverletOutputFormat

### Nuke.Common.Tools.Coverlet.CoverletSettings

- .ctor()
- get_Assembly() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Exclude() : IReadOnlyList<string>
- get_ExcludeByFile() : IReadOnlyList<string>
- get_Format() : IReadOnlyList<CoverletOutputFormat>
- get_Include() : IReadOnlyList<string>
- get_MergeWith() : string
- get_Output() : string
- get_Target() : string
- get_TargetArgs() : IReadOnlyList<string>
- get_Threshold() : int?
- get_ThresholdType() : CoverletThresholdType
- get_ToolPath() : string
- get_Version() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Coverlet.CoverletSettingsExtensions

- AddExclude(this CoverletSettings toolSettings, string[] exclude) : CoverletSettings
- AddExclude(this CoverletSettings toolSettings, IEnumerable<string> exclude) : CoverletSettings
- AddExcludeByFile(this CoverletSettings toolSettings, string[] excludeByFile) : CoverletSettings
- AddExcludeByFile(this CoverletSettings toolSettings, IEnumerable<string> excludeByFile) : CoverletSettings
- AddFormat(this CoverletSettings toolSettings, CoverletOutputFormat[] format) : CoverletSettings
- AddFormat(this CoverletSettings toolSettings, IEnumerable<CoverletOutputFormat> format) : CoverletSettings
- AddInclude(this CoverletSettings toolSettings, string[] include) : CoverletSettings
- AddInclude(this CoverletSettings toolSettings, IEnumerable<string> include) : CoverletSettings
- AddTargetArgs(this CoverletSettings toolSettings, string[] targetArgs) : CoverletSettings
- AddTargetArgs(this CoverletSettings toolSettings, IEnumerable<string> targetArgs) : CoverletSettings
- ClearExclude(this CoverletSettings toolSettings) : CoverletSettings
- ClearExcludeByFile(this CoverletSettings toolSettings) : CoverletSettings
- ClearFormat(this CoverletSettings toolSettings) : CoverletSettings
- ClearInclude(this CoverletSettings toolSettings) : CoverletSettings
- ClearTargetArgs(this CoverletSettings toolSettings) : CoverletSettings
- DisableVersion(this CoverletSettings toolSettings) : CoverletSettings
- EnableVersion(this CoverletSettings toolSettings) : CoverletSettings
- RemoveExclude(this CoverletSettings toolSettings, string[] exclude) : CoverletSettings
- RemoveExclude(this CoverletSettings toolSettings, IEnumerable<string> exclude) : CoverletSettings
- RemoveExcludeByFile(this CoverletSettings toolSettings, string[] excludeByFile) : CoverletSettings
- RemoveExcludeByFile(this CoverletSettings toolSettings, IEnumerable<string> excludeByFile) : CoverletSettings
- RemoveFormat(this CoverletSettings toolSettings, CoverletOutputFormat[] format) : CoverletSettings
- RemoveFormat(this CoverletSettings toolSettings, IEnumerable<CoverletOutputFormat> format) : CoverletSettings
- RemoveInclude(this CoverletSettings toolSettings, string[] include) : CoverletSettings
- RemoveInclude(this CoverletSettings toolSettings, IEnumerable<string> include) : CoverletSettings
- RemoveTargetArgs(this CoverletSettings toolSettings, string[] targetArgs) : CoverletSettings
- RemoveTargetArgs(this CoverletSettings toolSettings, IEnumerable<string> targetArgs) : CoverletSettings
- ResetAssembly(this CoverletSettings toolSettings) : CoverletSettings
- ResetMergeWith(this CoverletSettings toolSettings) : CoverletSettings
- ResetOutput(this CoverletSettings toolSettings) : CoverletSettings
- ResetTarget(this CoverletSettings toolSettings) : CoverletSettings
- ResetTargetSettings(this CoverletSettings toolSettings) : CoverletSettings
- ResetThreshold(this CoverletSettings toolSettings) : CoverletSettings
- ResetThresholdType(this CoverletSettings toolSettings) : CoverletSettings
- ResetVersion(this CoverletSettings toolSettings) : CoverletSettings
- SetAssembly(this CoverletSettings toolSettings, string assembly) : CoverletSettings
- SetExclude(this CoverletSettings toolSettings, string[] exclude) : CoverletSettings
- SetExclude(this CoverletSettings toolSettings, IEnumerable<string> exclude) : CoverletSettings
- SetExcludeByFile(this CoverletSettings toolSettings, string[] excludeByFile) : CoverletSettings
- SetExcludeByFile(this CoverletSettings toolSettings, IEnumerable<string> excludeByFile) : CoverletSettings
- SetFormat(this CoverletSettings toolSettings, CoverletOutputFormat[] format) : CoverletSettings
- SetFormat(this CoverletSettings toolSettings, IEnumerable<CoverletOutputFormat> format) : CoverletSettings
- SetInclude(this CoverletSettings toolSettings, string[] include) : CoverletSettings
- SetInclude(this CoverletSettings toolSettings, IEnumerable<string> include) : CoverletSettings
- SetMergeWith(this CoverletSettings toolSettings, string mergeWith) : CoverletSettings
- SetOutput(this CoverletSettings toolSettings, string output) : CoverletSettings
- SetTarget(this CoverletSettings toolSettings, string target) : CoverletSettings
- SetTargetArgs(this CoverletSettings toolSettings, string[] targetArgs) : CoverletSettings
- SetTargetArgs(this CoverletSettings toolSettings, IEnumerable<string> targetArgs) : CoverletSettings
- SetTargetSettings(this CoverletSettings toolSettings, ToolSettings targetSettings) : CoverletSettings
- SetThreshold(this CoverletSettings toolSettings, int? threshold) : CoverletSettings
- SetThresholdType(this CoverletSettings toolSettings, CoverletThresholdType thresholdType) : CoverletSettings
- SetVersion(this CoverletSettings toolSettings, bool? version) : CoverletSettings
- ToggleVersion(this CoverletSettings toolSettings) : CoverletSettings

### Nuke.Common.Tools.Coverlet.CoverletTasks

- get_CoverletLogger() : Action<OutputType, string>
- get_CoverletPath() : string
- set_CoverletLogger(Action<OutputType, string> value) : void
- Coverlet(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- Coverlet(CoverletSettings toolSettings = null) : IReadOnlyCollection<Output>
- Coverlet(Configure<CoverletSettings> configurator) : IReadOnlyCollection<Output>
- Coverlet(CombinatorialConfigure<CoverletSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings CoverletSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.Coverlet.CoverletThresholdType

- branch : CoverletThresholdType
- line : CoverletThresholdType
- method : CoverletThresholdType
- .ctor()
- op_Explicit(string value) : CoverletThresholdType

### Nuke.Common.Tools.Coverlet.DotNetTestSettingsExtensions

- DisableCollectCoverage(this DotNetTestSettings toolSettings) : DotNetTestSettings
- DisableUseSourceLink(this DotNetTestSettings toolSettings) : DotNetTestSettings
- EnableCollectCoverage(this DotNetTestSettings toolSettings) : DotNetTestSettings
- EnableUseSourceLink(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ResetCollectCoverage(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ResetCoverletOutput(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ResetCoverletOutputFormat(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ResetExcludeByFile(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ResetUseSourceLink(this DotNetTestSettings toolSettings) : DotNetTestSettings
- SetCollectCoverage(this DotNetTestSettings toolSettings, bool? collectCoverage) : DotNetTestSettings
- SetCoverletOutput(this DotNetTestSettings toolSettings, string coverletOutput) : DotNetTestSettings
- SetCoverletOutputFormat(this DotNetTestSettings toolSettings, CoverletOutputFormat coverletOutputFormat) : DotNetTestSettings
- SetExcludeByFile(this DotNetTestSettings toolSettings, string excludeByFile) : DotNetTestSettings
- SetUseSourceLink(this DotNetTestSettings toolSettings, bool? useSourceLink) : DotNetTestSettings
- ToggleCollectCoverage(this DotNetTestSettings toolSettings) : DotNetTestSettings
- ToggleUseSourceLink(this DotNetTestSettings toolSettings) : DotNetTestSettings

### Nuke.Common.Tools.DocFX.DocFXBuildSettings

- .ctor()
- get_ChangesFile() : string
- get_CleanupCacheHistory() : bool?
- get_ConfigFile() : string
- get_Content() : IReadOnlyList<string>
- get_CorrelationId() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableGitFeatures() : bool?
- get_DryRun() : bool?
- get_EnableDebugMode() : bool?
- get_ExportRawModel() : bool?
- get_ExportViewModel() : bool?
- get_FALName() : string
- get_FileMetadataFilePath() : string
- get_FileMetadataFilePaths() : IReadOnlyList<string>
- get_ForcePostProcess() : bool?
- get_ForceRebuild() : bool?
- get_GlobalMetadata() : string
- get_GlobalMetadataFilePath() : string
- get_GlobalMetadataFilePaths() : IReadOnlyList<string>
- get_Host() : string
- get_IntermediateFolder() : string
- get_KeepFileLink() : bool?
- get_LogFilePath() : string
- get_LogLevel() : DocFXLogLevel
- get_LruSize() : int?
- get_MarkdownEngineName() : string
- get_MarkdownEngineProperties() : string
- get_MaxParallelism() : int?
- get_NoLangKeyword() : bool?
- get_OutputFolder() : string
- get_OutputFolderForDebugFiles() : string
- get_Overwrite() : IReadOnlyList<string>
- get_Port() : int?
- get_PostProcessors() : IReadOnlyList<string>
- get_PrintHelpMessage() : bool?
- get_RawModelOutputFolder() : string
- get_RepoRoot() : string
- get_Resource() : IReadOnlyList<string>
- get_SchemaLicense() : string
- get_Serve() : bool?
- get_Templates() : IReadOnlyList<string>
- get_Themes() : IReadOnlyList<string>
- get_ToolPath() : string
- get_ViewModelOutputFolder() : string
- get_WarningsAsErrors() : bool?
- get_XRefMaps() : IReadOnlyList<string>
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXBuildSettingsExtensions

- AddContent(this DocFXBuildSettings toolSettings, string[] content) : DocFXBuildSettings
- AddContent(this DocFXBuildSettings toolSettings, IEnumerable<string> content) : DocFXBuildSettings
- AddFileMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] fileMetadataFilePaths) : DocFXBuildSettings
- AddFileMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXBuildSettings
- AddGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] globalMetadataFilePaths) : DocFXBuildSettings
- AddGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXBuildSettings
- AddOverwrite(this DocFXBuildSettings toolSettings, string[] overwrite) : DocFXBuildSettings
- AddOverwrite(this DocFXBuildSettings toolSettings, IEnumerable<string> overwrite) : DocFXBuildSettings
- AddPostProcessors(this DocFXBuildSettings toolSettings, string[] postProcessors) : DocFXBuildSettings
- AddPostProcessors(this DocFXBuildSettings toolSettings, IEnumerable<string> postProcessors) : DocFXBuildSettings
- AddResource(this DocFXBuildSettings toolSettings, string[] resource) : DocFXBuildSettings
- AddResource(this DocFXBuildSettings toolSettings, IEnumerable<string> resource) : DocFXBuildSettings
- AddTemplates(this DocFXBuildSettings toolSettings, string[] templates) : DocFXBuildSettings
- AddTemplates(this DocFXBuildSettings toolSettings, IEnumerable<string> templates) : DocFXBuildSettings
- AddThemes(this DocFXBuildSettings toolSettings, string[] themes) : DocFXBuildSettings
- AddThemes(this DocFXBuildSettings toolSettings, IEnumerable<string> themes) : DocFXBuildSettings
- AddXRefMaps(this DocFXBuildSettings toolSettings, string[] xrefMaps) : DocFXBuildSettings
- AddXRefMaps(this DocFXBuildSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXBuildSettings
- ClearContent(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearFileMetadataFilePaths(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearOverwrite(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearPostProcessors(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearResource(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearTemplates(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearThemes(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ClearXRefMaps(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableCleanupCacheHistory(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableDisableGitFeatures(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableDryRun(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableEnableDebugMode(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableExportRawModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableExportViewModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableForcePostProcess(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableForceRebuild(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableKeepFileLink(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableNoLangKeyword(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisablePrintHelpMessage(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableServe(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- DisableWarningsAsErrors(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableCleanupCacheHistory(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableDisableGitFeatures(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableDryRun(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableEnableDebugMode(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableExportRawModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableExportViewModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableForcePostProcess(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableForceRebuild(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableKeepFileLink(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableNoLangKeyword(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnablePrintHelpMessage(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableServe(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- EnableWarningsAsErrors(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- RemoveContent(this DocFXBuildSettings toolSettings, string[] content) : DocFXBuildSettings
- RemoveContent(this DocFXBuildSettings toolSettings, IEnumerable<string> content) : DocFXBuildSettings
- RemoveFileMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] fileMetadataFilePaths) : DocFXBuildSettings
- RemoveFileMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXBuildSettings
- RemoveGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] globalMetadataFilePaths) : DocFXBuildSettings
- RemoveGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXBuildSettings
- RemoveOverwrite(this DocFXBuildSettings toolSettings, string[] overwrite) : DocFXBuildSettings
- RemoveOverwrite(this DocFXBuildSettings toolSettings, IEnumerable<string> overwrite) : DocFXBuildSettings
- RemovePostProcessors(this DocFXBuildSettings toolSettings, string[] postProcessors) : DocFXBuildSettings
- RemovePostProcessors(this DocFXBuildSettings toolSettings, IEnumerable<string> postProcessors) : DocFXBuildSettings
- RemoveResource(this DocFXBuildSettings toolSettings, string[] resource) : DocFXBuildSettings
- RemoveResource(this DocFXBuildSettings toolSettings, IEnumerable<string> resource) : DocFXBuildSettings
- RemoveTemplates(this DocFXBuildSettings toolSettings, string[] templates) : DocFXBuildSettings
- RemoveTemplates(this DocFXBuildSettings toolSettings, IEnumerable<string> templates) : DocFXBuildSettings
- RemoveThemes(this DocFXBuildSettings toolSettings, string[] themes) : DocFXBuildSettings
- RemoveThemes(this DocFXBuildSettings toolSettings, IEnumerable<string> themes) : DocFXBuildSettings
- RemoveXRefMaps(this DocFXBuildSettings toolSettings, string[] xrefMaps) : DocFXBuildSettings
- RemoveXRefMaps(this DocFXBuildSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXBuildSettings
- ResetChangesFile(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetCleanupCacheHistory(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetConfigFile(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetCorrelationId(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetDisableGitFeatures(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetDryRun(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetEnableDebugMode(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetExportRawModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetExportViewModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetFALName(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetFileMetadataFilePath(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetForcePostProcess(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetForceRebuild(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetGlobalMetadata(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetGlobalMetadataFilePath(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetHost(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetIntermediateFolder(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetKeepFileLink(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetLogFilePath(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetLogLevel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetLruSize(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetMarkdownEngineName(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetMarkdownEngineProperties(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetMaxParallelism(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetNoLangKeyword(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetOutputFolder(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetOutputFolderForDebugFiles(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetPort(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetPrintHelpMessage(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetRawModelOutputFolder(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetRepoRoot(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetSchemaLicense(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetServe(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetViewModelOutputFolder(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ResetWarningsAsErrors(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- SetChangesFile(this DocFXBuildSettings toolSettings, string changesFile) : DocFXBuildSettings
- SetCleanupCacheHistory(this DocFXBuildSettings toolSettings, bool? cleanupCacheHistory) : DocFXBuildSettings
- SetConfigFile(this DocFXBuildSettings toolSettings, string configFile) : DocFXBuildSettings
- SetContent(this DocFXBuildSettings toolSettings, string[] content) : DocFXBuildSettings
- SetContent(this DocFXBuildSettings toolSettings, IEnumerable<string> content) : DocFXBuildSettings
- SetCorrelationId(this DocFXBuildSettings toolSettings, string correlationId) : DocFXBuildSettings
- SetDisableGitFeatures(this DocFXBuildSettings toolSettings, bool? disableGitFeatures) : DocFXBuildSettings
- SetDryRun(this DocFXBuildSettings toolSettings, bool? dryRun) : DocFXBuildSettings
- SetEnableDebugMode(this DocFXBuildSettings toolSettings, bool? enableDebugMode) : DocFXBuildSettings
- SetExportRawModel(this DocFXBuildSettings toolSettings, bool? exportRawModel) : DocFXBuildSettings
- SetExportViewModel(this DocFXBuildSettings toolSettings, bool? exportViewModel) : DocFXBuildSettings
- SetFALName(this DocFXBuildSettings toolSettings, string falname) : DocFXBuildSettings
- SetFileMetadataFilePath(this DocFXBuildSettings toolSettings, string fileMetadataFilePath) : DocFXBuildSettings
- SetFileMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] fileMetadataFilePaths) : DocFXBuildSettings
- SetFileMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXBuildSettings
- SetForcePostProcess(this DocFXBuildSettings toolSettings, bool? forcePostProcess) : DocFXBuildSettings
- SetForceRebuild(this DocFXBuildSettings toolSettings, bool? forceRebuild) : DocFXBuildSettings
- SetGlobalMetadata(this DocFXBuildSettings toolSettings, string globalMetadata) : DocFXBuildSettings
- SetGlobalMetadataFilePath(this DocFXBuildSettings toolSettings, string globalMetadataFilePath) : DocFXBuildSettings
- SetGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, string[] globalMetadataFilePaths) : DocFXBuildSettings
- SetGlobalMetadataFilePaths(this DocFXBuildSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXBuildSettings
- SetHost(this DocFXBuildSettings toolSettings, string host) : DocFXBuildSettings
- SetIntermediateFolder(this DocFXBuildSettings toolSettings, string intermediateFolder) : DocFXBuildSettings
- SetKeepFileLink(this DocFXBuildSettings toolSettings, bool? keepFileLink) : DocFXBuildSettings
- SetLogFilePath(this DocFXBuildSettings toolSettings, string logFilePath) : DocFXBuildSettings
- SetLogLevel(this DocFXBuildSettings toolSettings, DocFXLogLevel logLevel) : DocFXBuildSettings
- SetLruSize(this DocFXBuildSettings toolSettings, int? lruSize) : DocFXBuildSettings
- SetMarkdownEngineName(this DocFXBuildSettings toolSettings, string markdownEngineName) : DocFXBuildSettings
- SetMarkdownEngineProperties(this DocFXBuildSettings toolSettings, string markdownEngineProperties) : DocFXBuildSettings
- SetMaxParallelism(this DocFXBuildSettings toolSettings, int? maxParallelism) : DocFXBuildSettings
- SetNoLangKeyword(this DocFXBuildSettings toolSettings, bool? noLangKeyword) : DocFXBuildSettings
- SetOutputFolder(this DocFXBuildSettings toolSettings, string outputFolder) : DocFXBuildSettings
- SetOutputFolderForDebugFiles(this DocFXBuildSettings toolSettings, string outputFolderForDebugFiles) : DocFXBuildSettings
- SetOverwrite(this DocFXBuildSettings toolSettings, string[] overwrite) : DocFXBuildSettings
- SetOverwrite(this DocFXBuildSettings toolSettings, IEnumerable<string> overwrite) : DocFXBuildSettings
- SetPort(this DocFXBuildSettings toolSettings, int? port) : DocFXBuildSettings
- SetPostProcessors(this DocFXBuildSettings toolSettings, string[] postProcessors) : DocFXBuildSettings
- SetPostProcessors(this DocFXBuildSettings toolSettings, IEnumerable<string> postProcessors) : DocFXBuildSettings
- SetPrintHelpMessage(this DocFXBuildSettings toolSettings, bool? printHelpMessage) : DocFXBuildSettings
- SetRawModelOutputFolder(this DocFXBuildSettings toolSettings, string rawModelOutputFolder) : DocFXBuildSettings
- SetRepoRoot(this DocFXBuildSettings toolSettings, string repoRoot) : DocFXBuildSettings
- SetResource(this DocFXBuildSettings toolSettings, string[] resource) : DocFXBuildSettings
- SetResource(this DocFXBuildSettings toolSettings, IEnumerable<string> resource) : DocFXBuildSettings
- SetSchemaLicense(this DocFXBuildSettings toolSettings, string schemaLicense) : DocFXBuildSettings
- SetServe(this DocFXBuildSettings toolSettings, bool? serve) : DocFXBuildSettings
- SetTemplates(this DocFXBuildSettings toolSettings, string[] templates) : DocFXBuildSettings
- SetTemplates(this DocFXBuildSettings toolSettings, IEnumerable<string> templates) : DocFXBuildSettings
- SetThemes(this DocFXBuildSettings toolSettings, string[] themes) : DocFXBuildSettings
- SetThemes(this DocFXBuildSettings toolSettings, IEnumerable<string> themes) : DocFXBuildSettings
- SetViewModelOutputFolder(this DocFXBuildSettings toolSettings, string viewModelOutputFolder) : DocFXBuildSettings
- SetWarningsAsErrors(this DocFXBuildSettings toolSettings, bool? warningsAsErrors) : DocFXBuildSettings
- SetXRefMaps(this DocFXBuildSettings toolSettings, string[] xrefMaps) : DocFXBuildSettings
- SetXRefMaps(this DocFXBuildSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXBuildSettings
- ToggleCleanupCacheHistory(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleDisableGitFeatures(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleDryRun(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleEnableDebugMode(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleExportRawModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleExportViewModel(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleForcePostProcess(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleForceRebuild(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleKeepFileLink(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleNoLangKeyword(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- TogglePrintHelpMessage(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleServe(this DocFXBuildSettings toolSettings) : DocFXBuildSettings
- ToggleWarningsAsErrors(this DocFXBuildSettings toolSettings) : DocFXBuildSettings

### Nuke.Common.Tools.DocFX.DocFXDependencySettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_DependencyFile() : string
- get_IntermediateFolder() : string
- get_PrintHelpMessage() : bool?
- get_ToolPath() : string
- get_VersionName() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXDependencySettingsExtensions

- DisablePrintHelpMessage(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- EnablePrintHelpMessage(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- ResetDependencyFile(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- ResetIntermediateFolder(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- ResetPrintHelpMessage(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- ResetVersionName(this DocFXDependencySettings toolSettings) : DocFXDependencySettings
- SetDependencyFile(this DocFXDependencySettings toolSettings, string dependencyFile) : DocFXDependencySettings
- SetIntermediateFolder(this DocFXDependencySettings toolSettings, string intermediateFolder) : DocFXDependencySettings
- SetPrintHelpMessage(this DocFXDependencySettings toolSettings, bool? printHelpMessage) : DocFXDependencySettings
- SetVersionName(this DocFXDependencySettings toolSettings, string versionName) : DocFXDependencySettings
- TogglePrintHelpMessage(this DocFXDependencySettings toolSettings) : DocFXDependencySettings

### Nuke.Common.Tools.DocFX.DocFXDownloadSettings

- .ctor()
- get_ArchiveFile() : string
- get_CustomLogger() : Action<OutputType, string>
- get_PrintHelpMessage() : bool?
- get_ToolPath() : string
- get_Uri() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXDownloadSettingsExtensions

- DisablePrintHelpMessage(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings
- EnablePrintHelpMessage(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings
- ResetArchiveFile(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings
- ResetPrintHelpMessage(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings
- ResetUri(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings
- SetArchiveFile(this DocFXDownloadSettings toolSettings, string archiveFile) : DocFXDownloadSettings
- SetPrintHelpMessage(this DocFXDownloadSettings toolSettings, bool? printHelpMessage) : DocFXDownloadSettings
- SetUri(this DocFXDownloadSettings toolSettings, string uri) : DocFXDownloadSettings
- TogglePrintHelpMessage(this DocFXDownloadSettings toolSettings) : DocFXDownloadSettings

### Nuke.Common.Tools.DocFX.DocFXHelpSettings

- .ctor()
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXHelpSettingsExtensions

- ResetCommand(this DocFXHelpSettings toolSettings) : DocFXHelpSettings
- SetCommand(this DocFXHelpSettings toolSettings, string command) : DocFXHelpSettings

### Nuke.Common.Tools.DocFX.DocFXInitSettings

- .ctor()
- get_ApiSourceFolder() : string
- get_ApiSourceGlobPattern() : string
- get_CustomLogger() : Action<OutputType, string>
- get_OnlyConfigFile() : bool?
- get_OutputFolder() : string
- get_Overwrite() : bool?
- get_PrintHelpMessage() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXInitSettingsExtensions

- DisableOnlyConfigFile(this DocFXInitSettings toolSettings) : DocFXInitSettings
- DisableOverwrite(this DocFXInitSettings toolSettings) : DocFXInitSettings
- DisablePrintHelpMessage(this DocFXInitSettings toolSettings) : DocFXInitSettings
- DisableQuiet(this DocFXInitSettings toolSettings) : DocFXInitSettings
- EnableOnlyConfigFile(this DocFXInitSettings toolSettings) : DocFXInitSettings
- EnableOverwrite(this DocFXInitSettings toolSettings) : DocFXInitSettings
- EnablePrintHelpMessage(this DocFXInitSettings toolSettings) : DocFXInitSettings
- EnableQuiet(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetApiSourceFolder(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetApiSourceGlobPattern(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetOnlyConfigFile(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetOutputFolder(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetOverwrite(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetPrintHelpMessage(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ResetQuiet(this DocFXInitSettings toolSettings) : DocFXInitSettings
- SetApiSourceFolder(this DocFXInitSettings toolSettings, string apiSourceFolder) : DocFXInitSettings
- SetApiSourceGlobPattern(this DocFXInitSettings toolSettings, string apiSourceGlobPattern) : DocFXInitSettings
- SetOnlyConfigFile(this DocFXInitSettings toolSettings, bool? onlyConfigFile) : DocFXInitSettings
- SetOutputFolder(this DocFXInitSettings toolSettings, string outputFolder) : DocFXInitSettings
- SetOverwrite(this DocFXInitSettings toolSettings, bool? overwrite) : DocFXInitSettings
- SetPrintHelpMessage(this DocFXInitSettings toolSettings, bool? printHelpMessage) : DocFXInitSettings
- SetQuiet(this DocFXInitSettings toolSettings, bool? quiet) : DocFXInitSettings
- ToggleOnlyConfigFile(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ToggleOverwrite(this DocFXInitSettings toolSettings) : DocFXInitSettings
- TogglePrintHelpMessage(this DocFXInitSettings toolSettings) : DocFXInitSettings
- ToggleQuiet(this DocFXInitSettings toolSettings) : DocFXInitSettings

### Nuke.Common.Tools.DocFX.DocFXLogLevel

- Diagnostic : DocFXLogLevel
- Error : DocFXLogLevel
- Info : DocFXLogLevel
- Suggestion : DocFXLogLevel
- Verbose : DocFXLogLevel
- Warning : DocFXLogLevel
- .ctor()
- op_Explicit(string value) : DocFXLogLevel

### Nuke.Common.Tools.DocFX.DocFXMergeSettings

- .ctor()
- get_ConfigFile() : string
- get_Content() : IReadOnlyList<string>
- get_CorrelationId() : string
- get_CustomLogger() : Action<OutputType, string>
- get_FileMetadataFilePath() : string
- get_GlobalMetadata() : string
- get_GlobalMetadataFilePath() : string
- get_LogFilePath() : string
- get_LogLevel() : DocFXLogLevel
- get_PrintHelpMessage() : bool?
- get_RepoRoot() : string
- get_TocMetadata() : IReadOnlyList<string>
- get_ToolPath() : string
- get_WarningsAsErrors() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXMergeSettingsExtensions

- AddContent(this DocFXMergeSettings toolSettings, string[] content) : DocFXMergeSettings
- AddContent(this DocFXMergeSettings toolSettings, IEnumerable<string> content) : DocFXMergeSettings
- AddTocMetadata(this DocFXMergeSettings toolSettings, string[] tocMetadata) : DocFXMergeSettings
- AddTocMetadata(this DocFXMergeSettings toolSettings, IEnumerable<string> tocMetadata) : DocFXMergeSettings
- ClearContent(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ClearTocMetadata(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- DisablePrintHelpMessage(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- DisableWarningsAsErrors(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- EnablePrintHelpMessage(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- EnableWarningsAsErrors(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- RemoveContent(this DocFXMergeSettings toolSettings, string[] content) : DocFXMergeSettings
- RemoveContent(this DocFXMergeSettings toolSettings, IEnumerable<string> content) : DocFXMergeSettings
- RemoveTocMetadata(this DocFXMergeSettings toolSettings, string[] tocMetadata) : DocFXMergeSettings
- RemoveTocMetadata(this DocFXMergeSettings toolSettings, IEnumerable<string> tocMetadata) : DocFXMergeSettings
- ResetConfigFile(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetCorrelationId(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetFileMetadataFilePath(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetGlobalMetadata(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetGlobalMetadataFilePath(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetLogFilePath(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetLogLevel(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetPrintHelpMessage(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetRepoRoot(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ResetWarningsAsErrors(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- SetConfigFile(this DocFXMergeSettings toolSettings, string configFile) : DocFXMergeSettings
- SetContent(this DocFXMergeSettings toolSettings, string[] content) : DocFXMergeSettings
- SetContent(this DocFXMergeSettings toolSettings, IEnumerable<string> content) : DocFXMergeSettings
- SetCorrelationId(this DocFXMergeSettings toolSettings, string correlationId) : DocFXMergeSettings
- SetFileMetadataFilePath(this DocFXMergeSettings toolSettings, string fileMetadataFilePath) : DocFXMergeSettings
- SetGlobalMetadata(this DocFXMergeSettings toolSettings, string globalMetadata) : DocFXMergeSettings
- SetGlobalMetadataFilePath(this DocFXMergeSettings toolSettings, string globalMetadataFilePath) : DocFXMergeSettings
- SetLogFilePath(this DocFXMergeSettings toolSettings, string logFilePath) : DocFXMergeSettings
- SetLogLevel(this DocFXMergeSettings toolSettings, DocFXLogLevel logLevel) : DocFXMergeSettings
- SetPrintHelpMessage(this DocFXMergeSettings toolSettings, bool? printHelpMessage) : DocFXMergeSettings
- SetRepoRoot(this DocFXMergeSettings toolSettings, string repoRoot) : DocFXMergeSettings
- SetTocMetadata(this DocFXMergeSettings toolSettings, string[] tocMetadata) : DocFXMergeSettings
- SetTocMetadata(this DocFXMergeSettings toolSettings, IEnumerable<string> tocMetadata) : DocFXMergeSettings
- SetWarningsAsErrors(this DocFXMergeSettings toolSettings, bool? warningsAsErrors) : DocFXMergeSettings
- TogglePrintHelpMessage(this DocFXMergeSettings toolSettings) : DocFXMergeSettings
- ToggleWarningsAsErrors(this DocFXMergeSettings toolSettings) : DocFXMergeSettings

### Nuke.Common.Tools.DocFX.DocFXMetadataSettings

- .ctor()
- get_CorrelationId() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableDefaultFilter() : bool?
- get_DisableGitFeatures() : bool?
- get_FilterConfigFile() : string
- get_ForceRebuild() : bool?
- get_GlobalNamespaceId() : string
- get_LogFilePath() : string
- get_LogLevel() : DocFXLogLevel
- get_MSBuildProperties() : IReadOnlyDictionary<string, string>
- get_OutputFolder() : string
- get_PreserveRawInlineComments() : bool?
- get_PrintHelpMessage() : bool?
- get_Projects() : IReadOnlyList<string>
- get_RepoRoot() : string
- get_ShouldSkipMarkup() : bool?
- get_ToolPath() : string
- get_WarningsAsErrors() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXMetadataSettingsExtensions

- AddMSBuildProperty(this DocFXMetadataSettings toolSettings, string msbuildPropertyKey, string msbuildPropertyValue) : DocFXMetadataSettings
- AddProjects(this DocFXMetadataSettings toolSettings, string[] projects) : DocFXMetadataSettings
- AddProjects(this DocFXMetadataSettings toolSettings, IEnumerable<string> projects) : DocFXMetadataSettings
- ClearMSBuildProperties(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ClearProjects(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisableDisableDefaultFilter(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisableDisableGitFeatures(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisableForceRebuild(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisablePreserveRawInlineComments(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisablePrintHelpMessage(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisableShouldSkipMarkup(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- DisableWarningsAsErrors(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnableDisableDefaultFilter(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnableDisableGitFeatures(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnableForceRebuild(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnablePreserveRawInlineComments(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnablePrintHelpMessage(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnableShouldSkipMarkup(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- EnableWarningsAsErrors(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- RemoveMSBuildProperty(this DocFXMetadataSettings toolSettings, string msbuildPropertyKey) : DocFXMetadataSettings
- RemoveProjects(this DocFXMetadataSettings toolSettings, string[] projects) : DocFXMetadataSettings
- RemoveProjects(this DocFXMetadataSettings toolSettings, IEnumerable<string> projects) : DocFXMetadataSettings
- ResetCorrelationId(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetDisableDefaultFilter(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetDisableGitFeatures(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetFilterConfigFile(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetForceRebuild(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetGlobalNamespaceId(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetLogFilePath(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetLogLevel(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetOutputFolder(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetPreserveRawInlineComments(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetPrintHelpMessage(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetRepoRoot(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetShouldSkipMarkup(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ResetWarningsAsErrors(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- SetCorrelationId(this DocFXMetadataSettings toolSettings, string correlationId) : DocFXMetadataSettings
- SetDisableDefaultFilter(this DocFXMetadataSettings toolSettings, bool? disableDefaultFilter) : DocFXMetadataSettings
- SetDisableGitFeatures(this DocFXMetadataSettings toolSettings, bool? disableGitFeatures) : DocFXMetadataSettings
- SetFilterConfigFile(this DocFXMetadataSettings toolSettings, string filterConfigFile) : DocFXMetadataSettings
- SetForceRebuild(this DocFXMetadataSettings toolSettings, bool? forceRebuild) : DocFXMetadataSettings
- SetGlobalNamespaceId(this DocFXMetadataSettings toolSettings, string globalNamespaceId) : DocFXMetadataSettings
- SetLogFilePath(this DocFXMetadataSettings toolSettings, string logFilePath) : DocFXMetadataSettings
- SetLogLevel(this DocFXMetadataSettings toolSettings, DocFXLogLevel logLevel) : DocFXMetadataSettings
- SetMSBuildProperties(this DocFXMetadataSettings toolSettings, IDictionary<string, string> msbuildProperties) : DocFXMetadataSettings
- SetMSBuildProperty(this DocFXMetadataSettings toolSettings, string msbuildPropertyKey, string msbuildPropertyValue) : DocFXMetadataSettings
- SetOutputFolder(this DocFXMetadataSettings toolSettings, string outputFolder) : DocFXMetadataSettings
- SetPreserveRawInlineComments(this DocFXMetadataSettings toolSettings, bool? preserveRawInlineComments) : DocFXMetadataSettings
- SetPrintHelpMessage(this DocFXMetadataSettings toolSettings, bool? printHelpMessage) : DocFXMetadataSettings
- SetProjects(this DocFXMetadataSettings toolSettings, string[] projects) : DocFXMetadataSettings
- SetProjects(this DocFXMetadataSettings toolSettings, IEnumerable<string> projects) : DocFXMetadataSettings
- SetRepoRoot(this DocFXMetadataSettings toolSettings, string repoRoot) : DocFXMetadataSettings
- SetShouldSkipMarkup(this DocFXMetadataSettings toolSettings, bool? shouldSkipMarkup) : DocFXMetadataSettings
- SetWarningsAsErrors(this DocFXMetadataSettings toolSettings, bool? warningsAsErrors) : DocFXMetadataSettings
- ToggleDisableDefaultFilter(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ToggleDisableGitFeatures(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ToggleForceRebuild(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- TogglePreserveRawInlineComments(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- TogglePrintHelpMessage(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ToggleShouldSkipMarkup(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings
- ToggleWarningsAsErrors(this DocFXMetadataSettings toolSettings) : DocFXMetadataSettings

### Nuke.Common.Tools.DocFX.DocFXPdfSettings

- .ctor()
- get_BasePath() : string
- get_ChangesFile() : string
- get_CleanupCacheHistory() : bool?
- get_ConfigFile() : string
- get_Content() : IReadOnlyList<string>
- get_CorrelationId() : string
- get_CssFilePath() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableGitFeatures() : bool?
- get_DryRun() : bool?
- get_EnableDebugMode() : bool?
- get_ExcludedTocs() : IReadOnlyList<string>
- get_ExportRawModel() : bool?
- get_ExportViewModel() : bool?
- get_FALName() : string
- get_FileMetadataFilePath() : string
- get_FileMetadataFilePaths() : IReadOnlyList<string>
- get_ForcePostProcess() : bool?
- get_ForceRebuild() : bool?
- get_GeneratesAppendices() : bool?
- get_GeneratesExternalLink() : bool?
- get_GlobalMetadata() : string
- get_GlobalMetadataFilePath() : string
- get_GlobalMetadataFilePaths() : IReadOnlyList<string>
- get_Host() : string
- get_IntermediateFolder() : string
- get_KeepFileLink() : bool?
- get_KeepRawFiles() : bool?
- get_LoadErrorHandling() : string
- get_Locale() : string
- get_LogFilePath() : string
- get_LogLevel() : DocFXLogLevel
- get_LruSize() : int?
- get_MarkdownEngineName() : string
- get_MarkdownEngineProperties() : string
- get_MaxParallelism() : int?
- get_Name() : string
- get_NoInputStreamArgs() : bool?
- get_NoLangKeyword() : bool?
- get_OutputFolder() : string
- get_OutputFolderForDebugFiles() : string
- get_Overwrite() : IReadOnlyList<string>
- get_PdfHost() : string
- get_Port() : int?
- get_PostProcessors() : IReadOnlyList<string>
- get_PrintHelpMessage() : bool?
- get_RawModelOutputFolder() : string
- get_RawOutputFolder() : string
- get_RepoRoot() : string
- get_Resource() : IReadOnlyList<string>
- get_SchemaLicense() : string
- get_Serve() : bool?
- get_Templates() : IReadOnlyList<string>
- get_Themes() : IReadOnlyList<string>
- get_ToolPath() : string
- get_ViewModelOutputFolder() : string
- get_WarningsAsErrors() : bool?
- get_XRefMaps() : IReadOnlyList<string>
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXPdfSettingsExtensions

- AddContent(this DocFXPdfSettings toolSettings, string[] content) : DocFXPdfSettings
- AddContent(this DocFXPdfSettings toolSettings, IEnumerable<string> content) : DocFXPdfSettings
- AddExcludedTocs(this DocFXPdfSettings toolSettings, string[] excludedTocs) : DocFXPdfSettings
- AddExcludedTocs(this DocFXPdfSettings toolSettings, IEnumerable<string> excludedTocs) : DocFXPdfSettings
- AddFileMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] fileMetadataFilePaths) : DocFXPdfSettings
- AddFileMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXPdfSettings
- AddGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] globalMetadataFilePaths) : DocFXPdfSettings
- AddGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXPdfSettings
- AddOverwrite(this DocFXPdfSettings toolSettings, string[] overwrite) : DocFXPdfSettings
- AddOverwrite(this DocFXPdfSettings toolSettings, IEnumerable<string> overwrite) : DocFXPdfSettings
- AddPostProcessors(this DocFXPdfSettings toolSettings, string[] postProcessors) : DocFXPdfSettings
- AddPostProcessors(this DocFXPdfSettings toolSettings, IEnumerable<string> postProcessors) : DocFXPdfSettings
- AddResource(this DocFXPdfSettings toolSettings, string[] resource) : DocFXPdfSettings
- AddResource(this DocFXPdfSettings toolSettings, IEnumerable<string> resource) : DocFXPdfSettings
- AddTemplates(this DocFXPdfSettings toolSettings, string[] templates) : DocFXPdfSettings
- AddTemplates(this DocFXPdfSettings toolSettings, IEnumerable<string> templates) : DocFXPdfSettings
- AddThemes(this DocFXPdfSettings toolSettings, string[] themes) : DocFXPdfSettings
- AddThemes(this DocFXPdfSettings toolSettings, IEnumerable<string> themes) : DocFXPdfSettings
- AddXRefMaps(this DocFXPdfSettings toolSettings, string[] xrefMaps) : DocFXPdfSettings
- AddXRefMaps(this DocFXPdfSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXPdfSettings
- ClearContent(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearExcludedTocs(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearFileMetadataFilePaths(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearOverwrite(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearPostProcessors(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearResource(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearTemplates(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearThemes(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ClearXRefMaps(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableCleanupCacheHistory(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableDisableGitFeatures(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableDryRun(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableEnableDebugMode(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableExportRawModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableExportViewModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableForcePostProcess(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableForceRebuild(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableGeneratesAppendices(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableGeneratesExternalLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableKeepFileLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableKeepRawFiles(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableNoInputStreamArgs(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableNoLangKeyword(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisablePrintHelpMessage(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableServe(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- DisableWarningsAsErrors(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableCleanupCacheHistory(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableDisableGitFeatures(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableDryRun(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableEnableDebugMode(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableExportRawModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableExportViewModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableForcePostProcess(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableForceRebuild(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableGeneratesAppendices(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableGeneratesExternalLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableKeepFileLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableKeepRawFiles(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableNoInputStreamArgs(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableNoLangKeyword(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnablePrintHelpMessage(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableServe(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- EnableWarningsAsErrors(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- RemoveContent(this DocFXPdfSettings toolSettings, string[] content) : DocFXPdfSettings
- RemoveContent(this DocFXPdfSettings toolSettings, IEnumerable<string> content) : DocFXPdfSettings
- RemoveExcludedTocs(this DocFXPdfSettings toolSettings, string[] excludedTocs) : DocFXPdfSettings
- RemoveExcludedTocs(this DocFXPdfSettings toolSettings, IEnumerable<string> excludedTocs) : DocFXPdfSettings
- RemoveFileMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] fileMetadataFilePaths) : DocFXPdfSettings
- RemoveFileMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXPdfSettings
- RemoveGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] globalMetadataFilePaths) : DocFXPdfSettings
- RemoveGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXPdfSettings
- RemoveOverwrite(this DocFXPdfSettings toolSettings, string[] overwrite) : DocFXPdfSettings
- RemoveOverwrite(this DocFXPdfSettings toolSettings, IEnumerable<string> overwrite) : DocFXPdfSettings
- RemovePostProcessors(this DocFXPdfSettings toolSettings, string[] postProcessors) : DocFXPdfSettings
- RemovePostProcessors(this DocFXPdfSettings toolSettings, IEnumerable<string> postProcessors) : DocFXPdfSettings
- RemoveResource(this DocFXPdfSettings toolSettings, string[] resource) : DocFXPdfSettings
- RemoveResource(this DocFXPdfSettings toolSettings, IEnumerable<string> resource) : DocFXPdfSettings
- RemoveTemplates(this DocFXPdfSettings toolSettings, string[] templates) : DocFXPdfSettings
- RemoveTemplates(this DocFXPdfSettings toolSettings, IEnumerable<string> templates) : DocFXPdfSettings
- RemoveThemes(this DocFXPdfSettings toolSettings, string[] themes) : DocFXPdfSettings
- RemoveThemes(this DocFXPdfSettings toolSettings, IEnumerable<string> themes) : DocFXPdfSettings
- RemoveXRefMaps(this DocFXPdfSettings toolSettings, string[] xrefMaps) : DocFXPdfSettings
- RemoveXRefMaps(this DocFXPdfSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXPdfSettings
- ResetBasePath(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetChangesFile(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetCleanupCacheHistory(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetConfigFile(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetCorrelationId(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetCssFilePath(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetDisableGitFeatures(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetDryRun(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetEnableDebugMode(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetExportRawModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetExportViewModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetFALName(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetFileMetadataFilePath(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetForcePostProcess(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetForceRebuild(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetGeneratesAppendices(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetGeneratesExternalLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetGlobalMetadata(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetGlobalMetadataFilePath(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetHost(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetIntermediateFolder(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetKeepFileLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetKeepRawFiles(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetLoadErrorHandling(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetLocale(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetLogFilePath(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetLogLevel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetLruSize(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetMarkdownEngineName(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetMarkdownEngineProperties(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetMaxParallelism(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetName(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetNoInputStreamArgs(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetNoLangKeyword(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetOutputFolder(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetOutputFolderForDebugFiles(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetPdfHost(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetPort(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetPrintHelpMessage(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetRawModelOutputFolder(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetRawOutputFolder(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetRepoRoot(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetSchemaLicense(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetServe(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetViewModelOutputFolder(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ResetWarningsAsErrors(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- SetBasePath(this DocFXPdfSettings toolSettings, string basePath) : DocFXPdfSettings
- SetChangesFile(this DocFXPdfSettings toolSettings, string changesFile) : DocFXPdfSettings
- SetCleanupCacheHistory(this DocFXPdfSettings toolSettings, bool? cleanupCacheHistory) : DocFXPdfSettings
- SetConfigFile(this DocFXPdfSettings toolSettings, string configFile) : DocFXPdfSettings
- SetContent(this DocFXPdfSettings toolSettings, string[] content) : DocFXPdfSettings
- SetContent(this DocFXPdfSettings toolSettings, IEnumerable<string> content) : DocFXPdfSettings
- SetCorrelationId(this DocFXPdfSettings toolSettings, string correlationId) : DocFXPdfSettings
- SetCssFilePath(this DocFXPdfSettings toolSettings, string cssFilePath) : DocFXPdfSettings
- SetDisableGitFeatures(this DocFXPdfSettings toolSettings, bool? disableGitFeatures) : DocFXPdfSettings
- SetDryRun(this DocFXPdfSettings toolSettings, bool? dryRun) : DocFXPdfSettings
- SetEnableDebugMode(this DocFXPdfSettings toolSettings, bool? enableDebugMode) : DocFXPdfSettings
- SetExcludedTocs(this DocFXPdfSettings toolSettings, string[] excludedTocs) : DocFXPdfSettings
- SetExcludedTocs(this DocFXPdfSettings toolSettings, IEnumerable<string> excludedTocs) : DocFXPdfSettings
- SetExportRawModel(this DocFXPdfSettings toolSettings, bool? exportRawModel) : DocFXPdfSettings
- SetExportViewModel(this DocFXPdfSettings toolSettings, bool? exportViewModel) : DocFXPdfSettings
- SetFALName(this DocFXPdfSettings toolSettings, string falname) : DocFXPdfSettings
- SetFileMetadataFilePath(this DocFXPdfSettings toolSettings, string fileMetadataFilePath) : DocFXPdfSettings
- SetFileMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] fileMetadataFilePaths) : DocFXPdfSettings
- SetFileMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> fileMetadataFilePaths) : DocFXPdfSettings
- SetForcePostProcess(this DocFXPdfSettings toolSettings, bool? forcePostProcess) : DocFXPdfSettings
- SetForceRebuild(this DocFXPdfSettings toolSettings, bool? forceRebuild) : DocFXPdfSettings
- SetGeneratesAppendices(this DocFXPdfSettings toolSettings, bool? generatesAppendices) : DocFXPdfSettings
- SetGeneratesExternalLink(this DocFXPdfSettings toolSettings, bool? generatesExternalLink) : DocFXPdfSettings
- SetGlobalMetadata(this DocFXPdfSettings toolSettings, string globalMetadata) : DocFXPdfSettings
- SetGlobalMetadataFilePath(this DocFXPdfSettings toolSettings, string globalMetadataFilePath) : DocFXPdfSettings
- SetGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, string[] globalMetadataFilePaths) : DocFXPdfSettings
- SetGlobalMetadataFilePaths(this DocFXPdfSettings toolSettings, IEnumerable<string> globalMetadataFilePaths) : DocFXPdfSettings
- SetHost(this DocFXPdfSettings toolSettings, string host) : DocFXPdfSettings
- SetIntermediateFolder(this DocFXPdfSettings toolSettings, string intermediateFolder) : DocFXPdfSettings
- SetKeepFileLink(this DocFXPdfSettings toolSettings, bool? keepFileLink) : DocFXPdfSettings
- SetKeepRawFiles(this DocFXPdfSettings toolSettings, bool? keepRawFiles) : DocFXPdfSettings
- SetLoadErrorHandling(this DocFXPdfSettings toolSettings, string loadErrorHandling) : DocFXPdfSettings
- SetLocale(this DocFXPdfSettings toolSettings, string locale) : DocFXPdfSettings
- SetLogFilePath(this DocFXPdfSettings toolSettings, string logFilePath) : DocFXPdfSettings
- SetLogLevel(this DocFXPdfSettings toolSettings, DocFXLogLevel logLevel) : DocFXPdfSettings
- SetLruSize(this DocFXPdfSettings toolSettings, int? lruSize) : DocFXPdfSettings
- SetMarkdownEngineName(this DocFXPdfSettings toolSettings, string markdownEngineName) : DocFXPdfSettings
- SetMarkdownEngineProperties(this DocFXPdfSettings toolSettings, string markdownEngineProperties) : DocFXPdfSettings
- SetMaxParallelism(this DocFXPdfSettings toolSettings, int? maxParallelism) : DocFXPdfSettings
- SetName(this DocFXPdfSettings toolSettings, string name) : DocFXPdfSettings
- SetNoInputStreamArgs(this DocFXPdfSettings toolSettings, bool? noInputStreamArgs) : DocFXPdfSettings
- SetNoLangKeyword(this DocFXPdfSettings toolSettings, bool? noLangKeyword) : DocFXPdfSettings
- SetOutputFolder(this DocFXPdfSettings toolSettings, string outputFolder) : DocFXPdfSettings
- SetOutputFolderForDebugFiles(this DocFXPdfSettings toolSettings, string outputFolderForDebugFiles) : DocFXPdfSettings
- SetOverwrite(this DocFXPdfSettings toolSettings, string[] overwrite) : DocFXPdfSettings
- SetOverwrite(this DocFXPdfSettings toolSettings, IEnumerable<string> overwrite) : DocFXPdfSettings
- SetPdfHost(this DocFXPdfSettings toolSettings, string pdfHost) : DocFXPdfSettings
- SetPort(this DocFXPdfSettings toolSettings, int? port) : DocFXPdfSettings
- SetPostProcessors(this DocFXPdfSettings toolSettings, string[] postProcessors) : DocFXPdfSettings
- SetPostProcessors(this DocFXPdfSettings toolSettings, IEnumerable<string> postProcessors) : DocFXPdfSettings
- SetPrintHelpMessage(this DocFXPdfSettings toolSettings, bool? printHelpMessage) : DocFXPdfSettings
- SetRawModelOutputFolder(this DocFXPdfSettings toolSettings, string rawModelOutputFolder) : DocFXPdfSettings
- SetRawOutputFolder(this DocFXPdfSettings toolSettings, string rawOutputFolder) : DocFXPdfSettings
- SetRepoRoot(this DocFXPdfSettings toolSettings, string repoRoot) : DocFXPdfSettings
- SetResource(this DocFXPdfSettings toolSettings, string[] resource) : DocFXPdfSettings
- SetResource(this DocFXPdfSettings toolSettings, IEnumerable<string> resource) : DocFXPdfSettings
- SetSchemaLicense(this DocFXPdfSettings toolSettings, string schemaLicense) : DocFXPdfSettings
- SetServe(this DocFXPdfSettings toolSettings, bool? serve) : DocFXPdfSettings
- SetTemplates(this DocFXPdfSettings toolSettings, string[] templates) : DocFXPdfSettings
- SetTemplates(this DocFXPdfSettings toolSettings, IEnumerable<string> templates) : DocFXPdfSettings
- SetThemes(this DocFXPdfSettings toolSettings, string[] themes) : DocFXPdfSettings
- SetThemes(this DocFXPdfSettings toolSettings, IEnumerable<string> themes) : DocFXPdfSettings
- SetViewModelOutputFolder(this DocFXPdfSettings toolSettings, string viewModelOutputFolder) : DocFXPdfSettings
- SetWarningsAsErrors(this DocFXPdfSettings toolSettings, bool? warningsAsErrors) : DocFXPdfSettings
- SetXRefMaps(this DocFXPdfSettings toolSettings, string[] xrefMaps) : DocFXPdfSettings
- SetXRefMaps(this DocFXPdfSettings toolSettings, IEnumerable<string> xrefMaps) : DocFXPdfSettings
- ToggleCleanupCacheHistory(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleDisableGitFeatures(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleDryRun(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleEnableDebugMode(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleExportRawModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleExportViewModel(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleForcePostProcess(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleForceRebuild(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleGeneratesAppendices(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleGeneratesExternalLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleKeepFileLink(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleKeepRawFiles(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleNoInputStreamArgs(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleNoLangKeyword(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- TogglePrintHelpMessage(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleServe(this DocFXPdfSettings toolSettings) : DocFXPdfSettings
- ToggleWarningsAsErrors(this DocFXPdfSettings toolSettings) : DocFXPdfSettings

### Nuke.Common.Tools.DocFX.DocFXServeSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Folder() : string
- get_Host() : string
- get_Port() : int?
- get_PrintHelpMessage() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXServeSettingsExtensions

- DisablePrintHelpMessage(this DocFXServeSettings toolSettings) : DocFXServeSettings
- EnablePrintHelpMessage(this DocFXServeSettings toolSettings) : DocFXServeSettings
- ResetFolder(this DocFXServeSettings toolSettings) : DocFXServeSettings
- ResetHost(this DocFXServeSettings toolSettings) : DocFXServeSettings
- ResetPort(this DocFXServeSettings toolSettings) : DocFXServeSettings
- ResetPrintHelpMessage(this DocFXServeSettings toolSettings) : DocFXServeSettings
- SetFolder(this DocFXServeSettings toolSettings, string folder) : DocFXServeSettings
- SetHost(this DocFXServeSettings toolSettings, string host) : DocFXServeSettings
- SetPort(this DocFXServeSettings toolSettings, int? port) : DocFXServeSettings
- SetPrintHelpMessage(this DocFXServeSettings toolSettings, bool? printHelpMessage) : DocFXServeSettings
- TogglePrintHelpMessage(this DocFXServeSettings toolSettings) : DocFXServeSettings

### Nuke.Common.Tools.DocFX.DocFXTasks

- get_DocFXLogger() : Action<OutputType, string>
- get_DocFXPath() : string
- set_DocFXLogger(Action<OutputType, string> value) : void
- DocFX(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- DocFXBuild(DocFXBuildSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXBuild(Configure<DocFXBuildSettings> configurator) : IReadOnlyCollection<Output>
- DocFXBuild(CombinatorialConfigure<DocFXBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXBuildSettings, Output IReadOnlyCollection<Output>)>
- DocFXDependency(DocFXDependencySettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXDependency(Configure<DocFXDependencySettings> configurator) : IReadOnlyCollection<Output>
- DocFXDependency(CombinatorialConfigure<DocFXDependencySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXDependencySettings, Output IReadOnlyCollection<Output>)>
- DocFXDownload(DocFXDownloadSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXDownload(Configure<DocFXDownloadSettings> configurator) : IReadOnlyCollection<Output>
- DocFXDownload(CombinatorialConfigure<DocFXDownloadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXDownloadSettings, Output IReadOnlyCollection<Output>)>
- DocFXHelp(DocFXHelpSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXHelp(Configure<DocFXHelpSettings> configurator) : IReadOnlyCollection<Output>
- DocFXHelp(CombinatorialConfigure<DocFXHelpSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXHelpSettings, Output IReadOnlyCollection<Output>)>
- DocFXInit(DocFXInitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXInit(Configure<DocFXInitSettings> configurator) : IReadOnlyCollection<Output>
- DocFXInit(CombinatorialConfigure<DocFXInitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXInitSettings, Output IReadOnlyCollection<Output>)>
- DocFXMerge(DocFXMergeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXMerge(Configure<DocFXMergeSettings> configurator) : IReadOnlyCollection<Output>
- DocFXMerge(CombinatorialConfigure<DocFXMergeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXMergeSettings, Output IReadOnlyCollection<Output>)>
- DocFXMetadata(DocFXMetadataSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXMetadata(Configure<DocFXMetadataSettings> configurator) : IReadOnlyCollection<Output>
- DocFXMetadata(CombinatorialConfigure<DocFXMetadataSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXMetadataSettings, Output IReadOnlyCollection<Output>)>
- DocFXPdf(DocFXPdfSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXPdf(Configure<DocFXPdfSettings> configurator) : IReadOnlyCollection<Output>
- DocFXPdf(CombinatorialConfigure<DocFXPdfSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXPdfSettings, Output IReadOnlyCollection<Output>)>
- DocFXServe(DocFXServeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXServe(Configure<DocFXServeSettings> configurator) : IReadOnlyCollection<Output>
- DocFXServe(CombinatorialConfigure<DocFXServeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXServeSettings, Output IReadOnlyCollection<Output>)>
- DocFXTemplate(DocFXTemplateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DocFXTemplate(Configure<DocFXTemplateSettings> configurator) : IReadOnlyCollection<Output>
- DocFXTemplate(CombinatorialConfigure<DocFXTemplateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DocFXTemplateSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.DocFX.DocFXTemplateCommand

- Export : DocFXTemplateCommand
- List : DocFXTemplateCommand
- .ctor()
- op_Explicit(string value) : DocFXTemplateCommand

### Nuke.Common.Tools.DocFX.DocFXTemplateSettings

- .ctor()
- get_All() : bool?
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_OutputFolder() : string
- get_PrintHelpMessage() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DocFX.DocFXTemplateSettingsExtensions

- DisableAll(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- DisablePrintHelpMessage(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- EnableAll(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- EnablePrintHelpMessage(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- ResetAll(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- ResetCommand(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- ResetOutputFolder(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- ResetPrintHelpMessage(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- SetAll(this DocFXTemplateSettings toolSettings, bool? all) : DocFXTemplateSettings
- SetCommand(this DocFXTemplateSettings toolSettings, string command) : DocFXTemplateSettings
- SetOutputFolder(this DocFXTemplateSettings toolSettings, string outputFolder) : DocFXTemplateSettings
- SetPrintHelpMessage(this DocFXTemplateSettings toolSettings, bool? printHelpMessage) : DocFXTemplateSettings
- ToggleAll(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings
- TogglePrintHelpMessage(this DocFXTemplateSettings toolSettings) : DocFXTemplateSettings

### Nuke.Common.Tools.Docker.Availability

- active : Availability
- drain : Availability
- pause : Availability
- .ctor()
- op_Explicit(string value) : Availability

### Nuke.Common.Tools.Docker.CliSettings

- .ctor()
- get_Config() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Debug() : bool?
- get_LogLevel() : LogLevel
- get_TLS() : bool?
- get_TLSCaCert() : string
- get_TLSCert() : string
- get_TLSKey() : string
- get_TLSVerify() : bool?
- ConfigureArguments(Arguments arguments) : Arguments
- CreateArguments() : Arguments

### Nuke.Common.Tools.Docker.DockerAttachSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DetachKeys() : string
- get_NoStdin() : bool?
- get_SigProxy() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerAttachSettingsExtensions

- DisableNoStdin(this DockerAttachSettings toolSettings) : DockerAttachSettings
- DisableSigProxy(this DockerAttachSettings toolSettings) : DockerAttachSettings
- EnableNoStdin(this DockerAttachSettings toolSettings) : DockerAttachSettings
- EnableSigProxy(this DockerAttachSettings toolSettings) : DockerAttachSettings
- ResetContainer(this DockerAttachSettings toolSettings) : DockerAttachSettings
- ResetDetachKeys(this DockerAttachSettings toolSettings) : DockerAttachSettings
- ResetNoStdin(this DockerAttachSettings toolSettings) : DockerAttachSettings
- ResetSigProxy(this DockerAttachSettings toolSettings) : DockerAttachSettings
- SetContainer(this DockerAttachSettings toolSettings, string container) : DockerAttachSettings
- SetDetachKeys(this DockerAttachSettings toolSettings, string detachKeys) : DockerAttachSettings
- SetNoStdin(this DockerAttachSettings toolSettings, bool? noStdin) : DockerAttachSettings
- SetSigProxy(this DockerAttachSettings toolSettings, bool? sigProxy) : DockerAttachSettings
- ToggleNoStdin(this DockerAttachSettings toolSettings) : DockerAttachSettings
- ToggleSigProxy(this DockerAttachSettings toolSettings) : DockerAttachSettings

### Nuke.Common.Tools.Docker.DockerBuilderBuildSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_BuildArg() : IReadOnlyList<string>
- get_CacheFrom() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Compress() : bool?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_File() : string
- get_ForceRm() : bool?
- get_Iidfile() : string
- get_Isolation() : string
- get_Label() : IReadOnlyList<string>
- get_Memory() : long?
- get_MemorySwap() : long?
- get_Network() : string
- get_NoCache() : bool?
- get_Output() : string
- get_Path() : string
- get_Platform() : string
- get_Progress() : string
- get_Pull() : bool?
- get_Quiet() : bool?
- get_Rm() : bool?
- get_Secret() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_Squash() : bool?
- get_Ssh() : string
- get_Stream() : bool?
- get_Tag() : IReadOnlyList<string>
- get_Target() : string
- get_ToolPath() : string
- get_Ulimit() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerBuilderBuildSettingsExtensions

- AddAddHost(this DockerBuilderBuildSettings toolSettings, string[] addHost) : DockerBuilderBuildSettings
- AddAddHost(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuilderBuildSettings
- AddBuildArg(this DockerBuilderBuildSettings toolSettings, string[] buildArg) : DockerBuilderBuildSettings
- AddBuildArg(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuilderBuildSettings
- AddCacheFrom(this DockerBuilderBuildSettings toolSettings, string[] cacheFrom) : DockerBuilderBuildSettings
- AddCacheFrom(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuilderBuildSettings
- AddLabel(this DockerBuilderBuildSettings toolSettings, string[] label) : DockerBuilderBuildSettings
- AddLabel(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> label) : DockerBuilderBuildSettings
- AddSecurityOpt(this DockerBuilderBuildSettings toolSettings, string[] securityOpt) : DockerBuilderBuildSettings
- AddSecurityOpt(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuilderBuildSettings
- AddTag(this DockerBuilderBuildSettings toolSettings, string[] tag) : DockerBuilderBuildSettings
- AddTag(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuilderBuildSettings
- ClearAddHost(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ClearBuildArg(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ClearCacheFrom(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ClearLabel(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ClearSecurityOpt(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ClearTag(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableCompress(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableDisableContentTrust(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableForceRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableNoCache(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisablePull(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableQuiet(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableSquash(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- DisableStream(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableCompress(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableDisableContentTrust(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableForceRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableNoCache(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnablePull(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableQuiet(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableSquash(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- EnableStream(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- RemoveAddHost(this DockerBuilderBuildSettings toolSettings, string[] addHost) : DockerBuilderBuildSettings
- RemoveAddHost(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuilderBuildSettings
- RemoveBuildArg(this DockerBuilderBuildSettings toolSettings, string[] buildArg) : DockerBuilderBuildSettings
- RemoveBuildArg(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuilderBuildSettings
- RemoveCacheFrom(this DockerBuilderBuildSettings toolSettings, string[] cacheFrom) : DockerBuilderBuildSettings
- RemoveCacheFrom(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuilderBuildSettings
- RemoveLabel(this DockerBuilderBuildSettings toolSettings, string[] label) : DockerBuilderBuildSettings
- RemoveLabel(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> label) : DockerBuilderBuildSettings
- RemoveSecurityOpt(this DockerBuilderBuildSettings toolSettings, string[] securityOpt) : DockerBuilderBuildSettings
- RemoveSecurityOpt(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuilderBuildSettings
- RemoveTag(this DockerBuilderBuildSettings toolSettings, string[] tag) : DockerBuilderBuildSettings
- RemoveTag(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuilderBuildSettings
- ResetCgroupParent(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCompress(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCpuPeriod(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCpuQuota(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCpusetCpus(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCpusetMems(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetCpuShares(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetDisableContentTrust(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetFile(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetForceRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetIidfile(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetIsolation(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetMemory(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetMemorySwap(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetNetwork(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetNoCache(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetOutput(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetPath(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetPlatform(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetProgress(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetPull(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetQuiet(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetSecret(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetShmSize(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetSquash(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetSsh(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetStream(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetTarget(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ResetUlimit(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- SetAddHost(this DockerBuilderBuildSettings toolSettings, string[] addHost) : DockerBuilderBuildSettings
- SetAddHost(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuilderBuildSettings
- SetBuildArg(this DockerBuilderBuildSettings toolSettings, string[] buildArg) : DockerBuilderBuildSettings
- SetBuildArg(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuilderBuildSettings
- SetCacheFrom(this DockerBuilderBuildSettings toolSettings, string[] cacheFrom) : DockerBuilderBuildSettings
- SetCacheFrom(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuilderBuildSettings
- SetCgroupParent(this DockerBuilderBuildSettings toolSettings, string cgroupParent) : DockerBuilderBuildSettings
- SetCompress(this DockerBuilderBuildSettings toolSettings, bool? compress) : DockerBuilderBuildSettings
- SetCpuPeriod(this DockerBuilderBuildSettings toolSettings, long? cpuPeriod) : DockerBuilderBuildSettings
- SetCpuQuota(this DockerBuilderBuildSettings toolSettings, long? cpuQuota) : DockerBuilderBuildSettings
- SetCpusetCpus(this DockerBuilderBuildSettings toolSettings, string cpusetCpus) : DockerBuilderBuildSettings
- SetCpusetMems(this DockerBuilderBuildSettings toolSettings, string cpusetMems) : DockerBuilderBuildSettings
- SetCpuShares(this DockerBuilderBuildSettings toolSettings, long? cpuShares) : DockerBuilderBuildSettings
- SetDisableContentTrust(this DockerBuilderBuildSettings toolSettings, bool? disableContentTrust) : DockerBuilderBuildSettings
- SetFile(this DockerBuilderBuildSettings toolSettings, string file) : DockerBuilderBuildSettings
- SetForceRm(this DockerBuilderBuildSettings toolSettings, bool? forceRm) : DockerBuilderBuildSettings
- SetIidfile(this DockerBuilderBuildSettings toolSettings, string iidfile) : DockerBuilderBuildSettings
- SetIsolation(this DockerBuilderBuildSettings toolSettings, string isolation) : DockerBuilderBuildSettings
- SetLabel(this DockerBuilderBuildSettings toolSettings, string[] label) : DockerBuilderBuildSettings
- SetLabel(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> label) : DockerBuilderBuildSettings
- SetMemory(this DockerBuilderBuildSettings toolSettings, long? memory) : DockerBuilderBuildSettings
- SetMemorySwap(this DockerBuilderBuildSettings toolSettings, long? memorySwap) : DockerBuilderBuildSettings
- SetNetwork(this DockerBuilderBuildSettings toolSettings, string network) : DockerBuilderBuildSettings
- SetNoCache(this DockerBuilderBuildSettings toolSettings, bool? noCache) : DockerBuilderBuildSettings
- SetOutput(this DockerBuilderBuildSettings toolSettings, string output) : DockerBuilderBuildSettings
- SetPath(this DockerBuilderBuildSettings toolSettings, string path) : DockerBuilderBuildSettings
- SetPlatform(this DockerBuilderBuildSettings toolSettings, string platform) : DockerBuilderBuildSettings
- SetProgress(this DockerBuilderBuildSettings toolSettings, string progress) : DockerBuilderBuildSettings
- SetPull(this DockerBuilderBuildSettings toolSettings, bool? pull) : DockerBuilderBuildSettings
- SetQuiet(this DockerBuilderBuildSettings toolSettings, bool? quiet) : DockerBuilderBuildSettings
- SetRm(this DockerBuilderBuildSettings toolSettings, bool? rm) : DockerBuilderBuildSettings
- SetSecret(this DockerBuilderBuildSettings toolSettings, string secret) : DockerBuilderBuildSettings
- SetSecurityOpt(this DockerBuilderBuildSettings toolSettings, string[] securityOpt) : DockerBuilderBuildSettings
- SetSecurityOpt(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuilderBuildSettings
- SetShmSize(this DockerBuilderBuildSettings toolSettings, long? shmSize) : DockerBuilderBuildSettings
- SetSquash(this DockerBuilderBuildSettings toolSettings, bool? squash) : DockerBuilderBuildSettings
- SetSsh(this DockerBuilderBuildSettings toolSettings, string ssh) : DockerBuilderBuildSettings
- SetStream(this DockerBuilderBuildSettings toolSettings, bool? stream) : DockerBuilderBuildSettings
- SetTag(this DockerBuilderBuildSettings toolSettings, string[] tag) : DockerBuilderBuildSettings
- SetTag(this DockerBuilderBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuilderBuildSettings
- SetTarget(this DockerBuilderBuildSettings toolSettings, string target) : DockerBuilderBuildSettings
- SetUlimit(this DockerBuilderBuildSettings toolSettings, string ulimit) : DockerBuilderBuildSettings
- ToggleCompress(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleDisableContentTrust(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleForceRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleNoCache(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- TogglePull(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleQuiet(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleRm(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleSquash(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings
- ToggleStream(this DockerBuilderBuildSettings toolSettings) : DockerBuilderBuildSettings

### Nuke.Common.Tools.Docker.DockerBuilderPruneSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerBuilderPruneSettingsExtensions


### Nuke.Common.Tools.Docker.DockerBuilderSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerBuilderSettingsExtensions


### Nuke.Common.Tools.Docker.DockerBuildSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_BuildArg() : IReadOnlyList<string>
- get_CacheFrom() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Compress() : bool?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_File() : string
- get_ForceRm() : bool?
- get_Iidfile() : string
- get_Isolation() : string
- get_Label() : IReadOnlyList<string>
- get_Memory() : long?
- get_MemorySwap() : long?
- get_Network() : string
- get_NoCache() : bool?
- get_Output() : string
- get_Path() : string
- get_Platform() : string
- get_Progress() : string
- get_Pull() : bool?
- get_Quiet() : bool?
- get_Rm() : bool?
- get_Secret() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_Squash() : bool?
- get_Ssh() : string
- get_Stream() : bool?
- get_Tag() : IReadOnlyList<string>
- get_Target() : string
- get_ToolPath() : string
- get_Ulimit() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerBuildSettingsExtensions

- AddAddHost(this DockerBuildSettings toolSettings, string[] addHost) : DockerBuildSettings
- AddAddHost(this DockerBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuildSettings
- AddBuildArg(this DockerBuildSettings toolSettings, string[] buildArg) : DockerBuildSettings
- AddBuildArg(this DockerBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuildSettings
- AddCacheFrom(this DockerBuildSettings toolSettings, string[] cacheFrom) : DockerBuildSettings
- AddCacheFrom(this DockerBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuildSettings
- AddLabel(this DockerBuildSettings toolSettings, string[] label) : DockerBuildSettings
- AddLabel(this DockerBuildSettings toolSettings, IEnumerable<string> label) : DockerBuildSettings
- AddSecurityOpt(this DockerBuildSettings toolSettings, string[] securityOpt) : DockerBuildSettings
- AddSecurityOpt(this DockerBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuildSettings
- AddTag(this DockerBuildSettings toolSettings, string[] tag) : DockerBuildSettings
- AddTag(this DockerBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuildSettings
- ClearAddHost(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ClearBuildArg(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ClearCacheFrom(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ClearLabel(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ClearSecurityOpt(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ClearTag(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableCompress(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableDisableContentTrust(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableForceRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableNoCache(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisablePull(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableQuiet(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableSquash(this DockerBuildSettings toolSettings) : DockerBuildSettings
- DisableStream(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableCompress(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableDisableContentTrust(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableForceRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableNoCache(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnablePull(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableQuiet(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableSquash(this DockerBuildSettings toolSettings) : DockerBuildSettings
- EnableStream(this DockerBuildSettings toolSettings) : DockerBuildSettings
- RemoveAddHost(this DockerBuildSettings toolSettings, string[] addHost) : DockerBuildSettings
- RemoveAddHost(this DockerBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuildSettings
- RemoveBuildArg(this DockerBuildSettings toolSettings, string[] buildArg) : DockerBuildSettings
- RemoveBuildArg(this DockerBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuildSettings
- RemoveCacheFrom(this DockerBuildSettings toolSettings, string[] cacheFrom) : DockerBuildSettings
- RemoveCacheFrom(this DockerBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuildSettings
- RemoveLabel(this DockerBuildSettings toolSettings, string[] label) : DockerBuildSettings
- RemoveLabel(this DockerBuildSettings toolSettings, IEnumerable<string> label) : DockerBuildSettings
- RemoveSecurityOpt(this DockerBuildSettings toolSettings, string[] securityOpt) : DockerBuildSettings
- RemoveSecurityOpt(this DockerBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuildSettings
- RemoveTag(this DockerBuildSettings toolSettings, string[] tag) : DockerBuildSettings
- RemoveTag(this DockerBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuildSettings
- ResetCgroupParent(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCompress(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCpuPeriod(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCpuQuota(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCpusetCpus(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCpusetMems(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetCpuShares(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetDisableContentTrust(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetFile(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetForceRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetIidfile(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetIsolation(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetMemory(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetMemorySwap(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetNetwork(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetNoCache(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetOutput(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetPath(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetPlatform(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetProgress(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetPull(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetQuiet(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetSecret(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetShmSize(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetSquash(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetSsh(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetStream(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetTarget(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ResetUlimit(this DockerBuildSettings toolSettings) : DockerBuildSettings
- SetAddHost(this DockerBuildSettings toolSettings, string[] addHost) : DockerBuildSettings
- SetAddHost(this DockerBuildSettings toolSettings, IEnumerable<string> addHost) : DockerBuildSettings
- SetBuildArg(this DockerBuildSettings toolSettings, string[] buildArg) : DockerBuildSettings
- SetBuildArg(this DockerBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerBuildSettings
- SetCacheFrom(this DockerBuildSettings toolSettings, string[] cacheFrom) : DockerBuildSettings
- SetCacheFrom(this DockerBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerBuildSettings
- SetCgroupParent(this DockerBuildSettings toolSettings, string cgroupParent) : DockerBuildSettings
- SetCompress(this DockerBuildSettings toolSettings, bool? compress) : DockerBuildSettings
- SetCpuPeriod(this DockerBuildSettings toolSettings, long? cpuPeriod) : DockerBuildSettings
- SetCpuQuota(this DockerBuildSettings toolSettings, long? cpuQuota) : DockerBuildSettings
- SetCpusetCpus(this DockerBuildSettings toolSettings, string cpusetCpus) : DockerBuildSettings
- SetCpusetMems(this DockerBuildSettings toolSettings, string cpusetMems) : DockerBuildSettings
- SetCpuShares(this DockerBuildSettings toolSettings, long? cpuShares) : DockerBuildSettings
- SetDisableContentTrust(this DockerBuildSettings toolSettings, bool? disableContentTrust) : DockerBuildSettings
- SetFile(this DockerBuildSettings toolSettings, string file) : DockerBuildSettings
- SetForceRm(this DockerBuildSettings toolSettings, bool? forceRm) : DockerBuildSettings
- SetIidfile(this DockerBuildSettings toolSettings, string iidfile) : DockerBuildSettings
- SetIsolation(this DockerBuildSettings toolSettings, string isolation) : DockerBuildSettings
- SetLabel(this DockerBuildSettings toolSettings, string[] label) : DockerBuildSettings
- SetLabel(this DockerBuildSettings toolSettings, IEnumerable<string> label) : DockerBuildSettings
- SetMemory(this DockerBuildSettings toolSettings, long? memory) : DockerBuildSettings
- SetMemorySwap(this DockerBuildSettings toolSettings, long? memorySwap) : DockerBuildSettings
- SetNetwork(this DockerBuildSettings toolSettings, string network) : DockerBuildSettings
- SetNoCache(this DockerBuildSettings toolSettings, bool? noCache) : DockerBuildSettings
- SetOutput(this DockerBuildSettings toolSettings, string output) : DockerBuildSettings
- SetPath(this DockerBuildSettings toolSettings, string path) : DockerBuildSettings
- SetPlatform(this DockerBuildSettings toolSettings, string platform) : DockerBuildSettings
- SetProgress(this DockerBuildSettings toolSettings, string progress) : DockerBuildSettings
- SetPull(this DockerBuildSettings toolSettings, bool? pull) : DockerBuildSettings
- SetQuiet(this DockerBuildSettings toolSettings, bool? quiet) : DockerBuildSettings
- SetRm(this DockerBuildSettings toolSettings, bool? rm) : DockerBuildSettings
- SetSecret(this DockerBuildSettings toolSettings, string secret) : DockerBuildSettings
- SetSecurityOpt(this DockerBuildSettings toolSettings, string[] securityOpt) : DockerBuildSettings
- SetSecurityOpt(this DockerBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerBuildSettings
- SetShmSize(this DockerBuildSettings toolSettings, long? shmSize) : DockerBuildSettings
- SetSquash(this DockerBuildSettings toolSettings, bool? squash) : DockerBuildSettings
- SetSsh(this DockerBuildSettings toolSettings, string ssh) : DockerBuildSettings
- SetStream(this DockerBuildSettings toolSettings, bool? stream) : DockerBuildSettings
- SetTag(this DockerBuildSettings toolSettings, string[] tag) : DockerBuildSettings
- SetTag(this DockerBuildSettings toolSettings, IEnumerable<string> tag) : DockerBuildSettings
- SetTarget(this DockerBuildSettings toolSettings, string target) : DockerBuildSettings
- SetUlimit(this DockerBuildSettings toolSettings, string ulimit) : DockerBuildSettings
- ToggleCompress(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleDisableContentTrust(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleForceRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleNoCache(this DockerBuildSettings toolSettings) : DockerBuildSettings
- TogglePull(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleQuiet(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleRm(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleSquash(this DockerBuildSettings toolSettings) : DockerBuildSettings
- ToggleStream(this DockerBuildSettings toolSettings) : DockerBuildSettings

### Nuke.Common.Tools.Docker.DockerCheckpointCreateSettings

- .ctor()
- get_Checkpoint() : string
- get_CheckpointDir() : string
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_LeaveRunning() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCheckpointCreateSettingsExtensions

- DisableLeaveRunning(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- EnableLeaveRunning(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- ResetCheckpoint(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- ResetCheckpointDir(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- ResetContainer(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- ResetLeaveRunning(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings
- SetCheckpoint(this DockerCheckpointCreateSettings toolSettings, string checkpoint) : DockerCheckpointCreateSettings
- SetCheckpointDir(this DockerCheckpointCreateSettings toolSettings, string checkpointDir) : DockerCheckpointCreateSettings
- SetContainer(this DockerCheckpointCreateSettings toolSettings, string container) : DockerCheckpointCreateSettings
- SetLeaveRunning(this DockerCheckpointCreateSettings toolSettings, bool? leaveRunning) : DockerCheckpointCreateSettings
- ToggleLeaveRunning(this DockerCheckpointCreateSettings toolSettings) : DockerCheckpointCreateSettings

### Nuke.Common.Tools.Docker.DockerCheckpointLsSettings

- .ctor()
- get_CheckpointDir() : string
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCheckpointLsSettingsExtensions

- ResetCheckpointDir(this DockerCheckpointLsSettings toolSettings) : DockerCheckpointLsSettings
- ResetContainer(this DockerCheckpointLsSettings toolSettings) : DockerCheckpointLsSettings
- SetCheckpointDir(this DockerCheckpointLsSettings toolSettings, string checkpointDir) : DockerCheckpointLsSettings
- SetContainer(this DockerCheckpointLsSettings toolSettings, string container) : DockerCheckpointLsSettings

### Nuke.Common.Tools.Docker.DockerCheckpointRmSettings

- .ctor()
- get_Checkpoint() : string
- get_CheckpointDir() : string
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCheckpointRmSettingsExtensions

- ResetCheckpoint(this DockerCheckpointRmSettings toolSettings) : DockerCheckpointRmSettings
- ResetCheckpointDir(this DockerCheckpointRmSettings toolSettings) : DockerCheckpointRmSettings
- ResetContainer(this DockerCheckpointRmSettings toolSettings) : DockerCheckpointRmSettings
- SetCheckpoint(this DockerCheckpointRmSettings toolSettings, string checkpoint) : DockerCheckpointRmSettings
- SetCheckpointDir(this DockerCheckpointRmSettings toolSettings, string checkpointDir) : DockerCheckpointRmSettings
- SetContainer(this DockerCheckpointRmSettings toolSettings, string container) : DockerCheckpointRmSettings

### Nuke.Common.Tools.Docker.DockerCheckpointSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCheckpointSettingsExtensions


### Nuke.Common.Tools.Docker.DockerCommitSettings

- .ctor()
- get_Author() : string
- get_Change() : IReadOnlyList<string>
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Message() : string
- get_Pause() : bool?
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCommitSettingsExtensions

- AddChange(this DockerCommitSettings toolSettings, string[] change) : DockerCommitSettings
- AddChange(this DockerCommitSettings toolSettings, IEnumerable<string> change) : DockerCommitSettings
- ClearChange(this DockerCommitSettings toolSettings) : DockerCommitSettings
- DisablePause(this DockerCommitSettings toolSettings) : DockerCommitSettings
- EnablePause(this DockerCommitSettings toolSettings) : DockerCommitSettings
- RemoveChange(this DockerCommitSettings toolSettings, string[] change) : DockerCommitSettings
- RemoveChange(this DockerCommitSettings toolSettings, IEnumerable<string> change) : DockerCommitSettings
- ResetAuthor(this DockerCommitSettings toolSettings) : DockerCommitSettings
- ResetContainer(this DockerCommitSettings toolSettings) : DockerCommitSettings
- ResetMessage(this DockerCommitSettings toolSettings) : DockerCommitSettings
- ResetPause(this DockerCommitSettings toolSettings) : DockerCommitSettings
- ResetRepository(this DockerCommitSettings toolSettings) : DockerCommitSettings
- SetAuthor(this DockerCommitSettings toolSettings, string author) : DockerCommitSettings
- SetChange(this DockerCommitSettings toolSettings, string[] change) : DockerCommitSettings
- SetChange(this DockerCommitSettings toolSettings, IEnumerable<string> change) : DockerCommitSettings
- SetContainer(this DockerCommitSettings toolSettings, string container) : DockerCommitSettings
- SetMessage(this DockerCommitSettings toolSettings, string message) : DockerCommitSettings
- SetPause(this DockerCommitSettings toolSettings, bool? pause) : DockerCommitSettings
- SetRepository(this DockerCommitSettings toolSettings, string repository) : DockerCommitSettings
- TogglePause(this DockerCommitSettings toolSettings) : DockerCommitSettings

### Nuke.Common.Tools.Docker.DockerConfigCreateSettings

- .ctor()
- get_Config() : string
- get_CustomLogger() : Action<OutputType, string>
- get_File() : string
- get_Label() : IReadOnlyList<string>
- get_TemplateDriver() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerConfigCreateSettingsExtensions

- AddLabel(this DockerConfigCreateSettings toolSettings, string[] label) : DockerConfigCreateSettings
- AddLabel(this DockerConfigCreateSettings toolSettings, IEnumerable<string> label) : DockerConfigCreateSettings
- ClearLabel(this DockerConfigCreateSettings toolSettings) : DockerConfigCreateSettings
- RemoveLabel(this DockerConfigCreateSettings toolSettings, string[] label) : DockerConfigCreateSettings
- RemoveLabel(this DockerConfigCreateSettings toolSettings, IEnumerable<string> label) : DockerConfigCreateSettings
- ResetConfig(this DockerConfigCreateSettings toolSettings) : DockerConfigCreateSettings
- ResetFile(this DockerConfigCreateSettings toolSettings) : DockerConfigCreateSettings
- ResetTemplateDriver(this DockerConfigCreateSettings toolSettings) : DockerConfigCreateSettings
- SetConfig(this DockerConfigCreateSettings toolSettings, string config) : DockerConfigCreateSettings
- SetFile(this DockerConfigCreateSettings toolSettings, string file) : DockerConfigCreateSettings
- SetLabel(this DockerConfigCreateSettings toolSettings, string[] label) : DockerConfigCreateSettings
- SetLabel(this DockerConfigCreateSettings toolSettings, IEnumerable<string> label) : DockerConfigCreateSettings
- SetTemplateDriver(this DockerConfigCreateSettings toolSettings, string templateDriver) : DockerConfigCreateSettings

### Nuke.Common.Tools.Docker.DockerConfigInspectSettings

- .ctor()
- get_Configs() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Pretty() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerConfigInspectSettingsExtensions

- AddConfigs(this DockerConfigInspectSettings toolSettings, string[] configs) : DockerConfigInspectSettings
- AddConfigs(this DockerConfigInspectSettings toolSettings, IEnumerable<string> configs) : DockerConfigInspectSettings
- ClearConfigs(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings
- DisablePretty(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings
- EnablePretty(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings
- RemoveConfigs(this DockerConfigInspectSettings toolSettings, string[] configs) : DockerConfigInspectSettings
- RemoveConfigs(this DockerConfigInspectSettings toolSettings, IEnumerable<string> configs) : DockerConfigInspectSettings
- ResetFormat(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings
- ResetPretty(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings
- SetConfigs(this DockerConfigInspectSettings toolSettings, string[] configs) : DockerConfigInspectSettings
- SetConfigs(this DockerConfigInspectSettings toolSettings, IEnumerable<string> configs) : DockerConfigInspectSettings
- SetFormat(this DockerConfigInspectSettings toolSettings, string format) : DockerConfigInspectSettings
- SetPretty(this DockerConfigInspectSettings toolSettings, bool? pretty) : DockerConfigInspectSettings
- TogglePretty(this DockerConfigInspectSettings toolSettings) : DockerConfigInspectSettings

### Nuke.Common.Tools.Docker.DockerConfigLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerConfigLsSettingsExtensions

- DisableQuiet(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings
- EnableQuiet(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings
- ResetFilter(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings
- ResetFormat(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings
- ResetQuiet(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings
- SetFilter(this DockerConfigLsSettings toolSettings, string filter) : DockerConfigLsSettings
- SetFormat(this DockerConfigLsSettings toolSettings, string format) : DockerConfigLsSettings
- SetQuiet(this DockerConfigLsSettings toolSettings, bool? quiet) : DockerConfigLsSettings
- ToggleQuiet(this DockerConfigLsSettings toolSettings) : DockerConfigLsSettings

### Nuke.Common.Tools.Docker.DockerConfigRmSettings

- .ctor()
- get_Configs() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerConfigRmSettingsExtensions

- AddConfigs(this DockerConfigRmSettings toolSettings, string[] configs) : DockerConfigRmSettings
- AddConfigs(this DockerConfigRmSettings toolSettings, IEnumerable<string> configs) : DockerConfigRmSettings
- ClearConfigs(this DockerConfigRmSettings toolSettings) : DockerConfigRmSettings
- RemoveConfigs(this DockerConfigRmSettings toolSettings, string[] configs) : DockerConfigRmSettings
- RemoveConfigs(this DockerConfigRmSettings toolSettings, IEnumerable<string> configs) : DockerConfigRmSettings
- SetConfigs(this DockerConfigRmSettings toolSettings, string[] configs) : DockerConfigRmSettings
- SetConfigs(this DockerConfigRmSettings toolSettings, IEnumerable<string> configs) : DockerConfigRmSettings

### Nuke.Common.Tools.Docker.DockerConfigSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerConfigSettingsExtensions


### Nuke.Common.Tools.Docker.DockerContainerAttachSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DetachKeys() : string
- get_NoStdin() : bool?
- get_SigProxy() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerAttachSettingsExtensions

- DisableNoStdin(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- DisableSigProxy(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- EnableNoStdin(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- EnableSigProxy(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- ResetContainer(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- ResetDetachKeys(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- ResetNoStdin(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- ResetSigProxy(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- SetContainer(this DockerContainerAttachSettings toolSettings, string container) : DockerContainerAttachSettings
- SetDetachKeys(this DockerContainerAttachSettings toolSettings, string detachKeys) : DockerContainerAttachSettings
- SetNoStdin(this DockerContainerAttachSettings toolSettings, bool? noStdin) : DockerContainerAttachSettings
- SetSigProxy(this DockerContainerAttachSettings toolSettings, bool? sigProxy) : DockerContainerAttachSettings
- ToggleNoStdin(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings
- ToggleSigProxy(this DockerContainerAttachSettings toolSettings) : DockerContainerAttachSettings

### Nuke.Common.Tools.Docker.DockerContainerCommitSettings

- .ctor()
- get_Author() : string
- get_Change() : IReadOnlyList<string>
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Message() : string
- get_Pause() : bool?
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerCommitSettingsExtensions

- AddChange(this DockerContainerCommitSettings toolSettings, string[] change) : DockerContainerCommitSettings
- AddChange(this DockerContainerCommitSettings toolSettings, IEnumerable<string> change) : DockerContainerCommitSettings
- ClearChange(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- DisablePause(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- EnablePause(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- RemoveChange(this DockerContainerCommitSettings toolSettings, string[] change) : DockerContainerCommitSettings
- RemoveChange(this DockerContainerCommitSettings toolSettings, IEnumerable<string> change) : DockerContainerCommitSettings
- ResetAuthor(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- ResetContainer(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- ResetMessage(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- ResetPause(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- ResetRepository(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings
- SetAuthor(this DockerContainerCommitSettings toolSettings, string author) : DockerContainerCommitSettings
- SetChange(this DockerContainerCommitSettings toolSettings, string[] change) : DockerContainerCommitSettings
- SetChange(this DockerContainerCommitSettings toolSettings, IEnumerable<string> change) : DockerContainerCommitSettings
- SetContainer(this DockerContainerCommitSettings toolSettings, string container) : DockerContainerCommitSettings
- SetMessage(this DockerContainerCommitSettings toolSettings, string message) : DockerContainerCommitSettings
- SetPause(this DockerContainerCommitSettings toolSettings, bool? pause) : DockerContainerCommitSettings
- SetRepository(this DockerContainerCommitSettings toolSettings, string repository) : DockerContainerCommitSettings
- TogglePause(this DockerContainerCommitSettings toolSettings) : DockerContainerCommitSettings

### Nuke.Common.Tools.Docker.DockerContainerCreateSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_Args() : IReadOnlyList<string>
- get_Attach() : IReadOnlyList<string>
- get_BlkioWeight() : int?
- get_BlkioWeightDevice() : IReadOnlyList<string>
- get_CapAdd() : IReadOnlyList<string>
- get_CapDrop() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Cidfile() : string
- get_Command() : string
- get_CpuCount() : long?
- get_CpuPercent() : long?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_Device() : IReadOnlyList<string>
- get_DeviceCgroupRule() : IReadOnlyList<string>
- get_DeviceReadBps() : IReadOnlyList<string>
- get_DeviceReadIops() : IReadOnlyList<string>
- get_DeviceWriteBps() : IReadOnlyList<string>
- get_DeviceWriteIops() : IReadOnlyList<string>
- get_DisableContentTrust() : bool?
- get_Dns() : IReadOnlyList<string>
- get_DnsOpt() : IReadOnlyList<string>
- get_DnsOption() : IReadOnlyList<string>
- get_DnsSearch() : IReadOnlyList<string>
- get_Domainname() : string
- get_Entrypoint() : string
- get_Env() : IReadOnlyList<string>
- get_EnvFile() : IReadOnlyList<string>
- get_Expose() : IReadOnlyList<string>
- get_Gpus() : string
- get_GroupAdd() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_Help() : bool?
- get_Hostname() : string
- get_Image() : string
- get_Init() : bool?
- get_Interactive() : bool?
- get_IoMaxbandwidth() : long?
- get_IoMaxiops() : int?
- get_Ip() : string
- get_Ip6() : string
- get_Ipc() : string
- get_Isolation() : string
- get_KernelMemory() : long?
- get_Label() : IReadOnlyList<string>
- get_LabelFile() : IReadOnlyList<string>
- get_Link() : IReadOnlyList<string>
- get_LinkLocalIp() : IReadOnlyList<string>
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_MacAddress() : string
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_MemorySwappiness() : long?
- get_Mount() : string
- get_Name() : string
- get_Net() : string
- get_NetAlias() : IReadOnlyList<string>
- get_Network() : string
- get_NetworkAlias() : IReadOnlyList<string>
- get_NoHealthcheck() : bool?
- get_OomKillDisable() : bool?
- get_OomScoreAdj() : int?
- get_Pid() : string
- get_PidsLimit() : long?
- get_Platform() : string
- get_Privileged() : bool?
- get_Publish() : IReadOnlyList<string>
- get_PublishAll() : bool?
- get_ReadOnly() : bool?
- get_Restart() : string
- get_Rm() : bool?
- get_Runtime() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_StopSignal() : string
- get_StopTimeout() : int?
- get_StorageOpt() : IReadOnlyList<string>
- get_Sysctl() : IReadOnlyDictionary<string, string>
- get_Tmpfs() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_Ulimit() : string
- get_User() : string
- get_Userns() : string
- get_Uts() : string
- get_Volume() : IReadOnlyList<string>
- get_VolumeDriver() : string
- get_VolumesFrom() : IReadOnlyList<string>
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerCreateSettingsExtensions

- AddAddHost(this DockerContainerCreateSettings toolSettings, string[] addHost) : DockerContainerCreateSettings
- AddAddHost(this DockerContainerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerContainerCreateSettings
- AddArgs(this DockerContainerCreateSettings toolSettings, string[] args) : DockerContainerCreateSettings
- AddArgs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> args) : DockerContainerCreateSettings
- AddAttach(this DockerContainerCreateSettings toolSettings, string[] attach) : DockerContainerCreateSettings
- AddAttach(this DockerContainerCreateSettings toolSettings, IEnumerable<string> attach) : DockerContainerCreateSettings
- AddBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerContainerCreateSettings
- AddBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerCreateSettings
- AddCapAdd(this DockerContainerCreateSettings toolSettings, string[] capAdd) : DockerContainerCreateSettings
- AddCapAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerCreateSettings
- AddCapDrop(this DockerContainerCreateSettings toolSettings, string[] capDrop) : DockerContainerCreateSettings
- AddCapDrop(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerCreateSettings
- AddDevice(this DockerContainerCreateSettings toolSettings, string[] device) : DockerContainerCreateSettings
- AddDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> device) : DockerContainerCreateSettings
- AddDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerContainerCreateSettings
- AddDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerCreateSettings
- AddDeviceReadBps(this DockerContainerCreateSettings toolSettings, string[] deviceReadBps) : DockerContainerCreateSettings
- AddDeviceReadBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerCreateSettings
- AddDeviceReadIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerCreateSettings
- AddDeviceReadIops(this DockerContainerCreateSettings toolSettings, string[] deviceReadIops) : DockerContainerCreateSettings
- AddDeviceWriteBps(this DockerContainerCreateSettings toolSettings, string[] deviceWriteBps) : DockerContainerCreateSettings
- AddDeviceWriteBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerCreateSettings
- AddDeviceWriteIops(this DockerContainerCreateSettings toolSettings, string[] deviceWriteIops) : DockerContainerCreateSettings
- AddDeviceWriteIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerCreateSettings
- AddDns(this DockerContainerCreateSettings toolSettings, string[] dns) : DockerContainerCreateSettings
- AddDns(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dns) : DockerContainerCreateSettings
- AddDnsOpt(this DockerContainerCreateSettings toolSettings, string[] dnsOpt) : DockerContainerCreateSettings
- AddDnsOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerCreateSettings
- AddDnsOption(this DockerContainerCreateSettings toolSettings, string[] dnsOption) : DockerContainerCreateSettings
- AddDnsOption(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerCreateSettings
- AddDnsSearch(this DockerContainerCreateSettings toolSettings, string[] dnsSearch) : DockerContainerCreateSettings
- AddDnsSearch(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerCreateSettings
- AddEnv(this DockerContainerCreateSettings toolSettings, string[] env) : DockerContainerCreateSettings
- AddEnv(this DockerContainerCreateSettings toolSettings, IEnumerable<string> env) : DockerContainerCreateSettings
- AddEnvFile(this DockerContainerCreateSettings toolSettings, string[] envFile) : DockerContainerCreateSettings
- AddEnvFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerContainerCreateSettings
- AddExpose(this DockerContainerCreateSettings toolSettings, string[] expose) : DockerContainerCreateSettings
- AddExpose(this DockerContainerCreateSettings toolSettings, IEnumerable<string> expose) : DockerContainerCreateSettings
- AddGroupAdd(this DockerContainerCreateSettings toolSettings, string[] groupAdd) : DockerContainerCreateSettings
- AddGroupAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerCreateSettings
- AddLabel(this DockerContainerCreateSettings toolSettings, string[] label) : DockerContainerCreateSettings
- AddLabel(this DockerContainerCreateSettings toolSettings, IEnumerable<string> label) : DockerContainerCreateSettings
- AddLabelFile(this DockerContainerCreateSettings toolSettings, string[] labelFile) : DockerContainerCreateSettings
- AddLabelFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerCreateSettings
- AddLink(this DockerContainerCreateSettings toolSettings, string[] link) : DockerContainerCreateSettings
- AddLink(this DockerContainerCreateSettings toolSettings, IEnumerable<string> link) : DockerContainerCreateSettings
- AddLinkLocalIp(this DockerContainerCreateSettings toolSettings, string[] linkLocalIp) : DockerContainerCreateSettings
- AddLinkLocalIp(this DockerContainerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerCreateSettings
- AddLogOpt(this DockerContainerCreateSettings toolSettings, string[] logOpt) : DockerContainerCreateSettings
- AddLogOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerCreateSettings
- AddNetAlias(this DockerContainerCreateSettings toolSettings, string[] netAlias) : DockerContainerCreateSettings
- AddNetAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerCreateSettings
- AddNetworkAlias(this DockerContainerCreateSettings toolSettings, string[] networkAlias) : DockerContainerCreateSettings
- AddNetworkAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerCreateSettings
- AddPublish(this DockerContainerCreateSettings toolSettings, string[] publish) : DockerContainerCreateSettings
- AddPublish(this DockerContainerCreateSettings toolSettings, IEnumerable<string> publish) : DockerContainerCreateSettings
- AddSecurityOpt(this DockerContainerCreateSettings toolSettings, string[] securityOpt) : DockerContainerCreateSettings
- AddSecurityOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerCreateSettings
- AddStorageOpt(this DockerContainerCreateSettings toolSettings, string[] storageOpt) : DockerContainerCreateSettings
- AddStorageOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerCreateSettings
- AddSysctl(this DockerContainerCreateSettings toolSettings, string sysctlKey, string sysctlValue) : DockerContainerCreateSettings
- AddTmpfs(this DockerContainerCreateSettings toolSettings, string[] tmpfs) : DockerContainerCreateSettings
- AddTmpfs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerCreateSettings
- AddVolume(this DockerContainerCreateSettings toolSettings, string[] volume) : DockerContainerCreateSettings
- AddVolume(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volume) : DockerContainerCreateSettings
- AddVolumesFrom(this DockerContainerCreateSettings toolSettings, string[] volumesFrom) : DockerContainerCreateSettings
- AddVolumesFrom(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerCreateSettings
- ClearAddHost(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearArgs(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearAttach(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearBlkioWeightDevice(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearCapAdd(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearCapDrop(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDevice(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDeviceCgroupRule(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDeviceReadBps(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDeviceReadIops(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDeviceWriteBps(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDeviceWriteIops(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDns(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDnsOpt(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDnsOption(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearDnsSearch(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearEnv(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearEnvFile(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearExpose(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearGroupAdd(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearLabel(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearLabelFile(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearLink(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearLinkLocalIp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearLogOpt(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearNetAlias(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearNetworkAlias(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearPublish(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearSecurityOpt(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearStorageOpt(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearSysctl(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearTmpfs(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearVolume(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ClearVolumesFrom(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableDisableContentTrust(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableHelp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableInit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableInteractive(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableNoHealthcheck(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableOomKillDisable(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisablePrivileged(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisablePublishAll(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableReadOnly(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableRm(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- DisableTty(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableDisableContentTrust(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableHelp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableInit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableInteractive(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableNoHealthcheck(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableOomKillDisable(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnablePrivileged(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnablePublishAll(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableReadOnly(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableRm(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- EnableTty(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- RemoveAddHost(this DockerContainerCreateSettings toolSettings, string[] addHost) : DockerContainerCreateSettings
- RemoveAddHost(this DockerContainerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerContainerCreateSettings
- RemoveArgs(this DockerContainerCreateSettings toolSettings, string[] args) : DockerContainerCreateSettings
- RemoveArgs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> args) : DockerContainerCreateSettings
- RemoveAttach(this DockerContainerCreateSettings toolSettings, string[] attach) : DockerContainerCreateSettings
- RemoveAttach(this DockerContainerCreateSettings toolSettings, IEnumerable<string> attach) : DockerContainerCreateSettings
- RemoveBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerContainerCreateSettings
- RemoveBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerCreateSettings
- RemoveCapAdd(this DockerContainerCreateSettings toolSettings, string[] capAdd) : DockerContainerCreateSettings
- RemoveCapAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerCreateSettings
- RemoveCapDrop(this DockerContainerCreateSettings toolSettings, string[] capDrop) : DockerContainerCreateSettings
- RemoveCapDrop(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerCreateSettings
- RemoveDevice(this DockerContainerCreateSettings toolSettings, string[] device) : DockerContainerCreateSettings
- RemoveDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> device) : DockerContainerCreateSettings
- RemoveDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerContainerCreateSettings
- RemoveDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerCreateSettings
- RemoveDeviceReadBps(this DockerContainerCreateSettings toolSettings, string[] deviceReadBps) : DockerContainerCreateSettings
- RemoveDeviceReadBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerCreateSettings
- RemoveDeviceReadIops(this DockerContainerCreateSettings toolSettings, string[] deviceReadIops) : DockerContainerCreateSettings
- RemoveDeviceReadIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerCreateSettings
- RemoveDeviceWriteBps(this DockerContainerCreateSettings toolSettings, string[] deviceWriteBps) : DockerContainerCreateSettings
- RemoveDeviceWriteBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerCreateSettings
- RemoveDeviceWriteIops(this DockerContainerCreateSettings toolSettings, string[] deviceWriteIops) : DockerContainerCreateSettings
- RemoveDeviceWriteIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerCreateSettings
- RemoveDns(this DockerContainerCreateSettings toolSettings, string[] dns) : DockerContainerCreateSettings
- RemoveDns(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dns) : DockerContainerCreateSettings
- RemoveDnsOpt(this DockerContainerCreateSettings toolSettings, string[] dnsOpt) : DockerContainerCreateSettings
- RemoveDnsOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerCreateSettings
- RemoveDnsOption(this DockerContainerCreateSettings toolSettings, string[] dnsOption) : DockerContainerCreateSettings
- RemoveDnsOption(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerCreateSettings
- RemoveDnsSearch(this DockerContainerCreateSettings toolSettings, string[] dnsSearch) : DockerContainerCreateSettings
- RemoveDnsSearch(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerCreateSettings
- RemoveEnv(this DockerContainerCreateSettings toolSettings, string[] env) : DockerContainerCreateSettings
- RemoveEnv(this DockerContainerCreateSettings toolSettings, IEnumerable<string> env) : DockerContainerCreateSettings
- RemoveEnvFile(this DockerContainerCreateSettings toolSettings, string[] envFile) : DockerContainerCreateSettings
- RemoveEnvFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerContainerCreateSettings
- RemoveExpose(this DockerContainerCreateSettings toolSettings, string[] expose) : DockerContainerCreateSettings
- RemoveExpose(this DockerContainerCreateSettings toolSettings, IEnumerable<string> expose) : DockerContainerCreateSettings
- RemoveGroupAdd(this DockerContainerCreateSettings toolSettings, string[] groupAdd) : DockerContainerCreateSettings
- RemoveGroupAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerCreateSettings
- RemoveLabel(this DockerContainerCreateSettings toolSettings, string[] label) : DockerContainerCreateSettings
- RemoveLabel(this DockerContainerCreateSettings toolSettings, IEnumerable<string> label) : DockerContainerCreateSettings
- RemoveLabelFile(this DockerContainerCreateSettings toolSettings, string[] labelFile) : DockerContainerCreateSettings
- RemoveLabelFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerCreateSettings
- RemoveLink(this DockerContainerCreateSettings toolSettings, string[] link) : DockerContainerCreateSettings
- RemoveLink(this DockerContainerCreateSettings toolSettings, IEnumerable<string> link) : DockerContainerCreateSettings
- RemoveLinkLocalIp(this DockerContainerCreateSettings toolSettings, string[] linkLocalIp) : DockerContainerCreateSettings
- RemoveLinkLocalIp(this DockerContainerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerCreateSettings
- RemoveLogOpt(this DockerContainerCreateSettings toolSettings, string[] logOpt) : DockerContainerCreateSettings
- RemoveLogOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerCreateSettings
- RemoveNetAlias(this DockerContainerCreateSettings toolSettings, string[] netAlias) : DockerContainerCreateSettings
- RemoveNetAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerCreateSettings
- RemoveNetworkAlias(this DockerContainerCreateSettings toolSettings, string[] networkAlias) : DockerContainerCreateSettings
- RemoveNetworkAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerCreateSettings
- RemovePublish(this DockerContainerCreateSettings toolSettings, string[] publish) : DockerContainerCreateSettings
- RemovePublish(this DockerContainerCreateSettings toolSettings, IEnumerable<string> publish) : DockerContainerCreateSettings
- RemoveSecurityOpt(this DockerContainerCreateSettings toolSettings, string[] securityOpt) : DockerContainerCreateSettings
- RemoveSecurityOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerCreateSettings
- RemoveStorageOpt(this DockerContainerCreateSettings toolSettings, string[] storageOpt) : DockerContainerCreateSettings
- RemoveStorageOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerCreateSettings
- RemoveSysctl(this DockerContainerCreateSettings toolSettings, string sysctlKey) : DockerContainerCreateSettings
- RemoveTmpfs(this DockerContainerCreateSettings toolSettings, string[] tmpfs) : DockerContainerCreateSettings
- RemoveTmpfs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerCreateSettings
- RemoveVolume(this DockerContainerCreateSettings toolSettings, string[] volume) : DockerContainerCreateSettings
- RemoveVolume(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volume) : DockerContainerCreateSettings
- RemoveVolumesFrom(this DockerContainerCreateSettings toolSettings, string[] volumesFrom) : DockerContainerCreateSettings
- RemoveVolumesFrom(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerCreateSettings
- ResetBlkioWeight(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCgroupParent(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCidfile(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCommand(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuCount(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuPercent(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuPeriod(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuQuota(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuRtPeriod(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuRtRuntime(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpus(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpusetCpus(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpusetMems(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetCpuShares(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetDisableContentTrust(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetDomainname(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetEntrypoint(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetGpus(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHealthCmd(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHealthInterval(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHealthRetries(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHealthStartPeriod(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHealthTimeout(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHelp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetHostname(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetImage(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetInit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetInteractive(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIoMaxbandwidth(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIoMaxiops(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIp6(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIpc(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetIsolation(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetKernelMemory(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetLogDriver(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMacAddress(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMemory(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMemoryReservation(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMemorySwap(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMemorySwappiness(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetMount(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetName(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetNet(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetNetwork(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetNoHealthcheck(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetOomKillDisable(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetOomScoreAdj(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetPid(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetPidsLimit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetPlatform(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetPrivileged(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetPublishAll(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetReadOnly(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetRestart(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetRm(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetRuntime(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetShmSize(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetStopSignal(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetStopTimeout(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetTty(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetUlimit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetUser(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetUserns(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetUts(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetVolumeDriver(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ResetWorkdir(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- SetAddHost(this DockerContainerCreateSettings toolSettings, string[] addHost) : DockerContainerCreateSettings
- SetAddHost(this DockerContainerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerContainerCreateSettings
- SetArgs(this DockerContainerCreateSettings toolSettings, string[] args) : DockerContainerCreateSettings
- SetArgs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> args) : DockerContainerCreateSettings
- SetAttach(this DockerContainerCreateSettings toolSettings, string[] attach) : DockerContainerCreateSettings
- SetAttach(this DockerContainerCreateSettings toolSettings, IEnumerable<string> attach) : DockerContainerCreateSettings
- SetBlkioWeight(this DockerContainerCreateSettings toolSettings, int? blkioWeight) : DockerContainerCreateSettings
- SetBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerContainerCreateSettings
- SetBlkioWeightDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerCreateSettings
- SetCapAdd(this DockerContainerCreateSettings toolSettings, string[] capAdd) : DockerContainerCreateSettings
- SetCapAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerCreateSettings
- SetCapDrop(this DockerContainerCreateSettings toolSettings, string[] capDrop) : DockerContainerCreateSettings
- SetCapDrop(this DockerContainerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerCreateSettings
- SetCgroupParent(this DockerContainerCreateSettings toolSettings, string cgroupParent) : DockerContainerCreateSettings
- SetCidfile(this DockerContainerCreateSettings toolSettings, string cidfile) : DockerContainerCreateSettings
- SetCommand(this DockerContainerCreateSettings toolSettings, string command) : DockerContainerCreateSettings
- SetCpuCount(this DockerContainerCreateSettings toolSettings, long? cpuCount) : DockerContainerCreateSettings
- SetCpuPercent(this DockerContainerCreateSettings toolSettings, long? cpuPercent) : DockerContainerCreateSettings
- SetCpuPeriod(this DockerContainerCreateSettings toolSettings, long? cpuPeriod) : DockerContainerCreateSettings
- SetCpuQuota(this DockerContainerCreateSettings toolSettings, long? cpuQuota) : DockerContainerCreateSettings
- SetCpuRtPeriod(this DockerContainerCreateSettings toolSettings, long? cpuRtPeriod) : DockerContainerCreateSettings
- SetCpuRtRuntime(this DockerContainerCreateSettings toolSettings, long? cpuRtRuntime) : DockerContainerCreateSettings
- SetCpus(this DockerContainerCreateSettings toolSettings, decimal? cpus) : DockerContainerCreateSettings
- SetCpusetCpus(this DockerContainerCreateSettings toolSettings, string cpusetCpus) : DockerContainerCreateSettings
- SetCpusetMems(this DockerContainerCreateSettings toolSettings, string cpusetMems) : DockerContainerCreateSettings
- SetCpuShares(this DockerContainerCreateSettings toolSettings, long? cpuShares) : DockerContainerCreateSettings
- SetDevice(this DockerContainerCreateSettings toolSettings, string[] device) : DockerContainerCreateSettings
- SetDevice(this DockerContainerCreateSettings toolSettings, IEnumerable<string> device) : DockerContainerCreateSettings
- SetDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerContainerCreateSettings
- SetDeviceCgroupRule(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerCreateSettings
- SetDeviceReadBps(this DockerContainerCreateSettings toolSettings, string[] deviceReadBps) : DockerContainerCreateSettings
- SetDeviceReadBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerCreateSettings
- SetDeviceReadIops(this DockerContainerCreateSettings toolSettings, string[] deviceReadIops) : DockerContainerCreateSettings
- SetDeviceReadIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerCreateSettings
- SetDeviceWriteBps(this DockerContainerCreateSettings toolSettings, string[] deviceWriteBps) : DockerContainerCreateSettings
- SetDeviceWriteBps(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerCreateSettings
- SetDeviceWriteIops(this DockerContainerCreateSettings toolSettings, string[] deviceWriteIops) : DockerContainerCreateSettings
- SetDeviceWriteIops(this DockerContainerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerCreateSettings
- SetDisableContentTrust(this DockerContainerCreateSettings toolSettings, bool? disableContentTrust) : DockerContainerCreateSettings
- SetDns(this DockerContainerCreateSettings toolSettings, string[] dns) : DockerContainerCreateSettings
- SetDns(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dns) : DockerContainerCreateSettings
- SetDnsOpt(this DockerContainerCreateSettings toolSettings, string[] dnsOpt) : DockerContainerCreateSettings
- SetDnsOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerCreateSettings
- SetDnsOption(this DockerContainerCreateSettings toolSettings, string[] dnsOption) : DockerContainerCreateSettings
- SetDnsOption(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerCreateSettings
- SetDnsSearch(this DockerContainerCreateSettings toolSettings, string[] dnsSearch) : DockerContainerCreateSettings
- SetDnsSearch(this DockerContainerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerCreateSettings
- SetDomainname(this DockerContainerCreateSettings toolSettings, string domainname) : DockerContainerCreateSettings
- SetEntrypoint(this DockerContainerCreateSettings toolSettings, string entrypoint) : DockerContainerCreateSettings
- SetEnv(this DockerContainerCreateSettings toolSettings, string[] env) : DockerContainerCreateSettings
- SetEnv(this DockerContainerCreateSettings toolSettings, IEnumerable<string> env) : DockerContainerCreateSettings
- SetEnvFile(this DockerContainerCreateSettings toolSettings, string[] envFile) : DockerContainerCreateSettings
- SetEnvFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerContainerCreateSettings
- SetExpose(this DockerContainerCreateSettings toolSettings, string[] expose) : DockerContainerCreateSettings
- SetExpose(this DockerContainerCreateSettings toolSettings, IEnumerable<string> expose) : DockerContainerCreateSettings
- SetGpus(this DockerContainerCreateSettings toolSettings, string gpus) : DockerContainerCreateSettings
- SetGroupAdd(this DockerContainerCreateSettings toolSettings, string[] groupAdd) : DockerContainerCreateSettings
- SetGroupAdd(this DockerContainerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerCreateSettings
- SetHealthCmd(this DockerContainerCreateSettings toolSettings, string healthCmd) : DockerContainerCreateSettings
- SetHealthInterval(this DockerContainerCreateSettings toolSettings, string healthInterval) : DockerContainerCreateSettings
- SetHealthRetries(this DockerContainerCreateSettings toolSettings, int? healthRetries) : DockerContainerCreateSettings
- SetHealthStartPeriod(this DockerContainerCreateSettings toolSettings, string healthStartPeriod) : DockerContainerCreateSettings
- SetHealthTimeout(this DockerContainerCreateSettings toolSettings, string healthTimeout) : DockerContainerCreateSettings
- SetHelp(this DockerContainerCreateSettings toolSettings, bool? help) : DockerContainerCreateSettings
- SetHostname(this DockerContainerCreateSettings toolSettings, string hostname) : DockerContainerCreateSettings
- SetImage(this DockerContainerCreateSettings toolSettings, string image) : DockerContainerCreateSettings
- SetInit(this DockerContainerCreateSettings toolSettings, bool? init) : DockerContainerCreateSettings
- SetInteractive(this DockerContainerCreateSettings toolSettings, bool? interactive) : DockerContainerCreateSettings
- SetIoMaxbandwidth(this DockerContainerCreateSettings toolSettings, long? ioMaxbandwidth) : DockerContainerCreateSettings
- SetIoMaxiops(this DockerContainerCreateSettings toolSettings, int? ioMaxiops) : DockerContainerCreateSettings
- SetIp(this DockerContainerCreateSettings toolSettings, string ip) : DockerContainerCreateSettings
- SetIp6(this DockerContainerCreateSettings toolSettings, string ip6) : DockerContainerCreateSettings
- SetIpc(this DockerContainerCreateSettings toolSettings, string ipc) : DockerContainerCreateSettings
- SetIsolation(this DockerContainerCreateSettings toolSettings, string isolation) : DockerContainerCreateSettings
- SetKernelMemory(this DockerContainerCreateSettings toolSettings, long? kernelMemory) : DockerContainerCreateSettings
- SetLabel(this DockerContainerCreateSettings toolSettings, string[] label) : DockerContainerCreateSettings
- SetLabel(this DockerContainerCreateSettings toolSettings, IEnumerable<string> label) : DockerContainerCreateSettings
- SetLabelFile(this DockerContainerCreateSettings toolSettings, string[] labelFile) : DockerContainerCreateSettings
- SetLabelFile(this DockerContainerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerCreateSettings
- SetLink(this DockerContainerCreateSettings toolSettings, string[] link) : DockerContainerCreateSettings
- SetLink(this DockerContainerCreateSettings toolSettings, IEnumerable<string> link) : DockerContainerCreateSettings
- SetLinkLocalIp(this DockerContainerCreateSettings toolSettings, string[] linkLocalIp) : DockerContainerCreateSettings
- SetLinkLocalIp(this DockerContainerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerCreateSettings
- SetLogDriver(this DockerContainerCreateSettings toolSettings, string logDriver) : DockerContainerCreateSettings
- SetLogOpt(this DockerContainerCreateSettings toolSettings, string[] logOpt) : DockerContainerCreateSettings
- SetLogOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerCreateSettings
- SetMacAddress(this DockerContainerCreateSettings toolSettings, string macAddress) : DockerContainerCreateSettings
- SetMemory(this DockerContainerCreateSettings toolSettings, long? memory) : DockerContainerCreateSettings
- SetMemoryReservation(this DockerContainerCreateSettings toolSettings, long? memoryReservation) : DockerContainerCreateSettings
- SetMemorySwap(this DockerContainerCreateSettings toolSettings, long? memorySwap) : DockerContainerCreateSettings
- SetMemorySwappiness(this DockerContainerCreateSettings toolSettings, long? memorySwappiness) : DockerContainerCreateSettings
- SetMount(this DockerContainerCreateSettings toolSettings, string mount) : DockerContainerCreateSettings
- SetName(this DockerContainerCreateSettings toolSettings, string name) : DockerContainerCreateSettings
- SetNet(this DockerContainerCreateSettings toolSettings, string net) : DockerContainerCreateSettings
- SetNetAlias(this DockerContainerCreateSettings toolSettings, string[] netAlias) : DockerContainerCreateSettings
- SetNetAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerCreateSettings
- SetNetwork(this DockerContainerCreateSettings toolSettings, string network) : DockerContainerCreateSettings
- SetNetworkAlias(this DockerContainerCreateSettings toolSettings, string[] networkAlias) : DockerContainerCreateSettings
- SetNetworkAlias(this DockerContainerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerCreateSettings
- SetNoHealthcheck(this DockerContainerCreateSettings toolSettings, bool? noHealthcheck) : DockerContainerCreateSettings
- SetOomKillDisable(this DockerContainerCreateSettings toolSettings, bool? oomKillDisable) : DockerContainerCreateSettings
- SetOomScoreAdj(this DockerContainerCreateSettings toolSettings, int? oomScoreAdj) : DockerContainerCreateSettings
- SetPid(this DockerContainerCreateSettings toolSettings, string pid) : DockerContainerCreateSettings
- SetPidsLimit(this DockerContainerCreateSettings toolSettings, long? pidsLimit) : DockerContainerCreateSettings
- SetPlatform(this DockerContainerCreateSettings toolSettings, string platform) : DockerContainerCreateSettings
- SetPrivileged(this DockerContainerCreateSettings toolSettings, bool? privileged) : DockerContainerCreateSettings
- SetPublish(this DockerContainerCreateSettings toolSettings, string[] publish) : DockerContainerCreateSettings
- SetPublish(this DockerContainerCreateSettings toolSettings, IEnumerable<string> publish) : DockerContainerCreateSettings
- SetPublishAll(this DockerContainerCreateSettings toolSettings, bool? publishAll) : DockerContainerCreateSettings
- SetReadOnly(this DockerContainerCreateSettings toolSettings, bool? readOnly) : DockerContainerCreateSettings
- SetRestart(this DockerContainerCreateSettings toolSettings, string restart) : DockerContainerCreateSettings
- SetRm(this DockerContainerCreateSettings toolSettings, bool? rm) : DockerContainerCreateSettings
- SetRuntime(this DockerContainerCreateSettings toolSettings, string runtime) : DockerContainerCreateSettings
- SetSecurityOpt(this DockerContainerCreateSettings toolSettings, string[] securityOpt) : DockerContainerCreateSettings
- SetSecurityOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerCreateSettings
- SetShmSize(this DockerContainerCreateSettings toolSettings, long? shmSize) : DockerContainerCreateSettings
- SetStopSignal(this DockerContainerCreateSettings toolSettings, string stopSignal) : DockerContainerCreateSettings
- SetStopTimeout(this DockerContainerCreateSettings toolSettings, int? stopTimeout) : DockerContainerCreateSettings
- SetStorageOpt(this DockerContainerCreateSettings toolSettings, string[] storageOpt) : DockerContainerCreateSettings
- SetStorageOpt(this DockerContainerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerCreateSettings
- SetSysctl(this DockerContainerCreateSettings toolSettings, IDictionary<string, string> sysctl) : DockerContainerCreateSettings
- SetSysctl(this DockerContainerCreateSettings toolSettings, string sysctlKey, string sysctlValue) : DockerContainerCreateSettings
- SetTmpfs(this DockerContainerCreateSettings toolSettings, string[] tmpfs) : DockerContainerCreateSettings
- SetTmpfs(this DockerContainerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerCreateSettings
- SetTty(this DockerContainerCreateSettings toolSettings, bool? tty) : DockerContainerCreateSettings
- SetUlimit(this DockerContainerCreateSettings toolSettings, string ulimit) : DockerContainerCreateSettings
- SetUser(this DockerContainerCreateSettings toolSettings, string user) : DockerContainerCreateSettings
- SetUserns(this DockerContainerCreateSettings toolSettings, string userns) : DockerContainerCreateSettings
- SetUts(this DockerContainerCreateSettings toolSettings, string uts) : DockerContainerCreateSettings
- SetVolume(this DockerContainerCreateSettings toolSettings, string[] volume) : DockerContainerCreateSettings
- SetVolume(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volume) : DockerContainerCreateSettings
- SetVolumeDriver(this DockerContainerCreateSettings toolSettings, string volumeDriver) : DockerContainerCreateSettings
- SetVolumesFrom(this DockerContainerCreateSettings toolSettings, string[] volumesFrom) : DockerContainerCreateSettings
- SetVolumesFrom(this DockerContainerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerCreateSettings
- SetWorkdir(this DockerContainerCreateSettings toolSettings, string workdir) : DockerContainerCreateSettings
- ToggleDisableContentTrust(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleHelp(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleInit(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleInteractive(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleNoHealthcheck(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleOomKillDisable(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- TogglePrivileged(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- TogglePublishAll(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleReadOnly(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleRm(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings
- ToggleTty(this DockerContainerCreateSettings toolSettings) : DockerContainerCreateSettings

### Nuke.Common.Tools.Docker.DockerContainerDiffSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerDiffSettingsExtensions

- ResetContainer(this DockerContainerDiffSettings toolSettings) : DockerContainerDiffSettings
- SetContainer(this DockerContainerDiffSettings toolSettings, string container) : DockerContainerDiffSettings

### Nuke.Common.Tools.Docker.DockerContainerExecSettings

- .ctor()
- get_Args() : IReadOnlyList<string>
- get_Command() : string
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_DetachKeys() : string
- get_Env() : IReadOnlyList<string>
- get_Interactive() : bool?
- get_Privileged() : bool?
- get_ToolPath() : string
- get_Tty() : bool?
- get_User() : string
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerExecSettingsExtensions

- AddArgs(this DockerContainerExecSettings toolSettings, string[] args) : DockerContainerExecSettings
- AddArgs(this DockerContainerExecSettings toolSettings, IEnumerable<string> args) : DockerContainerExecSettings
- AddEnv(this DockerContainerExecSettings toolSettings, string[] env) : DockerContainerExecSettings
- AddEnv(this DockerContainerExecSettings toolSettings, IEnumerable<string> env) : DockerContainerExecSettings
- ClearArgs(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ClearEnv(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- DisableDetach(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- DisableInteractive(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- DisablePrivileged(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- DisableTty(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- EnableDetach(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- EnableInteractive(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- EnablePrivileged(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- EnableTty(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- RemoveArgs(this DockerContainerExecSettings toolSettings, string[] args) : DockerContainerExecSettings
- RemoveArgs(this DockerContainerExecSettings toolSettings, IEnumerable<string> args) : DockerContainerExecSettings
- RemoveEnv(this DockerContainerExecSettings toolSettings, string[] env) : DockerContainerExecSettings
- RemoveEnv(this DockerContainerExecSettings toolSettings, IEnumerable<string> env) : DockerContainerExecSettings
- ResetCommand(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetContainer(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetDetach(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetDetachKeys(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetInteractive(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetPrivileged(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetTty(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetUser(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ResetWorkdir(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- SetArgs(this DockerContainerExecSettings toolSettings, string[] args) : DockerContainerExecSettings
- SetArgs(this DockerContainerExecSettings toolSettings, IEnumerable<string> args) : DockerContainerExecSettings
- SetCommand(this DockerContainerExecSettings toolSettings, string command) : DockerContainerExecSettings
- SetContainer(this DockerContainerExecSettings toolSettings, string container) : DockerContainerExecSettings
- SetDetach(this DockerContainerExecSettings toolSettings, bool? detach) : DockerContainerExecSettings
- SetDetachKeys(this DockerContainerExecSettings toolSettings, string detachKeys) : DockerContainerExecSettings
- SetEnv(this DockerContainerExecSettings toolSettings, string[] env) : DockerContainerExecSettings
- SetEnv(this DockerContainerExecSettings toolSettings, IEnumerable<string> env) : DockerContainerExecSettings
- SetInteractive(this DockerContainerExecSettings toolSettings, bool? interactive) : DockerContainerExecSettings
- SetPrivileged(this DockerContainerExecSettings toolSettings, bool? privileged) : DockerContainerExecSettings
- SetTty(this DockerContainerExecSettings toolSettings, bool? tty) : DockerContainerExecSettings
- SetUser(this DockerContainerExecSettings toolSettings, string user) : DockerContainerExecSettings
- SetWorkdir(this DockerContainerExecSettings toolSettings, string workdir) : DockerContainerExecSettings
- ToggleDetach(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ToggleInteractive(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- TogglePrivileged(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings
- ToggleTty(this DockerContainerExecSettings toolSettings) : DockerContainerExecSettings

### Nuke.Common.Tools.Docker.DockerContainerExportSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Output() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerExportSettingsExtensions

- ResetContainer(this DockerContainerExportSettings toolSettings) : DockerContainerExportSettings
- ResetOutput(this DockerContainerExportSettings toolSettings) : DockerContainerExportSettings
- SetContainer(this DockerContainerExportSettings toolSettings, string container) : DockerContainerExportSettings
- SetOutput(this DockerContainerExportSettings toolSettings, string output) : DockerContainerExportSettings

### Nuke.Common.Tools.Docker.DockerContainerInspectSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Size() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerInspectSettingsExtensions

- AddContainers(this DockerContainerInspectSettings toolSettings, string[] containers) : DockerContainerInspectSettings
- AddContainers(this DockerContainerInspectSettings toolSettings, IEnumerable<string> containers) : DockerContainerInspectSettings
- ClearContainers(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings
- DisableSize(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings
- EnableSize(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings
- RemoveContainers(this DockerContainerInspectSettings toolSettings, string[] containers) : DockerContainerInspectSettings
- RemoveContainers(this DockerContainerInspectSettings toolSettings, IEnumerable<string> containers) : DockerContainerInspectSettings
- ResetFormat(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings
- ResetSize(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings
- SetContainers(this DockerContainerInspectSettings toolSettings, string[] containers) : DockerContainerInspectSettings
- SetContainers(this DockerContainerInspectSettings toolSettings, IEnumerable<string> containers) : DockerContainerInspectSettings
- SetFormat(this DockerContainerInspectSettings toolSettings, string format) : DockerContainerInspectSettings
- SetSize(this DockerContainerInspectSettings toolSettings, bool? size) : DockerContainerInspectSettings
- ToggleSize(this DockerContainerInspectSettings toolSettings) : DockerContainerInspectSettings

### Nuke.Common.Tools.Docker.DockerContainerKillSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Signal() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerKillSettingsExtensions

- AddContainers(this DockerContainerKillSettings toolSettings, string[] containers) : DockerContainerKillSettings
- AddContainers(this DockerContainerKillSettings toolSettings, IEnumerable<string> containers) : DockerContainerKillSettings
- ClearContainers(this DockerContainerKillSettings toolSettings) : DockerContainerKillSettings
- RemoveContainers(this DockerContainerKillSettings toolSettings, string[] containers) : DockerContainerKillSettings
- RemoveContainers(this DockerContainerKillSettings toolSettings, IEnumerable<string> containers) : DockerContainerKillSettings
- ResetSignal(this DockerContainerKillSettings toolSettings) : DockerContainerKillSettings
- SetContainers(this DockerContainerKillSettings toolSettings, string[] containers) : DockerContainerKillSettings
- SetContainers(this DockerContainerKillSettings toolSettings, IEnumerable<string> containers) : DockerContainerKillSettings
- SetSignal(this DockerContainerKillSettings toolSettings, string signal) : DockerContainerKillSettings

### Nuke.Common.Tools.Docker.DockerContainerLogsSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Details() : bool?
- get_Follow() : bool?
- get_Since() : string
- get_Tail() : string
- get_Timestamps() : bool?
- get_ToolPath() : string
- get_Until() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerLogsSettingsExtensions

- DisableDetails(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- DisableFollow(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- DisableTimestamps(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- EnableDetails(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- EnableFollow(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- EnableTimestamps(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetContainer(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetDetails(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetFollow(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetSince(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetTail(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetTimestamps(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ResetUntil(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- SetContainer(this DockerContainerLogsSettings toolSettings, string container) : DockerContainerLogsSettings
- SetDetails(this DockerContainerLogsSettings toolSettings, bool? details) : DockerContainerLogsSettings
- SetFollow(this DockerContainerLogsSettings toolSettings, bool? follow) : DockerContainerLogsSettings
- SetSince(this DockerContainerLogsSettings toolSettings, string since) : DockerContainerLogsSettings
- SetTail(this DockerContainerLogsSettings toolSettings, string tail) : DockerContainerLogsSettings
- SetTimestamps(this DockerContainerLogsSettings toolSettings, bool? timestamps) : DockerContainerLogsSettings
- SetUntil(this DockerContainerLogsSettings toolSettings, string until) : DockerContainerLogsSettings
- ToggleDetails(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ToggleFollow(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings
- ToggleTimestamps(this DockerContainerLogsSettings toolSettings) : DockerContainerLogsSettings

### Nuke.Common.Tools.Docker.DockerContainerLsSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Last() : int?
- get_Latest() : bool?
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Size() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerLsSettingsExtensions

- DisableAll(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- DisableLatest(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- DisableNoTrunc(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- DisableQuiet(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- DisableSize(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- EnableAll(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- EnableLatest(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- EnableNoTrunc(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- EnableQuiet(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- EnableSize(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetAll(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetFilter(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetFormat(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetLast(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetLatest(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetNoTrunc(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetQuiet(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ResetSize(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- SetAll(this DockerContainerLsSettings toolSettings, bool? all) : DockerContainerLsSettings
- SetFilter(this DockerContainerLsSettings toolSettings, string filter) : DockerContainerLsSettings
- SetFormat(this DockerContainerLsSettings toolSettings, string format) : DockerContainerLsSettings
- SetLast(this DockerContainerLsSettings toolSettings, int? last) : DockerContainerLsSettings
- SetLatest(this DockerContainerLsSettings toolSettings, bool? latest) : DockerContainerLsSettings
- SetNoTrunc(this DockerContainerLsSettings toolSettings, bool? noTrunc) : DockerContainerLsSettings
- SetQuiet(this DockerContainerLsSettings toolSettings, bool? quiet) : DockerContainerLsSettings
- SetSize(this DockerContainerLsSettings toolSettings, bool? size) : DockerContainerLsSettings
- ToggleAll(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ToggleLatest(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ToggleNoTrunc(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ToggleQuiet(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings
- ToggleSize(this DockerContainerLsSettings toolSettings) : DockerContainerLsSettings

### Nuke.Common.Tools.Docker.DockerContainerPauseSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerPauseSettingsExtensions

- AddContainers(this DockerContainerPauseSettings toolSettings, string[] containers) : DockerContainerPauseSettings
- AddContainers(this DockerContainerPauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerPauseSettings
- ClearContainers(this DockerContainerPauseSettings toolSettings) : DockerContainerPauseSettings
- RemoveContainers(this DockerContainerPauseSettings toolSettings, string[] containers) : DockerContainerPauseSettings
- RemoveContainers(this DockerContainerPauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerPauseSettings
- SetContainers(this DockerContainerPauseSettings toolSettings, string[] containers) : DockerContainerPauseSettings
- SetContainers(this DockerContainerPauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerPauseSettings

### Nuke.Common.Tools.Docker.DockerContainerPortSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_PrivatePort() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerPortSettingsExtensions

- ResetContainer(this DockerContainerPortSettings toolSettings) : DockerContainerPortSettings
- ResetPrivatePort(this DockerContainerPortSettings toolSettings) : DockerContainerPortSettings
- SetContainer(this DockerContainerPortSettings toolSettings, string container) : DockerContainerPortSettings
- SetPrivatePort(this DockerContainerPortSettings toolSettings, string privatePort) : DockerContainerPortSettings

### Nuke.Common.Tools.Docker.DockerContainerPruneSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Force() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerPruneSettingsExtensions

- DisableForce(this DockerContainerPruneSettings toolSettings) : DockerContainerPruneSettings
- EnableForce(this DockerContainerPruneSettings toolSettings) : DockerContainerPruneSettings
- ResetFilter(this DockerContainerPruneSettings toolSettings) : DockerContainerPruneSettings
- ResetForce(this DockerContainerPruneSettings toolSettings) : DockerContainerPruneSettings
- SetFilter(this DockerContainerPruneSettings toolSettings, string filter) : DockerContainerPruneSettings
- SetForce(this DockerContainerPruneSettings toolSettings, bool? force) : DockerContainerPruneSettings
- ToggleForce(this DockerContainerPruneSettings toolSettings) : DockerContainerPruneSettings

### Nuke.Common.Tools.Docker.DockerContainerRenameSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_NewName() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerRenameSettingsExtensions

- ResetContainer(this DockerContainerRenameSettings toolSettings) : DockerContainerRenameSettings
- ResetNewName(this DockerContainerRenameSettings toolSettings) : DockerContainerRenameSettings
- SetContainer(this DockerContainerRenameSettings toolSettings, string container) : DockerContainerRenameSettings
- SetNewName(this DockerContainerRenameSettings toolSettings, string newName) : DockerContainerRenameSettings

### Nuke.Common.Tools.Docker.DockerContainerRestartSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Time() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerRestartSettingsExtensions

- AddContainers(this DockerContainerRestartSettings toolSettings, string[] containers) : DockerContainerRestartSettings
- AddContainers(this DockerContainerRestartSettings toolSettings, IEnumerable<string> containers) : DockerContainerRestartSettings
- ClearContainers(this DockerContainerRestartSettings toolSettings) : DockerContainerRestartSettings
- RemoveContainers(this DockerContainerRestartSettings toolSettings, string[] containers) : DockerContainerRestartSettings
- RemoveContainers(this DockerContainerRestartSettings toolSettings, IEnumerable<string> containers) : DockerContainerRestartSettings
- ResetTime(this DockerContainerRestartSettings toolSettings) : DockerContainerRestartSettings
- SetContainers(this DockerContainerRestartSettings toolSettings, string[] containers) : DockerContainerRestartSettings
- SetContainers(this DockerContainerRestartSettings toolSettings, IEnumerable<string> containers) : DockerContainerRestartSettings
- SetTime(this DockerContainerRestartSettings toolSettings, int? time) : DockerContainerRestartSettings

### Nuke.Common.Tools.Docker.DockerContainerRmSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Link() : bool?
- get_ToolPath() : string
- get_Volumes() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerRmSettingsExtensions

- AddContainers(this DockerContainerRmSettings toolSettings, string[] containers) : DockerContainerRmSettings
- AddContainers(this DockerContainerRmSettings toolSettings, IEnumerable<string> containers) : DockerContainerRmSettings
- ClearContainers(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- DisableForce(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- DisableLink(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- DisableVolumes(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- EnableForce(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- EnableLink(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- EnableVolumes(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- RemoveContainers(this DockerContainerRmSettings toolSettings, string[] containers) : DockerContainerRmSettings
- RemoveContainers(this DockerContainerRmSettings toolSettings, IEnumerable<string> containers) : DockerContainerRmSettings
- ResetForce(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- ResetLink(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- ResetVolumes(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- SetContainers(this DockerContainerRmSettings toolSettings, string[] containers) : DockerContainerRmSettings
- SetContainers(this DockerContainerRmSettings toolSettings, IEnumerable<string> containers) : DockerContainerRmSettings
- SetForce(this DockerContainerRmSettings toolSettings, bool? force) : DockerContainerRmSettings
- SetLink(this DockerContainerRmSettings toolSettings, bool? link) : DockerContainerRmSettings
- SetVolumes(this DockerContainerRmSettings toolSettings, bool? volumes) : DockerContainerRmSettings
- ToggleForce(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- ToggleLink(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings
- ToggleVolumes(this DockerContainerRmSettings toolSettings) : DockerContainerRmSettings

### Nuke.Common.Tools.Docker.DockerContainerRunSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_Args() : IReadOnlyList<string>
- get_Attach() : IReadOnlyList<string>
- get_BlkioWeight() : int?
- get_BlkioWeightDevice() : IReadOnlyList<string>
- get_CapAdd() : IReadOnlyList<string>
- get_CapDrop() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Cidfile() : string
- get_Command() : string
- get_CpuCount() : long?
- get_CpuPercent() : long?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_DetachKeys() : string
- get_Device() : IReadOnlyList<string>
- get_DeviceCgroupRule() : IReadOnlyList<string>
- get_DeviceReadBps() : IReadOnlyList<string>
- get_DeviceReadIops() : IReadOnlyList<string>
- get_DeviceWriteBps() : IReadOnlyList<string>
- get_DeviceWriteIops() : IReadOnlyList<string>
- get_DisableContentTrust() : bool?
- get_Dns() : IReadOnlyList<string>
- get_DnsOpt() : IReadOnlyList<string>
- get_DnsOption() : IReadOnlyList<string>
- get_DnsSearch() : IReadOnlyList<string>
- get_Domainname() : string
- get_Entrypoint() : string
- get_Env() : IReadOnlyList<string>
- get_EnvFile() : IReadOnlyList<string>
- get_Expose() : IReadOnlyList<string>
- get_Gpus() : string
- get_GroupAdd() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_Help() : bool?
- get_Hostname() : string
- get_Image() : string
- get_Init() : bool?
- get_Interactive() : bool?
- get_IoMaxbandwidth() : long?
- get_IoMaxiops() : int?
- get_Ip() : string
- get_Ip6() : string
- get_Ipc() : string
- get_Isolation() : string
- get_KernelMemory() : long?
- get_Label() : IReadOnlyList<string>
- get_LabelFile() : IReadOnlyList<string>
- get_Link() : IReadOnlyList<string>
- get_LinkLocalIp() : IReadOnlyList<string>
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_MacAddress() : string
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_MemorySwappiness() : long?
- get_Mount() : string
- get_Name() : string
- get_Net() : string
- get_NetAlias() : IReadOnlyList<string>
- get_Network() : string
- get_NetworkAlias() : IReadOnlyList<string>
- get_NoHealthcheck() : bool?
- get_OomKillDisable() : bool?
- get_OomScoreAdj() : int?
- get_Pid() : string
- get_PidsLimit() : long?
- get_Platform() : string
- get_Privileged() : bool?
- get_Publish() : IReadOnlyList<string>
- get_PublishAll() : bool?
- get_ReadOnly() : bool?
- get_Restart() : string
- get_Rm() : bool?
- get_Runtime() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_SigProxy() : bool?
- get_StopSignal() : string
- get_StopTimeout() : int?
- get_StorageOpt() : IReadOnlyList<string>
- get_Sysctl() : IReadOnlyDictionary<string, string>
- get_Tmpfs() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_Ulimit() : string
- get_User() : string
- get_Userns() : string
- get_Uts() : string
- get_Volume() : IReadOnlyList<string>
- get_VolumeDriver() : string
- get_VolumesFrom() : IReadOnlyList<string>
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerRunSettingsExtensions

- AddAddHost(this DockerContainerRunSettings toolSettings, string[] addHost) : DockerContainerRunSettings
- AddAddHost(this DockerContainerRunSettings toolSettings, IEnumerable<string> addHost) : DockerContainerRunSettings
- AddArgs(this DockerContainerRunSettings toolSettings, string[] args) : DockerContainerRunSettings
- AddArgs(this DockerContainerRunSettings toolSettings, IEnumerable<string> args) : DockerContainerRunSettings
- AddAttach(this DockerContainerRunSettings toolSettings, string[] attach) : DockerContainerRunSettings
- AddAttach(this DockerContainerRunSettings toolSettings, IEnumerable<string> attach) : DockerContainerRunSettings
- AddBlkioWeightDevice(this DockerContainerRunSettings toolSettings, string[] blkioWeightDevice) : DockerContainerRunSettings
- AddBlkioWeightDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerRunSettings
- AddCapAdd(this DockerContainerRunSettings toolSettings, string[] capAdd) : DockerContainerRunSettings
- AddCapAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerRunSettings
- AddCapDrop(this DockerContainerRunSettings toolSettings, string[] capDrop) : DockerContainerRunSettings
- AddCapDrop(this DockerContainerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerRunSettings
- AddDevice(this DockerContainerRunSettings toolSettings, string[] device) : DockerContainerRunSettings
- AddDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> device) : DockerContainerRunSettings
- AddDeviceCgroupRule(this DockerContainerRunSettings toolSettings, string[] deviceCgroupRule) : DockerContainerRunSettings
- AddDeviceCgroupRule(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerRunSettings
- AddDeviceReadBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerRunSettings
- AddDeviceReadBps(this DockerContainerRunSettings toolSettings, string[] deviceReadBps) : DockerContainerRunSettings
- AddDeviceReadIops(this DockerContainerRunSettings toolSettings, string[] deviceReadIops) : DockerContainerRunSettings
- AddDeviceReadIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerRunSettings
- AddDeviceWriteBps(this DockerContainerRunSettings toolSettings, string[] deviceWriteBps) : DockerContainerRunSettings
- AddDeviceWriteBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerRunSettings
- AddDeviceWriteIops(this DockerContainerRunSettings toolSettings, string[] deviceWriteIops) : DockerContainerRunSettings
- AddDeviceWriteIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerRunSettings
- AddDns(this DockerContainerRunSettings toolSettings, string[] dns) : DockerContainerRunSettings
- AddDns(this DockerContainerRunSettings toolSettings, IEnumerable<string> dns) : DockerContainerRunSettings
- AddDnsOpt(this DockerContainerRunSettings toolSettings, string[] dnsOpt) : DockerContainerRunSettings
- AddDnsOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerRunSettings
- AddDnsOption(this DockerContainerRunSettings toolSettings, string[] dnsOption) : DockerContainerRunSettings
- AddDnsOption(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerRunSettings
- AddDnsSearch(this DockerContainerRunSettings toolSettings, string[] dnsSearch) : DockerContainerRunSettings
- AddDnsSearch(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerRunSettings
- AddEnv(this DockerContainerRunSettings toolSettings, string[] env) : DockerContainerRunSettings
- AddEnv(this DockerContainerRunSettings toolSettings, IEnumerable<string> env) : DockerContainerRunSettings
- AddEnvFile(this DockerContainerRunSettings toolSettings, string[] envFile) : DockerContainerRunSettings
- AddEnvFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> envFile) : DockerContainerRunSettings
- AddExpose(this DockerContainerRunSettings toolSettings, string[] expose) : DockerContainerRunSettings
- AddExpose(this DockerContainerRunSettings toolSettings, IEnumerable<string> expose) : DockerContainerRunSettings
- AddGroupAdd(this DockerContainerRunSettings toolSettings, string[] groupAdd) : DockerContainerRunSettings
- AddGroupAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerRunSettings
- AddLabel(this DockerContainerRunSettings toolSettings, string[] label) : DockerContainerRunSettings
- AddLabel(this DockerContainerRunSettings toolSettings, IEnumerable<string> label) : DockerContainerRunSettings
- AddLabelFile(this DockerContainerRunSettings toolSettings, string[] labelFile) : DockerContainerRunSettings
- AddLabelFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerRunSettings
- AddLink(this DockerContainerRunSettings toolSettings, string[] link) : DockerContainerRunSettings
- AddLink(this DockerContainerRunSettings toolSettings, IEnumerable<string> link) : DockerContainerRunSettings
- AddLinkLocalIp(this DockerContainerRunSettings toolSettings, string[] linkLocalIp) : DockerContainerRunSettings
- AddLinkLocalIp(this DockerContainerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerRunSettings
- AddLogOpt(this DockerContainerRunSettings toolSettings, string[] logOpt) : DockerContainerRunSettings
- AddLogOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerRunSettings
- AddNetAlias(this DockerContainerRunSettings toolSettings, string[] netAlias) : DockerContainerRunSettings
- AddNetAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerRunSettings
- AddNetworkAlias(this DockerContainerRunSettings toolSettings, string[] networkAlias) : DockerContainerRunSettings
- AddNetworkAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerRunSettings
- AddPublish(this DockerContainerRunSettings toolSettings, string[] publish) : DockerContainerRunSettings
- AddPublish(this DockerContainerRunSettings toolSettings, IEnumerable<string> publish) : DockerContainerRunSettings
- AddSecurityOpt(this DockerContainerRunSettings toolSettings, string[] securityOpt) : DockerContainerRunSettings
- AddSecurityOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerRunSettings
- AddStorageOpt(this DockerContainerRunSettings toolSettings, string[] storageOpt) : DockerContainerRunSettings
- AddStorageOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerRunSettings
- AddSysctl(this DockerContainerRunSettings toolSettings, string sysctlKey, string sysctlValue) : DockerContainerRunSettings
- AddTmpfs(this DockerContainerRunSettings toolSettings, string[] tmpfs) : DockerContainerRunSettings
- AddTmpfs(this DockerContainerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerRunSettings
- AddVolume(this DockerContainerRunSettings toolSettings, string[] volume) : DockerContainerRunSettings
- AddVolume(this DockerContainerRunSettings toolSettings, IEnumerable<string> volume) : DockerContainerRunSettings
- AddVolumesFrom(this DockerContainerRunSettings toolSettings, string[] volumesFrom) : DockerContainerRunSettings
- AddVolumesFrom(this DockerContainerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerRunSettings
- ClearAddHost(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearArgs(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearAttach(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearBlkioWeightDevice(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearCapAdd(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearCapDrop(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDevice(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDeviceCgroupRule(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDeviceReadBps(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDeviceReadIops(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDeviceWriteBps(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDeviceWriteIops(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDns(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDnsOpt(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDnsOption(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearDnsSearch(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearEnv(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearEnvFile(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearExpose(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearGroupAdd(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearLabel(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearLabelFile(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearLink(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearLinkLocalIp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearLogOpt(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearNetAlias(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearNetworkAlias(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearPublish(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearSecurityOpt(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearStorageOpt(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearSysctl(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearTmpfs(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearVolume(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ClearVolumesFrom(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableDetach(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableDisableContentTrust(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableHelp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableInit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableInteractive(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableNoHealthcheck(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableOomKillDisable(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisablePrivileged(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisablePublishAll(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableReadOnly(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableRm(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableSigProxy(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- DisableTty(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableDetach(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableDisableContentTrust(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableHelp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableInit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableInteractive(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableNoHealthcheck(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableOomKillDisable(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnablePrivileged(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnablePublishAll(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableReadOnly(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableRm(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableSigProxy(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- EnableTty(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- RemoveAddHost(this DockerContainerRunSettings toolSettings, string[] addHost) : DockerContainerRunSettings
- RemoveAddHost(this DockerContainerRunSettings toolSettings, IEnumerable<string> addHost) : DockerContainerRunSettings
- RemoveArgs(this DockerContainerRunSettings toolSettings, string[] args) : DockerContainerRunSettings
- RemoveArgs(this DockerContainerRunSettings toolSettings, IEnumerable<string> args) : DockerContainerRunSettings
- RemoveAttach(this DockerContainerRunSettings toolSettings, string[] attach) : DockerContainerRunSettings
- RemoveAttach(this DockerContainerRunSettings toolSettings, IEnumerable<string> attach) : DockerContainerRunSettings
- RemoveBlkioWeightDevice(this DockerContainerRunSettings toolSettings, string[] blkioWeightDevice) : DockerContainerRunSettings
- RemoveBlkioWeightDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerRunSettings
- RemoveCapAdd(this DockerContainerRunSettings toolSettings, string[] capAdd) : DockerContainerRunSettings
- RemoveCapAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerRunSettings
- RemoveCapDrop(this DockerContainerRunSettings toolSettings, string[] capDrop) : DockerContainerRunSettings
- RemoveCapDrop(this DockerContainerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerRunSettings
- RemoveDevice(this DockerContainerRunSettings toolSettings, string[] device) : DockerContainerRunSettings
- RemoveDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> device) : DockerContainerRunSettings
- RemoveDeviceCgroupRule(this DockerContainerRunSettings toolSettings, string[] deviceCgroupRule) : DockerContainerRunSettings
- RemoveDeviceCgroupRule(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerRunSettings
- RemoveDeviceReadBps(this DockerContainerRunSettings toolSettings, string[] deviceReadBps) : DockerContainerRunSettings
- RemoveDeviceReadBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerRunSettings
- RemoveDeviceReadIops(this DockerContainerRunSettings toolSettings, string[] deviceReadIops) : DockerContainerRunSettings
- RemoveDeviceReadIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerRunSettings
- RemoveDeviceWriteBps(this DockerContainerRunSettings toolSettings, string[] deviceWriteBps) : DockerContainerRunSettings
- RemoveDeviceWriteBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerRunSettings
- RemoveDeviceWriteIops(this DockerContainerRunSettings toolSettings, string[] deviceWriteIops) : DockerContainerRunSettings
- RemoveDeviceWriteIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerRunSettings
- RemoveDns(this DockerContainerRunSettings toolSettings, string[] dns) : DockerContainerRunSettings
- RemoveDns(this DockerContainerRunSettings toolSettings, IEnumerable<string> dns) : DockerContainerRunSettings
- RemoveDnsOpt(this DockerContainerRunSettings toolSettings, string[] dnsOpt) : DockerContainerRunSettings
- RemoveDnsOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerRunSettings
- RemoveDnsOption(this DockerContainerRunSettings toolSettings, string[] dnsOption) : DockerContainerRunSettings
- RemoveDnsOption(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerRunSettings
- RemoveDnsSearch(this DockerContainerRunSettings toolSettings, string[] dnsSearch) : DockerContainerRunSettings
- RemoveDnsSearch(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerRunSettings
- RemoveEnv(this DockerContainerRunSettings toolSettings, string[] env) : DockerContainerRunSettings
- RemoveEnv(this DockerContainerRunSettings toolSettings, IEnumerable<string> env) : DockerContainerRunSettings
- RemoveEnvFile(this DockerContainerRunSettings toolSettings, string[] envFile) : DockerContainerRunSettings
- RemoveEnvFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> envFile) : DockerContainerRunSettings
- RemoveExpose(this DockerContainerRunSettings toolSettings, string[] expose) : DockerContainerRunSettings
- RemoveExpose(this DockerContainerRunSettings toolSettings, IEnumerable<string> expose) : DockerContainerRunSettings
- RemoveGroupAdd(this DockerContainerRunSettings toolSettings, string[] groupAdd) : DockerContainerRunSettings
- RemoveGroupAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerRunSettings
- RemoveLabel(this DockerContainerRunSettings toolSettings, string[] label) : DockerContainerRunSettings
- RemoveLabel(this DockerContainerRunSettings toolSettings, IEnumerable<string> label) : DockerContainerRunSettings
- RemoveLabelFile(this DockerContainerRunSettings toolSettings, string[] labelFile) : DockerContainerRunSettings
- RemoveLabelFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerRunSettings
- RemoveLink(this DockerContainerRunSettings toolSettings, string[] link) : DockerContainerRunSettings
- RemoveLink(this DockerContainerRunSettings toolSettings, IEnumerable<string> link) : DockerContainerRunSettings
- RemoveLinkLocalIp(this DockerContainerRunSettings toolSettings, string[] linkLocalIp) : DockerContainerRunSettings
- RemoveLinkLocalIp(this DockerContainerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerRunSettings
- RemoveLogOpt(this DockerContainerRunSettings toolSettings, string[] logOpt) : DockerContainerRunSettings
- RemoveLogOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerRunSettings
- RemoveNetAlias(this DockerContainerRunSettings toolSettings, string[] netAlias) : DockerContainerRunSettings
- RemoveNetAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerRunSettings
- RemoveNetworkAlias(this DockerContainerRunSettings toolSettings, string[] networkAlias) : DockerContainerRunSettings
- RemoveNetworkAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerRunSettings
- RemovePublish(this DockerContainerRunSettings toolSettings, string[] publish) : DockerContainerRunSettings
- RemovePublish(this DockerContainerRunSettings toolSettings, IEnumerable<string> publish) : DockerContainerRunSettings
- RemoveSecurityOpt(this DockerContainerRunSettings toolSettings, string[] securityOpt) : DockerContainerRunSettings
- RemoveSecurityOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerRunSettings
- RemoveStorageOpt(this DockerContainerRunSettings toolSettings, string[] storageOpt) : DockerContainerRunSettings
- RemoveStorageOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerRunSettings
- RemoveSysctl(this DockerContainerRunSettings toolSettings, string sysctlKey) : DockerContainerRunSettings
- RemoveTmpfs(this DockerContainerRunSettings toolSettings, string[] tmpfs) : DockerContainerRunSettings
- RemoveTmpfs(this DockerContainerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerRunSettings
- RemoveVolume(this DockerContainerRunSettings toolSettings, string[] volume) : DockerContainerRunSettings
- RemoveVolume(this DockerContainerRunSettings toolSettings, IEnumerable<string> volume) : DockerContainerRunSettings
- RemoveVolumesFrom(this DockerContainerRunSettings toolSettings, string[] volumesFrom) : DockerContainerRunSettings
- RemoveVolumesFrom(this DockerContainerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerRunSettings
- ResetBlkioWeight(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCgroupParent(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCidfile(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCommand(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuCount(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuPercent(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuPeriod(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuQuota(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuRtPeriod(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuRtRuntime(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpus(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpusetCpus(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpusetMems(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetCpuShares(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetDetach(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetDetachKeys(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetDisableContentTrust(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetDomainname(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetEntrypoint(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetGpus(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHealthCmd(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHealthInterval(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHealthRetries(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHealthStartPeriod(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHealthTimeout(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHelp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetHostname(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetImage(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetInit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetInteractive(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIoMaxbandwidth(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIoMaxiops(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIp6(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIpc(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetIsolation(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetKernelMemory(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetLogDriver(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMacAddress(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMemory(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMemoryReservation(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMemorySwap(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMemorySwappiness(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetMount(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetName(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetNet(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetNetwork(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetNoHealthcheck(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetOomKillDisable(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetOomScoreAdj(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetPid(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetPidsLimit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetPlatform(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetPrivileged(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetPublishAll(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetReadOnly(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetRestart(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetRm(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetRuntime(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetShmSize(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetSigProxy(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetStopSignal(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetStopTimeout(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetTty(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetUlimit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetUser(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetUserns(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetUts(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetVolumeDriver(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ResetWorkdir(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- SetAddHost(this DockerContainerRunSettings toolSettings, string[] addHost) : DockerContainerRunSettings
- SetAddHost(this DockerContainerRunSettings toolSettings, IEnumerable<string> addHost) : DockerContainerRunSettings
- SetArgs(this DockerContainerRunSettings toolSettings, string[] args) : DockerContainerRunSettings
- SetArgs(this DockerContainerRunSettings toolSettings, IEnumerable<string> args) : DockerContainerRunSettings
- SetAttach(this DockerContainerRunSettings toolSettings, string[] attach) : DockerContainerRunSettings
- SetAttach(this DockerContainerRunSettings toolSettings, IEnumerable<string> attach) : DockerContainerRunSettings
- SetBlkioWeight(this DockerContainerRunSettings toolSettings, int? blkioWeight) : DockerContainerRunSettings
- SetBlkioWeightDevice(this DockerContainerRunSettings toolSettings, string[] blkioWeightDevice) : DockerContainerRunSettings
- SetBlkioWeightDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerContainerRunSettings
- SetCapAdd(this DockerContainerRunSettings toolSettings, string[] capAdd) : DockerContainerRunSettings
- SetCapAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerContainerRunSettings
- SetCapDrop(this DockerContainerRunSettings toolSettings, string[] capDrop) : DockerContainerRunSettings
- SetCapDrop(this DockerContainerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerContainerRunSettings
- SetCgroupParent(this DockerContainerRunSettings toolSettings, string cgroupParent) : DockerContainerRunSettings
- SetCidfile(this DockerContainerRunSettings toolSettings, string cidfile) : DockerContainerRunSettings
- SetCommand(this DockerContainerRunSettings toolSettings, string command) : DockerContainerRunSettings
- SetCpuCount(this DockerContainerRunSettings toolSettings, long? cpuCount) : DockerContainerRunSettings
- SetCpuPercent(this DockerContainerRunSettings toolSettings, long? cpuPercent) : DockerContainerRunSettings
- SetCpuPeriod(this DockerContainerRunSettings toolSettings, long? cpuPeriod) : DockerContainerRunSettings
- SetCpuQuota(this DockerContainerRunSettings toolSettings, long? cpuQuota) : DockerContainerRunSettings
- SetCpuRtPeriod(this DockerContainerRunSettings toolSettings, long? cpuRtPeriod) : DockerContainerRunSettings
- SetCpuRtRuntime(this DockerContainerRunSettings toolSettings, long? cpuRtRuntime) : DockerContainerRunSettings
- SetCpus(this DockerContainerRunSettings toolSettings, decimal? cpus) : DockerContainerRunSettings
- SetCpusetCpus(this DockerContainerRunSettings toolSettings, string cpusetCpus) : DockerContainerRunSettings
- SetCpusetMems(this DockerContainerRunSettings toolSettings, string cpusetMems) : DockerContainerRunSettings
- SetCpuShares(this DockerContainerRunSettings toolSettings, long? cpuShares) : DockerContainerRunSettings
- SetDetach(this DockerContainerRunSettings toolSettings, bool? detach) : DockerContainerRunSettings
- SetDetachKeys(this DockerContainerRunSettings toolSettings, string detachKeys) : DockerContainerRunSettings
- SetDevice(this DockerContainerRunSettings toolSettings, string[] device) : DockerContainerRunSettings
- SetDevice(this DockerContainerRunSettings toolSettings, IEnumerable<string> device) : DockerContainerRunSettings
- SetDeviceCgroupRule(this DockerContainerRunSettings toolSettings, string[] deviceCgroupRule) : DockerContainerRunSettings
- SetDeviceCgroupRule(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerContainerRunSettings
- SetDeviceReadBps(this DockerContainerRunSettings toolSettings, string[] deviceReadBps) : DockerContainerRunSettings
- SetDeviceReadBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerContainerRunSettings
- SetDeviceReadIops(this DockerContainerRunSettings toolSettings, string[] deviceReadIops) : DockerContainerRunSettings
- SetDeviceReadIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerContainerRunSettings
- SetDeviceWriteBps(this DockerContainerRunSettings toolSettings, string[] deviceWriteBps) : DockerContainerRunSettings
- SetDeviceWriteBps(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerContainerRunSettings
- SetDeviceWriteIops(this DockerContainerRunSettings toolSettings, string[] deviceWriteIops) : DockerContainerRunSettings
- SetDeviceWriteIops(this DockerContainerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerContainerRunSettings
- SetDisableContentTrust(this DockerContainerRunSettings toolSettings, bool? disableContentTrust) : DockerContainerRunSettings
- SetDns(this DockerContainerRunSettings toolSettings, string[] dns) : DockerContainerRunSettings
- SetDns(this DockerContainerRunSettings toolSettings, IEnumerable<string> dns) : DockerContainerRunSettings
- SetDnsOpt(this DockerContainerRunSettings toolSettings, string[] dnsOpt) : DockerContainerRunSettings
- SetDnsOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerContainerRunSettings
- SetDnsOption(this DockerContainerRunSettings toolSettings, string[] dnsOption) : DockerContainerRunSettings
- SetDnsOption(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerContainerRunSettings
- SetDnsSearch(this DockerContainerRunSettings toolSettings, string[] dnsSearch) : DockerContainerRunSettings
- SetDnsSearch(this DockerContainerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerContainerRunSettings
- SetDomainname(this DockerContainerRunSettings toolSettings, string domainname) : DockerContainerRunSettings
- SetEntrypoint(this DockerContainerRunSettings toolSettings, string entrypoint) : DockerContainerRunSettings
- SetEnv(this DockerContainerRunSettings toolSettings, string[] env) : DockerContainerRunSettings
- SetEnv(this DockerContainerRunSettings toolSettings, IEnumerable<string> env) : DockerContainerRunSettings
- SetEnvFile(this DockerContainerRunSettings toolSettings, string[] envFile) : DockerContainerRunSettings
- SetEnvFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> envFile) : DockerContainerRunSettings
- SetExpose(this DockerContainerRunSettings toolSettings, string[] expose) : DockerContainerRunSettings
- SetExpose(this DockerContainerRunSettings toolSettings, IEnumerable<string> expose) : DockerContainerRunSettings
- SetGpus(this DockerContainerRunSettings toolSettings, string gpus) : DockerContainerRunSettings
- SetGroupAdd(this DockerContainerRunSettings toolSettings, string[] groupAdd) : DockerContainerRunSettings
- SetGroupAdd(this DockerContainerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerContainerRunSettings
- SetHealthCmd(this DockerContainerRunSettings toolSettings, string healthCmd) : DockerContainerRunSettings
- SetHealthInterval(this DockerContainerRunSettings toolSettings, string healthInterval) : DockerContainerRunSettings
- SetHealthRetries(this DockerContainerRunSettings toolSettings, int? healthRetries) : DockerContainerRunSettings
- SetHealthStartPeriod(this DockerContainerRunSettings toolSettings, string healthStartPeriod) : DockerContainerRunSettings
- SetHealthTimeout(this DockerContainerRunSettings toolSettings, string healthTimeout) : DockerContainerRunSettings
- SetHelp(this DockerContainerRunSettings toolSettings, bool? help) : DockerContainerRunSettings
- SetHostname(this DockerContainerRunSettings toolSettings, string hostname) : DockerContainerRunSettings
- SetImage(this DockerContainerRunSettings toolSettings, string image) : DockerContainerRunSettings
- SetInit(this DockerContainerRunSettings toolSettings, bool? init) : DockerContainerRunSettings
- SetInteractive(this DockerContainerRunSettings toolSettings, bool? interactive) : DockerContainerRunSettings
- SetIoMaxbandwidth(this DockerContainerRunSettings toolSettings, long? ioMaxbandwidth) : DockerContainerRunSettings
- SetIoMaxiops(this DockerContainerRunSettings toolSettings, int? ioMaxiops) : DockerContainerRunSettings
- SetIp(this DockerContainerRunSettings toolSettings, string ip) : DockerContainerRunSettings
- SetIp6(this DockerContainerRunSettings toolSettings, string ip6) : DockerContainerRunSettings
- SetIpc(this DockerContainerRunSettings toolSettings, string ipc) : DockerContainerRunSettings
- SetIsolation(this DockerContainerRunSettings toolSettings, string isolation) : DockerContainerRunSettings
- SetKernelMemory(this DockerContainerRunSettings toolSettings, long? kernelMemory) : DockerContainerRunSettings
- SetLabel(this DockerContainerRunSettings toolSettings, string[] label) : DockerContainerRunSettings
- SetLabel(this DockerContainerRunSettings toolSettings, IEnumerable<string> label) : DockerContainerRunSettings
- SetLabelFile(this DockerContainerRunSettings toolSettings, string[] labelFile) : DockerContainerRunSettings
- SetLabelFile(this DockerContainerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerContainerRunSettings
- SetLink(this DockerContainerRunSettings toolSettings, string[] link) : DockerContainerRunSettings
- SetLink(this DockerContainerRunSettings toolSettings, IEnumerable<string> link) : DockerContainerRunSettings
- SetLinkLocalIp(this DockerContainerRunSettings toolSettings, string[] linkLocalIp) : DockerContainerRunSettings
- SetLinkLocalIp(this DockerContainerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerContainerRunSettings
- SetLogDriver(this DockerContainerRunSettings toolSettings, string logDriver) : DockerContainerRunSettings
- SetLogOpt(this DockerContainerRunSettings toolSettings, string[] logOpt) : DockerContainerRunSettings
- SetLogOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerContainerRunSettings
- SetMacAddress(this DockerContainerRunSettings toolSettings, string macAddress) : DockerContainerRunSettings
- SetMemory(this DockerContainerRunSettings toolSettings, long? memory) : DockerContainerRunSettings
- SetMemoryReservation(this DockerContainerRunSettings toolSettings, long? memoryReservation) : DockerContainerRunSettings
- SetMemorySwap(this DockerContainerRunSettings toolSettings, long? memorySwap) : DockerContainerRunSettings
- SetMemorySwappiness(this DockerContainerRunSettings toolSettings, long? memorySwappiness) : DockerContainerRunSettings
- SetMount(this DockerContainerRunSettings toolSettings, string mount) : DockerContainerRunSettings
- SetName(this DockerContainerRunSettings toolSettings, string name) : DockerContainerRunSettings
- SetNet(this DockerContainerRunSettings toolSettings, string net) : DockerContainerRunSettings
- SetNetAlias(this DockerContainerRunSettings toolSettings, string[] netAlias) : DockerContainerRunSettings
- SetNetAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerContainerRunSettings
- SetNetwork(this DockerContainerRunSettings toolSettings, string network) : DockerContainerRunSettings
- SetNetworkAlias(this DockerContainerRunSettings toolSettings, string[] networkAlias) : DockerContainerRunSettings
- SetNetworkAlias(this DockerContainerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerContainerRunSettings
- SetNoHealthcheck(this DockerContainerRunSettings toolSettings, bool? noHealthcheck) : DockerContainerRunSettings
- SetOomKillDisable(this DockerContainerRunSettings toolSettings, bool? oomKillDisable) : DockerContainerRunSettings
- SetOomScoreAdj(this DockerContainerRunSettings toolSettings, int? oomScoreAdj) : DockerContainerRunSettings
- SetPid(this DockerContainerRunSettings toolSettings, string pid) : DockerContainerRunSettings
- SetPidsLimit(this DockerContainerRunSettings toolSettings, long? pidsLimit) : DockerContainerRunSettings
- SetPlatform(this DockerContainerRunSettings toolSettings, string platform) : DockerContainerRunSettings
- SetPrivileged(this DockerContainerRunSettings toolSettings, bool? privileged) : DockerContainerRunSettings
- SetPublish(this DockerContainerRunSettings toolSettings, string[] publish) : DockerContainerRunSettings
- SetPublish(this DockerContainerRunSettings toolSettings, IEnumerable<string> publish) : DockerContainerRunSettings
- SetPublishAll(this DockerContainerRunSettings toolSettings, bool? publishAll) : DockerContainerRunSettings
- SetReadOnly(this DockerContainerRunSettings toolSettings, bool? readOnly) : DockerContainerRunSettings
- SetRestart(this DockerContainerRunSettings toolSettings, string restart) : DockerContainerRunSettings
- SetRm(this DockerContainerRunSettings toolSettings, bool? rm) : DockerContainerRunSettings
- SetRuntime(this DockerContainerRunSettings toolSettings, string runtime) : DockerContainerRunSettings
- SetSecurityOpt(this DockerContainerRunSettings toolSettings, string[] securityOpt) : DockerContainerRunSettings
- SetSecurityOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerContainerRunSettings
- SetShmSize(this DockerContainerRunSettings toolSettings, long? shmSize) : DockerContainerRunSettings
- SetSigProxy(this DockerContainerRunSettings toolSettings, bool? sigProxy) : DockerContainerRunSettings
- SetStopSignal(this DockerContainerRunSettings toolSettings, string stopSignal) : DockerContainerRunSettings
- SetStopTimeout(this DockerContainerRunSettings toolSettings, int? stopTimeout) : DockerContainerRunSettings
- SetStorageOpt(this DockerContainerRunSettings toolSettings, string[] storageOpt) : DockerContainerRunSettings
- SetStorageOpt(this DockerContainerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerContainerRunSettings
- SetSysctl(this DockerContainerRunSettings toolSettings, IDictionary<string, string> sysctl) : DockerContainerRunSettings
- SetSysctl(this DockerContainerRunSettings toolSettings, string sysctlKey, string sysctlValue) : DockerContainerRunSettings
- SetTmpfs(this DockerContainerRunSettings toolSettings, string[] tmpfs) : DockerContainerRunSettings
- SetTmpfs(this DockerContainerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerContainerRunSettings
- SetTty(this DockerContainerRunSettings toolSettings, bool? tty) : DockerContainerRunSettings
- SetUlimit(this DockerContainerRunSettings toolSettings, string ulimit) : DockerContainerRunSettings
- SetUser(this DockerContainerRunSettings toolSettings, string user) : DockerContainerRunSettings
- SetUserns(this DockerContainerRunSettings toolSettings, string userns) : DockerContainerRunSettings
- SetUts(this DockerContainerRunSettings toolSettings, string uts) : DockerContainerRunSettings
- SetVolume(this DockerContainerRunSettings toolSettings, string[] volume) : DockerContainerRunSettings
- SetVolume(this DockerContainerRunSettings toolSettings, IEnumerable<string> volume) : DockerContainerRunSettings
- SetVolumeDriver(this DockerContainerRunSettings toolSettings, string volumeDriver) : DockerContainerRunSettings
- SetVolumesFrom(this DockerContainerRunSettings toolSettings, string[] volumesFrom) : DockerContainerRunSettings
- SetVolumesFrom(this DockerContainerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerContainerRunSettings
- SetWorkdir(this DockerContainerRunSettings toolSettings, string workdir) : DockerContainerRunSettings
- ToggleDetach(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleDisableContentTrust(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleHelp(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleInit(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleInteractive(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleNoHealthcheck(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleOomKillDisable(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- TogglePrivileged(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- TogglePublishAll(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleReadOnly(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleRm(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleSigProxy(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings
- ToggleTty(this DockerContainerRunSettings toolSettings) : DockerContainerRunSettings

### Nuke.Common.Tools.Docker.DockerContainerSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerSettingsExtensions


### Nuke.Common.Tools.Docker.DockerContainerStartSettings

- .ctor()
- get_Attach() : bool?
- get_Checkpoint() : string
- get_CheckpointDir() : string
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_DetachKeys() : string
- get_Interactive() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerStartSettingsExtensions

- AddContainers(this DockerContainerStartSettings toolSettings, string[] containers) : DockerContainerStartSettings
- AddContainers(this DockerContainerStartSettings toolSettings, IEnumerable<string> containers) : DockerContainerStartSettings
- ClearContainers(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- DisableAttach(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- DisableInteractive(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- EnableAttach(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- EnableInteractive(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- RemoveContainers(this DockerContainerStartSettings toolSettings, string[] containers) : DockerContainerStartSettings
- RemoveContainers(this DockerContainerStartSettings toolSettings, IEnumerable<string> containers) : DockerContainerStartSettings
- ResetAttach(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- ResetCheckpoint(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- ResetCheckpointDir(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- ResetDetachKeys(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- ResetInteractive(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- SetAttach(this DockerContainerStartSettings toolSettings, bool? attach) : DockerContainerStartSettings
- SetCheckpoint(this DockerContainerStartSettings toolSettings, string checkpoint) : DockerContainerStartSettings
- SetCheckpointDir(this DockerContainerStartSettings toolSettings, string checkpointDir) : DockerContainerStartSettings
- SetContainers(this DockerContainerStartSettings toolSettings, string[] containers) : DockerContainerStartSettings
- SetContainers(this DockerContainerStartSettings toolSettings, IEnumerable<string> containers) : DockerContainerStartSettings
- SetDetachKeys(this DockerContainerStartSettings toolSettings, string detachKeys) : DockerContainerStartSettings
- SetInteractive(this DockerContainerStartSettings toolSettings, bool? interactive) : DockerContainerStartSettings
- ToggleAttach(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings
- ToggleInteractive(this DockerContainerStartSettings toolSettings) : DockerContainerStartSettings

### Nuke.Common.Tools.Docker.DockerContainerStatsSettings

- .ctor()
- get_All() : bool?
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_NoStream() : bool?
- get_NoTrunc() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerStatsSettingsExtensions

- AddContainers(this DockerContainerStatsSettings toolSettings, string[] containers) : DockerContainerStatsSettings
- AddContainers(this DockerContainerStatsSettings toolSettings, IEnumerable<string> containers) : DockerContainerStatsSettings
- ClearContainers(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- DisableAll(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- DisableNoStream(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- DisableNoTrunc(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- EnableAll(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- EnableNoStream(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- EnableNoTrunc(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- RemoveContainers(this DockerContainerStatsSettings toolSettings, string[] containers) : DockerContainerStatsSettings
- RemoveContainers(this DockerContainerStatsSettings toolSettings, IEnumerable<string> containers) : DockerContainerStatsSettings
- ResetAll(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- ResetFormat(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- ResetNoStream(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- ResetNoTrunc(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- SetAll(this DockerContainerStatsSettings toolSettings, bool? all) : DockerContainerStatsSettings
- SetContainers(this DockerContainerStatsSettings toolSettings, string[] containers) : DockerContainerStatsSettings
- SetContainers(this DockerContainerStatsSettings toolSettings, IEnumerable<string> containers) : DockerContainerStatsSettings
- SetFormat(this DockerContainerStatsSettings toolSettings, string format) : DockerContainerStatsSettings
- SetNoStream(this DockerContainerStatsSettings toolSettings, bool? noStream) : DockerContainerStatsSettings
- SetNoTrunc(this DockerContainerStatsSettings toolSettings, bool? noTrunc) : DockerContainerStatsSettings
- ToggleAll(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- ToggleNoStream(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings
- ToggleNoTrunc(this DockerContainerStatsSettings toolSettings) : DockerContainerStatsSettings

### Nuke.Common.Tools.Docker.DockerContainerStopSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Time() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerStopSettingsExtensions

- AddContainers(this DockerContainerStopSettings toolSettings, string[] containers) : DockerContainerStopSettings
- AddContainers(this DockerContainerStopSettings toolSettings, IEnumerable<string> containers) : DockerContainerStopSettings
- ClearContainers(this DockerContainerStopSettings toolSettings) : DockerContainerStopSettings
- RemoveContainers(this DockerContainerStopSettings toolSettings, string[] containers) : DockerContainerStopSettings
- RemoveContainers(this DockerContainerStopSettings toolSettings, IEnumerable<string> containers) : DockerContainerStopSettings
- ResetTime(this DockerContainerStopSettings toolSettings) : DockerContainerStopSettings
- SetContainers(this DockerContainerStopSettings toolSettings, string[] containers) : DockerContainerStopSettings
- SetContainers(this DockerContainerStopSettings toolSettings, IEnumerable<string> containers) : DockerContainerStopSettings
- SetTime(this DockerContainerStopSettings toolSettings, int? time) : DockerContainerStopSettings

### Nuke.Common.Tools.Docker.DockerContainerTopSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Options() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerTopSettingsExtensions

- ResetContainer(this DockerContainerTopSettings toolSettings) : DockerContainerTopSettings
- ResetOptions(this DockerContainerTopSettings toolSettings) : DockerContainerTopSettings
- SetContainer(this DockerContainerTopSettings toolSettings, string container) : DockerContainerTopSettings
- SetOptions(this DockerContainerTopSettings toolSettings, string options) : DockerContainerTopSettings

### Nuke.Common.Tools.Docker.DockerContainerUnpauseSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerUnpauseSettingsExtensions

- AddContainers(this DockerContainerUnpauseSettings toolSettings, string[] containers) : DockerContainerUnpauseSettings
- AddContainers(this DockerContainerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerUnpauseSettings
- ClearContainers(this DockerContainerUnpauseSettings toolSettings) : DockerContainerUnpauseSettings
- RemoveContainers(this DockerContainerUnpauseSettings toolSettings, string[] containers) : DockerContainerUnpauseSettings
- RemoveContainers(this DockerContainerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerUnpauseSettings
- SetContainers(this DockerContainerUnpauseSettings toolSettings, string[] containers) : DockerContainerUnpauseSettings
- SetContainers(this DockerContainerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerContainerUnpauseSettings

### Nuke.Common.Tools.Docker.DockerContainerUpdateSettings

- .ctor()
- get_BlkioWeight() : int?
- get_Containers() : IReadOnlyList<string>
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_KernelMemory() : long?
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_PidsLimit() : long?
- get_Restart() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerUpdateSettingsExtensions

- AddContainers(this DockerContainerUpdateSettings toolSettings, string[] containers) : DockerContainerUpdateSettings
- AddContainers(this DockerContainerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerContainerUpdateSettings
- ClearContainers(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- RemoveContainers(this DockerContainerUpdateSettings toolSettings, string[] containers) : DockerContainerUpdateSettings
- RemoveContainers(this DockerContainerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerContainerUpdateSettings
- ResetBlkioWeight(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpuPeriod(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpuQuota(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpuRtPeriod(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpuRtRuntime(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpus(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpusetCpus(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpusetMems(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetCpuShares(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetKernelMemory(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetMemory(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetMemoryReservation(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetMemorySwap(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetPidsLimit(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- ResetRestart(this DockerContainerUpdateSettings toolSettings) : DockerContainerUpdateSettings
- SetBlkioWeight(this DockerContainerUpdateSettings toolSettings, int? blkioWeight) : DockerContainerUpdateSettings
- SetContainers(this DockerContainerUpdateSettings toolSettings, string[] containers) : DockerContainerUpdateSettings
- SetContainers(this DockerContainerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerContainerUpdateSettings
- SetCpuPeriod(this DockerContainerUpdateSettings toolSettings, long? cpuPeriod) : DockerContainerUpdateSettings
- SetCpuQuota(this DockerContainerUpdateSettings toolSettings, long? cpuQuota) : DockerContainerUpdateSettings
- SetCpuRtPeriod(this DockerContainerUpdateSettings toolSettings, long? cpuRtPeriod) : DockerContainerUpdateSettings
- SetCpuRtRuntime(this DockerContainerUpdateSettings toolSettings, long? cpuRtRuntime) : DockerContainerUpdateSettings
- SetCpus(this DockerContainerUpdateSettings toolSettings, decimal? cpus) : DockerContainerUpdateSettings
- SetCpusetCpus(this DockerContainerUpdateSettings toolSettings, string cpusetCpus) : DockerContainerUpdateSettings
- SetCpusetMems(this DockerContainerUpdateSettings toolSettings, string cpusetMems) : DockerContainerUpdateSettings
- SetCpuShares(this DockerContainerUpdateSettings toolSettings, long? cpuShares) : DockerContainerUpdateSettings
- SetKernelMemory(this DockerContainerUpdateSettings toolSettings, long? kernelMemory) : DockerContainerUpdateSettings
- SetMemory(this DockerContainerUpdateSettings toolSettings, long? memory) : DockerContainerUpdateSettings
- SetMemoryReservation(this DockerContainerUpdateSettings toolSettings, long? memoryReservation) : DockerContainerUpdateSettings
- SetMemorySwap(this DockerContainerUpdateSettings toolSettings, long? memorySwap) : DockerContainerUpdateSettings
- SetPidsLimit(this DockerContainerUpdateSettings toolSettings, long? pidsLimit) : DockerContainerUpdateSettings
- SetRestart(this DockerContainerUpdateSettings toolSettings, string restart) : DockerContainerUpdateSettings

### Nuke.Common.Tools.Docker.DockerContainerWaitSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContainerWaitSettingsExtensions

- AddContainers(this DockerContainerWaitSettings toolSettings, string[] containers) : DockerContainerWaitSettings
- AddContainers(this DockerContainerWaitSettings toolSettings, IEnumerable<string> containers) : DockerContainerWaitSettings
- ClearContainers(this DockerContainerWaitSettings toolSettings) : DockerContainerWaitSettings
- RemoveContainers(this DockerContainerWaitSettings toolSettings, string[] containers) : DockerContainerWaitSettings
- RemoveContainers(this DockerContainerWaitSettings toolSettings, IEnumerable<string> containers) : DockerContainerWaitSettings
- SetContainers(this DockerContainerWaitSettings toolSettings, string[] containers) : DockerContainerWaitSettings
- SetContainers(this DockerContainerWaitSettings toolSettings, IEnumerable<string> containers) : DockerContainerWaitSettings

### Nuke.Common.Tools.Docker.DockerContextCreateSettings

- .ctor()
- get_Context() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DefaultStackOrchestrator() : string
- get_Description() : string
- get_Docker() : string
- get_From() : string
- get_Kubernetes() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextCreateSettingsExtensions

- ResetContext(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- ResetDefaultStackOrchestrator(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- ResetDescription(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- ResetDocker(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- ResetFrom(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- ResetKubernetes(this DockerContextCreateSettings toolSettings) : DockerContextCreateSettings
- SetContext(this DockerContextCreateSettings toolSettings, string context) : DockerContextCreateSettings
- SetDefaultStackOrchestrator(this DockerContextCreateSettings toolSettings, string defaultStackOrchestrator) : DockerContextCreateSettings
- SetDescription(this DockerContextCreateSettings toolSettings, string description) : DockerContextCreateSettings
- SetDocker(this DockerContextCreateSettings toolSettings, string docker) : DockerContextCreateSettings
- SetFrom(this DockerContextCreateSettings toolSettings, string from) : DockerContextCreateSettings
- SetKubernetes(this DockerContextCreateSettings toolSettings, string kubernetes) : DockerContextCreateSettings

### Nuke.Common.Tools.Docker.DockerContextExportSettings

- .ctor()
- get_Context() : string
- get_CustomLogger() : Action<OutputType, string>
- get_File() : string
- get_Kubeconfig() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextExportSettingsExtensions

- DisableKubeconfig(this DockerContextExportSettings toolSettings) : DockerContextExportSettings
- EnableKubeconfig(this DockerContextExportSettings toolSettings) : DockerContextExportSettings
- ResetContext(this DockerContextExportSettings toolSettings) : DockerContextExportSettings
- ResetFile(this DockerContextExportSettings toolSettings) : DockerContextExportSettings
- ResetKubeconfig(this DockerContextExportSettings toolSettings) : DockerContextExportSettings
- SetContext(this DockerContextExportSettings toolSettings, string context) : DockerContextExportSettings
- SetFile(this DockerContextExportSettings toolSettings, string file) : DockerContextExportSettings
- SetKubeconfig(this DockerContextExportSettings toolSettings, bool? kubeconfig) : DockerContextExportSettings
- ToggleKubeconfig(this DockerContextExportSettings toolSettings) : DockerContextExportSettings

### Nuke.Common.Tools.Docker.DockerContextImportSettings

- .ctor()
- get_Context() : string
- get_CustomLogger() : Action<OutputType, string>
- get_File() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextImportSettingsExtensions

- ResetContext(this DockerContextImportSettings toolSettings) : DockerContextImportSettings
- ResetFile(this DockerContextImportSettings toolSettings) : DockerContextImportSettings
- SetContext(this DockerContextImportSettings toolSettings, string context) : DockerContextImportSettings
- SetFile(this DockerContextImportSettings toolSettings, string file) : DockerContextImportSettings

### Nuke.Common.Tools.Docker.DockerContextInspectSettings

- .ctor()
- get_Context() : string
- get_Contexts() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextInspectSettingsExtensions

- AddContexts(this DockerContextInspectSettings toolSettings, string[] contexts) : DockerContextInspectSettings
- AddContexts(this DockerContextInspectSettings toolSettings, IEnumerable<string> contexts) : DockerContextInspectSettings
- ClearContexts(this DockerContextInspectSettings toolSettings) : DockerContextInspectSettings
- RemoveContexts(this DockerContextInspectSettings toolSettings, string[] contexts) : DockerContextInspectSettings
- RemoveContexts(this DockerContextInspectSettings toolSettings, IEnumerable<string> contexts) : DockerContextInspectSettings
- ResetContext(this DockerContextInspectSettings toolSettings) : DockerContextInspectSettings
- ResetFormat(this DockerContextInspectSettings toolSettings) : DockerContextInspectSettings
- SetContext(this DockerContextInspectSettings toolSettings, string context) : DockerContextInspectSettings
- SetContexts(this DockerContextInspectSettings toolSettings, string[] contexts) : DockerContextInspectSettings
- SetContexts(this DockerContextInspectSettings toolSettings, IEnumerable<string> contexts) : DockerContextInspectSettings
- SetFormat(this DockerContextInspectSettings toolSettings, string format) : DockerContextInspectSettings

### Nuke.Common.Tools.Docker.DockerContextLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextLsSettingsExtensions

- DisableQuiet(this DockerContextLsSettings toolSettings) : DockerContextLsSettings
- EnableQuiet(this DockerContextLsSettings toolSettings) : DockerContextLsSettings
- ResetFormat(this DockerContextLsSettings toolSettings) : DockerContextLsSettings
- ResetQuiet(this DockerContextLsSettings toolSettings) : DockerContextLsSettings
- SetFormat(this DockerContextLsSettings toolSettings, string format) : DockerContextLsSettings
- SetQuiet(this DockerContextLsSettings toolSettings, bool? quiet) : DockerContextLsSettings
- ToggleQuiet(this DockerContextLsSettings toolSettings) : DockerContextLsSettings

### Nuke.Common.Tools.Docker.DockerContextRmSettings

- .ctor()
- get_Contexts() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextRmSettingsExtensions

- AddContexts(this DockerContextRmSettings toolSettings, string[] contexts) : DockerContextRmSettings
- AddContexts(this DockerContextRmSettings toolSettings, IEnumerable<string> contexts) : DockerContextRmSettings
- ClearContexts(this DockerContextRmSettings toolSettings) : DockerContextRmSettings
- RemoveContexts(this DockerContextRmSettings toolSettings, string[] contexts) : DockerContextRmSettings
- RemoveContexts(this DockerContextRmSettings toolSettings, IEnumerable<string> contexts) : DockerContextRmSettings
- SetContexts(this DockerContextRmSettings toolSettings, string[] contexts) : DockerContextRmSettings
- SetContexts(this DockerContextRmSettings toolSettings, IEnumerable<string> contexts) : DockerContextRmSettings

### Nuke.Common.Tools.Docker.DockerContextSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextSettingsExtensions


### Nuke.Common.Tools.Docker.DockerContextUpdateSettings

- .ctor()
- get_Context() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DefaultStackOrchestrator() : string
- get_Description() : string
- get_Docker() : string
- get_Kubernetes() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextUpdateSettingsExtensions

- ResetContext(this DockerContextUpdateSettings toolSettings) : DockerContextUpdateSettings
- ResetDefaultStackOrchestrator(this DockerContextUpdateSettings toolSettings) : DockerContextUpdateSettings
- ResetDescription(this DockerContextUpdateSettings toolSettings) : DockerContextUpdateSettings
- ResetDocker(this DockerContextUpdateSettings toolSettings) : DockerContextUpdateSettings
- ResetKubernetes(this DockerContextUpdateSettings toolSettings) : DockerContextUpdateSettings
- SetContext(this DockerContextUpdateSettings toolSettings, string context) : DockerContextUpdateSettings
- SetDefaultStackOrchestrator(this DockerContextUpdateSettings toolSettings, string defaultStackOrchestrator) : DockerContextUpdateSettings
- SetDescription(this DockerContextUpdateSettings toolSettings, string description) : DockerContextUpdateSettings
- SetDocker(this DockerContextUpdateSettings toolSettings, string docker) : DockerContextUpdateSettings
- SetKubernetes(this DockerContextUpdateSettings toolSettings, string kubernetes) : DockerContextUpdateSettings

### Nuke.Common.Tools.Docker.DockerContextUseSettings

- .ctor()
- get_Context() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerContextUseSettingsExtensions

- ResetContext(this DockerContextUseSettings toolSettings) : DockerContextUseSettings
- SetContext(this DockerContextUseSettings toolSettings, string context) : DockerContextUseSettings

### Nuke.Common.Tools.Docker.DockerCreateSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_Args() : IReadOnlyList<string>
- get_Attach() : IReadOnlyList<string>
- get_BlkioWeight() : int?
- get_BlkioWeightDevice() : IReadOnlyList<string>
- get_CapAdd() : IReadOnlyList<string>
- get_CapDrop() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Cidfile() : string
- get_Command() : string
- get_CpuCount() : long?
- get_CpuPercent() : long?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_Device() : IReadOnlyList<string>
- get_DeviceCgroupRule() : IReadOnlyList<string>
- get_DeviceReadBps() : IReadOnlyList<string>
- get_DeviceReadIops() : IReadOnlyList<string>
- get_DeviceWriteBps() : IReadOnlyList<string>
- get_DeviceWriteIops() : IReadOnlyList<string>
- get_DisableContentTrust() : bool?
- get_Dns() : IReadOnlyList<string>
- get_DnsOpt() : IReadOnlyList<string>
- get_DnsOption() : IReadOnlyList<string>
- get_DnsSearch() : IReadOnlyList<string>
- get_Domainname() : string
- get_Entrypoint() : string
- get_Env() : IReadOnlyList<string>
- get_EnvFile() : IReadOnlyList<string>
- get_Expose() : IReadOnlyList<string>
- get_Gpus() : string
- get_GroupAdd() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_Help() : bool?
- get_Hostname() : string
- get_Image() : string
- get_Init() : bool?
- get_Interactive() : bool?
- get_IoMaxbandwidth() : long?
- get_IoMaxiops() : int?
- get_Ip() : string
- get_Ip6() : string
- get_Ipc() : string
- get_Isolation() : string
- get_KernelMemory() : long?
- get_Label() : IReadOnlyList<string>
- get_LabelFile() : IReadOnlyList<string>
- get_Link() : IReadOnlyList<string>
- get_LinkLocalIp() : IReadOnlyList<string>
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_MacAddress() : string
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_MemorySwappiness() : long?
- get_Mount() : string
- get_Name() : string
- get_Net() : string
- get_NetAlias() : IReadOnlyList<string>
- get_Network() : string
- get_NetworkAlias() : IReadOnlyList<string>
- get_NoHealthcheck() : bool?
- get_OomKillDisable() : bool?
- get_OomScoreAdj() : int?
- get_Pid() : string
- get_PidsLimit() : long?
- get_Platform() : string
- get_Privileged() : bool?
- get_Publish() : IReadOnlyList<string>
- get_PublishAll() : bool?
- get_ReadOnly() : bool?
- get_Restart() : string
- get_Rm() : bool?
- get_Runtime() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_StopSignal() : string
- get_StopTimeout() : int?
- get_StorageOpt() : IReadOnlyList<string>
- get_Sysctl() : IReadOnlyDictionary<string, string>
- get_Tmpfs() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_Ulimit() : string
- get_User() : string
- get_Userns() : string
- get_Uts() : string
- get_Volume() : IReadOnlyList<string>
- get_VolumeDriver() : string
- get_VolumesFrom() : IReadOnlyList<string>
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerCreateSettingsExtensions

- AddAddHost(this DockerCreateSettings toolSettings, string[] addHost) : DockerCreateSettings
- AddAddHost(this DockerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerCreateSettings
- AddArgs(this DockerCreateSettings toolSettings, string[] args) : DockerCreateSettings
- AddArgs(this DockerCreateSettings toolSettings, IEnumerable<string> args) : DockerCreateSettings
- AddAttach(this DockerCreateSettings toolSettings, string[] attach) : DockerCreateSettings
- AddAttach(this DockerCreateSettings toolSettings, IEnumerable<string> attach) : DockerCreateSettings
- AddBlkioWeightDevice(this DockerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerCreateSettings
- AddBlkioWeightDevice(this DockerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerCreateSettings
- AddCapAdd(this DockerCreateSettings toolSettings, string[] capAdd) : DockerCreateSettings
- AddCapAdd(this DockerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerCreateSettings
- AddCapDrop(this DockerCreateSettings toolSettings, string[] capDrop) : DockerCreateSettings
- AddCapDrop(this DockerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerCreateSettings
- AddDevice(this DockerCreateSettings toolSettings, string[] device) : DockerCreateSettings
- AddDevice(this DockerCreateSettings toolSettings, IEnumerable<string> device) : DockerCreateSettings
- AddDeviceCgroupRule(this DockerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerCreateSettings
- AddDeviceCgroupRule(this DockerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerCreateSettings
- AddDeviceReadBps(this DockerCreateSettings toolSettings, string[] deviceReadBps) : DockerCreateSettings
- AddDeviceReadBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerCreateSettings
- AddDeviceReadIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerCreateSettings
- AddDeviceReadIops(this DockerCreateSettings toolSettings, string[] deviceReadIops) : DockerCreateSettings
- AddDeviceWriteBps(this DockerCreateSettings toolSettings, string[] deviceWriteBps) : DockerCreateSettings
- AddDeviceWriteBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerCreateSettings
- AddDeviceWriteIops(this DockerCreateSettings toolSettings, string[] deviceWriteIops) : DockerCreateSettings
- AddDeviceWriteIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerCreateSettings
- AddDns(this DockerCreateSettings toolSettings, string[] dns) : DockerCreateSettings
- AddDns(this DockerCreateSettings toolSettings, IEnumerable<string> dns) : DockerCreateSettings
- AddDnsOpt(this DockerCreateSettings toolSettings, string[] dnsOpt) : DockerCreateSettings
- AddDnsOpt(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerCreateSettings
- AddDnsOption(this DockerCreateSettings toolSettings, string[] dnsOption) : DockerCreateSettings
- AddDnsOption(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerCreateSettings
- AddDnsSearch(this DockerCreateSettings toolSettings, string[] dnsSearch) : DockerCreateSettings
- AddDnsSearch(this DockerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerCreateSettings
- AddEnv(this DockerCreateSettings toolSettings, string[] env) : DockerCreateSettings
- AddEnv(this DockerCreateSettings toolSettings, IEnumerable<string> env) : DockerCreateSettings
- AddEnvFile(this DockerCreateSettings toolSettings, string[] envFile) : DockerCreateSettings
- AddEnvFile(this DockerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerCreateSettings
- AddExpose(this DockerCreateSettings toolSettings, string[] expose) : DockerCreateSettings
- AddExpose(this DockerCreateSettings toolSettings, IEnumerable<string> expose) : DockerCreateSettings
- AddGroupAdd(this DockerCreateSettings toolSettings, string[] groupAdd) : DockerCreateSettings
- AddGroupAdd(this DockerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerCreateSettings
- AddLabel(this DockerCreateSettings toolSettings, string[] label) : DockerCreateSettings
- AddLabel(this DockerCreateSettings toolSettings, IEnumerable<string> label) : DockerCreateSettings
- AddLabelFile(this DockerCreateSettings toolSettings, string[] labelFile) : DockerCreateSettings
- AddLabelFile(this DockerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerCreateSettings
- AddLink(this DockerCreateSettings toolSettings, string[] link) : DockerCreateSettings
- AddLink(this DockerCreateSettings toolSettings, IEnumerable<string> link) : DockerCreateSettings
- AddLinkLocalIp(this DockerCreateSettings toolSettings, string[] linkLocalIp) : DockerCreateSettings
- AddLinkLocalIp(this DockerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerCreateSettings
- AddLogOpt(this DockerCreateSettings toolSettings, string[] logOpt) : DockerCreateSettings
- AddLogOpt(this DockerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerCreateSettings
- AddNetAlias(this DockerCreateSettings toolSettings, string[] netAlias) : DockerCreateSettings
- AddNetAlias(this DockerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerCreateSettings
- AddNetworkAlias(this DockerCreateSettings toolSettings, string[] networkAlias) : DockerCreateSettings
- AddNetworkAlias(this DockerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerCreateSettings
- AddPublish(this DockerCreateSettings toolSettings, string[] publish) : DockerCreateSettings
- AddPublish(this DockerCreateSettings toolSettings, IEnumerable<string> publish) : DockerCreateSettings
- AddSecurityOpt(this DockerCreateSettings toolSettings, string[] securityOpt) : DockerCreateSettings
- AddSecurityOpt(this DockerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerCreateSettings
- AddStorageOpt(this DockerCreateSettings toolSettings, string[] storageOpt) : DockerCreateSettings
- AddStorageOpt(this DockerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerCreateSettings
- AddSysctl(this DockerCreateSettings toolSettings, string sysctlKey, string sysctlValue) : DockerCreateSettings
- AddTmpfs(this DockerCreateSettings toolSettings, string[] tmpfs) : DockerCreateSettings
- AddTmpfs(this DockerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerCreateSettings
- AddVolume(this DockerCreateSettings toolSettings, string[] volume) : DockerCreateSettings
- AddVolume(this DockerCreateSettings toolSettings, IEnumerable<string> volume) : DockerCreateSettings
- AddVolumesFrom(this DockerCreateSettings toolSettings, string[] volumesFrom) : DockerCreateSettings
- AddVolumesFrom(this DockerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerCreateSettings
- ClearAddHost(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearArgs(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearAttach(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearBlkioWeightDevice(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearCapAdd(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearCapDrop(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDevice(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDeviceCgroupRule(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDeviceReadBps(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDeviceReadIops(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDeviceWriteBps(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDeviceWriteIops(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDns(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDnsOpt(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDnsOption(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearDnsSearch(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearEnv(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearEnvFile(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearExpose(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearGroupAdd(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearLabel(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearLabelFile(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearLink(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearLinkLocalIp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearLogOpt(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearNetAlias(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearNetworkAlias(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearPublish(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearSecurityOpt(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearStorageOpt(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearSysctl(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearTmpfs(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearVolume(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ClearVolumesFrom(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableDisableContentTrust(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableHelp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableInit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableInteractive(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableNoHealthcheck(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableOomKillDisable(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisablePrivileged(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisablePublishAll(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableReadOnly(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableRm(this DockerCreateSettings toolSettings) : DockerCreateSettings
- DisableTty(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableDisableContentTrust(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableHelp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableInit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableInteractive(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableNoHealthcheck(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableOomKillDisable(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnablePrivileged(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnablePublishAll(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableReadOnly(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableRm(this DockerCreateSettings toolSettings) : DockerCreateSettings
- EnableTty(this DockerCreateSettings toolSettings) : DockerCreateSettings
- RemoveAddHost(this DockerCreateSettings toolSettings, string[] addHost) : DockerCreateSettings
- RemoveAddHost(this DockerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerCreateSettings
- RemoveArgs(this DockerCreateSettings toolSettings, string[] args) : DockerCreateSettings
- RemoveArgs(this DockerCreateSettings toolSettings, IEnumerable<string> args) : DockerCreateSettings
- RemoveAttach(this DockerCreateSettings toolSettings, string[] attach) : DockerCreateSettings
- RemoveAttach(this DockerCreateSettings toolSettings, IEnumerable<string> attach) : DockerCreateSettings
- RemoveBlkioWeightDevice(this DockerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerCreateSettings
- RemoveBlkioWeightDevice(this DockerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerCreateSettings
- RemoveCapAdd(this DockerCreateSettings toolSettings, string[] capAdd) : DockerCreateSettings
- RemoveCapAdd(this DockerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerCreateSettings
- RemoveCapDrop(this DockerCreateSettings toolSettings, string[] capDrop) : DockerCreateSettings
- RemoveCapDrop(this DockerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerCreateSettings
- RemoveDevice(this DockerCreateSettings toolSettings, string[] device) : DockerCreateSettings
- RemoveDevice(this DockerCreateSettings toolSettings, IEnumerable<string> device) : DockerCreateSettings
- RemoveDeviceCgroupRule(this DockerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerCreateSettings
- RemoveDeviceCgroupRule(this DockerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerCreateSettings
- RemoveDeviceReadBps(this DockerCreateSettings toolSettings, string[] deviceReadBps) : DockerCreateSettings
- RemoveDeviceReadBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerCreateSettings
- RemoveDeviceReadIops(this DockerCreateSettings toolSettings, string[] deviceReadIops) : DockerCreateSettings
- RemoveDeviceReadIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerCreateSettings
- RemoveDeviceWriteBps(this DockerCreateSettings toolSettings, string[] deviceWriteBps) : DockerCreateSettings
- RemoveDeviceWriteBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerCreateSettings
- RemoveDeviceWriteIops(this DockerCreateSettings toolSettings, string[] deviceWriteIops) : DockerCreateSettings
- RemoveDeviceWriteIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerCreateSettings
- RemoveDns(this DockerCreateSettings toolSettings, string[] dns) : DockerCreateSettings
- RemoveDns(this DockerCreateSettings toolSettings, IEnumerable<string> dns) : DockerCreateSettings
- RemoveDnsOpt(this DockerCreateSettings toolSettings, string[] dnsOpt) : DockerCreateSettings
- RemoveDnsOpt(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerCreateSettings
- RemoveDnsOption(this DockerCreateSettings toolSettings, string[] dnsOption) : DockerCreateSettings
- RemoveDnsOption(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerCreateSettings
- RemoveDnsSearch(this DockerCreateSettings toolSettings, string[] dnsSearch) : DockerCreateSettings
- RemoveDnsSearch(this DockerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerCreateSettings
- RemoveEnv(this DockerCreateSettings toolSettings, string[] env) : DockerCreateSettings
- RemoveEnv(this DockerCreateSettings toolSettings, IEnumerable<string> env) : DockerCreateSettings
- RemoveEnvFile(this DockerCreateSettings toolSettings, string[] envFile) : DockerCreateSettings
- RemoveEnvFile(this DockerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerCreateSettings
- RemoveExpose(this DockerCreateSettings toolSettings, string[] expose) : DockerCreateSettings
- RemoveExpose(this DockerCreateSettings toolSettings, IEnumerable<string> expose) : DockerCreateSettings
- RemoveGroupAdd(this DockerCreateSettings toolSettings, string[] groupAdd) : DockerCreateSettings
- RemoveGroupAdd(this DockerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerCreateSettings
- RemoveLabel(this DockerCreateSettings toolSettings, string[] label) : DockerCreateSettings
- RemoveLabel(this DockerCreateSettings toolSettings, IEnumerable<string> label) : DockerCreateSettings
- RemoveLabelFile(this DockerCreateSettings toolSettings, string[] labelFile) : DockerCreateSettings
- RemoveLabelFile(this DockerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerCreateSettings
- RemoveLink(this DockerCreateSettings toolSettings, string[] link) : DockerCreateSettings
- RemoveLink(this DockerCreateSettings toolSettings, IEnumerable<string> link) : DockerCreateSettings
- RemoveLinkLocalIp(this DockerCreateSettings toolSettings, string[] linkLocalIp) : DockerCreateSettings
- RemoveLinkLocalIp(this DockerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerCreateSettings
- RemoveLogOpt(this DockerCreateSettings toolSettings, string[] logOpt) : DockerCreateSettings
- RemoveLogOpt(this DockerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerCreateSettings
- RemoveNetAlias(this DockerCreateSettings toolSettings, string[] netAlias) : DockerCreateSettings
- RemoveNetAlias(this DockerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerCreateSettings
- RemoveNetworkAlias(this DockerCreateSettings toolSettings, string[] networkAlias) : DockerCreateSettings
- RemoveNetworkAlias(this DockerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerCreateSettings
- RemovePublish(this DockerCreateSettings toolSettings, string[] publish) : DockerCreateSettings
- RemovePublish(this DockerCreateSettings toolSettings, IEnumerable<string> publish) : DockerCreateSettings
- RemoveSecurityOpt(this DockerCreateSettings toolSettings, string[] securityOpt) : DockerCreateSettings
- RemoveSecurityOpt(this DockerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerCreateSettings
- RemoveStorageOpt(this DockerCreateSettings toolSettings, string[] storageOpt) : DockerCreateSettings
- RemoveStorageOpt(this DockerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerCreateSettings
- RemoveSysctl(this DockerCreateSettings toolSettings, string sysctlKey) : DockerCreateSettings
- RemoveTmpfs(this DockerCreateSettings toolSettings, string[] tmpfs) : DockerCreateSettings
- RemoveTmpfs(this DockerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerCreateSettings
- RemoveVolume(this DockerCreateSettings toolSettings, string[] volume) : DockerCreateSettings
- RemoveVolume(this DockerCreateSettings toolSettings, IEnumerable<string> volume) : DockerCreateSettings
- RemoveVolumesFrom(this DockerCreateSettings toolSettings, string[] volumesFrom) : DockerCreateSettings
- RemoveVolumesFrom(this DockerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerCreateSettings
- ResetBlkioWeight(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCgroupParent(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCidfile(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCommand(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuCount(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuPercent(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuPeriod(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuQuota(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuRtPeriod(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuRtRuntime(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpus(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpusetCpus(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpusetMems(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetCpuShares(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetDisableContentTrust(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetDomainname(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetEntrypoint(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetGpus(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHealthCmd(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHealthInterval(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHealthRetries(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHealthStartPeriod(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHealthTimeout(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHelp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetHostname(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetImage(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetInit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetInteractive(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIoMaxbandwidth(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIoMaxiops(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIp6(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIpc(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetIsolation(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetKernelMemory(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetLogDriver(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMacAddress(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMemory(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMemoryReservation(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMemorySwap(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMemorySwappiness(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetMount(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetName(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetNet(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetNetwork(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetNoHealthcheck(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetOomKillDisable(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetOomScoreAdj(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetPid(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetPidsLimit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetPlatform(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetPrivileged(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetPublishAll(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetReadOnly(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetRestart(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetRm(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetRuntime(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetShmSize(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetStopSignal(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetStopTimeout(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetTty(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetUlimit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetUser(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetUserns(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetUts(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetVolumeDriver(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ResetWorkdir(this DockerCreateSettings toolSettings) : DockerCreateSettings
- SetAddHost(this DockerCreateSettings toolSettings, string[] addHost) : DockerCreateSettings
- SetAddHost(this DockerCreateSettings toolSettings, IEnumerable<string> addHost) : DockerCreateSettings
- SetArgs(this DockerCreateSettings toolSettings, string[] args) : DockerCreateSettings
- SetArgs(this DockerCreateSettings toolSettings, IEnumerable<string> args) : DockerCreateSettings
- SetAttach(this DockerCreateSettings toolSettings, string[] attach) : DockerCreateSettings
- SetAttach(this DockerCreateSettings toolSettings, IEnumerable<string> attach) : DockerCreateSettings
- SetBlkioWeight(this DockerCreateSettings toolSettings, int? blkioWeight) : DockerCreateSettings
- SetBlkioWeightDevice(this DockerCreateSettings toolSettings, string[] blkioWeightDevice) : DockerCreateSettings
- SetBlkioWeightDevice(this DockerCreateSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerCreateSettings
- SetCapAdd(this DockerCreateSettings toolSettings, string[] capAdd) : DockerCreateSettings
- SetCapAdd(this DockerCreateSettings toolSettings, IEnumerable<string> capAdd) : DockerCreateSettings
- SetCapDrop(this DockerCreateSettings toolSettings, string[] capDrop) : DockerCreateSettings
- SetCapDrop(this DockerCreateSettings toolSettings, IEnumerable<string> capDrop) : DockerCreateSettings
- SetCgroupParent(this DockerCreateSettings toolSettings, string cgroupParent) : DockerCreateSettings
- SetCidfile(this DockerCreateSettings toolSettings, string cidfile) : DockerCreateSettings
- SetCommand(this DockerCreateSettings toolSettings, string command) : DockerCreateSettings
- SetCpuCount(this DockerCreateSettings toolSettings, long? cpuCount) : DockerCreateSettings
- SetCpuPercent(this DockerCreateSettings toolSettings, long? cpuPercent) : DockerCreateSettings
- SetCpuPeriod(this DockerCreateSettings toolSettings, long? cpuPeriod) : DockerCreateSettings
- SetCpuQuota(this DockerCreateSettings toolSettings, long? cpuQuota) : DockerCreateSettings
- SetCpuRtPeriod(this DockerCreateSettings toolSettings, long? cpuRtPeriod) : DockerCreateSettings
- SetCpuRtRuntime(this DockerCreateSettings toolSettings, long? cpuRtRuntime) : DockerCreateSettings
- SetCpus(this DockerCreateSettings toolSettings, decimal? cpus) : DockerCreateSettings
- SetCpusetCpus(this DockerCreateSettings toolSettings, string cpusetCpus) : DockerCreateSettings
- SetCpusetMems(this DockerCreateSettings toolSettings, string cpusetMems) : DockerCreateSettings
- SetCpuShares(this DockerCreateSettings toolSettings, long? cpuShares) : DockerCreateSettings
- SetDevice(this DockerCreateSettings toolSettings, string[] device) : DockerCreateSettings
- SetDevice(this DockerCreateSettings toolSettings, IEnumerable<string> device) : DockerCreateSettings
- SetDeviceCgroupRule(this DockerCreateSettings toolSettings, string[] deviceCgroupRule) : DockerCreateSettings
- SetDeviceCgroupRule(this DockerCreateSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerCreateSettings
- SetDeviceReadBps(this DockerCreateSettings toolSettings, string[] deviceReadBps) : DockerCreateSettings
- SetDeviceReadBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerCreateSettings
- SetDeviceReadIops(this DockerCreateSettings toolSettings, string[] deviceReadIops) : DockerCreateSettings
- SetDeviceReadIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerCreateSettings
- SetDeviceWriteBps(this DockerCreateSettings toolSettings, string[] deviceWriteBps) : DockerCreateSettings
- SetDeviceWriteBps(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerCreateSettings
- SetDeviceWriteIops(this DockerCreateSettings toolSettings, string[] deviceWriteIops) : DockerCreateSettings
- SetDeviceWriteIops(this DockerCreateSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerCreateSettings
- SetDisableContentTrust(this DockerCreateSettings toolSettings, bool? disableContentTrust) : DockerCreateSettings
- SetDns(this DockerCreateSettings toolSettings, string[] dns) : DockerCreateSettings
- SetDns(this DockerCreateSettings toolSettings, IEnumerable<string> dns) : DockerCreateSettings
- SetDnsOpt(this DockerCreateSettings toolSettings, string[] dnsOpt) : DockerCreateSettings
- SetDnsOpt(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOpt) : DockerCreateSettings
- SetDnsOption(this DockerCreateSettings toolSettings, string[] dnsOption) : DockerCreateSettings
- SetDnsOption(this DockerCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerCreateSettings
- SetDnsSearch(this DockerCreateSettings toolSettings, string[] dnsSearch) : DockerCreateSettings
- SetDnsSearch(this DockerCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerCreateSettings
- SetDomainname(this DockerCreateSettings toolSettings, string domainname) : DockerCreateSettings
- SetEntrypoint(this DockerCreateSettings toolSettings, string entrypoint) : DockerCreateSettings
- SetEnv(this DockerCreateSettings toolSettings, string[] env) : DockerCreateSettings
- SetEnv(this DockerCreateSettings toolSettings, IEnumerable<string> env) : DockerCreateSettings
- SetEnvFile(this DockerCreateSettings toolSettings, string[] envFile) : DockerCreateSettings
- SetEnvFile(this DockerCreateSettings toolSettings, IEnumerable<string> envFile) : DockerCreateSettings
- SetExpose(this DockerCreateSettings toolSettings, string[] expose) : DockerCreateSettings
- SetExpose(this DockerCreateSettings toolSettings, IEnumerable<string> expose) : DockerCreateSettings
- SetGpus(this DockerCreateSettings toolSettings, string gpus) : DockerCreateSettings
- SetGroupAdd(this DockerCreateSettings toolSettings, string[] groupAdd) : DockerCreateSettings
- SetGroupAdd(this DockerCreateSettings toolSettings, IEnumerable<string> groupAdd) : DockerCreateSettings
- SetHealthCmd(this DockerCreateSettings toolSettings, string healthCmd) : DockerCreateSettings
- SetHealthInterval(this DockerCreateSettings toolSettings, string healthInterval) : DockerCreateSettings
- SetHealthRetries(this DockerCreateSettings toolSettings, int? healthRetries) : DockerCreateSettings
- SetHealthStartPeriod(this DockerCreateSettings toolSettings, string healthStartPeriod) : DockerCreateSettings
- SetHealthTimeout(this DockerCreateSettings toolSettings, string healthTimeout) : DockerCreateSettings
- SetHelp(this DockerCreateSettings toolSettings, bool? help) : DockerCreateSettings
- SetHostname(this DockerCreateSettings toolSettings, string hostname) : DockerCreateSettings
- SetImage(this DockerCreateSettings toolSettings, string image) : DockerCreateSettings
- SetInit(this DockerCreateSettings toolSettings, bool? init) : DockerCreateSettings
- SetInteractive(this DockerCreateSettings toolSettings, bool? interactive) : DockerCreateSettings
- SetIoMaxbandwidth(this DockerCreateSettings toolSettings, long? ioMaxbandwidth) : DockerCreateSettings
- SetIoMaxiops(this DockerCreateSettings toolSettings, int? ioMaxiops) : DockerCreateSettings
- SetIp(this DockerCreateSettings toolSettings, string ip) : DockerCreateSettings
- SetIp6(this DockerCreateSettings toolSettings, string ip6) : DockerCreateSettings
- SetIpc(this DockerCreateSettings toolSettings, string ipc) : DockerCreateSettings
- SetIsolation(this DockerCreateSettings toolSettings, string isolation) : DockerCreateSettings
- SetKernelMemory(this DockerCreateSettings toolSettings, long? kernelMemory) : DockerCreateSettings
- SetLabel(this DockerCreateSettings toolSettings, string[] label) : DockerCreateSettings
- SetLabel(this DockerCreateSettings toolSettings, IEnumerable<string> label) : DockerCreateSettings
- SetLabelFile(this DockerCreateSettings toolSettings, string[] labelFile) : DockerCreateSettings
- SetLabelFile(this DockerCreateSettings toolSettings, IEnumerable<string> labelFile) : DockerCreateSettings
- SetLink(this DockerCreateSettings toolSettings, string[] link) : DockerCreateSettings
- SetLink(this DockerCreateSettings toolSettings, IEnumerable<string> link) : DockerCreateSettings
- SetLinkLocalIp(this DockerCreateSettings toolSettings, string[] linkLocalIp) : DockerCreateSettings
- SetLinkLocalIp(this DockerCreateSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerCreateSettings
- SetLogDriver(this DockerCreateSettings toolSettings, string logDriver) : DockerCreateSettings
- SetLogOpt(this DockerCreateSettings toolSettings, string[] logOpt) : DockerCreateSettings
- SetLogOpt(this DockerCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerCreateSettings
- SetMacAddress(this DockerCreateSettings toolSettings, string macAddress) : DockerCreateSettings
- SetMemory(this DockerCreateSettings toolSettings, long? memory) : DockerCreateSettings
- SetMemoryReservation(this DockerCreateSettings toolSettings, long? memoryReservation) : DockerCreateSettings
- SetMemorySwap(this DockerCreateSettings toolSettings, long? memorySwap) : DockerCreateSettings
- SetMemorySwappiness(this DockerCreateSettings toolSettings, long? memorySwappiness) : DockerCreateSettings
- SetMount(this DockerCreateSettings toolSettings, string mount) : DockerCreateSettings
- SetName(this DockerCreateSettings toolSettings, string name) : DockerCreateSettings
- SetNet(this DockerCreateSettings toolSettings, string net) : DockerCreateSettings
- SetNetAlias(this DockerCreateSettings toolSettings, string[] netAlias) : DockerCreateSettings
- SetNetAlias(this DockerCreateSettings toolSettings, IEnumerable<string> netAlias) : DockerCreateSettings
- SetNetwork(this DockerCreateSettings toolSettings, string network) : DockerCreateSettings
- SetNetworkAlias(this DockerCreateSettings toolSettings, string[] networkAlias) : DockerCreateSettings
- SetNetworkAlias(this DockerCreateSettings toolSettings, IEnumerable<string> networkAlias) : DockerCreateSettings
- SetNoHealthcheck(this DockerCreateSettings toolSettings, bool? noHealthcheck) : DockerCreateSettings
- SetOomKillDisable(this DockerCreateSettings toolSettings, bool? oomKillDisable) : DockerCreateSettings
- SetOomScoreAdj(this DockerCreateSettings toolSettings, int? oomScoreAdj) : DockerCreateSettings
- SetPid(this DockerCreateSettings toolSettings, string pid) : DockerCreateSettings
- SetPidsLimit(this DockerCreateSettings toolSettings, long? pidsLimit) : DockerCreateSettings
- SetPlatform(this DockerCreateSettings toolSettings, string platform) : DockerCreateSettings
- SetPrivileged(this DockerCreateSettings toolSettings, bool? privileged) : DockerCreateSettings
- SetPublish(this DockerCreateSettings toolSettings, string[] publish) : DockerCreateSettings
- SetPublish(this DockerCreateSettings toolSettings, IEnumerable<string> publish) : DockerCreateSettings
- SetPublishAll(this DockerCreateSettings toolSettings, bool? publishAll) : DockerCreateSettings
- SetReadOnly(this DockerCreateSettings toolSettings, bool? readOnly) : DockerCreateSettings
- SetRestart(this DockerCreateSettings toolSettings, string restart) : DockerCreateSettings
- SetRm(this DockerCreateSettings toolSettings, bool? rm) : DockerCreateSettings
- SetRuntime(this DockerCreateSettings toolSettings, string runtime) : DockerCreateSettings
- SetSecurityOpt(this DockerCreateSettings toolSettings, string[] securityOpt) : DockerCreateSettings
- SetSecurityOpt(this DockerCreateSettings toolSettings, IEnumerable<string> securityOpt) : DockerCreateSettings
- SetShmSize(this DockerCreateSettings toolSettings, long? shmSize) : DockerCreateSettings
- SetStopSignal(this DockerCreateSettings toolSettings, string stopSignal) : DockerCreateSettings
- SetStopTimeout(this DockerCreateSettings toolSettings, int? stopTimeout) : DockerCreateSettings
- SetStorageOpt(this DockerCreateSettings toolSettings, string[] storageOpt) : DockerCreateSettings
- SetStorageOpt(this DockerCreateSettings toolSettings, IEnumerable<string> storageOpt) : DockerCreateSettings
- SetSysctl(this DockerCreateSettings toolSettings, IDictionary<string, string> sysctl) : DockerCreateSettings
- SetSysctl(this DockerCreateSettings toolSettings, string sysctlKey, string sysctlValue) : DockerCreateSettings
- SetTmpfs(this DockerCreateSettings toolSettings, string[] tmpfs) : DockerCreateSettings
- SetTmpfs(this DockerCreateSettings toolSettings, IEnumerable<string> tmpfs) : DockerCreateSettings
- SetTty(this DockerCreateSettings toolSettings, bool? tty) : DockerCreateSettings
- SetUlimit(this DockerCreateSettings toolSettings, string ulimit) : DockerCreateSettings
- SetUser(this DockerCreateSettings toolSettings, string user) : DockerCreateSettings
- SetUserns(this DockerCreateSettings toolSettings, string userns) : DockerCreateSettings
- SetUts(this DockerCreateSettings toolSettings, string uts) : DockerCreateSettings
- SetVolume(this DockerCreateSettings toolSettings, string[] volume) : DockerCreateSettings
- SetVolume(this DockerCreateSettings toolSettings, IEnumerable<string> volume) : DockerCreateSettings
- SetVolumeDriver(this DockerCreateSettings toolSettings, string volumeDriver) : DockerCreateSettings
- SetVolumesFrom(this DockerCreateSettings toolSettings, string[] volumesFrom) : DockerCreateSettings
- SetVolumesFrom(this DockerCreateSettings toolSettings, IEnumerable<string> volumesFrom) : DockerCreateSettings
- SetWorkdir(this DockerCreateSettings toolSettings, string workdir) : DockerCreateSettings
- ToggleDisableContentTrust(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleHelp(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleInit(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleInteractive(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleNoHealthcheck(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleOomKillDisable(this DockerCreateSettings toolSettings) : DockerCreateSettings
- TogglePrivileged(this DockerCreateSettings toolSettings) : DockerCreateSettings
- TogglePublishAll(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleReadOnly(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleRm(this DockerCreateSettings toolSettings) : DockerCreateSettings
- ToggleTty(this DockerCreateSettings toolSettings) : DockerCreateSettings

### Nuke.Common.Tools.Docker.DockerDeploySettings

- .ctor()
- get_BundleFile() : string
- get_ComposeFile() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Namespace() : string
- get_Prune() : bool?
- get_ResolveImage() : ResolveImage
- get_Stack() : string
- get_ToolPath() : string
- get_WithRegistryAuth() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerDeploySettingsExtensions

- AddComposeFile(this DockerDeploySettings toolSettings, string[] composeFile) : DockerDeploySettings
- AddComposeFile(this DockerDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerDeploySettings
- ClearComposeFile(this DockerDeploySettings toolSettings) : DockerDeploySettings
- DisablePrune(this DockerDeploySettings toolSettings) : DockerDeploySettings
- DisableWithRegistryAuth(this DockerDeploySettings toolSettings) : DockerDeploySettings
- EnablePrune(this DockerDeploySettings toolSettings) : DockerDeploySettings
- EnableWithRegistryAuth(this DockerDeploySettings toolSettings) : DockerDeploySettings
- RemoveComposeFile(this DockerDeploySettings toolSettings, string[] composeFile) : DockerDeploySettings
- RemoveComposeFile(this DockerDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerDeploySettings
- ResetBundleFile(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ResetNamespace(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ResetPrune(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ResetResolveImage(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ResetStack(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ResetWithRegistryAuth(this DockerDeploySettings toolSettings) : DockerDeploySettings
- SetBundleFile(this DockerDeploySettings toolSettings, string bundleFile) : DockerDeploySettings
- SetComposeFile(this DockerDeploySettings toolSettings, string[] composeFile) : DockerDeploySettings
- SetComposeFile(this DockerDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerDeploySettings
- SetNamespace(this DockerDeploySettings toolSettings, string namespace) : DockerDeploySettings
- SetPrune(this DockerDeploySettings toolSettings, bool? prune) : DockerDeploySettings
- SetResolveImage(this DockerDeploySettings toolSettings, ResolveImage resolveImage) : DockerDeploySettings
- SetStack(this DockerDeploySettings toolSettings, string stack) : DockerDeploySettings
- SetWithRegistryAuth(this DockerDeploySettings toolSettings, bool? withRegistryAuth) : DockerDeploySettings
- TogglePrune(this DockerDeploySettings toolSettings) : DockerDeploySettings
- ToggleWithRegistryAuth(this DockerDeploySettings toolSettings) : DockerDeploySettings

### Nuke.Common.Tools.Docker.DockerDiffSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerDiffSettingsExtensions

- ResetContainer(this DockerDiffSettings toolSettings) : DockerDiffSettings
- SetContainer(this DockerDiffSettings toolSettings, string container) : DockerDiffSettings

### Nuke.Common.Tools.Docker.DockerEngineActivateSettings

- .ctor()
- get_Containerd() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisplayOnly() : bool?
- get_EngineImage() : string
- get_Format() : string
- get_License() : string
- get_Quiet() : bool?
- get_RegistryPrefix() : string
- get_ToolPath() : string
- get_Version() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerEngineActivateSettingsExtensions

- DisableDisplayOnly(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- DisableQuiet(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- EnableDisplayOnly(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- EnableQuiet(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetContainerd(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetDisplayOnly(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetEngineImage(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetFormat(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetLicense(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetQuiet(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetRegistryPrefix(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ResetVersion(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- SetContainerd(this DockerEngineActivateSettings toolSettings, string containerd) : DockerEngineActivateSettings
- SetDisplayOnly(this DockerEngineActivateSettings toolSettings, bool? displayOnly) : DockerEngineActivateSettings
- SetEngineImage(this DockerEngineActivateSettings toolSettings, string engineImage) : DockerEngineActivateSettings
- SetFormat(this DockerEngineActivateSettings toolSettings, string format) : DockerEngineActivateSettings
- SetLicense(this DockerEngineActivateSettings toolSettings, string license) : DockerEngineActivateSettings
- SetQuiet(this DockerEngineActivateSettings toolSettings, bool? quiet) : DockerEngineActivateSettings
- SetRegistryPrefix(this DockerEngineActivateSettings toolSettings, string registryPrefix) : DockerEngineActivateSettings
- SetVersion(this DockerEngineActivateSettings toolSettings, string version) : DockerEngineActivateSettings
- ToggleDisplayOnly(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings
- ToggleQuiet(this DockerEngineActivateSettings toolSettings) : DockerEngineActivateSettings

### Nuke.Common.Tools.Docker.DockerEngineCheckSettings

- .ctor()
- get_Containerd() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Downgrades() : bool?
- get_EngineImage() : string
- get_Format() : string
- get_PreReleases() : bool?
- get_Quiet() : bool?
- get_RegistryPrefix() : string
- get_ToolPath() : string
- get_Upgrades() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerEngineCheckSettingsExtensions

- DisableDowngrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- DisablePreReleases(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- DisableQuiet(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- DisableUpgrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- EnableDowngrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- EnablePreReleases(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- EnableQuiet(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- EnableUpgrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetContainerd(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetDowngrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetEngineImage(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetFormat(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetPreReleases(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetQuiet(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetRegistryPrefix(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ResetUpgrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- SetContainerd(this DockerEngineCheckSettings toolSettings, string containerd) : DockerEngineCheckSettings
- SetDowngrades(this DockerEngineCheckSettings toolSettings, bool? downgrades) : DockerEngineCheckSettings
- SetEngineImage(this DockerEngineCheckSettings toolSettings, string engineImage) : DockerEngineCheckSettings
- SetFormat(this DockerEngineCheckSettings toolSettings, string format) : DockerEngineCheckSettings
- SetPreReleases(this DockerEngineCheckSettings toolSettings, bool? preReleases) : DockerEngineCheckSettings
- SetQuiet(this DockerEngineCheckSettings toolSettings, bool? quiet) : DockerEngineCheckSettings
- SetRegistryPrefix(this DockerEngineCheckSettings toolSettings, string registryPrefix) : DockerEngineCheckSettings
- SetUpgrades(this DockerEngineCheckSettings toolSettings, bool? upgrades) : DockerEngineCheckSettings
- ToggleDowngrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- TogglePreReleases(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ToggleQuiet(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings
- ToggleUpgrades(this DockerEngineCheckSettings toolSettings) : DockerEngineCheckSettings

### Nuke.Common.Tools.Docker.DockerEngineSettings

- .ctor()
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerEngineSettingsExtensions

- ResetCommand(this DockerEngineSettings toolSettings) : DockerEngineSettings
- SetCommand(this DockerEngineSettings toolSettings, string command) : DockerEngineSettings

### Nuke.Common.Tools.Docker.DockerEngineUpdateSettings

- .ctor()
- get_Containerd() : string
- get_CustomLogger() : Action<OutputType, string>
- get_EngineImage() : string
- get_RegistryPrefix() : string
- get_ToolPath() : string
- get_Version() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerEngineUpdateSettingsExtensions

- ResetContainerd(this DockerEngineUpdateSettings toolSettings) : DockerEngineUpdateSettings
- ResetEngineImage(this DockerEngineUpdateSettings toolSettings) : DockerEngineUpdateSettings
- ResetRegistryPrefix(this DockerEngineUpdateSettings toolSettings) : DockerEngineUpdateSettings
- ResetVersion(this DockerEngineUpdateSettings toolSettings) : DockerEngineUpdateSettings
- SetContainerd(this DockerEngineUpdateSettings toolSettings, string containerd) : DockerEngineUpdateSettings
- SetEngineImage(this DockerEngineUpdateSettings toolSettings, string engineImage) : DockerEngineUpdateSettings
- SetRegistryPrefix(this DockerEngineUpdateSettings toolSettings, string registryPrefix) : DockerEngineUpdateSettings
- SetVersion(this DockerEngineUpdateSettings toolSettings, string version) : DockerEngineUpdateSettings

### Nuke.Common.Tools.Docker.DockerEventsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Since() : string
- get_ToolPath() : string
- get_Until() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerEventsSettingsExtensions

- ResetFilter(this DockerEventsSettings toolSettings) : DockerEventsSettings
- ResetFormat(this DockerEventsSettings toolSettings) : DockerEventsSettings
- ResetSince(this DockerEventsSettings toolSettings) : DockerEventsSettings
- ResetUntil(this DockerEventsSettings toolSettings) : DockerEventsSettings
- SetFilter(this DockerEventsSettings toolSettings, string filter) : DockerEventsSettings
- SetFormat(this DockerEventsSettings toolSettings, string format) : DockerEventsSettings
- SetSince(this DockerEventsSettings toolSettings, string since) : DockerEventsSettings
- SetUntil(this DockerEventsSettings toolSettings, string until) : DockerEventsSettings

### Nuke.Common.Tools.Docker.DockerExecSettings

- .ctor()
- get_Args() : IReadOnlyList<string>
- get_Command() : string
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_DetachKeys() : string
- get_Env() : IReadOnlyList<string>
- get_Interactive() : bool?
- get_Privileged() : bool?
- get_ToolPath() : string
- get_Tty() : bool?
- get_User() : string
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerExecSettingsExtensions

- AddArgs(this DockerExecSettings toolSettings, string[] args) : DockerExecSettings
- AddArgs(this DockerExecSettings toolSettings, IEnumerable<string> args) : DockerExecSettings
- AddEnv(this DockerExecSettings toolSettings, string[] env) : DockerExecSettings
- AddEnv(this DockerExecSettings toolSettings, IEnumerable<string> env) : DockerExecSettings
- ClearArgs(this DockerExecSettings toolSettings) : DockerExecSettings
- ClearEnv(this DockerExecSettings toolSettings) : DockerExecSettings
- DisableDetach(this DockerExecSettings toolSettings) : DockerExecSettings
- DisableInteractive(this DockerExecSettings toolSettings) : DockerExecSettings
- DisablePrivileged(this DockerExecSettings toolSettings) : DockerExecSettings
- DisableTty(this DockerExecSettings toolSettings) : DockerExecSettings
- EnableDetach(this DockerExecSettings toolSettings) : DockerExecSettings
- EnableInteractive(this DockerExecSettings toolSettings) : DockerExecSettings
- EnablePrivileged(this DockerExecSettings toolSettings) : DockerExecSettings
- EnableTty(this DockerExecSettings toolSettings) : DockerExecSettings
- RemoveArgs(this DockerExecSettings toolSettings, string[] args) : DockerExecSettings
- RemoveArgs(this DockerExecSettings toolSettings, IEnumerable<string> args) : DockerExecSettings
- RemoveEnv(this DockerExecSettings toolSettings, string[] env) : DockerExecSettings
- RemoveEnv(this DockerExecSettings toolSettings, IEnumerable<string> env) : DockerExecSettings
- ResetCommand(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetContainer(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetDetach(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetDetachKeys(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetInteractive(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetPrivileged(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetTty(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetUser(this DockerExecSettings toolSettings) : DockerExecSettings
- ResetWorkdir(this DockerExecSettings toolSettings) : DockerExecSettings
- SetArgs(this DockerExecSettings toolSettings, string[] args) : DockerExecSettings
- SetArgs(this DockerExecSettings toolSettings, IEnumerable<string> args) : DockerExecSettings
- SetCommand(this DockerExecSettings toolSettings, string command) : DockerExecSettings
- SetContainer(this DockerExecSettings toolSettings, string container) : DockerExecSettings
- SetDetach(this DockerExecSettings toolSettings, bool? detach) : DockerExecSettings
- SetDetachKeys(this DockerExecSettings toolSettings, string detachKeys) : DockerExecSettings
- SetEnv(this DockerExecSettings toolSettings, string[] env) : DockerExecSettings
- SetEnv(this DockerExecSettings toolSettings, IEnumerable<string> env) : DockerExecSettings
- SetInteractive(this DockerExecSettings toolSettings, bool? interactive) : DockerExecSettings
- SetPrivileged(this DockerExecSettings toolSettings, bool? privileged) : DockerExecSettings
- SetTty(this DockerExecSettings toolSettings, bool? tty) : DockerExecSettings
- SetUser(this DockerExecSettings toolSettings, string user) : DockerExecSettings
- SetWorkdir(this DockerExecSettings toolSettings, string workdir) : DockerExecSettings
- ToggleDetach(this DockerExecSettings toolSettings) : DockerExecSettings
- ToggleInteractive(this DockerExecSettings toolSettings) : DockerExecSettings
- TogglePrivileged(this DockerExecSettings toolSettings) : DockerExecSettings
- ToggleTty(this DockerExecSettings toolSettings) : DockerExecSettings

### Nuke.Common.Tools.Docker.DockerExportSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Output() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerExportSettingsExtensions

- ResetContainer(this DockerExportSettings toolSettings) : DockerExportSettings
- ResetOutput(this DockerExportSettings toolSettings) : DockerExportSettings
- SetContainer(this DockerExportSettings toolSettings, string container) : DockerExportSettings
- SetOutput(this DockerExportSettings toolSettings, string output) : DockerExportSettings

### Nuke.Common.Tools.Docker.DockerHistorySettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Human() : bool?
- get_Image() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerHistorySettingsExtensions

- DisableHuman(this DockerHistorySettings toolSettings) : DockerHistorySettings
- DisableNoTrunc(this DockerHistorySettings toolSettings) : DockerHistorySettings
- DisableQuiet(this DockerHistorySettings toolSettings) : DockerHistorySettings
- EnableHuman(this DockerHistorySettings toolSettings) : DockerHistorySettings
- EnableNoTrunc(this DockerHistorySettings toolSettings) : DockerHistorySettings
- EnableQuiet(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ResetFormat(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ResetHuman(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ResetImage(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ResetNoTrunc(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ResetQuiet(this DockerHistorySettings toolSettings) : DockerHistorySettings
- SetFormat(this DockerHistorySettings toolSettings, string format) : DockerHistorySettings
- SetHuman(this DockerHistorySettings toolSettings, bool? human) : DockerHistorySettings
- SetImage(this DockerHistorySettings toolSettings, string image) : DockerHistorySettings
- SetNoTrunc(this DockerHistorySettings toolSettings, bool? noTrunc) : DockerHistorySettings
- SetQuiet(this DockerHistorySettings toolSettings, bool? quiet) : DockerHistorySettings
- ToggleHuman(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ToggleNoTrunc(this DockerHistorySettings toolSettings) : DockerHistorySettings
- ToggleQuiet(this DockerHistorySettings toolSettings) : DockerHistorySettings

### Nuke.Common.Tools.Docker.DockerImageBuildSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_BuildArg() : IReadOnlyList<string>
- get_CacheFrom() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Compress() : bool?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_File() : string
- get_ForceRm() : bool?
- get_Iidfile() : string
- get_Isolation() : string
- get_Label() : IReadOnlyList<string>
- get_Memory() : long?
- get_MemorySwap() : long?
- get_Network() : string
- get_NoCache() : bool?
- get_Output() : string
- get_Path() : string
- get_Platform() : string
- get_Progress() : string
- get_Pull() : bool?
- get_Quiet() : bool?
- get_Rm() : bool?
- get_Secret() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_Squash() : bool?
- get_Ssh() : string
- get_Stream() : bool?
- get_Tag() : IReadOnlyList<string>
- get_Target() : string
- get_ToolPath() : string
- get_Ulimit() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageBuildSettingsExtensions

- AddAddHost(this DockerImageBuildSettings toolSettings, string[] addHost) : DockerImageBuildSettings
- AddAddHost(this DockerImageBuildSettings toolSettings, IEnumerable<string> addHost) : DockerImageBuildSettings
- AddBuildArg(this DockerImageBuildSettings toolSettings, string[] buildArg) : DockerImageBuildSettings
- AddBuildArg(this DockerImageBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerImageBuildSettings
- AddCacheFrom(this DockerImageBuildSettings toolSettings, string[] cacheFrom) : DockerImageBuildSettings
- AddCacheFrom(this DockerImageBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerImageBuildSettings
- AddLabel(this DockerImageBuildSettings toolSettings, string[] label) : DockerImageBuildSettings
- AddLabel(this DockerImageBuildSettings toolSettings, IEnumerable<string> label) : DockerImageBuildSettings
- AddSecurityOpt(this DockerImageBuildSettings toolSettings, string[] securityOpt) : DockerImageBuildSettings
- AddSecurityOpt(this DockerImageBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerImageBuildSettings
- AddTag(this DockerImageBuildSettings toolSettings, string[] tag) : DockerImageBuildSettings
- AddTag(this DockerImageBuildSettings toolSettings, IEnumerable<string> tag) : DockerImageBuildSettings
- ClearAddHost(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ClearBuildArg(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ClearCacheFrom(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ClearLabel(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ClearSecurityOpt(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ClearTag(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableCompress(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableDisableContentTrust(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableForceRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableNoCache(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisablePull(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableQuiet(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableSquash(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- DisableStream(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableCompress(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableDisableContentTrust(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableForceRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableNoCache(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnablePull(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableQuiet(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableSquash(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- EnableStream(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- RemoveAddHost(this DockerImageBuildSettings toolSettings, string[] addHost) : DockerImageBuildSettings
- RemoveAddHost(this DockerImageBuildSettings toolSettings, IEnumerable<string> addHost) : DockerImageBuildSettings
- RemoveBuildArg(this DockerImageBuildSettings toolSettings, string[] buildArg) : DockerImageBuildSettings
- RemoveBuildArg(this DockerImageBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerImageBuildSettings
- RemoveCacheFrom(this DockerImageBuildSettings toolSettings, string[] cacheFrom) : DockerImageBuildSettings
- RemoveCacheFrom(this DockerImageBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerImageBuildSettings
- RemoveLabel(this DockerImageBuildSettings toolSettings, string[] label) : DockerImageBuildSettings
- RemoveLabel(this DockerImageBuildSettings toolSettings, IEnumerable<string> label) : DockerImageBuildSettings
- RemoveSecurityOpt(this DockerImageBuildSettings toolSettings, string[] securityOpt) : DockerImageBuildSettings
- RemoveSecurityOpt(this DockerImageBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerImageBuildSettings
- RemoveTag(this DockerImageBuildSettings toolSettings, string[] tag) : DockerImageBuildSettings
- RemoveTag(this DockerImageBuildSettings toolSettings, IEnumerable<string> tag) : DockerImageBuildSettings
- ResetCgroupParent(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCompress(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCpuPeriod(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCpuQuota(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCpusetCpus(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCpusetMems(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetCpuShares(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetDisableContentTrust(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetFile(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetForceRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetIidfile(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetIsolation(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetMemory(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetMemorySwap(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetNetwork(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetNoCache(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetOutput(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetPath(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetPlatform(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetProgress(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetPull(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetQuiet(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetSecret(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetShmSize(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetSquash(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetSsh(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetStream(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetTarget(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ResetUlimit(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- SetAddHost(this DockerImageBuildSettings toolSettings, string[] addHost) : DockerImageBuildSettings
- SetAddHost(this DockerImageBuildSettings toolSettings, IEnumerable<string> addHost) : DockerImageBuildSettings
- SetBuildArg(this DockerImageBuildSettings toolSettings, string[] buildArg) : DockerImageBuildSettings
- SetBuildArg(this DockerImageBuildSettings toolSettings, IEnumerable<string> buildArg) : DockerImageBuildSettings
- SetCacheFrom(this DockerImageBuildSettings toolSettings, string[] cacheFrom) : DockerImageBuildSettings
- SetCacheFrom(this DockerImageBuildSettings toolSettings, IEnumerable<string> cacheFrom) : DockerImageBuildSettings
- SetCgroupParent(this DockerImageBuildSettings toolSettings, string cgroupParent) : DockerImageBuildSettings
- SetCompress(this DockerImageBuildSettings toolSettings, bool? compress) : DockerImageBuildSettings
- SetCpuPeriod(this DockerImageBuildSettings toolSettings, long? cpuPeriod) : DockerImageBuildSettings
- SetCpuQuota(this DockerImageBuildSettings toolSettings, long? cpuQuota) : DockerImageBuildSettings
- SetCpusetCpus(this DockerImageBuildSettings toolSettings, string cpusetCpus) : DockerImageBuildSettings
- SetCpusetMems(this DockerImageBuildSettings toolSettings, string cpusetMems) : DockerImageBuildSettings
- SetCpuShares(this DockerImageBuildSettings toolSettings, long? cpuShares) : DockerImageBuildSettings
- SetDisableContentTrust(this DockerImageBuildSettings toolSettings, bool? disableContentTrust) : DockerImageBuildSettings
- SetFile(this DockerImageBuildSettings toolSettings, string file) : DockerImageBuildSettings
- SetForceRm(this DockerImageBuildSettings toolSettings, bool? forceRm) : DockerImageBuildSettings
- SetIidfile(this DockerImageBuildSettings toolSettings, string iidfile) : DockerImageBuildSettings
- SetIsolation(this DockerImageBuildSettings toolSettings, string isolation) : DockerImageBuildSettings
- SetLabel(this DockerImageBuildSettings toolSettings, string[] label) : DockerImageBuildSettings
- SetLabel(this DockerImageBuildSettings toolSettings, IEnumerable<string> label) : DockerImageBuildSettings
- SetMemory(this DockerImageBuildSettings toolSettings, long? memory) : DockerImageBuildSettings
- SetMemorySwap(this DockerImageBuildSettings toolSettings, long? memorySwap) : DockerImageBuildSettings
- SetNetwork(this DockerImageBuildSettings toolSettings, string network) : DockerImageBuildSettings
- SetNoCache(this DockerImageBuildSettings toolSettings, bool? noCache) : DockerImageBuildSettings
- SetOutput(this DockerImageBuildSettings toolSettings, string output) : DockerImageBuildSettings
- SetPath(this DockerImageBuildSettings toolSettings, string path) : DockerImageBuildSettings
- SetPlatform(this DockerImageBuildSettings toolSettings, string platform) : DockerImageBuildSettings
- SetProgress(this DockerImageBuildSettings toolSettings, string progress) : DockerImageBuildSettings
- SetPull(this DockerImageBuildSettings toolSettings, bool? pull) : DockerImageBuildSettings
- SetQuiet(this DockerImageBuildSettings toolSettings, bool? quiet) : DockerImageBuildSettings
- SetRm(this DockerImageBuildSettings toolSettings, bool? rm) : DockerImageBuildSettings
- SetSecret(this DockerImageBuildSettings toolSettings, string secret) : DockerImageBuildSettings
- SetSecurityOpt(this DockerImageBuildSettings toolSettings, string[] securityOpt) : DockerImageBuildSettings
- SetSecurityOpt(this DockerImageBuildSettings toolSettings, IEnumerable<string> securityOpt) : DockerImageBuildSettings
- SetShmSize(this DockerImageBuildSettings toolSettings, long? shmSize) : DockerImageBuildSettings
- SetSquash(this DockerImageBuildSettings toolSettings, bool? squash) : DockerImageBuildSettings
- SetSsh(this DockerImageBuildSettings toolSettings, string ssh) : DockerImageBuildSettings
- SetStream(this DockerImageBuildSettings toolSettings, bool? stream) : DockerImageBuildSettings
- SetTag(this DockerImageBuildSettings toolSettings, string[] tag) : DockerImageBuildSettings
- SetTag(this DockerImageBuildSettings toolSettings, IEnumerable<string> tag) : DockerImageBuildSettings
- SetTarget(this DockerImageBuildSettings toolSettings, string target) : DockerImageBuildSettings
- SetUlimit(this DockerImageBuildSettings toolSettings, string ulimit) : DockerImageBuildSettings
- ToggleCompress(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleDisableContentTrust(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleForceRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleNoCache(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- TogglePull(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleQuiet(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleRm(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleSquash(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings
- ToggleStream(this DockerImageBuildSettings toolSettings) : DockerImageBuildSettings

### Nuke.Common.Tools.Docker.DockerImageHistorySettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Human() : bool?
- get_Image() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageHistorySettingsExtensions

- DisableHuman(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- DisableNoTrunc(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- DisableQuiet(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- EnableHuman(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- EnableNoTrunc(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- EnableQuiet(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ResetFormat(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ResetHuman(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ResetImage(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ResetNoTrunc(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ResetQuiet(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- SetFormat(this DockerImageHistorySettings toolSettings, string format) : DockerImageHistorySettings
- SetHuman(this DockerImageHistorySettings toolSettings, bool? human) : DockerImageHistorySettings
- SetImage(this DockerImageHistorySettings toolSettings, string image) : DockerImageHistorySettings
- SetNoTrunc(this DockerImageHistorySettings toolSettings, bool? noTrunc) : DockerImageHistorySettings
- SetQuiet(this DockerImageHistorySettings toolSettings, bool? quiet) : DockerImageHistorySettings
- ToggleHuman(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ToggleNoTrunc(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings
- ToggleQuiet(this DockerImageHistorySettings toolSettings) : DockerImageHistorySettings

### Nuke.Common.Tools.Docker.DockerImageImportSettings

- .ctor()
- get_Change() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_File() : string
- get_Message() : string
- get_Platform() : string
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageImportSettingsExtensions

- AddChange(this DockerImageImportSettings toolSettings, string[] change) : DockerImageImportSettings
- AddChange(this DockerImageImportSettings toolSettings, IEnumerable<string> change) : DockerImageImportSettings
- ClearChange(this DockerImageImportSettings toolSettings) : DockerImageImportSettings
- RemoveChange(this DockerImageImportSettings toolSettings, string[] change) : DockerImageImportSettings
- RemoveChange(this DockerImageImportSettings toolSettings, IEnumerable<string> change) : DockerImageImportSettings
- ResetFile(this DockerImageImportSettings toolSettings) : DockerImageImportSettings
- ResetMessage(this DockerImageImportSettings toolSettings) : DockerImageImportSettings
- ResetPlatform(this DockerImageImportSettings toolSettings) : DockerImageImportSettings
- ResetRepository(this DockerImageImportSettings toolSettings) : DockerImageImportSettings
- SetChange(this DockerImageImportSettings toolSettings, string[] change) : DockerImageImportSettings
- SetChange(this DockerImageImportSettings toolSettings, IEnumerable<string> change) : DockerImageImportSettings
- SetFile(this DockerImageImportSettings toolSettings, string file) : DockerImageImportSettings
- SetMessage(this DockerImageImportSettings toolSettings, string message) : DockerImageImportSettings
- SetPlatform(this DockerImageImportSettings toolSettings, string platform) : DockerImageImportSettings
- SetRepository(this DockerImageImportSettings toolSettings, string repository) : DockerImageImportSettings

### Nuke.Common.Tools.Docker.DockerImageInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Images() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageInspectSettingsExtensions

- AddImages(this DockerImageInspectSettings toolSettings, string[] images) : DockerImageInspectSettings
- AddImages(this DockerImageInspectSettings toolSettings, IEnumerable<string> images) : DockerImageInspectSettings
- ClearImages(this DockerImageInspectSettings toolSettings) : DockerImageInspectSettings
- RemoveImages(this DockerImageInspectSettings toolSettings, string[] images) : DockerImageInspectSettings
- RemoveImages(this DockerImageInspectSettings toolSettings, IEnumerable<string> images) : DockerImageInspectSettings
- ResetFormat(this DockerImageInspectSettings toolSettings) : DockerImageInspectSettings
- SetFormat(this DockerImageInspectSettings toolSettings, string format) : DockerImageInspectSettings
- SetImages(this DockerImageInspectSettings toolSettings, string[] images) : DockerImageInspectSettings
- SetImages(this DockerImageInspectSettings toolSettings, IEnumerable<string> images) : DockerImageInspectSettings

### Nuke.Common.Tools.Docker.DockerImageLoadSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Input() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageLoadSettingsExtensions

- DisableQuiet(this DockerImageLoadSettings toolSettings) : DockerImageLoadSettings
- EnableQuiet(this DockerImageLoadSettings toolSettings) : DockerImageLoadSettings
- ResetInput(this DockerImageLoadSettings toolSettings) : DockerImageLoadSettings
- ResetQuiet(this DockerImageLoadSettings toolSettings) : DockerImageLoadSettings
- SetInput(this DockerImageLoadSettings toolSettings, string input) : DockerImageLoadSettings
- SetQuiet(this DockerImageLoadSettings toolSettings, bool? quiet) : DockerImageLoadSettings
- ToggleQuiet(this DockerImageLoadSettings toolSettings) : DockerImageLoadSettings

### Nuke.Common.Tools.Docker.DockerImageLsSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Digests() : bool?
- get_Filter() : string
- get_Format() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageLsSettingsExtensions

- DisableAll(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- DisableDigests(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- DisableNoTrunc(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- DisableQuiet(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- EnableAll(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- EnableDigests(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- EnableNoTrunc(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- EnableQuiet(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetAll(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetDigests(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetFilter(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetFormat(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetNoTrunc(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetQuiet(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ResetRepository(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- SetAll(this DockerImageLsSettings toolSettings, bool? all) : DockerImageLsSettings
- SetDigests(this DockerImageLsSettings toolSettings, bool? digests) : DockerImageLsSettings
- SetFilter(this DockerImageLsSettings toolSettings, string filter) : DockerImageLsSettings
- SetFormat(this DockerImageLsSettings toolSettings, string format) : DockerImageLsSettings
- SetNoTrunc(this DockerImageLsSettings toolSettings, bool? noTrunc) : DockerImageLsSettings
- SetQuiet(this DockerImageLsSettings toolSettings, bool? quiet) : DockerImageLsSettings
- SetRepository(this DockerImageLsSettings toolSettings, string repository) : DockerImageLsSettings
- ToggleAll(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ToggleDigests(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ToggleNoTrunc(this DockerImageLsSettings toolSettings) : DockerImageLsSettings
- ToggleQuiet(this DockerImageLsSettings toolSettings) : DockerImageLsSettings

### Nuke.Common.Tools.Docker.DockerImagePruneSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Force() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImagePruneSettingsExtensions

- DisableAll(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- DisableForce(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- EnableAll(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- EnableForce(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- ResetAll(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- ResetFilter(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- ResetForce(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- SetAll(this DockerImagePruneSettings toolSettings, bool? all) : DockerImagePruneSettings
- SetFilter(this DockerImagePruneSettings toolSettings, string filter) : DockerImagePruneSettings
- SetForce(this DockerImagePruneSettings toolSettings, bool? force) : DockerImagePruneSettings
- ToggleAll(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings
- ToggleForce(this DockerImagePruneSettings toolSettings) : DockerImagePruneSettings

### Nuke.Common.Tools.Docker.DockerImagePullSettings

- .ctor()
- get_AllTags() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_Name() : string
- get_Platform() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImagePullSettingsExtensions

- DisableAllTags(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- DisableDisableContentTrust(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- DisableQuiet(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- EnableAllTags(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- EnableDisableContentTrust(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- EnableQuiet(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ResetAllTags(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ResetDisableContentTrust(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ResetName(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ResetPlatform(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ResetQuiet(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- SetAllTags(this DockerImagePullSettings toolSettings, bool? allTags) : DockerImagePullSettings
- SetDisableContentTrust(this DockerImagePullSettings toolSettings, bool? disableContentTrust) : DockerImagePullSettings
- SetName(this DockerImagePullSettings toolSettings, string name) : DockerImagePullSettings
- SetPlatform(this DockerImagePullSettings toolSettings, string platform) : DockerImagePullSettings
- SetQuiet(this DockerImagePullSettings toolSettings, bool? quiet) : DockerImagePullSettings
- ToggleAllTags(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ToggleDisableContentTrust(this DockerImagePullSettings toolSettings) : DockerImagePullSettings
- ToggleQuiet(this DockerImagePullSettings toolSettings) : DockerImagePullSettings

### Nuke.Common.Tools.Docker.DockerImagePushSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_Name() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImagePushSettingsExtensions

- DisableDisableContentTrust(this DockerImagePushSettings toolSettings) : DockerImagePushSettings
- EnableDisableContentTrust(this DockerImagePushSettings toolSettings) : DockerImagePushSettings
- ResetDisableContentTrust(this DockerImagePushSettings toolSettings) : DockerImagePushSettings
- ResetName(this DockerImagePushSettings toolSettings) : DockerImagePushSettings
- SetDisableContentTrust(this DockerImagePushSettings toolSettings, bool? disableContentTrust) : DockerImagePushSettings
- SetName(this DockerImagePushSettings toolSettings, string name) : DockerImagePushSettings
- ToggleDisableContentTrust(this DockerImagePushSettings toolSettings) : DockerImagePushSettings

### Nuke.Common.Tools.Docker.DockerImageRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Images() : IReadOnlyList<string>
- get_NoPrune() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageRmSettingsExtensions

- AddImages(this DockerImageRmSettings toolSettings, string[] images) : DockerImageRmSettings
- AddImages(this DockerImageRmSettings toolSettings, IEnumerable<string> images) : DockerImageRmSettings
- ClearImages(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- DisableForce(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- DisableNoPrune(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- EnableForce(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- EnableNoPrune(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- RemoveImages(this DockerImageRmSettings toolSettings, string[] images) : DockerImageRmSettings
- RemoveImages(this DockerImageRmSettings toolSettings, IEnumerable<string> images) : DockerImageRmSettings
- ResetForce(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- ResetNoPrune(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- SetForce(this DockerImageRmSettings toolSettings, bool? force) : DockerImageRmSettings
- SetImages(this DockerImageRmSettings toolSettings, string[] images) : DockerImageRmSettings
- SetImages(this DockerImageRmSettings toolSettings, IEnumerable<string> images) : DockerImageRmSettings
- SetNoPrune(this DockerImageRmSettings toolSettings, bool? noPrune) : DockerImageRmSettings
- ToggleForce(this DockerImageRmSettings toolSettings) : DockerImageRmSettings
- ToggleNoPrune(this DockerImageRmSettings toolSettings) : DockerImageRmSettings

### Nuke.Common.Tools.Docker.DockerImageSaveSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Images() : IReadOnlyList<string>
- get_Output() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageSaveSettingsExtensions

- AddImages(this DockerImageSaveSettings toolSettings, string[] images) : DockerImageSaveSettings
- AddImages(this DockerImageSaveSettings toolSettings, IEnumerable<string> images) : DockerImageSaveSettings
- ClearImages(this DockerImageSaveSettings toolSettings) : DockerImageSaveSettings
- RemoveImages(this DockerImageSaveSettings toolSettings, string[] images) : DockerImageSaveSettings
- RemoveImages(this DockerImageSaveSettings toolSettings, IEnumerable<string> images) : DockerImageSaveSettings
- ResetOutput(this DockerImageSaveSettings toolSettings) : DockerImageSaveSettings
- SetImages(this DockerImageSaveSettings toolSettings, string[] images) : DockerImageSaveSettings
- SetImages(this DockerImageSaveSettings toolSettings, IEnumerable<string> images) : DockerImageSaveSettings
- SetOutput(this DockerImageSaveSettings toolSettings, string output) : DockerImageSaveSettings

### Nuke.Common.Tools.Docker.DockerImageSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageSettingsExtensions


### Nuke.Common.Tools.Docker.DockerImagesSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Digests() : bool?
- get_Filter() : string
- get_Format() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImagesSettingsExtensions

- DisableAll(this DockerImagesSettings toolSettings) : DockerImagesSettings
- DisableDigests(this DockerImagesSettings toolSettings) : DockerImagesSettings
- DisableNoTrunc(this DockerImagesSettings toolSettings) : DockerImagesSettings
- DisableQuiet(this DockerImagesSettings toolSettings) : DockerImagesSettings
- EnableAll(this DockerImagesSettings toolSettings) : DockerImagesSettings
- EnableDigests(this DockerImagesSettings toolSettings) : DockerImagesSettings
- EnableNoTrunc(this DockerImagesSettings toolSettings) : DockerImagesSettings
- EnableQuiet(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetAll(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetDigests(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetFilter(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetFormat(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetNoTrunc(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetQuiet(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ResetRepository(this DockerImagesSettings toolSettings) : DockerImagesSettings
- SetAll(this DockerImagesSettings toolSettings, bool? all) : DockerImagesSettings
- SetDigests(this DockerImagesSettings toolSettings, bool? digests) : DockerImagesSettings
- SetFilter(this DockerImagesSettings toolSettings, string filter) : DockerImagesSettings
- SetFormat(this DockerImagesSettings toolSettings, string format) : DockerImagesSettings
- SetNoTrunc(this DockerImagesSettings toolSettings, bool? noTrunc) : DockerImagesSettings
- SetQuiet(this DockerImagesSettings toolSettings, bool? quiet) : DockerImagesSettings
- SetRepository(this DockerImagesSettings toolSettings, string repository) : DockerImagesSettings
- ToggleAll(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ToggleDigests(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ToggleNoTrunc(this DockerImagesSettings toolSettings) : DockerImagesSettings
- ToggleQuiet(this DockerImagesSettings toolSettings) : DockerImagesSettings

### Nuke.Common.Tools.Docker.DockerImageTagSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_SourceImage() : string
- get_TargetImage() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImageTagSettingsExtensions

- ResetSourceImage(this DockerImageTagSettings toolSettings) : DockerImageTagSettings
- ResetTargetImage(this DockerImageTagSettings toolSettings) : DockerImageTagSettings
- SetSourceImage(this DockerImageTagSettings toolSettings, string sourceImage) : DockerImageTagSettings
- SetTargetImage(this DockerImageTagSettings toolSettings, string targetImage) : DockerImageTagSettings

### Nuke.Common.Tools.Docker.DockerImportSettings

- .ctor()
- get_Change() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_File() : string
- get_Message() : string
- get_Platform() : string
- get_Repository() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerImportSettingsExtensions

- AddChange(this DockerImportSettings toolSettings, string[] change) : DockerImportSettings
- AddChange(this DockerImportSettings toolSettings, IEnumerable<string> change) : DockerImportSettings
- ClearChange(this DockerImportSettings toolSettings) : DockerImportSettings
- RemoveChange(this DockerImportSettings toolSettings, string[] change) : DockerImportSettings
- RemoveChange(this DockerImportSettings toolSettings, IEnumerable<string> change) : DockerImportSettings
- ResetFile(this DockerImportSettings toolSettings) : DockerImportSettings
- ResetMessage(this DockerImportSettings toolSettings) : DockerImportSettings
- ResetPlatform(this DockerImportSettings toolSettings) : DockerImportSettings
- ResetRepository(this DockerImportSettings toolSettings) : DockerImportSettings
- SetChange(this DockerImportSettings toolSettings, string[] change) : DockerImportSettings
- SetChange(this DockerImportSettings toolSettings, IEnumerable<string> change) : DockerImportSettings
- SetFile(this DockerImportSettings toolSettings, string file) : DockerImportSettings
- SetMessage(this DockerImportSettings toolSettings, string message) : DockerImportSettings
- SetPlatform(this DockerImportSettings toolSettings, string platform) : DockerImportSettings
- SetRepository(this DockerImportSettings toolSettings, string repository) : DockerImportSettings

### Nuke.Common.Tools.Docker.DockerInfoSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerInfoSettingsExtensions

- ResetFormat(this DockerInfoSettings toolSettings) : DockerInfoSettings
- SetFormat(this DockerInfoSettings toolSettings, string format) : DockerInfoSettings

### Nuke.Common.Tools.Docker.DockerInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Names() : IReadOnlyList<string>
- get_Size() : bool?
- get_ToolPath() : string
- get_Type() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerInspectSettingsExtensions

- AddNames(this DockerInspectSettings toolSettings, string[] names) : DockerInspectSettings
- AddNames(this DockerInspectSettings toolSettings, IEnumerable<string> names) : DockerInspectSettings
- ClearNames(this DockerInspectSettings toolSettings) : DockerInspectSettings
- DisableSize(this DockerInspectSettings toolSettings) : DockerInspectSettings
- EnableSize(this DockerInspectSettings toolSettings) : DockerInspectSettings
- RemoveNames(this DockerInspectSettings toolSettings, string[] names) : DockerInspectSettings
- RemoveNames(this DockerInspectSettings toolSettings, IEnumerable<string> names) : DockerInspectSettings
- ResetFormat(this DockerInspectSettings toolSettings) : DockerInspectSettings
- ResetSize(this DockerInspectSettings toolSettings) : DockerInspectSettings
- ResetType(this DockerInspectSettings toolSettings) : DockerInspectSettings
- SetFormat(this DockerInspectSettings toolSettings, string format) : DockerInspectSettings
- SetNames(this DockerInspectSettings toolSettings, string[] names) : DockerInspectSettings
- SetNames(this DockerInspectSettings toolSettings, IEnumerable<string> names) : DockerInspectSettings
- SetSize(this DockerInspectSettings toolSettings, bool? size) : DockerInspectSettings
- SetType(this DockerInspectSettings toolSettings, string type) : DockerInspectSettings
- ToggleSize(this DockerInspectSettings toolSettings) : DockerInspectSettings

### Nuke.Common.Tools.Docker.DockerKillSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Signal() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerKillSettingsExtensions

- AddContainers(this DockerKillSettings toolSettings, string[] containers) : DockerKillSettings
- AddContainers(this DockerKillSettings toolSettings, IEnumerable<string> containers) : DockerKillSettings
- ClearContainers(this DockerKillSettings toolSettings) : DockerKillSettings
- RemoveContainers(this DockerKillSettings toolSettings, string[] containers) : DockerKillSettings
- RemoveContainers(this DockerKillSettings toolSettings, IEnumerable<string> containers) : DockerKillSettings
- ResetSignal(this DockerKillSettings toolSettings) : DockerKillSettings
- SetContainers(this DockerKillSettings toolSettings, string[] containers) : DockerKillSettings
- SetContainers(this DockerKillSettings toolSettings, IEnumerable<string> containers) : DockerKillSettings
- SetSignal(this DockerKillSettings toolSettings, string signal) : DockerKillSettings

### Nuke.Common.Tools.Docker.DockerLoadSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Input() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerLoadSettingsExtensions

- DisableQuiet(this DockerLoadSettings toolSettings) : DockerLoadSettings
- EnableQuiet(this DockerLoadSettings toolSettings) : DockerLoadSettings
- ResetInput(this DockerLoadSettings toolSettings) : DockerLoadSettings
- ResetQuiet(this DockerLoadSettings toolSettings) : DockerLoadSettings
- SetInput(this DockerLoadSettings toolSettings, string input) : DockerLoadSettings
- SetQuiet(this DockerLoadSettings toolSettings, bool? quiet) : DockerLoadSettings
- ToggleQuiet(this DockerLoadSettings toolSettings) : DockerLoadSettings

### Nuke.Common.Tools.Docker.DockerLoginSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Password() : string
- get_Server() : string
- get_ToolPath() : string
- get_Username() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerLoginSettingsExtensions

- ResetPassword(this DockerLoginSettings toolSettings) : DockerLoginSettings
- ResetServer(this DockerLoginSettings toolSettings) : DockerLoginSettings
- ResetUsername(this DockerLoginSettings toolSettings) : DockerLoginSettings
- SetPassword(this DockerLoginSettings toolSettings, string password) : DockerLoginSettings
- SetServer(this DockerLoginSettings toolSettings, string server) : DockerLoginSettings
- SetUsername(this DockerLoginSettings toolSettings, string username) : DockerLoginSettings

### Nuke.Common.Tools.Docker.DockerLogoutSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Server() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerLogoutSettingsExtensions

- ResetServer(this DockerLogoutSettings toolSettings) : DockerLogoutSettings
- SetServer(this DockerLogoutSettings toolSettings, string server) : DockerLogoutSettings

### Nuke.Common.Tools.Docker.DockerLogsSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Details() : bool?
- get_Follow() : bool?
- get_Since() : string
- get_Tail() : string
- get_Timestamps() : bool?
- get_ToolPath() : string
- get_Until() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerLogsSettingsExtensions

- DisableDetails(this DockerLogsSettings toolSettings) : DockerLogsSettings
- DisableFollow(this DockerLogsSettings toolSettings) : DockerLogsSettings
- DisableTimestamps(this DockerLogsSettings toolSettings) : DockerLogsSettings
- EnableDetails(this DockerLogsSettings toolSettings) : DockerLogsSettings
- EnableFollow(this DockerLogsSettings toolSettings) : DockerLogsSettings
- EnableTimestamps(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetContainer(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetDetails(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetFollow(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetSince(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetTail(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetTimestamps(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ResetUntil(this DockerLogsSettings toolSettings) : DockerLogsSettings
- SetContainer(this DockerLogsSettings toolSettings, string container) : DockerLogsSettings
- SetDetails(this DockerLogsSettings toolSettings, bool? details) : DockerLogsSettings
- SetFollow(this DockerLogsSettings toolSettings, bool? follow) : DockerLogsSettings
- SetSince(this DockerLogsSettings toolSettings, string since) : DockerLogsSettings
- SetTail(this DockerLogsSettings toolSettings, string tail) : DockerLogsSettings
- SetTimestamps(this DockerLogsSettings toolSettings, bool? timestamps) : DockerLogsSettings
- SetUntil(this DockerLogsSettings toolSettings, string until) : DockerLogsSettings
- ToggleDetails(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ToggleFollow(this DockerLogsSettings toolSettings) : DockerLogsSettings
- ToggleTimestamps(this DockerLogsSettings toolSettings) : DockerLogsSettings

### Nuke.Common.Tools.Docker.DockerManifestAnnotateSettings

- .ctor()
- get_Arch() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Manifest() : string
- get_ManifestList() : string
- get_Os() : string
- get_OsFeatures() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Variant() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerManifestAnnotateSettingsExtensions

- AddOsFeatures(this DockerManifestAnnotateSettings toolSettings, string[] osFeatures) : DockerManifestAnnotateSettings
- AddOsFeatures(this DockerManifestAnnotateSettings toolSettings, IEnumerable<string> osFeatures) : DockerManifestAnnotateSettings
- ClearOsFeatures(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- RemoveOsFeatures(this DockerManifestAnnotateSettings toolSettings, string[] osFeatures) : DockerManifestAnnotateSettings
- RemoveOsFeatures(this DockerManifestAnnotateSettings toolSettings, IEnumerable<string> osFeatures) : DockerManifestAnnotateSettings
- ResetArch(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- ResetManifest(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- ResetManifestList(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- ResetOs(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- ResetVariant(this DockerManifestAnnotateSettings toolSettings) : DockerManifestAnnotateSettings
- SetArch(this DockerManifestAnnotateSettings toolSettings, string arch) : DockerManifestAnnotateSettings
- SetManifest(this DockerManifestAnnotateSettings toolSettings, string manifest) : DockerManifestAnnotateSettings
- SetManifestList(this DockerManifestAnnotateSettings toolSettings, string manifestList) : DockerManifestAnnotateSettings
- SetOs(this DockerManifestAnnotateSettings toolSettings, string os) : DockerManifestAnnotateSettings
- SetOsFeatures(this DockerManifestAnnotateSettings toolSettings, string[] osFeatures) : DockerManifestAnnotateSettings
- SetOsFeatures(this DockerManifestAnnotateSettings toolSettings, IEnumerable<string> osFeatures) : DockerManifestAnnotateSettings
- SetVariant(this DockerManifestAnnotateSettings toolSettings, string variant) : DockerManifestAnnotateSettings

### Nuke.Common.Tools.Docker.DockerManifestCreateSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ManifestList() : string
- get_Manifests() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerManifestCreateSettingsExtensions

- AddManifests(this DockerManifestCreateSettings toolSettings, string[] manifests) : DockerManifestCreateSettings
- AddManifests(this DockerManifestCreateSettings toolSettings, IEnumerable<string> manifests) : DockerManifestCreateSettings
- ClearManifests(this DockerManifestCreateSettings toolSettings) : DockerManifestCreateSettings
- RemoveManifests(this DockerManifestCreateSettings toolSettings, string[] manifests) : DockerManifestCreateSettings
- RemoveManifests(this DockerManifestCreateSettings toolSettings, IEnumerable<string> manifests) : DockerManifestCreateSettings
- ResetManifestList(this DockerManifestCreateSettings toolSettings) : DockerManifestCreateSettings
- SetManifestList(this DockerManifestCreateSettings toolSettings, string manifestList) : DockerManifestCreateSettings
- SetManifests(this DockerManifestCreateSettings toolSettings, string[] manifests) : DockerManifestCreateSettings
- SetManifests(this DockerManifestCreateSettings toolSettings, IEnumerable<string> manifests) : DockerManifestCreateSettings

### Nuke.Common.Tools.Docker.DockerManifestInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Insecure() : bool?
- get_Manifest() : string
- get_ManifestList() : string
- get_ToolPath() : string
- get_Verbose() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerManifestInspectSettingsExtensions

- DisableInsecure(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- DisableVerbose(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- EnableInsecure(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- EnableVerbose(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- ResetInsecure(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- ResetManifest(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- ResetManifestList(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- ResetVerbose(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- SetInsecure(this DockerManifestInspectSettings toolSettings, bool? insecure) : DockerManifestInspectSettings
- SetManifest(this DockerManifestInspectSettings toolSettings, string manifest) : DockerManifestInspectSettings
- SetManifestList(this DockerManifestInspectSettings toolSettings, string manifestList) : DockerManifestInspectSettings
- SetVerbose(this DockerManifestInspectSettings toolSettings, bool? verbose) : DockerManifestInspectSettings
- ToggleInsecure(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings
- ToggleVerbose(this DockerManifestInspectSettings toolSettings) : DockerManifestInspectSettings

### Nuke.Common.Tools.Docker.DockerManifestPushSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Insecure() : bool?
- get_ManifestList() : string
- get_Purge() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerManifestPushSettingsExtensions

- DisableInsecure(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- DisablePurge(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- EnableInsecure(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- EnablePurge(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- ResetInsecure(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- ResetManifestList(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- ResetPurge(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- SetInsecure(this DockerManifestPushSettings toolSettings, bool? insecure) : DockerManifestPushSettings
- SetManifestList(this DockerManifestPushSettings toolSettings, string manifestList) : DockerManifestPushSettings
- SetPurge(this DockerManifestPushSettings toolSettings, bool? purge) : DockerManifestPushSettings
- ToggleInsecure(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings
- TogglePurge(this DockerManifestPushSettings toolSettings) : DockerManifestPushSettings

### Nuke.Common.Tools.Docker.DockerManifestSettings

- .ctor()
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerManifestSettingsExtensions

- ResetCommand(this DockerManifestSettings toolSettings) : DockerManifestSettings
- SetCommand(this DockerManifestSettings toolSettings, string command) : DockerManifestSettings

### Nuke.Common.Tools.Docker.DockerNetworkConnectSettings

- .ctor()
- get_Alias() : IReadOnlyList<string>
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DriverOpt() : IReadOnlyList<string>
- get_Ip() : string
- get_Ip6() : string
- get_Link() : IReadOnlyList<string>
- get_LinkLocalIp() : IReadOnlyList<string>
- get_Network() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkConnectSettingsExtensions

- AddAlias(this DockerNetworkConnectSettings toolSettings, string[] alias) : DockerNetworkConnectSettings
- AddAlias(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> alias) : DockerNetworkConnectSettings
- AddDriverOpt(this DockerNetworkConnectSettings toolSettings, string[] driverOpt) : DockerNetworkConnectSettings
- AddDriverOpt(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> driverOpt) : DockerNetworkConnectSettings
- AddLink(this DockerNetworkConnectSettings toolSettings, string[] link) : DockerNetworkConnectSettings
- AddLink(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> link) : DockerNetworkConnectSettings
- AddLinkLocalIp(this DockerNetworkConnectSettings toolSettings, string[] linkLocalIp) : DockerNetworkConnectSettings
- AddLinkLocalIp(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerNetworkConnectSettings
- ClearAlias(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ClearDriverOpt(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ClearLink(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ClearLinkLocalIp(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- RemoveAlias(this DockerNetworkConnectSettings toolSettings, string[] alias) : DockerNetworkConnectSettings
- RemoveAlias(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> alias) : DockerNetworkConnectSettings
- RemoveDriverOpt(this DockerNetworkConnectSettings toolSettings, string[] driverOpt) : DockerNetworkConnectSettings
- RemoveDriverOpt(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> driverOpt) : DockerNetworkConnectSettings
- RemoveLink(this DockerNetworkConnectSettings toolSettings, string[] link) : DockerNetworkConnectSettings
- RemoveLink(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> link) : DockerNetworkConnectSettings
- RemoveLinkLocalIp(this DockerNetworkConnectSettings toolSettings, string[] linkLocalIp) : DockerNetworkConnectSettings
- RemoveLinkLocalIp(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerNetworkConnectSettings
- ResetContainer(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ResetIp(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ResetIp6(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- ResetNetwork(this DockerNetworkConnectSettings toolSettings) : DockerNetworkConnectSettings
- SetAlias(this DockerNetworkConnectSettings toolSettings, string[] alias) : DockerNetworkConnectSettings
- SetAlias(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> alias) : DockerNetworkConnectSettings
- SetContainer(this DockerNetworkConnectSettings toolSettings, string container) : DockerNetworkConnectSettings
- SetDriverOpt(this DockerNetworkConnectSettings toolSettings, string[] driverOpt) : DockerNetworkConnectSettings
- SetDriverOpt(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> driverOpt) : DockerNetworkConnectSettings
- SetIp(this DockerNetworkConnectSettings toolSettings, string ip) : DockerNetworkConnectSettings
- SetIp6(this DockerNetworkConnectSettings toolSettings, string ip6) : DockerNetworkConnectSettings
- SetLink(this DockerNetworkConnectSettings toolSettings, string[] link) : DockerNetworkConnectSettings
- SetLink(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> link) : DockerNetworkConnectSettings
- SetLinkLocalIp(this DockerNetworkConnectSettings toolSettings, string[] linkLocalIp) : DockerNetworkConnectSettings
- SetLinkLocalIp(this DockerNetworkConnectSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerNetworkConnectSettings
- SetNetwork(this DockerNetworkConnectSettings toolSettings, string network) : DockerNetworkConnectSettings

### Nuke.Common.Tools.Docker.DockerNetworkCreateSettings

- .ctor()
- get_Attachable() : bool?
- get_AuxAddress() : IReadOnlyDictionary<string, string>
- get_ConfigFrom() : string
- get_ConfigOnly() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Driver() : string
- get_Gateway() : IReadOnlyList<string>
- get_Ingress() : bool?
- get_Internal() : bool?
- get_IpamDriver() : string
- get_IpamOpt() : IReadOnlyDictionary<string, string>
- get_IpRange() : IReadOnlyList<string>
- get_Ipv6() : bool?
- get_Label() : IReadOnlyList<string>
- get_Network() : string
- get_Opt() : IReadOnlyDictionary<string, string>
- get_Scope() : string
- get_Subnet() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkCreateSettingsExtensions

- AddAuxAddress(this DockerNetworkCreateSettings toolSettings, string auxAddressKey, string auxAddressValue) : DockerNetworkCreateSettings
- AddGateway(this DockerNetworkCreateSettings toolSettings, string[] gateway) : DockerNetworkCreateSettings
- AddGateway(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> gateway) : DockerNetworkCreateSettings
- AddIpamOpt(this DockerNetworkCreateSettings toolSettings, string ipamOptKey, string ipamOptValue) : DockerNetworkCreateSettings
- AddIpRange(this DockerNetworkCreateSettings toolSettings, string[] ipRange) : DockerNetworkCreateSettings
- AddIpRange(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> ipRange) : DockerNetworkCreateSettings
- AddLabel(this DockerNetworkCreateSettings toolSettings, string[] label) : DockerNetworkCreateSettings
- AddLabel(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> label) : DockerNetworkCreateSettings
- AddOpt(this DockerNetworkCreateSettings toolSettings, string optKey, string optValue) : DockerNetworkCreateSettings
- AddSubnet(this DockerNetworkCreateSettings toolSettings, string[] subnet) : DockerNetworkCreateSettings
- AddSubnet(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> subnet) : DockerNetworkCreateSettings
- ClearAuxAddress(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearGateway(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearIpamOpt(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearIpRange(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearLabel(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearOpt(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ClearSubnet(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- DisableAttachable(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- DisableConfigOnly(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- DisableIngress(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- DisableInternal(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- DisableIpv6(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- EnableAttachable(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- EnableConfigOnly(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- EnableIngress(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- EnableInternal(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- EnableIpv6(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- RemoveAuxAddress(this DockerNetworkCreateSettings toolSettings, string auxAddressKey) : DockerNetworkCreateSettings
- RemoveGateway(this DockerNetworkCreateSettings toolSettings, string[] gateway) : DockerNetworkCreateSettings
- RemoveGateway(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> gateway) : DockerNetworkCreateSettings
- RemoveIpamOpt(this DockerNetworkCreateSettings toolSettings, string ipamOptKey) : DockerNetworkCreateSettings
- RemoveIpRange(this DockerNetworkCreateSettings toolSettings, string[] ipRange) : DockerNetworkCreateSettings
- RemoveIpRange(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> ipRange) : DockerNetworkCreateSettings
- RemoveLabel(this DockerNetworkCreateSettings toolSettings, string[] label) : DockerNetworkCreateSettings
- RemoveLabel(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> label) : DockerNetworkCreateSettings
- RemoveOpt(this DockerNetworkCreateSettings toolSettings, string optKey) : DockerNetworkCreateSettings
- RemoveSubnet(this DockerNetworkCreateSettings toolSettings, string[] subnet) : DockerNetworkCreateSettings
- RemoveSubnet(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> subnet) : DockerNetworkCreateSettings
- ResetAttachable(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetConfigFrom(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetConfigOnly(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetDriver(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetIngress(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetInternal(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetIpamDriver(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetIpv6(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetNetwork(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ResetScope(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- SetAttachable(this DockerNetworkCreateSettings toolSettings, bool? attachable) : DockerNetworkCreateSettings
- SetAuxAddress(this DockerNetworkCreateSettings toolSettings, IDictionary<string, string> auxAddress) : DockerNetworkCreateSettings
- SetAuxAddress(this DockerNetworkCreateSettings toolSettings, string auxAddressKey, string auxAddressValue) : DockerNetworkCreateSettings
- SetConfigFrom(this DockerNetworkCreateSettings toolSettings, string configFrom) : DockerNetworkCreateSettings
- SetConfigOnly(this DockerNetworkCreateSettings toolSettings, bool? configOnly) : DockerNetworkCreateSettings
- SetDriver(this DockerNetworkCreateSettings toolSettings, string driver) : DockerNetworkCreateSettings
- SetGateway(this DockerNetworkCreateSettings toolSettings, string[] gateway) : DockerNetworkCreateSettings
- SetGateway(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> gateway) : DockerNetworkCreateSettings
- SetIngress(this DockerNetworkCreateSettings toolSettings, bool? ingress) : DockerNetworkCreateSettings
- SetInternal(this DockerNetworkCreateSettings toolSettings, bool? internal) : DockerNetworkCreateSettings
- SetIpamDriver(this DockerNetworkCreateSettings toolSettings, string ipamDriver) : DockerNetworkCreateSettings
- SetIpamOpt(this DockerNetworkCreateSettings toolSettings, IDictionary<string, string> ipamOpt) : DockerNetworkCreateSettings
- SetIpamOpt(this DockerNetworkCreateSettings toolSettings, string ipamOptKey, string ipamOptValue) : DockerNetworkCreateSettings
- SetIpRange(this DockerNetworkCreateSettings toolSettings, string[] ipRange) : DockerNetworkCreateSettings
- SetIpRange(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> ipRange) : DockerNetworkCreateSettings
- SetIpv6(this DockerNetworkCreateSettings toolSettings, bool? ipv6) : DockerNetworkCreateSettings
- SetLabel(this DockerNetworkCreateSettings toolSettings, string[] label) : DockerNetworkCreateSettings
- SetLabel(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> label) : DockerNetworkCreateSettings
- SetNetwork(this DockerNetworkCreateSettings toolSettings, string network) : DockerNetworkCreateSettings
- SetOpt(this DockerNetworkCreateSettings toolSettings, IDictionary<string, string> opt) : DockerNetworkCreateSettings
- SetOpt(this DockerNetworkCreateSettings toolSettings, string optKey, string optValue) : DockerNetworkCreateSettings
- SetScope(this DockerNetworkCreateSettings toolSettings, string scope) : DockerNetworkCreateSettings
- SetSubnet(this DockerNetworkCreateSettings toolSettings, string[] subnet) : DockerNetworkCreateSettings
- SetSubnet(this DockerNetworkCreateSettings toolSettings, IEnumerable<string> subnet) : DockerNetworkCreateSettings
- ToggleAttachable(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ToggleConfigOnly(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ToggleIngress(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ToggleInternal(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings
- ToggleIpv6(this DockerNetworkCreateSettings toolSettings) : DockerNetworkCreateSettings

### Nuke.Common.Tools.Docker.DockerNetworkDisconnectSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Network() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkDisconnectSettingsExtensions

- DisableForce(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings
- EnableForce(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings
- ResetContainer(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings
- ResetForce(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings
- ResetNetwork(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings
- SetContainer(this DockerNetworkDisconnectSettings toolSettings, string container) : DockerNetworkDisconnectSettings
- SetForce(this DockerNetworkDisconnectSettings toolSettings, bool? force) : DockerNetworkDisconnectSettings
- SetNetwork(this DockerNetworkDisconnectSettings toolSettings, string network) : DockerNetworkDisconnectSettings
- ToggleForce(this DockerNetworkDisconnectSettings toolSettings) : DockerNetworkDisconnectSettings

### Nuke.Common.Tools.Docker.DockerNetworkInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Networks() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Verbose() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkInspectSettingsExtensions

- AddNetworks(this DockerNetworkInspectSettings toolSettings, string[] networks) : DockerNetworkInspectSettings
- AddNetworks(this DockerNetworkInspectSettings toolSettings, IEnumerable<string> networks) : DockerNetworkInspectSettings
- ClearNetworks(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings
- DisableVerbose(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings
- EnableVerbose(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings
- RemoveNetworks(this DockerNetworkInspectSettings toolSettings, string[] networks) : DockerNetworkInspectSettings
- RemoveNetworks(this DockerNetworkInspectSettings toolSettings, IEnumerable<string> networks) : DockerNetworkInspectSettings
- ResetFormat(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings
- ResetVerbose(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings
- SetFormat(this DockerNetworkInspectSettings toolSettings, string format) : DockerNetworkInspectSettings
- SetNetworks(this DockerNetworkInspectSettings toolSettings, string[] networks) : DockerNetworkInspectSettings
- SetNetworks(this DockerNetworkInspectSettings toolSettings, IEnumerable<string> networks) : DockerNetworkInspectSettings
- SetVerbose(this DockerNetworkInspectSettings toolSettings, bool? verbose) : DockerNetworkInspectSettings
- ToggleVerbose(this DockerNetworkInspectSettings toolSettings) : DockerNetworkInspectSettings

### Nuke.Common.Tools.Docker.DockerNetworkLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkLsSettingsExtensions

- DisableNoTrunc(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- DisableQuiet(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- EnableNoTrunc(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- EnableQuiet(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- ResetFilter(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- ResetFormat(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- ResetNoTrunc(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- ResetQuiet(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- SetFilter(this DockerNetworkLsSettings toolSettings, string filter) : DockerNetworkLsSettings
- SetFormat(this DockerNetworkLsSettings toolSettings, string format) : DockerNetworkLsSettings
- SetNoTrunc(this DockerNetworkLsSettings toolSettings, bool? noTrunc) : DockerNetworkLsSettings
- SetQuiet(this DockerNetworkLsSettings toolSettings, bool? quiet) : DockerNetworkLsSettings
- ToggleNoTrunc(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings
- ToggleQuiet(this DockerNetworkLsSettings toolSettings) : DockerNetworkLsSettings

### Nuke.Common.Tools.Docker.DockerNetworkPruneSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Force() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkPruneSettingsExtensions

- DisableForce(this DockerNetworkPruneSettings toolSettings) : DockerNetworkPruneSettings
- EnableForce(this DockerNetworkPruneSettings toolSettings) : DockerNetworkPruneSettings
- ResetFilter(this DockerNetworkPruneSettings toolSettings) : DockerNetworkPruneSettings
- ResetForce(this DockerNetworkPruneSettings toolSettings) : DockerNetworkPruneSettings
- SetFilter(this DockerNetworkPruneSettings toolSettings, string filter) : DockerNetworkPruneSettings
- SetForce(this DockerNetworkPruneSettings toolSettings, bool? force) : DockerNetworkPruneSettings
- ToggleForce(this DockerNetworkPruneSettings toolSettings) : DockerNetworkPruneSettings

### Nuke.Common.Tools.Docker.DockerNetworkRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Networks() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkRmSettingsExtensions

- AddNetworks(this DockerNetworkRmSettings toolSettings, string[] networks) : DockerNetworkRmSettings
- AddNetworks(this DockerNetworkRmSettings toolSettings, IEnumerable<string> networks) : DockerNetworkRmSettings
- ClearNetworks(this DockerNetworkRmSettings toolSettings) : DockerNetworkRmSettings
- RemoveNetworks(this DockerNetworkRmSettings toolSettings, string[] networks) : DockerNetworkRmSettings
- RemoveNetworks(this DockerNetworkRmSettings toolSettings, IEnumerable<string> networks) : DockerNetworkRmSettings
- SetNetworks(this DockerNetworkRmSettings toolSettings, string[] networks) : DockerNetworkRmSettings
- SetNetworks(this DockerNetworkRmSettings toolSettings, IEnumerable<string> networks) : DockerNetworkRmSettings

### Nuke.Common.Tools.Docker.DockerNetworkSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNetworkSettingsExtensions


### Nuke.Common.Tools.Docker.DockerNodeDemoteSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Nodes() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeDemoteSettingsExtensions

- AddNodes(this DockerNodeDemoteSettings toolSettings, string[] nodes) : DockerNodeDemoteSettings
- AddNodes(this DockerNodeDemoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodeDemoteSettings
- ClearNodes(this DockerNodeDemoteSettings toolSettings) : DockerNodeDemoteSettings
- RemoveNodes(this DockerNodeDemoteSettings toolSettings, string[] nodes) : DockerNodeDemoteSettings
- RemoveNodes(this DockerNodeDemoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodeDemoteSettings
- SetNodes(this DockerNodeDemoteSettings toolSettings, string[] nodes) : DockerNodeDemoteSettings
- SetNodes(this DockerNodeDemoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodeDemoteSettings

### Nuke.Common.Tools.Docker.DockerNodeInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Pretty() : bool?
- get_Selves() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeInspectSettingsExtensions

- AddSelves(this DockerNodeInspectSettings toolSettings, string[] selves) : DockerNodeInspectSettings
- AddSelves(this DockerNodeInspectSettings toolSettings, IEnumerable<string> selves) : DockerNodeInspectSettings
- ClearSelves(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings
- DisablePretty(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings
- EnablePretty(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings
- RemoveSelves(this DockerNodeInspectSettings toolSettings, string[] selves) : DockerNodeInspectSettings
- RemoveSelves(this DockerNodeInspectSettings toolSettings, IEnumerable<string> selves) : DockerNodeInspectSettings
- ResetFormat(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings
- ResetPretty(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings
- SetFormat(this DockerNodeInspectSettings toolSettings, string format) : DockerNodeInspectSettings
- SetPretty(this DockerNodeInspectSettings toolSettings, bool? pretty) : DockerNodeInspectSettings
- SetSelves(this DockerNodeInspectSettings toolSettings, string[] selves) : DockerNodeInspectSettings
- SetSelves(this DockerNodeInspectSettings toolSettings, IEnumerable<string> selves) : DockerNodeInspectSettings
- TogglePretty(this DockerNodeInspectSettings toolSettings) : DockerNodeInspectSettings

### Nuke.Common.Tools.Docker.DockerNodeLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeLsSettingsExtensions

- DisableQuiet(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings
- EnableQuiet(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings
- ResetFilter(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings
- ResetFormat(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings
- ResetQuiet(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings
- SetFilter(this DockerNodeLsSettings toolSettings, string filter) : DockerNodeLsSettings
- SetFormat(this DockerNodeLsSettings toolSettings, string format) : DockerNodeLsSettings
- SetQuiet(this DockerNodeLsSettings toolSettings, bool? quiet) : DockerNodeLsSettings
- ToggleQuiet(this DockerNodeLsSettings toolSettings) : DockerNodeLsSettings

### Nuke.Common.Tools.Docker.DockerNodePromoteSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Nodes() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodePromoteSettingsExtensions

- AddNodes(this DockerNodePromoteSettings toolSettings, string[] nodes) : DockerNodePromoteSettings
- AddNodes(this DockerNodePromoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodePromoteSettings
- ClearNodes(this DockerNodePromoteSettings toolSettings) : DockerNodePromoteSettings
- RemoveNodes(this DockerNodePromoteSettings toolSettings, string[] nodes) : DockerNodePromoteSettings
- RemoveNodes(this DockerNodePromoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodePromoteSettings
- SetNodes(this DockerNodePromoteSettings toolSettings, string[] nodes) : DockerNodePromoteSettings
- SetNodes(this DockerNodePromoteSettings toolSettings, IEnumerable<string> nodes) : DockerNodePromoteSettings

### Nuke.Common.Tools.Docker.DockerNodePsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Nodes() : IReadOnlyList<string>
- get_NoResolve() : bool?
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodePsSettingsExtensions

- AddNodes(this DockerNodePsSettings toolSettings, string[] nodes) : DockerNodePsSettings
- AddNodes(this DockerNodePsSettings toolSettings, IEnumerable<string> nodes) : DockerNodePsSettings
- ClearNodes(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- DisableNoResolve(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- DisableNoTrunc(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- DisableQuiet(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- EnableNoResolve(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- EnableNoTrunc(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- EnableQuiet(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- RemoveNodes(this DockerNodePsSettings toolSettings, string[] nodes) : DockerNodePsSettings
- RemoveNodes(this DockerNodePsSettings toolSettings, IEnumerable<string> nodes) : DockerNodePsSettings
- ResetFilter(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ResetFormat(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ResetNoResolve(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ResetNoTrunc(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ResetQuiet(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- SetFilter(this DockerNodePsSettings toolSettings, string filter) : DockerNodePsSettings
- SetFormat(this DockerNodePsSettings toolSettings, string format) : DockerNodePsSettings
- SetNodes(this DockerNodePsSettings toolSettings, string[] nodes) : DockerNodePsSettings
- SetNodes(this DockerNodePsSettings toolSettings, IEnumerable<string> nodes) : DockerNodePsSettings
- SetNoResolve(this DockerNodePsSettings toolSettings, bool? noResolve) : DockerNodePsSettings
- SetNoTrunc(this DockerNodePsSettings toolSettings, bool? noTrunc) : DockerNodePsSettings
- SetQuiet(this DockerNodePsSettings toolSettings, bool? quiet) : DockerNodePsSettings
- ToggleNoResolve(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ToggleNoTrunc(this DockerNodePsSettings toolSettings) : DockerNodePsSettings
- ToggleQuiet(this DockerNodePsSettings toolSettings) : DockerNodePsSettings

### Nuke.Common.Tools.Docker.DockerNodeRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Nodes() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeRmSettingsExtensions

- AddNodes(this DockerNodeRmSettings toolSettings, string[] nodes) : DockerNodeRmSettings
- AddNodes(this DockerNodeRmSettings toolSettings, IEnumerable<string> nodes) : DockerNodeRmSettings
- ClearNodes(this DockerNodeRmSettings toolSettings) : DockerNodeRmSettings
- DisableForce(this DockerNodeRmSettings toolSettings) : DockerNodeRmSettings
- EnableForce(this DockerNodeRmSettings toolSettings) : DockerNodeRmSettings
- RemoveNodes(this DockerNodeRmSettings toolSettings, string[] nodes) : DockerNodeRmSettings
- RemoveNodes(this DockerNodeRmSettings toolSettings, IEnumerable<string> nodes) : DockerNodeRmSettings
- ResetForce(this DockerNodeRmSettings toolSettings) : DockerNodeRmSettings
- SetForce(this DockerNodeRmSettings toolSettings, bool? force) : DockerNodeRmSettings
- SetNodes(this DockerNodeRmSettings toolSettings, string[] nodes) : DockerNodeRmSettings
- SetNodes(this DockerNodeRmSettings toolSettings, IEnumerable<string> nodes) : DockerNodeRmSettings
- ToggleForce(this DockerNodeRmSettings toolSettings) : DockerNodeRmSettings

### Nuke.Common.Tools.Docker.DockerNodeSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeSettingsExtensions


### Nuke.Common.Tools.Docker.DockerNodeUpdateSettings

- .ctor()
- get_Availability() : Availability
- get_CustomLogger() : Action<OutputType, string>
- get_LabelAdd() : IReadOnlyList<string>
- get_LabelRm() : IReadOnlyList<string>
- get_Node() : string
- get_Role() : Role
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerNodeUpdateSettingsExtensions

- AddLabelAdd(this DockerNodeUpdateSettings toolSettings, string[] labelAdd) : DockerNodeUpdateSettings
- AddLabelAdd(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerNodeUpdateSettings
- AddLabelRm(this DockerNodeUpdateSettings toolSettings, string[] labelRm) : DockerNodeUpdateSettings
- AddLabelRm(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerNodeUpdateSettings
- ClearLabelAdd(this DockerNodeUpdateSettings toolSettings) : DockerNodeUpdateSettings
- ClearLabelRm(this DockerNodeUpdateSettings toolSettings) : DockerNodeUpdateSettings
- RemoveLabelAdd(this DockerNodeUpdateSettings toolSettings, string[] labelAdd) : DockerNodeUpdateSettings
- RemoveLabelAdd(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerNodeUpdateSettings
- RemoveLabelRm(this DockerNodeUpdateSettings toolSettings, string[] labelRm) : DockerNodeUpdateSettings
- RemoveLabelRm(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerNodeUpdateSettings
- ResetAvailability(this DockerNodeUpdateSettings toolSettings) : DockerNodeUpdateSettings
- ResetNode(this DockerNodeUpdateSettings toolSettings) : DockerNodeUpdateSettings
- ResetRole(this DockerNodeUpdateSettings toolSettings) : DockerNodeUpdateSettings
- SetAvailability(this DockerNodeUpdateSettings toolSettings, Availability availability) : DockerNodeUpdateSettings
- SetLabelAdd(this DockerNodeUpdateSettings toolSettings, string[] labelAdd) : DockerNodeUpdateSettings
- SetLabelAdd(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerNodeUpdateSettings
- SetLabelRm(this DockerNodeUpdateSettings toolSettings, string[] labelRm) : DockerNodeUpdateSettings
- SetLabelRm(this DockerNodeUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerNodeUpdateSettings
- SetNode(this DockerNodeUpdateSettings toolSettings, string node) : DockerNodeUpdateSettings
- SetRole(this DockerNodeUpdateSettings toolSettings, Role role) : DockerNodeUpdateSettings

### Nuke.Common.Tools.Docker.DockerPauseSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPauseSettingsExtensions

- AddContainers(this DockerPauseSettings toolSettings, string[] containers) : DockerPauseSettings
- AddContainers(this DockerPauseSettings toolSettings, IEnumerable<string> containers) : DockerPauseSettings
- ClearContainers(this DockerPauseSettings toolSettings) : DockerPauseSettings
- RemoveContainers(this DockerPauseSettings toolSettings, string[] containers) : DockerPauseSettings
- RemoveContainers(this DockerPauseSettings toolSettings, IEnumerable<string> containers) : DockerPauseSettings
- SetContainers(this DockerPauseSettings toolSettings, string[] containers) : DockerPauseSettings
- SetContainers(this DockerPauseSettings toolSettings, IEnumerable<string> containers) : DockerPauseSettings

### Nuke.Common.Tools.Docker.DockerPluginCreateSettings

- .ctor()
- get_Compress() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Plugin() : string
- get_PluginDataDir() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginCreateSettingsExtensions

- DisableCompress(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings
- EnableCompress(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings
- ResetCompress(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings
- ResetPlugin(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings
- ResetPluginDataDir(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings
- SetCompress(this DockerPluginCreateSettings toolSettings, bool? compress) : DockerPluginCreateSettings
- SetPlugin(this DockerPluginCreateSettings toolSettings, string plugin) : DockerPluginCreateSettings
- SetPluginDataDir(this DockerPluginCreateSettings toolSettings, string pluginDataDir) : DockerPluginCreateSettings
- ToggleCompress(this DockerPluginCreateSettings toolSettings) : DockerPluginCreateSettings

### Nuke.Common.Tools.Docker.DockerPluginDisableSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Plugin() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginDisableSettingsExtensions

- DisableForce(this DockerPluginDisableSettings toolSettings) : DockerPluginDisableSettings
- EnableForce(this DockerPluginDisableSettings toolSettings) : DockerPluginDisableSettings
- ResetForce(this DockerPluginDisableSettings toolSettings) : DockerPluginDisableSettings
- ResetPlugin(this DockerPluginDisableSettings toolSettings) : DockerPluginDisableSettings
- SetForce(this DockerPluginDisableSettings toolSettings, bool? force) : DockerPluginDisableSettings
- SetPlugin(this DockerPluginDisableSettings toolSettings, string plugin) : DockerPluginDisableSettings
- ToggleForce(this DockerPluginDisableSettings toolSettings) : DockerPluginDisableSettings

### Nuke.Common.Tools.Docker.DockerPluginEnableSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Plugin() : string
- get_Timeout() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginEnableSettingsExtensions

- ResetPlugin(this DockerPluginEnableSettings toolSettings) : DockerPluginEnableSettings
- ResetTimeout(this DockerPluginEnableSettings toolSettings) : DockerPluginEnableSettings
- SetPlugin(this DockerPluginEnableSettings toolSettings, string plugin) : DockerPluginEnableSettings
- SetTimeout(this DockerPluginEnableSettings toolSettings, int? timeout) : DockerPluginEnableSettings

### Nuke.Common.Tools.Docker.DockerPluginInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Plugins() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginInspectSettingsExtensions

- AddPlugins(this DockerPluginInspectSettings toolSettings, string[] plugins) : DockerPluginInspectSettings
- AddPlugins(this DockerPluginInspectSettings toolSettings, IEnumerable<string> plugins) : DockerPluginInspectSettings
- ClearPlugins(this DockerPluginInspectSettings toolSettings) : DockerPluginInspectSettings
- RemovePlugins(this DockerPluginInspectSettings toolSettings, string[] plugins) : DockerPluginInspectSettings
- RemovePlugins(this DockerPluginInspectSettings toolSettings, IEnumerable<string> plugins) : DockerPluginInspectSettings
- ResetFormat(this DockerPluginInspectSettings toolSettings) : DockerPluginInspectSettings
- SetFormat(this DockerPluginInspectSettings toolSettings, string format) : DockerPluginInspectSettings
- SetPlugins(this DockerPluginInspectSettings toolSettings, string[] plugins) : DockerPluginInspectSettings
- SetPlugins(this DockerPluginInspectSettings toolSettings, IEnumerable<string> plugins) : DockerPluginInspectSettings

### Nuke.Common.Tools.Docker.DockerPluginInstallSettings

- .ctor()
- get_Alias() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Disable() : bool?
- get_DisableContentTrust() : bool?
- get_GrantAllPermissions() : bool?
- get_KeyValues() : IReadOnlyDictionary<string, string>
- get_Plugin() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginInstallSettingsExtensions

- AddKeyValue(this DockerPluginInstallSettings toolSettings, string keyValueKey, string keyValueValue) : DockerPluginInstallSettings
- ClearKeyValues(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- DisableDisable(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- DisableDisableContentTrust(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- DisableGrantAllPermissions(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- EnableDisable(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- EnableDisableContentTrust(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- EnableGrantAllPermissions(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- RemoveKeyValue(this DockerPluginInstallSettings toolSettings, string keyValueKey) : DockerPluginInstallSettings
- ResetAlias(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ResetDisable(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ResetDisableContentTrust(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ResetGrantAllPermissions(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ResetPlugin(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- SetAlias(this DockerPluginInstallSettings toolSettings, string alias) : DockerPluginInstallSettings
- SetDisable(this DockerPluginInstallSettings toolSettings, bool? disable) : DockerPluginInstallSettings
- SetDisableContentTrust(this DockerPluginInstallSettings toolSettings, bool? disableContentTrust) : DockerPluginInstallSettings
- SetGrantAllPermissions(this DockerPluginInstallSettings toolSettings, bool? grantAllPermissions) : DockerPluginInstallSettings
- SetKeyValue(this DockerPluginInstallSettings toolSettings, string keyValueKey, string keyValueValue) : DockerPluginInstallSettings
- SetKeyValues(this DockerPluginInstallSettings toolSettings, IDictionary<string, string> keyValues) : DockerPluginInstallSettings
- SetPlugin(this DockerPluginInstallSettings toolSettings, string plugin) : DockerPluginInstallSettings
- ToggleDisable(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ToggleDisableContentTrust(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings
- ToggleGrantAllPermissions(this DockerPluginInstallSettings toolSettings) : DockerPluginInstallSettings

### Nuke.Common.Tools.Docker.DockerPluginLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginLsSettingsExtensions

- DisableNoTrunc(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- DisableQuiet(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- EnableNoTrunc(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- EnableQuiet(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- ResetFilter(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- ResetFormat(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- ResetNoTrunc(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- ResetQuiet(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- SetFilter(this DockerPluginLsSettings toolSettings, string filter) : DockerPluginLsSettings
- SetFormat(this DockerPluginLsSettings toolSettings, string format) : DockerPluginLsSettings
- SetNoTrunc(this DockerPluginLsSettings toolSettings, bool? noTrunc) : DockerPluginLsSettings
- SetQuiet(this DockerPluginLsSettings toolSettings, bool? quiet) : DockerPluginLsSettings
- ToggleNoTrunc(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings
- ToggleQuiet(this DockerPluginLsSettings toolSettings) : DockerPluginLsSettings

### Nuke.Common.Tools.Docker.DockerPluginPushSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_Plugin() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginPushSettingsExtensions

- DisableDisableContentTrust(this DockerPluginPushSettings toolSettings) : DockerPluginPushSettings
- EnableDisableContentTrust(this DockerPluginPushSettings toolSettings) : DockerPluginPushSettings
- ResetDisableContentTrust(this DockerPluginPushSettings toolSettings) : DockerPluginPushSettings
- ResetPlugin(this DockerPluginPushSettings toolSettings) : DockerPluginPushSettings
- SetDisableContentTrust(this DockerPluginPushSettings toolSettings, bool? disableContentTrust) : DockerPluginPushSettings
- SetPlugin(this DockerPluginPushSettings toolSettings, string plugin) : DockerPluginPushSettings
- ToggleDisableContentTrust(this DockerPluginPushSettings toolSettings) : DockerPluginPushSettings

### Nuke.Common.Tools.Docker.DockerPluginRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Plugins() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginRmSettingsExtensions

- AddPlugins(this DockerPluginRmSettings toolSettings, string[] plugins) : DockerPluginRmSettings
- AddPlugins(this DockerPluginRmSettings toolSettings, IEnumerable<string> plugins) : DockerPluginRmSettings
- ClearPlugins(this DockerPluginRmSettings toolSettings) : DockerPluginRmSettings
- DisableForce(this DockerPluginRmSettings toolSettings) : DockerPluginRmSettings
- EnableForce(this DockerPluginRmSettings toolSettings) : DockerPluginRmSettings
- RemovePlugins(this DockerPluginRmSettings toolSettings, string[] plugins) : DockerPluginRmSettings
- RemovePlugins(this DockerPluginRmSettings toolSettings, IEnumerable<string> plugins) : DockerPluginRmSettings
- ResetForce(this DockerPluginRmSettings toolSettings) : DockerPluginRmSettings
- SetForce(this DockerPluginRmSettings toolSettings, bool? force) : DockerPluginRmSettings
- SetPlugins(this DockerPluginRmSettings toolSettings, string[] plugins) : DockerPluginRmSettings
- SetPlugins(this DockerPluginRmSettings toolSettings, IEnumerable<string> plugins) : DockerPluginRmSettings
- ToggleForce(this DockerPluginRmSettings toolSettings) : DockerPluginRmSettings

### Nuke.Common.Tools.Docker.DockerPluginSetSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_KeyValues() : IReadOnlyDictionary<string, string>
- get_Plugin() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginSetSettingsExtensions

- AddKeyValue(this DockerPluginSetSettings toolSettings, string keyValueKey, string keyValueValue) : DockerPluginSetSettings
- ClearKeyValues(this DockerPluginSetSettings toolSettings) : DockerPluginSetSettings
- RemoveKeyValue(this DockerPluginSetSettings toolSettings, string keyValueKey) : DockerPluginSetSettings
- ResetPlugin(this DockerPluginSetSettings toolSettings) : DockerPluginSetSettings
- SetKeyValue(this DockerPluginSetSettings toolSettings, string keyValueKey, string keyValueValue) : DockerPluginSetSettings
- SetKeyValues(this DockerPluginSetSettings toolSettings, IDictionary<string, string> keyValues) : DockerPluginSetSettings
- SetPlugin(this DockerPluginSetSettings toolSettings, string plugin) : DockerPluginSetSettings

### Nuke.Common.Tools.Docker.DockerPluginSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginSettingsExtensions


### Nuke.Common.Tools.Docker.DockerPluginUpgradeSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_GrantAllPermissions() : bool?
- get_Plugin() : string
- get_Remote() : string
- get_SkipRemoteCheck() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPluginUpgradeSettingsExtensions

- DisableDisableContentTrust(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- DisableGrantAllPermissions(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- DisableSkipRemoteCheck(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- EnableDisableContentTrust(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- EnableGrantAllPermissions(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- EnableSkipRemoteCheck(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ResetDisableContentTrust(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ResetGrantAllPermissions(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ResetPlugin(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ResetRemote(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ResetSkipRemoteCheck(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- SetDisableContentTrust(this DockerPluginUpgradeSettings toolSettings, bool? disableContentTrust) : DockerPluginUpgradeSettings
- SetGrantAllPermissions(this DockerPluginUpgradeSettings toolSettings, bool? grantAllPermissions) : DockerPluginUpgradeSettings
- SetPlugin(this DockerPluginUpgradeSettings toolSettings, string plugin) : DockerPluginUpgradeSettings
- SetRemote(this DockerPluginUpgradeSettings toolSettings, string remote) : DockerPluginUpgradeSettings
- SetSkipRemoteCheck(this DockerPluginUpgradeSettings toolSettings, bool? skipRemoteCheck) : DockerPluginUpgradeSettings
- ToggleDisableContentTrust(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ToggleGrantAllPermissions(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings
- ToggleSkipRemoteCheck(this DockerPluginUpgradeSettings toolSettings) : DockerPluginUpgradeSettings

### Nuke.Common.Tools.Docker.DockerPortSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_PrivatePort() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPortSettingsExtensions

- ResetContainer(this DockerPortSettings toolSettings) : DockerPortSettings
- ResetPrivatePort(this DockerPortSettings toolSettings) : DockerPortSettings
- SetContainer(this DockerPortSettings toolSettings, string container) : DockerPortSettings
- SetPrivatePort(this DockerPortSettings toolSettings, string privatePort) : DockerPortSettings

### Nuke.Common.Tools.Docker.DockerPsSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Last() : int?
- get_Latest() : bool?
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Size() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPsSettingsExtensions

- DisableAll(this DockerPsSettings toolSettings) : DockerPsSettings
- DisableLatest(this DockerPsSettings toolSettings) : DockerPsSettings
- DisableNoTrunc(this DockerPsSettings toolSettings) : DockerPsSettings
- DisableQuiet(this DockerPsSettings toolSettings) : DockerPsSettings
- DisableSize(this DockerPsSettings toolSettings) : DockerPsSettings
- EnableAll(this DockerPsSettings toolSettings) : DockerPsSettings
- EnableLatest(this DockerPsSettings toolSettings) : DockerPsSettings
- EnableNoTrunc(this DockerPsSettings toolSettings) : DockerPsSettings
- EnableQuiet(this DockerPsSettings toolSettings) : DockerPsSettings
- EnableSize(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetAll(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetFilter(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetFormat(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetLast(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetLatest(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetNoTrunc(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetQuiet(this DockerPsSettings toolSettings) : DockerPsSettings
- ResetSize(this DockerPsSettings toolSettings) : DockerPsSettings
- SetAll(this DockerPsSettings toolSettings, bool? all) : DockerPsSettings
- SetFilter(this DockerPsSettings toolSettings, string filter) : DockerPsSettings
- SetFormat(this DockerPsSettings toolSettings, string format) : DockerPsSettings
- SetLast(this DockerPsSettings toolSettings, int? last) : DockerPsSettings
- SetLatest(this DockerPsSettings toolSettings, bool? latest) : DockerPsSettings
- SetNoTrunc(this DockerPsSettings toolSettings, bool? noTrunc) : DockerPsSettings
- SetQuiet(this DockerPsSettings toolSettings, bool? quiet) : DockerPsSettings
- SetSize(this DockerPsSettings toolSettings, bool? size) : DockerPsSettings
- ToggleAll(this DockerPsSettings toolSettings) : DockerPsSettings
- ToggleLatest(this DockerPsSettings toolSettings) : DockerPsSettings
- ToggleNoTrunc(this DockerPsSettings toolSettings) : DockerPsSettings
- ToggleQuiet(this DockerPsSettings toolSettings) : DockerPsSettings
- ToggleSize(this DockerPsSettings toolSettings) : DockerPsSettings

### Nuke.Common.Tools.Docker.DockerPullSettings

- .ctor()
- get_AllTags() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_Name() : string
- get_Platform() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPullSettingsExtensions

- DisableAllTags(this DockerPullSettings toolSettings) : DockerPullSettings
- DisableDisableContentTrust(this DockerPullSettings toolSettings) : DockerPullSettings
- DisableQuiet(this DockerPullSettings toolSettings) : DockerPullSettings
- EnableAllTags(this DockerPullSettings toolSettings) : DockerPullSettings
- EnableDisableContentTrust(this DockerPullSettings toolSettings) : DockerPullSettings
- EnableQuiet(this DockerPullSettings toolSettings) : DockerPullSettings
- ResetAllTags(this DockerPullSettings toolSettings) : DockerPullSettings
- ResetDisableContentTrust(this DockerPullSettings toolSettings) : DockerPullSettings
- ResetName(this DockerPullSettings toolSettings) : DockerPullSettings
- ResetPlatform(this DockerPullSettings toolSettings) : DockerPullSettings
- ResetQuiet(this DockerPullSettings toolSettings) : DockerPullSettings
- SetAllTags(this DockerPullSettings toolSettings, bool? allTags) : DockerPullSettings
- SetDisableContentTrust(this DockerPullSettings toolSettings, bool? disableContentTrust) : DockerPullSettings
- SetName(this DockerPullSettings toolSettings, string name) : DockerPullSettings
- SetPlatform(this DockerPullSettings toolSettings, string platform) : DockerPullSettings
- SetQuiet(this DockerPullSettings toolSettings, bool? quiet) : DockerPullSettings
- ToggleAllTags(this DockerPullSettings toolSettings) : DockerPullSettings
- ToggleDisableContentTrust(this DockerPullSettings toolSettings) : DockerPullSettings
- ToggleQuiet(this DockerPullSettings toolSettings) : DockerPullSettings

### Nuke.Common.Tools.Docker.DockerPushSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_DisableContentTrust() : bool?
- get_Name() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerPushSettingsExtensions

- DisableDisableContentTrust(this DockerPushSettings toolSettings) : DockerPushSettings
- EnableDisableContentTrust(this DockerPushSettings toolSettings) : DockerPushSettings
- ResetDisableContentTrust(this DockerPushSettings toolSettings) : DockerPushSettings
- ResetName(this DockerPushSettings toolSettings) : DockerPushSettings
- SetDisableContentTrust(this DockerPushSettings toolSettings, bool? disableContentTrust) : DockerPushSettings
- SetName(this DockerPushSettings toolSettings, string name) : DockerPushSettings
- ToggleDisableContentTrust(this DockerPushSettings toolSettings) : DockerPushSettings

### Nuke.Common.Tools.Docker.DockerRenameSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_NewName() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerRenameSettingsExtensions

- ResetContainer(this DockerRenameSettings toolSettings) : DockerRenameSettings
- ResetNewName(this DockerRenameSettings toolSettings) : DockerRenameSettings
- SetContainer(this DockerRenameSettings toolSettings, string container) : DockerRenameSettings
- SetNewName(this DockerRenameSettings toolSettings, string newName) : DockerRenameSettings

### Nuke.Common.Tools.Docker.DockerRestartSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Time() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerRestartSettingsExtensions

- AddContainers(this DockerRestartSettings toolSettings, string[] containers) : DockerRestartSettings
- AddContainers(this DockerRestartSettings toolSettings, IEnumerable<string> containers) : DockerRestartSettings
- ClearContainers(this DockerRestartSettings toolSettings) : DockerRestartSettings
- RemoveContainers(this DockerRestartSettings toolSettings, string[] containers) : DockerRestartSettings
- RemoveContainers(this DockerRestartSettings toolSettings, IEnumerable<string> containers) : DockerRestartSettings
- ResetTime(this DockerRestartSettings toolSettings) : DockerRestartSettings
- SetContainers(this DockerRestartSettings toolSettings, string[] containers) : DockerRestartSettings
- SetContainers(this DockerRestartSettings toolSettings, IEnumerable<string> containers) : DockerRestartSettings
- SetTime(this DockerRestartSettings toolSettings, int? time) : DockerRestartSettings

### Nuke.Common.Tools.Docker.DockerRmiSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Images() : IReadOnlyList<string>
- get_NoPrune() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerRmiSettingsExtensions

- AddImages(this DockerRmiSettings toolSettings, string[] images) : DockerRmiSettings
- AddImages(this DockerRmiSettings toolSettings, IEnumerable<string> images) : DockerRmiSettings
- ClearImages(this DockerRmiSettings toolSettings) : DockerRmiSettings
- DisableForce(this DockerRmiSettings toolSettings) : DockerRmiSettings
- DisableNoPrune(this DockerRmiSettings toolSettings) : DockerRmiSettings
- EnableForce(this DockerRmiSettings toolSettings) : DockerRmiSettings
- EnableNoPrune(this DockerRmiSettings toolSettings) : DockerRmiSettings
- RemoveImages(this DockerRmiSettings toolSettings, string[] images) : DockerRmiSettings
- RemoveImages(this DockerRmiSettings toolSettings, IEnumerable<string> images) : DockerRmiSettings
- ResetForce(this DockerRmiSettings toolSettings) : DockerRmiSettings
- ResetNoPrune(this DockerRmiSettings toolSettings) : DockerRmiSettings
- SetForce(this DockerRmiSettings toolSettings, bool? force) : DockerRmiSettings
- SetImages(this DockerRmiSettings toolSettings, string[] images) : DockerRmiSettings
- SetImages(this DockerRmiSettings toolSettings, IEnumerable<string> images) : DockerRmiSettings
- SetNoPrune(this DockerRmiSettings toolSettings, bool? noPrune) : DockerRmiSettings
- ToggleForce(this DockerRmiSettings toolSettings) : DockerRmiSettings
- ToggleNoPrune(this DockerRmiSettings toolSettings) : DockerRmiSettings

### Nuke.Common.Tools.Docker.DockerRmSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Link() : bool?
- get_ToolPath() : string
- get_Volumes() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerRmSettingsExtensions

- AddContainers(this DockerRmSettings toolSettings, string[] containers) : DockerRmSettings
- AddContainers(this DockerRmSettings toolSettings, IEnumerable<string> containers) : DockerRmSettings
- ClearContainers(this DockerRmSettings toolSettings) : DockerRmSettings
- DisableForce(this DockerRmSettings toolSettings) : DockerRmSettings
- DisableLink(this DockerRmSettings toolSettings) : DockerRmSettings
- DisableVolumes(this DockerRmSettings toolSettings) : DockerRmSettings
- EnableForce(this DockerRmSettings toolSettings) : DockerRmSettings
- EnableLink(this DockerRmSettings toolSettings) : DockerRmSettings
- EnableVolumes(this DockerRmSettings toolSettings) : DockerRmSettings
- RemoveContainers(this DockerRmSettings toolSettings, string[] containers) : DockerRmSettings
- RemoveContainers(this DockerRmSettings toolSettings, IEnumerable<string> containers) : DockerRmSettings
- ResetForce(this DockerRmSettings toolSettings) : DockerRmSettings
- ResetLink(this DockerRmSettings toolSettings) : DockerRmSettings
- ResetVolumes(this DockerRmSettings toolSettings) : DockerRmSettings
- SetContainers(this DockerRmSettings toolSettings, string[] containers) : DockerRmSettings
- SetContainers(this DockerRmSettings toolSettings, IEnumerable<string> containers) : DockerRmSettings
- SetForce(this DockerRmSettings toolSettings, bool? force) : DockerRmSettings
- SetLink(this DockerRmSettings toolSettings, bool? link) : DockerRmSettings
- SetVolumes(this DockerRmSettings toolSettings, bool? volumes) : DockerRmSettings
- ToggleForce(this DockerRmSettings toolSettings) : DockerRmSettings
- ToggleLink(this DockerRmSettings toolSettings) : DockerRmSettings
- ToggleVolumes(this DockerRmSettings toolSettings) : DockerRmSettings

### Nuke.Common.Tools.Docker.DockerRunSettings

- .ctor()
- get_AddHost() : IReadOnlyList<string>
- get_Args() : IReadOnlyList<string>
- get_Attach() : IReadOnlyList<string>
- get_BlkioWeight() : int?
- get_BlkioWeightDevice() : IReadOnlyList<string>
- get_CapAdd() : IReadOnlyList<string>
- get_CapDrop() : IReadOnlyList<string>
- get_CgroupParent() : string
- get_Cidfile() : string
- get_Command() : string
- get_CpuCount() : long?
- get_CpuPercent() : long?
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_DetachKeys() : string
- get_Device() : IReadOnlyList<string>
- get_DeviceCgroupRule() : IReadOnlyList<string>
- get_DeviceReadBps() : IReadOnlyList<string>
- get_DeviceReadIops() : IReadOnlyList<string>
- get_DeviceWriteBps() : IReadOnlyList<string>
- get_DeviceWriteIops() : IReadOnlyList<string>
- get_DisableContentTrust() : bool?
- get_Dns() : IReadOnlyList<string>
- get_DnsOpt() : IReadOnlyList<string>
- get_DnsOption() : IReadOnlyList<string>
- get_DnsSearch() : IReadOnlyList<string>
- get_Domainname() : string
- get_Entrypoint() : string
- get_Env() : IReadOnlyList<string>
- get_EnvFile() : IReadOnlyList<string>
- get_Expose() : IReadOnlyList<string>
- get_Gpus() : string
- get_GroupAdd() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_Help() : bool?
- get_Hostname() : string
- get_Image() : string
- get_Init() : bool?
- get_Interactive() : bool?
- get_IoMaxbandwidth() : long?
- get_IoMaxiops() : int?
- get_Ip() : string
- get_Ip6() : string
- get_Ipc() : string
- get_Isolation() : string
- get_KernelMemory() : long?
- get_Label() : IReadOnlyList<string>
- get_LabelFile() : IReadOnlyList<string>
- get_Link() : IReadOnlyList<string>
- get_LinkLocalIp() : IReadOnlyList<string>
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_MacAddress() : string
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_MemorySwappiness() : long?
- get_Mount() : string
- get_Name() : string
- get_Net() : string
- get_NetAlias() : IReadOnlyList<string>
- get_Network() : string
- get_NetworkAlias() : IReadOnlyList<string>
- get_NoHealthcheck() : bool?
- get_OomKillDisable() : bool?
- get_OomScoreAdj() : int?
- get_Pid() : string
- get_PidsLimit() : long?
- get_Platform() : string
- get_Privileged() : bool?
- get_Publish() : IReadOnlyList<string>
- get_PublishAll() : bool?
- get_ReadOnly() : bool?
- get_Restart() : string
- get_Rm() : bool?
- get_Runtime() : string
- get_SecurityOpt() : IReadOnlyList<string>
- get_ShmSize() : long?
- get_SigProxy() : bool?
- get_StopSignal() : string
- get_StopTimeout() : int?
- get_StorageOpt() : IReadOnlyList<string>
- get_Sysctl() : IReadOnlyDictionary<string, string>
- get_Tmpfs() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_Ulimit() : string
- get_User() : string
- get_Userns() : string
- get_Uts() : string
- get_Volume() : IReadOnlyList<string>
- get_VolumeDriver() : string
- get_VolumesFrom() : IReadOnlyList<string>
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerRunSettingsExtensions

- AddAddHost(this DockerRunSettings toolSettings, string[] addHost) : DockerRunSettings
- AddAddHost(this DockerRunSettings toolSettings, IEnumerable<string> addHost) : DockerRunSettings
- AddArgs(this DockerRunSettings toolSettings, string[] args) : DockerRunSettings
- AddArgs(this DockerRunSettings toolSettings, IEnumerable<string> args) : DockerRunSettings
- AddAttach(this DockerRunSettings toolSettings, string[] attach) : DockerRunSettings
- AddAttach(this DockerRunSettings toolSettings, IEnumerable<string> attach) : DockerRunSettings
- AddBlkioWeightDevice(this DockerRunSettings toolSettings, string[] blkioWeightDevice) : DockerRunSettings
- AddBlkioWeightDevice(this DockerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerRunSettings
- AddCapAdd(this DockerRunSettings toolSettings, string[] capAdd) : DockerRunSettings
- AddCapAdd(this DockerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerRunSettings
- AddCapDrop(this DockerRunSettings toolSettings, string[] capDrop) : DockerRunSettings
- AddCapDrop(this DockerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerRunSettings
- AddDevice(this DockerRunSettings toolSettings, string[] device) : DockerRunSettings
- AddDevice(this DockerRunSettings toolSettings, IEnumerable<string> device) : DockerRunSettings
- AddDeviceCgroupRule(this DockerRunSettings toolSettings, string[] deviceCgroupRule) : DockerRunSettings
- AddDeviceCgroupRule(this DockerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerRunSettings
- AddDeviceReadBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerRunSettings
- AddDeviceReadBps(this DockerRunSettings toolSettings, string[] deviceReadBps) : DockerRunSettings
- AddDeviceReadIops(this DockerRunSettings toolSettings, string[] deviceReadIops) : DockerRunSettings
- AddDeviceReadIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerRunSettings
- AddDeviceWriteBps(this DockerRunSettings toolSettings, string[] deviceWriteBps) : DockerRunSettings
- AddDeviceWriteBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerRunSettings
- AddDeviceWriteIops(this DockerRunSettings toolSettings, string[] deviceWriteIops) : DockerRunSettings
- AddDeviceWriteIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerRunSettings
- AddDns(this DockerRunSettings toolSettings, string[] dns) : DockerRunSettings
- AddDns(this DockerRunSettings toolSettings, IEnumerable<string> dns) : DockerRunSettings
- AddDnsOpt(this DockerRunSettings toolSettings, string[] dnsOpt) : DockerRunSettings
- AddDnsOpt(this DockerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerRunSettings
- AddDnsOption(this DockerRunSettings toolSettings, string[] dnsOption) : DockerRunSettings
- AddDnsOption(this DockerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerRunSettings
- AddDnsSearch(this DockerRunSettings toolSettings, string[] dnsSearch) : DockerRunSettings
- AddDnsSearch(this DockerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerRunSettings
- AddEnv(this DockerRunSettings toolSettings, string[] env) : DockerRunSettings
- AddEnv(this DockerRunSettings toolSettings, IEnumerable<string> env) : DockerRunSettings
- AddEnvFile(this DockerRunSettings toolSettings, string[] envFile) : DockerRunSettings
- AddEnvFile(this DockerRunSettings toolSettings, IEnumerable<string> envFile) : DockerRunSettings
- AddExpose(this DockerRunSettings toolSettings, string[] expose) : DockerRunSettings
- AddExpose(this DockerRunSettings toolSettings, IEnumerable<string> expose) : DockerRunSettings
- AddGroupAdd(this DockerRunSettings toolSettings, string[] groupAdd) : DockerRunSettings
- AddGroupAdd(this DockerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerRunSettings
- AddLabel(this DockerRunSettings toolSettings, string[] label) : DockerRunSettings
- AddLabel(this DockerRunSettings toolSettings, IEnumerable<string> label) : DockerRunSettings
- AddLabelFile(this DockerRunSettings toolSettings, string[] labelFile) : DockerRunSettings
- AddLabelFile(this DockerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerRunSettings
- AddLink(this DockerRunSettings toolSettings, string[] link) : DockerRunSettings
- AddLink(this DockerRunSettings toolSettings, IEnumerable<string> link) : DockerRunSettings
- AddLinkLocalIp(this DockerRunSettings toolSettings, string[] linkLocalIp) : DockerRunSettings
- AddLinkLocalIp(this DockerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerRunSettings
- AddLogOpt(this DockerRunSettings toolSettings, string[] logOpt) : DockerRunSettings
- AddLogOpt(this DockerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerRunSettings
- AddNetAlias(this DockerRunSettings toolSettings, string[] netAlias) : DockerRunSettings
- AddNetAlias(this DockerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerRunSettings
- AddNetworkAlias(this DockerRunSettings toolSettings, string[] networkAlias) : DockerRunSettings
- AddNetworkAlias(this DockerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerRunSettings
- AddPublish(this DockerRunSettings toolSettings, string[] publish) : DockerRunSettings
- AddPublish(this DockerRunSettings toolSettings, IEnumerable<string> publish) : DockerRunSettings
- AddSecurityOpt(this DockerRunSettings toolSettings, string[] securityOpt) : DockerRunSettings
- AddSecurityOpt(this DockerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerRunSettings
- AddStorageOpt(this DockerRunSettings toolSettings, string[] storageOpt) : DockerRunSettings
- AddStorageOpt(this DockerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerRunSettings
- AddSysctl(this DockerRunSettings toolSettings, string sysctlKey, string sysctlValue) : DockerRunSettings
- AddTmpfs(this DockerRunSettings toolSettings, string[] tmpfs) : DockerRunSettings
- AddTmpfs(this DockerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerRunSettings
- AddVolume(this DockerRunSettings toolSettings, string[] volume) : DockerRunSettings
- AddVolume(this DockerRunSettings toolSettings, IEnumerable<string> volume) : DockerRunSettings
- AddVolumesFrom(this DockerRunSettings toolSettings, string[] volumesFrom) : DockerRunSettings
- AddVolumesFrom(this DockerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerRunSettings
- ClearAddHost(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearArgs(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearAttach(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearBlkioWeightDevice(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearCapAdd(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearCapDrop(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDevice(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDeviceCgroupRule(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDeviceReadBps(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDeviceReadIops(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDeviceWriteBps(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDeviceWriteIops(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDns(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDnsOpt(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDnsOption(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearDnsSearch(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearEnv(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearEnvFile(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearExpose(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearGroupAdd(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearLabel(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearLabelFile(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearLink(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearLinkLocalIp(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearLogOpt(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearNetAlias(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearNetworkAlias(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearPublish(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearSecurityOpt(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearStorageOpt(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearSysctl(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearTmpfs(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearVolume(this DockerRunSettings toolSettings) : DockerRunSettings
- ClearVolumesFrom(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableDetach(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableDisableContentTrust(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableHelp(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableInit(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableInteractive(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableNoHealthcheck(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableOomKillDisable(this DockerRunSettings toolSettings) : DockerRunSettings
- DisablePrivileged(this DockerRunSettings toolSettings) : DockerRunSettings
- DisablePublishAll(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableReadOnly(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableRm(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableSigProxy(this DockerRunSettings toolSettings) : DockerRunSettings
- DisableTty(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableDetach(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableDisableContentTrust(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableHelp(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableInit(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableInteractive(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableNoHealthcheck(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableOomKillDisable(this DockerRunSettings toolSettings) : DockerRunSettings
- EnablePrivileged(this DockerRunSettings toolSettings) : DockerRunSettings
- EnablePublishAll(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableReadOnly(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableRm(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableSigProxy(this DockerRunSettings toolSettings) : DockerRunSettings
- EnableTty(this DockerRunSettings toolSettings) : DockerRunSettings
- RemoveAddHost(this DockerRunSettings toolSettings, string[] addHost) : DockerRunSettings
- RemoveAddHost(this DockerRunSettings toolSettings, IEnumerable<string> addHost) : DockerRunSettings
- RemoveArgs(this DockerRunSettings toolSettings, string[] args) : DockerRunSettings
- RemoveArgs(this DockerRunSettings toolSettings, IEnumerable<string> args) : DockerRunSettings
- RemoveAttach(this DockerRunSettings toolSettings, string[] attach) : DockerRunSettings
- RemoveAttach(this DockerRunSettings toolSettings, IEnumerable<string> attach) : DockerRunSettings
- RemoveBlkioWeightDevice(this DockerRunSettings toolSettings, string[] blkioWeightDevice) : DockerRunSettings
- RemoveBlkioWeightDevice(this DockerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerRunSettings
- RemoveCapAdd(this DockerRunSettings toolSettings, string[] capAdd) : DockerRunSettings
- RemoveCapAdd(this DockerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerRunSettings
- RemoveCapDrop(this DockerRunSettings toolSettings, string[] capDrop) : DockerRunSettings
- RemoveCapDrop(this DockerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerRunSettings
- RemoveDevice(this DockerRunSettings toolSettings, string[] device) : DockerRunSettings
- RemoveDevice(this DockerRunSettings toolSettings, IEnumerable<string> device) : DockerRunSettings
- RemoveDeviceCgroupRule(this DockerRunSettings toolSettings, string[] deviceCgroupRule) : DockerRunSettings
- RemoveDeviceCgroupRule(this DockerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerRunSettings
- RemoveDeviceReadBps(this DockerRunSettings toolSettings, string[] deviceReadBps) : DockerRunSettings
- RemoveDeviceReadBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerRunSettings
- RemoveDeviceReadIops(this DockerRunSettings toolSettings, string[] deviceReadIops) : DockerRunSettings
- RemoveDeviceReadIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerRunSettings
- RemoveDeviceWriteBps(this DockerRunSettings toolSettings, string[] deviceWriteBps) : DockerRunSettings
- RemoveDeviceWriteBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerRunSettings
- RemoveDeviceWriteIops(this DockerRunSettings toolSettings, string[] deviceWriteIops) : DockerRunSettings
- RemoveDeviceWriteIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerRunSettings
- RemoveDns(this DockerRunSettings toolSettings, string[] dns) : DockerRunSettings
- RemoveDns(this DockerRunSettings toolSettings, IEnumerable<string> dns) : DockerRunSettings
- RemoveDnsOpt(this DockerRunSettings toolSettings, string[] dnsOpt) : DockerRunSettings
- RemoveDnsOpt(this DockerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerRunSettings
- RemoveDnsOption(this DockerRunSettings toolSettings, string[] dnsOption) : DockerRunSettings
- RemoveDnsOption(this DockerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerRunSettings
- RemoveDnsSearch(this DockerRunSettings toolSettings, string[] dnsSearch) : DockerRunSettings
- RemoveDnsSearch(this DockerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerRunSettings
- RemoveEnv(this DockerRunSettings toolSettings, string[] env) : DockerRunSettings
- RemoveEnv(this DockerRunSettings toolSettings, IEnumerable<string> env) : DockerRunSettings
- RemoveEnvFile(this DockerRunSettings toolSettings, string[] envFile) : DockerRunSettings
- RemoveEnvFile(this DockerRunSettings toolSettings, IEnumerable<string> envFile) : DockerRunSettings
- RemoveExpose(this DockerRunSettings toolSettings, string[] expose) : DockerRunSettings
- RemoveExpose(this DockerRunSettings toolSettings, IEnumerable<string> expose) : DockerRunSettings
- RemoveGroupAdd(this DockerRunSettings toolSettings, string[] groupAdd) : DockerRunSettings
- RemoveGroupAdd(this DockerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerRunSettings
- RemoveLabel(this DockerRunSettings toolSettings, string[] label) : DockerRunSettings
- RemoveLabel(this DockerRunSettings toolSettings, IEnumerable<string> label) : DockerRunSettings
- RemoveLabelFile(this DockerRunSettings toolSettings, string[] labelFile) : DockerRunSettings
- RemoveLabelFile(this DockerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerRunSettings
- RemoveLink(this DockerRunSettings toolSettings, string[] link) : DockerRunSettings
- RemoveLink(this DockerRunSettings toolSettings, IEnumerable<string> link) : DockerRunSettings
- RemoveLinkLocalIp(this DockerRunSettings toolSettings, string[] linkLocalIp) : DockerRunSettings
- RemoveLinkLocalIp(this DockerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerRunSettings
- RemoveLogOpt(this DockerRunSettings toolSettings, string[] logOpt) : DockerRunSettings
- RemoveLogOpt(this DockerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerRunSettings
- RemoveNetAlias(this DockerRunSettings toolSettings, string[] netAlias) : DockerRunSettings
- RemoveNetAlias(this DockerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerRunSettings
- RemoveNetworkAlias(this DockerRunSettings toolSettings, string[] networkAlias) : DockerRunSettings
- RemoveNetworkAlias(this DockerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerRunSettings
- RemovePublish(this DockerRunSettings toolSettings, string[] publish) : DockerRunSettings
- RemovePublish(this DockerRunSettings toolSettings, IEnumerable<string> publish) : DockerRunSettings
- RemoveSecurityOpt(this DockerRunSettings toolSettings, string[] securityOpt) : DockerRunSettings
- RemoveSecurityOpt(this DockerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerRunSettings
- RemoveStorageOpt(this DockerRunSettings toolSettings, string[] storageOpt) : DockerRunSettings
- RemoveStorageOpt(this DockerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerRunSettings
- RemoveSysctl(this DockerRunSettings toolSettings, string sysctlKey) : DockerRunSettings
- RemoveTmpfs(this DockerRunSettings toolSettings, string[] tmpfs) : DockerRunSettings
- RemoveTmpfs(this DockerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerRunSettings
- RemoveVolume(this DockerRunSettings toolSettings, string[] volume) : DockerRunSettings
- RemoveVolume(this DockerRunSettings toolSettings, IEnumerable<string> volume) : DockerRunSettings
- RemoveVolumesFrom(this DockerRunSettings toolSettings, string[] volumesFrom) : DockerRunSettings
- RemoveVolumesFrom(this DockerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerRunSettings
- ResetBlkioWeight(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCgroupParent(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCidfile(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCommand(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuCount(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuPercent(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuPeriod(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuQuota(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuRtPeriod(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuRtRuntime(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpus(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpusetCpus(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpusetMems(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetCpuShares(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetDetach(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetDetachKeys(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetDisableContentTrust(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetDomainname(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetEntrypoint(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetGpus(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHealthCmd(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHealthInterval(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHealthRetries(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHealthStartPeriod(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHealthTimeout(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHelp(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetHostname(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetImage(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetInit(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetInteractive(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIoMaxbandwidth(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIoMaxiops(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIp(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIp6(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIpc(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetIsolation(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetKernelMemory(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetLogDriver(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMacAddress(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMemory(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMemoryReservation(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMemorySwap(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMemorySwappiness(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetMount(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetName(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetNet(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetNetwork(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetNoHealthcheck(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetOomKillDisable(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetOomScoreAdj(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetPid(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetPidsLimit(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetPlatform(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetPrivileged(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetPublishAll(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetReadOnly(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetRestart(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetRm(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetRuntime(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetShmSize(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetSigProxy(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetStopSignal(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetStopTimeout(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetTty(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetUlimit(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetUser(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetUserns(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetUts(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetVolumeDriver(this DockerRunSettings toolSettings) : DockerRunSettings
- ResetWorkdir(this DockerRunSettings toolSettings) : DockerRunSettings
- SetAddHost(this DockerRunSettings toolSettings, string[] addHost) : DockerRunSettings
- SetAddHost(this DockerRunSettings toolSettings, IEnumerable<string> addHost) : DockerRunSettings
- SetArgs(this DockerRunSettings toolSettings, string[] args) : DockerRunSettings
- SetArgs(this DockerRunSettings toolSettings, IEnumerable<string> args) : DockerRunSettings
- SetAttach(this DockerRunSettings toolSettings, string[] attach) : DockerRunSettings
- SetAttach(this DockerRunSettings toolSettings, IEnumerable<string> attach) : DockerRunSettings
- SetBlkioWeight(this DockerRunSettings toolSettings, int? blkioWeight) : DockerRunSettings
- SetBlkioWeightDevice(this DockerRunSettings toolSettings, string[] blkioWeightDevice) : DockerRunSettings
- SetBlkioWeightDevice(this DockerRunSettings toolSettings, IEnumerable<string> blkioWeightDevice) : DockerRunSettings
- SetCapAdd(this DockerRunSettings toolSettings, string[] capAdd) : DockerRunSettings
- SetCapAdd(this DockerRunSettings toolSettings, IEnumerable<string> capAdd) : DockerRunSettings
- SetCapDrop(this DockerRunSettings toolSettings, string[] capDrop) : DockerRunSettings
- SetCapDrop(this DockerRunSettings toolSettings, IEnumerable<string> capDrop) : DockerRunSettings
- SetCgroupParent(this DockerRunSettings toolSettings, string cgroupParent) : DockerRunSettings
- SetCidfile(this DockerRunSettings toolSettings, string cidfile) : DockerRunSettings
- SetCommand(this DockerRunSettings toolSettings, string command) : DockerRunSettings
- SetCpuCount(this DockerRunSettings toolSettings, long? cpuCount) : DockerRunSettings
- SetCpuPercent(this DockerRunSettings toolSettings, long? cpuPercent) : DockerRunSettings
- SetCpuPeriod(this DockerRunSettings toolSettings, long? cpuPeriod) : DockerRunSettings
- SetCpuQuota(this DockerRunSettings toolSettings, long? cpuQuota) : DockerRunSettings
- SetCpuRtPeriod(this DockerRunSettings toolSettings, long? cpuRtPeriod) : DockerRunSettings
- SetCpuRtRuntime(this DockerRunSettings toolSettings, long? cpuRtRuntime) : DockerRunSettings
- SetCpus(this DockerRunSettings toolSettings, decimal? cpus) : DockerRunSettings
- SetCpusetCpus(this DockerRunSettings toolSettings, string cpusetCpus) : DockerRunSettings
- SetCpusetMems(this DockerRunSettings toolSettings, string cpusetMems) : DockerRunSettings
- SetCpuShares(this DockerRunSettings toolSettings, long? cpuShares) : DockerRunSettings
- SetDetach(this DockerRunSettings toolSettings, bool? detach) : DockerRunSettings
- SetDetachKeys(this DockerRunSettings toolSettings, string detachKeys) : DockerRunSettings
- SetDevice(this DockerRunSettings toolSettings, string[] device) : DockerRunSettings
- SetDevice(this DockerRunSettings toolSettings, IEnumerable<string> device) : DockerRunSettings
- SetDeviceCgroupRule(this DockerRunSettings toolSettings, string[] deviceCgroupRule) : DockerRunSettings
- SetDeviceCgroupRule(this DockerRunSettings toolSettings, IEnumerable<string> deviceCgroupRule) : DockerRunSettings
- SetDeviceReadBps(this DockerRunSettings toolSettings, string[] deviceReadBps) : DockerRunSettings
- SetDeviceReadBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadBps) : DockerRunSettings
- SetDeviceReadIops(this DockerRunSettings toolSettings, string[] deviceReadIops) : DockerRunSettings
- SetDeviceReadIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceReadIops) : DockerRunSettings
- SetDeviceWriteBps(this DockerRunSettings toolSettings, string[] deviceWriteBps) : DockerRunSettings
- SetDeviceWriteBps(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteBps) : DockerRunSettings
- SetDeviceWriteIops(this DockerRunSettings toolSettings, string[] deviceWriteIops) : DockerRunSettings
- SetDeviceWriteIops(this DockerRunSettings toolSettings, IEnumerable<string> deviceWriteIops) : DockerRunSettings
- SetDisableContentTrust(this DockerRunSettings toolSettings, bool? disableContentTrust) : DockerRunSettings
- SetDns(this DockerRunSettings toolSettings, string[] dns) : DockerRunSettings
- SetDns(this DockerRunSettings toolSettings, IEnumerable<string> dns) : DockerRunSettings
- SetDnsOpt(this DockerRunSettings toolSettings, string[] dnsOpt) : DockerRunSettings
- SetDnsOpt(this DockerRunSettings toolSettings, IEnumerable<string> dnsOpt) : DockerRunSettings
- SetDnsOption(this DockerRunSettings toolSettings, string[] dnsOption) : DockerRunSettings
- SetDnsOption(this DockerRunSettings toolSettings, IEnumerable<string> dnsOption) : DockerRunSettings
- SetDnsSearch(this DockerRunSettings toolSettings, string[] dnsSearch) : DockerRunSettings
- SetDnsSearch(this DockerRunSettings toolSettings, IEnumerable<string> dnsSearch) : DockerRunSettings
- SetDomainname(this DockerRunSettings toolSettings, string domainname) : DockerRunSettings
- SetEntrypoint(this DockerRunSettings toolSettings, string entrypoint) : DockerRunSettings
- SetEnv(this DockerRunSettings toolSettings, string[] env) : DockerRunSettings
- SetEnv(this DockerRunSettings toolSettings, IEnumerable<string> env) : DockerRunSettings
- SetEnvFile(this DockerRunSettings toolSettings, string[] envFile) : DockerRunSettings
- SetEnvFile(this DockerRunSettings toolSettings, IEnumerable<string> envFile) : DockerRunSettings
- SetExpose(this DockerRunSettings toolSettings, string[] expose) : DockerRunSettings
- SetExpose(this DockerRunSettings toolSettings, IEnumerable<string> expose) : DockerRunSettings
- SetGpus(this DockerRunSettings toolSettings, string gpus) : DockerRunSettings
- SetGroupAdd(this DockerRunSettings toolSettings, string[] groupAdd) : DockerRunSettings
- SetGroupAdd(this DockerRunSettings toolSettings, IEnumerable<string> groupAdd) : DockerRunSettings
- SetHealthCmd(this DockerRunSettings toolSettings, string healthCmd) : DockerRunSettings
- SetHealthInterval(this DockerRunSettings toolSettings, string healthInterval) : DockerRunSettings
- SetHealthRetries(this DockerRunSettings toolSettings, int? healthRetries) : DockerRunSettings
- SetHealthStartPeriod(this DockerRunSettings toolSettings, string healthStartPeriod) : DockerRunSettings
- SetHealthTimeout(this DockerRunSettings toolSettings, string healthTimeout) : DockerRunSettings
- SetHelp(this DockerRunSettings toolSettings, bool? help) : DockerRunSettings
- SetHostname(this DockerRunSettings toolSettings, string hostname) : DockerRunSettings
- SetImage(this DockerRunSettings toolSettings, string image) : DockerRunSettings
- SetInit(this DockerRunSettings toolSettings, bool? init) : DockerRunSettings
- SetInteractive(this DockerRunSettings toolSettings, bool? interactive) : DockerRunSettings
- SetIoMaxbandwidth(this DockerRunSettings toolSettings, long? ioMaxbandwidth) : DockerRunSettings
- SetIoMaxiops(this DockerRunSettings toolSettings, int? ioMaxiops) : DockerRunSettings
- SetIp(this DockerRunSettings toolSettings, string ip) : DockerRunSettings
- SetIp6(this DockerRunSettings toolSettings, string ip6) : DockerRunSettings
- SetIpc(this DockerRunSettings toolSettings, string ipc) : DockerRunSettings
- SetIsolation(this DockerRunSettings toolSettings, string isolation) : DockerRunSettings
- SetKernelMemory(this DockerRunSettings toolSettings, long? kernelMemory) : DockerRunSettings
- SetLabel(this DockerRunSettings toolSettings, string[] label) : DockerRunSettings
- SetLabel(this DockerRunSettings toolSettings, IEnumerable<string> label) : DockerRunSettings
- SetLabelFile(this DockerRunSettings toolSettings, string[] labelFile) : DockerRunSettings
- SetLabelFile(this DockerRunSettings toolSettings, IEnumerable<string> labelFile) : DockerRunSettings
- SetLink(this DockerRunSettings toolSettings, string[] link) : DockerRunSettings
- SetLink(this DockerRunSettings toolSettings, IEnumerable<string> link) : DockerRunSettings
- SetLinkLocalIp(this DockerRunSettings toolSettings, string[] linkLocalIp) : DockerRunSettings
- SetLinkLocalIp(this DockerRunSettings toolSettings, IEnumerable<string> linkLocalIp) : DockerRunSettings
- SetLogDriver(this DockerRunSettings toolSettings, string logDriver) : DockerRunSettings
- SetLogOpt(this DockerRunSettings toolSettings, string[] logOpt) : DockerRunSettings
- SetLogOpt(this DockerRunSettings toolSettings, IEnumerable<string> logOpt) : DockerRunSettings
- SetMacAddress(this DockerRunSettings toolSettings, string macAddress) : DockerRunSettings
- SetMemory(this DockerRunSettings toolSettings, long? memory) : DockerRunSettings
- SetMemoryReservation(this DockerRunSettings toolSettings, long? memoryReservation) : DockerRunSettings
- SetMemorySwap(this DockerRunSettings toolSettings, long? memorySwap) : DockerRunSettings
- SetMemorySwappiness(this DockerRunSettings toolSettings, long? memorySwappiness) : DockerRunSettings
- SetMount(this DockerRunSettings toolSettings, string mount) : DockerRunSettings
- SetName(this DockerRunSettings toolSettings, string name) : DockerRunSettings
- SetNet(this DockerRunSettings toolSettings, string net) : DockerRunSettings
- SetNetAlias(this DockerRunSettings toolSettings, string[] netAlias) : DockerRunSettings
- SetNetAlias(this DockerRunSettings toolSettings, IEnumerable<string> netAlias) : DockerRunSettings
- SetNetwork(this DockerRunSettings toolSettings, string network) : DockerRunSettings
- SetNetworkAlias(this DockerRunSettings toolSettings, string[] networkAlias) : DockerRunSettings
- SetNetworkAlias(this DockerRunSettings toolSettings, IEnumerable<string> networkAlias) : DockerRunSettings
- SetNoHealthcheck(this DockerRunSettings toolSettings, bool? noHealthcheck) : DockerRunSettings
- SetOomKillDisable(this DockerRunSettings toolSettings, bool? oomKillDisable) : DockerRunSettings
- SetOomScoreAdj(this DockerRunSettings toolSettings, int? oomScoreAdj) : DockerRunSettings
- SetPid(this DockerRunSettings toolSettings, string pid) : DockerRunSettings
- SetPidsLimit(this DockerRunSettings toolSettings, long? pidsLimit) : DockerRunSettings
- SetPlatform(this DockerRunSettings toolSettings, string platform) : DockerRunSettings
- SetPrivileged(this DockerRunSettings toolSettings, bool? privileged) : DockerRunSettings
- SetPublish(this DockerRunSettings toolSettings, string[] publish) : DockerRunSettings
- SetPublish(this DockerRunSettings toolSettings, IEnumerable<string> publish) : DockerRunSettings
- SetPublishAll(this DockerRunSettings toolSettings, bool? publishAll) : DockerRunSettings
- SetReadOnly(this DockerRunSettings toolSettings, bool? readOnly) : DockerRunSettings
- SetRestart(this DockerRunSettings toolSettings, string restart) : DockerRunSettings
- SetRm(this DockerRunSettings toolSettings, bool? rm) : DockerRunSettings
- SetRuntime(this DockerRunSettings toolSettings, string runtime) : DockerRunSettings
- SetSecurityOpt(this DockerRunSettings toolSettings, string[] securityOpt) : DockerRunSettings
- SetSecurityOpt(this DockerRunSettings toolSettings, IEnumerable<string> securityOpt) : DockerRunSettings
- SetShmSize(this DockerRunSettings toolSettings, long? shmSize) : DockerRunSettings
- SetSigProxy(this DockerRunSettings toolSettings, bool? sigProxy) : DockerRunSettings
- SetStopSignal(this DockerRunSettings toolSettings, string stopSignal) : DockerRunSettings
- SetStopTimeout(this DockerRunSettings toolSettings, int? stopTimeout) : DockerRunSettings
- SetStorageOpt(this DockerRunSettings toolSettings, string[] storageOpt) : DockerRunSettings
- SetStorageOpt(this DockerRunSettings toolSettings, IEnumerable<string> storageOpt) : DockerRunSettings
- SetSysctl(this DockerRunSettings toolSettings, IDictionary<string, string> sysctl) : DockerRunSettings
- SetSysctl(this DockerRunSettings toolSettings, string sysctlKey, string sysctlValue) : DockerRunSettings
- SetTmpfs(this DockerRunSettings toolSettings, string[] tmpfs) : DockerRunSettings
- SetTmpfs(this DockerRunSettings toolSettings, IEnumerable<string> tmpfs) : DockerRunSettings
- SetTty(this DockerRunSettings toolSettings, bool? tty) : DockerRunSettings
- SetUlimit(this DockerRunSettings toolSettings, string ulimit) : DockerRunSettings
- SetUser(this DockerRunSettings toolSettings, string user) : DockerRunSettings
- SetUserns(this DockerRunSettings toolSettings, string userns) : DockerRunSettings
- SetUts(this DockerRunSettings toolSettings, string uts) : DockerRunSettings
- SetVolume(this DockerRunSettings toolSettings, string[] volume) : DockerRunSettings
- SetVolume(this DockerRunSettings toolSettings, IEnumerable<string> volume) : DockerRunSettings
- SetVolumeDriver(this DockerRunSettings toolSettings, string volumeDriver) : DockerRunSettings
- SetVolumesFrom(this DockerRunSettings toolSettings, string[] volumesFrom) : DockerRunSettings
- SetVolumesFrom(this DockerRunSettings toolSettings, IEnumerable<string> volumesFrom) : DockerRunSettings
- SetWorkdir(this DockerRunSettings toolSettings, string workdir) : DockerRunSettings
- ToggleDetach(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleDisableContentTrust(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleHelp(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleInit(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleInteractive(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleNoHealthcheck(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleOomKillDisable(this DockerRunSettings toolSettings) : DockerRunSettings
- TogglePrivileged(this DockerRunSettings toolSettings) : DockerRunSettings
- TogglePublishAll(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleReadOnly(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleRm(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleSigProxy(this DockerRunSettings toolSettings) : DockerRunSettings
- ToggleTty(this DockerRunSettings toolSettings) : DockerRunSettings

### Nuke.Common.Tools.Docker.DockerSaveSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Images() : IReadOnlyList<string>
- get_Output() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSaveSettingsExtensions

- AddImages(this DockerSaveSettings toolSettings, string[] images) : DockerSaveSettings
- AddImages(this DockerSaveSettings toolSettings, IEnumerable<string> images) : DockerSaveSettings
- ClearImages(this DockerSaveSettings toolSettings) : DockerSaveSettings
- RemoveImages(this DockerSaveSettings toolSettings, string[] images) : DockerSaveSettings
- RemoveImages(this DockerSaveSettings toolSettings, IEnumerable<string> images) : DockerSaveSettings
- ResetOutput(this DockerSaveSettings toolSettings) : DockerSaveSettings
- SetImages(this DockerSaveSettings toolSettings, string[] images) : DockerSaveSettings
- SetImages(this DockerSaveSettings toolSettings, IEnumerable<string> images) : DockerSaveSettings
- SetOutput(this DockerSaveSettings toolSettings, string output) : DockerSaveSettings

### Nuke.Common.Tools.Docker.DockerSearchSettings

- .ctor()
- get_Automated() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Limit() : int?
- get_NoTrunc() : bool?
- get_Stars() : int?
- get_Term() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSearchSettingsExtensions

- DisableAutomated(this DockerSearchSettings toolSettings) : DockerSearchSettings
- DisableNoTrunc(this DockerSearchSettings toolSettings) : DockerSearchSettings
- EnableAutomated(this DockerSearchSettings toolSettings) : DockerSearchSettings
- EnableNoTrunc(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetAutomated(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetFilter(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetFormat(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetLimit(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetNoTrunc(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetStars(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ResetTerm(this DockerSearchSettings toolSettings) : DockerSearchSettings
- SetAutomated(this DockerSearchSettings toolSettings, bool? automated) : DockerSearchSettings
- SetFilter(this DockerSearchSettings toolSettings, string filter) : DockerSearchSettings
- SetFormat(this DockerSearchSettings toolSettings, string format) : DockerSearchSettings
- SetLimit(this DockerSearchSettings toolSettings, int? limit) : DockerSearchSettings
- SetNoTrunc(this DockerSearchSettings toolSettings, bool? noTrunc) : DockerSearchSettings
- SetStars(this DockerSearchSettings toolSettings, int? stars) : DockerSearchSettings
- SetTerm(this DockerSearchSettings toolSettings, string term) : DockerSearchSettings
- ToggleAutomated(this DockerSearchSettings toolSettings) : DockerSearchSettings
- ToggleNoTrunc(this DockerSearchSettings toolSettings) : DockerSearchSettings

### Nuke.Common.Tools.Docker.DockerSecretCreateSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Driver() : string
- get_File() : string
- get_Label() : IReadOnlyList<string>
- get_Secret() : string
- get_TemplateDriver() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSecretCreateSettingsExtensions

- AddLabel(this DockerSecretCreateSettings toolSettings, string[] label) : DockerSecretCreateSettings
- AddLabel(this DockerSecretCreateSettings toolSettings, IEnumerable<string> label) : DockerSecretCreateSettings
- ClearLabel(this DockerSecretCreateSettings toolSettings) : DockerSecretCreateSettings
- RemoveLabel(this DockerSecretCreateSettings toolSettings, string[] label) : DockerSecretCreateSettings
- RemoveLabel(this DockerSecretCreateSettings toolSettings, IEnumerable<string> label) : DockerSecretCreateSettings
- ResetDriver(this DockerSecretCreateSettings toolSettings) : DockerSecretCreateSettings
- ResetFile(this DockerSecretCreateSettings toolSettings) : DockerSecretCreateSettings
- ResetSecret(this DockerSecretCreateSettings toolSettings) : DockerSecretCreateSettings
- ResetTemplateDriver(this DockerSecretCreateSettings toolSettings) : DockerSecretCreateSettings
- SetDriver(this DockerSecretCreateSettings toolSettings, string driver) : DockerSecretCreateSettings
- SetFile(this DockerSecretCreateSettings toolSettings, string file) : DockerSecretCreateSettings
- SetLabel(this DockerSecretCreateSettings toolSettings, string[] label) : DockerSecretCreateSettings
- SetLabel(this DockerSecretCreateSettings toolSettings, IEnumerable<string> label) : DockerSecretCreateSettings
- SetSecret(this DockerSecretCreateSettings toolSettings, string secret) : DockerSecretCreateSettings
- SetTemplateDriver(this DockerSecretCreateSettings toolSettings, string templateDriver) : DockerSecretCreateSettings

### Nuke.Common.Tools.Docker.DockerSecretInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Pretty() : bool?
- get_Secrets() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSecretInspectSettingsExtensions

- AddSecrets(this DockerSecretInspectSettings toolSettings, string[] secrets) : DockerSecretInspectSettings
- AddSecrets(this DockerSecretInspectSettings toolSettings, IEnumerable<string> secrets) : DockerSecretInspectSettings
- ClearSecrets(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings
- DisablePretty(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings
- EnablePretty(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings
- RemoveSecrets(this DockerSecretInspectSettings toolSettings, string[] secrets) : DockerSecretInspectSettings
- RemoveSecrets(this DockerSecretInspectSettings toolSettings, IEnumerable<string> secrets) : DockerSecretInspectSettings
- ResetFormat(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings
- ResetPretty(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings
- SetFormat(this DockerSecretInspectSettings toolSettings, string format) : DockerSecretInspectSettings
- SetPretty(this DockerSecretInspectSettings toolSettings, bool? pretty) : DockerSecretInspectSettings
- SetSecrets(this DockerSecretInspectSettings toolSettings, string[] secrets) : DockerSecretInspectSettings
- SetSecrets(this DockerSecretInspectSettings toolSettings, IEnumerable<string> secrets) : DockerSecretInspectSettings
- TogglePretty(this DockerSecretInspectSettings toolSettings) : DockerSecretInspectSettings

### Nuke.Common.Tools.Docker.DockerSecretLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSecretLsSettingsExtensions

- DisableQuiet(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings
- EnableQuiet(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings
- ResetFilter(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings
- ResetFormat(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings
- ResetQuiet(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings
- SetFilter(this DockerSecretLsSettings toolSettings, string filter) : DockerSecretLsSettings
- SetFormat(this DockerSecretLsSettings toolSettings, string format) : DockerSecretLsSettings
- SetQuiet(this DockerSecretLsSettings toolSettings, bool? quiet) : DockerSecretLsSettings
- ToggleQuiet(this DockerSecretLsSettings toolSettings) : DockerSecretLsSettings

### Nuke.Common.Tools.Docker.DockerSecretRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Secrets() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSecretRmSettingsExtensions

- AddSecrets(this DockerSecretRmSettings toolSettings, string[] secrets) : DockerSecretRmSettings
- AddSecrets(this DockerSecretRmSettings toolSettings, IEnumerable<string> secrets) : DockerSecretRmSettings
- ClearSecrets(this DockerSecretRmSettings toolSettings) : DockerSecretRmSettings
- RemoveSecrets(this DockerSecretRmSettings toolSettings, string[] secrets) : DockerSecretRmSettings
- RemoveSecrets(this DockerSecretRmSettings toolSettings, IEnumerable<string> secrets) : DockerSecretRmSettings
- SetSecrets(this DockerSecretRmSettings toolSettings, string[] secrets) : DockerSecretRmSettings
- SetSecrets(this DockerSecretRmSettings toolSettings, IEnumerable<string> secrets) : DockerSecretRmSettings

### Nuke.Common.Tools.Docker.DockerSecretSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSecretSettingsExtensions


### Nuke.Common.Tools.Docker.DockerServiceCreateSettings

- .ctor()
- get_Args() : IReadOnlyList<string>
- get_Command() : string
- get_Config() : string
- get_Constraint() : IReadOnlyList<string>
- get_ContainerLabel() : IReadOnlyList<string>
- get_CredentialSpec() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_Dns() : IReadOnlyList<string>
- get_DnsOption() : IReadOnlyList<string>
- get_DnsSearch() : IReadOnlyList<string>
- get_EndpointMode() : string
- get_Entrypoint() : string
- get_Env() : IReadOnlyList<string>
- get_EnvFile() : IReadOnlyList<string>
- get_GenericResource() : IReadOnlyList<string>
- get_Group() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_Host() : IReadOnlyList<string>
- get_Hostname() : string
- get_Image() : string
- get_Init() : bool?
- get_Isolation() : string
- get_Label() : IReadOnlyList<string>
- get_LimitCpu() : decimal?
- get_LimitMemory() : long?
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_Mode() : string
- get_Mount() : string
- get_Name() : string
- get_Network() : string
- get_NoHealthcheck() : bool?
- get_NoResolveImage() : bool?
- get_PlacementPref() : string
- get_Publish() : string
- get_Quiet() : bool?
- get_ReadOnly() : bool?
- get_Replicas() : int?
- get_ReplicasMaxPerNode() : int?
- get_ReserveCpu() : decimal?
- get_ReserveMemory() : long?
- get_RestartCondition() : RestartCondition
- get_RestartDelay() : string
- get_RestartMaxAttempts() : int?
- get_RestartWindow() : string
- get_RollbackDelay() : string
- get_RollbackFailureAction() : RollbackFailureAction
- get_RollbackMaxFailureRatio() : float?
- get_RollbackMonitor() : string
- get_RollbackOrder() : RollbackOrder
- get_RollbackParallelism() : int?
- get_Secret() : string
- get_StopGracePeriod() : string
- get_StopSignal() : string
- get_Sysctl() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_UpdateDelay() : string
- get_UpdateFailureAction() : UpdateFailureAction
- get_UpdateMaxFailureRatio() : float?
- get_UpdateMonitor() : string
- get_UpdateOrder() : UpdateOrder
- get_UpdateParallelism() : int?
- get_User() : string
- get_WithRegistryAuth() : bool?
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceCreateSettingsExtensions

- AddArgs(this DockerServiceCreateSettings toolSettings, string[] args) : DockerServiceCreateSettings
- AddArgs(this DockerServiceCreateSettings toolSettings, IEnumerable<string> args) : DockerServiceCreateSettings
- AddConstraint(this DockerServiceCreateSettings toolSettings, string[] constraint) : DockerServiceCreateSettings
- AddConstraint(this DockerServiceCreateSettings toolSettings, IEnumerable<string> constraint) : DockerServiceCreateSettings
- AddContainerLabel(this DockerServiceCreateSettings toolSettings, string[] containerLabel) : DockerServiceCreateSettings
- AddContainerLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> containerLabel) : DockerServiceCreateSettings
- AddDns(this DockerServiceCreateSettings toolSettings, string[] dns) : DockerServiceCreateSettings
- AddDns(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dns) : DockerServiceCreateSettings
- AddDnsOption(this DockerServiceCreateSettings toolSettings, string[] dnsOption) : DockerServiceCreateSettings
- AddDnsOption(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerServiceCreateSettings
- AddDnsSearch(this DockerServiceCreateSettings toolSettings, string[] dnsSearch) : DockerServiceCreateSettings
- AddDnsSearch(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerServiceCreateSettings
- AddEnv(this DockerServiceCreateSettings toolSettings, string[] env) : DockerServiceCreateSettings
- AddEnv(this DockerServiceCreateSettings toolSettings, IEnumerable<string> env) : DockerServiceCreateSettings
- AddEnvFile(this DockerServiceCreateSettings toolSettings, string[] envFile) : DockerServiceCreateSettings
- AddEnvFile(this DockerServiceCreateSettings toolSettings, IEnumerable<string> envFile) : DockerServiceCreateSettings
- AddGenericResource(this DockerServiceCreateSettings toolSettings, string[] genericResource) : DockerServiceCreateSettings
- AddGenericResource(this DockerServiceCreateSettings toolSettings, IEnumerable<string> genericResource) : DockerServiceCreateSettings
- AddGroup(this DockerServiceCreateSettings toolSettings, string[] group) : DockerServiceCreateSettings
- AddGroup(this DockerServiceCreateSettings toolSettings, IEnumerable<string> group) : DockerServiceCreateSettings
- AddHost(this DockerServiceCreateSettings toolSettings, string[] host) : DockerServiceCreateSettings
- AddHost(this DockerServiceCreateSettings toolSettings, IEnumerable<string> host) : DockerServiceCreateSettings
- AddLabel(this DockerServiceCreateSettings toolSettings, string[] label) : DockerServiceCreateSettings
- AddLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> label) : DockerServiceCreateSettings
- AddLogOpt(this DockerServiceCreateSettings toolSettings, string[] logOpt) : DockerServiceCreateSettings
- AddLogOpt(this DockerServiceCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceCreateSettings
- AddSysctl(this DockerServiceCreateSettings toolSettings, string[] sysctl) : DockerServiceCreateSettings
- AddSysctl(this DockerServiceCreateSettings toolSettings, IEnumerable<string> sysctl) : DockerServiceCreateSettings
- ClearArgs(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearConstraint(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearContainerLabel(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearDns(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearDnsOption(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearDnsSearch(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearEnv(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearEnvFile(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearGenericResource(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearGroup(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearHost(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearLabel(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearLogOpt(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ClearSysctl(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableDetach(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableInit(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableNoHealthcheck(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableNoResolveImage(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableQuiet(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableReadOnly(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableTty(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- DisableWithRegistryAuth(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableDetach(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableInit(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableNoHealthcheck(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableNoResolveImage(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableQuiet(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableReadOnly(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableTty(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- EnableWithRegistryAuth(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- RemoveArgs(this DockerServiceCreateSettings toolSettings, string[] args) : DockerServiceCreateSettings
- RemoveArgs(this DockerServiceCreateSettings toolSettings, IEnumerable<string> args) : DockerServiceCreateSettings
- RemoveConstraint(this DockerServiceCreateSettings toolSettings, string[] constraint) : DockerServiceCreateSettings
- RemoveConstraint(this DockerServiceCreateSettings toolSettings, IEnumerable<string> constraint) : DockerServiceCreateSettings
- RemoveContainerLabel(this DockerServiceCreateSettings toolSettings, string[] containerLabel) : DockerServiceCreateSettings
- RemoveContainerLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> containerLabel) : DockerServiceCreateSettings
- RemoveDns(this DockerServiceCreateSettings toolSettings, string[] dns) : DockerServiceCreateSettings
- RemoveDns(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dns) : DockerServiceCreateSettings
- RemoveDnsOption(this DockerServiceCreateSettings toolSettings, string[] dnsOption) : DockerServiceCreateSettings
- RemoveDnsOption(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerServiceCreateSettings
- RemoveDnsSearch(this DockerServiceCreateSettings toolSettings, string[] dnsSearch) : DockerServiceCreateSettings
- RemoveDnsSearch(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerServiceCreateSettings
- RemoveEnv(this DockerServiceCreateSettings toolSettings, string[] env) : DockerServiceCreateSettings
- RemoveEnv(this DockerServiceCreateSettings toolSettings, IEnumerable<string> env) : DockerServiceCreateSettings
- RemoveEnvFile(this DockerServiceCreateSettings toolSettings, string[] envFile) : DockerServiceCreateSettings
- RemoveEnvFile(this DockerServiceCreateSettings toolSettings, IEnumerable<string> envFile) : DockerServiceCreateSettings
- RemoveGenericResource(this DockerServiceCreateSettings toolSettings, string[] genericResource) : DockerServiceCreateSettings
- RemoveGenericResource(this DockerServiceCreateSettings toolSettings, IEnumerable<string> genericResource) : DockerServiceCreateSettings
- RemoveGroup(this DockerServiceCreateSettings toolSettings, string[] group) : DockerServiceCreateSettings
- RemoveGroup(this DockerServiceCreateSettings toolSettings, IEnumerable<string> group) : DockerServiceCreateSettings
- RemoveHost(this DockerServiceCreateSettings toolSettings, string[] host) : DockerServiceCreateSettings
- RemoveHost(this DockerServiceCreateSettings toolSettings, IEnumerable<string> host) : DockerServiceCreateSettings
- RemoveLabel(this DockerServiceCreateSettings toolSettings, string[] label) : DockerServiceCreateSettings
- RemoveLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> label) : DockerServiceCreateSettings
- RemoveLogOpt(this DockerServiceCreateSettings toolSettings, string[] logOpt) : DockerServiceCreateSettings
- RemoveLogOpt(this DockerServiceCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceCreateSettings
- RemoveSysctl(this DockerServiceCreateSettings toolSettings, string[] sysctl) : DockerServiceCreateSettings
- RemoveSysctl(this DockerServiceCreateSettings toolSettings, IEnumerable<string> sysctl) : DockerServiceCreateSettings
- ResetCommand(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetConfig(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetCredentialSpec(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetDetach(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetEndpointMode(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetEntrypoint(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHealthCmd(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHealthInterval(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHealthRetries(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHealthStartPeriod(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHealthTimeout(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetHostname(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetImage(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetInit(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetIsolation(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetLimitCpu(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetLimitMemory(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetLogDriver(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetMode(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetMount(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetName(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetNetwork(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetNoHealthcheck(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetNoResolveImage(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetPlacementPref(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetPublish(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetQuiet(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetReadOnly(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetReplicas(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetReplicasMaxPerNode(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetReserveCpu(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetReserveMemory(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRestartCondition(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRestartDelay(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRestartMaxAttempts(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRestartWindow(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackDelay(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackFailureAction(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackMaxFailureRatio(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackMonitor(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackOrder(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetRollbackParallelism(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetSecret(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetStopGracePeriod(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetStopSignal(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetTty(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateDelay(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateFailureAction(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateMaxFailureRatio(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateMonitor(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateOrder(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUpdateParallelism(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetUser(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetWithRegistryAuth(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ResetWorkdir(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- SetArgs(this DockerServiceCreateSettings toolSettings, string[] args) : DockerServiceCreateSettings
- SetArgs(this DockerServiceCreateSettings toolSettings, IEnumerable<string> args) : DockerServiceCreateSettings
- SetCommand(this DockerServiceCreateSettings toolSettings, string command) : DockerServiceCreateSettings
- SetConfig(this DockerServiceCreateSettings toolSettings, string config) : DockerServiceCreateSettings
- SetConstraint(this DockerServiceCreateSettings toolSettings, string[] constraint) : DockerServiceCreateSettings
- SetConstraint(this DockerServiceCreateSettings toolSettings, IEnumerable<string> constraint) : DockerServiceCreateSettings
- SetContainerLabel(this DockerServiceCreateSettings toolSettings, string[] containerLabel) : DockerServiceCreateSettings
- SetContainerLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> containerLabel) : DockerServiceCreateSettings
- SetCredentialSpec(this DockerServiceCreateSettings toolSettings, string credentialSpec) : DockerServiceCreateSettings
- SetDetach(this DockerServiceCreateSettings toolSettings, bool? detach) : DockerServiceCreateSettings
- SetDns(this DockerServiceCreateSettings toolSettings, string[] dns) : DockerServiceCreateSettings
- SetDns(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dns) : DockerServiceCreateSettings
- SetDnsOption(this DockerServiceCreateSettings toolSettings, string[] dnsOption) : DockerServiceCreateSettings
- SetDnsOption(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsOption) : DockerServiceCreateSettings
- SetDnsSearch(this DockerServiceCreateSettings toolSettings, string[] dnsSearch) : DockerServiceCreateSettings
- SetDnsSearch(this DockerServiceCreateSettings toolSettings, IEnumerable<string> dnsSearch) : DockerServiceCreateSettings
- SetEndpointMode(this DockerServiceCreateSettings toolSettings, string endpointMode) : DockerServiceCreateSettings
- SetEntrypoint(this DockerServiceCreateSettings toolSettings, string entrypoint) : DockerServiceCreateSettings
- SetEnv(this DockerServiceCreateSettings toolSettings, string[] env) : DockerServiceCreateSettings
- SetEnv(this DockerServiceCreateSettings toolSettings, IEnumerable<string> env) : DockerServiceCreateSettings
- SetEnvFile(this DockerServiceCreateSettings toolSettings, string[] envFile) : DockerServiceCreateSettings
- SetEnvFile(this DockerServiceCreateSettings toolSettings, IEnumerable<string> envFile) : DockerServiceCreateSettings
- SetGenericResource(this DockerServiceCreateSettings toolSettings, string[] genericResource) : DockerServiceCreateSettings
- SetGenericResource(this DockerServiceCreateSettings toolSettings, IEnumerable<string> genericResource) : DockerServiceCreateSettings
- SetGroup(this DockerServiceCreateSettings toolSettings, string[] group) : DockerServiceCreateSettings
- SetGroup(this DockerServiceCreateSettings toolSettings, IEnumerable<string> group) : DockerServiceCreateSettings
- SetHealthCmd(this DockerServiceCreateSettings toolSettings, string healthCmd) : DockerServiceCreateSettings
- SetHealthInterval(this DockerServiceCreateSettings toolSettings, string healthInterval) : DockerServiceCreateSettings
- SetHealthRetries(this DockerServiceCreateSettings toolSettings, int? healthRetries) : DockerServiceCreateSettings
- SetHealthStartPeriod(this DockerServiceCreateSettings toolSettings, string healthStartPeriod) : DockerServiceCreateSettings
- SetHealthTimeout(this DockerServiceCreateSettings toolSettings, string healthTimeout) : DockerServiceCreateSettings
- SetHost(this DockerServiceCreateSettings toolSettings, string[] host) : DockerServiceCreateSettings
- SetHost(this DockerServiceCreateSettings toolSettings, IEnumerable<string> host) : DockerServiceCreateSettings
- SetHostname(this DockerServiceCreateSettings toolSettings, string hostname) : DockerServiceCreateSettings
- SetImage(this DockerServiceCreateSettings toolSettings, string image) : DockerServiceCreateSettings
- SetInit(this DockerServiceCreateSettings toolSettings, bool? init) : DockerServiceCreateSettings
- SetIsolation(this DockerServiceCreateSettings toolSettings, string isolation) : DockerServiceCreateSettings
- SetLabel(this DockerServiceCreateSettings toolSettings, string[] label) : DockerServiceCreateSettings
- SetLabel(this DockerServiceCreateSettings toolSettings, IEnumerable<string> label) : DockerServiceCreateSettings
- SetLimitCpu(this DockerServiceCreateSettings toolSettings, decimal? limitCpu) : DockerServiceCreateSettings
- SetLimitMemory(this DockerServiceCreateSettings toolSettings, long? limitMemory) : DockerServiceCreateSettings
- SetLogDriver(this DockerServiceCreateSettings toolSettings, string logDriver) : DockerServiceCreateSettings
- SetLogOpt(this DockerServiceCreateSettings toolSettings, string[] logOpt) : DockerServiceCreateSettings
- SetLogOpt(this DockerServiceCreateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceCreateSettings
- SetMode(this DockerServiceCreateSettings toolSettings, string mode) : DockerServiceCreateSettings
- SetMount(this DockerServiceCreateSettings toolSettings, string mount) : DockerServiceCreateSettings
- SetName(this DockerServiceCreateSettings toolSettings, string name) : DockerServiceCreateSettings
- SetNetwork(this DockerServiceCreateSettings toolSettings, string network) : DockerServiceCreateSettings
- SetNoHealthcheck(this DockerServiceCreateSettings toolSettings, bool? noHealthcheck) : DockerServiceCreateSettings
- SetNoResolveImage(this DockerServiceCreateSettings toolSettings, bool? noResolveImage) : DockerServiceCreateSettings
- SetPlacementPref(this DockerServiceCreateSettings toolSettings, string placementPref) : DockerServiceCreateSettings
- SetPublish(this DockerServiceCreateSettings toolSettings, string publish) : DockerServiceCreateSettings
- SetQuiet(this DockerServiceCreateSettings toolSettings, bool? quiet) : DockerServiceCreateSettings
- SetReadOnly(this DockerServiceCreateSettings toolSettings, bool? readOnly) : DockerServiceCreateSettings
- SetReplicas(this DockerServiceCreateSettings toolSettings, int? replicas) : DockerServiceCreateSettings
- SetReplicasMaxPerNode(this DockerServiceCreateSettings toolSettings, int? replicasMaxPerNode) : DockerServiceCreateSettings
- SetReserveCpu(this DockerServiceCreateSettings toolSettings, decimal? reserveCpu) : DockerServiceCreateSettings
- SetReserveMemory(this DockerServiceCreateSettings toolSettings, long? reserveMemory) : DockerServiceCreateSettings
- SetRestartCondition(this DockerServiceCreateSettings toolSettings, RestartCondition restartCondition) : DockerServiceCreateSettings
- SetRestartDelay(this DockerServiceCreateSettings toolSettings, string restartDelay) : DockerServiceCreateSettings
- SetRestartMaxAttempts(this DockerServiceCreateSettings toolSettings, int? restartMaxAttempts) : DockerServiceCreateSettings
- SetRestartWindow(this DockerServiceCreateSettings toolSettings, string restartWindow) : DockerServiceCreateSettings
- SetRollbackDelay(this DockerServiceCreateSettings toolSettings, string rollbackDelay) : DockerServiceCreateSettings
- SetRollbackFailureAction(this DockerServiceCreateSettings toolSettings, RollbackFailureAction rollbackFailureAction) : DockerServiceCreateSettings
- SetRollbackMaxFailureRatio(this DockerServiceCreateSettings toolSettings, float? rollbackMaxFailureRatio) : DockerServiceCreateSettings
- SetRollbackMonitor(this DockerServiceCreateSettings toolSettings, string rollbackMonitor) : DockerServiceCreateSettings
- SetRollbackOrder(this DockerServiceCreateSettings toolSettings, RollbackOrder rollbackOrder) : DockerServiceCreateSettings
- SetRollbackParallelism(this DockerServiceCreateSettings toolSettings, int? rollbackParallelism) : DockerServiceCreateSettings
- SetSecret(this DockerServiceCreateSettings toolSettings, string secret) : DockerServiceCreateSettings
- SetStopGracePeriod(this DockerServiceCreateSettings toolSettings, string stopGracePeriod) : DockerServiceCreateSettings
- SetStopSignal(this DockerServiceCreateSettings toolSettings, string stopSignal) : DockerServiceCreateSettings
- SetSysctl(this DockerServiceCreateSettings toolSettings, string[] sysctl) : DockerServiceCreateSettings
- SetSysctl(this DockerServiceCreateSettings toolSettings, IEnumerable<string> sysctl) : DockerServiceCreateSettings
- SetTty(this DockerServiceCreateSettings toolSettings, bool? tty) : DockerServiceCreateSettings
- SetUpdateDelay(this DockerServiceCreateSettings toolSettings, string updateDelay) : DockerServiceCreateSettings
- SetUpdateFailureAction(this DockerServiceCreateSettings toolSettings, UpdateFailureAction updateFailureAction) : DockerServiceCreateSettings
- SetUpdateMaxFailureRatio(this DockerServiceCreateSettings toolSettings, float? updateMaxFailureRatio) : DockerServiceCreateSettings
- SetUpdateMonitor(this DockerServiceCreateSettings toolSettings, string updateMonitor) : DockerServiceCreateSettings
- SetUpdateOrder(this DockerServiceCreateSettings toolSettings, UpdateOrder updateOrder) : DockerServiceCreateSettings
- SetUpdateParallelism(this DockerServiceCreateSettings toolSettings, int? updateParallelism) : DockerServiceCreateSettings
- SetUser(this DockerServiceCreateSettings toolSettings, string user) : DockerServiceCreateSettings
- SetWithRegistryAuth(this DockerServiceCreateSettings toolSettings, bool? withRegistryAuth) : DockerServiceCreateSettings
- SetWorkdir(this DockerServiceCreateSettings toolSettings, string workdir) : DockerServiceCreateSettings
- ToggleDetach(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleInit(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleNoHealthcheck(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleNoResolveImage(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleQuiet(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleReadOnly(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleTty(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings
- ToggleWithRegistryAuth(this DockerServiceCreateSettings toolSettings) : DockerServiceCreateSettings

### Nuke.Common.Tools.Docker.DockerServiceInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Pretty() : bool?
- get_Services() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceInspectSettingsExtensions

- AddServices(this DockerServiceInspectSettings toolSettings, string[] services) : DockerServiceInspectSettings
- AddServices(this DockerServiceInspectSettings toolSettings, IEnumerable<string> services) : DockerServiceInspectSettings
- ClearServices(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings
- DisablePretty(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings
- EnablePretty(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings
- RemoveServices(this DockerServiceInspectSettings toolSettings, string[] services) : DockerServiceInspectSettings
- RemoveServices(this DockerServiceInspectSettings toolSettings, IEnumerable<string> services) : DockerServiceInspectSettings
- ResetFormat(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings
- ResetPretty(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings
- SetFormat(this DockerServiceInspectSettings toolSettings, string format) : DockerServiceInspectSettings
- SetPretty(this DockerServiceInspectSettings toolSettings, bool? pretty) : DockerServiceInspectSettings
- SetServices(this DockerServiceInspectSettings toolSettings, string[] services) : DockerServiceInspectSettings
- SetServices(this DockerServiceInspectSettings toolSettings, IEnumerable<string> services) : DockerServiceInspectSettings
- TogglePretty(this DockerServiceInspectSettings toolSettings) : DockerServiceInspectSettings

### Nuke.Common.Tools.Docker.DockerServiceLogsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Details() : bool?
- get_Follow() : bool?
- get_NoResolve() : bool?
- get_NoTaskIds() : bool?
- get_NoTrunc() : bool?
- get_Raw() : bool?
- get_Service() : string
- get_Since() : string
- get_Tail() : string
- get_Timestamps() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceLogsSettingsExtensions

- DisableDetails(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableFollow(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableNoResolve(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableNoTaskIds(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableNoTrunc(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableRaw(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- DisableTimestamps(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableDetails(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableFollow(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableNoResolve(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableNoTaskIds(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableNoTrunc(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableRaw(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- EnableTimestamps(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetDetails(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetFollow(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetNoResolve(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetNoTaskIds(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetNoTrunc(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetRaw(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetService(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetSince(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetTail(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ResetTimestamps(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- SetDetails(this DockerServiceLogsSettings toolSettings, bool? details) : DockerServiceLogsSettings
- SetFollow(this DockerServiceLogsSettings toolSettings, bool? follow) : DockerServiceLogsSettings
- SetNoResolve(this DockerServiceLogsSettings toolSettings, bool? noResolve) : DockerServiceLogsSettings
- SetNoTaskIds(this DockerServiceLogsSettings toolSettings, bool? noTaskIds) : DockerServiceLogsSettings
- SetNoTrunc(this DockerServiceLogsSettings toolSettings, bool? noTrunc) : DockerServiceLogsSettings
- SetRaw(this DockerServiceLogsSettings toolSettings, bool? raw) : DockerServiceLogsSettings
- SetService(this DockerServiceLogsSettings toolSettings, string service) : DockerServiceLogsSettings
- SetSince(this DockerServiceLogsSettings toolSettings, string since) : DockerServiceLogsSettings
- SetTail(this DockerServiceLogsSettings toolSettings, string tail) : DockerServiceLogsSettings
- SetTimestamps(this DockerServiceLogsSettings toolSettings, bool? timestamps) : DockerServiceLogsSettings
- ToggleDetails(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleFollow(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleNoResolve(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleNoTaskIds(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleNoTrunc(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleRaw(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings
- ToggleTimestamps(this DockerServiceLogsSettings toolSettings) : DockerServiceLogsSettings

### Nuke.Common.Tools.Docker.DockerServiceLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceLsSettingsExtensions

- DisableQuiet(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings
- EnableQuiet(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings
- ResetFilter(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings
- ResetFormat(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings
- ResetQuiet(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings
- SetFilter(this DockerServiceLsSettings toolSettings, string filter) : DockerServiceLsSettings
- SetFormat(this DockerServiceLsSettings toolSettings, string format) : DockerServiceLsSettings
- SetQuiet(this DockerServiceLsSettings toolSettings, bool? quiet) : DockerServiceLsSettings
- ToggleQuiet(this DockerServiceLsSettings toolSettings) : DockerServiceLsSettings

### Nuke.Common.Tools.Docker.DockerServicePsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_NoResolve() : bool?
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Services() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServicePsSettingsExtensions

- AddServices(this DockerServicePsSettings toolSettings, string[] services) : DockerServicePsSettings
- AddServices(this DockerServicePsSettings toolSettings, IEnumerable<string> services) : DockerServicePsSettings
- ClearServices(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- DisableNoResolve(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- DisableNoTrunc(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- DisableQuiet(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- EnableNoResolve(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- EnableNoTrunc(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- EnableQuiet(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- RemoveServices(this DockerServicePsSettings toolSettings, string[] services) : DockerServicePsSettings
- RemoveServices(this DockerServicePsSettings toolSettings, IEnumerable<string> services) : DockerServicePsSettings
- ResetFilter(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ResetFormat(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ResetNoResolve(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ResetNoTrunc(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ResetQuiet(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- SetFilter(this DockerServicePsSettings toolSettings, string filter) : DockerServicePsSettings
- SetFormat(this DockerServicePsSettings toolSettings, string format) : DockerServicePsSettings
- SetNoResolve(this DockerServicePsSettings toolSettings, bool? noResolve) : DockerServicePsSettings
- SetNoTrunc(this DockerServicePsSettings toolSettings, bool? noTrunc) : DockerServicePsSettings
- SetQuiet(this DockerServicePsSettings toolSettings, bool? quiet) : DockerServicePsSettings
- SetServices(this DockerServicePsSettings toolSettings, string[] services) : DockerServicePsSettings
- SetServices(this DockerServicePsSettings toolSettings, IEnumerable<string> services) : DockerServicePsSettings
- ToggleNoResolve(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ToggleNoTrunc(this DockerServicePsSettings toolSettings) : DockerServicePsSettings
- ToggleQuiet(this DockerServicePsSettings toolSettings) : DockerServicePsSettings

### Nuke.Common.Tools.Docker.DockerServiceRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Services() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceRmSettingsExtensions

- AddServices(this DockerServiceRmSettings toolSettings, string[] services) : DockerServiceRmSettings
- AddServices(this DockerServiceRmSettings toolSettings, IEnumerable<string> services) : DockerServiceRmSettings
- ClearServices(this DockerServiceRmSettings toolSettings) : DockerServiceRmSettings
- RemoveServices(this DockerServiceRmSettings toolSettings, string[] services) : DockerServiceRmSettings
- RemoveServices(this DockerServiceRmSettings toolSettings, IEnumerable<string> services) : DockerServiceRmSettings
- SetServices(this DockerServiceRmSettings toolSettings, string[] services) : DockerServiceRmSettings
- SetServices(this DockerServiceRmSettings toolSettings, IEnumerable<string> services) : DockerServiceRmSettings

### Nuke.Common.Tools.Docker.DockerServiceRollbackSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_Quiet() : bool?
- get_Service() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceRollbackSettingsExtensions

- DisableDetach(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- DisableQuiet(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- EnableDetach(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- EnableQuiet(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- ResetDetach(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- ResetQuiet(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- ResetService(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- SetDetach(this DockerServiceRollbackSettings toolSettings, bool? detach) : DockerServiceRollbackSettings
- SetQuiet(this DockerServiceRollbackSettings toolSettings, bool? quiet) : DockerServiceRollbackSettings
- SetService(this DockerServiceRollbackSettings toolSettings, string service) : DockerServiceRollbackSettings
- ToggleDetach(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings
- ToggleQuiet(this DockerServiceRollbackSettings toolSettings) : DockerServiceRollbackSettings

### Nuke.Common.Tools.Docker.DockerServiceScaleSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ServiceReplicas() : IReadOnlyDictionary<string, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceScaleSettingsExtensions

- AddServiceReplica(this DockerServiceScaleSettings toolSettings, string serviceReplicaKey, string serviceReplicaValue) : DockerServiceScaleSettings
- ClearServiceReplicas(this DockerServiceScaleSettings toolSettings) : DockerServiceScaleSettings
- RemoveServiceReplica(this DockerServiceScaleSettings toolSettings, string serviceReplicaKey) : DockerServiceScaleSettings
- SetServiceReplica(this DockerServiceScaleSettings toolSettings, string serviceReplicaKey, string serviceReplicaValue) : DockerServiceScaleSettings
- SetServiceReplicas(this DockerServiceScaleSettings toolSettings, IDictionary<string, string> serviceReplicas) : DockerServiceScaleSettings

### Nuke.Common.Tools.Docker.DockerServiceSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceSettingsExtensions


### Nuke.Common.Tools.Docker.DockerServiceUpdateSettings

- .ctor()
- get_Args() : string
- get_ConfigAdd() : string
- get_ConfigRm() : IReadOnlyList<string>
- get_ConstraintAdd() : IReadOnlyList<string>
- get_ConstraintRm() : IReadOnlyList<string>
- get_ContainerLabelAdd() : IReadOnlyList<string>
- get_ContainerLabelRm() : IReadOnlyList<string>
- get_CredentialSpec() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_DnsAdd() : IReadOnlyList<string>
- get_DnsOptionAdd() : IReadOnlyList<string>
- get_DnsOptionRm() : IReadOnlyList<string>
- get_DnsRm() : IReadOnlyList<string>
- get_DnsSearchAdd() : IReadOnlyList<string>
- get_DnsSearchRm() : IReadOnlyList<string>
- get_EndpointMode() : string
- get_Entrypoint() : string
- get_EnvAdd() : IReadOnlyList<string>
- get_EnvRm() : IReadOnlyList<string>
- get_Force() : bool?
- get_GenericResourceAdd() : IReadOnlyList<string>
- get_GenericResourceRm() : IReadOnlyList<string>
- get_GroupAdd() : IReadOnlyList<string>
- get_GroupRm() : IReadOnlyList<string>
- get_HealthCmd() : string
- get_HealthInterval() : string
- get_HealthRetries() : int?
- get_HealthStartPeriod() : string
- get_HealthTimeout() : string
- get_HostAdd() : IReadOnlyList<string>
- get_Hostname() : string
- get_HostRm() : IReadOnlyList<string>
- get_Image() : string
- get_Init() : bool?
- get_Isolation() : string
- get_LabelAdd() : IReadOnlyList<string>
- get_LabelRm() : IReadOnlyList<string>
- get_LimitCpu() : decimal?
- get_LimitMemory() : long?
- get_LogDriver() : string
- get_LogOpt() : IReadOnlyList<string>
- get_MountAdd() : string
- get_MountRm() : IReadOnlyList<string>
- get_NetworkAdd() : string
- get_NetworkRm() : IReadOnlyList<string>
- get_NoHealthcheck() : bool?
- get_NoResolveImage() : bool?
- get_PlacementPrefAdd() : string
- get_PlacementPrefRm() : string
- get_PublishAdd() : string
- get_PublishRm() : string
- get_Quiet() : bool?
- get_ReadOnly() : bool?
- get_Replicas() : int?
- get_ReplicasMaxPerNode() : int?
- get_ReserveCpu() : decimal?
- get_ReserveMemory() : long?
- get_RestartCondition() : RestartCondition
- get_RestartDelay() : string
- get_RestartMaxAttempts() : int?
- get_RestartWindow() : string
- get_Rollback() : bool?
- get_RollbackDelay() : string
- get_RollbackFailureAction() : RollbackFailureAction
- get_RollbackMaxFailureRatio() : float?
- get_RollbackMonitor() : string
- get_RollbackOrder() : RollbackOrder
- get_RollbackParallelism() : int?
- get_SecretAdd() : string
- get_SecretRm() : IReadOnlyList<string>
- get_Service() : string
- get_StopGracePeriod() : string
- get_StopSignal() : string
- get_SysctlAdd() : IReadOnlyList<string>
- get_SysctlRm() : IReadOnlyList<string>
- get_ToolPath() : string
- get_Tty() : bool?
- get_UpdateDelay() : string
- get_UpdateFailureAction() : UpdateFailureAction
- get_UpdateMaxFailureRatio() : float?
- get_UpdateMonitor() : string
- get_UpdateOrder() : UpdateOrder
- get_UpdateParallelism() : int?
- get_User() : string
- get_WithRegistryAuth() : bool?
- get_Workdir() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerServiceUpdateSettingsExtensions

- AddConfigRm(this DockerServiceUpdateSettings toolSettings, string[] configRm) : DockerServiceUpdateSettings
- AddConfigRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> configRm) : DockerServiceUpdateSettings
- AddConstraintAdd(this DockerServiceUpdateSettings toolSettings, string[] constraintAdd) : DockerServiceUpdateSettings
- AddConstraintAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintAdd) : DockerServiceUpdateSettings
- AddConstraintRm(this DockerServiceUpdateSettings toolSettings, string[] constraintRm) : DockerServiceUpdateSettings
- AddConstraintRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintRm) : DockerServiceUpdateSettings
- AddContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] containerLabelAdd) : DockerServiceUpdateSettings
- AddContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelAdd) : DockerServiceUpdateSettings
- AddContainerLabelRm(this DockerServiceUpdateSettings toolSettings, string[] containerLabelRm) : DockerServiceUpdateSettings
- AddContainerLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelRm) : DockerServiceUpdateSettings
- AddDnsAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsAdd) : DockerServiceUpdateSettings
- AddDnsAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsAdd) : DockerServiceUpdateSettings
- AddDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionAdd) : DockerServiceUpdateSettings
- AddDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionAdd) : DockerServiceUpdateSettings
- AddDnsOptionRm(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionRm) : DockerServiceUpdateSettings
- AddDnsOptionRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionRm) : DockerServiceUpdateSettings
- AddDnsRm(this DockerServiceUpdateSettings toolSettings, string[] dnsRm) : DockerServiceUpdateSettings
- AddDnsRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsRm) : DockerServiceUpdateSettings
- AddDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchAdd) : DockerServiceUpdateSettings
- AddDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchAdd) : DockerServiceUpdateSettings
- AddDnsSearchRm(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchRm) : DockerServiceUpdateSettings
- AddDnsSearchRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchRm) : DockerServiceUpdateSettings
- AddEnvAdd(this DockerServiceUpdateSettings toolSettings, string[] envAdd) : DockerServiceUpdateSettings
- AddEnvAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envAdd) : DockerServiceUpdateSettings
- AddEnvRm(this DockerServiceUpdateSettings toolSettings, string[] envRm) : DockerServiceUpdateSettings
- AddEnvRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envRm) : DockerServiceUpdateSettings
- AddGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, string[] genericResourceAdd) : DockerServiceUpdateSettings
- AddGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceAdd) : DockerServiceUpdateSettings
- AddGenericResourceRm(this DockerServiceUpdateSettings toolSettings, string[] genericResourceRm) : DockerServiceUpdateSettings
- AddGenericResourceRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceRm) : DockerServiceUpdateSettings
- AddGroupAdd(this DockerServiceUpdateSettings toolSettings, string[] groupAdd) : DockerServiceUpdateSettings
- AddGroupAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupAdd) : DockerServiceUpdateSettings
- AddGroupRm(this DockerServiceUpdateSettings toolSettings, string[] groupRm) : DockerServiceUpdateSettings
- AddGroupRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupRm) : DockerServiceUpdateSettings
- AddHostAdd(this DockerServiceUpdateSettings toolSettings, string[] hostAdd) : DockerServiceUpdateSettings
- AddHostAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostAdd) : DockerServiceUpdateSettings
- AddHostRm(this DockerServiceUpdateSettings toolSettings, string[] hostRm) : DockerServiceUpdateSettings
- AddHostRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostRm) : DockerServiceUpdateSettings
- AddLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] labelAdd) : DockerServiceUpdateSettings
- AddLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerServiceUpdateSettings
- AddLabelRm(this DockerServiceUpdateSettings toolSettings, string[] labelRm) : DockerServiceUpdateSettings
- AddLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerServiceUpdateSettings
- AddLogOpt(this DockerServiceUpdateSettings toolSettings, string[] logOpt) : DockerServiceUpdateSettings
- AddLogOpt(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceUpdateSettings
- AddMountRm(this DockerServiceUpdateSettings toolSettings, string[] mountRm) : DockerServiceUpdateSettings
- AddMountRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> mountRm) : DockerServiceUpdateSettings
- AddNetworkRm(this DockerServiceUpdateSettings toolSettings, string[] networkRm) : DockerServiceUpdateSettings
- AddNetworkRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> networkRm) : DockerServiceUpdateSettings
- AddSecretRm(this DockerServiceUpdateSettings toolSettings, string[] secretRm) : DockerServiceUpdateSettings
- AddSecretRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> secretRm) : DockerServiceUpdateSettings
- AddSysctlAdd(this DockerServiceUpdateSettings toolSettings, string[] sysctlAdd) : DockerServiceUpdateSettings
- AddSysctlAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlAdd) : DockerServiceUpdateSettings
- AddSysctlRm(this DockerServiceUpdateSettings toolSettings, string[] sysctlRm) : DockerServiceUpdateSettings
- AddSysctlRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlRm) : DockerServiceUpdateSettings
- ClearConfigRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearConstraintAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearConstraintRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearContainerLabelAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearContainerLabelRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsOptionAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsOptionRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsSearchAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearDnsSearchRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearEnvAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearEnvRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearGenericResourceAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearGenericResourceRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearGroupAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearGroupRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearHostAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearHostRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearLabelAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearLabelRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearLogOpt(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearMountRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearNetworkRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearSecretRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearSysctlAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ClearSysctlRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableDetach(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableForce(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableInit(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableNoHealthcheck(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableNoResolveImage(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableQuiet(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableReadOnly(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableRollback(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableTty(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- DisableWithRegistryAuth(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableDetach(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableForce(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableInit(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableNoHealthcheck(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableNoResolveImage(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableQuiet(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableReadOnly(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableRollback(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableTty(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- EnableWithRegistryAuth(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- RemoveConfigRm(this DockerServiceUpdateSettings toolSettings, string[] configRm) : DockerServiceUpdateSettings
- RemoveConfigRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> configRm) : DockerServiceUpdateSettings
- RemoveConstraintAdd(this DockerServiceUpdateSettings toolSettings, string[] constraintAdd) : DockerServiceUpdateSettings
- RemoveConstraintAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintAdd) : DockerServiceUpdateSettings
- RemoveConstraintRm(this DockerServiceUpdateSettings toolSettings, string[] constraintRm) : DockerServiceUpdateSettings
- RemoveConstraintRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintRm) : DockerServiceUpdateSettings
- RemoveContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] containerLabelAdd) : DockerServiceUpdateSettings
- RemoveContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelAdd) : DockerServiceUpdateSettings
- RemoveContainerLabelRm(this DockerServiceUpdateSettings toolSettings, string[] containerLabelRm) : DockerServiceUpdateSettings
- RemoveContainerLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelRm) : DockerServiceUpdateSettings
- RemoveDnsAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsAdd) : DockerServiceUpdateSettings
- RemoveDnsAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsAdd) : DockerServiceUpdateSettings
- RemoveDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionAdd) : DockerServiceUpdateSettings
- RemoveDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionAdd) : DockerServiceUpdateSettings
- RemoveDnsOptionRm(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionRm) : DockerServiceUpdateSettings
- RemoveDnsOptionRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionRm) : DockerServiceUpdateSettings
- RemoveDnsRm(this DockerServiceUpdateSettings toolSettings, string[] dnsRm) : DockerServiceUpdateSettings
- RemoveDnsRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsRm) : DockerServiceUpdateSettings
- RemoveDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchAdd) : DockerServiceUpdateSettings
- RemoveDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchAdd) : DockerServiceUpdateSettings
- RemoveDnsSearchRm(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchRm) : DockerServiceUpdateSettings
- RemoveDnsSearchRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchRm) : DockerServiceUpdateSettings
- RemoveEnvAdd(this DockerServiceUpdateSettings toolSettings, string[] envAdd) : DockerServiceUpdateSettings
- RemoveEnvAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envAdd) : DockerServiceUpdateSettings
- RemoveEnvRm(this DockerServiceUpdateSettings toolSettings, string[] envRm) : DockerServiceUpdateSettings
- RemoveEnvRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envRm) : DockerServiceUpdateSettings
- RemoveGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, string[] genericResourceAdd) : DockerServiceUpdateSettings
- RemoveGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceAdd) : DockerServiceUpdateSettings
- RemoveGenericResourceRm(this DockerServiceUpdateSettings toolSettings, string[] genericResourceRm) : DockerServiceUpdateSettings
- RemoveGenericResourceRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceRm) : DockerServiceUpdateSettings
- RemoveGroupAdd(this DockerServiceUpdateSettings toolSettings, string[] groupAdd) : DockerServiceUpdateSettings
- RemoveGroupAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupAdd) : DockerServiceUpdateSettings
- RemoveGroupRm(this DockerServiceUpdateSettings toolSettings, string[] groupRm) : DockerServiceUpdateSettings
- RemoveGroupRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupRm) : DockerServiceUpdateSettings
- RemoveHostAdd(this DockerServiceUpdateSettings toolSettings, string[] hostAdd) : DockerServiceUpdateSettings
- RemoveHostAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostAdd) : DockerServiceUpdateSettings
- RemoveHostRm(this DockerServiceUpdateSettings toolSettings, string[] hostRm) : DockerServiceUpdateSettings
- RemoveHostRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostRm) : DockerServiceUpdateSettings
- RemoveLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] labelAdd) : DockerServiceUpdateSettings
- RemoveLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerServiceUpdateSettings
- RemoveLabelRm(this DockerServiceUpdateSettings toolSettings, string[] labelRm) : DockerServiceUpdateSettings
- RemoveLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerServiceUpdateSettings
- RemoveLogOpt(this DockerServiceUpdateSettings toolSettings, string[] logOpt) : DockerServiceUpdateSettings
- RemoveLogOpt(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceUpdateSettings
- RemoveMountRm(this DockerServiceUpdateSettings toolSettings, string[] mountRm) : DockerServiceUpdateSettings
- RemoveMountRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> mountRm) : DockerServiceUpdateSettings
- RemoveNetworkRm(this DockerServiceUpdateSettings toolSettings, string[] networkRm) : DockerServiceUpdateSettings
- RemoveNetworkRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> networkRm) : DockerServiceUpdateSettings
- RemoveSecretRm(this DockerServiceUpdateSettings toolSettings, string[] secretRm) : DockerServiceUpdateSettings
- RemoveSecretRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> secretRm) : DockerServiceUpdateSettings
- RemoveSysctlAdd(this DockerServiceUpdateSettings toolSettings, string[] sysctlAdd) : DockerServiceUpdateSettings
- RemoveSysctlAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlAdd) : DockerServiceUpdateSettings
- RemoveSysctlRm(this DockerServiceUpdateSettings toolSettings, string[] sysctlRm) : DockerServiceUpdateSettings
- RemoveSysctlRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlRm) : DockerServiceUpdateSettings
- ResetArgs(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetConfigAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetCredentialSpec(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetDetach(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetEndpointMode(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetEntrypoint(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetForce(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHealthCmd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHealthInterval(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHealthRetries(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHealthStartPeriod(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHealthTimeout(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetHostname(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetImage(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetInit(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetIsolation(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetLimitCpu(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetLimitMemory(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetLogDriver(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetMountAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetNetworkAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetNoHealthcheck(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetNoResolveImage(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetPlacementPrefAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetPlacementPrefRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetPublishAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetPublishRm(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetQuiet(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetReadOnly(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetReplicas(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetReplicasMaxPerNode(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetReserveCpu(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetReserveMemory(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRestartCondition(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRestartDelay(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRestartMaxAttempts(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRestartWindow(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollback(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackDelay(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackFailureAction(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackMaxFailureRatio(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackMonitor(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackOrder(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetRollbackParallelism(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetSecretAdd(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetService(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetStopGracePeriod(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetStopSignal(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetTty(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateDelay(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateFailureAction(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateMaxFailureRatio(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateMonitor(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateOrder(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUpdateParallelism(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetUser(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetWithRegistryAuth(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ResetWorkdir(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- SetArgs(this DockerServiceUpdateSettings toolSettings, string args) : DockerServiceUpdateSettings
- SetConfigAdd(this DockerServiceUpdateSettings toolSettings, string configAdd) : DockerServiceUpdateSettings
- SetConfigRm(this DockerServiceUpdateSettings toolSettings, string[] configRm) : DockerServiceUpdateSettings
- SetConfigRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> configRm) : DockerServiceUpdateSettings
- SetConstraintAdd(this DockerServiceUpdateSettings toolSettings, string[] constraintAdd) : DockerServiceUpdateSettings
- SetConstraintAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintAdd) : DockerServiceUpdateSettings
- SetConstraintRm(this DockerServiceUpdateSettings toolSettings, string[] constraintRm) : DockerServiceUpdateSettings
- SetConstraintRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> constraintRm) : DockerServiceUpdateSettings
- SetContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] containerLabelAdd) : DockerServiceUpdateSettings
- SetContainerLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelAdd) : DockerServiceUpdateSettings
- SetContainerLabelRm(this DockerServiceUpdateSettings toolSettings, string[] containerLabelRm) : DockerServiceUpdateSettings
- SetContainerLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> containerLabelRm) : DockerServiceUpdateSettings
- SetCredentialSpec(this DockerServiceUpdateSettings toolSettings, string credentialSpec) : DockerServiceUpdateSettings
- SetDetach(this DockerServiceUpdateSettings toolSettings, bool? detach) : DockerServiceUpdateSettings
- SetDnsAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsAdd) : DockerServiceUpdateSettings
- SetDnsAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsAdd) : DockerServiceUpdateSettings
- SetDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionAdd) : DockerServiceUpdateSettings
- SetDnsOptionAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionAdd) : DockerServiceUpdateSettings
- SetDnsOptionRm(this DockerServiceUpdateSettings toolSettings, string[] dnsOptionRm) : DockerServiceUpdateSettings
- SetDnsOptionRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsOptionRm) : DockerServiceUpdateSettings
- SetDnsRm(this DockerServiceUpdateSettings toolSettings, string[] dnsRm) : DockerServiceUpdateSettings
- SetDnsRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsRm) : DockerServiceUpdateSettings
- SetDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchAdd) : DockerServiceUpdateSettings
- SetDnsSearchAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchAdd) : DockerServiceUpdateSettings
- SetDnsSearchRm(this DockerServiceUpdateSettings toolSettings, string[] dnsSearchRm) : DockerServiceUpdateSettings
- SetDnsSearchRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> dnsSearchRm) : DockerServiceUpdateSettings
- SetEndpointMode(this DockerServiceUpdateSettings toolSettings, string endpointMode) : DockerServiceUpdateSettings
- SetEntrypoint(this DockerServiceUpdateSettings toolSettings, string entrypoint) : DockerServiceUpdateSettings
- SetEnvAdd(this DockerServiceUpdateSettings toolSettings, string[] envAdd) : DockerServiceUpdateSettings
- SetEnvAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envAdd) : DockerServiceUpdateSettings
- SetEnvRm(this DockerServiceUpdateSettings toolSettings, string[] envRm) : DockerServiceUpdateSettings
- SetEnvRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> envRm) : DockerServiceUpdateSettings
- SetForce(this DockerServiceUpdateSettings toolSettings, bool? force) : DockerServiceUpdateSettings
- SetGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, string[] genericResourceAdd) : DockerServiceUpdateSettings
- SetGenericResourceAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceAdd) : DockerServiceUpdateSettings
- SetGenericResourceRm(this DockerServiceUpdateSettings toolSettings, string[] genericResourceRm) : DockerServiceUpdateSettings
- SetGenericResourceRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> genericResourceRm) : DockerServiceUpdateSettings
- SetGroupAdd(this DockerServiceUpdateSettings toolSettings, string[] groupAdd) : DockerServiceUpdateSettings
- SetGroupAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupAdd) : DockerServiceUpdateSettings
- SetGroupRm(this DockerServiceUpdateSettings toolSettings, string[] groupRm) : DockerServiceUpdateSettings
- SetGroupRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> groupRm) : DockerServiceUpdateSettings
- SetHealthCmd(this DockerServiceUpdateSettings toolSettings, string healthCmd) : DockerServiceUpdateSettings
- SetHealthInterval(this DockerServiceUpdateSettings toolSettings, string healthInterval) : DockerServiceUpdateSettings
- SetHealthRetries(this DockerServiceUpdateSettings toolSettings, int? healthRetries) : DockerServiceUpdateSettings
- SetHealthStartPeriod(this DockerServiceUpdateSettings toolSettings, string healthStartPeriod) : DockerServiceUpdateSettings
- SetHealthTimeout(this DockerServiceUpdateSettings toolSettings, string healthTimeout) : DockerServiceUpdateSettings
- SetHostAdd(this DockerServiceUpdateSettings toolSettings, string[] hostAdd) : DockerServiceUpdateSettings
- SetHostAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostAdd) : DockerServiceUpdateSettings
- SetHostname(this DockerServiceUpdateSettings toolSettings, string hostname) : DockerServiceUpdateSettings
- SetHostRm(this DockerServiceUpdateSettings toolSettings, string[] hostRm) : DockerServiceUpdateSettings
- SetHostRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> hostRm) : DockerServiceUpdateSettings
- SetImage(this DockerServiceUpdateSettings toolSettings, string image) : DockerServiceUpdateSettings
- SetInit(this DockerServiceUpdateSettings toolSettings, bool? init) : DockerServiceUpdateSettings
- SetIsolation(this DockerServiceUpdateSettings toolSettings, string isolation) : DockerServiceUpdateSettings
- SetLabelAdd(this DockerServiceUpdateSettings toolSettings, string[] labelAdd) : DockerServiceUpdateSettings
- SetLabelAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelAdd) : DockerServiceUpdateSettings
- SetLabelRm(this DockerServiceUpdateSettings toolSettings, string[] labelRm) : DockerServiceUpdateSettings
- SetLabelRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> labelRm) : DockerServiceUpdateSettings
- SetLimitCpu(this DockerServiceUpdateSettings toolSettings, decimal? limitCpu) : DockerServiceUpdateSettings
- SetLimitMemory(this DockerServiceUpdateSettings toolSettings, long? limitMemory) : DockerServiceUpdateSettings
- SetLogDriver(this DockerServiceUpdateSettings toolSettings, string logDriver) : DockerServiceUpdateSettings
- SetLogOpt(this DockerServiceUpdateSettings toolSettings, string[] logOpt) : DockerServiceUpdateSettings
- SetLogOpt(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> logOpt) : DockerServiceUpdateSettings
- SetMountAdd(this DockerServiceUpdateSettings toolSettings, string mountAdd) : DockerServiceUpdateSettings
- SetMountRm(this DockerServiceUpdateSettings toolSettings, string[] mountRm) : DockerServiceUpdateSettings
- SetMountRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> mountRm) : DockerServiceUpdateSettings
- SetNetworkAdd(this DockerServiceUpdateSettings toolSettings, string networkAdd) : DockerServiceUpdateSettings
- SetNetworkRm(this DockerServiceUpdateSettings toolSettings, string[] networkRm) : DockerServiceUpdateSettings
- SetNetworkRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> networkRm) : DockerServiceUpdateSettings
- SetNoHealthcheck(this DockerServiceUpdateSettings toolSettings, bool? noHealthcheck) : DockerServiceUpdateSettings
- SetNoResolveImage(this DockerServiceUpdateSettings toolSettings, bool? noResolveImage) : DockerServiceUpdateSettings
- SetPlacementPrefAdd(this DockerServiceUpdateSettings toolSettings, string placementPrefAdd) : DockerServiceUpdateSettings
- SetPlacementPrefRm(this DockerServiceUpdateSettings toolSettings, string placementPrefRm) : DockerServiceUpdateSettings
- SetPublishAdd(this DockerServiceUpdateSettings toolSettings, string publishAdd) : DockerServiceUpdateSettings
- SetPublishRm(this DockerServiceUpdateSettings toolSettings, string publishRm) : DockerServiceUpdateSettings
- SetQuiet(this DockerServiceUpdateSettings toolSettings, bool? quiet) : DockerServiceUpdateSettings
- SetReadOnly(this DockerServiceUpdateSettings toolSettings, bool? readOnly) : DockerServiceUpdateSettings
- SetReplicas(this DockerServiceUpdateSettings toolSettings, int? replicas) : DockerServiceUpdateSettings
- SetReplicasMaxPerNode(this DockerServiceUpdateSettings toolSettings, int? replicasMaxPerNode) : DockerServiceUpdateSettings
- SetReserveCpu(this DockerServiceUpdateSettings toolSettings, decimal? reserveCpu) : DockerServiceUpdateSettings
- SetReserveMemory(this DockerServiceUpdateSettings toolSettings, long? reserveMemory) : DockerServiceUpdateSettings
- SetRestartCondition(this DockerServiceUpdateSettings toolSettings, RestartCondition restartCondition) : DockerServiceUpdateSettings
- SetRestartDelay(this DockerServiceUpdateSettings toolSettings, string restartDelay) : DockerServiceUpdateSettings
- SetRestartMaxAttempts(this DockerServiceUpdateSettings toolSettings, int? restartMaxAttempts) : DockerServiceUpdateSettings
- SetRestartWindow(this DockerServiceUpdateSettings toolSettings, string restartWindow) : DockerServiceUpdateSettings
- SetRollback(this DockerServiceUpdateSettings toolSettings, bool? rollback) : DockerServiceUpdateSettings
- SetRollbackDelay(this DockerServiceUpdateSettings toolSettings, string rollbackDelay) : DockerServiceUpdateSettings
- SetRollbackFailureAction(this DockerServiceUpdateSettings toolSettings, RollbackFailureAction rollbackFailureAction) : DockerServiceUpdateSettings
- SetRollbackMaxFailureRatio(this DockerServiceUpdateSettings toolSettings, float? rollbackMaxFailureRatio) : DockerServiceUpdateSettings
- SetRollbackMonitor(this DockerServiceUpdateSettings toolSettings, string rollbackMonitor) : DockerServiceUpdateSettings
- SetRollbackOrder(this DockerServiceUpdateSettings toolSettings, RollbackOrder rollbackOrder) : DockerServiceUpdateSettings
- SetRollbackParallelism(this DockerServiceUpdateSettings toolSettings, int? rollbackParallelism) : DockerServiceUpdateSettings
- SetSecretAdd(this DockerServiceUpdateSettings toolSettings, string secretAdd) : DockerServiceUpdateSettings
- SetSecretRm(this DockerServiceUpdateSettings toolSettings, string[] secretRm) : DockerServiceUpdateSettings
- SetSecretRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> secretRm) : DockerServiceUpdateSettings
- SetService(this DockerServiceUpdateSettings toolSettings, string service) : DockerServiceUpdateSettings
- SetStopGracePeriod(this DockerServiceUpdateSettings toolSettings, string stopGracePeriod) : DockerServiceUpdateSettings
- SetStopSignal(this DockerServiceUpdateSettings toolSettings, string stopSignal) : DockerServiceUpdateSettings
- SetSysctlAdd(this DockerServiceUpdateSettings toolSettings, string[] sysctlAdd) : DockerServiceUpdateSettings
- SetSysctlAdd(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlAdd) : DockerServiceUpdateSettings
- SetSysctlRm(this DockerServiceUpdateSettings toolSettings, string[] sysctlRm) : DockerServiceUpdateSettings
- SetSysctlRm(this DockerServiceUpdateSettings toolSettings, IEnumerable<string> sysctlRm) : DockerServiceUpdateSettings
- SetTty(this DockerServiceUpdateSettings toolSettings, bool? tty) : DockerServiceUpdateSettings
- SetUpdateDelay(this DockerServiceUpdateSettings toolSettings, string updateDelay) : DockerServiceUpdateSettings
- SetUpdateFailureAction(this DockerServiceUpdateSettings toolSettings, UpdateFailureAction updateFailureAction) : DockerServiceUpdateSettings
- SetUpdateMaxFailureRatio(this DockerServiceUpdateSettings toolSettings, float? updateMaxFailureRatio) : DockerServiceUpdateSettings
- SetUpdateMonitor(this DockerServiceUpdateSettings toolSettings, string updateMonitor) : DockerServiceUpdateSettings
- SetUpdateOrder(this DockerServiceUpdateSettings toolSettings, UpdateOrder updateOrder) : DockerServiceUpdateSettings
- SetUpdateParallelism(this DockerServiceUpdateSettings toolSettings, int? updateParallelism) : DockerServiceUpdateSettings
- SetUser(this DockerServiceUpdateSettings toolSettings, string user) : DockerServiceUpdateSettings
- SetWithRegistryAuth(this DockerServiceUpdateSettings toolSettings, bool? withRegistryAuth) : DockerServiceUpdateSettings
- SetWorkdir(this DockerServiceUpdateSettings toolSettings, string workdir) : DockerServiceUpdateSettings
- ToggleDetach(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleForce(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleInit(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleNoHealthcheck(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleNoResolveImage(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleQuiet(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleReadOnly(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleRollback(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleTty(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings
- ToggleWithRegistryAuth(this DockerServiceUpdateSettings toolSettings) : DockerServiceUpdateSettings

### Nuke.Common.Tools.Docker.DockerSettings

- .ctor()
- get_CliSettings() : CliSettings
- ConfigureArguments(Arguments arguments) : Arguments
- GetCliSettings() : string

### Nuke.Common.Tools.Docker.DockerSettingsExtensions

- ResetCliSettings(this T settings) : T
- SetCliSettings(this T settings, Configure<CliSettings> configure) : T

### Nuke.Common.Tools.Docker.DockerStackDeploySettings

- .ctor()
- get_BundleFile() : string
- get_ComposeFile() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Namespace() : string
- get_Prune() : bool?
- get_ResolveImage() : ResolveImage
- get_Stack() : string
- get_ToolPath() : string
- get_WithRegistryAuth() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackDeploySettingsExtensions

- AddComposeFile(this DockerStackDeploySettings toolSettings, string[] composeFile) : DockerStackDeploySettings
- AddComposeFile(this DockerStackDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerStackDeploySettings
- ClearComposeFile(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- DisablePrune(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- DisableWithRegistryAuth(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- EnablePrune(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- EnableWithRegistryAuth(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- RemoveComposeFile(this DockerStackDeploySettings toolSettings, string[] composeFile) : DockerStackDeploySettings
- RemoveComposeFile(this DockerStackDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerStackDeploySettings
- ResetBundleFile(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ResetNamespace(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ResetPrune(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ResetResolveImage(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ResetStack(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ResetWithRegistryAuth(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- SetBundleFile(this DockerStackDeploySettings toolSettings, string bundleFile) : DockerStackDeploySettings
- SetComposeFile(this DockerStackDeploySettings toolSettings, string[] composeFile) : DockerStackDeploySettings
- SetComposeFile(this DockerStackDeploySettings toolSettings, IEnumerable<string> composeFile) : DockerStackDeploySettings
- SetNamespace(this DockerStackDeploySettings toolSettings, string namespace) : DockerStackDeploySettings
- SetPrune(this DockerStackDeploySettings toolSettings, bool? prune) : DockerStackDeploySettings
- SetResolveImage(this DockerStackDeploySettings toolSettings, ResolveImage resolveImage) : DockerStackDeploySettings
- SetStack(this DockerStackDeploySettings toolSettings, string stack) : DockerStackDeploySettings
- SetWithRegistryAuth(this DockerStackDeploySettings toolSettings, bool? withRegistryAuth) : DockerStackDeploySettings
- TogglePrune(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings
- ToggleWithRegistryAuth(this DockerStackDeploySettings toolSettings) : DockerStackDeploySettings

### Nuke.Common.Tools.Docker.DockerStackLsSettings

- .ctor()
- get_AllNamespaces() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Namespace() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackLsSettingsExtensions

- AddNamespace(this DockerStackLsSettings toolSettings, string[] namespace) : DockerStackLsSettings
- AddNamespace(this DockerStackLsSettings toolSettings, IEnumerable<string> namespace) : DockerStackLsSettings
- ClearNamespace(this DockerStackLsSettings toolSettings) : DockerStackLsSettings
- DisableAllNamespaces(this DockerStackLsSettings toolSettings) : DockerStackLsSettings
- EnableAllNamespaces(this DockerStackLsSettings toolSettings) : DockerStackLsSettings
- RemoveNamespace(this DockerStackLsSettings toolSettings, string[] namespace) : DockerStackLsSettings
- RemoveNamespace(this DockerStackLsSettings toolSettings, IEnumerable<string> namespace) : DockerStackLsSettings
- ResetAllNamespaces(this DockerStackLsSettings toolSettings) : DockerStackLsSettings
- ResetFormat(this DockerStackLsSettings toolSettings) : DockerStackLsSettings
- SetAllNamespaces(this DockerStackLsSettings toolSettings, bool? allNamespaces) : DockerStackLsSettings
- SetFormat(this DockerStackLsSettings toolSettings, string format) : DockerStackLsSettings
- SetNamespace(this DockerStackLsSettings toolSettings, string[] namespace) : DockerStackLsSettings
- SetNamespace(this DockerStackLsSettings toolSettings, IEnumerable<string> namespace) : DockerStackLsSettings
- ToggleAllNamespaces(this DockerStackLsSettings toolSettings) : DockerStackLsSettings

### Nuke.Common.Tools.Docker.DockerStackPsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Namespace() : string
- get_NoResolve() : bool?
- get_NoTrunc() : bool?
- get_Quiet() : bool?
- get_Stack() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackPsSettingsExtensions

- DisableNoResolve(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- DisableNoTrunc(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- DisableQuiet(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- EnableNoResolve(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- EnableNoTrunc(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- EnableQuiet(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetFilter(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetFormat(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetNamespace(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetNoResolve(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetNoTrunc(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetQuiet(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ResetStack(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- SetFilter(this DockerStackPsSettings toolSettings, string filter) : DockerStackPsSettings
- SetFormat(this DockerStackPsSettings toolSettings, string format) : DockerStackPsSettings
- SetNamespace(this DockerStackPsSettings toolSettings, string namespace) : DockerStackPsSettings
- SetNoResolve(this DockerStackPsSettings toolSettings, bool? noResolve) : DockerStackPsSettings
- SetNoTrunc(this DockerStackPsSettings toolSettings, bool? noTrunc) : DockerStackPsSettings
- SetQuiet(this DockerStackPsSettings toolSettings, bool? quiet) : DockerStackPsSettings
- SetStack(this DockerStackPsSettings toolSettings, string stack) : DockerStackPsSettings
- ToggleNoResolve(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ToggleNoTrunc(this DockerStackPsSettings toolSettings) : DockerStackPsSettings
- ToggleQuiet(this DockerStackPsSettings toolSettings) : DockerStackPsSettings

### Nuke.Common.Tools.Docker.DockerStackRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Namespace() : string
- get_Stacks() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackRmSettingsExtensions

- AddStacks(this DockerStackRmSettings toolSettings, string[] stacks) : DockerStackRmSettings
- AddStacks(this DockerStackRmSettings toolSettings, IEnumerable<string> stacks) : DockerStackRmSettings
- ClearStacks(this DockerStackRmSettings toolSettings) : DockerStackRmSettings
- RemoveStacks(this DockerStackRmSettings toolSettings, string[] stacks) : DockerStackRmSettings
- RemoveStacks(this DockerStackRmSettings toolSettings, IEnumerable<string> stacks) : DockerStackRmSettings
- ResetNamespace(this DockerStackRmSettings toolSettings) : DockerStackRmSettings
- SetNamespace(this DockerStackRmSettings toolSettings, string namespace) : DockerStackRmSettings
- SetStacks(this DockerStackRmSettings toolSettings, string[] stacks) : DockerStackRmSettings
- SetStacks(this DockerStackRmSettings toolSettings, IEnumerable<string> stacks) : DockerStackRmSettings

### Nuke.Common.Tools.Docker.DockerStackServicesSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Namespace() : string
- get_Quiet() : bool?
- get_Stack() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackServicesSettingsExtensions

- DisableQuiet(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- EnableQuiet(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- ResetFilter(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- ResetFormat(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- ResetNamespace(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- ResetQuiet(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- ResetStack(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings
- SetFilter(this DockerStackServicesSettings toolSettings, string filter) : DockerStackServicesSettings
- SetFormat(this DockerStackServicesSettings toolSettings, string format) : DockerStackServicesSettings
- SetNamespace(this DockerStackServicesSettings toolSettings, string namespace) : DockerStackServicesSettings
- SetQuiet(this DockerStackServicesSettings toolSettings, bool? quiet) : DockerStackServicesSettings
- SetStack(this DockerStackServicesSettings toolSettings, string stack) : DockerStackServicesSettings
- ToggleQuiet(this DockerStackServicesSettings toolSettings) : DockerStackServicesSettings

### Nuke.Common.Tools.Docker.DockerStackSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Kubeconfig() : string
- get_Orchestrator() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStackSettingsExtensions

- ResetKubeconfig(this DockerStackSettings toolSettings) : DockerStackSettings
- ResetOrchestrator(this DockerStackSettings toolSettings) : DockerStackSettings
- SetKubeconfig(this DockerStackSettings toolSettings, string kubeconfig) : DockerStackSettings
- SetOrchestrator(this DockerStackSettings toolSettings, string orchestrator) : DockerStackSettings

### Nuke.Common.Tools.Docker.DockerStartSettings

- .ctor()
- get_Attach() : bool?
- get_Checkpoint() : string
- get_CheckpointDir() : string
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_DetachKeys() : string
- get_Interactive() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStartSettingsExtensions

- AddContainers(this DockerStartSettings toolSettings, string[] containers) : DockerStartSettings
- AddContainers(this DockerStartSettings toolSettings, IEnumerable<string> containers) : DockerStartSettings
- ClearContainers(this DockerStartSettings toolSettings) : DockerStartSettings
- DisableAttach(this DockerStartSettings toolSettings) : DockerStartSettings
- DisableInteractive(this DockerStartSettings toolSettings) : DockerStartSettings
- EnableAttach(this DockerStartSettings toolSettings) : DockerStartSettings
- EnableInteractive(this DockerStartSettings toolSettings) : DockerStartSettings
- RemoveContainers(this DockerStartSettings toolSettings, string[] containers) : DockerStartSettings
- RemoveContainers(this DockerStartSettings toolSettings, IEnumerable<string> containers) : DockerStartSettings
- ResetAttach(this DockerStartSettings toolSettings) : DockerStartSettings
- ResetCheckpoint(this DockerStartSettings toolSettings) : DockerStartSettings
- ResetCheckpointDir(this DockerStartSettings toolSettings) : DockerStartSettings
- ResetDetachKeys(this DockerStartSettings toolSettings) : DockerStartSettings
- ResetInteractive(this DockerStartSettings toolSettings) : DockerStartSettings
- SetAttach(this DockerStartSettings toolSettings, bool? attach) : DockerStartSettings
- SetCheckpoint(this DockerStartSettings toolSettings, string checkpoint) : DockerStartSettings
- SetCheckpointDir(this DockerStartSettings toolSettings, string checkpointDir) : DockerStartSettings
- SetContainers(this DockerStartSettings toolSettings, string[] containers) : DockerStartSettings
- SetContainers(this DockerStartSettings toolSettings, IEnumerable<string> containers) : DockerStartSettings
- SetDetachKeys(this DockerStartSettings toolSettings, string detachKeys) : DockerStartSettings
- SetInteractive(this DockerStartSettings toolSettings, bool? interactive) : DockerStartSettings
- ToggleAttach(this DockerStartSettings toolSettings) : DockerStartSettings
- ToggleInteractive(this DockerStartSettings toolSettings) : DockerStartSettings

### Nuke.Common.Tools.Docker.DockerStatsSettings

- .ctor()
- get_All() : bool?
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_NoStream() : bool?
- get_NoTrunc() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStatsSettingsExtensions

- AddContainers(this DockerStatsSettings toolSettings, string[] containers) : DockerStatsSettings
- AddContainers(this DockerStatsSettings toolSettings, IEnumerable<string> containers) : DockerStatsSettings
- ClearContainers(this DockerStatsSettings toolSettings) : DockerStatsSettings
- DisableAll(this DockerStatsSettings toolSettings) : DockerStatsSettings
- DisableNoStream(this DockerStatsSettings toolSettings) : DockerStatsSettings
- DisableNoTrunc(this DockerStatsSettings toolSettings) : DockerStatsSettings
- EnableAll(this DockerStatsSettings toolSettings) : DockerStatsSettings
- EnableNoStream(this DockerStatsSettings toolSettings) : DockerStatsSettings
- EnableNoTrunc(this DockerStatsSettings toolSettings) : DockerStatsSettings
- RemoveContainers(this DockerStatsSettings toolSettings, string[] containers) : DockerStatsSettings
- RemoveContainers(this DockerStatsSettings toolSettings, IEnumerable<string> containers) : DockerStatsSettings
- ResetAll(this DockerStatsSettings toolSettings) : DockerStatsSettings
- ResetFormat(this DockerStatsSettings toolSettings) : DockerStatsSettings
- ResetNoStream(this DockerStatsSettings toolSettings) : DockerStatsSettings
- ResetNoTrunc(this DockerStatsSettings toolSettings) : DockerStatsSettings
- SetAll(this DockerStatsSettings toolSettings, bool? all) : DockerStatsSettings
- SetContainers(this DockerStatsSettings toolSettings, string[] containers) : DockerStatsSettings
- SetContainers(this DockerStatsSettings toolSettings, IEnumerable<string> containers) : DockerStatsSettings
- SetFormat(this DockerStatsSettings toolSettings, string format) : DockerStatsSettings
- SetNoStream(this DockerStatsSettings toolSettings, bool? noStream) : DockerStatsSettings
- SetNoTrunc(this DockerStatsSettings toolSettings, bool? noTrunc) : DockerStatsSettings
- ToggleAll(this DockerStatsSettings toolSettings) : DockerStatsSettings
- ToggleNoStream(this DockerStatsSettings toolSettings) : DockerStatsSettings
- ToggleNoTrunc(this DockerStatsSettings toolSettings) : DockerStatsSettings

### Nuke.Common.Tools.Docker.DockerStopSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_Time() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerStopSettingsExtensions

- AddContainers(this DockerStopSettings toolSettings, string[] containers) : DockerStopSettings
- AddContainers(this DockerStopSettings toolSettings, IEnumerable<string> containers) : DockerStopSettings
- ClearContainers(this DockerStopSettings toolSettings) : DockerStopSettings
- RemoveContainers(this DockerStopSettings toolSettings, string[] containers) : DockerStopSettings
- RemoveContainers(this DockerStopSettings toolSettings, IEnumerable<string> containers) : DockerStopSettings
- ResetTime(this DockerStopSettings toolSettings) : DockerStopSettings
- SetContainers(this DockerStopSettings toolSettings, string[] containers) : DockerStopSettings
- SetContainers(this DockerStopSettings toolSettings, IEnumerable<string> containers) : DockerStopSettings
- SetTime(this DockerStopSettings toolSettings, int? time) : DockerStopSettings

### Nuke.Common.Tools.Docker.DockerSwarmCaSettings

- .ctor()
- get_CaCert() : string
- get_CaKey() : string
- get_CertExpiry() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Detach() : bool?
- get_ExternalCa() : string
- get_Quiet() : bool?
- get_Rotate() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmCaSettingsExtensions

- DisableDetach(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- DisableQuiet(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- DisableRotate(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- EnableDetach(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- EnableQuiet(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- EnableRotate(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetCaCert(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetCaKey(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetCertExpiry(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetDetach(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetExternalCa(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetQuiet(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ResetRotate(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- SetCaCert(this DockerSwarmCaSettings toolSettings, string caCert) : DockerSwarmCaSettings
- SetCaKey(this DockerSwarmCaSettings toolSettings, string caKey) : DockerSwarmCaSettings
- SetCertExpiry(this DockerSwarmCaSettings toolSettings, string certExpiry) : DockerSwarmCaSettings
- SetDetach(this DockerSwarmCaSettings toolSettings, bool? detach) : DockerSwarmCaSettings
- SetExternalCa(this DockerSwarmCaSettings toolSettings, string externalCa) : DockerSwarmCaSettings
- SetQuiet(this DockerSwarmCaSettings toolSettings, bool? quiet) : DockerSwarmCaSettings
- SetRotate(this DockerSwarmCaSettings toolSettings, bool? rotate) : DockerSwarmCaSettings
- ToggleDetach(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ToggleQuiet(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings
- ToggleRotate(this DockerSwarmCaSettings toolSettings) : DockerSwarmCaSettings

### Nuke.Common.Tools.Docker.DockerSwarmInitSettings

- .ctor()
- get_AdvertiseAddr() : string
- get_Autolock() : bool?
- get_Availability() : Availability
- get_CertExpiry() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DataPathAddr() : string
- get_DataPathPort() : string
- get_DefaultAddrPool() : string
- get_DefaultAddrPoolMaskLength() : string
- get_DispatcherHeartbeat() : string
- get_ExternalCa() : string
- get_ForceNewCluster() : bool?
- get_ListenAddr() : string
- get_MaxSnapshots() : int?
- get_SnapshotInterval() : int?
- get_TaskHistoryLimit() : long?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmInitSettingsExtensions

- DisableAutolock(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- DisableForceNewCluster(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- EnableAutolock(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- EnableForceNewCluster(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetAdvertiseAddr(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetAutolock(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetAvailability(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetCertExpiry(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetDataPathAddr(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetDataPathPort(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetDefaultAddrPool(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetDefaultAddrPoolMaskLength(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetDispatcherHeartbeat(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetExternalCa(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetForceNewCluster(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetListenAddr(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetMaxSnapshots(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetSnapshotInterval(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ResetTaskHistoryLimit(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- SetAdvertiseAddr(this DockerSwarmInitSettings toolSettings, string advertiseAddr) : DockerSwarmInitSettings
- SetAutolock(this DockerSwarmInitSettings toolSettings, bool? autolock) : DockerSwarmInitSettings
- SetAvailability(this DockerSwarmInitSettings toolSettings, Availability availability) : DockerSwarmInitSettings
- SetCertExpiry(this DockerSwarmInitSettings toolSettings, string certExpiry) : DockerSwarmInitSettings
- SetDataPathAddr(this DockerSwarmInitSettings toolSettings, string dataPathAddr) : DockerSwarmInitSettings
- SetDataPathPort(this DockerSwarmInitSettings toolSettings, string dataPathPort) : DockerSwarmInitSettings
- SetDefaultAddrPool(this DockerSwarmInitSettings toolSettings, string defaultAddrPool) : DockerSwarmInitSettings
- SetDefaultAddrPoolMaskLength(this DockerSwarmInitSettings toolSettings, string defaultAddrPoolMaskLength) : DockerSwarmInitSettings
- SetDispatcherHeartbeat(this DockerSwarmInitSettings toolSettings, string dispatcherHeartbeat) : DockerSwarmInitSettings
- SetExternalCa(this DockerSwarmInitSettings toolSettings, string externalCa) : DockerSwarmInitSettings
- SetForceNewCluster(this DockerSwarmInitSettings toolSettings, bool? forceNewCluster) : DockerSwarmInitSettings
- SetListenAddr(this DockerSwarmInitSettings toolSettings, string listenAddr) : DockerSwarmInitSettings
- SetMaxSnapshots(this DockerSwarmInitSettings toolSettings, int? maxSnapshots) : DockerSwarmInitSettings
- SetSnapshotInterval(this DockerSwarmInitSettings toolSettings, int? snapshotInterval) : DockerSwarmInitSettings
- SetTaskHistoryLimit(this DockerSwarmInitSettings toolSettings, long? taskHistoryLimit) : DockerSwarmInitSettings
- ToggleAutolock(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings
- ToggleForceNewCluster(this DockerSwarmInitSettings toolSettings) : DockerSwarmInitSettings

### Nuke.Common.Tools.Docker.DockerSwarmJoinSettings

- .ctor()
- get_AdvertiseAddr() : string
- get_Availability() : Availability
- get_CustomLogger() : Action<OutputType, string>
- get_DataPathAddr() : string
- get_ListenAddr() : string
- get_Token() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmJoinSettingsExtensions

- ResetAdvertiseAddr(this DockerSwarmJoinSettings toolSettings) : DockerSwarmJoinSettings
- ResetAvailability(this DockerSwarmJoinSettings toolSettings) : DockerSwarmJoinSettings
- ResetDataPathAddr(this DockerSwarmJoinSettings toolSettings) : DockerSwarmJoinSettings
- ResetListenAddr(this DockerSwarmJoinSettings toolSettings) : DockerSwarmJoinSettings
- ResetToken(this DockerSwarmJoinSettings toolSettings) : DockerSwarmJoinSettings
- SetAdvertiseAddr(this DockerSwarmJoinSettings toolSettings, string advertiseAddr) : DockerSwarmJoinSettings
- SetAvailability(this DockerSwarmJoinSettings toolSettings, Availability availability) : DockerSwarmJoinSettings
- SetDataPathAddr(this DockerSwarmJoinSettings toolSettings, string dataPathAddr) : DockerSwarmJoinSettings
- SetListenAddr(this DockerSwarmJoinSettings toolSettings, string listenAddr) : DockerSwarmJoinSettings
- SetToken(this DockerSwarmJoinSettings toolSettings, string token) : DockerSwarmJoinSettings

### Nuke.Common.Tools.Docker.DockerSwarmJoinTokenSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Quiet() : bool?
- get_Rotate() : bool?
- get_ToolPath() : string
- get_Worker() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmJoinTokenSettingsExtensions

- DisableQuiet(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- DisableRotate(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- EnableQuiet(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- EnableRotate(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- ResetQuiet(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- ResetRotate(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- ResetWorker(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- SetQuiet(this DockerSwarmJoinTokenSettings toolSettings, bool? quiet) : DockerSwarmJoinTokenSettings
- SetRotate(this DockerSwarmJoinTokenSettings toolSettings, bool? rotate) : DockerSwarmJoinTokenSettings
- SetWorker(this DockerSwarmJoinTokenSettings toolSettings, string worker) : DockerSwarmJoinTokenSettings
- ToggleQuiet(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings
- ToggleRotate(this DockerSwarmJoinTokenSettings toolSettings) : DockerSwarmJoinTokenSettings

### Nuke.Common.Tools.Docker.DockerSwarmLeaveSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmLeaveSettingsExtensions

- DisableForce(this DockerSwarmLeaveSettings toolSettings) : DockerSwarmLeaveSettings
- EnableForce(this DockerSwarmLeaveSettings toolSettings) : DockerSwarmLeaveSettings
- ResetForce(this DockerSwarmLeaveSettings toolSettings) : DockerSwarmLeaveSettings
- SetForce(this DockerSwarmLeaveSettings toolSettings, bool? force) : DockerSwarmLeaveSettings
- ToggleForce(this DockerSwarmLeaveSettings toolSettings) : DockerSwarmLeaveSettings

### Nuke.Common.Tools.Docker.DockerSwarmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmSettingsExtensions


### Nuke.Common.Tools.Docker.DockerSwarmUnlockKeySettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Quiet() : bool?
- get_Rotate() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmUnlockKeySettingsExtensions

- DisableQuiet(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- DisableRotate(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- EnableQuiet(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- EnableRotate(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- ResetQuiet(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- ResetRotate(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- SetQuiet(this DockerSwarmUnlockKeySettings toolSettings, bool? quiet) : DockerSwarmUnlockKeySettings
- SetRotate(this DockerSwarmUnlockKeySettings toolSettings, bool? rotate) : DockerSwarmUnlockKeySettings
- ToggleQuiet(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings
- ToggleRotate(this DockerSwarmUnlockKeySettings toolSettings) : DockerSwarmUnlockKeySettings

### Nuke.Common.Tools.Docker.DockerSwarmUnlockSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmUnlockSettingsExtensions


### Nuke.Common.Tools.Docker.DockerSwarmUpdateSettings

- .ctor()
- get_Autolock() : bool?
- get_CertExpiry() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DispatcherHeartbeat() : string
- get_ExternalCa() : string
- get_MaxSnapshots() : int?
- get_SnapshotInterval() : int?
- get_TaskHistoryLimit() : long?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSwarmUpdateSettingsExtensions

- DisableAutolock(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- EnableAutolock(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetAutolock(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetCertExpiry(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetDispatcherHeartbeat(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetExternalCa(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetMaxSnapshots(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetSnapshotInterval(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- ResetTaskHistoryLimit(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings
- SetAutolock(this DockerSwarmUpdateSettings toolSettings, bool? autolock) : DockerSwarmUpdateSettings
- SetCertExpiry(this DockerSwarmUpdateSettings toolSettings, string certExpiry) : DockerSwarmUpdateSettings
- SetDispatcherHeartbeat(this DockerSwarmUpdateSettings toolSettings, string dispatcherHeartbeat) : DockerSwarmUpdateSettings
- SetExternalCa(this DockerSwarmUpdateSettings toolSettings, string externalCa) : DockerSwarmUpdateSettings
- SetMaxSnapshots(this DockerSwarmUpdateSettings toolSettings, int? maxSnapshots) : DockerSwarmUpdateSettings
- SetSnapshotInterval(this DockerSwarmUpdateSettings toolSettings, int? snapshotInterval) : DockerSwarmUpdateSettings
- SetTaskHistoryLimit(this DockerSwarmUpdateSettings toolSettings, long? taskHistoryLimit) : DockerSwarmUpdateSettings
- ToggleAutolock(this DockerSwarmUpdateSettings toolSettings) : DockerSwarmUpdateSettings

### Nuke.Common.Tools.Docker.DockerSystemDfSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_ToolPath() : string
- get_Verbose() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSystemDfSettingsExtensions

- DisableVerbose(this DockerSystemDfSettings toolSettings) : DockerSystemDfSettings
- EnableVerbose(this DockerSystemDfSettings toolSettings) : DockerSystemDfSettings
- ResetFormat(this DockerSystemDfSettings toolSettings) : DockerSystemDfSettings
- ResetVerbose(this DockerSystemDfSettings toolSettings) : DockerSystemDfSettings
- SetFormat(this DockerSystemDfSettings toolSettings, string format) : DockerSystemDfSettings
- SetVerbose(this DockerSystemDfSettings toolSettings, bool? verbose) : DockerSystemDfSettings
- ToggleVerbose(this DockerSystemDfSettings toolSettings) : DockerSystemDfSettings

### Nuke.Common.Tools.Docker.DockerSystemEventsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Since() : string
- get_ToolPath() : string
- get_Until() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSystemEventsSettingsExtensions

- ResetFilter(this DockerSystemEventsSettings toolSettings) : DockerSystemEventsSettings
- ResetFormat(this DockerSystemEventsSettings toolSettings) : DockerSystemEventsSettings
- ResetSince(this DockerSystemEventsSettings toolSettings) : DockerSystemEventsSettings
- ResetUntil(this DockerSystemEventsSettings toolSettings) : DockerSystemEventsSettings
- SetFilter(this DockerSystemEventsSettings toolSettings, string filter) : DockerSystemEventsSettings
- SetFormat(this DockerSystemEventsSettings toolSettings, string format) : DockerSystemEventsSettings
- SetSince(this DockerSystemEventsSettings toolSettings, string since) : DockerSystemEventsSettings
- SetUntil(this DockerSystemEventsSettings toolSettings, string until) : DockerSystemEventsSettings

### Nuke.Common.Tools.Docker.DockerSystemInfoSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSystemInfoSettingsExtensions

- ResetFormat(this DockerSystemInfoSettings toolSettings) : DockerSystemInfoSettings
- SetFormat(this DockerSystemInfoSettings toolSettings, string format) : DockerSystemInfoSettings

### Nuke.Common.Tools.Docker.DockerSystemPruneSettings

- .ctor()
- get_All() : bool?
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Force() : bool?
- get_ToolPath() : string
- get_Volumes() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSystemPruneSettingsExtensions

- DisableAll(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- DisableForce(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- DisableVolumes(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- EnableAll(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- EnableForce(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- EnableVolumes(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ResetAll(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ResetFilter(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ResetForce(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ResetVolumes(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- SetAll(this DockerSystemPruneSettings toolSettings, bool? all) : DockerSystemPruneSettings
- SetFilter(this DockerSystemPruneSettings toolSettings, string filter) : DockerSystemPruneSettings
- SetForce(this DockerSystemPruneSettings toolSettings, bool? force) : DockerSystemPruneSettings
- SetVolumes(this DockerSystemPruneSettings toolSettings, bool? volumes) : DockerSystemPruneSettings
- ToggleAll(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ToggleForce(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings
- ToggleVolumes(this DockerSystemPruneSettings toolSettings) : DockerSystemPruneSettings

### Nuke.Common.Tools.Docker.DockerSystemSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerSystemSettingsExtensions


### Nuke.Common.Tools.Docker.DockerTagSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_SourceImage() : string
- get_TargetImage() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTagSettingsExtensions

- ResetSourceImage(this DockerTagSettings toolSettings) : DockerTagSettings
- ResetTargetImage(this DockerTagSettings toolSettings) : DockerTagSettings
- SetSourceImage(this DockerTagSettings toolSettings, string sourceImage) : DockerTagSettings
- SetTargetImage(this DockerTagSettings toolSettings, string targetImage) : DockerTagSettings

### Nuke.Common.Tools.Docker.DockerTasks

- get_DockerLogger() : Action<OutputType, string>
- get_DockerPath() : string
- set_DockerLogger(Action<OutputType, string> value) : void
- Docker(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- DockerAttach(DockerAttachSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerAttach(Configure<DockerAttachSettings> configurator) : IReadOnlyCollection<Output>
- DockerAttach(CombinatorialConfigure<DockerAttachSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerAttachSettings, Output IReadOnlyCollection<Output>)>
- DockerBuild(DockerBuildSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerBuild(Configure<DockerBuildSettings> configurator) : IReadOnlyCollection<Output>
- DockerBuild(CombinatorialConfigure<DockerBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerBuildSettings, Output IReadOnlyCollection<Output>)>
- DockerBuilder(DockerBuilderSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerBuilder(Configure<DockerBuilderSettings> configurator) : IReadOnlyCollection<Output>
- DockerBuilder(CombinatorialConfigure<DockerBuilderSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerBuilderSettings, Output IReadOnlyCollection<Output>)>
- DockerBuilderBuild(DockerBuilderBuildSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerBuilderBuild(Configure<DockerBuilderBuildSettings> configurator) : IReadOnlyCollection<Output>
- DockerBuilderBuild(CombinatorialConfigure<DockerBuilderBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerBuilderBuildSettings, Output IReadOnlyCollection<Output>)>
- DockerBuilderPrune(DockerBuilderPruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerBuilderPrune(Configure<DockerBuilderPruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerBuilderPrune(CombinatorialConfigure<DockerBuilderPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerBuilderPruneSettings, Output IReadOnlyCollection<Output>)>
- DockerCheckpoint(DockerCheckpointSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCheckpoint(Configure<DockerCheckpointSettings> configurator) : IReadOnlyCollection<Output>
- DockerCheckpoint(CombinatorialConfigure<DockerCheckpointSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCheckpointSettings, Output IReadOnlyCollection<Output>)>
- DockerCheckpointCreate(DockerCheckpointCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCheckpointCreate(Configure<DockerCheckpointCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerCheckpointCreate(CombinatorialConfigure<DockerCheckpointCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCheckpointCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerCheckpointLs(DockerCheckpointLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCheckpointLs(Configure<DockerCheckpointLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerCheckpointLs(CombinatorialConfigure<DockerCheckpointLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCheckpointLsSettings, Output IReadOnlyCollection<Output>)>
- DockerCheckpointRm(DockerCheckpointRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCheckpointRm(Configure<DockerCheckpointRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerCheckpointRm(CombinatorialConfigure<DockerCheckpointRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCheckpointRmSettings, Output IReadOnlyCollection<Output>)>
- DockerCommit(DockerCommitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCommit(Configure<DockerCommitSettings> configurator) : IReadOnlyCollection<Output>
- DockerCommit(CombinatorialConfigure<DockerCommitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCommitSettings, Output IReadOnlyCollection<Output>)>
- DockerConfig(DockerConfigSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerConfig(Configure<DockerConfigSettings> configurator) : IReadOnlyCollection<Output>
- DockerConfig(CombinatorialConfigure<DockerConfigSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerConfigSettings, Output IReadOnlyCollection<Output>)>
- DockerConfigCreate(DockerConfigCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerConfigCreate(Configure<DockerConfigCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerConfigCreate(CombinatorialConfigure<DockerConfigCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerConfigCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerConfigInspect(DockerConfigInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerConfigInspect(Configure<DockerConfigInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerConfigInspect(CombinatorialConfigure<DockerConfigInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerConfigInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerConfigLs(DockerConfigLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerConfigLs(Configure<DockerConfigLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerConfigLs(CombinatorialConfigure<DockerConfigLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerConfigLsSettings, Output IReadOnlyCollection<Output>)>
- DockerConfigRm(DockerConfigRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerConfigRm(Configure<DockerConfigRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerConfigRm(CombinatorialConfigure<DockerConfigRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerConfigRmSettings, Output IReadOnlyCollection<Output>)>
- DockerContainer(DockerContainerSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainer(Configure<DockerContainerSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainer(CombinatorialConfigure<DockerContainerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerAttach(DockerContainerAttachSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerAttach(Configure<DockerContainerAttachSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerAttach(CombinatorialConfigure<DockerContainerAttachSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerAttachSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerCommit(DockerContainerCommitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerCommit(Configure<DockerContainerCommitSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerCommit(CombinatorialConfigure<DockerContainerCommitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerCommitSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerCreate(DockerContainerCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerCreate(Configure<DockerContainerCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerCreate(CombinatorialConfigure<DockerContainerCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerDiff(DockerContainerDiffSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerDiff(Configure<DockerContainerDiffSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerDiff(CombinatorialConfigure<DockerContainerDiffSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerDiffSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerExec(DockerContainerExecSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerExec(Configure<DockerContainerExecSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerExec(CombinatorialConfigure<DockerContainerExecSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerExecSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerExport(DockerContainerExportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerExport(Configure<DockerContainerExportSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerExport(CombinatorialConfigure<DockerContainerExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerExportSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerInspect(DockerContainerInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerInspect(Configure<DockerContainerInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerInspect(CombinatorialConfigure<DockerContainerInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerKill(DockerContainerKillSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerKill(Configure<DockerContainerKillSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerKill(CombinatorialConfigure<DockerContainerKillSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerKillSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerLogs(DockerContainerLogsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerLogs(Configure<DockerContainerLogsSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerLogs(CombinatorialConfigure<DockerContainerLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerLogsSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerLs(DockerContainerLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerLs(Configure<DockerContainerLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerLs(CombinatorialConfigure<DockerContainerLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerLsSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerPause(DockerContainerPauseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerPause(Configure<DockerContainerPauseSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerPause(CombinatorialConfigure<DockerContainerPauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerPauseSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerPort(DockerContainerPortSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerPort(Configure<DockerContainerPortSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerPort(CombinatorialConfigure<DockerContainerPortSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerPortSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerPrune(DockerContainerPruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerPrune(Configure<DockerContainerPruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerPrune(CombinatorialConfigure<DockerContainerPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerPruneSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerRename(Configure<DockerContainerRenameSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerRename(CombinatorialConfigure<DockerContainerRenameSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerRenameSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerRename(DockerContainerRenameSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerRestart(DockerContainerRestartSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerRestart(Configure<DockerContainerRestartSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerRestart(CombinatorialConfigure<DockerContainerRestartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerRestartSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerRm(DockerContainerRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerRm(Configure<DockerContainerRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerRm(CombinatorialConfigure<DockerContainerRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerRmSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerRun(DockerContainerRunSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerRun(Configure<DockerContainerRunSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerRun(CombinatorialConfigure<DockerContainerRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerRunSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerStart(DockerContainerStartSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerStart(Configure<DockerContainerStartSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerStart(CombinatorialConfigure<DockerContainerStartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerStartSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerStats(DockerContainerStatsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerStats(Configure<DockerContainerStatsSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerStats(CombinatorialConfigure<DockerContainerStatsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerStatsSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerStop(DockerContainerStopSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerStop(Configure<DockerContainerStopSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerStop(CombinatorialConfigure<DockerContainerStopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerStopSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerTop(DockerContainerTopSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerTop(Configure<DockerContainerTopSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerTop(CombinatorialConfigure<DockerContainerTopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerTopSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerUnpause(DockerContainerUnpauseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerUnpause(Configure<DockerContainerUnpauseSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerUnpause(CombinatorialConfigure<DockerContainerUnpauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerUnpauseSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerUpdate(DockerContainerUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerUpdate(Configure<DockerContainerUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerContainerUpdate(CombinatorialConfigure<DockerContainerUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerWait(CombinatorialConfigure<DockerContainerWaitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContainerWaitSettings, Output IReadOnlyCollection<Output>)>
- DockerContainerWait(DockerContainerWaitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContainerWait(Configure<DockerContainerWaitSettings> configurator) : IReadOnlyCollection<Output>
- DockerContext(DockerContextSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContext(Configure<DockerContextSettings> configurator) : IReadOnlyCollection<Output>
- DockerContext(CombinatorialConfigure<DockerContextSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextSettings, Output IReadOnlyCollection<Output>)>
- DockerContextCreate(DockerContextCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextCreate(Configure<DockerContextCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextCreate(CombinatorialConfigure<DockerContextCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerContextExport(DockerContextExportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextExport(Configure<DockerContextExportSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextExport(CombinatorialConfigure<DockerContextExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextExportSettings, Output IReadOnlyCollection<Output>)>
- DockerContextImport(DockerContextImportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextImport(Configure<DockerContextImportSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextImport(CombinatorialConfigure<DockerContextImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextImportSettings, Output IReadOnlyCollection<Output>)>
- DockerContextInspect(DockerContextInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextInspect(Configure<DockerContextInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextInspect(CombinatorialConfigure<DockerContextInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerContextLs(DockerContextLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextLs(Configure<DockerContextLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextLs(CombinatorialConfigure<DockerContextLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextLsSettings, Output IReadOnlyCollection<Output>)>
- DockerContextRm(DockerContextRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextRm(Configure<DockerContextRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextRm(CombinatorialConfigure<DockerContextRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextRmSettings, Output IReadOnlyCollection<Output>)>
- DockerContextUpdate(DockerContextUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextUpdate(Configure<DockerContextUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextUpdate(CombinatorialConfigure<DockerContextUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerContextUse(DockerContextUseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerContextUse(Configure<DockerContextUseSettings> configurator) : IReadOnlyCollection<Output>
- DockerContextUse(CombinatorialConfigure<DockerContextUseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerContextUseSettings, Output IReadOnlyCollection<Output>)>
- DockerCreate(DockerCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerCreate(Configure<DockerCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerCreate(CombinatorialConfigure<DockerCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerDeploy(DockerDeploySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerDeploy(Configure<DockerDeploySettings> configurator) : IReadOnlyCollection<Output>
- DockerDeploy(CombinatorialConfigure<DockerDeploySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerDeploySettings, Output IReadOnlyCollection<Output>)>
- DockerDiff(DockerDiffSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerDiff(Configure<DockerDiffSettings> configurator) : IReadOnlyCollection<Output>
- DockerDiff(CombinatorialConfigure<DockerDiffSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerDiffSettings, Output IReadOnlyCollection<Output>)>
- DockerEngine(DockerEngineSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerEngine(Configure<DockerEngineSettings> configurator) : IReadOnlyCollection<Output>
- DockerEngine(CombinatorialConfigure<DockerEngineSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerEngineSettings, Output IReadOnlyCollection<Output>)>
- DockerEngineActivate(DockerEngineActivateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerEngineActivate(Configure<DockerEngineActivateSettings> configurator) : IReadOnlyCollection<Output>
- DockerEngineActivate(CombinatorialConfigure<DockerEngineActivateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerEngineActivateSettings, Output IReadOnlyCollection<Output>)>
- DockerEngineCheck(DockerEngineCheckSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerEngineCheck(Configure<DockerEngineCheckSettings> configurator) : IReadOnlyCollection<Output>
- DockerEngineCheck(CombinatorialConfigure<DockerEngineCheckSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerEngineCheckSettings, Output IReadOnlyCollection<Output>)>
- DockerEngineUpdate(DockerEngineUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerEngineUpdate(Configure<DockerEngineUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerEngineUpdate(CombinatorialConfigure<DockerEngineUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerEngineUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerEvents(DockerEventsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerEvents(Configure<DockerEventsSettings> configurator) : IReadOnlyCollection<Output>
- DockerEvents(CombinatorialConfigure<DockerEventsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerEventsSettings, Output IReadOnlyCollection<Output>)>
- DockerExec(DockerExecSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerExec(Configure<DockerExecSettings> configurator) : IReadOnlyCollection<Output>
- DockerExec(CombinatorialConfigure<DockerExecSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerExecSettings, Output IReadOnlyCollection<Output>)>
- DockerExport(DockerExportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerExport(Configure<DockerExportSettings> configurator) : IReadOnlyCollection<Output>
- DockerExport(CombinatorialConfigure<DockerExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerExportSettings, Output IReadOnlyCollection<Output>)>
- DockerHistory(DockerHistorySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerHistory(Configure<DockerHistorySettings> configurator) : IReadOnlyCollection<Output>
- DockerHistory(CombinatorialConfigure<DockerHistorySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerHistorySettings, Output IReadOnlyCollection<Output>)>
- DockerImage(DockerImageSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImage(Configure<DockerImageSettings> configurator) : IReadOnlyCollection<Output>
- DockerImage(CombinatorialConfigure<DockerImageSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageSettings, Output IReadOnlyCollection<Output>)>
- DockerImageBuild(DockerImageBuildSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageBuild(Configure<DockerImageBuildSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageBuild(CombinatorialConfigure<DockerImageBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageBuildSettings, Output IReadOnlyCollection<Output>)>
- DockerImageHistory(DockerImageHistorySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageHistory(Configure<DockerImageHistorySettings> configurator) : IReadOnlyCollection<Output>
- DockerImageHistory(CombinatorialConfigure<DockerImageHistorySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageHistorySettings, Output IReadOnlyCollection<Output>)>
- DockerImageImport(DockerImageImportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageImport(Configure<DockerImageImportSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageImport(CombinatorialConfigure<DockerImageImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageImportSettings, Output IReadOnlyCollection<Output>)>
- DockerImageInspect(DockerImageInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageInspect(Configure<DockerImageInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageInspect(CombinatorialConfigure<DockerImageInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerImageLoad(DockerImageLoadSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageLoad(Configure<DockerImageLoadSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageLoad(CombinatorialConfigure<DockerImageLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageLoadSettings, Output IReadOnlyCollection<Output>)>
- DockerImageLs(DockerImageLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageLs(Configure<DockerImageLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageLs(CombinatorialConfigure<DockerImageLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageLsSettings, Output IReadOnlyCollection<Output>)>
- DockerImagePrune(DockerImagePruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImagePrune(Configure<DockerImagePruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerImagePrune(CombinatorialConfigure<DockerImagePruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImagePruneSettings, Output IReadOnlyCollection<Output>)>
- DockerImagePull(DockerImagePullSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImagePull(Configure<DockerImagePullSettings> configurator) : IReadOnlyCollection<Output>
- DockerImagePull(CombinatorialConfigure<DockerImagePullSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImagePullSettings, Output IReadOnlyCollection<Output>)>
- DockerImagePush(DockerImagePushSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImagePush(Configure<DockerImagePushSettings> configurator) : IReadOnlyCollection<Output>
- DockerImagePush(CombinatorialConfigure<DockerImagePushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImagePushSettings, Output IReadOnlyCollection<Output>)>
- DockerImageRm(DockerImageRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageRm(Configure<DockerImageRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageRm(CombinatorialConfigure<DockerImageRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageRmSettings, Output IReadOnlyCollection<Output>)>
- DockerImages(DockerImagesSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImages(Configure<DockerImagesSettings> configurator) : IReadOnlyCollection<Output>
- DockerImages(CombinatorialConfigure<DockerImagesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImagesSettings, Output IReadOnlyCollection<Output>)>
- DockerImageSave(DockerImageSaveSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageSave(Configure<DockerImageSaveSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageSave(CombinatorialConfigure<DockerImageSaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageSaveSettings, Output IReadOnlyCollection<Output>)>
- DockerImageTag(DockerImageTagSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImageTag(Configure<DockerImageTagSettings> configurator) : IReadOnlyCollection<Output>
- DockerImageTag(CombinatorialConfigure<DockerImageTagSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImageTagSettings, Output IReadOnlyCollection<Output>)>
- DockerImport(DockerImportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerImport(Configure<DockerImportSettings> configurator) : IReadOnlyCollection<Output>
- DockerImport(CombinatorialConfigure<DockerImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerImportSettings, Output IReadOnlyCollection<Output>)>
- DockerInfo(DockerInfoSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerInfo(Configure<DockerInfoSettings> configurator) : IReadOnlyCollection<Output>
- DockerInfo(CombinatorialConfigure<DockerInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerInfoSettings, Output IReadOnlyCollection<Output>)>
- DockerInspect(DockerInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerInspect(Configure<DockerInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerInspect(CombinatorialConfigure<DockerInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerKill(DockerKillSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerKill(Configure<DockerKillSettings> configurator) : IReadOnlyCollection<Output>
- DockerKill(CombinatorialConfigure<DockerKillSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerKillSettings, Output IReadOnlyCollection<Output>)>
- DockerLoad(DockerLoadSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerLoad(Configure<DockerLoadSettings> configurator) : IReadOnlyCollection<Output>
- DockerLoad(CombinatorialConfigure<DockerLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerLoadSettings, Output IReadOnlyCollection<Output>)>
- DockerLogin(DockerLoginSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerLogin(Configure<DockerLoginSettings> configurator) : IReadOnlyCollection<Output>
- DockerLogin(CombinatorialConfigure<DockerLoginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerLoginSettings, Output IReadOnlyCollection<Output>)>
- DockerLogout(DockerLogoutSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerLogout(Configure<DockerLogoutSettings> configurator) : IReadOnlyCollection<Output>
- DockerLogout(CombinatorialConfigure<DockerLogoutSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerLogoutSettings, Output IReadOnlyCollection<Output>)>
- DockerLogs(DockerLogsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerLogs(Configure<DockerLogsSettings> configurator) : IReadOnlyCollection<Output>
- DockerLogs(CombinatorialConfigure<DockerLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerLogsSettings, Output IReadOnlyCollection<Output>)>
- DockerManifest(DockerManifestSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerManifest(Configure<DockerManifestSettings> configurator) : IReadOnlyCollection<Output>
- DockerManifest(CombinatorialConfigure<DockerManifestSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerManifestSettings, Output IReadOnlyCollection<Output>)>
- DockerManifestAnnotate(DockerManifestAnnotateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerManifestAnnotate(Configure<DockerManifestAnnotateSettings> configurator) : IReadOnlyCollection<Output>
- DockerManifestAnnotate(CombinatorialConfigure<DockerManifestAnnotateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerManifestAnnotateSettings, Output IReadOnlyCollection<Output>)>
- DockerManifestCreate(DockerManifestCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerManifestCreate(Configure<DockerManifestCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerManifestCreate(CombinatorialConfigure<DockerManifestCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerManifestCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerManifestInspect(DockerManifestInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerManifestInspect(Configure<DockerManifestInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerManifestInspect(CombinatorialConfigure<DockerManifestInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerManifestInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerManifestPush(DockerManifestPushSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerManifestPush(Configure<DockerManifestPushSettings> configurator) : IReadOnlyCollection<Output>
- DockerManifestPush(CombinatorialConfigure<DockerManifestPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerManifestPushSettings, Output IReadOnlyCollection<Output>)>
- DockerNetwork(DockerNetworkSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetwork(Configure<DockerNetworkSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetwork(CombinatorialConfigure<DockerNetworkSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkConnect(DockerNetworkConnectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkConnect(Configure<DockerNetworkConnectSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkConnect(CombinatorialConfigure<DockerNetworkConnectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkConnectSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkCreate(DockerNetworkCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkCreate(Configure<DockerNetworkCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkCreate(CombinatorialConfigure<DockerNetworkCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkDisconnect(DockerNetworkDisconnectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkDisconnect(Configure<DockerNetworkDisconnectSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkDisconnect(CombinatorialConfigure<DockerNetworkDisconnectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkDisconnectSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkInspect(DockerNetworkInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkInspect(Configure<DockerNetworkInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkInspect(CombinatorialConfigure<DockerNetworkInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkLs(DockerNetworkLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkLs(Configure<DockerNetworkLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkLs(CombinatorialConfigure<DockerNetworkLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkLsSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkPrune(DockerNetworkPruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkPrune(Configure<DockerNetworkPruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkPrune(CombinatorialConfigure<DockerNetworkPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkPruneSettings, Output IReadOnlyCollection<Output>)>
- DockerNetworkRm(DockerNetworkRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNetworkRm(Configure<DockerNetworkRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerNetworkRm(CombinatorialConfigure<DockerNetworkRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNetworkRmSettings, Output IReadOnlyCollection<Output>)>
- DockerNode(DockerNodeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNode(Configure<DockerNodeSettings> configurator) : IReadOnlyCollection<Output>
- DockerNode(CombinatorialConfigure<DockerNodeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeSettings, Output IReadOnlyCollection<Output>)>
- DockerNodeDemote(DockerNodeDemoteSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodeDemote(Configure<DockerNodeDemoteSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodeDemote(CombinatorialConfigure<DockerNodeDemoteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeDemoteSettings, Output IReadOnlyCollection<Output>)>
- DockerNodeInspect(DockerNodeInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodeInspect(Configure<DockerNodeInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodeInspect(CombinatorialConfigure<DockerNodeInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerNodeLs(DockerNodeLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodeLs(Configure<DockerNodeLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodeLs(CombinatorialConfigure<DockerNodeLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeLsSettings, Output IReadOnlyCollection<Output>)>
- DockerNodePromote(CombinatorialConfigure<DockerNodePromoteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodePromoteSettings, Output IReadOnlyCollection<Output>)>
- DockerNodePromote(DockerNodePromoteSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodePromote(Configure<DockerNodePromoteSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodePs(DockerNodePsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodePs(Configure<DockerNodePsSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodePs(CombinatorialConfigure<DockerNodePsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodePsSettings, Output IReadOnlyCollection<Output>)>
- DockerNodeRm(DockerNodeRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodeRm(Configure<DockerNodeRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodeRm(CombinatorialConfigure<DockerNodeRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeRmSettings, Output IReadOnlyCollection<Output>)>
- DockerNodeUpdate(DockerNodeUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerNodeUpdate(Configure<DockerNodeUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerNodeUpdate(CombinatorialConfigure<DockerNodeUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerNodeUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerPause(DockerPauseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPause(Configure<DockerPauseSettings> configurator) : IReadOnlyCollection<Output>
- DockerPause(CombinatorialConfigure<DockerPauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPauseSettings, Output IReadOnlyCollection<Output>)>
- DockerPlugin(DockerPluginSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPlugin(Configure<DockerPluginSettings> configurator) : IReadOnlyCollection<Output>
- DockerPlugin(CombinatorialConfigure<DockerPluginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginCreate(DockerPluginCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginCreate(Configure<DockerPluginCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginCreate(CombinatorialConfigure<DockerPluginCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginDisable(DockerPluginDisableSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginDisable(Configure<DockerPluginDisableSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginDisable(CombinatorialConfigure<DockerPluginDisableSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginDisableSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginEnable(DockerPluginEnableSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginEnable(Configure<DockerPluginEnableSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginEnable(CombinatorialConfigure<DockerPluginEnableSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginEnableSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginInspect(DockerPluginInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginInspect(Configure<DockerPluginInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginInspect(CombinatorialConfigure<DockerPluginInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginInstall(DockerPluginInstallSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginInstall(Configure<DockerPluginInstallSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginInstall(CombinatorialConfigure<DockerPluginInstallSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginInstallSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginLs(DockerPluginLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginLs(Configure<DockerPluginLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginLs(CombinatorialConfigure<DockerPluginLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginLsSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginPush(DockerPluginPushSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginPush(Configure<DockerPluginPushSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginPush(CombinatorialConfigure<DockerPluginPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginPushSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginRm(DockerPluginRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginRm(Configure<DockerPluginRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginRm(CombinatorialConfigure<DockerPluginRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginRmSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginSet(DockerPluginSetSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginSet(Configure<DockerPluginSetSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginSet(CombinatorialConfigure<DockerPluginSetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginSetSettings, Output IReadOnlyCollection<Output>)>
- DockerPluginUpgrade(DockerPluginUpgradeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPluginUpgrade(Configure<DockerPluginUpgradeSettings> configurator) : IReadOnlyCollection<Output>
- DockerPluginUpgrade(CombinatorialConfigure<DockerPluginUpgradeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPluginUpgradeSettings, Output IReadOnlyCollection<Output>)>
- DockerPort(DockerPortSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPort(Configure<DockerPortSettings> configurator) : IReadOnlyCollection<Output>
- DockerPort(CombinatorialConfigure<DockerPortSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPortSettings, Output IReadOnlyCollection<Output>)>
- DockerPs(DockerPsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPs(Configure<DockerPsSettings> configurator) : IReadOnlyCollection<Output>
- DockerPs(CombinatorialConfigure<DockerPsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPsSettings, Output IReadOnlyCollection<Output>)>
- DockerPull(DockerPullSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPull(Configure<DockerPullSettings> configurator) : IReadOnlyCollection<Output>
- DockerPull(CombinatorialConfigure<DockerPullSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPullSettings, Output IReadOnlyCollection<Output>)>
- DockerPush(DockerPushSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerPush(Configure<DockerPushSettings> configurator) : IReadOnlyCollection<Output>
- DockerPush(CombinatorialConfigure<DockerPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerPushSettings, Output IReadOnlyCollection<Output>)>
- DockerRename(DockerRenameSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerRename(Configure<DockerRenameSettings> configurator) : IReadOnlyCollection<Output>
- DockerRename(CombinatorialConfigure<DockerRenameSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerRenameSettings, Output IReadOnlyCollection<Output>)>
- DockerRestart(DockerRestartSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerRestart(Configure<DockerRestartSettings> configurator) : IReadOnlyCollection<Output>
- DockerRestart(CombinatorialConfigure<DockerRestartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerRestartSettings, Output IReadOnlyCollection<Output>)>
- DockerRm(DockerRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerRm(Configure<DockerRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerRm(CombinatorialConfigure<DockerRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerRmSettings, Output IReadOnlyCollection<Output>)>
- DockerRmi(DockerRmiSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerRmi(Configure<DockerRmiSettings> configurator) : IReadOnlyCollection<Output>
- DockerRmi(CombinatorialConfigure<DockerRmiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerRmiSettings, Output IReadOnlyCollection<Output>)>
- DockerRun(DockerRunSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerRun(Configure<DockerRunSettings> configurator) : IReadOnlyCollection<Output>
- DockerRun(CombinatorialConfigure<DockerRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerRunSettings, Output IReadOnlyCollection<Output>)>
- DockerSave(DockerSaveSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSave(Configure<DockerSaveSettings> configurator) : IReadOnlyCollection<Output>
- DockerSave(CombinatorialConfigure<DockerSaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSaveSettings, Output IReadOnlyCollection<Output>)>
- DockerSearch(DockerSearchSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSearch(Configure<DockerSearchSettings> configurator) : IReadOnlyCollection<Output>
- DockerSearch(CombinatorialConfigure<DockerSearchSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSearchSettings, Output IReadOnlyCollection<Output>)>
- DockerSecret(DockerSecretSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSecret(Configure<DockerSecretSettings> configurator) : IReadOnlyCollection<Output>
- DockerSecret(CombinatorialConfigure<DockerSecretSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSecretSettings, Output IReadOnlyCollection<Output>)>
- DockerSecretCreate(DockerSecretCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSecretCreate(Configure<DockerSecretCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerSecretCreate(CombinatorialConfigure<DockerSecretCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSecretCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerSecretInspect(DockerSecretInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSecretInspect(Configure<DockerSecretInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerSecretInspect(CombinatorialConfigure<DockerSecretInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSecretInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerSecretLs(DockerSecretLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSecretLs(Configure<DockerSecretLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerSecretLs(CombinatorialConfigure<DockerSecretLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSecretLsSettings, Output IReadOnlyCollection<Output>)>
- DockerSecretRm(DockerSecretRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSecretRm(Configure<DockerSecretRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerSecretRm(CombinatorialConfigure<DockerSecretRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSecretRmSettings, Output IReadOnlyCollection<Output>)>
- DockerService(DockerServiceSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerService(Configure<DockerServiceSettings> configurator) : IReadOnlyCollection<Output>
- DockerService(CombinatorialConfigure<DockerServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceCreate(DockerServiceCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceCreate(Configure<DockerServiceCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceCreate(CombinatorialConfigure<DockerServiceCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceInspect(DockerServiceInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceInspect(Configure<DockerServiceInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceInspect(CombinatorialConfigure<DockerServiceInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceLogs(DockerServiceLogsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceLogs(Configure<DockerServiceLogsSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceLogs(CombinatorialConfigure<DockerServiceLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceLogsSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceLs(DockerServiceLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceLs(Configure<DockerServiceLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceLs(CombinatorialConfigure<DockerServiceLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceLsSettings, Output IReadOnlyCollection<Output>)>
- DockerServicePs(DockerServicePsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServicePs(Configure<DockerServicePsSettings> configurator) : IReadOnlyCollection<Output>
- DockerServicePs(CombinatorialConfigure<DockerServicePsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServicePsSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceRm(DockerServiceRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceRm(Configure<DockerServiceRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceRm(CombinatorialConfigure<DockerServiceRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceRmSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceRollback(DockerServiceRollbackSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceRollback(Configure<DockerServiceRollbackSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceRollback(CombinatorialConfigure<DockerServiceRollbackSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceRollbackSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceScale(DockerServiceScaleSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceScale(Configure<DockerServiceScaleSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceScale(CombinatorialConfigure<DockerServiceScaleSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceScaleSettings, Output IReadOnlyCollection<Output>)>
- DockerServiceUpdate(DockerServiceUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerServiceUpdate(Configure<DockerServiceUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerServiceUpdate(CombinatorialConfigure<DockerServiceUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerServiceUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerStack(DockerStackSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStack(Configure<DockerStackSettings> configurator) : IReadOnlyCollection<Output>
- DockerStack(CombinatorialConfigure<DockerStackSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackSettings, Output IReadOnlyCollection<Output>)>
- DockerStackDeploy(DockerStackDeploySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStackDeploy(Configure<DockerStackDeploySettings> configurator) : IReadOnlyCollection<Output>
- DockerStackDeploy(CombinatorialConfigure<DockerStackDeploySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackDeploySettings, Output IReadOnlyCollection<Output>)>
- DockerStackLs(DockerStackLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStackLs(Configure<DockerStackLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerStackLs(CombinatorialConfigure<DockerStackLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackLsSettings, Output IReadOnlyCollection<Output>)>
- DockerStackPs(DockerStackPsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStackPs(Configure<DockerStackPsSettings> configurator) : IReadOnlyCollection<Output>
- DockerStackPs(CombinatorialConfigure<DockerStackPsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackPsSettings, Output IReadOnlyCollection<Output>)>
- DockerStackRm(DockerStackRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStackRm(Configure<DockerStackRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerStackRm(CombinatorialConfigure<DockerStackRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackRmSettings, Output IReadOnlyCollection<Output>)>
- DockerStackServices(DockerStackServicesSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStackServices(Configure<DockerStackServicesSettings> configurator) : IReadOnlyCollection<Output>
- DockerStackServices(CombinatorialConfigure<DockerStackServicesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStackServicesSettings, Output IReadOnlyCollection<Output>)>
- DockerStart(DockerStartSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStart(Configure<DockerStartSettings> configurator) : IReadOnlyCollection<Output>
- DockerStart(CombinatorialConfigure<DockerStartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStartSettings, Output IReadOnlyCollection<Output>)>
- DockerStats(DockerStatsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStats(Configure<DockerStatsSettings> configurator) : IReadOnlyCollection<Output>
- DockerStats(CombinatorialConfigure<DockerStatsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStatsSettings, Output IReadOnlyCollection<Output>)>
- DockerStop(DockerStopSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerStop(Configure<DockerStopSettings> configurator) : IReadOnlyCollection<Output>
- DockerStop(CombinatorialConfigure<DockerStopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerStopSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarm(DockerSwarmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarm(Configure<DockerSwarmSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarm(CombinatorialConfigure<DockerSwarmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmCa(DockerSwarmCaSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmCa(Configure<DockerSwarmCaSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmCa(CombinatorialConfigure<DockerSwarmCaSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmCaSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmInit(DockerSwarmInitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmInit(Configure<DockerSwarmInitSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmInit(CombinatorialConfigure<DockerSwarmInitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmInitSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmJoin(DockerSwarmJoinSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmJoin(Configure<DockerSwarmJoinSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmJoin(CombinatorialConfigure<DockerSwarmJoinSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmJoinSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmJoinToken(DockerSwarmJoinTokenSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmJoinToken(Configure<DockerSwarmJoinTokenSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmJoinToken(CombinatorialConfigure<DockerSwarmJoinTokenSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmJoinTokenSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmLeave(DockerSwarmLeaveSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmLeave(Configure<DockerSwarmLeaveSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmLeave(CombinatorialConfigure<DockerSwarmLeaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmLeaveSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmUnlock(DockerSwarmUnlockSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmUnlock(Configure<DockerSwarmUnlockSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmUnlock(CombinatorialConfigure<DockerSwarmUnlockSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmUnlockSettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmUnlockKey(DockerSwarmUnlockKeySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmUnlockKey(Configure<DockerSwarmUnlockKeySettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmUnlockKey(CombinatorialConfigure<DockerSwarmUnlockKeySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmUnlockKeySettings, Output IReadOnlyCollection<Output>)>
- DockerSwarmUpdate(DockerSwarmUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSwarmUpdate(Configure<DockerSwarmUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerSwarmUpdate(CombinatorialConfigure<DockerSwarmUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSwarmUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerSystem(DockerSystemSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSystem(Configure<DockerSystemSettings> configurator) : IReadOnlyCollection<Output>
- DockerSystem(CombinatorialConfigure<DockerSystemSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSystemSettings, Output IReadOnlyCollection<Output>)>
- DockerSystemDf(DockerSystemDfSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSystemDf(Configure<DockerSystemDfSettings> configurator) : IReadOnlyCollection<Output>
- DockerSystemDf(CombinatorialConfigure<DockerSystemDfSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSystemDfSettings, Output IReadOnlyCollection<Output>)>
- DockerSystemEvents(DockerSystemEventsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSystemEvents(Configure<DockerSystemEventsSettings> configurator) : IReadOnlyCollection<Output>
- DockerSystemEvents(CombinatorialConfigure<DockerSystemEventsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSystemEventsSettings, Output IReadOnlyCollection<Output>)>
- DockerSystemInfo(DockerSystemInfoSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSystemInfo(Configure<DockerSystemInfoSettings> configurator) : IReadOnlyCollection<Output>
- DockerSystemInfo(CombinatorialConfigure<DockerSystemInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSystemInfoSettings, Output IReadOnlyCollection<Output>)>
- DockerSystemPrune(DockerSystemPruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerSystemPrune(Configure<DockerSystemPruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerSystemPrune(CombinatorialConfigure<DockerSystemPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerSystemPruneSettings, Output IReadOnlyCollection<Output>)>
- DockerTag(DockerTagSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTag(Configure<DockerTagSettings> configurator) : IReadOnlyCollection<Output>
- DockerTag(CombinatorialConfigure<DockerTagSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTagSettings, Output IReadOnlyCollection<Output>)>
- DockerTop(DockerTopSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTop(Configure<DockerTopSettings> configurator) : IReadOnlyCollection<Output>
- DockerTop(CombinatorialConfigure<DockerTopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTopSettings, Output IReadOnlyCollection<Output>)>
- DockerTrust(DockerTrustSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrust(Configure<DockerTrustSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrust(CombinatorialConfigure<DockerTrustSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustInspect(DockerTrustInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustInspect(Configure<DockerTrustInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustInspect(CombinatorialConfigure<DockerTrustInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustKey(Configure<DockerTrustKeySettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustKey(CombinatorialConfigure<DockerTrustKeySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustKeySettings, Output IReadOnlyCollection<Output>)>
- DockerTrustKey(DockerTrustKeySettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustKeyGenerate(DockerTrustKeyGenerateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustKeyGenerate(Configure<DockerTrustKeyGenerateSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustKeyGenerate(CombinatorialConfigure<DockerTrustKeyGenerateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustKeyGenerateSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustKeyLoad(DockerTrustKeyLoadSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustKeyLoad(Configure<DockerTrustKeyLoadSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustKeyLoad(CombinatorialConfigure<DockerTrustKeyLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustKeyLoadSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustRevoke(DockerTrustRevokeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustRevoke(Configure<DockerTrustRevokeSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustRevoke(CombinatorialConfigure<DockerTrustRevokeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustRevokeSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustSign(DockerTrustSignSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustSign(Configure<DockerTrustSignSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustSign(CombinatorialConfigure<DockerTrustSignSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustSignSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustSigner(DockerTrustSignerSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustSigner(Configure<DockerTrustSignerSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustSigner(CombinatorialConfigure<DockerTrustSignerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustSignerSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustSignerAdd(DockerTrustSignerAddSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustSignerAdd(Configure<DockerTrustSignerAddSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustSignerAdd(CombinatorialConfigure<DockerTrustSignerAddSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustSignerAddSettings, Output IReadOnlyCollection<Output>)>
- DockerTrustSignerRemove(DockerTrustSignerRemoveSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerTrustSignerRemove(Configure<DockerTrustSignerRemoveSettings> configurator) : IReadOnlyCollection<Output>
- DockerTrustSignerRemove(CombinatorialConfigure<DockerTrustSignerRemoveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerTrustSignerRemoveSettings, Output IReadOnlyCollection<Output>)>
- DockerUnpause(DockerUnpauseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerUnpause(Configure<DockerUnpauseSettings> configurator) : IReadOnlyCollection<Output>
- DockerUnpause(CombinatorialConfigure<DockerUnpauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerUnpauseSettings, Output IReadOnlyCollection<Output>)>
- DockerUpdate(DockerUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerUpdate(Configure<DockerUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DockerUpdate(CombinatorialConfigure<DockerUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerUpdateSettings, Output IReadOnlyCollection<Output>)>
- DockerVersion(DockerVersionSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVersion(Configure<DockerVersionSettings> configurator) : IReadOnlyCollection<Output>
- DockerVersion(CombinatorialConfigure<DockerVersionSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVersionSettings, Output IReadOnlyCollection<Output>)>
- DockerVolume(DockerVolumeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolume(Configure<DockerVolumeSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolume(CombinatorialConfigure<DockerVolumeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumeSettings, Output IReadOnlyCollection<Output>)>
- DockerVolumeCreate(DockerVolumeCreateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolumeCreate(Configure<DockerVolumeCreateSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolumeCreate(CombinatorialConfigure<DockerVolumeCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumeCreateSettings, Output IReadOnlyCollection<Output>)>
- DockerVolumeInspect(DockerVolumeInspectSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolumeInspect(Configure<DockerVolumeInspectSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolumeInspect(CombinatorialConfigure<DockerVolumeInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumeInspectSettings, Output IReadOnlyCollection<Output>)>
- DockerVolumeLs(DockerVolumeLsSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolumeLs(Configure<DockerVolumeLsSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolumeLs(CombinatorialConfigure<DockerVolumeLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumeLsSettings, Output IReadOnlyCollection<Output>)>
- DockerVolumePrune(DockerVolumePruneSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolumePrune(Configure<DockerVolumePruneSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolumePrune(CombinatorialConfigure<DockerVolumePruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumePruneSettings, Output IReadOnlyCollection<Output>)>
- DockerVolumeRm(DockerVolumeRmSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerVolumeRm(Configure<DockerVolumeRmSettings> configurator) : IReadOnlyCollection<Output>
- DockerVolumeRm(CombinatorialConfigure<DockerVolumeRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerVolumeRmSettings, Output IReadOnlyCollection<Output>)>
- DockerWait(DockerWaitSettings toolSettings = null) : IReadOnlyCollection<Output>
- DockerWait(Configure<DockerWaitSettings> configurator) : IReadOnlyCollection<Output>
- DockerWait(CombinatorialConfigure<DockerWaitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DockerWaitSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.Docker.DockerTopSettings

- .ctor()
- get_Container() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Options() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTopSettingsExtensions

- ResetContainer(this DockerTopSettings toolSettings) : DockerTopSettings
- ResetOptions(this DockerTopSettings toolSettings) : DockerTopSettings
- SetContainer(this DockerTopSettings toolSettings, string container) : DockerTopSettings
- SetOptions(this DockerTopSettings toolSettings, string options) : DockerTopSettings

### Nuke.Common.Tools.Docker.DockerTrustInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Images() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustInspectSettingsExtensions

- AddImages(this DockerTrustInspectSettings toolSettings, string[] images) : DockerTrustInspectSettings
- AddImages(this DockerTrustInspectSettings toolSettings, IEnumerable<string> images) : DockerTrustInspectSettings
- ClearImages(this DockerTrustInspectSettings toolSettings) : DockerTrustInspectSettings
- RemoveImages(this DockerTrustInspectSettings toolSettings, string[] images) : DockerTrustInspectSettings
- RemoveImages(this DockerTrustInspectSettings toolSettings, IEnumerable<string> images) : DockerTrustInspectSettings
- SetImages(this DockerTrustInspectSettings toolSettings, string[] images) : DockerTrustInspectSettings
- SetImages(this DockerTrustInspectSettings toolSettings, IEnumerable<string> images) : DockerTrustInspectSettings

### Nuke.Common.Tools.Docker.DockerTrustKeyGenerateSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Name() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustKeyGenerateSettingsExtensions

- ResetName(this DockerTrustKeyGenerateSettings toolSettings) : DockerTrustKeyGenerateSettings
- SetName(this DockerTrustKeyGenerateSettings toolSettings, string name) : DockerTrustKeyGenerateSettings

### Nuke.Common.Tools.Docker.DockerTrustKeyLoadSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Keyfile() : string
- get_Name() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustKeyLoadSettingsExtensions

- ResetKeyfile(this DockerTrustKeyLoadSettings toolSettings) : DockerTrustKeyLoadSettings
- ResetName(this DockerTrustKeyLoadSettings toolSettings) : DockerTrustKeyLoadSettings
- SetKeyfile(this DockerTrustKeyLoadSettings toolSettings, string keyfile) : DockerTrustKeyLoadSettings
- SetName(this DockerTrustKeyLoadSettings toolSettings, string name) : DockerTrustKeyLoadSettings

### Nuke.Common.Tools.Docker.DockerTrustKeySettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustKeySettingsExtensions


### Nuke.Common.Tools.Docker.DockerTrustRevokeSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Image() : string
- get_ToolPath() : string
- get_Yes() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustRevokeSettingsExtensions

- DisableYes(this DockerTrustRevokeSettings toolSettings) : DockerTrustRevokeSettings
- EnableYes(this DockerTrustRevokeSettings toolSettings) : DockerTrustRevokeSettings
- ResetImage(this DockerTrustRevokeSettings toolSettings) : DockerTrustRevokeSettings
- ResetYes(this DockerTrustRevokeSettings toolSettings) : DockerTrustRevokeSettings
- SetImage(this DockerTrustRevokeSettings toolSettings, string image) : DockerTrustRevokeSettings
- SetYes(this DockerTrustRevokeSettings toolSettings, bool? yes) : DockerTrustRevokeSettings
- ToggleYes(this DockerTrustRevokeSettings toolSettings) : DockerTrustRevokeSettings

### Nuke.Common.Tools.Docker.DockerTrustSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustSettingsExtensions


### Nuke.Common.Tools.Docker.DockerTrustSignerAddSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Name() : string
- get_Options() : string
- get_Repositories() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustSignerAddSettingsExtensions

- AddRepositories(this DockerTrustSignerAddSettings toolSettings, string[] repositories) : DockerTrustSignerAddSettings
- AddRepositories(this DockerTrustSignerAddSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerAddSettings
- ClearRepositories(this DockerTrustSignerAddSettings toolSettings) : DockerTrustSignerAddSettings
- RemoveRepositories(this DockerTrustSignerAddSettings toolSettings, string[] repositories) : DockerTrustSignerAddSettings
- RemoveRepositories(this DockerTrustSignerAddSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerAddSettings
- ResetName(this DockerTrustSignerAddSettings toolSettings) : DockerTrustSignerAddSettings
- ResetOptions(this DockerTrustSignerAddSettings toolSettings) : DockerTrustSignerAddSettings
- SetName(this DockerTrustSignerAddSettings toolSettings, string name) : DockerTrustSignerAddSettings
- SetOptions(this DockerTrustSignerAddSettings toolSettings, string options) : DockerTrustSignerAddSettings
- SetRepositories(this DockerTrustSignerAddSettings toolSettings, string[] repositories) : DockerTrustSignerAddSettings
- SetRepositories(this DockerTrustSignerAddSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerAddSettings

### Nuke.Common.Tools.Docker.DockerTrustSignerRemoveSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_Name() : string
- get_Repositories() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustSignerRemoveSettingsExtensions

- AddRepositories(this DockerTrustSignerRemoveSettings toolSettings, string[] repositories) : DockerTrustSignerRemoveSettings
- AddRepositories(this DockerTrustSignerRemoveSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerRemoveSettings
- ClearRepositories(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings
- DisableForce(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings
- EnableForce(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings
- RemoveRepositories(this DockerTrustSignerRemoveSettings toolSettings, string[] repositories) : DockerTrustSignerRemoveSettings
- RemoveRepositories(this DockerTrustSignerRemoveSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerRemoveSettings
- ResetForce(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings
- ResetName(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings
- SetForce(this DockerTrustSignerRemoveSettings toolSettings, bool? force) : DockerTrustSignerRemoveSettings
- SetName(this DockerTrustSignerRemoveSettings toolSettings, string name) : DockerTrustSignerRemoveSettings
- SetRepositories(this DockerTrustSignerRemoveSettings toolSettings, string[] repositories) : DockerTrustSignerRemoveSettings
- SetRepositories(this DockerTrustSignerRemoveSettings toolSettings, IEnumerable<string> repositories) : DockerTrustSignerRemoveSettings
- ToggleForce(this DockerTrustSignerRemoveSettings toolSettings) : DockerTrustSignerRemoveSettings

### Nuke.Common.Tools.Docker.DockerTrustSignerSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustSignerSettingsExtensions


### Nuke.Common.Tools.Docker.DockerTrustSignSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerTrustSignSettingsExtensions


### Nuke.Common.Tools.Docker.DockerUnpauseSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerUnpauseSettingsExtensions

- AddContainers(this DockerUnpauseSettings toolSettings, string[] containers) : DockerUnpauseSettings
- AddContainers(this DockerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerUnpauseSettings
- ClearContainers(this DockerUnpauseSettings toolSettings) : DockerUnpauseSettings
- RemoveContainers(this DockerUnpauseSettings toolSettings, string[] containers) : DockerUnpauseSettings
- RemoveContainers(this DockerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerUnpauseSettings
- SetContainers(this DockerUnpauseSettings toolSettings, string[] containers) : DockerUnpauseSettings
- SetContainers(this DockerUnpauseSettings toolSettings, IEnumerable<string> containers) : DockerUnpauseSettings

### Nuke.Common.Tools.Docker.DockerUpdateSettings

- .ctor()
- get_BlkioWeight() : int?
- get_Containers() : IReadOnlyList<string>
- get_CpuPeriod() : long?
- get_CpuQuota() : long?
- get_CpuRtPeriod() : long?
- get_CpuRtRuntime() : long?
- get_Cpus() : decimal?
- get_CpusetCpus() : string
- get_CpusetMems() : string
- get_CpuShares() : long?
- get_CustomLogger() : Action<OutputType, string>
- get_KernelMemory() : long?
- get_Memory() : long?
- get_MemoryReservation() : long?
- get_MemorySwap() : long?
- get_PidsLimit() : long?
- get_Restart() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerUpdateSettingsExtensions

- AddContainers(this DockerUpdateSettings toolSettings, string[] containers) : DockerUpdateSettings
- AddContainers(this DockerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerUpdateSettings
- ClearContainers(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- RemoveContainers(this DockerUpdateSettings toolSettings, string[] containers) : DockerUpdateSettings
- RemoveContainers(this DockerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerUpdateSettings
- ResetBlkioWeight(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpuPeriod(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpuQuota(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpuRtPeriod(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpuRtRuntime(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpus(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpusetCpus(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpusetMems(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetCpuShares(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetKernelMemory(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetMemory(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetMemoryReservation(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetMemorySwap(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetPidsLimit(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- ResetRestart(this DockerUpdateSettings toolSettings) : DockerUpdateSettings
- SetBlkioWeight(this DockerUpdateSettings toolSettings, int? blkioWeight) : DockerUpdateSettings
- SetContainers(this DockerUpdateSettings toolSettings, string[] containers) : DockerUpdateSettings
- SetContainers(this DockerUpdateSettings toolSettings, IEnumerable<string> containers) : DockerUpdateSettings
- SetCpuPeriod(this DockerUpdateSettings toolSettings, long? cpuPeriod) : DockerUpdateSettings
- SetCpuQuota(this DockerUpdateSettings toolSettings, long? cpuQuota) : DockerUpdateSettings
- SetCpuRtPeriod(this DockerUpdateSettings toolSettings, long? cpuRtPeriod) : DockerUpdateSettings
- SetCpuRtRuntime(this DockerUpdateSettings toolSettings, long? cpuRtRuntime) : DockerUpdateSettings
- SetCpus(this DockerUpdateSettings toolSettings, decimal? cpus) : DockerUpdateSettings
- SetCpusetCpus(this DockerUpdateSettings toolSettings, string cpusetCpus) : DockerUpdateSettings
- SetCpusetMems(this DockerUpdateSettings toolSettings, string cpusetMems) : DockerUpdateSettings
- SetCpuShares(this DockerUpdateSettings toolSettings, long? cpuShares) : DockerUpdateSettings
- SetKernelMemory(this DockerUpdateSettings toolSettings, long? kernelMemory) : DockerUpdateSettings
- SetMemory(this DockerUpdateSettings toolSettings, long? memory) : DockerUpdateSettings
- SetMemoryReservation(this DockerUpdateSettings toolSettings, long? memoryReservation) : DockerUpdateSettings
- SetMemorySwap(this DockerUpdateSettings toolSettings, long? memorySwap) : DockerUpdateSettings
- SetPidsLimit(this DockerUpdateSettings toolSettings, long? pidsLimit) : DockerUpdateSettings
- SetRestart(this DockerUpdateSettings toolSettings, string restart) : DockerUpdateSettings

### Nuke.Common.Tools.Docker.DockerVersionSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_Kubeconfig() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVersionSettingsExtensions

- ResetFormat(this DockerVersionSettings toolSettings) : DockerVersionSettings
- ResetKubeconfig(this DockerVersionSettings toolSettings) : DockerVersionSettings
- SetFormat(this DockerVersionSettings toolSettings, string format) : DockerVersionSettings
- SetKubeconfig(this DockerVersionSettings toolSettings, string kubeconfig) : DockerVersionSettings

### Nuke.Common.Tools.Docker.DockerVolumeCreateSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Driver() : string
- get_Label() : IReadOnlyList<string>
- get_Name() : string
- get_Opt() : IReadOnlyDictionary<string, string>
- get_ToolPath() : string
- get_Volume() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumeCreateSettingsExtensions

- AddLabel(this DockerVolumeCreateSettings toolSettings, string[] label) : DockerVolumeCreateSettings
- AddLabel(this DockerVolumeCreateSettings toolSettings, IEnumerable<string> label) : DockerVolumeCreateSettings
- AddOpt(this DockerVolumeCreateSettings toolSettings, string optKey, string optValue) : DockerVolumeCreateSettings
- ClearLabel(this DockerVolumeCreateSettings toolSettings) : DockerVolumeCreateSettings
- ClearOpt(this DockerVolumeCreateSettings toolSettings) : DockerVolumeCreateSettings
- RemoveLabel(this DockerVolumeCreateSettings toolSettings, string[] label) : DockerVolumeCreateSettings
- RemoveLabel(this DockerVolumeCreateSettings toolSettings, IEnumerable<string> label) : DockerVolumeCreateSettings
- RemoveOpt(this DockerVolumeCreateSettings toolSettings, string optKey) : DockerVolumeCreateSettings
- ResetDriver(this DockerVolumeCreateSettings toolSettings) : DockerVolumeCreateSettings
- ResetName(this DockerVolumeCreateSettings toolSettings) : DockerVolumeCreateSettings
- ResetVolume(this DockerVolumeCreateSettings toolSettings) : DockerVolumeCreateSettings
- SetDriver(this DockerVolumeCreateSettings toolSettings, string driver) : DockerVolumeCreateSettings
- SetLabel(this DockerVolumeCreateSettings toolSettings, string[] label) : DockerVolumeCreateSettings
- SetLabel(this DockerVolumeCreateSettings toolSettings, IEnumerable<string> label) : DockerVolumeCreateSettings
- SetName(this DockerVolumeCreateSettings toolSettings, string name) : DockerVolumeCreateSettings
- SetOpt(this DockerVolumeCreateSettings toolSettings, IDictionary<string, string> opt) : DockerVolumeCreateSettings
- SetOpt(this DockerVolumeCreateSettings toolSettings, string optKey, string optValue) : DockerVolumeCreateSettings
- SetVolume(this DockerVolumeCreateSettings toolSettings, string volume) : DockerVolumeCreateSettings

### Nuke.Common.Tools.Docker.DockerVolumeInspectSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Format() : string
- get_ToolPath() : string
- get_Volumes() : IReadOnlyList<string>
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumeInspectSettingsExtensions

- AddVolumes(this DockerVolumeInspectSettings toolSettings, string[] volumes) : DockerVolumeInspectSettings
- AddVolumes(this DockerVolumeInspectSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeInspectSettings
- ClearVolumes(this DockerVolumeInspectSettings toolSettings) : DockerVolumeInspectSettings
- RemoveVolumes(this DockerVolumeInspectSettings toolSettings, string[] volumes) : DockerVolumeInspectSettings
- RemoveVolumes(this DockerVolumeInspectSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeInspectSettings
- ResetFormat(this DockerVolumeInspectSettings toolSettings) : DockerVolumeInspectSettings
- SetFormat(this DockerVolumeInspectSettings toolSettings, string format) : DockerVolumeInspectSettings
- SetVolumes(this DockerVolumeInspectSettings toolSettings, string[] volumes) : DockerVolumeInspectSettings
- SetVolumes(this DockerVolumeInspectSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeInspectSettings

### Nuke.Common.Tools.Docker.DockerVolumeLsSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Format() : string
- get_Quiet() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumeLsSettingsExtensions

- DisableQuiet(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings
- EnableQuiet(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings
- ResetFilter(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings
- ResetFormat(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings
- ResetQuiet(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings
- SetFilter(this DockerVolumeLsSettings toolSettings, string filter) : DockerVolumeLsSettings
- SetFormat(this DockerVolumeLsSettings toolSettings, string format) : DockerVolumeLsSettings
- SetQuiet(this DockerVolumeLsSettings toolSettings, bool? quiet) : DockerVolumeLsSettings
- ToggleQuiet(this DockerVolumeLsSettings toolSettings) : DockerVolumeLsSettings

### Nuke.Common.Tools.Docker.DockerVolumePruneSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Filter() : string
- get_Force() : bool?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumePruneSettingsExtensions

- DisableForce(this DockerVolumePruneSettings toolSettings) : DockerVolumePruneSettings
- EnableForce(this DockerVolumePruneSettings toolSettings) : DockerVolumePruneSettings
- ResetFilter(this DockerVolumePruneSettings toolSettings) : DockerVolumePruneSettings
- ResetForce(this DockerVolumePruneSettings toolSettings) : DockerVolumePruneSettings
- SetFilter(this DockerVolumePruneSettings toolSettings, string filter) : DockerVolumePruneSettings
- SetForce(this DockerVolumePruneSettings toolSettings, bool? force) : DockerVolumePruneSettings
- ToggleForce(this DockerVolumePruneSettings toolSettings) : DockerVolumePruneSettings

### Nuke.Common.Tools.Docker.DockerVolumeRmSettings

- .ctor()
- get_CustomLogger() : Action<OutputType, string>
- get_Force() : bool?
- get_ToolPath() : string
- get_Volumes() : IReadOnlyList<string>
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumeRmSettingsExtensions

- AddVolumes(this DockerVolumeRmSettings toolSettings, string[] volumes) : DockerVolumeRmSettings
- AddVolumes(this DockerVolumeRmSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeRmSettings
- ClearVolumes(this DockerVolumeRmSettings toolSettings) : DockerVolumeRmSettings
- DisableForce(this DockerVolumeRmSettings toolSettings) : DockerVolumeRmSettings
- EnableForce(this DockerVolumeRmSettings toolSettings) : DockerVolumeRmSettings
- RemoveVolumes(this DockerVolumeRmSettings toolSettings, string[] volumes) : DockerVolumeRmSettings
- RemoveVolumes(this DockerVolumeRmSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeRmSettings
- ResetForce(this DockerVolumeRmSettings toolSettings) : DockerVolumeRmSettings
- SetForce(this DockerVolumeRmSettings toolSettings, bool? force) : DockerVolumeRmSettings
- SetVolumes(this DockerVolumeRmSettings toolSettings, string[] volumes) : DockerVolumeRmSettings
- SetVolumes(this DockerVolumeRmSettings toolSettings, IEnumerable<string> volumes) : DockerVolumeRmSettings
- ToggleForce(this DockerVolumeRmSettings toolSettings) : DockerVolumeRmSettings

### Nuke.Common.Tools.Docker.DockerVolumeSettings

- .ctor()
- get_Command() : string
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerVolumeSettingsExtensions

- ResetCommand(this DockerVolumeSettings toolSettings) : DockerVolumeSettings
- SetCommand(this DockerVolumeSettings toolSettings, string command) : DockerVolumeSettings

### Nuke.Common.Tools.Docker.DockerWaitSettings

- .ctor()
- get_Containers() : IReadOnlyList<string>
- get_CustomLogger() : Action<OutputType, string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.Docker.DockerWaitSettingsExtensions

- AddContainers(this DockerWaitSettings toolSettings, string[] containers) : DockerWaitSettings
- AddContainers(this DockerWaitSettings toolSettings, IEnumerable<string> containers) : DockerWaitSettings
- ClearContainers(this DockerWaitSettings toolSettings) : DockerWaitSettings
- RemoveContainers(this DockerWaitSettings toolSettings, string[] containers) : DockerWaitSettings
- RemoveContainers(this DockerWaitSettings toolSettings, IEnumerable<string> containers) : DockerWaitSettings
- SetContainers(this DockerWaitSettings toolSettings, string[] containers) : DockerWaitSettings
- SetContainers(this DockerWaitSettings toolSettings, IEnumerable<string> containers) : DockerWaitSettings

### Nuke.Common.Tools.Docker.LogLevel

- debug : LogLevel
- error : LogLevel
- fatal : LogLevel
- info : LogLevel
- warn : LogLevel
- .ctor()
- op_Explicit(string value) : LogLevel

### Nuke.Common.Tools.Docker.ResolveImage

- always : ResolveImage
- changed : ResolveImage
- never : ResolveImage
- .ctor()
- op_Explicit(string value) : ResolveImage

### Nuke.Common.Tools.Docker.RestartCondition

- any : RestartCondition
- none : RestartCondition
- on_failure : RestartCondition
- .ctor()
- op_Explicit(string value) : RestartCondition

### Nuke.Common.Tools.Docker.Role

- manager : Role
- worker : Role
- .ctor()
- op_Explicit(string value) : Role

### Nuke.Common.Tools.Docker.RollbackFailureAction

- continue_ : RollbackFailureAction
- pause : RollbackFailureAction
- .ctor()
- op_Explicit(string value) : RollbackFailureAction

### Nuke.Common.Tools.Docker.RollbackOrder

- start_first : RollbackOrder
- stop_first : RollbackOrder
- .ctor()
- op_Explicit(string value) : RollbackOrder

### Nuke.Common.Tools.Docker.UpdateFailureAction

- continue_ : UpdateFailureAction
- pause : UpdateFailureAction
- rollback : UpdateFailureAction
- .ctor()
- op_Explicit(string value) : UpdateFailureAction

### Nuke.Common.Tools.Docker.UpdateOrder

- start_first : UpdateOrder
- stop_first : UpdateOrder
- .ctor()
- op_Explicit(string value) : UpdateOrder

### Nuke.Common.Tools.DotCover.DotCoverAnalyseSettings

- .ctor()
- get_AllowSymbolServerAccess() : bool?
- get_AnalyseTargetArguments() : bool?
- get_AttributeFilters() : IReadOnlyList<string>
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableDefaultFilters() : bool?
- get_Filters() : IReadOnlyList<string>
- get_HideAutoProperties() : bool?
- get_InheritConsole() : bool?
- get_LogFile() : string
- get_OutputFile() : string
- get_ProcessFilters() : IReadOnlyList<string>
- get_ReportType() : DotCoverReportType
- get_ReturnTargetExitCode() : bool?
- get_Scope() : IReadOnlyList<string>
- get_SymbolSearchPaths() : IReadOnlyList<string>
- get_TargetArguments() : string
- get_TargetExecutable() : string
- get_TargetWorkingDirectory() : string
- get_TempDirectory() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverAnalyseSettingsExtensions

- AddAttributeFilters(this DotCoverAnalyseSettings toolSettings, string[] attributeFilters) : DotCoverAnalyseSettings
- AddAttributeFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverAnalyseSettings
- AddFilters(this DotCoverAnalyseSettings toolSettings, string[] filters) : DotCoverAnalyseSettings
- AddFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> filters) : DotCoverAnalyseSettings
- AddProcessFilters(this DotCoverAnalyseSettings toolSettings, string[] processFilters) : DotCoverAnalyseSettings
- AddProcessFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> processFilters) : DotCoverAnalyseSettings
- AddScope(this DotCoverAnalyseSettings toolSettings, string[] scope) : DotCoverAnalyseSettings
- AddScope(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> scope) : DotCoverAnalyseSettings
- AddSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, string[] symbolSearchPaths) : DotCoverAnalyseSettings
- AddSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverAnalyseSettings
- ClearAttributeFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ClearFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ClearProcessFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ClearScope(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ClearSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableAllowSymbolServerAccess(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableAnalyseTargetArguments(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableDisableDefaultFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableHideAutoProperties(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableInheritConsole(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- DisableReturnTargetExitCode(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableAllowSymbolServerAccess(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableAnalyseTargetArguments(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableDisableDefaultFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableHideAutoProperties(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableInheritConsole(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- EnableReturnTargetExitCode(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- RemoveAttributeFilters(this DotCoverAnalyseSettings toolSettings, string[] attributeFilters) : DotCoverAnalyseSettings
- RemoveAttributeFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverAnalyseSettings
- RemoveFilters(this DotCoverAnalyseSettings toolSettings, string[] filters) : DotCoverAnalyseSettings
- RemoveFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> filters) : DotCoverAnalyseSettings
- RemoveProcessFilters(this DotCoverAnalyseSettings toolSettings, string[] processFilters) : DotCoverAnalyseSettings
- RemoveProcessFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> processFilters) : DotCoverAnalyseSettings
- RemoveScope(this DotCoverAnalyseSettings toolSettings, string[] scope) : DotCoverAnalyseSettings
- RemoveScope(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> scope) : DotCoverAnalyseSettings
- RemoveSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, string[] symbolSearchPaths) : DotCoverAnalyseSettings
- RemoveSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverAnalyseSettings
- ResetAllowSymbolServerAccess(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetAnalyseTargetArguments(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetConfiguration(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetDisableDefaultFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetHideAutoProperties(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetInheritConsole(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetLogFile(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetOutputFile(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetReportType(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetReturnTargetExitCode(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetTargetArguments(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetTargetExecutable(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetTargetSettings(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetTargetWorkingDirectory(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ResetTempDirectory(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- SetAllowSymbolServerAccess(this DotCoverAnalyseSettings toolSettings, bool? allowSymbolServerAccess) : DotCoverAnalyseSettings
- SetAnalyseTargetArguments(this DotCoverAnalyseSettings toolSettings, bool? analyseTargetArguments) : DotCoverAnalyseSettings
- SetAttributeFilters(this DotCoverAnalyseSettings toolSettings, string[] attributeFilters) : DotCoverAnalyseSettings
- SetAttributeFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverAnalyseSettings
- SetConfiguration(this DotCoverAnalyseSettings toolSettings, string configuration) : DotCoverAnalyseSettings
- SetDisableDefaultFilters(this DotCoverAnalyseSettings toolSettings, bool? disableDefaultFilters) : DotCoverAnalyseSettings
- SetFilters(this DotCoverAnalyseSettings toolSettings, string[] filters) : DotCoverAnalyseSettings
- SetFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> filters) : DotCoverAnalyseSettings
- SetHideAutoProperties(this DotCoverAnalyseSettings toolSettings, bool? hideAutoProperties) : DotCoverAnalyseSettings
- SetInheritConsole(this DotCoverAnalyseSettings toolSettings, bool? inheritConsole) : DotCoverAnalyseSettings
- SetLogFile(this DotCoverAnalyseSettings toolSettings, string logFile) : DotCoverAnalyseSettings
- SetOutputFile(this DotCoverAnalyseSettings toolSettings, string outputFile) : DotCoverAnalyseSettings
- SetProcessFilters(this DotCoverAnalyseSettings toolSettings, string[] processFilters) : DotCoverAnalyseSettings
- SetProcessFilters(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> processFilters) : DotCoverAnalyseSettings
- SetReportType(this DotCoverAnalyseSettings toolSettings, DotCoverReportType reportType) : DotCoverAnalyseSettings
- SetReturnTargetExitCode(this DotCoverAnalyseSettings toolSettings, bool? returnTargetExitCode) : DotCoverAnalyseSettings
- SetScope(this DotCoverAnalyseSettings toolSettings, string[] scope) : DotCoverAnalyseSettings
- SetScope(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> scope) : DotCoverAnalyseSettings
- SetSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, string[] symbolSearchPaths) : DotCoverAnalyseSettings
- SetSymbolSearchPaths(this DotCoverAnalyseSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverAnalyseSettings
- SetTargetArguments(this DotCoverAnalyseSettings toolSettings, string targetArguments) : DotCoverAnalyseSettings
- SetTargetExecutable(this DotCoverAnalyseSettings toolSettings, string targetExecutable) : DotCoverAnalyseSettings
- SetTargetSettings(this DotCoverAnalyseSettings toolSettings, ToolSettings targetSettings) : DotCoverAnalyseSettings
- SetTargetWorkingDirectory(this DotCoverAnalyseSettings toolSettings, string targetWorkingDirectory) : DotCoverAnalyseSettings
- SetTempDirectory(this DotCoverAnalyseSettings toolSettings, string tempDirectory) : DotCoverAnalyseSettings
- ToggleAllowSymbolServerAccess(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ToggleAnalyseTargetArguments(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ToggleDisableDefaultFilters(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ToggleHideAutoProperties(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ToggleInheritConsole(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings
- ToggleReturnTargetExitCode(this DotCoverAnalyseSettings toolSettings) : DotCoverAnalyseSettings

### Nuke.Common.Tools.DotCover.DotCoverCoverSettings

- .ctor()
- get_AllowSymbolServerAccess() : bool?
- get_AnalyseTargetArguments() : bool?
- get_AttributeFilters() : IReadOnlyList<string>
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableDefaultFilters() : bool?
- get_Filters() : IReadOnlyList<string>
- get_InheritConsole() : bool?
- get_LogFile() : string
- get_OutputFile() : string
- get_ProcessFilters() : IReadOnlyList<string>
- get_ReturnTargetExitCode() : bool?
- get_Scope() : IReadOnlyList<string>
- get_SymbolSearchPaths() : IReadOnlyList<string>
- get_TargetArguments() : string
- get_TargetExecutable() : string
- get_TargetWorkingDirectory() : string
- get_TempDirectory() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverCoverSettingsExtensions

- AddAttributeFilters(this DotCoverCoverSettings toolSettings, string[] attributeFilters) : DotCoverCoverSettings
- AddAttributeFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverCoverSettings
- AddFilters(this DotCoverCoverSettings toolSettings, string[] filters) : DotCoverCoverSettings
- AddFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> filters) : DotCoverCoverSettings
- AddProcessFilters(this DotCoverCoverSettings toolSettings, string[] processFilters) : DotCoverCoverSettings
- AddProcessFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> processFilters) : DotCoverCoverSettings
- AddScope(this DotCoverCoverSettings toolSettings, string[] scope) : DotCoverCoverSettings
- AddScope(this DotCoverCoverSettings toolSettings, IEnumerable<string> scope) : DotCoverCoverSettings
- AddSymbolSearchPaths(this DotCoverCoverSettings toolSettings, string[] symbolSearchPaths) : DotCoverCoverSettings
- AddSymbolSearchPaths(this DotCoverCoverSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverCoverSettings
- ClearAttributeFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ClearFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ClearProcessFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ClearScope(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ClearSymbolSearchPaths(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- DisableAllowSymbolServerAccess(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- DisableAnalyseTargetArguments(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- DisableDisableDefaultFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- DisableInheritConsole(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- DisableReturnTargetExitCode(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- EnableAllowSymbolServerAccess(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- EnableAnalyseTargetArguments(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- EnableDisableDefaultFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- EnableInheritConsole(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- EnableReturnTargetExitCode(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- RemoveAttributeFilters(this DotCoverCoverSettings toolSettings, string[] attributeFilters) : DotCoverCoverSettings
- RemoveAttributeFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverCoverSettings
- RemoveFilters(this DotCoverCoverSettings toolSettings, string[] filters) : DotCoverCoverSettings
- RemoveFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> filters) : DotCoverCoverSettings
- RemoveProcessFilters(this DotCoverCoverSettings toolSettings, string[] processFilters) : DotCoverCoverSettings
- RemoveProcessFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> processFilters) : DotCoverCoverSettings
- RemoveScope(this DotCoverCoverSettings toolSettings, string[] scope) : DotCoverCoverSettings
- RemoveScope(this DotCoverCoverSettings toolSettings, IEnumerable<string> scope) : DotCoverCoverSettings
- RemoveSymbolSearchPaths(this DotCoverCoverSettings toolSettings, string[] symbolSearchPaths) : DotCoverCoverSettings
- RemoveSymbolSearchPaths(this DotCoverCoverSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverCoverSettings
- ResetAllowSymbolServerAccess(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetAnalyseTargetArguments(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetConfiguration(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetDisableDefaultFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetInheritConsole(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetLogFile(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetOutputFile(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetReturnTargetExitCode(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetTargetArguments(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetTargetExecutable(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetTargetSettings(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetTargetWorkingDirectory(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ResetTempDirectory(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- SetAllowSymbolServerAccess(this DotCoverCoverSettings toolSettings, bool? allowSymbolServerAccess) : DotCoverCoverSettings
- SetAnalyseTargetArguments(this DotCoverCoverSettings toolSettings, bool? analyseTargetArguments) : DotCoverCoverSettings
- SetAttributeFilters(this DotCoverCoverSettings toolSettings, string[] attributeFilters) : DotCoverCoverSettings
- SetAttributeFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> attributeFilters) : DotCoverCoverSettings
- SetConfiguration(this DotCoverCoverSettings toolSettings, string configuration) : DotCoverCoverSettings
- SetDisableDefaultFilters(this DotCoverCoverSettings toolSettings, bool? disableDefaultFilters) : DotCoverCoverSettings
- SetFilters(this DotCoverCoverSettings toolSettings, string[] filters) : DotCoverCoverSettings
- SetFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> filters) : DotCoverCoverSettings
- SetInheritConsole(this DotCoverCoverSettings toolSettings, bool? inheritConsole) : DotCoverCoverSettings
- SetLogFile(this DotCoverCoverSettings toolSettings, string logFile) : DotCoverCoverSettings
- SetOutputFile(this DotCoverCoverSettings toolSettings, string outputFile) : DotCoverCoverSettings
- SetProcessFilters(this DotCoverCoverSettings toolSettings, string[] processFilters) : DotCoverCoverSettings
- SetProcessFilters(this DotCoverCoverSettings toolSettings, IEnumerable<string> processFilters) : DotCoverCoverSettings
- SetReturnTargetExitCode(this DotCoverCoverSettings toolSettings, bool? returnTargetExitCode) : DotCoverCoverSettings
- SetScope(this DotCoverCoverSettings toolSettings, string[] scope) : DotCoverCoverSettings
- SetScope(this DotCoverCoverSettings toolSettings, IEnumerable<string> scope) : DotCoverCoverSettings
- SetSymbolSearchPaths(this DotCoverCoverSettings toolSettings, string[] symbolSearchPaths) : DotCoverCoverSettings
- SetSymbolSearchPaths(this DotCoverCoverSettings toolSettings, IEnumerable<string> symbolSearchPaths) : DotCoverCoverSettings
- SetTargetArguments(this DotCoverCoverSettings toolSettings, string targetArguments) : DotCoverCoverSettings
- SetTargetExecutable(this DotCoverCoverSettings toolSettings, string targetExecutable) : DotCoverCoverSettings
- SetTargetSettings(this DotCoverCoverSettings toolSettings, ToolSettings targetSettings) : DotCoverCoverSettings
- SetTargetWorkingDirectory(this DotCoverCoverSettings toolSettings, string targetWorkingDirectory) : DotCoverCoverSettings
- SetTempDirectory(this DotCoverCoverSettings toolSettings, string tempDirectory) : DotCoverCoverSettings
- ToggleAllowSymbolServerAccess(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ToggleAnalyseTargetArguments(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ToggleDisableDefaultFilters(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ToggleInheritConsole(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings
- ToggleReturnTargetExitCode(this DotCoverCoverSettings toolSettings) : DotCoverCoverSettings

### Nuke.Common.Tools.DotCover.DotCoverDeleteSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_LogFile() : string
- get_Source() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverDeleteSettingsExtensions

- AddSource(this DotCoverDeleteSettings toolSettings, string[] source) : DotCoverDeleteSettings
- AddSource(this DotCoverDeleteSettings toolSettings, IEnumerable<string> source) : DotCoverDeleteSettings
- ClearSource(this DotCoverDeleteSettings toolSettings) : DotCoverDeleteSettings
- RemoveSource(this DotCoverDeleteSettings toolSettings, string[] source) : DotCoverDeleteSettings
- RemoveSource(this DotCoverDeleteSettings toolSettings, IEnumerable<string> source) : DotCoverDeleteSettings
- ResetConfiguration(this DotCoverDeleteSettings toolSettings) : DotCoverDeleteSettings
- ResetLogFile(this DotCoverDeleteSettings toolSettings) : DotCoverDeleteSettings
- SetConfiguration(this DotCoverDeleteSettings toolSettings, string configuration) : DotCoverDeleteSettings
- SetLogFile(this DotCoverDeleteSettings toolSettings, string logFile) : DotCoverDeleteSettings
- SetSource(this DotCoverDeleteSettings toolSettings, string[] source) : DotCoverDeleteSettings
- SetSource(this DotCoverDeleteSettings toolSettings, IEnumerable<string> source) : DotCoverDeleteSettings

### Nuke.Common.Tools.DotCover.DotCoverMergeSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_LogFile() : string
- get_OutputFile() : string
- get_Source() : IReadOnlyList<string>
- get_TempDirectory() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverMergeSettingsExtensions

- AddSource(this DotCoverMergeSettings toolSettings, string[] source) : DotCoverMergeSettings
- AddSource(this DotCoverMergeSettings toolSettings, IEnumerable<string> source) : DotCoverMergeSettings
- ClearSource(this DotCoverMergeSettings toolSettings) : DotCoverMergeSettings
- RemoveSource(this DotCoverMergeSettings toolSettings, string[] source) : DotCoverMergeSettings
- RemoveSource(this DotCoverMergeSettings toolSettings, IEnumerable<string> source) : DotCoverMergeSettings
- ResetConfiguration(this DotCoverMergeSettings toolSettings) : DotCoverMergeSettings
- ResetLogFile(this DotCoverMergeSettings toolSettings) : DotCoverMergeSettings
- ResetOutputFile(this DotCoverMergeSettings toolSettings) : DotCoverMergeSettings
- ResetTempDirectory(this DotCoverMergeSettings toolSettings) : DotCoverMergeSettings
- SetConfiguration(this DotCoverMergeSettings toolSettings, string configuration) : DotCoverMergeSettings
- SetLogFile(this DotCoverMergeSettings toolSettings, string logFile) : DotCoverMergeSettings
- SetOutputFile(this DotCoverMergeSettings toolSettings, string outputFile) : DotCoverMergeSettings
- SetSource(this DotCoverMergeSettings toolSettings, string[] source) : DotCoverMergeSettings
- SetSource(this DotCoverMergeSettings toolSettings, IEnumerable<string> source) : DotCoverMergeSettings
- SetTempDirectory(this DotCoverMergeSettings toolSettings, string tempDirectory) : DotCoverMergeSettings

### Nuke.Common.Tools.DotCover.DotCoverReportSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_HideAutoProperties() : bool?
- get_LogFile() : string
- get_OutputFile() : string
- get_ReportType() : DotCoverReportType
- get_Source() : IReadOnlyList<string>
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverReportSettingsExtensions

- AddSource(this DotCoverReportSettings toolSettings, string[] source) : DotCoverReportSettings
- AddSource(this DotCoverReportSettings toolSettings, IEnumerable<string> source) : DotCoverReportSettings
- ClearSource(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- DisableHideAutoProperties(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- EnableHideAutoProperties(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- RemoveSource(this DotCoverReportSettings toolSettings, string[] source) : DotCoverReportSettings
- RemoveSource(this DotCoverReportSettings toolSettings, IEnumerable<string> source) : DotCoverReportSettings
- ResetConfiguration(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- ResetHideAutoProperties(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- ResetLogFile(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- ResetOutputFile(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- ResetReportType(this DotCoverReportSettings toolSettings) : DotCoverReportSettings
- SetConfiguration(this DotCoverReportSettings toolSettings, string configuration) : DotCoverReportSettings
- SetHideAutoProperties(this DotCoverReportSettings toolSettings, bool? hideAutoProperties) : DotCoverReportSettings
- SetLogFile(this DotCoverReportSettings toolSettings, string logFile) : DotCoverReportSettings
- SetOutputFile(this DotCoverReportSettings toolSettings, string outputFile) : DotCoverReportSettings
- SetReportType(this DotCoverReportSettings toolSettings, DotCoverReportType reportType) : DotCoverReportSettings
- SetSource(this DotCoverReportSettings toolSettings, string[] source) : DotCoverReportSettings
- SetSource(this DotCoverReportSettings toolSettings, IEnumerable<string> source) : DotCoverReportSettings
- ToggleHideAutoProperties(this DotCoverReportSettings toolSettings) : DotCoverReportSettings

### Nuke.Common.Tools.DotCover.DotCoverReportType

- DetailedXml : DotCoverReportType
- Html : DotCoverReportType
- Json : DotCoverReportType
- Xml : DotCoverReportType
- .ctor()
- op_Explicit(string value) : DotCoverReportType

### Nuke.Common.Tools.DotCover.DotCoverTasks

- get_DotCoverLogger() : Action<OutputType, string>
- get_DotCoverPath() : string
- set_DotCoverLogger(Action<OutputType, string> value) : void
- DotCover(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- DotCoverAnalyse(DotCoverAnalyseSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverAnalyse(Configure<DotCoverAnalyseSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverAnalyse(CombinatorialConfigure<DotCoverAnalyseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverAnalyseSettings, Output IReadOnlyCollection<Output>)>
- DotCoverCover(DotCoverCoverSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverCover(Configure<DotCoverCoverSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverCover(CombinatorialConfigure<DotCoverCoverSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverCoverSettings, Output IReadOnlyCollection<Output>)>
- DotCoverDelete(DotCoverDeleteSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverDelete(Configure<DotCoverDeleteSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverDelete(CombinatorialConfigure<DotCoverDeleteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverDeleteSettings, Output IReadOnlyCollection<Output>)>
- DotCoverMerge(DotCoverMergeSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverMerge(Configure<DotCoverMergeSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverMerge(CombinatorialConfigure<DotCoverMergeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverMergeSettings, Output IReadOnlyCollection<Output>)>
- DotCoverReport(DotCoverReportSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverReport(Configure<DotCoverReportSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverReport(CombinatorialConfigure<DotCoverReportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverReportSettings, Output IReadOnlyCollection<Output>)>
- DotCoverZip(DotCoverZipSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotCoverZip(Configure<DotCoverZipSettings> configurator) : IReadOnlyCollection<Output>
- DotCoverZip(CombinatorialConfigure<DotCoverZipSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotCoverZipSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.DotCover.DotCoverZipSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_LogFile() : string
- get_OutputFile() : string
- get_Source() : string
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotCover.DotCoverZipSettingsExtensions

- ResetConfiguration(this DotCoverZipSettings toolSettings) : DotCoverZipSettings
- ResetLogFile(this DotCoverZipSettings toolSettings) : DotCoverZipSettings
- ResetOutputFile(this DotCoverZipSettings toolSettings) : DotCoverZipSettings
- ResetSource(this DotCoverZipSettings toolSettings) : DotCoverZipSettings
- SetConfiguration(this DotCoverZipSettings toolSettings, string configuration) : DotCoverZipSettings
- SetLogFile(this DotCoverZipSettings toolSettings, string logFile) : DotCoverZipSettings
- SetOutputFile(this DotCoverZipSettings toolSettings, string outputFile) : DotCoverZipSettings
- SetSource(this DotCoverZipSettings toolSettings, string source) : DotCoverZipSettings

### Nuke.Common.Tools.DotCover.TeamCitySetDotCoverHomePathAttribute

- .ctor()
- OnAfterLogo(NukeBuild build, IReadOnlyCollection<ExecutableTarget> executableTargets, IReadOnlyCollection<ExecutableTarget> executionPlan) : void

### Nuke.Common.Tools.DotMemoryUnit.DotMemoryUnitTasks

- get_DotMemoryUnitLogger() : Action<OutputType, string>
- get_DotMemoryUnitPath() : string
- set_DotMemoryUnitLogger(Action<OutputType, string> value) : void
- DotMemoryUnit(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>

### Nuke.Common.Tools.DotNet.DotNetBuildSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableParallel() : bool?
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_Framework() : string
- get_IgnoreFailedSources() : bool?
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_Loggers() : IReadOnlyList<string>
- get_NoCache() : bool?
- get_NoConsoleLogger() : bool?
- get_NoDependencies() : bool?
- get_NoIncremental() : bool?
- get_NoRestore() : bool?
- get_OutputDirectory() : string
- get_PackageDirectory() : string
- get_ProjectFile() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_Sources() : IReadOnlyList<string>
- get_ToolPath() : string
- get_UseLockFile() : bool?
- get_Verbosity() : DotNetVerbosity
- get_VersionSuffix() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetBuildSettingsExtensions

- AddAuthors(this DotNetBuildSettings toolSettings, string[] authors) : DotNetBuildSettings
- AddAuthors(this DotNetBuildSettings toolSettings, IEnumerable<string> authors) : DotNetBuildSettings
- AddLoggers(this DotNetBuildSettings toolSettings, string[] loggers) : DotNetBuildSettings
- AddLoggers(this DotNetBuildSettings toolSettings, IEnumerable<string> loggers) : DotNetBuildSettings
- AddNoWarns(this DotNetBuildSettings toolSettings, int[] noWarn) : DotNetBuildSettings
- AddNoWarns(this DotNetBuildSettings toolSettings, IEnumerable<int> noWarn) : DotNetBuildSettings
- AddPackageTags(this DotNetBuildSettings toolSettings, string[] packageTags) : DotNetBuildSettings
- AddPackageTags(this DotNetBuildSettings toolSettings, IEnumerable<string> packageTags) : DotNetBuildSettings
- AddProperty(this DotNetBuildSettings toolSettings, string propertyKey, object propertyValue) : DotNetBuildSettings
- AddSources(this DotNetBuildSettings toolSettings, string[] sources) : DotNetBuildSettings
- AddSources(this DotNetBuildSettings toolSettings, IEnumerable<string> sources) : DotNetBuildSettings
- AddWarningsAsErrors(this DotNetBuildSettings toolSettings, int[] warningsAsErrors) : DotNetBuildSettings
- AddWarningsAsErrors(this DotNetBuildSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetBuildSettings
- ClearAuthors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearLoggers(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearNoWarns(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearPackageTags(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearProperties(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearSources(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ClearWarningsAsErrors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableDisableParallel(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableForce(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableForceEvaluate(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableIgnoreFailedSources(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableLockedMode(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableNoCache(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableNoConsoleLogger(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableNoDependencies(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableNoIncremental(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableNoRestore(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisablePackageRequireLicenseAcceptance(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableRunCodeAnalysis(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableTreatWarningsAsErrors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- DisableUseLockFile(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableDisableParallel(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableForce(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableForceEvaluate(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableIgnoreFailedSources(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableLockedMode(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableNoCache(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableNoConsoleLogger(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableNoDependencies(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableNoIncremental(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableNoRestore(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnablePackageRequireLicenseAcceptance(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableRunCodeAnalysis(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableTreatWarningsAsErrors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- EnableUseLockFile(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- RemoveAuthors(this DotNetBuildSettings toolSettings, string[] authors) : DotNetBuildSettings
- RemoveAuthors(this DotNetBuildSettings toolSettings, IEnumerable<string> authors) : DotNetBuildSettings
- RemoveLoggers(this DotNetBuildSettings toolSettings, string[] loggers) : DotNetBuildSettings
- RemoveLoggers(this DotNetBuildSettings toolSettings, IEnumerable<string> loggers) : DotNetBuildSettings
- RemoveNoWarns(this DotNetBuildSettings toolSettings, int[] noWarn) : DotNetBuildSettings
- RemoveNoWarns(this DotNetBuildSettings toolSettings, IEnumerable<int> noWarn) : DotNetBuildSettings
- RemovePackageTags(this DotNetBuildSettings toolSettings, string[] packageTags) : DotNetBuildSettings
- RemovePackageTags(this DotNetBuildSettings toolSettings, IEnumerable<string> packageTags) : DotNetBuildSettings
- RemoveProperty(this DotNetBuildSettings toolSettings, string propertyKey) : DotNetBuildSettings
- RemoveSources(this DotNetBuildSettings toolSettings, string[] sources) : DotNetBuildSettings
- RemoveSources(this DotNetBuildSettings toolSettings, IEnumerable<string> sources) : DotNetBuildSettings
- RemoveWarningsAsErrors(this DotNetBuildSettings toolSettings, int[] warningsAsErrors) : DotNetBuildSettings
- RemoveWarningsAsErrors(this DotNetBuildSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetBuildSettings
- ResetAssemblyVersion(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetConfiguration(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetCopyright(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetDescription(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetDisableParallel(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetFileVersion(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetForce(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetForceEvaluate(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetFramework(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetIgnoreFailedSources(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetInformationalVersion(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetLockedMode(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetLockFilePath(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetNoCache(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetNoConsoleLogger(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetNoDependencies(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetNoIncremental(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetNoRestore(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetOutputDirectory(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageDirectory(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageIconUrl(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageId(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageLicenseUrl(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageProjectUrl(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageReleaseNotes(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetPackageRequireLicenseAcceptance(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetProjectFile(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetRepositoryType(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetRepositoryUrl(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetRunCodeAnalysis(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetRuntime(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetSymbolPackageFormat(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetTitle(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetTreatWarningsAsErrors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetUseLockFile(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetVerbosity(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetVersion(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetVersionPrefix(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetVersionSuffix(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ResetWarningLevel(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- SetAssemblyVersion(this DotNetBuildSettings toolSettings, string assemblyVersion) : DotNetBuildSettings
- SetAuthors(this DotNetBuildSettings toolSettings, string[] authors) : DotNetBuildSettings
- SetAuthors(this DotNetBuildSettings toolSettings, IEnumerable<string> authors) : DotNetBuildSettings
- SetConfiguration(this DotNetBuildSettings toolSettings, string configuration) : DotNetBuildSettings
- SetCopyright(this DotNetBuildSettings toolSettings, string copyright) : DotNetBuildSettings
- SetDescription(this DotNetBuildSettings toolSettings, string description) : DotNetBuildSettings
- SetDisableParallel(this DotNetBuildSettings toolSettings, bool? disableParallel) : DotNetBuildSettings
- SetFileVersion(this DotNetBuildSettings toolSettings, string fileVersion) : DotNetBuildSettings
- SetForce(this DotNetBuildSettings toolSettings, bool? force) : DotNetBuildSettings
- SetForceEvaluate(this DotNetBuildSettings toolSettings, bool? forceEvaluate) : DotNetBuildSettings
- SetFramework(this DotNetBuildSettings toolSettings, string framework) : DotNetBuildSettings
- SetIgnoreFailedSources(this DotNetBuildSettings toolSettings, bool? ignoreFailedSources) : DotNetBuildSettings
- SetInformationalVersion(this DotNetBuildSettings toolSettings, string informationalVersion) : DotNetBuildSettings
- SetLockedMode(this DotNetBuildSettings toolSettings, bool? lockedMode) : DotNetBuildSettings
- SetLockFilePath(this DotNetBuildSettings toolSettings, string lockFilePath) : DotNetBuildSettings
- SetLoggers(this DotNetBuildSettings toolSettings, string[] loggers) : DotNetBuildSettings
- SetLoggers(this DotNetBuildSettings toolSettings, IEnumerable<string> loggers) : DotNetBuildSettings
- SetNoCache(this DotNetBuildSettings toolSettings, bool? noCache) : DotNetBuildSettings
- SetNoConsoleLogger(this DotNetBuildSettings toolSettings, bool? noConsoleLogger) : DotNetBuildSettings
- SetNoDependencies(this DotNetBuildSettings toolSettings, bool? noDependencies) : DotNetBuildSettings
- SetNoIncremental(this DotNetBuildSettings toolSettings, bool? noIncremental) : DotNetBuildSettings
- SetNoRestore(this DotNetBuildSettings toolSettings, bool? noRestore) : DotNetBuildSettings
- SetNoWarns(this DotNetBuildSettings toolSettings, int[] noWarn) : DotNetBuildSettings
- SetNoWarns(this DotNetBuildSettings toolSettings, IEnumerable<int> noWarn) : DotNetBuildSettings
- SetOutputDirectory(this DotNetBuildSettings toolSettings, string outputDirectory) : DotNetBuildSettings
- SetPackageDirectory(this DotNetBuildSettings toolSettings, string packageDirectory) : DotNetBuildSettings
- SetPackageIconUrl(this DotNetBuildSettings toolSettings, string packageIconUrl) : DotNetBuildSettings
- SetPackageId(this DotNetBuildSettings toolSettings, string packageId) : DotNetBuildSettings
- SetPackageLicenseUrl(this DotNetBuildSettings toolSettings, string packageLicenseUrl) : DotNetBuildSettings
- SetPackageProjectUrl(this DotNetBuildSettings toolSettings, string packageProjectUrl) : DotNetBuildSettings
- SetPackageReleaseNotes(this DotNetBuildSettings toolSettings, string packageReleaseNotes) : DotNetBuildSettings
- SetPackageRequireLicenseAcceptance(this DotNetBuildSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetBuildSettings
- SetPackageTags(this DotNetBuildSettings toolSettings, string[] packageTags) : DotNetBuildSettings
- SetPackageTags(this DotNetBuildSettings toolSettings, IEnumerable<string> packageTags) : DotNetBuildSettings
- SetProjectFile(this DotNetBuildSettings toolSettings, string projectFile) : DotNetBuildSettings
- SetProperties(this DotNetBuildSettings toolSettings, IDictionary<string, object> properties) : DotNetBuildSettings
- SetProperty(this DotNetBuildSettings toolSettings, string propertyKey, object propertyValue) : DotNetBuildSettings
- SetRepositoryType(this DotNetBuildSettings toolSettings, string repositoryType) : DotNetBuildSettings
- SetRepositoryUrl(this DotNetBuildSettings toolSettings, string repositoryUrl) : DotNetBuildSettings
- SetRunCodeAnalysis(this DotNetBuildSettings toolSettings, bool? runCodeAnalysis) : DotNetBuildSettings
- SetRuntime(this DotNetBuildSettings toolSettings, string runtime) : DotNetBuildSettings
- SetSources(this DotNetBuildSettings toolSettings, string[] sources) : DotNetBuildSettings
- SetSources(this DotNetBuildSettings toolSettings, IEnumerable<string> sources) : DotNetBuildSettings
- SetSymbolPackageFormat(this DotNetBuildSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetBuildSettings
- SetTitle(this DotNetBuildSettings toolSettings, string title) : DotNetBuildSettings
- SetTreatWarningsAsErrors(this DotNetBuildSettings toolSettings, bool? treatWarningsAsErrors) : DotNetBuildSettings
- SetUseLockFile(this DotNetBuildSettings toolSettings, bool? useLockFile) : DotNetBuildSettings
- SetVerbosity(this DotNetBuildSettings toolSettings, DotNetVerbosity verbosity) : DotNetBuildSettings
- SetVersion(this DotNetBuildSettings toolSettings, string version) : DotNetBuildSettings
- SetVersionPrefix(this DotNetBuildSettings toolSettings, string versionPrefix) : DotNetBuildSettings
- SetVersionSuffix(this DotNetBuildSettings toolSettings, string versionSuffix) : DotNetBuildSettings
- SetWarningLevel(this DotNetBuildSettings toolSettings, int? warningLevel) : DotNetBuildSettings
- SetWarningsAsErrors(this DotNetBuildSettings toolSettings, int[] warningsAsErrors) : DotNetBuildSettings
- SetWarningsAsErrors(this DotNetBuildSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetBuildSettings
- ToggleDisableParallel(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleForce(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleForceEvaluate(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleIgnoreFailedSources(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleLockedMode(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleNoCache(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleNoConsoleLogger(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleNoDependencies(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleNoIncremental(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleNoRestore(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- TogglePackageRequireLicenseAcceptance(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleRunCodeAnalysis(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleTreatWarningsAsErrors(this DotNetBuildSettings toolSettings) : DotNetBuildSettings
- ToggleUseLockFile(this DotNetBuildSettings toolSettings) : DotNetBuildSettings

### Nuke.Common.Tools.DotNet.DotNetCleanSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_Framework() : string
- get_Output() : string
- get_Project() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_ToolPath() : string
- get_Verbosity() : DotNetVerbosity
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetCleanSettingsExtensions

- AddAuthors(this DotNetCleanSettings toolSettings, string[] authors) : DotNetCleanSettings
- AddAuthors(this DotNetCleanSettings toolSettings, IEnumerable<string> authors) : DotNetCleanSettings
- AddNoWarns(this DotNetCleanSettings toolSettings, int[] noWarn) : DotNetCleanSettings
- AddNoWarns(this DotNetCleanSettings toolSettings, IEnumerable<int> noWarn) : DotNetCleanSettings
- AddPackageTags(this DotNetCleanSettings toolSettings, string[] packageTags) : DotNetCleanSettings
- AddPackageTags(this DotNetCleanSettings toolSettings, IEnumerable<string> packageTags) : DotNetCleanSettings
- AddProperty(this DotNetCleanSettings toolSettings, string propertyKey, object propertyValue) : DotNetCleanSettings
- AddWarningsAsErrors(this DotNetCleanSettings toolSettings, int[] warningsAsErrors) : DotNetCleanSettings
- AddWarningsAsErrors(this DotNetCleanSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetCleanSettings
- ClearAuthors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ClearNoWarns(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ClearPackageTags(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ClearProperties(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ClearWarningsAsErrors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- DisablePackageRequireLicenseAcceptance(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- DisableRunCodeAnalysis(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- DisableTreatWarningsAsErrors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- EnablePackageRequireLicenseAcceptance(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- EnableRunCodeAnalysis(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- EnableTreatWarningsAsErrors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- RemoveAuthors(this DotNetCleanSettings toolSettings, string[] authors) : DotNetCleanSettings
- RemoveAuthors(this DotNetCleanSettings toolSettings, IEnumerable<string> authors) : DotNetCleanSettings
- RemoveNoWarns(this DotNetCleanSettings toolSettings, int[] noWarn) : DotNetCleanSettings
- RemoveNoWarns(this DotNetCleanSettings toolSettings, IEnumerable<int> noWarn) : DotNetCleanSettings
- RemovePackageTags(this DotNetCleanSettings toolSettings, IEnumerable<string> packageTags) : DotNetCleanSettings
- RemovePackageTags(this DotNetCleanSettings toolSettings, string[] packageTags) : DotNetCleanSettings
- RemoveProperty(this DotNetCleanSettings toolSettings, string propertyKey) : DotNetCleanSettings
- RemoveWarningsAsErrors(this DotNetCleanSettings toolSettings, int[] warningsAsErrors) : DotNetCleanSettings
- RemoveWarningsAsErrors(this DotNetCleanSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetCleanSettings
- ResetAssemblyVersion(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetConfiguration(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetCopyright(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetDescription(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetFileVersion(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetFramework(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetInformationalVersion(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetOutput(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageIconUrl(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageId(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageLicenseUrl(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageProjectUrl(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageReleaseNotes(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetPackageRequireLicenseAcceptance(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetProject(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetRepositoryType(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetRepositoryUrl(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetRunCodeAnalysis(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetRuntime(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetSymbolPackageFormat(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetTitle(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetTreatWarningsAsErrors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetVerbosity(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetVersion(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetVersionPrefix(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ResetWarningLevel(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- SetAssemblyVersion(this DotNetCleanSettings toolSettings, string assemblyVersion) : DotNetCleanSettings
- SetAuthors(this DotNetCleanSettings toolSettings, string[] authors) : DotNetCleanSettings
- SetAuthors(this DotNetCleanSettings toolSettings, IEnumerable<string> authors) : DotNetCleanSettings
- SetConfiguration(this DotNetCleanSettings toolSettings, string configuration) : DotNetCleanSettings
- SetCopyright(this DotNetCleanSettings toolSettings, string copyright) : DotNetCleanSettings
- SetDescription(this DotNetCleanSettings toolSettings, string description) : DotNetCleanSettings
- SetFileVersion(this DotNetCleanSettings toolSettings, string fileVersion) : DotNetCleanSettings
- SetFramework(this DotNetCleanSettings toolSettings, string framework) : DotNetCleanSettings
- SetInformationalVersion(this DotNetCleanSettings toolSettings, string informationalVersion) : DotNetCleanSettings
- SetNoWarns(this DotNetCleanSettings toolSettings, int[] noWarn) : DotNetCleanSettings
- SetNoWarns(this DotNetCleanSettings toolSettings, IEnumerable<int> noWarn) : DotNetCleanSettings
- SetOutput(this DotNetCleanSettings toolSettings, string output) : DotNetCleanSettings
- SetPackageIconUrl(this DotNetCleanSettings toolSettings, string packageIconUrl) : DotNetCleanSettings
- SetPackageId(this DotNetCleanSettings toolSettings, string packageId) : DotNetCleanSettings
- SetPackageLicenseUrl(this DotNetCleanSettings toolSettings, string packageLicenseUrl) : DotNetCleanSettings
- SetPackageProjectUrl(this DotNetCleanSettings toolSettings, string packageProjectUrl) : DotNetCleanSettings
- SetPackageReleaseNotes(this DotNetCleanSettings toolSettings, string packageReleaseNotes) : DotNetCleanSettings
- SetPackageRequireLicenseAcceptance(this DotNetCleanSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetCleanSettings
- SetPackageTags(this DotNetCleanSettings toolSettings, string[] packageTags) : DotNetCleanSettings
- SetPackageTags(this DotNetCleanSettings toolSettings, IEnumerable<string> packageTags) : DotNetCleanSettings
- SetProject(this DotNetCleanSettings toolSettings, string project) : DotNetCleanSettings
- SetProperties(this DotNetCleanSettings toolSettings, IDictionary<string, object> properties) : DotNetCleanSettings
- SetProperty(this DotNetCleanSettings toolSettings, string propertyKey, object propertyValue) : DotNetCleanSettings
- SetRepositoryType(this DotNetCleanSettings toolSettings, string repositoryType) : DotNetCleanSettings
- SetRepositoryUrl(this DotNetCleanSettings toolSettings, string repositoryUrl) : DotNetCleanSettings
- SetRunCodeAnalysis(this DotNetCleanSettings toolSettings, bool? runCodeAnalysis) : DotNetCleanSettings
- SetRuntime(this DotNetCleanSettings toolSettings, string runtime) : DotNetCleanSettings
- SetSymbolPackageFormat(this DotNetCleanSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetCleanSettings
- SetTitle(this DotNetCleanSettings toolSettings, string title) : DotNetCleanSettings
- SetTreatWarningsAsErrors(this DotNetCleanSettings toolSettings, bool? treatWarningsAsErrors) : DotNetCleanSettings
- SetVerbosity(this DotNetCleanSettings toolSettings, DotNetVerbosity verbosity) : DotNetCleanSettings
- SetVersion(this DotNetCleanSettings toolSettings, string version) : DotNetCleanSettings
- SetVersionPrefix(this DotNetCleanSettings toolSettings, string versionPrefix) : DotNetCleanSettings
- SetWarningLevel(this DotNetCleanSettings toolSettings, int? warningLevel) : DotNetCleanSettings
- SetWarningsAsErrors(this DotNetCleanSettings toolSettings, int[] warningsAsErrors) : DotNetCleanSettings
- SetWarningsAsErrors(this DotNetCleanSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetCleanSettings
- TogglePackageRequireLicenseAcceptance(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ToggleRunCodeAnalysis(this DotNetCleanSettings toolSettings) : DotNetCleanSettings
- ToggleTreatWarningsAsErrors(this DotNetCleanSettings toolSettings) : DotNetCleanSettings

### Nuke.Common.Tools.DotNet.DotNetNuGetPushSettings

- .ctor()
- get_ApiKey() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableBuffering() : bool?
- get_ForceEnglishOutput() : bool?
- get_NoSymbols() : bool?
- get_Source() : string
- get_SymbolApiKey() : string
- get_SymbolSource() : string
- get_TargetPath() : string
- get_Timeout() : int?
- get_ToolPath() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetNuGetPushSettingsExtensions

- DisableDisableBuffering(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- DisableForceEnglishOutput(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- DisableNoSymbols(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- EnableDisableBuffering(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- EnableForceEnglishOutput(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- EnableNoSymbols(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetApiKey(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetDisableBuffering(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetForceEnglishOutput(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetNoSymbols(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetSource(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetSymbolApiKey(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetSymbolSource(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetTargetPath(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ResetTimeout(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- SetApiKey(this DotNetNuGetPushSettings toolSettings, string apiKey) : DotNetNuGetPushSettings
- SetDisableBuffering(this DotNetNuGetPushSettings toolSettings, bool? disableBuffering) : DotNetNuGetPushSettings
- SetForceEnglishOutput(this DotNetNuGetPushSettings toolSettings, bool? forceEnglishOutput) : DotNetNuGetPushSettings
- SetNoSymbols(this DotNetNuGetPushSettings toolSettings, bool? noSymbols) : DotNetNuGetPushSettings
- SetSource(this DotNetNuGetPushSettings toolSettings, string source) : DotNetNuGetPushSettings
- SetSymbolApiKey(this DotNetNuGetPushSettings toolSettings, string symbolApiKey) : DotNetNuGetPushSettings
- SetSymbolSource(this DotNetNuGetPushSettings toolSettings, string symbolSource) : DotNetNuGetPushSettings
- SetTargetPath(this DotNetNuGetPushSettings toolSettings, string targetPath) : DotNetNuGetPushSettings
- SetTimeout(this DotNetNuGetPushSettings toolSettings, int? timeout) : DotNetNuGetPushSettings
- ToggleDisableBuffering(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ToggleForceEnglishOutput(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings
- ToggleNoSymbols(this DotNetNuGetPushSettings toolSettings) : DotNetNuGetPushSettings

### Nuke.Common.Tools.DotNet.DotNetPackSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableParallel() : bool?
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_IgnoreFailedSources() : bool?
- get_IncludeSource() : bool?
- get_IncludeSymbols() : bool?
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_NoBuild() : bool?
- get_NoCache() : bool?
- get_NoDependencies() : bool?
- get_NoRestore() : bool?
- get_OutputDirectory() : string
- get_PackageDirectory() : string
- get_Project() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_Serviceable() : bool?
- get_Sources() : IReadOnlyList<string>
- get_ToolPath() : string
- get_UseLockFile() : bool?
- get_Verbostiy() : DotNetVerbosity
- get_VersionSuffix() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetPackSettingsExtensions

- AddAuthors(this DotNetPackSettings toolSettings, string[] authors) : DotNetPackSettings
- AddAuthors(this DotNetPackSettings toolSettings, IEnumerable<string> authors) : DotNetPackSettings
- AddNoWarns(this DotNetPackSettings toolSettings, int[] noWarn) : DotNetPackSettings
- AddNoWarns(this DotNetPackSettings toolSettings, IEnumerable<int> noWarn) : DotNetPackSettings
- AddPackageTags(this DotNetPackSettings toolSettings, string[] packageTags) : DotNetPackSettings
- AddPackageTags(this DotNetPackSettings toolSettings, IEnumerable<string> packageTags) : DotNetPackSettings
- AddProperty(this DotNetPackSettings toolSettings, string propertyKey, object propertyValue) : DotNetPackSettings
- AddSources(this DotNetPackSettings toolSettings, string[] sources) : DotNetPackSettings
- AddSources(this DotNetPackSettings toolSettings, IEnumerable<string> sources) : DotNetPackSettings
- AddWarningsAsErrors(this DotNetPackSettings toolSettings, int[] warningsAsErrors) : DotNetPackSettings
- AddWarningsAsErrors(this DotNetPackSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPackSettings
- ClearAuthors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ClearNoWarns(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ClearPackageTags(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ClearProperties(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ClearSources(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ClearWarningsAsErrors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableDisableParallel(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableForce(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableForceEvaluate(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableIgnoreFailedSources(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableIncludeSource(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableIncludeSymbols(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableLockedMode(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableNoBuild(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableNoCache(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableNoDependencies(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableNoRestore(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisablePackageRequireLicenseAcceptance(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableRunCodeAnalysis(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableServiceable(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableTreatWarningsAsErrors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- DisableUseLockFile(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableDisableParallel(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableForce(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableForceEvaluate(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableIgnoreFailedSources(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableIncludeSource(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableIncludeSymbols(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableLockedMode(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableNoBuild(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableNoCache(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableNoDependencies(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableNoRestore(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnablePackageRequireLicenseAcceptance(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableRunCodeAnalysis(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableServiceable(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableTreatWarningsAsErrors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- EnableUseLockFile(this DotNetPackSettings toolSettings) : DotNetPackSettings
- RemoveAuthors(this DotNetPackSettings toolSettings, string[] authors) : DotNetPackSettings
- RemoveAuthors(this DotNetPackSettings toolSettings, IEnumerable<string> authors) : DotNetPackSettings
- RemoveNoWarns(this DotNetPackSettings toolSettings, int[] noWarn) : DotNetPackSettings
- RemoveNoWarns(this DotNetPackSettings toolSettings, IEnumerable<int> noWarn) : DotNetPackSettings
- RemovePackageTags(this DotNetPackSettings toolSettings, string[] packageTags) : DotNetPackSettings
- RemovePackageTags(this DotNetPackSettings toolSettings, IEnumerable<string> packageTags) : DotNetPackSettings
- RemoveProperty(this DotNetPackSettings toolSettings, string propertyKey) : DotNetPackSettings
- RemoveSources(this DotNetPackSettings toolSettings, string[] sources) : DotNetPackSettings
- RemoveSources(this DotNetPackSettings toolSettings, IEnumerable<string> sources) : DotNetPackSettings
- RemoveWarningsAsErrors(this DotNetPackSettings toolSettings, int[] warningsAsErrors) : DotNetPackSettings
- RemoveWarningsAsErrors(this DotNetPackSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPackSettings
- ResetAssemblyVersion(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetConfiguration(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetCopyright(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetDescription(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetDisableParallel(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetFileVersion(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetForce(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetForceEvaluate(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetIgnoreFailedSources(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetIncludeSource(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetIncludeSymbols(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetInformationalVersion(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetLockedMode(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetLockFilePath(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetNoBuild(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetNoCache(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetNoDependencies(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetNoRestore(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetOutputDirectory(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageDirectory(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageIconUrl(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageId(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageLicenseUrl(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageProjectUrl(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageReleaseNotes(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetPackageRequireLicenseAcceptance(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetProject(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetRepositoryType(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetRepositoryUrl(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetRunCodeAnalysis(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetRuntime(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetServiceable(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetSymbolPackageFormat(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetTitle(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetTreatWarningsAsErrors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetUseLockFile(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetVerbostiy(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetVersion(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetVersionPrefix(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetVersionSuffix(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ResetWarningLevel(this DotNetPackSettings toolSettings) : DotNetPackSettings
- SetAssemblyVersion(this DotNetPackSettings toolSettings, string assemblyVersion) : DotNetPackSettings
- SetAuthors(this DotNetPackSettings toolSettings, string[] authors) : DotNetPackSettings
- SetAuthors(this DotNetPackSettings toolSettings, IEnumerable<string> authors) : DotNetPackSettings
- SetConfiguration(this DotNetPackSettings toolSettings, string configuration) : DotNetPackSettings
- SetCopyright(this DotNetPackSettings toolSettings, string copyright) : DotNetPackSettings
- SetDescription(this DotNetPackSettings toolSettings, string description) : DotNetPackSettings
- SetDisableParallel(this DotNetPackSettings toolSettings, bool? disableParallel) : DotNetPackSettings
- SetFileVersion(this DotNetPackSettings toolSettings, string fileVersion) : DotNetPackSettings
- SetForce(this DotNetPackSettings toolSettings, bool? force) : DotNetPackSettings
- SetForceEvaluate(this DotNetPackSettings toolSettings, bool? forceEvaluate) : DotNetPackSettings
- SetIgnoreFailedSources(this DotNetPackSettings toolSettings, bool? ignoreFailedSources) : DotNetPackSettings
- SetIncludeSource(this DotNetPackSettings toolSettings, bool? includeSource) : DotNetPackSettings
- SetIncludeSymbols(this DotNetPackSettings toolSettings, bool? includeSymbols) : DotNetPackSettings
- SetInformationalVersion(this DotNetPackSettings toolSettings, string informationalVersion) : DotNetPackSettings
- SetLockedMode(this DotNetPackSettings toolSettings, bool? lockedMode) : DotNetPackSettings
- SetLockFilePath(this DotNetPackSettings toolSettings, string lockFilePath) : DotNetPackSettings
- SetNoBuild(this DotNetPackSettings toolSettings, bool? noBuild) : DotNetPackSettings
- SetNoCache(this DotNetPackSettings toolSettings, bool? noCache) : DotNetPackSettings
- SetNoDependencies(this DotNetPackSettings toolSettings, bool? noDependencies) : DotNetPackSettings
- SetNoRestore(this DotNetPackSettings toolSettings, bool? noRestore) : DotNetPackSettings
- SetNoWarns(this DotNetPackSettings toolSettings, int[] noWarn) : DotNetPackSettings
- SetNoWarns(this DotNetPackSettings toolSettings, IEnumerable<int> noWarn) : DotNetPackSettings
- SetOutputDirectory(this DotNetPackSettings toolSettings, string outputDirectory) : DotNetPackSettings
- SetPackageDirectory(this DotNetPackSettings toolSettings, string packageDirectory) : DotNetPackSettings
- SetPackageIconUrl(this DotNetPackSettings toolSettings, string packageIconUrl) : DotNetPackSettings
- SetPackageId(this DotNetPackSettings toolSettings, string packageId) : DotNetPackSettings
- SetPackageLicenseUrl(this DotNetPackSettings toolSettings, string packageLicenseUrl) : DotNetPackSettings
- SetPackageProjectUrl(this DotNetPackSettings toolSettings, string packageProjectUrl) : DotNetPackSettings
- SetPackageReleaseNotes(this DotNetPackSettings toolSettings, string packageReleaseNotes) : DotNetPackSettings
- SetPackageRequireLicenseAcceptance(this DotNetPackSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetPackSettings
- SetPackageTags(this DotNetPackSettings toolSettings, string[] packageTags) : DotNetPackSettings
- SetPackageTags(this DotNetPackSettings toolSettings, IEnumerable<string> packageTags) : DotNetPackSettings
- SetProject(this DotNetPackSettings toolSettings, string project) : DotNetPackSettings
- SetProperties(this DotNetPackSettings toolSettings, IDictionary<string, object> properties) : DotNetPackSettings
- SetProperty(this DotNetPackSettings toolSettings, string propertyKey, object propertyValue) : DotNetPackSettings
- SetRepositoryType(this DotNetPackSettings toolSettings, string repositoryType) : DotNetPackSettings
- SetRepositoryUrl(this DotNetPackSettings toolSettings, string repositoryUrl) : DotNetPackSettings
- SetRunCodeAnalysis(this DotNetPackSettings toolSettings, bool? runCodeAnalysis) : DotNetPackSettings
- SetRuntime(this DotNetPackSettings toolSettings, string runtime) : DotNetPackSettings
- SetServiceable(this DotNetPackSettings toolSettings, bool? serviceable) : DotNetPackSettings
- SetSources(this DotNetPackSettings toolSettings, string[] sources) : DotNetPackSettings
- SetSources(this DotNetPackSettings toolSettings, IEnumerable<string> sources) : DotNetPackSettings
- SetSymbolPackageFormat(this DotNetPackSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetPackSettings
- SetTitle(this DotNetPackSettings toolSettings, string title) : DotNetPackSettings
- SetTreatWarningsAsErrors(this DotNetPackSettings toolSettings, bool? treatWarningsAsErrors) : DotNetPackSettings
- SetUseLockFile(this DotNetPackSettings toolSettings, bool? useLockFile) : DotNetPackSettings
- SetVerbostiy(this DotNetPackSettings toolSettings, DotNetVerbosity verbostiy) : DotNetPackSettings
- SetVersion(this DotNetPackSettings toolSettings, string version) : DotNetPackSettings
- SetVersionPrefix(this DotNetPackSettings toolSettings, string versionPrefix) : DotNetPackSettings
- SetVersionSuffix(this DotNetPackSettings toolSettings, string versionSuffix) : DotNetPackSettings
- SetWarningLevel(this DotNetPackSettings toolSettings, int? warningLevel) : DotNetPackSettings
- SetWarningsAsErrors(this DotNetPackSettings toolSettings, int[] warningsAsErrors) : DotNetPackSettings
- SetWarningsAsErrors(this DotNetPackSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPackSettings
- ToggleDisableParallel(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleForce(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleForceEvaluate(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleIgnoreFailedSources(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleIncludeSource(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleIncludeSymbols(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleLockedMode(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleNoBuild(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleNoCache(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleNoDependencies(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleNoRestore(this DotNetPackSettings toolSettings) : DotNetPackSettings
- TogglePackageRequireLicenseAcceptance(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleRunCodeAnalysis(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleServiceable(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleTreatWarningsAsErrors(this DotNetPackSettings toolSettings) : DotNetPackSettings
- ToggleUseLockFile(this DotNetPackSettings toolSettings) : DotNetPackSettings

### Nuke.Common.Tools.DotNet.DotNetPublishSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableParallel() : bool?
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_Framework() : string
- get_IgnoreFailedSources() : bool?
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_Manifest() : string
- get_NoBuild() : bool?
- get_NoCache() : bool?
- get_NoDependencies() : bool?
- get_NoRestore() : bool?
- get_Output() : string
- get_PackageDirectory() : string
- get_Project() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_SelfContained() : bool?
- get_Sources() : IReadOnlyList<string>
- get_ToolPath() : string
- get_UseLockFile() : bool?
- get_Verbosity() : DotNetVerbosity
- get_VersionSuffix() : string
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetPublishSettingsExtensions

- AddAuthors(this DotNetPublishSettings toolSettings, string[] authors) : DotNetPublishSettings
- AddAuthors(this DotNetPublishSettings toolSettings, IEnumerable<string> authors) : DotNetPublishSettings
- AddNoWarns(this DotNetPublishSettings toolSettings, int[] noWarn) : DotNetPublishSettings
- AddNoWarns(this DotNetPublishSettings toolSettings, IEnumerable<int> noWarn) : DotNetPublishSettings
- AddPackageTags(this DotNetPublishSettings toolSettings, string[] packageTags) : DotNetPublishSettings
- AddPackageTags(this DotNetPublishSettings toolSettings, IEnumerable<string> packageTags) : DotNetPublishSettings
- AddProperty(this DotNetPublishSettings toolSettings, string propertyKey, object propertyValue) : DotNetPublishSettings
- AddSources(this DotNetPublishSettings toolSettings, string[] sources) : DotNetPublishSettings
- AddSources(this DotNetPublishSettings toolSettings, IEnumerable<string> sources) : DotNetPublishSettings
- AddWarningsAsErrors(this DotNetPublishSettings toolSettings, int[] warningsAsErrors) : DotNetPublishSettings
- AddWarningsAsErrors(this DotNetPublishSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPublishSettings
- ClearAuthors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ClearNoWarns(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ClearPackageTags(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ClearProperties(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ClearSources(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ClearWarningsAsErrors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableDisableParallel(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableForce(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableForceEvaluate(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableIgnoreFailedSources(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableLockedMode(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableNoBuild(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableNoCache(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableNoDependencies(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableNoRestore(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisablePackageRequireLicenseAcceptance(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableRunCodeAnalysis(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableSelfContained(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableTreatWarningsAsErrors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- DisableUseLockFile(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableDisableParallel(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableForce(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableForceEvaluate(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableIgnoreFailedSources(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableLockedMode(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableNoBuild(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableNoCache(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableNoDependencies(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableNoRestore(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnablePackageRequireLicenseAcceptance(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableRunCodeAnalysis(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableSelfContained(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableTreatWarningsAsErrors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- EnableUseLockFile(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- RemoveAuthors(this DotNetPublishSettings toolSettings, string[] authors) : DotNetPublishSettings
- RemoveAuthors(this DotNetPublishSettings toolSettings, IEnumerable<string> authors) : DotNetPublishSettings
- RemoveNoWarns(this DotNetPublishSettings toolSettings, int[] noWarn) : DotNetPublishSettings
- RemoveNoWarns(this DotNetPublishSettings toolSettings, IEnumerable<int> noWarn) : DotNetPublishSettings
- RemovePackageTags(this DotNetPublishSettings toolSettings, string[] packageTags) : DotNetPublishSettings
- RemovePackageTags(this DotNetPublishSettings toolSettings, IEnumerable<string> packageTags) : DotNetPublishSettings
- RemoveProperty(this DotNetPublishSettings toolSettings, string propertyKey) : DotNetPublishSettings
- RemoveSources(this DotNetPublishSettings toolSettings, string[] sources) : DotNetPublishSettings
- RemoveSources(this DotNetPublishSettings toolSettings, IEnumerable<string> sources) : DotNetPublishSettings
- RemoveWarningsAsErrors(this DotNetPublishSettings toolSettings, int[] warningsAsErrors) : DotNetPublishSettings
- RemoveWarningsAsErrors(this DotNetPublishSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPublishSettings
- ResetAssemblyVersion(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetConfiguration(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetCopyright(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetDescription(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetDisableParallel(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetFileVersion(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetForce(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetForceEvaluate(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetFramework(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetIgnoreFailedSources(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetInformationalVersion(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetLockedMode(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetLockFilePath(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetManifest(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetNoBuild(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetNoCache(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetNoDependencies(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetNoRestore(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetOutput(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageDirectory(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageIconUrl(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageId(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageLicenseUrl(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageProjectUrl(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageReleaseNotes(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetPackageRequireLicenseAcceptance(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetProject(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetRepositoryType(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetRepositoryUrl(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetRunCodeAnalysis(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetRuntime(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetSelfContained(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetSymbolPackageFormat(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetTitle(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetTreatWarningsAsErrors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetUseLockFile(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetVerbosity(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetVersion(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetVersionPrefix(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetVersionSuffix(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ResetWarningLevel(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- SetAssemblyVersion(this DotNetPublishSettings toolSettings, string assemblyVersion) : DotNetPublishSettings
- SetAuthors(this DotNetPublishSettings toolSettings, string[] authors) : DotNetPublishSettings
- SetAuthors(this DotNetPublishSettings toolSettings, IEnumerable<string> authors) : DotNetPublishSettings
- SetConfiguration(this DotNetPublishSettings toolSettings, string configuration) : DotNetPublishSettings
- SetCopyright(this DotNetPublishSettings toolSettings, string copyright) : DotNetPublishSettings
- SetDescription(this DotNetPublishSettings toolSettings, string description) : DotNetPublishSettings
- SetDisableParallel(this DotNetPublishSettings toolSettings, bool? disableParallel) : DotNetPublishSettings
- SetFileVersion(this DotNetPublishSettings toolSettings, string fileVersion) : DotNetPublishSettings
- SetForce(this DotNetPublishSettings toolSettings, bool? force) : DotNetPublishSettings
- SetForceEvaluate(this DotNetPublishSettings toolSettings, bool? forceEvaluate) : DotNetPublishSettings
- SetFramework(this DotNetPublishSettings toolSettings, string framework) : DotNetPublishSettings
- SetIgnoreFailedSources(this DotNetPublishSettings toolSettings, bool? ignoreFailedSources) : DotNetPublishSettings
- SetInformationalVersion(this DotNetPublishSettings toolSettings, string informationalVersion) : DotNetPublishSettings
- SetLockedMode(this DotNetPublishSettings toolSettings, bool? lockedMode) : DotNetPublishSettings
- SetLockFilePath(this DotNetPublishSettings toolSettings, string lockFilePath) : DotNetPublishSettings
- SetManifest(this DotNetPublishSettings toolSettings, string manifest) : DotNetPublishSettings
- SetNoBuild(this DotNetPublishSettings toolSettings, bool? noBuild) : DotNetPublishSettings
- SetNoCache(this DotNetPublishSettings toolSettings, bool? noCache) : DotNetPublishSettings
- SetNoDependencies(this DotNetPublishSettings toolSettings, bool? noDependencies) : DotNetPublishSettings
- SetNoRestore(this DotNetPublishSettings toolSettings, bool? noRestore) : DotNetPublishSettings
- SetNoWarns(this DotNetPublishSettings toolSettings, int[] noWarn) : DotNetPublishSettings
- SetNoWarns(this DotNetPublishSettings toolSettings, IEnumerable<int> noWarn) : DotNetPublishSettings
- SetOutput(this DotNetPublishSettings toolSettings, string output) : DotNetPublishSettings
- SetPackageDirectory(this DotNetPublishSettings toolSettings, string packageDirectory) : DotNetPublishSettings
- SetPackageIconUrl(this DotNetPublishSettings toolSettings, string packageIconUrl) : DotNetPublishSettings
- SetPackageId(this DotNetPublishSettings toolSettings, string packageId) : DotNetPublishSettings
- SetPackageLicenseUrl(this DotNetPublishSettings toolSettings, string packageLicenseUrl) : DotNetPublishSettings
- SetPackageProjectUrl(this DotNetPublishSettings toolSettings, string packageProjectUrl) : DotNetPublishSettings
- SetPackageReleaseNotes(this DotNetPublishSettings toolSettings, string packageReleaseNotes) : DotNetPublishSettings
- SetPackageRequireLicenseAcceptance(this DotNetPublishSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetPublishSettings
- SetPackageTags(this DotNetPublishSettings toolSettings, string[] packageTags) : DotNetPublishSettings
- SetPackageTags(this DotNetPublishSettings toolSettings, IEnumerable<string> packageTags) : DotNetPublishSettings
- SetProject(this DotNetPublishSettings toolSettings, string project) : DotNetPublishSettings
- SetProperties(this DotNetPublishSettings toolSettings, IDictionary<string, object> properties) : DotNetPublishSettings
- SetProperty(this DotNetPublishSettings toolSettings, string propertyKey, object propertyValue) : DotNetPublishSettings
- SetRepositoryType(this DotNetPublishSettings toolSettings, string repositoryType) : DotNetPublishSettings
- SetRepositoryUrl(this DotNetPublishSettings toolSettings, string repositoryUrl) : DotNetPublishSettings
- SetRunCodeAnalysis(this DotNetPublishSettings toolSettings, bool? runCodeAnalysis) : DotNetPublishSettings
- SetRuntime(this DotNetPublishSettings toolSettings, string runtime) : DotNetPublishSettings
- SetSelfContained(this DotNetPublishSettings toolSettings, bool? selfContained) : DotNetPublishSettings
- SetSources(this DotNetPublishSettings toolSettings, string[] sources) : DotNetPublishSettings
- SetSources(this DotNetPublishSettings toolSettings, IEnumerable<string> sources) : DotNetPublishSettings
- SetSymbolPackageFormat(this DotNetPublishSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetPublishSettings
- SetTitle(this DotNetPublishSettings toolSettings, string title) : DotNetPublishSettings
- SetTreatWarningsAsErrors(this DotNetPublishSettings toolSettings, bool? treatWarningsAsErrors) : DotNetPublishSettings
- SetUseLockFile(this DotNetPublishSettings toolSettings, bool? useLockFile) : DotNetPublishSettings
- SetVerbosity(this DotNetPublishSettings toolSettings, DotNetVerbosity verbosity) : DotNetPublishSettings
- SetVersion(this DotNetPublishSettings toolSettings, string version) : DotNetPublishSettings
- SetVersionPrefix(this DotNetPublishSettings toolSettings, string versionPrefix) : DotNetPublishSettings
- SetVersionSuffix(this DotNetPublishSettings toolSettings, string versionSuffix) : DotNetPublishSettings
- SetWarningLevel(this DotNetPublishSettings toolSettings, int? warningLevel) : DotNetPublishSettings
- SetWarningsAsErrors(this DotNetPublishSettings toolSettings, int[] warningsAsErrors) : DotNetPublishSettings
- SetWarningsAsErrors(this DotNetPublishSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetPublishSettings
- ToggleDisableParallel(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleForce(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleForceEvaluate(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleIgnoreFailedSources(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleLockedMode(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleNoBuild(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleNoCache(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleNoDependencies(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleNoRestore(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- TogglePackageRequireLicenseAcceptance(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleRunCodeAnalysis(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleSelfContained(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleTreatWarningsAsErrors(this DotNetPublishSettings toolSettings) : DotNetPublishSettings
- ToggleUseLockFile(this DotNetPublishSettings toolSettings) : DotNetPublishSettings

### Nuke.Common.Tools.DotNet.DotNetRestoreSettings

- .ctor()
- get_ConfigFile() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableParallel() : bool?
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_IgnoreFailedSources() : bool?
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_NoCache() : bool?
- get_NoDependencies() : bool?
- get_PackageDirectory() : string
- get_ProjectFile() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_Sources() : IReadOnlyList<string>
- get_ToolPath() : string
- get_UseLockFile() : bool?
- get_Verbosity() : DotNetVerbosity
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetRestoreSettingsExtensions

- AddAuthors(this DotNetRestoreSettings toolSettings, string[] authors) : DotNetRestoreSettings
- AddAuthors(this DotNetRestoreSettings toolSettings, IEnumerable<string> authors) : DotNetRestoreSettings
- AddNoWarns(this DotNetRestoreSettings toolSettings, int[] noWarn) : DotNetRestoreSettings
- AddNoWarns(this DotNetRestoreSettings toolSettings, IEnumerable<int> noWarn) : DotNetRestoreSettings
- AddPackageTags(this DotNetRestoreSettings toolSettings, string[] packageTags) : DotNetRestoreSettings
- AddPackageTags(this DotNetRestoreSettings toolSettings, IEnumerable<string> packageTags) : DotNetRestoreSettings
- AddProperty(this DotNetRestoreSettings toolSettings, string propertyKey, object propertyValue) : DotNetRestoreSettings
- AddSources(this DotNetRestoreSettings toolSettings, string[] sources) : DotNetRestoreSettings
- AddSources(this DotNetRestoreSettings toolSettings, IEnumerable<string> sources) : DotNetRestoreSettings
- AddWarningsAsErrors(this DotNetRestoreSettings toolSettings, int[] warningsAsErrors) : DotNetRestoreSettings
- AddWarningsAsErrors(this DotNetRestoreSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRestoreSettings
- ClearAuthors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ClearNoWarns(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ClearPackageTags(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ClearProperties(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ClearSources(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ClearWarningsAsErrors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableDisableParallel(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableForce(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableForceEvaluate(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableIgnoreFailedSources(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableLockedMode(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableNoCache(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableNoDependencies(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisablePackageRequireLicenseAcceptance(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableRunCodeAnalysis(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableTreatWarningsAsErrors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- DisableUseLockFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableDisableParallel(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableForce(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableForceEvaluate(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableIgnoreFailedSources(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableLockedMode(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableNoCache(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableNoDependencies(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnablePackageRequireLicenseAcceptance(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableRunCodeAnalysis(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableTreatWarningsAsErrors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- EnableUseLockFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- RemoveAuthors(this DotNetRestoreSettings toolSettings, string[] authors) : DotNetRestoreSettings
- RemoveAuthors(this DotNetRestoreSettings toolSettings, IEnumerable<string> authors) : DotNetRestoreSettings
- RemoveNoWarns(this DotNetRestoreSettings toolSettings, int[] noWarn) : DotNetRestoreSettings
- RemoveNoWarns(this DotNetRestoreSettings toolSettings, IEnumerable<int> noWarn) : DotNetRestoreSettings
- RemovePackageTags(this DotNetRestoreSettings toolSettings, string[] packageTags) : DotNetRestoreSettings
- RemovePackageTags(this DotNetRestoreSettings toolSettings, IEnumerable<string> packageTags) : DotNetRestoreSettings
- RemoveProperty(this DotNetRestoreSettings toolSettings, string propertyKey) : DotNetRestoreSettings
- RemoveSources(this DotNetRestoreSettings toolSettings, string[] sources) : DotNetRestoreSettings
- RemoveSources(this DotNetRestoreSettings toolSettings, IEnumerable<string> sources) : DotNetRestoreSettings
- RemoveWarningsAsErrors(this DotNetRestoreSettings toolSettings, int[] warningsAsErrors) : DotNetRestoreSettings
- RemoveWarningsAsErrors(this DotNetRestoreSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRestoreSettings
- ResetAssemblyVersion(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetConfigFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetCopyright(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetDescription(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetDisableParallel(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetFileVersion(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetForce(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetForceEvaluate(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetIgnoreFailedSources(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetInformationalVersion(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetLockedMode(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetLockFilePath(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetNoCache(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetNoDependencies(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageDirectory(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageIconUrl(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageId(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageLicenseUrl(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageProjectUrl(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageReleaseNotes(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetPackageRequireLicenseAcceptance(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetProjectFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetRepositoryType(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetRepositoryUrl(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetRunCodeAnalysis(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetRuntime(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetSymbolPackageFormat(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetTitle(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetTreatWarningsAsErrors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetUseLockFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetVerbosity(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetVersion(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetVersionPrefix(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ResetWarningLevel(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- SetAssemblyVersion(this DotNetRestoreSettings toolSettings, string assemblyVersion) : DotNetRestoreSettings
- SetAuthors(this DotNetRestoreSettings toolSettings, string[] authors) : DotNetRestoreSettings
- SetAuthors(this DotNetRestoreSettings toolSettings, IEnumerable<string> authors) : DotNetRestoreSettings
- SetConfigFile(this DotNetRestoreSettings toolSettings, string configFile) : DotNetRestoreSettings
- SetCopyright(this DotNetRestoreSettings toolSettings, string copyright) : DotNetRestoreSettings
- SetDescription(this DotNetRestoreSettings toolSettings, string description) : DotNetRestoreSettings
- SetDisableParallel(this DotNetRestoreSettings toolSettings, bool? disableParallel) : DotNetRestoreSettings
- SetFileVersion(this DotNetRestoreSettings toolSettings, string fileVersion) : DotNetRestoreSettings
- SetForce(this DotNetRestoreSettings toolSettings, bool? force) : DotNetRestoreSettings
- SetForceEvaluate(this DotNetRestoreSettings toolSettings, bool? forceEvaluate) : DotNetRestoreSettings
- SetIgnoreFailedSources(this DotNetRestoreSettings toolSettings, bool? ignoreFailedSources) : DotNetRestoreSettings
- SetInformationalVersion(this DotNetRestoreSettings toolSettings, string informationalVersion) : DotNetRestoreSettings
- SetLockedMode(this DotNetRestoreSettings toolSettings, bool? lockedMode) : DotNetRestoreSettings
- SetLockFilePath(this DotNetRestoreSettings toolSettings, string lockFilePath) : DotNetRestoreSettings
- SetNoCache(this DotNetRestoreSettings toolSettings, bool? noCache) : DotNetRestoreSettings
- SetNoDependencies(this DotNetRestoreSettings toolSettings, bool? noDependencies) : DotNetRestoreSettings
- SetNoWarns(this DotNetRestoreSettings toolSettings, int[] noWarn) : DotNetRestoreSettings
- SetNoWarns(this DotNetRestoreSettings toolSettings, IEnumerable<int> noWarn) : DotNetRestoreSettings
- SetPackageDirectory(this DotNetRestoreSettings toolSettings, string packageDirectory) : DotNetRestoreSettings
- SetPackageIconUrl(this DotNetRestoreSettings toolSettings, string packageIconUrl) : DotNetRestoreSettings
- SetPackageId(this DotNetRestoreSettings toolSettings, string packageId) : DotNetRestoreSettings
- SetPackageLicenseUrl(this DotNetRestoreSettings toolSettings, string packageLicenseUrl) : DotNetRestoreSettings
- SetPackageProjectUrl(this DotNetRestoreSettings toolSettings, string packageProjectUrl) : DotNetRestoreSettings
- SetPackageReleaseNotes(this DotNetRestoreSettings toolSettings, string packageReleaseNotes) : DotNetRestoreSettings
- SetPackageRequireLicenseAcceptance(this DotNetRestoreSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetRestoreSettings
- SetPackageTags(this DotNetRestoreSettings toolSettings, string[] packageTags) : DotNetRestoreSettings
- SetPackageTags(this DotNetRestoreSettings toolSettings, IEnumerable<string> packageTags) : DotNetRestoreSettings
- SetProjectFile(this DotNetRestoreSettings toolSettings, string projectFile) : DotNetRestoreSettings
- SetProperties(this DotNetRestoreSettings toolSettings, IDictionary<string, object> properties) : DotNetRestoreSettings
- SetProperty(this DotNetRestoreSettings toolSettings, string propertyKey, object propertyValue) : DotNetRestoreSettings
- SetRepositoryType(this DotNetRestoreSettings toolSettings, string repositoryType) : DotNetRestoreSettings
- SetRepositoryUrl(this DotNetRestoreSettings toolSettings, string repositoryUrl) : DotNetRestoreSettings
- SetRunCodeAnalysis(this DotNetRestoreSettings toolSettings, bool? runCodeAnalysis) : DotNetRestoreSettings
- SetRuntime(this DotNetRestoreSettings toolSettings, string runtime) : DotNetRestoreSettings
- SetSources(this DotNetRestoreSettings toolSettings, string[] sources) : DotNetRestoreSettings
- SetSources(this DotNetRestoreSettings toolSettings, IEnumerable<string> sources) : DotNetRestoreSettings
- SetSymbolPackageFormat(this DotNetRestoreSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetRestoreSettings
- SetTitle(this DotNetRestoreSettings toolSettings, string title) : DotNetRestoreSettings
- SetTreatWarningsAsErrors(this DotNetRestoreSettings toolSettings, bool? treatWarningsAsErrors) : DotNetRestoreSettings
- SetUseLockFile(this DotNetRestoreSettings toolSettings, bool? useLockFile) : DotNetRestoreSettings
- SetVerbosity(this DotNetRestoreSettings toolSettings, DotNetVerbosity verbosity) : DotNetRestoreSettings
- SetVersion(this DotNetRestoreSettings toolSettings, string version) : DotNetRestoreSettings
- SetVersionPrefix(this DotNetRestoreSettings toolSettings, string versionPrefix) : DotNetRestoreSettings
- SetWarningLevel(this DotNetRestoreSettings toolSettings, int? warningLevel) : DotNetRestoreSettings
- SetWarningsAsErrors(this DotNetRestoreSettings toolSettings, int[] warningsAsErrors) : DotNetRestoreSettings
- SetWarningsAsErrors(this DotNetRestoreSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRestoreSettings
- ToggleDisableParallel(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleForce(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleForceEvaluate(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleIgnoreFailedSources(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleLockedMode(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleNoCache(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleNoDependencies(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- TogglePackageRequireLicenseAcceptance(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleRunCodeAnalysis(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleTreatWarningsAsErrors(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings
- ToggleUseLockFile(this DotNetRestoreSettings toolSettings) : DotNetRestoreSettings

### Nuke.Common.Tools.DotNet.DotNetRunSettings

- .ctor()
- get_ApplicationArguments() : string
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DisableParallel() : bool?
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_Framework() : string
- get_IgnoreFailedSources() : bool?
- get_LaunchProfile() : string
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_NoBuild() : bool?
- get_NoCache() : bool?
- get_NoDependencies() : bool?
- get_NoLaunchProfile() : bool?
- get_NoRestore() : bool?
- get_PackageDirectory() : string
- get_ProjectFile() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_Runtime() : string
- get_Sources() : IReadOnlyList<string>
- get_ToolPath() : string
- get_UseLockFile() : bool?
- ConfigureArguments(Arguments arguments) : Arguments

### Nuke.Common.Tools.DotNet.DotNetRunSettingsExtensions

- AddAuthors(this DotNetRunSettings toolSettings, string[] authors) : DotNetRunSettings
- AddAuthors(this DotNetRunSettings toolSettings, IEnumerable<string> authors) : DotNetRunSettings
- AddNoWarns(this DotNetRunSettings toolSettings, int[] noWarn) : DotNetRunSettings
- AddNoWarns(this DotNetRunSettings toolSettings, IEnumerable<int> noWarn) : DotNetRunSettings
- AddPackageTags(this DotNetRunSettings toolSettings, string[] packageTags) : DotNetRunSettings
- AddPackageTags(this DotNetRunSettings toolSettings, IEnumerable<string> packageTags) : DotNetRunSettings
- AddProperty(this DotNetRunSettings toolSettings, string propertyKey, object propertyValue) : DotNetRunSettings
- AddSources(this DotNetRunSettings toolSettings, string[] sources) : DotNetRunSettings
- AddSources(this DotNetRunSettings toolSettings, IEnumerable<string> sources) : DotNetRunSettings
- AddWarningsAsErrors(this DotNetRunSettings toolSettings, int[] warningsAsErrors) : DotNetRunSettings
- AddWarningsAsErrors(this DotNetRunSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRunSettings
- ClearAuthors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ClearNoWarns(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ClearPackageTags(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ClearProperties(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ClearSources(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ClearWarningsAsErrors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableDisableParallel(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableForce(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableForceEvaluate(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableIgnoreFailedSources(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableLockedMode(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableNoBuild(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableNoCache(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableNoDependencies(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableNoLaunchProfile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableNoRestore(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisablePackageRequireLicenseAcceptance(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableRunCodeAnalysis(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableTreatWarningsAsErrors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- DisableUseLockFile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableDisableParallel(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableForce(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableForceEvaluate(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableIgnoreFailedSources(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableLockedMode(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableNoBuild(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableNoCache(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableNoDependencies(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableNoLaunchProfile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableNoRestore(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnablePackageRequireLicenseAcceptance(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableRunCodeAnalysis(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableTreatWarningsAsErrors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- EnableUseLockFile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- RemoveAuthors(this DotNetRunSettings toolSettings, string[] authors) : DotNetRunSettings
- RemoveAuthors(this DotNetRunSettings toolSettings, IEnumerable<string> authors) : DotNetRunSettings
- RemoveNoWarns(this DotNetRunSettings toolSettings, int[] noWarn) : DotNetRunSettings
- RemoveNoWarns(this DotNetRunSettings toolSettings, IEnumerable<int> noWarn) : DotNetRunSettings
- RemovePackageTags(this DotNetRunSettings toolSettings, string[] packageTags) : DotNetRunSettings
- RemovePackageTags(this DotNetRunSettings toolSettings, IEnumerable<string> packageTags) : DotNetRunSettings
- RemoveProperty(this DotNetRunSettings toolSettings, string propertyKey) : DotNetRunSettings
- RemoveSources(this DotNetRunSettings toolSettings, string[] sources) : DotNetRunSettings
- RemoveSources(this DotNetRunSettings toolSettings, IEnumerable<string> sources) : DotNetRunSettings
- RemoveWarningsAsErrors(this DotNetRunSettings toolSettings, int[] warningsAsErrors) : DotNetRunSettings
- RemoveWarningsAsErrors(this DotNetRunSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRunSettings
- ResetApplicationArguments(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetAssemblyVersion(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetConfiguration(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetCopyright(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetDescription(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetDisableParallel(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetFileVersion(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetForce(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetForceEvaluate(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetFramework(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetIgnoreFailedSources(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetInformationalVersion(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetLaunchProfile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetLockedMode(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetLockFilePath(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetNoBuild(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetNoCache(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetNoDependencies(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetNoLaunchProfile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetNoRestore(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageDirectory(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageIconUrl(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageId(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageLicenseUrl(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageProjectUrl(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageReleaseNotes(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetPackageRequireLicenseAcceptance(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetProjectFile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetRepositoryType(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetRepositoryUrl(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetRunCodeAnalysis(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetRuntime(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetSymbolPackageFormat(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetTitle(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetTreatWarningsAsErrors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetUseLockFile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetVersion(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetVersionPrefix(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ResetWarningLevel(this DotNetRunSettings toolSettings) : DotNetRunSettings
- SetApplicationArguments(this DotNetRunSettings toolSettings, string applicationArguments) : DotNetRunSettings
- SetAssemblyVersion(this DotNetRunSettings toolSettings, string assemblyVersion) : DotNetRunSettings
- SetAuthors(this DotNetRunSettings toolSettings, string[] authors) : DotNetRunSettings
- SetAuthors(this DotNetRunSettings toolSettings, IEnumerable<string> authors) : DotNetRunSettings
- SetConfiguration(this DotNetRunSettings toolSettings, string configuration) : DotNetRunSettings
- SetCopyright(this DotNetRunSettings toolSettings, string copyright) : DotNetRunSettings
- SetDescription(this DotNetRunSettings toolSettings, string description) : DotNetRunSettings
- SetDisableParallel(this DotNetRunSettings toolSettings, bool? disableParallel) : DotNetRunSettings
- SetFileVersion(this DotNetRunSettings toolSettings, string fileVersion) : DotNetRunSettings
- SetForce(this DotNetRunSettings toolSettings, bool? force) : DotNetRunSettings
- SetForceEvaluate(this DotNetRunSettings toolSettings, bool? forceEvaluate) : DotNetRunSettings
- SetFramework(this DotNetRunSettings toolSettings, string framework) : DotNetRunSettings
- SetIgnoreFailedSources(this DotNetRunSettings toolSettings, bool? ignoreFailedSources) : DotNetRunSettings
- SetInformationalVersion(this DotNetRunSettings toolSettings, string informationalVersion) : DotNetRunSettings
- SetLaunchProfile(this DotNetRunSettings toolSettings, string launchProfile) : DotNetRunSettings
- SetLockedMode(this DotNetRunSettings toolSettings, bool? lockedMode) : DotNetRunSettings
- SetLockFilePath(this DotNetRunSettings toolSettings, string lockFilePath) : DotNetRunSettings
- SetNoBuild(this DotNetRunSettings toolSettings, bool? noBuild) : DotNetRunSettings
- SetNoCache(this DotNetRunSettings toolSettings, bool? noCache) : DotNetRunSettings
- SetNoDependencies(this DotNetRunSettings toolSettings, bool? noDependencies) : DotNetRunSettings
- SetNoLaunchProfile(this DotNetRunSettings toolSettings, bool? noLaunchProfile) : DotNetRunSettings
- SetNoRestore(this DotNetRunSettings toolSettings, bool? noRestore) : DotNetRunSettings
- SetNoWarns(this DotNetRunSettings toolSettings, int[] noWarn) : DotNetRunSettings
- SetNoWarns(this DotNetRunSettings toolSettings, IEnumerable<int> noWarn) : DotNetRunSettings
- SetPackageDirectory(this DotNetRunSettings toolSettings, string packageDirectory) : DotNetRunSettings
- SetPackageIconUrl(this DotNetRunSettings toolSettings, string packageIconUrl) : DotNetRunSettings
- SetPackageId(this DotNetRunSettings toolSettings, string packageId) : DotNetRunSettings
- SetPackageLicenseUrl(this DotNetRunSettings toolSettings, string packageLicenseUrl) : DotNetRunSettings
- SetPackageProjectUrl(this DotNetRunSettings toolSettings, string packageProjectUrl) : DotNetRunSettings
- SetPackageReleaseNotes(this DotNetRunSettings toolSettings, string packageReleaseNotes) : DotNetRunSettings
- SetPackageRequireLicenseAcceptance(this DotNetRunSettings toolSettings, bool? packageRequireLicenseAcceptance) : DotNetRunSettings
- SetPackageTags(this DotNetRunSettings toolSettings, string[] packageTags) : DotNetRunSettings
- SetPackageTags(this DotNetRunSettings toolSettings, IEnumerable<string> packageTags) : DotNetRunSettings
- SetProjectFile(this DotNetRunSettings toolSettings, string projectFile) : DotNetRunSettings
- SetProperties(this DotNetRunSettings toolSettings, IDictionary<string, object> properties) : DotNetRunSettings
- SetProperty(this DotNetRunSettings toolSettings, string propertyKey, object propertyValue) : DotNetRunSettings
- SetRepositoryType(this DotNetRunSettings toolSettings, string repositoryType) : DotNetRunSettings
- SetRepositoryUrl(this DotNetRunSettings toolSettings, string repositoryUrl) : DotNetRunSettings
- SetRunCodeAnalysis(this DotNetRunSettings toolSettings, bool? runCodeAnalysis) : DotNetRunSettings
- SetRuntime(this DotNetRunSettings toolSettings, string runtime) : DotNetRunSettings
- SetSources(this DotNetRunSettings toolSettings, string[] sources) : DotNetRunSettings
- SetSources(this DotNetRunSettings toolSettings, IEnumerable<string> sources) : DotNetRunSettings
- SetSymbolPackageFormat(this DotNetRunSettings toolSettings, DotNetSymbolPackageFormat symbolPackageFormat) : DotNetRunSettings
- SetTitle(this DotNetRunSettings toolSettings, string title) : DotNetRunSettings
- SetTreatWarningsAsErrors(this DotNetRunSettings toolSettings, bool? treatWarningsAsErrors) : DotNetRunSettings
- SetUseLockFile(this DotNetRunSettings toolSettings, bool? useLockFile) : DotNetRunSettings
- SetVersion(this DotNetRunSettings toolSettings, string version) : DotNetRunSettings
- SetVersionPrefix(this DotNetRunSettings toolSettings, string versionPrefix) : DotNetRunSettings
- SetWarningLevel(this DotNetRunSettings toolSettings, int? warningLevel) : DotNetRunSettings
- SetWarningsAsErrors(this DotNetRunSettings toolSettings, int[] warningsAsErrors) : DotNetRunSettings
- SetWarningsAsErrors(this DotNetRunSettings toolSettings, IEnumerable<int> warningsAsErrors) : DotNetRunSettings
- ToggleDisableParallel(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleForce(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleForceEvaluate(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleIgnoreFailedSources(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleLockedMode(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleNoBuild(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleNoCache(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleNoDependencies(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleNoLaunchProfile(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleNoRestore(this DotNetRunSettings toolSettings) : DotNetRunSettings
- TogglePackageRequireLicenseAcceptance(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleRunCodeAnalysis(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleTreatWarningsAsErrors(this DotNetRunSettings toolSettings) : DotNetRunSettings
- ToggleUseLockFile(this DotNetRunSettings toolSettings) : DotNetRunSettings

### Nuke.Common.Tools.DotNet.DotNetSymbolPackageFormat

- snupkg : DotNetSymbolPackageFormat
- symbols_nupkg : DotNetSymbolPackageFormat
- .ctor()
- op_Explicit(string value) : DotNetSymbolPackageFormat

### Nuke.Common.Tools.DotNet.DotNetTasks

- get_DotNetLogger() : Action<OutputType, string>
- get_DotNetPath() : string
- set_DotNetLogger(Action<OutputType, string> value) : void
- DotNet(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, Func<string, string> outputFilter = null) : IReadOnlyCollection<Output>
- DotNetBuild(DotNetBuildSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetBuild(Configure<DotNetBuildSettings> configurator) : IReadOnlyCollection<Output>
- DotNetBuild(CombinatorialConfigure<DotNetBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetBuildSettings, Output IReadOnlyCollection<Output>)>
- DotNetClean(DotNetCleanSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetClean(Configure<DotNetCleanSettings> configurator) : IReadOnlyCollection<Output>
- DotNetClean(CombinatorialConfigure<DotNetCleanSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetCleanSettings, Output IReadOnlyCollection<Output>)>
- DotNetNuGetPush(DotNetNuGetPushSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetNuGetPush(Configure<DotNetNuGetPushSettings> configurator) : IReadOnlyCollection<Output>
- DotNetNuGetPush(CombinatorialConfigure<DotNetNuGetPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetNuGetPushSettings, Output IReadOnlyCollection<Output>)>
- DotNetPack(DotNetPackSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetPack(Configure<DotNetPackSettings> configurator) : IReadOnlyCollection<Output>
- DotNetPack(CombinatorialConfigure<DotNetPackSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetPackSettings, Output IReadOnlyCollection<Output>)>
- DotNetPublish(DotNetPublishSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetPublish(Configure<DotNetPublishSettings> configurator) : IReadOnlyCollection<Output>
- DotNetPublish(CombinatorialConfigure<DotNetPublishSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetPublishSettings, Output IReadOnlyCollection<Output>)>
- DotNetRestore(DotNetRestoreSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetRestore(Configure<DotNetRestoreSettings> configurator) : IReadOnlyCollection<Output>
- DotNetRestore(CombinatorialConfigure<DotNetRestoreSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetRestoreSettings, Output IReadOnlyCollection<Output>)>
- DotNetRun(DotNetRunSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetRun(Configure<DotNetRunSettings> configurator) : IReadOnlyCollection<Output>
- DotNetRun(CombinatorialConfigure<DotNetRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetRunSettings, Output IReadOnlyCollection<Output>)>
- DotNetTest(DotNetTestSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetTest(Configure<DotNetTestSettings> configurator) : IReadOnlyCollection<Output>
- DotNetTest(CombinatorialConfigure<DotNetTestSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetTestSettings, Output IReadOnlyCollection<Output>)>
- DotNetToolInstall(DotNetToolInstallSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetToolInstall(Configure<DotNetToolInstallSettings> configurator) : IReadOnlyCollection<Output>
- DotNetToolInstall(CombinatorialConfigure<DotNetToolInstallSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetToolInstallSettings, Output IReadOnlyCollection<Output>)>
- DotNetToolUninstall(DotNetToolUninstallSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetToolUninstall(Configure<DotNetToolUninstallSettings> configurator) : IReadOnlyCollection<Output>
- DotNetToolUninstall(CombinatorialConfigure<DotNetToolUninstallSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetToolUninstallSettings, Output IReadOnlyCollection<Output>)>
- DotNetToolUpdate(DotNetToolUpdateSettings toolSettings = null) : IReadOnlyCollection<Output>
- DotNetToolUpdate(Configure<DotNetToolUpdateSettings> configurator) : IReadOnlyCollection<Output>
- DotNetToolUpdate(CombinatorialConfigure<DotNetToolUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = False) : IEnumerable<(Settings DotNetToolUpdateSettings, Output IReadOnlyCollection<Output>)>

### Nuke.Common.Tools.DotNet.DotNetTestSettings

- .ctor()
- get_Configuration() : string
- get_CustomLogger() : Action<OutputType, string>
- get_DataCollector() : string
- get_DiagnosticsFile() : string
- get_DisableParallel() : bool?
- get_Filter() : string
- get_Force() : bool?
- get_ForceEvaluate() : bool?
- get_Framework() : string
- get_IgnoreFailedSources() : bool?
- get_ListTests() : bool?
- get_LockedMode() : bool?
- get_LockFilePath() : string
- get_Logger() : string
- get_NoBuild() : bool?
- get_NoCache() : bool?
- get_NoDependencies() : bool?
- get_NoRestore() : bool?
- get_Output() : string
- get_PackageDirectory() : string
- get_ProjectFile() : string
- get_Properties() : IReadOnlyDictionary<string, object>
- get_ResultsDirec