#pragma warning disable CS1574
// Generated from https://github.com/nuke-build/nuke/blob/master/build/specifications/Docker.json

using JetBrains.Annotations;
using Newtonsoft.Json;
using Nuke.Common;
using Nuke.Common.Execution;
using Nuke.Common.Tooling;
using Nuke.Common.Tools;
using Nuke.Common.Utilities.Collections;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Text;

namespace Nuke.Common.Tools.Docker
{
    /// <summary>
    ///   <p>Docker is an open platform for developing, shipping, and running applications. Docker enables you to separate your applications from your infrastructure so you can deliver software quickly. With Docker, you can manage your infrastructure in the same ways you manage your applications. By taking advantage of Docker’s methodologies for shipping, testing, and deploying code quickly, you can significantly reduce the delay between writing code and running it in production.</p>
    ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class DockerTasks
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public static string DockerPath =>
            ToolPathResolver.TryGetEnvironmentExecutable("DOCKER_EXE") ??
            ToolPathResolver.GetPathExecutable("docker");
        public static Action<OutputType, string> DockerLogger { get; set; } = CustomLogger;
        /// <summary>
        ///   <p>Docker is an open platform for developing, shipping, and running applications. Docker enables you to separate your applications from your infrastructure so you can deliver software quickly. With Docker, you can manage your infrastructure in the same ways you manage your applications. By taking advantage of Docker’s methodologies for shipping, testing, and deploying code quickly, you can significantly reduce the delay between writing code and running it in production.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        public static IReadOnlyCollection<Output> Docker(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, bool? logTimestamp = null, string logFile = null, Func<string, string> outputFilter = null)
        {
            using var process = ProcessTasks.StartProcess(DockerPath, arguments, workingDirectory, environmentVariables, timeout, logOutput, logInvocation, logTimestamp, logFile, DockerLogger, outputFilter);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigRmSettings.Configs"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigRm(DockerConfigRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerConfigRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigRmSettings.Configs"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigRm(Configure<DockerConfigRmSettings> configurator)
        {
            return DockerConfigRm(configurator(new DockerConfigRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigRmSettings.Configs"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerConfigRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerConfigRm(CombinatorialConfigure<DockerConfigRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerConfigRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLoad(DockerLoadSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerLoadSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLoad(Configure<DockerLoadSettings> configurator)
        {
            return DockerLoad(configurator(new DockerLoadSettings()));
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerLoadSettings Settings, IReadOnlyCollection<Output> Output)> DockerLoad(CombinatorialConfigure<DockerLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerLoad, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove all stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPrune(DockerContainerPruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerPruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove all stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPrune(Configure<DockerContainerPruneSettings> configurator)
        {
            return DockerContainerPrune(configurator(new DockerContainerPruneSettings()));
        }
        /// <summary>
        ///   <p>Remove all stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerPruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerPrune(CombinatorialConfigure<DockerContainerPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerPrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage trust on Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrust(DockerTrustSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage trust on Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrust(Configure<DockerTrustSettings> configurator)
        {
            return DockerTrust(configurator(new DockerTrustSettings()));
        }
        /// <summary>
        ///   <p>Manage trust on Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrust(CombinatorialConfigure<DockerTrustSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrust, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Docker stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackSettings.CliSettings"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerStackSettings.Kubeconfig"/></li>
        ///     <li><c>--orchestrator</c> via <see cref="DockerStackSettings.Orchestrator"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStack(DockerStackSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Docker stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackSettings.CliSettings"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerStackSettings.Kubeconfig"/></li>
        ///     <li><c>--orchestrator</c> via <see cref="DockerStackSettings.Orchestrator"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStack(Configure<DockerStackSettings> configurator)
        {
            return DockerStack(configurator(new DockerStackSettings()));
        }
        /// <summary>
        ///   <p>Manage Docker stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackSettings.CliSettings"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerStackSettings.Kubeconfig"/></li>
        ///     <li><c>--orchestrator</c> via <see cref="DockerStackSettings.Orchestrator"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackSettings Settings, IReadOnlyCollection<Output> Output)> DockerStack(CombinatorialConfigure<DockerStackSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStack, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTop(DockerTopSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTopSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTop(Configure<DockerTopSettings> configurator)
        {
            return DockerTop(configurator(new DockerTopSettings()));
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTopSettings Settings, IReadOnlyCollection<Output> Output)> DockerTop(CombinatorialConfigure<DockerTopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTop, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerPullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerPullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPull(DockerPullSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPullSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerPullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerPullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPull(Configure<DockerPullSettings> configurator)
        {
            return DockerPull(configurator(new DockerPullSettings()));
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerPullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerPullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPullSettings Settings, IReadOnlyCollection<Output> Output)> DockerPull(CombinatorialConfigure<DockerPullSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPull, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Sign an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSign(DockerTrustSignSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustSignSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Sign an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSign(Configure<DockerTrustSignSettings> configurator)
        {
            return DockerTrustSign(configurator(new DockerTrustSignSettings()));
        }
        /// <summary>
        ///   <p>Sign an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustSignSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustSign(CombinatorialConfigure<DockerTrustSignSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustSign, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage checkpoints.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpoint(DockerCheckpointSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCheckpointSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage checkpoints.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpoint(Configure<DockerCheckpointSettings> configurator)
        {
            return DockerCheckpoint(configurator(new DockerCheckpointSettings()));
        }
        /// <summary>
        ///   <p>Manage checkpoints.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCheckpointSettings Settings, IReadOnlyCollection<Output> Output)> DockerCheckpoint(CombinatorialConfigure<DockerCheckpointSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCheckpoint, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage entities who can sign Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSigner(DockerTrustSignerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustSignerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage entities who can sign Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSigner(Configure<DockerTrustSignerSettings> configurator)
        {
            return DockerTrustSigner(configurator(new DockerTrustSignerSettings()));
        }
        /// <summary>
        ///   <p>Manage entities who can sign Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustSignerSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustSigner(CombinatorialConfigure<DockerTrustSignerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustSigner, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigInspectSettings.Configs"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerConfigInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigInspect(DockerConfigInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerConfigInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigInspectSettings.Configs"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerConfigInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigInspect(Configure<DockerConfigInspectSettings> configurator)
        {
            return DockerConfigInspect(configurator(new DockerConfigInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;configs&gt;</c> via <see cref="DockerConfigInspectSettings.Configs"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerConfigInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerConfigInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerConfigInspect(CombinatorialConfigure<DockerConfigInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerConfigInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerService(DockerServiceSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerService(Configure<DockerServiceSettings> configurator)
        {
            return DockerService(configurator(new DockerServiceSettings()));
        }
        /// <summary>
        ///   <p>Manage services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceSettings Settings, IReadOnlyCollection<Output> Output)> DockerService(CombinatorialConfigure<DockerServiceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerService, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generate and load a signing key-pair.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKeyGenerate(DockerTrustKeyGenerateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustKeyGenerateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generate and load a signing key-pair.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKeyGenerate(Configure<DockerTrustKeyGenerateSettings> configurator)
        {
            return DockerTrustKeyGenerate(configurator(new DockerTrustKeyGenerateSettings()));
        }
        /// <summary>
        ///   <p>Generate and load a signing key-pair.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustKeyGenerateSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustKeyGenerateSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustKeyGenerate(CombinatorialConfigure<DockerTrustKeyGenerateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustKeyGenerate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Docker.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystem(DockerSystemSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSystemSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Docker.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystem(Configure<DockerSystemSettings> configurator)
        {
            return DockerSystem(configurator(new DockerSystemSettings()));
        }
        /// <summary>
        ///   <p>Manage Docker.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSystemSettings Settings, IReadOnlyCollection<Output> Output)> DockerSystem(CombinatorialConfigure<DockerSystemSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSystem, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerConfigLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerConfigLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigLs(DockerConfigLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerConfigLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerConfigLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerConfigLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigLs(Configure<DockerConfigLsSettings> configurator)
        {
            return DockerConfigLs(configurator(new DockerConfigLsSettings()));
        }
        /// <summary>
        ///   <p>List configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerConfigLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerConfigLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerConfigLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerConfigLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerConfigLs(CombinatorialConfigure<DockerConfigLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerConfigLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUpdateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextUpdateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextUpdateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextUpdateSettings.Docker"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextUpdateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextUpdate(DockerContextUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUpdateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextUpdateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextUpdateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextUpdateSettings.Docker"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextUpdateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextUpdate(Configure<DockerContextUpdateSettings> configurator)
        {
            return DockerContextUpdate(configurator(new DockerContextUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUpdateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextUpdateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextUpdateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextUpdateSettings.Docker"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextUpdateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextUpdate(CombinatorialConfigure<DockerContextUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List the services in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackServicesSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackServicesSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackServicesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackServicesSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackServicesSettings.Namespace"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackServicesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackServices(DockerStackServicesSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackServicesSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List the services in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackServicesSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackServicesSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackServicesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackServicesSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackServicesSettings.Namespace"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackServicesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackServices(Configure<DockerStackServicesSettings> configurator)
        {
            return DockerStackServices(configurator(new DockerStackServicesSettings()));
        }
        /// <summary>
        ///   <p>List the services in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackServicesSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackServicesSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackServicesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackServicesSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackServicesSettings.Namespace"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackServicesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackServicesSettings Settings, IReadOnlyCollection<Output> Output)> DockerStackServices(CombinatorialConfigure<DockerStackServicesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStackServices, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerContainerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPort(DockerContainerPortSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerPortSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerContainerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPort(Configure<DockerContainerPortSettings> configurator)
        {
            return DockerContainerPort(configurator(new DockerContainerPortSettings()));
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerContainerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerPortSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerPort(CombinatorialConfigure<DockerContainerPortSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerPort, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRename(DockerRenameSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerRenameSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRename(Configure<DockerRenameSettings> configurator)
        {
            return DockerRename(configurator(new DockerRenameSettings()));
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerRenameSettings Settings, IReadOnlyCollection<Output> Output)> DockerRename(CombinatorialConfigure<DockerRenameSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerRename, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTag(DockerTagSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTagSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTag(Configure<DockerTagSettings> configurator)
        {
            return DockerTag(configurator(new DockerTagSettings()));
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTagSettings Settings, IReadOnlyCollection<Output> Output)> DockerTag(CombinatorialConfigure<DockerTagSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTag, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretInspectSettings.Secrets"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerSecretInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretInspect(DockerSecretInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSecretInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretInspectSettings.Secrets"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerSecretInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretInspect(Configure<DockerSecretInspectSettings> configurator)
        {
            return DockerSecretInspect(configurator(new DockerSecretInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretInspectSettings.Secrets"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerSecretInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSecretInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerSecretInspect(CombinatorialConfigure<DockerSecretInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSecretInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Docker secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecret(DockerSecretSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSecretSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Docker secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecret(Configure<DockerSecretSettings> configurator)
        {
            return DockerSecret(configurator(new DockerSecretSettings()));
        }
        /// <summary>
        ///   <p>Manage Docker secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSecretSettings Settings, IReadOnlyCollection<Output> Output)> DockerSecret(CombinatorialConfigure<DockerSecretSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSecret, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerContainerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerExport(DockerContainerExportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerExportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerContainerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerExport(Configure<DockerContainerExportSettings> configurator)
        {
            return DockerContainerExport(configurator(new DockerContainerExportSettings()));
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerContainerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerExportSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerExport(CombinatorialConfigure<DockerContainerExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerExport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerHistory(DockerHistorySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerHistorySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerHistory(Configure<DockerHistorySettings> configurator)
        {
            return DockerHistory(configurator(new DockerHistorySettings()));
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerHistorySettings Settings, IReadOnlyCollection<Output> Output)> DockerHistory(CombinatorialConfigure<DockerHistorySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerHistory, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a new service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerServiceCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerServiceCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerServiceCreateSettings.Image"/></li>
        ///     <li><c>--config</c> via <see cref="DockerServiceCreateSettings.Config"/></li>
        ///     <li><c>--constraint</c> via <see cref="DockerServiceCreateSettings.Constraint"/></li>
        ///     <li><c>--container-label</c> via <see cref="DockerServiceCreateSettings.ContainerLabel"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceCreateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceCreateSettings.Detach"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerServiceCreateSettings.Dns"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerServiceCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerServiceCreateSettings.DnsSearch"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceCreateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerServiceCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerServiceCreateSettings.EnvFile"/></li>
        ///     <li><c>--generic-resource</c> via <see cref="DockerServiceCreateSettings.GenericResource"/></li>
        ///     <li><c>--group</c> via <see cref="DockerServiceCreateSettings.Group"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--host</c> via <see cref="DockerServiceCreateSettings.Host"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceCreateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceCreateSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerServiceCreateSettings.Label"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceCreateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceCreateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceCreateSettings.LogOpt"/></li>
        ///     <li><c>--mode</c> via <see cref="DockerServiceCreateSettings.Mode"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerServiceCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerServiceCreateSettings.Name"/></li>
        ///     <li><c>--network</c> via <see cref="DockerServiceCreateSettings.Network"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceCreateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref</c> via <see cref="DockerServiceCreateSettings.PlacementPref"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerServiceCreateSettings.Publish"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceCreateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceCreateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceCreateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceCreateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceCreateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceCreateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceCreateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceCreateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceCreateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceCreateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceCreateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceCreateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceCreateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceCreateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceCreateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerServiceCreateSettings.Secret"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceCreateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceCreateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerServiceCreateSettings.Sysctl"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceCreateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceCreateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceCreateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceCreateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceCreateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceCreateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceCreateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceCreateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceCreate(DockerServiceCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a new service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerServiceCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerServiceCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerServiceCreateSettings.Image"/></li>
        ///     <li><c>--config</c> via <see cref="DockerServiceCreateSettings.Config"/></li>
        ///     <li><c>--constraint</c> via <see cref="DockerServiceCreateSettings.Constraint"/></li>
        ///     <li><c>--container-label</c> via <see cref="DockerServiceCreateSettings.ContainerLabel"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceCreateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceCreateSettings.Detach"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerServiceCreateSettings.Dns"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerServiceCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerServiceCreateSettings.DnsSearch"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceCreateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerServiceCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerServiceCreateSettings.EnvFile"/></li>
        ///     <li><c>--generic-resource</c> via <see cref="DockerServiceCreateSettings.GenericResource"/></li>
        ///     <li><c>--group</c> via <see cref="DockerServiceCreateSettings.Group"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--host</c> via <see cref="DockerServiceCreateSettings.Host"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceCreateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceCreateSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerServiceCreateSettings.Label"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceCreateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceCreateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceCreateSettings.LogOpt"/></li>
        ///     <li><c>--mode</c> via <see cref="DockerServiceCreateSettings.Mode"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerServiceCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerServiceCreateSettings.Name"/></li>
        ///     <li><c>--network</c> via <see cref="DockerServiceCreateSettings.Network"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceCreateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref</c> via <see cref="DockerServiceCreateSettings.PlacementPref"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerServiceCreateSettings.Publish"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceCreateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceCreateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceCreateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceCreateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceCreateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceCreateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceCreateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceCreateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceCreateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceCreateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceCreateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceCreateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceCreateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceCreateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceCreateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerServiceCreateSettings.Secret"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceCreateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceCreateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerServiceCreateSettings.Sysctl"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceCreateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceCreateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceCreateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceCreateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceCreateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceCreateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceCreateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceCreateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceCreate(Configure<DockerServiceCreateSettings> configurator)
        {
            return DockerServiceCreate(configurator(new DockerServiceCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a new service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerServiceCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerServiceCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerServiceCreateSettings.Image"/></li>
        ///     <li><c>--config</c> via <see cref="DockerServiceCreateSettings.Config"/></li>
        ///     <li><c>--constraint</c> via <see cref="DockerServiceCreateSettings.Constraint"/></li>
        ///     <li><c>--container-label</c> via <see cref="DockerServiceCreateSettings.ContainerLabel"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceCreateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceCreateSettings.Detach"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerServiceCreateSettings.Dns"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerServiceCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerServiceCreateSettings.DnsSearch"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceCreateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerServiceCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerServiceCreateSettings.EnvFile"/></li>
        ///     <li><c>--generic-resource</c> via <see cref="DockerServiceCreateSettings.GenericResource"/></li>
        ///     <li><c>--group</c> via <see cref="DockerServiceCreateSettings.Group"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--host</c> via <see cref="DockerServiceCreateSettings.Host"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceCreateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceCreateSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerServiceCreateSettings.Label"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceCreateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceCreateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceCreateSettings.LogOpt"/></li>
        ///     <li><c>--mode</c> via <see cref="DockerServiceCreateSettings.Mode"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerServiceCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerServiceCreateSettings.Name"/></li>
        ///     <li><c>--network</c> via <see cref="DockerServiceCreateSettings.Network"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceCreateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref</c> via <see cref="DockerServiceCreateSettings.PlacementPref"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerServiceCreateSettings.Publish"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceCreateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceCreateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceCreateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceCreateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceCreateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceCreateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceCreateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceCreateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceCreateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceCreateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceCreateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceCreateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceCreateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceCreateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceCreateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerServiceCreateSettings.Secret"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceCreateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceCreateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerServiceCreateSettings.Sysctl"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceCreateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceCreateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceCreateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceCreateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceCreateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceCreateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceCreateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceCreateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceCreateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceCreate(CombinatorialConfigure<DockerServiceCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List the tasks of one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServicePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServicePsSettings.Services"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServicePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServicePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServicePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServicePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServicePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServicePs(DockerServicePsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServicePsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List the tasks of one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServicePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServicePsSettings.Services"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServicePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServicePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServicePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServicePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServicePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServicePs(Configure<DockerServicePsSettings> configurator)
        {
            return DockerServicePs(configurator(new DockerServicePsSettings()));
        }
        /// <summary>
        ///   <p>List the tasks of one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServicePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServicePsSettings.Services"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServicePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServicePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServicePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServicePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServicePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServicePsSettings Settings, IReadOnlyCollection<Output> Output)> DockerServicePs(CombinatorialConfigure<DockerServicePsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServicePs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStop(DockerStopSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStopSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStop(Configure<DockerStopSettings> configurator)
        {
            return DockerStop(configurator(new DockerStopSettings()));
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStopSettings Settings, IReadOnlyCollection<Output> Output)> DockerStop(CombinatorialConfigure<DockerStopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStop, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Swarm nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNode(DockerNodeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Swarm nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNode(Configure<DockerNodeSettings> configurator)
        {
            return DockerNode(configurator(new DockerNodeSettings()));
        }
        /// <summary>
        ///   <p>Manage Swarm nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeSettings Settings, IReadOnlyCollection<Output> Output)> DockerNode(CombinatorialConfigure<DockerNodeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNode, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerUpdate(DockerUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerUpdate(Configure<DockerUpdateSettings> configurator)
        {
            return DockerUpdate(configurator(new DockerUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerUpdate(CombinatorialConfigure<DockerUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a plugin from a rootfs and configuration. Plugin data directory must contain config.json and rootfs directory.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginCreateSettings.Plugin"/></li>
        ///     <li><c>&lt;pluginDataDir&gt;</c> via <see cref="DockerPluginCreateSettings.PluginDataDir"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerPluginCreateSettings.Compress"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginCreate(DockerPluginCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a plugin from a rootfs and configuration. Plugin data directory must contain config.json and rootfs directory.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginCreateSettings.Plugin"/></li>
        ///     <li><c>&lt;pluginDataDir&gt;</c> via <see cref="DockerPluginCreateSettings.PluginDataDir"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerPluginCreateSettings.Compress"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginCreate(Configure<DockerPluginCreateSettings> configurator)
        {
            return DockerPluginCreate(configurator(new DockerPluginCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a plugin from a rootfs and configuration. Plugin data directory must contain config.json and rootfs directory.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginCreateSettings.Plugin"/></li>
        ///     <li><c>&lt;pluginDataDir&gt;</c> via <see cref="DockerPluginCreateSettings.PluginDataDir"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerPluginCreateSettings.Compress"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginCreate(CombinatorialConfigure<DockerPluginCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemInfo(DockerSystemInfoSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSystemInfoSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemInfo(Configure<DockerSystemInfoSettings> configurator)
        {
            return DockerSystemInfo(configurator(new DockerSystemInfoSettings()));
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSystemInfoSettings Settings, IReadOnlyCollection<Output> Output)> DockerSystemInfo(CombinatorialConfigure<DockerSystemInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSystemInfo, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove all unused local volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumePruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumePrune(DockerVolumePruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumePruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove all unused local volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumePruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumePrune(Configure<DockerVolumePruneSettings> configurator)
        {
            return DockerVolumePrune(configurator(new DockerVolumePruneSettings()));
        }
        /// <summary>
        ///   <p>Remove all unused local volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumePruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumePruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolumePrune(CombinatorialConfigure<DockerVolumePruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolumePrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Upgrade an existing plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginUpgradeSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginUpgradeSettings.Plugin"/></li>
        ///     <li><c>&lt;remote&gt;</c> via <see cref="DockerPluginUpgradeSettings.Remote"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginUpgradeSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginUpgradeSettings.GrantAllPermissions"/></li>
        ///     <li><c>--skip-remote-check</c> via <see cref="DockerPluginUpgradeSettings.SkipRemoteCheck"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginUpgrade(DockerPluginUpgradeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginUpgradeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Upgrade an existing plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginUpgradeSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginUpgradeSettings.Plugin"/></li>
        ///     <li><c>&lt;remote&gt;</c> via <see cref="DockerPluginUpgradeSettings.Remote"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginUpgradeSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginUpgradeSettings.GrantAllPermissions"/></li>
        ///     <li><c>--skip-remote-check</c> via <see cref="DockerPluginUpgradeSettings.SkipRemoteCheck"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginUpgrade(Configure<DockerPluginUpgradeSettings> configurator)
        {
            return DockerPluginUpgrade(configurator(new DockerPluginUpgradeSettings()));
        }
        /// <summary>
        ///   <p>Upgrade an existing plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginUpgradeSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginUpgradeSettings.Plugin"/></li>
        ///     <li><c>&lt;remote&gt;</c> via <see cref="DockerPluginUpgradeSettings.Remote"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginUpgradeSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginUpgradeSettings.GrantAllPermissions"/></li>
        ///     <li><c>--skip-remote-check</c> via <see cref="DockerPluginUpgradeSettings.SkipRemoteCheck"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginUpgradeSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginUpgrade(CombinatorialConfigure<DockerPluginUpgradeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginUpgrade, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove build cache.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderPruneSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilderPrune(DockerBuilderPruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerBuilderPruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove build cache.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderPruneSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilderPrune(Configure<DockerBuilderPruneSettings> configurator)
        {
            return DockerBuilderPrune(configurator(new DockerBuilderPruneSettings()));
        }
        /// <summary>
        ///   <p>Remove build cache.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderPruneSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerBuilderPruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerBuilderPrune(CombinatorialConfigure<DockerBuilderPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerBuilderPrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage join tokens.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.CliSettings"/></li>
        ///     <li><c>&lt;worker&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.Worker"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmJoinTokenSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmJoinTokenSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmJoinToken(DockerSwarmJoinTokenSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmJoinTokenSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage join tokens.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.CliSettings"/></li>
        ///     <li><c>&lt;worker&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.Worker"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmJoinTokenSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmJoinTokenSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmJoinToken(Configure<DockerSwarmJoinTokenSettings> configurator)
        {
            return DockerSwarmJoinToken(configurator(new DockerSwarmJoinTokenSettings()));
        }
        /// <summary>
        ///   <p>Manage join tokens.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.CliSettings"/></li>
        ///     <li><c>&lt;worker&gt;</c> via <see cref="DockerSwarmJoinTokenSettings.Worker"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmJoinTokenSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmJoinTokenSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmJoinTokenSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmJoinToken(CombinatorialConfigure<DockerSwarmJoinTokenSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmJoinToken, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update a node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;node&gt;</c> via <see cref="DockerNodeUpdateSettings.Node"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerNodeUpdateSettings.Availability"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerNodeUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerNodeUpdateSettings.LabelRm"/></li>
        ///     <li><c>--role</c> via <see cref="DockerNodeUpdateSettings.Role"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeUpdate(DockerNodeUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update a node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;node&gt;</c> via <see cref="DockerNodeUpdateSettings.Node"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerNodeUpdateSettings.Availability"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerNodeUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerNodeUpdateSettings.LabelRm"/></li>
        ///     <li><c>--role</c> via <see cref="DockerNodeUpdateSettings.Role"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeUpdate(Configure<DockerNodeUpdateSettings> configurator)
        {
            return DockerNodeUpdate(configurator(new DockerNodeUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update a node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;node&gt;</c> via <see cref="DockerNodeUpdateSettings.Node"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerNodeUpdateSettings.Availability"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerNodeUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerNodeUpdateSettings.LabelRm"/></li>
        ///     <li><c>--role</c> via <see cref="DockerNodeUpdateSettings.Role"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodeUpdate(CombinatorialConfigure<DockerNodeUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodeUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Add a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerAddSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerAddSettings.Name"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTrustSignerAddSettings.Options"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerAddSettings.Repositories"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSignerAdd(DockerTrustSignerAddSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustSignerAddSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Add a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerAddSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerAddSettings.Name"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTrustSignerAddSettings.Options"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerAddSettings.Repositories"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSignerAdd(Configure<DockerTrustSignerAddSettings> configurator)
        {
            return DockerTrustSignerAdd(configurator(new DockerTrustSignerAddSettings()));
        }
        /// <summary>
        ///   <p>Add a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerAddSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerAddSettings.Name"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerTrustSignerAddSettings.Options"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerAddSettings.Repositories"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustSignerAddSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustSignerAdd(CombinatorialConfigure<DockerTrustSignerAddSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustSignerAdd, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUpdateSettings.CliSettings"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmUpdateSettings.Autolock"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmUpdateSettings.CertExpiry"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmUpdateSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmUpdateSettings.ExternalCa"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmUpdateSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmUpdateSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmUpdateSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUpdate(DockerSwarmUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUpdateSettings.CliSettings"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmUpdateSettings.Autolock"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmUpdateSettings.CertExpiry"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmUpdateSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmUpdateSettings.ExternalCa"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmUpdateSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmUpdateSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmUpdateSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUpdate(Configure<DockerSwarmUpdateSettings> configurator)
        {
            return DockerSwarmUpdate(configurator(new DockerSwarmUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUpdateSettings.CliSettings"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmUpdateSettings.Autolock"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmUpdateSettings.CertExpiry"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmUpdateSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmUpdateSettings.ExternalCa"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmUpdateSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmUpdateSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmUpdateSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmUpdate(CombinatorialConfigure<DockerSwarmUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Fetch the logs of a service or task.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceLogsSettings.Service"/></li>
        ///     <li><c>--details</c> via <see cref="DockerServiceLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerServiceLogsSettings.Follow"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServiceLogsSettings.NoResolve"/></li>
        ///     <li><c>--no-task-ids</c> via <see cref="DockerServiceLogsSettings.NoTaskIds"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServiceLogsSettings.NoTrunc"/></li>
        ///     <li><c>--raw</c> via <see cref="DockerServiceLogsSettings.Raw"/></li>
        ///     <li><c>--since</c> via <see cref="DockerServiceLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerServiceLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerServiceLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceLogs(DockerServiceLogsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceLogsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Fetch the logs of a service or task.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceLogsSettings.Service"/></li>
        ///     <li><c>--details</c> via <see cref="DockerServiceLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerServiceLogsSettings.Follow"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServiceLogsSettings.NoResolve"/></li>
        ///     <li><c>--no-task-ids</c> via <see cref="DockerServiceLogsSettings.NoTaskIds"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServiceLogsSettings.NoTrunc"/></li>
        ///     <li><c>--raw</c> via <see cref="DockerServiceLogsSettings.Raw"/></li>
        ///     <li><c>--since</c> via <see cref="DockerServiceLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerServiceLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerServiceLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceLogs(Configure<DockerServiceLogsSettings> configurator)
        {
            return DockerServiceLogs(configurator(new DockerServiceLogsSettings()));
        }
        /// <summary>
        ///   <p>Fetch the logs of a service or task.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceLogsSettings.Service"/></li>
        ///     <li><c>--details</c> via <see cref="DockerServiceLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerServiceLogsSettings.Follow"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerServiceLogsSettings.NoResolve"/></li>
        ///     <li><c>--no-task-ids</c> via <see cref="DockerServiceLogsSettings.NoTaskIds"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerServiceLogsSettings.NoTrunc"/></li>
        ///     <li><c>--raw</c> via <see cref="DockerServiceLogsSettings.Raw"/></li>
        ///     <li><c>--since</c> via <see cref="DockerServiceLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerServiceLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerServiceLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceLogsSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceLogs(CombinatorialConfigure<DockerServiceLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceLogs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServiceLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceLs(DockerServiceLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServiceLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceLs(Configure<DockerServiceLsSettings> configurator)
        {
            return DockerServiceLs(configurator(new DockerServiceLsSettings()));
        }
        /// <summary>
        ///   <p>List services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerServiceLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceLs(CombinatorialConfigure<DockerServiceLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Unlock swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUnlock(DockerSwarmUnlockSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmUnlockSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Unlock swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUnlock(Configure<DockerSwarmUnlockSettings> configurator)
        {
            return DockerSwarmUnlock(configurator(new DockerSwarmUnlockSettings()));
        }
        /// <summary>
        ///   <p>Unlock swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmUnlockSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmUnlock(CombinatorialConfigure<DockerSwarmUnlockSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmUnlock, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNetworkLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNetworkLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkLs(DockerNetworkLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNetworkLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNetworkLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkLs(Configure<DockerNetworkLsSettings> configurator)
        {
            return DockerNetworkLs(configurator(new DockerNetworkLsSettings()));
        }
        /// <summary>
        ///   <p>List networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNetworkLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNetworkLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkLs(CombinatorialConfigure<DockerNetworkLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPluginLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPluginLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPluginLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginLs(DockerPluginLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPluginLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPluginLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPluginLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginLs(Configure<DockerPluginLsSettings> configurator)
        {
            return DockerPluginLs(configurator(new DockerPluginLsSettings()));
        }
        /// <summary>
        ///   <p>List plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPluginLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPluginLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPluginLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginLs(CombinatorialConfigure<DockerPluginLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginRmSettings.Plugins"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginRm(DockerPluginRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginRmSettings.Plugins"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginRm(Configure<DockerPluginRmSettings> configurator)
        {
            return DockerPluginRm(configurator(new DockerPluginRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginRmSettings.Plugins"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginRm(CombinatorialConfigure<DockerPluginRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerImageBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerImageBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerImageBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerImageBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerImageBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerImageBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerImageBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerImageBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerImageBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerImageBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerImageBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImageBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerImageBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerImageBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerImageBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerImageBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerImageBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerImageBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerImageBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerImageBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerImageBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerImageBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerImageBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerImageBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerImageBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerImageBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerImageBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerImageBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerImageBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerImageBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerImageBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerImageBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerImageBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageBuild(DockerImageBuildSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageBuildSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerImageBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerImageBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerImageBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerImageBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerImageBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerImageBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerImageBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerImageBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerImageBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerImageBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerImageBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImageBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerImageBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerImageBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerImageBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerImageBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerImageBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerImageBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerImageBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerImageBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerImageBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerImageBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerImageBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerImageBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerImageBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerImageBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerImageBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerImageBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerImageBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerImageBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerImageBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerImageBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerImageBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageBuild(Configure<DockerImageBuildSettings> configurator)
        {
            return DockerImageBuild(configurator(new DockerImageBuildSettings()));
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerImageBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerImageBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerImageBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerImageBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerImageBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerImageBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerImageBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerImageBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerImageBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerImageBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerImageBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImageBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerImageBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerImageBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerImageBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerImageBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerImageBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerImageBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerImageBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerImageBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerImageBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerImageBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerImageBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerImageBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerImageBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerImageBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerImageBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerImageBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerImageBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerImageBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerImageBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerImageBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerImageBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageBuildSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageBuild(CombinatorialConfigure<DockerImageBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageBuild, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove trust for an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustRevokeSettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerTrustRevokeSettings.Image"/></li>
        ///     <li><c>--yes</c> via <see cref="DockerTrustRevokeSettings.Yes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustRevoke(DockerTrustRevokeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustRevokeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove trust for an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustRevokeSettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerTrustRevokeSettings.Image"/></li>
        ///     <li><c>--yes</c> via <see cref="DockerTrustRevokeSettings.Yes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustRevoke(Configure<DockerTrustRevokeSettings> configurator)
        {
            return DockerTrustRevoke(configurator(new DockerTrustRevokeSettings()));
        }
        /// <summary>
        ///   <p>Remove trust for an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustRevokeSettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerTrustRevokeSettings.Image"/></li>
        ///     <li><c>--yes</c> via <see cref="DockerTrustRevokeSettings.Yes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustRevokeSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustRevoke(CombinatorialConfigure<DockerTrustRevokeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustRevoke, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmiSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerRmiSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmiSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerRmiSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRmi(DockerRmiSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerRmiSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmiSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerRmiSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmiSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerRmiSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRmi(Configure<DockerRmiSettings> configurator)
        {
            return DockerRmi(configurator(new DockerRmiSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmiSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerRmiSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmiSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerRmiSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerRmiSettings Settings, IReadOnlyCollection<Output> Output)> DockerRmi(CombinatorialConfigure<DockerRmiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerRmi, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkRmSettings.Networks"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkRm(DockerNetworkRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkRmSettings.Networks"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkRm(Configure<DockerNetworkRmSettings> configurator)
        {
            return DockerNetworkRm(configurator(new DockerNetworkRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkRmSettings.Networks"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkRm(CombinatorialConfigure<DockerNetworkRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Show the Docker version information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVersionSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVersionSettings.Format"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerVersionSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVersion(DockerVersionSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVersionSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Show the Docker version information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVersionSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVersionSettings.Format"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerVersionSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVersion(Configure<DockerVersionSettings> configurator)
        {
            return DockerVersion(configurator(new DockerVersionSettings()));
        }
        /// <summary>
        ///   <p>Show the Docker version information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVersionSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVersionSettings.Format"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerVersionSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVersionSettings Settings, IReadOnlyCollection<Output> Output)> DockerVersion(CombinatorialConfigure<DockerVersionSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVersion, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a secret from a file or STDIN as content.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerSecretCreateSettings.File"/></li>
        ///     <li><c>&lt;secret&gt;</c> via <see cref="DockerSecretCreateSettings.Secret"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerSecretCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerSecretCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerSecretCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretCreate(DockerSecretCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSecretCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a secret from a file or STDIN as content.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerSecretCreateSettings.File"/></li>
        ///     <li><c>&lt;secret&gt;</c> via <see cref="DockerSecretCreateSettings.Secret"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerSecretCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerSecretCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerSecretCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretCreate(Configure<DockerSecretCreateSettings> configurator)
        {
            return DockerSecretCreate(configurator(new DockerSecretCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a secret from a file or STDIN as content.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerSecretCreateSettings.File"/></li>
        ///     <li><c>&lt;secret&gt;</c> via <see cref="DockerSecretCreateSettings.Secret"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerSecretCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerSecretCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerSecretCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSecretCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerSecretCreate(CombinatorialConfigure<DockerSecretCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSecretCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceRmSettings.Services"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceRm(DockerServiceRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceRmSettings.Services"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceRm(Configure<DockerServiceRmSettings> configurator)
        {
            return DockerServiceRm(configurator(new DockerServiceRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceRmSettings.Services"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceRm(CombinatorialConfigure<DockerServiceRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Load a private key file for signing.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyLoadSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyfile&gt;</c> via <see cref="DockerTrustKeyLoadSettings.Keyfile"/></li>
        ///     <li><c>--name</c> via <see cref="DockerTrustKeyLoadSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKeyLoad(DockerTrustKeyLoadSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustKeyLoadSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Load a private key file for signing.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyLoadSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyfile&gt;</c> via <see cref="DockerTrustKeyLoadSettings.Keyfile"/></li>
        ///     <li><c>--name</c> via <see cref="DockerTrustKeyLoadSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKeyLoad(Configure<DockerTrustKeyLoadSettings> configurator)
        {
            return DockerTrustKeyLoad(configurator(new DockerTrustKeyLoadSettings()));
        }
        /// <summary>
        ///   <p>Load a private key file for signing.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeyLoadSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyfile&gt;</c> via <see cref="DockerTrustKeyLoadSettings.Keyfile"/></li>
        ///     <li><c>--name</c> via <see cref="DockerTrustKeyLoadSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustKeyLoadSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustKeyLoad(CombinatorialConfigure<DockerTrustKeyLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustKeyLoad, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretRmSettings.Secrets"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretRm(DockerSecretRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSecretRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretRmSettings.Secrets"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretRm(Configure<DockerSecretRmSettings> configurator)
        {
            return DockerSecretRm(configurator(new DockerSecretRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;secrets&gt;</c> via <see cref="DockerSecretRmSettings.Secrets"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSecretRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerSecretRm(CombinatorialConfigure<DockerSecretRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSecretRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageInspectSettings.Images"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageInspect(DockerImageInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageInspectSettings.Images"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageInspect(Configure<DockerImageInspectSettings> configurator)
        {
            return DockerImageInspect(configurator(new DockerImageInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageInspectSettings.Images"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageInspect(CombinatorialConfigure<DockerImageInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageSave(DockerImageSaveSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageSaveSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageSave(Configure<DockerImageSaveSettings> configurator)
        {
            return DockerImageSave(configurator(new DockerImageSaveSettings()));
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerImageSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageSaveSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageSave(CombinatorialConfigure<DockerImageSaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageSave, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage keys for signing Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeySettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKey(DockerTrustKeySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustKeySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage keys for signing Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeySettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustKey(Configure<DockerTrustKeySettings> configurator)
        {
            return DockerTrustKey(configurator(new DockerTrustKeySettings()));
        }
        /// <summary>
        ///   <p>Manage keys for signing Docker images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustKeySettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustKeySettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustKey(CombinatorialConfigure<DockerTrustKeySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustKey, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerContainerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerAttach(DockerContainerAttachSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerAttachSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerContainerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerAttach(Configure<DockerContainerAttachSettings> configurator)
        {
            return DockerContainerAttach(configurator(new DockerContainerAttachSettings()));
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerContainerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerAttachSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerAttach(CombinatorialConfigure<DockerContainerAttachSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerAttach, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextCreateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextCreateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextCreateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextCreateSettings.Docker"/></li>
        ///     <li><c>--from</c> via <see cref="DockerContextCreateSettings.From"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextCreateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextCreate(DockerContextCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextCreateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextCreateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextCreateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextCreateSettings.Docker"/></li>
        ///     <li><c>--from</c> via <see cref="DockerContextCreateSettings.From"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextCreateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextCreate(Configure<DockerContextCreateSettings> configurator)
        {
            return DockerContextCreate(configurator(new DockerContextCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextCreateSettings.Context"/></li>
        ///     <li><c>--default-stack-orchestrator</c> via <see cref="DockerContextCreateSettings.DefaultStackOrchestrator"/></li>
        ///     <li><c>--description</c> via <see cref="DockerContextCreateSettings.Description"/></li>
        ///     <li><c>--docker</c> via <see cref="DockerContextCreateSettings.Docker"/></li>
        ///     <li><c>--from</c> via <see cref="DockerContextCreateSettings.From"/></li>
        ///     <li><c>--kubernetes</c> via <see cref="DockerContextCreateSettings.Kubernetes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextCreate(CombinatorialConfigure<DockerContextCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a config from a file or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;config&gt;</c> via <see cref="DockerConfigCreateSettings.Config"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerConfigCreateSettings.File"/></li>
        ///     <li><c>--label</c> via <see cref="DockerConfigCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerConfigCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigCreate(DockerConfigCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerConfigCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a config from a file or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;config&gt;</c> via <see cref="DockerConfigCreateSettings.Config"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerConfigCreateSettings.File"/></li>
        ///     <li><c>--label</c> via <see cref="DockerConfigCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerConfigCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfigCreate(Configure<DockerConfigCreateSettings> configurator)
        {
            return DockerConfigCreate(configurator(new DockerConfigCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a config from a file or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;config&gt;</c> via <see cref="DockerConfigCreateSettings.Config"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerConfigCreateSettings.File"/></li>
        ///     <li><c>--label</c> via <see cref="DockerConfigCreateSettings.Label"/></li>
        ///     <li><c>--template-driver</c> via <see cref="DockerConfigCreateSettings.TemplateDriver"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerConfigCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerConfigCreate(CombinatorialConfigure<DockerConfigCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerConfigCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeInspectSettings.Volumes"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeInspect(DockerVolumeInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumeInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeInspectSettings.Volumes"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeInspect(Configure<DockerVolumeInspectSettings> configurator)
        {
            return DockerVolumeInspect(configurator(new DockerVolumeInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeInspectSettings.Volumes"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumeInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolumeInspect(CombinatorialConfigure<DockerVolumeInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolumeInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStop(DockerContainerStopSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerStopSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStop(Configure<DockerContainerStopSettings> configurator)
        {
            return DockerContainerStop(configurator(new DockerContainerStopSettings()));
        }
        /// <summary>
        ///   <p>Stop one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStopSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStopSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerStopSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerStopSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerStop(CombinatorialConfigure<DockerContainerStopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerStop, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove all unused networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkPrune(DockerNetworkPruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkPruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove all unused networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkPrune(Configure<DockerNetworkPruneSettings> configurator)
        {
            return DockerNetworkPrune(configurator(new DockerNetworkPruneSettings()));
        }
        /// <summary>
        ///   <p>Remove all unused networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkPruneSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNetworkPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkPruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkPruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkPrune(CombinatorialConfigure<DockerNetworkPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkPrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display an image manifest, or manifest list.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestInspectSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestInspectSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestInspectSettings.Insecure"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerManifestInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestInspect(DockerManifestInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerManifestInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display an image manifest, or manifest list.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestInspectSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestInspectSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestInspectSettings.Insecure"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerManifestInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestInspect(Configure<DockerManifestInspectSettings> configurator)
        {
            return DockerManifestInspect(configurator(new DockerManifestInspectSettings()));
        }
        /// <summary>
        ///   <p>Display an image manifest, or manifest list.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestInspectSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestInspectSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestInspectSettings.Insecure"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerManifestInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerManifestInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerManifestInspect(CombinatorialConfigure<DockerManifestInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerManifestInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerInfo(DockerInfoSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerInfoSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerInfo(Configure<DockerInfoSettings> configurator)
        {
            return DockerInfo(configurator(new DockerInfoSettings()));
        }
        /// <summary>
        ///   <p>Display system-wide information.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInfoSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInfoSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerInfoSettings Settings, IReadOnlyCollection<Output> Output)> DockerInfo(CombinatorialConfigure<DockerInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerInfo, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCommit(DockerCommitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCommitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCommit(Configure<DockerCommitSettings> configurator)
        {
            return DockerCommit(configurator(new DockerCommitSettings()));
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCommitSettings Settings, IReadOnlyCollection<Output> Output)> DockerCommit(CombinatorialConfigure<DockerCommitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCommit, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerStackDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerStackDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerStackDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerStackDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerStackDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackDeploy(DockerStackDeploySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackDeploySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerStackDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerStackDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerStackDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerStackDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerStackDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackDeploy(Configure<DockerStackDeploySettings> configurator)
        {
            return DockerStackDeploy(configurator(new DockerStackDeploySettings()));
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerStackDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerStackDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerStackDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerStackDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerStackDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackDeploySettings Settings, IReadOnlyCollection<Output> Output)> DockerStackDeploy(CombinatorialConfigure<DockerStackDeploySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStackDeploy, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Scale one or multiple replicated services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceScaleSettings.CliSettings"/></li>
        ///     <li><c>&lt;serviceReplicas&gt;</c> via <see cref="DockerServiceScaleSettings.ServiceReplicas"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceScale(DockerServiceScaleSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceScaleSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Scale one or multiple replicated services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceScaleSettings.CliSettings"/></li>
        ///     <li><c>&lt;serviceReplicas&gt;</c> via <see cref="DockerServiceScaleSettings.ServiceReplicas"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceScale(Configure<DockerServiceScaleSettings> configurator)
        {
            return DockerServiceScale(configurator(new DockerServiceScaleSettings()));
        }
        /// <summary>
        ///   <p>Scale one or multiple replicated services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceScaleSettings.CliSettings"/></li>
        ///     <li><c>&lt;serviceReplicas&gt;</c> via <see cref="DockerServiceScaleSettings.ServiceReplicas"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceScaleSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceScale(CombinatorialConfigure<DockerServiceScaleSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceScale, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRun(DockerRunSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerRunSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRun(Configure<DockerRunSettings> configurator)
        {
            return DockerRun(configurator(new DockerRunSettings()));
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerRunSettings Settings, IReadOnlyCollection<Output> Output)> DockerRun(CombinatorialConfigure<DockerRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerRun, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCreate(DockerCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCreate(Configure<DockerCreateSettings> configurator)
        {
            return DockerCreate(configurator(new DockerCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerCreate(CombinatorialConfigure<DockerCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update a service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceUpdateSettings.Service"/></li>
        ///     <li><c>--args</c> via <see cref="DockerServiceUpdateSettings.Args"/></li>
        ///     <li><c>--config-add</c> via <see cref="DockerServiceUpdateSettings.ConfigAdd"/></li>
        ///     <li><c>--config-rm</c> via <see cref="DockerServiceUpdateSettings.ConfigRm"/></li>
        ///     <li><c>--constraint-add</c> via <see cref="DockerServiceUpdateSettings.ConstraintAdd"/></li>
        ///     <li><c>--constraint-rm</c> via <see cref="DockerServiceUpdateSettings.ConstraintRm"/></li>
        ///     <li><c>--container-label-add</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelAdd"/></li>
        ///     <li><c>--container-label-rm</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelRm"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceUpdateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceUpdateSettings.Detach"/></li>
        ///     <li><c>--dns-add</c> via <see cref="DockerServiceUpdateSettings.DnsAdd"/></li>
        ///     <li><c>--dns-option-add</c> via <see cref="DockerServiceUpdateSettings.DnsOptionAdd"/></li>
        ///     <li><c>--dns-option-rm</c> via <see cref="DockerServiceUpdateSettings.DnsOptionRm"/></li>
        ///     <li><c>--dns-rm</c> via <see cref="DockerServiceUpdateSettings.DnsRm"/></li>
        ///     <li><c>--dns-search-add</c> via <see cref="DockerServiceUpdateSettings.DnsSearchAdd"/></li>
        ///     <li><c>--dns-search-rm</c> via <see cref="DockerServiceUpdateSettings.DnsSearchRm"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceUpdateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceUpdateSettings.Entrypoint"/></li>
        ///     <li><c>--env-add</c> via <see cref="DockerServiceUpdateSettings.EnvAdd"/></li>
        ///     <li><c>--env-rm</c> via <see cref="DockerServiceUpdateSettings.EnvRm"/></li>
        ///     <li><c>--force</c> via <see cref="DockerServiceUpdateSettings.Force"/></li>
        ///     <li><c>--generic-resource-add</c> via <see cref="DockerServiceUpdateSettings.GenericResourceAdd"/></li>
        ///     <li><c>--generic-resource-rm</c> via <see cref="DockerServiceUpdateSettings.GenericResourceRm"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerServiceUpdateSettings.GroupAdd"/></li>
        ///     <li><c>--group-rm</c> via <see cref="DockerServiceUpdateSettings.GroupRm"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceUpdateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceUpdateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceUpdateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceUpdateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceUpdateSettings.HealthTimeout"/></li>
        ///     <li><c>--host-add</c> via <see cref="DockerServiceUpdateSettings.HostAdd"/></li>
        ///     <li><c>--host-rm</c> via <see cref="DockerServiceUpdateSettings.HostRm"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceUpdateSettings.Hostname"/></li>
        ///     <li><c>--image</c> via <see cref="DockerServiceUpdateSettings.Image"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceUpdateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceUpdateSettings.Isolation"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerServiceUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerServiceUpdateSettings.LabelRm"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceUpdateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceUpdateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceUpdateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceUpdateSettings.LogOpt"/></li>
        ///     <li><c>--mount-add</c> via <see cref="DockerServiceUpdateSettings.MountAdd"/></li>
        ///     <li><c>--mount-rm</c> via <see cref="DockerServiceUpdateSettings.MountRm"/></li>
        ///     <li><c>--network-add</c> via <see cref="DockerServiceUpdateSettings.NetworkAdd"/></li>
        ///     <li><c>--network-rm</c> via <see cref="DockerServiceUpdateSettings.NetworkRm"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceUpdateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceUpdateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref-add</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefAdd"/></li>
        ///     <li><c>--placement-pref-rm</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefRm"/></li>
        ///     <li><c>--publish-add</c> via <see cref="DockerServiceUpdateSettings.PublishAdd"/></li>
        ///     <li><c>--publish-rm</c> via <see cref="DockerServiceUpdateSettings.PublishRm"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceUpdateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceUpdateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceUpdateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceUpdateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceUpdateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceUpdateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceUpdateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceUpdateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceUpdateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceUpdateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback</c> via <see cref="DockerServiceUpdateSettings.Rollback"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceUpdateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceUpdateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceUpdateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceUpdateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceUpdateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret-add</c> via <see cref="DockerServiceUpdateSettings.SecretAdd"/></li>
        ///     <li><c>--secret-rm</c> via <see cref="DockerServiceUpdateSettings.SecretRm"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceUpdateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceUpdateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl-add</c> via <see cref="DockerServiceUpdateSettings.SysctlAdd"/></li>
        ///     <li><c>--sysctl-rm</c> via <see cref="DockerServiceUpdateSettings.SysctlRm"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceUpdateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceUpdateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceUpdateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceUpdateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceUpdateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceUpdateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceUpdateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceUpdateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceUpdateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceUpdate(DockerServiceUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update a service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceUpdateSettings.Service"/></li>
        ///     <li><c>--args</c> via <see cref="DockerServiceUpdateSettings.Args"/></li>
        ///     <li><c>--config-add</c> via <see cref="DockerServiceUpdateSettings.ConfigAdd"/></li>
        ///     <li><c>--config-rm</c> via <see cref="DockerServiceUpdateSettings.ConfigRm"/></li>
        ///     <li><c>--constraint-add</c> via <see cref="DockerServiceUpdateSettings.ConstraintAdd"/></li>
        ///     <li><c>--constraint-rm</c> via <see cref="DockerServiceUpdateSettings.ConstraintRm"/></li>
        ///     <li><c>--container-label-add</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelAdd"/></li>
        ///     <li><c>--container-label-rm</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelRm"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceUpdateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceUpdateSettings.Detach"/></li>
        ///     <li><c>--dns-add</c> via <see cref="DockerServiceUpdateSettings.DnsAdd"/></li>
        ///     <li><c>--dns-option-add</c> via <see cref="DockerServiceUpdateSettings.DnsOptionAdd"/></li>
        ///     <li><c>--dns-option-rm</c> via <see cref="DockerServiceUpdateSettings.DnsOptionRm"/></li>
        ///     <li><c>--dns-rm</c> via <see cref="DockerServiceUpdateSettings.DnsRm"/></li>
        ///     <li><c>--dns-search-add</c> via <see cref="DockerServiceUpdateSettings.DnsSearchAdd"/></li>
        ///     <li><c>--dns-search-rm</c> via <see cref="DockerServiceUpdateSettings.DnsSearchRm"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceUpdateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceUpdateSettings.Entrypoint"/></li>
        ///     <li><c>--env-add</c> via <see cref="DockerServiceUpdateSettings.EnvAdd"/></li>
        ///     <li><c>--env-rm</c> via <see cref="DockerServiceUpdateSettings.EnvRm"/></li>
        ///     <li><c>--force</c> via <see cref="DockerServiceUpdateSettings.Force"/></li>
        ///     <li><c>--generic-resource-add</c> via <see cref="DockerServiceUpdateSettings.GenericResourceAdd"/></li>
        ///     <li><c>--generic-resource-rm</c> via <see cref="DockerServiceUpdateSettings.GenericResourceRm"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerServiceUpdateSettings.GroupAdd"/></li>
        ///     <li><c>--group-rm</c> via <see cref="DockerServiceUpdateSettings.GroupRm"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceUpdateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceUpdateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceUpdateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceUpdateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceUpdateSettings.HealthTimeout"/></li>
        ///     <li><c>--host-add</c> via <see cref="DockerServiceUpdateSettings.HostAdd"/></li>
        ///     <li><c>--host-rm</c> via <see cref="DockerServiceUpdateSettings.HostRm"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceUpdateSettings.Hostname"/></li>
        ///     <li><c>--image</c> via <see cref="DockerServiceUpdateSettings.Image"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceUpdateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceUpdateSettings.Isolation"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerServiceUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerServiceUpdateSettings.LabelRm"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceUpdateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceUpdateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceUpdateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceUpdateSettings.LogOpt"/></li>
        ///     <li><c>--mount-add</c> via <see cref="DockerServiceUpdateSettings.MountAdd"/></li>
        ///     <li><c>--mount-rm</c> via <see cref="DockerServiceUpdateSettings.MountRm"/></li>
        ///     <li><c>--network-add</c> via <see cref="DockerServiceUpdateSettings.NetworkAdd"/></li>
        ///     <li><c>--network-rm</c> via <see cref="DockerServiceUpdateSettings.NetworkRm"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceUpdateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceUpdateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref-add</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefAdd"/></li>
        ///     <li><c>--placement-pref-rm</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefRm"/></li>
        ///     <li><c>--publish-add</c> via <see cref="DockerServiceUpdateSettings.PublishAdd"/></li>
        ///     <li><c>--publish-rm</c> via <see cref="DockerServiceUpdateSettings.PublishRm"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceUpdateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceUpdateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceUpdateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceUpdateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceUpdateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceUpdateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceUpdateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceUpdateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceUpdateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceUpdateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback</c> via <see cref="DockerServiceUpdateSettings.Rollback"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceUpdateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceUpdateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceUpdateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceUpdateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceUpdateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret-add</c> via <see cref="DockerServiceUpdateSettings.SecretAdd"/></li>
        ///     <li><c>--secret-rm</c> via <see cref="DockerServiceUpdateSettings.SecretRm"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceUpdateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceUpdateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl-add</c> via <see cref="DockerServiceUpdateSettings.SysctlAdd"/></li>
        ///     <li><c>--sysctl-rm</c> via <see cref="DockerServiceUpdateSettings.SysctlRm"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceUpdateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceUpdateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceUpdateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceUpdateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceUpdateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceUpdateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceUpdateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceUpdateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceUpdateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceUpdate(Configure<DockerServiceUpdateSettings> configurator)
        {
            return DockerServiceUpdate(configurator(new DockerServiceUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update a service.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceUpdateSettings.Service"/></li>
        ///     <li><c>--args</c> via <see cref="DockerServiceUpdateSettings.Args"/></li>
        ///     <li><c>--config-add</c> via <see cref="DockerServiceUpdateSettings.ConfigAdd"/></li>
        ///     <li><c>--config-rm</c> via <see cref="DockerServiceUpdateSettings.ConfigRm"/></li>
        ///     <li><c>--constraint-add</c> via <see cref="DockerServiceUpdateSettings.ConstraintAdd"/></li>
        ///     <li><c>--constraint-rm</c> via <see cref="DockerServiceUpdateSettings.ConstraintRm"/></li>
        ///     <li><c>--container-label-add</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelAdd"/></li>
        ///     <li><c>--container-label-rm</c> via <see cref="DockerServiceUpdateSettings.ContainerLabelRm"/></li>
        ///     <li><c>--credential-spec</c> via <see cref="DockerServiceUpdateSettings.CredentialSpec"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceUpdateSettings.Detach"/></li>
        ///     <li><c>--dns-add</c> via <see cref="DockerServiceUpdateSettings.DnsAdd"/></li>
        ///     <li><c>--dns-option-add</c> via <see cref="DockerServiceUpdateSettings.DnsOptionAdd"/></li>
        ///     <li><c>--dns-option-rm</c> via <see cref="DockerServiceUpdateSettings.DnsOptionRm"/></li>
        ///     <li><c>--dns-rm</c> via <see cref="DockerServiceUpdateSettings.DnsRm"/></li>
        ///     <li><c>--dns-search-add</c> via <see cref="DockerServiceUpdateSettings.DnsSearchAdd"/></li>
        ///     <li><c>--dns-search-rm</c> via <see cref="DockerServiceUpdateSettings.DnsSearchRm"/></li>
        ///     <li><c>--endpoint-mode</c> via <see cref="DockerServiceUpdateSettings.EndpointMode"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerServiceUpdateSettings.Entrypoint"/></li>
        ///     <li><c>--env-add</c> via <see cref="DockerServiceUpdateSettings.EnvAdd"/></li>
        ///     <li><c>--env-rm</c> via <see cref="DockerServiceUpdateSettings.EnvRm"/></li>
        ///     <li><c>--force</c> via <see cref="DockerServiceUpdateSettings.Force"/></li>
        ///     <li><c>--generic-resource-add</c> via <see cref="DockerServiceUpdateSettings.GenericResourceAdd"/></li>
        ///     <li><c>--generic-resource-rm</c> via <see cref="DockerServiceUpdateSettings.GenericResourceRm"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerServiceUpdateSettings.GroupAdd"/></li>
        ///     <li><c>--group-rm</c> via <see cref="DockerServiceUpdateSettings.GroupRm"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerServiceUpdateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerServiceUpdateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerServiceUpdateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerServiceUpdateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerServiceUpdateSettings.HealthTimeout"/></li>
        ///     <li><c>--host-add</c> via <see cref="DockerServiceUpdateSettings.HostAdd"/></li>
        ///     <li><c>--host-rm</c> via <see cref="DockerServiceUpdateSettings.HostRm"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerServiceUpdateSettings.Hostname"/></li>
        ///     <li><c>--image</c> via <see cref="DockerServiceUpdateSettings.Image"/></li>
        ///     <li><c>--init</c> via <see cref="DockerServiceUpdateSettings.Init"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerServiceUpdateSettings.Isolation"/></li>
        ///     <li><c>--label-add</c> via <see cref="DockerServiceUpdateSettings.LabelAdd"/></li>
        ///     <li><c>--label-rm</c> via <see cref="DockerServiceUpdateSettings.LabelRm"/></li>
        ///     <li><c>--limit-cpu</c> via <see cref="DockerServiceUpdateSettings.LimitCpu"/></li>
        ///     <li><c>--limit-memory</c> via <see cref="DockerServiceUpdateSettings.LimitMemory"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerServiceUpdateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerServiceUpdateSettings.LogOpt"/></li>
        ///     <li><c>--mount-add</c> via <see cref="DockerServiceUpdateSettings.MountAdd"/></li>
        ///     <li><c>--mount-rm</c> via <see cref="DockerServiceUpdateSettings.MountRm"/></li>
        ///     <li><c>--network-add</c> via <see cref="DockerServiceUpdateSettings.NetworkAdd"/></li>
        ///     <li><c>--network-rm</c> via <see cref="DockerServiceUpdateSettings.NetworkRm"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerServiceUpdateSettings.NoHealthcheck"/></li>
        ///     <li><c>--no-resolve-image</c> via <see cref="DockerServiceUpdateSettings.NoResolveImage"/></li>
        ///     <li><c>--placement-pref-add</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefAdd"/></li>
        ///     <li><c>--placement-pref-rm</c> via <see cref="DockerServiceUpdateSettings.PlacementPrefRm"/></li>
        ///     <li><c>--publish-add</c> via <see cref="DockerServiceUpdateSettings.PublishAdd"/></li>
        ///     <li><c>--publish-rm</c> via <see cref="DockerServiceUpdateSettings.PublishRm"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceUpdateSettings.Quiet"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerServiceUpdateSettings.ReadOnly"/></li>
        ///     <li><c>--replicas</c> via <see cref="DockerServiceUpdateSettings.Replicas"/></li>
        ///     <li><c>--replicas-max-per-node</c> via <see cref="DockerServiceUpdateSettings.ReplicasMaxPerNode"/></li>
        ///     <li><c>--reserve-cpu</c> via <see cref="DockerServiceUpdateSettings.ReserveCpu"/></li>
        ///     <li><c>--reserve-memory</c> via <see cref="DockerServiceUpdateSettings.ReserveMemory"/></li>
        ///     <li><c>--restart-condition</c> via <see cref="DockerServiceUpdateSettings.RestartCondition"/></li>
        ///     <li><c>--restart-delay</c> via <see cref="DockerServiceUpdateSettings.RestartDelay"/></li>
        ///     <li><c>--restart-max-attempts</c> via <see cref="DockerServiceUpdateSettings.RestartMaxAttempts"/></li>
        ///     <li><c>--restart-window</c> via <see cref="DockerServiceUpdateSettings.RestartWindow"/></li>
        ///     <li><c>--rollback</c> via <see cref="DockerServiceUpdateSettings.Rollback"/></li>
        ///     <li><c>--rollback-delay</c> via <see cref="DockerServiceUpdateSettings.RollbackDelay"/></li>
        ///     <li><c>--rollback-failure-action</c> via <see cref="DockerServiceUpdateSettings.RollbackFailureAction"/></li>
        ///     <li><c>--rollback-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.RollbackMaxFailureRatio"/></li>
        ///     <li><c>--rollback-monitor</c> via <see cref="DockerServiceUpdateSettings.RollbackMonitor"/></li>
        ///     <li><c>--rollback-order</c> via <see cref="DockerServiceUpdateSettings.RollbackOrder"/></li>
        ///     <li><c>--rollback-parallelism</c> via <see cref="DockerServiceUpdateSettings.RollbackParallelism"/></li>
        ///     <li><c>--secret-add</c> via <see cref="DockerServiceUpdateSettings.SecretAdd"/></li>
        ///     <li><c>--secret-rm</c> via <see cref="DockerServiceUpdateSettings.SecretRm"/></li>
        ///     <li><c>--stop-grace-period</c> via <see cref="DockerServiceUpdateSettings.StopGracePeriod"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerServiceUpdateSettings.StopSignal"/></li>
        ///     <li><c>--sysctl-add</c> via <see cref="DockerServiceUpdateSettings.SysctlAdd"/></li>
        ///     <li><c>--sysctl-rm</c> via <see cref="DockerServiceUpdateSettings.SysctlRm"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerServiceUpdateSettings.Tty"/></li>
        ///     <li><c>--update-delay</c> via <see cref="DockerServiceUpdateSettings.UpdateDelay"/></li>
        ///     <li><c>--update-failure-action</c> via <see cref="DockerServiceUpdateSettings.UpdateFailureAction"/></li>
        ///     <li><c>--update-max-failure-ratio</c> via <see cref="DockerServiceUpdateSettings.UpdateMaxFailureRatio"/></li>
        ///     <li><c>--update-monitor</c> via <see cref="DockerServiceUpdateSettings.UpdateMonitor"/></li>
        ///     <li><c>--update-order</c> via <see cref="DockerServiceUpdateSettings.UpdateOrder"/></li>
        ///     <li><c>--update-parallelism</c> via <see cref="DockerServiceUpdateSettings.UpdateParallelism"/></li>
        ///     <li><c>--user</c> via <see cref="DockerServiceUpdateSettings.User"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerServiceUpdateSettings.WithRegistryAuth"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerServiceUpdateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceUpdate(CombinatorialConfigure<DockerServiceUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPort(DockerPortSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPortSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPort(Configure<DockerPortSettings> configurator)
        {
            return DockerPort(configurator(new DockerPortSettings()));
        }
        /// <summary>
        ///   <p>List port mappings or a specific mapping for the container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPortSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerPortSettings.Container"/></li>
        ///     <li><c>&lt;privatePort&gt;</c> via <see cref="DockerPortSettings.PrivatePort"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPortSettings Settings, IReadOnlyCollection<Output> Output)> DockerPort(CombinatorialConfigure<DockerPortSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPort, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainer(DockerContainerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainer(Configure<DockerContainerSettings> configurator)
        {
            return DockerContainer(configurator(new DockerContainerSettings()));
        }
        /// <summary>
        ///   <p>Manage containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainer(CombinatorialConfigure<DockerContainerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainer, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePush(DockerImagePushSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImagePushSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePush(Configure<DockerImagePushSettings> configurator)
        {
            return DockerImagePush(configurator(new DockerImagePushSettings()));
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImagePushSettings Settings, IReadOnlyCollection<Output> Output)> DockerImagePush(CombinatorialConfigure<DockerImagePushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImagePush, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceInspectSettings.Services"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerServiceInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceInspect(DockerServiceInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceInspectSettings.Services"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerServiceInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceInspect(Configure<DockerServiceInspectSettings> configurator)
        {
            return DockerServiceInspect(configurator(new DockerServiceInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more services.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;services&gt;</c> via <see cref="DockerServiceInspectSettings.Services"/></li>
        ///     <li><c>--format</c> via <see cref="DockerServiceInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerServiceInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceInspect(CombinatorialConfigure<DockerServiceInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Connect a container to a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkConnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkConnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkConnectSettings.Network"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerNetworkConnectSettings.Alias"/></li>
        ///     <li><c>--driver-opt</c> via <see cref="DockerNetworkConnectSettings.DriverOpt"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerNetworkConnectSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerNetworkConnectSettings.Ip6"/></li>
        ///     <li><c>--link</c> via <see cref="DockerNetworkConnectSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerNetworkConnectSettings.LinkLocalIp"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkConnect(DockerNetworkConnectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkConnectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Connect a container to a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkConnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkConnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkConnectSettings.Network"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerNetworkConnectSettings.Alias"/></li>
        ///     <li><c>--driver-opt</c> via <see cref="DockerNetworkConnectSettings.DriverOpt"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerNetworkConnectSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerNetworkConnectSettings.Ip6"/></li>
        ///     <li><c>--link</c> via <see cref="DockerNetworkConnectSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerNetworkConnectSettings.LinkLocalIp"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkConnect(Configure<DockerNetworkConnectSettings> configurator)
        {
            return DockerNetworkConnect(configurator(new DockerNetworkConnectSettings()));
        }
        /// <summary>
        ///   <p>Connect a container to a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkConnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkConnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkConnectSettings.Network"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerNetworkConnectSettings.Alias"/></li>
        ///     <li><c>--driver-opt</c> via <see cref="DockerNetworkConnectSettings.DriverOpt"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerNetworkConnectSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerNetworkConnectSettings.Ip6"/></li>
        ///     <li><c>--link</c> via <see cref="DockerNetworkConnectSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerNetworkConnectSettings.LinkLocalIp"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkConnectSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkConnect(CombinatorialConfigure<DockerNetworkConnectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkConnect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSecretLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSecretLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretLs(DockerSecretLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSecretLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSecretLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSecretLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSecretLs(Configure<DockerSecretLsSettings> configurator)
        {
            return DockerSecretLs(configurator(new DockerSecretLsSettings()));
        }
        /// <summary>
        ///   <p>List secrets.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSecretLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSecretLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSecretLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSecretLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSecretLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerSecretLs(CombinatorialConfigure<DockerSecretLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSecretLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Leave the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmLeaveSettings.CliSettings"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSwarmLeaveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmLeave(DockerSwarmLeaveSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmLeaveSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Leave the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmLeaveSettings.CliSettings"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSwarmLeaveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmLeave(Configure<DockerSwarmLeaveSettings> configurator)
        {
            return DockerSwarmLeave(configurator(new DockerSwarmLeaveSettings()));
        }
        /// <summary>
        ///   <p>Leave the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmLeaveSettings.CliSettings"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSwarmLeaveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmLeaveSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmLeave(CombinatorialConfigure<DockerSwarmLeaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmLeave, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagesSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImagesSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagesSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImagesSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImagesSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImagesSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImages(DockerImagesSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImagesSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagesSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImagesSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagesSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImagesSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImagesSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImagesSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImages(Configure<DockerImagesSettings> configurator)
        {
            return DockerImages(configurator(new DockerImagesSettings()));
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagesSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImagesSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagesSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImagesSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagesSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImagesSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImagesSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagesSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImagesSettings Settings, IReadOnlyCollection<Output> Output)> DockerImages(CombinatorialConfigure<DockerImagesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImages, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update a local engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineUpdateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineUpdateSettings.Containerd"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineUpdateSettings.EngineImage"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineUpdateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineUpdateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineUpdate(DockerEngineUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerEngineUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update a local engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineUpdateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineUpdateSettings.Containerd"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineUpdateSettings.EngineImage"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineUpdateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineUpdateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineUpdate(Configure<DockerEngineUpdateSettings> configurator)
        {
            return DockerEngineUpdate(configurator(new DockerEngineUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update a local engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineUpdateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineUpdateSettings.Containerd"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineUpdateSettings.EngineImage"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineUpdateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineUpdateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerEngineUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerEngineUpdate(CombinatorialConfigure<DockerEngineUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerEngineUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerSystemEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerSystemEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemEvents(DockerSystemEventsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSystemEventsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerSystemEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerSystemEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemEvents(Configure<DockerSystemEventsSettings> configurator)
        {
            return DockerSystemEvents(configurator(new DockerSystemEventsSettings()));
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerSystemEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerSystemEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSystemEventsSettings Settings, IReadOnlyCollection<Output> Output)> DockerSystemEvents(CombinatorialConfigure<DockerSystemEventsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSystemEvents, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Return low-level information on Docker objects.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;names&gt;</c> via <see cref="DockerInspectSettings.Names"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerInspectSettings.Size"/></li>
        ///     <li><c>--type</c> via <see cref="DockerInspectSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerInspect(DockerInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Return low-level information on Docker objects.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;names&gt;</c> via <see cref="DockerInspectSettings.Names"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerInspectSettings.Size"/></li>
        ///     <li><c>--type</c> via <see cref="DockerInspectSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerInspect(Configure<DockerInspectSettings> configurator)
        {
            return DockerInspect(configurator(new DockerInspectSettings()));
        }
        /// <summary>
        ///   <p>Return low-level information on Docker objects.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;names&gt;</c> via <see cref="DockerInspectSettings.Names"/></li>
        ///     <li><c>--format</c> via <see cref="DockerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerInspectSettings.Size"/></li>
        ///     <li><c>--type</c> via <see cref="DockerInspectSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerInspect(CombinatorialConfigure<DockerInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Check for available engine updates.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineCheckSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineCheckSettings.Containerd"/></li>
        ///     <li><c>--downgrades</c> via <see cref="DockerEngineCheckSettings.Downgrades"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineCheckSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineCheckSettings.Format"/></li>
        ///     <li><c>--pre-releases</c> via <see cref="DockerEngineCheckSettings.PreReleases"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineCheckSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineCheckSettings.RegistryPrefix"/></li>
        ///     <li><c>--upgrades</c> via <see cref="DockerEngineCheckSettings.Upgrades"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineCheck(DockerEngineCheckSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerEngineCheckSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Check for available engine updates.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineCheckSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineCheckSettings.Containerd"/></li>
        ///     <li><c>--downgrades</c> via <see cref="DockerEngineCheckSettings.Downgrades"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineCheckSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineCheckSettings.Format"/></li>
        ///     <li><c>--pre-releases</c> via <see cref="DockerEngineCheckSettings.PreReleases"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineCheckSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineCheckSettings.RegistryPrefix"/></li>
        ///     <li><c>--upgrades</c> via <see cref="DockerEngineCheckSettings.Upgrades"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineCheck(Configure<DockerEngineCheckSettings> configurator)
        {
            return DockerEngineCheck(configurator(new DockerEngineCheckSettings()));
        }
        /// <summary>
        ///   <p>Check for available engine updates.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineCheckSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineCheckSettings.Containerd"/></li>
        ///     <li><c>--downgrades</c> via <see cref="DockerEngineCheckSettings.Downgrades"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineCheckSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineCheckSettings.Format"/></li>
        ///     <li><c>--pre-releases</c> via <see cref="DockerEngineCheckSettings.PreReleases"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineCheckSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineCheckSettings.RegistryPrefix"/></li>
        ///     <li><c>--upgrades</c> via <see cref="DockerEngineCheckSettings.Upgrades"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerEngineCheckSettings Settings, IReadOnlyCollection<Output> Output)> DockerEngineCheck(CombinatorialConfigure<DockerEngineCheckSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerEngineCheck, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerAttach(DockerAttachSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerAttachSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerAttach(Configure<DockerAttachSettings> configurator)
        {
            return DockerAttach(configurator(new DockerAttachSettings()));
        }
        /// <summary>
        ///   <p>Attach local standard input, output, and error streams to a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerAttachSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerAttachSettings.Container"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerAttachSettings.DetachKeys"/></li>
        ///     <li><c>--no-stdin</c> via <see cref="DockerAttachSettings.NoStdin"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerAttachSettings.SigProxy"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerAttachSettings Settings, IReadOnlyCollection<Output> Output)> DockerAttach(CombinatorialConfigure<DockerAttachSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerAttach, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerWait(DockerContainerWaitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerWaitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerWait(Configure<DockerContainerWaitSettings> configurator)
        {
            return DockerContainerWait(configurator(new DockerContainerWaitSettings()));
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerWaitSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerWait(CombinatorialConfigure<DockerContainerWaitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerWait, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display and rotate the root CA.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmCaSettings.CliSettings"/></li>
        ///     <li><c>--ca-cert</c> via <see cref="DockerSwarmCaSettings.CaCert"/></li>
        ///     <li><c>--ca-key</c> via <see cref="DockerSwarmCaSettings.CaKey"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmCaSettings.CertExpiry"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerSwarmCaSettings.Detach"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmCaSettings.ExternalCa"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmCaSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmCaSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmCa(DockerSwarmCaSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmCaSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display and rotate the root CA.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmCaSettings.CliSettings"/></li>
        ///     <li><c>--ca-cert</c> via <see cref="DockerSwarmCaSettings.CaCert"/></li>
        ///     <li><c>--ca-key</c> via <see cref="DockerSwarmCaSettings.CaKey"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmCaSettings.CertExpiry"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerSwarmCaSettings.Detach"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmCaSettings.ExternalCa"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmCaSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmCaSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmCa(Configure<DockerSwarmCaSettings> configurator)
        {
            return DockerSwarmCa(configurator(new DockerSwarmCaSettings()));
        }
        /// <summary>
        ///   <p>Display and rotate the root CA.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmCaSettings.CliSettings"/></li>
        ///     <li><c>--ca-cert</c> via <see cref="DockerSwarmCaSettings.CaCert"/></li>
        ///     <li><c>--ca-key</c> via <see cref="DockerSwarmCaSettings.CaKey"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmCaSettings.CertExpiry"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerSwarmCaSettings.Detach"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmCaSettings.ExternalCa"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmCaSettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmCaSettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmCaSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmCa(CombinatorialConfigure<DockerSwarmCaSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmCa, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage the docker engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerEngineSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngine(DockerEngineSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerEngineSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage the docker engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerEngineSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngine(Configure<DockerEngineSettings> configurator)
        {
            return DockerEngine(configurator(new DockerEngineSettings()));
        }
        /// <summary>
        ///   <p>Manage the docker engine.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerEngineSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerEngineSettings Settings, IReadOnlyCollection<Output> Output)> DockerEngine(CombinatorialConfigure<DockerEngineSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerEngine, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove unused data.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemPruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerSystemPruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSystemPruneSettings.Force"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerSystemPruneSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemPrune(DockerSystemPruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSystemPruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove unused data.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemPruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerSystemPruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSystemPruneSettings.Force"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerSystemPruneSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemPrune(Configure<DockerSystemPruneSettings> configurator)
        {
            return DockerSystemPrune(configurator(new DockerSystemPruneSettings()));
        }
        /// <summary>
        ///   <p>Remove unused data.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemPruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerSystemPruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSystemPruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerSystemPruneSettings.Force"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerSystemPruneSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSystemPruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerSystemPrune(CombinatorialConfigure<DockerSystemPruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSystemPrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage builds.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilder(DockerBuilderSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerBuilderSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage builds.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilder(Configure<DockerBuilderSettings> configurator)
        {
            return DockerBuilder(configurator(new DockerBuilderSettings()));
        }
        /// <summary>
        ///   <p>Manage builds.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerBuilderSettings Settings, IReadOnlyCollection<Output> Output)> DockerBuilder(CombinatorialConfigure<DockerBuilderSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerBuilder, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPause(DockerContainerPauseSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerPauseSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerPause(Configure<DockerContainerPauseSettings> configurator)
        {
            return DockerContainerPause(configurator(new DockerContainerPauseSettings()));
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerPauseSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerPause(CombinatorialConfigure<DockerContainerPauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerPause, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerContainerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerContainerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerContainerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerContainerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerContainerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerCommit(DockerContainerCommitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerCommitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerContainerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerContainerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerContainerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerContainerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerContainerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerCommit(Configure<DockerContainerCommitSettings> configurator)
        {
            return DockerContainerCommit(configurator(new DockerContainerCommitSettings()));
        }
        /// <summary>
        ///   <p>Create a new image from a container's changes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCommitSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerCommitSettings.Container"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerContainerCommitSettings.Repository"/></li>
        ///     <li><c>--author</c> via <see cref="DockerContainerCommitSettings.Author"/></li>
        ///     <li><c>--change</c> via <see cref="DockerContainerCommitSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerContainerCommitSettings.Message"/></li>
        ///     <li><c>--pause</c> via <see cref="DockerContainerCommitSettings.Pause"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerCommitSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerCommit(CombinatorialConfigure<DockerContainerCommitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerCommit, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextLsSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContextLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextLs(DockerContextLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextLsSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContextLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextLs(Configure<DockerContextLsSettings> configurator)
        {
            return DockerContextLs(configurator(new DockerContextLsSettings()));
        }
        /// <summary>
        ///   <p>List contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextLsSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContextLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextLs(CombinatorialConfigure<DockerContextLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextRmSettings.Contexts"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextRm(DockerContextRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextRmSettings.Contexts"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextRm(Configure<DockerContextRmSettings> configurator)
        {
            return DockerContextRm(configurator(new DockerContextRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextRmSettings.Contexts"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextRm(CombinatorialConfigure<DockerContextRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List the tasks in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackPsSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackPsSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackPsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackPsSettings.Namespace"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerStackPsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStackPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackPsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackPs(DockerStackPsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackPsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List the tasks in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackPsSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackPsSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackPsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackPsSettings.Namespace"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerStackPsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStackPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackPsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackPs(Configure<DockerStackPsSettings> configurator)
        {
            return DockerStackPs(configurator(new DockerStackPsSettings()));
        }
        /// <summary>
        ///   <p>List the tasks in the stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackPsSettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerStackPsSettings.Stack"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerStackPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackPsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackPsSettings.Namespace"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerStackPsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStackPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerStackPsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackPsSettings Settings, IReadOnlyCollection<Output> Output)> DockerStackPs(CombinatorialConfigure<DockerStackPsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStackPs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerCreate(DockerContainerCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerCreate(Configure<DockerContainerCreateSettings> configurator)
        {
            return DockerContainerCreate(configurator(new DockerContainerCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerCreateSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerCreateSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerCreateSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerCreateSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerCreateSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerCreateSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerCreateSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerCreateSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerCreateSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerCreateSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerCreateSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerCreateSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerCreateSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerCreateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerCreateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerCreateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerCreateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerCreateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerCreateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerCreateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerCreateSettings.CpusetMems"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerCreateSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerCreateSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerCreateSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerCreateSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerCreateSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerCreateSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerCreateSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerCreateSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerCreateSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerCreateSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerCreateSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerCreateSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerCreateSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerCreateSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerCreateSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerCreateSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerCreateSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerCreateSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerCreateSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerCreateSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerCreateSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerCreateSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerCreateSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerCreateSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerCreateSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerCreateSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerCreateSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerCreateSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerCreateSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerCreateSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerCreateSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerCreateSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerCreateSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerCreateSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerCreateSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerCreateSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerCreateSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerCreateSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerCreateSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerCreateSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerCreateSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerCreateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerCreateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerCreateSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerCreateSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerCreateSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerCreateSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerCreateSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerCreateSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerCreateSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerCreateSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerCreateSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerCreateSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerCreateSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerCreateSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerCreateSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerCreateSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerCreateSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerCreateSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerCreateSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerCreateSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerCreateSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerCreateSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerCreateSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerCreateSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerCreateSettings.ShmSize"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerCreateSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerCreateSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerCreateSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerCreateSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerCreateSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerCreateSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerCreateSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerCreateSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerCreateSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerCreateSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerCreateSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerCreateSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerCreateSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerCreateSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerCreate(CombinatorialConfigure<DockerContainerCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a volume.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;volume&gt;</c> via <see cref="DockerVolumeCreateSettings.Volume"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerVolumeCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerVolumeCreateSettings.Label"/></li>
        ///     <li><c>--name</c> via <see cref="DockerVolumeCreateSettings.Name"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerVolumeCreateSettings.Opt"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeCreate(DockerVolumeCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumeCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a volume.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;volume&gt;</c> via <see cref="DockerVolumeCreateSettings.Volume"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerVolumeCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerVolumeCreateSettings.Label"/></li>
        ///     <li><c>--name</c> via <see cref="DockerVolumeCreateSettings.Name"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerVolumeCreateSettings.Opt"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeCreate(Configure<DockerVolumeCreateSettings> configurator)
        {
            return DockerVolumeCreate(configurator(new DockerVolumeCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a volume.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;volume&gt;</c> via <see cref="DockerVolumeCreateSettings.Volume"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerVolumeCreateSettings.Driver"/></li>
        ///     <li><c>--label</c> via <see cref="DockerVolumeCreateSettings.Label"/></li>
        ///     <li><c>--name</c> via <see cref="DockerVolumeCreateSettings.Name"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerVolumeCreateSettings.Opt"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumeCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolumeCreate(CombinatorialConfigure<DockerVolumeCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolumeCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPlugin(DockerPluginSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPlugin(Configure<DockerPluginSettings> configurator)
        {
            return DockerPlugin(configurator(new DockerPluginSettings()));
        }
        /// <summary>
        ///   <p>Manage plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginSettings Settings, IReadOnlyCollection<Output> Output)> DockerPlugin(CombinatorialConfigure<DockerPluginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPlugin, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Log in to a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoginSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLoginSettings.Server"/></li>
        ///     <li><c>--password</c> via <see cref="DockerLoginSettings.Password"/></li>
        ///     <li><c>--username</c> via <see cref="DockerLoginSettings.Username"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogin(DockerLoginSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerLoginSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Log in to a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoginSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLoginSettings.Server"/></li>
        ///     <li><c>--password</c> via <see cref="DockerLoginSettings.Password"/></li>
        ///     <li><c>--username</c> via <see cref="DockerLoginSettings.Username"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogin(Configure<DockerLoginSettings> configurator)
        {
            return DockerLogin(configurator(new DockerLoginSettings()));
        }
        /// <summary>
        ///   <p>Log in to a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLoginSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLoginSettings.Server"/></li>
        ///     <li><c>--password</c> via <see cref="DockerLoginSettings.Password"/></li>
        ///     <li><c>--username</c> via <see cref="DockerLoginSettings.Username"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerLoginSettings Settings, IReadOnlyCollection<Output> Output)> DockerLogin(CombinatorialConfigure<DockerLoginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerLogin, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage the unlock key.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockKeySettings.CliSettings"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmUnlockKeySettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmUnlockKeySettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUnlockKey(DockerSwarmUnlockKeySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmUnlockKeySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage the unlock key.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockKeySettings.CliSettings"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmUnlockKeySettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmUnlockKeySettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmUnlockKey(Configure<DockerSwarmUnlockKeySettings> configurator)
        {
            return DockerSwarmUnlockKey(configurator(new DockerSwarmUnlockKeySettings()));
        }
        /// <summary>
        ///   <p>Manage the unlock key.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmUnlockKeySettings.CliSettings"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerSwarmUnlockKeySettings.Quiet"/></li>
        ///     <li><c>--rotate</c> via <see cref="DockerSwarmUnlockKeySettings.Rotate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmUnlockKeySettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmUnlockKey(CombinatorialConfigure<DockerSwarmUnlockKeySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmUnlockKey, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStart(DockerStartSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStartSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStart(Configure<DockerStartSettings> configurator)
        {
            return DockerStart(configurator(new DockerStartSettings()));
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStartSettings Settings, IReadOnlyCollection<Output> Output)> DockerStart(CombinatorialConfigure<DockerStartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStart, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Initialize a swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmInitSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmInitSettings.AdvertiseAddr"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmInitSettings.Autolock"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmInitSettings.Availability"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmInitSettings.CertExpiry"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmInitSettings.DataPathAddr"/></li>
        ///     <li><c>--data-path-port</c> via <see cref="DockerSwarmInitSettings.DataPathPort"/></li>
        ///     <li><c>--default-addr-pool</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPool"/></li>
        ///     <li><c>--default-addr-pool-mask-length</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPoolMaskLength"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmInitSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmInitSettings.ExternalCa"/></li>
        ///     <li><c>--force-new-cluster</c> via <see cref="DockerSwarmInitSettings.ForceNewCluster"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmInitSettings.ListenAddr"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmInitSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmInitSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmInitSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmInit(DockerSwarmInitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmInitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Initialize a swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmInitSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmInitSettings.AdvertiseAddr"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmInitSettings.Autolock"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmInitSettings.Availability"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmInitSettings.CertExpiry"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmInitSettings.DataPathAddr"/></li>
        ///     <li><c>--data-path-port</c> via <see cref="DockerSwarmInitSettings.DataPathPort"/></li>
        ///     <li><c>--default-addr-pool</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPool"/></li>
        ///     <li><c>--default-addr-pool-mask-length</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPoolMaskLength"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmInitSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmInitSettings.ExternalCa"/></li>
        ///     <li><c>--force-new-cluster</c> via <see cref="DockerSwarmInitSettings.ForceNewCluster"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmInitSettings.ListenAddr"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmInitSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmInitSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmInitSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmInit(Configure<DockerSwarmInitSettings> configurator)
        {
            return DockerSwarmInit(configurator(new DockerSwarmInitSettings()));
        }
        /// <summary>
        ///   <p>Initialize a swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmInitSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmInitSettings.AdvertiseAddr"/></li>
        ///     <li><c>--autolock</c> via <see cref="DockerSwarmInitSettings.Autolock"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmInitSettings.Availability"/></li>
        ///     <li><c>--cert-expiry</c> via <see cref="DockerSwarmInitSettings.CertExpiry"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmInitSettings.DataPathAddr"/></li>
        ///     <li><c>--data-path-port</c> via <see cref="DockerSwarmInitSettings.DataPathPort"/></li>
        ///     <li><c>--default-addr-pool</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPool"/></li>
        ///     <li><c>--default-addr-pool-mask-length</c> via <see cref="DockerSwarmInitSettings.DefaultAddrPoolMaskLength"/></li>
        ///     <li><c>--dispatcher-heartbeat</c> via <see cref="DockerSwarmInitSettings.DispatcherHeartbeat"/></li>
        ///     <li><c>--external-ca</c> via <see cref="DockerSwarmInitSettings.ExternalCa"/></li>
        ///     <li><c>--force-new-cluster</c> via <see cref="DockerSwarmInitSettings.ForceNewCluster"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmInitSettings.ListenAddr"/></li>
        ///     <li><c>--max-snapshots</c> via <see cref="DockerSwarmInitSettings.MaxSnapshots"/></li>
        ///     <li><c>--snapshot-interval</c> via <see cref="DockerSwarmInitSettings.SnapshotInterval"/></li>
        ///     <li><c>--task-history-limit</c> via <see cref="DockerSwarmInitSettings.TaskHistoryLimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmInitSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmInit(CombinatorialConfigure<DockerSwarmInitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmInit, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerDiff(DockerContainerDiffSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerDiffSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerDiff(Configure<DockerContainerDiffSettings> configurator)
        {
            return DockerContainerDiff(configurator(new DockerContainerDiffSettings()));
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerDiffSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerDiff(CombinatorialConfigure<DockerContainerDiffSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerDiff, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRestart(DockerContainerRestartSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerRestartSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRestart(Configure<DockerContainerRestartSettings> configurator)
        {
            return DockerContainerRestart(configurator(new DockerContainerRestartSettings()));
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerContainerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerRestartSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerRestart(CombinatorialConfigure<DockerContainerRestartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerRestart, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Docker configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfig(DockerConfigSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerConfigSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Docker configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerConfig(Configure<DockerConfigSettings> configurator)
        {
            return DockerConfig(configurator(new DockerConfigSettings()));
        }
        /// <summary>
        ///   <p>Manage Docker configs.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerConfigSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerConfigSettings Settings, IReadOnlyCollection<Output> Output)> DockerConfig(CombinatorialConfigure<DockerConfigSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerConfig, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Disable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginDisableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginDisableSettings.Plugin"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginDisableSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginDisable(DockerPluginDisableSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginDisableSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Disable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginDisableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginDisableSettings.Plugin"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginDisableSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginDisable(Configure<DockerPluginDisableSettings> configurator)
        {
            return DockerPluginDisable(configurator(new DockerPluginDisableSettings()));
        }
        /// <summary>
        ///   <p>Disable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginDisableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginDisableSettings.Plugin"/></li>
        ///     <li><c>--force</c> via <see cref="DockerPluginDisableSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginDisableSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginDisable(CombinatorialConfigure<DockerPluginDisableSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginDisable, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerUnpause(DockerContainerUnpauseSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerUnpauseSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerUnpause(Configure<DockerContainerUnpauseSettings> configurator)
        {
            return DockerContainerUnpause(configurator(new DockerContainerUnpauseSettings()));
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerUnpauseSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerUnpause(CombinatorialConfigure<DockerContainerUnpauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerUnpause, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Import a context from a tar or zip file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextImportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextImportSettings.File"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextImport(DockerContextImportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextImportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Import a context from a tar or zip file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextImportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextImportSettings.File"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextImport(Configure<DockerContextImportSettings> configurator)
        {
            return DockerContextImport(configurator(new DockerContextImportSettings()));
        }
        /// <summary>
        ///   <p>Import a context from a tar or zip file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextImportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextImportSettings.File"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextImportSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextImport(CombinatorialConfigure<DockerContextImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextImport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRm(DockerRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRm(Configure<DockerRmSettings> configurator)
        {
            return DockerRm(configurator(new DockerRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerRm(CombinatorialConfigure<DockerRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerDeploy(DockerDeploySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerDeploySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerDeploy(Configure<DockerDeploySettings> configurator)
        {
            return DockerDeploy(configurator(new DockerDeploySettings()));
        }
        /// <summary>
        ///   <p>Deploy a new stack or update an existing stack.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDeploySettings.CliSettings"/></li>
        ///     <li><c>&lt;stack&gt;</c> via <see cref="DockerDeploySettings.Stack"/></li>
        ///     <li><c>--bundle-file</c> via <see cref="DockerDeploySettings.BundleFile"/></li>
        ///     <li><c>--compose-file</c> via <see cref="DockerDeploySettings.ComposeFile"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerDeploySettings.Namespace"/></li>
        ///     <li><c>--prune</c> via <see cref="DockerDeploySettings.Prune"/></li>
        ///     <li><c>--resolve-image</c> via <see cref="DockerDeploySettings.ResolveImage"/></li>
        ///     <li><c>--with-registry-auth</c> via <see cref="DockerDeploySettings.WithRegistryAuth"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerDeploySettings Settings, IReadOnlyCollection<Output> Output)> DockerDeploy(CombinatorialConfigure<DockerDeploySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerDeploy, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more nodes from the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeRmSettings.Nodes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNodeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeRm(DockerNodeRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more nodes from the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeRmSettings.Nodes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNodeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeRm(Configure<DockerNodeRmSettings> configurator)
        {
            return DockerNodeRm(configurator(new DockerNodeRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more nodes from the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeRmSettings.Nodes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNodeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodeRm(CombinatorialConfigure<DockerNodeRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodeRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove a checkpoint.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointRmSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointRmSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointRmSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointRm(DockerCheckpointRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCheckpointRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove a checkpoint.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointRmSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointRmSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointRmSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointRm(Configure<DockerCheckpointRmSettings> configurator)
        {
            return DockerCheckpointRm(configurator(new DockerCheckpointRmSettings()));
        }
        /// <summary>
        ///   <p>Remove a checkpoint.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointRmSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointRmSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointRmSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCheckpointRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerCheckpointRm(CombinatorialConfigure<DockerCheckpointRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCheckpointRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPush(DockerPushSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPushSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPush(Configure<DockerPushSettings> configurator)
        {
            return DockerPush(configurator(new DockerPushSettings()));
        }
        /// <summary>
        ///   <p>Push an image or a repository to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerPushSettings.Name"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPushSettings Settings, IReadOnlyCollection<Output> Output)> DockerPush(CombinatorialConfigure<DockerPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPush, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkCreateSettings.Network"/></li>
        ///     <li><c>--attachable</c> via <see cref="DockerNetworkCreateSettings.Attachable"/></li>
        ///     <li><c>--aux-address</c> via <see cref="DockerNetworkCreateSettings.AuxAddress"/></li>
        ///     <li><c>--config-from</c> via <see cref="DockerNetworkCreateSettings.ConfigFrom"/></li>
        ///     <li><c>--config-only</c> via <see cref="DockerNetworkCreateSettings.ConfigOnly"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerNetworkCreateSettings.Driver"/></li>
        ///     <li><c>--gateway</c> via <see cref="DockerNetworkCreateSettings.Gateway"/></li>
        ///     <li><c>--ingress</c> via <see cref="DockerNetworkCreateSettings.Ingress"/></li>
        ///     <li><c>--internal</c> via <see cref="DockerNetworkCreateSettings.Internal"/></li>
        ///     <li><c>--ip-range</c> via <see cref="DockerNetworkCreateSettings.IpRange"/></li>
        ///     <li><c>--ipam-driver</c> via <see cref="DockerNetworkCreateSettings.IpamDriver"/></li>
        ///     <li><c>--ipam-opt</c> via <see cref="DockerNetworkCreateSettings.IpamOpt"/></li>
        ///     <li><c>--ipv6</c> via <see cref="DockerNetworkCreateSettings.Ipv6"/></li>
        ///     <li><c>--label</c> via <see cref="DockerNetworkCreateSettings.Label"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerNetworkCreateSettings.Opt"/></li>
        ///     <li><c>--scope</c> via <see cref="DockerNetworkCreateSettings.Scope"/></li>
        ///     <li><c>--subnet</c> via <see cref="DockerNetworkCreateSettings.Subnet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkCreate(DockerNetworkCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkCreateSettings.Network"/></li>
        ///     <li><c>--attachable</c> via <see cref="DockerNetworkCreateSettings.Attachable"/></li>
        ///     <li><c>--aux-address</c> via <see cref="DockerNetworkCreateSettings.AuxAddress"/></li>
        ///     <li><c>--config-from</c> via <see cref="DockerNetworkCreateSettings.ConfigFrom"/></li>
        ///     <li><c>--config-only</c> via <see cref="DockerNetworkCreateSettings.ConfigOnly"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerNetworkCreateSettings.Driver"/></li>
        ///     <li><c>--gateway</c> via <see cref="DockerNetworkCreateSettings.Gateway"/></li>
        ///     <li><c>--ingress</c> via <see cref="DockerNetworkCreateSettings.Ingress"/></li>
        ///     <li><c>--internal</c> via <see cref="DockerNetworkCreateSettings.Internal"/></li>
        ///     <li><c>--ip-range</c> via <see cref="DockerNetworkCreateSettings.IpRange"/></li>
        ///     <li><c>--ipam-driver</c> via <see cref="DockerNetworkCreateSettings.IpamDriver"/></li>
        ///     <li><c>--ipam-opt</c> via <see cref="DockerNetworkCreateSettings.IpamOpt"/></li>
        ///     <li><c>--ipv6</c> via <see cref="DockerNetworkCreateSettings.Ipv6"/></li>
        ///     <li><c>--label</c> via <see cref="DockerNetworkCreateSettings.Label"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerNetworkCreateSettings.Opt"/></li>
        ///     <li><c>--scope</c> via <see cref="DockerNetworkCreateSettings.Scope"/></li>
        ///     <li><c>--subnet</c> via <see cref="DockerNetworkCreateSettings.Subnet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkCreate(Configure<DockerNetworkCreateSettings> configurator)
        {
            return DockerNetworkCreate(configurator(new DockerNetworkCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkCreateSettings.Network"/></li>
        ///     <li><c>--attachable</c> via <see cref="DockerNetworkCreateSettings.Attachable"/></li>
        ///     <li><c>--aux-address</c> via <see cref="DockerNetworkCreateSettings.AuxAddress"/></li>
        ///     <li><c>--config-from</c> via <see cref="DockerNetworkCreateSettings.ConfigFrom"/></li>
        ///     <li><c>--config-only</c> via <see cref="DockerNetworkCreateSettings.ConfigOnly"/></li>
        ///     <li><c>--driver</c> via <see cref="DockerNetworkCreateSettings.Driver"/></li>
        ///     <li><c>--gateway</c> via <see cref="DockerNetworkCreateSettings.Gateway"/></li>
        ///     <li><c>--ingress</c> via <see cref="DockerNetworkCreateSettings.Ingress"/></li>
        ///     <li><c>--internal</c> via <see cref="DockerNetworkCreateSettings.Internal"/></li>
        ///     <li><c>--ip-range</c> via <see cref="DockerNetworkCreateSettings.IpRange"/></li>
        ///     <li><c>--ipam-driver</c> via <see cref="DockerNetworkCreateSettings.IpamDriver"/></li>
        ///     <li><c>--ipam-opt</c> via <see cref="DockerNetworkCreateSettings.IpamOpt"/></li>
        ///     <li><c>--ipv6</c> via <see cref="DockerNetworkCreateSettings.Ipv6"/></li>
        ///     <li><c>--label</c> via <see cref="DockerNetworkCreateSettings.Label"/></li>
        ///     <li><c>--opt</c> via <see cref="DockerNetworkCreateSettings.Opt"/></li>
        ///     <li><c>--scope</c> via <see cref="DockerNetworkCreateSettings.Scope"/></li>
        ///     <li><c>--subnet</c> via <see cref="DockerNetworkCreateSettings.Subnet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkCreate(CombinatorialConfigure<DockerNetworkCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerVolumeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeLs(DockerVolumeLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumeLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerVolumeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeLs(Configure<DockerVolumeLsSettings> configurator)
        {
            return DockerVolumeLs(configurator(new DockerVolumeLsSettings()));
        }
        /// <summary>
        ///   <p>List volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerVolumeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerVolumeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerVolumeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumeLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolumeLs(CombinatorialConfigure<DockerVolumeLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolumeLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Return low-level information about keys and signatures.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerTrustInspectSettings.Images"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustInspect(DockerTrustInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Return low-level information about keys and signatures.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerTrustInspectSettings.Images"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustInspect(Configure<DockerTrustInspectSettings> configurator)
        {
            return DockerTrustInspect(configurator(new DockerTrustInspectSettings()));
        }
        /// <summary>
        ///   <p>Return low-level information about keys and signatures.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerTrustInspectSettings.Images"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustInspect(CombinatorialConfigure<DockerTrustInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkInspectSettings.Networks"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkInspectSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerNetworkInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkInspect(DockerNetworkInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkInspectSettings.Networks"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkInspectSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerNetworkInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkInspect(Configure<DockerNetworkInspectSettings> configurator)
        {
            return DockerNetworkInspect(configurator(new DockerNetworkInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;networks&gt;</c> via <see cref="DockerNetworkInspectSettings.Networks"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNetworkInspectSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerNetworkInspectSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkInspect(CombinatorialConfigure<DockerNetworkInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Activate Enterprise Edition.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineActivateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineActivateSettings.Containerd"/></li>
        ///     <li><c>--display-only</c> via <see cref="DockerEngineActivateSettings.DisplayOnly"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineActivateSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineActivateSettings.Format"/></li>
        ///     <li><c>--license</c> via <see cref="DockerEngineActivateSettings.License"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineActivateSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineActivateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineActivateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineActivate(DockerEngineActivateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerEngineActivateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Activate Enterprise Edition.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineActivateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineActivateSettings.Containerd"/></li>
        ///     <li><c>--display-only</c> via <see cref="DockerEngineActivateSettings.DisplayOnly"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineActivateSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineActivateSettings.Format"/></li>
        ///     <li><c>--license</c> via <see cref="DockerEngineActivateSettings.License"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineActivateSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineActivateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineActivateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEngineActivate(Configure<DockerEngineActivateSettings> configurator)
        {
            return DockerEngineActivate(configurator(new DockerEngineActivateSettings()));
        }
        /// <summary>
        ///   <p>Activate Enterprise Edition.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEngineActivateSettings.CliSettings"/></li>
        ///     <li><c>--containerd</c> via <see cref="DockerEngineActivateSettings.Containerd"/></li>
        ///     <li><c>--display-only</c> via <see cref="DockerEngineActivateSettings.DisplayOnly"/></li>
        ///     <li><c>--engine-image</c> via <see cref="DockerEngineActivateSettings.EngineImage"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEngineActivateSettings.Format"/></li>
        ///     <li><c>--license</c> via <see cref="DockerEngineActivateSettings.License"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerEngineActivateSettings.Quiet"/></li>
        ///     <li><c>--registry-prefix</c> via <see cref="DockerEngineActivateSettings.RegistryPrefix"/></li>
        ///     <li><c>--version</c> via <see cref="DockerEngineActivateSettings.Version"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerEngineActivateSettings Settings, IReadOnlyCollection<Output> Output)> DockerEngineActivate(CombinatorialConfigure<DockerEngineActivateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerEngineActivate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Set the current docker context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUseSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUseSettings.Context"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextUse(DockerContextUseSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextUseSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Set the current docker context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUseSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUseSettings.Context"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextUse(Configure<DockerContextUseSettings> configurator)
        {
            return DockerContextUse(configurator(new DockerContextUseSettings()));
        }
        /// <summary>
        ///   <p>Set the current docker context.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextUseSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextUseSettings.Context"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextUseSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextUse(CombinatorialConfigure<DockerContextUseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextUse, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeRmSettings.Volumes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeRm(DockerVolumeRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumeRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeRmSettings.Volumes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolumeRm(Configure<DockerVolumeRmSettings> configurator)
        {
            return DockerVolumeRm(configurator(new DockerVolumeRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;volumes&gt;</c> via <see cref="DockerVolumeRmSettings.Volumes"/></li>
        ///     <li><c>--force</c> via <see cref="DockerVolumeRmSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumeRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolumeRm(CombinatorialConfigure<DockerVolumeRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolumeRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a local manifest list for annotating and pushing to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestCreateSettings.ManifestList"/></li>
        ///     <li><c>&lt;manifests&gt;</c> via <see cref="DockerManifestCreateSettings.Manifests"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestCreate(DockerManifestCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerManifestCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a local manifest list for annotating and pushing to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestCreateSettings.ManifestList"/></li>
        ///     <li><c>&lt;manifests&gt;</c> via <see cref="DockerManifestCreateSettings.Manifests"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestCreate(Configure<DockerManifestCreateSettings> configurator)
        {
            return DockerManifestCreate(configurator(new DockerManifestCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a local manifest list for annotating and pushing to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestCreateSettings.ManifestList"/></li>
        ///     <li><c>&lt;manifests&gt;</c> via <see cref="DockerManifestCreateSettings.Manifests"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerManifestCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerManifestCreate(CombinatorialConfigure<DockerManifestCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerManifestCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Push a manifest list to a repository.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestPushSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestPushSettings.Insecure"/></li>
        ///     <li><c>--purge</c> via <see cref="DockerManifestPushSettings.Purge"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestPush(DockerManifestPushSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerManifestPushSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Push a manifest list to a repository.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestPushSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestPushSettings.Insecure"/></li>
        ///     <li><c>--purge</c> via <see cref="DockerManifestPushSettings.Purge"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestPush(Configure<DockerManifestPushSettings> configurator)
        {
            return DockerManifestPush(configurator(new DockerManifestPushSettings()));
        }
        /// <summary>
        ///   <p>Push a manifest list to a repository.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestPushSettings.ManifestList"/></li>
        ///     <li><c>--insecure</c> via <see cref="DockerManifestPushSettings.Insecure"/></li>
        ///     <li><c>--purge</c> via <see cref="DockerManifestPushSettings.Purge"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerManifestPushSettings Settings, IReadOnlyCollection<Output> Output)> DockerManifestPush(CombinatorialConfigure<DockerManifestPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerManifestPush, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Enable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginEnableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginEnableSettings.Plugin"/></li>
        ///     <li><c>--timeout</c> via <see cref="DockerPluginEnableSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginEnable(DockerPluginEnableSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginEnableSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Enable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginEnableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginEnableSettings.Plugin"/></li>
        ///     <li><c>--timeout</c> via <see cref="DockerPluginEnableSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginEnable(Configure<DockerPluginEnableSettings> configurator)
        {
            return DockerPluginEnable(configurator(new DockerPluginEnableSettings()));
        }
        /// <summary>
        ///   <p>Enable a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginEnableSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginEnableSettings.Plugin"/></li>
        ///     <li><c>--timeout</c> via <see cref="DockerPluginEnableSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginEnableSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginEnable(CombinatorialConfigure<DockerPluginEnableSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginEnable, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImport(DockerImportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImport(Configure<DockerImportSettings> configurator)
        {
            return DockerImport(configurator(new DockerImportSettings()));
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImportSettings Settings, IReadOnlyCollection<Output> Output)> DockerImport(CombinatorialConfigure<DockerImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRun(DockerContainerRunSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerRunSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRun(Configure<DockerContainerRunSettings> configurator)
        {
            return DockerContainerRun(configurator(new DockerContainerRunSettings()));
        }
        /// <summary>
        ///   <p>Run a command in a new container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerRunSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRunSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerRunSettings.Command"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerContainerRunSettings.Image"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerContainerRunSettings.AddHost"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerRunSettings.Attach"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerRunSettings.BlkioWeight"/></li>
        ///     <li><c>--blkio-weight-device</c> via <see cref="DockerContainerRunSettings.BlkioWeightDevice"/></li>
        ///     <li><c>--cap-add</c> via <see cref="DockerContainerRunSettings.CapAdd"/></li>
        ///     <li><c>--cap-drop</c> via <see cref="DockerContainerRunSettings.CapDrop"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerContainerRunSettings.CgroupParent"/></li>
        ///     <li><c>--cidfile</c> via <see cref="DockerContainerRunSettings.Cidfile"/></li>
        ///     <li><c>--cpu-count</c> via <see cref="DockerContainerRunSettings.CpuCount"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="DockerContainerRunSettings.CpuPercent"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerRunSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerRunSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerRunSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerRunSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerRunSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerRunSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerRunSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerRunSettings.CpusetMems"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerRunSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerRunSettings.DetachKeys"/></li>
        ///     <li><c>--device</c> via <see cref="DockerContainerRunSettings.Device"/></li>
        ///     <li><c>--device-cgroup-rule</c> via <see cref="DockerContainerRunSettings.DeviceCgroupRule"/></li>
        ///     <li><c>--device-read-bps</c> via <see cref="DockerContainerRunSettings.DeviceReadBps"/></li>
        ///     <li><c>--device-read-iops</c> via <see cref="DockerContainerRunSettings.DeviceReadIops"/></li>
        ///     <li><c>--device-write-bps</c> via <see cref="DockerContainerRunSettings.DeviceWriteBps"/></li>
        ///     <li><c>--device-write-iops</c> via <see cref="DockerContainerRunSettings.DeviceWriteIops"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerContainerRunSettings.DisableContentTrust"/></li>
        ///     <li><c>--dns</c> via <see cref="DockerContainerRunSettings.Dns"/></li>
        ///     <li><c>--dns-opt</c> via <see cref="DockerContainerRunSettings.DnsOpt"/></li>
        ///     <li><c>--dns-option</c> via <see cref="DockerContainerRunSettings.DnsOption"/></li>
        ///     <li><c>--dns-search</c> via <see cref="DockerContainerRunSettings.DnsSearch"/></li>
        ///     <li><c>--domainname</c> via <see cref="DockerContainerRunSettings.Domainname"/></li>
        ///     <li><c>--entrypoint</c> via <see cref="DockerContainerRunSettings.Entrypoint"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerRunSettings.Env"/></li>
        ///     <li><c>--env-file</c> via <see cref="DockerContainerRunSettings.EnvFile"/></li>
        ///     <li><c>--expose</c> via <see cref="DockerContainerRunSettings.Expose"/></li>
        ///     <li><c>--gpus</c> via <see cref="DockerContainerRunSettings.Gpus"/></li>
        ///     <li><c>--group-add</c> via <see cref="DockerContainerRunSettings.GroupAdd"/></li>
        ///     <li><c>--health-cmd</c> via <see cref="DockerContainerRunSettings.HealthCmd"/></li>
        ///     <li><c>--health-interval</c> via <see cref="DockerContainerRunSettings.HealthInterval"/></li>
        ///     <li><c>--health-retries</c> via <see cref="DockerContainerRunSettings.HealthRetries"/></li>
        ///     <li><c>--health-start-period</c> via <see cref="DockerContainerRunSettings.HealthStartPeriod"/></li>
        ///     <li><c>--health-timeout</c> via <see cref="DockerContainerRunSettings.HealthTimeout"/></li>
        ///     <li><c>--help</c> via <see cref="DockerContainerRunSettings.Help"/></li>
        ///     <li><c>--hostname</c> via <see cref="DockerContainerRunSettings.Hostname"/></li>
        ///     <li><c>--init</c> via <see cref="DockerContainerRunSettings.Init"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerRunSettings.Interactive"/></li>
        ///     <li><c>--io-maxbandwidth</c> via <see cref="DockerContainerRunSettings.IoMaxbandwidth"/></li>
        ///     <li><c>--io-maxiops</c> via <see cref="DockerContainerRunSettings.IoMaxiops"/></li>
        ///     <li><c>--ip</c> via <see cref="DockerContainerRunSettings.Ip"/></li>
        ///     <li><c>--ip6</c> via <see cref="DockerContainerRunSettings.Ip6"/></li>
        ///     <li><c>--ipc</c> via <see cref="DockerContainerRunSettings.Ipc"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerContainerRunSettings.Isolation"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerRunSettings.KernelMemory"/></li>
        ///     <li><c>--label</c> via <see cref="DockerContainerRunSettings.Label"/></li>
        ///     <li><c>--label-file</c> via <see cref="DockerContainerRunSettings.LabelFile"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRunSettings.Link"/></li>
        ///     <li><c>--link-local-ip</c> via <see cref="DockerContainerRunSettings.LinkLocalIp"/></li>
        ///     <li><c>--log-driver</c> via <see cref="DockerContainerRunSettings.LogDriver"/></li>
        ///     <li><c>--log-opt</c> via <see cref="DockerContainerRunSettings.LogOpt"/></li>
        ///     <li><c>--mac-address</c> via <see cref="DockerContainerRunSettings.MacAddress"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerRunSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerRunSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerRunSettings.MemorySwap"/></li>
        ///     <li><c>--memory-swappiness</c> via <see cref="DockerContainerRunSettings.MemorySwappiness"/></li>
        ///     <li><c>--mount</c> via <see cref="DockerContainerRunSettings.Mount"/></li>
        ///     <li><c>--name</c> via <see cref="DockerContainerRunSettings.Name"/></li>
        ///     <li><c>--net</c> via <see cref="DockerContainerRunSettings.Net"/></li>
        ///     <li><c>--net-alias</c> via <see cref="DockerContainerRunSettings.NetAlias"/></li>
        ///     <li><c>--network</c> via <see cref="DockerContainerRunSettings.Network"/></li>
        ///     <li><c>--network-alias</c> via <see cref="DockerContainerRunSettings.NetworkAlias"/></li>
        ///     <li><c>--no-healthcheck</c> via <see cref="DockerContainerRunSettings.NoHealthcheck"/></li>
        ///     <li><c>--oom-kill-disable</c> via <see cref="DockerContainerRunSettings.OomKillDisable"/></li>
        ///     <li><c>--oom-score-adj</c> via <see cref="DockerContainerRunSettings.OomScoreAdj"/></li>
        ///     <li><c>--pid</c> via <see cref="DockerContainerRunSettings.Pid"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerRunSettings.PidsLimit"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerContainerRunSettings.Platform"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerRunSettings.Privileged"/></li>
        ///     <li><c>--publish</c> via <see cref="DockerContainerRunSettings.Publish"/></li>
        ///     <li><c>--publish-all</c> via <see cref="DockerContainerRunSettings.PublishAll"/></li>
        ///     <li><c>--read-only</c> via <see cref="DockerContainerRunSettings.ReadOnly"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerContainerRunSettings.Rm"/></li>
        ///     <li><c>--runtime</c> via <see cref="DockerContainerRunSettings.Runtime"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerContainerRunSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerContainerRunSettings.ShmSize"/></li>
        ///     <li><c>--sig-proxy</c> via <see cref="DockerContainerRunSettings.SigProxy"/></li>
        ///     <li><c>--stop-signal</c> via <see cref="DockerContainerRunSettings.StopSignal"/></li>
        ///     <li><c>--stop-timeout</c> via <see cref="DockerContainerRunSettings.StopTimeout"/></li>
        ///     <li><c>--storage-opt</c> via <see cref="DockerContainerRunSettings.StorageOpt"/></li>
        ///     <li><c>--sysctl</c> via <see cref="DockerContainerRunSettings.Sysctl"/></li>
        ///     <li><c>--tmpfs</c> via <see cref="DockerContainerRunSettings.Tmpfs"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerRunSettings.Tty"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerContainerRunSettings.Ulimit"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerRunSettings.User"/></li>
        ///     <li><c>--userns</c> via <see cref="DockerContainerRunSettings.Userns"/></li>
        ///     <li><c>--uts</c> via <see cref="DockerContainerRunSettings.Uts"/></li>
        ///     <li><c>--volume</c> via <see cref="DockerContainerRunSettings.Volume"/></li>
        ///     <li><c>--volume-driver</c> via <see cref="DockerContainerRunSettings.VolumeDriver"/></li>
        ///     <li><c>--volumes-from</c> via <see cref="DockerContainerRunSettings.VolumesFrom"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerRunSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerRunSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerRun(CombinatorialConfigure<DockerContainerRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerRun, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;selves&gt;</c> via <see cref="DockerNodeInspectSettings.Selves"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerNodeInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeInspect(DockerNodeInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;selves&gt;</c> via <see cref="DockerNodeInspectSettings.Selves"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerNodeInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeInspect(Configure<DockerNodeInspectSettings> configurator)
        {
            return DockerNodeInspect(configurator(new DockerNodeInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more nodes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;selves&gt;</c> via <see cref="DockerNodeInspectSettings.Selves"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeInspectSettings.Format"/></li>
        ///     <li><c>--pretty</c> via <see cref="DockerNodeInspectSettings.Pretty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodeInspect(CombinatorialConfigure<DockerNodeInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodeInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSave(DockerSaveSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSaveSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSave(Configure<DockerSaveSettings> configurator)
        {
            return DockerSave(configurator(new DockerSaveSettings()));
        }
        /// <summary>
        ///   <p>Save one or more images to a tar archive (streamed to STDOUT by default).</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSaveSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerSaveSettings.Images"/></li>
        ///     <li><c>--output</c> via <see cref="DockerSaveSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSaveSettings Settings, IReadOnlyCollection<Output> Output)> DockerSave(CombinatorialConfigure<DockerSaveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSave, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerContainerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStats(DockerContainerStatsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerStatsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerContainerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStats(Configure<DockerContainerStatsSettings> configurator)
        {
            return DockerContainerStats(configurator(new DockerContainerStatsSettings()));
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerContainerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerStatsSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerStats(CombinatorialConfigure<DockerContainerStatsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerStats, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerExec(DockerContainerExecSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerExecSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerExec(Configure<DockerContainerExecSettings> configurator)
        {
            return DockerContainerExec(configurator(new DockerContainerExecSettings()));
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerContainerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerContainerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerContainerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerContainerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerContainerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerContainerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerContainerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerContainerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerExecSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerExec(CombinatorialConfigure<DockerContainerExecSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerExec, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List nodes in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeLs(DockerNodeLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List nodes in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeLs(Configure<DockerNodeLsSettings> configurator)
        {
            return DockerNodeLs(configurator(new DockerNodeLsSettings()));
        }
        /// <summary>
        ///   <p>List nodes in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeLsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodeLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodeLsSettings.Format"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodeLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodeLs(CombinatorialConfigure<DockerNodeLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodeLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Join a swarm as a node and/or manager.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmJoinSettings.AdvertiseAddr"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmJoinSettings.Availability"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmJoinSettings.DataPathAddr"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmJoinSettings.ListenAddr"/></li>
        ///     <li><c>--token</c> via <see cref="DockerSwarmJoinSettings.Token"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmJoin(DockerSwarmJoinSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmJoinSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Join a swarm as a node and/or manager.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmJoinSettings.AdvertiseAddr"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmJoinSettings.Availability"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmJoinSettings.DataPathAddr"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmJoinSettings.ListenAddr"/></li>
        ///     <li><c>--token</c> via <see cref="DockerSwarmJoinSettings.Token"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarmJoin(Configure<DockerSwarmJoinSettings> configurator)
        {
            return DockerSwarmJoin(configurator(new DockerSwarmJoinSettings()));
        }
        /// <summary>
        ///   <p>Join a swarm as a node and/or manager.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmJoinSettings.CliSettings"/></li>
        ///     <li><c>--advertise-addr</c> via <see cref="DockerSwarmJoinSettings.AdvertiseAddr"/></li>
        ///     <li><c>--availability</c> via <see cref="DockerSwarmJoinSettings.Availability"/></li>
        ///     <li><c>--data-path-addr</c> via <see cref="DockerSwarmJoinSettings.DataPathAddr"/></li>
        ///     <li><c>--listen-addr</c> via <see cref="DockerSwarmJoinSettings.ListenAddr"/></li>
        ///     <li><c>--token</c> via <see cref="DockerSwarmJoinSettings.Token"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmJoinSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarmJoin(CombinatorialConfigure<DockerSwarmJoinSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarmJoin, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerContainerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerContainerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerContainerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerContainerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerContainerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerContainerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerLogs(DockerContainerLogsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerLogsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerContainerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerContainerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerContainerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerContainerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerContainerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerContainerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerLogs(Configure<DockerContainerLogsSettings> configurator)
        {
            return DockerContainerLogs(configurator(new DockerContainerLogsSettings()));
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerContainerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerContainerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerContainerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerContainerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerContainerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerContainerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerLogsSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerLogs(CombinatorialConfigure<DockerContainerLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerLogs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List checkpoints for a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointLsSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointLsSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointLs(DockerCheckpointLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCheckpointLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List checkpoints for a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointLsSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointLsSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointLs(Configure<DockerCheckpointLsSettings> configurator)
        {
            return DockerCheckpointLs(configurator(new DockerCheckpointLsSettings()));
        }
        /// <summary>
        ///   <p>List checkpoints for a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointLsSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointLsSettings.CheckpointDir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCheckpointLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerCheckpointLs(CombinatorialConfigure<DockerCheckpointLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCheckpointLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerContainerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerKill(DockerContainerKillSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerKillSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerContainerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerKill(Configure<DockerContainerKillSettings> configurator)
        {
            return DockerContainerKill(configurator(new DockerContainerKillSettings()));
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerContainerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerKillSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerKill(CombinatorialConfigure<DockerContainerKillSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerKill, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Install a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInstallSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginInstallSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginInstallSettings.Plugin"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerPluginInstallSettings.Alias"/></li>
        ///     <li><c>--disable</c> via <see cref="DockerPluginInstallSettings.Disable"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginInstallSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginInstallSettings.GrantAllPermissions"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginInstall(DockerPluginInstallSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginInstallSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Install a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInstallSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginInstallSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginInstallSettings.Plugin"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerPluginInstallSettings.Alias"/></li>
        ///     <li><c>--disable</c> via <see cref="DockerPluginInstallSettings.Disable"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginInstallSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginInstallSettings.GrantAllPermissions"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginInstall(Configure<DockerPluginInstallSettings> configurator)
        {
            return DockerPluginInstall(configurator(new DockerPluginInstallSettings()));
        }
        /// <summary>
        ///   <p>Install a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInstallSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginInstallSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginInstallSettings.Plugin"/></li>
        ///     <li><c>--alias</c> via <see cref="DockerPluginInstallSettings.Alias"/></li>
        ///     <li><c>--disable</c> via <see cref="DockerPluginInstallSettings.Disable"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginInstallSettings.DisableContentTrust"/></li>
        ///     <li><c>--grant-all-permissions</c> via <see cref="DockerPluginInstallSettings.GrantAllPermissions"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginInstallSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginInstall(CombinatorialConfigure<DockerPluginInstallSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginInstall, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove unused images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagePruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImagePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePrune(DockerImagePruneSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImagePruneSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove unused images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagePruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImagePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePrune(Configure<DockerImagePruneSettings> configurator)
        {
            return DockerImagePrune(configurator(new DockerImagePruneSettings()));
        }
        /// <summary>
        ///   <p>Remove unused images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePruneSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImagePruneSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImagePruneSettings.Filter"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImagePruneSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImagePruneSettings Settings, IReadOnlyCollection<Output> Output)> DockerImagePrune(CombinatorialConfigure<DockerImagePruneSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImagePrune, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImageImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImageImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImageImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageImport(DockerImageImportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageImportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImageImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImageImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImageImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageImport(Configure<DockerImageImportSettings> configurator)
        {
            return DockerImageImport(configurator(new DockerImageImportSettings()));
        }
        /// <summary>
        ///   <p>Import the contents from a tarball to create a filesystem image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageImportSettings.CliSettings"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerImageImportSettings.File"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageImportSettings.Repository"/></li>
        ///     <li><c>--change</c> via <see cref="DockerImageImportSettings.Change"/></li>
        ///     <li><c>--message</c> via <see cref="DockerImageImportSettings.Message"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImageImportSettings.Platform"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageImportSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageImport(CombinatorialConfigure<DockerImageImportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageImport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerDiff(DockerDiffSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerDiffSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerDiff(Configure<DockerDiffSettings> configurator)
        {
            return DockerDiff(configurator(new DockerDiffSettings()));
        }
        /// <summary>
        ///   <p>Inspect changes to files or directories on a container's filesystem.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerDiffSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerDiffSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerDiffSettings Settings, IReadOnlyCollection<Output> Output)> DockerDiff(CombinatorialConfigure<DockerDiffSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerDiff, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerUnpause(DockerUnpauseSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerUnpauseSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerUnpause(Configure<DockerUnpauseSettings> configurator)
        {
            return DockerUnpause(configurator(new DockerUnpauseSettings()));
        }
        /// <summary>
        ///   <p>Unpause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerUnpauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerUnpauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerUnpauseSettings Settings, IReadOnlyCollection<Output> Output)> DockerUnpause(CombinatorialConfigure<DockerUnpauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerUnpause, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerLsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerLsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerContainerLsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerContainerLsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContainerLsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerLsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerLs(DockerContainerLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerLsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerLsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerContainerLsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerContainerLsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContainerLsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerLsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerLs(Configure<DockerContainerLsSettings> configurator)
        {
            return DockerContainerLs(configurator(new DockerContainerLsSettings()));
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerLsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerContainerLsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerContainerLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerLsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerContainerLsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerContainerLsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerContainerLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerContainerLsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerLsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerLs(CombinatorialConfigure<DockerContainerLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List tasks running on one or more nodes, defaults to current node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePsSettings.Nodes"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerNodePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNodePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodePs(DockerNodePsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodePsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List tasks running on one or more nodes, defaults to current node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePsSettings.Nodes"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerNodePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNodePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodePs(Configure<DockerNodePsSettings> configurator)
        {
            return DockerNodePs(configurator(new DockerNodePsSettings()));
        }
        /// <summary>
        ///   <p>List tasks running on one or more nodes, defaults to current node.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePsSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePsSettings.Nodes"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerNodePsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerNodePsSettings.Format"/></li>
        ///     <li><c>--no-resolve</c> via <see cref="DockerNodePsSettings.NoResolve"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerNodePsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerNodePsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodePsSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodePs(CombinatorialConfigure<DockerNodePsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodePs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerContainerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerTop(DockerContainerTopSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerTopSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerContainerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerTop(Configure<DockerContainerTopSettings> configurator)
        {
            return DockerContainerTop(configurator(new DockerContainerTopSettings()));
        }
        /// <summary>
        ///   <p>Display the running processes of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerTopSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerTopSettings.Container"/></li>
        ///     <li><c>&lt;options&gt;</c> via <see cref="DockerContainerTopSettings.Options"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerTopSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerTop(CombinatorialConfigure<DockerContainerTopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerTop, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerContainerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRename(DockerContainerRenameSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerRenameSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerContainerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRename(Configure<DockerContainerRenameSettings> configurator)
        {
            return DockerContainerRename(configurator(new DockerContainerRenameSettings()));
        }
        /// <summary>
        ///   <p>Rename a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRenameSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerContainerRenameSettings.Container"/></li>
        ///     <li><c>&lt;newName&gt;</c> via <see cref="DockerContainerRenameSettings.NewName"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerRenameSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerRename(CombinatorialConfigure<DockerContainerRenameSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerRename, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerImageHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerImageHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageHistory(DockerImageHistorySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageHistorySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerImageHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerImageHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageHistory(Configure<DockerImageHistorySettings> configurator)
        {
            return DockerImageHistory(configurator(new DockerImageHistorySettings()));
        }
        /// <summary>
        ///   <p>Show the history of an image.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageHistorySettings.CliSettings"/></li>
        ///     <li><c>&lt;image&gt;</c> via <see cref="DockerImageHistorySettings.Image"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageHistorySettings.Format"/></li>
        ///     <li><c>--human</c> via <see cref="DockerImageHistorySettings.Human"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageHistorySettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageHistorySettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageHistorySettings Settings, IReadOnlyCollection<Output> Output)> DockerImageHistory(CombinatorialConfigure<DockerImageHistorySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageHistory, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerPsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerPsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerPsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerPsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPs(DockerPsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerPsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerPsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerPsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerPsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPs(Configure<DockerPsSettings> configurator)
        {
            return DockerPs(configurator(new DockerPsSettings()));
        }
        /// <summary>
        ///   <p>List containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPsSettings.CliSettings"/></li>
        ///     <li><c>--all</c> via <see cref="DockerPsSettings.All"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerPsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPsSettings.Format"/></li>
        ///     <li><c>--last</c> via <see cref="DockerPsSettings.Last"/></li>
        ///     <li><c>--latest</c> via <see cref="DockerPsSettings.Latest"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerPsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerPsSettings.Quiet"/></li>
        ///     <li><c>--size</c> via <see cref="DockerPsSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPsSettings Settings, IReadOnlyCollection<Output> Output)> DockerPs(CombinatorialConfigure<DockerPsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerImageTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerImageTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageTag(DockerImageTagSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageTagSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerImageTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerImageTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageTag(Configure<DockerImageTagSettings> configurator)
        {
            return DockerImageTag(configurator(new DockerImageTagSettings()));
        }
        /// <summary>
        ///   <p>Create a tag TARGET_IMAGE that refers to SOURCE_IMAGE.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageTagSettings.CliSettings"/></li>
        ///     <li><c>&lt;sourceImage&gt;</c> via <see cref="DockerImageTagSettings.SourceImage"/></li>
        ///     <li><c>&lt;targetImage&gt;</c> via <see cref="DockerImageTagSettings.TargetImage"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageTagSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageTag(CombinatorialConfigure<DockerImageTagSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageTag, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerExport(DockerExportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerExportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerExport(Configure<DockerExportSettings> configurator)
        {
            return DockerExport(configurator(new DockerExportSettings()));
        }
        /// <summary>
        ///   <p>Export a container's filesystem as a tar archive.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExportSettings.Container"/></li>
        ///     <li><c>--output</c> via <see cref="DockerExportSettings.Output"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerExportSettings Settings, IReadOnlyCollection<Output> Output)> DockerExport(CombinatorialConfigure<DockerExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerExport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Disconnect a container from a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkDisconnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Network"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkDisconnectSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkDisconnect(DockerNetworkDisconnectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkDisconnectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Disconnect a container from a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkDisconnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Network"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkDisconnectSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetworkDisconnect(Configure<DockerNetworkDisconnectSettings> configurator)
        {
            return DockerNetworkDisconnect(configurator(new DockerNetworkDisconnectSettings()));
        }
        /// <summary>
        ///   <p>Disconnect a container from a network.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkDisconnectSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Container"/></li>
        ///     <li><c>&lt;network&gt;</c> via <see cref="DockerNetworkDisconnectSettings.Network"/></li>
        ///     <li><c>--force</c> via <see cref="DockerNetworkDisconnectSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkDisconnectSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetworkDisconnect(CombinatorialConfigure<DockerNetworkDisconnectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetworkDisconnect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuilderBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuilderBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuilderBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuilderBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuilderBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuilderBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuilderBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuilderBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuilderBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuilderBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuilderBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuilderBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuilderBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuilderBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuilderBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuilderBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuilderBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuilderBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuilderBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuilderBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuilderBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuilderBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuilderBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuilderBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuilderBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuilderBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuilderBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuilderBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuilderBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuilderBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuilderBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuilderBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuilderBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuilderBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuilderBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuilderBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilderBuild(DockerBuilderBuildSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerBuilderBuildSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuilderBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuilderBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuilderBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuilderBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuilderBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuilderBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuilderBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuilderBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuilderBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuilderBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuilderBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuilderBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuilderBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuilderBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuilderBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuilderBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuilderBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuilderBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuilderBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuilderBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuilderBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuilderBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuilderBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuilderBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuilderBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuilderBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuilderBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuilderBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuilderBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuilderBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuilderBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuilderBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuilderBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuilderBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuilderBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuilderBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuilderBuild(Configure<DockerBuilderBuildSettings> configurator)
        {
            return DockerBuilderBuild(configurator(new DockerBuilderBuildSettings()));
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuilderBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuilderBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuilderBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuilderBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuilderBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuilderBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuilderBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuilderBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuilderBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuilderBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuilderBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuilderBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuilderBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuilderBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuilderBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuilderBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuilderBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuilderBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuilderBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuilderBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuilderBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuilderBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuilderBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuilderBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuilderBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuilderBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuilderBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuilderBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuilderBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuilderBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuilderBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuilderBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuilderBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuilderBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuilderBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuilderBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuilderBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerBuilderBuildSettings Settings, IReadOnlyCollection<Output> Output)> DockerBuilderBuild(CombinatorialConfigure<DockerBuilderBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerBuilderBuild, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStats(DockerStatsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStatsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStats(Configure<DockerStatsSettings> configurator)
        {
            return DockerStats(configurator(new DockerStatsSettings()));
        }
        /// <summary>
        ///   <p>Display a live stream of container(s) resource usage statistics.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStatsSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerStatsSettings.Containers"/></li>
        ///     <li><c>--all</c> via <see cref="DockerStatsSettings.All"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStatsSettings.Format"/></li>
        ///     <li><c>--no-stream</c> via <see cref="DockerStatsSettings.NoStream"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerStatsSettings.NoTrunc"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStatsSettings Settings, IReadOnlyCollection<Output> Output)> DockerStats(CombinatorialConfigure<DockerStatsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStats, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Search the Docker Hub for images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSearchSettings.CliSettings"/></li>
        ///     <li><c>&lt;term&gt;</c> via <see cref="DockerSearchSettings.Term"/></li>
        ///     <li><c>--automated</c> via <see cref="DockerSearchSettings.Automated"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSearchSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSearchSettings.Format"/></li>
        ///     <li><c>--limit</c> via <see cref="DockerSearchSettings.Limit"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerSearchSettings.NoTrunc"/></li>
        ///     <li><c>--stars</c> via <see cref="DockerSearchSettings.Stars"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSearch(DockerSearchSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSearchSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Search the Docker Hub for images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSearchSettings.CliSettings"/></li>
        ///     <li><c>&lt;term&gt;</c> via <see cref="DockerSearchSettings.Term"/></li>
        ///     <li><c>--automated</c> via <see cref="DockerSearchSettings.Automated"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSearchSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSearchSettings.Format"/></li>
        ///     <li><c>--limit</c> via <see cref="DockerSearchSettings.Limit"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerSearchSettings.NoTrunc"/></li>
        ///     <li><c>--stars</c> via <see cref="DockerSearchSettings.Stars"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSearch(Configure<DockerSearchSettings> configurator)
        {
            return DockerSearch(configurator(new DockerSearchSettings()));
        }
        /// <summary>
        ///   <p>Search the Docker Hub for images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSearchSettings.CliSettings"/></li>
        ///     <li><c>&lt;term&gt;</c> via <see cref="DockerSearchSettings.Term"/></li>
        ///     <li><c>--automated</c> via <see cref="DockerSearchSettings.Automated"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerSearchSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSearchSettings.Format"/></li>
        ///     <li><c>--limit</c> via <see cref="DockerSearchSettings.Limit"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerSearchSettings.NoTrunc"/></li>
        ///     <li><c>--stars</c> via <see cref="DockerSearchSettings.Stars"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSearchSettings Settings, IReadOnlyCollection<Output> Output)> DockerSearch(CombinatorialConfigure<DockerSearchSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSearch, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Docker image manifests and manifest lists.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerManifestSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifest(DockerManifestSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerManifestSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Docker image manifests and manifest lists.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerManifestSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifest(Configure<DockerManifestSettings> configurator)
        {
            return DockerManifest(configurator(new DockerManifestSettings()));
        }
        /// <summary>
        ///   <p>Manage Docker image manifests and manifest lists.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerManifestSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerManifestSettings Settings, IReadOnlyCollection<Output> Output)> DockerManifest(CombinatorialConfigure<DockerManifestSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerManifest, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Push a plugin to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginPushSettings.Plugin"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginPush(DockerPluginPushSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginPushSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Push a plugin to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginPushSettings.Plugin"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginPush(Configure<DockerPluginPushSettings> configurator)
        {
            return DockerPluginPush(configurator(new DockerPluginPushSettings()));
        }
        /// <summary>
        ///   <p>Push a plugin to a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginPushSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginPushSettings.Plugin"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerPluginPushSettings.DisableContentTrust"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginPushSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginPush(CombinatorialConfigure<DockerPluginPushSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginPush, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerImageLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageLoad(DockerImageLoadSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageLoadSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerImageLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageLoad(Configure<DockerImageLoadSettings> configurator)
        {
            return DockerImageLoad(configurator(new DockerImageLoadSettings()));
        }
        /// <summary>
        ///   <p>Load an image from a tar archive or STDIN.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLoadSettings.CliSettings"/></li>
        ///     <li><c>--input</c> via <see cref="DockerImageLoadSettings.Input"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLoadSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageLoadSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageLoad(CombinatorialConfigure<DockerImageLoadSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageLoad, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage Swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarm(DockerSwarmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSwarmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage Swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSwarm(Configure<DockerSwarmSettings> configurator)
        {
            return DockerSwarm(configurator(new DockerSwarmSettings()));
        }
        /// <summary>
        ///   <p>Manage Swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSwarmSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSwarmSettings Settings, IReadOnlyCollection<Output> Output)> DockerSwarm(CombinatorialConfigure<DockerSwarmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSwarm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerContainerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRm(DockerContainerRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerContainerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerRm(Configure<DockerContainerRmSettings> configurator)
        {
            return DockerContainerRm(configurator(new DockerContainerRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerRmSettings.Containers"/></li>
        ///     <li><c>--force</c> via <see cref="DockerContainerRmSettings.Force"/></li>
        ///     <li><c>--link</c> via <see cref="DockerContainerRmSettings.Link"/></li>
        ///     <li><c>--volumes</c> via <see cref="DockerContainerRmSettings.Volumes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerRm(CombinatorialConfigure<DockerContainerRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerUpdate(DockerContainerUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerUpdate(Configure<DockerContainerUpdateSettings> configurator)
        {
            return DockerContainerUpdate(configurator(new DockerContainerUpdateSettings()));
        }
        /// <summary>
        ///   <p>Update configuration of one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerUpdateSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerUpdateSettings.Containers"/></li>
        ///     <li><c>--blkio-weight</c> via <see cref="DockerContainerUpdateSettings.BlkioWeight"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerContainerUpdateSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerContainerUpdateSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-rt-period</c> via <see cref="DockerContainerUpdateSettings.CpuRtPeriod"/></li>
        ///     <li><c>--cpu-rt-runtime</c> via <see cref="DockerContainerUpdateSettings.CpuRtRuntime"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerContainerUpdateSettings.CpuShares"/></li>
        ///     <li><c>--cpus</c> via <see cref="DockerContainerUpdateSettings.Cpus"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerContainerUpdateSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerContainerUpdateSettings.CpusetMems"/></li>
        ///     <li><c>--kernel-memory</c> via <see cref="DockerContainerUpdateSettings.KernelMemory"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerContainerUpdateSettings.Memory"/></li>
        ///     <li><c>--memory-reservation</c> via <see cref="DockerContainerUpdateSettings.MemoryReservation"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerContainerUpdateSettings.MemorySwap"/></li>
        ///     <li><c>--pids-limit</c> via <see cref="DockerContainerUpdateSettings.PidsLimit"/></li>
        ///     <li><c>--restart</c> via <see cref="DockerContainerUpdateSettings.Restart"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerUpdateSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerUpdate(CombinatorialConfigure<DockerContainerUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerUpdate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Change settings for a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSetSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginSetSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginSetSettings.Plugin"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginSet(DockerPluginSetSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginSetSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Change settings for a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSetSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginSetSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginSetSettings.Plugin"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginSet(Configure<DockerPluginSetSettings> configurator)
        {
            return DockerPluginSet(configurator(new DockerPluginSetSettings()));
        }
        /// <summary>
        ///   <p>Change settings for a plugin.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginSetSettings.CliSettings"/></li>
        ///     <li><c>&lt;keyValues&gt;</c> via <see cref="DockerPluginSetSettings.KeyValues"/></li>
        ///     <li><c>&lt;plugin&gt;</c> via <see cref="DockerPluginSetSettings.Plugin"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginSetSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginSet(CombinatorialConfigure<DockerPluginSetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginSet, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerWait(DockerWaitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerWaitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerWait(Configure<DockerWaitSettings> configurator)
        {
            return DockerWait(configurator(new DockerWaitSettings()));
        }
        /// <summary>
        ///   <p>Block until one or more containers stop, then print their exit codes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerWaitSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerWaitSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerWaitSettings Settings, IReadOnlyCollection<Output> Output)> DockerWait(CombinatorialConfigure<DockerWaitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerWait, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Export a context to a tar or kubeconfig file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextExportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextExportSettings.File"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerContextExportSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextExport(DockerContextExportSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextExportSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Export a context to a tar or kubeconfig file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextExportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextExportSettings.File"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerContextExportSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextExport(Configure<DockerContextExportSettings> configurator)
        {
            return DockerContextExport(configurator(new DockerContextExportSettings()));
        }
        /// <summary>
        ///   <p>Export a context to a tar or kubeconfig file.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextExportSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextExportSettings.Context"/></li>
        ///     <li><c>&lt;file&gt;</c> via <see cref="DockerContextExportSettings.File"/></li>
        ///     <li><c>--kubeconfig</c> via <see cref="DockerContextExportSettings.Kubeconfig"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextExportSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextExport(CombinatorialConfigure<DockerContextExportSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextExport, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Add additional information to a local image manifest.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestAnnotateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestAnnotateSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestAnnotateSettings.ManifestList"/></li>
        ///     <li><c>--arch</c> via <see cref="DockerManifestAnnotateSettings.Arch"/></li>
        ///     <li><c>--os</c> via <see cref="DockerManifestAnnotateSettings.Os"/></li>
        ///     <li><c>--os-features</c> via <see cref="DockerManifestAnnotateSettings.OsFeatures"/></li>
        ///     <li><c>--variant</c> via <see cref="DockerManifestAnnotateSettings.Variant"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestAnnotate(DockerManifestAnnotateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerManifestAnnotateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Add additional information to a local image manifest.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestAnnotateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestAnnotateSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestAnnotateSettings.ManifestList"/></li>
        ///     <li><c>--arch</c> via <see cref="DockerManifestAnnotateSettings.Arch"/></li>
        ///     <li><c>--os</c> via <see cref="DockerManifestAnnotateSettings.Os"/></li>
        ///     <li><c>--os-features</c> via <see cref="DockerManifestAnnotateSettings.OsFeatures"/></li>
        ///     <li><c>--variant</c> via <see cref="DockerManifestAnnotateSettings.Variant"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerManifestAnnotate(Configure<DockerManifestAnnotateSettings> configurator)
        {
            return DockerManifestAnnotate(configurator(new DockerManifestAnnotateSettings()));
        }
        /// <summary>
        ///   <p>Add additional information to a local image manifest.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerManifestAnnotateSettings.CliSettings"/></li>
        ///     <li><c>&lt;manifest&gt;</c> via <see cref="DockerManifestAnnotateSettings.Manifest"/></li>
        ///     <li><c>&lt;manifestList&gt;</c> via <see cref="DockerManifestAnnotateSettings.ManifestList"/></li>
        ///     <li><c>--arch</c> via <see cref="DockerManifestAnnotateSettings.Arch"/></li>
        ///     <li><c>--os</c> via <see cref="DockerManifestAnnotateSettings.Os"/></li>
        ///     <li><c>--os-features</c> via <see cref="DockerManifestAnnotateSettings.OsFeatures"/></li>
        ///     <li><c>--variant</c> via <see cref="DockerManifestAnnotateSettings.Variant"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerManifestAnnotateSettings Settings, IReadOnlyCollection<Output> Output)> DockerManifestAnnotate(CombinatorialConfigure<DockerManifestAnnotateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerManifestAnnotate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerImagePullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImagePullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagePullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePull(DockerImagePullSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImagePullSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerImagePullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImagePullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagePullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImagePull(Configure<DockerImagePullSettings> configurator)
        {
            return DockerImagePull(configurator(new DockerImagePullSettings()));
        }
        /// <summary>
        ///   <p>Pull an image or a repository from a registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImagePullSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerImagePullSettings.Name"/></li>
        ///     <li><c>--all-tags</c> via <see cref="DockerImagePullSettings.AllTags"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerImagePullSettings.DisableContentTrust"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerImagePullSettings.Platform"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImagePullSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImagePullSettings Settings, IReadOnlyCollection<Output> Output)> DockerImagePull(CombinatorialConfigure<DockerImagePullSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImagePull, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEvents(DockerEventsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerEventsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerEvents(Configure<DockerEventsSettings> configurator)
        {
            return DockerEvents(configurator(new DockerEventsSettings()));
        }
        /// <summary>
        ///   <p>Get real time events from the server.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerEventsSettings.CliSettings"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerEventsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerEventsSettings.Format"/></li>
        ///     <li><c>--since</c> via <see cref="DockerEventsSettings.Since"/></li>
        ///     <li><c>--until</c> via <see cref="DockerEventsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerEventsSettings Settings, IReadOnlyCollection<Output> Output)> DockerEvents(CombinatorialConfigure<DockerEventsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerEvents, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackLsSettings.CliSettings"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="DockerStackLsSettings.AllNamespaces"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackLsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackLsSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackLs(DockerStackLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackLsSettings.CliSettings"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="DockerStackLsSettings.AllNamespaces"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackLsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackLsSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackLs(Configure<DockerStackLsSettings> configurator)
        {
            return DockerStackLs(configurator(new DockerStackLsSettings()));
        }
        /// <summary>
        ///   <p>List stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackLsSettings.CliSettings"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="DockerStackLsSettings.AllNamespaces"/></li>
        ///     <li><c>--format</c> via <see cref="DockerStackLsSettings.Format"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackLsSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerStackLs(CombinatorialConfigure<DockerStackLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStackLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerInspectSettings.Containers"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerInspectSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerInspect(DockerContainerInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerInspectSettings.Containers"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerInspectSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerInspect(Configure<DockerContainerInspectSettings> configurator)
        {
            return DockerContainerInspect(configurator(new DockerContainerInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerInspectSettings.Containers"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContainerInspectSettings.Format"/></li>
        ///     <li><c>--size</c> via <see cref="DockerContainerInspectSettings.Size"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerInspect(CombinatorialConfigure<DockerContainerInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerKill(DockerKillSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerKillSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerKill(Configure<DockerKillSettings> configurator)
        {
            return DockerKill(configurator(new DockerKillSettings()));
        }
        /// <summary>
        ///   <p>Kill one or more running containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerKillSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerKillSettings.Containers"/></li>
        ///     <li><c>--signal</c> via <see cref="DockerKillSettings.Signal"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerKillSettings Settings, IReadOnlyCollection<Output> Output)> DockerKill(CombinatorialConfigure<DockerKillSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerKill, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a checkpoint from a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointCreateSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointCreateSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointCreateSettings.CheckpointDir"/></li>
        ///     <li><c>--leave-running</c> via <see cref="DockerCheckpointCreateSettings.LeaveRunning"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointCreate(DockerCheckpointCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerCheckpointCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a checkpoint from a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointCreateSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointCreateSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointCreateSettings.CheckpointDir"/></li>
        ///     <li><c>--leave-running</c> via <see cref="DockerCheckpointCreateSettings.LeaveRunning"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerCheckpointCreate(Configure<DockerCheckpointCreateSettings> configurator)
        {
            return DockerCheckpointCreate(configurator(new DockerCheckpointCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a checkpoint from a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;checkpoint&gt;</c> via <see cref="DockerCheckpointCreateSettings.Checkpoint"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerCheckpointCreateSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerCheckpointCreateSettings.Container"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerCheckpointCreateSettings.CheckpointDir"/></li>
        ///     <li><c>--leave-running</c> via <see cref="DockerCheckpointCreateSettings.LeaveRunning"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerCheckpointCreateSettings Settings, IReadOnlyCollection<Output> Output)> DockerCheckpointCreate(CombinatorialConfigure<DockerCheckpointCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerCheckpointCreate, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPause(DockerPauseSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPauseSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPause(Configure<DockerPauseSettings> configurator)
        {
            return DockerPause(configurator(new DockerPauseSettings()));
        }
        /// <summary>
        ///   <p>Pause all processes within one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPauseSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerPauseSettings.Containers"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPauseSettings Settings, IReadOnlyCollection<Output> Output)> DockerPause(CombinatorialConfigure<DockerPauseSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPause, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogs(DockerLogsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerLogsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogs(Configure<DockerLogsSettings> configurator)
        {
            return DockerLogs(configurator(new DockerLogsSettings()));
        }
        /// <summary>
        ///   <p>Fetch the logs of a container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogsSettings.CliSettings"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerLogsSettings.Container"/></li>
        ///     <li><c>--details</c> via <see cref="DockerLogsSettings.Details"/></li>
        ///     <li><c>--follow</c> via <see cref="DockerLogsSettings.Follow"/></li>
        ///     <li><c>--since</c> via <see cref="DockerLogsSettings.Since"/></li>
        ///     <li><c>--tail</c> via <see cref="DockerLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="DockerLogsSettings.Timestamps"/></li>
        ///     <li><c>--until</c> via <see cref="DockerLogsSettings.Until"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerLogsSettings Settings, IReadOnlyCollection<Output> Output)> DockerLogs(CombinatorialConfigure<DockerLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerLogs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextInspectSettings.Context"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextInspectSettings.Contexts"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextInspect(DockerContextInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextInspectSettings.Context"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextInspectSettings.Contexts"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContextInspect(Configure<DockerContextInspectSettings> configurator)
        {
            return DockerContextInspect(configurator(new DockerContextInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;context&gt;</c> via <see cref="DockerContextInspectSettings.Context"/></li>
        ///     <li><c>&lt;contexts&gt;</c> via <see cref="DockerContextInspectSettings.Contexts"/></li>
        ///     <li><c>--format</c> via <see cref="DockerContextInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerContextInspect(CombinatorialConfigure<DockerContextInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContextInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Promote one or more nodes to manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePromoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePromoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodePromote(DockerNodePromoteSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodePromoteSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Promote one or more nodes to manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePromoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePromoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodePromote(Configure<DockerNodePromoteSettings> configurator)
        {
            return DockerNodePromote(configurator(new DockerNodePromoteSettings()));
        }
        /// <summary>
        ///   <p>Promote one or more nodes to manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodePromoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodePromoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodePromoteSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodePromote(CombinatorialConfigure<DockerNodePromoteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodePromote, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Demote one or more nodes from manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeDemoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeDemoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeDemote(DockerNodeDemoteSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNodeDemoteSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Demote one or more nodes from manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeDemoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeDemoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNodeDemote(Configure<DockerNodeDemoteSettings> configurator)
        {
            return DockerNodeDemote(configurator(new DockerNodeDemoteSettings()));
        }
        /// <summary>
        ///   <p>Demote one or more nodes from manager in the swarm.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNodeDemoteSettings.CliSettings"/></li>
        ///     <li><c>&lt;nodes&gt;</c> via <see cref="DockerNodeDemoteSettings.Nodes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNodeDemoteSettings Settings, IReadOnlyCollection<Output> Output)> DockerNodeDemote(CombinatorialConfigure<DockerNodeDemoteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNodeDemote, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerExec(DockerExecSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerExecSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerExec(Configure<DockerExecSettings> configurator)
        {
            return DockerExec(configurator(new DockerExecSettings()));
        }
        /// <summary>
        ///   <p>Run a command in a running container.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;args&gt;</c> via <see cref="DockerExecSettings.Args"/></li>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerExecSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerExecSettings.Command"/></li>
        ///     <li><c>&lt;container&gt;</c> via <see cref="DockerExecSettings.Container"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerExecSettings.Detach"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerExecSettings.DetachKeys"/></li>
        ///     <li><c>--env</c> via <see cref="DockerExecSettings.Env"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerExecSettings.Interactive"/></li>
        ///     <li><c>--privileged</c> via <see cref="DockerExecSettings.Privileged"/></li>
        ///     <li><c>--tty</c> via <see cref="DockerExecSettings.Tty"/></li>
        ///     <li><c>--user</c> via <see cref="DockerExecSettings.User"/></li>
        ///     <li><c>--workdir</c> via <see cref="DockerExecSettings.Workdir"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerExecSettings Settings, IReadOnlyCollection<Output> Output)> DockerExec(CombinatorialConfigure<DockerExecSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerExec, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageRmSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImageRmSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerImageRmSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageRm(DockerImageRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageRmSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImageRmSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerImageRmSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageRm(Configure<DockerImageRmSettings> configurator)
        {
            return DockerImageRm(configurator(new DockerImageRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;images&gt;</c> via <see cref="DockerImageRmSettings.Images"/></li>
        ///     <li><c>--force</c> via <see cref="DockerImageRmSettings.Force"/></li>
        ///     <li><c>--no-prune</c> via <see cref="DockerImageRmSettings.NoPrune"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageRm(CombinatorialConfigure<DockerImageRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImage(DockerImageSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImage(Configure<DockerImageSettings> configurator)
        {
            return DockerImage(configurator(new DockerImageSettings()));
        }
        /// <summary>
        ///   <p>Manage images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageSettings Settings, IReadOnlyCollection<Output> Output)> DockerImage(CombinatorialConfigure<DockerImageSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImage, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContext(DockerContextSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContextSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContext(Configure<DockerContextSettings> configurator)
        {
            return DockerContext(configurator(new DockerContextSettings()));
        }
        /// <summary>
        ///   <p>Manage contexts.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContextSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContextSettings Settings, IReadOnlyCollection<Output> Output)> DockerContext(CombinatorialConfigure<DockerContextSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContext, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerVolumeSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolume(DockerVolumeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerVolumeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerVolumeSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerVolume(Configure<DockerVolumeSettings> configurator)
        {
            return DockerVolume(configurator(new DockerVolumeSettings()));
        }
        /// <summary>
        ///   <p>Manage volumes.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerVolumeSettings.CliSettings"/></li>
        ///     <li><c>&lt;command&gt;</c> via <see cref="DockerVolumeSettings.Command"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerVolumeSettings Settings, IReadOnlyCollection<Output> Output)> DockerVolume(CombinatorialConfigure<DockerVolumeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerVolume, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerContainerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerContainerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStart(DockerContainerStartSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerContainerStartSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerContainerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerContainerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerContainerStart(Configure<DockerContainerStartSettings> configurator)
        {
            return DockerContainerStart(configurator(new DockerContainerStartSettings()));
        }
        /// <summary>
        ///   <p>Start one or more stopped containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerContainerStartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerContainerStartSettings.Containers"/></li>
        ///     <li><c>--attach</c> via <see cref="DockerContainerStartSettings.Attach"/></li>
        ///     <li><c>--checkpoint</c> via <see cref="DockerContainerStartSettings.Checkpoint"/></li>
        ///     <li><c>--checkpoint-dir</c> via <see cref="DockerContainerStartSettings.CheckpointDir"/></li>
        ///     <li><c>--detach-keys</c> via <see cref="DockerContainerStartSettings.DetachKeys"/></li>
        ///     <li><c>--interactive</c> via <see cref="DockerContainerStartSettings.Interactive"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerContainerStartSettings Settings, IReadOnlyCollection<Output> Output)> DockerContainerStart(CombinatorialConfigure<DockerContainerStartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerContainerStart, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display detailed information on one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginInspectSettings.Plugins"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginInspect(DockerPluginInspectSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerPluginInspectSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display detailed information on one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginInspectSettings.Plugins"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerPluginInspect(Configure<DockerPluginInspectSettings> configurator)
        {
            return DockerPluginInspect(configurator(new DockerPluginInspectSettings()));
        }
        /// <summary>
        ///   <p>Display detailed information on one or more plugins.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerPluginInspectSettings.CliSettings"/></li>
        ///     <li><c>&lt;plugins&gt;</c> via <see cref="DockerPluginInspectSettings.Plugins"/></li>
        ///     <li><c>--format</c> via <see cref="DockerPluginInspectSettings.Format"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerPluginInspectSettings Settings, IReadOnlyCollection<Output> Output)> DockerPluginInspect(CombinatorialConfigure<DockerPluginInspectSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerPluginInspect, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Log out from a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogoutSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLogoutSettings.Server"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogout(DockerLogoutSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerLogoutSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Log out from a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogoutSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLogoutSettings.Server"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerLogout(Configure<DockerLogoutSettings> configurator)
        {
            return DockerLogout(configurator(new DockerLogoutSettings()));
        }
        /// <summary>
        ///   <p>Log out from a Docker registry.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerLogoutSettings.CliSettings"/></li>
        ///     <li><c>&lt;server&gt;</c> via <see cref="DockerLogoutSettings.Server"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerLogoutSettings Settings, IReadOnlyCollection<Output> Output)> DockerLogout(CombinatorialConfigure<DockerLogoutSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerLogout, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetwork(DockerNetworkSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerNetworkSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerNetwork(Configure<DockerNetworkSettings> configurator)
        {
            return DockerNetwork(configurator(new DockerNetworkSettings()));
        }
        /// <summary>
        ///   <p>Manage networks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerNetworkSettings.CliSettings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerNetworkSettings Settings, IReadOnlyCollection<Output> Output)> DockerNetwork(CombinatorialConfigure<DockerNetworkSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerNetwork, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageLsSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImageLsSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImageLsSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImageLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageLs(DockerImageLsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerImageLsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageLsSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImageLsSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImageLsSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImageLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerImageLs(Configure<DockerImageLsSettings> configurator)
        {
            return DockerImageLs(configurator(new DockerImageLsSettings()));
        }
        /// <summary>
        ///   <p>List images.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerImageLsSettings.CliSettings"/></li>
        ///     <li><c>&lt;repository&gt;</c> via <see cref="DockerImageLsSettings.Repository"/></li>
        ///     <li><c>--all</c> via <see cref="DockerImageLsSettings.All"/></li>
        ///     <li><c>--digests</c> via <see cref="DockerImageLsSettings.Digests"/></li>
        ///     <li><c>--filter</c> via <see cref="DockerImageLsSettings.Filter"/></li>
        ///     <li><c>--format</c> via <see cref="DockerImageLsSettings.Format"/></li>
        ///     <li><c>--no-trunc</c> via <see cref="DockerImageLsSettings.NoTrunc"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerImageLsSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerImageLsSettings Settings, IReadOnlyCollection<Output> Output)> DockerImageLs(CombinatorialConfigure<DockerImageLsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerImageLs, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Show docker disk usage.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemDfSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemDfSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerSystemDfSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemDf(DockerSystemDfSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerSystemDfSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Show docker disk usage.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemDfSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemDfSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerSystemDfSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerSystemDf(Configure<DockerSystemDfSettings> configurator)
        {
            return DockerSystemDf(configurator(new DockerSystemDfSettings()));
        }
        /// <summary>
        ///   <p>Show docker disk usage.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerSystemDfSettings.CliSettings"/></li>
        ///     <li><c>--format</c> via <see cref="DockerSystemDfSettings.Format"/></li>
        ///     <li><c>--verbose</c> via <see cref="DockerSystemDfSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerSystemDfSettings Settings, IReadOnlyCollection<Output> Output)> DockerSystemDf(CombinatorialConfigure<DockerSystemDfSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerSystemDf, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Revert changes to a service's configuration.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRollbackSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceRollbackSettings.Service"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceRollbackSettings.Detach"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceRollbackSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceRollback(DockerServiceRollbackSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerServiceRollbackSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Revert changes to a service's configuration.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRollbackSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceRollbackSettings.Service"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceRollbackSettings.Detach"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceRollbackSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerServiceRollback(Configure<DockerServiceRollbackSettings> configurator)
        {
            return DockerServiceRollback(configurator(new DockerServiceRollbackSettings()));
        }
        /// <summary>
        ///   <p>Revert changes to a service's configuration.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerServiceRollbackSettings.CliSettings"/></li>
        ///     <li><c>&lt;service&gt;</c> via <see cref="DockerServiceRollbackSettings.Service"/></li>
        ///     <li><c>--detach</c> via <see cref="DockerServiceRollbackSettings.Detach"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerServiceRollbackSettings.Quiet"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerServiceRollbackSettings Settings, IReadOnlyCollection<Output> Output)> DockerServiceRollback(CombinatorialConfigure<DockerServiceRollbackSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerServiceRollback, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRestart(DockerRestartSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerRestartSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerRestart(Configure<DockerRestartSettings> configurator)
        {
            return DockerRestart(configurator(new DockerRestartSettings()));
        }
        /// <summary>
        ///   <p>Restart one or more containers.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerRestartSettings.CliSettings"/></li>
        ///     <li><c>&lt;containers&gt;</c> via <see cref="DockerRestartSettings.Containers"/></li>
        ///     <li><c>--time</c> via <see cref="DockerRestartSettings.Time"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerRestartSettings Settings, IReadOnlyCollection<Output> Output)> DockerRestart(CombinatorialConfigure<DockerRestartSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerRestart, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Name"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Repositories"/></li>
        ///     <li><c>--force</c> via <see cref="DockerTrustSignerRemoveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSignerRemove(DockerTrustSignerRemoveSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerTrustSignerRemoveSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Name"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Repositories"/></li>
        ///     <li><c>--force</c> via <see cref="DockerTrustSignerRemoveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerTrustSignerRemove(Configure<DockerTrustSignerRemoveSettings> configurator)
        {
            return DockerTrustSignerRemove(configurator(new DockerTrustSignerRemoveSettings()));
        }
        /// <summary>
        ///   <p>Remove a signer.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.CliSettings"/></li>
        ///     <li><c>&lt;name&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Name"/></li>
        ///     <li><c>&lt;repositories&gt;</c> via <see cref="DockerTrustSignerRemoveSettings.Repositories"/></li>
        ///     <li><c>--force</c> via <see cref="DockerTrustSignerRemoveSettings.Force"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerTrustSignerRemoveSettings Settings, IReadOnlyCollection<Output> Output)> DockerTrustSignerRemove(CombinatorialConfigure<DockerTrustSignerRemoveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerTrustSignerRemove, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Remove one or more stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;stacks&gt;</c> via <see cref="DockerStackRmSettings.Stacks"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackRmSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackRm(DockerStackRmSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerStackRmSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Remove one or more stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;stacks&gt;</c> via <see cref="DockerStackRmSettings.Stacks"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackRmSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerStackRm(Configure<DockerStackRmSettings> configurator)
        {
            return DockerStackRm(configurator(new DockerStackRmSettings()));
        }
        /// <summary>
        ///   <p>Remove one or more stacks.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerStackRmSettings.CliSettings"/></li>
        ///     <li><c>&lt;stacks&gt;</c> via <see cref="DockerStackRmSettings.Stacks"/></li>
        ///     <li><c>--namespace</c> via <see cref="DockerStackRmSettings.Namespace"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerStackRmSettings Settings, IReadOnlyCollection<Output> Output)> DockerStackRm(CombinatorialConfigure<DockerStackRmSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerStackRm, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuild(DockerBuildSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new DockerBuildSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> DockerBuild(Configure<DockerBuildSettings> configurator)
        {
            return DockerBuild(configurator(new DockerBuildSettings()));
        }
        /// <summary>
        ///   <p>Build an image from a Dockerfile.</p>
        ///   <p>For more details, visit the <a href="https://www.docker.com/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;cliSettings&gt;</c> via <see cref="DockerBuildSettings.CliSettings"/></li>
        ///     <li><c>&lt;path&gt;</c> via <see cref="DockerBuildSettings.Path"/></li>
        ///     <li><c>--add-host</c> via <see cref="DockerBuildSettings.AddHost"/></li>
        ///     <li><c>--build-arg</c> via <see cref="DockerBuildSettings.BuildArg"/></li>
        ///     <li><c>--cache-from</c> via <see cref="DockerBuildSettings.CacheFrom"/></li>
        ///     <li><c>--cgroup-parent</c> via <see cref="DockerBuildSettings.CgroupParent"/></li>
        ///     <li><c>--compress</c> via <see cref="DockerBuildSettings.Compress"/></li>
        ///     <li><c>--cpu-period</c> via <see cref="DockerBuildSettings.CpuPeriod"/></li>
        ///     <li><c>--cpu-quota</c> via <see cref="DockerBuildSettings.CpuQuota"/></li>
        ///     <li><c>--cpu-shares</c> via <see cref="DockerBuildSettings.CpuShares"/></li>
        ///     <li><c>--cpuset-cpus</c> via <see cref="DockerBuildSettings.CpusetCpus"/></li>
        ///     <li><c>--cpuset-mems</c> via <see cref="DockerBuildSettings.CpusetMems"/></li>
        ///     <li><c>--disable-content-trust</c> via <see cref="DockerBuildSettings.DisableContentTrust"/></li>
        ///     <li><c>--file</c> via <see cref="DockerBuildSettings.File"/></li>
        ///     <li><c>--force-rm</c> via <see cref="DockerBuildSettings.ForceRm"/></li>
        ///     <li><c>--iidfile</c> via <see cref="DockerBuildSettings.Iidfile"/></li>
        ///     <li><c>--isolation</c> via <see cref="DockerBuildSettings.Isolation"/></li>
        ///     <li><c>--label</c> via <see cref="DockerBuildSettings.Label"/></li>
        ///     <li><c>--memory</c> via <see cref="DockerBuildSettings.Memory"/></li>
        ///     <li><c>--memory-swap</c> via <see cref="DockerBuildSettings.MemorySwap"/></li>
        ///     <li><c>--network</c> via <see cref="DockerBuildSettings.Network"/></li>
        ///     <li><c>--no-cache</c> via <see cref="DockerBuildSettings.NoCache"/></li>
        ///     <li><c>--output</c> via <see cref="DockerBuildSettings.Output"/></li>
        ///     <li><c>--platform</c> via <see cref="DockerBuildSettings.Platform"/></li>
        ///     <li><c>--progress</c> via <see cref="DockerBuildSettings.Progress"/></li>
        ///     <li><c>--pull</c> via <see cref="DockerBuildSettings.Pull"/></li>
        ///     <li><c>--quiet</c> via <see cref="DockerBuildSettings.Quiet"/></li>
        ///     <li><c>--rm</c> via <see cref="DockerBuildSettings.Rm"/></li>
        ///     <li><c>--secret</c> via <see cref="DockerBuildSettings.Secret"/></li>
        ///     <li><c>--security-opt</c> via <see cref="DockerBuildSettings.SecurityOpt"/></li>
        ///     <li><c>--shm-size</c> via <see cref="DockerBuildSettings.ShmSize"/></li>
        ///     <li><c>--squash</c> via <see cref="DockerBuildSettings.Squash"/></li>
        ///     <li><c>--ssh</c> via <see cref="DockerBuildSettings.Ssh"/></li>
        ///     <li><c>--stream</c> via <see cref="DockerBuildSettings.Stream"/></li>
        ///     <li><c>--tag</c> via <see cref="DockerBuildSettings.Tag"/></li>
        ///     <li><c>--target</c> via <see cref="DockerBuildSettings.Target"/></li>
        ///     <li><c>--ulimit</c> via <see cref="DockerBuildSettings.Ulimit"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(DockerBuildSettings Settings, IReadOnlyCollection<Output> Output)> DockerBuild(CombinatorialConfigure<DockerBuildSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(DockerBuild, DockerLogger, degreeOfParallelism, completeOnFailure);
        }
    }
    #region DockerConfigRmSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerConfigRmSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   CONFIG
        /// </summary>
        public virtual IReadOnlyList<string> Configs => ConfigsInternal.AsReadOnly();
        internal List<string> ConfigsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("config rm")
              .Add("{value}", Configs, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerLoadSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerLoadSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Read from tar archive file, instead of STDIN.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Suppress the load output.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("load")
              .Add("--input {value}", Input)
              .Add("--quiet", Quiet)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContainerPruneSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContainerPruneSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Provide filter values (e.g. 'until=&lt;timestamp&gt;').
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Do not prompt for confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("container prune")
              .Add("--filter {value}", Filter)
              .Add("--force", Force)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerStackSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerStackSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Kubernetes config file.
        /// </summary>
        public virtual string Kubeconfig { get; internal set; }
        /// <summary>
        ///   Orchestrator to use (swarm|kubernetes|all).
        /// </summary>
        public virtual string Orchestrator { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("stack")
              .Add("--kubeconfig {value}", Kubeconfig)
              .Add("--orchestrator {value}", Orchestrator)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTopSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTopSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   OPTIONS]
        /// </summary>
        public virtual string Options { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("top [ps")
              .Add("{value}", Container)
              .Add("{value}", Options)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerPullSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerPullSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Download all tagged images in the repository.
        /// </summary>
        public virtual bool? AllTags { get; internal set; }
        /// <summary>
        ///   Skip image verification.
        /// </summary>
        public virtual bool? DisableContentTrust { get; internal set; }
        /// <summary>
        ///   Set platform if server is multi-platform capable.
        /// </summary>
        public virtual string Platform { get; internal set; }
        /// <summary>
        ///   Suppress verbose output.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   NAME[:TAG|@DIGEST]
        /// </summary>
        public virtual string Name { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("pull")
              .Add("--all-tags", AllTags)
              .Add("--disable-content-trust", DisableContentTrust)
              .Add("--platform {value}", Platform)
              .Add("--quiet", Quiet)
              .Add("{value}", Name)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustSignSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustSignSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust sign IMAGE:TAG")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerCheckpointSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerCheckpointSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("checkpoint")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustSignerSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustSignerSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust signer")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerConfigInspectSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerConfigInspectSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Print the information in a human friendly format.
        /// </summary>
        public virtual bool? Pretty { get; internal set; }
        /// <summary>
        ///   CONFIG
        /// </summary>
        public virtual IReadOnlyList<string> Configs => ConfigsInternal.AsReadOnly();
        internal List<string> ConfigsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("config inspect")
              .Add("--format {value}", Format)
              .Add("--pretty", Pretty)
              .Add("{value}", Configs, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustKeyGenerateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustKeyGenerateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   NAME
        /// </summary>
        public virtual string Name { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust key generate")
              .Add("{value}", Name)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSystemSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSystemSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("system")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerConfigLsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerConfigLsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Filter output based on conditions provided.
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print configs using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Only display IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("config ls")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--quiet", Quiet)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContextUpdateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContextUpdateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Default orchestrator for stack operations to use with this context (swarm|kubernetes|all).
        /// </summary>
        public virtual string DefaultStackOrchestrator { get; internal set; }
        /// <summary>
        ///   Description of the context.
        /// </summary>
        public virtual string Description { get; internal set; }
        /// <summary>
        ///   set the docker endpoint.
        /// </summary>
        public virtual string Docker { get; internal set; }
        /// <summary>
        ///   set the kubernetes endpoint.
        /// </summary>
        public virtual string Kubernetes { get; internal set; }
        /// <summary>
        ///   CONTEXT
        /// </summary>
        public virtual string Context { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("context update")
              .Add("--default-stack-orchestrator {value}", DefaultStackOrchestrator)
              .Add("--description {value}", Description)
              .Add("--docker {value}", Docker)
              .Add("--kubernetes {value}", Kubernetes)
              .Add("{value}", Context)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerStackServicesSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerStackServicesSettings : DockerStackSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Filter output based on conditions provided.
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print services using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Kubernetes namespace to use.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   Only display IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   STACK
        /// </summary>
        public virtual string Stack { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("stack services")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--namespace {value}", Namespace)
              .Add("--quiet", Quiet)
              .Add("{value}", Stack)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContainerPortSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContainerPortSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   [PRIVATE_PORT[/PROTO]]
        /// </summary>
        public virtual string PrivatePort { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("container port")
              .Add("{value}", Container)
              .Add("{value}", PrivatePort)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerRenameSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerRenameSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   NEW_NAME
        /// </summary>
        public virtual string NewName { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("rename")
              .Add("{value}", Container)
              .Add("{value}", NewName)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTagSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTagSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   SOURCE_IMAGE[:TAG]
        /// </summary>
        public virtual string SourceImage { get; internal set; }
        /// <summary>
        ///   TARGET_IMAGE[:TAG]
        /// </summary>
        public virtual string TargetImage { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("tag")
              .Add("{value}", SourceImage)
              .Add("{value}", TargetImage)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSecretInspectSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSecretInspectSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Print the information in a human friendly format.
        /// </summary>
        public virtual bool? Pretty { get; internal set; }
        /// <summary>
        ///   SECRET
        /// </summary>
        public virtual IReadOnlyList<string> Secrets => SecretsInternal.AsReadOnly();
        internal List<string> SecretsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("secret inspect")
              .Add("--format {value}", Format)
              .Add("--pretty", Pretty)
              .Add("{value}", Secrets, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSecretSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSecretSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("secret")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContainerExportSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContainerExportSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Write to a file, instead of STDOUT.
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("container export")
              .Add("--output {value}", Output)
              .Add("{value}", Container)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerHistorySettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerHistorySettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Pretty-print images using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Print sizes and dates in human readable format.
        /// </summary>
        public virtual bool? Human { get; internal set; }
        /// <summary>
        ///   Don't truncate output.
        /// </summary>
        public virtual bool? NoTrunc { get; internal set; }
        /// <summary>
        ///   Only show numeric IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   IMAGE
        /// </summary>
        public virtual string Image { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("history")
              .Add("--format {value}", Format)
              .Add("--human", Human)
              .Add("--no-trunc", NoTrunc)
              .Add("--quiet", Quiet)
              .Add("{value}", Image)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceCreateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceCreateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Specify configurations to expose to the service.
        /// </summary>
        public virtual string Config { get; internal set; }
        /// <summary>
        ///   Placement constraints.
        /// </summary>
        public virtual IReadOnlyList<string> Constraint => ConstraintInternal.AsReadOnly();
        internal List<string> ConstraintInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Container labels.
        /// </summary>
        public virtual IReadOnlyList<string> ContainerLabel => ContainerLabelInternal.AsReadOnly();
        internal List<string> ContainerLabelInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Credential spec for managed service account (Windows only).
        /// </summary>
        public virtual string CredentialSpec { get; internal set; }
        /// <summary>
        ///   Exit immediately instead of waiting for the service to converge.
        /// </summary>
        public virtual bool? Detach { get; internal set; }
        /// <summary>
        ///   Set custom DNS servers.
        /// </summary>
        public virtual IReadOnlyList<string> Dns => DnsInternal.AsReadOnly();
        internal List<string> DnsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Set DNS options.
        /// </summary>
        public virtual IReadOnlyList<string> DnsOption => DnsOptionInternal.AsReadOnly();
        internal List<string> DnsOptionInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Set custom DNS search domains.
        /// </summary>
        public virtual IReadOnlyList<string> DnsSearch => DnsSearchInternal.AsReadOnly();
        internal List<string> DnsSearchInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Endpoint mode (vip or dnsrr).
        /// </summary>
        public virtual string EndpointMode { get; internal set; }
        /// <summary>
        ///   Overwrite the default ENTRYPOINT of the image.
        /// </summary>
        public virtual string Entrypoint { get; internal set; }
        /// <summary>
        ///   Set environment variables.
        /// </summary>
        public virtual IReadOnlyList<string> Env => EnvInternal.AsReadOnly();
        internal List<string> EnvInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Read in a file of environment variables.
        /// </summary>
        public virtual IReadOnlyList<string> EnvFile => EnvFileInternal.AsReadOnly();
        internal List<string> EnvFileInternal { get; set; } = new List<string>();
        /// <summary>
        ///   User defined resources.
        /// </summary>
        public virtual IReadOnlyList<string> GenericResource => GenericResourceInternal.AsReadOnly();
        internal List<string> GenericResourceInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Set one or more supplementary user groups for the container.
        /// </summary>
        public virtual IReadOnlyList<string> Group => GroupInternal.AsReadOnly();
        internal List<string> GroupInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Command to run to check health.
        /// </summary>
        public virtual string HealthCmd { get; internal set; }
        /// <summary>
        ///   Time between running the check (ms|s|m|h).
        /// </summary>
        public virtual string HealthInterval { get; internal set; }
        /// <summary>
        ///   Consecutive failures needed to report unhealthy.
        /// </summary>
        public virtual int? HealthRetries { get; internal set; }
        /// <summary>
        ///   Start period for the container to initialize before counting retries towards unstable (ms|s|m|h).
        /// </summary>
        public virtual string HealthStartPeriod { get; internal set; }
        /// <summary>
        ///   Maximum time to allow one check to run (ms|s|m|h).
        /// </summary>
        public virtual string HealthTimeout { get; internal set; }
        /// <summary>
        ///   Set one or more custom host-to-IP mappings (host:ip).
        /// </summary>
        public virtual IReadOnlyList<string> Host => HostInternal.AsReadOnly();
        internal List<string> HostInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Container hostname.
        /// </summary>
        public virtual string Hostname { get; internal set; }
        /// <summary>
        ///   Use an init inside each service container to forward signals and reap processes.
        /// </summary>
        public virtual bool? Init { get; internal set; }
        /// <summary>
        ///   Service container isolation mode.
        /// </summary>
        public virtual string Isolation { get; internal set; }
        /// <summary>
        ///   Service labels.
        /// </summary>
        public virtual IReadOnlyList<string> Label => LabelInternal.AsReadOnly();
        internal List<string> LabelInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Limit CPUs.
        /// </summary>
        public virtual decimal? LimitCpu { get; internal set; }
        /// <summary>
        ///   Limit Memory.
        /// </summary>
        public virtual long? LimitMemory { get; internal set; }
        /// <summary>
        ///   Logging driver for service.
        /// </summary>
        public virtual string LogDriver { get; internal set; }
        /// <summary>
        ///   Logging driver options.
        /// </summary>
        public virtual IReadOnlyList<string> LogOpt => LogOptInternal.AsReadOnly();
        internal List<string> LogOptInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Service mode (replicated or global).
        /// </summary>
        public virtual string Mode { get; internal set; }
        /// <summary>
        ///   Attach a filesystem mount to the service.
        /// </summary>
        public virtual string Mount { get; internal set; }
        /// <summary>
        ///   Service name.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   Network attachments.
        /// </summary>
        public virtual string Network { get; internal set; }
        /// <summary>
        ///   Disable any container-specified HEALTHCHECK.
        /// </summary>
        public virtual bool? NoHealthcheck { get; internal set; }
        /// <summary>
        ///   Do not query the registry to resolve image digest and supported platforms.
        /// </summary>
        public virtual bool? NoResolveImage { get; internal set; }
        /// <summary>
        ///   Add a placement preference.
        /// </summary>
        public virtual string PlacementPref { get; internal set; }
        /// <summary>
        ///   Publish a port as a node port.
        /// </summary>
        public virtual string Publish { get; internal set; }
        /// <summary>
        ///   Suppress progress output.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   Mount the container's root filesystem as read only.
        /// </summary>
        public virtual bool? ReadOnly { get; internal set; }
        /// <summary>
        ///   Number of tasks.
        /// </summary>
        public virtual int? Replicas { get; internal set; }
        /// <summary>
        ///   Maximum number of tasks per node (default 0 = unlimited).
        /// </summary>
        public virtual int? ReplicasMaxPerNode { get; internal set; }
        /// <summary>
        ///   Reserve CPUs.
        /// </summary>
        public virtual decimal? ReserveCpu { get; internal set; }
        /// <summary>
        ///   Reserve Memory.
        /// </summary>
        public virtual long? ReserveMemory { get; internal set; }
        /// <summary>
        ///   Restart when condition is met ("none"|"on-failure"|"any") (default "any").
        /// </summary>
        public virtual RestartCondition RestartCondition { get; internal set; }
        /// <summary>
        ///   Delay between restart attempts (ns|us|ms|s|m|h) (default 5s).
        /// </summary>
        public virtual string RestartDelay { get; internal set; }
        /// <summary>
        ///   Maximum number of restarts before giving up.
        /// </summary>
        public virtual int? RestartMaxAttempts { get; internal set; }
        /// <summary>
        ///   Window used to evaluate the restart policy (ns|us|ms|s|m|h).
        /// </summary>
        public virtual string RestartWindow { get; internal set; }
        /// <summary>
        ///   Delay between task rollbacks (ns|us|ms|s|m|h) (default 0s).
        /// </summary>
        public virtual string RollbackDelay { get; internal set; }
        /// <summary>
        ///   Action on rollback failure ("pause"|"continue") (default "pause").
        /// </summary>
        public virtual RollbackFailureAction RollbackFailureAction { get; internal set; }
        /// <summary>
        ///   Failure rate to tolerate during a rollback (default 0).
        /// </summary>
        public virtual float? RollbackMaxFailureRatio { get; internal set; }
        /// <summary>
        ///   Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h) (default 5s).
        /// </summary>
        public virtual string RollbackMonitor { get; internal set; }
        /// <summary>
        ///   Rollback order ("start-first"|"stop-first") (default "stop-first").
        /// </summary>
        public virtual RollbackOrder RollbackOrder { get; internal set; }
        /// <summary>
        ///   Maximum number of tasks rolled back simultaneously (0 to roll back all at once).
        /// </summary>
        public virtual int? RollbackParallelism { get; internal set; }
        /// <summary>
        ///   Specify secrets to expose to the service.
        /// </summary>
        public virtual string Secret { get; internal set; }
        /// <summary>
        ///   Time to wait before force killing a container (ns|us|ms|s|m|h) (default 10s).
        /// </summary>
        public virtual string StopGracePeriod { get; internal set; }
        /// <summary>
        ///   Signal to stop the container.
        /// </summary>
        public virtual string StopSignal { get; internal set; }
        /// <summary>
        ///   Sysctl options.
        /// </summary>
        public virtual IReadOnlyList<string> Sysctl => SysctlInternal.AsReadOnly();
        internal List<string> SysctlInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Allocate a pseudo-TTY.
        /// </summary>
        public virtual bool? Tty { get; internal set; }
        /// <summary>
        ///   Delay between updates (ns|us|ms|s|m|h) (default 0s).
        /// </summary>
        public virtual string UpdateDelay { get; internal set; }
        /// <summary>
        ///   Action on update failure ("pause"|"continue"|"rollback") (default "pause").
        /// </summary>
        public virtual UpdateFailureAction UpdateFailureAction { get; internal set; }
        /// <summary>
        ///   Failure rate to tolerate during an update (default 0).
        /// </summary>
        public virtual float? UpdateMaxFailureRatio { get; internal set; }
        /// <summary>
        ///   Duration after each task update to monitor for failure (ns|us|ms|s|m|h) (default 5s).
        /// </summary>
        public virtual string UpdateMonitor { get; internal set; }
        /// <summary>
        ///   Update order ("start-first"|"stop-first") (default "stop-first").
        /// </summary>
        public virtual UpdateOrder UpdateOrder { get; internal set; }
        /// <summary>
        ///   Maximum number of tasks updated simultaneously (0 to update all at once).
        /// </summary>
        public virtual int? UpdateParallelism { get; internal set; }
        /// <summary>
        ///   Username or UID (format: &lt;name|uid&gt;[:&lt;group|gid&gt;]).
        /// </summary>
        public virtual string User { get; internal set; }
        /// <summary>
        ///   Send registry authentication details to swarm agents.
        /// </summary>
        public virtual bool? WithRegistryAuth { get; internal set; }
        /// <summary>
        ///   Working directory inside the container.
        /// </summary>
        public virtual string Workdir { get; internal set; }
        /// <summary>
        ///   IMAGE
        /// </summary>
        public virtual string Image { get; internal set; }
        /// <summary>
        ///   [COMMAND]
        /// </summary>
        public virtual string Command { get; internal set; }
        /// <summary>
        ///   [ARG...]
        /// </summary>
        public virtual IReadOnlyList<string> Args => ArgsInternal.AsReadOnly();
        internal List<string> ArgsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service create")
              .Add("--config {value}", Config)
              .Add("--constraint {value}", Constraint)
              .Add("--container-label {value}", ContainerLabel)
              .Add("--credential-spec {value}", CredentialSpec)
              .Add("--detach", Detach)
              .Add("--dns {value}", Dns)
              .Add("--dns-option {value}", DnsOption)
              .Add("--dns-search {value}", DnsSearch)
              .Add("--endpoint-mode {value}", EndpointMode)
              .Add("--entrypoint {value}", Entrypoint)
              .Add("--env {value}", Env)
              .Add("--env-file {value}", EnvFile)
              .Add("--generic-resource {value}", GenericResource)
              .Add("--group {value}", Group)
              .Add("--health-cmd {value}", HealthCmd)
              .Add("--health-interval {value}", HealthInterval)
              .Add("--health-retries {value}", HealthRetries)
              .Add("--health-start-period {value}", HealthStartPeriod)
              .Add("--health-timeout {value}", HealthTimeout)
              .Add("--host {value}", Host)
              .Add("--hostname {value}", Hostname)
              .Add("--init", Init)
              .Add("--isolation {value}", Isolation)
              .Add("--label {value}", Label)
              .Add("--limit-cpu {value}", LimitCpu)
              .Add("--limit-memory {value}", LimitMemory)
              .Add("--log-driver {value}", LogDriver)
              .Add("--log-opt {value}", LogOpt)
              .Add("--mode {value}", Mode)
              .Add("--mount {value}", Mount)
              .Add("--name {value}", Name)
              .Add("--network {value}", Network)
              .Add("--no-healthcheck", NoHealthcheck)
              .Add("--no-resolve-image", NoResolveImage)
              .Add("--placement-pref {value}", PlacementPref)
              .Add("--publish {value}", Publish)
              .Add("--quiet", Quiet)
              .Add("--read-only", ReadOnly)
              .Add("--replicas {value}", Replicas)
              .Add("--replicas-max-per-node {value}", ReplicasMaxPerNode)
              .Add("--reserve-cpu {value}", ReserveCpu)
              .Add("--reserve-memory {value}", ReserveMemory)
              .Add("--restart-condition {value}", RestartCondition)
              .Add("--restart-delay {value}", RestartDelay)
              .Add("--restart-max-attempts {value}", RestartMaxAttempts)
              .Add("--restart-window {value}", RestartWindow)
              .Add("--rollback-delay {value}", RollbackDelay)
              .Add("--rollback-failure-action {value}", RollbackFailureAction)
              .Add("--rollback-max-failure-ratio {value}", RollbackMaxFailureRatio)
              .Add("--rollback-monitor {value}", RollbackMonitor)
              .Add("--rollback-order {value}", RollbackOrder)
              .Add("--rollback-parallelism {value}", RollbackParallelism)
              .Add("--secret {value}", Secret)
              .Add("--stop-grace-period {value}", StopGracePeriod)
              .Add("--stop-signal {value}", StopSignal)
              .Add("--sysctl {value}", Sysctl)
              .Add("--tty", Tty)
              .Add("--update-delay {value}", UpdateDelay)
              .Add("--update-failure-action {value}", UpdateFailureAction)
              .Add("--update-max-failure-ratio {value}", UpdateMaxFailureRatio)
              .Add("--update-monitor {value}", UpdateMonitor)
              .Add("--update-order {value}", UpdateOrder)
              .Add("--update-parallelism {value}", UpdateParallelism)
              .Add("--user {value}", User)
              .Add("--with-registry-auth", WithRegistryAuth)
              .Add("--workdir {value}", Workdir)
              .Add("{value}", Image)
              .Add("{value}", Command)
              .Add("{value}", Args, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServicePsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServicePsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Filter output based on conditions provided.
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print tasks using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Do not map IDs to Names.
        /// </summary>
        public virtual bool? NoResolve { get; internal set; }
        /// <summary>
        ///   Do not truncate output.
        /// </summary>
        public virtual bool? NoTrunc { get; internal set; }
        /// <summary>
        ///   Only display task IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   SERVICE
        /// </summary>
        public virtual IReadOnlyList<string> Services => ServicesInternal.AsReadOnly();
        internal List<string> ServicesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service ps")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--no-resolve", NoResolve)
              .Add("--no-trunc", NoTrunc)
              .Add("--quiet", Quiet)
              .Add("{value}", Services, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerStopSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerStopSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Seconds to wait for stop before killing it.
        /// </summary>
        public virtual int? Time { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual IReadOnlyList<string> Containers => ContainersInternal.AsReadOnly();
        internal List<string> ContainersInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("stop")
              .Add("--time {value}", Time)
              .Add("{value}", Containers, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerNodeSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerNodeSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("node")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerUpdateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerUpdateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Block IO (relative weight), between 10 and 1000, or 0 to disable (default 0).
        /// </summary>
        public virtual int? BlkioWeight { get; internal set; }
        /// <summary>
        ///   Limit CPU CFS (Completely Fair Scheduler) period.
        /// </summary>
        public virtual long? CpuPeriod { get; internal set; }
        /// <summary>
        ///   Limit CPU CFS (Completely Fair Scheduler) quota.
        /// </summary>
        public virtual long? CpuQuota { get; internal set; }
        /// <summary>
        ///   Limit the CPU real-time period in microseconds.
        /// </summary>
        public virtual long? CpuRtPeriod { get; internal set; }
        /// <summary>
        ///   Limit the CPU real-time runtime in microseconds.
        /// </summary>
        public virtual long? CpuRtRuntime { get; internal set; }
        /// <summary>
        ///   CPU shares (relative weight).
        /// </summary>
        public virtual long? CpuShares { get; internal set; }
        /// <summary>
        ///   Number of CPUs.
        /// </summary>
        public virtual decimal? Cpus { get; internal set; }
        /// <summary>
        ///   CPUs in which to allow execution (0-3, 0,1).
        /// </summary>
        public virtual string CpusetCpus { get; internal set; }
        /// <summary>
        ///   MEMs in which to allow execution (0-3, 0,1).
        /// </summary>
        public virtual string CpusetMems { get; internal set; }
        /// <summary>
        ///   Kernel memory limit.
        /// </summary>
        public virtual long? KernelMemory { get; internal set; }
        /// <summary>
        ///   Memory limit.
        /// </summary>
        public virtual long? Memory { get; internal set; }
        /// <summary>
        ///   Memory soft limit.
        /// </summary>
        public virtual long? MemoryReservation { get; internal set; }
        /// <summary>
        ///   Swap limit equal to memory plus swap: '-1' to enable unlimited swap.
        /// </summary>
        public virtual long? MemorySwap { get; internal set; }
        /// <summary>
        ///   Tune container pids limit (set -1 for unlimited).
        /// </summary>
        public virtual long? PidsLimit { get; internal set; }
        /// <summary>
        ///   Restart policy to apply when a container exits.
        /// </summary>
        public virtual string Restart { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual IReadOnlyList<string> Containers => ContainersInternal.AsReadOnly();
        internal List<string> ContainersInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("update")
              .Add("--blkio-weight {value}", BlkioWeight)
              .Add("--cpu-period {value}", CpuPeriod)
              .Add("--cpu-quota {value}", CpuQuota)
              .Add("--cpu-rt-period {value}", CpuRtPeriod)
              .Add("--cpu-rt-runtime {value}", CpuRtRuntime)
              .Add("--cpu-shares {value}", CpuShares)
              .Add("--cpus {value}", Cpus)
              .Add("--cpuset-cpus {value}", CpusetCpus)
              .Add("--cpuset-mems {value}", CpusetMems)
              .Add("--kernel-memory {value}", KernelMemory)
              .Add("--memory {value}", Memory)
              .Add("--memory-reservation {value}", MemoryReservation)
              .Add("--memory-swap {value}", MemorySwap)
              .Add("--pids-limit {value}", PidsLimit)
              .Add("--restart {value}", Restart)
              .Add("{value}", Containers, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerPluginCreateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerPluginCreateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Compress the context using gzip.
        /// </summary>
        public virtual bool? Compress { get; internal set; }
        /// <summary>
        ///   PLUGIN
        /// </summary>
        public virtual string Plugin { get; internal set; }
        /// <summary>
        ///   PLUGIN-DATA-DIR
        /// </summary>
        public virtual string PluginDataDir { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("plugin create")
              .Add("--compress", Compress)
              .Add("{value}", Plugin)
              .Add("{value}", PluginDataDir)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSystemInfoSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSystemInfoSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("system info")
              .Add("--format {value}", Format)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerVolumePruneSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerVolumePruneSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Provide filter values (e.g. 'label=&lt;label&gt;').
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Do not prompt for confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("volume prune")
              .Add("--filter {value}", Filter)
              .Add("--force", Force)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerPluginUpgradeSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerPluginUpgradeSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Skip image verification.
        /// </summary>
        public virtual bool? DisableContentTrust { get; internal set; }
        /// <summary>
        ///   Grant all permissions necessary to run the plugin.
        /// </summary>
        public virtual bool? GrantAllPermissions { get; internal set; }
        /// <summary>
        ///   Do not check if specified remote plugin matches existing plugin image.
        /// </summary>
        public virtual bool? SkipRemoteCheck { get; internal set; }
        /// <summary>
        ///   PLUGIN
        /// </summary>
        public virtual string Plugin { get; internal set; }
        /// <summary>
        ///   [REMOTE]
        /// </summary>
        public virtual string Remote { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("plugin upgrade")
              .Add("--disable-content-trust", DisableContentTrust)
              .Add("--grant-all-permissions", GrantAllPermissions)
              .Add("--skip-remote-check", SkipRemoteCheck)
              .Add("{value}", Plugin)
              .Add("{value}", Remote)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerBuilderPruneSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerBuilderPruneSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("builder prune")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSwarmJoinTokenSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSwarmJoinTokenSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Only display token.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   Rotate join token.
        /// </summary>
        public virtual bool? Rotate { get; internal set; }
        /// <summary>
        ///   (worker|manager)
        /// </summary>
        public virtual string Worker { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swarm join-token")
              .Add("--quiet", Quiet)
              .Add("--rotate", Rotate)
              .Add("{value}", Worker)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerNodeUpdateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerNodeUpdateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Availability of the node ("active"|"pause"|"drain").
        /// </summary>
        public virtual Availability Availability { get; internal set; }
        /// <summary>
        ///   Add or update a node label (key=value).
        /// </summary>
        public virtual IReadOnlyList<string> LabelAdd => LabelAddInternal.AsReadOnly();
        internal List<string> LabelAddInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Remove a node label if exists.
        /// </summary>
        public virtual IReadOnlyList<string> LabelRm => LabelRmInternal.AsReadOnly();
        internal List<string> LabelRmInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Role of the node ("worker"|"manager").
        /// </summary>
        public virtual Role Role { get; internal set; }
        /// <summary>
        ///   NODE
        /// </summary>
        public virtual string Node { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("node update")
              .Add("--availability {value}", Availability)
              .Add("--label-add {value}", LabelAdd)
              .Add("--label-rm {value}", LabelRm)
              .Add("--role {value}", Role)
              .Add("{value}", Node)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustSignerAddSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustSignerAddSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   OPTIONS
        /// </summary>
        public virtual string Options { get; internal set; }
        /// <summary>
        ///   NAME
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   REPOSITORY
        /// </summary>
        public virtual IReadOnlyList<string> Repositories => RepositoriesInternal.AsReadOnly();
        internal List<string> RepositoriesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust signer add")
              .Add("{value}", Options)
              .Add("{value}", Name)
              .Add("{value}", Repositories, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSwarmUpdateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSwarmUpdateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Change manager autolocking setting (true|false).
        /// </summary>
        public virtual bool? Autolock { get; internal set; }
        /// <summary>
        ///   Validity period for node certificates (ns|us|ms|s|m|h).
        /// </summary>
        public virtual string CertExpiry { get; internal set; }
        /// <summary>
        ///   Dispatcher heartbeat period (ns|us|ms|s|m|h).
        /// </summary>
        public virtual string DispatcherHeartbeat { get; internal set; }
        /// <summary>
        ///   Specifications of one or more certificate signing endpoints.
        /// </summary>
        public virtual string ExternalCa { get; internal set; }
        /// <summary>
        ///   Number of additional Raft snapshots to retain.
        /// </summary>
        public virtual int? MaxSnapshots { get; internal set; }
        /// <summary>
        ///   Number of log entries between Raft snapshots.
        /// </summary>
        public virtual int? SnapshotInterval { get; internal set; }
        /// <summary>
        ///   Task history retention limit.
        /// </summary>
        public virtual long? TaskHistoryLimit { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swarm update")
              .Add("--autolock", Autolock)
              .Add("--cert-expiry {value}", CertExpiry)
              .Add("--dispatcher-heartbeat {value}", DispatcherHeartbeat)
              .Add("--external-ca {value}", ExternalCa)
              .Add("--max-snapshots {value}", MaxSnapshots)
              .Add("--snapshot-interval {value}", SnapshotInterval)
              .Add("--task-history-limit {value}", TaskHistoryLimit)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceLogsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceLogsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Show extra details provided to logs.
        /// </summary>
        public virtual bool? Details { get; internal set; }
        /// <summary>
        ///   Follow log output.
        /// </summary>
        public virtual bool? Follow { get; internal set; }
        /// <summary>
        ///   Do not map IDs to Names in output.
        /// </summary>
        public virtual bool? NoResolve { get; internal set; }
        /// <summary>
        ///   Do not include task IDs in output.
        /// </summary>
        public virtual bool? NoTaskIds { get; internal set; }
        /// <summary>
        ///   Do not truncate output.
        /// </summary>
        public virtual bool? NoTrunc { get; internal set; }
        /// <summary>
        ///   Do not neatly format logs.
        /// </summary>
        public virtual bool? Raw { get; internal set; }
        /// <summary>
        ///   Show logs since timestamp (e.g. 2013-01-02T13:23:37) or relative (e.g. 42m for 42 minutes).
        /// </summary>
        public virtual string Since { get; internal set; }
        /// <summary>
        ///   Number of lines to show from the end of the logs.
        /// </summary>
        public virtual string Tail { get; internal set; }
        /// <summary>
        ///   Show timestamps.
        /// </summary>
        public virtual bool? Timestamps { get; internal set; }
        /// <summary>
        ///   SERVICE|TASK
        /// </summary>
        public virtual string Service { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service logs")
              .Add("--details", Details)
              .Add("--follow", Follow)
              .Add("--no-resolve", NoResolve)
              .Add("--no-task-ids", NoTaskIds)
              .Add("--no-trunc", NoTrunc)
              .Add("--raw", Raw)
              .Add("--since {value}", Since)
              .Add("--tail {value}", Tail)
              .Add("--timestamps", Timestamps)
              .Add("{value}", Service)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceLsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceLsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Filter output based on conditions provided.
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print services using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Only display IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service ls")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--quiet", Quiet)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSwarmUnlockSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSwarmUnlockSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swarm unlock")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerNetworkLsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerNetworkLsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Provide filter values (e.g. 'driver=bridge').
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print networks using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Do not truncate the output.
        /// </summary>
        public virtual bool? NoTrunc { get; internal set; }
        /// <summary>
        ///   Only display network IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("network ls")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--no-trunc", NoTrunc)
              .Add("--quiet", Quiet)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerPluginLsSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerPluginLsSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Provide filter values (e.g. 'enabled=true').
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Pretty-print plugins using a Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Don't truncate output.
        /// </summary>
        public virtual bool? NoTrunc { get; internal set; }
        /// <summary>
        ///   Only display plugin IDs.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("plugin ls")
              .Add("--filter {value}", Filter)
              .Add("--format {value}", Format)
              .Add("--no-trunc", NoTrunc)
              .Add("--quiet", Quiet)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerPluginRmSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerPluginRmSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Force the removal of an active plugin.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   PLUGIN
        /// </summary>
        public virtual IReadOnlyList<string> Plugins => PluginsInternal.AsReadOnly();
        internal List<string> PluginsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("plugin rm")
              .Add("--force", Force)
              .Add("{value}", Plugins, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerImageBuildSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerImageBuildSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Add a custom host-to-IP mapping (host:ip).
        /// </summary>
        public virtual IReadOnlyList<string> AddHost => AddHostInternal.AsReadOnly();
        internal List<string> AddHostInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Set build-time variables.
        /// </summary>
        public virtual IReadOnlyList<string> BuildArg => BuildArgInternal.AsReadOnly();
        internal List<string> BuildArgInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Images to consider as cache sources.
        /// </summary>
        public virtual IReadOnlyList<string> CacheFrom => CacheFromInternal.AsReadOnly();
        internal List<string> CacheFromInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional parent cgroup for the container.
        /// </summary>
        public virtual string CgroupParent { get; internal set; }
        /// <summary>
        ///   Compress the build context using gzip.
        /// </summary>
        public virtual bool? Compress { get; internal set; }
        /// <summary>
        ///   Limit the CPU CFS (Completely Fair Scheduler) period.
        /// </summary>
        public virtual long? CpuPeriod { get; internal set; }
        /// <summary>
        ///   Limit the CPU CFS (Completely Fair Scheduler) quota.
        /// </summary>
        public virtual long? CpuQuota { get; internal set; }
        /// <summary>
        ///   CPU shares (relative weight).
        /// </summary>
        public virtual long? CpuShares { get; internal set; }
        /// <summary>
        ///   CPUs in which to allow execution (0-3, 0,1).
        /// </summary>
        public virtual string CpusetCpus { get; internal set; }
        /// <summary>
        ///   MEMs in which to allow execution (0-3, 0,1).
        /// </summary>
        public virtual string CpusetMems { get; internal set; }
        /// <summary>
        ///   Skip image verification.
        /// </summary>
        public virtual bool? DisableContentTrust { get; internal set; }
        /// <summary>
        ///   Name of the Dockerfile (Default is 'PATH/Dockerfile').
        /// </summary>
        public virtual string File { get; internal set; }
        /// <summary>
        ///   Always remove intermediate containers.
        /// </summary>
        public virtual bool? ForceRm { get; internal set; }
        /// <summary>
        ///   Write the image ID to the file.
        /// </summary>
        public virtual string Iidfile { get; internal set; }
        /// <summary>
        ///   Container isolation technology.
        /// </summary>
        public virtual string Isolation { get; internal set; }
        /// <summary>
        ///   Set metadata for an image.
        /// </summary>
        public virtual IReadOnlyList<string> Label => LabelInternal.AsReadOnly();
        internal List<string> LabelInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Memory limit.
        /// </summary>
        public virtual long? Memory { get; internal set; }
        /// <summary>
        ///   Swap limit equal to memory plus swap: '-1' to enable unlimited swap.
        /// </summary>
        public virtual long? MemorySwap { get; internal set; }
        /// <summary>
        ///   Set the networking mode for the RUN instructions during build.
        /// </summary>
        public virtual string Network { get; internal set; }
        /// <summary>
        ///   Do not use cache when building the image.
        /// </summary>
        public virtual bool? NoCache { get; internal set; }
        /// <summary>
        ///   Output destination (format: type=local,dest=path).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Set platform if server is multi-platform capable.
        /// </summary>
        public virtual string Platform { get; internal set; }
        /// <summary>
        ///   Set type of progress output (auto, plain, tty). Use plain to show container output.
        /// </summary>
        public virtual string Progress { get; internal set; }
        /// <summary>
        ///   Always attempt to pull a newer version of the image.
        /// </summary>
        public virtual bool? Pull { get; internal set; }
        /// <summary>
        ///   Suppress the build output and print image ID on success.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   Remove intermediate containers after a successful build.
        /// </summary>
        public virtual bool? Rm { get; internal set; }
        /// <summary>
        ///   Secret file to expose to the build (only if BuildKit enabled): id=mysecret,src=/local/secret.
        /// </summary>
        public virtual string Secret { get; internal set; }
        /// <summary>
        ///   Security options.
        /// </summary>
        public virtual IReadOnlyList<string> SecurityOpt => SecurityOptInternal.AsReadOnly();
        internal List<string> SecurityOptInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Size of /dev/shm.
        /// </summary>
        public virtual long? ShmSize { get; internal set; }
        /// <summary>
        ///   Squash newly built layers into a single new layer.
        /// </summary>
        public virtual bool? Squash { get; internal set; }
        /// <summary>
        ///   SSH agent socket or keys to expose to the build (only if BuildKit enabled) (format: default|&lt;id&gt;[=&lt;socket&gt;|&lt;key&gt;[,&lt;key&gt;]]).
        /// </summary>
        public virtual string Ssh { get; internal set; }
        /// <summary>
        ///   Stream attaches to server to negotiate build context.
        /// </summary>
        public virtual bool? Stream { get; internal set; }
        /// <summary>
        ///   Name and optionally a tag in the 'name:tag' format.
        /// </summary>
        public virtual IReadOnlyList<string> Tag => TagInternal.AsReadOnly();
        internal List<string> TagInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Set the target build stage to build.
        /// </summary>
        public virtual string Target { get; internal set; }
        /// <summary>
        ///   Ulimit options.
        /// </summary>
        public virtual string Ulimit { get; internal set; }
        /// <summary>
        ///   Path or url where the build context is located.
        /// </summary>
        public virtual string Path { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("image build")
              .Add("--add-host {value}", AddHost)
              .Add("--build-arg {value}", BuildArg)
              .Add("--cache-from {value}", CacheFrom)
              .Add("--cgroup-parent {value}", CgroupParent)
              .Add("--compress", Compress)
              .Add("--cpu-period {value}", CpuPeriod)
              .Add("--cpu-quota {value}", CpuQuota)
              .Add("--cpu-shares {value}", CpuShares)
              .Add("--cpuset-cpus {value}", CpusetCpus)
              .Add("--cpuset-mems {value}", CpusetMems)
              .Add("--disable-content-trust", DisableContentTrust)
              .Add("--file {value}", File)
              .Add("--force-rm", ForceRm)
              .Add("--iidfile {value}", Iidfile)
              .Add("--isolation {value}", Isolation)
              .Add("--label {value}", Label)
              .Add("--memory {value}", Memory)
              .Add("--memory-swap {value}", MemorySwap)
              .Add("--network {value}", Network)
              .Add("--no-cache", NoCache)
              .Add("--output {value}", Output)
              .Add("--platform {value}", Platform)
              .Add("--progress {value}", Progress)
              .Add("--pull", Pull)
              .Add("--quiet", Quiet)
              .Add("--rm", Rm)
              .Add("--secret {value}", Secret)
              .Add("--security-opt {value}", SecurityOpt)
              .Add("--shm-size {value}", ShmSize)
              .Add("--squash", Squash)
              .Add("--ssh {value}", Ssh)
              .Add("--stream", Stream)
              .Add("--tag {value}", Tag)
              .Add("--target {value}", Target)
              .Add("--ulimit {value}", Ulimit)
              .Add("{value}", Path)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustRevokeSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustRevokeSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Do not prompt for confirmation.
        /// </summary>
        public virtual bool? Yes { get; internal set; }
        /// <summary>
        ///   IMAGE[:TAG]
        /// </summary>
        public virtual string Image { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust revoke")
              .Add("--yes", Yes)
              .Add("{value}", Image)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerRmiSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerRmiSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Force removal of the image.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Do not delete untagged parents.
        /// </summary>
        public virtual bool? NoPrune { get; internal set; }
        /// <summary>
        ///   IMAGE
        /// </summary>
        public virtual IReadOnlyList<string> Images => ImagesInternal.AsReadOnly();
        internal List<string> ImagesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("rmi")
              .Add("--force", Force)
              .Add("--no-prune", NoPrune)
              .Add("{value}", Images, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerNetworkRmSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerNetworkRmSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   NETWORK
        /// </summary>
        public virtual IReadOnlyList<string> Networks => NetworksInternal.AsReadOnly();
        internal List<string> NetworksInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("network rm")
              .Add("{value}", Networks, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerVersionSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerVersionSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   Kubernetes config file.
        /// </summary>
        public virtual string Kubeconfig { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("version")
              .Add("--format {value}", Format)
              .Add("--kubeconfig {value}", Kubeconfig)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSecretCreateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSecretCreateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Secret driver.
        /// </summary>
        public virtual string Driver { get; internal set; }
        /// <summary>
        ///   Secret labels.
        /// </summary>
        public virtual IReadOnlyList<string> Label => LabelInternal.AsReadOnly();
        internal List<string> LabelInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Template driver.
        /// </summary>
        public virtual string TemplateDriver { get; internal set; }
        /// <summary>
        ///   SECRET
        /// </summary>
        public virtual string Secret { get; internal set; }
        /// <summary>
        ///   Path to file to create the secret from.
        /// </summary>
        public virtual string File { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("secret create")
              .Add("--driver {value}", Driver)
              .Add("--label {value}", Label)
              .Add("--template-driver {value}", TemplateDriver)
              .Add("{value}", Secret)
              .Add("{value}", File)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceRmSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceRmSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   SERVICE
        /// </summary>
        public virtual IReadOnlyList<string> Services => ServicesInternal.AsReadOnly();
        internal List<string> ServicesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service rm")
              .Add("{value}", Services, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustKeyLoadSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustKeyLoadSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Name for the loaded key.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   KEYFILE
        /// </summary>
        public virtual string Keyfile { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust key load")
              .Add("--name {value}", Name)
              .Add("{value}", Keyfile)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerSecretRmSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerSecretRmSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   SECRET
        /// </summary>
        public virtual IReadOnlyList<string> Secrets => SecretsInternal.AsReadOnly();
        internal List<string> SecretsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("secret rm")
              .Add("{value}", Secrets, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerImageInspectSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerImageInspectSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   IMAGE
        /// </summary>
        public virtual IReadOnlyList<string> Images => ImagesInternal.AsReadOnly();
        internal List<string> ImagesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("image inspect")
              .Add("--format {value}", Format)
              .Add("{value}", Images, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerImageSaveSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerImageSaveSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Write to a file, instead of STDOUT.
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   IMAGE
        /// </summary>
        public virtual IReadOnlyList<string> Images => ImagesInternal.AsReadOnly();
        internal List<string> ImagesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("image save")
              .Add("--output {value}", Output)
              .Add("{value}", Images, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerTrustKeySettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerTrustKeySettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("trust key")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContainerAttachSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContainerAttachSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Override the key sequence for detaching a container.
        /// </summary>
        public virtual string DetachKeys { get; internal set; }
        /// <summary>
        ///   Do not attach STDIN.
        /// </summary>
        public virtual bool? NoStdin { get; internal set; }
        /// <summary>
        ///   Proxy all received signals to the process.
        /// </summary>
        public virtual bool? SigProxy { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("container attach")
              .Add("--detach-keys {value}", DetachKeys)
              .Add("--no-stdin", NoStdin)
              .Add("--sig-proxy", SigProxy)
              .Add("{value}", Container)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContextCreateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContextCreateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Default orchestrator for stack operations to use with this context (swarm|kubernetes|all).
        /// </summary>
        public virtual string DefaultStackOrchestrator { get; internal set; }
        /// <summary>
        ///   Description of the context.
        /// </summary>
        public virtual string Description { get; internal set; }
        /// <summary>
        ///   set the docker endpoint.
        /// </summary>
        public virtual string Docker { get; internal set; }
        /// <summary>
        ///   create context from a named context.
        /// </summary>
        public virtual string From { get; internal set; }
        /// <summary>
        ///   set the kubernetes endpoint.
        /// </summary>
        public virtual string Kubernetes { get; internal set; }
        /// <summary>
        ///   CONTEXT
        /// </summary>
        public virtual string Context { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("context create")
              .Add("--default-stack-orchestrator {value}", DefaultStackOrchestrator)
              .Add("--description {value}", Description)
              .Add("--docker {value}", Docker)
              .Add("--from {value}", From)
              .Add("--kubernetes {value}", Kubernetes)
              .Add("{value}", Context)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerConfigCreateSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerConfigCreateSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Config labels.
        /// </summary>
        public virtual IReadOnlyList<string> Label => LabelInternal.AsReadOnly();
        internal List<string> LabelInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Template driver.
        /// </summary>
        public virtual string TemplateDriver { get; internal set; }
        /// <summary>
        ///   CONFIG
        /// </summary>
        public virtual string Config { get; internal set; }
        /// <summary>
        ///   file|-
        /// </summary>
        public virtual string File { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("config create")
              .Add("--label {value}", Label)
              .Add("--template-driver {value}", TemplateDriver)
              .Add("{value}", Config)
              .Add("{value}", File)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerVolumeInspectSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerVolumeInspectSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        /// <summary>
        ///   VOLUME
        /// </summary>
        public virtual IReadOnlyList<string> Volumes => VolumesInternal.AsReadOnly();
        internal List<string> VolumesInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("volume inspect")
              .Add("--format {value}", Format)
              .Add("{value}", Volumes, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerContainerStopSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerContainerStopSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Seconds to wait for stop before killing it.
        /// </summary>
        public virtual int? Time { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual IReadOnlyList<string> Containers => ContainersInternal.AsReadOnly();
        internal List<string> ContainersInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("container stop")
              .Add("--time {value}", Time)
              .Add("{value}", Containers, separator: ' ')
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerNetworkPruneSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerNetworkPruneSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Provide filter values (e.g. 'until=&lt;timestamp&gt;').
        /// </summary>
        public virtual string Filter { get; internal set; }
        /// <summary>
        ///   Do not prompt for confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("network prune")
              .Add("--filter {value}", Filter)
              .Add("--force", Force)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerManifestInspectSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerManifestInspectSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Allow communication with an insecure registry.
        /// </summary>
        public virtual bool? Insecure { get; internal set; }
        /// <summary>
        ///   Output additional info including layers and platform.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        /// <summary>
        ///   [MANIFEST_LIST]
        /// </summary>
        public virtual string ManifestList { get; internal set; }
        /// <summary>
        ///   MANIFEST
        /// </summary>
        public virtual string Manifest { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("manifest inspect")
              .Add("--insecure", Insecure)
              .Add("--verbose", Verbose)
              .Add("{value}", ManifestList)
              .Add("{value}", Manifest)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerInfoSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerInfoSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Format the output using the given Go template.
        /// </summary>
        public virtual string Format { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("info")
              .Add("--format {value}", Format)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerCommitSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerCommitSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Author (e.g., "John Hannibal Smith &lt;hannibal@a-team.com&gt;").
        /// </summary>
        public virtual string Author { get; internal set; }
        /// <summary>
        ///   Apply Dockerfile instruction to the created image.
        /// </summary>
        public virtual IReadOnlyList<string> Change => ChangeInternal.AsReadOnly();
        internal List<string> ChangeInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Commit message.
        /// </summary>
        public virtual string Message { get; internal set; }
        /// <summary>
        ///   Pause container during commit.
        /// </summary>
        public virtual bool? Pause { get; internal set; }
        /// <summary>
        ///   CONTAINER
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   [REPOSITORY[:TAG]]
        /// </summary>
        public virtual string Repository { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("commit")
              .Add("--author {value}", Author)
              .Add("--change {value}", Change)
              .Add("--message {value}", Message)
              .Add("--pause", Pause)
              .Add("{value}", Container)
              .Add("{value}", Repository)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerStackDeploySettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerStackDeploySettings : DockerStackSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Path to a Distributed Application Bundle file.
        /// </summary>
        public virtual string BundleFile { get; internal set; }
        /// <summary>
        ///   Path to a Compose file, or "-" to read from stdin.
        /// </summary>
        public virtual IReadOnlyList<string> ComposeFile => ComposeFileInternal.AsReadOnly();
        internal List<string> ComposeFileInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Kubernetes namespace to use.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   Prune services that are no longer referenced.
        /// </summary>
        public virtual bool? Prune { get; internal set; }
        /// <summary>
        ///   Query the registry to resolve image digest and supported platforms ("always"|"changed"|"never").
        /// </summary>
        public virtual ResolveImage ResolveImage { get; internal set; }
        /// <summary>
        ///   Send registry authentication details to Swarm agents.
        /// </summary>
        public virtual bool? WithRegistryAuth { get; internal set; }
        /// <summary>
        ///   STACK
        /// </summary>
        public virtual string Stack { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("stack deploy")
              .Add("--bundle-file {value}", BundleFile)
              .Add("--compose-file {value}", ComposeFile)
              .Add("--namespace {value}", Namespace)
              .Add("--prune", Prune)
              .Add("--resolve-image {value}", ResolveImage)
              .Add("--with-registry-auth", WithRegistryAuth)
              .Add("{value}", Stack)
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerServiceScaleSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerServiceScaleSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   SERVICE=REPLICAS
        /// </summary>
        public virtual IReadOnlyDictionary<string, string> ServiceReplicas => ServiceReplicasInternal.AsReadOnly();
        internal Dictionary<string,string> ServiceReplicasInternal { get; set; } = new Dictionary<string,string>(StringComparer.OrdinalIgnoreCase);
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("service scale")
              .Add("{value}", ServiceReplicas, "{key=value}")
              .Add("{value}", GetCliSettings(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region DockerRunSettings
    /// <summary>
    ///   Used within <see cref="DockerTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class DockerRunSettings : DockerSettings
    {
        /// <summary>
        ///   Path to the Docker executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? DockerTasks.DockerPath;
        public override Action<OutputType, string> ProcessCustomLogger => DockerTasks.DockerLogger;
        /// <summary>
        ///   Add a custom host-to-IP mapping (host:ip).
        /// </summary>
        public virtual IReadOnlyList<string> AddHost => AddHostInternal.AsReadOnly();
        internal List<string> AddHostInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Attach to STDIN, STDOUT or STDERR.
        /// </summary>
        public virtual IReadOnlyList<string> Attach => AttachInternal.AsReadOnly();
        internal List<string> AttachInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Block IO (relative weight), between 10 and 1000, or 0 to disable (default 0).
        /// </summary>
        public virtual int? BlkioWeight { get; internal set; }
        /// <summary>
        ///   Block IO weight (relative device weight).
        /// </summary>
        public virtual IReadOnlyList<string> BlkioWeightDevice => BlkioWeightDeviceInternal.AsReadOnly();
        internal List<string> BlkioWeightDeviceInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Add Linux capabilities.
        /// </summary>
        public virtual IReadOnlyList<string> CapAdd => CapAddInternal.AsReadOnly();
        internal List<string> CapAddInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Drop Linux capabilities.
        /// </summary>
        public virtual IReadOnlyList<string> CapDrop => CapDropInternal.AsReadOnly();
        internal List<string> CapDropInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional parent cgroup for the container.
        /// </summary>
        public virtual string CgroupParent { get; internal set; }
        /// <summary>
        ///   Write the container ID to the file.
        /// </summary>
        public virtual string Cidfile { get; internal set; }
        /// <summary>
        ///   CPU count (Windows only).
        /// </summary>
        public virtual long? CpuCount { get; internal set; }
        /// <summary>
        ///   CPU percent (Windows only).
        /// </summary>
        public virtual long? CpuPercent { get; internal set; }
        /// <summary>
        ///   Limit CPU CFS (Completely Fair Scheduler) period.
        /// </summary>
        public virtual long? CpuPeriod { get; internal set; }
        /// <summary>
        ///   Limit CPU CFS (Completely Fair Scheduler) quota.
        /// </summary>
        public virtual long? CpuQuota { get; internal set; }
        /// <summary>
        ///   Limit CPU real-time period in microseconds.
        /// </summary>
        public virtual long? CpuRtPeriod { get; internal set; }
        /// <summary>
        ///   Limit CPU real-time runtime in microseconds.
        /// </summary>
        public virtual long? CpuRtRuntime { get; internal set; }
        /// <summary>
      