// Generated from https://github.com/nuke-build/nuke/blob/master/build/specifications/EntityFramework.json

using JetBrains.Annotations;
using Newtonsoft.Json;
using Nuke.Common;
using Nuke.Common.Execution;
using Nuke.Common.Tooling;
using Nuke.Common.Tools;
using Nuke.Common.Utilities.Collections;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Text;

namespace Nuke.Common.Tools.EntityFramework
{
    /// <summary>
    ///   <p>The command-line interface (CLI) tools for Entity Framework Core perform design-time development tasks. For example, they create migrations, apply <a href="https://docs.microsoft.com/en-us/aspnet/core/data/ef-mvc/migrations?view=aspnetcore-2.0#introduction-to-migrations">migrations</a>, and generate code for a model based on an existing database. The commands are an extension to the cross-platform <a href="https://docs.microsoft.com/en-us/dotnet/core/tools">dotnet</a> command, which is part of the <a href="https://www.microsoft.com/net/core">.NET Core SDK</a>. These tools work with .NET Core projects.<para/>If you're using Visual Studio, we recommend the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/powershell">Package Manager Console tools</a> instead:<para/><ul><li>They automatically work with the current project selected in the Package Manager Console without requiring that you manually switch directories.</li><li>They automatically open files generated by a command after the command is completed.</li></ul></p>
    ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkTasks
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public static string EntityFrameworkPath =>
            ToolPathResolver.TryGetEnvironmentExecutable("ENTITYFRAMEWORK_EXE") ??
            ToolPathResolver.GetPathExecutable("dotnet");
        public static Action<OutputType, string> EntityFrameworkLogger { get; set; } = ProcessTasks.DefaultLogger;
        /// <summary>
        ///   <p>The command-line interface (CLI) tools for Entity Framework Core perform design-time development tasks. For example, they create migrations, apply <a href="https://docs.microsoft.com/en-us/aspnet/core/data/ef-mvc/migrations?view=aspnetcore-2.0#introduction-to-migrations">migrations</a>, and generate code for a model based on an existing database. The commands are an extension to the cross-platform <a href="https://docs.microsoft.com/en-us/dotnet/core/tools">dotnet</a> command, which is part of the <a href="https://www.microsoft.com/net/core">.NET Core SDK</a>. These tools work with .NET Core projects.<para/>If you're using Visual Studio, we recommend the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/powershell">Package Manager Console tools</a> instead:<para/><ul><li>They automatically work with the current project selected in the Package Manager Console without requiring that you manually switch directories.</li><li>They automatically open files generated by a command after the command is completed.</li></ul></p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        public static IReadOnlyCollection<Output> EntityFramework(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, bool? logTimestamp = null, string logFile = null, Func<string, string> outputFilter = null)
        {
            using var process = ProcessTasks.StartProcess(EntityFrameworkPath, arguments, workingDirectory, environmentVariables, timeout, logOutput, logInvocation, logTimestamp, logFile, EntityFrameworkLogger, outputFilter);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database drop</c> command is used to drop the database.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseDropSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseDropSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDatabaseDropSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseDropSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseDropSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseDropSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseDropSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseDropSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDatabaseDrop(EntityFrameworkDatabaseDropSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkDatabaseDropSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database drop</c> command is used to drop the database.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseDropSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseDropSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDatabaseDropSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseDropSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseDropSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseDropSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseDropSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseDropSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDatabaseDrop(Configure<EntityFrameworkDatabaseDropSettings> configurator)
        {
            return EntityFrameworkDatabaseDrop(configurator(new EntityFrameworkDatabaseDropSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database drop</c> command is used to drop the database.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseDropSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseDropSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDatabaseDropSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseDropSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseDropSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseDropSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseDropSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseDropSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkDatabaseDropSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkDatabaseDrop(CombinatorialConfigure<EntityFrameworkDatabaseDropSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkDatabaseDrop, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database update</c> command is used to update the database to the last migration or to a specified migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;migration&gt;</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Migration"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDatabaseUpdate(EntityFrameworkDatabaseUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkDatabaseUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database update</c> command is used to update the database to the last migration or to a specified migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;migration&gt;</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Migration"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDatabaseUpdate(Configure<EntityFrameworkDatabaseUpdateSettings> configurator)
        {
            return EntityFrameworkDatabaseUpdate(configurator(new EntityFrameworkDatabaseUpdateSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef database update</c> command is used to update the database to the last migration or to a specified migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;migration&gt;</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Migration"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Context"/></li>
        ///     <li><c>--dry-run</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkDatabaseUpdateSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkDatabaseUpdate(CombinatorialConfigure<EntityFrameworkDatabaseUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkDatabaseUpdate, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext info</c> command is used to get information about a <c>DbContext</c> type.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextInfoSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextInfoSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextInfoSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextInfoSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextInfoSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextInfoSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextInfoSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextInfo(EntityFrameworkDbContextInfoSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkDbContextInfoSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext info</c> command is used to get information about a <c>DbContext</c> type.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextInfoSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextInfoSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextInfoSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextInfoSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextInfoSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextInfoSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextInfoSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextInfo(Configure<EntityFrameworkDbContextInfoSettings> configurator)
        {
            return EntityFrameworkDbContextInfo(configurator(new EntityFrameworkDbContextInfoSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext info</c> command is used to get information about a <c>DbContext</c> type.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextInfoSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextInfoSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextInfoSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextInfoSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextInfoSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextInfoSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextInfoSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkDbContextInfoSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkDbContextInfo(CombinatorialConfigure<EntityFrameworkDbContextInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkDbContextInfo, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext list</c> command is used to list available <c>DbContext</c> types.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextList(EntityFrameworkDbContextListSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkDbContextListSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext list</c> command is used to list available <c>DbContext</c> types.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextList(Configure<EntityFrameworkDbContextListSettings> configurator)
        {
            return EntityFrameworkDbContextList(configurator(new EntityFrameworkDbContextListSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext list</c> command is used to list available <c>DbContext</c> types.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkDbContextListSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkDbContextList(CombinatorialConfigure<EntityFrameworkDbContextListSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkDbContextList, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext scaffold</c> command is used to generate code for a <c>DbContext</c> and entity types for a database. In order for this command to generate an entity type, the database table must have a primary key.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;connection&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Connection"/></li>
        ///     <li><c>&lt;provider&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Provider"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Context"/></li>
        ///     <li><c>--context-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.ContextDirectory"/></li>
        ///     <li><c>--data-annotations</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Runtime"/></li>
        ///     <li><c>--schema</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.StartupProject"/></li>
        ///     <li><c>--table</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></li>
        ///     <li><c>--use-database-names</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextScaffold(EntityFrameworkDbContextScaffoldSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkDbContextScaffoldSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext scaffold</c> command is used to generate code for a <c>DbContext</c> and entity types for a database. In order for this command to generate an entity type, the database table must have a primary key.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;connection&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Connection"/></li>
        ///     <li><c>&lt;provider&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Provider"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Context"/></li>
        ///     <li><c>--context-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.ContextDirectory"/></li>
        ///     <li><c>--data-annotations</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Runtime"/></li>
        ///     <li><c>--schema</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.StartupProject"/></li>
        ///     <li><c>--table</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></li>
        ///     <li><c>--use-database-names</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkDbContextScaffold(Configure<EntityFrameworkDbContextScaffoldSettings> configurator)
        {
            return EntityFrameworkDbContextScaffold(configurator(new EntityFrameworkDbContextScaffoldSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef dbcontext scaffold</c> command is used to generate code for a <c>DbContext</c> and entity types for a database. In order for this command to generate an entity type, the database table must have a primary key.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;connection&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Connection"/></li>
        ///     <li><c>&lt;provider&gt;</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Provider"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Context"/></li>
        ///     <li><c>--context-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.ContextDirectory"/></li>
        ///     <li><c>--data-annotations</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></li>
        ///     <li><c>--force</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Runtime"/></li>
        ///     <li><c>--schema</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.StartupProject"/></li>
        ///     <li><c>--table</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></li>
        ///     <li><c>--use-database-names</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkDbContextScaffoldSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkDbContextScaffold(CombinatorialConfigure<EntityFrameworkDbContextScaffoldSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkDbContextScaffold, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations add</c> command is used to add a new migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="EntityFrameworkMigrationsAddSettings.Name"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsAddSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsAddSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsAddSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsAddSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsAddSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsAddSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsAddSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsAddSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsAdd(EntityFrameworkMigrationsAddSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkMigrationsAddSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations add</c> command is used to add a new migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="EntityFrameworkMigrationsAddSettings.Name"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsAddSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsAddSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsAddSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsAddSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsAddSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsAddSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsAddSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsAddSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsAdd(Configure<EntityFrameworkMigrationsAddSettings> configurator)
        {
            return EntityFrameworkMigrationsAdd(configurator(new EntityFrameworkMigrationsAddSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations add</c> command is used to add a new migration.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="EntityFrameworkMigrationsAddSettings.Name"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsAddSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsAddSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsAddSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsAddSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsAddSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsAddSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsAddSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsAddSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkMigrationsAddSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkMigrationsAdd(CombinatorialConfigure<EntityFrameworkMigrationsAddSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkMigrationsAdd, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations list</c> command is used to list available migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsList(EntityFrameworkMigrationsListSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkMigrationsListSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations list</c> command is used to list available migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsList(Configure<EntityFrameworkMigrationsListSettings> configurator)
        {
            return EntityFrameworkMigrationsList(configurator(new EntityFrameworkMigrationsListSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations list</c> command is used to list available migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsListSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsListSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsListSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsListSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsListSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsListSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsListSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkMigrationsListSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkMigrationsList(CombinatorialConfigure<EntityFrameworkMigrationsListSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkMigrationsList, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations remove</c> command is used to remove the last migration (rolls back the code changes that were done for the migration).</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsRemove(EntityFrameworkMigrationsRemoveSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkMigrationsRemoveSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations remove</c> command is used to remove the last migration (rolls back the code changes that were done for the migration).</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsRemove(Configure<EntityFrameworkMigrationsRemoveSettings> configurator)
        {
            return EntityFrameworkMigrationsRemove(configurator(new EntityFrameworkMigrationsRemoveSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations remove</c> command is used to remove the last migration (rolls back the code changes that were done for the migration).</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Framework"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></li>
        ///     <li><c>--output-dir</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.OutputDirectory"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkMigrationsRemoveSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkMigrationsRemove(CombinatorialConfigure<EntityFrameworkMigrationsRemoveSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkMigrationsRemove, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations script</c> command is used to generate a SQL script from migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;from&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.From"/></li>
        ///     <li><c>&lt;to&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.To"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Framework"/></li>
        ///     <li><c>--idempotent</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></li>
        ///     <li><c>--output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Output"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsScript(EntityFrameworkMigrationsScriptSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new EntityFrameworkMigrationsScriptSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations script</c> command is used to generate a SQL script from migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;from&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.From"/></li>
        ///     <li><c>&lt;to&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.To"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Framework"/></li>
        ///     <li><c>--idempotent</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></li>
        ///     <li><c>--output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Output"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> EntityFrameworkMigrationsScript(Configure<EntityFrameworkMigrationsScriptSettings> configurator)
        {
            return EntityFrameworkMigrationsScript(configurator(new EntityFrameworkMigrationsScriptSettings()));
        }
        /// <summary>
        ///   <p>The <c>dotnet ef migrations script</c> command is used to generate a SQL script from migrations.</p>
        ///   <p>For more details, visit the <a href="https://docs.microsoft.com/en-us/ef/core/miscellaneous/cli/dotnet">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;from&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.From"/></li>
        ///     <li><c>&lt;to&gt;</c> via <see cref="EntityFrameworkMigrationsScriptSettings.To"/></li>
        ///     <li><c>--configuration</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Configuration"/></li>
        ///     <li><c>--context</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Context"/></li>
        ///     <li><c>--framework</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Framework"/></li>
        ///     <li><c>--idempotent</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></li>
        ///     <li><c>--json</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></li>
        ///     <li><c>--no-color</c> via <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></li>
        ///     <li><c>--output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Output"/></li>
        ///     <li><c>--prefix-output</c> via <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></li>
        ///     <li><c>--project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Project"/></li>
        ///     <li><c>--runtime</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Runtime"/></li>
        ///     <li><c>--startup-project</c> via <see cref="EntityFrameworkMigrationsScriptSettings.StartupProject"/></li>
        ///     <li><c>--verbose</c> via <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(EntityFrameworkMigrationsScriptSettings Settings, IReadOnlyCollection<Output> Output)> EntityFrameworkMigrationsScript(CombinatorialConfigure<EntityFrameworkMigrationsScriptSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(EntityFrameworkMigrationsScript, EntityFrameworkLogger, degreeOfParallelism, completeOnFailure);
        }
    }
    #region EntityFrameworkDatabaseDropSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkDatabaseDropSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   Don't confirm.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Show which database would be dropped, but don't drop it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef database drop")
              .Add("--force", Force)
              .Add("--dry-run", DryRun)
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkDatabaseUpdateSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkDatabaseUpdateSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   The target migration. Migrations may be identified by name or by ID. The number 0 is a special case that means before the first migration and causes all migrations to be reverted. If no migration is specified, the command defaults to the last migration.
        /// </summary>
        public virtual string Migration { get; internal set; }
        /// <summary>
        ///   This option shows which database would be dropped, but doesn't drop it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef database update")
              .Add("{value}", Migration)
              .Add("--dry-run", DryRun)
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkDbContextInfoSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkDbContextInfoSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef dbcontext info")
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkDbContextListSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkDbContextListSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef dbcontext list")
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkDbContextScaffoldSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkDbContextScaffoldSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   The connection string to the database. For ASP.NET Core 2.x projects, the value can be <em>name=&lt;name of connection string&gt;</em>. In that case the name comes from the configuration sources that are set up for the project.
        /// </summary>
        public virtual string Connection { get; internal set; }
        /// <summary>
        ///   The provider to use. Typically this is the name of the NuGet package, for example: <c>Microsoft.EntityFrameworkCore.SqlServer.</c>
        /// </summary>
        public virtual string Provider { get; internal set; }
        /// <summary>
        ///   Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.
        /// </summary>
        public virtual bool? DataAnnotations { get; internal set; }
        /// <summary>
        ///   The name of the <c>DbContext</c> class to generate.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   The directory to put the <c>DbContext</c> class file in. Paths are relative to the project directory. Namespaces are derived from the folder names.
        /// </summary>
        public virtual string ContextDirectory { get; internal set; }
        /// <summary>
        ///   Overwrite existing files.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   The directory to put entity class files in. Paths are relative to the project directory.
        /// </summary>
        public virtual string OutputDirectory { get; internal set; }
        /// <summary>
        ///   The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.
        /// </summary>
        public virtual IReadOnlyList<string> Schemas => SchemasInternal.AsReadOnly();
        internal List<string> SchemasInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.
        /// </summary>
        public virtual IReadOnlyList<string> Tables => TablesInternal.AsReadOnly();
        internal List<string> TablesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.
        /// </summary>
        public virtual bool? UseDatabaseNames { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef dbcontext scaffold")
              .Add("{value}", Connection)
              .Add("{value}", Provider)
              .Add("--data-annotations", DataAnnotations)
              .Add("--context {value}", Context)
              .Add("--context-dir {value}", ContextDirectory)
              .Add("--force", Force)
              .Add("--output-dir {value}", OutputDirectory)
              .Add("--schema {value}", Schemas)
              .Add("--table {value}", Tables)
              .Add("--use-database-names", UseDatabaseNames)
              .Add("--json", Json)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkMigrationsAddSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkMigrationsAddSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   The name of the migration.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.
        /// </summary>
        public virtual string OutputDirectory { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef migrations add")
              .Add("{value}", Name)
              .Add("--output-dir {value}", OutputDirectory)
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkMigrationsListSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkMigrationsListSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef migrations list")
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkMigrationsRemoveSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkMigrationsRemoveSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.
        /// </summary>
        public virtual string OutputDirectory { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef migrations remove")
              .Add("--output-dir {value}", OutputDirectory)
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkMigrationsScriptSettings
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class EntityFrameworkMigrationsScriptSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the EntityFramework executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? EntityFrameworkTasks.EntityFrameworkPath;
        public override Action<OutputType, string> ProcessCustomLogger => EntityFrameworkTasks.EntityFrameworkLogger;
        /// <summary>
        ///   The starting migration. Migrations may be identified by name or by ID. The number 0 is a special case that means <em>before the first migration</em>. Defaults to 0.
        /// </summary>
        public virtual string From { get; internal set; }
        /// <summary>
        ///   The ending migration. Defaults to the last migration.
        /// </summary>
        public virtual string To { get; internal set; }
        /// <summary>
        ///   The file to write the script to.
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Generate a script that can be used on a database at any migration.
        /// </summary>
        public virtual bool? Idempotent { get; internal set; }
        /// <summary>
        ///   Show JSON output.
        /// </summary>
        public virtual bool? Json { get; internal set; }
        /// <summary>
        ///   The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the target project. Default value is the current folder.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Relative path to the project folder of the startup project. Default value is the current folder.
        /// </summary>
        public virtual string StartupProject { get; internal set; }
        /// <summary>
        ///   The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.
        /// </summary>
        public virtual string Framework { get; internal set; }
        /// <summary>
        ///   The build configuration, for example: <c>Debug</c> or <c>Release.</c>
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   Don't colorize output.
        /// </summary>
        public virtual bool? NoColor { get; internal set; }
        /// <summary>
        ///   Prefix output with level.
        /// </summary>
        public virtual bool? PrefixOutput { get; internal set; }
        /// <summary>
        ///   Show verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("ef migrations script")
              .Add("{value}", From)
              .Add("{value}", To)
              .Add("--output {value}", Output)
              .Add("--idempotent", Idempotent)
              .Add("--json", Json)
              .Add("--context {value}", Context)
              .Add("--project {value}", Project)
              .Add("--startup-project {value}", StartupProject)
              .Add("--framework {value}", Framework)
              .Add("--configuration {value}", Configuration)
              .Add("--runtime {value}", Runtime)
              .Add("--no-color", NoColor)
              .Add("--prefix-output", PrefixOutput)
              .Add("--verbose", Verbose);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region EntityFrameworkDatabaseDropSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkDatabaseDropSettingsExtensions
    {
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Force"/></em></p>
        ///   <p>Don't confirm.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Force"/></em></p>
        ///   <p>Don't confirm.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.Force"/></em></p>
        ///   <p>Don't confirm.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.Force"/></em></p>
        ///   <p>Don't confirm.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.Force"/></em></p>
        ///   <p>Don't confirm.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></em></p>
        ///   <p>Show which database would be dropped, but don't drop it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></em></p>
        ///   <p>Show which database would be dropped, but don't drop it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></em></p>
        ///   <p>Show which database would be dropped, but don't drop it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></em></p>
        ///   <p>Show which database would be dropped, but don't drop it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.DryRun"/></em></p>
        ///   <p>Show which database would be dropped, but don't drop it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseDropSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseDropSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkDatabaseUpdateSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkDatabaseUpdateSettingsExtensions
    {
        #region Migration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Migration"/></em></p>
        ///   <p>The target migration. Migrations may be identified by name or by ID. The number 0 is a special case that means before the first migration and causes all migrations to be reverted. If no migration is specified, the command defaults to the last migration.</p>
        /// </summary>
        [Pure]
        public static T SetMigration<T>(this T toolSettings, string migration) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Migration = migration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Migration"/></em></p>
        ///   <p>The target migration. Migrations may be identified by name or by ID. The number 0 is a special case that means before the first migration and causes all migrations to be reverted. If no migration is specified, the command defaults to the last migration.</p>
        /// </summary>
        [Pure]
        public static T ResetMigration<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Migration = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></em></p>
        ///   <p>This option shows which database would be dropped, but doesn't drop it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></em></p>
        ///   <p>This option shows which database would be dropped, but doesn't drop it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></em></p>
        ///   <p>This option shows which database would be dropped, but doesn't drop it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></em></p>
        ///   <p>This option shows which database would be dropped, but doesn't drop it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseUpdateSettings.DryRun"/></em></p>
        ///   <p>This option shows which database would be dropped, but doesn't drop it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseUpdateSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseUpdateSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseUpdateSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDatabaseUpdateSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkDatabaseUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkDbContextInfoSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkDbContextInfoSettingsExtensions
    {
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextInfoSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextInfoSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextInfoSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextInfoSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextInfoSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextInfoSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextInfoSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkDbContextListSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkDbContextListSettingsExtensions
    {
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkDbContextScaffoldSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkDbContextScaffoldSettingsExtensions
    {
        #region Connection
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Connection"/></em></p>
        ///   <p>The connection string to the database. For ASP.NET Core 2.x projects, the value can be <em>name=&lt;name of connection string&gt;</em>. In that case the name comes from the configuration sources that are set up for the project.</p>
        /// </summary>
        [Pure]
        public static T SetConnection<T>(this T toolSettings, string connection) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Connection = connection;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Connection"/></em></p>
        ///   <p>The connection string to the database. For ASP.NET Core 2.x projects, the value can be <em>name=&lt;name of connection string&gt;</em>. In that case the name comes from the configuration sources that are set up for the project.</p>
        /// </summary>
        [Pure]
        public static T ResetConnection<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Connection = null;
            return toolSettings;
        }
        #endregion
        #region Provider
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Provider"/></em></p>
        ///   <p>The provider to use. Typically this is the name of the NuGet package, for example: <c>Microsoft.EntityFrameworkCore.SqlServer.</c></p>
        /// </summary>
        [Pure]
        public static T SetProvider<T>(this T toolSettings, string provider) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Provider = provider;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Provider"/></em></p>
        ///   <p>The provider to use. Typically this is the name of the NuGet package, for example: <c>Microsoft.EntityFrameworkCore.SqlServer.</c></p>
        /// </summary>
        [Pure]
        public static T ResetProvider<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Provider = null;
            return toolSettings;
        }
        #endregion
        #region DataAnnotations
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></em></p>
        ///   <p>Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.</p>
        /// </summary>
        [Pure]
        public static T SetDataAnnotations<T>(this T toolSettings, bool? dataAnnotations) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DataAnnotations = dataAnnotations;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></em></p>
        ///   <p>Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.</p>
        /// </summary>
        [Pure]
        public static T ResetDataAnnotations<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DataAnnotations = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></em></p>
        ///   <p>Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.</p>
        /// </summary>
        [Pure]
        public static T EnableDataAnnotations<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DataAnnotations = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></em></p>
        ///   <p>Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.</p>
        /// </summary>
        [Pure]
        public static T DisableDataAnnotations<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DataAnnotations = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.DataAnnotations"/></em></p>
        ///   <p>Use attributes to configure the model (where possible). If this option is omitted, only the fluent API is used.</p>
        /// </summary>
        [Pure]
        public static T ToggleDataAnnotations<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DataAnnotations = !toolSettings.DataAnnotations;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Context"/></em></p>
        ///   <p>The name of the <c>DbContext</c> class to generate.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Context"/></em></p>
        ///   <p>The name of the <c>DbContext</c> class to generate.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region ContextDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.ContextDirectory"/></em></p>
        ///   <p>The directory to put the <c>DbContext</c> class file in. Paths are relative to the project directory. Namespaces are derived from the folder names.</p>
        /// </summary>
        [Pure]
        public static T SetContextDirectory<T>(this T toolSettings, string contextDirectory) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContextDirectory = contextDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.ContextDirectory"/></em></p>
        ///   <p>The directory to put the <c>DbContext</c> class file in. Paths are relative to the project directory. Namespaces are derived from the folder names.</p>
        /// </summary>
        [Pure]
        public static T ResetContextDirectory<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContextDirectory = null;
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></em></p>
        ///   <p>Overwrite existing files.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></em></p>
        ///   <p>Overwrite existing files.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></em></p>
        ///   <p>Overwrite existing files.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></em></p>
        ///   <p>Overwrite existing files.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.Force"/></em></p>
        ///   <p>Overwrite existing files.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region OutputDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.OutputDirectory"/></em></p>
        ///   <p>The directory to put entity class files in. Paths are relative to the project directory.</p>
        /// </summary>
        [Pure]
        public static T SetOutputDirectory<T>(this T toolSettings, string outputDirectory) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = outputDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.OutputDirectory"/></em></p>
        ///   <p>The directory to put entity class files in. Paths are relative to the project directory.</p>
        /// </summary>
        [Pure]
        public static T ResetOutputDirectory<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = null;
            return toolSettings;
        }
        #endregion
        #region Schemas
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/> to a new list</em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T SetSchemas<T>(this T toolSettings, params string[] schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemasInternal = schemas.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/> to a new list</em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T SetSchemas<T>(this T toolSettings, IEnumerable<string> schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemasInternal = schemas.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T AddSchemas<T>(this T toolSettings, params string[] schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemasInternal.AddRange(schemas);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T AddSchemas<T>(this T toolSettings, IEnumerable<string> schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemasInternal.AddRange(schemas);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T ClearSchemas<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemasInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T RemoveSchemas<T>(this T toolSettings, params string[] schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(schemas);
            toolSettings.SchemasInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="EntityFrameworkDbContextScaffoldSettings.Schemas"/></em></p>
        ///   <p>The schemas of tables to generate entity types for. To specify multiple schemas, repeat <c>--schema</c> for each one. If this option is omitted, all schemas are included.</p>
        /// </summary>
        [Pure]
        public static T RemoveSchemas<T>(this T toolSettings, IEnumerable<string> schemas) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(schemas);
            toolSettings.SchemasInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Tables
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/> to a new list</em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T SetTables<T>(this T toolSettings, params string[] tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TablesInternal = tables.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/> to a new list</em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T SetTables<T>(this T toolSettings, IEnumerable<string> tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TablesInternal = tables.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T AddTables<T>(this T toolSettings, params string[] tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TablesInternal.AddRange(tables);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T AddTables<T>(this T toolSettings, IEnumerable<string> tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TablesInternal.AddRange(tables);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T ClearTables<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TablesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T RemoveTables<T>(this T toolSettings, params string[] tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(tables);
            toolSettings.TablesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="EntityFrameworkDbContextScaffoldSettings.Tables"/></em></p>
        ///   <p>The tables to generate entity types for. To specify multiple tables, repeat <c>-t</c> or <c>--table</c> for each one. If this option is omitted, all tables are included.</p>
        /// </summary>
        [Pure]
        public static T RemoveTables<T>(this T toolSettings, IEnumerable<string> tables) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(tables);
            toolSettings.TablesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseDatabaseNames
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></em></p>
        ///   <p>Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.</p>
        /// </summary>
        [Pure]
        public static T SetUseDatabaseNames<T>(this T toolSettings, bool? useDatabaseNames) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDatabaseNames = useDatabaseNames;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></em></p>
        ///   <p>Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.</p>
        /// </summary>
        [Pure]
        public static T ResetUseDatabaseNames<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDatabaseNames = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></em></p>
        ///   <p>Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.</p>
        /// </summary>
        [Pure]
        public static T EnableUseDatabaseNames<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDatabaseNames = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></em></p>
        ///   <p>Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.</p>
        /// </summary>
        [Pure]
        public static T DisableUseDatabaseNames<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDatabaseNames = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.UseDatabaseNames"/></em></p>
        ///   <p>Use table and column names exactly as they appear in the database. If this option is omitted, database names are changed to more closely conform to C# name style conventions.</p>
        /// </summary>
        [Pure]
        public static T ToggleUseDatabaseNames<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDatabaseNames = !toolSettings.UseDatabaseNames;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkDbContextScaffoldSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkDbContextScaffoldSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkMigrationsAddSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkMigrationsAddSettingsExtensions
    {
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Name"/></em></p>
        ///   <p>The name of the migration.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Name"/></em></p>
        ///   <p>The name of the migration.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region OutputDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.OutputDirectory"/></em></p>
        ///   <p>The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.</p>
        /// </summary>
        [Pure]
        public static T SetOutputDirectory<T>(this T toolSettings, string outputDirectory) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = outputDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.OutputDirectory"/></em></p>
        ///   <p>The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.</p>
        /// </summary>
        [Pure]
        public static T ResetOutputDirectory<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = null;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsAddSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsAddSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsAddSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsAddSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsAddSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsAddSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsAddSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkMigrationsListSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkMigrationsListSettingsExtensions
    {
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsListSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsListSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsListSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsListSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsListSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkMigrationsRemoveSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkMigrationsRemoveSettingsExtensions
    {
        #region OutputDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.OutputDirectory"/></em></p>
        ///   <p>The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.</p>
        /// </summary>
        [Pure]
        public static T SetOutputDirectory<T>(this T toolSettings, string outputDirectory) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = outputDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.OutputDirectory"/></em></p>
        ///   <p>The directory (and sub-namespace) to use. Paths are relative to the project directory. Defaults to 'Migrations'.</p>
        /// </summary>
        [Pure]
        public static T ResetOutputDirectory<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputDirectory = null;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsRemoveSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsRemoveSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsRemoveSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsRemoveSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsRemoveSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region EntityFrameworkMigrationsScriptSettingsExtensions
    /// <summary>
    ///   Used within <see cref="EntityFrameworkTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class EntityFrameworkMigrationsScriptSettingsExtensions
    {
        #region From
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.From"/></em></p>
        ///   <p>The starting migration. Migrations may be identified by name or by ID. The number 0 is a special case that means <em>before the first migration</em>. Defaults to 0.</p>
        /// </summary>
        [Pure]
        public static T SetFrom<T>(this T toolSettings, string from) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.From = from;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.From"/></em></p>
        ///   <p>The starting migration. Migrations may be identified by name or by ID. The number 0 is a special case that means <em>before the first migration</em>. Defaults to 0.</p>
        /// </summary>
        [Pure]
        public static T ResetFrom<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.From = null;
            return toolSettings;
        }
        #endregion
        #region To
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.To"/></em></p>
        ///   <p>The ending migration. Defaults to the last migration.</p>
        /// </summary>
        [Pure]
        public static T SetTo<T>(this T toolSettings, string to) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.To = to;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.To"/></em></p>
        ///   <p>The ending migration. Defaults to the last migration.</p>
        /// </summary>
        [Pure]
        public static T ResetTo<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.To = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Output"/></em></p>
        ///   <p>The file to write the script to.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Output"/></em></p>
        ///   <p>The file to write the script to.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Idempotent
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></em></p>
        ///   <p>Generate a script that can be used on a database at any migration.</p>
        /// </summary>
        [Pure]
        public static T SetIdempotent<T>(this T toolSettings, bool? idempotent) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Idempotent = idempotent;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></em></p>
        ///   <p>Generate a script that can be used on a database at any migration.</p>
        /// </summary>
        [Pure]
        public static T ResetIdempotent<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Idempotent = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></em></p>
        ///   <p>Generate a script that can be used on a database at any migration.</p>
        /// </summary>
        [Pure]
        public static T EnableIdempotent<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Idempotent = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></em></p>
        ///   <p>Generate a script that can be used on a database at any migration.</p>
        /// </summary>
        [Pure]
        public static T DisableIdempotent<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Idempotent = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsScriptSettings.Idempotent"/></em></p>
        ///   <p>Generate a script that can be used on a database at any migration.</p>
        /// </summary>
        [Pure]
        public static T ToggleIdempotent<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Idempotent = !toolSettings.Idempotent;
            return toolSettings;
        }
        #endregion
        #region Json
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T SetJson<T>(this T toolSettings, bool? json) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = json;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ResetJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T EnableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T DisableJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsScriptSettings.Json"/></em></p>
        ///   <p>Show JSON output.</p>
        /// </summary>
        [Pure]
        public static T ToggleJson<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Json = !toolSettings.Json;
            return toolSettings;
        }
        #endregion
        #region Context
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T SetContext<T>(this T toolSettings, string context) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = context;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Context"/></em></p>
        ///   <p>The <c>DbContext</c> class to use. Class name only or fully qualified with namespaces. If this option is omitted, EF Core will find the context class. If there are multiple context classes, this option is required.</p>
        /// </summary>
        [Pure]
        public static T ResetContext<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Context = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Project"/></em></p>
        ///   <p>Relative path to the project folder of the target project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region StartupProject
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T SetStartupProject<T>(this T toolSettings, string startupProject) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = startupProject;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.StartupProject"/></em></p>
        ///   <p>Relative path to the project folder of the startup project. Default value is the current folder.</p>
        /// </summary>
        [Pure]
        public static T ResetStartupProject<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.StartupProject = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Framework"/></em></p>
        ///   <p>The <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks#supported-target-framework-versions">Target Framework Moniker</a> for the <a href="https://docs.microsoft.com/en-us/dotnet/standard/frameworks">target framework</a>. Use when the project file specifies multiple target frameworks, and you want to select one of them.</p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Configuration"/></em></p>
        ///   <p>The build configuration, for example: <c>Debug</c> or <c>Release.</c></p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Runtime"/></em></p>
        ///   <p>The identifier of the target runtime to restore packages for. For a list of Runtime Identifiers (RIDs), see the <a href="https://docs.microsoft.com/en-us/dotnet/core/rid-catalog">RID catalog</a>.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region NoColor
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T SetNoColor<T>(this T toolSettings, bool? noColor) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = noColor;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ResetNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T EnableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T DisableNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsScriptSettings.NoColor"/></em></p>
        ///   <p>Don't colorize output.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoColor<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoColor = !toolSettings.NoColor;
            return toolSettings;
        }
        #endregion
        #region PrefixOutput
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T SetPrefixOutput<T>(this T toolSettings, bool? prefixOutput) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = prefixOutput;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T ResetPrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T EnablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T DisablePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsScriptSettings.PrefixOutput"/></em></p>
        ///   <p>Prefix output with level.</p>
        /// </summary>
        [Pure]
        public static T TogglePrefixOutput<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PrefixOutput = !toolSettings.PrefixOutput;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="EntityFrameworkMigrationsScriptSettings.Verbose"/></em></p>
        ///   <p>Show verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : EntityFrameworkMigrationsScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
    }
    #endregion
}
