// Generated from https://github.com/nuke-build/nuke/blob/master/build/specifications/Kubernetes.json

using JetBrains.Annotations;
using Newtonsoft.Json;
using Nuke.Common;
using Nuke.Common.Execution;
using Nuke.Common.Tooling;
using Nuke.Common.Tools;
using Nuke.Common.Utilities.Collections;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Text;

namespace Nuke.Common.Tools.Kubernetes
{
    /// <summary>
    ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesTasks
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public static string KubernetesPath =>
            ToolPathResolver.TryGetEnvironmentExecutable("KUBERNETES_EXE") ??
            ToolPathResolver.GetPathExecutable("kubectl");
        public static Action<OutputType, string> KubernetesLogger { get; set; } = ProcessTasks.DefaultLogger;
        /// <summary>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        public static IReadOnlyCollection<Output> Kubernetes(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, bool? logTimestamp = null, string logFile = null, Func<string, string> outputFilter = null)
        {
            using var process = ProcessTasks.StartProcess(KubernetesPath, arguments, workingDirectory, environmentVariables, timeout, logOutput, logInvocation, logTimestamp, logFile, KubernetesLogger, outputFilter);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the supported API resources on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--api-group</c> via <see cref="KubernetesApiResourcesSettings.ApiGroup"/></li>
        ///     <li><c>--cached</c> via <see cref="KubernetesApiResourcesSettings.Cached"/></li>
        ///     <li><c>--namespaced</c> via <see cref="KubernetesApiResourcesSettings.Namespaced"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesApiResourcesSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApiResourcesSettings.Output"/></li>
        ///     <li><c>--verbs</c> via <see cref="KubernetesApiResourcesSettings.Verbs"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApiResources(KubernetesApiResourcesSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesApiResourcesSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the supported API resources on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--api-group</c> via <see cref="KubernetesApiResourcesSettings.ApiGroup"/></li>
        ///     <li><c>--cached</c> via <see cref="KubernetesApiResourcesSettings.Cached"/></li>
        ///     <li><c>--namespaced</c> via <see cref="KubernetesApiResourcesSettings.Namespaced"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesApiResourcesSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApiResourcesSettings.Output"/></li>
        ///     <li><c>--verbs</c> via <see cref="KubernetesApiResourcesSettings.Verbs"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApiResources(Configure<KubernetesApiResourcesSettings> configurator)
        {
            return KubernetesApiResources(configurator(new KubernetesApiResourcesSettings()));
        }
        /// <summary>
        ///   <p>Print the supported API resources on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--api-group</c> via <see cref="KubernetesApiResourcesSettings.ApiGroup"/></li>
        ///     <li><c>--cached</c> via <see cref="KubernetesApiResourcesSettings.Cached"/></li>
        ///     <li><c>--namespaced</c> via <see cref="KubernetesApiResourcesSettings.Namespaced"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesApiResourcesSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApiResourcesSettings.Output"/></li>
        ///     <li><c>--verbs</c> via <see cref="KubernetesApiResourcesSettings.Verbs"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesApiResourcesSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesApiResources(CombinatorialConfigure<KubernetesApiResourcesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesApiResources, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Drain node in preparation for maintenance. The given node will be marked unschedulable to prevent new pods from arriving. 'drain' evicts the pods if the APIServer supports eviction (http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE to delete the pods. The 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through the API server).  If there are DaemonSet-managed pods, drain will not proceed without --ignore-daemonsets, and regardless it will not delete any DaemonSet-managed pods, because those pods would be immediately replaced by the DaemonSet controller, which ignores unschedulable markings.  If there are any pods that are neither mirror pods nor managed by ReplicationController, ReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you use --force.  --force will also allow deletion to proceed if the managing resource of one or more pods is missing. 'drain' waits for graceful termination. You should not operate on the machine until the command completes. When you are ready to put the node back into service, use kubectl uncordon, which will make the node schedulable again. ! http://kubernetes.io/images/docs/kubectl_drain.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--delete-local-data</c> via <see cref="KubernetesDrainSettings.DeleteLocalData"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesDrainSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDrainSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDrainSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-daemonsets</c> via <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></li>
        ///     <li><c>--pod-selector</c> via <see cref="KubernetesDrainSettings.PodSelector"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDrainSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDrainSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDrain(KubernetesDrainSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesDrainSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Drain node in preparation for maintenance. The given node will be marked unschedulable to prevent new pods from arriving. 'drain' evicts the pods if the APIServer supports eviction (http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE to delete the pods. The 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through the API server).  If there are DaemonSet-managed pods, drain will not proceed without --ignore-daemonsets, and regardless it will not delete any DaemonSet-managed pods, because those pods would be immediately replaced by the DaemonSet controller, which ignores unschedulable markings.  If there are any pods that are neither mirror pods nor managed by ReplicationController, ReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you use --force.  --force will also allow deletion to proceed if the managing resource of one or more pods is missing. 'drain' waits for graceful termination. You should not operate on the machine until the command completes. When you are ready to put the node back into service, use kubectl uncordon, which will make the node schedulable again. ! http://kubernetes.io/images/docs/kubectl_drain.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--delete-local-data</c> via <see cref="KubernetesDrainSettings.DeleteLocalData"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesDrainSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDrainSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDrainSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-daemonsets</c> via <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></li>
        ///     <li><c>--pod-selector</c> via <see cref="KubernetesDrainSettings.PodSelector"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDrainSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDrainSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDrain(Configure<KubernetesDrainSettings> configurator)
        {
            return KubernetesDrain(configurator(new KubernetesDrainSettings()));
        }
        /// <summary>
        ///   <p>Drain node in preparation for maintenance. The given node will be marked unschedulable to prevent new pods from arriving. 'drain' evicts the pods if the APIServer supports eviction (http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE to delete the pods. The 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through the API server).  If there are DaemonSet-managed pods, drain will not proceed without --ignore-daemonsets, and regardless it will not delete any DaemonSet-managed pods, because those pods would be immediately replaced by the DaemonSet controller, which ignores unschedulable markings.  If there are any pods that are neither mirror pods nor managed by ReplicationController, ReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you use --force.  --force will also allow deletion to proceed if the managing resource of one or more pods is missing. 'drain' waits for graceful termination. You should not operate on the machine until the command completes. When you are ready to put the node back into service, use kubectl uncordon, which will make the node schedulable again. ! http://kubernetes.io/images/docs/kubectl_drain.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--delete-local-data</c> via <see cref="KubernetesDrainSettings.DeleteLocalData"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesDrainSettings.DryRun"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDrainSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDrainSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-daemonsets</c> via <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></li>
        ///     <li><c>--pod-selector</c> via <see cref="KubernetesDrainSettings.PodSelector"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDrainSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDrainSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesDrainSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesDrain(CombinatorialConfigure<KubernetesDrainSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesDrain, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesRunSettings.Name"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRun(KubernetesRunSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesRunSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesRunSettings.Name"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRun(Configure<KubernetesRunSettings> configurator)
        {
            return KubernetesRun(configurator(new KubernetesRunSettings()));
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesRunSettings.Name"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesRunSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesRun(CombinatorialConfigure<KubernetesRunSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesRun, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display one or many resources Prints a table of the most important information about the specified resources. You can filter the list using a label selector and the --selector flag. If the desired resource type is namespaced you will only see results in your current namespace unless you pass --all-namespaces. Uninitialized objects are not shown unless --include-uninitialized is passed. By specifying the output as 'template' and providing a Go template as the value of the --template flag, you can filter the attributes of the fetched resources.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesGetSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesGetSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--chunk-size</c> via <see cref="KubernetesGetSettings.ChunkSize"/></li>
        ///     <li><c>--export</c> via <see cref="KubernetesGetSettings.Export"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesGetSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesGetSettings.Filename"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesGetSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesGetSettings.IncludeUninitialized"/></li>
        ///     <li><c>--label-columns</c> via <see cref="KubernetesGetSettings.LabelColumns"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesGetSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesGetSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesGetSettings.Raw"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesGetSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesGetSettings.Selector"/></li>
        ///     <li><c>--server-print</c> via <see cref="KubernetesGetSettings.ServerPrint"/></li>
        ///     <li><c>--show-all</c> via <see cref="KubernetesGetSettings.ShowAll"/></li>
        ///     <li><c>--show-kind</c> via <see cref="KubernetesGetSettings.ShowKind"/></li>
        ///     <li><c>--show-labels</c> via <see cref="KubernetesGetSettings.ShowLabels"/></li>
        ///     <li><c>--sort-by</c> via <see cref="KubernetesGetSettings.SortBy"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesGetSettings.Template"/></li>
        ///     <li><c>--use-openapi-print-columns</c> via <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></li>
        ///     <li><c>--watch</c> via <see cref="KubernetesGetSettings.Watch"/></li>
        ///     <li><c>--watch-only</c> via <see cref="KubernetesGetSettings.WatchOnly"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesGet(KubernetesGetSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesGetSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display one or many resources Prints a table of the most important information about the specified resources. You can filter the list using a label selector and the --selector flag. If the desired resource type is namespaced you will only see results in your current namespace unless you pass --all-namespaces. Uninitialized objects are not shown unless --include-uninitialized is passed. By specifying the output as 'template' and providing a Go template as the value of the --template flag, you can filter the attributes of the fetched resources.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesGetSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesGetSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--chunk-size</c> via <see cref="KubernetesGetSettings.ChunkSize"/></li>
        ///     <li><c>--export</c> via <see cref="KubernetesGetSettings.Export"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesGetSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesGetSettings.Filename"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesGetSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesGetSettings.IncludeUninitialized"/></li>
        ///     <li><c>--label-columns</c> via <see cref="KubernetesGetSettings.LabelColumns"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesGetSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesGetSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesGetSettings.Raw"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesGetSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesGetSettings.Selector"/></li>
        ///     <li><c>--server-print</c> via <see cref="KubernetesGetSettings.ServerPrint"/></li>
        ///     <li><c>--show-all</c> via <see cref="KubernetesGetSettings.ShowAll"/></li>
        ///     <li><c>--show-kind</c> via <see cref="KubernetesGetSettings.ShowKind"/></li>
        ///     <li><c>--show-labels</c> via <see cref="KubernetesGetSettings.ShowLabels"/></li>
        ///     <li><c>--sort-by</c> via <see cref="KubernetesGetSettings.SortBy"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesGetSettings.Template"/></li>
        ///     <li><c>--use-openapi-print-columns</c> via <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></li>
        ///     <li><c>--watch</c> via <see cref="KubernetesGetSettings.Watch"/></li>
        ///     <li><c>--watch-only</c> via <see cref="KubernetesGetSettings.WatchOnly"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesGet(Configure<KubernetesGetSettings> configurator)
        {
            return KubernetesGet(configurator(new KubernetesGetSettings()));
        }
        /// <summary>
        ///   <p>Display one or many resources Prints a table of the most important information about the specified resources. You can filter the list using a label selector and the --selector flag. If the desired resource type is namespaced you will only see results in your current namespace unless you pass --all-namespaces. Uninitialized objects are not shown unless --include-uninitialized is passed. By specifying the output as 'template' and providing a Go template as the value of the --template flag, you can filter the attributes of the fetched resources.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesGetSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesGetSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--chunk-size</c> via <see cref="KubernetesGetSettings.ChunkSize"/></li>
        ///     <li><c>--export</c> via <see cref="KubernetesGetSettings.Export"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesGetSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesGetSettings.Filename"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesGetSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesGetSettings.IncludeUninitialized"/></li>
        ///     <li><c>--label-columns</c> via <see cref="KubernetesGetSettings.LabelColumns"/></li>
        ///     <li><c>--no-headers</c> via <see cref="KubernetesGetSettings.NoHeaders"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesGetSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesGetSettings.Raw"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesGetSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesGetSettings.Selector"/></li>
        ///     <li><c>--server-print</c> via <see cref="KubernetesGetSettings.ServerPrint"/></li>
        ///     <li><c>--show-all</c> via <see cref="KubernetesGetSettings.ShowAll"/></li>
        ///     <li><c>--show-kind</c> via <see cref="KubernetesGetSettings.ShowKind"/></li>
        ///     <li><c>--show-labels</c> via <see cref="KubernetesGetSettings.ShowLabels"/></li>
        ///     <li><c>--sort-by</c> via <see cref="KubernetesGetSettings.SortBy"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesGetSettings.Template"/></li>
        ///     <li><c>--use-openapi-print-columns</c> via <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></li>
        ///     <li><c>--watch</c> via <see cref="KubernetesGetSettings.Watch"/></li>
        ///     <li><c>--watch-only</c> via <see cref="KubernetesGetSettings.WatchOnly"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesGetSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesGet(CombinatorialConfigure<KubernetesGetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesGet, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Print the client and server version information for the current context.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--client</c> via <see cref="KubernetesVersionSettings.Client"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesVersionSettings.Output"/></li>
        ///     <li><c>--short</c> via <see cref="KubernetesVersionSettings.Short"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesVersion(KubernetesVersionSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesVersionSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the client and server version information for the current context.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--client</c> via <see cref="KubernetesVersionSettings.Client"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesVersionSettings.Output"/></li>
        ///     <li><c>--short</c> via <see cref="KubernetesVersionSettings.Short"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesVersion(Configure<KubernetesVersionSettings> configurator)
        {
            return KubernetesVersion(configurator(new KubernetesVersionSettings()));
        }
        /// <summary>
        ///   <p>Print the client and server version information for the current context.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--client</c> via <see cref="KubernetesVersionSettings.Client"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesVersionSettings.Output"/></li>
        ///     <li><c>--short</c> via <see cref="KubernetesVersionSettings.Short"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesVersionSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesVersion(CombinatorialConfigure<KubernetesVersionSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesVersion, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display Resource (CPU/Memory/Storage) usage. The top command allows you to see the resource consumption for nodes or pods. This command requires Heapster to be correctly configured and working on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesTop(KubernetesTopSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesTopSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display Resource (CPU/Memory/Storage) usage. The top command allows you to see the resource consumption for nodes or pods. This command requires Heapster to be correctly configured and working on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesTop(Configure<KubernetesTopSettings> configurator)
        {
            return KubernetesTop(configurator(new KubernetesTopSettings()));
        }
        /// <summary>
        ///   <p>Display Resource (CPU/Memory/Storage) usage. The top command allows you to see the resource consumption for nodes or pods. This command requires Heapster to be correctly configured and working on the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesTopSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesTop(CombinatorialConfigure<KubernetesTopSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesTop, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Modify kubeconfig files using subcommands like "kubectl config set current-context my-context" The loading order follows these rules:   1. If the --kubeconfig flag is set, then only that file is loaded.  The flag may only be set once and no merging takes place.    2. If $KUBECONFIG environment variable is set, then it is used a list of paths (normal path delimitting rules for your system).  These paths are merged.  When a value is modified, it is modified in the file that defines the stanza.  When a value is created, it is created in the first file that exists.  If no files in the chain exist, then it creates the last file in the list.    3. Otherwise, ${HOME}/.kube/config is used and no merging takes place.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesConfig(KubernetesConfigSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesConfigSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Modify kubeconfig files using subcommands like "kubectl config set current-context my-context" The loading order follows these rules:   1. If the --kubeconfig flag is set, then only that file is loaded.  The flag may only be set once and no merging takes place.    2. If $KUBECONFIG environment variable is set, then it is used a list of paths (normal path delimitting rules for your system).  These paths are merged.  When a value is modified, it is modified in the file that defines the stanza.  When a value is created, it is created in the first file that exists.  If no files in the chain exist, then it creates the last file in the list.    3. Otherwise, ${HOME}/.kube/config is used and no merging takes place.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesConfig(Configure<KubernetesConfigSettings> configurator)
        {
            return KubernetesConfig(configurator(new KubernetesConfigSettings()));
        }
        /// <summary>
        ///   <p>Modify kubeconfig files using subcommands like "kubectl config set current-context my-context" The loading order follows these rules:   1. If the --kubeconfig flag is set, then only that file is loaded.  The flag may only be set once and no merging takes place.    2. If $KUBECONFIG environment variable is set, then it is used a list of paths (normal path delimitting rules for your system).  These paths are merged.  When a value is modified, it is modified in the file that defines the stanza.  When a value is created, it is created in the first file that exists.  If no files in the chain exist, then it creates the last file in the list.    3. Otherwise, ${HOME}/.kube/config is used and no merging takes place.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesConfigSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesConfig(CombinatorialConfigure<KubernetesConfigSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesConfig, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Execute a command in a container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;podName&gt;</c> via <see cref="KubernetesExecSettings.PodName"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesExecSettings.Container"/></li>
        ///     <li><c>--pod</c> via <see cref="KubernetesExecSettings.Pod"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesExecSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesExecSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExec(KubernetesExecSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesExecSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Execute a command in a container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;podName&gt;</c> via <see cref="KubernetesExecSettings.PodName"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesExecSettings.Container"/></li>
        ///     <li><c>--pod</c> via <see cref="KubernetesExecSettings.Pod"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesExecSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesExecSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExec(Configure<KubernetesExecSettings> configurator)
        {
            return KubernetesExec(configurator(new KubernetesExecSettings()));
        }
        /// <summary>
        ///   <p>Execute a command in a container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;podName&gt;</c> via <see cref="KubernetesExecSettings.PodName"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesExecSettings.Container"/></li>
        ///     <li><c>--pod</c> via <see cref="KubernetesExecSettings.Pod"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesExecSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesExecSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesExecSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesExec(CombinatorialConfigure<KubernetesExecSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesExec, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Perform a rolling update of the given ReplicationController. Replaces the specified replication controller with a new replication controller by updating one pod at a time to use the new PodTemplate. The new-controller.json must specify the same namespace as the existing replication controller and overwrite at least one (common) label in its replicaSelector. ! http://kubernetes.io/images/docs/kubectl_rollingupdate.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesRollingUpdateSettings.Container"/></li>
        ///     <li><c>--deployment-label-key</c> via <see cref="KubernetesRollingUpdateSettings.DeploymentLabelKey"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRollingUpdateSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRollingUpdateSettings.Filename"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRollingUpdateSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRollingUpdateSettings.ImagePullPolicy"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRollingUpdateSettings.Output"/></li>
        ///     <li><c>--poll-interval</c> via <see cref="KubernetesRollingUpdateSettings.PollInterval"/></li>
        ///     <li><c>--rollback</c> via <see cref="KubernetesRollingUpdateSettings.Rollback"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRollingUpdateSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRollingUpdateSettings.Timeout"/></li>
        ///     <li><c>--update-period</c> via <see cref="KubernetesRollingUpdateSettings.UpdatePeriod"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesRollingUpdateSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRollingUpdate(KubernetesRollingUpdateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesRollingUpdateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Perform a rolling update of the given ReplicationController. Replaces the specified replication controller with a new replication controller by updating one pod at a time to use the new PodTemplate. The new-controller.json must specify the same namespace as the existing replication controller and overwrite at least one (common) label in its replicaSelector. ! http://kubernetes.io/images/docs/kubectl_rollingupdate.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesRollingUpdateSettings.Container"/></li>
        ///     <li><c>--deployment-label-key</c> via <see cref="KubernetesRollingUpdateSettings.DeploymentLabelKey"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRollingUpdateSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRollingUpdateSettings.Filename"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRollingUpdateSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRollingUpdateSettings.ImagePullPolicy"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRollingUpdateSettings.Output"/></li>
        ///     <li><c>--poll-interval</c> via <see cref="KubernetesRollingUpdateSettings.PollInterval"/></li>
        ///     <li><c>--rollback</c> via <see cref="KubernetesRollingUpdateSettings.Rollback"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRollingUpdateSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRollingUpdateSettings.Timeout"/></li>
        ///     <li><c>--update-period</c> via <see cref="KubernetesRollingUpdateSettings.UpdatePeriod"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesRollingUpdateSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRollingUpdate(Configure<KubernetesRollingUpdateSettings> configurator)
        {
            return KubernetesRollingUpdate(configurator(new KubernetesRollingUpdateSettings()));
        }
        /// <summary>
        ///   <p>Perform a rolling update of the given ReplicationController. Replaces the specified replication controller with a new replication controller by updating one pod at a time to use the new PodTemplate. The new-controller.json must specify the same namespace as the existing replication controller and overwrite at least one (common) label in its replicaSelector. ! http://kubernetes.io/images/docs/kubectl_rollingupdate.svg.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesRollingUpdateSettings.Container"/></li>
        ///     <li><c>--deployment-label-key</c> via <see cref="KubernetesRollingUpdateSettings.DeploymentLabelKey"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRollingUpdateSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRollingUpdateSettings.Filename"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRollingUpdateSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRollingUpdateSettings.ImagePullPolicy"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRollingUpdateSettings.Output"/></li>
        ///     <li><c>--poll-interval</c> via <see cref="KubernetesRollingUpdateSettings.PollInterval"/></li>
        ///     <li><c>--rollback</c> via <see cref="KubernetesRollingUpdateSettings.Rollback"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRollingUpdateSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRollingUpdateSettings.Timeout"/></li>
        ///     <li><c>--update-period</c> via <see cref="KubernetesRollingUpdateSettings.UpdatePeriod"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesRollingUpdateSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesRollingUpdateSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesRollingUpdate(CombinatorialConfigure<KubernetesRollingUpdateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesRollingUpdate, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update the labels on a resource.   * A label key and value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters each.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.    * If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;labels&gt;</c> via <see cref="KubernetesLabelSettings.Labels"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLabelSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesLabelSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesLabelSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesLabelSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesLabelSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesLabelSettings.IncludeUninitialized"/></li>
        ///     <li><c>--list</c> via <see cref="KubernetesLabelSettings.List"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesLabelSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesLabelSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesLabelSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesLabelSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesLabelSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesLabelSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLabelSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesLabelSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesLabel(KubernetesLabelSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesLabelSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update the labels on a resource.   * A label key and value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters each.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.    * If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;labels&gt;</c> via <see cref="KubernetesLabelSettings.Labels"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLabelSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesLabelSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesLabelSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesLabelSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesLabelSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesLabelSettings.IncludeUninitialized"/></li>
        ///     <li><c>--list</c> via <see cref="KubernetesLabelSettings.List"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesLabelSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesLabelSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesLabelSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesLabelSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesLabelSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesLabelSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLabelSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesLabelSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesLabel(Configure<KubernetesLabelSettings> configurator)
        {
            return KubernetesLabel(configurator(new KubernetesLabelSettings()));
        }
        /// <summary>
        ///   <p>Update the labels on a resource.   * A label key and value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters each.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.    * If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;labels&gt;</c> via <see cref="KubernetesLabelSettings.Labels"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLabelSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesLabelSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesLabelSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesLabelSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesLabelSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesLabelSettings.IncludeUninitialized"/></li>
        ///     <li><c>--list</c> via <see cref="KubernetesLabelSettings.List"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesLabelSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesLabelSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesLabelSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesLabelSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesLabelSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesLabelSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLabelSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesLabelSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesLabelSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesLabel(CombinatorialConfigure<KubernetesLabelSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesLabel, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update the annotations on one or more resources All Kubernetes objects support the ability to store additional data with the object as annotations. Annotations are key/value pairs that can be larger than labels and include arbitrary string values such as structured JSON. Tools and system extensions may use annotations to store their own data. Attempting to set an annotation that already exists will fail unless --overwrite is set. If --resource-version is specified and does not match the current resource version on the server the command will fail.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;annotations&gt;</c> via <see cref="KubernetesAnnotateSettings.Annotations"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesAnnotateSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesAnnotateSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAnnotateSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesAnnotateSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAnnotateSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesAnnotateSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAnnotateSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesAnnotateSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAnnotateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAnnotateSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesAnnotateSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesAnnotateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAnnotateSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAnnotate(KubernetesAnnotateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesAnnotateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update the annotations on one or more resources All Kubernetes objects support the ability to store additional data with the object as annotations. Annotations are key/value pairs that can be larger than labels and include arbitrary string values such as structured JSON. Tools and system extensions may use annotations to store their own data. Attempting to set an annotation that already exists will fail unless --overwrite is set. If --resource-version is specified and does not match the current resource version on the server the command will fail.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;annotations&gt;</c> via <see cref="KubernetesAnnotateSettings.Annotations"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesAnnotateSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesAnnotateSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAnnotateSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesAnnotateSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAnnotateSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesAnnotateSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAnnotateSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesAnnotateSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAnnotateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAnnotateSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesAnnotateSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesAnnotateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAnnotateSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAnnotate(Configure<KubernetesAnnotateSettings> configurator)
        {
            return KubernetesAnnotate(configurator(new KubernetesAnnotateSettings()));
        }
        /// <summary>
        ///   <p>Update the annotations on one or more resources All Kubernetes objects support the ability to store additional data with the object as annotations. Annotations are key/value pairs that can be larger than labels and include arbitrary string values such as structured JSON. Tools and system extensions may use annotations to store their own data. Attempting to set an annotation that already exists will fail unless --overwrite is set. If --resource-version is specified and does not match the current resource version on the server the command will fail.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;annotations&gt;</c> via <see cref="KubernetesAnnotateSettings.Annotations"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesAnnotateSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesAnnotateSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAnnotateSettings.DryRun"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesAnnotateSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAnnotateSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesAnnotateSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAnnotateSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesAnnotateSettings.Overwrite"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAnnotateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAnnotateSettings.Recursive"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesAnnotateSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesAnnotateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAnnotateSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesAnnotateSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesAnnotate(CombinatorialConfigure<KubernetesAnnotateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesAnnotate, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Delete resources by filenames, stdin, resources and names, or by resources and label selector. JSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames, resources and names, or resources and label selector. Some resources, such as pods, support graceful deletion. These resources define a default period before they are forcibly terminated (the grace period) but you may override that value with the --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often represent entities in the cluster, deletion may not be acknowledged immediately. If the node hosting a pod is down or cannot reach the API server, termination may take significantly longer than the grace period. To force delete a resource, you must pass a grace period of 0 and specify the --force flag. IMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been terminated, which can leave those processes running until the node detects the deletion and completes graceful deletion. If your processes use shared storage or talk to a remote API and depend on the name of the pod to identify themselves, force deleting those pods may result in multiple processes running on different machines using the same identification which may lead to data corruption or inconsistency. Only force delete pods when you are sure the pod is terminated, or if your application can tolerate multiple copies of the same pod running at once. Also, if you force delete pods the scheduler may place new pods on those nodes before the node has released those resources and causing those pods to be evicted immediately. Note that the delete command does NOT do resource version checks, so if someone submits an update to a resource right when you submit a delete, their update will be lost along with the rest of the resource.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesDeleteSettings.All"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesDeleteSettings.Cascade"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesDeleteSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDeleteSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDeleteSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDeleteSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></li>
        ///     <li><c>--now</c> via <see cref="KubernetesDeleteSettings.Now"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesDeleteSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDeleteSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDeleteSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDeleteSettings.Timeout"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesDeleteSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDelete(KubernetesDeleteSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesDeleteSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Delete resources by filenames, stdin, resources and names, or by resources and label selector. JSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames, resources and names, or resources and label selector. Some resources, such as pods, support graceful deletion. These resources define a default period before they are forcibly terminated (the grace period) but you may override that value with the --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often represent entities in the cluster, deletion may not be acknowledged immediately. If the node hosting a pod is down or cannot reach the API server, termination may take significantly longer than the grace period. To force delete a resource, you must pass a grace period of 0 and specify the --force flag. IMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been terminated, which can leave those processes running until the node detects the deletion and completes graceful deletion. If your processes use shared storage or talk to a remote API and depend on the name of the pod to identify themselves, force deleting those pods may result in multiple processes running on different machines using the same identification which may lead to data corruption or inconsistency. Only force delete pods when you are sure the pod is terminated, or if your application can tolerate multiple copies of the same pod running at once. Also, if you force delete pods the scheduler may place new pods on those nodes before the node has released those resources and causing those pods to be evicted immediately. Note that the delete command does NOT do resource version checks, so if someone submits an update to a resource right when you submit a delete, their update will be lost along with the rest of the resource.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesDeleteSettings.All"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesDeleteSettings.Cascade"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesDeleteSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDeleteSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDeleteSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDeleteSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></li>
        ///     <li><c>--now</c> via <see cref="KubernetesDeleteSettings.Now"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesDeleteSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDeleteSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDeleteSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDeleteSettings.Timeout"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesDeleteSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDelete(Configure<KubernetesDeleteSettings> configurator)
        {
            return KubernetesDelete(configurator(new KubernetesDeleteSettings()));
        }
        /// <summary>
        ///   <p>Delete resources by filenames, stdin, resources and names, or by resources and label selector. JSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames, resources and names, or resources and label selector. Some resources, such as pods, support graceful deletion. These resources define a default period before they are forcibly terminated (the grace period) but you may override that value with the --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often represent entities in the cluster, deletion may not be acknowledged immediately. If the node hosting a pod is down or cannot reach the API server, termination may take significantly longer than the grace period. To force delete a resource, you must pass a grace period of 0 and specify the --force flag. IMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been terminated, which can leave those processes running until the node detects the deletion and completes graceful deletion. If your processes use shared storage or talk to a remote API and depend on the name of the pod to identify themselves, force deleting those pods may result in multiple processes running on different machines using the same identification which may lead to data corruption or inconsistency. Only force delete pods when you are sure the pod is terminated, or if your application can tolerate multiple copies of the same pod running at once. Also, if you force delete pods the scheduler may place new pods on those nodes before the node has released those resources and causing those pods to be evicted immediately. Note that the delete command does NOT do resource version checks, so if someone submits an update to a resource right when you submit a delete, their update will be lost along with the rest of the resource.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesDeleteSettings.All"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesDeleteSettings.Cascade"/></li>
        ///     <li><c>--field-selector</c> via <see cref="KubernetesDeleteSettings.FieldSelector"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDeleteSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesDeleteSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesDeleteSettings.GracePeriod"/></li>
        ///     <li><c>--ignore-not-found</c> via <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></li>
        ///     <li><c>--now</c> via <see cref="KubernetesDeleteSettings.Now"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesDeleteSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDeleteSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDeleteSettings.Selector"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesDeleteSettings.Timeout"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesDeleteSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesDeleteSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesDelete(CombinatorialConfigure<KubernetesDeleteSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesDelete, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Expose a resource as a new Kubernetes service. Looks up a deployment, service, replica set, replication controller or pod by name and uses the selector for that resource as the selector for a new service on the specified port. A deployment or replica set will be exposed as a service only if its selector is convertible to a selector that service supports, i.e. when the selector contains only the matchLabels component. Note that if no port is specified via --port and the exposed resource has multiple ports, all will be re-used by the new service. Also if no labels are specified, the new service will re-use the labels from the resource it exposes. Possible resources include (case insensitive): pod (po), service (svc), replicationcontroller (rc), deployment (deploy), replicaset (rs).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cluster-ip</c> via <see cref="KubernetesExposeSettings.ClusterIp"/></li>
        ///     <li><c>--container-port</c> via <see cref="KubernetesExposeSettings.ContainerPort"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesExposeSettings.DryRun"/></li>
        ///     <li><c>--external-ip</c> via <see cref="KubernetesExposeSettings.ExternalIp"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesExposeSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesExposeSettings.Generator"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesExposeSettings.Labels"/></li>
        ///     <li><c>--load-balancer-ip</c> via <see cref="KubernetesExposeSettings.LoadBalancerIp"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesExposeSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesExposeSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesExposeSettings.Overrides"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesExposeSettings.Port"/></li>
        ///     <li><c>--protocol</c> via <see cref="KubernetesExposeSettings.Protocol"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesExposeSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExposeSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesExposeSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesExposeSettings.Selector"/></li>
        ///     <li><c>--session-affinity</c> via <see cref="KubernetesExposeSettings.SessionAffinity"/></li>
        ///     <li><c>--target-port</c> via <see cref="KubernetesExposeSettings.TargetPort"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesExposeSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesExposeSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExpose(KubernetesExposeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesExposeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Expose a resource as a new Kubernetes service. Looks up a deployment, service, replica set, replication controller or pod by name and uses the selector for that resource as the selector for a new service on the specified port. A deployment or replica set will be exposed as a service only if its selector is convertible to a selector that service supports, i.e. when the selector contains only the matchLabels component. Note that if no port is specified via --port and the exposed resource has multiple ports, all will be re-used by the new service. Also if no labels are specified, the new service will re-use the labels from the resource it exposes. Possible resources include (case insensitive): pod (po), service (svc), replicationcontroller (rc), deployment (deploy), replicaset (rs).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cluster-ip</c> via <see cref="KubernetesExposeSettings.ClusterIp"/></li>
        ///     <li><c>--container-port</c> via <see cref="KubernetesExposeSettings.ContainerPort"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesExposeSettings.DryRun"/></li>
        ///     <li><c>--external-ip</c> via <see cref="KubernetesExposeSettings.ExternalIp"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesExposeSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesExposeSettings.Generator"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesExposeSettings.Labels"/></li>
        ///     <li><c>--load-balancer-ip</c> via <see cref="KubernetesExposeSettings.LoadBalancerIp"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesExposeSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesExposeSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesExposeSettings.Overrides"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesExposeSettings.Port"/></li>
        ///     <li><c>--protocol</c> via <see cref="KubernetesExposeSettings.Protocol"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesExposeSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExposeSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesExposeSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesExposeSettings.Selector"/></li>
        ///     <li><c>--session-affinity</c> via <see cref="KubernetesExposeSettings.SessionAffinity"/></li>
        ///     <li><c>--target-port</c> via <see cref="KubernetesExposeSettings.TargetPort"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesExposeSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesExposeSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExpose(Configure<KubernetesExposeSettings> configurator)
        {
            return KubernetesExpose(configurator(new KubernetesExposeSettings()));
        }
        /// <summary>
        ///   <p>Expose a resource as a new Kubernetes service. Looks up a deployment, service, replica set, replication controller or pod by name and uses the selector for that resource as the selector for a new service on the specified port. A deployment or replica set will be exposed as a service only if its selector is convertible to a selector that service supports, i.e. when the selector contains only the matchLabels component. Note that if no port is specified via --port and the exposed resource has multiple ports, all will be re-used by the new service. Also if no labels are specified, the new service will re-use the labels from the resource it exposes. Possible resources include (case insensitive): pod (po), service (svc), replicationcontroller (rc), deployment (deploy), replicaset (rs).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cluster-ip</c> via <see cref="KubernetesExposeSettings.ClusterIp"/></li>
        ///     <li><c>--container-port</c> via <see cref="KubernetesExposeSettings.ContainerPort"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesExposeSettings.DryRun"/></li>
        ///     <li><c>--external-ip</c> via <see cref="KubernetesExposeSettings.ExternalIp"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesExposeSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesExposeSettings.Generator"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesExposeSettings.Labels"/></li>
        ///     <li><c>--load-balancer-ip</c> via <see cref="KubernetesExposeSettings.LoadBalancerIp"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesExposeSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesExposeSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesExposeSettings.Overrides"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesExposeSettings.Port"/></li>
        ///     <li><c>--protocol</c> via <see cref="KubernetesExposeSettings.Protocol"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesExposeSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExposeSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesExposeSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesExposeSettings.Selector"/></li>
        ///     <li><c>--session-affinity</c> via <see cref="KubernetesExposeSettings.SessionAffinity"/></li>
        ///     <li><c>--target-port</c> via <see cref="KubernetesExposeSettings.TargetPort"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesExposeSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesExposeSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesExposeSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesExpose(CombinatorialConfigure<KubernetesExposeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesExpose, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Print the list of flags inherited by all commands.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesOptions(KubernetesOptionsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesOptionsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the list of flags inherited by all commands.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesOptions(Configure<KubernetesOptionsSettings> configurator)
        {
            return KubernetesOptions(configurator(new KubernetesOptionsSettings()));
        }
        /// <summary>
        ///   <p>Print the list of flags inherited by all commands.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesOptionsSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesOptions(CombinatorialConfigure<KubernetesOptionsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesOptions, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Attach to a process that is already running inside an existing container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;pod&gt;</c> via <see cref="KubernetesAttachSettings.Pod"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesAttachSettings.Container"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesAttachSettings.PodRunningTimeout"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesAttachSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesAttachSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAttach(KubernetesAttachSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesAttachSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Attach to a process that is already running inside an existing container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;pod&gt;</c> via <see cref="KubernetesAttachSettings.Pod"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesAttachSettings.Container"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesAttachSettings.PodRunningTimeout"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesAttachSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesAttachSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAttach(Configure<KubernetesAttachSettings> configurator)
        {
            return KubernetesAttach(configurator(new KubernetesAttachSettings()));
        }
        /// <summary>
        ///   <p>Attach to a process that is already running inside an existing container.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;pod&gt;</c> via <see cref="KubernetesAttachSettings.Pod"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesAttachSettings.Container"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesAttachSettings.PodRunningTimeout"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesAttachSettings.Stdin"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesAttachSettings.Tty"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesAttachSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesAttach(CombinatorialConfigure<KubernetesAttachSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesAttach, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Creates a proxy server or application-level gateway between localhost and the Kubernetes API Server. It also allows serving static content over specified HTTP path. All incoming data enters through one port and gets forwarded to the remote kubernetes API Server port, except for the path matching the static content path.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--accept-hosts</c> via <see cref="KubernetesProxySettings.AcceptHosts"/></li>
        ///     <li><c>--accept-paths</c> via <see cref="KubernetesProxySettings.AcceptPaths"/></li>
        ///     <li><c>--address</c> via <see cref="KubernetesProxySettings.Address"/></li>
        ///     <li><c>--api-prefix</c> via <see cref="KubernetesProxySettings.ApiPrefix"/></li>
        ///     <li><c>--disable-filter</c> via <see cref="KubernetesProxySettings.DisableFilter"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesProxySettings.Port"/></li>
        ///     <li><c>--reject-methods</c> via <see cref="KubernetesProxySettings.RejectMethods"/></li>
        ///     <li><c>--reject-paths</c> via <see cref="KubernetesProxySettings.RejectPaths"/></li>
        ///     <li><c>--unix-socket</c> via <see cref="KubernetesProxySettings.UnixSocket"/></li>
        ///     <li><c>--www</c> via <see cref="KubernetesProxySettings.Www"/></li>
        ///     <li><c>--www-prefix</c> via <see cref="KubernetesProxySettings.WwwPrefix"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesProxy(KubernetesProxySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesProxySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Creates a proxy server or application-level gateway between localhost and the Kubernetes API Server. It also allows serving static content over specified HTTP path. All incoming data enters through one port and gets forwarded to the remote kubernetes API Server port, except for the path matching the static content path.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--accept-hosts</c> via <see cref="KubernetesProxySettings.AcceptHosts"/></li>
        ///     <li><c>--accept-paths</c> via <see cref="KubernetesProxySettings.AcceptPaths"/></li>
        ///     <li><c>--address</c> via <see cref="KubernetesProxySettings.Address"/></li>
        ///     <li><c>--api-prefix</c> via <see cref="KubernetesProxySettings.ApiPrefix"/></li>
        ///     <li><c>--disable-filter</c> via <see cref="KubernetesProxySettings.DisableFilter"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesProxySettings.Port"/></li>
        ///     <li><c>--reject-methods</c> via <see cref="KubernetesProxySettings.RejectMethods"/></li>
        ///     <li><c>--reject-paths</c> via <see cref="KubernetesProxySettings.RejectPaths"/></li>
        ///     <li><c>--unix-socket</c> via <see cref="KubernetesProxySettings.UnixSocket"/></li>
        ///     <li><c>--www</c> via <see cref="KubernetesProxySettings.Www"/></li>
        ///     <li><c>--www-prefix</c> via <see cref="KubernetesProxySettings.WwwPrefix"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesProxy(Configure<KubernetesProxySettings> configurator)
        {
            return KubernetesProxy(configurator(new KubernetesProxySettings()));
        }
        /// <summary>
        ///   <p>Creates a proxy server or application-level gateway between localhost and the Kubernetes API Server. It also allows serving static content over specified HTTP path. All incoming data enters through one port and gets forwarded to the remote kubernetes API Server port, except for the path matching the static content path.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--accept-hosts</c> via <see cref="KubernetesProxySettings.AcceptHosts"/></li>
        ///     <li><c>--accept-paths</c> via <see cref="KubernetesProxySettings.AcceptPaths"/></li>
        ///     <li><c>--address</c> via <see cref="KubernetesProxySettings.Address"/></li>
        ///     <li><c>--api-prefix</c> via <see cref="KubernetesProxySettings.ApiPrefix"/></li>
        ///     <li><c>--disable-filter</c> via <see cref="KubernetesProxySettings.DisableFilter"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesProxySettings.Port"/></li>
        ///     <li><c>--reject-methods</c> via <see cref="KubernetesProxySettings.RejectMethods"/></li>
        ///     <li><c>--reject-paths</c> via <see cref="KubernetesProxySettings.RejectPaths"/></li>
        ///     <li><c>--unix-socket</c> via <see cref="KubernetesProxySettings.UnixSocket"/></li>
        ///     <li><c>--www</c> via <see cref="KubernetesProxySettings.Www"/></li>
        ///     <li><c>--www-prefix</c> via <see cref="KubernetesProxySettings.WwwPrefix"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesProxySettings Settings, IReadOnlyCollection<Output> Output)> KubernetesProxy(CombinatorialConfigure<KubernetesProxySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesProxy, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>These commands correspond to alpha features that are not enabled in Kubernetes clusters by default.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAlpha(KubernetesAlphaSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesAlphaSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>These commands correspond to alpha features that are not enabled in Kubernetes clusters by default.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAlpha(Configure<KubernetesAlphaSettings> configurator)
        {
            return KubernetesAlpha(configurator(new KubernetesAlphaSettings()));
        }
        /// <summary>
        ///   <p>These commands correspond to alpha features that are not enabled in Kubernetes clusters by default.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesAlphaSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesAlpha(CombinatorialConfigure<KubernetesAlphaSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesAlpha, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>kubectl controls the Kubernetes cluster manager. Find more information at: https://kubernetes.io/docs/reference/kubectl/overview/.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> Kubernetes(KubernetesSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>kubectl controls the Kubernetes cluster manager. Find more information at: https://kubernetes.io/docs/reference/kubectl/overview/.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> Kubernetes(Configure<KubernetesSettings> configurator)
        {
            return Kubernetes(configurator(new KubernetesSettings()));
        }
        /// <summary>
        ///   <p>kubectl controls the Kubernetes cluster manager. Find more information at: https://kubernetes.io/docs/reference/kubectl/overview/.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesSettings Settings, IReadOnlyCollection<Output> Output)> Kubernetes(CombinatorialConfigure<KubernetesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(Kubernetes, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Output shell completion code for the specified shell (bash or zsh). The shell code must be evaluated to provide interactive completion of kubectl commands.  This can be done by sourcing it from the .bash _profile. Detailed instructions on how to do this are available here: https://kubernetes.io/docs/tasks/tools/install-kubectl/#enabling-shell-autocompletion Note for zsh users: [1] zsh completions are only supported in versions of zsh &gt;= 5.2.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCompletion(KubernetesCompletionSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesCompletionSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Output shell completion code for the specified shell (bash or zsh). The shell code must be evaluated to provide interactive completion of kubectl commands.  This can be done by sourcing it from the .bash _profile. Detailed instructions on how to do this are available here: https://kubernetes.io/docs/tasks/tools/install-kubectl/#enabling-shell-autocompletion Note for zsh users: [1] zsh completions are only supported in versions of zsh &gt;= 5.2.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCompletion(Configure<KubernetesCompletionSettings> configurator)
        {
            return KubernetesCompletion(configurator(new KubernetesCompletionSettings()));
        }
        /// <summary>
        ///   <p>Output shell completion code for the specified shell (bash or zsh). The shell code must be evaluated to provide interactive completion of kubectl commands.  This can be done by sourcing it from the .bash _profile. Detailed instructions on how to do this are available here: https://kubernetes.io/docs/tasks/tools/install-kubectl/#enabling-shell-autocompletion Note for zsh users: [1] zsh completions are only supported in versions of zsh &gt;= 5.2.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesCompletionSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesCompletion(CombinatorialConfigure<KubernetesCompletionSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesCompletion, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update field(s) of a resource using strategic merge patch, a JSON merge patch, or a JSON patch. JSON and YAML formats are accepted. Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPatchSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesPatchSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesPatchSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesPatchSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesPatchSettings.Output"/></li>
        ///     <li><c>--patch</c> via <see cref="KubernetesPatchSettings.Patch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesPatchSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesPatchSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesPatchSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesPatchSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPatch(KubernetesPatchSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesPatchSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update field(s) of a resource using strategic merge patch, a JSON merge patch, or a JSON patch. JSON and YAML formats are accepted. Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPatchSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesPatchSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesPatchSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesPatchSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesPatchSettings.Output"/></li>
        ///     <li><c>--patch</c> via <see cref="KubernetesPatchSettings.Patch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesPatchSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesPatchSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesPatchSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesPatchSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPatch(Configure<KubernetesPatchSettings> configurator)
        {
            return KubernetesPatch(configurator(new KubernetesPatchSettings()));
        }
        /// <summary>
        ///   <p>Update field(s) of a resource using strategic merge patch, a JSON merge patch, or a JSON patch. JSON and YAML formats are accepted. Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPatchSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesPatchSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesPatchSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesPatchSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesPatchSettings.Output"/></li>
        ///     <li><c>--patch</c> via <see cref="KubernetesPatchSettings.Patch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesPatchSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesPatchSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesPatchSettings.Template"/></li>
        ///     <li><c>--type</c> via <see cref="KubernetesPatchSettings.Type"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesPatchSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesPatch(CombinatorialConfigure<KubernetesPatchSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesPatch, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Replace a resource by filename or stdin. JSON and YAML formats are accepted. If replacing an existing resource, the complete resource spec must be provided. This can be obtained by   $ kubectl get TYPE NAME -o yaml  Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesReplaceSettings.Cascade"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesReplaceSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesReplaceSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesReplaceSettings.GracePeriod"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesReplaceSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesReplaceSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesReplaceSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesReplaceSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesReplaceSettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesReplaceSettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesReplaceSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesReplace(KubernetesReplaceSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesReplaceSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Replace a resource by filename or stdin. JSON and YAML formats are accepted. If replacing an existing resource, the complete resource spec must be provided. This can be obtained by   $ kubectl get TYPE NAME -o yaml  Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesReplaceSettings.Cascade"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesReplaceSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesReplaceSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesReplaceSettings.GracePeriod"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesReplaceSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesReplaceSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesReplaceSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesReplaceSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesReplaceSettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesReplaceSettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesReplaceSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesReplace(Configure<KubernetesReplaceSettings> configurator)
        {
            return KubernetesReplace(configurator(new KubernetesReplaceSettings()));
        }
        /// <summary>
        ///   <p>Replace a resource by filename or stdin. JSON and YAML formats are accepted. If replacing an existing resource, the complete resource spec must be provided. This can be obtained by   $ kubectl get TYPE NAME -o yaml  Please refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesReplaceSettings.Cascade"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesReplaceSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesReplaceSettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesReplaceSettings.GracePeriod"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesReplaceSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesReplaceSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesReplaceSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesReplaceSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesReplaceSettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesReplaceSettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesReplaceSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesReplaceSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesReplace(CombinatorialConfigure<KubernetesReplaceSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesReplace, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Update the taints on one or more nodes.   * A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.    * The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  253 characters.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters.    * The effect must be NoSchedule, PreferNoSchedule or NoExecute.    * Currently taint can only apply to node.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;taintEffects&gt;</c> via <see cref="KubernetesTaintSettings.TaintEffects"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesTaintSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesTaintSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesTaintSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesTaintSettings.Overwrite"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesTaintSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesTaintSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesTaintSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesTaint(KubernetesTaintSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesTaintSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Update the taints on one or more nodes.   * A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.    * The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  253 characters.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters.    * The effect must be NoSchedule, PreferNoSchedule or NoExecute.    * Currently taint can only apply to node.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;taintEffects&gt;</c> via <see cref="KubernetesTaintSettings.TaintEffects"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesTaintSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesTaintSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesTaintSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesTaintSettings.Overwrite"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesTaintSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesTaintSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesTaintSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesTaint(Configure<KubernetesTaintSettings> configurator)
        {
            return KubernetesTaint(configurator(new KubernetesTaintSettings()));
        }
        /// <summary>
        ///   <p>Update the taints on one or more nodes.   * A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.    * The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  253 characters.    * Optionally, the key can begin with a DNS subdomain prefix and a single '/', like example.com/my-app    * The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to  63 characters.    * The effect must be NoSchedule, PreferNoSchedule or NoExecute.    * Currently taint can only apply to node.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;taintEffects&gt;</c> via <see cref="KubernetesTaintSettings.TaintEffects"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesTaintSettings.TypeName"/></li>
        ///     <li><c>--all</c> via <see cref="KubernetesTaintSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesTaintSettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesTaintSettings.Overwrite"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesTaintSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesTaintSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesTaintSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesTaintSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesTaint(CombinatorialConfigure<KubernetesTaintSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesTaint, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Show details of a specific resource or group of resources Print a detailed description of the selected resources, including related resources such as events or controllers. You may select a single object by name, all objects of that type, provide a name prefix, or label selector. For example:   $ kubectl describe TYPE NAME_PREFIX  will first check for an exact match on TYPE and NAME PREFIX. If no such resource exists, it will output details for every resource that has a name prefixed with NAME PREFIX.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesDescribeSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesDescribeSettings.AllNamespaces"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDescribeSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDescribeSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDescribeSettings.Selector"/></li>
        ///     <li><c>--show-events</c> via <see cref="KubernetesDescribeSettings.ShowEvents"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDescribe(KubernetesDescribeSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesDescribeSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Show details of a specific resource or group of resources Print a detailed description of the selected resources, including related resources such as events or controllers. You may select a single object by name, all objects of that type, provide a name prefix, or label selector. For example:   $ kubectl describe TYPE NAME_PREFIX  will first check for an exact match on TYPE and NAME PREFIX. If no such resource exists, it will output details for every resource that has a name prefixed with NAME PREFIX.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesDescribeSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesDescribeSettings.AllNamespaces"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDescribeSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDescribeSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDescribeSettings.Selector"/></li>
        ///     <li><c>--show-events</c> via <see cref="KubernetesDescribeSettings.ShowEvents"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesDescribe(Configure<KubernetesDescribeSettings> configurator)
        {
            return KubernetesDescribe(configurator(new KubernetesDescribeSettings()));
        }
        /// <summary>
        ///   <p>Show details of a specific resource or group of resources Print a detailed description of the selected resources, including related resources such as events or controllers. You may select a single object by name, all objects of that type, provide a name prefix, or label selector. For example:   $ kubectl describe TYPE NAME_PREFIX  will first check for an exact match on TYPE and NAME PREFIX. If no such resource exists, it will output details for every resource that has a name prefixed with NAME PREFIX.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesDescribeSettings.TypeName"/></li>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesDescribeSettings.AllNamespaces"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesDescribeSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesDescribeSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesDescribeSettings.Selector"/></li>
        ///     <li><c>--show-events</c> via <see cref="KubernetesDescribeSettings.ShowEvents"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesDescribeSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesDescribe(CombinatorialConfigure<KubernetesDescribeSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesDescribe, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Configure application resources These commands help you make changes to existing application resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesSetSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesSet(KubernetesSetSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesSetSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Configure application resources These commands help you make changes to existing application resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesSetSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesSet(Configure<KubernetesSetSettings> configurator)
        {
            return KubernetesSet(configurator(new KubernetesSetSettings()));
        }
        /// <summary>
        ///   <p>Configure application resources These commands help you make changes to existing application resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesSetSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesSetSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesSet(CombinatorialConfigure<KubernetesSetSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesSet, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Inspect authorization.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesAuthSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAuth(KubernetesAuthSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesAuthSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Inspect authorization.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesAuthSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAuth(Configure<KubernetesAuthSettings> configurator)
        {
            return KubernetesAuth(configurator(new KubernetesAuthSettings()));
        }
        /// <summary>
        ///   <p>Inspect authorization.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesAuthSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesAuthSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesAuth(CombinatorialConfigure<KubernetesAuthSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesAuth, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Modify certificate resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesCertificateSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCertificate(KubernetesCertificateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesCertificateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Modify certificate resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesCertificateSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCertificate(Configure<KubernetesCertificateSettings> configurator)
        {
            return KubernetesCertificate(configurator(new KubernetesCertificateSettings()));
        }
        /// <summary>
        ///   <p>Modify certificate resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesCertificateSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesCertificateSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesCertificate(CombinatorialConfigure<KubernetesCertificateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesCertificate, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Manage the rollout of a resource.  Valid resource types include:   * deployments    * daemonsets    * statefulsets.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesRolloutSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRollout(KubernetesRolloutSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesRolloutSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Manage the rollout of a resource.  Valid resource types include:   * deployments    * daemonsets    * statefulsets.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesRolloutSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRollout(Configure<KubernetesRolloutSettings> configurator)
        {
            return KubernetesRollout(configurator(new KubernetesRolloutSettings()));
        }
        /// <summary>
        ///   <p>Manage the rollout of a resource.  Valid resource types include:   * deployments    * daemonsets    * statefulsets.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;subcommand&gt;</c> via <see cref="KubernetesRolloutSettings.Subcommand"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesRolloutSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesRollout(CombinatorialConfigure<KubernetesRolloutSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesRollout, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Apply a configuration to a resource by filename or stdin. The resource name must be specified. This resource will be created if it doesn't exist yet. To use 'apply', always create the resource initially with either 'apply' or 'create --save-config'. JSON and YAML formats are accepted. Alpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesApplySettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesApplySettings.Cascade"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesApplySettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesApplySettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesApplySettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesApplySettings.GracePeriod"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesApplySettings.IncludeUninitialized"/></li>
        ///     <li><c>--openapi-patch</c> via <see cref="KubernetesApplySettings.OpenapiPatch"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApplySettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesApplySettings.Overwrite"/></li>
        ///     <li><c>--prune</c> via <see cref="KubernetesApplySettings.Prune"/></li>
        ///     <li><c>--prune-whitelist</c> via <see cref="KubernetesApplySettings.PruneWhitelist"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesApplySettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesApplySettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesApplySettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesApplySettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesApplySettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesApplySettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesApplySettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApply(KubernetesApplySettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesApplySettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Apply a configuration to a resource by filename or stdin. The resource name must be specified. This resource will be created if it doesn't exist yet. To use 'apply', always create the resource initially with either 'apply' or 'create --save-config'. JSON and YAML formats are accepted. Alpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesApplySettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesApplySettings.Cascade"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesApplySettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesApplySettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesApplySettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesApplySettings.GracePeriod"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesApplySettings.IncludeUninitialized"/></li>
        ///     <li><c>--openapi-patch</c> via <see cref="KubernetesApplySettings.OpenapiPatch"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApplySettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesApplySettings.Overwrite"/></li>
        ///     <li><c>--prune</c> via <see cref="KubernetesApplySettings.Prune"/></li>
        ///     <li><c>--prune-whitelist</c> via <see cref="KubernetesApplySettings.PruneWhitelist"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesApplySettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesApplySettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesApplySettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesApplySettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesApplySettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesApplySettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesApplySettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApply(Configure<KubernetesApplySettings> configurator)
        {
            return KubernetesApply(configurator(new KubernetesApplySettings()));
        }
        /// <summary>
        ///   <p>Apply a configuration to a resource by filename or stdin. The resource name must be specified. This resource will be created if it doesn't exist yet. To use 'apply', always create the resource initially with either 'apply' or 'create --save-config'. JSON and YAML formats are accepted. Alpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesApplySettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesApplySettings.Cascade"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesApplySettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesApplySettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesApplySettings.Force"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesApplySettings.GracePeriod"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesApplySettings.IncludeUninitialized"/></li>
        ///     <li><c>--openapi-patch</c> via <see cref="KubernetesApplySettings.OpenapiPatch"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesApplySettings.Output"/></li>
        ///     <li><c>--overwrite</c> via <see cref="KubernetesApplySettings.Overwrite"/></li>
        ///     <li><c>--prune</c> via <see cref="KubernetesApplySettings.Prune"/></li>
        ///     <li><c>--prune-whitelist</c> via <see cref="KubernetesApplySettings.PruneWhitelist"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesApplySettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesApplySettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesApplySettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesApplySettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesApplySettings.Timeout"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesApplySettings.Validate"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesApplySettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesApplySettings Settings, IReadOnlyCollection<Output> Output)> KubernetesApply(CombinatorialConfigure<KubernetesApplySettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesApply, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Mark node as unschedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesCordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCordon(KubernetesCordonSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesCordonSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Mark node as unschedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesCordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCordon(Configure<KubernetesCordonSettings> configurator)
        {
            return KubernetesCordon(configurator(new KubernetesCordonSettings()));
        }
        /// <summary>
        ///   <p>Mark node as unschedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesCordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesCordonSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesCordon(CombinatorialConfigure<KubernetesCordonSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesCordon, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Copy files and directories to and from containers.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;destFileSpec&gt;</c> via <see cref="KubernetesCpSettings.DestFileSpec"/></li>
        ///     <li><c>&lt;srcFileSpec&gt;</c> via <see cref="KubernetesCpSettings.SrcFileSpec"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesCpSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCp(KubernetesCpSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesCpSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Copy files and directories to and from containers.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;destFileSpec&gt;</c> via <see cref="KubernetesCpSettings.DestFileSpec"/></li>
        ///     <li><c>&lt;srcFileSpec&gt;</c> via <see cref="KubernetesCpSettings.SrcFileSpec"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesCpSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCp(Configure<KubernetesCpSettings> configurator)
        {
            return KubernetesCp(configurator(new KubernetesCpSettings()));
        }
        /// <summary>
        ///   <p>Copy files and directories to and from containers.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;destFileSpec&gt;</c> via <see cref="KubernetesCpSettings.DestFileSpec"/></li>
        ///     <li><c>&lt;srcFileSpec&gt;</c> via <see cref="KubernetesCpSettings.SrcFileSpec"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesCpSettings.Container"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesCpSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesCp(CombinatorialConfigure<KubernetesCpSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesCp, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Print the supported API versions on the server, in the form of "group/version".</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApiVersions(KubernetesApiVersionsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesApiVersionsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the supported API versions on the server, in the form of "group/version".</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesApiVersions(Configure<KubernetesApiVersionsSettings> configurator)
        {
            return KubernetesApiVersions(configurator(new KubernetesApiVersionsSettings()));
        }
        /// <summary>
        ///   <p>Print the supported API versions on the server, in the form of "group/version".</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesApiVersionsSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesApiVersions(CombinatorialConfigure<KubernetesApiVersionsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesApiVersions, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Mark node as schedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesUncordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesUncordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesUncordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesUncordon(KubernetesUncordonSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesUncordonSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Mark node as schedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesUncordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesUncordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesUncordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesUncordon(Configure<KubernetesUncordonSettings> configurator)
        {
            return KubernetesUncordon(configurator(new KubernetesUncordonSettings()));
        }
        /// <summary>
        ///   <p>Mark node as schedulable.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;node&gt;</c> via <see cref="KubernetesUncordonSettings.Node"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesUncordonSettings.DryRun"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesUncordonSettings.Selector"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesUncordonSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesUncordon(CombinatorialConfigure<KubernetesUncordonSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesUncordon, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Creates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster. Looks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference. An autoscaler can automatically increase or decrease number of pods deployed within the system as needed.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="KubernetesAutoscaleSettings.CpuPercent"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAutoscaleSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAutoscaleSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesAutoscaleSettings.Generator"/></li>
        ///     <li><c>--max</c> via <see cref="KubernetesAutoscaleSettings.Max"/></li>
        ///     <li><c>--min</c> via <see cref="KubernetesAutoscaleSettings.Min"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesAutoscaleSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAutoscaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAutoscaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAutoscaleSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesAutoscaleSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAutoscaleSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAutoscale(KubernetesAutoscaleSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesAutoscaleSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Creates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster. Looks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference. An autoscaler can automatically increase or decrease number of pods deployed within the system as needed.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="KubernetesAutoscaleSettings.CpuPercent"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAutoscaleSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAutoscaleSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesAutoscaleSettings.Generator"/></li>
        ///     <li><c>--max</c> via <see cref="KubernetesAutoscaleSettings.Max"/></li>
        ///     <li><c>--min</c> via <see cref="KubernetesAutoscaleSettings.Min"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesAutoscaleSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAutoscaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAutoscaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAutoscaleSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesAutoscaleSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAutoscaleSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesAutoscale(Configure<KubernetesAutoscaleSettings> configurator)
        {
            return KubernetesAutoscale(configurator(new KubernetesAutoscaleSettings()));
        }
        /// <summary>
        ///   <p>Creates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster. Looks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference. An autoscaler can automatically increase or decrease number of pods deployed within the system as needed.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--cpu-percent</c> via <see cref="KubernetesAutoscaleSettings.CpuPercent"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesAutoscaleSettings.DryRun"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesAutoscaleSettings.Filename"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesAutoscaleSettings.Generator"/></li>
        ///     <li><c>--max</c> via <see cref="KubernetesAutoscaleSettings.Max"/></li>
        ///     <li><c>--min</c> via <see cref="KubernetesAutoscaleSettings.Min"/></li>
        ///     <li><c>--name</c> via <see cref="KubernetesAutoscaleSettings.Name"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesAutoscaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesAutoscaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesAutoscaleSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesAutoscaleSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesAutoscaleSettings.Template"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesAutoscaleSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesAutoscale(CombinatorialConfigure<KubernetesAutoscaleSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesAutoscale, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Runs a command-line plugin. Plugins are subcommands that are not part of the major command-line distribution and can even be provided by third-parties. Please refer to the documentation and examples for more information about how to install and write your own plugins.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesPluginSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPlugin(KubernetesPluginSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesPluginSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Runs a command-line plugin. Plugins are subcommands that are not part of the major command-line distribution and can even be provided by third-parties. Please refer to the documentation and examples for more information about how to install and write your own plugins.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesPluginSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPlugin(Configure<KubernetesPluginSettings> configurator)
        {
            return KubernetesPlugin(configurator(new KubernetesPluginSettings()));
        }
        /// <summary>
        ///   <p>Runs a command-line plugin. Plugins are subcommands that are not part of the major command-line distribution and can even be provided by third-parties. Please refer to the documentation and examples for more information about how to install and write your own plugins.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;name&gt;</c> via <see cref="KubernetesPluginSettings.Name"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesPluginSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesPlugin(CombinatorialConfigure<KubernetesPluginSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesPlugin, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Display addresses of the master and services with label kubernetes.io/cluster-service=true To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesClusterInfo(KubernetesClusterInfoSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesClusterInfoSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Display addresses of the master and services with label kubernetes.io/cluster-service=true To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesClusterInfo(Configure<KubernetesClusterInfoSettings> configurator)
        {
            return KubernetesClusterInfo(configurator(new KubernetesClusterInfoSettings()));
        }
        /// <summary>
        ///   <p>Display addresses of the master and services with label kubernetes.io/cluster-service=true To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        /// </remarks>
        public static IEnumerable<(KubernetesClusterInfoSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesClusterInfo(CombinatorialConfigure<KubernetesClusterInfoSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesClusterInfo, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesWaitSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesWaitSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesWaitSettings.Filename"/></li>
        ///     <li><c>--for</c> via <see cref="KubernetesWaitSettings.For"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesWaitSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesWaitSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesWaitSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesWaitSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesWaitSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesWait(KubernetesWaitSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesWaitSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesWaitSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesWaitSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesWaitSettings.Filename"/></li>
        ///     <li><c>--for</c> via <see cref="KubernetesWaitSettings.For"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesWaitSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesWaitSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesWaitSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesWaitSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesWaitSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesWait(Configure<KubernetesWaitSettings> configurator)
        {
            return KubernetesWait(configurator(new KubernetesWaitSettings()));
        }
        /// <summary>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all-namespaces</c> via <see cref="KubernetesWaitSettings.AllNamespaces"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesWaitSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesWaitSettings.Filename"/></li>
        ///     <li><c>--for</c> via <see cref="KubernetesWaitSettings.For"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesWaitSettings.Output"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesWaitSettings.Recursive"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesWaitSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesWaitSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesWaitSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesWaitSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesWait(CombinatorialConfigure<KubernetesWaitSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesWait, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Convert config files between different API versions. Both YAML and JSON formats are accepted. The command takes filename, directory, or URL as input, and convert it into format of version specified by --output-version flag. If target version is not specified or not supported, convert to latest version. The default output will be printed to stdout in YAML format. One can use -o option to change to output destination.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesConvertSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesConvertSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesConvertSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesConvertSettings.Output"/></li>
        ///     <li><c>--output-version</c> via <see cref="KubernetesConvertSettings.OutputVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesConvertSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesConvertSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesConvertSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesConvert(KubernetesConvertSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesConvertSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Convert config files between different API versions. Both YAML and JSON formats are accepted. The command takes filename, directory, or URL as input, and convert it into format of version specified by --output-version flag. If target version is not specified or not supported, convert to latest version. The default output will be printed to stdout in YAML format. One can use -o option to change to output destination.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesConvertSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesConvertSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesConvertSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesConvertSettings.Output"/></li>
        ///     <li><c>--output-version</c> via <see cref="KubernetesConvertSettings.OutputVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesConvertSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesConvertSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesConvertSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesConvert(Configure<KubernetesConvertSettings> configurator)
        {
            return KubernetesConvert(configurator(new KubernetesConvertSettings()));
        }
        /// <summary>
        ///   <p>Convert config files between different API versions. Both YAML and JSON formats are accepted. The command takes filename, directory, or URL as input, and convert it into format of version specified by --output-version flag. If target version is not specified or not supported, convert to latest version. The default output will be printed to stdout in YAML format. One can use -o option to change to output destination.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesConvertSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesConvertSettings.Filename"/></li>
        ///     <li><c>--local</c> via <see cref="KubernetesConvertSettings.Local"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesConvertSettings.Output"/></li>
        ///     <li><c>--output-version</c> via <see cref="KubernetesConvertSettings.OutputVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesConvertSettings.Recursive"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesConvertSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesConvertSettings.Validate"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesConvertSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesConvert(CombinatorialConfigure<KubernetesConvertSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesConvert, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create a resource from a file or from stdin. JSON and YAML formats are accepted.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesCreateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCreateSettings.DryRun"/></li>
        ///     <li><c>--edit</c> via <see cref="KubernetesCreateSettings.Edit"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesCreateSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesCreateSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesCreateSettings.Raw"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesCreateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesCreateSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesCreateSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCreateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesCreateSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesCreateSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesCreateSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCreate(KubernetesCreateSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesCreateSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create a resource from a file or from stdin. JSON and YAML formats are accepted.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesCreateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCreateSettings.DryRun"/></li>
        ///     <li><c>--edit</c> via <see cref="KubernetesCreateSettings.Edit"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesCreateSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesCreateSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesCreateSettings.Raw"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesCreateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesCreateSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesCreateSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCreateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesCreateSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesCreateSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesCreateSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesCreate(Configure<KubernetesCreateSettings> configurator)
        {
            return KubernetesCreate(configurator(new KubernetesCreateSettings()));
        }
        /// <summary>
        ///   <p>Create a resource from a file or from stdin. JSON and YAML formats are accepted.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesCreateSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesCreateSettings.DryRun"/></li>
        ///     <li><c>--edit</c> via <see cref="KubernetesCreateSettings.Edit"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesCreateSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesCreateSettings.Output"/></li>
        ///     <li><c>--raw</c> via <see cref="KubernetesCreateSettings.Raw"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesCreateSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesCreateSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesCreateSettings.SaveConfig"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesCreateSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesCreateSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesCreateSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesCreateSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesCreateSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesCreate(CombinatorialConfigure<KubernetesCreateSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesCreate, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Forward one or more local ports to a pod. Use resource type/name such as deployment/mydeployment to select a pod. Resource type defaults to 'pod' if omitted. If there are multiple pods matching the criteria, a pod will be selected automatically. The forwarding session ends when the selected pod terminates, and rerun of the command is needed to resume forwarding.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;ports&gt;</c> via <see cref="KubernetesPortForwardSettings.Ports"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPortForwardSettings.TypeName"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesPortForwardSettings.PodRunningTimeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPortForward(KubernetesPortForwardSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesPortForwardSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Forward one or more local ports to a pod. Use resource type/name such as deployment/mydeployment to select a pod. Resource type defaults to 'pod' if omitted. If there are multiple pods matching the criteria, a pod will be selected automatically. The forwarding session ends when the selected pod terminates, and rerun of the command is needed to resume forwarding.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;ports&gt;</c> via <see cref="KubernetesPortForwardSettings.Ports"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPortForwardSettings.TypeName"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesPortForwardSettings.PodRunningTimeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesPortForward(Configure<KubernetesPortForwardSettings> configurator)
        {
            return KubernetesPortForward(configurator(new KubernetesPortForwardSettings()));
        }
        /// <summary>
        ///   <p>Forward one or more local ports to a pod. Use resource type/name such as deployment/mydeployment to select a pod. Resource type defaults to 'pod' if omitted. If there are multiple pods matching the criteria, a pod will be selected automatically. The forwarding session ends when the selected pod terminates, and rerun of the command is needed to resume forwarding.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;ports&gt;</c> via <see cref="KubernetesPortForwardSettings.Ports"/></li>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesPortForwardSettings.TypeName"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesPortForwardSettings.PodRunningTimeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesPortForwardSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesPortForward(CombinatorialConfigure<KubernetesPortForwardSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesPortForward, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunContainerSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunContainerSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunContainerSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunContainerSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunContainerSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunContainerSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunContainerSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunContainerSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunContainerSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunContainerSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunContainerSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunContainerSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunContainerSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunContainerSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunContainerSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunContainerSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunContainerSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunContainerSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunContainerSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunContainerSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunContainerSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunContainerSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunContainerSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunContainerSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunContainerSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunContainerSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunContainerSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunContainerSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunContainerSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunContainerSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunContainerSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunContainerSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunContainerSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunContainerSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunContainerSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunContainerSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunContainerSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunContainerSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRunContainer(KubernetesRunContainerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesRunContainerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunContainerSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunContainerSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunContainerSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunContainerSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunContainerSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunContainerSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunContainerSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunContainerSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunContainerSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunContainerSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunContainerSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunContainerSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunContainerSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunContainerSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunContainerSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunContainerSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunContainerSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunContainerSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunContainerSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunContainerSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunContainerSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunContainerSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunContainerSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunContainerSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunContainerSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunContainerSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunContainerSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunContainerSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunContainerSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunContainerSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunContainerSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunContainerSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunContainerSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunContainerSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunContainerSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunContainerSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunContainerSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunContainerSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesRunContainer(Configure<KubernetesRunContainerSettings> configurator)
        {
            return KubernetesRunContainer(configurator(new KubernetesRunContainerSettings()));
        }
        /// <summary>
        ///   <p>Create and run a particular image, possibly replicated. Creates a deployment or job to manage the created container(s).</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesRunContainerSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--attach</c> via <see cref="KubernetesRunContainerSettings.Attach"/></li>
        ///     <li><c>--cascade</c> via <see cref="KubernetesRunContainerSettings.Cascade"/></li>
        ///     <li><c>--command</c> via <see cref="KubernetesRunContainerSettings.Command"/></li>
        ///     <li><c>--dry-run</c> via <see cref="KubernetesRunContainerSettings.DryRun"/></li>
        ///     <li><c>--env</c> via <see cref="KubernetesRunContainerSettings.Env"/></li>
        ///     <li><c>--expose</c> via <see cref="KubernetesRunContainerSettings.Expose"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesRunContainerSettings.Filename"/></li>
        ///     <li><c>--force</c> via <see cref="KubernetesRunContainerSettings.Force"/></li>
        ///     <li><c>--generator</c> via <see cref="KubernetesRunContainerSettings.Generator"/></li>
        ///     <li><c>--grace-period</c> via <see cref="KubernetesRunContainerSettings.GracePeriod"/></li>
        ///     <li><c>--hostport</c> via <see cref="KubernetesRunContainerSettings.Hostport"/></li>
        ///     <li><c>--image</c> via <see cref="KubernetesRunContainerSettings.Image"/></li>
        ///     <li><c>--image-pull-policy</c> via <see cref="KubernetesRunContainerSettings.ImagePullPolicy"/></li>
        ///     <li><c>--labels</c> via <see cref="KubernetesRunContainerSettings.Labels"/></li>
        ///     <li><c>--leave-stdin-open</c> via <see cref="KubernetesRunContainerSettings.LeaveStdinOpen"/></li>
        ///     <li><c>--limits</c> via <see cref="KubernetesRunContainerSettings.Limits"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesRunContainerSettings.Output"/></li>
        ///     <li><c>--overrides</c> via <see cref="KubernetesRunContainerSettings.Overrides"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesRunContainerSettings.PodRunningTimeout"/></li>
        ///     <li><c>--port</c> via <see cref="KubernetesRunContainerSettings.Port"/></li>
        ///     <li><c>--quiet</c> via <see cref="KubernetesRunContainerSettings.Quiet"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesRunContainerSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesRunContainerSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesRunContainerSettings.Replicas"/></li>
        ///     <li><c>--requests</c> via <see cref="KubernetesRunContainerSettings.Requests"/></li>
        ///     <li><c>--restart</c> via <see cref="KubernetesRunContainerSettings.Restart"/></li>
        ///     <li><c>--rm</c> via <see cref="KubernetesRunContainerSettings.Rm"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesRunContainerSettings.SaveConfig"/></li>
        ///     <li><c>--schedule</c> via <see cref="KubernetesRunContainerSettings.Schedule"/></li>
        ///     <li><c>--service-generator</c> via <see cref="KubernetesRunContainerSettings.ServiceGenerator"/></li>
        ///     <li><c>--service-overrides</c> via <see cref="KubernetesRunContainerSettings.ServiceOverrides"/></li>
        ///     <li><c>--serviceaccount</c> via <see cref="KubernetesRunContainerSettings.Serviceaccount"/></li>
        ///     <li><c>--stdin</c> via <see cref="KubernetesRunContainerSettings.Stdin"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesRunContainerSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesRunContainerSettings.Timeout"/></li>
        ///     <li><c>--tty</c> via <see cref="KubernetesRunContainerSettings.Tty"/></li>
        ///     <li><c>--wait</c> via <see cref="KubernetesRunContainerSettings.Wait"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesRunContainerSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesRunContainer(CombinatorialConfigure<KubernetesRunContainerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesRunContainer, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Edit a resource from the default editor. The edit command allows you to directly edit any API resource you can retrieve via the command line tools. It will open the editor defined by your KUBE _EDITOR, or EDITOR environment variables, or fall back to 'vi' for Linux or 'notepad' for Windows. You can edit multiple objects, although changes are applied one at a time. The command accepts filenames as well as command line arguments, although the files you point to must be previously saved versions of resources. Editing is done with the API version used to fetch the resource. To edit using a specific API version, fully-qualify the resource, version, and group. The default format is YAML. To edit in JSON, specify "-o json". The flag --windows-line-endings can be used to force Windows line endings, otherwise the default for your operating system will be used. In the event an error occurs while updating, a temporary file will be created on disk that contains your unapplied changes. The most common error when updating a resource is another editor changing the resource on the server. When this occurs, you will have to apply your changes to the newer version of the resource, or update your temporary saved copy to include the latest resource version.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesEditSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesEditSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesEditSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesEditSettings.IncludeUninitialized"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesEditSettings.Output"/></li>
        ///     <li><c>--output-patch</c> via <see cref="KubernetesEditSettings.OutputPatch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesEditSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesEditSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesEditSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesEditSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesEditSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesEditSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesEdit(KubernetesEditSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesEditSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Edit a resource from the default editor. The edit command allows you to directly edit any API resource you can retrieve via the command line tools. It will open the editor defined by your KUBE _EDITOR, or EDITOR environment variables, or fall back to 'vi' for Linux or 'notepad' for Windows. You can edit multiple objects, although changes are applied one at a time. The command accepts filenames as well as command line arguments, although the files you point to must be previously saved versions of resources. Editing is done with the API version used to fetch the resource. To edit using a specific API version, fully-qualify the resource, version, and group. The default format is YAML. To edit in JSON, specify "-o json". The flag --windows-line-endings can be used to force Windows line endings, otherwise the default for your operating system will be used. In the event an error occurs while updating, a temporary file will be created on disk that contains your unapplied changes. The most common error when updating a resource is another editor changing the resource on the server. When this occurs, you will have to apply your changes to the newer version of the resource, or update your temporary saved copy to include the latest resource version.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesEditSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesEditSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesEditSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesEditSettings.IncludeUninitialized"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesEditSettings.Output"/></li>
        ///     <li><c>--output-patch</c> via <see cref="KubernetesEditSettings.OutputPatch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesEditSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesEditSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesEditSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesEditSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesEditSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesEditSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesEdit(Configure<KubernetesEditSettings> configurator)
        {
            return KubernetesEdit(configurator(new KubernetesEditSettings()));
        }
        /// <summary>
        ///   <p>Edit a resource from the default editor. The edit command allows you to directly edit any API resource you can retrieve via the command line tools. It will open the editor defined by your KUBE _EDITOR, or EDITOR environment variables, or fall back to 'vi' for Linux or 'notepad' for Windows. You can edit multiple objects, although changes are applied one at a time. The command accepts filenames as well as command line arguments, although the files you point to must be previously saved versions of resources. Editing is done with the API version used to fetch the resource. To edit using a specific API version, fully-qualify the resource, version, and group. The default format is YAML. To edit in JSON, specify "-o json". The flag --windows-line-endings can be used to force Windows line endings, otherwise the default for your operating system will be used. In the event an error occurs while updating, a temporary file will be created on disk that contains your unapplied changes. The most common error when updating a resource is another editor changing the resource on the server. When this occurs, you will have to apply your changes to the newer version of the resource, or update your temporary saved copy to include the latest resource version.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesEditSettings.TypeName"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesEditSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesEditSettings.Filename"/></li>
        ///     <li><c>--include-uninitialized</c> via <see cref="KubernetesEditSettings.IncludeUninitialized"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesEditSettings.Output"/></li>
        ///     <li><c>--output-patch</c> via <see cref="KubernetesEditSettings.OutputPatch"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesEditSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesEditSettings.Recursive"/></li>
        ///     <li><c>--save-config</c> via <see cref="KubernetesEditSettings.SaveConfig"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesEditSettings.Template"/></li>
        ///     <li><c>--validate</c> via <see cref="KubernetesEditSettings.Validate"/></li>
        ///     <li><c>--windows-line-endings</c> via <see cref="KubernetesEditSettings.WindowsLineEndings"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesEditSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesEdit(CombinatorialConfigure<KubernetesEditSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesEdit, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Set a new size for a Deployment, ReplicaSet, Replication Controller, or StatefulSet. Scale also allows users to specify one or more preconditions for the scale action. If --current-replicas or --resource-version is specified, it is validated before the scale is attempted, and it is guaranteed that the precondition holds true when the scale is sent to the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesScaleSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesScaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--current-replicas</c> via <see cref="KubernetesScaleSettings.CurrentReplicas"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesScaleSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesScaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesScaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesScaleSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesScaleSettings.Replicas"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesScaleSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesScaleSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesScaleSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesScaleSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesScale(KubernetesScaleSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesScaleSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Set a new size for a Deployment, ReplicaSet, Replication Controller, or StatefulSet. Scale also allows users to specify one or more preconditions for the scale action. If --current-replicas or --resource-version is specified, it is validated before the scale is attempted, and it is guaranteed that the precondition holds true when the scale is sent to the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesScaleSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesScaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--current-replicas</c> via <see cref="KubernetesScaleSettings.CurrentReplicas"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesScaleSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesScaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesScaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesScaleSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesScaleSettings.Replicas"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesScaleSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesScaleSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesScaleSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesScaleSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesScale(Configure<KubernetesScaleSettings> configurator)
        {
            return KubernetesScale(configurator(new KubernetesScaleSettings()));
        }
        /// <summary>
        ///   <p>Set a new size for a Deployment, ReplicaSet, Replication Controller, or StatefulSet. Scale also allows users to specify one or more preconditions for the scale action. If --current-replicas or --resource-version is specified, it is validated before the scale is attempted, and it is guaranteed that the precondition holds true when the scale is sent to the server.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>--all</c> via <see cref="KubernetesScaleSettings.All"/></li>
        ///     <li><c>--allow-missing-template-keys</c> via <see cref="KubernetesScaleSettings.AllowMissingTemplateKeys"/></li>
        ///     <li><c>--current-replicas</c> via <see cref="KubernetesScaleSettings.CurrentReplicas"/></li>
        ///     <li><c>--filename</c> via <see cref="KubernetesScaleSettings.Filename"/></li>
        ///     <li><c>--output</c> via <see cref="KubernetesScaleSettings.Output"/></li>
        ///     <li><c>--record</c> via <see cref="KubernetesScaleSettings.Record"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesScaleSettings.Recursive"/></li>
        ///     <li><c>--replicas</c> via <see cref="KubernetesScaleSettings.Replicas"/></li>
        ///     <li><c>--resource-version</c> via <see cref="KubernetesScaleSettings.ResourceVersion"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesScaleSettings.Selector"/></li>
        ///     <li><c>--template</c> via <see cref="KubernetesScaleSettings.Template"/></li>
        ///     <li><c>--timeout</c> via <see cref="KubernetesScaleSettings.Timeout"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesScaleSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesScale(CombinatorialConfigure<KubernetesScaleSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesScale, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List the fields for supported resources This command describes the fields associated with each supported API resource. Fields are identified via a simple JSONPath identifier:   &lt;type&gt;.&lt;fieldName&gt;[.&lt;fieldName&gt;]  Add the --recursive flag to display all of the fields at once without descriptions. Information about each field is retrieved from the server in OpenAPI format.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;resource&gt;</c> via <see cref="KubernetesExplainSettings.Resource"/></li>
        ///     <li><c>--api-version</c> via <see cref="KubernetesExplainSettings.ApiVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExplainSettings.Recursive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExplain(KubernetesExplainSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesExplainSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List the fields for supported resources This command describes the fields associated with each supported API resource. Fields are identified via a simple JSONPath identifier:   &lt;type&gt;.&lt;fieldName&gt;[.&lt;fieldName&gt;]  Add the --recursive flag to display all of the fields at once without descriptions. Information about each field is retrieved from the server in OpenAPI format.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;resource&gt;</c> via <see cref="KubernetesExplainSettings.Resource"/></li>
        ///     <li><c>--api-version</c> via <see cref="KubernetesExplainSettings.ApiVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExplainSettings.Recursive"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesExplain(Configure<KubernetesExplainSettings> configurator)
        {
            return KubernetesExplain(configurator(new KubernetesExplainSettings()));
        }
        /// <summary>
        ///   <p>List the fields for supported resources This command describes the fields associated with each supported API resource. Fields are identified via a simple JSONPath identifier:   &lt;type&gt;.&lt;fieldName&gt;[.&lt;fieldName&gt;]  Add the --recursive flag to display all of the fields at once without descriptions. Information about each field is retrieved from the server in OpenAPI format.Use "kubectl api-resources" for a complete list of supported resources.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;resource&gt;</c> via <see cref="KubernetesExplainSettings.Resource"/></li>
        ///     <li><c>--api-version</c> via <see cref="KubernetesExplainSettings.ApiVersion"/></li>
        ///     <li><c>--recursive</c> via <see cref="KubernetesExplainSettings.Recursive"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesExplainSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesExplain(CombinatorialConfigure<KubernetesExplainSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesExplain, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Print the logs for a container in a pod or specified resource. If the pod has only one container, the container name is optional.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLogsSettings.TypeName"/></li>
        ///     <li><c>--all-containers</c> via <see cref="KubernetesLogsSettings.AllContainers"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesLogsSettings.Container"/></li>
        ///     <li><c>--follow</c> via <see cref="KubernetesLogsSettings.Follow"/></li>
        ///     <li><c>--interactive</c> via <see cref="KubernetesLogsSettings.Interactive"/></li>
        ///     <li><c>--limit-bytes</c> via <see cref="KubernetesLogsSettings.LimitBytes"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesLogsSettings.PodRunningTimeout"/></li>
        ///     <li><c>--previous</c> via <see cref="KubernetesLogsSettings.Previous"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLogsSettings.Selector"/></li>
        ///     <li><c>--since</c> via <see cref="KubernetesLogsSettings.Since"/></li>
        ///     <li><c>--since-time</c> via <see cref="KubernetesLogsSettings.SinceTime"/></li>
        ///     <li><c>--tail</c> via <see cref="KubernetesLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="KubernetesLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesLogs(KubernetesLogsSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new KubernetesLogsSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Print the logs for a container in a pod or specified resource. If the pod has only one container, the container name is optional.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLogsSettings.TypeName"/></li>
        ///     <li><c>--all-containers</c> via <see cref="KubernetesLogsSettings.AllContainers"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesLogsSettings.Container"/></li>
        ///     <li><c>--follow</c> via <see cref="KubernetesLogsSettings.Follow"/></li>
        ///     <li><c>--interactive</c> via <see cref="KubernetesLogsSettings.Interactive"/></li>
        ///     <li><c>--limit-bytes</c> via <see cref="KubernetesLogsSettings.LimitBytes"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesLogsSettings.PodRunningTimeout"/></li>
        ///     <li><c>--previous</c> via <see cref="KubernetesLogsSettings.Previous"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLogsSettings.Selector"/></li>
        ///     <li><c>--since</c> via <see cref="KubernetesLogsSettings.Since"/></li>
        ///     <li><c>--since-time</c> via <see cref="KubernetesLogsSettings.SinceTime"/></li>
        ///     <li><c>--tail</c> via <see cref="KubernetesLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="KubernetesLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> KubernetesLogs(Configure<KubernetesLogsSettings> configurator)
        {
            return KubernetesLogs(configurator(new KubernetesLogsSettings()));
        }
        /// <summary>
        ///   <p>Print the logs for a container in a pod or specified resource. If the pod has only one container, the container name is optional.</p>
        ///   <p>For more details, visit the <a href="https://kubernetes.io/">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;typeName&gt;</c> via <see cref="KubernetesLogsSettings.TypeName"/></li>
        ///     <li><c>--all-containers</c> via <see cref="KubernetesLogsSettings.AllContainers"/></li>
        ///     <li><c>--container</c> via <see cref="KubernetesLogsSettings.Container"/></li>
        ///     <li><c>--follow</c> via <see cref="KubernetesLogsSettings.Follow"/></li>
        ///     <li><c>--interactive</c> via <see cref="KubernetesLogsSettings.Interactive"/></li>
        ///     <li><c>--limit-bytes</c> via <see cref="KubernetesLogsSettings.LimitBytes"/></li>
        ///     <li><c>--pod-running-timeout</c> via <see cref="KubernetesLogsSettings.PodRunningTimeout"/></li>
        ///     <li><c>--previous</c> via <see cref="KubernetesLogsSettings.Previous"/></li>
        ///     <li><c>--selector</c> via <see cref="KubernetesLogsSettings.Selector"/></li>
        ///     <li><c>--since</c> via <see cref="KubernetesLogsSettings.Since"/></li>
        ///     <li><c>--since-time</c> via <see cref="KubernetesLogsSettings.SinceTime"/></li>
        ///     <li><c>--tail</c> via <see cref="KubernetesLogsSettings.Tail"/></li>
        ///     <li><c>--timestamps</c> via <see cref="KubernetesLogsSettings.Timestamps"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(KubernetesLogsSettings Settings, IReadOnlyCollection<Output> Output)> KubernetesLogs(CombinatorialConfigure<KubernetesLogsSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(KubernetesLogs, KubernetesLogger, degreeOfParallelism, completeOnFailure);
        }
    }
    #region KubernetesApiResourcesSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesApiResourcesSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Limit to resources in the specified API group.
        /// </summary>
        public virtual string ApiGroup { get; internal set; }
        /// <summary>
        ///   Use the cached list of resources if available.
        /// </summary>
        public virtual bool? Cached { get; internal set; }
        /// <summary>
        ///   If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.
        /// </summary>
        public virtual bool? Namespaced { get; internal set; }
        /// <summary>
        ///   When using the default or custom-column output format, don't print headers (default print headers).
        /// </summary>
        public virtual bool? NoHeaders { get; internal set; }
        /// <summary>
        ///   Output format. One of: wide|name.
        /// </summary>
        public virtual KubernetesApiResourcesOutput Output { get; internal set; }
        /// <summary>
        ///   Limit to resources that support the specified verbs.
        /// </summary>
        public virtual IReadOnlyList<string> Verbs => VerbsInternal.AsReadOnly();
        internal List<string> VerbsInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("api-resources")
              .Add("--api-group={value}", ApiGroup)
              .Add("--cached={value}", Cached)
              .Add("--namespaced={value}", Namespaced)
              .Add("--no-headers={value}", NoHeaders)
              .Add("--output={value}", Output)
              .Add("--verbs={value}", Verbs, separator: ',');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesDrainSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesDrainSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).
        /// </summary>
        public virtual bool? DeleteLocalData { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to each pod to terminate gracefully. If negative, the default value specified in the pod will be used.
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   Ignore DaemonSet-managed pods.
        /// </summary>
        public virtual bool? IgnoreDaemonsets { get; internal set; }
        /// <summary>
        ///   Label selector to filter pods on the node.
        /// </summary>
        public virtual string PodSelector { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on.
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up, zero means infinite.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("drain")
              .Add("--delete-local-data={value}", DeleteLocalData)
              .Add("--dry-run={value}", DryRun)
              .Add("--force={value}", Force)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--ignore-daemonsets={value}", IgnoreDaemonsets)
              .Add("--pod-selector={value}", PodSelector)
              .Add("--selector={value}", Selector)
              .Add("--timeout={value}", Timeout);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesRunSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesRunSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The name of the container.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.
        /// </summary>
        public virtual bool? Attach { get; internal set; }
        /// <summary>
        ///   If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.
        /// </summary>
        public virtual bool? Cascade { get; internal set; }
        /// <summary>
        ///   If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.
        /// </summary>
        public virtual bool? Command { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Environment variables to set in the container.
        /// </summary>
        public virtual IReadOnlyList<string> Env => EnvInternal.AsReadOnly();
        internal List<string> EnvInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, a public, external service is created for the container(s) which are run.
        /// </summary>
        public virtual bool? Expose { get; internal set; }
        /// <summary>
        ///   to use to replace the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.
        /// </summary>
        public virtual string Generator { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   The host port mapping for the container port. To demonstrate a single-machine container.
        /// </summary>
        public virtual int? Hostport { get; internal set; }
        /// <summary>
        ///   The image for the container to run.
        /// </summary>
        public virtual string Image { get; internal set; }
        /// <summary>
        ///   The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server.
        /// </summary>
        public virtual string ImagePullPolicy { get; internal set; }
        /// <summary>
        ///   Comma separated labels to apply to the pod(s). Will override previous values.
        /// </summary>
        public virtual string Labels { get; internal set; }
        /// <summary>
        ///   If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.
        /// </summary>
        public virtual bool? LeaveStdinOpen { get; internal set; }
        /// <summary>
        ///   The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.
        /// </summary>
        public virtual string Limits { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesRunOutput Output { get; internal set; }
        /// <summary>
        ///   An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.
        /// </summary>
        public virtual string Overrides { get; internal set; }
        /// <summary>
        ///   The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.
        /// </summary>
        public virtual TimeSpan? PodRunningTimeout { get; internal set; }
        /// <summary>
        ///   The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.
        /// </summary>
        public virtual string Port { get; internal set; }
        /// <summary>
        ///   If true, suppress prompt messages.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Number of replicas to create for this container. Default is 1.
        /// </summary>
        public virtual int? Replicas { get; internal set; }
        /// <summary>
        ///   The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.
        /// </summary>
        public virtual string Requests { get; internal set; }
        /// <summary>
        ///   The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.
        /// </summary>
        public virtual string Restart { get; internal set; }
        /// <summary>
        ///   If true, delete resources created in this command for attached containers.
        /// </summary>
        public virtual bool? Rm { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   A schedule in the Cron format the job should be run with.
        /// </summary>
        public virtual string Schedule { get; internal set; }
        /// <summary>
        ///   The name of the generator to use for creating a service.  Only used if --expose is true.
        /// </summary>
        public virtual string ServiceGenerator { get; internal set; }
        /// <summary>
        ///   An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.
        /// </summary>
        public virtual string ServiceOverrides { get; internal set; }
        /// <summary>
        ///   Service account to set in the pod spec.
        /// </summary>
        public virtual string Serviceaccount { get; internal set; }
        /// <summary>
        ///   Keep stdin open on the container(s) in the pod, even if nothing is attached.
        /// </summary>
        public virtual bool? Stdin { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   Allocated a TTY for each container in the pod.
        /// </summary>
        public virtual bool? Tty { get; internal set; }
        /// <summary>
        ///   If true, wait for resources to be gone before returning. This waits for finalizers.
        /// </summary>
        public virtual bool? Wait { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("run")
              .Add("{value}", Name)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--attach={value}", Attach)
              .Add("--cascade={value}", Cascade)
              .Add("--command={value}", Command)
              .Add("--dry-run={value}", DryRun)
              .Add("--env={value}", Env)
              .Add("--expose={value}", Expose)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--force={value}", Force)
              .Add("--generator={value}", Generator)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--hostport={value}", Hostport)
              .Add("--image={value}", Image)
              .Add("--image-pull-policy={value}", ImagePullPolicy)
              .Add("--labels={value}", Labels)
              .Add("--leave-stdin-open={value}", LeaveStdinOpen)
              .Add("--limits={value}", Limits)
              .Add("--output={value}", Output)
              .Add("--overrides={value}", Overrides)
              .Add("--pod-running-timeout={value}", PodRunningTimeout)
              .Add("--port={value}", Port)
              .Add("--quiet={value}", Quiet)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--replicas={value}", Replicas)
              .Add("--requests={value}", Requests)
              .Add("--restart={value}", Restart)
              .Add("--rm={value}", Rm)
              .Add("--save-config={value}", SaveConfig)
              .Add("--schedule={value}", Schedule)
              .Add("--service-generator={value}", ServiceGenerator)
              .Add("--service-overrides={value}", ServiceOverrides)
              .Add("--serviceaccount={value}", Serviceaccount)
              .Add("--stdin={value}", Stdin)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout)
              .Add("--tty={value}", Tty)
              .Add("--wait={value}", Wait);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesGetSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesGetSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.
        /// </summary>
        public virtual bool? AllNamespaces { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Return large lists in chunks rather than all at once. Pass 0 to disable. This flag is beta and may change in the future.
        /// </summary>
        public virtual long? ChunkSize { get; internal set; }
        /// <summary>
        ///   If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.
        /// </summary>
        public virtual bool? Export { get; internal set; }
        /// <summary>
        ///   Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.
        /// </summary>
        public virtual string FieldSelector { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to get from a server.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If the requested object does not exist the command will return exit code 0.
        /// </summary>
        public virtual bool? IgnoreNotFound { get; internal set; }
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...
        /// </summary>
        public virtual IReadOnlyList<string> LabelColumns => LabelColumnsInternal.AsReadOnly();
        internal List<string> LabelColumnsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   When using the default or custom-column output format, don't print headers (default print headers).
        /// </summary>
        public virtual bool? NoHeaders { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|wide|name|custom-columns=...|custom-columns-file=...|go-template=...|go-template-file=...|jsonpath=...|jsonpath-file=... See custom columns [http://kubernetes.io/docs/user-guide/kubectl-overview/#custom-columns], golang template [http://golang.org/pkg/text/template/#pkg-overview] and jsonpath template [http://kubernetes.io/docs/user-guide/jsonpath].
        /// </summary>
        public virtual KubernetesGetOutput Output { get; internal set; }
        /// <summary>
        ///   Raw URI to request from the server.  Uses the transport specified by the kubeconfig file.
        /// </summary>
        public virtual string Raw { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   If true, have the server return the appropriate table output. Supports extension APIs and CRDs.
        /// </summary>
        public virtual bool? ServerPrint { get; internal set; }
        /// <summary>
        ///   When printing, show all resources (default show all pods including terminated one.).
        /// </summary>
        public virtual bool? ShowAll { get; internal set; }
        /// <summary>
        ///   If present, list the resource type for the requested object(s).
        /// </summary>
        public virtual bool? ShowKind { get; internal set; }
        /// <summary>
        ///   When printing, show all labels as the last column (default hide labels column).
        /// </summary>
        public virtual bool? ShowLabels { get; internal set; }
        /// <summary>
        ///   If non-empty, sort list types using this field specification.  The field specification is expressed as a JSONPath expression (e.g. '{.metadata.name}'). The field in the API resource specified by this JSONPath expression must be an integer or a string.
        /// </summary>
        public virtual string SortBy { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.
        /// </summary>
        public virtual bool? UseOpenapiPrintColumns { get; internal set; }
        /// <summary>
        ///   After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.
        /// </summary>
        public virtual bool? Watch { get; internal set; }
        /// <summary>
        ///   Watch for changes to the requested object(s), without listing/getting first.
        /// </summary>
        public virtual bool? WatchOnly { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("get")
              .Add("{value}", TypeName, separator: ' ')
              .Add("--all-namespaces={value}", AllNamespaces)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--chunk-size={value}", ChunkSize)
              .Add("--export={value}", Export)
              .Add("--field-selector={value}", FieldSelector)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--ignore-not-found={value}", IgnoreNotFound)
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--label-columns={value}", LabelColumns, separator: ',')
              .Add("--no-headers={value}", NoHeaders)
              .Add("--output={value}", Output)
              .Add("--raw={value}", Raw)
              .Add("--recursive={value}", Recursive)
              .Add("--selector={value}", Selector)
              .Add("--server-print={value}", ServerPrint)
              .Add("--show-all={value}", ShowAll)
              .Add("--show-kind={value}", ShowKind)
              .Add("--show-labels={value}", ShowLabels)
              .Add("--sort-by={value}", SortBy)
              .Add("--template={value}", Template)
              .Add("--use-openapi-print-columns={value}", UseOpenapiPrintColumns)
              .Add("--watch={value}", Watch)
              .Add("--watch-only={value}", WatchOnly);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesVersionSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesVersionSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Client version only (no server required).
        /// </summary>
        public virtual bool? Client { get; internal set; }
        /// <summary>
        ///   One of 'yaml' or 'json'.
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Print just the version number.
        /// </summary>
        public virtual bool? Short { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("version")
              .Add("--client={value}", Client)
              .Add("--output={value}", Output)
              .Add("--short={value}", Short);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesTopSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesTopSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("top");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesConfigSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesConfigSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("config");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesExecSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesExecSettings : KubernetesExecBaseSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The name of the pod.
        /// </summary>
        public virtual string PodName { get; internal set; }
        /// <summary>
        ///   Container name. If omitted, the first container in the pod will be chosen.
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   Pod name.
        /// </summary>
        public virtual string Pod { get; internal set; }
        /// <summary>
        ///   Pass stdin to the container.
        /// </summary>
        public virtual bool? Stdin { get; internal set; }
        /// <summary>
        ///   Stdin is a TTY.
        /// </summary>
        public virtual bool? Tty { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("exec")
              .Add("{value}", PodName)
              .Add("--container={value}", Container)
              .Add("--pod={value}", Pod)
              .Add("--stdin={value}", Stdin)
              .Add("--tty={value}", Tty);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesRollingUpdateSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesRollingUpdateSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod.
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise.
        /// </summary>
        public virtual string DeploymentLabelKey { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Filename or URL to file to use to create the new replication controller.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f.
        /// </summary>
        public virtual string Image { get; internal set; }
        /// <summary>
        ///   Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.
        /// </summary>
        public virtual string ImagePullPolicy { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|go-template-file|templatefile|template|go-template|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesRollingUpdateOutput Output { get; internal set; }
        /// <summary>
        ///   Time delay between polling for replication controller status after the update. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        /// </summary>
        public virtual TimeSpan? PollInterval { get; internal set; }
        /// <summary>
        ///   If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.
        /// </summary>
        public virtual bool? Rollback { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   Max time to wait for a replication controller to update before giving up. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   Time to wait between updating pods. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        /// </summary>
        public virtual TimeSpan? UpdatePeriod { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("rolling-update")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--container={value}", Container)
              .Add("--deployment-label-key={value}", DeploymentLabelKey)
              .Add("--dry-run={value}", DryRun)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--image={value}", Image)
              .Add("--image-pull-policy={value}", ImagePullPolicy)
              .Add("--output={value}", Output)
              .Add("--poll-interval={value}", PollInterval)
              .Add("--rollback={value}", Rollback)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout)
              .Add("--update-period={value}", UpdatePeriod)
              .Add("--validate={value}", Validate);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesLabelSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesLabelSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Labels to set.
        /// </summary>
        public virtual IReadOnlyDictionary<string, string> Labels => LabelsInternal.AsReadOnly();
        internal Dictionary<string,string> LabelsInternal { get; set; } = new Dictionary<string,string>(StringComparer.OrdinalIgnoreCase);
        /// <summary>
        ///   Select all resources, including uninitialized ones, in the namespace of the specified resource types.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.
        /// </summary>
        public virtual string FieldSelector { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to update the labels.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   If true, display the labels for a given resource.
        /// </summary>
        public virtual bool? List { get; internal set; }
        /// <summary>
        ///   If true, label will NOT contact api-server but run locally.
        /// </summary>
        public virtual bool? Local { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesLabelOutput Output { get; internal set; }
        /// <summary>
        ///   If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.
        /// </summary>
        public virtual bool? Overwrite { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.
        /// </summary>
        public virtual string ResourceVersion { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("label")
              .Add("{value}", TypeName, separator: ' ')
              .Add("{value}", Labels, "{key}={value}", separator: ' ')
              .Add("--all={value}", All)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--dry-run={value}", DryRun)
              .Add("--field-selector={value}", FieldSelector)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--list={value}", List)
              .Add("--local={value}", Local)
              .Add("--output={value}", Output)
              .Add("--overwrite={value}", Overwrite)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--resource-version={value}", ResourceVersion)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesAnnotateSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesAnnotateSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The annotations to set on the ressource
        /// </summary>
        public virtual IReadOnlyDictionary<string, string> Annotations => AnnotationsInternal.AsReadOnly();
        internal Dictionary<string,string> AnnotationsInternal { get; set; } = new Dictionary<string,string>(StringComparer.OrdinalIgnoreCase);
        /// <summary>
        ///   Select all resources, including uninitialized ones, in the namespace of the specified resource types.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.
        /// </summary>
        public virtual string FieldSelector { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to update the annotation.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   If true, annotation will NOT contact api-server but run locally.
        /// </summary>
        public virtual bool? Local { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesAnnotateOutput Output { get; internal set; }
        /// <summary>
        ///   If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.
        /// </summary>
        public virtual bool? Overwrite { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.
        /// </summary>
        public virtual string ResourceVersion { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("annotate")
              .Add("{value}", TypeName, separator: ' ')
              .Add("{value}", Annotations, "{key}={value}", separator: ' ')
              .Add("--all={value}", All)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--dry-run={value}", DryRun)
              .Add("--field-selector={value}", FieldSelector)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--local={value}", Local)
              .Add("--output={value}", Output)
              .Add("--overwrite={value}", Overwrite)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--resource-version={value}", ResourceVersion)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesDeleteSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesDeleteSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Delete all resources, including uninitialized ones, in the namespace of the specified resource types.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.
        /// </summary>
        public virtual bool? Cascade { get; internal set; }
        /// <summary>
        ///   Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.
        /// </summary>
        public virtual string FieldSelector { get; internal set; }
        /// <summary>
        ///   containing the resource to delete.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.
        /// </summary>
        public virtual bool? IgnoreNotFound { get; internal set; }
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   If true, resources are signaled for immediate shutdown (same as --grace-period=1).
        /// </summary>
        public virtual bool? Now { get; internal set; }
        /// <summary>
        ///   Output mode. Use "-o name" for shorter output (resource/name).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, not including uninitialized ones.
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   If true, wait for resources to be gone before returning. This waits for finalizers.
        /// </summary>
        public virtual bool? Wait { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("delete")
              .Add("--all={value}", All)
              .Add("--cascade={value}", Cascade)
              .Add("--field-selector={value}", FieldSelector)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--force={value}", Force)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--ignore-not-found={value}", IgnoreNotFound)
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--now={value}", Now)
              .Add("--output={value}", Output)
              .Add("--recursive={value}", Recursive)
              .Add("--selector={value}", Selector)
              .Add("--timeout={value}", Timeout)
              .Add("--wait={value}", Wait);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesExposeSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesExposeSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.
        /// </summary>
        public virtual string ClusterIp { get; internal set; }
        /// <summary>
        ///   Synonym for --target-port.
        /// </summary>
        public virtual string ContainerPort { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.
        /// </summary>
        public virtual string ExternalIp { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to expose a service.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.
        /// </summary>
        public virtual string Generator { get; internal set; }
        /// <summary>
        ///   Labels to apply to the service created by this call.
        /// </summary>
        public virtual string Labels { get; internal set; }
        /// <summary>
        ///   IP to assign to the LoadBalancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).
        /// </summary>
        public virtual string LoadBalancerIp { get; internal set; }
        /// <summary>
        ///   The name for the newly created object.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesExposeOutput Output { get; internal set; }
        /// <summary>
        ///   An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.
        /// </summary>
        public virtual string Overrides { get; internal set; }
        /// <summary>
        ///   The port that the service should serve on. Copied from the resource being exposed, if unspecified.
        /// </summary>
        public virtual string Port { get; internal set; }
        /// <summary>
        ///   The network protocol for the service to be created. Default is 'TCP'.
        /// </summary>
        public virtual string Protocol { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'.
        /// </summary>
        public virtual string SessionAffinity { get; internal set; }
        /// <summary>
        ///   Name or number for the port on the container that the service should direct traffic to. Optional.
        /// </summary>
        public virtual string TargetPort { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   Type for this service: ClusterIP, NodePort, LoadBalancer, or ExternalName. Default is 'ClusterIP'.
        /// </summary>
        public virtual string Type { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("expose")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--cluster-ip={value}", ClusterIp)
              .Add("--container-port={value}", ContainerPort)
              .Add("--dry-run={value}", DryRun)
              .Add("--external-ip={value}", ExternalIp)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--generator={value}", Generator)
              .Add("--labels={value}", Labels)
              .Add("--load-balancer-ip={value}", LoadBalancerIp)
              .Add("--name={value}", Name)
              .Add("--output={value}", Output)
              .Add("--overrides={value}", Overrides)
              .Add("--port={value}", Port)
              .Add("--protocol={value}", Protocol)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--save-config={value}", SaveConfig)
              .Add("--selector={value}", Selector)
              .Add("--session-affinity={value}", SessionAffinity)
              .Add("--target-port={value}", TargetPort)
              .Add("--template={value}", Template)
              .Add("--type={value}", Type);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesOptionsSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesOptionsSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("options");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesAttachSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesAttachSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the pod.
        /// </summary>
        public virtual IReadOnlyList<string> Pod => PodInternal.AsReadOnly();
        internal List<string> PodInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Container name. If omitted, the first container in the pod will be chosen.
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.
        /// </summary>
        public virtual TimeSpan? PodRunningTimeout { get; internal set; }
        /// <summary>
        ///   Pass stdin to the container.
        /// </summary>
        public virtual bool? Stdin { get; internal set; }
        /// <summary>
        ///   Stdin is a TTY.
        /// </summary>
        public virtual bool? Tty { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("attach")
              .Add("{value}", Pod, separator: ' ')
              .Add("--container={value}", Container)
              .Add("--pod-running-timeout={value}", PodRunningTimeout)
              .Add("--stdin={value}", Stdin)
              .Add("--tty={value}", Tty);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesProxySettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesProxySettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Regular expression for hosts that the proxy should accept.
        /// </summary>
        public virtual string AcceptHosts { get; internal set; }
        /// <summary>
        ///   Regular expression for paths that the proxy should accept.
        /// </summary>
        public virtual string AcceptPaths { get; internal set; }
        /// <summary>
        ///   The IP address on which to serve on.
        /// </summary>
        public virtual string Address { get; internal set; }
        /// <summary>
        ///   Prefix to serve the proxied API under.
        /// </summary>
        public virtual string ApiPrefix { get; internal set; }
        /// <summary>
        ///   If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.
        /// </summary>
        public virtual bool? DisableFilter { get; internal set; }
        /// <summary>
        ///   The port on which to run the proxy. Set to 0 to pick a random port.
        /// </summary>
        public virtual int? Port { get; internal set; }
        /// <summary>
        ///   Regular expression for HTTP methods that the proxy should reject (example --reject-methods='POST,PUT,PATCH'). .
        /// </summary>
        public virtual string RejectMethods { get; internal set; }
        /// <summary>
        ///   Regular expression for paths that the proxy should reject. Paths specified here will be rejected even accepted by --accept-paths.
        /// </summary>
        public virtual string RejectPaths { get; internal set; }
        /// <summary>
        ///   Unix socket on which to run the proxy.
        /// </summary>
        public virtual string UnixSocket { get; internal set; }
        /// <summary>
        ///   Also serve static files from the given directory under the specified prefix.
        /// </summary>
        public virtual string Www { get; internal set; }
        /// <summary>
        ///   Prefix to serve static files under, if static file directory is specified.
        /// </summary>
        public virtual string WwwPrefix { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("proxy")
              .Add("--accept-hosts={value}", AcceptHosts)
              .Add("--accept-paths={value}", AcceptPaths)
              .Add("--address={value}", Address)
              .Add("--api-prefix={value}", ApiPrefix)
              .Add("--disable-filter={value}", DisableFilter)
              .Add("--port={value}", Port)
              .Add("--reject-methods={value}", RejectMethods)
              .Add("--reject-paths={value}", RejectPaths)
              .Add("--unix-socket={value}", UnixSocket)
              .Add("--www={value}", Www)
              .Add("--www-prefix={value}", WwwPrefix);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesAlphaSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesAlphaSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("alpha");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("kubectl");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCompletionSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCompletionSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("completion");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesPatchSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesPatchSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to update.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, patch will operate on the content of the file, not the server-side resource.
        /// </summary>
        public virtual bool? Local { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesPatchOutput Output { get; internal set; }
        /// <summary>
        ///   The patch to be applied to the resource JSON file.
        /// </summary>
        public virtual string Patch { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The type of patch being provided; one of [json merge strategic].
        /// </summary>
        public virtual KubernetesPatchType Type { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("patch")
              .Add("{value}", TypeName, separator: ' ')
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--dry-run={value}", DryRun)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--local={value}", Local)
              .Add("--output={value}", Output)
              .Add("--patch={value}", Patch)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--template={value}", Template)
              .Add("--type={value}", Type);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesReplaceSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesReplaceSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.
        /// </summary>
        public virtual bool? Cascade { get; internal set; }
        /// <summary>
        ///   to use to replace the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesReplaceOutput Output { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        /// <summary>
        ///   If true, wait for resources to be gone before returning. This waits for finalizers.
        /// </summary>
        public virtual bool? Wait { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("replace")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--cascade={value}", Cascade)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--force={value}", Force)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--output={value}", Output)
              .Add("--recursive={value}", Recursive)
              .Add("--save-config={value}", SaveConfig)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout)
              .Add("--validate={value}", Validate)
              .Add("--wait={value}", Wait);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesTaintSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesTaintSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The taint effects to set.
        /// </summary>
        public virtual IReadOnlyDictionary<string, string> TaintEffects => TaintEffectsInternal.AsReadOnly();
        internal Dictionary<string,string> TaintEffectsInternal { get; set; } = new Dictionary<string,string>(StringComparer.OrdinalIgnoreCase);
        /// <summary>
        ///   Select all nodes in the cluster.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesTaintOutput Output { get; internal set; }
        /// <summary>
        ///   If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.
        /// </summary>
        public virtual bool? Overwrite { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("taint")
              .Add("{value}", TypeName, separator: ' ')
              .Add("{value}", TaintEffects, "{key}={value}", separator: ' ')
              .Add("--all={value}", All)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--output={value}", Output)
              .Add("--overwrite={value}", Overwrite)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template)
              .Add("--validate={value}", Validate);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesDescribeSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesDescribeSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.
        /// </summary>
        public virtual bool? AllNamespaces { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files containing the resource to describe.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   If true, display events related to the described object.
        /// </summary>
        public virtual bool? ShowEvents { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("describe")
              .Add("{value}", TypeName, separator: ' ')
              .Add("--all-namespaces={value}", AllNamespaces)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--recursive={value}", Recursive)
              .Add("--selector={value}", Selector)
              .Add("--show-events={value}", ShowEvents);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesSetSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesSetSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The subcommand to run.
        /// </summary>
        public virtual IReadOnlyList<string> Subcommand => SubcommandInternal.AsReadOnly();
        internal List<string> SubcommandInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("set")
              .Add("{value}", Subcommand, separator: ' ');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesAuthSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesAuthSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The subcommand to run.
        /// </summary>
        public virtual string Subcommand { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("auth")
              .Add("{value}", Subcommand);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCertificateSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCertificateSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The subcommand to run.
        /// </summary>
        public virtual IReadOnlyList<string> Subcommand => SubcommandInternal.AsReadOnly();
        internal List<string> SubcommandInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("certificate")
              .Add("{value}", Subcommand, separator: ' ');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesRolloutSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesRolloutSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The subcommand to run.
        /// </summary>
        public virtual IReadOnlyList<string> Subcommand => SubcommandInternal.AsReadOnly();
        internal List<string> SubcommandInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("rollout")
              .Add("{value}", Subcommand, separator: ' ');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesApplySettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesApplySettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Select all resources in the namespace of the specified resource types.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.
        /// </summary>
        public virtual bool? Cascade { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   that contains the configuration to apply.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.
        /// </summary>
        public virtual bool? OpenapiPatch { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesApplyOutput Output { get; internal set; }
        /// <summary>
        ///   Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.
        /// </summary>
        public virtual bool? Overwrite { get; internal set; }
        /// <summary>
        ///   Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.
        /// </summary>
        public virtual bool? Prune { get; internal set; }
        /// <summary>
        ///   Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.
        /// </summary>
        public virtual IReadOnlyList<string> PruneWhitelist => PruneWhitelistInternal.AsReadOnly();
        internal List<string> PruneWhitelistInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        /// <summary>
        ///   If true, wait for resources to be gone before returning. This waits for finalizers.
        /// </summary>
        public virtual bool? Wait { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("apply")
              .Add("--all={value}", All)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--cascade={value}", Cascade)
              .Add("--dry-run={value}", DryRun)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--force={value}", Force)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--openapi-patch={value}", OpenapiPatch)
              .Add("--output={value}", Output)
              .Add("--overwrite={value}", Overwrite)
              .Add("--prune={value}", Prune)
              .Add("--prune-whitelist={value}", PruneWhitelist)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout)
              .Add("--validate={value}", Validate)
              .Add("--wait={value}", Wait);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCordonSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCordonSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The namne of the Node.
        /// </summary>
        public virtual string Node { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on.
        /// </summary>
        public virtual string Selector { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("cordon")
              .Add("{value}", Node)
              .Add("--dry-run={value}", DryRun)
              .Add("--selector={value}", Selector);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCpSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCpSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The file specification of the source. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.
        /// </summary>
        public virtual string SrcFileSpec { get; internal set; }
        /// <summary>
        ///   The file specification of the destination. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.
        /// </summary>
        public virtual string DestFileSpec { get; internal set; }
        /// <summary>
        ///   Container name. If omitted, the first container in the pod will be chosen.
        /// </summary>
        public virtual string Container { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("cp")
              .Add("{value}", SrcFileSpec)
              .Add("{value}", DestFileSpec)
              .Add("--container={value}", Container);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesApiVersionsSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesApiVersionsSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("api-versions");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesUncordonSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesUncordonSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The name of the node.
        /// </summary>
        public virtual string Node { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on.
        /// </summary>
        public virtual string Selector { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("uncordon")
              .Add("{value}", Node)
              .Add("--dry-run={value}", DryRun)
              .Add("--selector={value}", Selector);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesAutoscaleSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesAutoscaleSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   The target average CPU utilization (represented as a percent of requested CPU) over all the pods. If it's not specified or negative, a default autoscaling policy will be used.
        /// </summary>
        public virtual int? CpuPercent { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to autoscale.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of the API generator to use. Currently there is only 1 generator.
        /// </summary>
        public virtual string Generator { get; internal set; }
        /// <summary>
        ///   The upper limit for the number of pods that can be set by the autoscaler. Required.
        /// </summary>
        public virtual int? Max { get; internal set; }
        /// <summary>
        ///   The lower limit for the number of pods that can be set by the autoscaler. If it's not specified or negative, the server will apply a default value.
        /// </summary>
        public virtual int? Min { get; internal set; }
        /// <summary>
        ///   The name for the newly created object. If not specified, the name of the input resource will be used.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesAutoscaleOutput Output { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("autoscale")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--cpu-percent={value}", CpuPercent)
              .Add("--dry-run={value}", DryRun)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--generator={value}", Generator)
              .Add("--max={value}", Max)
              .Add("--min={value}", Min)
              .Add("--name={value}", Name)
              .Add("--output={value}", Output)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--save-config={value}", SaveConfig)
              .Add("--template={value}", Template);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesPluginSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesPluginSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The name of the plugin.
        /// </summary>
        public virtual string Name { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("plugin")
              .Add("{value}", Name);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesClusterInfoSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesClusterInfoSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("cluster-info");
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesWaitSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesWaitSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.
        /// </summary>
        public virtual bool? AllNamespaces { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   identifying the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The condition to wait on: [delete|condition=condition-name].
        /// </summary>
        public virtual string For { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesWaitOutput Output { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up.  Zero means check once and don't wait, negative means wait for a week.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("wait")
              .Add("--all-namespaces={value}", AllNamespaces)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--for={value}", For)
              .Add("--output={value}", Output)
              .Add("--recursive={value}", Recursive)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesConvertSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesConvertSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files to need to get converted.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, convert will NOT try to contact api-server but run locally.
        /// </summary>
        public virtual bool? Local { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|go-template|go-template-file|templatefile|template|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesConvertOutput Output { get; internal set; }
        /// <summary>
        ///   Output the formatted object with the given group version (for ex: 'extensions/v1beta1').).
        /// </summary>
        public virtual string OutputVersion { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("convert")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--local={value}", Local)
              .Add("--output={value}", Output)
              .Add("--output-version={value}", OutputVersion)
              .Add("--recursive={value}", Recursive)
              .Add("--template={value}", Template)
              .Add("--validate={value}", Validate);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCreateSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCreateSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Edit the API resource before creating.
        /// </summary>
        public virtual bool? Edit { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files to use to create the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesCreateOutput Output { get; internal set; }
        /// <summary>
        ///   Raw URI to POST to the server.  Uses the transport specified by the kubeconfig file.
        /// </summary>
        public virtual string Raw { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        /// <summary>
        ///   Only relevant if --edit=true. Defaults to the line ending native to your platform.
        /// </summary>
        public virtual bool? WindowsLineEndings { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("create")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--dry-run={value}", DryRun)
              .Add("--edit={value}", Edit)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--output={value}", Output)
              .Add("--raw={value}", Raw)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--save-config={value}", SaveConfig)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template)
              .Add("--validate={value}", Validate)
              .Add("--windows-line-endings={value}", WindowsLineEndings);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesPortForwardSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesPortForwardSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The port combinations to forward. In the Format 'srcPort:destPort'.
        /// </summary>
        public virtual IReadOnlyDictionary<int, int> Ports => PortsInternal.AsReadOnly();
        internal Dictionary<int,int> PortsInternal { get; set; } = new Dictionary<int,int>(EqualityComparer<int>.Default);
        /// <summary>
        ///   The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.
        /// </summary>
        public virtual TimeSpan? PodRunningTimeout { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("port-forward")
              .Add("{value}", TypeName, separator: ' ')
              .Add("{value}", Ports, "{key}={value}", separator: ' ')
              .Add("--pod-running-timeout={value}", PodRunningTimeout);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesRunContainerSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesRunContainerSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.
        /// </summary>
        public virtual bool? Attach { get; internal set; }
        /// <summary>
        ///   If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.
        /// </summary>
        public virtual bool? Cascade { get; internal set; }
        /// <summary>
        ///   If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.
        /// </summary>
        public virtual bool? Command { get; internal set; }
        /// <summary>
        ///   If true, only print the object that would be sent, without sending it.
        /// </summary>
        public virtual bool? DryRun { get; internal set; }
        /// <summary>
        ///   Environment variables to set in the container.
        /// </summary>
        public virtual IReadOnlyList<string> Env => EnvInternal.AsReadOnly();
        internal List<string> EnvInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, a public, external service is created for the container(s) which are run.
        /// </summary>
        public virtual bool? Expose { get; internal set; }
        /// <summary>
        ///   to use to replace the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.
        /// </summary>
        public virtual bool? Force { get; internal set; }
        /// <summary>
        ///   The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.
        /// </summary>
        public virtual string Generator { get; internal set; }
        /// <summary>
        ///   Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).
        /// </summary>
        public virtual int? GracePeriod { get; internal set; }
        /// <summary>
        ///   The host port mapping for the container port. To demonstrate a single-machine container.
        /// </summary>
        public virtual int? Hostport { get; internal set; }
        /// <summary>
        ///   The image for the container to run.
        /// </summary>
        public virtual string Image { get; internal set; }
        /// <summary>
        ///   The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server.
        /// </summary>
        public virtual string ImagePullPolicy { get; internal set; }
        /// <summary>
        ///   Comma separated labels to apply to the pod(s). Will override previous values.
        /// </summary>
        public virtual string Labels { get; internal set; }
        /// <summary>
        ///   If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.
        /// </summary>
        public virtual bool? LeaveStdinOpen { get; internal set; }
        /// <summary>
        ///   The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.
        /// </summary>
        public virtual string Limits { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesRunContainerOutput Output { get; internal set; }
        /// <summary>
        ///   An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.
        /// </summary>
        public virtual string Overrides { get; internal set; }
        /// <summary>
        ///   The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.
        /// </summary>
        public virtual TimeSpan? PodRunningTimeout { get; internal set; }
        /// <summary>
        ///   The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.
        /// </summary>
        public virtual string Port { get; internal set; }
        /// <summary>
        ///   If true, suppress prompt messages.
        /// </summary>
        public virtual bool? Quiet { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   Number of replicas to create for this container. Default is 1.
        /// </summary>
        public virtual int? Replicas { get; internal set; }
        /// <summary>
        ///   The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.
        /// </summary>
        public virtual string Requests { get; internal set; }
        /// <summary>
        ///   The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.
        /// </summary>
        public virtual string Restart { get; internal set; }
        /// <summary>
        ///   If true, delete resources created in this command for attached containers.
        /// </summary>
        public virtual bool? Rm { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   A schedule in the Cron format the job should be run with.
        /// </summary>
        public virtual string Schedule { get; internal set; }
        /// <summary>
        ///   The name of the generator to use for creating a service.  Only used if --expose is true.
        /// </summary>
        public virtual string ServiceGenerator { get; internal set; }
        /// <summary>
        ///   An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.
        /// </summary>
        public virtual string ServiceOverrides { get; internal set; }
        /// <summary>
        ///   Service account to set in the pod spec.
        /// </summary>
        public virtual string Serviceaccount { get; internal set; }
        /// <summary>
        ///   Keep stdin open on the container(s) in the pod, even if nothing is attached.
        /// </summary>
        public virtual bool? Stdin { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        /// <summary>
        ///   Allocated a TTY for each container in the pod.
        /// </summary>
        public virtual bool? Tty { get; internal set; }
        /// <summary>
        ///   If true, wait for resources to be gone before returning. This waits for finalizers.
        /// </summary>
        public virtual bool? Wait { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("run-container")
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--attach={value}", Attach)
              .Add("--cascade={value}", Cascade)
              .Add("--command={value}", Command)
              .Add("--dry-run={value}", DryRun)
              .Add("--env={value}", Env)
              .Add("--expose={value}", Expose)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--force={value}", Force)
              .Add("--generator={value}", Generator)
              .Add("--grace-period={value}", GracePeriod)
              .Add("--hostport={value}", Hostport)
              .Add("--image={value}", Image)
              .Add("--image-pull-policy={value}", ImagePullPolicy)
              .Add("--labels={value}", Labels)
              .Add("--leave-stdin-open={value}", LeaveStdinOpen)
              .Add("--limits={value}", Limits)
              .Add("--output={value}", Output)
              .Add("--overrides={value}", Overrides)
              .Add("--pod-running-timeout={value}", PodRunningTimeout)
              .Add("--port={value}", Port)
              .Add("--quiet={value}", Quiet)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--replicas={value}", Replicas)
              .Add("--requests={value}", Requests)
              .Add("--restart={value}", Restart)
              .Add("--rm={value}", Rm)
              .Add("--save-config={value}", SaveConfig)
              .Add("--schedule={value}", Schedule)
              .Add("--service-generator={value}", ServiceGenerator)
              .Add("--service-overrides={value}", ServiceOverrides)
              .Add("--serviceaccount={value}", Serviceaccount)
              .Add("--stdin={value}", Stdin)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout)
              .Add("--tty={value}", Tty)
              .Add("--wait={value}", Wait);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesEditSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesEditSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files to use to edit the resource.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.
        /// </summary>
        public virtual bool? IncludeUninitialized { get; internal set; }
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesEditOutput Output { get; internal set; }
        /// <summary>
        ///   Output the patch if the resource is edited.
        /// </summary>
        public virtual bool? OutputPatch { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.
        /// </summary>
        public virtual bool? SaveConfig { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   If true, use a schema to validate the input before sending it.
        /// </summary>
        public virtual bool? Validate { get; internal set; }
        /// <summary>
        ///   Defaults to the line ending native to your platform.
        /// </summary>
        public virtual bool? WindowsLineEndings { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("edit")
              .Add("{value}", TypeName, separator: ' ')
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--include-uninitialized={value}", IncludeUninitialized)
              .Add("--output={value}", Output)
              .Add("--output-patch={value}", OutputPatch)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--save-config={value}", SaveConfig)
              .Add("--template={value}", Template)
              .Add("--validate={value}", Validate)
              .Add("--windows-line-endings={value}", WindowsLineEndings);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesScaleSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesScaleSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Select all resources in the namespace of the specified resource types.
        /// </summary>
        public virtual bool? All { get; internal set; }
        /// <summary>
        ///   If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.
        /// </summary>
        public virtual bool? AllowMissingTemplateKeys { get; internal set; }
        /// <summary>
        ///   Precondition for current size. Requires that the current size of the resource match this value in order to scale.
        /// </summary>
        public virtual int? CurrentReplicas { get; internal set; }
        /// <summary>
        ///   Filename, directory, or URL to files identifying the resource to set a new size.
        /// </summary>
        public virtual IReadOnlyList<string> Filename => FilenameInternal.AsReadOnly();
        internal List<string> FilenameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.
        /// </summary>
        public virtual KubernetesScaleOutput Output { get; internal set; }
        /// <summary>
        ///   Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.
        /// </summary>
        public virtual bool? Record { get; internal set; }
        /// <summary>
        ///   Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   The new desired number of replicas. Required.
        /// </summary>
        public virtual int? Replicas { get; internal set; }
        /// <summary>
        ///   Precondition for resource version. Requires that the current resource version match this value in order to scale.
        /// </summary>
        public virtual string ResourceVersion { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].
        /// </summary>
        public virtual string Template { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a scale operation, zero means don't wait. Any other values should contain a corresponding time unit (e.g. 1s, 2m, 3h).
        /// </summary>
        public virtual TimeSpan? Timeout { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("scale")
              .Add("--all={value}", All)
              .Add("--allow-missing-template-keys={value}", AllowMissingTemplateKeys)
              .Add("--current-replicas={value}", CurrentReplicas)
              .Add("--filename={value}", Filename, separator: ',')
              .Add("--output={value}", Output)
              .Add("--record={value}", Record)
              .Add("--recursive={value}", Recursive)
              .Add("--replicas={value}", Replicas)
              .Add("--resource-version={value}", ResourceVersion)
              .Add("--selector={value}", Selector)
              .Add("--template={value}", Template)
              .Add("--timeout={value}", Timeout);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesExplainSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesExplainSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   Get different explanations for particular API version.
        /// </summary>
        public virtual string ApiVersion { get; internal set; }
        /// <summary>
        ///   Print the fields of fields (Currently only 1 level deep).
        /// </summary>
        public virtual bool? Recursive { get; internal set; }
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> Resource => ResourceInternal.AsReadOnly();
        internal List<string> ResourceInternal { get; set; } = new List<string>();
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("explain")
              .Add("--api-version={value}", ApiVersion)
              .Add("--recursive={value}", Recursive)
              .Add("{value}", Resource, separator: ' ');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesLogsSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesLogsSettings : KubernetesToolSettings
    {
        /// <summary>
        ///   Path to the Kubernetes executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? KubernetesTasks.KubernetesPath;
        public override Action<OutputType, string> ProcessCustomLogger => KubernetesTasks.KubernetesLogger;
        /// <summary>
        ///   The type or/and name of the ressource.
        /// </summary>
        public virtual IReadOnlyList<string> TypeName => TypeNameInternal.AsReadOnly();
        internal List<string> TypeNameInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Get all containers's logs in the pod(s).
        /// </summary>
        public virtual bool? AllContainers { get; internal set; }
        /// <summary>
        ///   Print the logs of this container.
        /// </summary>
        public virtual string Container { get; internal set; }
        /// <summary>
        ///   Specify if the logs should be streamed.
        /// </summary>
        public virtual bool? Follow { get; internal set; }
        /// <summary>
        ///   If true, prompt the user for input when required.
        /// </summary>
        public virtual bool? Interactive { get; internal set; }
        /// <summary>
        ///   Maximum bytes of logs to return. Defaults to no limit.
        /// </summary>
        public virtual long? LimitBytes { get; internal set; }
        /// <summary>
        ///   The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.
        /// </summary>
        public virtual TimeSpan? PodRunningTimeout { get; internal set; }
        /// <summary>
        ///   If true, print the logs for the previous instance of the container in a pod if it exists.
        /// </summary>
        public virtual bool? Previous { get; internal set; }
        /// <summary>
        ///   Selector (label query) to filter on.
        /// </summary>
        public virtual string Selector { get; internal set; }
        /// <summary>
        ///   Only return logs newer than a relative duration like 5s, 2m, or 3h. Defaults to all logs. Only one of since-time / since may be used.
        /// </summary>
        public virtual TimeSpan? Since { get; internal set; }
        /// <summary>
        ///   Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.
        /// </summary>
        public virtual string SinceTime { get; internal set; }
        /// <summary>
        ///   Lines of recent log file to display. Defaults to -1 with no selector, showing all log lines otherwise 10, if a selector is provided.
        /// </summary>
        public virtual long? Tail { get; internal set; }
        /// <summary>
        ///   Include timestamps on each line in the log output.
        /// </summary>
        public virtual bool? Timestamps { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("logs")
              .Add("{value}", TypeName, separator: ' ')
              .Add("--all-containers={value}", AllContainers)
              .Add("--container={value}", Container)
              .Add("--follow={value}", Follow)
              .Add("--interactive={value}", Interactive)
              .Add("--limit-bytes={value}", LimitBytes)
              .Add("--pod-running-timeout={value}", PodRunningTimeout)
              .Add("--previous={value}", Previous)
              .Add("--selector={value}", Selector)
              .Add("--since={value}", Since)
              .Add("--since-time={value}", SinceTime)
              .Add("--tail={value}", Tail)
              .Add("--timestamps={value}", Timestamps);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesCommonSettings
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class KubernetesCommonSettings : ToolSettings
    {
        /// <summary>
        ///   log to standard error as well as files.
        /// </summary>
        public virtual bool? Alsologtostderr { get; internal set; }
        /// <summary>
        ///   Username to impersonate for the operation.
        /// </summary>
        public virtual string As { get; internal set; }
        /// <summary>
        ///   Group to impersonate for the operation, this flag can be repeated to specify multiple groups.
        /// </summary>
        public virtual IReadOnlyList<string> AsGroup => AsGroupInternal.AsReadOnly();
        internal List<string> AsGroupInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Default HTTP cache directory.
        /// </summary>
        public virtual string CacheDir { get; internal set; }
        /// <summary>
        ///   Path to a cert file for the certificate authority.
        /// </summary>
        public virtual string CertificateAuthority { get; internal set; }
        /// <summary>
        ///   Path to a client certificate file for TLS.
        /// </summary>
        public virtual string ClientCertificate { get; internal set; }
        /// <summary>
        ///   Path to a client key file for TLS.
        /// </summary>
        public virtual string ClientKey { get; internal set; }
        /// <summary>
        ///   The name of the kubeconfig cluster to use.
        /// </summary>
        public virtual string Cluster { get; internal set; }
        /// <summary>
        ///   The name of the kubeconfig context to use.
        /// </summary>
        public virtual string Context { get; internal set; }
        /// <summary>
        ///   If true, the server's certificate will not be checked for validity. This will make your HTTPS connections insecure.
        /// </summary>
        public virtual bool? InsecureSkipTlsVerify { get; internal set; }
        /// <summary>
        ///   Path to the kubeconfig file to use for CLI requests.
        /// </summary>
        public virtual string Kubeconfig { get; internal set; }
        /// <summary>
        ///   when logging hits line file:N, emit a stack trace.
        /// </summary>
        public virtual string LogBacktraceAt { get; internal set; }
        /// <summary>
        ///   If non-empty, write log files in this directory.
        /// </summary>
        public virtual string LogDir { get; internal set; }
        /// <summary>
        ///   log to standard error instead of files.
        /// </summary>
        public virtual bool? Logtostderr { get; internal set; }
        /// <summary>
        ///   Require server version to match client version.
        /// </summary>
        public virtual bool? MatchServerVersion { get; internal set; }
        /// <summary>
        ///   If present, the namespace scope for this CLI request.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The length of time to wait before giving up on a single server request. Non-zero values should contain a corresponding time unit (e.g. 1s, 2m, 3h). A value of zero means don't timeout requests.
        /// </summary>
        public virtual string RequestTimeout { get; internal set; }
        /// <summary>
        ///   The address and port of the Kubernetes API server.
        /// </summary>
        public virtual string Server { get; internal set; }
        /// <summary>
        ///   logs at or above this threshold go to stderr.
        /// </summary>
        public virtual int? Stderrthreshold { get; internal set; }
        /// <summary>
        ///   Bearer token for authentication to the API server.
        /// </summary>
        public virtual string Token { get; internal set; }
        /// <summary>
        ///   The name of the kubeconfig user to use.
        /// </summary>
        public virtual string User { get; internal set; }
        /// <summary>
        ///   log level for V logs.
        /// </summary>
        public virtual int? V { get; internal set; }
        /// <summary>
        ///   comma-separated list of pattern=N settings for file-filtered logging.
        /// </summary>
        public virtual IReadOnlyDictionary<string, string> Vmodule => VmoduleInternal.AsReadOnly();
        internal Dictionary<string,string> VmoduleInternal { get; set; } = new Dictionary<string,string>(StringComparer.OrdinalIgnoreCase);
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("--alsologtostderr={value}", Alsologtostderr)
              .Add("--as={value}", As)
              .Add("--as-group={value}", AsGroup)
              .Add("--cache-dir={value}", CacheDir)
              .Add("--certificate-authority={value}", CertificateAuthority)
              .Add("--client-certificate={value}", ClientCertificate)
              .Add("--client-key={value}", ClientKey)
              .Add("--cluster={value}", Cluster)
              .Add("--context={value}", Context)
              .Add("--insecure-skip-tls-verify={value}", InsecureSkipTlsVerify)
              .Add("--kubeconfig={value}", Kubeconfig)
              .Add("--log-backtrace-at={value}", LogBacktraceAt)
              .Add("--log-dir={value}", LogDir)
              .Add("--logtostderr={value}", Logtostderr)
              .Add("--match-server-version={value}", MatchServerVersion)
              .Add("--namespace={value}", Namespace)
              .Add("--request-timeout={value}", RequestTimeout)
              .Add("--server={value}", Server)
              .Add("--stderrthreshold={value}", Stderrthreshold)
              .Add("--token={value}", Token)
              .Add("--user={value}", User)
              .Add("--v={value}", V)
              .Add("--vmodule={value}", Vmodule, "{key}={value}", separator: ',');
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region KubernetesApiResourcesSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesApiResourcesSettingsExtensions
    {
        #region ApiGroup
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.ApiGroup"/></em></p>
        ///   <p>Limit to resources in the specified API group.</p>
        /// </summary>
        [Pure]
        public static T SetApiGroup<T>(this T toolSettings, string apiGroup) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroup = apiGroup;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApiResourcesSettings.ApiGroup"/></em></p>
        ///   <p>Limit to resources in the specified API group.</p>
        /// </summary>
        [Pure]
        public static T ResetApiGroup<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroup = null;
            return toolSettings;
        }
        #endregion
        #region Cached
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.Cached"/></em></p>
        ///   <p>Use the cached list of resources if available.</p>
        /// </summary>
        [Pure]
        public static T SetCached<T>(this T toolSettings, bool? cached) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cached = cached;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApiResourcesSettings.Cached"/></em></p>
        ///   <p>Use the cached list of resources if available.</p>
        /// </summary>
        [Pure]
        public static T ResetCached<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cached = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApiResourcesSettings.Cached"/></em></p>
        ///   <p>Use the cached list of resources if available.</p>
        /// </summary>
        [Pure]
        public static T EnableCached<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cached = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApiResourcesSettings.Cached"/></em></p>
        ///   <p>Use the cached list of resources if available.</p>
        /// </summary>
        [Pure]
        public static T DisableCached<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cached = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApiResourcesSettings.Cached"/></em></p>
        ///   <p>Use the cached list of resources if available.</p>
        /// </summary>
        [Pure]
        public static T ToggleCached<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cached = !toolSettings.Cached;
            return toolSettings;
        }
        #endregion
        #region Namespaced
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.Namespaced"/></em></p>
        ///   <p>If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.</p>
        /// </summary>
        [Pure]
        public static T SetNamespaced<T>(this T toolSettings, bool? namespaced) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespaced = namespaced;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApiResourcesSettings.Namespaced"/></em></p>
        ///   <p>If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.</p>
        /// </summary>
        [Pure]
        public static T ResetNamespaced<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespaced = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApiResourcesSettings.Namespaced"/></em></p>
        ///   <p>If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.</p>
        /// </summary>
        [Pure]
        public static T EnableNamespaced<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespaced = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApiResourcesSettings.Namespaced"/></em></p>
        ///   <p>If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.</p>
        /// </summary>
        [Pure]
        public static T DisableNamespaced<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespaced = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApiResourcesSettings.Namespaced"/></em></p>
        ///   <p>If false, non-namespaced resources will be returned, otherwise returning namespaced resources by default.</p>
        /// </summary>
        [Pure]
        public static T ToggleNamespaced<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespaced = !toolSettings.Namespaced;
            return toolSettings;
        }
        #endregion
        #region NoHeaders
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T SetNoHeaders<T>(this T toolSettings, bool? noHeaders) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = noHeaders;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApiResourcesSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T ResetNoHeaders<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApiResourcesSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T EnableNoHeaders<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApiResourcesSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T DisableNoHeaders<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApiResourcesSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T ToggleNoHeaders<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = !toolSettings.NoHeaders;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.Output"/></em></p>
        ///   <p>Output format. One of: wide|name.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesApiResourcesOutput output) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApiResourcesSettings.Output"/></em></p>
        ///   <p>Output format. One of: wide|name.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Verbs
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.Verbs"/> to a new list</em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T SetVerbs<T>(this T toolSettings, params string[] verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VerbsInternal = verbs.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApiResourcesSettings.Verbs"/> to a new list</em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T SetVerbs<T>(this T toolSettings, IEnumerable<string> verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VerbsInternal = verbs.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApiResourcesSettings.Verbs"/></em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T AddVerbs<T>(this T toolSettings, params string[] verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VerbsInternal.AddRange(verbs);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApiResourcesSettings.Verbs"/></em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T AddVerbs<T>(this T toolSettings, IEnumerable<string> verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VerbsInternal.AddRange(verbs);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesApiResourcesSettings.Verbs"/></em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T ClearVerbs<T>(this T toolSettings) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VerbsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApiResourcesSettings.Verbs"/></em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T RemoveVerbs<T>(this T toolSettings, params string[] verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(verbs);
            toolSettings.VerbsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApiResourcesSettings.Verbs"/></em></p>
        ///   <p>Limit to resources that support the specified verbs.</p>
        /// </summary>
        [Pure]
        public static T RemoveVerbs<T>(this T toolSettings, IEnumerable<string> verbs) where T : KubernetesApiResourcesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(verbs);
            toolSettings.VerbsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesDrainSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesDrainSettingsExtensions
    {
        #region DeleteLocalData
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.DeleteLocalData"/></em></p>
        ///   <p>Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).</p>
        /// </summary>
        [Pure]
        public static T SetDeleteLocalData<T>(this T toolSettings, bool? deleteLocalData) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeleteLocalData = deleteLocalData;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.DeleteLocalData"/></em></p>
        ///   <p>Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).</p>
        /// </summary>
        [Pure]
        public static T ResetDeleteLocalData<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeleteLocalData = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDrainSettings.DeleteLocalData"/></em></p>
        ///   <p>Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).</p>
        /// </summary>
        [Pure]
        public static T EnableDeleteLocalData<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeleteLocalData = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDrainSettings.DeleteLocalData"/></em></p>
        ///   <p>Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).</p>
        /// </summary>
        [Pure]
        public static T DisableDeleteLocalData<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeleteLocalData = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDrainSettings.DeleteLocalData"/></em></p>
        ///   <p>Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).</p>
        /// </summary>
        [Pure]
        public static T ToggleDeleteLocalData<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeleteLocalData = !toolSettings.DeleteLocalData;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDrainSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDrainSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDrainSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.Force"/></em></p>
        ///   <p>Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.Force"/></em></p>
        ///   <p>Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDrainSettings.Force"/></em></p>
        ///   <p>Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDrainSettings.Force"/></em></p>
        ///   <p>Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDrainSettings.Force"/></em></p>
        ///   <p>Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region GracePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to each pod to terminate gracefully. If negative, the default value specified in the pod will be used.</p>
        /// </summary>
        [Pure]
        public static T SetGracePeriod<T>(this T toolSettings, int? gracePeriod) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = gracePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to each pod to terminate gracefully. If negative, the default value specified in the pod will be used.</p>
        /// </summary>
        [Pure]
        public static T ResetGracePeriod<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = null;
            return toolSettings;
        }
        #endregion
        #region IgnoreDaemonsets
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></em></p>
        ///   <p>Ignore DaemonSet-managed pods.</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreDaemonsets<T>(this T toolSettings, bool? ignoreDaemonsets) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreDaemonsets = ignoreDaemonsets;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></em></p>
        ///   <p>Ignore DaemonSet-managed pods.</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreDaemonsets<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreDaemonsets = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></em></p>
        ///   <p>Ignore DaemonSet-managed pods.</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreDaemonsets<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreDaemonsets = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></em></p>
        ///   <p>Ignore DaemonSet-managed pods.</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreDaemonsets<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreDaemonsets = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDrainSettings.IgnoreDaemonsets"/></em></p>
        ///   <p>Ignore DaemonSet-managed pods.</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreDaemonsets<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreDaemonsets = !toolSettings.IgnoreDaemonsets;
            return toolSettings;
        }
        #endregion
        #region PodSelector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.PodSelector"/></em></p>
        ///   <p>Label selector to filter pods on the node.</p>
        /// </summary>
        [Pure]
        public static T SetPodSelector<T>(this T toolSettings, string podSelector) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodSelector = podSelector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.PodSelector"/></em></p>
        ///   <p>Label selector to filter pods on the node.</p>
        /// </summary>
        [Pure]
        public static T ResetPodSelector<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodSelector = null;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDrainSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up, zero means infinite.</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDrainSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up, zero means infinite.</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesDrainSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesRunSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesRunSettingsExtensions
    {
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Name"/></em></p>
        ///   <p>The name of the container.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Name"/></em></p>
        ///   <p>The name of the container.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region Attach
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Attach"/></em></p>
        ///   <p>If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.</p>
        /// </summary>
        [Pure]
        public static T SetAttach<T>(this T toolSettings, bool? attach) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Attach = attach;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Attach"/></em></p>
        ///   <p>If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.</p>
        /// </summary>
        [Pure]
        public static T ResetAttach<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Attach = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Attach"/></em></p>
        ///   <p>If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.</p>
        /// </summary>
        [Pure]
        public static T EnableAttach<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Attach = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Attach"/></em></p>
        ///   <p>If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.</p>
        /// </summary>
        [Pure]
        public static T DisableAttach<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Attach = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Attach"/></em></p>
        ///   <p>If true, wait for the Pod to start running, and then attach to the Pod as if 'kubectl attach ...' were called.  Default false, unless '-i/--stdin' is set, in which case the default is true. With '--restart=Never' the exit code of the container process is returned.</p>
        /// </summary>
        [Pure]
        public static T ToggleAttach<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Attach = !toolSettings.Attach;
            return toolSettings;
        }
        #endregion
        #region Cascade
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T SetCascade<T>(this T toolSettings, bool? cascade) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = cascade;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ResetCascade<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T EnableCascade<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T DisableCascade<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ToggleCascade<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = !toolSettings.Cascade;
            return toolSettings;
        }
        #endregion
        #region Command
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Command"/></em></p>
        ///   <p>If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.</p>
        /// </summary>
        [Pure]
        public static T SetCommand<T>(this T toolSettings, bool? command) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Command = command;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Command"/></em></p>
        ///   <p>If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.</p>
        /// </summary>
        [Pure]
        public static T ResetCommand<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Command = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Command"/></em></p>
        ///   <p>If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.</p>
        /// </summary>
        [Pure]
        public static T EnableCommand<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Command = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Command"/></em></p>
        ///   <p>If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.</p>
        /// </summary>
        [Pure]
        public static T DisableCommand<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Command = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Command"/></em></p>
        ///   <p>If true and extra arguments are present, use them as the 'command' field in the container, rather than the 'args' field which is the default.</p>
        /// </summary>
        [Pure]
        public static T ToggleCommand<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Command = !toolSettings.Command;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Env
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Env"/> to a new list</em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T SetEnv<T>(this T toolSettings, params string[] env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnvInternal = env.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Env"/> to a new list</em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T SetEnv<T>(this T toolSettings, IEnumerable<string> env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnvInternal = env.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRunSettings.Env"/></em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T AddEnv<T>(this T toolSettings, params string[] env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnvInternal.AddRange(env);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRunSettings.Env"/></em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T AddEnv<T>(this T toolSettings, IEnumerable<string> env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnvInternal.AddRange(env);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesRunSettings.Env"/></em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T ClearEnv<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnvInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRunSettings.Env"/></em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T RemoveEnv<T>(this T toolSettings, params string[] env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(env);
            toolSettings.EnvInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRunSettings.Env"/></em></p>
        ///   <p>Environment variables to set in the container.</p>
        /// </summary>
        [Pure]
        public static T RemoveEnv<T>(this T toolSettings, IEnumerable<string> env) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(env);
            toolSettings.EnvInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Expose
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Expose"/></em></p>
        ///   <p>If true, a public, external service is created for the container(s) which are run.</p>
        /// </summary>
        [Pure]
        public static T SetExpose<T>(this T toolSettings, bool? expose) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Expose = expose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Expose"/></em></p>
        ///   <p>If true, a public, external service is created for the container(s) which are run.</p>
        /// </summary>
        [Pure]
        public static T ResetExpose<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Expose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Expose"/></em></p>
        ///   <p>If true, a public, external service is created for the container(s) which are run.</p>
        /// </summary>
        [Pure]
        public static T EnableExpose<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Expose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Expose"/></em></p>
        ///   <p>If true, a public, external service is created for the container(s) which are run.</p>
        /// </summary>
        [Pure]
        public static T DisableExpose<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Expose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Expose"/></em></p>
        ///   <p>If true, a public, external service is created for the container(s) which are run.</p>
        /// </summary>
        [Pure]
        public static T ToggleExpose<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Expose = !toolSettings.Expose;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Filename"/> to a new list</em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Filename"/> to a new list</em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRunSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRunSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesRunSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRunSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRunSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region Generator
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.</p>
        /// </summary>
        [Pure]
        public static T SetGenerator<T>(this T toolSettings, string generator) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = generator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.</p>
        /// </summary>
        [Pure]
        public static T ResetGenerator<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = null;
            return toolSettings;
        }
        #endregion
        #region GracePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T SetGracePeriod<T>(this T toolSettings, int? gracePeriod) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = gracePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T ResetGracePeriod<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = null;
            return toolSettings;
        }
        #endregion
        #region Hostport
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Hostport"/></em></p>
        ///   <p>The host port mapping for the container port. To demonstrate a single-machine container.</p>
        /// </summary>
        [Pure]
        public static T SetHostport<T>(this T toolSettings, int? hostport) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Hostport = hostport;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Hostport"/></em></p>
        ///   <p>The host port mapping for the container port. To demonstrate a single-machine container.</p>
        /// </summary>
        [Pure]
        public static T ResetHostport<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Hostport = null;
            return toolSettings;
        }
        #endregion
        #region Image
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Image"/></em></p>
        ///   <p>The image for the container to run.</p>
        /// </summary>
        [Pure]
        public static T SetImage<T>(this T toolSettings, string image) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Image = image;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Image"/></em></p>
        ///   <p>The image for the container to run.</p>
        /// </summary>
        [Pure]
        public static T ResetImage<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Image = null;
            return toolSettings;
        }
        #endregion
        #region ImagePullPolicy
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.ImagePullPolicy"/></em></p>
        ///   <p>The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server.</p>
        /// </summary>
        [Pure]
        public static T SetImagePullPolicy<T>(this T toolSettings, string imagePullPolicy) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ImagePullPolicy = imagePullPolicy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.ImagePullPolicy"/></em></p>
        ///   <p>The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server.</p>
        /// </summary>
        [Pure]
        public static T ResetImagePullPolicy<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ImagePullPolicy = null;
            return toolSettings;
        }
        #endregion
        #region Labels
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Labels"/></em></p>
        ///   <p>Comma separated labels to apply to the pod(s). Will override previous values.</p>
        /// </summary>
        [Pure]
        public static T SetLabels<T>(this T toolSettings, string labels) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Labels = labels;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Labels"/></em></p>
        ///   <p>Comma separated labels to apply to the pod(s). Will override previous values.</p>
        /// </summary>
        [Pure]
        public static T ResetLabels<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Labels = null;
            return toolSettings;
        }
        #endregion
        #region LeaveStdinOpen
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.LeaveStdinOpen"/></em></p>
        ///   <p>If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.</p>
        /// </summary>
        [Pure]
        public static T SetLeaveStdinOpen<T>(this T toolSettings, bool? leaveStdinOpen) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LeaveStdinOpen = leaveStdinOpen;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.LeaveStdinOpen"/></em></p>
        ///   <p>If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.</p>
        /// </summary>
        [Pure]
        public static T ResetLeaveStdinOpen<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LeaveStdinOpen = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.LeaveStdinOpen"/></em></p>
        ///   <p>If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.</p>
        /// </summary>
        [Pure]
        public static T EnableLeaveStdinOpen<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LeaveStdinOpen = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.LeaveStdinOpen"/></em></p>
        ///   <p>If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.</p>
        /// </summary>
        [Pure]
        public static T DisableLeaveStdinOpen<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LeaveStdinOpen = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.LeaveStdinOpen"/></em></p>
        ///   <p>If the pod is started in interactive mode or with stdin, leave stdin open after the first attach completes. By default, stdin will be closed after the first attach completes.</p>
        /// </summary>
        [Pure]
        public static T ToggleLeaveStdinOpen<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LeaveStdinOpen = !toolSettings.LeaveStdinOpen;
            return toolSettings;
        }
        #endregion
        #region Limits
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Limits"/></em></p>
        ///   <p>The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.</p>
        /// </summary>
        [Pure]
        public static T SetLimits<T>(this T toolSettings, string limits) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Limits = limits;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Limits"/></em></p>
        ///   <p>The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.</p>
        /// </summary>
        [Pure]
        public static T ResetLimits<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Limits = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesRunOutput output) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overrides
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Overrides"/></em></p>
        ///   <p>An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.</p>
        /// </summary>
        [Pure]
        public static T SetOverrides<T>(this T toolSettings, string overrides) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overrides = overrides;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Overrides"/></em></p>
        ///   <p>An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.</p>
        /// </summary>
        [Pure]
        public static T ResetOverrides<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overrides = null;
            return toolSettings;
        }
        #endregion
        #region PodRunningTimeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.PodRunningTimeout"/></em></p>
        ///   <p>The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.</p>
        /// </summary>
        [Pure]
        public static T SetPodRunningTimeout<T>(this T toolSettings, TimeSpan? podRunningTimeout) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodRunningTimeout = podRunningTimeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.PodRunningTimeout"/></em></p>
        ///   <p>The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.</p>
        /// </summary>
        [Pure]
        public static T ResetPodRunningTimeout<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodRunningTimeout = null;
            return toolSettings;
        }
        #endregion
        #region Port
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Port"/></em></p>
        ///   <p>The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.</p>
        /// </summary>
        [Pure]
        public static T SetPort<T>(this T toolSettings, string port) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = port;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Port"/></em></p>
        ///   <p>The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.</p>
        /// </summary>
        [Pure]
        public static T ResetPort<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = null;
            return toolSettings;
        }
        #endregion
        #region Quiet
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Quiet"/></em></p>
        ///   <p>If true, suppress prompt messages.</p>
        /// </summary>
        [Pure]
        public static T SetQuiet<T>(this T toolSettings, bool? quiet) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Quiet = quiet;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Quiet"/></em></p>
        ///   <p>If true, suppress prompt messages.</p>
        /// </summary>
        [Pure]
        public static T ResetQuiet<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Quiet = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Quiet"/></em></p>
        ///   <p>If true, suppress prompt messages.</p>
        /// </summary>
        [Pure]
        public static T EnableQuiet<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Quiet = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Quiet"/></em></p>
        ///   <p>If true, suppress prompt messages.</p>
        /// </summary>
        [Pure]
        public static T DisableQuiet<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Quiet = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Quiet"/></em></p>
        ///   <p>If true, suppress prompt messages.</p>
        /// </summary>
        [Pure]
        public static T ToggleQuiet<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Quiet = !toolSettings.Quiet;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Replicas
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Replicas"/></em></p>
        ///   <p>Number of replicas to create for this container. Default is 1.</p>
        /// </summary>
        [Pure]
        public static T SetReplicas<T>(this T toolSettings, int? replicas) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Replicas = replicas;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Replicas"/></em></p>
        ///   <p>Number of replicas to create for this container. Default is 1.</p>
        /// </summary>
        [Pure]
        public static T ResetReplicas<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Replicas = null;
            return toolSettings;
        }
        #endregion
        #region Requests
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Requests"/></em></p>
        ///   <p>The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.</p>
        /// </summary>
        [Pure]
        public static T SetRequests<T>(this T toolSettings, string requests) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Requests = requests;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Requests"/></em></p>
        ///   <p>The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.</p>
        /// </summary>
        [Pure]
        public static T ResetRequests<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Requests = null;
            return toolSettings;
        }
        #endregion
        #region Restart
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Restart"/></em></p>
        ///   <p>The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.</p>
        /// </summary>
        [Pure]
        public static T SetRestart<T>(this T toolSettings, string restart) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Restart = restart;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Restart"/></em></p>
        ///   <p>The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.</p>
        /// </summary>
        [Pure]
        public static T ResetRestart<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Restart = null;
            return toolSettings;
        }
        #endregion
        #region Rm
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Rm"/></em></p>
        ///   <p>If true, delete resources created in this command for attached containers.</p>
        /// </summary>
        [Pure]
        public static T SetRm<T>(this T toolSettings, bool? rm) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rm = rm;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Rm"/></em></p>
        ///   <p>If true, delete resources created in this command for attached containers.</p>
        /// </summary>
        [Pure]
        public static T ResetRm<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rm = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Rm"/></em></p>
        ///   <p>If true, delete resources created in this command for attached containers.</p>
        /// </summary>
        [Pure]
        public static T EnableRm<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rm = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Rm"/></em></p>
        ///   <p>If true, delete resources created in this command for attached containers.</p>
        /// </summary>
        [Pure]
        public static T DisableRm<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rm = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Rm"/></em></p>
        ///   <p>If true, delete resources created in this command for attached containers.</p>
        /// </summary>
        [Pure]
        public static T ToggleRm<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rm = !toolSettings.Rm;
            return toolSettings;
        }
        #endregion
        #region SaveConfig
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T SetSaveConfig<T>(this T toolSettings, bool? saveConfig) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = saveConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ResetSaveConfig<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T EnableSaveConfig<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T DisableSaveConfig<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ToggleSaveConfig<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = !toolSettings.SaveConfig;
            return toolSettings;
        }
        #endregion
        #region Schedule
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Schedule"/></em></p>
        ///   <p>A schedule in the Cron format the job should be run with.</p>
        /// </summary>
        [Pure]
        public static T SetSchedule<T>(this T toolSettings, string schedule) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Schedule = schedule;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Schedule"/></em></p>
        ///   <p>A schedule in the Cron format the job should be run with.</p>
        /// </summary>
        [Pure]
        public static T ResetSchedule<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Schedule = null;
            return toolSettings;
        }
        #endregion
        #region ServiceGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.ServiceGenerator"/></em></p>
        ///   <p>The name of the generator to use for creating a service.  Only used if --expose is true.</p>
        /// </summary>
        [Pure]
        public static T SetServiceGenerator<T>(this T toolSettings, string serviceGenerator) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceGenerator = serviceGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.ServiceGenerator"/></em></p>
        ///   <p>The name of the generator to use for creating a service.  Only used if --expose is true.</p>
        /// </summary>
        [Pure]
        public static T ResetServiceGenerator<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceGenerator = null;
            return toolSettings;
        }
        #endregion
        #region ServiceOverrides
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.ServiceOverrides"/></em></p>
        ///   <p>An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.</p>
        /// </summary>
        [Pure]
        public static T SetServiceOverrides<T>(this T toolSettings, string serviceOverrides) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceOverrides = serviceOverrides;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.ServiceOverrides"/></em></p>
        ///   <p>An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.</p>
        /// </summary>
        [Pure]
        public static T ResetServiceOverrides<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceOverrides = null;
            return toolSettings;
        }
        #endregion
        #region Serviceaccount
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Serviceaccount"/></em></p>
        ///   <p>Service account to set in the pod spec.</p>
        /// </summary>
        [Pure]
        public static T SetServiceaccount<T>(this T toolSettings, string serviceaccount) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Serviceaccount = serviceaccount;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Serviceaccount"/></em></p>
        ///   <p>Service account to set in the pod spec.</p>
        /// </summary>
        [Pure]
        public static T ResetServiceaccount<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Serviceaccount = null;
            return toolSettings;
        }
        #endregion
        #region Stdin
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Stdin"/></em></p>
        ///   <p>Keep stdin open on the container(s) in the pod, even if nothing is attached.</p>
        /// </summary>
        [Pure]
        public static T SetStdin<T>(this T toolSettings, bool? stdin) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = stdin;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Stdin"/></em></p>
        ///   <p>Keep stdin open on the container(s) in the pod, even if nothing is attached.</p>
        /// </summary>
        [Pure]
        public static T ResetStdin<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Stdin"/></em></p>
        ///   <p>Keep stdin open on the container(s) in the pod, even if nothing is attached.</p>
        /// </summary>
        [Pure]
        public static T EnableStdin<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Stdin"/></em></p>
        ///   <p>Keep stdin open on the container(s) in the pod, even if nothing is attached.</p>
        /// </summary>
        [Pure]
        public static T DisableStdin<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Stdin"/></em></p>
        ///   <p>Keep stdin open on the container(s) in the pod, even if nothing is attached.</p>
        /// </summary>
        [Pure]
        public static T ToggleStdin<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = !toolSettings.Stdin;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
        #region Tty
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Tty"/></em></p>
        ///   <p>Allocated a TTY for each container in the pod.</p>
        /// </summary>
        [Pure]
        public static T SetTty<T>(this T toolSettings, bool? tty) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = tty;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Tty"/></em></p>
        ///   <p>Allocated a TTY for each container in the pod.</p>
        /// </summary>
        [Pure]
        public static T ResetTty<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Tty"/></em></p>
        ///   <p>Allocated a TTY for each container in the pod.</p>
        /// </summary>
        [Pure]
        public static T EnableTty<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Tty"/></em></p>
        ///   <p>Allocated a TTY for each container in the pod.</p>
        /// </summary>
        [Pure]
        public static T DisableTty<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Tty"/></em></p>
        ///   <p>Allocated a TTY for each container in the pod.</p>
        /// </summary>
        [Pure]
        public static T ToggleTty<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = !toolSettings.Tty;
            return toolSettings;
        }
        #endregion
        #region Wait
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRunSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T SetWait<T>(this T toolSettings, bool? wait) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = wait;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRunSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ResetWait<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRunSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T EnableWait<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRunSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T DisableWait<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRunSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ToggleWait<T>(this T toolSettings) where T : KubernetesRunSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = !toolSettings.Wait;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesGetSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesGetSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesGetSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AllNamespaces
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T SetAllNamespaces<T>(this T toolSettings, bool? allNamespaces) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = allNamespaces;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T ResetAllNamespaces<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T EnableAllNamespaces<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T DisableAllNamespaces<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllNamespaces<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = !toolSettings.AllNamespaces;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region ChunkSize
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.ChunkSize"/></em></p>
        ///   <p>Return large lists in chunks rather than all at once. Pass 0 to disable. This flag is beta and may change in the future.</p>
        /// </summary>
        [Pure]
        public static T SetChunkSize<T>(this T toolSettings, long? chunkSize) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ChunkSize = chunkSize;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.ChunkSize"/></em></p>
        ///   <p>Return large lists in chunks rather than all at once. Pass 0 to disable. This flag is beta and may change in the future.</p>
        /// </summary>
        [Pure]
        public static T ResetChunkSize<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ChunkSize = null;
            return toolSettings;
        }
        #endregion
        #region Export
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Export"/></em></p>
        ///   <p>If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.</p>
        /// </summary>
        [Pure]
        public static T SetExport<T>(this T toolSettings, bool? export) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Export = export;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Export"/></em></p>
        ///   <p>If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.</p>
        /// </summary>
        [Pure]
        public static T ResetExport<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Export = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.Export"/></em></p>
        ///   <p>If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.</p>
        /// </summary>
        [Pure]
        public static T EnableExport<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Export = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.Export"/></em></p>
        ///   <p>If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.</p>
        /// </summary>
        [Pure]
        public static T DisableExport<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Export = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.Export"/></em></p>
        ///   <p>If true, use 'export' for the resources.  Exported resources are stripped of cluster-specific information.</p>
        /// </summary>
        [Pure]
        public static T ToggleExport<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Export = !toolSettings.Export;
            return toolSettings;
        }
        #endregion
        #region FieldSelector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T SetFieldSelector<T>(this T toolSettings, string fieldSelector) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = fieldSelector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T ResetFieldSelector<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = null;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesGetSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to get from a server.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region IgnoreNotFound
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.IgnoreNotFound"/></em></p>
        ///   <p>If the requested object does not exist the command will return exit code 0.</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreNotFound<T>(this T toolSettings, bool? ignoreNotFound) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = ignoreNotFound;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.IgnoreNotFound"/></em></p>
        ///   <p>If the requested object does not exist the command will return exit code 0.</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreNotFound<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.IgnoreNotFound"/></em></p>
        ///   <p>If the requested object does not exist the command will return exit code 0.</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreNotFound<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.IgnoreNotFound"/></em></p>
        ///   <p>If the requested object does not exist the command will return exit code 0.</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreNotFound<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.IgnoreNotFound"/></em></p>
        ///   <p>If the requested object does not exist the command will return exit code 0.</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreNotFound<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = !toolSettings.IgnoreNotFound;
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region LabelColumns
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.LabelColumns"/> to a new list</em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T SetLabelColumns<T>(this T toolSettings, params string[] labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelColumnsInternal = labelColumns.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.LabelColumns"/> to a new list</em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T SetLabelColumns<T>(this T toolSettings, IEnumerable<string> labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelColumnsInternal = labelColumns.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.LabelColumns"/></em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T AddLabelColumns<T>(this T toolSettings, params string[] labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelColumnsInternal.AddRange(labelColumns);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesGetSettings.LabelColumns"/></em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T AddLabelColumns<T>(this T toolSettings, IEnumerable<string> labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelColumnsInternal.AddRange(labelColumns);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesGetSettings.LabelColumns"/></em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T ClearLabelColumns<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelColumnsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.LabelColumns"/></em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T RemoveLabelColumns<T>(this T toolSettings, params string[] labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(labelColumns);
            toolSettings.LabelColumnsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesGetSettings.LabelColumns"/></em></p>
        ///   <p>Accepts a comma separated list of labels that are going to be presented as columns. Names are case-sensitive. You can also use multiple flag options like -L label1 -L label2...</p>
        /// </summary>
        [Pure]
        public static T RemoveLabelColumns<T>(this T toolSettings, IEnumerable<string> labelColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(labelColumns);
            toolSettings.LabelColumnsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region NoHeaders
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T SetNoHeaders<T>(this T toolSettings, bool? noHeaders) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = noHeaders;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T ResetNoHeaders<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T EnableNoHeaders<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T DisableNoHeaders<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.NoHeaders"/></em></p>
        ///   <p>When using the default or custom-column output format, don't print headers (default print headers).</p>
        /// </summary>
        [Pure]
        public static T ToggleNoHeaders<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoHeaders = !toolSettings.NoHeaders;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|wide|name|custom-columns=...|custom-columns-file=...|go-template=...|go-template-file=...|jsonpath=...|jsonpath-file=... See custom columns [http://kubernetes.io/docs/user-guide/kubectl-overview/#custom-columns], golang template [http://golang.org/pkg/text/template/#pkg-overview] and jsonpath template [http://kubernetes.io/docs/user-guide/jsonpath].</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesGetOutput output) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|wide|name|custom-columns=...|custom-columns-file=...|go-template=...|go-template-file=...|jsonpath=...|jsonpath-file=... See custom columns [http://kubernetes.io/docs/user-guide/kubectl-overview/#custom-columns], golang template [http://golang.org/pkg/text/template/#pkg-overview] and jsonpath template [http://kubernetes.io/docs/user-guide/jsonpath].</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Raw
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Raw"/></em></p>
        ///   <p>Raw URI to request from the server.  Uses the transport specified by the kubeconfig file.</p>
        /// </summary>
        [Pure]
        public static T SetRaw<T>(this T toolSettings, string raw) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Raw = raw;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Raw"/></em></p>
        ///   <p>Raw URI to request from the server.  Uses the transport specified by the kubeconfig file.</p>
        /// </summary>
        [Pure]
        public static T ResetRaw<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Raw = null;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region ServerPrint
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.ServerPrint"/></em></p>
        ///   <p>If true, have the server return the appropriate table output. Supports extension APIs and CRDs.</p>
        /// </summary>
        [Pure]
        public static T SetServerPrint<T>(this T toolSettings, bool? serverPrint) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServerPrint = serverPrint;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.ServerPrint"/></em></p>
        ///   <p>If true, have the server return the appropriate table output. Supports extension APIs and CRDs.</p>
        /// </summary>
        [Pure]
        public static T ResetServerPrint<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServerPrint = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.ServerPrint"/></em></p>
        ///   <p>If true, have the server return the appropriate table output. Supports extension APIs and CRDs.</p>
        /// </summary>
        [Pure]
        public static T EnableServerPrint<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServerPrint = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.ServerPrint"/></em></p>
        ///   <p>If true, have the server return the appropriate table output. Supports extension APIs and CRDs.</p>
        /// </summary>
        [Pure]
        public static T DisableServerPrint<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServerPrint = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.ServerPrint"/></em></p>
        ///   <p>If true, have the server return the appropriate table output. Supports extension APIs and CRDs.</p>
        /// </summary>
        [Pure]
        public static T ToggleServerPrint<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServerPrint = !toolSettings.ServerPrint;
            return toolSettings;
        }
        #endregion
        #region ShowAll
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.ShowAll"/></em></p>
        ///   <p>When printing, show all resources (default show all pods including terminated one.).</p>
        /// </summary>
        [Pure]
        public static T SetShowAll<T>(this T toolSettings, bool? showAll) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowAll = showAll;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.ShowAll"/></em></p>
        ///   <p>When printing, show all resources (default show all pods including terminated one.).</p>
        /// </summary>
        [Pure]
        public static T ResetShowAll<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowAll = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.ShowAll"/></em></p>
        ///   <p>When printing, show all resources (default show all pods including terminated one.).</p>
        /// </summary>
        [Pure]
        public static T EnableShowAll<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowAll = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.ShowAll"/></em></p>
        ///   <p>When printing, show all resources (default show all pods including terminated one.).</p>
        /// </summary>
        [Pure]
        public static T DisableShowAll<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowAll = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.ShowAll"/></em></p>
        ///   <p>When printing, show all resources (default show all pods including terminated one.).</p>
        /// </summary>
        [Pure]
        public static T ToggleShowAll<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowAll = !toolSettings.ShowAll;
            return toolSettings;
        }
        #endregion
        #region ShowKind
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.ShowKind"/></em></p>
        ///   <p>If present, list the resource type for the requested object(s).</p>
        /// </summary>
        [Pure]
        public static T SetShowKind<T>(this T toolSettings, bool? showKind) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowKind = showKind;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.ShowKind"/></em></p>
        ///   <p>If present, list the resource type for the requested object(s).</p>
        /// </summary>
        [Pure]
        public static T ResetShowKind<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowKind = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.ShowKind"/></em></p>
        ///   <p>If present, list the resource type for the requested object(s).</p>
        /// </summary>
        [Pure]
        public static T EnableShowKind<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowKind = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.ShowKind"/></em></p>
        ///   <p>If present, list the resource type for the requested object(s).</p>
        /// </summary>
        [Pure]
        public static T DisableShowKind<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowKind = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.ShowKind"/></em></p>
        ///   <p>If present, list the resource type for the requested object(s).</p>
        /// </summary>
        [Pure]
        public static T ToggleShowKind<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowKind = !toolSettings.ShowKind;
            return toolSettings;
        }
        #endregion
        #region ShowLabels
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.ShowLabels"/></em></p>
        ///   <p>When printing, show all labels as the last column (default hide labels column).</p>
        /// </summary>
        [Pure]
        public static T SetShowLabels<T>(this T toolSettings, bool? showLabels) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowLabels = showLabels;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.ShowLabels"/></em></p>
        ///   <p>When printing, show all labels as the last column (default hide labels column).</p>
        /// </summary>
        [Pure]
        public static T ResetShowLabels<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowLabels = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.ShowLabels"/></em></p>
        ///   <p>When printing, show all labels as the last column (default hide labels column).</p>
        /// </summary>
        [Pure]
        public static T EnableShowLabels<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowLabels = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.ShowLabels"/></em></p>
        ///   <p>When printing, show all labels as the last column (default hide labels column).</p>
        /// </summary>
        [Pure]
        public static T DisableShowLabels<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowLabels = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.ShowLabels"/></em></p>
        ///   <p>When printing, show all labels as the last column (default hide labels column).</p>
        /// </summary>
        [Pure]
        public static T ToggleShowLabels<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowLabels = !toolSettings.ShowLabels;
            return toolSettings;
        }
        #endregion
        #region SortBy
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.SortBy"/></em></p>
        ///   <p>If non-empty, sort list types using this field specification.  The field specification is expressed as a JSONPath expression (e.g. '{.metadata.name}'). The field in the API resource specified by this JSONPath expression must be an integer or a string.</p>
        /// </summary>
        [Pure]
        public static T SetSortBy<T>(this T toolSettings, string sortBy) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SortBy = sortBy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.SortBy"/></em></p>
        ///   <p>If non-empty, sort list types using this field specification.  The field specification is expressed as a JSONPath expression (e.g. '{.metadata.name}'). The field in the API resource specified by this JSONPath expression must be an integer or a string.</p>
        /// </summary>
        [Pure]
        public static T ResetSortBy<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SortBy = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region UseOpenapiPrintColumns
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></em></p>
        ///   <p>If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.</p>
        /// </summary>
        [Pure]
        public static T SetUseOpenapiPrintColumns<T>(this T toolSettings, bool? useOpenapiPrintColumns) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseOpenapiPrintColumns = useOpenapiPrintColumns;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></em></p>
        ///   <p>If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.</p>
        /// </summary>
        [Pure]
        public static T ResetUseOpenapiPrintColumns<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseOpenapiPrintColumns = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></em></p>
        ///   <p>If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.</p>
        /// </summary>
        [Pure]
        public static T EnableUseOpenapiPrintColumns<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseOpenapiPrintColumns = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></em></p>
        ///   <p>If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.</p>
        /// </summary>
        [Pure]
        public static T DisableUseOpenapiPrintColumns<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseOpenapiPrintColumns = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.UseOpenapiPrintColumns"/></em></p>
        ///   <p>If true, use x-kubernetes-print-column metadata (if present) from the OpenAPI schema for displaying a resource.</p>
        /// </summary>
        [Pure]
        public static T ToggleUseOpenapiPrintColumns<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseOpenapiPrintColumns = !toolSettings.UseOpenapiPrintColumns;
            return toolSettings;
        }
        #endregion
        #region Watch
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.Watch"/></em></p>
        ///   <p>After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.</p>
        /// </summary>
        [Pure]
        public static T SetWatch<T>(this T toolSettings, bool? watch) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Watch = watch;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.Watch"/></em></p>
        ///   <p>After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.</p>
        /// </summary>
        [Pure]
        public static T ResetWatch<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Watch = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.Watch"/></em></p>
        ///   <p>After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.</p>
        /// </summary>
        [Pure]
        public static T EnableWatch<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Watch = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.Watch"/></em></p>
        ///   <p>After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.</p>
        /// </summary>
        [Pure]
        public static T DisableWatch<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Watch = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.Watch"/></em></p>
        ///   <p>After listing/getting the requested object, watch for changes. Uninitialized objects are excluded if no object name is provided.</p>
        /// </summary>
        [Pure]
        public static T ToggleWatch<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Watch = !toolSettings.Watch;
            return toolSettings;
        }
        #endregion
        #region WatchOnly
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesGetSettings.WatchOnly"/></em></p>
        ///   <p>Watch for changes to the requested object(s), without listing/getting first.</p>
        /// </summary>
        [Pure]
        public static T SetWatchOnly<T>(this T toolSettings, bool? watchOnly) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WatchOnly = watchOnly;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesGetSettings.WatchOnly"/></em></p>
        ///   <p>Watch for changes to the requested object(s), without listing/getting first.</p>
        /// </summary>
        [Pure]
        public static T ResetWatchOnly<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WatchOnly = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesGetSettings.WatchOnly"/></em></p>
        ///   <p>Watch for changes to the requested object(s), without listing/getting first.</p>
        /// </summary>
        [Pure]
        public static T EnableWatchOnly<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WatchOnly = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesGetSettings.WatchOnly"/></em></p>
        ///   <p>Watch for changes to the requested object(s), without listing/getting first.</p>
        /// </summary>
        [Pure]
        public static T DisableWatchOnly<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WatchOnly = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesGetSettings.WatchOnly"/></em></p>
        ///   <p>Watch for changes to the requested object(s), without listing/getting first.</p>
        /// </summary>
        [Pure]
        public static T ToggleWatchOnly<T>(this T toolSettings) where T : KubernetesGetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WatchOnly = !toolSettings.WatchOnly;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesVersionSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesVersionSettingsExtensions
    {
        #region Client
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesVersionSettings.Client"/></em></p>
        ///   <p>Client version only (no server required).</p>
        /// </summary>
        [Pure]
        public static T SetClient<T>(this T toolSettings, bool? client) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Client = client;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesVersionSettings.Client"/></em></p>
        ///   <p>Client version only (no server required).</p>
        /// </summary>
        [Pure]
        public static T ResetClient<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Client = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesVersionSettings.Client"/></em></p>
        ///   <p>Client version only (no server required).</p>
        /// </summary>
        [Pure]
        public static T EnableClient<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Client = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesVersionSettings.Client"/></em></p>
        ///   <p>Client version only (no server required).</p>
        /// </summary>
        [Pure]
        public static T DisableClient<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Client = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesVersionSettings.Client"/></em></p>
        ///   <p>Client version only (no server required).</p>
        /// </summary>
        [Pure]
        public static T ToggleClient<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Client = !toolSettings.Client;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesVersionSettings.Output"/></em></p>
        ///   <p>One of 'yaml' or 'json'.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesVersionSettings.Output"/></em></p>
        ///   <p>One of 'yaml' or 'json'.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Short
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesVersionSettings.Short"/></em></p>
        ///   <p>Print just the version number.</p>
        /// </summary>
        [Pure]
        public static T SetShort<T>(this T toolSettings, bool? @short) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Short = @short;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesVersionSettings.Short"/></em></p>
        ///   <p>Print just the version number.</p>
        /// </summary>
        [Pure]
        public static T ResetShort<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Short = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesVersionSettings.Short"/></em></p>
        ///   <p>Print just the version number.</p>
        /// </summary>
        [Pure]
        public static T EnableShort<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Short = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesVersionSettings.Short"/></em></p>
        ///   <p>Print just the version number.</p>
        /// </summary>
        [Pure]
        public static T DisableShort<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Short = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesVersionSettings.Short"/></em></p>
        ///   <p>Print just the version number.</p>
        /// </summary>
        [Pure]
        public static T ToggleShort<T>(this T toolSettings) where T : KubernetesVersionSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Short = !toolSettings.Short;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesTopSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesTopSettingsExtensions
    {
    }
    #endregion
    #region KubernetesConfigSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesConfigSettingsExtensions
    {
    }
    #endregion
    #region KubernetesExecSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesExecSettingsExtensions
    {
        #region PodName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExecSettings.PodName"/></em></p>
        ///   <p>The name of the pod.</p>
        /// </summary>
        [Pure]
        public static T SetPodName<T>(this T toolSettings, string podName) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodName = podName;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExecSettings.PodName"/></em></p>
        ///   <p>The name of the pod.</p>
        /// </summary>
        [Pure]
        public static T ResetPodName<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodName = null;
            return toolSettings;
        }
        #endregion
        #region Container
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExecSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T SetContainer<T>(this T toolSettings, string container) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = container;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExecSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T ResetContainer<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = null;
            return toolSettings;
        }
        #endregion
        #region Pod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExecSettings.Pod"/></em></p>
        ///   <p>Pod name.</p>
        /// </summary>
        [Pure]
        public static T SetPod<T>(this T toolSettings, string pod) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Pod = pod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExecSettings.Pod"/></em></p>
        ///   <p>Pod name.</p>
        /// </summary>
        [Pure]
        public static T ResetPod<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Pod = null;
            return toolSettings;
        }
        #endregion
        #region Stdin
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExecSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T SetStdin<T>(this T toolSettings, bool? stdin) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = stdin;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExecSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T ResetStdin<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExecSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T EnableStdin<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExecSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T DisableStdin<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExecSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T ToggleStdin<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = !toolSettings.Stdin;
            return toolSettings;
        }
        #endregion
        #region Tty
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExecSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T SetTty<T>(this T toolSettings, bool? tty) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = tty;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExecSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T ResetTty<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExecSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T EnableTty<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExecSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T DisableTty<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExecSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T ToggleTty<T>(this T toolSettings) where T : KubernetesExecSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = !toolSettings.Tty;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesRollingUpdateSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesRollingUpdateSettingsExtensions
    {
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRollingUpdateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region Container
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Container"/></em></p>
        ///   <p>Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod.</p>
        /// </summary>
        [Pure]
        public static T SetContainer<T>(this T toolSettings, string container) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = container;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Container"/></em></p>
        ///   <p>Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod.</p>
        /// </summary>
        [Pure]
        public static T ResetContainer<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = null;
            return toolSettings;
        }
        #endregion
        #region DeploymentLabelKey
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.DeploymentLabelKey"/></em></p>
        ///   <p>The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise.</p>
        /// </summary>
        [Pure]
        public static T SetDeploymentLabelKey<T>(this T toolSettings, string deploymentLabelKey) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeploymentLabelKey = deploymentLabelKey;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.DeploymentLabelKey"/></em></p>
        ///   <p>The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise.</p>
        /// </summary>
        [Pure]
        public static T ResetDeploymentLabelKey<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DeploymentLabelKey = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRollingUpdateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRollingUpdateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRollingUpdateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRollingUpdateSettings.Filename"/></em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRollingUpdateSettings.Filename"/></em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesRollingUpdateSettings.Filename"/></em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRollingUpdateSettings.Filename"/></em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRollingUpdateSettings.Filename"/></em></p>
        ///   <p>Filename or URL to file to use to create the new replication controller.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Image
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Image"/></em></p>
        ///   <p>Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f.</p>
        /// </summary>
        [Pure]
        public static T SetImage<T>(this T toolSettings, string image) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Image = image;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Image"/></em></p>
        ///   <p>Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f.</p>
        /// </summary>
        [Pure]
        public static T ResetImage<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Image = null;
            return toolSettings;
        }
        #endregion
        #region ImagePullPolicy
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.ImagePullPolicy"/></em></p>
        ///   <p>Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.</p>
        /// </summary>
        [Pure]
        public static T SetImagePullPolicy<T>(this T toolSettings, string imagePullPolicy) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ImagePullPolicy = imagePullPolicy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.ImagePullPolicy"/></em></p>
        ///   <p>Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.</p>
        /// </summary>
        [Pure]
        public static T ResetImagePullPolicy<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ImagePullPolicy = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|go-template-file|templatefile|template|go-template|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesRollingUpdateOutput output) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|go-template-file|templatefile|template|go-template|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region PollInterval
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.PollInterval"/></em></p>
        ///   <p>Time delay between polling for replication controller status after the update. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T SetPollInterval<T>(this T toolSettings, TimeSpan? pollInterval) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PollInterval = pollInterval;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.PollInterval"/></em></p>
        ///   <p>Time delay between polling for replication controller status after the update. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T ResetPollInterval<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PollInterval = null;
            return toolSettings;
        }
        #endregion
        #region Rollback
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Rollback"/></em></p>
        ///   <p>If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.</p>
        /// </summary>
        [Pure]
        public static T SetRollback<T>(this T toolSettings, bool? rollback) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rollback = rollback;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Rollback"/></em></p>
        ///   <p>If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.</p>
        /// </summary>
        [Pure]
        public static T ResetRollback<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rollback = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRollingUpdateSettings.Rollback"/></em></p>
        ///   <p>If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.</p>
        /// </summary>
        [Pure]
        public static T EnableRollback<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rollback = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRollingUpdateSettings.Rollback"/></em></p>
        ///   <p>If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.</p>
        /// </summary>
        [Pure]
        public static T DisableRollback<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rollback = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRollingUpdateSettings.Rollback"/></em></p>
        ///   <p>If true, this is a request to abort an existing rollout that is partially rolled out. It effectively reverses current and next and runs a rollout.</p>
        /// </summary>
        [Pure]
        public static T ToggleRollback<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Rollback = !toolSettings.Rollback;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Timeout"/></em></p>
        ///   <p>Max time to wait for a replication controller to update before giving up. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Timeout"/></em></p>
        ///   <p>Max time to wait for a replication controller to update before giving up. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
        #region UpdatePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.UpdatePeriod"/></em></p>
        ///   <p>Time to wait between updating pods. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T SetUpdatePeriod<T>(this T toolSettings, TimeSpan? updatePeriod) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UpdatePeriod = updatePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.UpdatePeriod"/></em></p>
        ///   <p>Time to wait between updating pods. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".</p>
        /// </summary>
        [Pure]
        public static T ResetUpdatePeriod<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UpdatePeriod = null;
            return toolSettings;
        }
        #endregion
        #region Validate
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRollingUpdateSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T SetValidate<T>(this T toolSettings, bool? validate) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = validate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesRollingUpdateSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetValidate<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesRollingUpdateSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableValidate<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesRollingUpdateSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableValidate<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesRollingUpdateSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleValidate<T>(this T toolSettings) where T : KubernetesRollingUpdateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = !toolSettings.Validate;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesLabelSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesLabelSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesLabelSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesLabelSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesLabelSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesLabelSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesLabelSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Labels
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Labels"/> to a new dictionary</em></p>
        ///   <p>The Labels to set.</p>
        /// </summary>
        [Pure]
        public static T SetLabels<T>(this T toolSettings, IDictionary<string, string> labels) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelsInternal = labels.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesLabelSettings.Labels"/></em></p>
        ///   <p>The Labels to set.</p>
        /// </summary>
        [Pure]
        public static T ClearLabels<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="KubernetesLabelSettings.Labels"/></em></p>
        ///   <p>The Labels to set.</p>
        /// </summary>
        [Pure]
        public static T AddLabel<T>(this T toolSettings, string labelKey, string labelValue) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelsInternal.Add(labelKey, labelValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="KubernetesLabelSettings.Labels"/></em></p>
        ///   <p>The Labels to set.</p>
        /// </summary>
        [Pure]
        public static T RemoveLabel<T>(this T toolSettings, string labelKey) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelsInternal.Remove(labelKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="KubernetesLabelSettings.Labels"/></em></p>
        ///   <p>The Labels to set.</p>
        /// </summary>
        [Pure]
        public static T SetLabel<T>(this T toolSettings, string labelKey, string labelValue) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LabelsInternal[labelKey] = labelValue;
            return toolSettings;
        }
        #endregion
        #region All
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T SetAll<T>(this T toolSettings, bool? all) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = all;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ResetAll<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T EnableAll<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T DisableAll<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ToggleAll<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = !toolSettings.All;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region FieldSelector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T SetFieldSelector<T>(this T toolSettings, string fieldSelector) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = fieldSelector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T ResetFieldSelector<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = null;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesLabelSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesLabelSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesLabelSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesLabelSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesLabelSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the labels.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region List
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.List"/></em></p>
        ///   <p>If true, display the labels for a given resource.</p>
        /// </summary>
        [Pure]
        public static T SetList<T>(this T toolSettings, bool? list) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.List = list;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.List"/></em></p>
        ///   <p>If true, display the labels for a given resource.</p>
        /// </summary>
        [Pure]
        public static T ResetList<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.List = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.List"/></em></p>
        ///   <p>If true, display the labels for a given resource.</p>
        /// </summary>
        [Pure]
        public static T EnableList<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.List = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.List"/></em></p>
        ///   <p>If true, display the labels for a given resource.</p>
        /// </summary>
        [Pure]
        public static T DisableList<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.List = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.List"/></em></p>
        ///   <p>If true, display the labels for a given resource.</p>
        /// </summary>
        [Pure]
        public static T ToggleList<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.List = !toolSettings.List;
            return toolSettings;
        }
        #endregion
        #region Local
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Local"/></em></p>
        ///   <p>If true, label will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T SetLocal<T>(this T toolSettings, bool? local) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = local;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Local"/></em></p>
        ///   <p>If true, label will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T ResetLocal<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.Local"/></em></p>
        ///   <p>If true, label will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T EnableLocal<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.Local"/></em></p>
        ///   <p>If true, label will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T DisableLocal<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.Local"/></em></p>
        ///   <p>If true, label will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T ToggleLocal<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = !toolSettings.Local;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesLabelOutput output) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overwrite
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Overwrite"/></em></p>
        ///   <p>If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.</p>
        /// </summary>
        [Pure]
        public static T SetOverwrite<T>(this T toolSettings, bool? overwrite) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = overwrite;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Overwrite"/></em></p>
        ///   <p>If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.</p>
        /// </summary>
        [Pure]
        public static T ResetOverwrite<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.Overwrite"/></em></p>
        ///   <p>If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.</p>
        /// </summary>
        [Pure]
        public static T EnableOverwrite<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.Overwrite"/></em></p>
        ///   <p>If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.</p>
        /// </summary>
        [Pure]
        public static T DisableOverwrite<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.Overwrite"/></em></p>
        ///   <p>If true, allow labels to be overwritten, otherwise reject label updates that overwrite existing labels.</p>
        /// </summary>
        [Pure]
        public static T ToggleOverwrite<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = !toolSettings.Overwrite;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesLabelSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesLabelSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesLabelSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region ResourceVersion
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.ResourceVersion"/></em></p>
        ///   <p>If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.</p>
        /// </summary>
        [Pure]
        public static T SetResourceVersion<T>(this T toolSettings, string resourceVersion) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResourceVersion = resourceVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.ResourceVersion"/></em></p>
        ///   <p>If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.</p>
        /// </summary>
        [Pure]
        public static T ResetResourceVersion<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResourceVersion = null;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesLabelSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesLabelSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesLabelSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesAnnotateSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesAnnotateSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAnnotateSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAnnotateSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesAnnotateSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAnnotateSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAnnotateSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Annotations
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Annotations"/> to a new dictionary</em></p>
        ///   <p>The annotations to set on the ressource</p>
        /// </summary>
        [Pure]
        public static T SetAnnotations<T>(this T toolSettings, IDictionary<string, string> annotations) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnnotationsInternal = annotations.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesAnnotateSettings.Annotations"/></em></p>
        ///   <p>The annotations to set on the ressource</p>
        /// </summary>
        [Pure]
        public static T ClearAnnotations<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnnotationsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="KubernetesAnnotateSettings.Annotations"/></em></p>
        ///   <p>The annotations to set on the ressource</p>
        /// </summary>
        [Pure]
        public static T AddAnnotation<T>(this T toolSettings, string annotationKey, string annotationValue) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnnotationsInternal.Add(annotationKey, annotationValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="KubernetesAnnotateSettings.Annotations"/></em></p>
        ///   <p>The annotations to set on the ressource</p>
        /// </summary>
        [Pure]
        public static T RemoveAnnotation<T>(this T toolSettings, string annotationKey) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnnotationsInternal.Remove(annotationKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="KubernetesAnnotateSettings.Annotations"/></em></p>
        ///   <p>The annotations to set on the ressource</p>
        /// </summary>
        [Pure]
        public static T SetAnnotation<T>(this T toolSettings, string annotationKey, string annotationValue) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnnotationsInternal[annotationKey] = annotationValue;
            return toolSettings;
        }
        #endregion
        #region All
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T SetAll<T>(this T toolSettings, bool? all) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = all;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ResetAll<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T EnableAll<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T DisableAll<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.All"/></em></p>
        ///   <p>Select all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ToggleAll<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = !toolSettings.All;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region FieldSelector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T SetFieldSelector<T>(this T toolSettings, string fieldSelector) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = fieldSelector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T ResetFieldSelector<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = null;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAnnotateSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAnnotateSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesAnnotateSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAnnotateSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAnnotateSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update the annotation.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region Local
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Local"/></em></p>
        ///   <p>If true, annotation will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T SetLocal<T>(this T toolSettings, bool? local) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = local;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Local"/></em></p>
        ///   <p>If true, annotation will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T ResetLocal<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.Local"/></em></p>
        ///   <p>If true, annotation will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T EnableLocal<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.Local"/></em></p>
        ///   <p>If true, annotation will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T DisableLocal<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.Local"/></em></p>
        ///   <p>If true, annotation will NOT contact api-server but run locally.</p>
        /// </summary>
        [Pure]
        public static T ToggleLocal<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = !toolSettings.Local;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesAnnotateOutput output) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|templatefile|template|go-template|go-template-file|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overwrite
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Overwrite"/></em></p>
        ///   <p>If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.</p>
        /// </summary>
        [Pure]
        public static T SetOverwrite<T>(this T toolSettings, bool? overwrite) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = overwrite;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Overwrite"/></em></p>
        ///   <p>If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.</p>
        /// </summary>
        [Pure]
        public static T ResetOverwrite<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.Overwrite"/></em></p>
        ///   <p>If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.</p>
        /// </summary>
        [Pure]
        public static T EnableOverwrite<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.Overwrite"/></em></p>
        ///   <p>If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.</p>
        /// </summary>
        [Pure]
        public static T DisableOverwrite<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.Overwrite"/></em></p>
        ///   <p>If true, allow annotations to be overwritten, otherwise reject annotation updates that overwrite existing annotations.</p>
        /// </summary>
        [Pure]
        public static T ToggleOverwrite<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = !toolSettings.Overwrite;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAnnotateSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAnnotateSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAnnotateSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region ResourceVersion
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.ResourceVersion"/></em></p>
        ///   <p>If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.</p>
        /// </summary>
        [Pure]
        public static T SetResourceVersion<T>(this T toolSettings, string resourceVersion) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResourceVersion = resourceVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.ResourceVersion"/></em></p>
        ///   <p>If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.</p>
        /// </summary>
        [Pure]
        public static T ResetResourceVersion<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResourceVersion = null;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAnnotateSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAnnotateSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesAnnotateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesDeleteSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesDeleteSettingsExtensions
    {
        #region All
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.All"/></em></p>
        ///   <p>Delete all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T SetAll<T>(this T toolSettings, bool? all) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = all;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.All"/></em></p>
        ///   <p>Delete all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ResetAll<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.All"/></em></p>
        ///   <p>Delete all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T EnableAll<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.All"/></em></p>
        ///   <p>Delete all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T DisableAll<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.All"/></em></p>
        ///   <p>Delete all resources, including uninitialized ones, in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ToggleAll<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = !toolSettings.All;
            return toolSettings;
        }
        #endregion
        #region Cascade
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T SetCascade<T>(this T toolSettings, bool? cascade) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = cascade;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ResetCascade<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T EnableCascade<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T DisableCascade<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ToggleCascade<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = !toolSettings.Cascade;
            return toolSettings;
        }
        #endregion
        #region FieldSelector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T SetFieldSelector<T>(this T toolSettings, string fieldSelector) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = fieldSelector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.FieldSelector"/></em></p>
        ///   <p>Selector (field query) to filter on, supports '=', '==', and '!='.(e.g. --field-selector key1=value1,key2=value2). The server only supports a limited number of field queries per type.</p>
        /// </summary>
        [Pure]
        public static T ResetFieldSelector<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FieldSelector = null;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Filename"/> to a new list</em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Filename"/> to a new list</em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDeleteSettings.Filename"/></em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDeleteSettings.Filename"/></em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesDeleteSettings.Filename"/></em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDeleteSettings.Filename"/></em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDeleteSettings.Filename"/></em></p>
        ///   <p>containing the resource to delete.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region GracePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T SetGracePeriod<T>(this T toolSettings, int? gracePeriod) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = gracePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T ResetGracePeriod<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = null;
            return toolSettings;
        }
        #endregion
        #region IgnoreNotFound
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></em></p>
        ///   <p>Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreNotFound<T>(this T toolSettings, bool? ignoreNotFound) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = ignoreNotFound;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></em></p>
        ///   <p>Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreNotFound<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></em></p>
        ///   <p>Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreNotFound<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></em></p>
        ///   <p>Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreNotFound<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.IgnoreNotFound"/></em></p>
        ///   <p>Treat "resource not found" as a successful delete. Defaults to "true" when --all is specified.</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreNotFound<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreNotFound = !toolSettings.IgnoreNotFound;
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region Now
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Now"/></em></p>
        ///   <p>If true, resources are signaled for immediate shutdown (same as --grace-period=1).</p>
        /// </summary>
        [Pure]
        public static T SetNow<T>(this T toolSettings, bool? now) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Now = now;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Now"/></em></p>
        ///   <p>If true, resources are signaled for immediate shutdown (same as --grace-period=1).</p>
        /// </summary>
        [Pure]
        public static T ResetNow<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Now = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.Now"/></em></p>
        ///   <p>If true, resources are signaled for immediate shutdown (same as --grace-period=1).</p>
        /// </summary>
        [Pure]
        public static T EnableNow<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Now = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.Now"/></em></p>
        ///   <p>If true, resources are signaled for immediate shutdown (same as --grace-period=1).</p>
        /// </summary>
        [Pure]
        public static T DisableNow<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Now = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.Now"/></em></p>
        ///   <p>If true, resources are signaled for immediate shutdown (same as --grace-period=1).</p>
        /// </summary>
        [Pure]
        public static T ToggleNow<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Now = !toolSettings.Now;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Output"/></em></p>
        ///   <p>Output mode. Use "-o name" for shorter output (resource/name).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Output"/></em></p>
        ///   <p>Output mode. Use "-o name" for shorter output (resource/name).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones.</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, not including uninitialized ones.</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
        #region Wait
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDeleteSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T SetWait<T>(this T toolSettings, bool? wait) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = wait;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDeleteSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ResetWait<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDeleteSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T EnableWait<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDeleteSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T DisableWait<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDeleteSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ToggleWait<T>(this T toolSettings) where T : KubernetesDeleteSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = !toolSettings.Wait;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesExposeSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesExposeSettingsExtensions
    {
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExposeSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region ClusterIp
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.ClusterIp"/></em></p>
        ///   <p>ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.</p>
        /// </summary>
        [Pure]
        public static T SetClusterIp<T>(this T toolSettings, string clusterIp) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClusterIp = clusterIp;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.ClusterIp"/></em></p>
        ///   <p>ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.</p>
        /// </summary>
        [Pure]
        public static T ResetClusterIp<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClusterIp = null;
            return toolSettings;
        }
        #endregion
        #region ContainerPort
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.ContainerPort"/></em></p>
        ///   <p>Synonym for --target-port.</p>
        /// </summary>
        [Pure]
        public static T SetContainerPort<T>(this T toolSettings, string containerPort) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContainerPort = containerPort;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.ContainerPort"/></em></p>
        ///   <p>Synonym for --target-port.</p>
        /// </summary>
        [Pure]
        public static T ResetContainerPort<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContainerPort = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExposeSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExposeSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExposeSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region ExternalIp
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.ExternalIp"/></em></p>
        ///   <p>Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.</p>
        /// </summary>
        [Pure]
        public static T SetExternalIp<T>(this T toolSettings, string externalIp) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExternalIp = externalIp;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.ExternalIp"/></em></p>
        ///   <p>Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.</p>
        /// </summary>
        [Pure]
        public static T ResetExternalIp<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExternalIp = null;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesExposeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesExposeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesExposeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesExposeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesExposeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to expose a service.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Generator
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.</p>
        /// </summary>
        [Pure]
        public static T SetGenerator<T>(this T toolSettings, string generator) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = generator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.</p>
        /// </summary>
        [Pure]
        public static T ResetGenerator<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = null;
            return toolSettings;
        }
        #endregion
        #region Labels
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Labels"/></em></p>
        ///   <p>Labels to apply to the service created by this call.</p>
        /// </summary>
        [Pure]
        public static T SetLabels<T>(this T toolSettings, string labels) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Labels = labels;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Labels"/></em></p>
        ///   <p>Labels to apply to the service created by this call.</p>
        /// </summary>
        [Pure]
        public static T ResetLabels<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Labels = null;
            return toolSettings;
        }
        #endregion
        #region LoadBalancerIp
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.LoadBalancerIp"/></em></p>
        ///   <p>IP to assign to the LoadBalancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).</p>
        /// </summary>
        [Pure]
        public static T SetLoadBalancerIp<T>(this T toolSettings, string loadBalancerIp) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LoadBalancerIp = loadBalancerIp;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.LoadBalancerIp"/></em></p>
        ///   <p>IP to assign to the LoadBalancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).</p>
        /// </summary>
        [Pure]
        public static T ResetLoadBalancerIp<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.LoadBalancerIp = null;
            return toolSettings;
        }
        #endregion
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Name"/></em></p>
        ///   <p>The name for the newly created object.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Name"/></em></p>
        ///   <p>The name for the newly created object.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesExposeOutput output) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overrides
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Overrides"/></em></p>
        ///   <p>An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.</p>
        /// </summary>
        [Pure]
        public static T SetOverrides<T>(this T toolSettings, string overrides) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overrides = overrides;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Overrides"/></em></p>
        ///   <p>An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.</p>
        /// </summary>
        [Pure]
        public static T ResetOverrides<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overrides = null;
            return toolSettings;
        }
        #endregion
        #region Port
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Port"/></em></p>
        ///   <p>The port that the service should serve on. Copied from the resource being exposed, if unspecified.</p>
        /// </summary>
        [Pure]
        public static T SetPort<T>(this T toolSettings, string port) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = port;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Port"/></em></p>
        ///   <p>The port that the service should serve on. Copied from the resource being exposed, if unspecified.</p>
        /// </summary>
        [Pure]
        public static T ResetPort<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = null;
            return toolSettings;
        }
        #endregion
        #region Protocol
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Protocol"/></em></p>
        ///   <p>The network protocol for the service to be created. Default is 'TCP'.</p>
        /// </summary>
        [Pure]
        public static T SetProtocol<T>(this T toolSettings, string protocol) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Protocol = protocol;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Protocol"/></em></p>
        ///   <p>The network protocol for the service to be created. Default is 'TCP'.</p>
        /// </summary>
        [Pure]
        public static T ResetProtocol<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Protocol = null;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExposeSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExposeSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExposeSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExposeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExposeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExposeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region SaveConfig
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T SetSaveConfig<T>(this T toolSettings, bool? saveConfig) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = saveConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ResetSaveConfig<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesExposeSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T EnableSaveConfig<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesExposeSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T DisableSaveConfig<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesExposeSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ToggleSaveConfig<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = !toolSettings.SaveConfig;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Selector"/></em></p>
        ///   <p>A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Selector"/></em></p>
        ///   <p>A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region SessionAffinity
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.SessionAffinity"/></em></p>
        ///   <p>If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'.</p>
        /// </summary>
        [Pure]
        public static T SetSessionAffinity<T>(this T toolSettings, string sessionAffinity) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SessionAffinity = sessionAffinity;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.SessionAffinity"/></em></p>
        ///   <p>If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'.</p>
        /// </summary>
        [Pure]
        public static T ResetSessionAffinity<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SessionAffinity = null;
            return toolSettings;
        }
        #endregion
        #region TargetPort
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.TargetPort"/></em></p>
        ///   <p>Name or number for the port on the container that the service should direct traffic to. Optional.</p>
        /// </summary>
        [Pure]
        public static T SetTargetPort<T>(this T toolSettings, string targetPort) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetPort = targetPort;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.TargetPort"/></em></p>
        ///   <p>Name or number for the port on the container that the service should direct traffic to. Optional.</p>
        /// </summary>
        [Pure]
        public static T ResetTargetPort<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetPort = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Type
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesExposeSettings.Type"/></em></p>
        ///   <p>Type for this service: ClusterIP, NodePort, LoadBalancer, or ExternalName. Default is 'ClusterIP'.</p>
        /// </summary>
        [Pure]
        public static T SetType<T>(this T toolSettings, string type) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Type = type;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesExposeSettings.Type"/></em></p>
        ///   <p>Type for this service: ClusterIP, NodePort, LoadBalancer, or ExternalName. Default is 'ClusterIP'.</p>
        /// </summary>
        [Pure]
        public static T ResetType<T>(this T toolSettings) where T : KubernetesExposeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Type = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesOptionsSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesOptionsSettingsExtensions
    {
    }
    #endregion
    #region KubernetesAttachSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesAttachSettingsExtensions
    {
        #region Pod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.Pod"/> to a new list</em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T SetPod<T>(this T toolSettings, params string[] pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodInternal = pod.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.Pod"/> to a new list</em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T SetPod<T>(this T toolSettings, IEnumerable<string> pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodInternal = pod.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAttachSettings.Pod"/></em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T AddPod<T>(this T toolSettings, params string[] pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodInternal.AddRange(pod);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAttachSettings.Pod"/></em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T AddPod<T>(this T toolSettings, IEnumerable<string> pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodInternal.AddRange(pod);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesAttachSettings.Pod"/></em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T ClearPod<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAttachSettings.Pod"/></em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T RemovePod<T>(this T toolSettings, params string[] pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(pod);
            toolSettings.PodInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAttachSettings.Pod"/></em></p>
        ///   <p>The type or/and name of the pod.</p>
        /// </summary>
        [Pure]
        public static T RemovePod<T>(this T toolSettings, IEnumerable<string> pod) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(pod);
            toolSettings.PodInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Container
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T SetContainer<T>(this T toolSettings, string container) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = container;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAttachSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T ResetContainer<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = null;
            return toolSettings;
        }
        #endregion
        #region PodRunningTimeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.PodRunningTimeout"/></em></p>
        ///   <p>The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.</p>
        /// </summary>
        [Pure]
        public static T SetPodRunningTimeout<T>(this T toolSettings, TimeSpan? podRunningTimeout) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodRunningTimeout = podRunningTimeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAttachSettings.PodRunningTimeout"/></em></p>
        ///   <p>The length of time (like 5s, 2m, or 3h, higher than zero) to wait until at least one pod is running.</p>
        /// </summary>
        [Pure]
        public static T ResetPodRunningTimeout<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PodRunningTimeout = null;
            return toolSettings;
        }
        #endregion
        #region Stdin
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T SetStdin<T>(this T toolSettings, bool? stdin) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = stdin;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAttachSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T ResetStdin<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAttachSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T EnableStdin<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAttachSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T DisableStdin<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAttachSettings.Stdin"/></em></p>
        ///   <p>Pass stdin to the container.</p>
        /// </summary>
        [Pure]
        public static T ToggleStdin<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Stdin = !toolSettings.Stdin;
            return toolSettings;
        }
        #endregion
        #region Tty
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAttachSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T SetTty<T>(this T toolSettings, bool? tty) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = tty;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAttachSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T ResetTty<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAttachSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T EnableTty<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAttachSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T DisableTty<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAttachSettings.Tty"/></em></p>
        ///   <p>Stdin is a TTY.</p>
        /// </summary>
        [Pure]
        public static T ToggleTty<T>(this T toolSettings) where T : KubernetesAttachSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tty = !toolSettings.Tty;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesProxySettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesProxySettingsExtensions
    {
        #region AcceptHosts
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.AcceptHosts"/></em></p>
        ///   <p>Regular expression for hosts that the proxy should accept.</p>
        /// </summary>
        [Pure]
        public static T SetAcceptHosts<T>(this T toolSettings, string acceptHosts) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AcceptHosts = acceptHosts;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.AcceptHosts"/></em></p>
        ///   <p>Regular expression for hosts that the proxy should accept.</p>
        /// </summary>
        [Pure]
        public static T ResetAcceptHosts<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AcceptHosts = null;
            return toolSettings;
        }
        #endregion
        #region AcceptPaths
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.AcceptPaths"/></em></p>
        ///   <p>Regular expression for paths that the proxy should accept.</p>
        /// </summary>
        [Pure]
        public static T SetAcceptPaths<T>(this T toolSettings, string acceptPaths) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AcceptPaths = acceptPaths;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.AcceptPaths"/></em></p>
        ///   <p>Regular expression for paths that the proxy should accept.</p>
        /// </summary>
        [Pure]
        public static T ResetAcceptPaths<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AcceptPaths = null;
            return toolSettings;
        }
        #endregion
        #region Address
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.Address"/></em></p>
        ///   <p>The IP address on which to serve on.</p>
        /// </summary>
        [Pure]
        public static T SetAddress<T>(this T toolSettings, string address) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Address = address;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.Address"/></em></p>
        ///   <p>The IP address on which to serve on.</p>
        /// </summary>
        [Pure]
        public static T ResetAddress<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Address = null;
            return toolSettings;
        }
        #endregion
        #region ApiPrefix
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.ApiPrefix"/></em></p>
        ///   <p>Prefix to serve the proxied API under.</p>
        /// </summary>
        [Pure]
        public static T SetApiPrefix<T>(this T toolSettings, string apiPrefix) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiPrefix = apiPrefix;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.ApiPrefix"/></em></p>
        ///   <p>Prefix to serve the proxied API under.</p>
        /// </summary>
        [Pure]
        public static T ResetApiPrefix<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiPrefix = null;
            return toolSettings;
        }
        #endregion
        #region DisableFilter
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.DisableFilter"/></em></p>
        ///   <p>If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.</p>
        /// </summary>
        [Pure]
        public static T SetDisableFilter<T>(this T toolSettings, bool? disableFilter) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DisableFilter = disableFilter;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.DisableFilter"/></em></p>
        ///   <p>If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.</p>
        /// </summary>
        [Pure]
        public static T ResetDisableFilter<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DisableFilter = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesProxySettings.DisableFilter"/></em></p>
        ///   <p>If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.</p>
        /// </summary>
        [Pure]
        public static T EnableDisableFilter<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DisableFilter = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesProxySettings.DisableFilter"/></em></p>
        ///   <p>If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.</p>
        /// </summary>
        [Pure]
        public static T DisableDisableFilter<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DisableFilter = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesProxySettings.DisableFilter"/></em></p>
        ///   <p>If true, disable request filtering in the proxy. This is dangerous, and can leave you vulnerable to XSRF attacks, when used with an accessible port.</p>
        /// </summary>
        [Pure]
        public static T ToggleDisableFilter<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DisableFilter = !toolSettings.DisableFilter;
            return toolSettings;
        }
        #endregion
        #region Port
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.Port"/></em></p>
        ///   <p>The port on which to run the proxy. Set to 0 to pick a random port.</p>
        /// </summary>
        [Pure]
        public static T SetPort<T>(this T toolSettings, int? port) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = port;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.Port"/></em></p>
        ///   <p>The port on which to run the proxy. Set to 0 to pick a random port.</p>
        /// </summary>
        [Pure]
        public static T ResetPort<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Port = null;
            return toolSettings;
        }
        #endregion
        #region RejectMethods
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.RejectMethods"/></em></p>
        ///   <p>Regular expression for HTTP methods that the proxy should reject (example --reject-methods='POST,PUT,PATCH'). .</p>
        /// </summary>
        [Pure]
        public static T SetRejectMethods<T>(this T toolSettings, string rejectMethods) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RejectMethods = rejectMethods;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.RejectMethods"/></em></p>
        ///   <p>Regular expression for HTTP methods that the proxy should reject (example --reject-methods='POST,PUT,PATCH'). .</p>
        /// </summary>
        [Pure]
        public static T ResetRejectMethods<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RejectMethods = null;
            return toolSettings;
        }
        #endregion
        #region RejectPaths
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.RejectPaths"/></em></p>
        ///   <p>Regular expression for paths that the proxy should reject. Paths specified here will be rejected even accepted by --accept-paths.</p>
        /// </summary>
        [Pure]
        public static T SetRejectPaths<T>(this T toolSettings, string rejectPaths) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RejectPaths = rejectPaths;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.RejectPaths"/></em></p>
        ///   <p>Regular expression for paths that the proxy should reject. Paths specified here will be rejected even accepted by --accept-paths.</p>
        /// </summary>
        [Pure]
        public static T ResetRejectPaths<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RejectPaths = null;
            return toolSettings;
        }
        #endregion
        #region UnixSocket
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.UnixSocket"/></em></p>
        ///   <p>Unix socket on which to run the proxy.</p>
        /// </summary>
        [Pure]
        public static T SetUnixSocket<T>(this T toolSettings, string unixSocket) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UnixSocket = unixSocket;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.UnixSocket"/></em></p>
        ///   <p>Unix socket on which to run the proxy.</p>
        /// </summary>
        [Pure]
        public static T ResetUnixSocket<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UnixSocket = null;
            return toolSettings;
        }
        #endregion
        #region Www
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.Www"/></em></p>
        ///   <p>Also serve static files from the given directory under the specified prefix.</p>
        /// </summary>
        [Pure]
        public static T SetWww<T>(this T toolSettings, string www) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Www = www;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.Www"/></em></p>
        ///   <p>Also serve static files from the given directory under the specified prefix.</p>
        /// </summary>
        [Pure]
        public static T ResetWww<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Www = null;
            return toolSettings;
        }
        #endregion
        #region WwwPrefix
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesProxySettings.WwwPrefix"/></em></p>
        ///   <p>Prefix to serve static files under, if static file directory is specified.</p>
        /// </summary>
        [Pure]
        public static T SetWwwPrefix<T>(this T toolSettings, string wwwPrefix) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WwwPrefix = wwwPrefix;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesProxySettings.WwwPrefix"/></em></p>
        ///   <p>Prefix to serve static files under, if static file directory is specified.</p>
        /// </summary>
        [Pure]
        public static T ResetWwwPrefix<T>(this T toolSettings) where T : KubernetesProxySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.WwwPrefix = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesAlphaSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesAlphaSettingsExtensions
    {
    }
    #endregion
    #region KubernetesSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesSettingsExtensions
    {
    }
    #endregion
    #region KubernetesCompletionSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesCompletionSettingsExtensions
    {
    }
    #endregion
    #region KubernetesPatchSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesPatchSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesPatchSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesPatchSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesPatchSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesPatchSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesPatchSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesPatchSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesPatchSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesPatchSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesPatchSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesPatchSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesPatchSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesPatchSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesPatchSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesPatchSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to update.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Local
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Local"/></em></p>
        ///   <p>If true, patch will operate on the content of the file, not the server-side resource.</p>
        /// </summary>
        [Pure]
        public static T SetLocal<T>(this T toolSettings, bool? local) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = local;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Local"/></em></p>
        ///   <p>If true, patch will operate on the content of the file, not the server-side resource.</p>
        /// </summary>
        [Pure]
        public static T ResetLocal<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesPatchSettings.Local"/></em></p>
        ///   <p>If true, patch will operate on the content of the file, not the server-side resource.</p>
        /// </summary>
        [Pure]
        public static T EnableLocal<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesPatchSettings.Local"/></em></p>
        ///   <p>If true, patch will operate on the content of the file, not the server-side resource.</p>
        /// </summary>
        [Pure]
        public static T DisableLocal<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesPatchSettings.Local"/></em></p>
        ///   <p>If true, patch will operate on the content of the file, not the server-side resource.</p>
        /// </summary>
        [Pure]
        public static T ToggleLocal<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Local = !toolSettings.Local;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesPatchOutput output) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Patch
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Patch"/></em></p>
        ///   <p>The patch to be applied to the resource JSON file.</p>
        /// </summary>
        [Pure]
        public static T SetPatch<T>(this T toolSettings, string patch) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Patch = patch;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Patch"/></em></p>
        ///   <p>The patch to be applied to the resource JSON file.</p>
        /// </summary>
        [Pure]
        public static T ResetPatch<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Patch = null;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesPatchSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesPatchSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesPatchSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesPatchSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesPatchSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesPatchSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Type
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesPatchSettings.Type"/></em></p>
        ///   <p>The type of patch being provided; one of [json merge strategic].</p>
        /// </summary>
        [Pure]
        public static T SetType<T>(this T toolSettings, KubernetesPatchType type) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Type = type;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesPatchSettings.Type"/></em></p>
        ///   <p>The type of patch being provided; one of [json merge strategic].</p>
        /// </summary>
        [Pure]
        public static T ResetType<T>(this T toolSettings) where T : KubernetesPatchSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Type = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesReplaceSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesReplaceSettingsExtensions
    {
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region Cascade
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T SetCascade<T>(this T toolSettings, bool? cascade) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = cascade;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ResetCascade<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T EnableCascade<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T DisableCascade<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ToggleCascade<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = !toolSettings.Cascade;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Filename"/> to a new list</em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Filename"/> to a new list</em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesReplaceSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesReplaceSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesReplaceSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesReplaceSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesReplaceSettings.Filename"/></em></p>
        ///   <p>to use to replace the resource.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region GracePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T SetGracePeriod<T>(this T toolSettings, int? gracePeriod) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = gracePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T ResetGracePeriod<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesReplaceOutput output) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region SaveConfig
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T SetSaveConfig<T>(this T toolSettings, bool? saveConfig) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = saveConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ResetSaveConfig<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T EnableSaveConfig<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T DisableSaveConfig<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T ToggleSaveConfig<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SaveConfig = !toolSettings.SaveConfig;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
        #region Validate
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T SetValidate<T>(this T toolSettings, bool? validate) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = validate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetValidate<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableValidate<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableValidate<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleValidate<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = !toolSettings.Validate;
            return toolSettings;
        }
        #endregion
        #region Wait
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesReplaceSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T SetWait<T>(this T toolSettings, bool? wait) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = wait;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesReplaceSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ResetWait<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesReplaceSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T EnableWait<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesReplaceSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T DisableWait<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesReplaceSettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ToggleWait<T>(this T toolSettings) where T : KubernetesReplaceSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = !toolSettings.Wait;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesTaintSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesTaintSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesTaintSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesTaintSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesTaintSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesTaintSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesTaintSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region TaintEffects
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.TaintEffects"/> to a new dictionary</em></p>
        ///   <p>The taint effects to set.</p>
        /// </summary>
        [Pure]
        public static T SetTaintEffects<T>(this T toolSettings, IDictionary<string, string> taintEffects) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TaintEffectsInternal = taintEffects.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesTaintSettings.TaintEffects"/></em></p>
        ///   <p>The taint effects to set.</p>
        /// </summary>
        [Pure]
        public static T ClearTaintEffects<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TaintEffectsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="KubernetesTaintSettings.TaintEffects"/></em></p>
        ///   <p>The taint effects to set.</p>
        /// </summary>
        [Pure]
        public static T AddTaintEffect<T>(this T toolSettings, string taintEffectKey, string taintEffectValue) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TaintEffectsInternal.Add(taintEffectKey, taintEffectValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="KubernetesTaintSettings.TaintEffects"/></em></p>
        ///   <p>The taint effects to set.</p>
        /// </summary>
        [Pure]
        public static T RemoveTaintEffect<T>(this T toolSettings, string taintEffectKey) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TaintEffectsInternal.Remove(taintEffectKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="KubernetesTaintSettings.TaintEffects"/></em></p>
        ///   <p>The taint effects to set.</p>
        /// </summary>
        [Pure]
        public static T SetTaintEffect<T>(this T toolSettings, string taintEffectKey, string taintEffectValue) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TaintEffectsInternal[taintEffectKey] = taintEffectValue;
            return toolSettings;
        }
        #endregion
        #region All
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.All"/></em></p>
        ///   <p>Select all nodes in the cluster.</p>
        /// </summary>
        [Pure]
        public static T SetAll<T>(this T toolSettings, bool? all) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = all;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.All"/></em></p>
        ///   <p>Select all nodes in the cluster.</p>
        /// </summary>
        [Pure]
        public static T ResetAll<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesTaintSettings.All"/></em></p>
        ///   <p>Select all nodes in the cluster.</p>
        /// </summary>
        [Pure]
        public static T EnableAll<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesTaintSettings.All"/></em></p>
        ///   <p>Select all nodes in the cluster.</p>
        /// </summary>
        [Pure]
        public static T DisableAll<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesTaintSettings.All"/></em></p>
        ///   <p>Select all nodes in the cluster.</p>
        /// </summary>
        [Pure]
        public static T ToggleAll<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = !toolSettings.All;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesTaintSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesTaintOutput output) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overwrite
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.Overwrite"/></em></p>
        ///   <p>If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.</p>
        /// </summary>
        [Pure]
        public static T SetOverwrite<T>(this T toolSettings, bool? overwrite) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = overwrite;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.Overwrite"/></em></p>
        ///   <p>If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.</p>
        /// </summary>
        [Pure]
        public static T ResetOverwrite<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesTaintSettings.Overwrite"/></em></p>
        ///   <p>If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.</p>
        /// </summary>
        [Pure]
        public static T EnableOverwrite<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesTaintSettings.Overwrite"/></em></p>
        ///   <p>If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.</p>
        /// </summary>
        [Pure]
        public static T DisableOverwrite<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesTaintSettings.Overwrite"/></em></p>
        ///   <p>If true, allow taints to be overwritten, otherwise reject taint updates that overwrite existing taints.</p>
        /// </summary>
        [Pure]
        public static T ToggleOverwrite<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = !toolSettings.Overwrite;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Validate
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesTaintSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T SetValidate<T>(this T toolSettings, bool? validate) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = validate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesTaintSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetValidate<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesTaintSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableValidate<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesTaintSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableValidate<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesTaintSettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleValidate<T>(this T toolSettings) where T : KubernetesTaintSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = !toolSettings.Validate;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesDescribeSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesDescribeSettingsExtensions
    {
        #region TypeName
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.TypeName"/> to a new list</em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T SetTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal = typeName.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDescribeSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDescribeSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T AddTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.AddRange(typeName);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesDescribeSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T ClearTypeName<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDescribeSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, params string[] typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDescribeSettings.TypeName"/></em></p>
        ///   <p>The type or/and name of the ressource.</p>
        /// </summary>
        [Pure]
        public static T RemoveTypeName<T>(this T toolSettings, IEnumerable<string> typeName) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(typeName);
            toolSettings.TypeNameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AllNamespaces
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T SetAllNamespaces<T>(this T toolSettings, bool? allNamespaces) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = allNamespaces;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDescribeSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T ResetAllNamespaces<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDescribeSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T EnableAllNamespaces<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDescribeSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T DisableAllNamespaces<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDescribeSettings.AllNamespaces"/></em></p>
        ///   <p>If present, list the requested object(s) across all namespaces. Namespace in current context is ignored even if specified with --namespace.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllNamespaces<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllNamespaces = !toolSettings.AllNamespaces;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDescribeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesDescribeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesDescribeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDescribeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesDescribeSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files containing the resource to describe.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDescribeSettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDescribeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDescribeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDescribeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDescribeSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDescribeSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region ShowEvents
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesDescribeSettings.ShowEvents"/></em></p>
        ///   <p>If true, display events related to the described object.</p>
        /// </summary>
        [Pure]
        public static T SetShowEvents<T>(this T toolSettings, bool? showEvents) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowEvents = showEvents;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesDescribeSettings.ShowEvents"/></em></p>
        ///   <p>If true, display events related to the described object.</p>
        /// </summary>
        [Pure]
        public static T ResetShowEvents<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowEvents = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesDescribeSettings.ShowEvents"/></em></p>
        ///   <p>If true, display events related to the described object.</p>
        /// </summary>
        [Pure]
        public static T EnableShowEvents<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowEvents = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesDescribeSettings.ShowEvents"/></em></p>
        ///   <p>If true, display events related to the described object.</p>
        /// </summary>
        [Pure]
        public static T DisableShowEvents<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowEvents = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesDescribeSettings.ShowEvents"/></em></p>
        ///   <p>If true, display events related to the described object.</p>
        /// </summary>
        [Pure]
        public static T ToggleShowEvents<T>(this T toolSettings) where T : KubernetesDescribeSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ShowEvents = !toolSettings.ShowEvents;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesSetSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesSetSettingsExtensions
    {
        #region Subcommand
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesSetSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesSetSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesSetSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesSetSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesSetSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T ClearSubcommand<T>(this T toolSettings) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesSetSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesSetSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesSetSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesAuthSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesAuthSettingsExtensions
    {
        #region Subcommand
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAuthSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, string subcommand) where T : KubernetesAuthSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Subcommand = subcommand;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAuthSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T ResetSubcommand<T>(this T toolSettings) where T : KubernetesAuthSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Subcommand = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesCertificateSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesCertificateSettingsExtensions
    {
        #region Subcommand
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCertificateSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCertificateSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesCertificateSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesCertificateSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesCertificateSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T ClearSubcommand<T>(this T toolSettings) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesCertificateSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesCertificateSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesCertificateSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesRolloutSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesRolloutSettingsExtensions
    {
        #region Subcommand
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRolloutSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesRolloutSettings.Subcommand"/> to a new list</em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T SetSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal = subcommand.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRolloutSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesRolloutSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T AddSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.AddRange(subcommand);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesRolloutSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T ClearSubcommand<T>(this T toolSettings) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SubcommandInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRolloutSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, params string[] subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesRolloutSettings.Subcommand"/></em></p>
        ///   <p>The subcommand to run.</p>
        /// </summary>
        [Pure]
        public static T RemoveSubcommand<T>(this T toolSettings, IEnumerable<string> subcommand) where T : KubernetesRolloutSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(subcommand);
            toolSettings.SubcommandInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesApplySettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesApplySettingsExtensions
    {
        #region All
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.All"/></em></p>
        ///   <p>Select all resources in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T SetAll<T>(this T toolSettings, bool? all) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = all;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.All"/></em></p>
        ///   <p>Select all resources in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ResetAll<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.All"/></em></p>
        ///   <p>Select all resources in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T EnableAll<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.All"/></em></p>
        ///   <p>Select all resources in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T DisableAll<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.All"/></em></p>
        ///   <p>Select all resources in the namespace of the specified resource types.</p>
        /// </summary>
        [Pure]
        public static T ToggleAll<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.All = !toolSettings.All;
            return toolSettings;
        }
        #endregion
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region Cascade
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T SetCascade<T>(this T toolSettings, bool? cascade) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = cascade;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ResetCascade<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T EnableCascade<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T DisableCascade<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Cascade"/></em></p>
        ///   <p>If true, cascade the deletion of the resources managed by this resource (e.g. Pods created by a ReplicationController).  Default true.</p>
        /// </summary>
        [Pure]
        public static T ToggleCascade<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Cascade = !toolSettings.Cascade;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Filename"/> to a new list</em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Filename"/> to a new list</em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApplySettings.Filename"/></em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApplySettings.Filename"/></em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesApplySettings.Filename"/></em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApplySettings.Filename"/></em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApplySettings.Filename"/></em></p>
        ///   <p>that contains the configuration to apply.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Force
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T SetForce<T>(this T toolSettings, bool? force) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = force;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ResetForce<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T EnableForce<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T DisableForce<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Force"/></em></p>
        ///   <p>Only used when grace-period=0. If true, immediately remove resources from API and bypass graceful deletion. Note that immediate deletion of some resources may result in inconsistency or data loss and requires confirmation.</p>
        /// </summary>
        [Pure]
        public static T ToggleForce<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Force = !toolSettings.Force;
            return toolSettings;
        }
        #endregion
        #region GracePeriod
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T SetGracePeriod<T>(this T toolSettings, int? gracePeriod) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = gracePeriod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.GracePeriod"/></em></p>
        ///   <p>Period of time in seconds given to the resource to terminate gracefully. Ignored if negative. Set to 1 for immediate shutdown. Can only be set to 0 when --force is true (force deletion).</p>
        /// </summary>
        [Pure]
        public static T ResetGracePeriod<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GracePeriod = null;
            return toolSettings;
        }
        #endregion
        #region IncludeUninitialized
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T SetIncludeUninitialized<T>(this T toolSettings, bool? includeUninitialized) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = includeUninitialized;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ResetIncludeUninitialized<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T EnableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T DisableIncludeUninitialized<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.IncludeUninitialized"/></em></p>
        ///   <p>If true, the kubectl command applies to uninitialized objects. If explicitly set to false, this flag overrides other flags that make the kubectl commands apply to uninitialized objects, e.g., "--all". Objects with empty metadata.initializers are regarded as initialized.</p>
        /// </summary>
        [Pure]
        public static T ToggleIncludeUninitialized<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludeUninitialized = !toolSettings.IncludeUninitialized;
            return toolSettings;
        }
        #endregion
        #region OpenapiPatch
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.OpenapiPatch"/></em></p>
        ///   <p>If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.</p>
        /// </summary>
        [Pure]
        public static T SetOpenapiPatch<T>(this T toolSettings, bool? openapiPatch) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OpenapiPatch = openapiPatch;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.OpenapiPatch"/></em></p>
        ///   <p>If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.</p>
        /// </summary>
        [Pure]
        public static T ResetOpenapiPatch<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OpenapiPatch = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.OpenapiPatch"/></em></p>
        ///   <p>If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.</p>
        /// </summary>
        [Pure]
        public static T EnableOpenapiPatch<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OpenapiPatch = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.OpenapiPatch"/></em></p>
        ///   <p>If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.</p>
        /// </summary>
        [Pure]
        public static T DisableOpenapiPatch<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OpenapiPatch = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.OpenapiPatch"/></em></p>
        ///   <p>If true, use openapi to calculate diff when the openapi presents and the resource can be found in the openapi spec. Otherwise, fall back to use baked-in types.</p>
        /// </summary>
        [Pure]
        public static T ToggleOpenapiPatch<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OpenapiPatch = !toolSettings.OpenapiPatch;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesApplyOutput output) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Overwrite
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Overwrite"/></em></p>
        ///   <p>Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.</p>
        /// </summary>
        [Pure]
        public static T SetOverwrite<T>(this T toolSettings, bool? overwrite) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = overwrite;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Overwrite"/></em></p>
        ///   <p>Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.</p>
        /// </summary>
        [Pure]
        public static T ResetOverwrite<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Overwrite"/></em></p>
        ///   <p>Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.</p>
        /// </summary>
        [Pure]
        public static T EnableOverwrite<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Overwrite"/></em></p>
        ///   <p>Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.</p>
        /// </summary>
        [Pure]
        public static T DisableOverwrite<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Overwrite"/></em></p>
        ///   <p>Automatically resolve conflicts between the modified and live configuration by using values from the modified configuration.</p>
        /// </summary>
        [Pure]
        public static T ToggleOverwrite<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Overwrite = !toolSettings.Overwrite;
            return toolSettings;
        }
        #endregion
        #region Prune
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Prune"/></em></p>
        ///   <p>Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.</p>
        /// </summary>
        [Pure]
        public static T SetPrune<T>(this T toolSettings, bool? prune) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Prune = prune;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Prune"/></em></p>
        ///   <p>Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.</p>
        /// </summary>
        [Pure]
        public static T ResetPrune<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Prune = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Prune"/></em></p>
        ///   <p>Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.</p>
        /// </summary>
        [Pure]
        public static T EnablePrune<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Prune = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Prune"/></em></p>
        ///   <p>Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.</p>
        /// </summary>
        [Pure]
        public static T DisablePrune<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Prune = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Prune"/></em></p>
        ///   <p>Automatically delete resource objects, including the uninitialized ones, that do not appear in the configs and are created by either apply or create --save-config. Should be used with either -l or --all.</p>
        /// </summary>
        [Pure]
        public static T TogglePrune<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Prune = !toolSettings.Prune;
            return toolSettings;
        }
        #endregion
        #region PruneWhitelist
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.PruneWhitelist"/> to a new list</em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T SetPruneWhitelist<T>(this T toolSettings, params string[] pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PruneWhitelistInternal = pruneWhitelist.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.PruneWhitelist"/> to a new list</em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T SetPruneWhitelist<T>(this T toolSettings, IEnumerable<string> pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PruneWhitelistInternal = pruneWhitelist.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApplySettings.PruneWhitelist"/></em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T AddPruneWhitelist<T>(this T toolSettings, params string[] pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PruneWhitelistInternal.AddRange(pruneWhitelist);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesApplySettings.PruneWhitelist"/></em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T AddPruneWhitelist<T>(this T toolSettings, IEnumerable<string> pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PruneWhitelistInternal.AddRange(pruneWhitelist);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesApplySettings.PruneWhitelist"/></em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T ClearPruneWhitelist<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.PruneWhitelistInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApplySettings.PruneWhitelist"/></em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T RemovePruneWhitelist<T>(this T toolSettings, params string[] pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(pruneWhitelist);
            toolSettings.PruneWhitelistInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesApplySettings.PruneWhitelist"/></em></p>
        ///   <p>Overwrite the default whitelist with &lt;group/version/kind&gt; for --prune.</p>
        /// </summary>
        [Pure]
        public static T RemovePruneWhitelist<T>(this T toolSettings, IEnumerable<string> pruneWhitelist) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(pruneWhitelist);
            toolSettings.PruneWhitelistInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on, supports '=', '==', and '!='.(e.g. -l key1=value1,key2=value2).</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
        #region Template
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T SetTemplate<T>(this T toolSettings, string template) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = template;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Template"/></em></p>
        ///   <p>Template string or path to template file to use when -o=go-template, -o=go-template-file. The template format is golang templates [http://golang.org/pkg/text/template/#pkg-overview].</p>
        /// </summary>
        [Pure]
        public static T ResetTemplate<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Template = null;
            return toolSettings;
        }
        #endregion
        #region Timeout
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T SetTimeout<T>(this T toolSettings, TimeSpan? timeout) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = timeout;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Timeout"/></em></p>
        ///   <p>The length of time to wait before giving up on a delete, zero means determine a timeout from the size of the object.</p>
        /// </summary>
        [Pure]
        public static T ResetTimeout<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Timeout = null;
            return toolSettings;
        }
        #endregion
        #region Validate
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T SetValidate<T>(this T toolSettings, bool? validate) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = validate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetValidate<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableValidate<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableValidate<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Validate"/></em></p>
        ///   <p>If true, use a schema to validate the input before sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleValidate<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Validate = !toolSettings.Validate;
            return toolSettings;
        }
        #endregion
        #region Wait
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesApplySettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T SetWait<T>(this T toolSettings, bool? wait) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = wait;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesApplySettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ResetWait<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesApplySettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T EnableWait<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesApplySettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T DisableWait<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesApplySettings.Wait"/></em></p>
        ///   <p>If true, wait for resources to be gone before returning. This waits for finalizers.</p>
        /// </summary>
        [Pure]
        public static T ToggleWait<T>(this T toolSettings) where T : KubernetesApplySettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Wait = !toolSettings.Wait;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesCordonSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesCordonSettingsExtensions
    {
        #region Node
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCordonSettings.Node"/></em></p>
        ///   <p>The namne of the Node.</p>
        /// </summary>
        [Pure]
        public static T SetNode<T>(this T toolSettings, string node) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Node = node;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCordonSettings.Node"/></em></p>
        ///   <p>The namne of the Node.</p>
        /// </summary>
        [Pure]
        public static T ResetNode<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Node = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesCordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesCordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesCordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCordonSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCordonSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesCordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesCpSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesCpSettingsExtensions
    {
        #region SrcFileSpec
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCpSettings.SrcFileSpec"/></em></p>
        ///   <p>The file specification of the source. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.</p>
        /// </summary>
        [Pure]
        public static T SetSrcFileSpec<T>(this T toolSettings, string srcFileSpec) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SrcFileSpec = srcFileSpec;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCpSettings.SrcFileSpec"/></em></p>
        ///   <p>The file specification of the source. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.</p>
        /// </summary>
        [Pure]
        public static T ResetSrcFileSpec<T>(this T toolSettings) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SrcFileSpec = null;
            return toolSettings;
        }
        #endregion
        #region DestFileSpec
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCpSettings.DestFileSpec"/></em></p>
        ///   <p>The file specification of the destination. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.</p>
        /// </summary>
        [Pure]
        public static T SetDestFileSpec<T>(this T toolSettings, string destFileSpec) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DestFileSpec = destFileSpec;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCpSettings.DestFileSpec"/></em></p>
        ///   <p>The file specification of the destination. '[namespace/]pod-name:/file/path'. for a remote file '/file/path' for a local file.</p>
        /// </summary>
        [Pure]
        public static T ResetDestFileSpec<T>(this T toolSettings) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DestFileSpec = null;
            return toolSettings;
        }
        #endregion
        #region Container
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesCpSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T SetContainer<T>(this T toolSettings, string container) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = container;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesCpSettings.Container"/></em></p>
        ///   <p>Container name. If omitted, the first container in the pod will be chosen.</p>
        /// </summary>
        [Pure]
        public static T ResetContainer<T>(this T toolSettings) where T : KubernetesCpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Container = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesApiVersionsSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesApiVersionsSettingsExtensions
    {
    }
    #endregion
    #region KubernetesUncordonSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesUncordonSettingsExtensions
    {
        #region Node
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesUncordonSettings.Node"/></em></p>
        ///   <p>The name of the node.</p>
        /// </summary>
        [Pure]
        public static T SetNode<T>(this T toolSettings, string node) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Node = node;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesUncordonSettings.Node"/></em></p>
        ///   <p>The name of the node.</p>
        /// </summary>
        [Pure]
        public static T ResetNode<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Node = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesUncordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesUncordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesUncordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesUncordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesUncordonSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Selector
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesUncordonSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T SetSelector<T>(this T toolSettings, string selector) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = selector;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesUncordonSettings.Selector"/></em></p>
        ///   <p>Selector (label query) to filter on.</p>
        /// </summary>
        [Pure]
        public static T ResetSelector<T>(this T toolSettings) where T : KubernetesUncordonSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Selector = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region KubernetesAutoscaleSettingsExtensions
    /// <summary>
    ///   Used within <see cref="KubernetesTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class KubernetesAutoscaleSettingsExtensions
    {
        #region AllowMissingTemplateKeys
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T SetAllowMissingTemplateKeys<T>(this T toolSettings, bool? allowMissingTemplateKeys) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = allowMissingTemplateKeys;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ResetAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T EnableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T DisableAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAutoscaleSettings.AllowMissingTemplateKeys"/></em></p>
        ///   <p>If true, ignore any errors in templates when a field or map key is missing in the template. Only applies to golang and jsonpath output formats.</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowMissingTemplateKeys<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowMissingTemplateKeys = !toolSettings.AllowMissingTemplateKeys;
            return toolSettings;
        }
        #endregion
        #region CpuPercent
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.CpuPercent"/></em></p>
        ///   <p>The target average CPU utilization (represented as a percent of requested CPU) over all the pods. If it's not specified or negative, a default autoscaling policy will be used.</p>
        /// </summary>
        [Pure]
        public static T SetCpuPercent<T>(this T toolSettings, int? cpuPercent) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CpuPercent = cpuPercent;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.CpuPercent"/></em></p>
        ///   <p>The target average CPU utilization (represented as a percent of requested CPU) over all the pods. If it's not specified or negative, a default autoscaling policy will be used.</p>
        /// </summary>
        [Pure]
        public static T ResetCpuPercent<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CpuPercent = null;
            return toolSettings;
        }
        #endregion
        #region DryRun
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T SetDryRun<T>(this T toolSettings, bool? dryRun) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = dryRun;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ResetDryRun<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAutoscaleSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T EnableDryRun<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAutoscaleSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T DisableDryRun<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAutoscaleSettings.DryRun"/></em></p>
        ///   <p>If true, only print the object that would be sent, without sending it.</p>
        /// </summary>
        [Pure]
        public static T ToggleDryRun<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DryRun = !toolSettings.DryRun;
            return toolSettings;
        }
        #endregion
        #region Filename
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Filename"/> to a new list</em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T SetFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal = filename.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAutoscaleSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="KubernetesAutoscaleSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T AddFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.AddRange(filename);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="KubernetesAutoscaleSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T ClearFilename<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FilenameInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAutoscaleSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, params string[] filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="KubernetesAutoscaleSettings.Filename"/></em></p>
        ///   <p>Filename, directory, or URL to files identifying the resource to autoscale.</p>
        /// </summary>
        [Pure]
        public static T RemoveFilename<T>(this T toolSettings, IEnumerable<string> filename) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(filename);
            toolSettings.FilenameInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Generator
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use. Currently there is only 1 generator.</p>
        /// </summary>
        [Pure]
        public static T SetGenerator<T>(this T toolSettings, string generator) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = generator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Generator"/></em></p>
        ///   <p>The name of the API generator to use. Currently there is only 1 generator.</p>
        /// </summary>
        [Pure]
        public static T ResetGenerator<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Generator = null;
            return toolSettings;
        }
        #endregion
        #region Max
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Max"/></em></p>
        ///   <p>The upper limit for the number of pods that can be set by the autoscaler. Required.</p>
        /// </summary>
        [Pure]
        public static T SetMax<T>(this T toolSettings, int? max) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Max = max;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Max"/></em></p>
        ///   <p>The upper limit for the number of pods that can be set by the autoscaler. Required.</p>
        /// </summary>
        [Pure]
        public static T ResetMax<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Max = null;
            return toolSettings;
        }
        #endregion
        #region Min
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Min"/></em></p>
        ///   <p>The lower limit for the number of pods that can be set by the autoscaler. If it's not specified or negative, the server will apply a default value.</p>
        /// </summary>
        [Pure]
        public static T SetMin<T>(this T toolSettings, int? min) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Min = min;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Min"/></em></p>
        ///   <p>The lower limit for the number of pods that can be set by the autoscaler. If it's not specified or negative, the server will apply a default value.</p>
        /// </summary>
        [Pure]
        public static T ResetMin<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Min = null;
            return toolSettings;
        }
        #endregion
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Name"/></em></p>
        ///   <p>The name for the newly created object. If not specified, the name of the input resource will be used.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Name"/></em></p>
        ///   <p>The name for the newly created object. If not specified, the name of the input resource will be used.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, KubernetesAutoscaleOutput output) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Output"/></em></p>
        ///   <p>Output format. One of: json|yaml|name|template|go-template|go-template-file|templatefile|jsonpath|jsonpath-file.</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region Record
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T SetRecord<T>(this T toolSettings, bool? record) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = record;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ResetRecord<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAutoscaleSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T EnableRecord<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAutoscaleSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T DisableRecord<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAutoscaleSettings.Record"/></em></p>
        ///   <p>Record current kubectl command in the resource annotation. If set to false, do not record the command. If set to true, record the command. If not set, default to updating the existing annotation value only if one already exists.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecord<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Record = !toolSettings.Record;
            return toolSettings;
        }
        #endregion
        #region Recursive
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T SetRecursive<T>(this T toolSettings, bool? recursive) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = recursive;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="KubernetesAutoscaleSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ResetRecursive<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="KubernetesAutoscaleSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T EnableRecursive<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="KubernetesAutoscaleSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T DisableRecursive<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="KubernetesAutoscaleSettings.Recursive"/></em></p>
        ///   <p>Process the directory used in -f, --filename recursively. Useful when you want to manage related manifests organized within the same directory.</p>
        /// </summary>
        [Pure]
        public static T ToggleRecursive<T>(this T toolSettings) where T : KubernetesAutoscaleSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Recursive = !toolSettings.Recursive;
            return toolSettings;
        }
        #endregion
        #region SaveConfig
        /// <summary>
        ///   <p><em>Sets <see cref="KubernetesAutoscaleSettings.SaveConfig"/></em></p>
        ///   <p>If true, the configuration of current object will be saved in its annotation. Otherwise, the annotation will be unchanged. This flag is useful when you want to perform kubectl apply on this object in the future.</p>
        /// </summary>
        [Pure]
        public static T SetSaveConfig<T>(this T toolSettings, bool? saveConfig) where T : KubernetesAutosca