#pragma warning disable CS1574
// Generated from https://github.com/nuke-build/nuke/blob/master/build/specifications/NSwag.json

using JetBrains.Annotations;
using Newtonsoft.Json;
using Nuke.Common;
using Nuke.Common.Execution;
using Nuke.Common.Tooling;
using Nuke.Common.Tools;
using Nuke.Common.Utilities.Collections;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Text;

namespace Nuke.Common.Tools.NSwag
{
    /// <summary>
    ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
    ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagTasks
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public static string NSwagPath =>
            ToolPathResolver.TryGetEnvironmentExecutable("NSWAG_EXE") ??
            GetToolPath();
        public static Action<OutputType, string> NSwagLogger { get; set; } = ProcessTasks.DefaultLogger;
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        public static IReadOnlyCollection<Output> NSwag(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, bool? logTimestamp = null, string logFile = null, Func<string, string> outputFilter = null)
        {
            using var process = ProcessTasks.StartProcess(NSwagPath, arguments, workingDirectory, environmentVariables, timeout, logOutput, logInvocation, logTimestamp, logFile, NSwagLogger, outputFilter);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Prints the toolchain version.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagVersionSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagVersion(NSwagVersionSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagVersionSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Prints the toolchain version.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagVersionSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagVersion(Configure<NSwagVersionSettings> configurator)
        {
            return NSwagVersion(configurator(new NSwagVersionSettings()));
        }
        /// <summary>
        ///   <p>Prints the toolchain version.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagVersionSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagVersionSettings Settings, IReadOnlyCollection<Output> Output)> NSwagVersion(CombinatorialConfigure<NSwagVersionSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagVersion, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List all types for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListTypesSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListTypesSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListTypesSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListTypesSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListTypesSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListTypesSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListTypesSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagListTypes(NSwagListTypesSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagListTypesSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List all types for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListTypesSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListTypesSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListTypesSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListTypesSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListTypesSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListTypesSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListTypesSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagListTypes(Configure<NSwagListTypesSettings> configurator)
        {
            return NSwagListTypes(configurator(new NSwagListTypesSettings()));
        }
        /// <summary>
        ///   <p>List all types for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListTypesSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListTypesSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListTypesSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListTypesSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListTypesSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListTypesSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListTypesSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagListTypesSettings Settings, IReadOnlyCollection<Output> Output)> NSwagListTypes(CombinatorialConfigure<NSwagListTypesSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagListTypes, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>List all controllers classes for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListWebApiControllersSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListWebApiControllersSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListWebApiControllersSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListWebApiControllersSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListWebApiControllersSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagListWebApiControllers(NSwagListWebApiControllersSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagListWebApiControllersSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>List all controllers classes for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListWebApiControllersSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListWebApiControllersSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListWebApiControllersSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListWebApiControllersSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListWebApiControllersSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagListWebApiControllers(Configure<NSwagListWebApiControllersSettings> configurator)
        {
            return NSwagListWebApiControllers(configurator(new NSwagListWebApiControllersSettings()));
        }
        /// <summary>
        ///   <p>List all controllers classes for the given assembly and settings.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagListWebApiControllersSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagListWebApiControllersSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagListWebApiControllersSettings.AssemblyConfig"/></li>
        ///     <li><c>/File</c> via <see cref="NSwagListWebApiControllersSettings.File"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagListWebApiControllersSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagListWebApiControllersSettings Settings, IReadOnlyCollection<Output> Output)> NSwagListWebApiControllers(CombinatorialConfigure<NSwagListWebApiControllersSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagListWebApiControllers, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagTypesToOpenApi(NSwagTypesToOpenApiSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagTypesToOpenApiSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagTypesToOpenApi(Configure<NSwagTypesToOpenApiSettings> configurator)
        {
            return NSwagTypesToOpenApi(configurator(new NSwagTypesToOpenApiSettings()));
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagTypesToOpenApiSettings Settings, IReadOnlyCollection<Output> Output)> NSwagTypesToOpenApi(CombinatorialConfigure<NSwagTypesToOpenApiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagTypesToOpenApi, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ClassNames</c> via <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagTypesToSwagger(NSwagTypesToSwaggerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagTypesToSwaggerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ClassNames</c> via <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagTypesToSwagger(Configure<NSwagTypesToSwaggerSettings> configurator)
        {
            return NSwagTypesToSwagger(configurator(new NSwagTypesToSwaggerSettings()));
        }
        /// <summary>
        ///   <p>The project combines the functionality of Swashbuckle (Swagger generation) and AutoRest (client generation) in one toolchain. This way a lot of incompatibilites can be avoided and features which are not well described by the Swagger specification or JSON Schema are better supported (e.g. <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Inheritance">inheritance</a>, <a href="https://github.com/NJsonSchema/NJsonSchema/wiki/Enums">enum</a> and reference handling). The NSwag project heavily uses <a href="http://njsonschema.org/">NJsonSchema for .NET</a> for JSON Schema handling and C#/TypeScript class/interface generation.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagTypesToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagTypesToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagTypesToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ClassNames</c> via <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagTypesToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagTypesToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagTypesToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagTypesToSwaggerSettings Settings, IReadOnlyCollection<Output> Output)> NSwagTypesToSwagger(CombinatorialConfigure<NSwagTypesToSwaggerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagTypesToSwagger, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagWebApiToOpenApi(NSwagWebApiToOpenApiSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagWebApiToOpenApiSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagWebApiToOpenApi(Configure<NSwagWebApiToOpenApiSettings> configurator)
        {
            return NSwagWebApiToOpenApi(configurator(new NSwagWebApiToOpenApiSettings()));
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagWebApiToOpenApiSettings Settings, IReadOnlyCollection<Output> Output)> NSwagWebApiToOpenApi(CombinatorialConfigure<NSwagWebApiToOpenApiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagWebApiToOpenApi, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly (obsolete: use webapi2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AddMissingPathParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCore</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/Controller</c> via <see cref="NSwagWebApiToSwaggerSettings.Controller"/></li>
        ///     <li><c>/Controllers</c> via <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultUrlTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultUrlTemplate"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/IncludedVersions</c> via <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/ResolveJsonOptions</c> via <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagWebApiToSwagger(NSwagWebApiToSwaggerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagWebApiToSwaggerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly (obsolete: use webapi2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AddMissingPathParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCore</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/Controller</c> via <see cref="NSwagWebApiToSwaggerSettings.Controller"/></li>
        ///     <li><c>/Controllers</c> via <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultUrlTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultUrlTemplate"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/IncludedVersions</c> via <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/ResolveJsonOptions</c> via <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagWebApiToSwagger(Configure<NSwagWebApiToSwaggerSettings> configurator)
        {
            return NSwagWebApiToSwagger(configurator(new NSwagWebApiToSwaggerSettings()));
        }
        /// <summary>
        ///   <p>Generates a Swagger/OpenAPI specification for a controller or controlles contained in a .NET Web API assembly (obsolete: use webapi2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagWebApiToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AddMissingPathParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCore</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagWebApiToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagWebApiToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagWebApiToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/Controller</c> via <see cref="NSwagWebApiToSwaggerSettings.Controller"/></li>
        ///     <li><c>/Controllers</c> via <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagWebApiToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultUrlTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DefaultUrlTemplate"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagWebApiToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/IncludedVersions</c> via <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagWebApiToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagWebApiToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagWebApiToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/ResolveJsonOptions</c> via <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagWebApiToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagWebApiToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagWebApiToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagWebApiToSwaggerSettings Settings, IReadOnlyCollection<Output> Output)> NSwagWebApiToSwagger(CombinatorialConfigure<NSwagWebApiToSwaggerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagWebApiToSwagger, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagAspNetCoreToOpenApi(NSwagAspNetCoreToOpenApiSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagAspNetCoreToOpenApiSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagAspNetCoreToOpenApi(Configure<NSwagAspNetCoreToOpenApiSettings> configurator)
        {
            return NSwagAspNetCoreToOpenApi(configurator(new NSwagAspNetCoreToOpenApiSettings()));
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.AssemblyConfig"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.InfoVersion"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.OutputType"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.Startup"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagAspNetCoreToOpenApiSettings Settings, IReadOnlyCollection<Output> Output)> NSwagAspNetCoreToOpenApi(CombinatorialConfigure<NSwagAspNetCoreToOpenApiSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagAspNetCoreToOpenApi, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer (obsolete: use aspnetcore2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/ApiGroupNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/Configuration</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Configuration"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/MSBuildProjectExtensionsPath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.MSBuildProjectExtensionsPath"/></li>
        ///     <li><c>/NoBuild</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/Project</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Project"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/RequireParametersWithoutDefault</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></li>
        ///     <li><c>/Runtime</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Runtime"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TargetFramework</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TargetFramework"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></li>
        ///     <li><c>/Verbose</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></li>
        ///     <li><c>/WorkingDirectory</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagWorkingDirectory"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagAspNetCoreToSwagger(NSwagAspNetCoreToSwaggerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagAspNetCoreToSwaggerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer (obsolete: use aspnetcore2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/ApiGroupNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/Configuration</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Configuration"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/MSBuildProjectExtensionsPath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.MSBuildProjectExtensionsPath"/></li>
        ///     <li><c>/NoBuild</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/Project</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Project"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/RequireParametersWithoutDefault</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></li>
        ///     <li><c>/Runtime</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Runtime"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TargetFramework</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TargetFramework"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></li>
        ///     <li><c>/Verbose</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></li>
        ///     <li><c>/WorkingDirectory</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagWorkingDirectory"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagAspNetCoreToSwagger(Configure<NSwagAspNetCoreToSwaggerSettings> configurator)
        {
            return NSwagAspNetCoreToSwagger(configurator(new NSwagAspNetCoreToSwaggerSettings()));
        }
        /// <summary>
        ///   <p>Generates a Swagger specification ASP.NET Core Mvc application using ApiExplorer (obsolete: use aspnetcore2openapi instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AllowNullableBodyParameters</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></li>
        ///     <li><c>/AllowReferencesWithProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></li>
        ///     <li><c>/ApiGroupNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></li>
        ///     <li><c>/AspNetCoreEnvironment</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AspNetCoreEnvironment"/></li>
        ///     <li><c>/Assembly</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></li>
        ///     <li><c>/AssemblyConfig</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.AssemblyConfig"/></li>
        ///     <li><c>/Configuration</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Configuration"/></li>
        ///     <li><c>/ContractResolver</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ContractResolver"/></li>
        ///     <li><c>/CreateWebHostBuilderMethod</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.CreateWebHostBuilderMethod"/></li>
        ///     <li><c>/DefaultDictionaryValueReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultEnumHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultEnumHandling"/></li>
        ///     <li><c>/DefaultPropertyNameHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultPropertyNameHandling"/></li>
        ///     <li><c>/DefaultReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultReferenceTypeNullHandling"/></li>
        ///     <li><c>/DefaultResponseReferenceTypeNullHandling</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></li>
        ///     <li><c>/DocumentName</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentName"/></li>
        ///     <li><c>/DocumentProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></li>
        ///     <li><c>/DocumentTemplate</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentTemplate"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/FlattenInheritanceHierarchy</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></li>
        ///     <li><c>/GenerateAbstractProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></li>
        ///     <li><c>/GenerateAbstractSchemas</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></li>
        ///     <li><c>/GenerateEnumMappingDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></li>
        ///     <li><c>/GenerateKnownTypes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></li>
        ///     <li><c>/GenerateXmlObjects</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></li>
        ///     <li><c>/IgnoreObsoleteProperties</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></li>
        ///     <li><c>/InfoDescription</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoDescription"/></li>
        ///     <li><c>/InfoTitle</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoTitle"/></li>
        ///     <li><c>/InfoVersion</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.InfoVersion"/></li>
        ///     <li><c>/MSBuildProjectExtensionsPath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.MSBuildProjectExtensionsPath"/></li>
        ///     <li><c>/NoBuild</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></li>
        ///     <li><c>/OperationProcessors</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Output"/></li>
        ///     <li><c>/OutputType</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.OutputType"/></li>
        ///     <li><c>/Project</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Project"/></li>
        ///     <li><c>/ReferencePaths</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></li>
        ///     <li><c>/RequireParametersWithoutDefault</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></li>
        ///     <li><c>/Runtime</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Runtime"/></li>
        ///     <li><c>/SchemaNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SchemaNameGenerator"/></li>
        ///     <li><c>/SerializerSettings</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.SerializerSettings"/></li>
        ///     <li><c>/ServiceBasePath</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceBasePath"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></li>
        ///     <li><c>/Startup</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Startup"/></li>
        ///     <li><c>/TargetFramework</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TargetFramework"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseDocumentProvider</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></li>
        ///     <li><c>/UseNuGetCache</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></li>
        ///     <li><c>/Verbose</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></li>
        ///     <li><c>/WorkingDirectory</c> via <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagWorkingDirectory"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagAspNetCoreToSwaggerSettings Settings, IReadOnlyCollection<Output> Output)> NSwagAspNetCoreToSwagger(CombinatorialConfigure<NSwagAspNetCoreToSwaggerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagAspNetCoreToSwagger, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Creates a new nswag.json file in the current directory.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagCreateDocumentSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagCreateDocument(NSwagCreateDocumentSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagCreateDocumentSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Creates a new nswag.json file in the current directory.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagCreateDocumentSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagCreateDocument(Configure<NSwagCreateDocumentSettings> configurator)
        {
            return NSwagCreateDocument(configurator(new NSwagCreateDocumentSettings()));
        }
        /// <summary>
        ///   <p>Creates a new nswag.json file in the current directory.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagCreateDocumentSettings.NSwagRuntime"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagCreateDocumentSettings Settings, IReadOnlyCollection<Output> Output)> NSwagCreateDocument(CombinatorialConfigure<NSwagCreateDocumentSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagCreateDocument, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Executes an .nswag file. If 'input' is not specified then all *.nswag files and the nswag.json file is executed.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagExecuteDocumentSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagExecuteDocumentSettings.Input"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagExecuteDocumentSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagExecuteDocument(NSwagExecuteDocumentSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagExecuteDocumentSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Executes an .nswag file. If 'input' is not specified then all *.nswag files and the nswag.json file is executed.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagExecuteDocumentSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagExecuteDocumentSettings.Input"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagExecuteDocumentSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagExecuteDocument(Configure<NSwagExecuteDocumentSettings> configurator)
        {
            return NSwagExecuteDocument(configurator(new NSwagExecuteDocumentSettings()));
        }
        /// <summary>
        ///   <p>Executes an .nswag file. If 'input' is not specified then all *.nswag files and the nswag.json file is executed.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagExecuteDocumentSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagExecuteDocumentSettings.Input"/></li>
        ///     <li><c>/Variables</c> via <see cref="NSwagExecuteDocumentSettings.Variables"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagExecuteDocumentSettings Settings, IReadOnlyCollection<Output> Output)> NSwagExecuteDocument(CombinatorialConfigure<NSwagExecuteDocumentSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagExecuteDocument, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates CSharp classes from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToCSharpSettings.NSwagRuntime"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.AnyType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayType"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DateTimeType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryType"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Name"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Namespace"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Output"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagJsonSchemaToCSharp(NSwagJsonSchemaToCSharpSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagJsonSchemaToCSharpSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates CSharp classes from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToCSharpSettings.NSwagRuntime"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.AnyType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayType"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DateTimeType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryType"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Name"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Namespace"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Output"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagJsonSchemaToCSharp(Configure<NSwagJsonSchemaToCSharpSettings> configurator)
        {
            return NSwagJsonSchemaToCSharp(configurator(new NSwagJsonSchemaToCSharpSettings()));
        }
        /// <summary>
        ///   <p>Generates CSharp classes from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToCSharpSettings.NSwagRuntime"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.AnyType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ArrayType"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DateTimeType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryType"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Name"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Namespace"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToCSharpSettings.Output"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagJsonSchemaToCSharpSettings Settings, IReadOnlyCollection<Output> Output)> NSwagJsonSchemaToCSharp(CombinatorialConfigure<NSwagJsonSchemaToCSharpSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagJsonSchemaToCSharp, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates TypeScript interfaces from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Name"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Output"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagJsonSchemaToTypeScript(NSwagJsonSchemaToTypeScriptSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagJsonSchemaToTypeScriptSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates TypeScript interfaces from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Name"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Output"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagJsonSchemaToTypeScript(Configure<NSwagJsonSchemaToTypeScriptSettings> configurator)
        {
            return NSwagJsonSchemaToTypeScript(configurator(new NSwagJsonSchemaToTypeScriptSettings()));
        }
        /// <summary>
        ///   <p>Generates TypeScript interfaces from a JSON Schema.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.NSwagRuntime"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Input"/></li>
        ///     <li><c>/Name</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Name"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.Output"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagJsonSchemaToTypeScriptSettings Settings, IReadOnlyCollection<Output> Output)> NSwagJsonSchemaToTypeScript(CombinatorialConfigure<NSwagJsonSchemaToTypeScriptSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagJsonSchemaToTypeScript, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToCSharpClient(NSwagOpenApiToCSharpClientSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagOpenApiToCSharpClientSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToCSharpClient(Configure<NSwagOpenApiToCSharpClientSettings> configurator)
        {
            return NSwagOpenApiToCSharpClient(configurator(new NSwagOpenApiToCSharpClientSettings()));
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagOpenApiToCSharpClientSettings Settings, IReadOnlyCollection<Output> Output)> NSwagOpenApiToCSharpClient(CombinatorialConfigure<NSwagOpenApiToCSharpClientSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagOpenApiToCSharpClient, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification (obsolete: use openapi2csclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ClientClassAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientClassAccessModifier"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ContractsNamespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsNamespace"/></li>
        ///     <li><c>/ContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsOutput"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/DisposeHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DisposeHttpClient"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExposeJsonSerializerSettings</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExposeJsonSerializerSettings"/></li>
        ///     <li><c>/GenerateBaseUrlProperty</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateBaseUrlProperty"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateContractsOutput"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateExceptionClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateExceptionClasses"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/GenerateSyncMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateSyncMethods"/></li>
        ///     <li><c>/GenerateUpdateJsonSerializerSettingsMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateUpdateJsonSerializerSettingsMethod"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClientType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HttpClientType"/></li>
        ///     <li><c>/InjectHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InjectHttpClient"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDateFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateFormat"/></li>
        ///     <li><c>/ParameterDateTimeFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateTimeFormat"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToCSharpClientSettings.QueryNullValue"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/SerializeTypeInformation</c> via <see cref="NSwagSwaggerToCSharpClientSettings.SerializeTypeInformation"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeAccessModifier"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseBaseUrl</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseBaseUrl"/></li>
        ///     <li><c>/UseHttpClientCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpClientCreationMethod"/></li>
        ///     <li><c>/UseHttpRequestMessageCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpRequestMessageCreationMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToCSharpClient(NSwagSwaggerToCSharpClientSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagSwaggerToCSharpClientSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification (obsolete: use openapi2csclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ClientClassAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientClassAccessModifier"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ContractsNamespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsNamespace"/></li>
        ///     <li><c>/ContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsOutput"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/DisposeHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DisposeHttpClient"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExposeJsonSerializerSettings</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExposeJsonSerializerSettings"/></li>
        ///     <li><c>/GenerateBaseUrlProperty</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateBaseUrlProperty"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateContractsOutput"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateExceptionClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateExceptionClasses"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/GenerateSyncMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateSyncMethods"/></li>
        ///     <li><c>/GenerateUpdateJsonSerializerSettingsMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateUpdateJsonSerializerSettingsMethod"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClientType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HttpClientType"/></li>
        ///     <li><c>/InjectHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InjectHttpClient"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDateFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateFormat"/></li>
        ///     <li><c>/ParameterDateTimeFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateTimeFormat"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToCSharpClientSettings.QueryNullValue"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/SerializeTypeInformation</c> via <see cref="NSwagSwaggerToCSharpClientSettings.SerializeTypeInformation"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeAccessModifier"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseBaseUrl</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseBaseUrl"/></li>
        ///     <li><c>/UseHttpClientCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpClientCreationMethod"/></li>
        ///     <li><c>/UseHttpRequestMessageCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpRequestMessageCreationMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToCSharpClient(Configure<NSwagSwaggerToCSharpClientSettings> configurator)
        {
            return NSwagSwaggerToCSharpClient(configurator(new NSwagSwaggerToCSharpClientSettings()));
        }
        /// <summary>
        ///   <p>Generates CSharp client code from a Swagger/OpenAPI specification (obsolete: use openapi2csclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClassStyle"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ClientClassAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ClientClassAccessModifier"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ContractsNamespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsNamespace"/></li>
        ///     <li><c>/ContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ContractsOutput"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DictionaryType"/></li>
        ///     <li><c>/DisposeHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.DisposeHttpClient"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExposeJsonSerializerSettings</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ExposeJsonSerializerSettings"/></li>
        ///     <li><c>/GenerateBaseUrlProperty</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateBaseUrlProperty"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateContractsOutput</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateContractsOutput"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateExceptionClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateExceptionClasses"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/GenerateSyncMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateSyncMethods"/></li>
        ///     <li><c>/GenerateUpdateJsonSerializerSettingsMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.GenerateUpdateJsonSerializerSettingsMethod"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClientType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.HttpClientType"/></li>
        ///     <li><c>/InjectHttpClient</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InjectHttpClient"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpClientSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpClientSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDateFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateFormat"/></li>
        ///     <li><c>/ParameterDateTimeFormat</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDateTimeFormat"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToCSharpClientSettings.QueryNullValue"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpClientSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/SerializeTypeInformation</c> via <see cref="NSwagSwaggerToCSharpClientSettings.SerializeTypeInformation"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TimeType"/></li>
        ///     <li><c>/TypeAccessModifier</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeAccessModifier"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseBaseUrl</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseBaseUrl"/></li>
        ///     <li><c>/UseHttpClientCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpClientCreationMethod"/></li>
        ///     <li><c>/UseHttpRequestMessageCreationMethod</c> via <see cref="NSwagSwaggerToCSharpClientSettings.UseHttpRequestMessageCreationMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagSwaggerToCSharpClientSettings Settings, IReadOnlyCollection<Output> Output)> NSwagSwaggerToCSharpClient(CombinatorialConfigure<NSwagSwaggerToCSharpClientSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagSwaggerToCSharpClient, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToCSharpController(NSwagOpenApiToCSharpControllerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagOpenApiToCSharpControllerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToCSharpController(Configure<NSwagOpenApiToCSharpControllerSettings> configurator)
        {
            return NSwagOpenApiToCSharpController(configurator(new NSwagOpenApiToCSharpControllerSettings()));
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagOpenApiToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagOpenApiToCSharpControllerSettings Settings, IReadOnlyCollection<Output> Output)> NSwagOpenApiToCSharpController(CombinatorialConfigure<NSwagOpenApiToCSharpControllerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagOpenApiToCSharpController, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification (obsolete: use openapi2cscontroller instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/BasePath</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.BasePath"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/ControllerBaseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerBaseClass"/></li>
        ///     <li><c>/ControllerStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerStyle"/></li>
        ///     <li><c>/ControllerTarget</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerTarget"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateModelValidationAttributes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateModelValidationAttributes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/RouteNamingStrategy</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RouteNamingStrategy"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseActionResultType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseActionResultType"/></li>
        ///     <li><c>/UseCancellationToken</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseCancellationToken"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToCSharpController(NSwagSwaggerToCSharpControllerSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagSwaggerToCSharpControllerSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification (obsolete: use openapi2cscontroller instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/BasePath</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.BasePath"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/ControllerBaseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerBaseClass"/></li>
        ///     <li><c>/ControllerStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerStyle"/></li>
        ///     <li><c>/ControllerTarget</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerTarget"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateModelValidationAttributes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateModelValidationAttributes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/RouteNamingStrategy</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RouteNamingStrategy"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseActionResultType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseActionResultType"/></li>
        ///     <li><c>/UseCancellationToken</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseCancellationToken"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToCSharpController(Configure<NSwagSwaggerToCSharpControllerSettings> configurator)
        {
            return NSwagSwaggerToCSharpController(configurator(new NSwagSwaggerToCSharpControllerSettings()));
        }
        /// <summary>
        ///   <p>Generates CSharp Web API controller code from a Swagger/OpenAPI specification (obsolete: use openapi2cscontroller instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.NSwagRuntime"/></li>
        ///     <li><c>/AdditionalContractNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalContractNamespaceUsages"/></li>
        ///     <li><c>/AdditionalNamespaceUsages</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AdditionalNamespaceUsages"/></li>
        ///     <li><c>/AnyType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.AnyType"/></li>
        ///     <li><c>/ArrayBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayBaseType"/></li>
        ///     <li><c>/ArrayInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayInstanceType"/></li>
        ///     <li><c>/ArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ArrayType"/></li>
        ///     <li><c>/BasePath</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.BasePath"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassName"/></li>
        ///     <li><c>/ClassStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ClassStyle"/></li>
        ///     <li><c>/ControllerBaseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerBaseClass"/></li>
        ///     <li><c>/ControllerStyle</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerStyle"/></li>
        ///     <li><c>/ControllerTarget</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ControllerTarget"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateTimeType"/></li>
        ///     <li><c>/DateType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DateType"/></li>
        ///     <li><c>/DictionaryBaseType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryBaseType"/></li>
        ///     <li><c>/DictionaryInstanceType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryInstanceType"/></li>
        ///     <li><c>/DictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.DictionaryType"/></li>
        ///     <li><c>/EnforceFlagEnums</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnforceFlagEnums"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/GenerateDataAnnotations</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDataAnnotations"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateImmutableArrayProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableArrayProperties"/></li>
        ///     <li><c>/GenerateImmutableDictionaryProperties</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateImmutableDictionaryProperties"/></li>
        ///     <li><c>/GenerateJsonMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateJsonMethods"/></li>
        ///     <li><c>/GenerateModelValidationAttributes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateModelValidationAttributes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateOptionalPropertiesAsNullable</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateOptionalPropertiesAsNullable"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.HandleReferences"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedArrays</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedArrays"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/InlineNamedTuples</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.InlineNamedTuples"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Input"/></li>
        ///     <li><c>/JsonConverters</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonConverters"/></li>
        ///     <li><c>/JsonSerializerSettingsTransformationMethod</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.JsonSerializerSettingsTransformationMethod"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Namespace"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.Output"/></li>
        ///     <li><c>/ParameterArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterArrayType"/></li>
        ///     <li><c>/ParameterDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ParameterDictionaryType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/RequiredPropertiesMustBeDefined</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RequiredPropertiesMustBeDefined"/></li>
        ///     <li><c>/ResponseArrayType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseArrayType"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseClass"/></li>
        ///     <li><c>/ResponseDictionaryType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ResponseDictionaryType"/></li>
        ///     <li><c>/RouteNamingStrategy</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.RouteNamingStrategy"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TemplateDirectory"/></li>
        ///     <li><c>/TimeSpanType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeSpanType"/></li>
        ///     <li><c>/TimeType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TimeType"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.TypeNameGenerator"/></li>
        ///     <li><c>/UseActionResultType</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseActionResultType"/></li>
        ///     <li><c>/UseCancellationToken</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.UseCancellationToken"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToCSharpControllerSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagSwaggerToCSharpControllerSettings Settings, IReadOnlyCollection<Output> Output)> NSwagSwaggerToCSharpController(CombinatorialConfigure<NSwagSwaggerToCSharpControllerSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagSwaggerToCSharpController, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToTypeScriptClient(NSwagOpenApiToTypeScriptClientSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagOpenApiToTypeScriptClientSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagOpenApiToTypeScriptClient(Configure<NSwagOpenApiToTypeScriptClientSettings> configurator)
        {
            return NSwagOpenApiToTypeScriptClient(configurator(new NSwagOpenApiToTypeScriptClientSettings()));
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification.</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagOpenApiToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagOpenApiToTypeScriptClientSettings Settings, IReadOnlyCollection<Output> Output)> NSwagOpenApiToTypeScriptClient(CombinatorialConfigure<NSwagOpenApiToTypeScriptClientSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagOpenApiToTypeScriptClient, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification (obsolete: use openapi2tsclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/BaseUrlTokenName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.BaseUrlTokenName"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassName"/></li>
        ///     <li><c>/ClassTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassTypes"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ConvertConstructorInterfaceData</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConvertConstructorInterfaceData"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.DateTimeType"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExportTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExportTypes"/></li>
        ///     <li><c>/ExtendedClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtendedClasses"/></li>
        ///     <li><c>/ExtensionCode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtensionCode"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateCloneMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateCloneMethod"/></li>
        ///     <li><c>/GenerateConstructorInterface</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateConstructorInterface"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HttpClass"/></li>
        ///     <li><c>/ImportRequiredTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ImportRequiredTypes"/></li>
        ///     <li><c>/InjectionTokenType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InjectionTokenType"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/MarkOptionalProperties</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.MarkOptionalProperties"/></li>
        ///     <li><c>/ModuleName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ModuleName"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Namespace"/></li>
        ///     <li><c>/NullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NullValue"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PromiseType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PromiseType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.QueryNullValue"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ResponseClass"/></li>
        ///     <li><c>/RxJsVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.RxJsVersion"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/Template</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Template"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/TypeScriptVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeScriptVersion"/></li>
        ///     <li><c>/TypeStyle</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeStyle"/></li>
        ///     <li><c>/UseGetBaseUrlMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseGetBaseUrlMethod"/></li>
        ///     <li><c>/UseSingletonProvider</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseSingletonProvider"/></li>
        ///     <li><c>/UseTransformOptionsMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformOptionsMethod"/></li>
        ///     <li><c>/UseTransformResultMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformResultMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToTypeScriptClient(NSwagSwaggerToTypeScriptClientSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new NSwagSwaggerToTypeScriptClientSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification (obsolete: use openapi2tsclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/BaseUrlTokenName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.BaseUrlTokenName"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassName"/></li>
        ///     <li><c>/ClassTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassTypes"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ConvertConstructorInterfaceData</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConvertConstructorInterfaceData"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.DateTimeType"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExportTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExportTypes"/></li>
        ///     <li><c>/ExtendedClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtendedClasses"/></li>
        ///     <li><c>/ExtensionCode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtensionCode"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateCloneMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateCloneMethod"/></li>
        ///     <li><c>/GenerateConstructorInterface</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateConstructorInterface"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HttpClass"/></li>
        ///     <li><c>/ImportRequiredTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ImportRequiredTypes"/></li>
        ///     <li><c>/InjectionTokenType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InjectionTokenType"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/MarkOptionalProperties</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.MarkOptionalProperties"/></li>
        ///     <li><c>/ModuleName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ModuleName"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Namespace"/></li>
        ///     <li><c>/NullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NullValue"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PromiseType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PromiseType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.QueryNullValue"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ResponseClass"/></li>
        ///     <li><c>/RxJsVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.RxJsVersion"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/Template</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Template"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/TypeScriptVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeScriptVersion"/></li>
        ///     <li><c>/TypeStyle</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeStyle"/></li>
        ///     <li><c>/UseGetBaseUrlMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseGetBaseUrlMethod"/></li>
        ///     <li><c>/UseSingletonProvider</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseSingletonProvider"/></li>
        ///     <li><c>/UseTransformOptionsMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformOptionsMethod"/></li>
        ///     <li><c>/UseTransformResultMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformResultMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> NSwagSwaggerToTypeScriptClient(Configure<NSwagSwaggerToTypeScriptClientSettings> configurator)
        {
            return NSwagSwaggerToTypeScriptClient(configurator(new NSwagSwaggerToTypeScriptClientSettings()));
        }
        /// <summary>
        ///   <p>Generates TypeScript client code from a Swagger/OpenAPI specification (obsolete: use openapi2tsclient instead).</p>
        ///   <p>For more details, visit the <a href="https://github.com/RSuter/NSwag">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>&lt;nswagRuntime&gt;</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NSwagRuntime"/></li>
        ///     <li><c>/BaseUrlTokenName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.BaseUrlTokenName"/></li>
        ///     <li><c>/ClassName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassName"/></li>
        ///     <li><c>/ClassTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClassTypes"/></li>
        ///     <li><c>/ClientBaseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ClientBaseClass"/></li>
        ///     <li><c>/ConfigurationClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConfigurationClass"/></li>
        ///     <li><c>/ConvertConstructorInterfaceData</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ConvertConstructorInterfaceData"/></li>
        ///     <li><c>/DateTimeType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.DateTimeType"/></li>
        ///     <li><c>/EnumNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.EnumNameGeneratorType"/></li>
        ///     <li><c>/ExceptionClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExceptionClass"/></li>
        ///     <li><c>/ExcludedParameterNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedParameterNames"/></li>
        ///     <li><c>/ExcludedTypeNames</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExcludedTypeNames"/></li>
        ///     <li><c>/ExportTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExportTypes"/></li>
        ///     <li><c>/ExtendedClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtendedClasses"/></li>
        ///     <li><c>/ExtensionCode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ExtensionCode"/></li>
        ///     <li><c>/GenerateClientClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientClasses"/></li>
        ///     <li><c>/GenerateClientInterfaces</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateClientInterfaces"/></li>
        ///     <li><c>/GenerateCloneMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateCloneMethod"/></li>
        ///     <li><c>/GenerateConstructorInterface</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateConstructorInterface"/></li>
        ///     <li><c>/GenerateDefaultValues</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDefaultValues"/></li>
        ///     <li><c>/GenerateDtoTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateDtoTypes"/></li>
        ///     <li><c>/GenerateOptionalParameters</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateOptionalParameters"/></li>
        ///     <li><c>/GenerateResponseClasses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.GenerateResponseClasses"/></li>
        ///     <li><c>/HandleReferences</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HandleReferences"/></li>
        ///     <li><c>/HttpClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.HttpClass"/></li>
        ///     <li><c>/ImportRequiredTypes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ImportRequiredTypes"/></li>
        ///     <li><c>/InjectionTokenType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InjectionTokenType"/></li>
        ///     <li><c>/InlineNamedAny</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedAny"/></li>
        ///     <li><c>/InlineNamedDictionaries</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.InlineNamedDictionaries"/></li>
        ///     <li><c>/Input</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Input"/></li>
        ///     <li><c>/MarkOptionalProperties</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.MarkOptionalProperties"/></li>
        ///     <li><c>/ModuleName</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ModuleName"/></li>
        ///     <li><c>/Namespace</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Namespace"/></li>
        ///     <li><c>/NullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.NullValue"/></li>
        ///     <li><c>/OperationGenerationMode</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.OperationGenerationMode"/></li>
        ///     <li><c>/Output</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Output"/></li>
        ///     <li><c>/PromiseType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PromiseType"/></li>
        ///     <li><c>/PropertyNameGeneratorType</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.PropertyNameGeneratorType"/></li>
        ///     <li><c>/ProtectedMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ProtectedMethods"/></li>
        ///     <li><c>/QueryNullValue</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.QueryNullValue"/></li>
        ///     <li><c>/ResponseClass</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ResponseClass"/></li>
        ///     <li><c>/RxJsVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.RxJsVersion"/></li>
        ///     <li><c>/ServiceHost</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceHost"/></li>
        ///     <li><c>/ServiceSchemes</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.ServiceSchemes"/></li>
        ///     <li><c>/Template</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.Template"/></li>
        ///     <li><c>/TemplateDirectory</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TemplateDirectory"/></li>
        ///     <li><c>/TypeNameGenerator</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeNameGenerator"/></li>
        ///     <li><c>/TypeScriptVersion</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeScriptVersion"/></li>
        ///     <li><c>/TypeStyle</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.TypeStyle"/></li>
        ///     <li><c>/UseGetBaseUrlMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseGetBaseUrlMethod"/></li>
        ///     <li><c>/UseSingletonProvider</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseSingletonProvider"/></li>
        ///     <li><c>/UseTransformOptionsMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformOptionsMethod"/></li>
        ///     <li><c>/UseTransformResultMethod</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.UseTransformResultMethod"/></li>
        ///     <li><c>/WrapDtoExceptions</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapDtoExceptions"/></li>
        ///     <li><c>/WrapResponseMethods</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponseMethods"/></li>
        ///     <li><c>/WrapResponses</c> via <see cref="NSwagSwaggerToTypeScriptClientSettings.WrapResponses"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(NSwagSwaggerToTypeScriptClientSettings Settings, IReadOnlyCollection<Output> Output)> NSwagSwaggerToTypeScriptClient(CombinatorialConfigure<NSwagSwaggerToTypeScriptClientSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(NSwagSwaggerToTypeScriptClient, NSwagLogger, degreeOfParallelism, completeOnFailure);
        }
    }
    #region NSwagVersionSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagVersionSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("version")
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagListTypesSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagListTypesSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The nswag.json configuration file path.
        /// </summary>
        public virtual string File { get; internal set; }
        public virtual IReadOnlyDictionary<string, object> Variables => VariablesInternal.AsReadOnly();
        internal Dictionary<string,object> VariablesInternal { get; set; } = new Dictionary<string,object>(StringComparer.OrdinalIgnoreCase);
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("list-types")
              .Add("/File:{value}", File)
              .Add("/Variables:{value}", Variables, "{key}={value}")
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagListWebApiControllersSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagListWebApiControllersSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The nswag.json configuration file path.
        /// </summary>
        public virtual string File { get; internal set; }
        public virtual IReadOnlyDictionary<string, object> Variables => VariablesInternal.AsReadOnly();
        internal Dictionary<string,object> VariablesInternal { get; set; } = new Dictionary<string,object>(StringComparer.OrdinalIgnoreCase);
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("list-controllers")
              .Add("/File:{value}", File)
              .Add("/Variables:{value}", Variables, "{key}={value}")
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagTypesToOpenApiSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagTypesToOpenApiSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("types2openapi")
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagTypesToSwaggerSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagTypesToSwaggerSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).
        /// </summary>
        public virtual bool? AllowReferencesWithProperties { get; internal set; }
        /// <summary>
        ///   The class names.
        /// </summary>
        public virtual IReadOnlyList<string> ClassNames => ClassNamesInternal.AsReadOnly();
        internal List<string> ClassNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The default reference type null handling of dictionary value types (NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultDictionaryValueReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default enum handling ('String' or 'Integer'), default: Integer.
        /// </summary>
        public virtual EnumHandling DefaultEnumHandling { get; internal set; }
        /// <summary>
        ///   The default property name handling ('Default' or 'CamelCase').
        /// </summary>
        public virtual PropertyNameHandling DefaultPropertyNameHandling { get; internal set; }
        /// <summary>
        ///   The default reference type null handling (Null (default) or NotNull).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).
        /// </summary>
        public virtual bool? FlattenInheritanceHierarchy { get; internal set; }
        /// <summary>
        ///   Generate schemas for types in KnownTypeAttribute attributes (default: true).
        /// </summary>
        public virtual bool? GenerateKnownTypes { get; internal set; }
        /// <summary>
        ///   Generate xmlObject representation for definitions (default: false).
        /// </summary>
        public virtual bool? GenerateXmlObjects { get; internal set; }
        /// <summary>
        ///   Ignore properties with the ObsoleteAttribute (default: false).
        /// </summary>
        public virtual bool? IgnoreObsoleteProperties { get; internal set; }
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("types2swagger")
              .Add("/AllowReferencesWithProperties:{value}", AllowReferencesWithProperties)
              .Add("/ClassNames:{value}", ClassNames)
              .Add("/DefaultDictionaryValueReferenceTypeNullHandling:{value}", DefaultDictionaryValueReferenceTypeNullHandling)
              .Add("/DefaultEnumHandling:{value}", DefaultEnumHandling)
              .Add("/DefaultPropertyNameHandling:{value}", DefaultPropertyNameHandling)
              .Add("/DefaultReferenceTypeNullHandling:{value}", DefaultReferenceTypeNullHandling)
              .Add("/FlattenInheritanceHierarchy:{value}", FlattenInheritanceHierarchy)
              .Add("/GenerateKnownTypes:{value}", GenerateKnownTypes)
              .Add("/GenerateXmlObjects:{value}", GenerateXmlObjects)
              .Add("/IgnoreObsoleteProperties:{value}", IgnoreObsoleteProperties)
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagWebApiToOpenApiSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagWebApiToOpenApiSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).
        /// </summary>
        public virtual bool? AllowNullableBodyParameters { get; internal set; }
        /// <summary>
        ///   Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).
        /// </summary>
        public virtual bool? AllowReferencesWithProperties { get; internal set; }
        /// <summary>
        ///   Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).
        /// </summary>
        public virtual string AspNetCoreEnvironment { get; internal set; }
        /// <summary>
        ///   DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string ContractResolver { get; internal set; }
        /// <summary>
        ///   The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.
        /// </summary>
        public virtual string CreateWebHostBuilderMethod { get; internal set; }
        /// <summary>
        ///   The default reference type null handling of dictionary value types (NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultDictionaryValueReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default enum handling ('String' or 'Integer'), default: Integer.
        /// </summary>
        public virtual EnumHandling DefaultEnumHandling { get; internal set; }
        /// <summary>
        ///   The default property name handling ('Default' or 'CamelCase').
        /// </summary>
        public virtual PropertyNameHandling DefaultPropertyNameHandling { get; internal set; }
        /// <summary>
        ///   The default reference type null handling (Null (default) or NotNull).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default response reference type null handling (default: NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultResponseReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The document name to use in SwaggerDocumentProvider (default: v1).
        /// </summary>
        public virtual string DocumentName { get; internal set; }
        /// <summary>
        ///   The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> DocumentProcessors => DocumentProcessorsInternal.AsReadOnly();
        internal List<string> DocumentProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies the Swagger document template (may be a path or JSON, default: none).
        /// </summary>
        public virtual string DocumentTemplate { get; internal set; }
        /// <summary>
        ///   The excluded type names (same as JsonSchemaIgnoreAttribute).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).
        /// </summary>
        public virtual bool? FlattenInheritanceHierarchy { get; internal set; }
        /// <summary>
        ///   Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).
        /// </summary>
        public virtual bool? GenerateAbstractProperties { get; internal set; }
        /// <summary>
        ///   Generate the x-abstract flag on schemas (default: true).
        /// </summary>
        public virtual bool? GenerateAbstractSchemas { get; internal set; }
        /// <summary>
        ///   Generate a description with number to enum name mappings (for integer enums only, default: false).
        /// </summary>
        public virtual bool? GenerateEnumMappingDescription { get; internal set; }
        /// <summary>
        ///   Generate schemas for types in KnownTypeAttribute attributes (default: true).
        /// </summary>
        public virtual bool? GenerateKnownTypes { get; internal set; }
        /// <summary>
        ///   Generate xmlObject representation for definitions (default: false).
        /// </summary>
        public virtual bool? GenerateXmlObjects { get; internal set; }
        /// <summary>
        ///   Ignore properties with the ObsoleteAttribute (default: false).
        /// </summary>
        public virtual bool? IgnoreObsoleteProperties { get; internal set; }
        /// <summary>
        ///   Specify the description of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoDescription { get; internal set; }
        /// <summary>
        ///   Specify the title of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoTitle { get; internal set; }
        /// <summary>
        ///   Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoVersion { get; internal set; }
        /// <summary>
        ///   The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> OperationProcessors => OperationProcessorsInternal.AsReadOnly();
        internal List<string> OperationProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SchemaNameGenerator { get; internal set; }
        /// <summary>
        ///   The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SerializerSettings { get; internal set; }
        /// <summary>
        ///   The basePath of the Swagger specification (optional).
        /// </summary>
        public virtual string ServiceBasePath { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web service (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.
        /// </summary>
        public virtual string Startup { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).
        /// </summary>
        public virtual bool? UseDocumentProvider { get; internal set; }
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("webapi2openapi")
              .Add("/AllowNullableBodyParameters:{value}", AllowNullableBodyParameters)
              .Add("/AllowReferencesWithProperties:{value}", AllowReferencesWithProperties)
              .Add("/AspNetCoreEnvironment:{value}", AspNetCoreEnvironment)
              .Add("/ContractResolver:{value}", ContractResolver)
              .Add("/CreateWebHostBuilderMethod:{value}", CreateWebHostBuilderMethod)
              .Add("/DefaultDictionaryValueReferenceTypeNullHandling:{value}", DefaultDictionaryValueReferenceTypeNullHandling)
              .Add("/DefaultEnumHandling:{value}", DefaultEnumHandling)
              .Add("/DefaultPropertyNameHandling:{value}", DefaultPropertyNameHandling)
              .Add("/DefaultReferenceTypeNullHandling:{value}", DefaultReferenceTypeNullHandling)
              .Add("/DefaultResponseReferenceTypeNullHandling:{value}", DefaultResponseReferenceTypeNullHandling)
              .Add("/DocumentName:{value}", DocumentName)
              .Add("/DocumentProcessors:{value}", DocumentProcessors)
              .Add("/DocumentTemplate:{value}", DocumentTemplate)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/FlattenInheritanceHierarchy:{value}", FlattenInheritanceHierarchy)
              .Add("/GenerateAbstractProperties:{value}", GenerateAbstractProperties)
              .Add("/GenerateAbstractSchemas:{value}", GenerateAbstractSchemas)
              .Add("/GenerateEnumMappingDescription:{value}", GenerateEnumMappingDescription)
              .Add("/GenerateKnownTypes:{value}", GenerateKnownTypes)
              .Add("/GenerateXmlObjects:{value}", GenerateXmlObjects)
              .Add("/IgnoreObsoleteProperties:{value}", IgnoreObsoleteProperties)
              .Add("/InfoDescription:{value}", InfoDescription)
              .Add("/InfoTitle:{value}", InfoTitle)
              .Add("/InfoVersion:{value}", InfoVersion)
              .Add("/OperationProcessors:{value}", OperationProcessors)
              .Add("/SchemaNameGenerator:{value}", SchemaNameGenerator)
              .Add("/SerializerSettings:{value}", SerializerSettings)
              .Add("/ServiceBasePath:{value}", ServiceBasePath)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Startup:{value}", Startup)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/UseDocumentProvider:{value}", UseDocumentProvider)
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagWebApiToSwaggerSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagWebApiToSwaggerSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   Specifies whether to add path parameters which are missing in the action method (default: true).
        /// </summary>
        public virtual bool? AddMissingPathParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether the controllers are hosted by ASP.NET Core.
        /// </summary>
        public virtual bool? AspNetCore { get; internal set; }
        /// <summary>
        ///   The Web API controller full class name or empty to load all controllers from the assembly.
        /// </summary>
        public virtual string Controller { get; internal set; }
        /// <summary>
        ///   The Web API controller full class names or empty to load all controllers from the assembly (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Controllers => ControllersInternal.AsReadOnly();
        internal List<string> ControllersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Web API default URL template (default for Web API: 'api/{controller}/{id}'; for MVC projects: '{controller}/{action}/{id?}').
        /// </summary>
        public virtual string DefaultUrlTemplate { get; internal set; }
        /// <summary>
        ///   The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).
        /// </summary>
        public virtual IReadOnlyList<string> IncludedVersions => IncludedVersionsInternal.AsReadOnly();
        internal List<string> IncludedVersionsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).
        /// </summary>
        public virtual bool? ResolveJsonOptions { get; internal set; }
        /// <summary>
        ///   Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).
        /// </summary>
        public virtual bool? AllowNullableBodyParameters { get; internal set; }
        /// <summary>
        ///   Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).
        /// </summary>
        public virtual bool? AllowReferencesWithProperties { get; internal set; }
        /// <summary>
        ///   Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).
        /// </summary>
        public virtual string AspNetCoreEnvironment { get; internal set; }
        /// <summary>
        ///   DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string ContractResolver { get; internal set; }
        /// <summary>
        ///   The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.
        /// </summary>
        public virtual string CreateWebHostBuilderMethod { get; internal set; }
        /// <summary>
        ///   The default reference type null handling of dictionary value types (NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultDictionaryValueReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default enum handling ('String' or 'Integer'), default: Integer.
        /// </summary>
        public virtual EnumHandling DefaultEnumHandling { get; internal set; }
        /// <summary>
        ///   The default property name handling ('Default' or 'CamelCase').
        /// </summary>
        public virtual PropertyNameHandling DefaultPropertyNameHandling { get; internal set; }
        /// <summary>
        ///   The default reference type null handling (Null (default) or NotNull).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default response reference type null handling (default: NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultResponseReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The document name to use in SwaggerDocumentProvider (default: v1).
        /// </summary>
        public virtual string DocumentName { get; internal set; }
        /// <summary>
        ///   The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> DocumentProcessors => DocumentProcessorsInternal.AsReadOnly();
        internal List<string> DocumentProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies the Swagger document template (may be a path or JSON, default: none).
        /// </summary>
        public virtual string DocumentTemplate { get; internal set; }
        /// <summary>
        ///   The excluded type names (same as JsonSchemaIgnoreAttribute).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).
        /// </summary>
        public virtual bool? FlattenInheritanceHierarchy { get; internal set; }
        /// <summary>
        ///   Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).
        /// </summary>
        public virtual bool? GenerateAbstractProperties { get; internal set; }
        /// <summary>
        ///   Generate the x-abstract flag on schemas (default: true).
        /// </summary>
        public virtual bool? GenerateAbstractSchemas { get; internal set; }
        /// <summary>
        ///   Generate a description with number to enum name mappings (for integer enums only, default: false).
        /// </summary>
        public virtual bool? GenerateEnumMappingDescription { get; internal set; }
        /// <summary>
        ///   Generate schemas for types in KnownTypeAttribute attributes (default: true).
        /// </summary>
        public virtual bool? GenerateKnownTypes { get; internal set; }
        /// <summary>
        ///   Generate xmlObject representation for definitions (default: false).
        /// </summary>
        public virtual bool? GenerateXmlObjects { get; internal set; }
        /// <summary>
        ///   Ignore properties with the ObsoleteAttribute (default: false).
        /// </summary>
        public virtual bool? IgnoreObsoleteProperties { get; internal set; }
        /// <summary>
        ///   Specify the description of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoDescription { get; internal set; }
        /// <summary>
        ///   Specify the title of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoTitle { get; internal set; }
        /// <summary>
        ///   Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoVersion { get; internal set; }
        /// <summary>
        ///   The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> OperationProcessors => OperationProcessorsInternal.AsReadOnly();
        internal List<string> OperationProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SchemaNameGenerator { get; internal set; }
        /// <summary>
        ///   The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SerializerSettings { get; internal set; }
        /// <summary>
        ///   The basePath of the Swagger specification (optional).
        /// </summary>
        public virtual string ServiceBasePath { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web service (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.
        /// </summary>
        public virtual string Startup { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).
        /// </summary>
        public virtual bool? UseDocumentProvider { get; internal set; }
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("webapi2swagger")
              .Add("/AddMissingPathParameters:{value}", AddMissingPathParameters)
              .Add("/AspNetCore:{value}", AspNetCore)
              .Add("/Controller:{value}", Controller)
              .Add("/Controllers:{value}", Controllers)
              .Add("/DefaultUrlTemplate:{value}", DefaultUrlTemplate)
              .Add("/IncludedVersions:{value}", IncludedVersions)
              .Add("/ResolveJsonOptions:{value}", ResolveJsonOptions)
              .Add("/AllowNullableBodyParameters:{value}", AllowNullableBodyParameters)
              .Add("/AllowReferencesWithProperties:{value}", AllowReferencesWithProperties)
              .Add("/AspNetCoreEnvironment:{value}", AspNetCoreEnvironment)
              .Add("/ContractResolver:{value}", ContractResolver)
              .Add("/CreateWebHostBuilderMethod:{value}", CreateWebHostBuilderMethod)
              .Add("/DefaultDictionaryValueReferenceTypeNullHandling:{value}", DefaultDictionaryValueReferenceTypeNullHandling)
              .Add("/DefaultEnumHandling:{value}", DefaultEnumHandling)
              .Add("/DefaultPropertyNameHandling:{value}", DefaultPropertyNameHandling)
              .Add("/DefaultReferenceTypeNullHandling:{value}", DefaultReferenceTypeNullHandling)
              .Add("/DefaultResponseReferenceTypeNullHandling:{value}", DefaultResponseReferenceTypeNullHandling)
              .Add("/DocumentName:{value}", DocumentName)
              .Add("/DocumentProcessors:{value}", DocumentProcessors)
              .Add("/DocumentTemplate:{value}", DocumentTemplate)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/FlattenInheritanceHierarchy:{value}", FlattenInheritanceHierarchy)
              .Add("/GenerateAbstractProperties:{value}", GenerateAbstractProperties)
              .Add("/GenerateAbstractSchemas:{value}", GenerateAbstractSchemas)
              .Add("/GenerateEnumMappingDescription:{value}", GenerateEnumMappingDescription)
              .Add("/GenerateKnownTypes:{value}", GenerateKnownTypes)
              .Add("/GenerateXmlObjects:{value}", GenerateXmlObjects)
              .Add("/IgnoreObsoleteProperties:{value}", IgnoreObsoleteProperties)
              .Add("/InfoDescription:{value}", InfoDescription)
              .Add("/InfoTitle:{value}", InfoTitle)
              .Add("/InfoVersion:{value}", InfoVersion)
              .Add("/OperationProcessors:{value}", OperationProcessors)
              .Add("/SchemaNameGenerator:{value}", SchemaNameGenerator)
              .Add("/SerializerSettings:{value}", SerializerSettings)
              .Add("/ServiceBasePath:{value}", ServiceBasePath)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Startup:{value}", Startup)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/UseDocumentProvider:{value}", UseDocumentProvider)
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagAspNetCoreToOpenApiSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagAspNetCoreToOpenApiSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).
        /// </summary>
        public virtual bool? AllowNullableBodyParameters { get; internal set; }
        /// <summary>
        ///   Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).
        /// </summary>
        public virtual bool? AllowReferencesWithProperties { get; internal set; }
        /// <summary>
        ///   Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).
        /// </summary>
        public virtual string AspNetCoreEnvironment { get; internal set; }
        /// <summary>
        ///   DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string ContractResolver { get; internal set; }
        /// <summary>
        ///   The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.
        /// </summary>
        public virtual string CreateWebHostBuilderMethod { get; internal set; }
        /// <summary>
        ///   The default reference type null handling of dictionary value types (NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultDictionaryValueReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default enum handling ('String' or 'Integer'), default: Integer.
        /// </summary>
        public virtual EnumHandling DefaultEnumHandling { get; internal set; }
        /// <summary>
        ///   The default property name handling ('Default' or 'CamelCase').
        /// </summary>
        public virtual PropertyNameHandling DefaultPropertyNameHandling { get; internal set; }
        /// <summary>
        ///   The default reference type null handling (Null (default) or NotNull).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default response reference type null handling (default: NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultResponseReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The document name to use in SwaggerDocumentProvider (default: v1).
        /// </summary>
        public virtual string DocumentName { get; internal set; }
        /// <summary>
        ///   The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> DocumentProcessors => DocumentProcessorsInternal.AsReadOnly();
        internal List<string> DocumentProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies the Swagger document template (may be a path or JSON, default: none).
        /// </summary>
        public virtual string DocumentTemplate { get; internal set; }
        /// <summary>
        ///   The excluded type names (same as JsonSchemaIgnoreAttribute).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).
        /// </summary>
        public virtual bool? FlattenInheritanceHierarchy { get; internal set; }
        /// <summary>
        ///   Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).
        /// </summary>
        public virtual bool? GenerateAbstractProperties { get; internal set; }
        /// <summary>
        ///   Generate the x-abstract flag on schemas (default: true).
        /// </summary>
        public virtual bool? GenerateAbstractSchemas { get; internal set; }
        /// <summary>
        ///   Generate a description with number to enum name mappings (for integer enums only, default: false).
        /// </summary>
        public virtual bool? GenerateEnumMappingDescription { get; internal set; }
        /// <summary>
        ///   Generate schemas for types in KnownTypeAttribute attributes (default: true).
        /// </summary>
        public virtual bool? GenerateKnownTypes { get; internal set; }
        /// <summary>
        ///   Generate xmlObject representation for definitions (default: false).
        /// </summary>
        public virtual bool? GenerateXmlObjects { get; internal set; }
        /// <summary>
        ///   Ignore properties with the ObsoleteAttribute (default: false).
        /// </summary>
        public virtual bool? IgnoreObsoleteProperties { get; internal set; }
        /// <summary>
        ///   Specify the description of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoDescription { get; internal set; }
        /// <summary>
        ///   Specify the title of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoTitle { get; internal set; }
        /// <summary>
        ///   Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoVersion { get; internal set; }
        /// <summary>
        ///   The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> OperationProcessors => OperationProcessorsInternal.AsReadOnly();
        internal List<string> OperationProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SchemaNameGenerator { get; internal set; }
        /// <summary>
        ///   The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SerializerSettings { get; internal set; }
        /// <summary>
        ///   The basePath of the Swagger specification (optional).
        /// </summary>
        public virtual string ServiceBasePath { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web service (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.
        /// </summary>
        public virtual string Startup { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).
        /// </summary>
        public virtual bool? UseDocumentProvider { get; internal set; }
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("aspnetcore2openapi")
              .Add("/AllowNullableBodyParameters:{value}", AllowNullableBodyParameters)
              .Add("/AllowReferencesWithProperties:{value}", AllowReferencesWithProperties)
              .Add("/AspNetCoreEnvironment:{value}", AspNetCoreEnvironment)
              .Add("/ContractResolver:{value}", ContractResolver)
              .Add("/CreateWebHostBuilderMethod:{value}", CreateWebHostBuilderMethod)
              .Add("/DefaultDictionaryValueReferenceTypeNullHandling:{value}", DefaultDictionaryValueReferenceTypeNullHandling)
              .Add("/DefaultEnumHandling:{value}", DefaultEnumHandling)
              .Add("/DefaultPropertyNameHandling:{value}", DefaultPropertyNameHandling)
              .Add("/DefaultReferenceTypeNullHandling:{value}", DefaultReferenceTypeNullHandling)
              .Add("/DefaultResponseReferenceTypeNullHandling:{value}", DefaultResponseReferenceTypeNullHandling)
              .Add("/DocumentName:{value}", DocumentName)
              .Add("/DocumentProcessors:{value}", DocumentProcessors)
              .Add("/DocumentTemplate:{value}", DocumentTemplate)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/FlattenInheritanceHierarchy:{value}", FlattenInheritanceHierarchy)
              .Add("/GenerateAbstractProperties:{value}", GenerateAbstractProperties)
              .Add("/GenerateAbstractSchemas:{value}", GenerateAbstractSchemas)
              .Add("/GenerateEnumMappingDescription:{value}", GenerateEnumMappingDescription)
              .Add("/GenerateKnownTypes:{value}", GenerateKnownTypes)
              .Add("/GenerateXmlObjects:{value}", GenerateXmlObjects)
              .Add("/IgnoreObsoleteProperties:{value}", IgnoreObsoleteProperties)
              .Add("/InfoDescription:{value}", InfoDescription)
              .Add("/InfoTitle:{value}", InfoTitle)
              .Add("/InfoVersion:{value}", InfoVersion)
              .Add("/OperationProcessors:{value}", OperationProcessors)
              .Add("/SchemaNameGenerator:{value}", SchemaNameGenerator)
              .Add("/SerializerSettings:{value}", SerializerSettings)
              .Add("/ServiceBasePath:{value}", ServiceBasePath)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Startup:{value}", Startup)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/UseDocumentProvider:{value}", UseDocumentProvider)
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagAspNetCoreToSwaggerSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagAspNetCoreToSwaggerSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).
        /// </summary>
        public virtual IReadOnlyList<string> ApiGroupNames => ApiGroupNamesInternal.AsReadOnly();
        internal List<string> ApiGroupNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The configuration to use.
        /// </summary>
        public virtual string Configuration { get; internal set; }
        /// <summary>
        ///   The MSBuild project extensions path. Defaults to "obj".
        /// </summary>
        public virtual string MSBuildProjectExtensionsPath { get; internal set; }
        /// <summary>
        ///   Don't build the project. Only use this when the build is up-to-date.
        /// </summary>
        public virtual bool? NoBuild { get; internal set; }
        /// <summary>
        ///   The working directory to use.
        /// </summary>
        public virtual string NSwagWorkingDirectory { get; internal set; }
        /// <summary>
        ///   The project to use.
        /// </summary>
        public virtual string Project { get; internal set; }
        /// <summary>
        ///   Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).
        /// </summary>
        public virtual bool? RequireParametersWithoutDefault { get; internal set; }
        /// <summary>
        ///   The runtime to use.
        /// </summary>
        public virtual string Runtime { get; internal set; }
        /// <summary>
        ///   The target framework to use.
        /// </summary>
        public virtual string TargetFramework { get; internal set; }
        /// <summary>
        ///   Print verbose output.
        /// </summary>
        public virtual bool? Verbose { get; internal set; }
        /// <summary>
        ///   Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).
        /// </summary>
        public virtual bool? AllowNullableBodyParameters { get; internal set; }
        /// <summary>
        ///   Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).
        /// </summary>
        public virtual bool? AllowReferencesWithProperties { get; internal set; }
        /// <summary>
        ///   Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).
        /// </summary>
        public virtual string AspNetCoreEnvironment { get; internal set; }
        /// <summary>
        ///   DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string ContractResolver { get; internal set; }
        /// <summary>
        ///   The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.
        /// </summary>
        public virtual string CreateWebHostBuilderMethod { get; internal set; }
        /// <summary>
        ///   The default reference type null handling of dictionary value types (NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultDictionaryValueReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default enum handling ('String' or 'Integer'), default: Integer.
        /// </summary>
        public virtual EnumHandling DefaultEnumHandling { get; internal set; }
        /// <summary>
        ///   The default property name handling ('Default' or 'CamelCase').
        /// </summary>
        public virtual PropertyNameHandling DefaultPropertyNameHandling { get; internal set; }
        /// <summary>
        ///   The default reference type null handling (Null (default) or NotNull).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The default response reference type null handling (default: NotNull (default) or Null).
        /// </summary>
        public virtual ReferenceTypeNullHandling DefaultResponseReferenceTypeNullHandling { get; internal set; }
        /// <summary>
        ///   The document name to use in SwaggerDocumentProvider (default: v1).
        /// </summary>
        public virtual string DocumentName { get; internal set; }
        /// <summary>
        ///   The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> DocumentProcessors => DocumentProcessorsInternal.AsReadOnly();
        internal List<string> DocumentProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies the Swagger document template (may be a path or JSON, default: none).
        /// </summary>
        public virtual string DocumentTemplate { get; internal set; }
        /// <summary>
        ///   The excluded type names (same as JsonSchemaIgnoreAttribute).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).
        /// </summary>
        public virtual bool? FlattenInheritanceHierarchy { get; internal set; }
        /// <summary>
        ///   Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).
        /// </summary>
        public virtual bool? GenerateAbstractProperties { get; internal set; }
        /// <summary>
        ///   Generate the x-abstract flag on schemas (default: true).
        /// </summary>
        public virtual bool? GenerateAbstractSchemas { get; internal set; }
        /// <summary>
        ///   Generate a description with number to enum name mappings (for integer enums only, default: false).
        /// </summary>
        public virtual bool? GenerateEnumMappingDescription { get; internal set; }
        /// <summary>
        ///   Generate schemas for types in KnownTypeAttribute attributes (default: true).
        /// </summary>
        public virtual bool? GenerateKnownTypes { get; internal set; }
        /// <summary>
        ///   Generate xmlObject representation for definitions (default: false).
        /// </summary>
        public virtual bool? GenerateXmlObjects { get; internal set; }
        /// <summary>
        ///   Ignore properties with the ObsoleteAttribute (default: false).
        /// </summary>
        public virtual bool? IgnoreObsoleteProperties { get; internal set; }
        /// <summary>
        ///   Specify the description of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoDescription { get; internal set; }
        /// <summary>
        ///   Specify the title of the Swagger specification (ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoTitle { get; internal set; }
        /// <summary>
        ///   Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).
        /// </summary>
        public virtual string InfoVersion { get; internal set; }
        /// <summary>
        ///   The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual IReadOnlyList<string> OperationProcessors => OperationProcessorsInternal.AsReadOnly();
        internal List<string> OperationProcessorsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SchemaNameGenerator { get; internal set; }
        /// <summary>
        ///   The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string SerializerSettings { get; internal set; }
        /// <summary>
        ///   The basePath of the Swagger specification (optional).
        /// </summary>
        public virtual string ServiceBasePath { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web service (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.
        /// </summary>
        public virtual string Startup { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).
        /// </summary>
        public virtual bool? UseDocumentProvider { get; internal set; }
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        /// <summary>
        ///   Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).
        /// </summary>
        public virtual SchemaType OutputType { get; internal set; }
        /// <summary>
        ///   The path or paths to the .NET assemblies (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> Assembly => AssemblyInternal.AsReadOnly();
        internal List<string> AssemblyInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The path to the assembly App.config or Web.config (optional).
        /// </summary>
        public virtual string AssemblyConfig { get; internal set; }
        /// <summary>
        ///   The paths to search for referenced assembly files (comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> ReferencePaths => ReferencePathsInternal.AsReadOnly();
        internal List<string> ReferencePathsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Determines if local Nuget's cache folder should be put in the ReferencePaths by default
        /// </summary>
        public virtual bool? UseNuGetCache { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("aspnetcore2swagger")
              .Add("/ApiGroupNames:{value}", ApiGroupNames)
              .Add("/Configuration:{value}", Configuration)
              .Add("/MSBuildProjectExtensionsPath:{value}", MSBuildProjectExtensionsPath)
              .Add("/NoBuild:{value}", NoBuild)
              .Add("/WorkingDirectory:{value}", NSwagWorkingDirectory)
              .Add("/Project:{value}", Project)
              .Add("/RequireParametersWithoutDefault:{value}", RequireParametersWithoutDefault)
              .Add("/Runtime:{value}", Runtime)
              .Add("/TargetFramework:{value}", TargetFramework)
              .Add("/Verbose:{value}", Verbose)
              .Add("/AllowNullableBodyParameters:{value}", AllowNullableBodyParameters)
              .Add("/AllowReferencesWithProperties:{value}", AllowReferencesWithProperties)
              .Add("/AspNetCoreEnvironment:{value}", AspNetCoreEnvironment)
              .Add("/ContractResolver:{value}", ContractResolver)
              .Add("/CreateWebHostBuilderMethod:{value}", CreateWebHostBuilderMethod)
              .Add("/DefaultDictionaryValueReferenceTypeNullHandling:{value}", DefaultDictionaryValueReferenceTypeNullHandling)
              .Add("/DefaultEnumHandling:{value}", DefaultEnumHandling)
              .Add("/DefaultPropertyNameHandling:{value}", DefaultPropertyNameHandling)
              .Add("/DefaultReferenceTypeNullHandling:{value}", DefaultReferenceTypeNullHandling)
              .Add("/DefaultResponseReferenceTypeNullHandling:{value}", DefaultResponseReferenceTypeNullHandling)
              .Add("/DocumentName:{value}", DocumentName)
              .Add("/DocumentProcessors:{value}", DocumentProcessors)
              .Add("/DocumentTemplate:{value}", DocumentTemplate)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/FlattenInheritanceHierarchy:{value}", FlattenInheritanceHierarchy)
              .Add("/GenerateAbstractProperties:{value}", GenerateAbstractProperties)
              .Add("/GenerateAbstractSchemas:{value}", GenerateAbstractSchemas)
              .Add("/GenerateEnumMappingDescription:{value}", GenerateEnumMappingDescription)
              .Add("/GenerateKnownTypes:{value}", GenerateKnownTypes)
              .Add("/GenerateXmlObjects:{value}", GenerateXmlObjects)
              .Add("/IgnoreObsoleteProperties:{value}", IgnoreObsoleteProperties)
              .Add("/InfoDescription:{value}", InfoDescription)
              .Add("/InfoTitle:{value}", InfoTitle)
              .Add("/InfoVersion:{value}", InfoVersion)
              .Add("/OperationProcessors:{value}", OperationProcessors)
              .Add("/SchemaNameGenerator:{value}", SchemaNameGenerator)
              .Add("/SerializerSettings:{value}", SerializerSettings)
              .Add("/ServiceBasePath:{value}", ServiceBasePath)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Startup:{value}", Startup)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/UseDocumentProvider:{value}", UseDocumentProvider)
              .Add("/Output:{value}", Output)
              .Add("/OutputType:{value}", OutputType)
              .Add("/Assembly:{value}", Assembly)
              .Add("/AssemblyConfig:{value}", AssemblyConfig)
              .Add("/ReferencePaths:{value}", ReferencePaths)
              .Add("/UseNuGetCache:{value}", UseNuGetCache)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagCreateDocumentSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagCreateDocumentSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("new")
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagExecuteDocumentSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagExecuteDocumentSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        public virtual string Input { get; internal set; }
        public virtual IReadOnlyDictionary<string, object> Variables => VariablesInternal.AsReadOnly();
        internal Dictionary<string,object> VariablesInternal { get; set; } = new Dictionary<string,object>(StringComparer.OrdinalIgnoreCase);
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("run")
              .Add("/Input:{value}", Input)
              .Add("/Variables:{value}", Variables, "{key}={value}")
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagJsonSchemaToCSharpSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagJsonSchemaToCSharpSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The any .NET type (default: 'object').
        /// </summary>
        public virtual string AnyType { get; internal set; }
        /// <summary>
        ///   The generic array .NET instance type (default: empty = ArrayType).
        /// </summary>
        public virtual string ArrayInstanceType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'ObservableCollection').
        /// </summary>
        public virtual string ArrayType { get; internal set; }
        /// <summary>
        ///   The date time .NET type (default: 'DateTime').
        /// </summary>
        public virtual string DateTimeType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET instance type (default: empty = DictionaryType).
        /// </summary>
        public virtual string DictionaryInstanceType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'Dictionary').
        /// </summary>
        public virtual string DictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalPropertiesAsNullable { get; internal set; }
        /// <summary>
        ///   The class name of the root schema.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   The namespace of the generated classes.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).
        /// </summary>
        public virtual bool? RequiredPropertiesMustBeDefined { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("jsonschema2csclient")
              .Add("/AnyType:{value}", AnyType)
              .Add("/ArrayInstanceType:{value}", ArrayInstanceType)
              .Add("/ArrayType:{value}", ArrayType)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/DictionaryInstanceType:{value}", DictionaryInstanceType)
              .Add("/DictionaryType:{value}", DictionaryType)
              .Add("/GenerateOptionalPropertiesAsNullable:{value}", GenerateOptionalPropertiesAsNullable)
              .Add("/Name:{value}", Name)
              .Add("/Namespace:{value}", Namespace)
              .Add("/RequiredPropertiesMustBeDefined:{value}", RequiredPropertiesMustBeDefined)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagJsonSchemaToTypeScriptSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagJsonSchemaToTypeScriptSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The type name of the root schema.
        /// </summary>
        public virtual string Name { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("jsonschema2tsclient")
              .Add("/Name:{value}", Name)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagOpenApiToCSharpClientSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagOpenApiToCSharpClientSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The additional contract namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalContractNamespaceUsages => AdditionalContractNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalContractNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The additional namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalNamespaceUsages => AdditionalNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The any .NET type (default: 'object').
        /// </summary>
        public virtual string AnyType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'Collection').
        /// </summary>
        public virtual string ArrayBaseType { get; internal set; }
        /// <summary>
        ///   The generic array .NET instance type (default: empty = ArrayType).
        /// </summary>
        public virtual string ArrayInstanceType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'ICollection').
        /// </summary>
        public virtual string ArrayType { get; internal set; }
        /// <summary>
        ///   The class name of the generated client.
        /// </summary>
        public virtual string ClassName { get; internal set; }
        /// <summary>
        ///   The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').
        /// </summary>
        public virtual CSharpClassStyle ClassStyle { get; internal set; }
        /// <summary>
        ///   The date time .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateTimeType { get; internal set; }
        /// <summary>
        ///   The date .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'Dictionary').
        /// </summary>
        public virtual string DictionaryBaseType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET instance type (default: empty = DictionaryType).
        /// </summary>
        public virtual string DictionaryInstanceType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'IDictionary').
        /// </summary>
        public virtual string DictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether enums should be always generated as bit flags (default: false).
        /// </summary>
        public virtual bool? EnforceFlagEnums { get; internal set; }
        /// <summary>
        ///   The globally excluded parameter names.
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedParameterNames => ExcludedParameterNamesInternal.AsReadOnly();
        internal List<string> ExcludedParameterNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The excluded DTO type names (must be defined in an import or other namespace).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to generate data annotation attributes on DTO classes (default: true).
        /// </summary>
        public virtual bool? GenerateDataAnnotations { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).
        /// </summary>
        public virtual bool? GenerateDefaultValues { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate DTO classes.
        /// </summary>
        public virtual bool? GenerateDtoTypes { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable array properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableArrayProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable dictionary properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableDictionaryProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).
        /// </summary>
        public virtual bool? GenerateJsonMethods { get; internal set; }
        /// <summary>
        ///   Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalPropertiesAsNullable { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate response classes (default: true).
        /// </summary>
        public virtual bool? GenerateResponseClasses { get; internal set; }
        /// <summary>
        ///   Use preserve references handling (All) in the JSON serializer (default: false).
        /// </summary>
        public virtual bool? HandleReferences { get; internal set; }
        /// <summary>
        ///   Inline named any types (default: false).
        /// </summary>
        public virtual bool? InlineNamedAny { get; internal set; }
        /// <summary>
        ///   Inline named arrays (default: false).
        /// </summary>
        public virtual bool? InlineNamedArrays { get; internal set; }
        /// <summary>
        ///   Inline named dictionaries (default: false).
        /// </summary>
        public virtual bool? InlineNamedDictionaries { get; internal set; }
        /// <summary>
        ///   Inline named tuples (default: true).
        /// </summary>
        public virtual bool? InlineNamedTuples { get; internal set; }
        /// <summary>
        ///   Specifies the custom Json.NET converter types (optional, comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> JsonConverters => JsonConvertersInternal.AsReadOnly();
        internal List<string> JsonConvertersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of a static method which is called to transform the JsonSerializerSettings used in the generated ToJson()/FromJson() methods (default: none).
        /// </summary>
        public virtual string JsonSerializerSettingsTransformationMethod { get; internal set; }
        /// <summary>
        ///   The namespace of the generated classes.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The operation generation mode ('SingleClientFromOperationId' or 'MultipleClientsFromPathSegments').
        /// </summary>
        public virtual OperationGenerationMode OperationGenerationMode { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation parameters (default: 'IEnumerable').
        /// </summary>
        public virtual string ParameterArrayType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation parameters (default: 'IDictionary').
        /// </summary>
        public virtual string ParameterDictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).
        /// </summary>
        public virtual bool? RequiredPropertiesMustBeDefined { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation responses (default: 'ICollection').
        /// </summary>
        public virtual string ResponseArrayType { get; internal set; }
        /// <summary>
        ///   The response class (default 'SwaggerResponse', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ResponseClass { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation responses (default: 'IDictionary').
        /// </summary>
        public virtual string ResponseDictionaryType { get; internal set; }
        /// <summary>
        ///   The time span .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeSpanType { get; internal set; }
        /// <summary>
        ///   The time .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeType { get; internal set; }
        /// <summary>
        ///   List of methods where responses are wrapped ('ControllerName.MethodName', WrapResponses must be true).
        /// </summary>
        public virtual IReadOnlyList<string> WrapResponseMethods => WrapResponseMethodsInternal.AsReadOnly();
        internal List<string> WrapResponseMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to wrap success responses to allow full response access.
        /// </summary>
        public virtual bool? WrapResponses { get; internal set; }
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("openapi2csclient")
              .Add("/AdditionalContractNamespaceUsages:{value}", AdditionalContractNamespaceUsages)
              .Add("/AdditionalNamespaceUsages:{value}", AdditionalNamespaceUsages)
              .Add("/AnyType:{value}", AnyType)
              .Add("/ArrayBaseType:{value}", ArrayBaseType)
              .Add("/ArrayInstanceType:{value}", ArrayInstanceType)
              .Add("/ArrayType:{value}", ArrayType)
              .Add("/ClassName:{value}", ClassName)
              .Add("/ClassStyle:{value}", ClassStyle)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/DateType:{value}", DateType)
              .Add("/DictionaryBaseType:{value}", DictionaryBaseType)
              .Add("/DictionaryInstanceType:{value}", DictionaryInstanceType)
              .Add("/DictionaryType:{value}", DictionaryType)
              .Add("/EnforceFlagEnums:{value}", EnforceFlagEnums)
              .Add("/ExcludedParameterNames:{value}", ExcludedParameterNames)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/GenerateDataAnnotations:{value}", GenerateDataAnnotations)
              .Add("/GenerateDefaultValues:{value}", GenerateDefaultValues)
              .Add("/GenerateDtoTypes:{value}", GenerateDtoTypes)
              .Add("/GenerateImmutableArrayProperties:{value}", GenerateImmutableArrayProperties)
              .Add("/GenerateImmutableDictionaryProperties:{value}", GenerateImmutableDictionaryProperties)
              .Add("/GenerateJsonMethods:{value}", GenerateJsonMethods)
              .Add("/GenerateOptionalParameters:{value}", GenerateOptionalParameters)
              .Add("/GenerateOptionalPropertiesAsNullable:{value}", GenerateOptionalPropertiesAsNullable)
              .Add("/GenerateResponseClasses:{value}", GenerateResponseClasses)
              .Add("/HandleReferences:{value}", HandleReferences)
              .Add("/InlineNamedAny:{value}", InlineNamedAny)
              .Add("/InlineNamedArrays:{value}", InlineNamedArrays)
              .Add("/InlineNamedDictionaries:{value}", InlineNamedDictionaries)
              .Add("/InlineNamedTuples:{value}", InlineNamedTuples)
              .Add("/JsonConverters:{value}", JsonConverters)
              .Add("/JsonSerializerSettingsTransformationMethod:{value}", JsonSerializerSettingsTransformationMethod)
              .Add("/Namespace:{value}", Namespace)
              .Add("/OperationGenerationMode:{value}", OperationGenerationMode)
              .Add("/ParameterArrayType:{value}", ParameterArrayType)
              .Add("/ParameterDictionaryType:{value}", ParameterDictionaryType)
              .Add("/RequiredPropertiesMustBeDefined:{value}", RequiredPropertiesMustBeDefined)
              .Add("/ResponseArrayType:{value}", ResponseArrayType)
              .Add("/ResponseClass:{value}", ResponseClass)
              .Add("/ResponseDictionaryType:{value}", ResponseDictionaryType)
              .Add("/TimeSpanType:{value}", TimeSpanType)
              .Add("/TimeType:{value}", TimeType)
              .Add("/WrapResponseMethods:{value}", WrapResponseMethods)
              .Add("/WrapResponses:{value}", WrapResponses)
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagSwaggerToCSharpClientSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagSwaggerToCSharpClientSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The client base class (empty for no base class).
        /// </summary>
        public virtual string ClientBaseClass { get; internal set; }
        /// <summary>
        ///   The client class access modifier (default: public).
        /// </summary>
        public virtual string ClientClassAccessModifier { get; internal set; }
        /// <summary>
        ///   The configuration class. The setting ClientBaseClass must be set. (empty for no configuration class).
        /// </summary>
        public virtual string ConfigurationClass { get; internal set; }
        /// <summary>
        ///   The contracts .NET namespace.
        /// </summary>
        public virtual string ContractsNamespace { get; internal set; }
        /// <summary>
        ///   The contracts output file path (optional, if no path is set then a single file with the implementation and contracts is generated).
        /// </summary>
        public virtual string ContractsOutput { get; internal set; }
        /// <summary>
        ///   Specifies whether to dispose the HttpClient (injected HttpClient is never disposed).
        /// </summary>
        public virtual bool? DisposeHttpClient { get; internal set; }
        /// <summary>
        ///   The exception class (default 'SwaggerException', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ExceptionClass { get; internal set; }
        /// <summary>
        ///   Specifies whether to expose the JsonSerializerSettings property (default: false).
        /// </summary>
        public virtual bool? ExposeJsonSerializerSettings { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate the BaseUrl property, must be defined on the base class otherwise (default: true).
        /// </summary>
        public virtual bool? GenerateBaseUrlProperty { get; internal set; }
        /// <summary>
        ///   Specifies whether generate client classes.
        /// </summary>
        public virtual bool? GenerateClientClasses { get; internal set; }
        /// <summary>
        ///   Specifies whether generate interfaces for the client classes.
        /// </summary>
        public virtual bool? GenerateClientInterfaces { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate contracts output (interface and models in a separate file set with the ContractsOutput parameter).
        /// </summary>
        public virtual bool? GenerateContractsOutput { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate exception classes (default: true).
        /// </summary>
        public virtual bool? GenerateExceptionClasses { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate synchronous methods (not recommended, default: false).
        /// </summary>
        public virtual bool? GenerateSyncMethods { get; internal set; }
        /// <summary>
        ///   Generate the UpdateJsonSerializerSettings method (must be implemented in the base class otherwise, default: true).
        /// </summary>
        public virtual bool? GenerateUpdateJsonSerializerSettingsMethod { get; internal set; }
        /// <summary>
        ///   Specifies the HttpClient type. By default the 'System.Net.Http.HttpClient' is used.
        /// </summary>
        public virtual string HttpClientType { get; internal set; }
        /// <summary>
        ///   Specifies whether an HttpClient instance is injected (default: true).
        /// </summary>
        public virtual bool? InjectHttpClient { get; internal set; }
        /// <summary>
        ///   Specifies the format for Date type method parameters (default: yyyy-MM-dd).
        /// </summary>
        public virtual string ParameterDateFormat { get; internal set; }
        /// <summary>
        ///   Specifies the format for DateTime type method parameters (default: s).
        /// </summary>
        public virtual string ParameterDateTimeFormat { get; internal set; }
        /// <summary>
        ///   List of methods with a protected access modifier ('classname.methodname').
        /// </summary>
        public virtual IReadOnlyList<string> ProtectedMethods => ProtectedMethodsInternal.AsReadOnly();
        internal List<string> ProtectedMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The null value used for query parameters which are null (default: '').
        /// </summary>
        public virtual string QueryNullValue { get; internal set; }
        /// <summary>
        ///   Serialize the type information in a $type property (not recommended, also sets TypeNameHandling = Auto, default: true).
        /// </summary>
        public virtual bool? SerializeTypeInformation { get; internal set; }
        /// <summary>
        ///   The DTO class/enum access modifier (default: public).
        /// </summary>
        public virtual string TypeAccessModifier { get; internal set; }
        /// <summary>
        ///   Specifies whether to use and expose the base URL (default: true).
        /// </summary>
        public virtual bool? UseBaseUrl { get; internal set; }
        /// <summary>
        ///   Specifies whether to call CreateHttpClientAsync on the base class to create a new HttpClient.
        /// </summary>
        public virtual bool? UseHttpClientCreationMethod { get; internal set; }
        /// <summary>
        ///   Specifies whether to call CreateHttpRequestMessageAsync on the base class to create a new HttpRequestMethod.
        /// </summary>
        public virtual bool? UseHttpRequestMessageCreationMethod { get; internal set; }
        /// <summary>
        ///   Specifies whether DTO exceptions are wrapped in a SwaggerException instance (default: true).
        /// </summary>
        public virtual bool? WrapDtoExceptions { get; internal set; }
        /// <summary>
        ///   The additional contract namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalContractNamespaceUsages => AdditionalContractNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalContractNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The additional namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalNamespaceUsages => AdditionalNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The any .NET type (default: 'object').
        /// </summary>
        public virtual string AnyType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'Collection').
        /// </summary>
        public virtual string ArrayBaseType { get; internal set; }
        /// <summary>
        ///   The generic array .NET instance type (default: empty = ArrayType).
        /// </summary>
        public virtual string ArrayInstanceType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'ICollection').
        /// </summary>
        public virtual string ArrayType { get; internal set; }
        /// <summary>
        ///   The class name of the generated client.
        /// </summary>
        public virtual string ClassName { get; internal set; }
        /// <summary>
        ///   The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').
        /// </summary>
        public virtual CSharpClassStyle ClassStyle { get; internal set; }
        /// <summary>
        ///   The date time .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateTimeType { get; internal set; }
        /// <summary>
        ///   The date .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'Dictionary').
        /// </summary>
        public virtual string DictionaryBaseType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET instance type (default: empty = DictionaryType).
        /// </summary>
        public virtual string DictionaryInstanceType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'IDictionary').
        /// </summary>
        public virtual string DictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether enums should be always generated as bit flags (default: false).
        /// </summary>
        public virtual bool? EnforceFlagEnums { get; internal set; }
        /// <summary>
        ///   The globally excluded parameter names.
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedParameterNames => ExcludedParameterNamesInternal.AsReadOnly();
        internal List<string> ExcludedParameterNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The excluded DTO type names (must be defined in an import or other namespace).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to generate data annotation attributes on DTO classes (default: true).
        /// </summary>
        public virtual bool? GenerateDataAnnotations { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).
        /// </summary>
        public virtual bool? GenerateDefaultValues { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate DTO classes.
        /// </summary>
        public virtual bool? GenerateDtoTypes { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable array properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableArrayProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable dictionary properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableDictionaryProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).
        /// </summary>
        public virtual bool? GenerateJsonMethods { get; internal set; }
        /// <summary>
        ///   Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalPropertiesAsNullable { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate response classes (default: true).
        /// </summary>
        public virtual bool? GenerateResponseClasses { get; internal set; }
        /// <summary>
        ///   Use preserve references handling (All) in the JSON serializer (default: false).
        /// </summary>
        public virtual bool? HandleReferences { get; internal set; }
        /// <summary>
        ///   Inline named any types (default: false).
        /// </summary>
        public virtual bool? InlineNamedAny { get; internal set; }
        /// <summary>
        ///   Inline named arrays (default: false).
        /// </summary>
        public virtual bool? InlineNamedArrays { get; internal set; }
        /// <summary>
        ///   Inline named dictionaries (default: false).
        /// </summary>
        public virtual bool? InlineNamedDictionaries { get; internal set; }
        /// <summary>
        ///   Inline named tuples (default: true).
        /// </summary>
        public virtual bool? InlineNamedTuples { get; internal set; }
        /// <summary>
        ///   Specifies the custom Json.NET converter types (optional, comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> JsonConverters => JsonConvertersInternal.AsReadOnly();
        internal List<string> JsonConvertersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of a static method which is called to transform the JsonSerializerSettings used in the generated ToJson()/FromJson() methods (default: none).
        /// </summary>
        public virtual string JsonSerializerSettingsTransformationMethod { get; internal set; }
        /// <summary>
        ///   The namespace of the generated classes.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The operation generation mode ('SingleClientFromOperationId' or 'MultipleClientsFromPathSegments').
        /// </summary>
        public virtual OperationGenerationMode OperationGenerationMode { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation parameters (default: 'IEnumerable').
        /// </summary>
        public virtual string ParameterArrayType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation parameters (default: 'IDictionary').
        /// </summary>
        public virtual string ParameterDictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).
        /// </summary>
        public virtual bool? RequiredPropertiesMustBeDefined { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation responses (default: 'ICollection').
        /// </summary>
        public virtual string ResponseArrayType { get; internal set; }
        /// <summary>
        ///   The response class (default 'SwaggerResponse', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ResponseClass { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation responses (default: 'IDictionary').
        /// </summary>
        public virtual string ResponseDictionaryType { get; internal set; }
        /// <summary>
        ///   The time span .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeSpanType { get; internal set; }
        /// <summary>
        ///   The time .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeType { get; internal set; }
        /// <summary>
        ///   List of methods where responses are wrapped ('ControllerName.MethodName', WrapResponses must be true).
        /// </summary>
        public virtual IReadOnlyList<string> WrapResponseMethods => WrapResponseMethodsInternal.AsReadOnly();
        internal List<string> WrapResponseMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to wrap success responses to allow full response access.
        /// </summary>
        public virtual bool? WrapResponses { get; internal set; }
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swagger2csclient")
              .Add("/ClientBaseClass:{value}", ClientBaseClass)
              .Add("/ClientClassAccessModifier:{value}", ClientClassAccessModifier)
              .Add("/ConfigurationClass:{value}", ConfigurationClass)
              .Add("/ContractsNamespace:{value}", ContractsNamespace)
              .Add("/ContractsOutput:{value}", ContractsOutput)
              .Add("/DisposeHttpClient:{value}", DisposeHttpClient)
              .Add("/ExceptionClass:{value}", ExceptionClass)
              .Add("/ExposeJsonSerializerSettings:{value}", ExposeJsonSerializerSettings)
              .Add("/GenerateBaseUrlProperty:{value}", GenerateBaseUrlProperty)
              .Add("/GenerateClientClasses:{value}", GenerateClientClasses)
              .Add("/GenerateClientInterfaces:{value}", GenerateClientInterfaces)
              .Add("/GenerateContractsOutput:{value}", GenerateContractsOutput)
              .Add("/GenerateExceptionClasses:{value}", GenerateExceptionClasses)
              .Add("/GenerateSyncMethods:{value}", GenerateSyncMethods)
              .Add("/GenerateUpdateJsonSerializerSettingsMethod:{value}", GenerateUpdateJsonSerializerSettingsMethod)
              .Add("/HttpClientType:{value}", HttpClientType)
              .Add("/InjectHttpClient:{value}", InjectHttpClient)
              .Add("/ParameterDateFormat:{value}", ParameterDateFormat)
              .Add("/ParameterDateTimeFormat:{value}", ParameterDateTimeFormat)
              .Add("/ProtectedMethods:{value}", ProtectedMethods)
              .Add("/QueryNullValue:{value}", QueryNullValue)
              .Add("/SerializeTypeInformation:{value}", SerializeTypeInformation)
              .Add("/TypeAccessModifier:{value}", TypeAccessModifier)
              .Add("/UseBaseUrl:{value}", UseBaseUrl)
              .Add("/UseHttpClientCreationMethod:{value}", UseHttpClientCreationMethod)
              .Add("/UseHttpRequestMessageCreationMethod:{value}", UseHttpRequestMessageCreationMethod)
              .Add("/WrapDtoExceptions:{value}", WrapDtoExceptions)
              .Add("/AdditionalContractNamespaceUsages:{value}", AdditionalContractNamespaceUsages)
              .Add("/AdditionalNamespaceUsages:{value}", AdditionalNamespaceUsages)
              .Add("/AnyType:{value}", AnyType)
              .Add("/ArrayBaseType:{value}", ArrayBaseType)
              .Add("/ArrayInstanceType:{value}", ArrayInstanceType)
              .Add("/ArrayType:{value}", ArrayType)
              .Add("/ClassName:{value}", ClassName)
              .Add("/ClassStyle:{value}", ClassStyle)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/DateType:{value}", DateType)
              .Add("/DictionaryBaseType:{value}", DictionaryBaseType)
              .Add("/DictionaryInstanceType:{value}", DictionaryInstanceType)
              .Add("/DictionaryType:{value}", DictionaryType)
              .Add("/EnforceFlagEnums:{value}", EnforceFlagEnums)
              .Add("/ExcludedParameterNames:{value}", ExcludedParameterNames)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/GenerateDataAnnotations:{value}", GenerateDataAnnotations)
              .Add("/GenerateDefaultValues:{value}", GenerateDefaultValues)
              .Add("/GenerateDtoTypes:{value}", GenerateDtoTypes)
              .Add("/GenerateImmutableArrayProperties:{value}", GenerateImmutableArrayProperties)
              .Add("/GenerateImmutableDictionaryProperties:{value}", GenerateImmutableDictionaryProperties)
              .Add("/GenerateJsonMethods:{value}", GenerateJsonMethods)
              .Add("/GenerateOptionalParameters:{value}", GenerateOptionalParameters)
              .Add("/GenerateOptionalPropertiesAsNullable:{value}", GenerateOptionalPropertiesAsNullable)
              .Add("/GenerateResponseClasses:{value}", GenerateResponseClasses)
              .Add("/HandleReferences:{value}", HandleReferences)
              .Add("/InlineNamedAny:{value}", InlineNamedAny)
              .Add("/InlineNamedArrays:{value}", InlineNamedArrays)
              .Add("/InlineNamedDictionaries:{value}", InlineNamedDictionaries)
              .Add("/InlineNamedTuples:{value}", InlineNamedTuples)
              .Add("/JsonConverters:{value}", JsonConverters)
              .Add("/JsonSerializerSettingsTransformationMethod:{value}", JsonSerializerSettingsTransformationMethod)
              .Add("/Namespace:{value}", Namespace)
              .Add("/OperationGenerationMode:{value}", OperationGenerationMode)
              .Add("/ParameterArrayType:{value}", ParameterArrayType)
              .Add("/ParameterDictionaryType:{value}", ParameterDictionaryType)
              .Add("/RequiredPropertiesMustBeDefined:{value}", RequiredPropertiesMustBeDefined)
              .Add("/ResponseArrayType:{value}", ResponseArrayType)
              .Add("/ResponseClass:{value}", ResponseClass)
              .Add("/ResponseDictionaryType:{value}", ResponseDictionaryType)
              .Add("/TimeSpanType:{value}", TimeSpanType)
              .Add("/TimeType:{value}", TimeType)
              .Add("/WrapResponseMethods:{value}", WrapResponseMethods)
              .Add("/WrapResponses:{value}", WrapResponses)
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagOpenApiToCSharpControllerSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagOpenApiToCSharpControllerSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The additional contract namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalContractNamespaceUsages => AdditionalContractNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalContractNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The additional namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalNamespaceUsages => AdditionalNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The any .NET type (default: 'object').
        /// </summary>
        public virtual string AnyType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'Collection').
        /// </summary>
        public virtual string ArrayBaseType { get; internal set; }
        /// <summary>
        ///   The generic array .NET instance type (default: empty = ArrayType).
        /// </summary>
        public virtual string ArrayInstanceType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'ICollection').
        /// </summary>
        public virtual string ArrayType { get; internal set; }
        /// <summary>
        ///   The class name of the generated client.
        /// </summary>
        public virtual string ClassName { get; internal set; }
        /// <summary>
        ///   The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').
        /// </summary>
        public virtual CSharpClassStyle ClassStyle { get; internal set; }
        /// <summary>
        ///   The date time .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateTimeType { get; internal set; }
        /// <summary>
        ///   The date .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'Dictionary').
        /// </summary>
        public virtual string DictionaryBaseType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET instance type (default: empty = DictionaryType).
        /// </summary>
        public virtual string DictionaryInstanceType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'IDictionary').
        /// </summary>
        public virtual string DictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether enums should be always generated as bit flags (default: false).
        /// </summary>
        public virtual bool? EnforceFlagEnums { get; internal set; }
        /// <summary>
        ///   The globally excluded parameter names.
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedParameterNames => ExcludedParameterNamesInternal.AsReadOnly();
        internal List<string> ExcludedParameterNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The excluded DTO type names (must be defined in an import or other namespace).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to generate data annotation attributes on DTO classes (default: true).
        /// </summary>
        public virtual bool? GenerateDataAnnotations { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).
        /// </summary>
        public virtual bool? GenerateDefaultValues { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate DTO classes.
        /// </summary>
        public virtual bool? GenerateDtoTypes { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable array properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableArrayProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable dictionary properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableDictionaryProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).
        /// </summary>
        public virtual bool? GenerateJsonMethods { get; internal set; }
        /// <summary>
        ///   Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalPropertiesAsNullable { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate response classes (default: true).
        /// </summary>
        public virtual bool? GenerateResponseClasses { get; internal set; }
        /// <summary>
        ///   Use preserve references handling (All) in the JSON serializer (default: false).
        /// </summary>
        public virtual bool? HandleReferences { get; internal set; }
        /// <summary>
        ///   Inline named any types (default: false).
        /// </summary>
        public virtual bool? InlineNamedAny { get; internal set; }
        /// <summary>
        ///   Inline named arrays (default: false).
        /// </summary>
        public virtual bool? InlineNamedArrays { get; internal set; }
        /// <summary>
        ///   Inline named dictionaries (default: false).
        /// </summary>
        public virtual bool? InlineNamedDictionaries { get; internal set; }
        /// <summary>
        ///   Inline named tuples (default: true).
        /// </summary>
        public virtual bool? InlineNamedTuples { get; internal set; }
        /// <summary>
        ///   Specifies the custom Json.NET converter types (optional, comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> JsonConverters => JsonConvertersInternal.AsReadOnly();
        internal List<string> JsonConvertersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of a static method which is called to transform the JsonSerializerSettings used in the generated ToJson()/FromJson() methods (default: none).
        /// </summary>
        public virtual string JsonSerializerSettingsTransformationMethod { get; internal set; }
        /// <summary>
        ///   The namespace of the generated classes.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The operation generation mode ('SingleClientFromOperationId' or 'MultipleClientsFromPathSegments').
        /// </summary>
        public virtual OperationGenerationMode OperationGenerationMode { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation parameters (default: 'IEnumerable').
        /// </summary>
        public virtual string ParameterArrayType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation parameters (default: 'IDictionary').
        /// </summary>
        public virtual string ParameterDictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).
        /// </summary>
        public virtual bool? RequiredPropertiesMustBeDefined { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation responses (default: 'ICollection').
        /// </summary>
        public virtual string ResponseArrayType { get; internal set; }
        /// <summary>
        ///   The response class (default 'SwaggerResponse', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ResponseClass { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation responses (default: 'IDictionary').
        /// </summary>
        public virtual string ResponseDictionaryType { get; internal set; }
        /// <summary>
        ///   The time span .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeSpanType { get; internal set; }
        /// <summary>
        ///   The time .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeType { get; internal set; }
        /// <summary>
        ///   List of methods where responses are wrapped ('ControllerName.MethodName', WrapResponses must be true).
        /// </summary>
        public virtual IReadOnlyList<string> WrapResponseMethods => WrapResponseMethodsInternal.AsReadOnly();
        internal List<string> WrapResponseMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to wrap success responses to allow full response access.
        /// </summary>
        public virtual bool? WrapResponses { get; internal set; }
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("openapi2cscontroller")
              .Add("/AdditionalContractNamespaceUsages:{value}", AdditionalContractNamespaceUsages)
              .Add("/AdditionalNamespaceUsages:{value}", AdditionalNamespaceUsages)
              .Add("/AnyType:{value}", AnyType)
              .Add("/ArrayBaseType:{value}", ArrayBaseType)
              .Add("/ArrayInstanceType:{value}", ArrayInstanceType)
              .Add("/ArrayType:{value}", ArrayType)
              .Add("/ClassName:{value}", ClassName)
              .Add("/ClassStyle:{value}", ClassStyle)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/DateType:{value}", DateType)
              .Add("/DictionaryBaseType:{value}", DictionaryBaseType)
              .Add("/DictionaryInstanceType:{value}", DictionaryInstanceType)
              .Add("/DictionaryType:{value}", DictionaryType)
              .Add("/EnforceFlagEnums:{value}", EnforceFlagEnums)
              .Add("/ExcludedParameterNames:{value}", ExcludedParameterNames)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/GenerateDataAnnotations:{value}", GenerateDataAnnotations)
              .Add("/GenerateDefaultValues:{value}", GenerateDefaultValues)
              .Add("/GenerateDtoTypes:{value}", GenerateDtoTypes)
              .Add("/GenerateImmutableArrayProperties:{value}", GenerateImmutableArrayProperties)
              .Add("/GenerateImmutableDictionaryProperties:{value}", GenerateImmutableDictionaryProperties)
              .Add("/GenerateJsonMethods:{value}", GenerateJsonMethods)
              .Add("/GenerateOptionalParameters:{value}", GenerateOptionalParameters)
              .Add("/GenerateOptionalPropertiesAsNullable:{value}", GenerateOptionalPropertiesAsNullable)
              .Add("/GenerateResponseClasses:{value}", GenerateResponseClasses)
              .Add("/HandleReferences:{value}", HandleReferences)
              .Add("/InlineNamedAny:{value}", InlineNamedAny)
              .Add("/InlineNamedArrays:{value}", InlineNamedArrays)
              .Add("/InlineNamedDictionaries:{value}", InlineNamedDictionaries)
              .Add("/InlineNamedTuples:{value}", InlineNamedTuples)
              .Add("/JsonConverters:{value}", JsonConverters)
              .Add("/JsonSerializerSettingsTransformationMethod:{value}", JsonSerializerSettingsTransformationMethod)
              .Add("/Namespace:{value}", Namespace)
              .Add("/OperationGenerationMode:{value}", OperationGenerationMode)
              .Add("/ParameterArrayType:{value}", ParameterArrayType)
              .Add("/ParameterDictionaryType:{value}", ParameterDictionaryType)
              .Add("/RequiredPropertiesMustBeDefined:{value}", RequiredPropertiesMustBeDefined)
              .Add("/ResponseArrayType:{value}", ResponseArrayType)
              .Add("/ResponseClass:{value}", ResponseClass)
              .Add("/ResponseDictionaryType:{value}", ResponseDictionaryType)
              .Add("/TimeSpanType:{value}", TimeSpanType)
              .Add("/TimeType:{value}", TimeType)
              .Add("/WrapResponseMethods:{value}", WrapResponseMethods)
              .Add("/WrapResponses:{value}", WrapResponses)
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagSwaggerToCSharpControllerSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagSwaggerToCSharpControllerSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The Base path on which the API is served, which is relative to the Host
        /// </summary>
        public virtual string BasePath { get; internal set; }
        /// <summary>
        ///   The controller base class (empty for 'ApiController').
        /// </summary>
        public virtual string ControllerBaseClass { get; internal set; }
        /// <summary>
        ///   The controller generation style (partial, abstract; default: partial).
        /// </summary>
        public virtual CSharpControllerStyle ControllerStyle { get; internal set; }
        /// <summary>
        ///   controller target framework (default: AspNetCore).
        /// </summary>
        public virtual CSharpControllerTarget ControllerTarget { get; internal set; }
        /// <summary>
        ///   Add model validation attributes (default: false).
        /// </summary>
        public virtual bool? GenerateModelValidationAttributes { get; internal set; }
        /// <summary>
        ///   The strategy for naming controller routes (none, operationid; default: none).
        /// </summary>
        public virtual CSharpControllerRouteNamingStrategy RouteNamingStrategy { get; internal set; }
        /// <summary>
        ///   Use ASP.Net Core (2.1) ActionResult type as return type (default: false)
        /// </summary>
        public virtual bool? UseActionResultType { get; internal set; }
        /// <summary>
        ///   Add a cancellation token parameter (default: false).
        /// </summary>
        public virtual bool? UseCancellationToken { get; internal set; }
        /// <summary>
        ///   The additional contract namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalContractNamespaceUsages => AdditionalContractNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalContractNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The additional namespace usages.
        /// </summary>
        public virtual IReadOnlyList<string> AdditionalNamespaceUsages => AdditionalNamespaceUsagesInternal.AsReadOnly();
        internal List<string> AdditionalNamespaceUsagesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The any .NET type (default: 'object').
        /// </summary>
        public virtual string AnyType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'Collection').
        /// </summary>
        public virtual string ArrayBaseType { get; internal set; }
        /// <summary>
        ///   The generic array .NET instance type (default: empty = ArrayType).
        /// </summary>
        public virtual string ArrayInstanceType { get; internal set; }
        /// <summary>
        ///   The generic array .NET type (default: 'ICollection').
        /// </summary>
        public virtual string ArrayType { get; internal set; }
        /// <summary>
        ///   The class name of the generated client.
        /// </summary>
        public virtual string ClassName { get; internal set; }
        /// <summary>
        ///   The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').
        /// </summary>
        public virtual CSharpClassStyle ClassStyle { get; internal set; }
        /// <summary>
        ///   The date time .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateTimeType { get; internal set; }
        /// <summary>
        ///   The date .NET type (default: 'DateTimeOffset').
        /// </summary>
        public virtual string DateType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'Dictionary').
        /// </summary>
        public virtual string DictionaryBaseType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET instance type (default: empty = DictionaryType).
        /// </summary>
        public virtual string DictionaryInstanceType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type (default: 'IDictionary').
        /// </summary>
        public virtual string DictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether enums should be always generated as bit flags (default: false).
        /// </summary>
        public virtual bool? EnforceFlagEnums { get; internal set; }
        /// <summary>
        ///   The globally excluded parameter names.
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedParameterNames => ExcludedParameterNamesInternal.AsReadOnly();
        internal List<string> ExcludedParameterNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The excluded DTO type names (must be defined in an import or other namespace).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to generate data annotation attributes on DTO classes (default: true).
        /// </summary>
        public virtual bool? GenerateDataAnnotations { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).
        /// </summary>
        public virtual bool? GenerateDefaultValues { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate DTO classes.
        /// </summary>
        public virtual bool? GenerateDtoTypes { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable array properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableArrayProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to remove the setter for non-nullable dictionary properties (default: false).
        /// </summary>
        public virtual bool? GenerateImmutableDictionaryProperties { get; internal set; }
        /// <summary>
        ///   Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).
        /// </summary>
        public virtual bool? GenerateJsonMethods { get; internal set; }
        /// <summary>
        ///   Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalPropertiesAsNullable { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate response classes (default: true).
        /// </summary>
        public virtual bool? GenerateResponseClasses { get; internal set; }
        /// <summary>
        ///   Use preserve references handling (All) in the JSON serializer (default: false).
        /// </summary>
        public virtual bool? HandleReferences { get; internal set; }
        /// <summary>
        ///   Inline named any types (default: false).
        /// </summary>
        public virtual bool? InlineNamedAny { get; internal set; }
        /// <summary>
        ///   Inline named arrays (default: false).
        /// </summary>
        public virtual bool? InlineNamedArrays { get; internal set; }
        /// <summary>
        ///   Inline named dictionaries (default: false).
        /// </summary>
        public virtual bool? InlineNamedDictionaries { get; internal set; }
        /// <summary>
        ///   Inline named tuples (default: true).
        /// </summary>
        public virtual bool? InlineNamedTuples { get; internal set; }
        /// <summary>
        ///   Specifies the custom Json.NET converter types (optional, comma separated).
        /// </summary>
        public virtual IReadOnlyList<string> JsonConverters => JsonConvertersInternal.AsReadOnly();
        internal List<string> JsonConvertersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The name of a static method which is called to transform the JsonSerializerSettings used in the generated ToJson()/FromJson() methods (default: none).
        /// </summary>
        public virtual string JsonSerializerSettingsTransformationMethod { get; internal set; }
        /// <summary>
        ///   The namespace of the generated classes.
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The operation generation mode ('SingleClientFromOperationId' or 'MultipleClientsFromPathSegments').
        /// </summary>
        public virtual OperationGenerationMode OperationGenerationMode { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation parameters (default: 'IEnumerable').
        /// </summary>
        public virtual string ParameterArrayType { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation parameters (default: 'IDictionary').
        /// </summary>
        public virtual string ParameterDictionaryType { get; internal set; }
        /// <summary>
        ///   Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).
        /// </summary>
        public virtual bool? RequiredPropertiesMustBeDefined { get; internal set; }
        /// <summary>
        ///   The generic array .NET type of operation responses (default: 'ICollection').
        /// </summary>
        public virtual string ResponseArrayType { get; internal set; }
        /// <summary>
        ///   The response class (default 'SwaggerResponse', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ResponseClass { get; internal set; }
        /// <summary>
        ///   The generic dictionary .NET type of operation responses (default: 'IDictionary').
        /// </summary>
        public virtual string ResponseDictionaryType { get; internal set; }
        /// <summary>
        ///   The time span .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeSpanType { get; internal set; }
        /// <summary>
        ///   The time .NET type (default: 'TimeSpan').
        /// </summary>
        public virtual string TimeType { get; internal set; }
        /// <summary>
        ///   List of methods where responses are wrapped ('ControllerName.MethodName', WrapResponses must be true).
        /// </summary>
        public virtual IReadOnlyList<string> WrapResponseMethods => WrapResponseMethodsInternal.AsReadOnly();
        internal List<string> WrapResponseMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to wrap success responses to allow full response access.
        /// </summary>
        public virtual bool? WrapResponses { get; internal set; }
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swagger2cscontroller")
              .Add("/BasePath:{value}", BasePath)
              .Add("/ControllerBaseClass:{value}", ControllerBaseClass)
              .Add("/ControllerStyle:{value}", ControllerStyle)
              .Add("/ControllerTarget:{value}", ControllerTarget)
              .Add("/GenerateModelValidationAttributes:{value}", GenerateModelValidationAttributes)
              .Add("/RouteNamingStrategy:{value}", RouteNamingStrategy)
              .Add("/UseActionResultType:{value}", UseActionResultType)
              .Add("/UseCancellationToken:{value}", UseCancellationToken)
              .Add("/AdditionalContractNamespaceUsages:{value}", AdditionalContractNamespaceUsages)
              .Add("/AdditionalNamespaceUsages:{value}", AdditionalNamespaceUsages)
              .Add("/AnyType:{value}", AnyType)
              .Add("/ArrayBaseType:{value}", ArrayBaseType)
              .Add("/ArrayInstanceType:{value}", ArrayInstanceType)
              .Add("/ArrayType:{value}", ArrayType)
              .Add("/ClassName:{value}", ClassName)
              .Add("/ClassStyle:{value}", ClassStyle)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/DateType:{value}", DateType)
              .Add("/DictionaryBaseType:{value}", DictionaryBaseType)
              .Add("/DictionaryInstanceType:{value}", DictionaryInstanceType)
              .Add("/DictionaryType:{value}", DictionaryType)
              .Add("/EnforceFlagEnums:{value}", EnforceFlagEnums)
              .Add("/ExcludedParameterNames:{value}", ExcludedParameterNames)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/GenerateDataAnnotations:{value}", GenerateDataAnnotations)
              .Add("/GenerateDefaultValues:{value}", GenerateDefaultValues)
              .Add("/GenerateDtoTypes:{value}", GenerateDtoTypes)
              .Add("/GenerateImmutableArrayProperties:{value}", GenerateImmutableArrayProperties)
              .Add("/GenerateImmutableDictionaryProperties:{value}", GenerateImmutableDictionaryProperties)
              .Add("/GenerateJsonMethods:{value}", GenerateJsonMethods)
              .Add("/GenerateOptionalParameters:{value}", GenerateOptionalParameters)
              .Add("/GenerateOptionalPropertiesAsNullable:{value}", GenerateOptionalPropertiesAsNullable)
              .Add("/GenerateResponseClasses:{value}", GenerateResponseClasses)
              .Add("/HandleReferences:{value}", HandleReferences)
              .Add("/InlineNamedAny:{value}", InlineNamedAny)
              .Add("/InlineNamedArrays:{value}", InlineNamedArrays)
              .Add("/InlineNamedDictionaries:{value}", InlineNamedDictionaries)
              .Add("/InlineNamedTuples:{value}", InlineNamedTuples)
              .Add("/JsonConverters:{value}", JsonConverters)
              .Add("/JsonSerializerSettingsTransformationMethod:{value}", JsonSerializerSettingsTransformationMethod)
              .Add("/Namespace:{value}", Namespace)
              .Add("/OperationGenerationMode:{value}", OperationGenerationMode)
              .Add("/ParameterArrayType:{value}", ParameterArrayType)
              .Add("/ParameterDictionaryType:{value}", ParameterDictionaryType)
              .Add("/RequiredPropertiesMustBeDefined:{value}", RequiredPropertiesMustBeDefined)
              .Add("/ResponseArrayType:{value}", ResponseArrayType)
              .Add("/ResponseClass:{value}", ResponseClass)
              .Add("/ResponseDictionaryType:{value}", ResponseDictionaryType)
              .Add("/TimeSpanType:{value}", TimeSpanType)
              .Add("/TimeType:{value}", TimeType)
              .Add("/WrapResponseMethods:{value}", WrapResponseMethods)
              .Add("/WrapResponses:{value}", WrapResponses)
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagOpenApiToTypeScriptClientSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagOpenApiToTypeScriptClientSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("openapi2tsclient")
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagSwaggerToTypeScriptClientSettings
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class NSwagSwaggerToTypeScriptClientSettings : NSwagSettings
    {
        /// <summary>
        ///   Path to the NSwag executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => NSwagTasks.NSwagLogger;
        /// <summary>
        ///   The token name for injecting the API base URL string (used in the Angular template, default: 'API_BASE_URL').
        /// </summary>
        public virtual string BaseUrlTokenName { get; internal set; }
        /// <summary>
        ///   The class name of the generated client.
        /// </summary>
        public virtual string ClassName { get; internal set; }
        /// <summary>
        ///   The type names which always generate plain TypeScript classes.
        /// </summary>
        public virtual IReadOnlyList<string> ClassTypes => ClassTypesInternal.AsReadOnly();
        internal List<string> ClassTypesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The base class of the generated client classes (optional, must be imported or implemented in the extension code).
        /// </summary>
        public virtual string ClientBaseClass { get; internal set; }
        /// <summary>
        ///   The configuration class. The setting ClientBaseClass must be set. (empty for no configuration class).
        /// </summary>
        public virtual string ConfigurationClass { get; internal set; }
        /// <summary>
        ///   Convert POJO objects in the constructor data to DTO instances (GenerateConstructorInterface must be enabled, default: false).
        /// </summary>
        public virtual bool? ConvertConstructorInterfaceData { get; internal set; }
        /// <summary>
        ///   The date time type ('Date', 'MomentJS', 'OffsetMomentJS', 'string').
        /// </summary>
        public virtual TypeScriptDateTimeType DateTimeType { get; internal set; }
        /// <summary>
        ///   The exception class (default 'ApiException').
        /// </summary>
        public virtual string ExceptionClass { get; internal set; }
        /// <summary>
        ///   The globally excluded parameter names.
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedParameterNames => ExcludedParameterNamesInternal.AsReadOnly();
        internal List<string> ExcludedParameterNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The excluded DTO type names (must be defined in an import or other namespace).
        /// </summary>
        public virtual IReadOnlyList<string> ExcludedTypeNames => ExcludedTypeNamesInternal.AsReadOnly();
        internal List<string> ExcludedTypeNamesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether the export keyword should be added to all classes, interfaces and enums (default: true).
        /// </summary>
        public virtual bool? ExportTypes { get; internal set; }
        /// <summary>
        ///   The list of extended classes.
        /// </summary>
        public virtual IReadOnlyList<string> ExtendedClasses => ExtendedClassesInternal.AsReadOnly();
        internal List<string> ExtendedClassesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The extension code (string or file path).
        /// </summary>
        public virtual string ExtensionCode { get; internal set; }
        /// <summary>
        ///   Specifies whether generate client classes.
        /// </summary>
        public virtual bool? GenerateClientClasses { get; internal set; }
        /// <summary>
        ///   Specifies whether generate interfaces for the client classes (default: false).
        /// </summary>
        public virtual bool? GenerateClientInterfaces { get; internal set; }
        /// <summary>
        ///   Specifies whether a clone() method should be generated in the DTO classes (default: false).
        /// </summary>
        public virtual bool? GenerateCloneMethod { get; internal set; }
        /// <summary>
        ///   Generate an class interface which is used in the constructor to initialize the class (only available when TypeStyle is Class, default: true).
        /// </summary>
        public virtual bool? GenerateConstructorInterface { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate default values for properties (default: true).
        /// </summary>
        public virtual bool? GenerateDefaultValues { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate DTO classes.
        /// </summary>
        public virtual bool? GenerateDtoTypes { get; internal set; }
        /// <summary>
        ///   Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).
        /// </summary>
        public virtual bool? GenerateOptionalParameters { get; internal set; }
        /// <summary>
        ///   Specifies whether to generate response classes (default: true).
        /// </summary>
        public virtual bool? GenerateResponseClasses { get; internal set; }
        /// <summary>
        ///   Handle JSON references (default: false).
        /// </summary>
        public virtual bool? HandleReferences { get; internal set; }
        /// <summary>
        ///   The Angular HTTP service class (default 'Http', 'HttpClient').
        /// </summary>
        public virtual HttpClass HttpClass { get; internal set; }
        /// <summary>
        ///   Specifies whether required types should be imported (default: true).
        /// </summary>
        public virtual bool? ImportRequiredTypes { get; internal set; }
        /// <summary>
        ///   The Angular injection token type (default 'InjectionToken', 'OpaqueToken').
        /// </summary>
        public virtual InjectionTokenType InjectionTokenType { get; internal set; }
        /// <summary>
        ///   Inline named any types (default: false).
        /// </summary>
        public virtual bool? InlineNamedAny { get; internal set; }
        /// <summary>
        ///   Inline named dictionaries (default: false).
        /// </summary>
        public virtual bool? InlineNamedDictionaries { get; internal set; }
        /// <summary>
        ///   Specifies whether to mark optional properties with ? (default: false).
        /// </summary>
        public virtual bool? MarkOptionalProperties { get; internal set; }
        /// <summary>
        ///   The TypeScript module name (default: '', no module).
        /// </summary>
        public virtual string ModuleName { get; internal set; }
        /// <summary>
        ///   The TypeScript namespace (default: '', no namespace).
        /// </summary>
        public virtual string Namespace { get; internal set; }
        /// <summary>
        ///   The null value used in object initializers (default 'Undefined', 'Null').
        /// </summary>
        public virtual TypeScriptNullValue NullValue { get; internal set; }
        /// <summary>
        ///   The operation generation mode ('SingleClientFromOperationId' or 'MultipleClientsFromPathSegments').
        /// </summary>
        public virtual OperationGenerationMode OperationGenerationMode { get; internal set; }
        /// <summary>
        ///   The promise type ('Promise' or 'QPromise').
        /// </summary>
        public virtual PromiseType PromiseType { get; internal set; }
        /// <summary>
        ///   List of methods with a protected access modifier ('classname.methodname').
        /// </summary>
        public virtual IReadOnlyList<string> ProtectedMethods => ProtectedMethodsInternal.AsReadOnly();
        internal List<string> ProtectedMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The null value used for query parameters which are null (default: '').
        /// </summary>
        public virtual string QueryNullValue { get; internal set; }
        /// <summary>
        ///   The response class (default 'SwaggerResponse', may use '{controller}' placeholder).
        /// </summary>
        public virtual string ResponseClass { get; internal set; }
        /// <summary>
        ///   The target RxJs version (default: 6.0).
        /// </summary>
        public virtual decimal? RxJsVersion { get; internal set; }
        /// <summary>
        ///   The type of the asynchronism handling ('JQueryCallbacks', 'JQueryPromises', 'AngularJS', 'Angular', 'Fetch', 'Aurelia').
        /// </summary>
        public virtual TypeScriptTemplate Template { get; internal set; }
        /// <summary>
        ///   The target TypeScript version (default: 2.7).
        /// </summary>
        public virtual decimal? TypeScriptVersion { get; internal set; }
        /// <summary>
        ///   The type style (default: Class).
        /// </summary>
        public virtual TypeScriptTypeStyle TypeStyle { get; internal set; }
        /// <summary>
        ///   Specifies whether to use the 'getBaseUrl(defaultUrl: string)' method from the base class (default: false).
        /// </summary>
        public virtual bool? UseGetBaseUrlMethod { get; internal set; }
        /// <summary>
        ///   Specifies whether to use the Angular 6 Singleton Provider (Angular template only, default: false).
        /// </summary>
        public virtual bool? UseSingletonProvider { get; internal set; }
        /// <summary>
        ///   Call 'transformOptions' on the base class or extension class (default: false).
        /// </summary>
        public virtual bool? UseTransformOptionsMethod { get; internal set; }
        /// <summary>
        ///   Call 'transformResult' on the base class or extension class (default: false).
        /// </summary>
        public virtual bool? UseTransformResultMethod { get; internal set; }
        /// <summary>
        ///   Specifies whether DTO exceptions are wrapped in a SwaggerException instance (default: false).
        /// </summary>
        public virtual bool? WrapDtoExceptions { get; internal set; }
        /// <summary>
        ///   List of methods where responses are wrapped ('ControllerName.MethodName', WrapResponses must be true).
        /// </summary>
        public virtual IReadOnlyList<string> WrapResponseMethods => WrapResponseMethodsInternal.AsReadOnly();
        internal List<string> WrapResponseMethodsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Specifies whether to wrap success responses to allow full response access (experimental).
        /// </summary>
        public virtual bool? WrapResponses { get; internal set; }
        /// <summary>
        ///   The custom IEnumNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string EnumNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The custom IPropertyNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string PropertyNameGeneratorType { get; internal set; }
        /// <summary>
        ///   The Liquid template directory (experimental).
        /// </summary>
        public virtual string TemplateDirectory { get; internal set; }
        /// <summary>
        ///   The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').
        /// </summary>
        public virtual string TypeNameGenerator { get; internal set; }
        /// <summary>
        ///   A file path or URL to the data or the JSON data itself.
        /// </summary>
        public virtual string Input { get; internal set; }
        /// <summary>
        ///   Overrides the service host of the web document (optional, use '.' to remove the hostname).
        /// </summary>
        public virtual string ServiceHost { get; internal set; }
        /// <summary>
        ///   Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').
        /// </summary>
        public virtual IReadOnlyList<string> ServiceSchemes => ServiceSchemesInternal.AsReadOnly();
        internal List<string> ServiceSchemesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The output file path (optional).
        /// </summary>
        public virtual string Output { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("swagger2tsclient")
              .Add("/BaseUrlTokenName:{value}", BaseUrlTokenName)
              .Add("/ClassName:{value}", ClassName)
              .Add("/ClassTypes:{value}", ClassTypes)
              .Add("/ClientBaseClass:{value}", ClientBaseClass)
              .Add("/ConfigurationClass:{value}", ConfigurationClass)
              .Add("/ConvertConstructorInterfaceData:{value}", ConvertConstructorInterfaceData)
              .Add("/DateTimeType:{value}", DateTimeType)
              .Add("/ExceptionClass:{value}", ExceptionClass)
              .Add("/ExcludedParameterNames:{value}", ExcludedParameterNames)
              .Add("/ExcludedTypeNames:{value}", ExcludedTypeNames)
              .Add("/ExportTypes:{value}", ExportTypes)
              .Add("/ExtendedClasses:{value}", ExtendedClasses)
              .Add("/ExtensionCode:{value}", ExtensionCode)
              .Add("/GenerateClientClasses:{value}", GenerateClientClasses)
              .Add("/GenerateClientInterfaces:{value}", GenerateClientInterfaces)
              .Add("/GenerateCloneMethod:{value}", GenerateCloneMethod)
              .Add("/GenerateConstructorInterface:{value}", GenerateConstructorInterface)
              .Add("/GenerateDefaultValues:{value}", GenerateDefaultValues)
              .Add("/GenerateDtoTypes:{value}", GenerateDtoTypes)
              .Add("/GenerateOptionalParameters:{value}", GenerateOptionalParameters)
              .Add("/GenerateResponseClasses:{value}", GenerateResponseClasses)
              .Add("/HandleReferences:{value}", HandleReferences)
              .Add("/HttpClass:{value}", HttpClass)
              .Add("/ImportRequiredTypes:{value}", ImportRequiredTypes)
              .Add("/InjectionTokenType:{value}", InjectionTokenType)
              .Add("/InlineNamedAny:{value}", InlineNamedAny)
              .Add("/InlineNamedDictionaries:{value}", InlineNamedDictionaries)
              .Add("/MarkOptionalProperties:{value}", MarkOptionalProperties)
              .Add("/ModuleName:{value}", ModuleName)
              .Add("/Namespace:{value}", Namespace)
              .Add("/NullValue:{value}", NullValue)
              .Add("/OperationGenerationMode:{value}", OperationGenerationMode)
              .Add("/PromiseType:{value}", PromiseType)
              .Add("/ProtectedMethods:{value}", ProtectedMethods)
              .Add("/QueryNullValue:{value}", QueryNullValue)
              .Add("/ResponseClass:{value}", ResponseClass)
              .Add("/RxJsVersion:{value}", RxJsVersion)
              .Add("/Template:{value}", Template)
              .Add("/TypeScriptVersion:{value}", TypeScriptVersion)
              .Add("/TypeStyle:{value}", TypeStyle)
              .Add("/UseGetBaseUrlMethod:{value}", UseGetBaseUrlMethod)
              .Add("/UseSingletonProvider:{value}", UseSingletonProvider)
              .Add("/UseTransformOptionsMethod:{value}", UseTransformOptionsMethod)
              .Add("/UseTransformResultMethod:{value}", UseTransformResultMethod)
              .Add("/WrapDtoExceptions:{value}", WrapDtoExceptions)
              .Add("/WrapResponseMethods:{value}", WrapResponseMethods)
              .Add("/WrapResponses:{value}", WrapResponses)
              .Add("/EnumNameGeneratorType:{value}", EnumNameGeneratorType)
              .Add("/PropertyNameGeneratorType:{value}", PropertyNameGeneratorType)
              .Add("/TemplateDirectory:{value}", TemplateDirectory)
              .Add("/TypeNameGenerator:{value}", TypeNameGenerator)
              .Add("/Input:{value}", Input)
              .Add("/ServiceHost:{value}", ServiceHost)
              .Add("/ServiceSchemes:{value}", ServiceSchemes)
              .Add("/Output:{value}", Output)
              .Add("{value}", GetNSwagRuntime(), customValue: true);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region NSwagVersionSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagVersionSettingsExtensions
    {
    }
    #endregion
    #region NSwagListTypesSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagListTypesSettingsExtensions
    {
        #region File
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.File"/></em></p>
        ///   <p>The nswag.json configuration file path.</p>
        /// </summary>
        [Pure]
        public static T SetFile<T>(this T toolSettings, string file) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.File = file;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListTypesSettings.File"/></em></p>
        ///   <p>The nswag.json configuration file path.</p>
        /// </summary>
        [Pure]
        public static T ResetFile<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.File = null;
            return toolSettings;
        }
        #endregion
        #region Variables
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.Variables"/> to a new dictionary</em></p>
        /// </summary>
        [Pure]
        public static T SetVariables<T>(this T toolSettings, IDictionary<string, object> variables) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal = variables.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListTypesSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T ClearVariables<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="NSwagListTypesSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T AddVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Add(variableKey, variableValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="NSwagListTypesSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T RemoveVariable<T>(this T toolSettings, string variableKey) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Remove(variableKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="NSwagListTypesSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T SetVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal[variableKey] = variableValue;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListTypesSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListTypesSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListTypesSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListTypesSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListTypesSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListTypesSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListTypesSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListTypesSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListTypesSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListTypesSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListTypesSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListTypesSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListTypesSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagListTypesSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagListTypesSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagListTypesSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagListTypesSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagListWebApiControllersSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagListWebApiControllersSettingsExtensions
    {
        #region File
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.File"/></em></p>
        ///   <p>The nswag.json configuration file path.</p>
        /// </summary>
        [Pure]
        public static T SetFile<T>(this T toolSettings, string file) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.File = file;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListWebApiControllersSettings.File"/></em></p>
        ///   <p>The nswag.json configuration file path.</p>
        /// </summary>
        [Pure]
        public static T ResetFile<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.File = null;
            return toolSettings;
        }
        #endregion
        #region Variables
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.Variables"/> to a new dictionary</em></p>
        /// </summary>
        [Pure]
        public static T SetVariables<T>(this T toolSettings, IDictionary<string, object> variables) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal = variables.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListWebApiControllersSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T ClearVariables<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="NSwagListWebApiControllersSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T AddVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Add(variableKey, variableValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="NSwagListWebApiControllersSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T RemoveVariable<T>(this T toolSettings, string variableKey) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Remove(variableKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="NSwagListWebApiControllersSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T SetVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal[variableKey] = variableValue;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListWebApiControllersSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListWebApiControllersSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListWebApiControllersSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListWebApiControllersSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListWebApiControllersSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListWebApiControllersSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagListWebApiControllersSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagListWebApiControllersSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagListWebApiControllersSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagTypesToOpenApiSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagTypesToOpenApiSettingsExtensions
    {
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagTypesToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagTypesToSwaggerSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagTypesToSwaggerSettingsExtensions
    {
        #region AllowReferencesWithProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetAllowReferencesWithProperties<T>(this T toolSettings, bool? allowReferencesWithProperties) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = allowReferencesWithProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = !toolSettings.AllowReferencesWithProperties;
            return toolSettings;
        }
        #endregion
        #region ClassNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.ClassNames"/> to a new list</em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T SetClassNames<T>(this T toolSettings, params string[] classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassNamesInternal = classNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.ClassNames"/> to a new list</em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T SetClassNames<T>(this T toolSettings, IEnumerable<string> classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassNamesInternal = classNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T AddClassNames<T>(this T toolSettings, params string[] classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassNamesInternal.AddRange(classNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T AddClassNames<T>(this T toolSettings, IEnumerable<string> classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassNamesInternal.AddRange(classNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T ClearClassNames<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T RemoveClassNames<T>(this T toolSettings, params string[] classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(classNames);
            toolSettings.ClassNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.ClassNames"/></em></p>
        ///   <p>The class names.</p>
        /// </summary>
        [Pure]
        public static T RemoveClassNames<T>(this T toolSettings, IEnumerable<string> classNames) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(classNames);
            toolSettings.ClassNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DefaultDictionaryValueReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultDictionaryValueReferenceTypeNullHandling) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = defaultDictionaryValueReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultEnumHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T SetDefaultEnumHandling<T>(this T toolSettings, EnumHandling defaultEnumHandling) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = defaultEnumHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultEnumHandling<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultPropertyNameHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultPropertyNameHandling<T>(this T toolSettings, PropertyNameHandling defaultPropertyNameHandling) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = defaultPropertyNameHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultPropertyNameHandling<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultReferenceTypeNullHandling) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = defaultReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region FlattenInheritanceHierarchy
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetFlattenInheritanceHierarchy<T>(this T toolSettings, bool? flattenInheritanceHierarchy) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = flattenInheritanceHierarchy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = !toolSettings.FlattenInheritanceHierarchy;
            return toolSettings;
        }
        #endregion
        #region GenerateKnownTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateKnownTypes<T>(this T toolSettings, bool? generateKnownTypes) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = generateKnownTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateKnownTypes<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateKnownTypes<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = !toolSettings.GenerateKnownTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateXmlObjects
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateXmlObjects<T>(this T toolSettings, bool? generateXmlObjects) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = generateXmlObjects;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateXmlObjects<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateXmlObjects<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = !toolSettings.GenerateXmlObjects;
            return toolSettings;
        }
        #endregion
        #region IgnoreObsoleteProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreObsoleteProperties<T>(this T toolSettings, bool? ignoreObsoleteProperties) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = ignoreObsoleteProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = !toolSettings.IgnoreObsoleteProperties;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagTypesToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagTypesToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagTypesToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagTypesToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagWebApiToOpenApiSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagWebApiToOpenApiSettingsExtensions
    {
        #region AllowNullableBodyParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T SetAllowNullableBodyParameters<T>(this T toolSettings, bool? allowNullableBodyParameters) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = allowNullableBodyParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = !toolSettings.AllowNullableBodyParameters;
            return toolSettings;
        }
        #endregion
        #region AllowReferencesWithProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetAllowReferencesWithProperties<T>(this T toolSettings, bool? allowReferencesWithProperties) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = allowReferencesWithProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = !toolSettings.AllowReferencesWithProperties;
            return toolSettings;
        }
        #endregion
        #region AspNetCoreEnvironment
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T SetAspNetCoreEnvironment<T>(this T toolSettings, string aspNetCoreEnvironment) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = aspNetCoreEnvironment;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T ResetAspNetCoreEnvironment<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = null;
            return toolSettings;
        }
        #endregion
        #region ContractResolver
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetContractResolver<T>(this T toolSettings, string contractResolver) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = contractResolver;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetContractResolver<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = null;
            return toolSettings;
        }
        #endregion
        #region CreateWebHostBuilderMethod
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T SetCreateWebHostBuilderMethod<T>(this T toolSettings, string createWebHostBuilderMethod) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = createWebHostBuilderMethod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T ResetCreateWebHostBuilderMethod<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = null;
            return toolSettings;
        }
        #endregion
        #region DefaultDictionaryValueReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultDictionaryValueReferenceTypeNullHandling) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = defaultDictionaryValueReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultEnumHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T SetDefaultEnumHandling<T>(this T toolSettings, EnumHandling defaultEnumHandling) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = defaultEnumHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultEnumHandling<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultPropertyNameHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultPropertyNameHandling<T>(this T toolSettings, PropertyNameHandling defaultPropertyNameHandling) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = defaultPropertyNameHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultPropertyNameHandling<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultReferenceTypeNullHandling) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = defaultReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultResponseReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultResponseReferenceTypeNullHandling) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = defaultResponseReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DocumentName
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentName<T>(this T toolSettings, string documentName) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = documentName;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentName<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = null;
            return toolSettings;
        }
        #endregion
        #region DocumentProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearDocumentProcessors<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DocumentTemplate
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentTemplate<T>(this T toolSettings, string documentTemplate) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = documentTemplate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentTemplate<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = null;
            return toolSettings;
        }
        #endregion
        #region ExcludedTypeNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedTypeNames<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region FlattenInheritanceHierarchy
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetFlattenInheritanceHierarchy<T>(this T toolSettings, bool? flattenInheritanceHierarchy) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = flattenInheritanceHierarchy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = !toolSettings.FlattenInheritanceHierarchy;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractProperties<T>(this T toolSettings, bool? generateAbstractProperties) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = generateAbstractProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = !toolSettings.GenerateAbstractProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractSchemas
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractSchemas<T>(this T toolSettings, bool? generateAbstractSchemas) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = generateAbstractSchemas;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = !toolSettings.GenerateAbstractSchemas;
            return toolSettings;
        }
        #endregion
        #region GenerateEnumMappingDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateEnumMappingDescription<T>(this T toolSettings, bool? generateEnumMappingDescription) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = generateEnumMappingDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = !toolSettings.GenerateEnumMappingDescription;
            return toolSettings;
        }
        #endregion
        #region GenerateKnownTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateKnownTypes<T>(this T toolSettings, bool? generateKnownTypes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = generateKnownTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = !toolSettings.GenerateKnownTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateXmlObjects
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateXmlObjects<T>(this T toolSettings, bool? generateXmlObjects) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = generateXmlObjects;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = !toolSettings.GenerateXmlObjects;
            return toolSettings;
        }
        #endregion
        #region IgnoreObsoleteProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreObsoleteProperties<T>(this T toolSettings, bool? ignoreObsoleteProperties) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = ignoreObsoleteProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = !toolSettings.IgnoreObsoleteProperties;
            return toolSettings;
        }
        #endregion
        #region InfoDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoDescription<T>(this T toolSettings, string infoDescription) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = infoDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoDescription<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = null;
            return toolSettings;
        }
        #endregion
        #region InfoTitle
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoTitle<T>(this T toolSettings, string infoTitle) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = infoTitle;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoTitle<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = null;
            return toolSettings;
        }
        #endregion
        #region InfoVersion
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoVersion<T>(this T toolSettings, string infoVersion) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = infoVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoVersion<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = null;
            return toolSettings;
        }
        #endregion
        #region OperationProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearOperationProcessors<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region SchemaNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSchemaNameGenerator<T>(this T toolSettings, string schemaNameGenerator) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = schemaNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSchemaNameGenerator<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region SerializerSettings
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSerializerSettings<T>(this T toolSettings, string serializerSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = serializerSettings;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSerializerSettings<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = null;
            return toolSettings;
        }
        #endregion
        #region ServiceBasePath
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T SetServiceBasePath<T>(this T toolSettings, string serviceBasePath) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = serviceBasePath;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceBasePath<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Startup
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T SetStartup<T>(this T toolSettings, string startup) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = startup;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T ResetStartup<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = null;
            return toolSettings;
        }
        #endregion
        #region TypeNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetTypeNameGenerator<T>(this T toolSettings, string typeNameGenerator) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = typeNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetTypeNameGenerator<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region UseDocumentProvider
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T SetUseDocumentProvider<T>(this T toolSettings, bool? useDocumentProvider) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = useDocumentProvider;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ResetUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T EnableUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T DisableUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ToggleUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = !toolSettings.UseDocumentProvider;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagWebApiToSwaggerSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagWebApiToSwaggerSettingsExtensions
    {
        #region AddMissingPathParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></em></p>
        ///   <p>Specifies whether to add path parameters which are missing in the action method (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetAddMissingPathParameters<T>(this T toolSettings, bool? addMissingPathParameters) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AddMissingPathParameters = addMissingPathParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></em></p>
        ///   <p>Specifies whether to add path parameters which are missing in the action method (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetAddMissingPathParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AddMissingPathParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></em></p>
        ///   <p>Specifies whether to add path parameters which are missing in the action method (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableAddMissingPathParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AddMissingPathParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></em></p>
        ///   <p>Specifies whether to add path parameters which are missing in the action method (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableAddMissingPathParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AddMissingPathParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.AddMissingPathParameters"/></em></p>
        ///   <p>Specifies whether to add path parameters which are missing in the action method (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleAddMissingPathParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AddMissingPathParameters = !toolSettings.AddMissingPathParameters;
            return toolSettings;
        }
        #endregion
        #region AspNetCore
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></em></p>
        ///   <p>Specifies whether the controllers are hosted by ASP.NET Core.</p>
        /// </summary>
        [Pure]
        public static T SetAspNetCore<T>(this T toolSettings, bool? aspNetCore) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCore = aspNetCore;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></em></p>
        ///   <p>Specifies whether the controllers are hosted by ASP.NET Core.</p>
        /// </summary>
        [Pure]
        public static T ResetAspNetCore<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCore = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></em></p>
        ///   <p>Specifies whether the controllers are hosted by ASP.NET Core.</p>
        /// </summary>
        [Pure]
        public static T EnableAspNetCore<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCore = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></em></p>
        ///   <p>Specifies whether the controllers are hosted by ASP.NET Core.</p>
        /// </summary>
        [Pure]
        public static T DisableAspNetCore<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCore = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.AspNetCore"/></em></p>
        ///   <p>Specifies whether the controllers are hosted by ASP.NET Core.</p>
        /// </summary>
        [Pure]
        public static T ToggleAspNetCore<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCore = !toolSettings.AspNetCore;
            return toolSettings;
        }
        #endregion
        #region Controller
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Controller"/></em></p>
        ///   <p>The Web API controller full class name or empty to load all controllers from the assembly.</p>
        /// </summary>
        [Pure]
        public static T SetController<T>(this T toolSettings, string controller) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Controller = controller;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.Controller"/></em></p>
        ///   <p>The Web API controller full class name or empty to load all controllers from the assembly.</p>
        /// </summary>
        [Pure]
        public static T ResetController<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Controller = null;
            return toolSettings;
        }
        #endregion
        #region Controllers
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Controllers"/> to a new list</em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetControllers<T>(this T toolSettings, params string[] controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ControllersInternal = controllers.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Controllers"/> to a new list</em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetControllers<T>(this T toolSettings, IEnumerable<string> controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ControllersInternal = controllers.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddControllers<T>(this T toolSettings, params string[] controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ControllersInternal.AddRange(controllers);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddControllers<T>(this T toolSettings, IEnumerable<string> controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ControllersInternal.AddRange(controllers);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearControllers<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ControllersInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveControllers<T>(this T toolSettings, params string[] controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(controllers);
            toolSettings.ControllersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.Controllers"/></em></p>
        ///   <p>The Web API controller full class names or empty to load all controllers from the assembly (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveControllers<T>(this T toolSettings, IEnumerable<string> controllers) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(controllers);
            toolSettings.ControllersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DefaultUrlTemplate
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultUrlTemplate"/></em></p>
        ///   <p>The Web API default URL template (default for Web API: 'api/{controller}/{id}'; for MVC projects: '{controller}/{action}/{id?}').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultUrlTemplate<T>(this T toolSettings, string defaultUrlTemplate) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultUrlTemplate = defaultUrlTemplate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultUrlTemplate"/></em></p>
        ///   <p>The Web API default URL template (default for Web API: 'api/{controller}/{id}'; for MVC projects: '{controller}/{action}/{id?}').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultUrlTemplate<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultUrlTemplate = null;
            return toolSettings;
        }
        #endregion
        #region IncludedVersions
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/> to a new list</em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T SetIncludedVersions<T>(this T toolSettings, params string[] includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludedVersionsInternal = includedVersions.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/> to a new list</em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T SetIncludedVersions<T>(this T toolSettings, IEnumerable<string> includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludedVersionsInternal = includedVersions.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T AddIncludedVersions<T>(this T toolSettings, params string[] includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludedVersionsInternal.AddRange(includedVersions);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T AddIncludedVersions<T>(this T toolSettings, IEnumerable<string> includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludedVersionsInternal.AddRange(includedVersions);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T ClearIncludedVersions<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IncludedVersionsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T RemoveIncludedVersions<T>(this T toolSettings, params string[] includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(includedVersions);
            toolSettings.IncludedVersionsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.IncludedVersions"/></em></p>
        ///   <p>The included API versions used by the ApiVersionProcessor (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T RemoveIncludedVersions<T>(this T toolSettings, IEnumerable<string> includedVersions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(includedVersions);
            toolSettings.IncludedVersionsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region ResolveJsonOptions
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></em></p>
        ///   <p>Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).</p>
        /// </summary>
        [Pure]
        public static T SetResolveJsonOptions<T>(this T toolSettings, bool? resolveJsonOptions) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResolveJsonOptions = resolveJsonOptions;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></em></p>
        ///   <p>Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).</p>
        /// </summary>
        [Pure]
        public static T ResetResolveJsonOptions<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResolveJsonOptions = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></em></p>
        ///   <p>Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).</p>
        /// </summary>
        [Pure]
        public static T EnableResolveJsonOptions<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResolveJsonOptions = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></em></p>
        ///   <p>Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).</p>
        /// </summary>
        [Pure]
        public static T DisableResolveJsonOptions<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResolveJsonOptions = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.ResolveJsonOptions"/></em></p>
        ///   <p>Specifies whether to resolve MvcJsonOptions to infer serializer settings (recommended, default: false, only available when IsAspNetCore is set).</p>
        /// </summary>
        [Pure]
        public static T ToggleResolveJsonOptions<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ResolveJsonOptions = !toolSettings.ResolveJsonOptions;
            return toolSettings;
        }
        #endregion
        #region AllowNullableBodyParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T SetAllowNullableBodyParameters<T>(this T toolSettings, bool? allowNullableBodyParameters) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = allowNullableBodyParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = !toolSettings.AllowNullableBodyParameters;
            return toolSettings;
        }
        #endregion
        #region AllowReferencesWithProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetAllowReferencesWithProperties<T>(this T toolSettings, bool? allowReferencesWithProperties) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = allowReferencesWithProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = !toolSettings.AllowReferencesWithProperties;
            return toolSettings;
        }
        #endregion
        #region AspNetCoreEnvironment
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T SetAspNetCoreEnvironment<T>(this T toolSettings, string aspNetCoreEnvironment) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = aspNetCoreEnvironment;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T ResetAspNetCoreEnvironment<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = null;
            return toolSettings;
        }
        #endregion
        #region ContractResolver
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetContractResolver<T>(this T toolSettings, string contractResolver) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = contractResolver;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetContractResolver<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = null;
            return toolSettings;
        }
        #endregion
        #region CreateWebHostBuilderMethod
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T SetCreateWebHostBuilderMethod<T>(this T toolSettings, string createWebHostBuilderMethod) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = createWebHostBuilderMethod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T ResetCreateWebHostBuilderMethod<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = null;
            return toolSettings;
        }
        #endregion
        #region DefaultDictionaryValueReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultDictionaryValueReferenceTypeNullHandling) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = defaultDictionaryValueReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultEnumHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T SetDefaultEnumHandling<T>(this T toolSettings, EnumHandling defaultEnumHandling) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = defaultEnumHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultEnumHandling<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultPropertyNameHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultPropertyNameHandling<T>(this T toolSettings, PropertyNameHandling defaultPropertyNameHandling) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = defaultPropertyNameHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultPropertyNameHandling<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultReferenceTypeNullHandling) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = defaultReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultResponseReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultResponseReferenceTypeNullHandling) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = defaultResponseReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DocumentName
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentName<T>(this T toolSettings, string documentName) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = documentName;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentName<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = null;
            return toolSettings;
        }
        #endregion
        #region DocumentProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearDocumentProcessors<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DocumentTemplate
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentTemplate<T>(this T toolSettings, string documentTemplate) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = documentTemplate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentTemplate<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = null;
            return toolSettings;
        }
        #endregion
        #region ExcludedTypeNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedTypeNames<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region FlattenInheritanceHierarchy
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetFlattenInheritanceHierarchy<T>(this T toolSettings, bool? flattenInheritanceHierarchy) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = flattenInheritanceHierarchy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = !toolSettings.FlattenInheritanceHierarchy;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractProperties<T>(this T toolSettings, bool? generateAbstractProperties) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = generateAbstractProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = !toolSettings.GenerateAbstractProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractSchemas
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractSchemas<T>(this T toolSettings, bool? generateAbstractSchemas) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = generateAbstractSchemas;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = !toolSettings.GenerateAbstractSchemas;
            return toolSettings;
        }
        #endregion
        #region GenerateEnumMappingDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateEnumMappingDescription<T>(this T toolSettings, bool? generateEnumMappingDescription) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = generateEnumMappingDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = !toolSettings.GenerateEnumMappingDescription;
            return toolSettings;
        }
        #endregion
        #region GenerateKnownTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateKnownTypes<T>(this T toolSettings, bool? generateKnownTypes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = generateKnownTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateKnownTypes<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = !toolSettings.GenerateKnownTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateXmlObjects
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateXmlObjects<T>(this T toolSettings, bool? generateXmlObjects) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = generateXmlObjects;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateXmlObjects<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = !toolSettings.GenerateXmlObjects;
            return toolSettings;
        }
        #endregion
        #region IgnoreObsoleteProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreObsoleteProperties<T>(this T toolSettings, bool? ignoreObsoleteProperties) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = ignoreObsoleteProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = !toolSettings.IgnoreObsoleteProperties;
            return toolSettings;
        }
        #endregion
        #region InfoDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoDescription<T>(this T toolSettings, string infoDescription) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = infoDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoDescription<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = null;
            return toolSettings;
        }
        #endregion
        #region InfoTitle
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoTitle<T>(this T toolSettings, string infoTitle) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = infoTitle;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoTitle<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = null;
            return toolSettings;
        }
        #endregion
        #region InfoVersion
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoVersion<T>(this T toolSettings, string infoVersion) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = infoVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoVersion<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = null;
            return toolSettings;
        }
        #endregion
        #region OperationProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearOperationProcessors<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region SchemaNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSchemaNameGenerator<T>(this T toolSettings, string schemaNameGenerator) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = schemaNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSchemaNameGenerator<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region SerializerSettings
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSerializerSettings<T>(this T toolSettings, string serializerSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = serializerSettings;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSerializerSettings<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = null;
            return toolSettings;
        }
        #endregion
        #region ServiceBasePath
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T SetServiceBasePath<T>(this T toolSettings, string serviceBasePath) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = serviceBasePath;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceBasePath<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Startup
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T SetStartup<T>(this T toolSettings, string startup) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = startup;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T ResetStartup<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = null;
            return toolSettings;
        }
        #endregion
        #region TypeNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetTypeNameGenerator<T>(this T toolSettings, string typeNameGenerator) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = typeNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetTypeNameGenerator<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region UseDocumentProvider
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T SetUseDocumentProvider<T>(this T toolSettings, bool? useDocumentProvider) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = useDocumentProvider;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ResetUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T EnableUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T DisableUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ToggleUseDocumentProvider<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = !toolSettings.UseDocumentProvider;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagWebApiToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagWebApiToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagWebApiToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagAspNetCoreToOpenApiSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagAspNetCoreToOpenApiSettingsExtensions
    {
        #region AllowNullableBodyParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T SetAllowNullableBodyParameters<T>(this T toolSettings, bool? allowNullableBodyParameters) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = allowNullableBodyParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = !toolSettings.AllowNullableBodyParameters;
            return toolSettings;
        }
        #endregion
        #region AllowReferencesWithProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetAllowReferencesWithProperties<T>(this T toolSettings, bool? allowReferencesWithProperties) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = allowReferencesWithProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = !toolSettings.AllowReferencesWithProperties;
            return toolSettings;
        }
        #endregion
        #region AspNetCoreEnvironment
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T SetAspNetCoreEnvironment<T>(this T toolSettings, string aspNetCoreEnvironment) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = aspNetCoreEnvironment;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T ResetAspNetCoreEnvironment<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = null;
            return toolSettings;
        }
        #endregion
        #region ContractResolver
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetContractResolver<T>(this T toolSettings, string contractResolver) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = contractResolver;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetContractResolver<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = null;
            return toolSettings;
        }
        #endregion
        #region CreateWebHostBuilderMethod
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T SetCreateWebHostBuilderMethod<T>(this T toolSettings, string createWebHostBuilderMethod) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = createWebHostBuilderMethod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T ResetCreateWebHostBuilderMethod<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = null;
            return toolSettings;
        }
        #endregion
        #region DefaultDictionaryValueReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultDictionaryValueReferenceTypeNullHandling) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = defaultDictionaryValueReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultEnumHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T SetDefaultEnumHandling<T>(this T toolSettings, EnumHandling defaultEnumHandling) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = defaultEnumHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultEnumHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultPropertyNameHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultPropertyNameHandling<T>(this T toolSettings, PropertyNameHandling defaultPropertyNameHandling) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = defaultPropertyNameHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultPropertyNameHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultReferenceTypeNullHandling) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = defaultReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultResponseReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultResponseReferenceTypeNullHandling) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = defaultResponseReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DocumentName
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentName<T>(this T toolSettings, string documentName) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = documentName;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentName<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = null;
            return toolSettings;
        }
        #endregion
        #region DocumentProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearDocumentProcessors<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DocumentTemplate
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentTemplate<T>(this T toolSettings, string documentTemplate) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = documentTemplate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentTemplate<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = null;
            return toolSettings;
        }
        #endregion
        #region ExcludedTypeNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedTypeNames<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region FlattenInheritanceHierarchy
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetFlattenInheritanceHierarchy<T>(this T toolSettings, bool? flattenInheritanceHierarchy) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = flattenInheritanceHierarchy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = !toolSettings.FlattenInheritanceHierarchy;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractProperties<T>(this T toolSettings, bool? generateAbstractProperties) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = generateAbstractProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = !toolSettings.GenerateAbstractProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractSchemas
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractSchemas<T>(this T toolSettings, bool? generateAbstractSchemas) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = generateAbstractSchemas;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = !toolSettings.GenerateAbstractSchemas;
            return toolSettings;
        }
        #endregion
        #region GenerateEnumMappingDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateEnumMappingDescription<T>(this T toolSettings, bool? generateEnumMappingDescription) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = generateEnumMappingDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = !toolSettings.GenerateEnumMappingDescription;
            return toolSettings;
        }
        #endregion
        #region GenerateKnownTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateKnownTypes<T>(this T toolSettings, bool? generateKnownTypes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = generateKnownTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = !toolSettings.GenerateKnownTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateXmlObjects
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateXmlObjects<T>(this T toolSettings, bool? generateXmlObjects) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = generateXmlObjects;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = !toolSettings.GenerateXmlObjects;
            return toolSettings;
        }
        #endregion
        #region IgnoreObsoleteProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreObsoleteProperties<T>(this T toolSettings, bool? ignoreObsoleteProperties) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = ignoreObsoleteProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = !toolSettings.IgnoreObsoleteProperties;
            return toolSettings;
        }
        #endregion
        #region InfoDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoDescription<T>(this T toolSettings, string infoDescription) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = infoDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = null;
            return toolSettings;
        }
        #endregion
        #region InfoTitle
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoTitle<T>(this T toolSettings, string infoTitle) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = infoTitle;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoTitle<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = null;
            return toolSettings;
        }
        #endregion
        #region InfoVersion
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoVersion<T>(this T toolSettings, string infoVersion) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = infoVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoVersion<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = null;
            return toolSettings;
        }
        #endregion
        #region OperationProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearOperationProcessors<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region SchemaNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSchemaNameGenerator<T>(this T toolSettings, string schemaNameGenerator) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = schemaNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSchemaNameGenerator<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region SerializerSettings
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSerializerSettings<T>(this T toolSettings, string serializerSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = serializerSettings;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSerializerSettings<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = null;
            return toolSettings;
        }
        #endregion
        #region ServiceBasePath
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T SetServiceBasePath<T>(this T toolSettings, string serviceBasePath) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = serviceBasePath;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceBasePath<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Startup
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T SetStartup<T>(this T toolSettings, string startup) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = startup;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T ResetStartup<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = null;
            return toolSettings;
        }
        #endregion
        #region TypeNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetTypeNameGenerator<T>(this T toolSettings, string typeNameGenerator) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = typeNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetTypeNameGenerator<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region UseDocumentProvider
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T SetUseDocumentProvider<T>(this T toolSettings, bool? useDocumentProvider) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = useDocumentProvider;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ResetUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T EnableUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T DisableUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ToggleUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = !toolSettings.UseDocumentProvider;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToOpenApiSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToOpenApiSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToOpenApiSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagAspNetCoreToSwaggerSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagAspNetCoreToSwaggerSettingsExtensions
    {
        #region ApiGroupNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/> to a new list</em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T SetApiGroupNames<T>(this T toolSettings, params string[] apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroupNamesInternal = apiGroupNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/> to a new list</em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T SetApiGroupNames<T>(this T toolSettings, IEnumerable<string> apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroupNamesInternal = apiGroupNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T AddApiGroupNames<T>(this T toolSettings, params string[] apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroupNamesInternal.AddRange(apiGroupNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T AddApiGroupNames<T>(this T toolSettings, IEnumerable<string> apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroupNamesInternal.AddRange(apiGroupNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T ClearApiGroupNames<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ApiGroupNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T RemoveApiGroupNames<T>(this T toolSettings, params string[] apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(apiGroupNames);
            toolSettings.ApiGroupNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ApiGroupNames"/></em></p>
        ///   <p>The ASP.NET Core API Explorer group names to include (comma separated, default: empty = all).</p>
        /// </summary>
        [Pure]
        public static T RemoveApiGroupNames<T>(this T toolSettings, IEnumerable<string> apiGroupNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(apiGroupNames);
            toolSettings.ApiGroupNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Configuration
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Configuration"/></em></p>
        ///   <p>The configuration to use.</p>
        /// </summary>
        [Pure]
        public static T SetConfiguration<T>(this T toolSettings, string configuration) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = configuration;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Configuration"/></em></p>
        ///   <p>The configuration to use.</p>
        /// </summary>
        [Pure]
        public static T ResetConfiguration<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Configuration = null;
            return toolSettings;
        }
        #endregion
        #region MSBuildProjectExtensionsPath
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.MSBuildProjectExtensionsPath"/></em></p>
        ///   <p>The MSBuild project extensions path. Defaults to "obj".</p>
        /// </summary>
        [Pure]
        public static T SetMSBuildProjectExtensionsPath<T>(this T toolSettings, string msbuildProjectExtensionsPath) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.MSBuildProjectExtensionsPath = msbuildProjectExtensionsPath;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.MSBuildProjectExtensionsPath"/></em></p>
        ///   <p>The MSBuild project extensions path. Defaults to "obj".</p>
        /// </summary>
        [Pure]
        public static T ResetMSBuildProjectExtensionsPath<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.MSBuildProjectExtensionsPath = null;
            return toolSettings;
        }
        #endregion
        #region NoBuild
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></em></p>
        ///   <p>Don't build the project. Only use this when the build is up-to-date.</p>
        /// </summary>
        [Pure]
        public static T SetNoBuild<T>(this T toolSettings, bool? noBuild) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoBuild = noBuild;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></em></p>
        ///   <p>Don't build the project. Only use this when the build is up-to-date.</p>
        /// </summary>
        [Pure]
        public static T ResetNoBuild<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoBuild = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></em></p>
        ///   <p>Don't build the project. Only use this when the build is up-to-date.</p>
        /// </summary>
        [Pure]
        public static T EnableNoBuild<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoBuild = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></em></p>
        ///   <p>Don't build the project. Only use this when the build is up-to-date.</p>
        /// </summary>
        [Pure]
        public static T DisableNoBuild<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoBuild = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.NoBuild"/></em></p>
        ///   <p>Don't build the project. Only use this when the build is up-to-date.</p>
        /// </summary>
        [Pure]
        public static T ToggleNoBuild<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NoBuild = !toolSettings.NoBuild;
            return toolSettings;
        }
        #endregion
        #region NSwagWorkingDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagWorkingDirectory"/></em></p>
        ///   <p>The working directory to use.</p>
        /// </summary>
        [Pure]
        public static T SetNSwagWorkingDirectory<T>(this T toolSettings, string nswagWorkingDirectory) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NSwagWorkingDirectory = nswagWorkingDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.NSwagWorkingDirectory"/></em></p>
        ///   <p>The working directory to use.</p>
        /// </summary>
        [Pure]
        public static T ResetNSwagWorkingDirectory<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.NSwagWorkingDirectory = null;
            return toolSettings;
        }
        #endregion
        #region Project
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Project"/></em></p>
        ///   <p>The project to use.</p>
        /// </summary>
        [Pure]
        public static T SetProject<T>(this T toolSettings, string project) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = project;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Project"/></em></p>
        ///   <p>The project to use.</p>
        /// </summary>
        [Pure]
        public static T ResetProject<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Project = null;
            return toolSettings;
        }
        #endregion
        #region RequireParametersWithoutDefault
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></em></p>
        ///   <p>Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetRequireParametersWithoutDefault<T>(this T toolSettings, bool? requireParametersWithoutDefault) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequireParametersWithoutDefault = requireParametersWithoutDefault;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></em></p>
        ///   <p>Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetRequireParametersWithoutDefault<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequireParametersWithoutDefault = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></em></p>
        ///   <p>Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableRequireParametersWithoutDefault<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequireParametersWithoutDefault = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></em></p>
        ///   <p>Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableRequireParametersWithoutDefault<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequireParametersWithoutDefault = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.RequireParametersWithoutDefault"/></em></p>
        ///   <p>Parameters without default value are always required(i.e. api explorer info and only optional when default is set, legacy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleRequireParametersWithoutDefault<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequireParametersWithoutDefault = !toolSettings.RequireParametersWithoutDefault;
            return toolSettings;
        }
        #endregion
        #region Runtime
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Runtime"/></em></p>
        ///   <p>The runtime to use.</p>
        /// </summary>
        [Pure]
        public static T SetRuntime<T>(this T toolSettings, string runtime) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = runtime;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Runtime"/></em></p>
        ///   <p>The runtime to use.</p>
        /// </summary>
        [Pure]
        public static T ResetRuntime<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Runtime = null;
            return toolSettings;
        }
        #endregion
        #region TargetFramework
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.TargetFramework"/></em></p>
        ///   <p>The target framework to use.</p>
        /// </summary>
        [Pure]
        public static T SetTargetFramework<T>(this T toolSettings, string targetFramework) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetFramework = targetFramework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.TargetFramework"/></em></p>
        ///   <p>The target framework to use.</p>
        /// </summary>
        [Pure]
        public static T ResetTargetFramework<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetFramework = null;
            return toolSettings;
        }
        #endregion
        #region Verbose
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></em></p>
        ///   <p>Print verbose output.</p>
        /// </summary>
        [Pure]
        public static T SetVerbose<T>(this T toolSettings, bool? verbose) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = verbose;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></em></p>
        ///   <p>Print verbose output.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbose<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></em></p>
        ///   <p>Print verbose output.</p>
        /// </summary>
        [Pure]
        public static T EnableVerbose<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></em></p>
        ///   <p>Print verbose output.</p>
        /// </summary>
        [Pure]
        public static T DisableVerbose<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.Verbose"/></em></p>
        ///   <p>Print verbose output.</p>
        /// </summary>
        [Pure]
        public static T ToggleVerbose<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbose = !toolSettings.Verbose;
            return toolSettings;
        }
        #endregion
        #region AllowNullableBodyParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T SetAllowNullableBodyParameters<T>(this T toolSettings, bool? allowNullableBodyParameters) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = allowNullableBodyParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.AllowNullableBodyParameters"/></em></p>
        ///   <p>Nullable body parameters are allowed (ignored when MvcOptions.AllowEmptyInputInBodyModelBinding is available (ASP.NET Core 2.0+), default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowNullableBodyParameters<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowNullableBodyParameters = !toolSettings.AllowNullableBodyParameters;
            return toolSettings;
        }
        #endregion
        #region AllowReferencesWithProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetAllowReferencesWithProperties<T>(this T toolSettings, bool? allowReferencesWithProperties) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = allowReferencesWithProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.AllowReferencesWithProperties"/></em></p>
        ///   <p>Use $ref references even if additional properties are defined on the object (otherwise allOf/oneOf with $ref is used, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleAllowReferencesWithProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AllowReferencesWithProperties = !toolSettings.AllowReferencesWithProperties;
            return toolSettings;
        }
        #endregion
        #region AspNetCoreEnvironment
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T SetAspNetCoreEnvironment<T>(this T toolSettings, string aspNetCoreEnvironment) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = aspNetCoreEnvironment;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.AspNetCoreEnvironment"/></em></p>
        ///   <p>Sets the ASPNETCORE_ENVIRONMENT if provided (default: empty).</p>
        /// </summary>
        [Pure]
        public static T ResetAspNetCoreEnvironment<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AspNetCoreEnvironment = null;
            return toolSettings;
        }
        #endregion
        #region ContractResolver
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetContractResolver<T>(this T toolSettings, string contractResolver) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = contractResolver;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.ContractResolver"/></em></p>
        ///   <p>DEPRECATED: The custom IContractResolver implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetContractResolver<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ContractResolver = null;
            return toolSettings;
        }
        #endregion
        #region CreateWebHostBuilderMethod
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T SetCreateWebHostBuilderMethod<T>(this T toolSettings, string createWebHostBuilderMethod) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = createWebHostBuilderMethod;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.CreateWebHostBuilderMethod"/></em></p>
        ///   <p>The CreateWebHostBuilder method in the form 'assemblyName:fullTypeName.methodName' or 'fullTypeName.methodName'.</p>
        /// </summary>
        [Pure]
        public static T ResetCreateWebHostBuilderMethod<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.CreateWebHostBuilderMethod = null;
            return toolSettings;
        }
        #endregion
        #region DefaultDictionaryValueReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultDictionaryValueReferenceTypeNullHandling) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = defaultDictionaryValueReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultDictionaryValueReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling of dictionary value types (NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultDictionaryValueReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultDictionaryValueReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultEnumHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T SetDefaultEnumHandling<T>(this T toolSettings, EnumHandling defaultEnumHandling) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = defaultEnumHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultEnumHandling"/></em></p>
        ///   <p>The default enum handling ('String' or 'Integer'), default: Integer.</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultEnumHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultEnumHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultPropertyNameHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T SetDefaultPropertyNameHandling<T>(this T toolSettings, PropertyNameHandling defaultPropertyNameHandling) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = defaultPropertyNameHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultPropertyNameHandling"/></em></p>
        ///   <p>The default property name handling ('Default' or 'CamelCase').</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultPropertyNameHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultPropertyNameHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultReferenceTypeNullHandling) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = defaultReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultReferenceTypeNullHandling"/></em></p>
        ///   <p>The default reference type null handling (Null (default) or NotNull).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DefaultResponseReferenceTypeNullHandling
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T SetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings, ReferenceTypeNullHandling defaultResponseReferenceTypeNullHandling) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = defaultResponseReferenceTypeNullHandling;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DefaultResponseReferenceTypeNullHandling"/></em></p>
        ///   <p>The default response reference type null handling (default: NotNull (default) or Null).</p>
        /// </summary>
        [Pure]
        public static T ResetDefaultResponseReferenceTypeNullHandling<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DefaultResponseReferenceTypeNullHandling = null;
            return toolSettings;
        }
        #endregion
        #region DocumentName
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentName<T>(this T toolSettings, string documentName) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = documentName;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentName"/></em></p>
        ///   <p>The document name to use in SwaggerDocumentProvider (default: v1).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentName<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentName = null;
            return toolSettings;
        }
        #endregion
        #region DocumentProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/> to a new list</em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal = documentProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.AddRange(documentProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearDocumentProcessors<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, params string[] documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentProcessors"/></em></p>
        ///   <p>The document processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveDocumentProcessors<T>(this T toolSettings, IEnumerable<string> documentProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(documentProcessors);
            toolSettings.DocumentProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region DocumentTemplate
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T SetDocumentTemplate<T>(this T toolSettings, string documentTemplate) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = documentTemplate;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.DocumentTemplate"/></em></p>
        ///   <p>Specifies the Swagger document template (may be a path or JSON, default: none).</p>
        /// </summary>
        [Pure]
        public static T ResetDocumentTemplate<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DocumentTemplate = null;
            return toolSettings;
        }
        #endregion
        #region ExcludedTypeNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedTypeNames<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded type names (same as JsonSchemaIgnoreAttribute).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region FlattenInheritanceHierarchy
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetFlattenInheritanceHierarchy<T>(this T toolSettings, bool? flattenInheritanceHierarchy) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = flattenInheritanceHierarchy;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.FlattenInheritanceHierarchy"/></em></p>
        ///   <p>Flatten the inheritance hierarchy instead of using allOf to describe inheritance (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleFlattenInheritanceHierarchy<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FlattenInheritanceHierarchy = !toolSettings.FlattenInheritanceHierarchy;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractProperties<T>(this T toolSettings, bool? generateAbstractProperties) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = generateAbstractProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractProperties"/></em></p>
        ///   <p>Generate abstract properties (i.e. interface and abstract properties. Properties may defined multiple times in a inheritance hierarchy, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractProperties = !toolSettings.GenerateAbstractProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateAbstractSchemas
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateAbstractSchemas<T>(this T toolSettings, bool? generateAbstractSchemas) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = generateAbstractSchemas;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateAbstractSchemas"/></em></p>
        ///   <p>Generate the x-abstract flag on schemas (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateAbstractSchemas<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateAbstractSchemas = !toolSettings.GenerateAbstractSchemas;
            return toolSettings;
        }
        #endregion
        #region GenerateEnumMappingDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateEnumMappingDescription<T>(this T toolSettings, bool? generateEnumMappingDescription) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = generateEnumMappingDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateEnumMappingDescription"/></em></p>
        ///   <p>Generate a description with number to enum name mappings (for integer enums only, default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateEnumMappingDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateEnumMappingDescription = !toolSettings.GenerateEnumMappingDescription;
            return toolSettings;
        }
        #endregion
        #region GenerateKnownTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateKnownTypes<T>(this T toolSettings, bool? generateKnownTypes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = generateKnownTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateKnownTypes"/></em></p>
        ///   <p>Generate schemas for types in KnownTypeAttribute attributes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateKnownTypes<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateKnownTypes = !toolSettings.GenerateKnownTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateXmlObjects
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateXmlObjects<T>(this T toolSettings, bool? generateXmlObjects) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = generateXmlObjects;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.GenerateXmlObjects"/></em></p>
        ///   <p>Generate xmlObject representation for definitions (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateXmlObjects<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateXmlObjects = !toolSettings.GenerateXmlObjects;
            return toolSettings;
        }
        #endregion
        #region IgnoreObsoleteProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetIgnoreObsoleteProperties<T>(this T toolSettings, bool? ignoreObsoleteProperties) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = ignoreObsoleteProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.IgnoreObsoleteProperties"/></em></p>
        ///   <p>Ignore properties with the ObsoleteAttribute (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleIgnoreObsoleteProperties<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.IgnoreObsoleteProperties = !toolSettings.IgnoreObsoleteProperties;
            return toolSettings;
        }
        #endregion
        #region InfoDescription
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoDescription<T>(this T toolSettings, string infoDescription) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = infoDescription;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoDescription"/></em></p>
        ///   <p>Specify the description of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoDescription<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoDescription = null;
            return toolSettings;
        }
        #endregion
        #region InfoTitle
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoTitle<T>(this T toolSettings, string infoTitle) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = infoTitle;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoTitle"/></em></p>
        ///   <p>Specify the title of the Swagger specification (ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoTitle<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoTitle = null;
            return toolSettings;
        }
        #endregion
        #region InfoVersion
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T SetInfoVersion<T>(this T toolSettings, string infoVersion) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = infoVersion;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.InfoVersion"/></em></p>
        ///   <p>Specify the version of the Swagger specification (default: 1.0.0, ignored when DocumentTemplate is set).</p>
        /// </summary>
        [Pure]
        public static T ResetInfoVersion<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InfoVersion = null;
            return toolSettings;
        }
        #endregion
        #region OperationProcessors
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/> to a new list</em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal = operationProcessors.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T AddOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.AddRange(operationProcessors);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ClearOperationProcessors<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OperationProcessorsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, params string[] operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.OperationProcessors"/></em></p>
        ///   <p>The operation processor type names in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T RemoveOperationProcessors<T>(this T toolSettings, IEnumerable<string> operationProcessors) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(operationProcessors);
            toolSettings.OperationProcessorsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region SchemaNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSchemaNameGenerator<T>(this T toolSettings, string schemaNameGenerator) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = schemaNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.SchemaNameGenerator"/></em></p>
        ///   <p>The custom ISchemaNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSchemaNameGenerator<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SchemaNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region SerializerSettings
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetSerializerSettings<T>(this T toolSettings, string serializerSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = serializerSettings;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.SerializerSettings"/></em></p>
        ///   <p>The custom JsonSerializerSettings implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetSerializerSettings<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SerializerSettings = null;
            return toolSettings;
        }
        #endregion
        #region ServiceBasePath
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T SetServiceBasePath<T>(this T toolSettings, string serviceBasePath) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = serviceBasePath;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceBasePath"/></em></p>
        ///   <p>The basePath of the Swagger specification (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceBasePath<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceBasePath = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web service (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Startup
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T SetStartup<T>(this T toolSettings, string startup) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = startup;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Startup"/></em></p>
        ///   <p>The Startup class type in the form 'assemblyName:fullTypeName' or 'fullTypeName'.</p>
        /// </summary>
        [Pure]
        public static T ResetStartup<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Startup = null;
            return toolSettings;
        }
        #endregion
        #region TypeNameGenerator
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T SetTypeNameGenerator<T>(this T toolSettings, string typeNameGenerator) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = typeNameGenerator;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.TypeNameGenerator"/></em></p>
        ///   <p>The custom ITypeNameGenerator implementation type in the form 'assemblyName:fullTypeName' or 'fullTypeName').</p>
        /// </summary>
        [Pure]
        public static T ResetTypeNameGenerator<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TypeNameGenerator = null;
            return toolSettings;
        }
        #endregion
        #region UseDocumentProvider
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T SetUseDocumentProvider<T>(this T toolSettings, bool? useDocumentProvider) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = useDocumentProvider;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ResetUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T EnableUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T DisableUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.UseDocumentProvider"/></em></p>
        ///   <p>Generate document using SwaggerDocumentProvider (configuration from AddOpenApiDocument()/AddSwaggerDocument(), most CLI settings will be ignored).</p>
        /// </summary>
        [Pure]
        public static T ToggleUseDocumentProvider<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseDocumentProvider = !toolSettings.UseDocumentProvider;
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
        #region OutputType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T SetOutputType<T>(this T toolSettings, SchemaType outputType) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = outputType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.OutputType"/></em></p>
        ///   <p>Specifies the output schema type, ignored when UseDocumentProvider is enabled (Swagger2|OpenApi3, default: Swagger2).</p>
        /// </summary>
        [Pure]
        public static T ResetOutputType<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.OutputType = null;
            return toolSettings;
        }
        #endregion
        #region Assembly
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/> to a new list</em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal = assembly.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.AddRange(assembly);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearAssembly<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, params string[] assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.Assembly"/></em></p>
        ///   <p>The path or paths to the .NET assemblies (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveAssembly<T>(this T toolSettings, IEnumerable<string> assembly) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assembly);
            toolSettings.AssemblyInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AssemblyConfig
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyConfig<T>(this T toolSettings, string assemblyConfig) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = assemblyConfig;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.AssemblyConfig"/></em></p>
        ///   <p>The path to the assembly App.config or Web.config (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetAssemblyConfig<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyConfig = null;
            return toolSettings;
        }
        #endregion
        #region ReferencePaths
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/> to a new list</em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T SetReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal = referencePaths.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T AddReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.AddRange(referencePaths);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T ClearReferencePaths<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReferencePathsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, params string[] referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagAspNetCoreToSwaggerSettings.ReferencePaths"/></em></p>
        ///   <p>The paths to search for referenced assembly files (comma separated).</p>
        /// </summary>
        [Pure]
        public static T RemoveReferencePaths<T>(this T toolSettings, IEnumerable<string> referencePaths) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(referencePaths);
            toolSettings.ReferencePathsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region UseNuGetCache
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T SetUseNuGetCache<T>(this T toolSettings, bool? useNuGetCache) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = useNuGetCache;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ResetUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T EnableUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T DisableUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagAspNetCoreToSwaggerSettings.UseNuGetCache"/></em></p>
        ///   <p>Determines if local Nuget's cache folder should be put in the ReferencePaths by default</p>
        /// </summary>
        [Pure]
        public static T ToggleUseNuGetCache<T>(this T toolSettings) where T : NSwagAspNetCoreToSwaggerSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.UseNuGetCache = !toolSettings.UseNuGetCache;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagCreateDocumentSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagCreateDocumentSettingsExtensions
    {
    }
    #endregion
    #region NSwagExecuteDocumentSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagExecuteDocumentSettingsExtensions
    {
        #region Input
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagExecuteDocumentSettings.Input"/></em></p>
        /// </summary>
        [Pure]
        public static T SetInput<T>(this T toolSettings, string input) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = input;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagExecuteDocumentSettings.Input"/></em></p>
        /// </summary>
        [Pure]
        public static T ResetInput<T>(this T toolSettings) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = null;
            return toolSettings;
        }
        #endregion
        #region Variables
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagExecuteDocumentSettings.Variables"/> to a new dictionary</em></p>
        /// </summary>
        [Pure]
        public static T SetVariables<T>(this T toolSettings, IDictionary<string, object> variables) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal = variables.ToDictionary(x => x.Key, x => x.Value, StringComparer.OrdinalIgnoreCase);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagExecuteDocumentSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T ClearVariables<T>(this T toolSettings) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds a new key-value-pair <see cref="NSwagExecuteDocumentSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T AddVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Add(variableKey, variableValue);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes a key-value-pair from <see cref="NSwagExecuteDocumentSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T RemoveVariable<T>(this T toolSettings, string variableKey) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal.Remove(variableKey);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets a key-value-pair in <see cref="NSwagExecuteDocumentSettings.Variables"/></em></p>
        /// </summary>
        [Pure]
        public static T SetVariable<T>(this T toolSettings, string variableKey, object variableValue) where T : NSwagExecuteDocumentSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.VariablesInternal[variableKey] = variableValue;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagJsonSchemaToCSharpSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagJsonSchemaToCSharpSettingsExtensions
    {
        #region AnyType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.AnyType"/></em></p>
        ///   <p>The any .NET type (default: 'object').</p>
        /// </summary>
        [Pure]
        public static T SetAnyType<T>(this T toolSettings, string anyType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnyType = anyType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.AnyType"/></em></p>
        ///   <p>The any .NET type (default: 'object').</p>
        /// </summary>
        [Pure]
        public static T ResetAnyType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnyType = null;
            return toolSettings;
        }
        #endregion
        #region ArrayInstanceType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.ArrayInstanceType"/></em></p>
        ///   <p>The generic array .NET instance type (default: empty = ArrayType).</p>
        /// </summary>
        [Pure]
        public static T SetArrayInstanceType<T>(this T toolSettings, string arrayInstanceType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayInstanceType = arrayInstanceType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.ArrayInstanceType"/></em></p>
        ///   <p>The generic array .NET instance type (default: empty = ArrayType).</p>
        /// </summary>
        [Pure]
        public static T ResetArrayInstanceType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayInstanceType = null;
            return toolSettings;
        }
        #endregion
        #region ArrayType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.ArrayType"/></em></p>
        ///   <p>The generic array .NET type (default: 'ObservableCollection').</p>
        /// </summary>
        [Pure]
        public static T SetArrayType<T>(this T toolSettings, string arrayType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayType = arrayType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.ArrayType"/></em></p>
        ///   <p>The generic array .NET type (default: 'ObservableCollection').</p>
        /// </summary>
        [Pure]
        public static T ResetArrayType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayType = null;
            return toolSettings;
        }
        #endregion
        #region DateTimeType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.DateTimeType"/></em></p>
        ///   <p>The date time .NET type (default: 'DateTime').</p>
        /// </summary>
        [Pure]
        public static T SetDateTimeType<T>(this T toolSettings, string dateTimeType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateTimeType = dateTimeType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.DateTimeType"/></em></p>
        ///   <p>The date time .NET type (default: 'DateTime').</p>
        /// </summary>
        [Pure]
        public static T ResetDateTimeType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateTimeType = null;
            return toolSettings;
        }
        #endregion
        #region DictionaryInstanceType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryInstanceType"/></em></p>
        ///   <p>The generic dictionary .NET instance type (default: empty = DictionaryType).</p>
        /// </summary>
        [Pure]
        public static T SetDictionaryInstanceType<T>(this T toolSettings, string dictionaryInstanceType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryInstanceType = dictionaryInstanceType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryInstanceType"/></em></p>
        ///   <p>The generic dictionary .NET instance type (default: empty = DictionaryType).</p>
        /// </summary>
        [Pure]
        public static T ResetDictionaryInstanceType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryInstanceType = null;
            return toolSettings;
        }
        #endregion
        #region DictionaryType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'Dictionary').</p>
        /// </summary>
        [Pure]
        public static T SetDictionaryType<T>(this T toolSettings, string dictionaryType) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryType = dictionaryType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.DictionaryType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'Dictionary').</p>
        /// </summary>
        [Pure]
        public static T ResetDictionaryType<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryType = null;
            return toolSettings;
        }
        #endregion
        #region GenerateOptionalPropertiesAsNullable
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateOptionalPropertiesAsNullable<T>(this T toolSettings, bool? generateOptionalPropertiesAsNullable) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = generateOptionalPropertiesAsNullable;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagJsonSchemaToCSharpSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = !toolSettings.GenerateOptionalPropertiesAsNullable;
            return toolSettings;
        }
        #endregion
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.Name"/></em></p>
        ///   <p>The class name of the root schema.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.Name"/></em></p>
        ///   <p>The class name of the root schema.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region Namespace
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.Namespace"/></em></p>
        ///   <p>The namespace of the generated classes.</p>
        /// </summary>
        [Pure]
        public static T SetNamespace<T>(this T toolSettings, string @namespace) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespace = @namespace;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.Namespace"/></em></p>
        ///   <p>The namespace of the generated classes.</p>
        /// </summary>
        [Pure]
        public static T ResetNamespace<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Namespace = null;
            return toolSettings;
        }
        #endregion
        #region RequiredPropertiesMustBeDefined
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></em></p>
        ///   <p>Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).</p>
        /// </summary>
        [Pure]
        public static T SetRequiredPropertiesMustBeDefined<T>(this T toolSettings, bool? requiredPropertiesMustBeDefined) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequiredPropertiesMustBeDefined = requiredPropertiesMustBeDefined;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></em></p>
        ///   <p>Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).</p>
        /// </summary>
        [Pure]
        public static T ResetRequiredPropertiesMustBeDefined<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequiredPropertiesMustBeDefined = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></em></p>
        ///   <p>Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).</p>
        /// </summary>
        [Pure]
        public static T EnableRequiredPropertiesMustBeDefined<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequiredPropertiesMustBeDefined = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></em></p>
        ///   <p>Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).</p>
        /// </summary>
        [Pure]
        public static T DisableRequiredPropertiesMustBeDefined<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequiredPropertiesMustBeDefined = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagJsonSchemaToCSharpSettings.RequiredPropertiesMustBeDefined"/></em></p>
        ///   <p>Specifies whether a required property must be defined in JSON (sets Required.Always when the property is required).</p>
        /// </summary>
        [Pure]
        public static T ToggleRequiredPropertiesMustBeDefined<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.RequiredPropertiesMustBeDefined = !toolSettings.RequiredPropertiesMustBeDefined;
            return toolSettings;
        }
        #endregion
        #region Input
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.Input"/></em></p>
        ///   <p>A file path or URL to the data or the JSON data itself.</p>
        /// </summary>
        [Pure]
        public static T SetInput<T>(this T toolSettings, string input) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = input;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.Input"/></em></p>
        ///   <p>A file path or URL to the data or the JSON data itself.</p>
        /// </summary>
        [Pure]
        public static T ResetInput<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web document (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web document (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagJsonSchemaToCSharpSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToCSharpSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToCSharpSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagJsonSchemaToCSharpSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagJsonSchemaToTypeScriptSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagJsonSchemaToTypeScriptSettingsExtensions
    {
        #region Name
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.Name"/></em></p>
        ///   <p>The type name of the root schema.</p>
        /// </summary>
        [Pure]
        public static T SetName<T>(this T toolSettings, string name) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = name;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToTypeScriptSettings.Name"/></em></p>
        ///   <p>The type name of the root schema.</p>
        /// </summary>
        [Pure]
        public static T ResetName<T>(this T toolSettings) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Name = null;
            return toolSettings;
        }
        #endregion
        #region Input
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.Input"/></em></p>
        ///   <p>A file path or URL to the data or the JSON data itself.</p>
        /// </summary>
        [Pure]
        public static T SetInput<T>(this T toolSettings, string input) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = input;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToTypeScriptSettings.Input"/></em></p>
        ///   <p>A file path or URL to the data or the JSON data itself.</p>
        /// </summary>
        [Pure]
        public static T ResetInput<T>(this T toolSettings) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Input = null;
            return toolSettings;
        }
        #endregion
        #region ServiceHost
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web document (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T SetServiceHost<T>(this T toolSettings, string serviceHost) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = serviceHost;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceHost"/></em></p>
        ///   <p>Overrides the service host of the web document (optional, use '.' to remove the hostname).</p>
        /// </summary>
        [Pure]
        public static T ResetServiceHost<T>(this T toolSettings) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceHost = null;
            return toolSettings;
        }
        #endregion
        #region ServiceSchemes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/> to a new list</em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T SetServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal = serviceSchemes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T AddServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.AddRange(serviceSchemes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T ClearServiceSchemes<T>(this T toolSettings) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ServiceSchemesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, params string[] serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagJsonSchemaToTypeScriptSettings.ServiceSchemes"/></em></p>
        ///   <p>Overrides the allowed schemes of the web service (optional, comma separated, 'http', 'https', 'ws', 'wss').</p>
        /// </summary>
        [Pure]
        public static T RemoveServiceSchemes<T>(this T toolSettings, IEnumerable<string> serviceSchemes) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(serviceSchemes);
            toolSettings.ServiceSchemesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Output
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagJsonSchemaToTypeScriptSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T SetOutput<T>(this T toolSettings, string output) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = output;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagJsonSchemaToTypeScriptSettings.Output"/></em></p>
        ///   <p>The output file path (optional).</p>
        /// </summary>
        [Pure]
        public static T ResetOutput<T>(this T toolSettings) where T : NSwagJsonSchemaToTypeScriptSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Output = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region NSwagOpenApiToCSharpClientSettingsExtensions
    /// <summary>
    ///   Used within <see cref="NSwagTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class NSwagOpenApiToCSharpClientSettingsExtensions
    {
        #region AdditionalContractNamespaceUsages
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/> to a new list</em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T SetAdditionalContractNamespaceUsages<T>(this T toolSettings, params string[] additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalContractNamespaceUsagesInternal = additionalContractNamespaceUsages.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/> to a new list</em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T SetAdditionalContractNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalContractNamespaceUsagesInternal = additionalContractNamespaceUsages.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T AddAdditionalContractNamespaceUsages<T>(this T toolSettings, params string[] additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalContractNamespaceUsagesInternal.AddRange(additionalContractNamespaceUsages);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T AddAdditionalContractNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalContractNamespaceUsagesInternal.AddRange(additionalContractNamespaceUsages);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T ClearAdditionalContractNamespaceUsages<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalContractNamespaceUsagesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T RemoveAdditionalContractNamespaceUsages<T>(this T toolSettings, params string[] additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(additionalContractNamespaceUsages);
            toolSettings.AdditionalContractNamespaceUsagesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalContractNamespaceUsages"/></em></p>
        ///   <p>The additional contract namespace usages.</p>
        /// </summary>
        [Pure]
        public static T RemoveAdditionalContractNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalContractNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(additionalContractNamespaceUsages);
            toolSettings.AdditionalContractNamespaceUsagesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AdditionalNamespaceUsages
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/> to a new list</em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T SetAdditionalNamespaceUsages<T>(this T toolSettings, params string[] additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalNamespaceUsagesInternal = additionalNamespaceUsages.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/> to a new list</em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T SetAdditionalNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalNamespaceUsagesInternal = additionalNamespaceUsages.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T AddAdditionalNamespaceUsages<T>(this T toolSettings, params string[] additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalNamespaceUsagesInternal.AddRange(additionalNamespaceUsages);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T AddAdditionalNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalNamespaceUsagesInternal.AddRange(additionalNamespaceUsages);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T ClearAdditionalNamespaceUsages<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AdditionalNamespaceUsagesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T RemoveAdditionalNamespaceUsages<T>(this T toolSettings, params string[] additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(additionalNamespaceUsages);
            toolSettings.AdditionalNamespaceUsagesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.AdditionalNamespaceUsages"/></em></p>
        ///   <p>The additional namespace usages.</p>
        /// </summary>
        [Pure]
        public static T RemoveAdditionalNamespaceUsages<T>(this T toolSettings, IEnumerable<string> additionalNamespaceUsages) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(additionalNamespaceUsages);
            toolSettings.AdditionalNamespaceUsagesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region AnyType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.AnyType"/></em></p>
        ///   <p>The any .NET type (default: 'object').</p>
        /// </summary>
        [Pure]
        public static T SetAnyType<T>(this T toolSettings, string anyType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnyType = anyType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.AnyType"/></em></p>
        ///   <p>The any .NET type (default: 'object').</p>
        /// </summary>
        [Pure]
        public static T ResetAnyType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AnyType = null;
            return toolSettings;
        }
        #endregion
        #region ArrayBaseType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayBaseType"/></em></p>
        ///   <p>The generic array .NET type (default: 'Collection').</p>
        /// </summary>
        [Pure]
        public static T SetArrayBaseType<T>(this T toolSettings, string arrayBaseType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayBaseType = arrayBaseType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayBaseType"/></em></p>
        ///   <p>The generic array .NET type (default: 'Collection').</p>
        /// </summary>
        [Pure]
        public static T ResetArrayBaseType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayBaseType = null;
            return toolSettings;
        }
        #endregion
        #region ArrayInstanceType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayInstanceType"/></em></p>
        ///   <p>The generic array .NET instance type (default: empty = ArrayType).</p>
        /// </summary>
        [Pure]
        public static T SetArrayInstanceType<T>(this T toolSettings, string arrayInstanceType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayInstanceType = arrayInstanceType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayInstanceType"/></em></p>
        ///   <p>The generic array .NET instance type (default: empty = ArrayType).</p>
        /// </summary>
        [Pure]
        public static T ResetArrayInstanceType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayInstanceType = null;
            return toolSettings;
        }
        #endregion
        #region ArrayType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayType"/></em></p>
        ///   <p>The generic array .NET type (default: 'ICollection').</p>
        /// </summary>
        [Pure]
        public static T SetArrayType<T>(this T toolSettings, string arrayType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayType = arrayType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.ArrayType"/></em></p>
        ///   <p>The generic array .NET type (default: 'ICollection').</p>
        /// </summary>
        [Pure]
        public static T ResetArrayType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ArrayType = null;
            return toolSettings;
        }
        #endregion
        #region ClassName
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ClassName"/></em></p>
        ///   <p>The class name of the generated client.</p>
        /// </summary>
        [Pure]
        public static T SetClassName<T>(this T toolSettings, string className) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassName = className;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.ClassName"/></em></p>
        ///   <p>The class name of the generated client.</p>
        /// </summary>
        [Pure]
        public static T ResetClassName<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassName = null;
            return toolSettings;
        }
        #endregion
        #region ClassStyle
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ClassStyle"/></em></p>
        ///   <p>The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').</p>
        /// </summary>
        [Pure]
        public static T SetClassStyle<T>(this T toolSettings, CSharpClassStyle classStyle) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassStyle = classStyle;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.ClassStyle"/></em></p>
        ///   <p>The CSharp class style, 'Poco' or 'Inpc' (default: 'Poco').</p>
        /// </summary>
        [Pure]
        public static T ResetClassStyle<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassStyle = null;
            return toolSettings;
        }
        #endregion
        #region DateTimeType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.DateTimeType"/></em></p>
        ///   <p>The date time .NET type (default: 'DateTimeOffset').</p>
        /// </summary>
        [Pure]
        public static T SetDateTimeType<T>(this T toolSettings, string dateTimeType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateTimeType = dateTimeType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.DateTimeType"/></em></p>
        ///   <p>The date time .NET type (default: 'DateTimeOffset').</p>
        /// </summary>
        [Pure]
        public static T ResetDateTimeType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateTimeType = null;
            return toolSettings;
        }
        #endregion
        #region DateType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.DateType"/></em></p>
        ///   <p>The date .NET type (default: 'DateTimeOffset').</p>
        /// </summary>
        [Pure]
        public static T SetDateType<T>(this T toolSettings, string dateType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateType = dateType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.DateType"/></em></p>
        ///   <p>The date .NET type (default: 'DateTimeOffset').</p>
        /// </summary>
        [Pure]
        public static T ResetDateType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DateType = null;
            return toolSettings;
        }
        #endregion
        #region DictionaryBaseType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryBaseType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'Dictionary').</p>
        /// </summary>
        [Pure]
        public static T SetDictionaryBaseType<T>(this T toolSettings, string dictionaryBaseType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryBaseType = dictionaryBaseType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryBaseType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'Dictionary').</p>
        /// </summary>
        [Pure]
        public static T ResetDictionaryBaseType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryBaseType = null;
            return toolSettings;
        }
        #endregion
        #region DictionaryInstanceType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryInstanceType"/></em></p>
        ///   <p>The generic dictionary .NET instance type (default: empty = DictionaryType).</p>
        /// </summary>
        [Pure]
        public static T SetDictionaryInstanceType<T>(this T toolSettings, string dictionaryInstanceType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryInstanceType = dictionaryInstanceType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryInstanceType"/></em></p>
        ///   <p>The generic dictionary .NET instance type (default: empty = DictionaryType).</p>
        /// </summary>
        [Pure]
        public static T ResetDictionaryInstanceType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryInstanceType = null;
            return toolSettings;
        }
        #endregion
        #region DictionaryType
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'IDictionary').</p>
        /// </summary>
        [Pure]
        public static T SetDictionaryType<T>(this T toolSettings, string dictionaryType) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryType = dictionaryType;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.DictionaryType"/></em></p>
        ///   <p>The generic dictionary .NET type (default: 'IDictionary').</p>
        /// </summary>
        [Pure]
        public static T ResetDictionaryType<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.DictionaryType = null;
            return toolSettings;
        }
        #endregion
        #region EnforceFlagEnums
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></em></p>
        ///   <p>Specifies whether enums should be always generated as bit flags (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetEnforceFlagEnums<T>(this T toolSettings, bool? enforceFlagEnums) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnforceFlagEnums = enforceFlagEnums;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></em></p>
        ///   <p>Specifies whether enums should be always generated as bit flags (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetEnforceFlagEnums<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnforceFlagEnums = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></em></p>
        ///   <p>Specifies whether enums should be always generated as bit flags (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableEnforceFlagEnums<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnforceFlagEnums = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></em></p>
        ///   <p>Specifies whether enums should be always generated as bit flags (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableEnforceFlagEnums<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnforceFlagEnums = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.EnforceFlagEnums"/></em></p>
        ///   <p>Specifies whether enums should be always generated as bit flags (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleEnforceFlagEnums<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.EnforceFlagEnums = !toolSettings.EnforceFlagEnums;
            return toolSettings;
        }
        #endregion
        #region ExcludedParameterNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/> to a new list</em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T SetExcludedParameterNames<T>(this T toolSettings, params string[] excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedParameterNamesInternal = excludedParameterNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/> to a new list</em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T SetExcludedParameterNames<T>(this T toolSettings, IEnumerable<string> excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedParameterNamesInternal = excludedParameterNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T AddExcludedParameterNames<T>(this T toolSettings, params string[] excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedParameterNamesInternal.AddRange(excludedParameterNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T AddExcludedParameterNames<T>(this T toolSettings, IEnumerable<string> excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedParameterNamesInternal.AddRange(excludedParameterNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedParameterNames<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedParameterNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedParameterNames<T>(this T toolSettings, params string[] excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedParameterNames);
            toolSettings.ExcludedParameterNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedParameterNames"/></em></p>
        ///   <p>The globally excluded parameter names.</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedParameterNames<T>(this T toolSettings, IEnumerable<string> excludedParameterNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedParameterNames);
            toolSettings.ExcludedParameterNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region ExcludedTypeNames
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/> to a new list</em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T SetExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal = excludedTypeNames.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T AddExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.AddRange(excludedTypeNames);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T ClearExcludedTypeNames<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ExcludedTypeNamesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, params string[] excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="NSwagOpenApiToCSharpClientSettings.ExcludedTypeNames"/></em></p>
        ///   <p>The excluded DTO type names (must be defined in an import or other namespace).</p>
        /// </summary>
        [Pure]
        public static T RemoveExcludedTypeNames<T>(this T toolSettings, IEnumerable<string> excludedTypeNames) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(excludedTypeNames);
            toolSettings.ExcludedTypeNamesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region GenerateDataAnnotations
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></em></p>
        ///   <p>Specifies whether to generate data annotation attributes on DTO classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateDataAnnotations<T>(this T toolSettings, bool? generateDataAnnotations) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDataAnnotations = generateDataAnnotations;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></em></p>
        ///   <p>Specifies whether to generate data annotation attributes on DTO classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateDataAnnotations<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDataAnnotations = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></em></p>
        ///   <p>Specifies whether to generate data annotation attributes on DTO classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateDataAnnotations<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDataAnnotations = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></em></p>
        ///   <p>Specifies whether to generate data annotation attributes on DTO classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateDataAnnotations<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDataAnnotations = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDataAnnotations"/></em></p>
        ///   <p>Specifies whether to generate data annotation attributes on DTO classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateDataAnnotations<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDataAnnotations = !toolSettings.GenerateDataAnnotations;
            return toolSettings;
        }
        #endregion
        #region GenerateDefaultValues
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></em></p>
        ///   <p>Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateDefaultValues<T>(this T toolSettings, bool? generateDefaultValues) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDefaultValues = generateDefaultValues;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></em></p>
        ///   <p>Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateDefaultValues<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDefaultValues = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></em></p>
        ///   <p>Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateDefaultValues<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDefaultValues = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></em></p>
        ///   <p>Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateDefaultValues<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDefaultValues = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDefaultValues"/></em></p>
        ///   <p>Specifies whether to generate default values for properties (may generate CSharp 6 code, default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateDefaultValues<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDefaultValues = !toolSettings.GenerateDefaultValues;
            return toolSettings;
        }
        #endregion
        #region GenerateDtoTypes
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></em></p>
        ///   <p>Specifies whether to generate DTO classes.</p>
        /// </summary>
        [Pure]
        public static T SetGenerateDtoTypes<T>(this T toolSettings, bool? generateDtoTypes) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDtoTypes = generateDtoTypes;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></em></p>
        ///   <p>Specifies whether to generate DTO classes.</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateDtoTypes<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDtoTypes = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></em></p>
        ///   <p>Specifies whether to generate DTO classes.</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateDtoTypes<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDtoTypes = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></em></p>
        ///   <p>Specifies whether to generate DTO classes.</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateDtoTypes<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDtoTypes = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateDtoTypes"/></em></p>
        ///   <p>Specifies whether to generate DTO classes.</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateDtoTypes<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateDtoTypes = !toolSettings.GenerateDtoTypes;
            return toolSettings;
        }
        #endregion
        #region GenerateImmutableArrayProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable array properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateImmutableArrayProperties<T>(this T toolSettings, bool? generateImmutableArrayProperties) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableArrayProperties = generateImmutableArrayProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable array properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateImmutableArrayProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableArrayProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable array properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateImmutableArrayProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableArrayProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable array properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateImmutableArrayProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableArrayProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableArrayProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable array properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateImmutableArrayProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableArrayProperties = !toolSettings.GenerateImmutableArrayProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateImmutableDictionaryProperties
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable dictionary properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateImmutableDictionaryProperties<T>(this T toolSettings, bool? generateImmutableDictionaryProperties) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableDictionaryProperties = generateImmutableDictionaryProperties;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable dictionary properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateImmutableDictionaryProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableDictionaryProperties = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable dictionary properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateImmutableDictionaryProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableDictionaryProperties = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable dictionary properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateImmutableDictionaryProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableDictionaryProperties = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateImmutableDictionaryProperties"/></em></p>
        ///   <p>Specifies whether to remove the setter for non-nullable dictionary properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateImmutableDictionaryProperties<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateImmutableDictionaryProperties = !toolSettings.GenerateImmutableDictionaryProperties;
            return toolSettings;
        }
        #endregion
        #region GenerateJsonMethods
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></em></p>
        ///   <p>Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateJsonMethods<T>(this T toolSettings, bool? generateJsonMethods) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateJsonMethods = generateJsonMethods;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></em></p>
        ///   <p>Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateJsonMethods<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateJsonMethods = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></em></p>
        ///   <p>Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateJsonMethods<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateJsonMethods = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></em></p>
        ///   <p>Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateJsonMethods<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateJsonMethods = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateJsonMethods"/></em></p>
        ///   <p>Specifies whether to render ToJson() and FromJson() methods for DTOs (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateJsonMethods<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateJsonMethods = !toolSettings.GenerateJsonMethods;
            return toolSettings;
        }
        #endregion
        #region GenerateOptionalParameters
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></em></p>
        ///   <p>Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateOptionalParameters<T>(this T toolSettings, bool? generateOptionalParameters) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalParameters = generateOptionalParameters;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></em></p>
        ///   <p>Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateOptionalParameters<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalParameters = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></em></p>
        ///   <p>Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateOptionalParameters<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalParameters = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></em></p>
        ///   <p>Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateOptionalParameters<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalParameters = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalParameters"/></em></p>
        ///   <p>Specifies whether to reorder parameters (required first, optional at the end) and generate optional parameters (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateOptionalParameters<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalParameters = !toolSettings.GenerateOptionalParameters;
            return toolSettings;
        }
        #endregion
        #region GenerateOptionalPropertiesAsNullable
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateOptionalPropertiesAsNullable<T>(this T toolSettings, bool? generateOptionalPropertiesAsNullable) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = generateOptionalPropertiesAsNullable;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateOptionalPropertiesAsNullable"/></em></p>
        ///   <p>Specifies whether optional schema properties (not required) are generated as nullable properties (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateOptionalPropertiesAsNullable<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateOptionalPropertiesAsNullable = !toolSettings.GenerateOptionalPropertiesAsNullable;
            return toolSettings;
        }
        #endregion
        #region GenerateResponseClasses
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></em></p>
        ///   <p>Specifies whether to generate response classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T SetGenerateResponseClasses<T>(this T toolSettings, bool? generateResponseClasses) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateResponseClasses = generateResponseClasses;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></em></p>
        ///   <p>Specifies whether to generate response classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ResetGenerateResponseClasses<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateResponseClasses = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></em></p>
        ///   <p>Specifies whether to generate response classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T EnableGenerateResponseClasses<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateResponseClasses = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></em></p>
        ///   <p>Specifies whether to generate response classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T DisableGenerateResponseClasses<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateResponseClasses = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.GenerateResponseClasses"/></em></p>
        ///   <p>Specifies whether to generate response classes (default: true).</p>
        /// </summary>
        [Pure]
        public static T ToggleGenerateResponseClasses<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.GenerateResponseClasses = !toolSettings.GenerateResponseClasses;
            return toolSettings;
        }
        #endregion
        #region HandleReferences
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></em></p>
        ///   <p>Use preserve references handling (All) in the JSON serializer (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetHandleReferences<T>(this T toolSettings, bool? handleReferences) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HandleReferences = handleReferences;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></em></p>
        ///   <p>Use preserve references handling (All) in the JSON serializer (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetHandleReferences<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HandleReferences = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></em></p>
        ///   <p>Use preserve references handling (All) in the JSON serializer (default: false).</p>
        /// </summary>
        [Pure]
        public static T EnableHandleReferences<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HandleReferences = true;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Disables <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></em></p>
        ///   <p>Use preserve references handling (All) in the JSON serializer (default: false).</p>
        /// </summary>
        [Pure]
        public static T DisableHandleReferences<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HandleReferences = false;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Toggles <see cref="NSwagOpenApiToCSharpClientSettings.HandleReferences"/></em></p>
        ///   <p>Use preserve references handling (All) in the JSON serializer (default: false).</p>
        /// </summary>
        [Pure]
        public static T ToggleHandleReferences<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HandleReferences = !toolSettings.HandleReferences;
            return toolSettings;
        }
        #endregion
        #region InlineNamedAny
        /// <summary>
        ///   <p><em>Sets <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedAny"/></em></p>
        ///   <p>Inline named any types (default: false).</p>
        /// </summary>
        [Pure]
        public static T SetInlineNamedAny<T>(this T toolSettings, bool? inlineNamedAny) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InlineNamedAny = inlineNamedAny;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="NSwagOpenApiToCSharpClientSettings.InlineNamedAny"/></em></p>
        ///   <p>Inline named any types (default: false).</p>
        /// </summary>
        [Pure]
        public static T ResetInlineNamedAny<T>(this T toolSettings) where T : NSwagOpenApiToCSharpClientSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.InlineNamedAny = null;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Enables <see cref="NSwagOpenApiToCSha