// Generated from https://github.com/nuke-build/nuke/blob/master/build/specifications/ReportGenerator.json

using JetBrains.Annotations;
using Newtonsoft.Json;
using Nuke.Common;
using Nuke.Common.Execution;
using Nuke.Common.Tooling;
using Nuke.Common.Tools;
using Nuke.Common.Utilities.Collections;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Text;

namespace Nuke.Common.Tools.ReportGenerator
{
    /// <summary>
    ///   <p>ReportGenerator converts XML reports generated by OpenCover, PartCover, dotCover, Visual Studio, NCover or Cobertura into human readable reports in various formats.</p><p>The reports do not only show the coverage quota, but also include the source code and visualize which lines have been covered.</p><p>ReportGenerator supports merging several reports into one. It is also possible to pass one XML file containing several reports to ReportGenerator (e.g. a build log file).</p><p>The following <a href="https://github.com/danielpalme/ReportGenerator/wiki/Output-formats">output formats</a> are supported by ReportGenerator:<ul><li>HTML, HTMLSummary, HTMLInline, HTMLChart, <a href="https://en.wikipedia.org/wiki/MHTML">MHTML</a></li><li>XML, XMLSummary</li><li>Latex, LatexSummary</li><li>TextSummary</li><li>CsvSummary</li><li>PngChart</li><li>Badges</li><li><a href="https://github.com/danielpalme/ReportGenerator/wiki/Custom-reports">Custom reports</a></li></ul></p><p>Compatibility:<ul><li><a href="https://github.com/OpenCover/opencover">OpenCover</a></li><li><a href="https://github.com/sawilde/partcover.net4">PartCover 4.0</a></li><li><a href="http://sourceforge.net/projects/partcover">PartCover 2.2, 2.3</a></li><li><a href="https://www.jetbrains.com/dotcover/help/dotCover__Console_Runner_Commands.html">dotCover</a> (/ReportType=DetailedXML)</li><li>Visual Studio (<a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#vstestconsoleexe">vstest.console.exe</a>, <a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#codecoverageexe">CodeCoverage.exe</a>)</li><li><a href="http://www.ncover.com/download/current">NCover</a> (tested version 1.5.8, other versions may not work)</li><li><a href="https://github.com/cobertura/cobertura">Cobertura</a></li><li>Mono (<a href="http://www.mono-project.com/docs/debug+profile/profile/profiler/#analyzing-the-profile-data">mprof-report</a>)</li></ul></p>
    ///   <p>For more details, visit the <a href="https://github.com/danielpalme/ReportGenerator">official website</a>.</p>
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class ReportGeneratorTasks
    {
        /// <summary>
        ///   Path to the ReportGenerator executable.
        /// </summary>
        public static string ReportGeneratorPath =>
            ToolPathResolver.TryGetEnvironmentExecutable("REPORTGENERATOR_EXE") ??
            GetToolPath();
        public static Action<OutputType, string> ReportGeneratorLogger { get; set; } = ProcessTasks.DefaultLogger;
        /// <summary>
        ///   <p>ReportGenerator converts XML reports generated by OpenCover, PartCover, dotCover, Visual Studio, NCover or Cobertura into human readable reports in various formats.</p><p>The reports do not only show the coverage quota, but also include the source code and visualize which lines have been covered.</p><p>ReportGenerator supports merging several reports into one. It is also possible to pass one XML file containing several reports to ReportGenerator (e.g. a build log file).</p><p>The following <a href="https://github.com/danielpalme/ReportGenerator/wiki/Output-formats">output formats</a> are supported by ReportGenerator:<ul><li>HTML, HTMLSummary, HTMLInline, HTMLChart, <a href="https://en.wikipedia.org/wiki/MHTML">MHTML</a></li><li>XML, XMLSummary</li><li>Latex, LatexSummary</li><li>TextSummary</li><li>CsvSummary</li><li>PngChart</li><li>Badges</li><li><a href="https://github.com/danielpalme/ReportGenerator/wiki/Custom-reports">Custom reports</a></li></ul></p><p>Compatibility:<ul><li><a href="https://github.com/OpenCover/opencover">OpenCover</a></li><li><a href="https://github.com/sawilde/partcover.net4">PartCover 4.0</a></li><li><a href="http://sourceforge.net/projects/partcover">PartCover 2.2, 2.3</a></li><li><a href="https://www.jetbrains.com/dotcover/help/dotCover__Console_Runner_Commands.html">dotCover</a> (/ReportType=DetailedXML)</li><li>Visual Studio (<a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#vstestconsoleexe">vstest.console.exe</a>, <a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#codecoverageexe">CodeCoverage.exe</a>)</li><li><a href="http://www.ncover.com/download/current">NCover</a> (tested version 1.5.8, other versions may not work)</li><li><a href="https://github.com/cobertura/cobertura">Cobertura</a></li><li>Mono (<a href="http://www.mono-project.com/docs/debug+profile/profile/profiler/#analyzing-the-profile-data">mprof-report</a>)</li></ul></p>
        ///   <p>For more details, visit the <a href="https://github.com/danielpalme/ReportGenerator">official website</a>.</p>
        /// </summary>
        public static IReadOnlyCollection<Output> ReportGenerator(string arguments, string workingDirectory = null, IReadOnlyDictionary<string, string> environmentVariables = null, int? timeout = null, bool? logOutput = null, bool? logInvocation = null, bool? logTimestamp = null, string logFile = null, Func<string, string> outputFilter = null)
        {
            using var process = ProcessTasks.StartProcess(ReportGeneratorPath, arguments, workingDirectory, environmentVariables, timeout, logOutput, logInvocation, logTimestamp, logFile, ReportGeneratorLogger, outputFilter);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>ReportGenerator converts XML reports generated by OpenCover, PartCover, dotCover, Visual Studio, NCover or Cobertura into human readable reports in various formats.</p><p>The reports do not only show the coverage quota, but also include the source code and visualize which lines have been covered.</p><p>ReportGenerator supports merging several reports into one. It is also possible to pass one XML file containing several reports to ReportGenerator (e.g. a build log file).</p><p>The following <a href="https://github.com/danielpalme/ReportGenerator/wiki/Output-formats">output formats</a> are supported by ReportGenerator:<ul><li>HTML, HTMLSummary, HTMLInline, HTMLChart, <a href="https://en.wikipedia.org/wiki/MHTML">MHTML</a></li><li>XML, XMLSummary</li><li>Latex, LatexSummary</li><li>TextSummary</li><li>CsvSummary</li><li>PngChart</li><li>Badges</li><li><a href="https://github.com/danielpalme/ReportGenerator/wiki/Custom-reports">Custom reports</a></li></ul></p><p>Compatibility:<ul><li><a href="https://github.com/OpenCover/opencover">OpenCover</a></li><li><a href="https://github.com/sawilde/partcover.net4">PartCover 4.0</a></li><li><a href="http://sourceforge.net/projects/partcover">PartCover 2.2, 2.3</a></li><li><a href="https://www.jetbrains.com/dotcover/help/dotCover__Console_Runner_Commands.html">dotCover</a> (/ReportType=DetailedXML)</li><li>Visual Studio (<a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#vstestconsoleexe">vstest.console.exe</a>, <a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#codecoverageexe">CodeCoverage.exe</a>)</li><li><a href="http://www.ncover.com/download/current">NCover</a> (tested version 1.5.8, other versions may not work)</li><li><a href="https://github.com/cobertura/cobertura">Cobertura</a></li><li>Mono (<a href="http://www.mono-project.com/docs/debug+profile/profile/profiler/#analyzing-the-profile-data">mprof-report</a>)</li></ul></p>
        ///   <p>For more details, visit the <a href="https://github.com/danielpalme/ReportGenerator">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>-assemblyfilters</c> via <see cref="ReportGeneratorSettings.AssemblyFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.ClassFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.FileFilters"/></li>
        ///     <li><c>-historydir</c> via <see cref="ReportGeneratorSettings.HistoryDirectory"/></li>
        ///     <li><c>-reports</c> via <see cref="ReportGeneratorSettings.Reports"/></li>
        ///     <li><c>-reporttypes</c> via <see cref="ReportGeneratorSettings.ReportTypes"/></li>
        ///     <li><c>-sourcedirs</c> via <see cref="ReportGeneratorSettings.SourceDirectories"/></li>
        ///     <li><c>-tag</c> via <see cref="ReportGeneratorSettings.Tag"/></li>
        ///     <li><c>-targetdir</c> via <see cref="ReportGeneratorSettings.TargetDirectory"/></li>
        ///     <li><c>-verbosity</c> via <see cref="ReportGeneratorSettings.Verbosity"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> ReportGenerator(ReportGeneratorSettings toolSettings = null)
        {
            toolSettings = toolSettings ?? new ReportGeneratorSettings();
            using var process = ProcessTasks.StartProcess(toolSettings);
            process.AssertZeroExitCode();
            return process.Output;
        }
        /// <summary>
        ///   <p>ReportGenerator converts XML reports generated by OpenCover, PartCover, dotCover, Visual Studio, NCover or Cobertura into human readable reports in various formats.</p><p>The reports do not only show the coverage quota, but also include the source code and visualize which lines have been covered.</p><p>ReportGenerator supports merging several reports into one. It is also possible to pass one XML file containing several reports to ReportGenerator (e.g. a build log file).</p><p>The following <a href="https://github.com/danielpalme/ReportGenerator/wiki/Output-formats">output formats</a> are supported by ReportGenerator:<ul><li>HTML, HTMLSummary, HTMLInline, HTMLChart, <a href="https://en.wikipedia.org/wiki/MHTML">MHTML</a></li><li>XML, XMLSummary</li><li>Latex, LatexSummary</li><li>TextSummary</li><li>CsvSummary</li><li>PngChart</li><li>Badges</li><li><a href="https://github.com/danielpalme/ReportGenerator/wiki/Custom-reports">Custom reports</a></li></ul></p><p>Compatibility:<ul><li><a href="https://github.com/OpenCover/opencover">OpenCover</a></li><li><a href="https://github.com/sawilde/partcover.net4">PartCover 4.0</a></li><li><a href="http://sourceforge.net/projects/partcover">PartCover 2.2, 2.3</a></li><li><a href="https://www.jetbrains.com/dotcover/help/dotCover__Console_Runner_Commands.html">dotCover</a> (/ReportType=DetailedXML)</li><li>Visual Studio (<a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#vstestconsoleexe">vstest.console.exe</a>, <a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#codecoverageexe">CodeCoverage.exe</a>)</li><li><a href="http://www.ncover.com/download/current">NCover</a> (tested version 1.5.8, other versions may not work)</li><li><a href="https://github.com/cobertura/cobertura">Cobertura</a></li><li>Mono (<a href="http://www.mono-project.com/docs/debug+profile/profile/profiler/#analyzing-the-profile-data">mprof-report</a>)</li></ul></p>
        ///   <p>For more details, visit the <a href="https://github.com/danielpalme/ReportGenerator">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>-assemblyfilters</c> via <see cref="ReportGeneratorSettings.AssemblyFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.ClassFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.FileFilters"/></li>
        ///     <li><c>-historydir</c> via <see cref="ReportGeneratorSettings.HistoryDirectory"/></li>
        ///     <li><c>-reports</c> via <see cref="ReportGeneratorSettings.Reports"/></li>
        ///     <li><c>-reporttypes</c> via <see cref="ReportGeneratorSettings.ReportTypes"/></li>
        ///     <li><c>-sourcedirs</c> via <see cref="ReportGeneratorSettings.SourceDirectories"/></li>
        ///     <li><c>-tag</c> via <see cref="ReportGeneratorSettings.Tag"/></li>
        ///     <li><c>-targetdir</c> via <see cref="ReportGeneratorSettings.TargetDirectory"/></li>
        ///     <li><c>-verbosity</c> via <see cref="ReportGeneratorSettings.Verbosity"/></li>
        ///   </ul>
        /// </remarks>
        public static IReadOnlyCollection<Output> ReportGenerator(Configure<ReportGeneratorSettings> configurator)
        {
            return ReportGenerator(configurator(new ReportGeneratorSettings()));
        }
        /// <summary>
        ///   <p>ReportGenerator converts XML reports generated by OpenCover, PartCover, dotCover, Visual Studio, NCover or Cobertura into human readable reports in various formats.</p><p>The reports do not only show the coverage quota, but also include the source code and visualize which lines have been covered.</p><p>ReportGenerator supports merging several reports into one. It is also possible to pass one XML file containing several reports to ReportGenerator (e.g. a build log file).</p><p>The following <a href="https://github.com/danielpalme/ReportGenerator/wiki/Output-formats">output formats</a> are supported by ReportGenerator:<ul><li>HTML, HTMLSummary, HTMLInline, HTMLChart, <a href="https://en.wikipedia.org/wiki/MHTML">MHTML</a></li><li>XML, XMLSummary</li><li>Latex, LatexSummary</li><li>TextSummary</li><li>CsvSummary</li><li>PngChart</li><li>Badges</li><li><a href="https://github.com/danielpalme/ReportGenerator/wiki/Custom-reports">Custom reports</a></li></ul></p><p>Compatibility:<ul><li><a href="https://github.com/OpenCover/opencover">OpenCover</a></li><li><a href="https://github.com/sawilde/partcover.net4">PartCover 4.0</a></li><li><a href="http://sourceforge.net/projects/partcover">PartCover 2.2, 2.3</a></li><li><a href="https://www.jetbrains.com/dotcover/help/dotCover__Console_Runner_Commands.html">dotCover</a> (/ReportType=DetailedXML)</li><li>Visual Studio (<a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#vstestconsoleexe">vstest.console.exe</a>, <a href="https://github.com/danielpalme/ReportGenerator/wiki/Visual-Studio-Coverage-Tools#codecoverageexe">CodeCoverage.exe</a>)</li><li><a href="http://www.ncover.com/download/current">NCover</a> (tested version 1.5.8, other versions may not work)</li><li><a href="https://github.com/cobertura/cobertura">Cobertura</a></li><li>Mono (<a href="http://www.mono-project.com/docs/debug+profile/profile/profiler/#analyzing-the-profile-data">mprof-report</a>)</li></ul></p>
        ///   <p>For more details, visit the <a href="https://github.com/danielpalme/ReportGenerator">official website</a>.</p>
        /// </summary>
        /// <remarks>
        ///   <p>This is a <a href="http://www.nuke.build/docs/authoring-builds/cli-tools.html#fluent-apis">CLI wrapper with fluent API</a> that allows to modify the following arguments:</p>
        ///   <ul>
        ///     <li><c>-assemblyfilters</c> via <see cref="ReportGeneratorSettings.AssemblyFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.ClassFilters"/></li>
        ///     <li><c>-classfilters</c> via <see cref="ReportGeneratorSettings.FileFilters"/></li>
        ///     <li><c>-historydir</c> via <see cref="ReportGeneratorSettings.HistoryDirectory"/></li>
        ///     <li><c>-reports</c> via <see cref="ReportGeneratorSettings.Reports"/></li>
        ///     <li><c>-reporttypes</c> via <see cref="ReportGeneratorSettings.ReportTypes"/></li>
        ///     <li><c>-sourcedirs</c> via <see cref="ReportGeneratorSettings.SourceDirectories"/></li>
        ///     <li><c>-tag</c> via <see cref="ReportGeneratorSettings.Tag"/></li>
        ///     <li><c>-targetdir</c> via <see cref="ReportGeneratorSettings.TargetDirectory"/></li>
        ///     <li><c>-verbosity</c> via <see cref="ReportGeneratorSettings.Verbosity"/></li>
        ///   </ul>
        /// </remarks>
        public static IEnumerable<(ReportGeneratorSettings Settings, IReadOnlyCollection<Output> Output)> ReportGenerator(CombinatorialConfigure<ReportGeneratorSettings> configurator, int degreeOfParallelism = 1, bool completeOnFailure = false)
        {
            return configurator.Invoke(ReportGenerator, ReportGeneratorLogger, degreeOfParallelism, completeOnFailure);
        }
    }
    #region ReportGeneratorSettings
    /// <summary>
    ///   Used within <see cref="ReportGeneratorTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    [Serializable]
    public partial class ReportGeneratorSettings : ToolSettings
    {
        /// <summary>
        ///   Path to the ReportGenerator executable.
        /// </summary>
        public override string ProcessToolPath => base.ProcessToolPath ?? GetProcessToolPath();
        public override Action<OutputType, string> ProcessCustomLogger => ReportGeneratorTasks.ReportGeneratorLogger;
        /// <summary>
        ///   The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.
        /// </summary>
        public virtual IReadOnlyList<string> Reports => ReportsInternal.AsReadOnly();
        internal List<string> ReportsInternal { get; set; } = new List<string>();
        /// <summary>
        ///   The directory where the generated report should be saved.
        /// </summary>
        public virtual string TargetDirectory { get; internal set; }
        /// <summary>
        ///   The output formats and scope (separated by semicolon). Default is Html.
        /// </summary>
        public virtual IReadOnlyList<ReportTypes> ReportTypes => ReportTypesInternal.AsReadOnly();
        internal List<ReportTypes> ReportTypesInternal { get; set; } = new List<ReportTypes>();
        /// <summary>
        ///   Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.
        /// </summary>
        public virtual IReadOnlyList<string> SourceDirectories => SourceDirectoriesInternal.AsReadOnly();
        internal List<string> SourceDirectoriesInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional directory for storing persistent coverage information. Can be used in future reports to show coverage evolution.
        /// </summary>
        public virtual string HistoryDirectory { get; internal set; }
        /// <summary>
        ///   Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.
        /// </summary>
        public virtual IReadOnlyList<string> AssemblyFilters => AssemblyFiltersInternal.AsReadOnly();
        internal List<string> AssemblyFiltersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.
        /// </summary>
        public virtual IReadOnlyList<string> ClassFilters => ClassFiltersInternal.AsReadOnly();
        internal List<string> ClassFiltersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.
        /// </summary>
        public virtual IReadOnlyList<string> FileFilters => FileFiltersInternal.AsReadOnly();
        internal List<string> FileFiltersInternal { get; set; } = new List<string>();
        /// <summary>
        ///   Optional tag or build version.
        /// </summary>
        public virtual string Tag { get; internal set; }
        /// <summary>
        ///   The verbosity level of the log messages. Default is Verbose.
        /// </summary>
        public virtual ReportGeneratorVerbosity Verbosity { get; internal set; }
        public virtual string Framework { get; internal set; }
        protected override Arguments ConfigureProcessArguments(Arguments arguments)
        {
            arguments
              .Add("-reports:{value}", Reports, separator: ';')
              .Add("-targetdir:{value}", TargetDirectory)
              .Add("-reporttypes:{value}", ReportTypes, separator: ';')
              .Add("-sourcedirs:{value}", SourceDirectories, separator: ';')
              .Add("-historydir:{value}", HistoryDirectory)
              .Add("-assemblyfilters:{value}", AssemblyFilters, separator: ';')
              .Add("-classfilters:{value}", ClassFilters, separator: ';')
              .Add("-classfilters:{value}", FileFilters, separator: ';')
              .Add("-tag:{value}", Tag)
              .Add("-verbosity:{value}", Verbosity);
            return base.ConfigureProcessArguments(arguments);
        }
    }
    #endregion
    #region ReportGeneratorSettingsExtensions
    /// <summary>
    ///   Used within <see cref="ReportGeneratorTasks"/>.
    /// </summary>
    [PublicAPI]
    [ExcludeFromCodeCoverage]
    public static partial class ReportGeneratorSettingsExtensions
    {
        #region Reports
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.Reports"/> to a new list</em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T SetReports<T>(this T toolSettings, params string[] reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportsInternal = reports.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.Reports"/> to a new list</em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T SetReports<T>(this T toolSettings, IEnumerable<string> reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportsInternal = reports.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.Reports"/></em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T AddReports<T>(this T toolSettings, params string[] reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportsInternal.AddRange(reports);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.Reports"/></em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T AddReports<T>(this T toolSettings, IEnumerable<string> reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportsInternal.AddRange(reports);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.Reports"/></em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T ClearReports<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportsInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.Reports"/></em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T RemoveReports<T>(this T toolSettings, params string[] reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(reports);
            toolSettings.ReportsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.Reports"/></em></p>
        ///   <p>The coverage reports that should be parsed (separated by semicolon). Wildcards are allowed.</p>
        /// </summary>
        [Pure]
        public static T RemoveReports<T>(this T toolSettings, IEnumerable<string> reports) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(reports);
            toolSettings.ReportsInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region TargetDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.TargetDirectory"/></em></p>
        ///   <p>The directory where the generated report should be saved.</p>
        /// </summary>
        [Pure]
        public static T SetTargetDirectory<T>(this T toolSettings, string targetDirectory) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetDirectory = targetDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="ReportGeneratorSettings.TargetDirectory"/></em></p>
        ///   <p>The directory where the generated report should be saved.</p>
        /// </summary>
        [Pure]
        public static T ResetTargetDirectory<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.TargetDirectory = null;
            return toolSettings;
        }
        #endregion
        #region ReportTypes
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.ReportTypes"/> to a new list</em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T SetReportTypes<T>(this T toolSettings, params ReportTypes[] reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportTypesInternal = reportTypes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.ReportTypes"/> to a new list</em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T SetReportTypes<T>(this T toolSettings, IEnumerable<ReportTypes> reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportTypesInternal = reportTypes.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.ReportTypes"/></em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T AddReportTypes<T>(this T toolSettings, params ReportTypes[] reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportTypesInternal.AddRange(reportTypes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.ReportTypes"/></em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T AddReportTypes<T>(this T toolSettings, IEnumerable<ReportTypes> reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportTypesInternal.AddRange(reportTypes);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.ReportTypes"/></em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T ClearReportTypes<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ReportTypesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.ReportTypes"/></em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T RemoveReportTypes<T>(this T toolSettings, params ReportTypes[] reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<ReportTypes>(reportTypes);
            toolSettings.ReportTypesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.ReportTypes"/></em></p>
        ///   <p>The output formats and scope (separated by semicolon). Default is Html.</p>
        /// </summary>
        [Pure]
        public static T RemoveReportTypes<T>(this T toolSettings, IEnumerable<ReportTypes> reportTypes) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<ReportTypes>(reportTypes);
            toolSettings.ReportTypesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region SourceDirectories
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.SourceDirectories"/> to a new list</em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T SetSourceDirectories<T>(this T toolSettings, params string[] sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SourceDirectoriesInternal = sourceDirectories.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.SourceDirectories"/> to a new list</em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T SetSourceDirectories<T>(this T toolSettings, IEnumerable<string> sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SourceDirectoriesInternal = sourceDirectories.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.SourceDirectories"/></em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T AddSourceDirectories<T>(this T toolSettings, params string[] sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SourceDirectoriesInternal.AddRange(sourceDirectories);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.SourceDirectories"/></em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T AddSourceDirectories<T>(this T toolSettings, IEnumerable<string> sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SourceDirectoriesInternal.AddRange(sourceDirectories);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.SourceDirectories"/></em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T ClearSourceDirectories<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.SourceDirectoriesInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.SourceDirectories"/></em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T RemoveSourceDirectories<T>(this T toolSettings, params string[] sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(sourceDirectories);
            toolSettings.SourceDirectoriesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.SourceDirectories"/></em></p>
        ///   <p>Optional directories which contain the corresponding source code (separated by semicolon). The source files are used if coverage report contains classes without path information.</p>
        /// </summary>
        [Pure]
        public static T RemoveSourceDirectories<T>(this T toolSettings, IEnumerable<string> sourceDirectories) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(sourceDirectories);
            toolSettings.SourceDirectoriesInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region HistoryDirectory
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.HistoryDirectory"/></em></p>
        ///   <p>Optional directory for storing persistent coverage information. Can be used in future reports to show coverage evolution.</p>
        /// </summary>
        [Pure]
        public static T SetHistoryDirectory<T>(this T toolSettings, string historyDirectory) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HistoryDirectory = historyDirectory;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="ReportGeneratorSettings.HistoryDirectory"/></em></p>
        ///   <p>Optional directory for storing persistent coverage information. Can be used in future reports to show coverage evolution.</p>
        /// </summary>
        [Pure]
        public static T ResetHistoryDirectory<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.HistoryDirectory = null;
            return toolSettings;
        }
        #endregion
        #region AssemblyFilters
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.AssemblyFilters"/> to a new list</em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyFilters<T>(this T toolSettings, params string[] assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyFiltersInternal = assemblyFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.AssemblyFilters"/> to a new list</em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetAssemblyFilters<T>(this T toolSettings, IEnumerable<string> assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyFiltersInternal = assemblyFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.AssemblyFilters"/></em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddAssemblyFilters<T>(this T toolSettings, params string[] assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyFiltersInternal.AddRange(assemblyFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.AssemblyFilters"/></em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddAssemblyFilters<T>(this T toolSettings, IEnumerable<string> assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyFiltersInternal.AddRange(assemblyFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.AssemblyFilters"/></em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T ClearAssemblyFilters<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.AssemblyFiltersInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.AssemblyFilters"/></em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveAssemblyFilters<T>(this T toolSettings, params string[] assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assemblyFilters);
            toolSettings.AssemblyFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.AssemblyFilters"/></em></p>
        ///   <p>Optional list of assemblies that should be included (+) or excluded (-) in the report. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveAssemblyFilters<T>(this T toolSettings, IEnumerable<string> assemblyFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(assemblyFilters);
            toolSettings.AssemblyFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region ClassFilters
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.ClassFilters"/> to a new list</em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetClassFilters<T>(this T toolSettings, params string[] classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassFiltersInternal = classFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.ClassFilters"/> to a new list</em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetClassFilters<T>(this T toolSettings, IEnumerable<string> classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassFiltersInternal = classFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.ClassFilters"/></em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddClassFilters<T>(this T toolSettings, params string[] classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassFiltersInternal.AddRange(classFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.ClassFilters"/></em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddClassFilters<T>(this T toolSettings, IEnumerable<string> classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassFiltersInternal.AddRange(classFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.ClassFilters"/></em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T ClearClassFilters<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.ClassFiltersInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.ClassFilters"/></em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveClassFilters<T>(this T toolSettings, params string[] classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(classFilters);
            toolSettings.ClassFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.ClassFilters"/></em></p>
        ///   <p>Optional list of classes that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveClassFilters<T>(this T toolSettings, IEnumerable<string> classFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(classFilters);
            toolSettings.ClassFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region FileFilters
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.FileFilters"/> to a new list</em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetFileFilters<T>(this T toolSettings, params string[] fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FileFiltersInternal = fileFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.FileFilters"/> to a new list</em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T SetFileFilters<T>(this T toolSettings, IEnumerable<string> fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FileFiltersInternal = fileFilters.ToList();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.FileFilters"/></em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddFileFilters<T>(this T toolSettings, params string[] fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FileFiltersInternal.AddRange(fileFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Adds values to <see cref="ReportGeneratorSettings.FileFilters"/></em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T AddFileFilters<T>(this T toolSettings, IEnumerable<string> fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FileFiltersInternal.AddRange(fileFilters);
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Clears <see cref="ReportGeneratorSettings.FileFilters"/></em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T ClearFileFilters<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.FileFiltersInternal.Clear();
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.FileFilters"/></em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveFileFilters<T>(this T toolSettings, params string[] fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(fileFilters);
            toolSettings.FileFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Removes values from <see cref="ReportGeneratorSettings.FileFilters"/></em></p>
        ///   <p>Optional list of files that should be included (+) or excluded (-) in the report. Exclusion filters take precedence over inclusion filters. Wildcards are allowed. Default is +*.</p>
        /// </summary>
        [Pure]
        public static T RemoveFileFilters<T>(this T toolSettings, IEnumerable<string> fileFilters) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            var hashSet = new HashSet<string>(fileFilters);
            toolSettings.FileFiltersInternal.RemoveAll(x => hashSet.Contains(x));
            return toolSettings;
        }
        #endregion
        #region Tag
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.Tag"/></em></p>
        ///   <p>Optional tag or build version.</p>
        /// </summary>
        [Pure]
        public static T SetTag<T>(this T toolSettings, string tag) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tag = tag;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="ReportGeneratorSettings.Tag"/></em></p>
        ///   <p>Optional tag or build version.</p>
        /// </summary>
        [Pure]
        public static T ResetTag<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Tag = null;
            return toolSettings;
        }
        #endregion
        #region Verbosity
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.Verbosity"/></em></p>
        ///   <p>The verbosity level of the log messages. Default is Verbose.</p>
        /// </summary>
        [Pure]
        public static T SetVerbosity<T>(this T toolSettings, ReportGeneratorVerbosity verbosity) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbosity = verbosity;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="ReportGeneratorSettings.Verbosity"/></em></p>
        ///   <p>The verbosity level of the log messages. Default is Verbose.</p>
        /// </summary>
        [Pure]
        public static T ResetVerbosity<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Verbosity = null;
            return toolSettings;
        }
        #endregion
        #region Framework
        /// <summary>
        ///   <p><em>Sets <see cref="ReportGeneratorSettings.Framework"/></em></p>
        /// </summary>
        [Pure]
        public static T SetFramework<T>(this T toolSettings, string framework) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = framework;
            return toolSettings;
        }
        /// <summary>
        ///   <p><em>Resets <see cref="ReportGeneratorSettings.Framework"/></em></p>
        /// </summary>
        [Pure]
        public static T ResetFramework<T>(this T toolSettings) where T : ReportGeneratorSettings
        {
            toolSettings = toolSettings.NewInstance();
            toolSettings.Framework = null;
            return toolSettings;
        }
        #endregion
    }
    #endregion
    #region ReportTypes
    /// <summary>
    ///   Used within <see cref="ReportGeneratorTasks"/>.
    /// </summary>
    [PublicAPI]
    [Serializable]
    [ExcludeFromCodeCoverage]
    [TypeConverter(typeof(TypeConverter<ReportTypes>))]
    public partial class ReportTypes : Enumeration
    {
        public static ReportTypes Badges = (ReportTypes) "Badges";
        public static ReportTypes Cobertura = (ReportTypes) "Cobertura";
        public static ReportTypes CsvSummary = (ReportTypes) "CsvSummary";
        public static ReportTypes Html = (ReportTypes) "Html";
        public static ReportTypes HtmlInline = (ReportTypes) "HtmlInline";
        public static ReportTypes HtmlInline_AzurePipelines = (ReportTypes) "HtmlInline_AzurePipelines";
        public static ReportTypes HtmlInline_AzurePipelines_Dark = (ReportTypes) "HtmlInline_AzurePipelines_Dark";
        public static ReportTypes HtmlChart = (ReportTypes) "HtmlChart";
        public static ReportTypes HtmlSummary = (ReportTypes) "HtmlSummary";
        public static ReportTypes Latex = (ReportTypes) "Latex";
        public static ReportTypes LatexSummary = (ReportTypes) "LatexSummary";
        public static ReportTypes MHtml = (ReportTypes) "MHtml";
        public static ReportTypes PngChart = (ReportTypes) "PngChart";
        public static ReportTypes TextSummary = (ReportTypes) "TextSummary";
        public static ReportTypes Xml = (ReportTypes) "Xml";
        public static ReportTypes XmlSummary = (ReportTypes) "XmlSummary";
        public static ReportTypes SonarQube = (ReportTypes) "SonarQube";
        public static ReportTypes TeamCitySummary = (ReportTypes) "TeamCitySummary";
        public static explicit operator ReportTypes(string value)
        {
            return new ReportTypes { Value = value };
        }
    }
    #endregion
    #region ReportGeneratorVerbosity
    /// <summary>
    ///   Used within <see cref="ReportGeneratorTasks"/>.
    /// </summary>
    [PublicAPI]
    [Serializable]
    [ExcludeFromCodeCoverage]
    [TypeConverter(typeof(TypeConverter<ReportGeneratorVerbosity>))]
    public partial class ReportGeneratorVerbosity : Enumeration
    {
        public static ReportGeneratorVerbosity Off = (ReportGeneratorVerbosity) "Off";
        public static ReportGeneratorVerbosity Verbose = (ReportGeneratorVerbosity) "Verbose";
        public static ReportGeneratorVerbosity Info = (ReportGeneratorVerbosity) "Info";
        public static ReportGeneratorVerbosity Warning = (ReportGeneratorVerbosity) "Warning";
        public static ReportGeneratorVerbosity Error = (ReportGeneratorVerbosity) "Error";
        public static explicit operator ReportGeneratorVerbosity(string value)
        {
            return new ReportGeneratorVerbosity { Value = value };
        }
    }
    #endregion
}
