# Структура приложения

В действительности Vuex не накладывает каких-то значительных ограничений на используемую структуру кода. Однако, он требует соблюдения нескольких высокоуровневых принципов:

1. Глобальное состояние приложения должно содержаться в централизованном хранилище;

2. Единственным механизмом изменения этого состояния являются **мутации**, являющиеся синхронными транзакциями;

3. Асинхронные операции инкапсулирутся в **действия**, или их комбинации.

Покуда вы следуете этим правилам, можно использовать любую структуру проекта. Если ваш файл хранилища становится слишком большим, просто начните выносить действия, мутации и геттеры в отдельные файлы.

Для любого нетривиального приложения скорее всего понадобится использование модулей. Вот пример возможной структуры проекта:

``` bash
├── index.html
├── main.js
├── api
│   └── ... # абстракции для выполнения запросов к API
├── components
│   ├── App.vue
│   └── ...
└── store
    ├── index.js          # здесь мы собираем модули и экспортируем хранилище
    ├── actions.js        # корневые действия
    ├── mutations.js      # корневые мутации
    └── modules
        ├── cart.js       # модуль корзины
        └── products.js   # модуль товаров
```

Для справки можно использовать [Пример корзины покупок](https://github.com/vuejs/vuex/tree/dev/examples/shopping-cart).
