# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{grit}
  s.version = "1.1.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Tom Preston-Werner", "Scott Chacon"]
  s.date = %q{2009-03-29}
  s.description = %q{Grit is a Ruby library for extracting information from a git repository in an object oriented manner.}
  s.email = %q{tom@mojombo.com}
  s.files = ["API.txt", "History.txt", "README.md", "VERSION.yml", "lib/grit", "lib/grit/actor.rb", "lib/grit/blame.rb", "lib/grit/blob.rb", "lib/grit/commit.rb", "lib/grit/commit_stats.rb", "lib/grit/config.rb", "lib/grit/diff.rb", "lib/grit/errors.rb", "lib/grit/git-ruby", "lib/grit/git-ruby/commit_db.rb", "lib/grit/git-ruby/file_index.rb", "lib/grit/git-ruby/git_object.rb", "lib/grit/git-ruby/internal", "lib/grit/git-ruby/internal/file_window.rb", "lib/grit/git-ruby/internal/loose.rb", "lib/grit/git-ruby/internal/pack.rb", "lib/grit/git-ruby/internal/raw_object.rb", "lib/grit/git-ruby/object.rb", "lib/grit/git-ruby/repository.rb", "lib/grit/git-ruby.rb", "lib/grit/git.rb", "lib/grit/index.rb", "lib/grit/lazy.rb", "lib/grit/merge.rb", "lib/grit/ref.rb", "lib/grit/repo.rb", "lib/grit/ruby1.9.rb", "lib/grit/status.rb", "lib/grit/submodule.rb", "lib/grit/tag.rb", "lib/grit/tree.rb", "lib/grit.rb", "lib/open3_detach.rb", "test/bench", "test/bench/benchmarks.rb", "test/bench/benchmarks.txt", "test/dot_git", "test/dot_git/COMMIT_EDITMSG", "test/dot_git/config", "test/dot_git/description", "test/dot_git/FETCH_HEAD", "test/dot_git/file-index", "test/dot_git/HEAD", "test/dot_git/hooks", "test/dot_git/hooks/applypatch-msg", "test/dot_git/hooks/commit-msg", "test/dot_git/hooks/post-commit", "test/dot_git/hooks/post-receive", "test/dot_git/hooks/post-update", "test/dot_git/hooks/pre-applypatch", "test/dot_git/hooks/pre-commit", "test/dot_git/hooks/pre-rebase", "test/dot_git/hooks/prepare-commit-msg", "test/dot_git/hooks/update", "test/dot_git/index", "test/dot_git/info", "test/dot_git/info/exclude", "test/dot_git/logs", "test/dot_git/logs/HEAD", "test/dot_git/logs/refs", "test/dot_git/logs/refs/heads", "test/dot_git/logs/refs/heads/master", "test/dot_git/logs/refs/remotes", "test/dot_git/logs/refs/remotes/origin", "test/dot_git/logs/refs/remotes/origin/master", "test/dot_git/logs/refs/remotes/tom", "test/dot_git/logs/refs/remotes/tom/master", "test/dot_git/objects", "test/dot_git/objects/00", "test/dot_git/objects/00/03f8338f3668723f26b37c8ccf544a95e29ec6", "test/dot_git/objects/00/1569f8fc3eb464ba486e4b22f2f06494f399e2", "test/dot_git/objects/00/3274c8973e2053718cfad0d36a6965d192fcab", "test/dot_git/objects/00/b1c149e635d481ca18349082583b8151f72747", "test/dot_git/objects/00/b71297a9d326f1c9647dc3199759696aa0fcd3", "test/dot_git/objects/00/f3447967b64aba158140cd40ee8b367612ce81", "test/dot_git/objects/01", "test/dot_git/objects/01/0ad5aba678e910d4d663b42dcc23b42beb829f", "test/dot_git/objects/01/17826165bc3b90c75ef2caeec37f5c8d782705", "test/dot_git/objects/01/4488a55fe5fe9494441a9340cc8c15107a212a", "test/dot_git/objects/01/4fc17423d6af7ac4816071dd29f0f0e2784066", "test/dot_git/objects/01/b74bca756428371115795ddf6ca02019c8917f", "test/dot_git/objects/01/d78e86ee2b2d9d8d67d2d5b70610879184cfe2", "test/dot_git/objects/01/f8c258619443ee16bdfe857b4852df5fa3e9d2", "test/dot_git/objects/02", "test/dot_git/objects/02/036e2cb5b44b6f4a27cea2f5bcca47ddfb24d8", "test/dot_git/objects/02/1e14889189cd86cff25b5677e12ac2c7234e0b", "test/dot_git/objects/02/3d5211ccff94a988645cdeb1738ef681053928", "test/dot_git/objects/02/52e31caf4384d3af956ddcf99b0625ca32564f", "test/dot_git/objects/02/776a9f673a9cd6e2dfaebdb4a20de867303091", "test/dot_git/objects/02/7d4de30093393c0f994ccca83ac80524850f52", "test/dot_git/objects/02/85f374047a4541f8a36b9195ad281220dca3be", "test/dot_git/objects/02/88dcd891dc1c3452558a67240a2969afe5e1f2", "test/dot_git/objects/02/de1ef84c9b8c2c2659048269784ee8cfd1bbb5", "test/dot_git/objects/03", "test/dot_git/objects/03/337ca011923c5ade57033d950557f8e593542f", "test/dot_git/objects/03/37a36c245dcafeb65eb8a77322bfa353447774", "test/dot_git/objects/03/517194eb06a1dc1bd3cb0d605cf30a56241053", "test/dot_git/objects/03/6eb07bb7c6e7f3b35dd0302bf9cf6c289ea0ed", "test/dot_git/objects/03/7f79a326dbcb10176d28f61998d72924ce77c8", "test/dot_git/objects/03/cf7ee8c1bf722d28e8fa93eb780e2e4dc084c9", "test/dot_git/objects/04", "test/dot_git/objects/04/7b5ae7038ef06f45520462912f039e80c00b8c", "test/dot_git/objects/04/c3a03b3f0d0a60b313f4be77749845a5235c08", "test/dot_git/objects/04/cb7a6a139313c907e0fec984da3fd4e41fdd33", "test/dot_git/objects/04/e515305cf9bc9598dceafffb7cb9a756544628", "test/dot_git/objects/04/fb83a65293a39614752633f8e6d945b80b5eb0", "test/dot_git/objects/05", "test/dot_git/objects/05/68b92d8d9705c4ff045ffdb5e3a1f1595bd923", "test/dot_git/objects/05/7826b56de5733beb44b4561443d3b46a449691", "test/dot_git/objects/05/7926e768e8b202655a3aa26adc7f201c0edcfc", "test/dot_git/objects/05/7929610b4988ec16e3c45b8383bd158990b4a0", "test/dot_git/objects/05/87c4160d02715e27c0cb305d4227cf17481225", "test/dot_git/objects/05/af9a86721dbfc9c26aa1e51ae2a69e3e659d4e", "test/dot_git/objects/05/b059421d3747a7806ac17ae7fec58942f4febb", "test/dot_git/objects/05/cc37f0a03392de8deb2ffe699be03f7dfb969f", "test/dot_git/objects/06", "test/dot_git/objects/06/05c3b4232a3ce29e9eaa37c5b87798500a6e7d", "test/dot_git/objects/06/06fabcdde5c927345a40f121f361d2e216b074", "test/dot_git/objects/06/2279d5eb12f88189544abbaed53853c5ed9515", "test/dot_git/objects/06/aa7f9270d9750713a16c8876a80d8208d0474b", "test/dot_git/objects/06/e218ce2718fb29fe8c3406e20a03af92b2c211", "test/dot_git/objects/06/f8bf7db18ed246f33840f89db357ffdb9ed685", "test/dot_git/objects/07", "test/dot_git/objects/07/49016e612b0cc541a9157c5af5202fc13afee5", "test/dot_git/objects/07/7b694fe425c945e50bcf07a17273f70ea9969f", "test/dot_git/objects/08", "test/dot_git/objects/08/2abfcf77d1c6ce8288c9e51960c4dc0386e214", "test/dot_git/objects/08/31f152b831b72c29c402c43a4f0d5f9c08098b", "test/dot_git/objects/08/3a20c51f91b45bd89c4e659be3004f3160eb9d", "test/dot_git/objects/09", "test/dot_git/objects/09/3df8605b97af993b943e6c8d752adb3a80414d", "test/dot_git/objects/09/4371d805417da0d5d45f05862c04f840164700", "test/dot_git/objects/09/509a4195f9fb7afbf688b03c80695bf42415aa", "test/dot_git/objects/09/722f3e93f2ac8b7576ad9875570b9fcd9c7742", "test/dot_git/objects/09/c0737da31a89f508274573ccca3fab84b99291", "test/dot_git/objects/09/c978c6ca56674793681e1f46e48d548f87b9b7", "test/dot_git/objects/09/d253737e9b3478116b5c28bc353bb04f6b3b15", "test/dot_git/objects/0a", "test/dot_git/objects/0a/8a50a991f45aacd9182cc9660352291102d62c", "test/dot_git/objects/0a/d7278c1b329f53ccce178365ef46c0acf1b5cf", "test/dot_git/objects/0b", "test/dot_git/objects/0b/7cad903e284fb0c67b4c5c2b7dce7bcb1ab331", "test/dot_git/objects/0b/982595f497472374e559c4a60bdf6f5d515747", "test/dot_git/objects/0b/a43a25402d95cdf77eab9daa395554b6bf0fee", "test/dot_git/objects/0c", "test/dot_git/objects/0c/27bd8cee7c56836d7116224eeee572b14d9207", "test/dot_git/objects/0c/93fbac2cae83e0c1ae53b95b1ad1e52049f9dc", "test/dot_git/objects/0c/f5be059c72d69cccc249f53b35c3c40907665c", "test/dot_git/objects/0d", "test/dot_git/objects/0d/03c5056d874db5cf0088b70a67d943ddcb5413", "test/dot_git/objects/0d/520f86139b0b1fc0ab6d92a5f837533b07488b", "test/dot_git/objects/0d/757583ecf0ce5235d41487d26bee258c317b3e", "test/dot_git/objects/0d/b262cb85533c5004f6f1a2cb26f5ae2dd85d36", "test/dot_git/objects/0d/fc2a798d3c8f3190e3478644e73478bf5a2198", "test/dot_git/objects/0e", "test/dot_git/objects/0e/1d014f006f27f2857eb504c520d2ed2bdd8e73", "test/dot_git/objects/0f", "test/dot_git/objects/0f/138d68197242f4e6be55e9133fafb7dfa2ea51", "test/dot_git/objects/0f/341dd5b4a15b61545f8f8a22fdfcfa611b88ba", "test/dot_git/objects/0f/41b030d38bc256c46da51ec61d8fbf78d95c71", "test/dot_git/objects/0f/6adc7b610f48813007fa9624308fdcd19624eb", "test/dot_git/objects/0f/73ea263af628ee73a91fd828a090ec0c1108bd", "test/dot_git/objects/0f/8ab2768611398a9271137b976e790158fea99b", "test/dot_git/objects/0f/b309e304e40fd066779c842d3dfb969820ee05", "test/dot_git/objects/0f/f24bd854839ec2d63df82511b30a87563cf93b", "test/dot_git/objects/10", "test/dot_git/objects/10/3b19041fdc3d56c2a233faeb835250f7979025", "test/dot_git/objects/10/49a9f3dde7bb76587fe082462866b5d0dbd286", "test/dot_git/objects/10/d5041b45374ba1ca060c9273ea8239b2836377", "test/dot_git/objects/11", "test/dot_git/objects/11/8273918e8e542d828b37fb58cb2ec0f557fb5f", "test/dot_git/objects/11/af521eb0e6e9c112b3bb6c4ad7ec24986d3ca9", "test/dot_git/objects/11/c94e9b614f3f2e17f72854e8be0f181471bfcc", "test/dot_git/objects/11/ef852d995ba4f160bd20474cfb7b21fd643524", "test/dot_git/objects/12", "test/dot_git/objects/12/285f38fe70a726001e29108536954f64d7133a", "test/dot_git/objects/12/36260f7be3454a989e82e28f6096e096e35a89", "test/dot_git/objects/12/8db38df991e126c5079bd4c36d15c21674db99", "test/dot_git/objects/12/a41f2de1265a2f7c56793ad6c1e9a48b10690d", "test/dot_git/objects/12/c064d545702771fde2debf89ae5d2332897d88", "test/dot_git/objects/12/c33c0bcf3ac3f569850943ad62c46c9861edeb", "test/dot_git/objects/12/c7b3bf5cdc29830afecbe20755d6f08fe735a1", "test/dot_git/objects/12/fca324bece56e856667502ebfed1c5172d1477", "test/dot_git/objects/13", "test/dot_git/objects/13/2335def2380870cd3b8f40d326976aea182aa7", "test/dot_git/objects/13/8e53fadb078d2b3716833d8b50eb10f12c7348", "test/dot_git/objects/13/d306ed324d1be706c78071a72414d50c68dca5", "test/dot_git/objects/14", "test/dot_git/objects/14/35f68d9466fbd70fc6084977ac19fd311c7c57", "test/dot_git/objects/14/66fcacc4070eb9a8fd88b3a825c6647f6491f1", "test/dot_git/objects/14/67cde22fefa7ddcab86786d5066bc6f51b250a", "test/dot_git/objects/14/d58395b6da306a5b161fb950ac2c252a091a95", "test/dot_git/objects/15", "test/dot_git/objects/15/2111c53821f7dd53a3cc4f6a251a7de3789414", "test/dot_git/objects/15/5c2ca2a4e8b1e0f2f54c0e3b413dd077633fdf", "test/dot_git/objects/15/78a2576e89eaa4954d5277d69b2bf66e926cdf", "test/dot_git/objects/15/7c95ee8c2989db8127c48548ed80c15a76b778", "test/dot_git/objects/15/979622ad6ae9c5cf1c424cd17dd2784130e8f1", "test/dot_git/objects/15/d022ad2ff13d0ef33424ff412676b6047ffed8", "test/dot_git/objects/15/e293762a035e16b6d3f5562c51e8a524c84381", "test/dot_git/objects/15/e93eb1c0b39f51291d1c432156f0ff43ab1ffd", "test/dot_git/objects/15/ebfa5c7792de35a107f413b397407ac3330888", "test/dot_git/objects/16", "test/dot_git/objects/16/3268d3698bb1626f34cd3ba59da51a7e25e03e", "test/dot_git/objects/16/48e3b1e22ebb852ded047d0ab7eac1b05fe060", "test/dot_git/objects/16/81e1b6486f601c8edcaddcaba5b43cee4aea3f", "test/dot_git/objects/16/910c6a1377054903ccb52369d3ee07b13e5d08", "test/dot_git/objects/16/b7edf7af22dd2bada9e936795f53943719fe65", "test/dot_git/objects/16/cc3f1fa6b58278c4fe216999464aaef8ae6750", "test/dot_git/objects/16/ef31d5b51a674634edb8b54b5706c17b62f558", "test/dot_git/objects/16/ff20f07ceb75dc60619c082f530ccd3379d572", "test/dot_git/objects/17", "test/dot_git/objects/17/3f4345c58750e2eb870a65e850917f97dbed91", "test/dot_git/objects/17/6255627b2fac737a7f77a5591814e88dc49815", "test/dot_git/objects/17/96a891d45dea162f9021f8e8c472c5e2006696", "test/dot_git/objects/17/ac818de1cc5ab1b1e1fc5f2796b0bb816a600c", "test/dot_git/objects/17/d488c2f71729e5d182cb944d28c837fba95ccf", "test/dot_git/objects/17/da04256d519b3bc102ff6654388a15ede87a9e", "test/dot_git/objects/19", "test/dot_git/objects/19/3e6eef82e784e52ba86addcb5d7b1b7c733b39", "test/dot_git/objects/19/6583fa8a32069927196d341590917ec3a44068", "test/dot_git/objects/19/c05c4b965f08e0a7856864293a206e07743c37", "test/dot_git/objects/19/c3d5c87afaac1c69dc0473635ef8a7fe0738da", "test/dot_git/objects/19/e8c71b6a30e8725e9c0d8e487333d102b20eec", "test/dot_git/objects/19/f53b5d629ef910276aa4ff3da37098b84ebbe5", "test/dot_git/objects/1a", "test/dot_git/objects/1a/5458d91ca6a8303793f2b65add534398fbdecb", "test/dot_git/objects/1a/b11cd93f687672c9cc8fa9b3fbac91a28e455f", "test/dot_git/objects/1a/d7f5703990fffc0623027f890c8da5a84b7f69", "test/dot_git/objects/1b", "test/dot_git/objects/1b/4ac33eca9279c482cf15bfbdaeff285dd610b1", "test/dot_git/objects/1b/5178ad8b4a4bebf9f311a655317dcb2b8022cc", "test/dot_git/objects/1b/6572ea59d924437ef351841ad7769189744070", "test/dot_git/objects/1b/7450de981e2cabd7394fd5d6eabad5d3d755cc", "test/dot_git/objects/1b/9fe079b5b81a05c585e71d7a3f435cf740ef98", "test/dot_git/objects/1b/fb8784f878f9cd3cfeaca34357cf50a74f1e09", "test/dot_git/objects/1c", "test/dot_git/objects/1c/0b90070d7e30f014551321378b272fa3fa4513", "test/dot_git/objects/1c/13b4bce41332da238a5b3dea893831da48cd51", "test/dot_git/objects/1c/6ab3410ae104091c7c48eb51fafeb10ceb840a", "test/dot_git/objects/1c/e53e58e0fce1b52e687738be9f29d2b66ad102", "test/dot_git/objects/1d", "test/dot_git/objects/1d/52507d6a4b62353f17426395176114a78c3e27", "test/dot_git/objects/1d/779cd342a3dceb1181617c6d78cf49dd4ea6d9", "test/dot_git/objects/1d/a4fc732293ade7bc64fa5bf0fe500e98d44086", "test/dot_git/objects/1d/ad0ebe6a69a154ae53834551aac811e2084d92", "test/dot_git/objects/1d/fb7c5c1bfe1d3faa4faa02588446132806a84a", "test/dot_git/objects/1e", "test/dot_git/objects/1e/48c5e962aed49286c66caf359ec9c2d36c2702", "test/dot_git/objects/1e/602e850a67f89c395797eac185740d5f26d4d2", "test/dot_git/objects/1e/72f4a8d9f13be6e98e948927eea0d14a2e1058", "test/dot_git/objects/1e/d9b70c5aeb93e24139fa7203d9a7455476c102", "test/dot_git/objects/1e/eb71ddbc2be8fd6cc4fe8c8465361601d2e1a5", "test/dot_git/objects/1f", "test/dot_git/objects/1f/56023e68acd9d981833e3eb2567ed2d851dd32", "test/dot_git/objects/1f/cfb4f859faed6bf0384993f0fd5edf41f00ef5", "test/dot_git/objects/1f/f7f94c2c07e96787211d977794a01701c84c48", "test/dot_git/objects/20", "test/dot_git/objects/20/527a9f7bff75c1fbddd9d99bb7e6da2558650a", "test/dot_git/objects/20/58b040a09bd2a1fbaebb1e40aae595115a715e", "test/dot_git/objects/20/7f3efe50e24e9423f55d56924c43d7ea3c5ce7", "test/dot_git/objects/20/92842ab2e8c0f9bdab4646a4ed7f714f66b12b", "test/dot_git/objects/20/f3156fa79fcc5ccfd5e70a1136397c026414b6", "test/dot_git/objects/21", "test/dot_git/objects/21/0ce1bcc38e0e98f8ec8930a930dbd7988ac4b2", "test/dot_git/objects/21/1cd03423ab654fb825b0bee37154330ba18e55", "test/dot_git/objects/21/28b4b92723c769fb9288584aa67dd7e38d3e66", "test/dot_git/objects/21/39d6008849105ef06dd7aa4ed24dbeab73812b", "test/dot_git/objects/21/6092db5b7af3826eb8cab98f214b87338f2e85", "test/dot_git/objects/21/6df5b81cd60076fc086ac6a5cda5fb45a3f51f", "test/dot_git/objects/21/8e0267be4449ca7fc6fa10752014533c14c546", "test/dot_git/objects/21/9580bb02cbd719c7e1b02d73665669a180120a", "test/dot_git/objects/21/e7baafef8ab19c21b162aef7cb6f3c6d7d7c67", "test/dot_git/objects/22", "test/dot_git/objects/22/0553c2c0869a33996016d0f01a16471c3cdfb4", "test/dot_git/objects/22/26c0f88671d695655a16bc3f40336bbc1d13e1", "test/dot_git/objects/22/be54ac7977e0bb45ad7e83210611dc16ce102d", "test/dot_git/objects/22/fb8209d8655a24594398d47f339870f924804f", "test/dot_git/objects/23", "test/dot_git/objects/23/53738d894ae00535ad011781d82c135a92a269", "test/dot_git/objects/23/7f04e2053831498762d50fc2470cc66892d268", "test/dot_git/objects/23/92b105b8747c1814b9a48d2f5b546f25b78ba1", "test/dot_git/objects/24", "test/dot_git/objects/24/02a4ccbf9f8a3d0697562dc88c3a3a7740de56", "test/dot_git/objects/24/21ffe1b4b0ddf0d7efbd674ee1fff714c6d7ae", "test/dot_git/objects/24/b49076b413a71c428eb8bcdaa4f258791e6773", "test/dot_git/objects/24/b7e95c0acae11954a9e7018cd6748fbc9ac8da", "test/dot_git/objects/24/bc825eb69933d3c42e1a81c92cc9ebc6cc3472", "test/dot_git/objects/24/c1a000ee73335664497f277a9c1fc6ec7e1518", "test/dot_git/objects/25", "test/dot_git/objects/25/c813a868fe8f0aa7ffb09688c0d357b92deafe", "test/dot_git/objects/26", "test/dot_git/objects/26/ccf9637b785b1bc787bddb0d0d1c73f4662982", "test/dot_git/objects/27", "test/dot_git/objects/27/06e2fda31d93c2e9d213f3406022173b10f15e", "test/dot_git/objects/27/23ccc0bc573581a85c131ce62dd0670bc4ceb0", "test/dot_git/objects/27/9478dba188b07e2948b2f52ac865557065031e", "test/dot_git/objects/27/9771d5b69e4d0342bced5345231d43976091c3", "test/dot_git/objects/27/b04aeb5b6042a2d90fb40d4293863841257640", "test/dot_git/objects/27/bcf5fe0a83910d826d1d71d78740441835bace", "test/dot_git/objects/27/f8f0d70ce7e5c303f3c09e0ad169de7e1a7c3d", "test/dot_git/objects/28", "test/dot_git/objects/28/08c797feeb40639304a503a395e8333daa0aaf", "test/dot_git/objects/28/0ebe908f5b3306f56b95c2e6758abeed139e26", "test/dot_git/objects/28/6fa3d105eadff6c94298aa3c0bb84358dbdd9a", "test/dot_git/objects/28/e43ff74f1cbb5e666ee66ef3df5fb612af3cb0", "test/dot_git/objects/28/ea69ddb42462cde12ddeabd39349fbf9e47fec", "test/dot_git/objects/28/f509a6f26bcce60274974581e63d730236cf90", "test/dot_git/objects/29", "test/dot_git/objects/29/4764c43a2059b716a5016a7f0beb4f41ef762f", "test/dot_git/objects/29/bb16c9ad7a921a6887d5d72c51b9312d1b6ae9", "test/dot_git/objects/29/bb1b3a815aa0c6c6f41aaf4bca766d0bef1cdf", "test/dot_git/objects/2a", "test/dot_git/objects/2a/4ff408fd52be259cb69b058d1ac280425d3a14", "test/dot_git/objects/2a/525a828e4d0d02c01d14445b49c645771bb82a", "test/dot_git/objects/2a/5c7305b52b836fbc0ec7200df58f3f9ba06ec0", "test/dot_git/objects/2a/6063405e5767fb4b9aa48c2eda4ab87e6cecf2", "test/dot_git/objects/2a/6d2a310fdaed46fb3a44901392e0bf4f05f8e7", "test/dot_git/objects/2a/88c76b382e2e3c3e3587e0676301f9949d646d", "test/dot_git/objects/2a/8b7d95c7b2be929873d050f56b6eef546d3c18", "test/dot_git/objects/2a/9068e8f69713464cbe5ea7492476437d14e8bb", "test/dot_git/objects/2b", "test/dot_git/objects/2b/79e430dc370f0810552660b495e4ecdeca6aae", "test/dot_git/objects/2b/cec98e50e04c0d01bc097ffa372dcf55695025", "test/dot_git/objects/2b/f43dbc4e2088a807250eaa609234fd55e3e94b", "test/dot_git/objects/2c", "test/dot_git/objects/2c/7ac7d7cac1e740e45cb90b4ab2b4f8d4dfaca1", "test/dot_git/objects/2c/87b72dff61f8394b3f1f32e21c1d936314ec2e", "test/dot_git/objects/2c/8aa45018ca47fce1073b1bf3710e8df35b2dbe", "test/dot_git/objects/2c/97dd5ed8d14496cfc71e7ab12bedfec7c14f2e", "test/dot_git/objects/2c/da3256555de3eb182224bcf9bdcff079ccc44e", "test/dot_git/objects/2d", "test/dot_git/objects/2d/4e03533d8d37a44a1f3e9315ef5164d7e07764", "test/dot_git/objects/2d/643778ccaa7adc11f5b2531b418cb1394316ec", "test/dot_git/objects/2d/aa9345be6d2692c2b9303e12e8b69fb78d78ec", "test/dot_git/objects/2d/aea61e18b399977a0fc0b124c837e1d00934fa", "test/dot_git/objects/2d/d3efda11ed9a5e5e883cc3b2a624934f3a150e", "test/dot_git/objects/2d/f7c5ddd50228c2d751df8b6aab96b37cdbc965", "test/dot_git/objects/2e", "test/dot_git/objects/2e/1325969bea6889ccffe59660583f8f225eaf47", "test/dot_git/objects/2e/19521c5c4a51a2fc8aee97f952560b7044941b", "test/dot_git/objects/2e/e881239adb659aea65927a76daf526c0d83891", "test/dot_git/objects/2f", "test/dot_git/objects/2f/91a713750e086ab1704e05177d4a8f0d88953b", "test/dot_git/objects/30", "test/dot_git/objects/30/2bc1a9a65d8c4ddf073a56d0fdacaff71d5500", "test/dot_git/objects/30/2c67f5952bb0bda88f303e3b8c8a4cf7f27933", "test/dot_git/objects/30/a95debfc08077d566c9aa204f708104c716e1d", "test/dot_git/objects/30/c859bedf72cb8dfb745bb17f705e4774d4f339", "test/dot_git/objects/30/eaea1a7dbd755b4774f2e7b4663623398b09a3", "test/dot_git/objects/31", "test/dot_git/objects/31/5cd4d93bf65f8d00303515c7f31be1b888a349", "test/dot_git/objects/31/81d650ade16efe68108b01998c1297c7ff0095", "test/dot_git/objects/31/98cb65f97c46156ad634d04141a3aec5a7f637", "test/dot_git/objects/31/aaeceab051ff055f4b46b642f5891ac54e85ae", "test/dot_git/objects/31/c867dca3a847692dc87bc4906194f13d183cae", "test/dot_git/objects/31/eee41e36796777df147c26692c0624d73cd2d2", "test/dot_git/objects/32", "test/dot_git/objects/32/89cea29590f1ed0f3da77f118b12ae527f7be7", "test/dot_git/objects/32/d40772f3ec99939cc2fb68cf66d971bb70af47", "test/dot_git/objects/32/d7a7f04ce188e48735ca805f27a2e399a1cffc", "test/dot_git/objects/32/dec7871d83a6de85e5b96d06178ada1b4185c8", "test/dot_git/objects/33", "test/dot_git/objects/33/373556aa00a77c621c8957d66994e220dd391b", "test/dot_git/objects/33/49c1bb38f1a3bff19ffdb83fe81373f0947531", "test/dot_git/objects/33/58897c6333ced9f5d0b8b0d70b53207c32cbf2", "test/dot_git/objects/33/83cca49868379103ad80ebd52d0cd34731ea27", "test/dot_git/objects/33/86be79ac5e657a5c9a35c0b4ef87e62c47b8bb", "test/dot_git/objects/33/a3d4c5d14917e67edec483f3222245be341fd1", "test/dot_git/objects/33/b61981170deb261faec0ce907d8775dc9b0827", "test/dot_git/objects/34", "test/dot_git/objects/34/1780f4f7f8409797a6ee710254cadabbd442c7", "test/dot_git/objects/34/57115dfa37b9f7729f79eee2c75fc13f21438d", "test/dot_git/objects/34/a29f36e9085784d1c22db7331c0d9ac4e90d99", "test/dot_git/objects/34/a4e9b8065fdd743ca61dcfa82ffbc7cfecdc93", "test/dot_git/objects/35", "test/dot_git/objects/35/82158a912c79ee8d48eba6196c3613b1e34e57", "test/dot_git/objects/35/dbdfe43f8ad52f5d396abb7a7014bc453803a8", "test/dot_git/objects/35/e17670f8b2bc0f9a260d34aa83bd40a9d738e3", "test/dot_git/objects/36", "test/dot_git/objects/36/37c7a23088ef2dabae477f385cdaa65c70a251", "test/dot_git/objects/36/5e358e24b22ca327750961b28dbfba0330d53f", "test/dot_git/objects/36/840b2a85f282cb11294190666a52f764da2e35", "test/dot_git/objects/36/855d1bea32e3d3f7e0f0ae135e85cc9e9a2671", "test/dot_git/objects/36/dba981988940ffe26fd7a818d1216360ade56d", "test/dot_git/objects/36/e81104a0508fea06062a796fd85f457e829380", "test/dot_git/objects/36/f8ebd8d58b3ce1a337024e6b71107591eaa634", "test/dot_git/objects/37", "test/dot_git/objects/37/175959911a8e8032e07935cde93b873f2466f3", "test/dot_git/objects/37/593280ce24318d5ff8eb1448ae06c83772afe4", "test/dot_git/objects/37/6ea43a79070bdea30e0508edf49ee891279559", "test/dot_git/objects/37/7c4c6c44acbdfd450bdd0eba55845ee885be82", "test/dot_git/objects/37/a7c60c6a9466823e09acaf6c8cdfb9e0ca79a5", "test/dot_git/objects/37/b6a48b7f3b475a48fe1cbe6c85e1e5c47caa32", "test/dot_git/objects/37/e9dad721f3414c686125bef88f1de22eec34f1", "test/dot_git/objects/38", "test/dot_git/objects/38/2f4decb47b8d35ced4b1c386f9ea8a38147897", "test/dot_git/objects/38/507ac81bcab18fff9a4062c508b3ae1c3ed2b4", "test/dot_git/objects/38/5b7e7fbe895f4c9e866899c8a9dd413c687e3f", "test/dot_git/objects/38/5f9658195f704e1f20ae167f23c3a91871dba2", "test/dot_git/objects/38/6eb8dab973c5baa669c4627287f608a602a837", "test/dot_git/objects/38/965f6e6489e6a9c0011c367ffba2b988512f50", "test/dot_git/objects/38/d6fa611eb2c06126f711eb64f036ffa83331fe", "test/dot_git/objects/39", "test/dot_git/objects/39/414f3aeb1c46b4829d41c2b5a41bc243137ab6", "test/dot_git/objects/39/49bf564f18107bb9c42f7c78e93c935d749db2", "test/dot_git/objects/39/693b227a583b222dd22eacfd16c948e40e8c19", "test/dot_git/objects/39/d92ab22590d648ed6efea996048876bf599c0a", "test/dot_git/objects/39/dbd7e9d354ee652f7f5ca117f867696c32fd73", "test/dot_git/objects/3a", "test/dot_git/objects/3a/6030afdfb2890fd10a19d4fba1395d7b24f828", "test/dot_git/objects/3a/9edce0b66cad4c011fb35c90e80b796ba5610f", "test/dot_git/objects/3b", "test/dot_git/objects/3b/004186dc696853e8af1c478a961fd4b8ec0531", "test/dot_git/objects/3b/1fd96da523e9922a1f2b126bbcbc65c7ee9c71", "test/dot_git/objects/3b/494f98fb24ee05c63c63cfaafa730bd933f9ea", "test/dot_git/objects/3b/5bf78ab1d4b5f3d36129b66f1c4a00cc52dcd9", "test/dot_git/objects/3b/5cc49cd62921d1abc9eaac373c29ea6fa604c9", "test/dot_git/objects/3b/79e6461579ba7cc976cea73d36a0c7ac56ff57", "test/dot_git/objects/3b/d1a9b888fb95bf4ce7da5ba1d0f7db711a07ad", "test/dot_git/objects/3c", "test/dot_git/objects/3c/135209062a3ccd2032092ab2457eb3980b249f", "test/dot_git/objects/3c/612dfb7e6530546a433262c4ccddc633da823a", "test/dot_git/objects/3c/631958129f12cd496c2c918ff76c04e3aec471", "test/dot_git/objects/3c/681414cda7c8200292d9c37baef74b8e55b25e", "test/dot_git/objects/3d", "test/dot_git/objects/3d/68199aa3c3ae3e55fad81d987bb954265da64d", "test/dot_git/objects/3d/6fb637c4c133a62712c2f5c5bc5d6c918b257b", "test/dot_git/objects/3d/8cf6e46dbc2863435a7c0befa9f0f9b72f2b40", "test/dot_git/objects/3d/c1b8ad89993a94b8b8af627ecefb656f450b3a", "test/dot_git/objects/3d/e0ed396b3309d3135dd608633c7e24d7eb7a78", "test/dot_git/objects/3e", "test/dot_git/objects/3e/4e5142403fdafa5daaf580ad2754bd5469f297", "test/dot_git/objects/3e/8b951715d51b517615319e74f1ff5f143bdd33", "test/dot_git/objects/3e/c671d1b0661dec389ec97ac49729be98a98363", "test/dot_git/objects/3f", "test/dot_git/objects/3f/09b8a94def39594ff66018a0267e3a095f0166", "test/dot_git/objects/3f/a4e130fa18c92e3030d4accb5d3e0cadd40157", "test/dot_git/objects/3f/a8b0bb7b1158b3d75cb01a338c688465266ae8", "test/dot_git/objects/3f/ab2e2576d21e160f65e0f037ef49932153b750", "test/dot_git/objects/3f/ef1de16cfa99882a900d682c98bf4cdbb0bd1e", "test/dot_git/objects/40", "test/dot_git/objects/40/1b901ae82016d0e387f3369e2c73b9729fa960", "test/dot_git/objects/40/5da6eab49ad6c40202515218685cc5e47ba191", "test/dot_git/objects/40/878bdc3b0b546884c23cc56e36bb01bca26360", "test/dot_git/objects/40/98e7e0b3ddb23cbb02faed6443bb662103cca9", "test/dot_git/objects/40/b5472e26b885b5578a748a7199a49f78fc640f", "test/dot_git/objects/40/c2094b4c5f49c7a75493c3b60718f692238689", "test/dot_git/objects/40/fbcace81729947e3b6a50db55f20e3b0b8619c", "test/dot_git/objects/40/fccf8916dbf1a607b69cb308affb800b24eff8", "test/dot_git/objects/41", "test/dot_git/objects/41/773794cb94bc0b504c25fe2c7160a4297ac722", "test/dot_git/objects/41/96d4ceab2df8250b126c1fefe537aed40ba3b8", "test/dot_git/objects/42", "test/dot_git/objects/42/3bd8e89cc0374ecbac89cb81f4d7994971373e", "test/dot_git/objects/42/55d57961f71cbbf37c4895cf2e7944cfb3c920", "test/dot_git/objects/42/77d827856344ecab7a8cd9b4cc8de189a058b6", "test/dot_git/objects/42/8b046f3d44ee60a2707cd0ec870f214d52b51d", "test/dot_git/objects/42/e9f36ecb27ec85cd80085f1e9848158af142cc", "test/dot_git/objects/42/ea225300e8cf78bb8dee7867cd9b9dd62a2e42", "test/dot_git/objects/43", "test/dot_git/objects/43/66fbe9656ed24eac8afa838af2e6872e0c0f50", "test/dot_git/objects/43/67a306774650effecbaf8cd100f2d01d53c736", "test/dot_git/objects/43/990427a4d4cf451298aa2adff627c97c7fbbba", "test/dot_git/objects/44", "test/dot_git/objects/44/4120068cf48a97010e1291f7a6b148dc7db3fe", "test/dot_git/objects/44/6235527422ab47a85897515acf1ba002f7d621", "test/dot_git/objects/44/c1bb76bef6677159624272045dbbd9e1be3de6", "test/dot_git/objects/45", "test/dot_git/objects/45/7135f1291992d204581e4f70019268d2b41f88", "test/dot_git/objects/45/7629071e6056bf4a8595a6f171b3404892d528", "test/dot_git/objects/46", "test/dot_git/objects/46/ccdb048ecf2b9452dc2e0174dfdba426df0f62", "test/dot_git/objects/46/d3b63432ebd26da44b9b5f4463ecab8610003c", "test/dot_git/objects/47", "test/dot_git/objects/47/07d2feacccdc27e3ae08b6557313c66ad792cb", "test/dot_git/objects/47/36537c04c8c3d07d91d2b3d7d3ec9f772bc208", "test/dot_git/objects/47/5cda8f04478f1f3eccdfe350cef3beb5854267", "test/dot_git/objects/47/f94fe43e503475c4699b9bab535949d45786da", "test/dot_git/objects/48", "test/dot_git/objects/48/18f5a5bf96cc367861b358578bad5d14bc1ad9", "test/dot_git/objects/49", "test/dot_git/objects/49/9167ba61ed6a925dbf1d801a417fed31325e79", "test/dot_git/objects/49/c183e5076a69d95cb3267d65b15f07e8ef3dd0", "test/dot_git/objects/4a", "test/dot_git/objects/4a/4960fbcaa4f2b5f540c2417a0e6e3e13cd21e5", "test/dot_git/objects/4a/4aadbb8d70d1a8f1e0494d93c51cf0a70c73c7", "test/dot_git/objects/4b", "test/dot_git/objects/4b/69268fd027874cdc84e08be1a7b0adabe29bd6", "test/dot_git/objects/4b/6a031b5bca40f2d1197e0d0a8c053e48f2d1b8", "test/dot_git/objects/4b/ac1a816ea4c330c0a60a7faead02c80d216bf9", "test/dot_git/objects/4b/c83809c12606b8673503ea595bc9dc926a4f85", "test/dot_git/objects/4c", "test/dot_git/objects/4c/5d14c6b35b4b9f9f8a10db253e3a61968fe0d5", "test/dot_git/objects/4c/721af72f40368c4af46c04956fe6553505b03e", "test/dot_git/objects/4c/765b6172fefd3aa2f2462f40b2c5614f855e33", "test/dot_git/objects/4c/82aff6d42a4a658102f617678bfd9653e0a997", "test/dot_git/objects/4c/c3aff3a2c0395c6acba1f57f3adf77a254847f", "test/dot_git/objects/4c/c4d71390cf1c9fbe9543b5da0cb0506fc354da", "test/dot_git/objects/4c/ee78c5ee3ab8591996a1b2f03fd20c78a33491", "test/dot_git/objects/4d", "test/dot_git/objects/4d/15668f43bd3d20dea783448a37421254211974", "test/dot_git/objects/4d/251e90cddd2da086b1a094a40877f94699c97b", "test/dot_git/objects/4d/35b41a2bcd2d028a9abffa2218239d0b1a04dd", "test/dot_git/objects/4d/4af31ee8fb34570f7c50474042246adf5f9536", "test/dot_git/objects/4d/d750e01c939c69940c3633ec65c18c97e9480f", "test/dot_git/objects/4d/fbecaffa3aab6f4f8823db875466a4e079d311", "test/dot_git/objects/4e", "test/dot_git/objects/4e/0942f5895107d26ed935f94720ce8fcb5677f7", "test/dot_git/objects/4e/1ba5a8835b0208f7b4b8832a3ac1f11c5923ad", "test/dot_git/objects/4e/6593b191405aec3d286b1e5e61ef864a47e779", "test/dot_git/objects/4e/749569e29fd394f47f679262bf138307352c19", "test/dot_git/objects/4e/9d21828e2e5003af0be5bb895350c428e6cfac", "test/dot_git/objects/4e/f86eb244bbbde9b793fd8cfab92042adb51485", "test/dot_git/objects/4f", "test/dot_git/objects/4f/09b8bf59198a887fb97de69dc6d8385ee74756", "test/dot_git/objects/4f/72728413e0e66b7281b979dce17eadc2fd8c60", "test/dot_git/objects/4f/ccb01f2d6a0ba681a5cc489af24adacfdab09a", "test/dot_git/objects/4f/f1303d44eba1b583ea2a3b7765153ee1743e61", "test/dot_git/objects/50", "test/dot_git/objects/50/1b7e3e4924d35febd00c13edf3cb513695b09b", "test/dot_git/objects/50/3e3076ad906d21bda16fa7dcd22eab19847c96", "test/dot_git/objects/50/40f4c67674acda890725edcd0425d02093107c", "test/dot_git/objects/50/87e423df619ef636e056e28a24f8cb7b873adf", "test/dot_git/objects/51", "test/dot_git/objects/51/28cc1329ea4d1a14910c23fe2b76d669c27dce", "test/dot_git/objects/51/48455670cac62caf07b4104b898982a2ee1d27", "test/dot_git/objects/51/84bca98dfa4da277688eb0cf5d4c3c30049dbc", "test/dot_git/objects/52", "test/dot_git/objects/52/0dad6b8078f0ec22714905c569a55adb18207c", "test/dot_git/objects/52/7c32e1f12197b30c91a0b0c47492ee5f84d116", "test/dot_git/objects/52/985c69fce3578762db2c549414d93c5344973f", "test/dot_git/objects/52/a0ed389b902d699b002b4b974d5a422f5d648f", "test/dot_git/objects/52/c074ceaeeae3ad8faba5eaa883b29d47e3753d", "test/dot_git/objects/52/e6e4c8d61116b7306af1e3a83330e9b2f2b22e", "test/dot_git/objects/52/ebe29d5aab2f2d13bff0300809349e47a93578", "test/dot_git/objects/52/f056f557e9c34c1d410e38f28fb0ff3eb8cf8a", "test/dot_git/objects/53", "test/dot_git/objects/53/029523a88fbcc802bc09d177b250779077da61", "test/dot_git/objects/53/94a7335809300349d81816fcd5c7e4c838025b", "test/dot_git/objects/53/bed2e68961f68a0d28589ab78ac3cddea26870", "test/dot_git/objects/53/d7b4bf2a0de4f29efbcf9cc5151e6599bfb180", "test/dot_git/objects/53/e7f70cb60a4a2c42e0c16f9eac862d527ef2b5", "test/dot_git/objects/54", "test/dot_git/objects/54/1264963de31abc20ae319ffb81afb894a58777", "test/dot_git/objects/55", "test/dot_git/objects/55/1240c0e157f1f2758ca49851278b209229067a", "test/dot_git/objects/55/4dd421736514dbff8ee54bcd0fdb14c6066ec5", "test/dot_git/objects/55/551f97b57dda2e947f0fd75097a712f3c72fa4", "test/dot_git/objects/55/9b8493ad088486436a0e5569abd24005bd00b8", "test/dot_git/objects/55/a588a07006a47eaf9805311e73a5c6c8516344", "test/dot_git/objects/55/b1da2f93e556f8ff2ab9063d73b1ff633f2954", "test/dot_git/objects/56", "test/dot_git/objects/56/3e1a6828c118fda28f11a33f9349bc15dd2607", "test/dot_git/objects/56/47e47c36c08268426e558565baf40ab240fe9e", "test/dot_git/objects/56/cfafc365c69aa55f9558a59e6d909d2f6822d9", "test/dot_git/objects/56/d26caca2e437e35d35cf42f782f8c74b283df2", "test/dot_git/objects/56/d65dce3016a197a757b693799847d2fddbb04e", "test/dot_git/objects/57", "test/dot_git/objects/57/639e8ddac5fff2b7693c462538babc53ef81d4", "test/dot_git/objects/57/771c0727c589e983019a5a076190d156c5ef1c", "test/dot_git/objects/57/e4351700dc0a81ae1aa812484eb0551b1a0866", "test/dot_git/objects/58", "test/dot_git/objects/58/223b18290bf0265b04b3697f729dba40f9e7cc", "test/dot_git/objects/58/40f249cdfffd086dbad61feea0c3a8a4b3d109", "test/dot_git/objects/58/4b8f537c2d89e0e47d6bbde2627ea6f01d4a7f", "test/dot_git/objects/58/5c2c53d923fa6b480ae2ddc2b820b317b1403d", "test/dot_git/objects/58/628e6483b6cc5cc721f1ee6d398bd0c2a87312", "test/dot_git/objects/58/74dd25ed52fa87b8597015a538b56ab0100d55", "test/dot_git/objects/58/8455d11d4347b9ac17d31205e8f638533727f4", "test/dot_git/objects/58/872e956be186c8fc87efaad3175d4ad9324283", "test/dot_git/objects/58/b73b8c03710dbc09303ca0a6a6bf0041481ac8", "test/dot_git/objects/58/f04c947cbdd1f0c2782c1c5575328680790193", "test/dot_git/objects/59", "test/dot_git/objects/59/032046844377888d7f0d53e8bf49e469321ebf", "test/dot_git/objects/59/96606c30d29c0bc97f67b18a0f255f87cc2da3", "test/dot_git/objects/59/eb45a3f0a6b80dbbb7b99024e55227a4086eba", "test/dot_git/objects/59/ee1a70e83c28f2d74843b91e39e557340e6172", "test/dot_git/objects/59/ef600ad21001772c04e540918f28c00ea71b39", "test/dot_git/objects/5a", "test/dot_git/objects/5a/6c2633eb0410a8651550d1f894c0a06fd4f92d", "test/dot_git/objects/5b", "test/dot_git/objects/5b/02a248683c285d22af6640765232a018cd666c", "test/dot_git/objects/5b/2741fde089f266afca1adcfdc4eeb8dfe4a463", "test/dot_git/objects/5b/9e2e35bffc027b09677112d4bd1b3af4d5c313", "test/dot_git/objects/5b/c6f75b8462a5d6190fdd50f3e74cf9e1dfeed3", "test/dot_git/objects/5b/f84617e57e85ca06eb64271e0cabfdf8cd925f", "test/dot_git/objects/5b/fd1435a75583e9dd95536f2da3882f41604727", "test/dot_git/objects/5c", "test/dot_git/objects/5c/2c0c973c27c8ee488d48bfd12b6e96d202381c", "test/dot_git/objects/5c/72f12ea25d302ad4a4ceb9f5f9f033cbf3fffc", "test/dot_git/objects/5c/8279a64dcfe94e59973fd0125cf5824296623a", "test/dot_git/objects/5c/a47fc1a9590937f34809ea48f5bd873b218317", "test/dot_git/objects/5d", "test/dot_git/objects/5d/6109a9e5ef1f941a39144f14340ceef80ff331", "test/dot_git/objects/5d/66d8da0c12ac0eca4e8c6e766c82b74593ec88", "test/dot_git/objects/5d/84fe98507e47d78953bd0208ae063f06e52b1f", "test/dot_git/objects/5d/a88f7992de649d8eae9529095b419e8a70f026", "test/dot_git/objects/5d/c9b501f6b70d5aa3d6420fa5f35bb0a2154a6a", "test/dot_git/objects/5d/e68783db60cc4b7361b8639a73dda527b50b58", "test/dot_git/objects/5d/ed8819f036921e27f2668819236725c1bc793e", "test/dot_git/objects/5d/fc38afe33e85878cd25a50ad3f18949372afbe", "test/dot_git/objects/5e", "test/dot_git/objects/5e/2e8449f6aea6b4ca05a1bca0478c1ddfd5535a", "test/dot_git/objects/5e/329b884e07932517bf9909303f6017cb178a25", "test/dot_git/objects/5e/79da1a7446822b46659edf25e9144816fa0454", "test/dot_git/objects/5e/d3c8d603d0ee1d52e0d512123e11bc892ec244", "test/dot_git/objects/5f", "test/dot_git/objects/5f/04dc6aa3c9ac971fb0c6720602be9c120c16f4", "test/dot_git/objects/5f/701c07e50ba10b912455198fcfc2392e29bd44", "test/dot_git/objects/5f/7950617f2d778d6209a11cb13e511ae4fb845f", "test/dot_git/objects/5f/88d05fb1efcdb4d1c825b3590f6a941d878048", "test/dot_git/objects/5f/c8689d7e4cb9dc91900539ff0562130cf90fdb", "test/dot_git/objects/5f/ec1ca382b811bf51abc319eb929cd7553842e8", "test/dot_git/objects/60", "test/dot_git/objects/60/390f7ddecc01fafb62b7d891f93ea23498acb8", "test/dot_git/objects/60/7d0c6725b82a2b8ad5977fdf08f7319cfb5b2b", "test/dot_git/objects/61", "test/dot_git/objects/61/0bed6eb24528c64369a7eb731801d1111bdf4d", "test/dot_git/objects/61/45457b008cd93e22a44f4cfee2b65f05808d17", "test/dot_git/objects/61/7d5fec3e4ee86080adc1dedd4ef91cc1b515d4", "test/dot_git/objects/62", "test/dot_git/objects/62/d812d2a42d5ad62cbcef99a81749d1ed68f2c2", "test/dot_git/objects/63", "test/dot_git/objects/63/142041870ce53f5ef4451b8cf021151e145054", "test/dot_git/objects/63/2ff9f2fc143cb67362b8267d57ff969d91ce85", "test/dot_git/objects/63/5e6c9e4f53250d4aae886ead0a080d81e0af2c", "test/dot_git/objects/64", "test/dot_git/objects/64/29532bf470fad3153093c7f4b10f69ee82ae18", "test/dot_git/objects/64/2b8924b35c87dd48f07bbdb6d0deb1ae5495dc", "test/dot_git/objects/64/3cc80fe2609914350d4a5bde3cc1c4d7197dc2", "test/dot_git/objects/64/53d33435bcf98c2736530f3fdd4f74a2cfb974", "test/dot_git/objects/64/e717a84fb544375169f554be6b922aba692aa9", "test/dot_git/objects/64/ec7cc059b0db49a529e51823891aef4d8bf338", "test/dot_git/objects/64/ef0dfa8ef722d4caae716111efb647a1060405", "test/dot_git/objects/65", "test/dot_git/objects/65/46414b519e280abb855f6231e8da5287c7a47d", "test/dot_git/objects/65/d911ebcec541a3d3aecfde6d067b979e6e5086", "test/dot_git/objects/65/fded76255bcab79ffa0f0a8d0c914b4056b380", "test/dot_git/objects/66", "test/dot_git/objects/66/1b95aeb34878aeacb70d74bf1c577b2cc461c3", "test/dot_git/objects/66/34746a6fe80824066823779491b252ae012bd6", "test/dot_git/objects/66/51ea0653b01a5f73d9ae1593c2d8a7369a74d9", "test/dot_git/objects/66/5fa9d3c28c07aa174637aca8252f88e7ed15ff", "test/dot_git/objects/66/7e57234226564739a618858668734a6b244876", "test/dot_git/objects/66/893c143a41615e9d2690f179308fc2c9ea2e92", "test/dot_git/objects/66/9224346dd756bf1d344d5a8b233805fa7e46e1", "test/dot_git/objects/66/99b0c4524bcdf045b66498ef281f863fc10628", "test/dot_git/objects/66/de9d57e1401ecd2cca3cd6487fb4ef348f5911", "test/dot_git/objects/66/e81f2947ee43f489386e4839edbc51bbaa3200", "test/dot_git/objects/67", "test/dot_git/objects/67/3f9b7a23a3fffe64f9ce4701914a110d70172b", "test/dot_git/objects/67/948a3f3783988c41844a3e3cba519563a6b6ae", "test/dot_git/objects/67/9a2f922a0937fc209a3ae77bffcc9fda6c49d0", "test/dot_git/objects/68", "test/dot_git/objects/68/0d86dd159ecd96257a223e3e36f820ececa886", "test/dot_git/objects/68/ad8c20d09837654709a9511a22d719631606d4", "test/dot_git/objects/69", "test/dot_git/objects/69/51fae70af8ff7ee84d7c3f9f0bdc99214451ed", "test/dot_git/objects/69/b1ef658dcf275374265786e3ef979e1ce7acad", "test/dot_git/objects/69/d8022883cf48368b3559b6e8ce2ba460e620fa", "test/dot_git/objects/6a", "test/dot_git/objects/6a/0f0474e45585c06d7caac652d252483187d68e", "test/dot_git/objects/6a/17ba4e3597af94f36b95350d0cde8d1a580db8", "test/dot_git/objects/6a/20b5c1026c8229c32f870c92e8f1031da099e8", "test/dot_git/objects/6a/4e6a2f37fc02e35ef674d98097c8661c37360c", "test/dot_git/objects/6a/a4e1aa5e7dbd47c73b28ed8ca30bcab93b4638", "test/dot_git/objects/6a/bc261d2e17d6200800890bf6db1e9bd0d9e764", "test/dot_git/objects/6b", "test/dot_git/objects/6b/7b8ca7b28c4c62f8a25ccccb4d6ade9e46c2d7", "test/dot_git/objects/6b/86465bf8bfad93a003413d0fe62af740f02f94", "test/dot_git/objects/6b/8c15931c3bc81f0825cbfbeeca79c8a6c3fe82", "test/dot_git/objects/6b/91775915c89f4141223d3ff5648281347276d1", "test/dot_git/objects/6b/c9cacf63f0e9783c9222583b3f836a1fd14243", "test/dot_git/objects/6c", "test/dot_git/objects/6c/023c8d73917e5c90651fb720269884befdb306", "test/dot_git/objects/6c/1c2608eaf29388ff986d825f413aefacde71b6", "test/dot_git/objects/6c/4b8c2fd3da22ef73e392683f926ae3b7494e57", "test/dot_git/objects/6c/57ae690bc5271210392920898240c13f4e5634", "test/dot_git/objects/6c/b49e0e6182741e6fd69d9cf9c162a1bd26be8c", "test/dot_git/objects/6c/b6584d6d4c398766ba42bd0a4f3cb620b62b95", "test/dot_git/objects/6c/d7d640a01480625cdf36af25696eea32a7a5ce", "test/dot_git/objects/6c/e9e816cf0f060838d5f34ecf284ad2458f806f", "test/dot_git/objects/6d", "test/dot_git/objects/6d/50eaf75755f91cd174bd97a6fb26574d42a972", "test/dot_git/objects/6d/7b878255abaea31a1bd43cfacd89727a40b334", "test/dot_git/objects/6e", "test/dot_git/objects/6e/770404d1e88f7b87a687bdba3e4063e1b84c43", "test/dot_git/objects/6e/9dc33da171c918556c6474b9c1ff075a4b4667", "test/dot_git/objects/6e/af969270949b97cde160323221579ebf7d0ae6", "test/dot_git/objects/6e/ea8c4874e378d50b39180173efd8540a3dad17", "test/dot_git/objects/6e/fe28fff834a94fbc20cac51fe9cd65ecc78d43", "test/dot_git/objects/6f", "test/dot_git/objects/6f/6906254fa5d16d54cd4511e79acc3ee79da96c", "test/dot_git/objects/6f/ba35bc25c85a6950fe9ad5c4713fee174dcd1e", "test/dot_git/objects/70", "test/dot_git/objects/70/03498f1263cfdbc14d0ba3f5107959c4ccff7a", "test/dot_git/objects/70/7d0fbd934e645980235d52112ce9ed8a8da14c", "test/dot_git/objects/70/9df040a86df6a593c7f3247202fb9d2103914b", "test/dot_git/objects/70/a5bb43f72b4a6075e0e2bf83e5abafee417d01", "test/dot_git/objects/71", "test/dot_git/objects/71/1cf6f726379a9c1a83eea1fae4ec3a10af28f1", "test/dot_git/objects/71/8053589f8cff63551986b4961853f16903eda2", "test/dot_git/objects/71/a6696da9143512b4f2b6d7474d58835c9dea6d", "test/dot_git/objects/71/b079961daac90fe8402177b87a08fa87a86ab7", "test/dot_git/objects/71/be442fd1a2b656e262f5a50268e57f3d64ec68", "test/dot_git/objects/71/eb51ed930e26754304f1470cfde1d1675cf2be", "test/dot_git/objects/72", "test/dot_git/objects/72/1cf10ace0fad67e9d7ef5024bbfdea99d54b6d", "test/dot_git/objects/72/944ef1b06abd709ae708d6be3426937f248a32", "test/dot_git/objects/72/c02e7e07d2284fe144183529f9b5ca45027a99", "test/dot_git/objects/72/ec1f22a7b22aca941d9483e3b9fec79b46c8c2", "test/dot_git/objects/73", "test/dot_git/objects/73/1501ae418cdc7babb9a86f3cb869daf11c28e8", "test/dot_git/objects/73/167b43c845d98eaa2040c701334f0c6f24a69c", "test/dot_git/objects/73/5942ed3013eb862658960cf891e4c7de0f511e", "test/dot_git/objects/73/64a83cdea4b92b1604c498d9e82f1f16a80778", "test/dot_git/objects/73/6b8e522a9076b3622c0f45f54b4ae2b033ce8f", "test/dot_git/objects/73/84eef4cb81eca27a0e7996bf7305f77438ae9e", "test/dot_git/objects/73/d04ec8b76b7eb2cacdd6fdd5c34bd975ebb04e", "test/dot_git/objects/73/e65a8a571f4319984cf694e45f37186f55fd0a", "test/dot_git/objects/73/f11a5cf43de10f70cbf9cc1dfd1f34fbf918e3", "test/dot_git/objects/74", "test/dot_git/objects/74/30b0ca149b99aad6bec0e5ffdab3f602648ceb", "test/dot_git/objects/74/8a7d9c0d07f08f5ad23a0188cd017e2f1d9730", "test/dot_git/objects/74/e48401ad6085171109f933862cb87c98cf1132", "test/dot_git/objects/75", "test/dot_git/objects/75/20a2be3072026e93bafbcb83245de447c02211", "test/dot_git/objects/75/7a9ec68a0a196a196ac5b42c13a45de2a39e3b", "test/dot_git/objects/75/f3bbdeec9b0ce7b4dbf652348f7105099df310", "test/dot_git/objects/76", "test/dot_git/objects/76/517e7150248161747a113dd311b5f2e5112b7e", "test/dot_git/objects/76/940ef6ba3d8d1048e6059d48417279b74e057f", "test/dot_git/objects/76/aa89f0b0bc7e92b92758b7e6520a8dfd086739", "test/dot_git/objects/76/ac881b1ec4cd0b8f3ed71bc90f915ac465042c", "test/dot_git/objects/76/b3f0be5ec5ff6c63e471f4dc696917d64de92d", "test/dot_git/objects/76/d54fdb3b93105642dd779a429b81a32d4a4d07", "test/dot_git/objects/77", "test/dot_git/objects/77/aa887449c28a922a660b2bb749e4127f7664e5", "test/dot_git/objects/77/edfa1c893d3e8d80881ff5eb56dc9d10fd944b", "test/dot_git/objects/78", "test/dot_git/objects/78/06987ac105edba10fe27c9a9f415dab7c0f9b8", "test/dot_git/objects/78/3367a2b50a733782aec243f1e8760effd62769", "test/dot_git/objects/78/38858f15204b6c4b0f076c47d0c825350a845f", "test/dot_git/objects/78/447092f23b8719ca1d548075f46174d1f18269", "test/dot_git/objects/78/591e22e8e9fd665bf9bf955ecd7601bc10efc5", "test/dot_git/objects/78/99ce846a293ff465fd391e790a8c7e6d896cbf", "test/dot_git/objects/78/d03cddc9d41d27792e9c84ce3174ee141294c9", "test/dot_git/objects/78/e0f291158261fcdb038e8cd7c09903b4c95729", "test/dot_git/objects/78/e118de9e47c4652608412c27425c01764317b5", "test/dot_git/objects/79", "test/dot_git/objects/79/0005c92fc8f75b3d194ae031bb89b041eecb04", "test/dot_git/objects/79/0e7b517e808fb9ddbc67ac1e6b4c02bd4f302a", "test/dot_git/objects/79/657d266b1abff32fb3177c9e383f670dc285c0", "test/dot_git/objects/79/6a9d3b5c3ad98586fa0e68f91ddb9d317600ab", "test/dot_git/objects/79/8078f16e07ac653bd09edb381b77fd70aa434f", "test/dot_git/objects/79/9bfeaa86d66c4e1638f9c777cd823329ce532e", "test/dot_git/objects/79/b2b708e1b11d83d8d169bae09d8291698d5365", "test/dot_git/objects/79/d5f65d307915105523c1267ee2457c853f6d76", "test/dot_git/objects/7a", "test/dot_git/objects/7a/087349e9f350ece8e7fa7715da5e84927e9705", "test/dot_git/objects/7a/5e762fa8f7fa3e2302f1ad4c0710b6910812c1", "test/dot_git/objects/7a/b4406c6679ad4d2a6d7abb029f46b35b1bd3ec", "test/dot_git/objects/7a/e93eb82d94273605ea4ffa808223f3517751f1", "test/dot_git/objects/7b", "test/dot_git/objects/7b/0eb3a3b0d48710afc0fb2f7b95cf949c17db45", "test/dot_git/objects/7b/3c2f5c49cc882758b2dfebcda96f14bf04ba11", "test/dot_git/objects/7b/95db1c259d8fca0aa9d641dfc85127b079c311", "test/dot_git/objects/7b/bf33d461c4840401abc9cb8b37287c7997e9cf", "test/dot_git/objects/7c", "test/dot_git/objects/7c/04a6027ad8768258e2dbbb82b069fa1f061e6f", "test/dot_git/objects/7d", "test/dot_git/objects/7d/3a818a79464316e03c53b11b684e797e9d06ed", "test/dot_git/objects/7d/bfba85b625779105f0d853f89522971346b3ef", "test/dot_git/objects/7d/cfb401bdfd9817a0b3ca08ada41bf0c1080802", "test/dot_git/objects/7e", "test/dot_git/objects/7e/013cd6934d110979c95b17ad9b796264919b52", "test/dot_git/objects/7e/1c4e68dcc2fb435310e397e1269e257f1db6b4", "test/dot_git/objects/7e/3f8ceb97f84e983cbae9934eda025babbb393a", "test/dot_git/objects/7e/4639a2cb181a6592f431d42db83cf640a563d1", "test/dot_git/objects/7e/8b4499db8aeeb2b1b285657113076d643b5f5d", "test/dot_git/objects/7f", "test/dot_git/objects/7f/200467dab592a0a0f1e72777bb2404ef00d57e", "test/dot_git/objects/7f/4a452ac9fc4b6751b454035df3f357c458b150", "test/dot_git/objects/7f/8c688c758239f302451b0bc10679e547003b5e", "test/dot_git/objects/7f/d9cd76d00c54c434d003a49058592b6f0c10c1", "test/dot_git/objects/7f/e607b5531e290bd50f1f70ea236d0306a882a9", "test/dot_git/objects/80", "test/dot_git/objects/80/056ae72df1345efa2dd3e216360ca326943fb9", "test/dot_git/objects/80/8ac3c39d4453622e036118e256f502689d4067", "test/dot_git/objects/80/dd878d113eee55fd606afc60099d24ba50e670", "test/dot_git/objects/81", "test/dot_git/objects/81/17c407e1439f789727b5acdfa809c67bf29ddd", "test/dot_git/objects/81/21bb4a8880254f69d3ce36b1e85de59f85d9bc", "test/dot_git/objects/81/28628b8e0eb3e167d58b1a393db319bc379fe9", "test/dot_git/objects/81/a18c36ebe04e406ab84ccc911d79e65e14d1c0", "test/dot_git/objects/81/b45795bd079c07ed01170a19069372bc6bb885", "test/dot_git/objects/81/c78b8d7ecacc9aea1ca93221f8b6cbef2ffde7", "test/dot_git/objects/81/db1993b56df3c9e2511209eecc3339df0a416e", "test/dot_git/objects/81/f3aa336cc7f79b9765daf032f084059eb2b635", "test/dot_git/objects/82", "test/dot_git/objects/82/0d6dbc4c5d6aa2ac39e9f6e18d334ea3cafa44", "test/dot_git/objects/82/def912edf146e3f30dd02ec78c07356aefdfa5", "test/dot_git/objects/83", "test/dot_git/objects/83/1a6e4e570910039b5359a9cdb5e6b42ff4c423", "test/dot_git/objects/83/6dca6265fb655643b769aa1dd9d24de45713c4", "test/dot_git/objects/83/797cb2aabfcc30a94aba8ae9ba396b2a16c3a6", "test/dot_git/objects/83/a11c45ea6d699f2a874701bc231495df320ef8", "test/dot_git/objects/83/b2a44866c05489569466edd0b64fd64c35f3bf", "test/dot_git/objects/84", "test/dot_git/objects/84/8b08ba949f0d0f64d00a3318775e7f3becf164", "test/dot_git/objects/85", "test/dot_git/objects/85/12f2fa7f4b87784c64cb6615f1fbad7926abf2", "test/dot_git/objects/85/1c599e01cab929963ee07bb8911477da3817bd", "test/dot_git/objects/85/4e76fadf16d5005f334dbaac7a951bf690c310", "test/dot_git/objects/85/80c640aa9c03061a2607afd70a52d4a0fe21b3", "test/dot_git/objects/85/b40f2911319215ea768a7d599e267a465e2b85", "test/dot_git/objects/85/bb8a9e19a9a179bd9f5c2056588e6e25274288", "test/dot_git/objects/85/e5fdbc2cefd10f0aa7042e092bd5f4c8c823d3", "test/dot_git/objects/86", "test/dot_git/objects/86/165d83745d61a99aa3961957d191e038b2f5a6", "test/dot_git/objects/86/1b019631332e20abcedcd44efb78b4bc245797", "test/dot_git/objects/86/4a495e2f411c12a0a5df886d2a3bc0c36edf8b", "test/dot_git/objects/86/a7b47629e8ae1c822c8014a342d1d041609d8c", "test/dot_git/objects/87", "test/dot_git/objects/87/26f79534faaea1e04860001c426e9ea4082a88", "test/dot_git/objects/87/e2e8f0df7fdf8605ba86ecd97d8e7b5590893c", "test/dot_git/objects/88", "test/dot_git/objects/88/33b49921fe5b49266199aa3eba316a80c9e61b", "test/dot_git/objects/88/a86c6983316e48805a13bbb54fa0f9c80248b2", "test/dot_git/objects/89", "test/dot_git/objects/89/353c81b260c81a3340ce0a1b92da0d94d8f6de", "test/dot_git/objects/89/6cdba0f0e33856711cb64067e30256894fe40c", "test/dot_git/objects/89/d0fc07bb62c543b73721d9eb8e76375317777c", "test/dot_git/objects/89/e93573ff69db29a5a7d7f77319a743e8afa784", "test/dot_git/objects/8a", "test/dot_git/objects/8a/0d30f5ec46a905b14597f5f1a50526339313f1", "test/dot_git/objects/8a/4e031f65e18814ff506beee5de5576aca31aeb", "test/dot_git/objects/8a/8a57d37adad012752dbba3c6e1063a374b66a6", "test/dot_git/objects/8a/ac2492e118b62b049858e49286eda99b70424c", "test/dot_git/objects/8b", "test/dot_git/objects/8b/039964bc11de4db51deada1676b0a8e7c80fbf", "test/dot_git/objects/8b/3cdab3baad4295363739c4116a96d8321a67c7", "test/dot_git/objects/8b/8e7f353094009e7fc3b360ecc266081fa7e72d", "test/dot_git/objects/8b/a8d47b778c172e3fa94f59d715d3ccfec9eab8", "test/dot_git/objects/8b/e6f34ad98804d1d0d39d41d63a06d736050494", "test/dot_git/objects/8b/ea8baddf15affc95414c402dfff718790816ee", "test/dot_git/objects/8c", "test/dot_git/objects/8c/a7f29a74c0245e6d5ffe19047290e89c53c2e3", "test/dot_git/objects/8c/b1801bab79dbed4c457f7c56a4243b19a572a1", "test/dot_git/objects/8c/b23bbdc76c2644bcc177e96c648f49b04f2a62", "test/dot_git/objects/8c/be10141cdef6c19f769fe5feb9f97f218a751c", "test/dot_git/objects/8c/cc9b07c5a8c07bb3170758dcd76bfd26631f05", "test/dot_git/objects/8d", "test/dot_git/objects/8d/2896b596358c8d3fe2bde06f71b74322e6c69f", "test/dot_git/objects/8d/86c5f852a8cde3e1500f0bc7e4b75fa16478bc", "test/dot_git/objects/8d/94435b58a834245eb3e98204f6981949febda4", "test/dot_git/objects/8d/9939f789c32f715831c70529faa0ed8bdaeaef", "test/dot_git/objects/8d/c2a6356dbcaa309b457d54ecc297fe9abe4cac", "test/dot_git/objects/8d/e21b364f1831a676486d65deea2bfbe141962c", "test/dot_git/objects/8d/fad1edfb99419586b830f19f9e96ce9d241c49", "test/dot_git/objects/8e", "test/dot_git/objects/8e/f9baa02195f51e8d2322fb9304c8631acc126d", "test/dot_git/objects/8f", "test/dot_git/objects/8f/1becb8995005a7e1b22260e5d6d674249f094c", "test/dot_git/objects/8f/1d9f4bc14deac99f49eddae61ef2c3db7ab5c4", "test/dot_git/objects/8f/270405010cb4b04ee17d650e27bedf52ebc104", "test/dot_git/objects/8f/33d0578b63742b37657963d10bdbc3a30ac874", "test/dot_git/objects/8f/67e2313d82205d121e809ba1095930ded3e3c7", "test/dot_git/objects/8f/a525c77fec13ec6c2178840912c6c37b8c3cce", "test/dot_git/objects/90", "test/dot_git/objects/90/00a6cdf5f075a5b745726b97a7b27f1e669c47", "test/dot_git/objects/90/6fb7baecb35dff873248bae5084a74f59b4912", "test/dot_git/objects/90/87b71f5562c7c842fd3001419f5676f28385b4", "test/dot_git/objects/91", "test/dot_git/objects/91/9f3cce611b8364e605830f3dbb059d36b223df", "test/dot_git/objects/91/a3a5989e366c3037fbd7e917c49a36dcfbf79e", "test/dot_git/objects/92", "test/dot_git/objects/92/06fce962ca848ff0d6c4a9bf28e92b4a694c87", "test/dot_git/objects/92/10addf8611cebd99b28d8ecc01dd90006cf8e3", "test/dot_git/objects/92/1f3eccb5f75c6b81f9044aedd151dd391eef10", "test/dot_git/objects/92/214a8582931848b8146baf317db76dee9cfac1", "test/dot_git/objects/92/4b409ce9b20af189cf2a6ce930be8d977d3d3b", "test/dot_git/objects/92/6bfd86bcaf51e3926756ffce7b877665a2e87f", "test/dot_git/objects/92/d6e4952a99f3b26a0848f5d121f618d9a36c9e", "test/dot_git/objects/92/ffbe0beb74ed54fe13db418914b436f8b155b8", "test/dot_git/objects/93", "test/dot_git/objects/93/a8d9a44e349e3b8eb1138d58aed8574dd1e5eb", "test/dot_git/objects/93/e09a95f21568d850e6dce849a3a637c9459c01", "test/dot_git/objects/94", "test/dot_git/objects/94/2831545ab1b5a6c47998d5204e8fa4a13af252", "test/dot_git/objects/94/319883d8329892c2a817a819b2208369000d09", "test/dot_git/objects/94/9d05d450c007f882ca5bf52552966f40af5e96", "test/dot_git/objects/94/b0a3aa0d0e1faea2587a2ea7f60d8b4720dc54", "test/dot_git/objects/94/c860430bed915b713e537a4b1a1327df976c1c", "test/dot_git/objects/94/ccb02ffd3754e3db0024925d5c15fa1292aae1", "test/dot_git/objects/94/f4167ce48b9a84a94dce037146cd1e6cccd1d1", "test/dot_git/objects/94/f6073254faf452d56d37160580fa2480b0e42b", "test/dot_git/objects/95", "test/dot_git/objects/95/49f8c5b4d118463f75816da93143d538be3f45", "test/dot_git/objects/95/c29e184a0ec7c5fa0a2d4ecd105f17bec6218b", "test/dot_git/objects/95/efe1bd08e0b7b1469b4773c14dc728d5068b7e", "test/dot_git/objects/96", "test/dot_git/objects/96/39d45833816298a7e113f5e6bf048fb3fba7dd", "test/dot_git/objects/96/3bce669afa5f95366b27bf12345f9c3a7e91f0", "test/dot_git/objects/96/738a9834afe2e2e8abee5b78a8b88ffa9fca0c", "test/dot_git/objects/97", "test/dot_git/objects/97/71f107d373b028c2b73e2e169218951f772028", "test/dot_git/objects/97/bc5e8c3cff57c5ad09ee02a39e90a0de08109d", "test/dot_git/objects/97/ec7d3e32843a7a846c3b24332d812a05d28fff", "test/dot_git/objects/98", "test/dot_git/objects/98/1c454cda632d2c1729c5dd8ff72dbf33c2e819", "test/dot_git/objects/98/36cd7a87f3baa9c004d7ed277baef050b2ce3d", "test/dot_git/objects/98/4ab69b9f09ba4087a503628badb3bfb001e417", "test/dot_git/objects/98/b806b34a110411575eee9d45f949a72ac27c7a", "test/dot_git/objects/98/eae78c5916391dc2553c50c60bb6360bc4a298", "test/dot_git/objects/99", "test/dot_git/objects/99/6e0688dd70cbbf10bf760f392d8d52629a51c3", "test/dot_git/objects/99/d7785e7d61fe9f201fdd8d0443e390d77d2ab2", "test/dot_git/objects/9a", "test/dot_git/objects/9a/24db0198f7b9980743fb18ff030428bb4e0da8", "test/dot_git/objects/9a/6864cba7ee98c5f4813ae96ca60385916b449b", "test/dot_git/objects/9a/9060f4b2cf886595f6eb374d5de37755ae8cd0", "test/dot_git/objects/9a/d1e4b62307d64b0e86ca3b178fedde4e078376", "test/dot_git/objects/9b", "test/dot_git/objects/9b/1ffc7e40c8e14632213cdaf588378e9ba8e90b", "test/dot_git/objects/9b/70d75286c8218b28f623a9b0801b0b952ffb8b", "test/dot_git/objects/9b/7786e50a3bc4bdfb9c85ac9ab526ee5030fc34", "test/dot_git/objects/9b/a5af0916c41313afd8ab1ad808e9e810157f50", "test/dot_git/objects/9b/cba3f8ce0858c3a3d79d049995b3b7431cbe2c", "test/dot_git/objects/9c", "test/dot_git/objects/9c/08a48040fa6f5532bcc3a66a79a423a99e7f2a", "test/dot_git/objects/9c/0e612a10196a3ab25264a807d2501bcd520540", "test/dot_git/objects/9c/13d94648123c351a208389b375ef220832086c", "test/dot_git/objects/9c/274162674c99d986363d19a31379b999666765", "test/dot_git/objects/9c/5810283f7b71f0e6658f83fa3cea4c42add182", "test/dot_git/objects/9c/757047550f98256fe4c212d42a404ca75826ba", "test/dot_git/objects/9c/a4d54b87ae030f69c6a1652b06458229163bff", "test/dot_git/objects/9d", "test/dot_git/objects/9d/4cb25621a8fd3751691b5320a63acc0cb71359", "test/dot_git/objects/9d/637db3c6cfa5434f11a71cee9da87c7b8fcfcc", "test/dot_git/objects/9d/b04ec7ffa80fec3f65b02ee882a872e61fa363", "test/dot_git/objects/9d/bdbf17f96c75b31237c301b704a7b11036793d", "test/dot_git/objects/9d/ddf2d703b7acb646470caf3f9b320f8171a952", "test/dot_git/objects/9e", "test/dot_git/objects/9e/0ac6b7a43e94f49694ff169d9e4f55700668c1", "test/dot_git/objects/9e/5651973373448a7621f2b50a6c7719fc731717", "test/dot_git/objects/9e/a045ac20cfcc8c99e5a096926516d940810219", "test/dot_git/objects/9e/cfabcf37cf5ca8f1d9e4be940d38a0ca374592", "test/dot_git/objects/9f", "test/dot_git/objects/9f/17dfcb0f307446f1a9f5f4f265fd03f01e5337", "test/dot_git/objects/9f/625cc941888266a5ace9ea0f7b6de8056648bb", "test/dot_git/objects/9f/94c114fbd1a011d99783c2df5dc97db923fd27", "test/dot_git/objects/9f/9b08b0ed1e63325c5669c54b1666cf00231856", "test/dot_git/objects/9f/a2a086398a284a5ec686601a80f23a81d579f6", "test/dot_git/objects/9f/a6e958bf96ddee6b71a2905bdd4b13bb35bbc3", "test/dot_git/objects/9f/ace5ebf66d7a4990759a6b23d593b27c560371", "test/dot_git/objects/a0", "test/dot_git/objects/a0/1626c862e48de9548a21ee3877c96266a9f247", "test/dot_git/objects/a0/292a1e42c64c9738088223f119740f9bcf25a4", "test/dot_git/objects/a0/2fea10783145b59d53157dfa950e1624506160", "test/dot_git/objects/a0/7705679876a805028101587259fd8f496e8c07", "test/dot_git/objects/a0/89b4d1cc2b3887c816f5ba51ce48d90ea53e4a", "test/dot_git/objects/a0/931153ab2b7eadad5cccf57e8cfe67051a902a", "test/dot_git/objects/a0/94901cc0f4e3f9c311214bc2f9a1e0cf9a0c18", "test/dot_git/objects/a1", "test/dot_git/objects/a1/31034466bff753545671326d45a76592e59f86", "test/dot_git/objects/a1/3905543ce8634d5206f155d887818c261a34ca", "test/dot_git/objects/a1/5c431db0bd54892a5b5965a68c4f313174a415", "test/dot_git/objects/a1/65317959fbd09503f7cc9c0cf917a2bf74d426", "test/dot_git/objects/a2", "test/dot_git/objects/a2/83d38a51ccde7f05bf3b2cdbb374d3e794e3e4", "test/dot_git/objects/a2/a52fd45454e98d600a73080db9be8da494fd05", "test/dot_git/objects/a2/d4e7e0f4d030940b4a62cf905c7f18c9f3ed08", "test/dot_git/objects/a2/e10f1f8af34131fa4e48a41d0331684ca13a80", "test/dot_git/objects/a2/f5e090e38fba14a1d0f776716ddc761952863d", "test/dot_git/objects/a3", "test/dot_git/objects/a3/5cd0e0eff6610786f61c335565d72d9fa3ae69", "test/dot_git/objects/a3/961f321293662cee00c6b53f0fcfa1b91275cf", "test/dot_git/objects/a3/ed9657784be802136449dfd07e5a9586c7826f", "test/dot_git/objects/a4", "test/dot_git/objects/a4/89242712c5cb4eddb40a7969e8e9c12db7b594", "test/dot_git/objects/a4/8bbf51254111dea6d206b753781fbef82f8f63", "test/dot_git/objects/a4/8dbab8aaf71f35784363f7bd5fe0bbdc91219a", "test/dot_git/objects/a4/949eb5bfc411c724532a24a2070e16fafbdbf8", "test/dot_git/objects/a5", "test/dot_git/objects/a5/0da2e9910b2748aafc830288ff86192291e594", "test/dot_git/objects/a5/3312cdadae43ef320f56980491d2db43649ccc", "test/dot_git/objects/a5/7dfa71d8353c05d3c96880fc4c1c2a18168a0a", "test/dot_git/objects/a5/825bc61ad69802743867bafa342c5922fe23bc", "test/dot_git/objects/a5/9c6325fc1e9e00808f2f077f2ba382c8e71140", "test/dot_git/objects/a5/a096c8f88729e302bc0dcfcde69bd1d6cee54b", "test/dot_git/objects/a6", "test/dot_git/objects/a6/25a89a89cfe2916a812c0a19bbf7c88d2bc6c5", "test/dot_git/objects/a6/5cf40f373fb2652f724aa1fe552cfb1cac8f9c", "test/dot_git/objects/a6/61101de591928518b26e5cf19f976173af84b1", "test/dot_git/objects/a6/79381688bf42ef8c52ff13d7ad10fd357b716b", "test/dot_git/objects/a6/7dc709250bd465ac07b180985de98f5eb176b5", "test/dot_git/objects/a6/8e7f06b20e91283fa2729f9f442dee40816d5e", "test/dot_git/objects/a6/b63376a6c6208c700d28f4152f06561a8591f5", "test/dot_git/objects/a6/cc9707d22121121c4c436961f25ad3136c7a2d", "test/dot_git/objects/a7", "test/dot_git/objects/a7/56e607bf1b1f234346348f600ee9216a5687f6", "test/dot_git/objects/a7/b17990b0ddd4909d8a765c5ddbe50e9cb135ca", "test/dot_git/objects/a7/f6425fdc0d6eab1f94942603f9101a9eb010f3", "test/dot_git/objects/a8", "test/dot_git/objects/a8/26a873283fed2746f1f9f934f71db6d9a5e040", "test/dot_git/objects/a8/2dc65e43b5f13287fe61d9c0d535319e10d1fb", "test/dot_git/objects/a8/92c736936baf76e90a8400e13180846943dd65", "test/dot_git/objects/a8/a74a93cf26ee794cebc9f1440c56882b0124e7", "test/dot_git/objects/a8/b7e0fbece9a52e5539e4ab8f80e14504344410", "test/dot_git/objects/a8/f3b83e0ed58f5a7c58fd673eeca588942bcde5", "test/dot_git/objects/a9", "test/dot_git/objects/a9/35f4bb2d641436ab22510afdb2ddf59f953521", "test/dot_git/objects/a9/a1da34ff670558c1aa7d3c6e285cc5fb9b76db", "test/dot_git/objects/a9/b871f8f8bee8e9236b0e47333a0fce672b1445", "test/dot_git/objects/aa", "test/dot_git/objects/aa/74200714ce8190b38211795f974b4410f5a9d0", "test/dot_git/objects/aa/957bcdd3c48f838e0e613c3066ce09399423dc", "test/dot_git/objects/aa/ca7266c757878ce0f80a5edd9651afc32624c5", "test/dot_git/objects/ab", "test/dot_git/objects/ab/a5708519a06e49c3801a27e54e710f30fb13d4", "test/dot_git/objects/ab/c19c8c3819bbaa4964ca4f7fafc32d97834920", "test/dot_git/objects/ac", "test/dot_git/objects/ac/44d394114272dc8ced750155b89a4ea7feec8e", "test/dot_git/objects/ac/9ba205c42662c60238be9f5997d10c2df68d05", "test/dot_git/objects/ac/e84f11ee83b490c7b0421c3815da52172e6106", "test/dot_git/objects/ac/f6144115985ce9f37dbe5f56f4f5d96875b518", "test/dot_git/objects/ad", "test/dot_git/objects/ad/065db654ef09714c6463e2f13e6e936ca8a4b1", "test/dot_git/objects/ad/ac6394aaa5f63348d12c6d7c556cc5895bdb5e", "test/dot_git/objects/ad/be3ad1cfaed6ae867ff4c780e57b24aba92bb6", "test/dot_git/objects/ae", "test/dot_git/objects/ae/45e5b88fcd45b55efa1e8a1f60e6525897430f", "test/dot_git/objects/ae/51c7beb1d82b967d1ec70d43dc2546880e902c", "test/dot_git/objects/ae/88cc08586ab2baad34a00de9aed2be4e8ec297", "test/dot_git/objects/ae/aa7324c31d374eac09744a5e1cf3eb5c11b1ef", "test/dot_git/objects/af", "test/dot_git/objects/af/37cb1d947f50b5a9c4ea7c68dcfeb67ad66f8a", "test/dot_git/objects/af/4976e0ea1364d59c64bfcf0482d50e0e238d16", "test/dot_git/objects/af/6752006c8dfaea112143bd2692f439719162b8", "test/dot_git/objects/af/a1dfabcd436cf7af4deaf13e00180ef5368940", "test/dot_git/objects/af/ae8e12352682bf9d015dce28e338a451c5f55e", "test/dot_git/objects/af/d4d958e849a246bd3413f2cc02e7910f19f058", "test/dot_git/objects/b0", "test/dot_git/objects/b0/1401ffc98de4b600588fcfcd09a3961d162c69", "test/dot_git/objects/b0/3531d097981c72b9c99aca10eca9c50a70d466", "test/dot_git/objects/b0/c2e6b2e88b854dab551433cb113e3daf4c4e3e", "test/dot_git/objects/b0/fb915abf0e5be77c6c2400cffbbfd9c3bdcd00", "test/dot_git/objects/b1", "test/dot_git/objects/b1/35bf729745de0027719d613c8adef1007eaf6e", "test/dot_git/objects/b1/c0001ea8e43861235f34cd4d21853ca458158e", "test/dot_git/objects/b1/fc231270ad6b6edc230aa22b4c10267198b9e6", "test/dot_git/objects/b2", "test/dot_git/objects/b2/1d54ab7d3ec8d8a3c91c997ed9538777e46188", "test/dot_git/objects/b2/1f05a2f9d51a8ef2c143fb7b8282fc53be06dd", "test/dot_git/objects/b2/226c9a893eb2e71e0ff33742968479cd50b131", "test/dot_git/objects/b2/5dce6bbfa5e52108459b9a89b16def6963aec0", "test/dot_git/objects/b2/c2a902e25e522df67b8577b8bb8ddf9aa25098", "test/dot_git/objects/b3", "test/dot_git/objects/b3/6d57789486dabe2309bd7819f7793ef2e7487c", "test/dot_git/objects/b3/d79746ef32b978c65e1654d7ccddb89baa216d", "test/dot_git/objects/b4", "test/dot_git/objects/b4/07761d8d0840acc0c147dce23dcf7b741e3238", "test/dot_git/objects/b4/1467a894bdbe6be958a5de6984dd9c6dcb176b", "test/dot_git/objects/b4/3d94c5a8e399fff7661187411c2f3702898160", "test/dot_git/objects/b4/f07cbe632b5fb7ffe7c25e2a2ed215268ef15f", "test/dot_git/objects/b4/f32e4ada1229dbc85db12ed3f93d15056252ec", "test/dot_git/objects/b4/fd01bf7d2194b58ffc3a8e703bcdef5b3046bc", "test/dot_git/objects/b5", "test/dot_git/objects/b5/297f606fed8450572f35e6e34df7c81d2840e5", "test/dot_git/objects/b5/9047a78a3d6a92deac583900b77af84d0ada54", "test/dot_git/objects/b5/b60fcbee8f46d6b1efa206e139255ae33b81cc", "test/dot_git/objects/b5/e9a82adb2f8bfe4b02ee14b46c32eeb453d53a", "test/dot_git/objects/b5/fe7fc1265ffab1b6441b88055a7638688ba013", "test/dot_git/objects/b6", "test/dot_git/objects/b6/33e336e94e1090bd7e19773972b1bf177d18bb", "test/dot_git/objects/b6/9a6fedabd2d05896b06986e7ac8f69f6d32903", "test/dot_git/objects/b6/e387967dd4d8cc2a590dae48327dd7b1225992", "test/dot_git/objects/b7", "test/dot_git/objects/b7/0c8fd36430fb1e0b02119d7f802c2144fa2a41", "test/dot_git/objects/b7/2772427161ca37e13344c1a9573dfdde28a881", "test/dot_git/objects/b7/6a1914a9461f6e66a4fc5a32b890f38b3dbe89", "test/dot_git/objects/b7/90eae3127d5f3c9d501885ae9e17f342b25298", "test/dot_git/objects/b7/f932bd02b3e0a4228ee7b55832749028d345de", "test/dot_git/objects/b8", "test/dot_git/objects/b8/2e9938dbcadfcb79efff23a12763d6ec48f19d", "test/dot_git/objects/b8/46d2f4cb2a5adfb0c4f46e73f53a074e76c2f6", "test/dot_git/objects/b8/562d355858f20a0043c4b8adf03d7ad64b71e6", "test/dot_git/objects/b8/a5e1b3d5334ec5484f1299b77526b187a94c25", "test/dot_git/objects/b8/a73a8761cd544a512ec2d4461953db8ce95bd2", "test/dot_git/objects/b9", "test/dot_git/objects/b9/04b1fddfc7870be76bb238721ce91ee589856a", "test/dot_git/objects/b9/695b896e6e9cb7944d01b7161c394f558618b8", "test/dot_git/objects/b9/751e8e983d7cf18c3a165a82158a7ad242cbcb", "test/dot_git/objects/b9/79812846dd07c8f72f80075e482764f84e6da2", "test/dot_git/objects/b9/82edbe57b1cb1a9cbe7c5866406978172b994c", "test/dot_git/objects/b9/e18f001d183fcf54debaf1b2995d31a2f60de8", "test/dot_git/objects/b9/fe6cfc99544168ab86a9e5326d2278651204c9", "test/dot_git/objects/ba", "test/dot_git/objects/ba/017639ed43f1604c4bdc3f06cafce7b6678d4a", "test/dot_git/objects/ba/3f83d47153b9bc59a4051c30c1dd037a6eeedd", "test/dot_git/objects/ba/8e143dc8770a08a289c15e575adc55c5a4bb54", "test/dot_git/objects/ba/bdcc3cacd23b79d9fc2bdf3c0b4fc18fb539a5", "test/dot_git/objects/ba/c7b8660ab69c5728f49b9e63751ad1d86ef5d3", "test/dot_git/objects/bb", "test/dot_git/objects/bb/332bf8f4417e45a74d87c762665d27562d4e95", "test/dot_git/objects/bb/9eeafff7d803955a2f4984b2334f43143eede9", "test/dot_git/objects/bb/d2a60494d609583a1117447158a329e1629022", "test/dot_git/objects/bc", "test/dot_git/objects/bc/ba8937bbe9b916c050151ab09d43fa735de698", "test/dot_git/objects/bd", "test/dot_git/objects/bd/0ff2ff68bff3d9c961ac3c549e888204d51ceb", "test/dot_git/objects/bd/1d7e6252aaa69a1a67688101117881c20c6ce2", "test/dot_git/objects/bd/451870911b60ed681e43d21a079858da8263bd", "test/dot_git/objects/bd/4bd34e5de499f1c7cfeb5c7355ea9074d7c3d2", "test/dot_git/objects/bd/5ae9aa537db33ac612a1eb89ea18f3a0f6a6eb", "test/dot_git/objects/bd/76610f714db7ccae84d520a1b354a404f7d860", "test/dot_git/objects/bd/d8251cf5343dafc1ab05b6a939de869802a157", "test/dot_git/objects/be", "test/dot_git/objects/be/0ff545481a8562aa83969dea21653fc932f809", "test/dot_git/objects/be/1f6f33eed717448edf483296f6c2aa558fb937", "test/dot_git/objects/be/8cb297061306048ddd8c190161745ee928e49e", "test/dot_git/objects/be/96f23efa55a1c4cdcd2da6735566571ef94302", "test/dot_git/objects/be/df2c64a1d0b97f039e8bc0d80722f020adfb70", "test/dot_git/objects/bf", "test/dot_git/objects/bf/1f2fa6fd19e57dde89b415269effcd3ac68540", "test/dot_git/objects/bf/2c69e3ff4f9c3abc2c8711a4d9b94fad30e9f0", "test/dot_git/objects/bf/83cc523b783450eb66980b493d415097aeea79", "test/dot_git/objects/bf/d2fc2cdbf316abd7da4ef8d8d8b4536613eeb0", "test/dot_git/objects/c0", "test/dot_git/objects/c0/090cbbfd98cfdbcbe152dd50bfc71e243e8e74", "test/dot_git/objects/c0/489424bfdca21656c06c22b37165a8e72ab8f3", "test/dot_git/objects/c0/529776901fd212c4534feca9ddf0af66962bbc", "test/dot_git/objects/c0/7b369a37b99a56c3d73682e076d610cc66f9ea", "test/dot_git/objects/c0/7e0a3d15fac47b3a4b1628b959a16577ff3388", "test/dot_git/objects/c0/85faa2f50c6d1e7dba1494be5589adadf67c1b", "test/dot_git/objects/c0/a0771d3e3ca04f47b010867ac7a4a42408da0d", "test/dot_git/objects/c0/bff5fee2b3e7ced9f6db56394af1aad1ea7ed8", "test/dot_git/objects/c1", "test/dot_git/objects/c1/4f6e2efdd2993b0bb6b3f247eb50310762bbfb", "test/dot_git/objects/c1/c96e82e7c4ceed6a5e2d54f1e471eb914d1b02", "test/dot_git/objects/c1/ccd31fd431573003f6492034e888f7d9f0b9b8", "test/dot_git/objects/c1/f6b5ee610aeb6ac999ad6dfba1252f17d06d76", "test/dot_git/objects/c2", "test/dot_git/objects/c2/85fb81c97b0ad4b5e31d6c88f7d2de1a999bf6", "test/dot_git/objects/c2/c11d80b63f7583f569ccedf8956daf4dcd7738", "test/dot_git/objects/c2/c80f4043230f63b99f68ba1b31cd3af0e6151a", "test/dot_git/objects/c2/dcc243dd5586cdefe67c1a47922f2b33515e84", "test/dot_git/objects/c3", "test/dot_git/objects/c3/0c8c756c092cc3c5260805b630973786a0c740", "test/dot_git/objects/c3/465a138d3eb08fd7f3ddf6682e1ff5afee196d", "test/dot_git/objects/c3/927974367ccc76ff45e65f64691f866843eda9", "test/dot_git/objects/c3/d90063e61a4f18f0c67f40875c3fbef7679c37", "test/dot_git/objects/c4", "test/dot_git/objects/c4/346031a7f6dd0445b2bb6c8ecfb4b210f71c02", "test/dot_git/objects/c4/a254452489221950ff79204a3fef57bed8f22c", "test/dot_git/objects/c4/cce53174e22a2c0a4ad14d953df1ffa2fb6798", "test/dot_git/objects/c4/e1178df3417161a08166519c671cc7eb9d13da", "test/dot_git/objects/c5", "test/dot_git/objects/c5/316e5a772e358243b305cd39185907ba4000e8", "test/dot_git/objects/c5/4397c1097a4bb0139266faf7f87af3829969fa", "test/dot_git/objects/c5/4fed0d4c2cbdbae8e0e7153d36a0570181dc57", "test/dot_git/objects/c5/5a0b537cb1897139a0423c262c5896633c8ec2", "test/dot_git/objects/c5/ad873781f7507ecbdff12ebf2892aa63829165", "test/dot_git/objects/c5/b18055a68d5dad811238d2c06ae311503c2bba", "test/dot_git/objects/c6", "test/dot_git/objects/c6/1481cac83e3ade196547455a29355a04eada79", "test/dot_git/objects/c6/2a36758a44d5314d84f2a0e5519a12fa788c52", "test/dot_git/objects/c6/9bf949c1ad67d6b982e2a963f5f6f6338efe03", "test/dot_git/objects/c6/c29d8b2626547f47c454e3132643e911a9dca7", "test/dot_git/objects/c6/e98d328fadcc7fd967d0600ddc285e0a1c40c8", "test/dot_git/objects/c6/f25e80b8bcf0a21db2bea368b9e444c19bc0bf", "test/dot_git/objects/c6/fe7a87983e74b52fa926fa439dc86267ad0ece", "test/dot_git/objects/c7", "test/dot_git/objects/c7/3ab753abf0ab07061c6e5c9f18f723c8839eea", "test/dot_git/objects/c7/7d84a29d341be904705ff97f40060d896d32a2", "test/dot_git/objects/c8", "test/dot_git/objects/c8/7eab9bd090b6e7f3777681b5cd11f4ea7a0fdb", "test/dot_git/objects/c8/b4c9d59ca1c0115f3ad4bb89d46dccdcf4a00c", "test/dot_git/objects/c9", "test/dot_git/objects/c9/0f97abc5e730138e977fa4b3049e6a8417b8c6", "test/dot_git/objects/c9/378208eb8e4d7b44ff1d4ed8b24b2a3cec63ac", "test/dot_git/objects/c9/67cea0a628ff0f9b85d59003b56ab3db1ab2b4", "test/dot_git/objects/c9/868012bd4ec4530b50ec581eb4464640583367", "test/dot_git/objects/ca", "test/dot_git/objects/ca/296a4122a0f6c4412532bd8cb785eb477d670a", "test/dot_git/objects/ca/8a30f5a7f0f163bbe3b6f0abf18a6c83b0687a", "test/dot_git/objects/ca/c661c85aa6405085fb561e4f5a1dbd62c89e0c", "test/dot_git/objects/cb", "test/dot_git/objects/cb/025c8d5557e85215123582995ce4f29ba8cf58", "test/dot_git/objects/cb/089cd89a7d7686d284d8761201649346b5aa1c", "test/dot_git/objects/cb/2d623b0705dab9033b26ba6b1d26347c9c7dc6", "test/dot_git/objects/cb/7524872ad0434e6ae1b9a467161d71cd052b20", "test/dot_git/objects/cb/865cdf59ba7e39d8a5130ff81b2c753dc87ed6", "test/dot_git/objects/cb/9af18c3753abd34f1bffd77af3c02e8975e24c", "test/dot_git/objects/cb/b903f44f2508c6204f58f812977dcc8cf9cefe", "test/dot_git/objects/cb/c8b3ec01bb98eb90e9988fe0005ecbc2dd33e8", "test/dot_git/objects/cc", "test/dot_git/objects/cc/04ea7b08f3c688db2d08837cd02cc314dcc993", "test/dot_git/objects/cc/21f81d7720b48f4c536e38de9228f590f747a2", "test/dot_git/objects/cc/5a59d08bd7e2ffe3e7b4476d809edab4038bb2", "test/dot_git/objects/cc/70a2b9b33e50633e146745b14be7b827a1b3fd", "test/dot_git/objects/cc/76d7de880e9bc84ff2b42cbfd394d0e3a61113", "test/dot_git/objects/cc/a47071801b43a39ca8d0a88f2201ad30ebedc9", "test/dot_git/objects/cc/fdeb08df97d990299a7cf523c0f26be1a17b72", "test/dot_git/objects/cd", "test/dot_git/objects/cd/34920bf0e591f952d46919b31ac464091c5ec6", "test/dot_git/objects/cd/3d162097c26b24b58f1d41cac56b871d945629", "test/dot_git/objects/cd/4b54aa066e4907be838d76250968a49d9a54a5", "test/dot_git/objects/cd/b5ce2c133787835ca0b75e3dddd4482d7d40ce", "test/dot_git/objects/ce", "test/dot_git/objects/ce/37aab31d5b51592d153e85dc31a1164f2c74d5", "test/dot_git/objects/ce/c2177c534977032173305e028aec34b2b15244", "test/dot_git/objects/ce/d71400e6918863c98829c3257274047aa86c3e", "test/dot_git/objects/cf", "test/dot_git/objects/cf/19fd85e7967177d5419c4d07398f990c33545d", "test/dot_git/objects/cf/1c5abec20238b4fda0b8fb9c9fcc0314198010", "test/dot_git/objects/cf/217f62ca6f13caa821e5f364e2db97d4139adc", "test/dot_git/objects/cf/940d627bfd8f62d084bc351a17e70f138754e7", "test/dot_git/objects/cf/ba8a784564e61ab02beec0546e2b7deb1dedf8", "test/dot_git/objects/cf/c1d07a120f8fa9812c821a93c6eea7b5f3f849", "test/dot_git/objects/d0", "test/dot_git/objects/d0/609bbcf9b21b5488a3d0ec2cac298072d39773", "test/dot_git/objects/d0/b8e19994cff4866d3464f604a44f5856436e67", "test/dot_git/objects/d0/b95097a4a97decfb88616ac5fa995bf8fd2353", "test/dot_git/objects/d0/c74daaca46f35c1ff78c5b600826deb5649524", "test/dot_git/objects/d1", "test/dot_git/objects/d1/13634b1167576fe27292c3857813ef5cc4a669", "test/dot_git/objects/d1/152cb07487bd11c9f63843437b277d51e07205", "test/dot_git/objects/d1/5036828e61ea14859aa7d1bfcebd0e3b0eb881", "test/dot_git/objects/d1/55f8b40aab911804bdc6375d9db0c585fd16ae", "test/dot_git/objects/d1/624b21caf0eee83ec682d312cf477e88f750d3", "test/dot_git/objects/d1/7653ab881d8ca2930b87b7456a41cf8745a4c2", "test/dot_git/objects/d1/d689918ec50ffe164a1eed435b6e3afb281aa0", "test/dot_git/objects/d1/f010bd414b89ab2d70d95f819b913dfe421a14", "test/dot_git/objects/d2", "test/dot_git/objects/d2/110dfef12479935cf619a11136153f94ca9b67", "test/dot_git/objects/d2/2e791be92d7cb52fb20e5734ace4423d1832b5", "test/dot_git/objects/d2/563757320e1557299ad7249cd23523f065e654", "test/dot_git/objects/d2/7b6ed3f2298528545a2d5fec952ab8468c52b4", "test/dot_git/objects/d2/d47b0e111aa46550e107f7c2d0342dab5fec54", "test/dot_git/objects/d2/ef2754d3f4498e5f39093a13bb7b63f5ac53e0", "test/dot_git/objects/d3", "test/dot_git/objects/d3/60d56c0dc32d09a1dac7d14227c0dc502e0315", "test/dot_git/objects/d3/6adf3899666534d3dfdbb7cb56ae6cd67c775f", "test/dot_git/objects/d3/e2f80ca20952878e5d2b113eea12af3b86548e", "test/dot_git/objects/d4", "test/dot_git/objects/d4/15fea0f0ad0b7894d6bef5705377f0bbdf14b1", "test/dot_git/objects/d4/47e353cbaaa11b404fc0f03d3cabe71cdf4938", "test/dot_git/objects/d4/c1f16003f3a9dbd786ff9c76fd870f6410219e", "test/dot_git/objects/d4/c52892a65b126bd009552425629d3ddeac187c", "test/dot_git/objects/d5", "test/dot_git/objects/d5/23191505a04e561b83f1d2d4161d0464fb7cc4", "test/dot_git/objects/d5/50ee25ecdea090a474e46047f5fb53c608225c", "test/dot_git/objects/d5/b2e50283d7c08ba11cff41cf969bc409e25b04", "test/dot_git/objects/d6", "test/dot_git/objects/d6/8924f19dad96912e1a653946aedca73e4f1515", "test/dot_git/objects/d6/8d89dbe9dd68f50039dce10c47e26f09515a49", "test/dot_git/objects/d6/a96d9347d002e1f4c994f6e706c92cacf34c1b", "test/dot_git/objects/d6/fa111185d38e869024040461d97e3fb1f2a3dd", "test/dot_git/objects/d7", "test/dot_git/objects/d7/06308dfda94ed1d1fa3b4e166204a3b3b821de", "test/dot_git/objects/d7/3109da898b1130ebf23ac384cd19f037244f2c", "test/dot_git/objects/d7/3cb7a250d50941a792fa4b7ce8967d8d19f172", "test/dot_git/objects/d7/769d5114d138fe191f89c4762207cf09ee6ff6", "test/dot_git/objects/d7/7e88e54007ca7054c80e4a553dfc9497033190", "test/dot_git/objects/d7/9588e68ca46be7ff40142a916384bb2e747a23", "test/dot_git/objects/d7/a66b7d6053a49c44d0be8431be4e3f83d2fca6", "test/dot_git/objects/d7/b6c50da9b2013a2b68a58ad248a5ee86e3e413", "test/dot_git/objects/d8", "test/dot_git/objects/d8/263d0d2544145f915010a759217b3cca42372d", "test/dot_git/objects/d8/32e468be4f1fc8898bf2e5273f1edbe96df5a1", "test/dot_git/objects/d8/5761603253c1244d71de61bbaede916abbc31e", "test/dot_git/objects/d8/73fa62a4ffb5d5a75d21432ffa8d1f6579024d", "test/dot_git/objects/d8/abe3ca243a8ff9bba26b084100087bfcb4cc76", "test/dot_git/objects/d8/c9929f8fd838bb3b382e0d59d64d98fde2c1c6", "test/dot_git/objects/d9", "test/dot_git/objects/d9/257b8d55aa73dd51720e85768d217c9305f3ff", "test/dot_git/objects/d9/8d313fdd7d2bfa25bc440ac7419b65548d0ccb", "test/dot_git/objects/d9/a1d623cba5e02e877ab45f642d103ef8d5b3b0", "test/dot_git/objects/d9/f86d513707635a11cbd37ea1bd2a7963122c0b", "test/dot_git/objects/da", "test/dot_git/objects/da/1669b4371b10947264cb338e9a1cbedc0ad569", "test/dot_git/objects/da/2906f8045e1fdb88e00041682e7bd681a8ad1d", "test/dot_git/objects/da/a1ae72d1b50ea84156ab4609e643a070bdef4e", "test/dot_git/objects/da/a957a7309b9c4151fbed3db2467a05a20af896", "test/dot_git/objects/da/d96db2312b0af8967b04f7071ef98dab98eda4", "test/dot_git/objects/da/fd8a6599574a188701e2efd965b5a9907925ee", "test/dot_git/objects/db", "test/dot_git/objects/db/0101ef085f8c71eb0f4a1ec982d292924a5d7e", "test/dot_git/objects/db/41697c57c3d294a776b4d42156868d6af91432", "test/dot_git/objects/db/668e5f99bf481aa0c196091e4922238fdaf341", "test/dot_git/objects/db/c9ba300c9939793123d04c4cb1b1f0b25e6bb3", "test/dot_git/objects/db/d625cae0863ef56c00c09d7954dea8165650db", "test/dot_git/objects/db/dff42a58d11af46dd1361105de13ae6cfcddf2", "test/dot_git/objects/db/fed0396f4690e49a9326015f0986f0d88e9bf8", "test/dot_git/objects/dc", "test/dot_git/objects/dc/0bcf3df4f74fa898ab5541c38e38b405dbcaa9", "test/dot_git/objects/dc/13b3e9e0c9f064e50c432158e3b038dc36b63e", "test/dot_git/objects/dc/5de731e66fa25fa825ef4d2d550914c50e3592", "test/dot_git/objects/dc/7dadd3e76635500988a1805b414074cca37470", "test/dot_git/objects/dc/80b6e1a79803154171b8b54021280c79345b03", "test/dot_git/objects/dc/a70d64a067eb0739bd71b8725d8e34fbc1ed0a", "test/dot_git/objects/dd", "test/dot_git/objects/dd/018cf1e22bb55a7603eb7b5dc40dd794df96f5", "test/dot_git/objects/dd/0d926603e93d455d1986c28adb6596062580f0", "test/dot_git/objects/dd/7efbb77e82a842d13c91288c372e26fc701ed6", "test/dot_git/objects/de", "test/dot_git/objects/de/6582afb45f6095e001f58add5ea7c10e9dcb6d", "test/dot_git/objects/de/b2346f42ba644e6768541b5eded5d381c26158", "test/dot_git/objects/de/e78dfdbff2d10b632252914a27b087c133c6c0", "test/dot_git/objects/df", "test/dot_git/objects/df/bda7c78373c97807758e7385e980ea1969a6a6", "test/dot_git/objects/df/eb56c9ad7ffe4aa3119f378720dea2e4c7b663", "test/dot_git/objects/df/eeb6e6ca48947e35b882ae04bdcc7cbc992d99", "test/dot_git/objects/e0", "test/dot_git/objects/e0/2bcf0380749a290c327fad97bfb383ca54bcb3", "test/dot_git/objects/e0/34f8ea24c4f0e5a5ad74291148ab8a94843dcf", "test/dot_git/objects/e1", "test/dot_git/objects/e1/c2a8f7843b588275eda6f3c8e321e23e74fd96", "test/dot_git/objects/e2", "test/dot_git/objects/e2/496eb77be920be74b1e9685a737a0f774d4fcf", "test/dot_git/objects/e2/4cc74b1f91acd0cc01b6cc413319155934735f", "test/dot_git/objects/e2/52fa762a251d01725a8d4c5becb136e9955fe8", "test/dot_git/objects/e2/56e219e2898ef4e259472205a4cfb3fb782f3b", "test/dot_git/objects/e2/a696dd7cc6a5870130b7111fd0d768101aef73", "test/dot_git/objects/e2/c9f53517ee568ac02ce2b8f2633e8b0a9f513e", "test/dot_git/objects/e3", "test/dot_git/objects/e3/2412d181cced969cb0259656bed360e07e1c3a", "test/dot_git/objects/e3/3e78cb3c472bc6e1566146f6758851ce2677b6", "test/dot_git/objects/e3/8017572b5eae23f041a40cb49292213e603cd2", "test/dot_git/objects/e3/a3038573f3b1246def8ef1a1614f054bedf997", "test/dot_git/objects/e3/e846396d26e98aa34d26c7417e851f46801f9a", "test/dot_git/objects/e4", "test/dot_git/objects/e4/2c5d4e90496dec671202ade0099d0ab93beb9d", "test/dot_git/objects/e4/36cb7f50f0d742c0e0aa972092ec9bebb7f576", "test/dot_git/objects/e4/45223b62c0dfe199d2db14b439c5eb1f10edd4", "test/dot_git/objects/e4/76515e4c1e9c034f44efea8cb96bc137cd4c94", "test/dot_git/objects/e4/c491a2a3369cd2dbb250ee51c77026a9f0e890", "test/dot_git/objects/e4/d1fc91a3740ecf260efeaaaf6e7376021900e1", "test/dot_git/objects/e4/e9744dfabd3c54cddf8274d95ffe7e8d4ae1f6", "test/dot_git/objects/e5", "test/dot_git/objects/e5/3c62a8e65bcb441de67dd388f22d9e59ff41b4", "test/dot_git/objects/e5/b2c414dddbe9e0c485e4021afe939e6f760113", "test/dot_git/objects/e6", "test/dot_git/objects/e6/04d431540c63ebb9387bd1506b7df63e3d4868", "test/dot_git/objects/e6/1b707b59d20dc125ae1c2383eb67e06ee6686e", "test/dot_git/objects/e6/2bf8d52ea71f4bfa9f703291736740662a569e", "test/dot_git/objects/e6/30c25e624543723c051a8cef0b7894a43b5d66", "test/dot_git/objects/e6/d63855e008c8a3a126fe042e8411bf60c6d6a1", "test/dot_git/objects/e6/e2baff2ba5e92ee6487187f4d0a47a6e981dc3", "test/dot_git/objects/e7", "test/dot_git/objects/e7/67e28974d0047a53f3880d1361822c2386873b", "test/dot_git/objects/e7/681e997de80c7d57e2c8e09c50c990c55d3b1c", "test/dot_git/objects/e7/68654a38ce8abc9f3b62d6860e386dc6188ed1", "test/dot_git/objects/e7/7a296aa02490f6a8d2ee4cb61e3600cdd416be", "test/dot_git/objects/e7/9953820104e86a400504a738d09a9af1a85d52", "test/dot_git/objects/e7/ca677143058e804352ae7225ec7ee077e732cc", "test/dot_git/objects/e8", "test/dot_git/objects/e8/c36a5942eb01f7036ed8969f5845c4d5385896", "test/dot_git/objects/e8/cecd71bf2bf0ee79b8254de22260bcacabe3aa", "test/dot_git/objects/e9", "test/dot_git/objects/e9/0d7972cddfcbed0e7efd7dac92cbe894c226f0", "test/dot_git/objects/e9/13e5150f7f6789f16afe8276c0c4cbd4e6d374", "test/dot_git/objects/e9/2a43db63f1c8bd572270140e8771fd33d1e415", "test/dot_git/objects/e9/462ac46b53343c09ea5dcdc7ab53b28dbdaf95", "test/dot_git/objects/e9/4f08ad7175d17064b709e487cf3d16954fb204", "test/dot_git/objects/e9/594eba936a7a228d42b65d700bebff95a4d7d9", "test/dot_git/objects/e9/5d5db706850682b2798f7643e31f3f82cfa8e0", "test/dot_git/objects/e9/6f1622e59e32a89c727359f2c8c5e598d719c8", "test/dot_git/objects/e9/95e20b7c6ad21823aedc5d3646271bbb5565a9", "test/dot_git/objects/e9/c97e96fc539a6586110b4698c64e8167f09b7d", "test/dot_git/objects/ea", "test/dot_git/objects/ea/35a4556f5a6f1e25e133e0c4928c1bd9994356", "test/dot_git/objects/ea/7d7232c2035543c3b0f349339d50157874b5f0", "test/dot_git/objects/ea/94f383c239922fd70cc0433e2f34484b630f52", "test/dot_git/objects/eb", "test/dot_git/objects/eb/0661fd2ee02af9e0c5c885028f147fbd5f13ab", "test/dot_git/objects/eb/275489327879906f5ced9f04220aa896534243", "test/dot_git/objects/eb/8ca7d4157905fe359425a58c05c4c43ceb3911", "test/dot_git/objects/eb/9c34e472281434001fb733bb12dcef2a27fc1e", "test/dot_git/objects/eb/edf3022c32069f7c375fed501e27ce570a8df7", "test/dot_git/objects/eb/ee5088c07150ab83f09d7f56b7317afdc0b447", "test/dot_git/objects/ec", "test/dot_git/objects/ec/256eeca5ef0eb92479e4b5dec684deb962e952", "test/dot_git/objects/ec/43985d3cabe16a0096836a5ad64317101bb0a6", "test/dot_git/objects/ec/a0c428506f18dc36589e9464513f7157cd6e52", "test/dot_git/objects/ec/c3c63aa7cd24a169698704dcbddd9dc19f81f1", "test/dot_git/objects/ed", "test/dot_git/objects/ed/0facca8d7f95104e95cc6682f77c8171c5423a", "test/dot_git/objects/ed/3d99d5dc459aca24614bb4ca672413aa41d64a", "test/dot_git/objects/ed/a08db954e49e1d794a7e74a81a2a5b2215a9a4", "test/dot_git/objects/ed/a3c8823fddd1f491948351df3757b624d5f3ef", "test/dot_git/objects/ed/c62f0fb7f82ee1ad7c29b42e513960fdcf13d9", "test/dot_git/objects/ee", "test/dot_git/objects/ee/0ca6cafabbf02988a2e023b35c1567f9b0795e", "test/dot_git/objects/ee/2b012174a4a37234adb948bc56ec2ed55881fb", "test/dot_git/objects/ee/88371bc4a42cb7980fdb7704be9f05fee3b0a3", "test/dot_git/objects/ee/ccc934cad8bb74624ed388988fe79c26e6900d", "test/dot_git/objects/ee/de095009fcdde7b3bb4ddc21f3f479eb2331c2", "test/dot_git/objects/ee/e211414ed00e6b5b65d81179ea21d5c052addd", "test/dot_git/objects/ee/e9df3d091825b2ce066c0fe717e2224f2f2931", "test/dot_git/objects/ef", "test/dot_git/objects/ef/9d99db794a654d4c67527d277064481e996c5a", "test/dot_git/objects/ef/9e75f59ccadfd4c67c6853828b9bc34d974ec7", "test/dot_git/objects/ef/b165f0221d9739b6be5179ae3cecd633e45ce8", "test/dot_git/objects/ef/e949a5fd8eb03a7380b2eccb2fc7dcabef6899", "test/dot_git/objects/f0", "test/dot_git/objects/f0/32303006cdfe5892e2f8f64cf0f972d351b9a3", "test/dot_git/objects/f0/5fb20e635d8ae2ff50ccb6a984274e58058632", "test/dot_git/objects/f0/6db1288baf0f8671f287ad5a2a91d943747068", "test/dot_git/objects/f0/f6f7e25c4bdd0647932e859fca992ff37869b3", "test/dot_git/objects/f0/f87fe091f1256b42135c6e2e482cd3a078c7f9", "test/dot_git/objects/f1", "test/dot_git/objects/f1/0267a9fd3a1baaf9ba9e869f23e9941f16a040", "test/dot_git/objects/f1/0a750f2d5017a105d99d49dac1a86adcfef830", "test/dot_git/objects/f1/279e3559971fcd3ab535140d9f320796f48269", "test/dot_git/objects/f1/43aeeecdd4c7736a3d9767acf598e9c5f10e9e", "test/dot_git/objects/f1/bf0001951ac41581e708bacacc4bdb4deddf3c", "test/dot_git/objects/f2", "test/dot_git/objects/f2/0b59e485ec38019c363f3e1e89e0f804ed48ec", "test/dot_git/objects/f2/2d0c85fbcfc90bc51ef9a9131d03033ca11115", "test/dot_git/objects/f2/41613e98ac4f7d57d45dfd8d7f38b7c8df99f3", "test/dot_git/objects/f2/46936f2d7e901199afad8bb7e1e3b27de590a6", "test/dot_git/objects/f2/4881f7c6a31653a8d979a9d57dc892987be60c", "test/dot_git/objects/f2/4e3a795e54ee05df27ecd67f24d7033f954e2d", "test/dot_git/objects/f2/55ce10804955454568678091a6f328ef66a8a6", "test/dot_git/objects/f2/7d9bd39b44bd80abd029a481c6a54617d0d170", "test/dot_git/objects/f2/8d3bb5dd2c9be42f4ec9458808a4d8487c2e3e", "test/dot_git/objects/f2/c90099c5e43ab88371cdccc411d0424b0a4fb9", "test/dot_git/objects/f2/ce4153e5b1231e5603dea5772cd7a895d93923", "test/dot_git/objects/f2/e63e8292a9e5750c459398d54f3ad9a23c18d7", "test/dot_git/objects/f3", "test/dot_git/objects/f3/58447ff06a87a0aeac39e1945e3c635b328801", "test/dot_git/objects/f3/7527fc3a9a67a11e982ac64d37b6f8ed68d297", "test/dot_git/objects/f3/b578c9694e83744b094524cbd190f2763f4a12", "test/dot_git/objects/f3/f1411becc7ea375d82a8cd1e6581f112dcb7d0", "test/dot_git/objects/f4", "test/dot_git/objects/f4/1be6d524d8db969348f7e3bdcc08908932bb4e", "test/dot_git/objects/f4/401b69f04ff4a08df8e03e7883feca260f30f1", "test/dot_git/objects/f4/e4a260042d8030185c55a6005496ca7735ac3e", "test/dot_git/objects/f5", "test/dot_git/objects/f5/0489c78cc3d06d797c82d871726716684fc61c", "test/dot_git/objects/f5/3a1631d49cfdb0a257974b3ebc0b5bc79bde52", "test/dot_git/objects/f5/3d11ab42a370d97a2121c864b411aaca6f08dd", "test/dot_git/objects/f5/3eb189e857104b44de96b0a41436ebf60ffd78", "test/dot_git/objects/f5/42ce17ea0da75b3de894eb7d0ffd8b9efe97d2", "test/dot_git/objects/f5/69f066cdae3a13946f7ef9608677006ff387ed", "test/dot_git/objects/f5/6b3f207a27f31f0d625926f822ca2e48d9d0d4", "test/dot_git/objects/f5/923002632da369454a1dc158ea3c0306fdeeee", "test/dot_git/objects/f5/c3d3175f45e9bc0d22a18c23d05aa3efd495dd", "test/dot_git/objects/f6", "test/dot_git/objects/f6/2215251c1d9fd76bdfb6454446cb1826ee9246", "test/dot_git/objects/f6/c9c0b559fd041a0a23d33ae4bb605f0dba7b58", "test/dot_git/objects/f7", "test/dot_git/objects/f7/3b9daf41c4c1380be40168b5cb7a3fefb87728", "test/dot_git/objects/f7/f0d1e2900534942ca33db3655dca736cf511cd", "test/dot_git/objects/f8", "test/dot_git/objects/f8/1eec2ace52484d074b1db7a29b32c8b716d056", "test/dot_git/objects/f8/206296fd197c506a224e9bbee22a8dccd2d8b7", "test/dot_git/objects/f8/5c1f389f7a79aff1d3f05abb8dbff7e7c15ee0", "test/dot_git/objects/f8/f75c70d9abddb176e61fe67520a0f0a168b8ee", "test/dot_git/objects/f9", "test/dot_git/objects/f9/1286d73b748a0008e48f03362e4642cd5dc9b3", "test/dot_git/objects/f9/f3fe3f0b327e5b7955a195e5d789791bcc08f1", "test/dot_git/objects/fa", "test/dot_git/objects/fa/18b41bbe8588286eaa9e969516ad761d0e3014", "test/dot_git/objects/fa/3c45fbf74c431e978028feee0b2fdd5253a150", "test/dot_git/objects/fa/64d91bcda155c1622505ca91dde0fa694c04c1", "test/dot_git/objects/fa/b9a01ca267b7eec6fa6f215c34b9967d8565a7", "test/dot_git/objects/fa/dd0862e018dbf21be3c6775acf9b93df85b8ae", "test/dot_git/objects/fb", "test/dot_git/objects/fb/646a3ac70216618af383ce1bec1e05692d81fd", "test/dot_git/objects/fb/720415bc5672ba589928d8ac63c5fcc7de2eb0", "test/dot_git/objects/fb/c4ed43dfd3173f9707e3d7657809dc77c0bd9a", "test/dot_git/objects/fc", "test/dot_git/objects/fc/0bfccdebfaea6fbb28e5a6cea62f9a820ea817", "test/dot_git/objects/fc/ee3824a8d0213b9a3a940653e9fafaeaeeae1d", "test/dot_git/objects/fd", "test/dot_git/objects/fd/f213805d60b3c1736a8121b8388ff143363e58", "test/dot_git/objects/fe", "test/dot_git/objects/fe/790b61726b8a710b66df71b8999798d9a8e176", "test/dot_git/objects/fe/7efffeafed1ecd4679b5526d72a7dd3df140a9", "test/dot_git/objects/fe/96440abd8d769d80037c7a8afcbf225156b604", "test/dot_git/objects/fe/a98a018892bd22aa0bf7de727097eafc66ecc2", "test/dot_git/objects/fe/cd79941b5854d9a729c4b0752ebc23c49ae0f0", "test/dot_git/objects/fe/d488d40a767dd69f1e6aa6ba060e8669666391", "test/dot_git/objects/fe/f69482cd45384aeccd1161cdbbf754a524a811", "test/dot_git/objects/ff", "test/dot_git/objects/ff/0f42a1d984cdcd4b647e713eaec668177fb1f6", "test/dot_git/objects/ff/2a1936f7883f44e7587a65dcbb5d18b03f3835", "test/dot_git/objects/ff/667b71fb08b0642e5a92087e763fc09096893c", "test/dot_git/objects/ff/97e5351d9fccccd047d798573c5a61771fc6c9", "test/dot_git/objects/info", "test/dot_git/objects/info/alternates", "test/dot_git/objects/pack", "test/dot_git/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.idx", "test/dot_git/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.keep", "test/dot_git/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.pack", "test/dot_git/ORIG_HEAD", "test/dot_git/packed-refs", "test/dot_git/refs", "test/dot_git/refs/heads", "test/dot_git/refs/heads/nonpack", "test/dot_git/refs/remotes", "test/dot_git/refs/remotes/origin", "test/dot_git/refs/remotes/origin/HEAD", "test/dot_git/refs/remotes/origin/master", "test/dot_git/refs/remotes/tom", "test/dot_git/refs/remotes/tom/master", "test/dot_git/refs/tags", "test/dot_git/refs/tags/annotated", "test/dot_git/refs/tags/not_annotated", "test/dot_git/refs/tags/v0.7.0", "test/dot_git_clone", "test/dot_git_clone/config", "test/dot_git_clone/description", "test/dot_git_clone/HEAD", "test/dot_git_clone/hooks", "test/dot_git_clone/hooks/applypatch-msg", "test/dot_git_clone/hooks/commit-msg", "test/dot_git_clone/hooks/post-commit", "test/dot_git_clone/hooks/post-receive", "test/dot_git_clone/hooks/post-update", "test/dot_git_clone/hooks/pre-applypatch", "test/dot_git_clone/hooks/pre-commit", "test/dot_git_clone/hooks/pre-rebase", "test/dot_git_clone/hooks/prepare-commit-msg", "test/dot_git_clone/hooks/update", "test/dot_git_clone/info", "test/dot_git_clone/info/exclude", "test/dot_git_clone/objects", "test/dot_git_clone/objects/info", "test/dot_git_clone/objects/info/alternates", "test/dot_git_clone/refs", "test/dot_git_clone/refs/heads", "test/dot_git_clone/refs/heads/master", "test/dot_git_clone/refs/heads/nonpack", "test/dot_git_clone/refs/heads/test", "test/dot_git_clone/refs/heads/test/chacon", "test/dot_git_clone/refs/heads/testing", "test/dot_git_clone/refs/tags", "test/dot_git_clone/refs/tags/v0.7.0", "test/dot_git_clone2", "test/dot_git_clone2/config", "test/dot_git_clone2/description", "test/dot_git_clone2/HEAD", "test/dot_git_clone2/hooks", "test/dot_git_clone2/hooks/applypatch-msg", "test/dot_git_clone2/hooks/commit-msg", "test/dot_git_clone2/hooks/post-commit", "test/dot_git_clone2/hooks/post-receive", "test/dot_git_clone2/hooks/post-update", "test/dot_git_clone2/hooks/pre-applypatch", "test/dot_git_clone2/hooks/pre-commit", "test/dot_git_clone2/hooks/pre-rebase", "test/dot_git_clone2/hooks/prepare-commit-msg", "test/dot_git_clone2/hooks/update", "test/dot_git_clone2/info", "test/dot_git_clone2/info/exclude", "test/dot_git_clone2/objects", "test/dot_git_clone2/objects/info", "test/dot_git_clone2/objects/info/alternates", "test/dot_git_clone2/refs", "test/dot_git_clone2/refs/heads", "test/dot_git_clone2/refs/heads/master", "test/dot_git_clone2/refs/heads/nonpack", "test/dot_git_clone2/refs/heads/test", "test/dot_git_clone2/refs/heads/test/chacon", "test/dot_git_clone2/refs/heads/testing", "test/dot_git_clone2/refs/tags", "test/dot_git_clone2/refs/tags/v0.7.0", "test/dot_git_iv2", "test/dot_git_iv2/config", "test/dot_git_iv2/description", "test/dot_git_iv2/HEAD", "test/dot_git_iv2/index", "test/dot_git_iv2/info", "test/dot_git_iv2/info/exclude", "test/dot_git_iv2/info/refs", "test/dot_git_iv2/objects", "test/dot_git_iv2/objects/info", "test/dot_git_iv2/objects/info/alternates", "test/dot_git_iv2/objects/info/packs", "test/dot_git_iv2/objects/pack", "test/dot_git_iv2/objects/pack/pack-4eb8bbafbe65e4f3841581537735fc5d448759c5.idx", "test/dot_git_iv2/objects/pack/pack-4eb8bbafbe65e4f3841581537735fc5d448759c5.pack", "test/dot_git_iv2/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.idx", "test/dot_git_iv2/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.keep", "test/dot_git_iv2/objects/pack/pack-c8881c2613522dc3ac69af9c7b4881a061aaec8c.pack", "test/dot_git_iv2/packed-refs", "test/dot_git_iv2/refs", "test/dot_git_iv2/refs/remotes", "test/dot_git_iv2/refs/remotes/origin", "test/dot_git_iv2/refs/remotes/origin/HEAD", "test/fixtures", "test/fixtures/blame", "test/fixtures/cat_file_blob", "test/fixtures/cat_file_blob_ruby", "test/fixtures/cat_file_blob_size", "test/fixtures/cat_file_commit_ruby", "test/fixtures/cat_file_tree_ruby", "test/fixtures/commit", "test/fixtures/diff_2", "test/fixtures/diff_2f", "test/fixtures/diff_f", "test/fixtures/diff_files", "test/fixtures/diff_i", "test/fixtures/diff_index", "test/fixtures/diff_mode_only", "test/fixtures/diff_new_mode", "test/fixtures/diff_p", "test/fixtures/for_each_ref", "test/fixtures/for_each_ref_remotes", "test/fixtures/for_each_ref_tags", "test/fixtures/gitmodules", "test/fixtures/log", "test/fixtures/ls_files", "test/fixtures/ls_tree_a", "test/fixtures/ls_tree_b", "test/fixtures/ls_tree_commit", "test/fixtures/ls_tree_paths_ruby", "test/fixtures/ls_tree_paths_ruby_deep", "test/fixtures/ls_tree_subdir", "test/fixtures/ls_tree_submodule", "test/fixtures/merge_result", "test/fixtures/rev_list", "test/fixtures/rev_list_all", "test/fixtures/rev_list_count", "test/fixtures/rev_list_delta_a", "test/fixtures/rev_list_delta_b", "test/fixtures/rev_list_lines", "test/fixtures/rev_list_range", "test/fixtures/rev_list_since", "test/fixtures/rev_list_single", "test/fixtures/rev_parse", "test/fixtures/ruby_diff", "test/fixtures/ruby_diff_full_index", "test/fixtures/ruby_for_each_ref", "test/fixtures/show_cc", "test/fixtures/show_empty_commit", "test/fixtures/simple_config", "test/helper.rb", "test/profile.rb", "test/suite.rb", "test/test_actor.rb", "test/test_blame.rb", "test/test_blame_tree.rb", "test/test_blob.rb", "test/test_commit.rb", "test/test_commit_stats.rb", "test/test_commit_write.rb", "test/test_config.rb", "test/test_diff.rb", "test/test_file_index.rb", "test/test_git.rb", "test/test_grit.rb", "test/test_head.rb", "test/test_index_status.rb", "test/test_merge.rb", "test/test_raw.rb", "test/test_real.rb", "test/test_reality.rb", "test/test_remote.rb", "test/test_repo.rb", "test/test_rubygit.rb", "test/test_rubygit_alt.rb", "test/test_rubygit_index.rb", "test/test_rubygit_iv2.rb", "test/test_submodule.rb", "test/test_tag.rb", "test/test_tree.rb"]
  s.has_rdoc = true
  s.homepage = %q{http://github.com/mojombo/grit}
  s.rdoc_options = ["--inline-source", "--charset=UTF-8"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{grit}
  s.rubygems_version = %q{1.3.0}
  s.summary = %q{Grit is a Ruby library for extracting information from a git repository in an object oriented manner.}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 2

    if Gem::Version.new(Gem::RubyGemsVersion) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<mime-types>, [">= 1.15"])
      s.add_runtime_dependency(%q<diff-lcs>, [">= 1.1.2"])
    else
      s.add_dependency(%q<mime-types>, [">= 1.15"])
      s.add_dependency(%q<diff-lcs>, [">= 1.1.2"])
    end
  else
    s.add_dependency(%q<mime-types>, [">= 1.15"])
    s.add_dependency(%q<diff-lcs>, [">= 1.1.2"])
  end
end
