// Copyright (c) 2016 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import React from 'react';

import ShowcaseButton from '../showcase-components/showcase-button';
import {
  XYPlot,
  XAxis,
  YAxis,
  VerticalGridLines,
  HorizontalGridLines,
  MarkSeries
} from 'index';

function generateData() {
  return [...new Array(10)].map(row => ({x: Math.random() * 5, y: Math.random() * 10}));
}

const MODE = [
  'noWobble',
  'gentle',
  'wobbly',
  'stiff'
];

export default class Example extends React.Component {
  state = {
    data: generateData(),
    modeIndex: 0
  }

  updateModeIndex = increment => () => {
    const newIndex = this.state.modeIndex + (increment ? 1 : -1);
    const modeIndex = newIndex < 0 ? MODE.length - 1 : newIndex >= MODE.length ? 0 : newIndex;
    this.setState({
      modeIndex
    });
  }

  render() {
    const {modeIndex, data} = this.state;
    return (
      <div className="centered-and-flexed">
        <div className="centered-and-flexed-controls">
          <ShowcaseButton onClick={this.updateModeIndex(false)} buttonContent={'PREV'} />
          <div> {`ANIMATION TECHNIQUE: ${MODE[modeIndex]}`} </div>
          <ShowcaseButton onClick={this.updateModeIndex(true)} buttonContent={'NEXT'} />
        </div>
        <XYPlot
          width={300}
          height={300}>
          <VerticalGridLines />
          <HorizontalGridLines />
          <XAxis />
          <YAxis />
          <MarkSeries
            animation={MODE[modeIndex]}
            data={data}/>
        </XYPlot>
        <ShowcaseButton onClick={() => this.setState({data: generateData()})} buttonContent={'UPDATE DATA'} />
      </div>
    );
  }
}
