/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@GwtIncompatible(value="java.lang.reflect.*")
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Class<?> typeParameter(Class<?> clazz, int paramIndex) {
        Type superclass = clazz.getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            String string = String.valueOf(String.valueOf(superclass));
            throw new IllegalArgumentException(new StringBuilder(20 + string.length()).append(string).append(" isn't parameterized").toString());
        }
        Type[] typeParams = ((ParameterizedType)superclass).getActualTypeArguments();
        return (Class)typeParams[paramIndex];
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        String string = String.valueOf(String.valueOf(fieldName));
        String string2 = String.valueOf(String.valueOf(clazz.getSimpleName()));
        throw new NoSuchFieldException(new StringBuilder(50 + string.length() + string2.length()).append("No such field ").append(string).append(" declared on ").append(string2).append(" or its parent classes.").toString());
    }
}

